#ifndef _HC_NET_SDK_H_
#define _HC_NET_SDK_H_

#ifndef _WINDOWS_
#if (defined(_WIN32) || defined(_WIN64))
#include <winsock2.h>
#include <windows.h>    
#endif
#endif

#ifndef __PLAYRECT_defined
#define __PLAYRECT_defined
typedef struct __PLAYRECT
{
    int x;
    int y;
    int uWidth;
    int uHeight;
}PLAYRECT;
#endif

#if (defined(_WIN32)) //windows
#define NET_DVR_API  extern "C" __declspec(dllimport)
typedef  unsigned __int64   UINT64;
typedef  signed   __int64   INT64;
#elif defined(__linux__) || defined(__APPLE__) //linux
#define  BOOL  int
typedef  unsigned int       DWORD;
typedef  unsigned short     WORD;
typedef  unsigned short     USHORT;
typedef  short              SHORT;
typedef  int                LONG;
typedef  unsigned char      BYTE;
typedef  unsigned int       UINT;
typedef  void*              LPVOID;
typedef  void*              HANDLE;
typedef  unsigned int*      LPDWORD; 
typedef  unsigned long long UINT64;
typedef  signed long long   INT64;

#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef NULL
#define NULL 0
#endif

#define __stdcall 
#define CALLBACK  

#define NET_DVR_API extern "C"
typedef unsigned int   COLORKEY;
typedef unsigned int   COLORREF;

#ifndef __HWND_defined
#define __HWND_defined
#if defined(__linux__)
typedef unsigned int HWND;
#else
typedef void* HWND;
#endif
#endif

#ifndef __HDC_defined
#define __HDC_defined
#if defined(__linux__)
typedef struct __DC
{
    void*   surface;        //SDL Surface
    HWND    hWnd;           //HDC window handle
}DC;
typedef DC* HDC;
#else
typedef void* HDC;
#endif
#endif

typedef struct tagInitInfo
{
    int uWidth; 
    int uHeight; 
}INITINFO; 
#endif

//Macro definition 
#define MAX_NAMELEN                    16        //DVR's local Username
#define MAX_RIGHT                    32        //Authority permitted by Device (1- 12 for local authority,  13- 32 for remote authority) 
#define NAME_LEN                    32      //Username length
#define MIN_PASSWD_LEN              8       //min password length
#define PASSWD_LEN                    16      //Password length
#define STREAM_PASSWD_LEN             12     //stream password length
#define MAX_PASSWD_LEN_EX            64      //Password length 64 bit
#define GUID_LEN                    16      //GUID length
#define DEV_TYPE_NAME_LEN            24      //Device name length
#define SERIALNO_LEN                48      //SN length
#define MACADDR_LEN                    6       //Length of MAC address
#define MAC_ADDRESS_NUM             48      //MAC Address num
#define MAX_SENCE_NUM               16      //scene Num
#define RULE_REGION_MAX             128     //Rule Region num
#define MAX_ETHERNET                2       //Configurable Ethernet of device
#define MAX_NETWORK_CARD            4       //Configurable Network card of device
#define MAX_NETWORK_CARD_EX         12      //Configurable Extension Network card of device
#define PATHNAME_LEN                128     //length of path name
#define MAX_PRESET_V13              16      //Preset number
#define  MAX_TEST_COMMAND_NUM       32 
#define MAX_NUMBER_LEN              32      //number length
#define MAX_NAME_LEN                128     //device name length
#define MAX_INDEX_LED               8       //LED Index 2013-11-19
#define    MAX_CUSTOM_DIR           64      //Custom Dir Max Length
#define URL_LEN_V40                 256     //max URL Length
#define ISO_8601_LEN                32      //ISO 8601 time Length


#define CLOUD_NAME_LEN              48      //Cloud storage server username length
#define CLOUD_PASSWD_LEN            48      //Cloud storage server Password length

#define MAX_SENSORNAME_LEN          64      //Sensor Name Len
#define MAX_SENSORCHAN_LEN          32      //Sensor Channel Len
#define MAX_DESCRIPTION_LEN         32      //Description Len
#define MAX_DEVNAME_LEN_EX          64      //Device Name Len
#define NET_SDK_MAX_FILE_PATH       256     //File path len 
#define MAX_TMEVOICE_LEN            64      //TME Voice Len

#define NET_SDK_MAX_FDID_LEN 256//face lib id length
#define NET_SDK_MAX_PICID_LEN 256 //face picture id len
#define NET_SDK_FDPIC_CUSTOM_INFO_LEN 96 //face lib custom info len
#define NET_DVR_MAX_FACE_ANALYSIS_NUM      32   //max face analysis num
#define NET_DVR_MAX_FACE_SEARCH_NUM      5   //manx face search number
#define NET_SDK_CUSTOM_LEN                  512 //Maximum length of custom information
#define NET_SDK_CHECK_CODE_LEN              128//Check length
#define MAX_NUM_INPUT_BOARD         512     //the maximum number of input board
#define  MAX_SHIPSDETE_REGION_NUM    8       // Ship detection area maximum number list 

#define NET_SDK_SECRETKEY_LEN      128   //config file secret key len 
//led controler
#define  MAX_LEN_TEXT_CONTENT    128
#define  MAX_NUM_INPUT_SOURCE_TEXT    32
#define  MAX_NUM_OUTPUT_CHANNEL  512

#define MAX_RES_NUM_ONE_VS_INPUT_CHAN  8
#define MAX_VS_INPUT_CHAN_NUM  16

#define MAX_LEN_OSD_CONTENT  256
#define MAX_NUM_OSD_ONE_SUBWND  8
#define MAX_NUM_SPLIT_WND  64
#define MAX_NUM_OSD 8

//2013-11-19
#define MAX_DEVNAME_LEN             32      //Device Name
#define MAX_LED_INFO                256     //The screen font display information
#define MAX_TIME_LEN                32      //Time Max Len
#define MAX_CARD_LEN                24      //Card Max Len
#define MAX_OPERATORNAME_LEN        32      //OperatorName Max Len
#define MODULE_INFO_LEN            32    
#define VERSION_INFO_LEN        32  

#define THERMOMETRY_ALARMRULE_NUM   40       //Thermometry Alarm rule Number
#define MAX_THERMOMETRY_REGION_NUM  40      //Thermometry Region Num
#define MAX_THERMOMETRY_DIFFCOMPARISON_NUM  40 //Thermometry Temperature difference Num
#define MAX_SHIPS_NUM               20      //Ships Num

#define ASYN_LOGIN_SUCC                1        
#define ASYN_LOGIN_FAILED            0    

#define NET_SDK_MAX_VERIFICATION_CODE_LEN  32        //verification Code Max Len
#define NET_SDK_MAX_OPERATE_CODE_LEN  64        //operate code max len
#define MAX_TIMESEGMENT_V30            8       //Maximum number of time segments in 9000 DVR's guard schedule
#define MAX_TIMESEGMENT                4       //Maximum number of time segments in 8000 DVR's guard schedule
#define MAX_SHELTERNUM                4       //Maximum number of mask areas in 8000 DVR
#define MAX_DAYS                    7       //The number of days in a week
#define MAX_ACCESSORY_CARD         256      //The maximum length parts board information 
#define PHONENUMBER_LEN                32      //Maximum length of PPPOE number
#define MAX_ICR_NUM                 8       //ITC Maximum ICR Preset Point number
#define MAX_VEHICLEFLOW_INFO                       24       //ITC maximum vehicleflow info number
#define MAX_SHELTERNUM                4       //Maximum number of mask areas in 8000 DVR
#define MAX_DAYS                    7       //The number of days in a week
#define PHONENUMBER_LEN                32      //Maximum length of PPPOE number
#define CARD_READER_DESCRIPTION    32       //card reader description
#define MAX_FACE_NUM                2       //max face num
#define MAX_DOOR_CODE_LEN               8 //room code length
#define MAX_LOCK_CODE_LEN               8 //lock code length

#define MAX_DISKNUM_V30                33        //Maximum disk number in 9000 DVR,  including 16 internal SATA disks,  1 eSTAT disk and 16 NFS disks

#define NET_SDK_DISK_LOCATION_LEN  16      //Hard disk location length 
#define NET_SDK_SUPPLIER_NAME_LEN  32      //Supplier name length 
#define NET_SDK_DISK_MODEL_LEN     64      //Drive model length 
#define NET_SDK_MAX_DISK_VOLUME    33      //The largest hard disk volume number 
#define NET_SDK_DISK_VOLUME_LEN    36      //Hard disk volume name length 

#define MAX_DISKNUM                    16      //Maximum disk number in 8000 DVR
#define MAX_DISKNUM_V10                8       //used in 1.2 or earlier version

#define MAX_WINDOW_V30                32      //9000 maximum number of local display windows
#define MAX_WINDOW_V40                64      //Netra 2.3.1 extern
#define MAX_WINDOW                    16      //8000 maximum number of local display windows
#define MAX_VGA_V30                    4       //9000 maximum number of VGA
#define MAX_VGA                        1       //8000 maximum number of VGA

#define MAX_USERNUM_V30                32      //Maximum number of 9000 DVR users
#define MAX_USERNUM                    16      //Maximum number of 8000 DVR users
#define MAX_EXCEPTIONNUM_V30        32      //Maximum number of exceptions handled by 9000 DVR
#define MAX_EXCEPTIONNUM            16      //Maximum number of exceptions handled by 8000 DVR
#define MAX_LINK                    6       //Maximum number of video connections to 8000's single channel
#define MAX_ITC_EXCEPTIONOUT        32      //Maximun number of ITC exception Out
#define MAX_SCREEN_DISPLAY_LEN        512        //Screen characters in length 

#define MAX_DECPOOLNUM                4       //Maximum loop decoding number supported by each decoding channel of single channel decoder
#define MAX_DECNUM                    4       //Maximum decoding channel number of single channel decoder (only has one channel,  others are reserved) 
#define MAX_TRANSPARENTNUM            2       //Maximum number of Transparent channel in single channel decoder
#define MAX_CYCLE_CHAN                16      //Maximum number of loop channels in single channel decoder
#define MAX_CYCLE_CHAN_V30          64      //Maximum number of loop channels in single channel decoder (extend) 
#define MAX_DIRNAME_LENGTH            80      //Maximum number of directory name
#define MAX_WINDOWS                    16      //Maximum number of windows

#define MAX_STRINGNUM_V30            8        //Maximum number of OSD lines in 9000 DVR
#define MAX_STRINGNUM                4       //Maximum number of OSD lines in 8000 DVR
#define MAX_STRINGNUM_EX            8       //8000 customized extensions
#define MAX_AUXOUT_V30                16      //9000 maximum number of AUX output ports
#define MAX_AUXOUT                    4       //8000 maximum number of AUX output ports
#define MAX_HD_GROUP                16      //9000 maximum number of hard disk groups
#define MAX_HD_GROUP_V40            32      // maximum number of hard disk groups (256NVR)
#define MAX_NFS_DISK                8       //8000 maximum number of NFS disks

#define IW_ESSID_MAX_SIZE            32      //SSID length of WIFI
#define IW_ENCODING_TOKEN_MAX        32      //Maximum bytes of WIFI security Key
#define MAX_SERIAL_NUM                64        //Maximum number of Transparent channel
#define MAX_DDNS_NUMS                10      //Maximum number of DDNS in 9000
#define MAX_DOMAIN_NAME                64        //Maximum Domain Name length
#define MAX_EMAIL_ADDR_LEN            48        //Maximum Email Address length
#define MAX_EMAIL_PWD_LEN            32      //Maximum Email password length
#define MAX_SLAVECAMERA_NUM         8       //Maximum SlaveCamera Number
#define MAX_CALIB_NUM               6       //Maximum Calib Num 
#define MAX_CALIB_NUM_EX            20      //Maximum Calib Num Express   
#define MAX_LEDDISPLAYINFO_LEN      1024    //Maximum LedDisplayInfo Len
#define MAX_PEOPLE_DETECTION_NUM    8       //Maximum People Detection Region Number

#define MAXPROGRESS                    100     //Maximum percent while playing back
#define MAX_SERIALNUM                2       //Serial Port supported by 8000 DVR,  1- 232,  2- 485
#define CARDNUM_LEN                    20      //Card number length
#define PATIENTID_LEN              64
#define CARDNUM_LEN_OUT                32      //Card number length for outer
#define MAX_VIDEOOUT_V30            4       //9000 DVR analog video output number. 
#define MAX_VIDEOOUT                2       //8000 DVR analog video output number

#define MAX_PRESET_V30                256        // 9000 Preset number of PTZ  
#define MAX_TRACK_V30                256        // 9000 Track number of PTZ   
#define MAX_CRUISE_V30                256        // 9000 Cruise number of PTZ  
#define MAX_PRESET                    128        // 8000 Preset number of PTZ  
#define MAX_TRACK                    128        // 8000 Track number of PTZ   
#define MAX_CRUISE                    128        // 8000 Cruise number of PTZ  

#define MAX_PRESET_V40                300        /* PTZ Max Support Preset Num */
#define MAX_CRUISE_POINT_NUM        128     /* Max Support Cruise Point Num */
#define MAX_CRUISEPOINT_NUM_V50     256     //Max Support Cruise Point V50 Num 

#define CRUISE_MAX_PRESET_NUMS        32         // Maximum number of Cruise points in one Cruise 
#define MAX_FACE_PIC_NUM            30      //Face Pictrue Num
#define LOCKGATE_TIME_NUM           4       //Lock Gate Num

#define MAX_SERIAL_PORT             8       // Maximum number of RS232 supported by 9000 DVR
#define MAX_PREVIEW_MODE            8       // Maximum number of display layout mode;  single windows/4 windows/9 windows/16 windows/... 
#define MAX_MATRIXOUT               16      // Maximum number of analog matrix output 
#define LOG_INFO_LEN                11840   // Additional information of Log 
#define DESC_LEN                    16      // String length of PTZ description 
#define PTZ_PROTOCOL_NUM            200     // Maximum number of PTZ protocols in 9000 DVR 
#define IPC_PROTOCOL_NUM            50      // Maximum number of ipc protocols in 9000 DVR 

#define MAX_AUDIO                    1       //Number of talk channels in 8000 DVR
#define MAX_AUDIO_V30                2       //Number of talk channels in 9000 DVR
#define MAX_CHANNUM                    16      //Maximum number of video/audio channels in 8000 DVR
#define MAX_ALARMIN                    16      //Maximum number of alarm input channels in 8000 DVR
#define MAX_ALARMOUT                4       //Maximum number of alarm output channels in 8000 DVR
//9000 IP Camera
#define MAX_ANALOG_CHANNUM          32      //32 analog channels in total
#define MAX_ANALOG_ALARMOUT         32      //32 analog alarm output channels intotal
#define MAX_ANALOG_ALARMIN          32      //32 analog alarm input channels intotal
#define MAX_IP_DEVICE               32      //9000 DVR can connect 32 IP devices
#define MAX_IP_DEVICE_V40           64      //Maximum number of IP devices that can be added, the value is 64, including IVMS-2000
#define MAX_IP_CHANNEL              32      //9000 DVR can connect 32 IP channels
#define MAX_IP_ALARMIN              128     //Maximum number of alarm input channels that can be added
#define MAX_IP_ALARMOUT             64      //Maximum number of alarm output channels that can be added
#define MAX_IP_ALARMIN_V40          4096    //Maximum number of alarm input channels that can be added
#define MAX_IP_ALARMOUT_V40         4096    //Maximum number of alarm output channels that can be added

#define MAX_RECORD_FILE_NUM         20        //max file number for back , cd write or delete

//SDK_V31 ATM
#define MAX_ACTION_TYPE                12        //Maximum action number of the transactions added  
#define MAX_ATM_PROTOCOL_NUM        256     //Maximum protocol number of each input sort
#define ATM_CUSTOM_PROTO            1025    //user- defined protocol
#define ATM_PROTOCOL_SORT           4       //number of ATM protocol segment 
#define ATM_DESC_LEN                32      //Length of the ATM description string
// SDK_V31 ATM

/*Maximum channels number including analog channels and IP channels */
#define MAX_IPV6_LEN                  64      //MAX IPv6 Address Len
#define MAX_EVENTID_LEN             64      //MAX EventID Len

#define INVALID_VALUE_UINT32         0xffffffff   // Invalid Value
#define MAX_CHANNUM_V40             512
#define MAX_MULTI_AREA_NUM          24

#define MAX_SINGLE_FTPPICNAME_LEN       20 //The largest single FTP channel names 
#define MAX_CAMNAME_LEN                 32 //The channel name 
#define MAX_FTPNAME_NUM                 12 //Number of TFP name 


#define COURSE_NAME_LEN                32    
#define INSTRUCTOR_NAME_LEN            16    
#define COURSE_DESCRIPTION_LEN        256    
#define MAX_TIMESEGMENT_V40            16

#define MAX_MIX_CHAN_NUM        16        //max mixed channel number
#define MAX_LINE_IN_CHAN_NUM    16        //max line in channel number
#define MAX_MIC_CHAN_NUM        16        //max mic channel number
#define INQUEST_CASE_NO_LEN        64        //inquest case number length
#define INQUEST_CASE_NAME_LEN    64        //inquest case name length
#define CUSTOM_INFO_LEN            64        //custom information length
#define INQUEST_CASE_LEN        64        //inquest case information length

#define MAX_FILE_ID_LEN         128
#define MAX_PIC_NAME_LEN        128 //picture name len

#define MAX_CHANNUM_V30                ( MAX_ANALOG_CHANNUM + MAX_IP_CHANNEL )   //64
#define MAX_ALARMOUT_V40             (MAX_IP_ALARMOUT_V40 +MAX_ANALOG_ALARMOUT) //4128
#define MAX_ALARMOUT_V30               ( MAX_ANALOG_ALARMOUT + MAX_IP_ALARMOUT ) //96
#define MAX_ALARMIN_V30                ( MAX_ANALOG_ALARMIN + MAX_IP_ALARMIN )   //160
#define MAX_ALARMIN_V40             (MAX_IP_ALARMIN_V40 +MAX_ANALOG_ALARMOUT) //4128
#define MAX_ANALOG_ALARM_WITH_VOLT_LIMIT    16 //max analog alarm num with limited volt
#define NET_SDK_VERSION_LIST_LEN    64 //Algorithm library version Max

#define MAX_ROIDETECT_NUM           8
#define MAX_LANERECT_NUM            5       //Max Lane rect num
#define MAX_FORTIFY_NUM                10      //Max number of channels to be fortified
#define MAX_INTERVAL_NUM            4       //Max number of interval
#define MAX_CHJC_NUM                3       //Max number of chars short for province of car
#define MAX_VL_NUM                    5       //Max number of virtual lines
#define MAX_DRIVECHAN_NUM            16      //max number of drive channels
#define MAX_COIL_NUM                3       //max number of coils
#define MAX_SIGNALLIGHT_NUM            6       //max number of signal lights
#define LEN_16                        16
#define LEN_32                        32
#define LEN_64                        64
#define LEN_31                        31
#define	MAX_LINKAGE_CHAN_NUM          16  //max alarm linkage NVR channel number
#define MAX_CABINET_COUNT           8       //max number of cabinets
#define MAX_ID_LEN                  48
#define MAX_PARKNO_LEN              16
#define MAX_ALARMREASON_LEN         32 
#define MAX_UPGRADE_INFO_LEN        48
#define MAX_CUSTOMDIR_LEN           32      //max Lenth of custom Dir   
#define MAX_LED_INFO_LEN            512     //LED Info Len
#define MAX_VOICE_INFO_LEN          128     //Voice Info Len
#define MAX_LITLE_INFO_LEN          64      //Litle Info Len
#define MAX_CUSTOM_INFO_LEN         64      //Custom Info Len
#define MAX_PHONE_NUM_LEN           16      //Phone Num Len
#define MAX_APP_SERIALNUM_LEN       32      //App Serial Num Len

#define AUDIOTALKTYPE_G722            0
#define AUDIOTALKTYPE_G711_MU        1
#define AUDIOTALKTYPE_G711_A        2
#define AUDIOTALKTYPE_MP2L2         5
#define AUDIOTALKTYPE_G726            6
#define AUDIOTALKTYPE_AAC            7
#define AUDIOTALKTYPE_PCM             8
#define AUDIOTALKTYPE_G722C       9

//packet type
#define FILE_HEAD            0 //file head
#define VIDEO_I_FRAME        1 //video I frame
#define VIDEO_B_FRAME        2 //video B frame
#define VIDEO_P_FRAME        3 //video P frame
#define AUDIO_PACKET        10 //audio packet
#define PRIVT_PACKET        11 //private packet
//E frame
#define HIK_H264_E_FRAME    (1 << 6)



#define MAX_TRANSPARENT_CHAN_NUM    4        //max transparent channels for every serial channel
#define MAX_TRANSPARENT_ACCESS_NUM  4        //max host access number for every lisening port 

//ITS
#define MAX_PARKING_STATUS            8        //Park State: 0-no Car,1-Car,2-Press Line (highest priority), 3-Special Park Spaces 
#define MAX_PARKING_NUM                4        //A channel 4 largest parking Spaces (from left to right an array of 0 ~ 3) 

#define MAX_ITS_SCENE_NUM          16       //max ITS scene num
#define MAX_SCENE_TIMESEG_NUM      16       //max scene time segment num
#define MAX_IVMS_IP_CHANNEL        128      //max ip channels
#define DEVICE_ID_LEN              48       //device id len
#define MONITORSITE_ID_LEN         48       //monitor site id len
#define MAX_AUXAREA_NUM            16       //max auxiliary area num
#define MAX_SLAVE_CHANNEL_NUM      16       //max slave channel num
#define MAX_DEVDESC_LEN            64       //Device description information Len
#define MAX_SECRETKEY_LEN          512      //Secret Key Len
#define MAX_INDEX_CODE_LEN         64       //Index Code Len
#define MAX_ILLEGAL_LEN            64       //Illegal Len
#define ILLEGAL_LEN            32       //Illegal Len
#define CODE_LEN        64  //Authorization code
#define ALIAS_LEN       32  //Alias,read only
#define MAX_TRUCK_AXLE_NUM          10      //max truck axle
#define MAX_CATEGORY_LEN            8       //Max Category Len
#define SERIAL_NO_LEN               16      //Parking Serial NO length
//IPC
#define MAX_SCH_TASKS_NUM 10

#define MAX_SERVERID_LEN            64 //Max Server ID Len 
#define MAX_SERVERDOMAIN_LEN        128 //Max Server Domain Name Len 
#define MAX_AUTHENTICATEID_LEN      64 //Max Authenticate ID Len 
#define MAX_AUTHENTICATEPASSWD_LEN  32 //Max Authenticate Passwd Len 
#define MAX_SERVERNAME_LEN          64 //???????? 
#define MAX_COMPRESSIONID_LEN       64 //??ID?????
#define MAX_SIPSERVER_ADDRESS_LEN   128 //SIP??????????IP??
#define MAX_PlATE_NO_LEN         32   //Max Plate Number Len 2013-09-27
#define UPNP_PORT_NUM            12      //upnp port Number
#define MAX_NOTICE_NUMBER_LEN       32   //max notice number len
#define MAX_NOTICE_THEME_LEN        64   //max notice theme len
#define MAX_NOTICE_DETAIL_LEN       1024 //max notice detal len
#define MAX_NOTICE_PIC_NUM          6    //max notice pic num
#define MAX_DEV_NUMBER_LEN          32   //Max Device ID Len

#define HOLIDAY_GROUP_NAME_LEN          32  //holiday group name len
#define MAX_HOLIDAY_PLAN_NUM            16  //holiday max plan number
#define TEMPLATE_NAME_LEN               32  //plan template name len 
#define MAX_HOLIDAY_GROUP_NUM           16   //plan template max group number
#define DOOR_NAME_LEN                   32  //door name len 
#define STRESS_PASSWORD_LEN             8   //stress password len
#define SUPER_PASSWORD_LEN              8   //super password len
#define GROUP_NAME_LEN                  32  //group name len 
#define GROUP_COMBINATION_NUM           8   //group combination number 
#define MULTI_CARD_GROUP_NUM            4   //multi card group number 
#define ACS_CARD_NO_LEN                 32  //access card No. len
#define NET_SDK_EMPLOYEE_NO_LEN         32  //employee No. len
#define NET_SDK_UUID_LEN                36  //UUID len
#define NET_SDK_EHOME_KEY_LEN           32  //EHome Key Len
#define CARD_PASSWORD_LEN               8   // card password len 
#define MAX_DOOR_NUM                    32  //max door number
#define MAX_CARD_RIGHT_PLAN_NUM         4   //max card right plan number
#define MAX_GROUP_NUM_128               128 //The largest number of grou
#define MAX_CARD_READER_NUM             64  //max card reader number 
#define MAX_SNEAK_PATH_NODE             8   //max sneak path node number
#define MAX_MULTI_DOOR_INTERLOCK_GROUP  8   //max multi door interlock group 
#define MAX_INTER_LOCK_DOOR_NUM         8   //max inter lock door number
#define MAX_CASE_SENSOR_NUM             8   //max case sensor number
#define MAX_DOOR_NUM_256                256 //max door num
#define MAX_READER_ROUTE_NUM            16  //max reader route num
#define MAX_FINGER_PRINT_NUM            10  //max finger print num
#define MAX_CARD_READER_NUM_512            512 //max card reader num
#define NET_SDK_MULTI_CARD_GROUP_NUM_20     20   //multi card group num

#define ERROR_MSG_LEN                      32 

#define PER_RING_PORT_NUM                2   //the port number of the ring
#define SENSORNAME_LEN                  32  //Sensor Name Len
#define MAX_SENSORDESCR_LEN             64  //Sensor Description Len
#define MAX_DNS_SERVER_NUM              2   //DNS Server Num
#define SENSORUNIT_LEN                  32 //max unit word length

#define WEP_KEY_MAX_SIZE                32 //WEP Key Max Size
#define WEP_KEY_MAX_NUM                 4  //WEP Key Max Num
#define WPA_KEY_MAX_SIZE                64 //WPA Key Max Size

#define MAX_IDCODE_LEN                  128 //firmware code length
#define MAX_VERSIIN_LEN                 64  //max version length
#define MAX_IDCODE_NUM                  32  //max firmware code number
#define SDK_LEN_2048                    2048
#define SDK_MAX_IP_LEN 48

#define RECT_POINT_NUM                    4

#define MAX_PUBLIC_KEY_LEN 512 
#define CHIP_SERIALNO_LEN 32 
#define ENCRYPT_DEV_ID_LEN        20
#define MAX_SEARCH_ID_LEN               36
#define TERMINAL_NAME_LEN               64
#define MAX_URL_LEN                     512
#define REGISTER_NAME_LEN               64 
#define KEY_WORD_NUM             3 //key word number
#define KEY_WORD_LEN            128  //key word length
//optical fiber
#define MAX_PORT_NUM            64  //maximum port number
#define MAX_SINGLE_CARD_PORT_NO 4   //maximum port number of single card
#define MAX_FUNC_CARD_NUM       32  //maximum function card number
#define MAX_FC_CARD_NUM         33  //maximum card number
#define MAX_REMARKS_LEN         128 //port remarks length
#define NET_DEV_NAME_LEN        64  //The length of the device name 
#define NET_DEV_TYPE_NAME_LEN  64  //Device type name length
//LED
#define MAX_OUTPUT_PORT_NUM                32    //maximum output port number
#define MAX_SINGLE_PORT_RECVCARD_NUM    64    //maximum receive card number of single port
#define MAX_GAMMA_X_VALUE                256    //maximum x value number of GAMMA table

#define ABNORMAL_INFO_NUM               4   //abnormal info num

#define PLAYLIST_NAME_LEN                64            //play list name length
#define PLAYLIST_ITEM_NUM                64            //play item nummber

//NVR
#define NET_SDK_MAX_LOGIN_PASSWORD_LEN           128 //login password len
#define NET_SDK_MAX_ANSWER_LEN                   256 //security answer length
#define NET_SDK_MAX_QUESTION_LIST_LEN            32//security question list length
#define NET_SDK_MAX_THERMOMETRYALGNAME           128//Thermometry Algorithm library length
#define NET_SDK_MAX_SHIPSALGNAME                128//Ships Algorithm library length
#define NET_SDK_MAX_FIRESALGNAME                 128//Fire Algorithm library length

#define MAX_PASSPORT_NUM_LEN          16     //max passport number len
#define MAX_PASSPORT_INFO_LEN         128    //max generic info len
#define MAX_PASSPORT_NAME_LEN         64     //max name len
#define MAX_PASSPORT_MONITOR_LEN      1024   //max monitor info len
#define MAX_NATIONALITY_LEN           16     //max nationality len
#define MAX_PASSPORT_TYPE_LEN         4      //max type len

#define  MAX_SCREEN_AREA_NUM  128  //maximum number of screen area
#define  LOCK_NAME_LEN                   32 

//[add]by zengxiaole 2017-09-27 DS-19D2000-S v2.0
#define MAX_FIRE_ALARM_ZONE         12           //max fire alarm host zone
#define MAX_FIRE_ALARM_POINT_ZONE   32           //max fire alarm host point

/*******************Global Error Code**********************/
#define NET_DVR_NOERROR 					0	//No Error
#define NET_DVR_PASSWORD_ERROR 				1	//Username or Password error
#define NET_DVR_NOENOUGHPRI 				2	//Don't have enough authority 
#define NET_DVR_NOINIT 						3	//have not Initialized
#define NET_DVR_CHANNEL_ERROR 				4	//Channel number error
#define NET_DVR_OVER_MAXLINK 				5	//Number of clients connecting to DVR beyonds the Maximum
#define NET_DVR_VERSIONNOMATCH				6	//Version is not matched
#define NET_DVR_NETWORK_FAIL_CONNECT		7	//Connect to server failed
#define NET_DVR_NETWORK_SEND_ERROR			8	//Send data to server failed
#define NET_DVR_NETWORK_RECV_ERROR			9	//Receive data from server failed
#define NET_DVR_NETWORK_RECV_TIMEOUT		10	//Receive data from server timeout
#define NET_DVR_NETWORK_ERRORDATA			11	//Transferred data has error
#define NET_DVR_ORDER_ERROR					12	//Wrong Sequence of invoking API
#define NET_DVR_OPERNOPERMIT				13	//No such authority. 
#define NET_DVR_COMMANDTIMEOUT				14	//Execute command timeout
#define NET_DVR_ERRORSERIALPORT				15	//Serial port number error
#define NET_DVR_ERRORALARMPORT				16	//Alarm port error
#define NET_DVR_PARAMETER_ERROR 			17  //Parameters error
#define NET_DVR_CHAN_EXCEPTION				18	//Server channel in error status
#define NET_DVR_NODISK						19	//No hard disk
#define NET_DVR_ERRORDISKNUM				20	//Hard disk number error
#define NET_DVR_DISK_FULL					21	//Server's hard disk is full
#define NET_DVR_DISK_ERROR					22	//Server's hard disk error
#define NET_DVR_NOSUPPORT					23	//Server doesn't support
#define NET_DVR_BUSY						24	//Server is busy
#define NET_DVR_MODIFY_FAIL					25	//Server modification failed
#define NET_DVR_PASSWORD_FORMAT_ERROR		26	//Input format of Password error
#define NET_DVR_DISK_FORMATING				27	//Hard disk is formating,  cannot execute.  
#define NET_DVR_DVRNORESOURCE				28	//DVR don't have enough resource
#define	NET_DVR_DVROPRATEFAILED				29  //DVR Operation failed
#define NET_DVR_OPENHOSTSOUND_FAIL 			30  //Open PC audio failed
#define NET_DVR_DVRVOICEOPENED 				31  //Server's talk channel is occupied 
#define	NET_DVR_TIMEINPUTERROR				32  //Time input is not correct
#define	NET_DVR_NOSPECFILE					33  //Can't playback the file that does not exist in Server
#define NET_DVR_CREATEFILE_ERROR			34	//Create file error
#define	NET_DVR_FILEOPENFAIL				35  //Open file error
#define	NET_DVR_OPERNOTFINISH				36  //The previous operation is not finished yet
#define	NET_DVR_GETPLAYTIMEFAIL				37  //Get current playing time error
#define	NET_DVR_PLAYFAIL					38  //Playback error
#define NET_DVR_FILEFORMAT_ERROR			39  //Wrong file format
#define NET_DVR_DIR_ERROR					40	//Wrong directory 
#define NET_DVR_ALLOC_RESOURCE_ERROR		41  //Assign resource error
#define NET_DVR_AUDIO_MODE_ERROR			42	//Audio card mode error
#define NET_DVR_NOENOUGH_BUF				43	//Buffer is too small
#define NET_DVR_CREATESOCKET_ERROR		 	44	//Create SOCKET error
#define NET_DVR_SETSOCKET_ERROR				45	//Setup SOCKET error
#define NET_DVR_MAX_NUM						46	//Reach the maximum number
#define NET_DVR_USERNOTEXIST				47	//User does not exist
#define NET_DVR_WRITEFLASHERROR				48  //Write to FLASH error
#define NET_DVR_UPGRADEFAIL					49  //DVR update failed 
#define NET_DVR_CARDHAVEINIT				50  //Decoding Card has been initialized already
#define NET_DVR_PLAYERFAILED				51	//Invoke API of player library error
#define NET_DVR_MAX_USERNUM					52  //Reach the maximum number of DVR Users
#define NET_DVR_GETLOCALIPANDMACFAIL		53  //Failed to get Client software's IP or MAC address
#define NET_DVR_NOENCODEING					54	//No encoding on this channel
#define NET_DVR_IPMISMATCH					55	//IP address is not matched
#define NET_DVR_MACMISMATCH					56	//MAC address is not matched
#define NET_DVR_UPGRADELANGMISMATCH			57	//Update file has wrong language
#define NET_DVR_MAX_PLAYERPORT				58	//Reach the maximum player number
#define NET_DVR_NOSPACEBACKUP				59	//There is no enough space on the backup device
#define NET_DVR_NODEVICEBACKUP				60	//Failed to find the specified backup device 
#define NET_DVR_PICTURE_BITS_ERROR			61	//Image has wrong color bit,  24 color only
#define NET_DVR_PICTURE_DIMENSION_ERROR		62	//Image size exceeds the maximum value;  smaller than 128*256
#define NET_DVR_PICTURE_SIZ_ERROR			63	//Image file exceeds the maximum size;  smaller than 100K
#define NET_DVR_LOADPLAYERSDKFAILED			64	//Failed to load the player SDK from current directory
#define NET_DVR_LOADPLAYERSDKPROC_ERROR		65	//Failed to find the API's entry in player SDK
#define NET_DVR_LOADDSSDKFAILED				66	//Failed to load the DSsdk from current directory
#define NET_DVR_LOADDSSDKPROC_ERROR		    67	//Failed to find the API's entry in DSsDK
#define NET_DVR_DSSDK_ERROR					68	//Failed to involve the API of DSsDK.dll
#define NET_DVR_VOICEMONOPOLIZE				69	//Audio card has been occupied exclusively
#define NET_DVR_JOINMULTICASTFAILED			70	//Join to multicast group error
#define NET_DVR_CREATEDIR_ERROR				71	//Failed to create log directory
#define NET_DVR_BINDSOCKET_ERROR			72	//Failed to bind socked error. 
#define NET_DVR_SOCKETCLOSE_ERROR			73	//socket is disconnected,  that caused by network disconnected or unreachable destination mostly
#define NET_DVR_USERID_ISUSING			    74	//User ID is using when logout
#define NET_DVR_SOCKETLISTEN_ERROR			75	//Socket listen error
#define NET_DVR_PROGRAM_EXCEPTION			76	//Application error
#define NET_DVR_WRITEFILE_FAILED			77	//Failed to write file
#define NET_DVR_FORMAT_READONLY				78  //Forbidden to format read only disk
#define NET_DVR_WITHSAMEUSERNAME		    79  //Same user name already exists.
#define NET_DVR_DEVICETYPE_ERROR            80  //Device Model is not matched when import parameters
#define NET_DVR_LANGUAGE_ERROR              81  //Audio is not matched when import parameters
#define NET_DVR_PARAVERSION_ERROR           82  //Software version is not matched when import parameters
#define NET_DVR_IPCHAN_NOTALIVE             83  //IP Channels is off line when
#define NET_DVR_RTSP_SDK_ERROR                84    //Failed to load IPC communication library
#define NET_DVR_CONVERT_SDK_ERROR            85    //Failed to load stream format convertion library
#define NET_DVR_IPC_COUNT_OVERFLOW            86  //ip count overflow
#define NET_DVR_MAX_ADD_NUM                 87  //add label or other operation reach the maximum number
#define NET_DVR_PARAMMODE_ERROR             88  //Param Mode Error
//2009- 01- 04 
#define NET_DVR_CODESPITTER_OFFLINE            89  //Videoplat: CodeSpitter is Offline
#define NET_DVR_BACKUP_COPYING                90  //Device is backuping
//2010-01-16
#define NET_DVR_CHAN_NOTSUPPORT             91  //Channel doesn't support

#define NET_DVR_CALLINEINVALID              92  // The height line location is too concentrated, or the length line is not inclined enough 
#define NET_DVR_CALCANCELCONFLICT           93  // Cancel calibration conflict, if the rule and overall actual size filter have been set
#define NET_DVR_CALPOINTOUTRANGE            94     // Calibration point exceeds the range 
#define NET_DVR_FILTERRECTINVALID           95  // The size filter does not meet the requirement
#define NET_DVR_DDNS_DEVOFFLINE             96  // Device hasn't registered to ddns
#define NET_DVR_DDNS_INTER_ERROR            97  // DDNS inter error
#define NET_DVR_FUNCTION_NOT_SUPPORT_OS     98  //This function don't support this OS.
#define NET_DVR_DEC_CHAN_REBIND             99  //Decode channel can not bind two or more display channel
#define NET_DVR_INTERCOM_SDK_ERROR          100 //Failed to load the Intercom SDK from current directory
#define NET_DVR_NO_CURRENT_UPDATEFILE       101 //NO Current UpdateFile
#define NET_DVR_USER_NOT_SUCC_LOGIN         102  //user is not login yet
#define NET_DVR_USE_LOG_SWITCH_FILE            103  //it is using log switch file
#define NET_DVR_POOL_PORT_EXHAUST            104  //Port pool is exhaust
#define    NET_DVR_PACKET_TYPE_NOT_SUPPORT        105    //The stream packet type is error

#define NET_DVR_IPPARA_IPID_ERROR           106  //IPID when IP access configuration is incorrect

#define NET_DVR_LOAD_HCPREVIEW_SDK_ERROR           107  //Load Preview COM Failed
#define NET_DVR_LOAD_HCVOICETALK_SDK_ERROR         108  //Load Voice talk COM Failed
#define NET_DVR_LOAD_HCALARM_SDK_ERROR             109  //Load Alarm COM Failed
#define NET_DVR_LOAD_HCPLAYBACK_SDK_ERROR          110  //Load Play back COM Failed
#define NET_DVR_LOAD_HCDISPLAY_SDK_ERROR           111  //Load Display COM Failed
#define NET_DVR_LOAD_HCINDUSTRY_SDK_ERROR          112  //Load Industry COM Failed
#define NET_DVR_LOAD_HCGENERALCFGMGR_SDK_ERROR     113  //Load General config mgr COM Failed
#define NET_DVR_LOAD_HCCOREDEVCFG_SDK_ERROR        114  //Load device core config COM Failed
#define NET_DVR_LOAD_HCNETUTILS_SDK_ERROR          115  //Load HCNetUtils Failed

#define NET_DVR_CORE_VER_MISMATCH                  121   //There is a mismatch between the component and core version 
#define NET_DVR_CORE_VER_MISMATCH_HCPREVIEW        122   //There is a mismatch  between Live view component and core version.
#define NET_DVR_CORE_VER_MISMATCH_HCVOICETALK      123   //There is a mismatch  between voice component and core version
#define NET_DVR_CORE_VER_MISMATCH_HCALARM          124   //There is a mismatch  between alarm component and core version
#define NET_DVR_CORE_VER_MISMATCH_HCPLAYBACK       125   //There is a mismatch  between playback component and core version
#define NET_DVR_CORE_VER_MISMATCH_HCDISPLAY        126   //There is a mismatch  between display component and core version
#define NET_DVR_CORE_VER_MISMATCH_HCINDUSTRY       127   //There is a mismatch  between industrial application component and core version
#define NET_DVR_CORE_VER_MISMATCH_HCGENERALCFGMGR  128   //There is a mismatch  between General configuration management component and the core version

#define NET_DVR_COM_VER_MISMATCH_HCPREVIEW         136   //There is a mismatch  between Live view component and HCNetSDK version.
#define NET_DVR_COM_VER_MISMATCH_HCVOICETALK       137   //There is a mismatch  between voice component and HCNetSDK version
#define NET_DVR_COM_VER_MISMATCH_HCALARM           138   //here is a mismatch  between alarm component and HCNetSDK version
#define NET_DVR_COM_VER_MISMATCH_HCPLAYBACK        139   //There is a mismatch  between playback component and HCNetSDK version
#define NET_DVR_COM_VER_MISMATCH_HCDISPLAY         140   //There is a mismatch  between display component and HCNetSDK version
#define NET_DVR_COM_VER_MISMATCH_HCINDUSTRY        141   //There is a mismatch  between industrial application component and HCNetSDK version
#define NET_DVR_COM_VER_MISMATCH_HCGENERALCFGMGR   142   //There is a mismatch  between General configuration management component and the HCNetSDK version

#define NET_ERR_CONFIG_FILE_IMPORT_FAILED          145  //import config file failed
#define NET_ERR_CONFIG_FILE_EXPORT_FAILED          146  //export config file failed

#define NET_DVR_ALIAS_DUPLICATE                150    // Alias is duplicate  //2011-08-31 the configuration of new ddns accessing device by alias or serial number

#define    NET_DVR_INVALID_COMMUNICATION        151    //Invalid Communication
#define    NET_DVR_USERNAME_NOT_EXIST            152    //UserName is not exist
#define    NET_DVR_USER_LOCKED                    153 //UserName Locked
#define NET_DVR_INVALID_USERID              154 //Invalid User ID
#define NET_DVR_LOW_LOGIN_VERSION           155 //Low Login Version
#define NET_DVR_LOAD_LIBEAY32_DLL_ERROR     156 //load libeay32.dll failed
#define NET_DVR_LOAD_SSLEAY32_DLL_ERROR     157 //load ssleay32.dll failed
#define NET_ERR_LOAD_LIBICONV                       158 //load libiconv2 failed
#define NET_ERR_SSL_CONNECT_FAILED        159 //SSL connect failed
#define NET_ERR_MCAST_ADDRESS_ERROR      160 //Multicast's address is error

#define NET_DVR_SERVER_NOT_EXIST         164 //can not find the server
#define NET_DVR_TEST_SERVER_FAIL_CONNECT            165    //fail connect with test server
#define NET_DVR_NAS_SERVER_INVALID_DIR                166    //NAS server mount fail,invalid directory
#define NET_DVR_NAS_SERVER_NOENOUGH_PRI                167    //NAS server mount fail,no authority
#define NET_DVR_EMAIL_SERVER_NOT_CONFIG_DNS            168    //sever not configure DNS.
#define    NET_DVR_EMAIL_SERVER_NOT_CONFIG_GATEWAY        169    //Email server not configure gateway
#define    NET_DVR_TEST_SERVER_PASSWORD_ERROR            170    //the password of the test server is error
#define    NET_DVR_EMAIL_SERVER_CONNECT_EXCEPTION_WITH_SMTP    171    //device connect exception with smtp server
#define    NET_DVR_FTP_SERVER_FAIL_CREATE_DIR            172    //FTP server create directory fail
#define    NET_DVR_FTP_SERVER_NO_WRITE_PIR                173    //FTP server not have write authority
#define    NET_DVR_IP_CONFLICT                            174    //IP conflict
#define NET_DVR_INSUFFICIENT_STORAGEPOOL_SPACE      175  //No free space for the storage pool
#define NET_DVR_STORAGEPOOL_INVALID                 176  //The storage pool of the cloud server is invalid, no configured storage pool or the storage pool ID is incorrect.
#define NET_DVR_EFFECTIVENESS_REBOOT                177  //Effectiveness Reboot
#define NET_ERR_ANR_ARMING_EXIST                    178  //ANR arming is already established.
#define NET_ERR_UPLOADLINK_EXIST                    179  //Upload Link is already established.
#define NET_ERR_INCORRECT_FILE_FORMAT               180  //Incorrect file format
#define NET_ERR_INCORRECT_FILE_CONTENT              181  //Incorrect file content
#define NET_ERR_MAX_HRUDP_LINK                       182               //HRUDP limit the number of connections over equipment 
// RAID error code
#define RAID_ERROR_INDEX                    200
#define NET_DVR_NAME_NOT_ONLY               (RAID_ERROR_INDEX + 0)  // Existing name
#define NET_DVR_OVER_MAX_ARRAY              (RAID_ERROR_INDEX + 1 ) // Number of arrays has reached its limit
#define NET_DVR_OVER_MAX_VD                 (RAID_ERROR_INDEX + 2 ) // Number of virtual disks  has reached its limit
#define NET_DVR_VD_SLOT_EXCEED              (RAID_ERROR_INDEX + 3 ) // Virtual disk slot is full
#define NET_DVR_PD_STATUS_INVALID           (RAID_ERROR_INDEX + 4 ) // Physical disk for rebuilding array is with error status
#define NET_DVR_PD_BE_DEDICATE_SPARE        (RAID_ERROR_INDEX + 5 ) // Physical disk for rebuilding array is specified as spare drive
#define NET_DVR_PD_NOT_FREE                 (RAID_ERROR_INDEX + 6 ) // Physical disk for rebuilding array is not idle
#define NET_DVR_CANNOT_MIG2NEWMODE          (RAID_ERROR_INDEX + 7 ) // Unable to migrate from the current array type to the new array type
#define NET_DVR_MIG_PAUSE                   (RAID_ERROR_INDEX + 8 ) // The migration operation has been paused
#define NET_DVR_MIG_CANCEL                  (RAID_ERROR_INDEX + 9 ) // The migration operation has been canceled
#define NET_DVR_EXIST_VD                    (RAID_ERROR_INDEX + 10) // Operation failed! Please delete the virtual disk existed in the array first
#define NET_DVR_TARGET_IN_LD_FUNCTIONAL     (RAID_ERROR_INDEX + 11) // Target physical disk is part of the virtual disk and is functional
#define NET_DVR_HD_IS_ASSIGNED_ALREADY      (RAID_ERROR_INDEX + 12) // Specified physical disk is assigned to a virtual disk
#define NET_DVR_INVALID_HD_COUNT            (RAID_ERROR_INDEX + 13) // Number of physical disks doesn't fit the specified RAID level
#define NET_DVR_LD_IS_FUNCTIONAL            (RAID_ERROR_INDEX + 14) // Specified virtual disk is functional
#define NET_DVR_BGA_RUNNING                 (RAID_ERROR_INDEX + 15) // BGA is running
#define NET_DVR_LD_NO_ATAPI                 (RAID_ERROR_INDEX + 16) // Can not create virtual disk with ATAPI drive
#define NET_DVR_MIGRATION_NOT_NEED          (RAID_ERROR_INDEX + 17) // Migration is not necessary
#define NET_DVR_HD_TYPE_MISMATCH            (RAID_ERROR_INDEX + 18) // Physical disks are not of the same type
#define NET_DVR_NO_LD_IN_DG                 (RAID_ERROR_INDEX + 19) // No virtual disk exist on the specified array
#define NET_DVR_NO_ROOM_FOR_SPARE           (RAID_ERROR_INDEX + 20) // Disk space is too small to be assigned as spare drive
#define NET_DVR_SPARE_IS_IN_MULTI_DG        (RAID_ERROR_INDEX + 21) // Disk is already assigned as a spare drive for an array
#define NET_DVR_DG_HAS_MISSING_PD           (RAID_ERROR_INDEX + 22) // Disk is missing from an array
// x86 64bit nvr 2012-02-04
#define NET_DVR_NAME_EMPTY                    (RAID_ERROR_INDEX + 23) /*Name is empty*/
#define NET_DVR_INPUT_PARAM                    (RAID_ERROR_INDEX + 24) /*Input param is wrong*/
#define NET_DVR_PD_NOT_AVAILABLE            (RAID_ERROR_INDEX + 25) /*Physics disk is not available*/
#define NET_DVR_ARRAY_NOT_AVAILABLE            (RAID_ERROR_INDEX + 26) /*Array is not available*/
#define NET_DVR_PD_COUNT                    (RAID_ERROR_INDEX + 27) /*Physics disk number is wrong*/
#define NET_DVR_VD_SMALL                    (RAID_ERROR_INDEX + 28) /*Virtual disk is small*/
#define NET_DVR_NO_EXIST                    (RAID_ERROR_INDEX + 29) /*Raid No exist*/
#define NET_DVR_NOT_SUPPORT                    (RAID_ERROR_INDEX + 30) /*Operation not support*/
#define NET_DVR_NOT_FUNCTIONAL                 (RAID_ERROR_INDEX + 31) /*Raid is not functional*/
#define NET_DVR_DEV_NODE_NOT_FOUND            (RAID_ERROR_INDEX + 32) /*Virtual disk device node is no exist*/
#define NET_DVR_SLOT_EXCEED                    (RAID_ERROR_INDEX + 33) /*Slot is exceed*/ 
#define NET_DVR_NO_VD_IN_ARRAY                (RAID_ERROR_INDEX + 34) /*Virtual disk is not exist in array*/
#define NET_DVR_VD_SLOT_INVALID                (RAID_ERROR_INDEX + 35) /*Virtual disk slot is invalid*/
#define NET_DVR_PD_NO_ENOUGH_SPACE            (RAID_ERROR_INDEX + 36) /*Physics disk is no enough space*/
#define NET_DVR_ARRAY_NONFUNCTION            (RAID_ERROR_INDEX + 37) /*Only functional raid can move*/
#define NET_DVR_ARRAY_NO_ENOUGH_SPACE        (RAID_ERROR_INDEX + 38) /*Array is no enough space*/
#define NET_DVR_STOPPING_SCANNING_ARRAY        (RAID_ERROR_INDEX + 39) /*Pull disk or scan array is processing*/
#define NET_DVR_NOT_SUPPORT_16T             (RAID_ERROR_INDEX + 40) /*Not support 16T*/
#define NET_DVR_ARRAY_FORMATING             (RAID_ERROR_INDEX + 41) /*Array formating*/ 
#define NET_DVR_QUICK_SETUP_PD_COUNT        (RAID_ERROR_INDEX + 42) /*at least three idle wheel cfg*/ 

#define    NET_DVR_ERROR_DEVICE_NOT_ACTIVATED    250//device not activated
#define  NET_DVR_ERROR_RISK_PASSWORD          251 //risk password
#define    NET_DVR_ERROR_DEVICE_HAS_ACTIVATED    252//device has activated already

// Intelligence error code  
#define VCA_ERROR_INDEX                     300 // VCA error index
#define NET_DVR_ID_ERROR                    (VCA_ERROR_INDEX + 0)   // Configuration ID is illegal.
#define NET_DVR_POLYGON_ERROR               (VCA_ERROR_INDEX + 1)   // Polygon does not match requirement.
#define NET_DVR_RULE_PARAM_ERROR            (VCA_ERROR_INDEX + 2)   // Rule parameter is illegal.
#define NET_DVR_RULE_CFG_CONFLICT           (VCA_ERROR_INDEX + 3)   // Configuration conflict.
#define NET_DVR_CALIBRATE_NOT_READY         (VCA_ERROR_INDEX + 4)   // Calibration not ready.
#define NET_DVR_CAMERA_DATA_ERROR           (VCA_ERROR_INDEX + 5)   // Camera parameter is illegal.
#define NET_DVR_CALIBRATE_DATA_UNFIT        (VCA_ERROR_INDEX + 6)    // Not tilt enough, not fit to calibrate.
#define NET_DVR_CALIBRATE_DATA_CONFLICT    (VCA_ERROR_INDEX + 7)    // Calibration error.
#define NET_DVR_CALIBRATE_CALC_FAIL         (VCA_ERROR_INDEX + 8)    // Failed to calculate camera calibration parameter.
#define    NET_DVR_CALIBRATE_LINE_OUT_RECT        (VCA_ERROR_INDEX + 9)    // The input calibrating line exceeds the external rectangle sample.
#define NET_DVR_ENTER_RULE_NOT_READY        (VCA_ERROR_INDEX + 10)  // Enter rule not ready.
#define NET_DVR_AID_RULE_NO_INCLUDE_LANE    (VCA_ERROR_INDEX + 11)    // It does not include lane in the traffic event rule (especial for traffic jam or driving against the traffic).
#define NET_DVR_LANE_NOT_READY                (VCA_ERROR_INDEX + 12)    // Lane not ready.
#define NET_DVR_RULE_INCLUDE_TWO_WAY        (VCA_ERROR_INDEX + 13)    // There are two different directions in event rule.
#define NET_DVR_LANE_TPS_RULE_CONFLICT      (VCA_ERROR_INDEX + 14)  // The lane conflicts with the data rule.
#define NET_DVR_NOT_SUPPORT_EVENT_TYPE      (VCA_ERROR_INDEX + 15)  // Event type is not support.
#define NET_DVR_LANE_NO_WAY                 (VCA_ERROR_INDEX + 16)  // Lane has not direction.
#define NET_DVR_SIZE_FILTER_ERROR           (VCA_ERROR_INDEX + 17)  // Size filter is error.
#define NET_DVR_LIB_FFL_NO_FACE             (VCA_ERROR_INDEX + 18)  // Picture of feature point location has not face.
#define NET_DVR_LIB_FFL_IMG_TOO_SMALL       (VCA_ERROR_INDEX + 19)  // Picture of feature point location is too small.
#define NET_DVR_LIB_FD_IMG_NO_FACE          (VCA_ERROR_INDEX + 20)  // Picture of single detect has not face.
#define NET_DVR_LIB_FACE_TOO_SMALL          (VCA_ERROR_INDEX + 21)  // Face is too small when modeling.
#define NET_DVR_LIB_FACE_QUALITY_TOO_BAD    (VCA_ERROR_INDEX + 22)  // Face quality is too bad when modeling.
#define NET_DVR_KEY_PARAM_ERR               (VCA_ERROR_INDEX + 23)  //Key parameter is error.
#define NET_DVR_CALIBRATE_DATA_ERR          (VCA_ERROR_INDEX + 24)  //Calibrate data is error.
#define NET_DVR_CALIBRATE_DISABLE_FAIL      (VCA_ERROR_INDEX + 25)  //Disable calibrate has failed.
#define NET_DVR_VCA_LIB_FD_SCALE_OUTRANGE   (VCA_ERROR_INDEX + 26)  //Filter scale is out range.
#define NET_DVR_LIB_FD_REGION_TOO_LARGE     (VCA_ERROR_INDEX + 27)  //Region is too big.
#define NET_DVR_TRIAL_OVERDUE               (VCA_ERROR_INDEX + 28) //Trial overdue.
#define NET_DVR_CONFIG_FILE_CONFLICT        (VCA_ERROR_INDEX + 29) //Config file conflict.

#define NET_DVR_FR_FPL_FAIL                 (VCA_ERROR_INDEX + 30)   //Feature points location is error in face recognition
#define NET_DVR_FR_IQA_FAIL                 (VCA_ERROR_INDEX + 31)   //Image quality assessment is error in face recognition
#define NET_DVR_FR_FEM_FAIL                 (VCA_ERROR_INDEX + 32)   //Feature extract & match error in face recognition
#define NET_DVR_FPL_DT_CONF_TOO_LOW         (VCA_ERROR_INDEX + 33)   //Detection confidence is too low in feature points location
#define NET_DVR_FPL_CONF_TOO_LOW            (VCA_ERROR_INDEX + 34)   //Confidence is too low in feature points location
#define NET_DVR_E_DATA_SIZE                 (VCA_ERROR_INDEX + 35)  //Size of model data error
#define NET_DVR_FR_MODEL_VERSION_ERR        (VCA_ERROR_INDEX + 36)  //Model version is error
#define NET_DVR_FR_FD_FAIL                  (VCA_ERROR_INDEX + 37)  //Face detection error in face recognition
#define NET_DVR_FA_NORMALIZE_ERR            (VCA_ERROR_INDEX + 38)  //Face attribute normalize error

#define NET_DVR_DOG_PUSTREAM_NOT_MATCH      (VCA_ERROR_INDEX + 39)  //Pustream and softdog are mismatched
#define NET_DVR_DEV_PUSTREAM_NOT_MATCH      (VCA_ERROR_INDEX + 40)  //Pustream device version is error
#define NET_DVR_PUSTREAM_ALREADY_EXISTS     (VCA_ERROR_INDEX + 41)  //The pustream has existence
#define NET_DVR_SEARCH_CONNECT_FAILED       (VCA_ERROR_INDEX + 42)  //Failed to connect face retrieval device
#define NET_DVR_INSUFFICIENT_DISK_SPACE     (VCA_ERROR_INDEX + 43)  //Storage space is insufficient
#define NET_DVR_DATABASE_CONNECTION_FAILED  (VCA_ERROR_INDEX + 44)  //Failed to connect database
#define NET_DVR_DATABASE_ADM_PW_ERROR       (VCA_ERROR_INDEX + 45)  //Username or password is error for database
#define NET_DVR_DECODE_YUV                  (VCA_ERROR_INDEX + 46)  //Failed to decode image
#define NET_DVR_IMAGE_RESOLUTION_ERROR      (VCA_ERROR_INDEX + 47)  //Image resolution is unreasonable
#define NET_DVR_CHAN_WORKMODE_ERROR         (VCA_ERROR_INDEX + 48)  //Channel workmode error

#define NET_DVR_RTSP_ERROR_NOENOUGHPRI              401  // no authoration: when server return 401,RTSP return it.
#define NET_DVR_RTSP_ERROR_ALLOC_RESOURCE           402  // fail to alloc resource
#define NET_DVR_RTSP_ERROR_PARAMETER                403  // parameter error.
#define NET_DVR_RTSP_ERROR_NO_URL                   404  // can't find the url. when server return 404,RTSP return it.
#define NET_DVR_RTSP_ERROR_FORCE_STOP               406  // user force to stop.
#define NET_DVR_RTSP_GETPORTFAILED                  407  // rtsp get port failed

#define NET_DVR_RTSP_DESCRIBERROR                   410  // rtsp describe communicate error
#define NET_DVR_RTSP_DESCRIBESENDTIMEOUT            411  // Sending signal "DECRIBE" is timeout
#define NET_DVR_RTSP_DESCRIBESENDERROR                412  // Failed to send signal "DECRIBE"
#define NET_DVR_RTSP_DESCRIBERECVTIMEOUT            413  // Receiving signal "DECRIBE" is timeout
#define NET_DVR_RTSP_DESCRIBERECVDATALOST            414  // Receiving data of signal "DECRIBE" error
#define NET_DVR_RTSP_DESCRIBERECVERROR                415  // Failed to receive signal "DECRIBE"
#define NET_DVR_RTSP_DESCRIBESERVERERR                416  // Signal "DECRIBE" server returns the error

#define NET_DVR_RTSP_SETUPERROR                        420  // rtsp setup communicate error
#define NET_DVR_RTSP_SETUPSENDTIMEOUT                421  // Sending signal "SETUP" is timeout
#define NET_DVR_RTSP_SETUPSENDERROR                    422  // Sending signal "SETUP" error
#define NET_DVR_RTSP_SETUPRECVTIMEOUT                423  // Receiving signal "SETUP" is timeout
#define NET_DVR_RTSP_SETUPRECVDATALOST                424  // Receiving data of signal "SETUP" error
#define NET_DVR_RTSP_SETUPRECVERROR                    425  // Failed to receive signal "SETUP"
#define NET_DVR_RTSP_OVER_MAX_CHAN                    426  // It exceeds the max connection number, or no enough resource. when server return 453,RTSP return it.
#define NET_DVR_RTSP_SETUPSERVERERR                    427  // Signal "SETUP" server returns the error

#define NET_DVR_RTSP_PLAYERROR                        430  // rtsp play communicate error
#define NET_DVR_RTSP_PLAYSENDTIMEOUT                431  // Sending signal "PLAY" is timeout
#define NET_DVR_RTSP_PLAYSENDERROR                    432  // Sending signal "PLAY" error
#define NET_DVR_RTSP_PLAYRECVTIMEOUT                433  // Receiving signal "PLAY" is timeout
#define NET_DVR_RTSP_PLAYRECVDATALOST                434  // Receiving data of signal "PLAY" error
#define NET_DVR_RTSP_PLAYRECVERROR                    435  // Failed to receive signal "PLAY"
#define NET_DVR_RTSP_PLAYSERVERERR                    436  // Signal "PLAY" server returns the error

#define NET_DVR_RTSP_TEARDOWNERROR                    440  // rtsp teardown communicate error
#define NET_DVR_RTSP_TEARDOWNSENDTIMEOUT            441  // Sending signal "TEARDOWN" is timeout
#define NET_DVR_RTSP_TEARDOWNSENDERROR                442  // Sending signal "TEARDOWN" error
#define NET_DVR_RTSP_TEARDOWNRECVTIMEOUT            443  // Receiving signal "TEARDOWN" is timeout
#define NET_DVR_RTSP_TEARDOWNRECVDATALOST            444  // Receiving data of signal "TEARDOWN" error
#define NET_DVR_RTSP_TEARDOWNRECVERROR                445  // Failed to receive signal "TEARDOWN"
#define NET_DVR_RTSP_TEARDOWNSERVERERR                446  // Signal "TEARDOWN" server returns the error

#define NET_PLAYM4_NOERROR                            500     // No error
#define    NET_PLAYM4_PARA_OVER                        501     // Input parameter is invalid; 
#define NET_PLAYM4_ORDER_ERROR                        502     // The order of the function to be called is error.
#define    NET_PLAYM4_TIMER_ERROR                        503     // Create multimedia clock failed; 
#define NET_PLAYM4_DEC_VIDEO_ERROR                    504     // Decode video data failed.
#define NET_PLAYM4_DEC_AUDIO_ERROR                    505     // Decode audio data failed.
#define    NET_PLAYM4_ALLOC_MEMORY_ERROR                506     // Allocate memory failed.
#define NET_PLAYM4_OPEN_FILE_ERROR                    507     // Open the file failed.
#define NET_PLAYM4_CREATE_OBJ_ERROR                    508     // Create thread or event failed
#define NET_PLAYM4_CREATE_DDRAW_ERROR                509     // Create DirectDraw object failed.
#define NET_PLAYM4_CREATE_OFFSCREEN_ERROR            510     // Failed when creating off- screen surface.
#define NET_PLAYM4_BUF_OVER                            511     // Buffer is overflow
#define NET_PLAYM4_CREATE_SOUND_ERROR                512     // Failed when creating audio device.    
#define    NET_PLAYM4_SET_VOLUME_ERROR                    513     // Set volume failed
#define NET_PLAYM4_SUPPORT_FILE_ONLY                514     // The function only support play file.
#define NET_PLAYM4_SUPPORT_STREAM_ONLY                515     // The function only support play stream.
#define NET_PLAYM4_SYS_NOT_SUPPORT                    516     // System not support.
#define NET_PLAYM4_FILEHEADER_UNKNOWN                517     // No file header.
#define NET_PLAYM4_VERSION_INCORRECT                518     // The version of decoder and encoder is not adapted.  
#define NET_PALYM4_INIT_DECODER_ERROR                519     // Initialize decoder failed.
#define NET_PLAYM4_CHECK_FILE_ERROR                    520     // The file data is unknown.
#define NET_PLAYM4_INIT_TIMER_ERROR                    521     // Initialize multimedia clock failed.
#define    NET_PLAYM4_BLT_ERROR                        522     // BLT failed.
#define NET_PLAYM4_UPDATE_ERROR                        523     // Update failed.
#define NET_PLAYM4_OPEN_FILE_ERROR_MULTI            524  // Open file error,  stream type is multi
#define NET_PLAYM4_OPEN_FILE_ERROR_VIDEO            525  // Open file error,  stream type is video
#define NET_PLAYM4_JPEG_COMPRESS_ERROR                526  // JPEG compress error
#define NET_PLAYM4_EXTRACT_NOT_SUPPORT                527     // Don't support the version of this file.
#define NET_PLAYM4_EXTRACT_DATA_ERROR                528     // Extract video data failed.

//convert error
#define  NET_CONVERT_ERROR_NOT_SUPPORT          581  //convert not support

//audio intercom error
#define  NET_AUDIOINTERCOM_OK                   600
#define  NET_AUDIOINTECOM_ERR_NOTSUPORT         601 //not support
#define  NET_AUDIOINTECOM_ERR_ALLOC_MEMERY      602 //alloc memery error
#define  NET_AUDIOINTECOM_ERR_PARAMETER            603 //param error
#define  NET_AUDIOINTECOM_ERR_CALL_ORDER        604 //call order error
#define  NET_AUDIOINTECOM_ERR_FIND_DEVICE       605 //can not find device error
#define  NET_AUDIOINTECOM_ERR_OPEN_DEVICE       606 // open device error
#define  NET_AUDIOINTECOM_ERR_NO_CONTEXT        607 // no context error
#define  NET_AUDIOINTECOM_ERR_NO_WAVFILE        608 //no Wav file error
#define  NET_AUDIOINTECOM_ERR_INVALID_TYPE      609 // invalid type error
#define  NET_AUDIOINTECOM_ERR_ENCODE_FAIL       610 //encode fail error
#define  NET_AUDIOINTECOM_ERR_DECODE_FAIL       611 //decode fail error
#define  NET_AUDIOINTECOM_ERR_NO_PLAYBACK       612 //play back error
#define  NET_AUDIOINTECOM_ERR_DENOISE_FAIL      613 //denoise fail error
#define  NET_AUDIOINTECOM_ERR_UNKOWN            619 //unKown Error

#define NET_QOS_OK                                    700                        // No error
#define NET_QOS_ERROR                                (NET_QOS_OK - 1)        // Qos error
#define NET_QOS_ERR_INVALID_ARGUMENTS                (NET_QOS_OK - 2)        // Invalid arguments 
#define NET_QOS_ERR_SESSION_NOT_FOUND                (NET_QOS_OK - 3)        // Session net found
#define NET_QOS_ERR_LIB_NOT_INITIALIZED                (NET_QOS_OK - 4)        // Lib not initialized
#define NET_QOS_ERR_OUTOFMEM                        (NET_QOS_OK - 5)        // Out of memory
#define NET_QOS_ERR_PACKET_UNKNOW                    (NET_QOS_OK - 10)        // Packet unknown
#define NET_QOS_ERR_PACKET_VERSION                    (NET_QOS_OK - 11)        // Packet version error
#define NET_QOS_ERR_PACKET_LENGTH                    (NET_QOS_OK - 12)        // Packet length error
#define NET_QOS_ERR_PACKET_TOO_BIG                    (NET_QOS_OK - 13)        // Packet too big
#define NET_QOS_ERR_SCHEDPARAMS_INVALID_BANDWIDTH    (NET_QOS_OK - 20)        // Schedule parameters invalid bandwidth
#define NET_QOS_ERR_SCHEDPARAMS_BAD_FRACTION        (NET_QOS_OK - 21)        // Schedule parameters bad fraction
#define NET_QOS_ERR_SCHEDPARAMS_BAD_MINIMUM_INTERVAL (NET_QOS_OK - 22)        // Schedule parameters bad minimum interval

#define NET_ERROR_TRUNK_LINE                         711    //sub system has been used as trunk line
#define NET_ERROR_MIXED_JOINT                         712    //mixed jointing is not allowed
#define NET_ERROR_DISPLAY_SWITCH                     713    //can not switch display channel
#define NET_ERROR_USED_BY_BIG_SCREEN                 714    //decode resource had been used by big screen
#define NET_ERROR_USE_OTHER_DEC_RESOURCE             715    //can not use other sub systems' decode resource
#define NET_ERROR_DISP_MODE_SWITCH                     716    //display mode is switching
#define NET_ERROR_SCENE_USING                         717    //scene is using
#define NET_ERR_NO_ENOUGH_DEC_RESOURCE               718    //no enough decode resource
#define NET_ERR_NO_ENOUGH_FREE_SHOW_RESOURCE         719    //no enough free show resource
#define NET_ERR_NO_ENOUGH_VIDEO_MEMORY               720    //no enough video memory
#define NET_ERR_MAX_VIDEO_NUM                        721    //reach max video number
#define NET_ERR_WIN_COVER_FREE_SHOW_AND_NORMAL       722    //window can not cover free show window and normal window
#define NET_ERR_FREE_SHOW_WIN_SPLIT                  723    //free show window can not split
#define NET_ERR_INAPPROPRIATE_WIN_FREE_SHOW          724    //the window can not free show
#define NET_DVR_TRANSPARENT_WIN_NOT_SUPPORT_SPLIT    725    //transparent window not support split
#define NET_DVR_SPLIT_WIN_NOT_SUPPORT_TRANSPARENT    726    //split window not support transparent
#define NET_ERR_MAX_LOGO_NUM                         727    //reach max logo number
#define NET_ERR_MAX_WIN_LOOP_NUM                     728    //reach max window loop number
#define NET_ERR_VIRTUAL_LED_VERTICAL_CROSS           729    //virtual LED can not cross screen vertically
#define NET_ERR_MAX_VIRTUAL_LED_HEIGHT               730    //virtual LED height overlimit
#define NET_ERR_VIRTUAL_LED_ILLEGAL_CHARACTER        731    //illegal character in virtual LED
#define NET_ERR_BASEMAP_NOT_EXIST                    732    //base map is not existed
#define NET_ERR_LED_NOT_SUPPORT_VIRTUAL_LED          733    //LED screen does not support virtual LED
#define NET_ERR_LED_RESOLUTION_NOT_SUPPORT           734    //LED resolution not support
#define NET_ERR_PLAN_OVERDUE                         735    //plan is overdue, can not be called
#define NET_ERR_PROCESSER_MAX_SCREEN_BLK             736    //the number of screen which a single processor across reach limit
#define NET_ERR_WND_SIZE_TOO_SMALL                   737    //the size of window is too small
#define NET_ERR_WND_SPLIT_NOT_SUPPORT_ROAM           738    //split window is not supported roam
#define NET_ERR_OUTPUT_ONE_BOARD_ONE_WALL            739    //outputs of one board is not supported binded to walls 
#define NET_ERR_WND_CANNOT_LCD_AND_LED_OUTPUT        740    //window can not cross LCD and LED output
#define NET_ERR_MAX_OSD_NUM                          741    //the number of OSD is limited

#define NET_SDK_CANCEL_WND_TOPKEEP_ATTR_FIRST       751 //cancel set-top maintaining of window top attributes before set-bottom operation
#define NET_SDK_ERR_LED_SCREEN_CHECKING             752 //checking LED screen
#define NET_SDK_ERR_NOT_SUPPORT_SINGLE_RESOLUTION   753 //LCD/LED output not support single resolution configuration when binded
#define NET_SDK_ERR_LED_RESOLUTION_MISMATCHED       754 //the LED output resolution is mismatched with other LED output resolution

#define NET_SDK_ERR_MAX_VIRTUAL_LED_WIDTH           755 //virtual led max width
#define NET_SDK_ERR_MAX_VIRTUAL_LED_IN_SCREEN       756 //virtual max in screen
#define NET_SDK_ERR_MAX_VIRTUAL_LED_IN_WALL         757 //virtual max in wall
#define NET_SDK_ERR_VIRTUAL_LED_OVERLAP             758 //virtual overlap
#define NET_SDK_ERR_VIRTUAL_LED_TYPE                759 //virtual type error
#define NET_SDK_ERR_VIRTUAL_LED_COLOUR              760 //virtual color error
#define NET_SDK_ERR_VIRTUAL_LED_MOVE_DIRECTION      761 //virtual move direction error
#define NET_SDK_ERR_VIRTUAL_LED_MOVE_MODE           762 //virtual mode mode error
#define NET_SDK_ERR_VIRTUAL_LED_MOVE_SPEED          763 //virtual move speed error
#define NET_SDK_ERR_VIRTUAL_LED_DISP_MODE           764 //virtual display mode error
#define NET_SDK_ERR_VIRTUAL_LED_NO                  765 //virtual led no error
#define NET_SDK_ERR_VIRTUAL_LED_PARA                766 //virtual param error
#define NET_SDK_ERR_BASEMAP_POSITION                767 //basemap position error
#define NET_SDK_ERR_BASEMAP_PICTURE_LEN             768 //basemap picture lenth error
#define NET_SDK_ERR_BASEMAP_PICTURE_RESOLUTION      769 //basemap picture resolution error
#define NET_SDK_ERR_BASEMAP_PICTURE_FORMAT          770 //basemap picture  format error
#define NET_SDK_ERR_MAX_VIRTUAL_LED_NUM             771 //maximum number of virtual LED is limited
#define NET_SDK_ERR_MAX_TIME_VIRTUAL_LED_IN_WALL    772 //the number of time LED of one wall is limited

#define NET_ERR_TERMINAL_BUSY                         780    //terminal busy, it is in the meeting

#define NET_ERR_DATA_RETURNED_ILLEGAL                 790   //the data returned from device is illegal 
#define NET_DVR_FUNCTION_RESOURCE_USAGE_ERROR         791    //Equipment other resource-intensive function, cause the function could not be opened 

#define NET_DVR_DEV_NET_OVERFLOW                     800    // Over the ability of the device network
#define NET_DVR_STATUS_RECORDFILE_WRITING_NOT_LOCK   801    // Can't lock because the file being recording.
#define NET_DVR_STATUS_CANT_FORMAT_LITTLE_DISK       802    // Can't format little disk.

//N+1
#define NET_SDK_ERR_REMOTE_DISCONNECT                803 //Remote disconnect
#define NET_SDK_ERR_RD_ADD_RD                        804 //Redaunt device can't add redaunt device
#define NET_SDK_ERR_BACKUP_DISK_EXCEPT                805 //Backup disk exception
#define NET_SDK_ERR_RD_LIMIT                        806 //Redaunt device is up to limit
#define NET_SDK_ERR_ADDED_RD_IS_WD                    807 //Added redaunt device is work device
#define NET_SDK_ERR_ADD_ORDER_WRONG                    808 //Added order is wrong
#define NET_SDK_ERR_WD_ADD_WD                        809 //Work device can't add work device
#define NET_SDK_ERR_WD_SERVICE_EXCETP                810 //Work device cvr service exception
#define NET_SDK_ERR_RD_SERVICE_EXCETP                811 //Redaunt device cvr service exception
#define NET_SDK_ERR_ADDED_WD_IS_RD                    812 //Added work device is redaunt device
#define NET_SDK_ERR_PERFORMANCE_LIMIT                813 //Perormance limit
#define NET_SDK_ERR_ADDED_DEVICE_EXIST                814 //Added device exist

//Inquest
#define NET_SDK_ERR_INQUEST_RESUMING                815 //Inquest resuming
#define NET_SDK_ERR_RECORD_BACKUPING                816 //Record backuping
#define NET_SDK_ERR_DISK_PLAYING                    817 //Disk playing
#define NET_SDK_ERR_INQUEST_STARTED                    818 //Inquest started
#define NET_SDK_ERR_LOCAL_OPERATING                    819 //Local operating
#define NET_SDK_ERR_INQUEST_NOT_START                820 //Inquest not start
//netra3.1.0             
#define NET_SDK_ERR_CHAN_AUDIO_BIND                 821 //chan bind aduio error or no bind
//netra3.1.2 
#define NET_DVR_N_PLUS_ONE_MODE                     822 //Current equipment is N +1 mode
#define NET_DVR_CLOUD_STORAGE_OPENED                823 //Cloud storage mode is open

#define NET_DVR_ERR_OPER_NOT_ALLOWED                824   //N+0 status,not allowed
#define NET_DVR_ERR_NEED_RELOCATE                    825   //need relocate

//trial host error
#define NET_SDK_ERR_IR_PORT_ERROR                   830 //ir port error
#define NET_SDK_ERR_IR_CMD_ERROR                    831 //ir cmd error
#define NET_SDK_ERR_NOT_INQUESTING                  832 //Device in non-trial condition
#define NET_SDK_ERR_INQUEST_NOT_PAUSED              833 //Device in non-pause condition
#define NET_DVR_CHECK_PASSWORD_MISTAKE_ERROR        834 //Check the password mistake 
#define NET_DVR_CHECK_PASSWORD_NULL_ERROR           835 //Check the password can't null
#define NET_DVR_UNABLE_CALIB_ERROR                  836  //Unable to calibrate currently
#define NET_DVR_PLEASE_CALIB_ERROR                  837//Please finish the calibration first
#define NET_DVR_ERR_PANORAMIC_CAL_EMPTY             838 //No panorama image for PanoVu camera calibration in flash.
#define NET_DVR_ERR_CALIB_FAIL_PLEASEAGAIN          839 //(Calibration failed. Please calibrate again.)
#define NET_DVR_ERR_DETECTION_LINE                  840 //(Please set detection line again. The detection line should be within the red count area.)
#define NET_DVR_ERR_TURN_OFF_IMAGE_PARA             841 //Please turn off the image parameters switch first.
#define NET_DVR_EXCEED_FACE_IMAGES_ERROR            843  //exceed face images error
#define NET_DVR_ANALYSIS_FACE_IMAGES_ERROR          844  //analysis face images error
#define NET_ERR_ALARM_INPUT_OCCUPIED   845  //Alarm Input No. A<-1 is used to trigger vehicle capture.
#define NET_DVR_FACELIB_DATABASE_ERROR              846  //face lib error
#define NET_DVR_FACELIB_DATA_ERROR                  847  //face lib data error
#define NET_DVR_FACE_DATA_ID_ERROR                  848  //face pid error
#define NET_DVR_FACELIB_ID_ERROR                    849  //face lib id error
#define NET_DVR_EXCEED_FACE_LIBARY_ERROR            850  //exceed face lib error
#define NET_DVR_PIC_ANALYSIS_NO_TARGET_ERROR           851  
#define NET_DVR_SUBPIC_ANALYSIS_MODELING_ERROR         852 
#define NET_DVR_PIC_ANALYSIS_NO_RESOURCE_ERROR         853 
#define NET_DVR_ANALYSIS_ENGINES_NO_RESOURCE_ERROR                 854
#define NET_DVR_ANALYSIS_ENGINES_USAGE_EXCEED_ERROR                855
#define NET_DVR_EXCEED_HUMANMISINFO_FILTER_ENABLED_ERROR           856 
#define NET_DVR_NAME_ERROR                                         857  //name error
#define NET_DVR_NAME_EXIST_ERROR                                   858  //name exist error
#define NET_DVR_FACELIB_PIC_IMPORTING_ERROR                        859  //face lib picture importing
#define NET_DVR_ERR_CALIB_POSITION                 860 //Calibration position beyond camera motion range
#define NET_DVR_ERR_DELETE                         861 //Unable to delete
#define NET_DVR_ERR_SCENE_ID                       862 //Invalid scene ID
#define NET_DVR_ERR_CALIBING                       863 //In calibration
#define NET_DVR_PIC_FORMAT_ERROR                                   864  //picture format error
#define NET_DVR_PIC_RESOLUTION_INVALID_ERROR                       865  //picture resolution invalid error
#define NET_DVR_PIC_SIZE_EXCEED_ERROR                              866  //picture size exceed
#define NET_DVR_PIC_ANALYSIS_TARGRT_NUM_EXCEED_ERROR               867  //picture target num exceed
#define NET_DVR_ANALYSIS_ENGINES_LOADING_ERROR                     868//engine loading error
#define NET_DVR_ANALYSIS_ENGINES_ABNORMA_ERROR                     869//engine abnorma
#define NET_DVR_ANALYSIS_ENGINES_FACELIB_IMPORTING                 870//analysis engine is import face library 
#define NET_DVR_NO_DATA_FOR_MODELING_ERROR         871  //no data for modeling
#define NET_DVR_FACE_DATA_MODELING_ERROR           872 //face data modeling
#define NET_ERR_FACELIBDATA_OVERLIMIT              873  //facelib data over limit
#define NET_DVR_ANALYSIS_ENGINES_ASSOCIATED_CHANNEL  874//analysis engine has been associated channel 
#define NET_DVR_ERR_CUSTOMID_LEN                   875 //CustomID Len Error
#define NET_DVR_ERR_CUSTOMFACELIBID_REPEAT         876 //CustomFaceLibID Repeat
#define NET_DVR_ERR_CUSTOMHUMANID_REPEAT           877 //CustomHumanID Repeat
#define NET_DVR_ERR_URL_DOWNLOAD_FAIL              878 //url Download Fail
#define NET_DVR_ERR_URL_DOWNLOAD_NOTSTART          879 //url Download Not Start

#define NET_DVR_CFG_FILE_SECRETKEY_ERROR         880  //config file secret key error
#define NET_DVR_WDR_NOTDISABLE_ERROR             881  //Please disable WDR function of all camera channels.
#define NET_DVR_HLC_NOTDISABLE_ERROR             882  //Please disable HLC fucntion of all camera channels.

#define NET_DVR_THERMOMETRY_REGION_OVERSTEP_ERROR         883  //thermometry region overstep error

#define NET_DVR_ERR_MODELING_DEVICEINTERNAL      884 //Modeling failed. Device internal error
#define NET_DVR_ERR_MODELING_FACE                885 //Modeling failed. Face modeling error
#define NET_DVR_ERR_MODELING_FACEGRADING         886 //Modeling failed. Face grading error
#define NET_DVR_ERR_MODELING_FACEGFEATURE        887 //Modeling failed. Facial feature points extracting error
#define NET_DVR_ERR_MODELING_FACEGANALYZING      888 //Modeling failed. Feature analyzing error

#define NET_DVR_ERR_STREAM_LIMIT                 889 //Streaming performance reaches its limit. Please reduce simultaneous live view channels.
#define NET_DVR_ERR_STREAM_DESCRIPTION           890 //Input description for the stream.
#define NET_DVR_ERR_STREAM_DELETE                891 //Stream in use can not be deleted.
#define NET_DVR_ERR_CUSTOMSTREAM_NAME            892 //Custom stream name is empty or invalid
#define NET_DVR_ERR_CUSTOMSTREAM_NOTEXISTED      893 //The stream is not existed

#define NET_DVR_ERR_TOO_SHORT_CALIBRATING_TIME     894 //calibrate time is too short
#define NET_DVR_ERR_AUTO_CALIBRATE_FAILED     895 //auto calibrate failed
#define NET_DVR_ERR_VERIFICATION_FAILED     896 //verification failed

#define NET_DVR_NO_TEMP_SENSOR_ERROR         897  // 
#define NET_DVR_PUPIL_DISTANCE_OVERSIZE_ERROR         898  // 
#define NET_DVR_ERR_UNOPENED_FACE_SNAP           899 //

#define NET_ERR_CUT_INPUTSTREAM_OVERLIMIT           900 //cut input stream signal overlimit
#define NET_ERR_WINCHAN_IDX                             901    // Window index error
#define NET_ERR_WIN_LAYER                             902    // Window Layer    error
#define NET_ERR_WIN_BLK_NUM                             903    // Window Block error
#define NET_ERR_OUTPUT_RESOLUTION                     904    // Output resolution error
#define NET_ERR_LAYOUT                                 905    // Layout Index error
#define NET_ERR_INPUT_RESOLUTION                     906    // Input  resolution error

#define NET_ERR_SUBDEVICE_OFFLINE                     907    // device is off-line
#define NET_ERR_NO_DECODE_CHAN                         908    // no decode channel for use
#define NET_ERR_MAX_WINDOW_ABILITY                     909    // no enough resource for openning window 
#define NET_ERR_ORDER_ERROR                             910    // order error

#define NET_ERR_PLAYING_PLAN                        911    //plan is running
#define NET_ERR_DECODER_USED                        912    //decoder is using
#define    NET_ERR_OUTPUT_BOARD_DATA_OVERFLOW            913    // data is overflow on the output board
#define    NET_ERR_SAME_USER_NAME                        914    // the same user name
#define    NET_ERR_INVALID_USER_NAME                    915    // invalid user name
#define    NET_ERR_MATRIX_USING                        916    // the matrix is using
#define    NET_ERR_DIFFERENT_CHAN_TYPE                    917    // the channel type is different
#define    NET_ERR_INPUT_CHAN_BINDED                    918    // input channel is binded the other matrix channel
#define    NET_ERR_BINDED_OUTPUT_CHAN_OVERFLOW            919    // output channels that are using is over max
#define    NET_ERR_MAX_SIGNAL_NUM                        920    // signal number is overflow
#define NET_ERR_INPUT_CHAN_USING                    921    // input channel(signal)is using
#define NET_ERR_MANAGER_LOGON                         922    //manager logon ,operate failed
#define NET_ERR_USERALREADY_LOGON                     923    //the user already logon,operate failed
#define NET_ERR_LAYOUT_INIT                         924    //plan is init,operate failed
#define    NET_ERR_BASEMAP_SIZE_NOT_MATCH                925    //the size of basemap is not match
#define NET_ERR_WINDOW_OPERATING                    926    // the window is executing another action, the operate failed
#define NET_ERR_SIGNAL_UPLIMIT                        927 // there are too many windows base on this signal.
#define NET_ERR_SIGNAL_MAX_ENLARGE_TIMES            928 // can not enlarge signal to the specified times 
#define NET_ERR_ONE_SIGNAL_MULTI_CROSS              929 // one signal can not cross screen two times
#define NET_ERR_ULTRA_HD_SIGNAL_MULTI_WIN           930 // ultra HD signal can not on window two times
#define  NET_ERR_MAX_VIRTUAL_LED_WIDTH              931 //The width of Virtual LED is larger than limit value
#define  NET_ERR_MAX_VIRTUAL_LED_WORD_LEN           932 //The character number of virtual LED is larger than limit value
#define     NET_ERR_SINGLE_OUTPUTPARAM_CONFIG            933//not support single output parameter configure
#define  NET_ERR_MULTI_WIN_BE_COVER                 934// multi windows be cover
#define  NET_ERR_WIN_NOT_EXIST                        935//window  does not exist
#define  NET_ERR_WIN_MAX_SIGNALSOURCE                936// the signal source number of the window is over the limit
#define  NET_ERR_MULTI_WIN_MOVE                        937// move the multi window
#define  NET_ERR_MULTI_WIN_YPBPR_SDI                938 // the YPBPR and SDI signal source  doesn't support 9/16 split
#define  NET_ERR_DIFF_TYPE_OUTPUT_MIXUSE            939  //difference type input board mix
#define  NET_ERR_SPLIT_WIN_CROSS                    940  //split the cross window
#define  NET_ERR_SPLIT_WIN_NOT_FULL_SCREEN            941  //split the not full screen window
#define  NET_ERR_SPLIT_WIN_MANY_WIN                    942  //split the window that only has single output
#define  NET_ERR_WINDOW_SIZE_OVERLIMIT              943   //window size over limit
#define  NET_ERR_INPUTSTREAM_ALREADY_JOINT           944    //input signal is already in joint 
#define  NET_ERR_JOINT_INPUTSTREAM_OVERLIMIT          945    //joint input signal number overlimit

#define  NET_ERR_LED_RESOLUTION                        946  //LED resolution greater than output resolution
#define  NET_ERR_JOINT_SCALE_OVERLIMIT              947  //joint scale overlimit
#define  NET_ERR_INPUTSTREAM_ALREADY_DECODE            948  //input signal is already decoding
#define  NET_ERR_INPUTSTREAM_NOTSUPPORT_CAPTURE     949  //input signal does not support picture capture
#define  NET_ERR_JOINT_NOTSUPPORT_SPLITWIN            950  //joint signal can not show in multi split window

#define NET_ERR_MAX_WIN_OVERLAP                     951    //reach max allowed window overlap number
#define NET_ERR_STREAMID_CHAN_BOTH_VALID            952 //stream ID and channel cannot be valid both
#define NET_ERR_NO_ZERO_CHAN                        953 //device does not have zero channel
#define NEED_RECONNECT                                955 //need reconnect
#define NET_ERR_NO_STREAM_ID                        956 //stream ID does not exist
#define NET_DVR_TRANS_NOT_START                        957 //transcoding has not started
#define NET_ERR_MAXNUM_STREAM_ID                    958 //reach max stream ID number
#define NET_ERR_WORKMODE_MISMATCH                    959 //work mode mismatch
#define NET_ERR_MODE_IS_USING                        960 //already work in the selected mode
#define NET_ERR_DEV_PROGRESSING                        961 //device is progressing
#define NET_ERR_PASSIVE_TRANSCODING                    962 //passive transcoding
#define NET_ERR_RING_NOT_CONFIGURE                   964 //ring net not configed

#define NET_ERR_CLOSE_WINDOW_FIRST                    971  //when switching full frame rate show must close the window of the wall 
#define NET_ERR_SPLIT_WINDOW_NUM_NOT_SUPPORT        972  //input source of VGA/DVI/DP/HDMI/HDBase_T does not support 9/16 under full frame rate show
#define NET_ERR_REACH_ONE_SIGNAL_PREVIEW_MAX_LINK   973  //reach max link number of one signal preview echo
#define NET_ERR_ONLY_SPLITWND_SUPPORT_AMPLIFICATION  974  //only a split screen window  support child window amplification 
#define NET_DVR_ERR_WINDOW_SIZE_PLACE  975  //Wrong window position. 
#define NET_DVR_ERR_RGIONAL_RESTRICTIONS  976  //Screen distance exceeds the limit.
#define NET_ERR_WNDZOOM_NOT_SUPPORT  977  //single window does not support child window full screen
#define NET_ERR_LED_SCREEN_SIZE  978  //LED  screen width or height is not correct
#define NET_ERR_OPEN_WIN_IN_ERROR_AREA  979  //open a window in the illegal area, the area can not include LED screen and LCD screen
#define NET_ERR_TITLE_WIN_NOT_SUPPORT_MOVE  980  //tile pattern does not support roaming
#define NET_ERR_TITLE_WIN_NOT_SUPPORT_COVER  981  //tile pattern does not support layer covering 
#define NET_ERR_TITLE_WIN_NOT_SUPPORT_SPLIT  982  //tile pattern does not support split screen
#define NET_DVR_LED_WINDOWS_ALREADY_CLOSED  983  //the resolution of LED area output changes, the device has already closed all LED windows in this area
#define NET_DVR_ERR_CLOSE_WINDOWS  984  //Operation failed. Close the window first.
#define NET_DVR_ERR_MATRIX_LOOP_ABILITY            985 //Beyond the cycle decoding capacity.
#define NET_DVR_ERR_MATRIX_LOOP_TIME           986 //Invalid cycle decoding time.
#define NET_DVR_ERR_LINKED_OUT_ABILITY           987 //No more linked camera can be added.
#define NET_ERR_REACH_SCENE_MAX_NUM         988 //scene to upper limit 
#define NET_ERR_SCENE_MEM_NOT_ENOUGH        989 //insufficient memory to new scene
#define NET_ERR_RESOLUTION_NOT_SUPPORT_ODD_VOUT     990     //odd video output channel not support the resolution
#define NET_ERR_RESOLUTION_NOT_SUPPORT_EVEN_VOUT    991     //even video output channel not support the resolution

#define NET_DVR_CANCEL_WND_OPENKEEP_ATTR_FIRST    992     //open keep window can be closed only when it's open keep attribute is canceled
#define NET_SDK_LED_MODE_NOT_SUPPORT_SPLIT        993     //LED mode does not support window split screen
#define NET_ERR_VOICETALK_ONLY_SUPPORT_ONE_TALK   994     //only support one voice talk
#define NET_ERR_WND_POSITION_ADJUSTED             995     //the window position is adjusted by the device, and the application needs to get the location of the window again
#define NET_SDK_ERR_STARTTIME_CANNOT_LESSTHAN_CURTIME   996     //start time can not be less than the current time
#define NET_SDK_ERR_NEED_ADJUST_PLAN            997     //the scene has been associated with the plan, please delete the scene from the plan first

//ability analyze error
#define XML_ABILITY_NOTSUPPORT                      1000  //not support
#define        XML_ANALYZE_NOENOUGH_BUF                1001        //no enough buf
#define        XML_ANALYZE_FIND_LOCALXML_ERROR            1002        //can not find local xml
#define        XML_ANALYZE_LOAD_LOCALXML_ERROR            1003        //local local xml error
#define        XML_NANLYZE_DVR_DATA_FORMAT_ERROR        1004        //device ability data format error
#define        XML_ANALYZE_TYPE_ERROR                    1005        //ability type error
#define        XML_ANALYZE_XML_NODE_ERROR                1006        //XML ability node format error
#define XML_INPUT_PARAM_ERROR                       1007  //input parameter error

#define NET_DVR_ERR_RETURNED_XML_DATA  1008  //XML data error returned from device

// transport and display error
#define NET_ERR_LEDAREA_EXIST_WINDOW        1051 //lead era exist window
#define NET_ERR_AUDIO_EXIST                 1052 //output exist audio
#define NET_ERR_MATERIAL_NAME_EXIST                1053 //material name already exist
#define NET_ERR_MATERIAL_APPROVE_STATE             1054 //material approve state error
#define NET_ERR_DATAHD_SIGNAL_FORMAT               1055 //already used hd do not support signal format

#define NET_ERR_SCENE_SWITCHING                    1056 //scene is switch
#define NER_ERR_DATA_TRANSFER                      1057 //device is transfering 
#define NET_ERR_DATA_RESTORE                       1058 //device is restoring
#define NET_ERR_CHECK_NOT_ENABLE                   1059  //check not enable
#define NET_ERR_AREA_OFFLINE                       1060  //area offline 
#define NET_ERR_SCREEN_TYPE                        1061 //screen Type not match
#define NET_ERR_MIN_OPERATE_UNIT                   1062 //min operate unit not match
#define NET_ERR_MAINHD_NOT_BACKUP                  1063 //main board not backup
#define NET_ERR_ONE_BACKUP_HD                      1064 //at least one normal hd
#define NET_ERR_CONNECT_SUB_SYSTEM_ABNORMAL     1065  //connect sub system abnormal
#define NET_ERR_SERIAL_PORT_VEST             1066     //serial port vest error
#define NET_ERR_WHITE_LIST_FULL        1067           //white list full
#define NET_ERR_NOT_MATCH_SOURCE    1068         //source signal type not match
#define NET_ERR_CLOCK_VIRTUAL_LED_FULL    1069        //the virtual LED of clock full
#define NET_ERR_MAX_WIN_SIGNAL_LOOP_NUM   1070      //the window loop signals full
#define NET_ERR_RESOLUTION_NO_MATCH_FRAME 1071   //resolution not match current frame
#define NET_ERR_NOT_UPDATE_LOW_VERSION    1072   //not support update to low version firmware
#define NET_ERR_NO_CUSTOM_TO_UPDATE       1073   //no custom firmware can not update
#define NET_ERR_CHAN_RESOLUTION_NOT_SUPPORT_SPLIT  1074   //this output channel not support split screen
#define NET_ERR_HIGH_DEFINITION_NOT_SUPPORT_SPLIT  1075    //super high definition not support split screen by 9/16
#define NET_ERR_MIRROR_IMAGE_BY_VIDEO_WALL         1076    //the mirror image error about video wall
#define NET_ERR_MAX_OSD_FONT_SIZE                  1077    //the byte of OSD spillover
#define NET_ERR_HIGH_DEFINITION_NOT_SUPPORT_VIDEO_SET  1078  //high definition not support set video parameter
#define NET_ERR_TILE_MODE_NOT_SUPPORT_JOINT        1079  //tile mode not support joint
#define NET_ERR_ADD_AUDIO_MATRIX_FAILED         1080  //create audio matrix failed
#define NET_ERR_ONE_VIRTUAL_LED_AREA_BIND_ONE_AUDIO_AREA   1081  //one virtual LED area bind one audio area
#define NET_ERR_NAT_NOT_MODIFY_SERVER_NETWORK_PARAM   1082  //NAT mode cannot modify server network parameters


//Civil Error Code(1100~1200)

#define NET_ERR_PLT_USERID                          1100 //Verification platform Userid Error
#define NET_ERR_TRANS_CHAN_START                    1101 //Operation failed because of the transparent channel is open.
#define NET_ERR_DEV_UPGRADING                        1102 //Device Upgrading 
#define NET_ERR_MISMATCH_UPGRADE_PACK_TYPE          1103 //Upgrade Pack Type Mismatch
#define NET_ERR_DEV_FORMATTING                      1104 //Device Formatting
#define NET_ERR_MISMATCH_UPGRADE_PACK_VERSION       1105 //Upgrade Pack Version Mismatch
#define NET_ERR_PT_LOCKED                           1106 //PT locked

#define NET_DVR_LOGO_OVERLAY_WITHOUT_UPLOAD_PIC     1110 //logo overlay failed,without Upload Picture success
#define NET_DVR_ERR_ILLEGAL_VERIFICATION_CODE        1111 //illegal verification Code 
#define NET_DVR_ERR_LACK_VERIFICATION_CODE            1112 //lack verification Code
#define NET_DVR_ERR_FORBIDDEN_IP                    1113 //This IP address has been banned, do not allow the configuration (IP address filtering device support) 
#define NET_DVR_ERR_UNLOCKPTZ                       1114 //Invalid operation,Lock PTZ first before you save the settings.
#define NET_DVR_ERR_COUNTAREA_LARGE                 1116 //Invalid count area. The size of the count area exceeds the upper limit.
#define NET_DVR_ERR_LABEL_ID_EXCEED                 1117//label id exceed error
#define NET_DVR_ERR_LABEL_TYPE                      1118//label type error
#define NET_DVR_ERR_LABEL_FULL                      1119//label full error
#define NET_DVR_ERR_LABEL_DISABLED                  1120//label disabled error
#define NET_DVR_ERR_DOME_PT_TRANS_TO_DOME_XY        1121//dome PT translate to dome XY error
#define NET_DVR_ERR_DOME_PT_TRANS_TO_PANORAMA_XY    1122//dome PT translate to panorama XY error
#define NET_DVR_ERR_PANORAMA_XY_TRANS_TO_DOME_PT    1123//panorama XY translate to dome PT error
#define NET_DVR_ERR_SCENE_DUR_TIME_LESS_THAN_INTERV_TIME 1124//secene duration time less than interval time
#define NET_DVR_ERR_HTTP_BKN_EXCEED_ONE            1125//http broken only support one link
#define NET_DVR_ERR_DELETING_FAILED_TURN_OFF_HTTPS_ESDK_WEBSOCKETS_FIRST    1126//Deleting failed. Turn off HTTPS, Enhanced SDK Service and Websockets on Network Service page first
#define NET_DVR_ERR_DELETING_FAILED_TURN_OFF_HTTPS_ESDK_FIRST    1127//Deleting failed. Turn off HTTPS and Enhanced SDK Service on Network Service page first.
//2012-10-16 Error of alarmhost (1200~1300)
#define NET_ERR_SEARCHING_MODULE                    1201 // It is searching external modules
#define NET_ERR_REGISTERING_MODULE                  1202 // It is registering external modules
#define NET_ERR_GETTING_ZONES                        1203 // It is getting zone config parameters
#define NET_ERR_GETTING_TRIGGERS                    1204 // It is getting trigger config parameters
#define NET_ERR_ARMED_STATUS                        1205 // Armed status
#define    NET_ERR_PROGRAM_MODE_STATUS                    1206 // Program status
#define    NET_ERR_WALK_TEST_MODE_STATUS                1207 // Walk test status
#define    NET_ERR_BYPASS_STATUS                        1208 // Bypass status
#define NET_ERR_DISABLED_MODULE_STATUS                1209 // Function disabled
#define    NET_ERR_NOT_SUPPORT_OPERATE_ZONE            1210 // Not support operate zone
#define NET_ERR_NOT_SUPPORT_MOD_MODULE_ADDR            1211 // Not support mod module address
#define NET_ERR_UNREGISTERED_MODULE                    1212 // External is not registered
#define NET_ERR_PUBLIC_SUBSYSTEM_ASSOCIATE_SELF        1213 // Public subsystem can not associate itself
#define NET_ERR_EXCEEDS_ASSOCIATE_SUBSYSTEM_NUM        1214 // It is exceeds associate numbers
#define NET_ERR_BE_ASSOCIATED_BY_PUBLIC_SUBSYSTEM    1215 // The subsystem is associate by the public subsystem
#define    NET_ERR_ZONE_FAULT_STATUS                    1216 // Zone is fault status
#define  NET_ERR_SAME_EVENT_TYPE                    1217 // There is same event type in "Event cause alarm out on" and "Event cause alarm out off"    
#define NET_ERR_ZONE_ALARM_STATUS                    1218 // zone is alarm status    
#define NET_ERR_EXPANSION_BUS_SHORT_CIRCUIT            1219 // expansion bus short circuit    
#define NET_ERR_PWD_CONFLICT                        1220  //password conflict
#define NET_ERR_PWD_CONFLICT                        1220  //password conflict
#define NET_ERR_DETECTOR_GISTERED_BY_OTHER_ZONE     1221
#define NET_ERR_DETECTOR_GISTERED_BY_OTHER_PU       1222
#define NET_ERR_DETECTOR_DISCONNECT                 1223
#define NET_ERR_CALL_BUSY                           1224    //device is on the phone call
#define NET_DVR_ERR_ZONE_TAMPER_STAUS                1225    //zone is in tamper status
#define NET_DVR_ERR_WIRELESS_DEV_REGISTER             1226    //Wireless device has be registered by other panel
#define NET_DVR_ERR_WIRELESS_DEV_ADDED                1227   //Wireless device has be added
#define NET_DVR_ERR_WIRELESS_DEV_OFFLINE              1228  //Wireless device is offline
#define NET_DVR_ERR_WIRELESS_DEV_TAMPER_STATUS         1229  //Wireless device is in temper status
#define NET_DVR_ERR_GPRS_PHONE_CONFLICT    1230   
#define NET_ERR_GET_ALL_RETURN_OVER                    1300  //get all the returns number overrun 
#define NET_ERR_RESOURCE_USING                      1301  //information resources are in use and cannot be modified
#define NET_ERR_FILE_SIZE_OVERLIMIT                    1302  //the size of file is overlimit
//information publish server error code
#define NET_ERR_MATERIAL_NAME                       1303  //the name of the material illegal
#define NET_ERR_MATERIAL_NAME_LEN                   1304  //material name length is illegal
#define NET_ERR_MATERIAL_REMARK                     1305  //the remarks of the material is illegal
#define NET_ERR_MATERIAL_REMARK_LEN                 1306  //material remarks length is illegal
#define NET_ERR_MATERIAL_SHARE_PROPERTY             1307  //material shared property is illegal
#define NET_ERR_UNSUPPORT_MATERIAL_TYPE             1308  //material type is not supported
#define NET_ERR_MATERIAL_NOT_EXIST                  1309  //material does not exist
#define NET_ERR_READ_FROM_DISK                      1310  //failed to read material from the hard disk file
#define NET_ERR_WRITE_TO_DISK                       1311  //write material files to the hard drive failure
#define NET_ERR_WRITE_DATA_BASE                     1312  //write material database failure
#define NET_ERR_NO_APPROVED_NOT_EXPORT               1313  //not approved content can not export

//screen interactive error code 
#define    NET_ERR_MAX_SCREEN_CTRL_NUM                    1351  //the number of control connections to screen is limited
#define    NET_ERR_FILE_NOT_EXIST                        1352  //the file is not exist
#define NET_ERR_THUMBNAIL_NOT_EXIST                    1353  //the thumbnail is not exist
#define NET_ERR_DEV_OPEN_FILE_FAIL                    1354  //the device failed to open the file
#define NET_ERR_SERVER_READ_FILE_FAIL                1355  //the screen server failed to read the file
#define NET_ERR_FILE_SIZE                            1356  //file size error
#define    NET_ERR_FILE_NAME                            1357  //file name error, file name is empty or illegal

#define NET_ERR_BROADCAST_BUSY                     1358     //device is on broadcasting
//2012-12-20 ITC ERROR(1400-1499)
#define NET_DVR_ERR_LANENUM_EXCEED                  1400  //Lane number exceed
#define NET_DVR_ERR_PRAREA_EXCEED                   1401  //Area exceed
#define NET_DVR_ERR_LIGHT_PARAM                     1402  //Light parameter error
#define NET_DVR_ERR_LANE_LINE_INVALID               1403  //Lane line invalid
#define NET_DVR_ERR_STOP_LINE_INVALID               1404  //Stop line invalid
#define NET_DVR_ERR_LEFTORRIGHT_LINE_INVALID        1405  //Left or right line invalid
#define NET_DVR_ERR_LANE_NO_REPEAT                  1406  //Lane NO. repeat
#define NET_DVR_ERR_PRAREA_INVALID                  1407  //Area invalid
#define NET_DVR_ERR_LIGHT_NUM_EXCEED                1408  //Light number exceed
#define NET_DVR_ERR_SUBLIGHT_NUM_INVALID            1409  //Sublight number invalid
#define NET_DVR_ERR_LIGHT_AREASIZE_INVALID          1410  //Light area size invalid
#define NET_DVR_ERR_LIGHT_COLOR_INVALID             1411  //Light color invalid
#define NET_DVR_ERR_LIGHT_DIRECTION_INVALID         1412  //Light direction invalid    
#define NET_DVR_ERR_LACK_IOABLITY                    1413  //IO ablity invalid 

#define NET_DVR_ERR_FTP_PORT                        1414  //FTP port error
#define NET_DVR_ERR_FTP_CATALOGUE                   1415  //FTP catalogue error
#define NET_DVR_ERR_FTP_UPLOAD_TYPE                    1416  //FTP upload type error
#define NET_DVR_ERR_FLASH_PARAM_WRITE                1417  //Setting param flash write error
#define NET_DVR_ERR_FLASH_PARAM_READ                1418  //Getting param flash read error
#define NET_DVR_ERR_PICNAME_DELIMITER                1419  //Pic name delimiter error
#define NET_DVR_ERR_PICNAME_ITEM                    1420  //Pic name item error
#define NET_DVR_ERR_PLATE_RECOGNIZE_TYPE            1421  //Plate recognize type error
#define NET_DVR_ERR_CAPTURE_TIMES                    1422  //Capture times error
#define NET_DVR_ERR_LOOP_DISTANCE                    1423  //Loop distance error
#define NET_DVR_ERR_LOOP_INPUT_STATUS                1424  //Loop input status error
#define NET_DVR_ERR_RELATE_IO_CONFLICT                1425  //Related IO conflict
#define NET_DVR_ERR_INTERVAL_TIME                    1426  //Interval time error
#define NET_DVR_ERR_SIGN_SPEED                        1427  //Sign speed error
#define NET_DVR_ERR_PIC_FLIP                        1428  //Flip is used
#define NET_DVR_ERR_RELATE_LANE_NUMBER                1429  //Related lane number error
#define NET_DVR_ERR_TRIGGER_MODE                    1430  //Trigger mode error
#define NET_DVR_ERR_DELAY_TIME                        1431  //Delay time error
#define NET_DVR_ERR_EXCEED_RS485_COUNT                1432  //Exceed RS485 count
#define NET_DVR_ERR_RADAR_TYPE                        1433  //Radar type error
#define NET_DVR_ERR_RADAR_ANGLE                        1434  //Radar angle error
#define NET_DVR_ERR_RADAR_SPEED_VALID_TIME            1435  //Radar speed valid time error
#define NET_DVR_ERR_RADAR_LINE_CORRECT                1436  //Radar line correct error
#define NET_DVR_ERR_RADAR_CONST_CORRECT                1437  //Radar const correct error
#define NET_DVR_ERR_RECORD_PARAM                    1438  //Record param error
#define NET_DVR_ERR_LIGHT_WITHOUT_COLOR_AND_DIRECTION        1439  //Light number and other param error
#define NET_DVR_ERR_LIGHT_WITHOUT_DETECTION_REGION            1440  //Light number and detection region error
#define NET_DVR_ERR_RECOGNIZE_PROVINCE_PARAM                1441  //Plate recognize Province param error

#define NET_DVR_ERR_SPEED_TIMEOUT                 1442    //IO Speed TimeOut Param error
#define NET_DVR_ERR_NTP_TIMEZONE                  1443    //NTP TimeZone Param error
#define NET_DVR_ERR_NTP_INTERVAL_TIME             1444    //NTP Interval Time error
#define NET_DVR_ERR_NETWORK_CARD_NUM              1445    //Network Card Num error
#define NET_DVR_ERR_DEFAULT_ROUTE                 1446    //Default Route error
#define NET_DVR_ERR_BONDING_WORK_MODE             1447    //Banding Work Mode error
#define NET_DVR_ERR_SLAVE_CARD                    1448    //Slave Card error
#define NET_DVR_ERR_PRIMARY_CARD                  1449    //Primary Card error
#define NET_DVR_ERR_DHCP_PPOE_WORK                1450    //DHCP and PPOE not Meanwhile start
#define NET_DVR_ERR_NET_INTERFACE                 1451    //Net Interface invalid
#define NET_DVR_ERR_MTU                           1452    //MTU Param invalid
#define NET_DVR_ERR_NETMASK                       1453    //Netmask address invalid
#define NET_DVR_ERR_IP_INVALID                    1454    //IP address invalid
#define NET_DVR_ERR_MULTICAST_IP_INVALID          1455    //Multicast IP address invalid
#define NET_DVR_ERR_GATEWAY_INVALID               1456    //Gateway address invalid
#define NET_DVR_ERR_DNS_INVALID                   1457    //DNS Param invalid
#define NET_DVR_ERR_ALARMHOST_IP_INVALID          1458    //AlarmHost IP invalid
#define NET_DVR_ERR_IP_CONFLICT                   1459    //IP address Conflict
#define NET_DVR_ERR_NETWORK_SEGMENT               1460    //IP not support Multi Network segment
#define NET_DVR_ERR_NETPORT                       1461    //NetPort param error
#define NET_DVR_ERR_PPPOE_NOSUPPORT               1462  //Unsupport Pppoe 
#define NET_DVR_ERR_DOMAINNAME_NOSUPPORT          1463  //Not Support Domain
#define NET_DVR_ERR_NO_SPEED                      1464  //Speed Not Enabled 
#define NET_DVR_ERR_IOSTATUS_INVALID              1465  //IO Status invalidIO
#define NET_DVR_ERR_BURST_INTERVAL_INVALID        1466  //Burst Interval invalid    
#define NET_DVR_ERR_RESERVE_MODE                  1467  //Reserve Mode invalid
#define NET_DVR_ERR_LANE_NO                       1468  //Lane No error
#define NET_DVR_ERR_COIL_AREA_TYPE                1469  //Coil Area Type error
#define NET_DVR_ERR_TRIGGER_AREA_PARAM            1470  //Trigger Area Param error
#define NET_DVR_ERR_SPEED_LIMIT_PARAM             1471  //Speed Limit Param error
#define NET_DVR_ERR_LANE_PROTOCOL_TYPE            1472  //Lane Protocol Type error
#define NET_DVR_ERR_INTERVAL_TYPE                 1473  //Capture Interval Type error
#define NET_DVR_ERR_INTERVAL_DISTANCE             1474  //Capture Interval Distance error
#define NET_DVR_ERR_RS485_ASSOCIATE_DEVTYPE       1475  //Rs485 Associate DevType error
#define NET_DVR_ERR_RS485_ASSOCIATE_LANENO        1476  //Rs485 Associate LaneNo error
#define NET_DVR_ERR_LANENO_ASSOCIATE_MULTIRS485   1477  //LaneNo Associate MulitRs485 error
#define NET_DVR_ERR_LIGHT_DETECTION_REGION        1478  //Light Detection Region error
#define NET_DVR_ERR_DN2D_NOSUPPORT            1479  //Not Support Capture Frame 2D Noise Reduction
#define NET_DVR_ERR_IRISMODE_NOSUPPORT        1480  //Not Support IRIS Mode
#define NET_DVR_ERR_WB_NOSUPPORT              1481  //Not Support White Balance Mode
#define NET_DVR_ERR_IO_EFFECTIVENESS          1482  //IO Effectiveness invalid
#define NET_DVR_ERR_LIGHTNO_MAX               1483  //Access Detector Lights Red / Yellow Overrun
#define NET_DVR_ERR_LIGHTNO_CONFLICT          1484  //Access Detector Lights Red / Yellow Conflict     
#define NET_DVR_ERR_CANCEL_LINE                1485  //Trigger straight line error
#define NET_DVR_ERR_STOP_LINE               1486  //Subject line area stop line error
#define NET_DVR_ERR_RUSH_REDLIGHT_LINE      1487  //Red light trigger lines error
#define NET_DVR_ERR_IOOUTNO_MAX             1488  //IO output port number of cross-border
#define NET_DVR_ERR_IOOUTNO_AHEADTIME_MAX    1489  //IO output port ahead of time overrun
#define NET_DVR_ERR_IOOUTNO_IOWORKTIME      1490  //IO output effective duration overrun
#define NET_DVR_ERR_IOOUTNO_FREQMULTI       1491  //IO Output No Freqmulti error
#define NET_DVR_ERR_IOOUTNO_DUTYRATE        1492  //IO Output No Dutyrate error
#define NET_DVR_ERR_VIDEO_WITH_EXPOSURE     1493  //To exposure flash onset, work does not support video
#define NET_DVR_ERR_PLATE_BRIGHTNESS_WITHOUT_FLASHDET   1494  //Plate flash brightness is automatically enabled only under license onset luminance compensation mode

#define NET_DVR_ERR_RECOGNIZE_TYPE_PARAM            1495 //Identify the types of illegal license plate recognition parameters (such as cars, car, back, forward, vehicle logo recognition etc.)
#define NET_DVR_ERR_PALTE_RECOGNIZE_AREA_PARAM      1496 //Brand identification card recognition area configuration parameter illegal judgment error
#define NET_DVR_ERR_PORT_CONFLICT                   1497 //Port Conflict
#define NET_DVR_ERR_LOOP_IP                         1498 //IP cannot be the loopback address
#define NET_DVR_ERR_DRIVELINE_SENSITIVE             1499 //Driveline sensitivity error.


#define NET_ERR_VQD_TIME_CONFLICT                    1500 //VQD Diagnostic period conflicts
#define NET_ERR_VQD_PLAN_NO_EXIST                    1501 //VQD Diagnostic plan does not exist
#define NET_ERR_VQD_CHAN_NO_EXIST                    1502 //VQD Monitoring point does not exist
#define NET_ERR_VQD_CHAN_MAX                        1503 //VQD Have reached the maximum number of plans
#define NET_ERR_VQD_TASK_MAX                        1504 //VQD Have reached the maximum number of Task

#define NET_SDK_GET_INPUTSTREAMCFG                  1551  //get input signal list
#define NET_SDK_AUDIO_SWITCH_CONTROL                1552 //sub win audio switch control
#define NET_SDK_GET_VIDEOWALLDISPLAYNO              1553 //get video wall display no
#define NET_SDK_GET_ALLSUBSYSTEM_BASIC_INFO         1554//get all system basic info
#define NET_SDK_SET_ALLSUBSYSTEM_BASIC_INFO         1555 //set all system basic info
#define NET_SDK_GET_AUDIO_INFO                      1556//get all audio info
#define NET_SDK_GET_MATRIX_STATUS_V50               1557 // get matrix status _V50


//ITC new Err Code(1600~1900)
#define NET_DVR_ERR_EXCEED_MAX_CAPTURE_TIMES        1600 //Capture times exceed 2 in flash mode.
#define NET_DVR_ERR_REDAR_TYPE_CONFLICT             1601 //Radar type conflict.
#define NET_DVR_ERR_LICENSE_PLATE_NULL              1602 //License Plate is Null
#define NET_DVR_ERR_WRITE_DATABASE                  1603 //Write Database Error
#define NET_DVR_ERR_LICENSE_EFFECTIVE_TIME          1604 //License Plate Effective Time Error 
#define NET_DVR_ERR_PRERECORDED_STARTTIME_LONG      1605 //The pre recorded start time is greater than the number of illegal capture
#define NET_DVR_ERR_TRIGGER_RULE_LINE               1606 //Trigger rule line error
#define NET_DVR_ERR_LEFTRIGHT_TRIGGERLINE_NOTVERTICAL 1607 //Left and right trigger line is not vertical
#define NET_DVR_ERR_FLASH_LAMP_MODE                 1608 //Flash lamp mode error
#define NET_DVR_ERR_ILLEGAL_SNAPSHOT_NUM            1609 //Illegal capture number error
#define NET_DVR_ERR_ILLEGAL_DETECTION_TYPE          1610 //Illegal detection type error
#define NET_DVR_ERR_POSITIVEBACK_TRIGGERLINE_HIGH   1611 //Positive back to trigger line height error
#define NET_DVR_ERR_MIXEDMODE_CAPTYPE_ALLTARGETS    1612 //Mixed mode only supports capture type all targets

#define NET_DVR_ERR_CARSIGNSPEED_GREATERTHAN_LIMITSPEED  1613//Car sign speed Greaterthan limit Speed
#define NET_DVR_ERR_BIGCARSIGNSPEED_GREATERTHAN_LIMITSPEED  1614//Big Car sign speed Greaterthan limit Speed
#define NET_DVR_ERR_BIGCARSIGNSPEED_GREATERTHAN_CARSIGNSPEED  1615//Big Car sign speed Greaterthan car sign Speed
#define NET_DVR_ERR_BIGCARLIMITSPEED_GREATERTHAN_CARLIMITSPEED  1616//Big Car limit speed Greaterthan car limit Speed
#define NET_DVR_ERR_BIGCARLOWSPEEDLIMIT_GREATERTHAN_CARLOWSPEEDLIMIT  1617//Big Car low speed limit Greaterthan car low speed limit
#define NET_DVR_ERR_CARLIMITSPEED_GREATERTHAN_EXCEPHIGHSPEED  1618//Car limit speed Greaterthan car exception high speed
#define NET_DVR_ERR_BIGCARLIMITSPEED_GREATERTHAN_EXCEPHIGHSPEED  1619//Big car limit speed Greaterthan car exception high speed
#define NET_DVR_ERR_STOPLINE_MORETHAN_TRIGGERLINE  1620//Stopping more than straight lines trigger lines
#define NET_DVR_ERR_YELLOWLIGHTTIME_INVALID        1621//yellowlighttime setting error
#define NET_DVR_ERR_TRIGGERLINE1_FOR_NOT_YIELD_TO_PEDESTRIAN_CANNOT_EXCEED_TRIGGERLINE2 1622//Trigger line 1 for Not Yield to Pedestrian detection cannot exceed trigger line 2
#define NET_DVR_ERR_TRIGGERLINE2_FOR_NOT_YIELD_TO_PEDESTRIAN_CANNOT_EXCEED_TRIGGERLINE1 1623// Trigger line 2  for Not Yield to Pedestrian detection cannot exceed trigger line 1

//ACS Err Code
#define NET_ERR_TIME_OVERLAP                        1900 //time segment overlap
#define NET_ERR_HOLIDAY_PLAN_OVERLAP                1901 //holiday plan overlap
#define NET_ERR_CARDNO_NOT_SORT                     1902 //not sort card No.
#define NET_ERR_CARDNO_NOT_EXIST                    1903 //card No. inexist
#define NET_ERR_ILLEGAL_CARDNO                      1904 //card No. illegal
#define NET_ERR_ZONE_ALARM                          1905 //zone be arming
#define NET_ERR_ZONE_OPERATION_NOT_SUPPORT          1906 //zone don't support this operate
#define NET_ERR_INTERLOCK_ANTI_CONFLICT             1907 //interlock and anti conflict
#define NET_ERR_DEVICE_CARD_FULL                    1908 //card full(max 100 thousand)
#define NET_ERR_HOLIDAY_GROUP_DOWNLOAD              1909 //holiday group download error
#define NET_ERR_LOCAL_CONTROL_OFF                    1910 //local control off
#define NET_ERR_LOCAL_CONTROL_DISADD                1911 //local control disadd
#define NET_ERR_LOCAL_CONTROL_HASADD                1912 //local control hasadd
#define NET_ERR_LOCAL_CONTROL_DOORNO_CONFLICT        1913 //local control doorNO conflict
#define NET_ERR_LOCAL_CONTROL_COMMUNICATION_FAIL    1914 //local control communication fail
#define NET_ERR_OPERAND_INEXISTENCE                  1915 //operand inexistence
#define NET_ERR_LOCAL_CONTROL_OVER_LIMIT              1916 //local control over limit
#define NET_ERR_DOOR_OVER_LIMIT                         1917 //door over limit
#define NET_ERR_ALARM_OVER_LIMIT                         1918 //alarm over limit
#define NET_ERR_LOCAL_CONTROL_ADDRESS_INCONFORMITY_TYPE      1919 //local control address inconformity type
#define NET_ERR_NOT_SUPPORT_ONE_MORE_CARD           1920 //device not support one more card
#define NET_ERR_DELETE_NO_EXISTENCE_FACE            1921 //delete no existence face
#define NET_ERR_DOOR_SPECIAL_PASSWORD_REPEAT        1922 //door special password repeat
#define NET_ERR_AUTH_CODE_REPEAT                    1923 //auth code repeat
#define NET_ERR_DEPLOY_EXCEED_MAX                   1924 //deploy exceed max
#define NET_ERR_NOT_SUPPORT_DEL_FP_BY_ID            1925 //not support delete finger print by ID
#define NET_ERR_TIME_RANGE                          1926 //time range error

//VIS Error Code                                    
#define NET_DVR_ERR_OUTDOOR_COMMUNICATION            1950 //communication the door machine  abnormality
#define NET_DVR_ERR_ROOMNO_UNDEFINED                1951 //not configured  room No.
#define NET_DVR_ERR_NO_CALLING            1952 //no calling
#define NET_DVR_ERR_RINGING                1953 //rining
#define NET_DVR_ERR_IS_CALLING_NOW        1954 //calling
#define NET_DVR_ERR_NO_CALLING                        1952 //no call 
#define NET_DVR_ERR_RINGING                            1953 //ring the bell 
#define NET_DVR_ERR_IS_CALLING_NOW                    1954 //is calling now 
#define NET_DVR_ERR_LOCK_PASSWORD_WRONG             1955//Intelligent lock password mistake 
#define NET_DVR_ERR_CONTROL_LOCK_FAILURE            1956//Switch lock failure     
#define NET_DVR_ERR_CONTROL_LOCK_OVERTIME           1957//Switch lock timeout     
#define NET_DVR_ERR_LOCK_DEVICE_BUSY                1958//Intelligent lock device is busy 
#define NET_DVR_ERR_UNOPEN_REMOTE_LOCK_FUNCTION     1959//Remote lock function is not open 



#define NET_DVR_ERR_FILE_NOT_COMPLETE               2100     // File not complete
#define NET_DVR_ERR_IPC_EXIST                       2101    //IPC is exist
#define NET_DVR_ERR_ADD_IPC                         2102    //The channle has alread be added
#define NET_DVR_ERR_OUT_OF_RES                      2103    //Band is limited
#define NET_DVR_ERR_CONFLICT_TO_LOCALIP             2104    //IP address is conflict
#define NET_DVR_ERR_IP_SET                          2105    //IP address is illegal
#define NET_DVR_ERR_PORT_SET                        2106    //port is illeagl

#define NET_ERR_WAN_NOTSUPPORT                      2107     //not in the same WLAN/ not support securityquestion config or export GUID
#define NET_ERR_MUTEX_FUNCTION                      2108     //mutex function error
#define NET_ERR_QUESTION_CONFIGNUM                  2109     //security question amount error
#define NET_ERR_FACECHAN_NORESOURCE                 2110     //Face intelligent channel resource has run out 
#define NET_ERR_DATA_CALLBACK                       2111     //Data is callback
#define NET_ERR_ATM_VCA_CHAN_IS_RELATED             2112     //ATM vca channel is related 
#define NET_ERR_ATM_VCA_CHAN_IS_OVERLAPED           2113     //ATM vca channel is overlaped
#define NET_ERR_FACE_CHAN_UNOVERLAP_EACH_OTHER      2114     //Face channel can't overlap each other
#define NET_ERR_ACHIEVE_MAX_CHANNLE_LIMIT           2115     //Achieve max channel limit
#define NET_DVR_SMD_ENCODING_NORESOURSE             2116    //SMD insufficient encoding resources
#define NET_DVR_SMD_DECODING_NORESOURSE             2117    //SMD insufficient decoding resources
#define NET_DVR_FACELIB_DATA_PROCESSING             2118    //Facelib data is being processed
#define NET_DVR_ERR_LARGE_TIME_DIFFRENCE            2119    //Too large time difference between device and server
#define NET_DVR_NO_SUPPORT_WITH_PLAYBACK            2120    //Open the playback,this function is not supported
#define NET_DVR_CHANNEL_NO_SUPPORT_WITH_SMD         2121    //The channel has opened SMD,this function is not supported
#define NET_DVR_CHANNEL_NO_SUPPORT_WITH_FD          2122    //The channel has opened Face snap,this function is not supported
#define NET_DVR_ILLEGAL_PHONE_NUMBER                2123    //Illegal phone number
#define NET_DVR_ILLEGAL_CERITIFICATE_NUMBER         2124    //Illegal ceritificate number
#define NET_DVR_ERR_CHANNEL_RESOLUTION_NO_SUPPORT   2125   //Channel resolution is not supported
#define NET_DVR_ERR_CHANNEL_COMPRESSION_NO_SUPPORT  2126   //Channel compression is not supported
#define NET_DVR_ERR_CLUSTER_DEVICE_TOO_LESS                 2127  
#define NET_DVR_ERR_CLUSTER_DEL_DEVICE_CM_PLAYLOAD          2128  
#define NET_DVR_ERR_CLUSTER_DEVNUM_OVER_UPPER_LIMIT         2129  
#define NET_DVR_ERR_CLUSTER_DEVICE_TYPE_INCONFORMITY        2130  
#define NET_DVR_ERR_CLUSTER_DEVICE_VERSION_INCONFORMITY     2131  
#define NET_DVR_ERR_CLUSTER_IP_CONFLICT                     2132  
#define NET_DVR_ERR_CLUSTER_IP_INVALID                      2133  
#define NET_DVR_ERR_CLUSTER_PORT_CONFLICT                   2134  
#define NET_DVR_ERR_CLUSTER_PORT_INVALID                    2135  
#define NET_DVR_ERR_CLUSTER_USERNAEM_OR_PASSWORD_INVALID    2136  
#define NET_DVR_ERR_CLUSTER_DEVICE_ALREADY_EXIST            2137 
#define NET_DVR_ERR_CLUSTER_DEVICE_NOT_EXIST                2138  
#define NET_DVR_ERR_CLUSTER_NON_CLUSTER_MODE                2139  
#define NET_DVR_ERR_CLUSTER_IP_NOT_SAME_LAN                 2140  

#define NET_DVR_ERR_CAPTURE_PACKAGE_FAILED                  2141  //Capture package failed
#define NET_DVR_ERR_CAPTURE_PACKAGE_PROCESSING              2142  //Capture package processing
#define NET_DVR_ERR_SAFETY_HELMET_NO_RESOURCE               2143  //Safety helmet has insufficient detection resources
#define NET_DVR_NO_SUPPORT_WITH_ABSTRACT                    2144  //Open the abstract,this function is not supported
#define NET_DVR_ERR_TAPE_LIB_NEED_STOP_ARCHIVE              2145  //The tape library needs to stop archiving
#define NET_DVR_INSUFFICIENT_DEEP_LEARNING_RESOURCES        2146  //Deep learning resources exceed limits
#define NET_DVR_ERR_IDENTITY_KEY                            2147  //Identity key error
#define NET_DVR_MISSING_IDENTITY_KEY                        2148  //Identity key is missing
#define NET_DVR_NO_SUPPORT_WITH_PERSON_DENSITY_DETECT       2149  //Open the person density detect,this function is not supported
#define NET_DVR_IPC_RESOLUTION_OVERFLOW                     2150  //IPC resolution overflow
#define NET_DVR_IPC_BITRATE_OVERFLOW                        2151  //IPC bitrate overflow
#define NET_DVR_ERR_INVALID_TASKID                          2152  //Invalid taskid
#define NET_DVR_PANEL_MODE_NOT_CONFIG                       2153  //No configuration panel mode.
#define NET_DVR_NO_HUMAN_ENGINES_RESOURCE                   2154  //No human engines resource
#define NET_DVR_ERR_TASK_NUMBER_OVERFLOW                    2155  //Task number overflow
#define NET_DVR_ERR_COLLISION_TIME_OVERFLOW                 2156  //Collision time overflow
#define NET_DVR_ERR_CAPTURE_PACKAGE_NO_USB                  2157  //No usb when capture package
#define NET_DVR_ERR_NO_SET_SECURITY_EMAIL                   2158  //The security email is not set
#define NET_DVR_ERR_EVENT_NOTSUPPORT                        2159  //The event is not support
#define NET_DVR_ERR_PASSWORD_FORMAT                         2160  //The password format is wrong
#define NET_DVR_ACCESS_FRONT_DEVICE_PARAM_FAILURE           2161  //The device access front device param failure
#define NET_DVR_ACCESS_FRONT_DEVICE_STREAM_FAILURE          2162  //The device access front device stream failure
#define NET_DVR_ERR_USERNAME_FORMAT                         2163  //The username format is wrong
#define NET_DVR_ERR_UNOPENED_HIGH_RESOLUTION_MODE           2164  //High resolution mode is not open
#define NET_DVR_ERR_TOO_SMALL_QUATO                         2165  //Quota setting is too small
#define NET_DVR_ERR_EMAIL_FORMAT                            2166  //The email format is wrong
#define NET_DVR_ERR_SECURITY_CODE_FORMAT                    2167  //The security code format is wrong
#define NET_DVR_PD_SPACE_TOO_SMALL                          2168  //The array hard disk is too small
#define NET_DVR_PD_NUM_TOO_BIG                              2169  //The total number of array hard disks exceeds one half of the total number
#define NET_DVR_ERR_USB_IS_FULL                             2170  //USB is full
#define NET_DVR_EXCEED_MAX_SMD_TYPE                         2171  //The maximum type of SMD event is reached
#define NET_DVR_CHANNEL_NO_SUPPORT_WITH_BEHAVIOR            2172  //The channel is open for behavior analysis and does not support this function
#define NET_DVR_NO_BEHAVIOR_ENGINES_RESOURCE                2173  //Behavioral analysis resources are insufficient
#define NET_DVR_NO_RETENTION_ENGINES_RESOURCE               2174  //Personnel detention resources are insufficient
#define NET_DVR_NO_LEAVE_POSITION_ENGINES_RESOURCE          2175  //Leave position resources are insufficient
#define NET_DVR_NO_PEOPLE_NUM_CHANGE_ENGINES_RESOURCE       2176  //People number change resources are insufficient
#define NET_DVR_PANEL_MODE_NUM_OVER_LIMIT                   2177  //Exceeding the maximum number of panel mode
#define NET_DVR_SURROUND_MODE_NUM_OVER_LIMIT                2178  //Exceeding the maximum number of environmental mode
#define NET_DVR_FACE_MODE_NUM_OVER_LIMIT                    2179  //Exceeding the maximum number of face mode
#define NET_DVR_SAFETYCABIN_MODE_NUM_OVER_LIMIT             2180  //Exceeding the maximum number of safetycabin mode
#define NET_DVR_DETECT_REGION_RANGE_INVALID                 2181  //The detection area is illegal
#define NET_DVR_CHANNEL_CAPTURE_PICTURE_FAILURE             2182  //Channel capture failed
#define NET_DVR_VCACHAN_IS_NORESOURCE                       2183  //Smart channel resources run out
#define NET_DVR_IPC_NUM_REACHES_LIMIT                       2184  // The number of IPC channels reaches the upper limit
#define NET_DVR_IOT_NUM_REACHES_LIMIT                       2185  // The number of IOT channels reaches the upper limit
#define NET_DVR_IOT_CHANNEL_DEVICE_EXIST                    2186  //The current IOT channel has added devices
#define NET_DVR_IOT_CHANNEL_DEVICE_NOT_EXIST                2187  //There is no device in the current IOT channel
#define NET_DVR_INVALID_IOT_PROTOCOL_TYPE                   2188  //Illegal IOT protocol type
#define NET_DVR_INVALID_EZVIZ_SECRET_KEY                    2189  //Invalid ezviz secret key
#define NET_DVR_DUPLICATE_IOT_DEVICE                        2190  //Duplicate IOT devices
#define NET_DVR_SADP_MODIFY_FALIURE                         2191  //SADP modification failed
#define NET_DVR_IPC_NETWORK_ABNORMAL                        2192  //IPC network anomaly
#define NET_DVR_IPC_PASSWORD_ERROR                          2193  //IPC user name and password error
#define NET_DVR_ERROR_IPC_TYPE                              2194  //Wrong type of IPC
#define NET_DVR_ERROR_IPC_LIST_NOT_EMPTY                    2195  //The list of added IPC is not empty
#define NET_DVR_ERROR_IPC_LIST_NOT_MATCH_PAIRING            2196  //The IPC list does not match the pairing
#define NET_DVR_ERROR_IPC_BAD_LANGUAGE                      2197  //The IPC language does not match the device
#define NET_DVR_ERROR_IPC_IS_LOCKING                        2198  //The IPC is locking
#define NET_DVR_ERROR_IPC_NOT_ACTIVATED                     2199  //The IPC is not activated
#define NET_DVR_FIELD_CODING_NOT_SUPPORT                    2200  //Field coding is not supported
#define NET_DVR_ERROR_H323_NOT_SUPPORT_H265                 2201  //H323 video conference does not support H265 stream
#define NET_DVR_ERROR_EXPOSURE_TIME_TOO_BIG_IN_MODE_P       2202  //Under P mode, the exposure time is too large
#define NET_DVR_ERROR_EXPOSURE_TIME_TOO_BIG_IN_MODE_N       2203  //Under N mode, the exposure time is too large
#define NET_DVR_ERROR_PING_PROCESSING                       2204  //Ping is processing
#define NET_DVR_ERROR_PING_NOT_START                        2205  //Ping has not started
#define NET_DVR_ERROR_NEED_DOUBLE_VERIFICATION              2206  //Need double verification
#define NET_DVR_NO_DOUBLE_VERIFICATION_USER                 2207  //No double verification user
#define NET_DVR_CHANNEL_OFFLINE                             2208  //The channel is offline
#define NET_DVR_TIMESPAN_NUM_OVER_LIMIT                     2209  //Time periods exceeded the maximum number of supported
#define NET_DVR_CHANNEL_NUM_OVER_LIMIT                      2210  //The number of channels exceeds the maximum number of supported channels
#define NET_DVR_NO_SEARCH_ID_RESOURCE                       2211  //The searchID resources for the paging query are insufficient
#define NET_DVR_ERROR_ONEKEY_EXPORT                         2212  //Export is underway, please try again later
#define NET_DVR_NO_CITY_MANAGEMENT_ENGINES_RESOURCE         2213  //City management algorithm engine resources are insufficient
#define NET_DVR_NO_SITUATION_ANALYSIS_ENGINES_RESOURCE      2214  //Situation analysis engine resources are insufficient
#define NET_DVR_INTELLIGENT_ANALYSIS_IPC_CANNT_DELETE       2215  //Intelligent analysing ipc can not delete 
#define NET_DVR_NOSUPPORT_RESET_PASSWORD                    2216  //NVR does not support resetting passwords to IPC
#define NET_DVR_ERROR_IPC_NEED_ON_LAN                       2217  //IPC needs to be on LAN
#define NET_DVR_CHANNEL_NO_SUPPORT_WITH_SAFETY_HELMET       2218  //The channel has opened safety helmet,this function is not supported
#define NET_DVR_ERROR_GET_RESETPASSWORDTYPE_IS_ABNORMAL     2219  /*Reset password type exception for IPC*/
#define NET_DVR_ERROR_IPC_NOSUPPORT_RESET_PASSWORD          2220  /* Reset passwords are not supported by IPC*/
#define NET_DVR_ERROR_IP_IS_NOT_ONLY_ONE                    2221 /*The IPC IP is not unique*/
#define NET_DVR_NO_SUPPORT_WITH_SMD_OR_SCD                  2222  //Open the SMD/SCD,this function is not supported
#define NET_DVR_NO_SUPPORT_WITH_FD                          2223  //Open the FD,this function is not supported
#define NET_DVR_NO_FD_ENGINES_RESOURCE                      2224  //FD resources are insufficient
#define NET_DVR_ERROR_ONEKEY_REMOVE                         2225  //Remove is underway, please try again later
#define NET_DVR_FACE_PIP_BACKGROUND_CHANNEL_OVERFLOW        2226  //Face pip background channel overflow
#define NET_DVR_MICIN_CHANNEL_OCCUPIED                      2227  //Micin channel occupied
#define NET_DVR_IPC_CHANNEL_IS_IN_PIP                       2228  // ipc chan is in Pip, delete  IPC  invalid

#define NET_DVR_INVALID_RECHARGE_CARD                       2230 //invalid recharge card
#define NET_DVR_CLOUD_PLATFORM_SERVER_EXCEPTION             2231 //cloud platform server exception
#define NET_DVR_OPERATION_FAILURE_WITHOUT_LOGIN             2232 //operation failure without login
#define NET_DVR_INVALID_ASSOCIATED_SERIAL_NUMBER            2233 //invalid associated serial number
#define NET_DVR_CLOUD_PLATFORM_ACCOUNT_NOT_EXIST            2234 //cloud platform account not exist
#define NET_DVR_DEVICE_SERIAL_NUMBER_REGISTERED             2235 //device serial number registered
#define NET_DVR_CONFERENCE_ROOM_NOT_EXIST                   2236 //conference room not exist
#define NET_DVR_NEED_DISABLED_ANALOG_CHANNEL                2237//need disabled analog channel
#define NET_DVR_STUDENT_ROLL_CALL_FAILURE                   2238//student roll call failure
#define NET_DVR_SUB_DEVICE_NOT_ENABLE_INDIVIDUAL_BEHAVIOR   2239//sub device not enable individual behavior
#define NET_DVR_SUB_DEVICE_CHANNEL_CONTROL_FAILED           2240//sub device channel control failed
#define NET_DVR_DEVICE_NOT_IN_CONFERENCE                    2241//device not in conference
#define NET_DVR_ALREADY_EXIST_CONFERENCE                    2242//already exist conference
#define NET_DVR_NO_SUPPORT_WITH_VIDEO_CONFERENCE            2243//no support with video conference
#define NET_DVR_START_INTERACTION_FAILURE                   2244//start interaction failure
#define NET_DVR_ASK_QUESTION_STARTED                        2245//ask question started
#define NET_DVR_ASK_QUESTION_CLOSED                         2246//ask question closed
#define NET_DVR_UNABLE_OPERATE_BY_HOST                      2247//unable operate by host
#define NET_DVR_REPEATED_ASK_QUESTION                       2248//repeated ask question
#define NET_DVR_TIMEDIFF_LESS_LIMIT                         2249/*Switch time difference less limit value (10 minutes)*/
#define NET_DVR_CHANNEL_DEVICE_EXIST                        2250  //The current channel has added devices
#define NET_DVR_CHANNEL_DEVICE_NOT_EXIST                    2251  //There is no device in the current channel

//Thermal error codes(3001 - 3500)
#define NET_DVR_ERR_NOTSUPPORT_DEICING              3001    //Notsupport Deicing
#define NET_DVR_ERR_THERMENABLE_CLOSE               3002    //Thermometry basic param enabled close 
#define NET_DVR_ERR_NOTMEET_DEICING                 3003    //The current temperature does not meet the manual de icing on the open condition 
#define NET_DVR_ERR_PANORAMIC_LIMIT_OPERATED        3004    //Panoramic maps and limit cannot be operated at the same time 
#define NET_DVR_ERR_SMARTH264_ROI_OPERATED          3005    //SmartH264 and ROI can not be operated at the same time 
#define NET_DVR_ERR_RULENUM_LIMIT   3006    //Rule Num Limit
#define NET_DVR_ERR_LASER_DEICING_OPERATED   3007    //Laser and deicing cannot be operated at the same time
#define NET_DVR_ERR_OFFDIGITALZOOM_OR_MINZOOMLIMIT   3008    //Turn off the digital zoom function or set the zoom limit to the minimum.
#define NET_DVR_ERR_FIREWAITING 3009 //Fire Waiting
#define NET_DVR_SYNCHRONIZEFOV_ERROR 3010 //
#define NET_DVR_CERTIFICATE_VALIDATION_ERROR 3011 //Certificate validation failed
#define NET_DVR_CERTIFICATES_NUM_EXCEED_ERROR 3012 //The number of certificates exceeded the upper limit

#define NET_ERR_NPQ_BASE_INDEX    8000    //NPQ base index
#define NET_ERR_NPQ_PARAM       (NET_ERR_NPQ_BASE_INDEX + 1)        //NPQ parameter error
#define NET_ERR_NPQ_SYSTEM      (NET_ERR_NPQ_BASE_INDEX + 2)        //NPQ system error
#define NET_ERR_NPQ_GENRAL      (NET_ERR_NPQ_BASE_INDEX + 3)        //NPQ gereral error
#define NET_ERR_NPQ_PRECONDITION    (NET_ERR_NPQ_BASE_INDEX + 4)    //NPQ precondition error
#define NET_ERR_NPQ_NOTSUPPORT        (NET_ERR_NPQ_BASE_INDEX + 5)  //NPQ not support

#define NET_ERR_NPQ_NOTCALLBACK    (NET_ERR_NPQ_BASE_INDEX + 100)   //NPQ NO callback
#define NET_ERR_NPQ_LOADLIB (NET_ERR_NPQ_BASE_INDEX + 101)          //NPQ library error
#define NET_ERR_NPQ_STEAM_CLOSE (NET_ERR_NPQ_BASE_INDEX + 104)      //NPQ stream close
#define NET_ERR_NPQ_MAX_LINK (NET_ERR_NPQ_BASE_INDEX + 110)         //NPQ max link
#define NET_ERR_NPQ_STREAM_CFG (NET_ERR_NPQ_BASE_INDEX + 111)       //NPQ stream config error
/*******************Global Error Code end**********************/

/*************************************************
Return value of NET_DVR_IsSupport () ,
the definition of bit 1 to bit 9 is below and TRUE means support
**************************************************/
#define NET_DVR_SUPPORT_DDRAW            0x01  // Support DIRECTDRAW,  otherwise Player can't work
#define NET_DVR_SUPPORT_BLT                0x02  // Display adapter supports BLT,  otherwise Player can't work
#define NET_DVR_SUPPORT_BLTFOURCC        0x04  // BLT supports color conversion,  otherwise,  Player will do RGB conversion in software mode; 
#define NET_DVR_SUPPORT_BLTSHRINKX        0x08  // BLT supports X- coordinate shrink,  otherwise,  Player will do it in software mode; 
#define NET_DVR_SUPPORT_BLTSHRINKY        0x10  // BLT supports Y- coordinate shrink,  otherwise,  Player will do it in software mode; 
#define NET_DVR_SUPPORT_BLTSTRETCHX        0x20  // BLT supports X- coordinate expand,  otherwise,  Player will do it in software mode; 
#define NET_DVR_SUPPORT_BLTSTRETCHY        0x40  // BLT supports Y- coordinate expand,  otherwise,  Player will do it in software mode; 
#define NET_DVR_SUPPORT_SSE                0x80  // CPU supports SSE commands, Intel Pentium3 or higher version supports SSE; 
#define NET_DVR_SUPPORT_MMX                0x100 // CPU supports MMX commands, Intel Pentium3 or higher version supports MMX

/**********************PTZ Commands begin*************************/
#define LIGHT_PWRON        2    // Switch on light 
#define WIPER_PWRON        3    // Switch on Wiper 
#define FAN_PWRON        4    // Switch on Fan 
#define HEATER_PWRON    5    // Switch on Heater 
#define AUX_PWRON1        6    // Switch on auxiliary equipment 1
#define AUX_PWRON2        7    // Switch on auxiliary equipment 2
#define SET_PRESET        8    // Configure Preset 
#define CLE_PRESET        9    // Clean Preset 

#define ZOOM_IN            11    // Zoom in
#define ZOOM_OUT        12    // Zoom out 
#define FOCUS_NEAR      13  // Focus in 
#define FOCUS_FAR       14  // Focus out
#define IRIS_OPEN       15  // Iris open 
#define IRIS_CLOSE      16  // Iris close 

#define TILT_UP            21    // PTZ tilt up 
#define TILT_DOWN        22    // PTZ tilt down
#define PAN_LEFT        23    // PTZ pan left 
#define PAN_RIGHT        24    // PTZ pan right
#define UP_LEFT            25    // PTZ turn up and left 
#define UP_RIGHT        26    // PTZ turn up and right 
#define DOWN_LEFT        27    // PTZ turn down and left 
#define DOWN_RIGHT        28    // PTZ turn down and right 
#define PAN_AUTO        29    // PTZ auto pan 

#define FILL_PRE_SEQ    30    // Add preset to sequence 
#define SET_SEQ_DWELL    31    // Set cruise point's residence time 
#define SET_SEQ_SPEED    32    // Set cruise point 
#define CLE_PRE_SEQ        33    // Delete preset from sequence 
#define STA_MEM_CRUISE    34    // Start recording trace 
#define STO_MEM_CRUISE    35    // Stop recoding trace  
#define RUN_CRUISE        36    // Start Cruise 
#define RUN_SEQ            37    // Start Sequence 
#define STOP_SEQ        38    // Stop Sequence 
#define GOTO_PRESET        39    // Go to preset 
#define DEL_SEQ         43  // delete cruise path
#define STOP_CRUISE            44    // stop cruise
#define DELETE_CRUISE        45    // delete cruise
#define DELETE_ALL_CRUISE    46    // delete all cruise

#define PAN_CIRCLE      50  // PTZ of the SS speed automatic circle scanning
#define DRAG_PTZ        51  // PTZ drag
#define LINEAR_SCAN     52  /* Area scanning */ //2014-03-15 
#define CLE_ALL_PRESET  53   /* Clean All Preset */ 
#define CLE_ALL_SEQ     54   /* Clean All Seq */ 
#define CLE_ALL_CRUISE  55   /* Clean All Cruise */ 

#define POPUP_MENU        56 /* Operation  Menu */

#define TILT_DOWN_ZOOM_IN    58    /* PTZ tilt down & Zoom in */
#define TILT_DOWN_ZOOM_OUT  59  /* PTZ tilt down & Zoom out */
#define PAN_LEFT_ZOOM_IN    60  /* PTZ pan left & Zoom in*/
#define PAN_LEFT_ZOOM_OUT   61  /* PTZ pan left & Zoom out*/
#define PAN_RIGHT_ZOOM_IN    62  /* PTZ pan right & Zoom in*/
#define PAN_RIGHT_ZOOM_OUT  63  /* PTZ pan right & Zoom out */
#define UP_LEFT_ZOOM_IN     64  /* PTZ turn up and left & Zoom in*/
#define UP_LEFT_ZOOM_OUT    65  /* PTZ turn up and left & Zoom Out*/
#define UP_RIGHT_ZOOM_IN    66  /* PTZ turn up and right & Zoom in*/
#define UP_RIGHT_ZOOM_OUT   67  /* PTZ turn up and right & Zoom Out*/
#define DOWN_LEFT_ZOOM_IN   68  /* PTZ turn down and left & Zoom in */
#define DOWN_LEFT_ZOOM_OUT  69  /* PTZ turn down and left & Zoom Out */
#define DOWN_RIGHT_ZOOM_IN    70  /* PTZ turn down and right & Zoom in */
#define DOWN_RIGHT_ZOOM_OUT    71  /* PTZ turn down and right & Zoom Out */
#define TILT_UP_ZOOM_IN        72    /* PTZ tilt up & Zoom in */
#define TILT_UP_ZOOM_OUT    73    /* PTZ tilt up & Zoom out */

#define DVR_VEHICLE_CONTROL_LIST   0x1 //Vehicle black and white list data type (data type) 2013-11-04
/**********************PTZ Commands end*************************/

/*************************************************
Play Control Commands
Macro Definition
NET_DVR_PlayBackControl
NET_DVR_PlayControlLocDisplay
NET_DVR_DecPlayBackCtrl
**************************************************/
#define NET_DVR_PLAYSTART        1  // Start Play
#define NET_DVR_PLAYSTOP        2  // Stop Play
#define NET_DVR_PLAYPAUSE        3  // Pause Play
#define NET_DVR_PLAYRESTART        4  // Restore Play
#define NET_DVR_PLAYFAST        5  // Play faster
#define NET_DVR_PLAYSLOW        6  // Play slower
#define NET_DVR_PLAYNORMAL        7  // Normal Speed
#define NET_DVR_PLAYFRAME        8  // Play frame by frame
#define NET_DVR_PLAYSTARTAUDIO    9  // Open audio
#define NET_DVR_PLAYSTOPAUDIO    10 // Close audio
#define NET_DVR_PLAYAUDIOVOLUME    11 // Adjust volume 
#define NET_DVR_PLAYSETPOS        12 // Change the playback progress 
#define NET_DVR_PLAYGETPOS        13 // Get the playback progress
#define NET_DVR_PLAYGETTIME        14 // Get the played time (available when playback by time) 
#define NET_DVR_PLAYGETFRAME    15 // Get the played frame number (available when playback by file) 
#define NET_DVR_GETTOTALFRAMES  16 // Get total frame number of current file (available when playback by file) 
#define NET_DVR_GETTOTALTIME    17 // Get total time of current file (available when playback by file) 
#define NET_DVR_THROWBFRAME        20 // Discard B frame
#define NET_DVR_SETSPEED        24 // Setup stream speed
#define NET_DVR_KEEPALIVE        25 // Keep connection with server (if callback is blocked,  send it every 2 second) 
#define NET_DVR_PLAYSETTIME        26 // Set playback position according to absolute time 
#define NET_DVR_PLAYGETTOTALLEN    27 // Get total time length of all the detected files under playback by time mode
#define NET_DVR_PLAYSETTIME_V50    28//Set playback position according to absolute time (support time zone)
#define NET_DVR_PLAY_FORWARD    29 //change stream from reverse to forward
#define NET_DVR_PLAY_REVERSE    30 //change stream from froward to reverse
#define NET_DVR_SET_DECODEFFRAMETYPE 31 //Set decode frame type
#define NET_DVR_SET_TRANS_TYPE        32    //Set Transcodeing Type 
#define NET_DVR_PLAY_CONVERT    33 //playback decode
#define NET_DVR_START_DRAWFRAME 34 //start draw I Frame 
#define NET_DVR_STOP_DRAWFRAME  35 //stop draw I Frame
#define NET_DVR_CHANGEWNDRESOLUTION   36    //change wnd size
#define NET_DVR_RESETBUFFER	    37  //reset matrix decode buffer(remote playback file)
#define NET_DVR_VOD_DRAG_ING    38 //playback in drag 
#define NET_DVR_VOD_DRAG_END    39 //end of the playback drag 
#define NET_DVR_VOD_RESET_PLAYTIME    40 //reset playback time


#define PLAYM4_DECODE_NORMAIL              0   //normal
#define PLAYM4_DECODE_KEY_FRAME            1   //decode I frame
#define PLAYM4_DECODE_NONE                 2   //none 
#define PLAYM4_DECODE_TEMPORAL_LAYER_0     3   // half 
#define PLAYM4_DECODE_TEMPORAL_LAYER_1     4   //a quarter


//Remote Key//
/* key value send to CONFIG program */
#define KEY_CODE_1        1
#define KEY_CODE_2        2
#define KEY_CODE_3        3
#define KEY_CODE_4        4
#define KEY_CODE_5        5
#define KEY_CODE_6        6
#define KEY_CODE_7        7
#define KEY_CODE_8        8
#define KEY_CODE_9        9
#define KEY_CODE_0        10
#define KEY_CODE_POWER    11
#define KEY_CODE_MENU    12
#define KEY_CODE_ENTER    13
#define KEY_CODE_CANCEL 14
#define KEY_CODE_UP        15
#define KEY_CODE_DOWN    16
#define KEY_CODE_LEFT    17
#define KEY_CODE_RIGHT    18
#define KEY_CODE_EDIT    19
#define KEY_CODE_ADD    20
#define KEY_CODE_MINUS    21
#define KEY_CODE_PLAY    22
#define KEY_CODE_REC    23
#define KEY_CODE_PAN    24
#define KEY_CODE_M        25
#define KEY_CODE_A        26
#define KEY_CODE_F1        27
#define KEY_CODE_F2        28

/* for PTZ control */
#define KEY_PTZ_UP_START     KEY_CODE_UP
#define KEY_PTZ_UP_STOP         32

#define KEY_PTZ_DOWN_START     KEY_CODE_DOWN
#define KEY_PTZ_DOWN_STOP     33

#define KEY_PTZ_LEFT_START     KEY_CODE_LEFT
#define KEY_PTZ_LEFT_STOP     34

#define KEY_PTZ_RIGHT_START  KEY_CODE_RIGHT
#define KEY_PTZ_RIGHT_STOP     35

#define KEY_PTZ_AP1_START     KEY_CODE_EDIT /* Iris+ */
#define KEY_PTZ_AP1_STOP     36

#define KEY_PTZ_AP2_START     KEY_CODE_PAN /* Iris-  */
#define KEY_PTZ_AP2_STOP     37

#define KEY_PTZ_FOCUS1_START KEY_CODE_A /* Focus+ */
#define KEY_PTZ_FOCUS1_STOP  38

#define KEY_PTZ_FOCUS2_START KEY_CODE_M /* Focus-  */
#define KEY_PTZ_FOCUS2_STOP  39

#define KEY_PTZ_B1_START     40 /* Zoom+ */
#define KEY_PTZ_B1_STOP         41

#define KEY_PTZ_B2_START     42 /* Zoom-  */
#define KEY_PTZ_B2_STOP         43

//New in 9000
#define KEY_CODE_11             44
#define KEY_CODE_12             45
#define KEY_CODE_13             46
#define KEY_CODE_14             47
#define KEY_CODE_15             48
#define KEY_CODE_16             49

/*************************Parameter Configure Commands begin*******************************/
//Used for NET_DVR_SetDVRConfig and NET_DVR_GetDVRConfig,  pay attention to corresponding Structure

#define NET_DVR_GET_DEVICECFG        100        //Get DVR Parameters
#define NET_DVR_SET_DEVICECFG        101        //Set DVR Parameters
#define NET_DVR_GET_NETCFG            102        //Get Network Parameters
#define NET_DVR_SET_NETCFG            103        //Set Network Parameters
#define NET_DVR_GET_PICCFG            104        //Get Image Parameters
#define NET_DVR_SET_PICCFG            105        //Set Image Parameters
#define NET_DVR_GET_COMPRESSCFG        106        //Get Compression Parameters
#define NET_DVR_SET_COMPRESSCFG        107        //Set Compression Parameters
#define NET_DVR_GET_RECORDCFG        108        //Get Record Parameters
#define NET_DVR_SET_RECORDCFG        109        //Set Record Parameters
#define NET_DVR_GET_DECODERCFG        110        //Get PTZ Parameters
#define NET_DVR_SET_DECODERCFG        111        //Set PTZ Parameters
#define NET_DVR_GET_RS232CFG         112        //Get RS232 Parameters
#define NET_DVR_SET_RS232CFG        113        //Set RS232 Parameters
#define NET_DVR_GET_ALARMINCFG         114        //Get Alarm In Parameters
#define NET_DVR_SET_ALARMINCFG        115        //Set Alarm In Parameters
#define NET_DVR_GET_ALARMOUTCFG     116        //Get Alarm Out Parameters
#define NET_DVR_SET_ALARMOUTCFG        117        //Set Alarm Out Parameters
#define NET_DVR_GET_TIMECFG         118        //Get DVR time
#define NET_DVR_SET_TIMECFG            119        //Set DVR time
#define NET_DVR_GET_PREVIEWCFG         120        //Get Local Preview Parameters
#define NET_DVR_SET_PREVIEWCFG        121        //Set Local Preview Parameters
#define NET_DVR_GET_VIDEOOUTCFG     122        //Get Video Output Parameters
#define NET_DVR_SET_VIDEOOUTCFG        123        //Set Video Output Parameters
#define NET_DVR_GET_USERCFG         124        //Get User Parameters
#define NET_DVR_SET_USERCFG            125        //Set User Parameters
#define NET_DVR_GET_EXCEPTIONCFG     126        //Get Exception Parameters
#define NET_DVR_SET_EXCEPTIONCFG    127        //Set Exception Parameters
#define NET_DVR_GET_ZONEANDDST        128        //Get Time Zone & DST Parameters
#define NET_DVR_SET_ZONEANDDST        129        //Set Time Zone & DST Parameters
#define NET_DVR_GET_SHOWSTRING        130        //Get OSD Parameters
#define NET_DVR_SET_SHOWSTRING        131        //Set OSD Parameters
#define NET_DVR_GET_EVENTCOMPCFG    132        //Get Event Record Parameters
#define NET_DVR_SET_EVENTCOMPCFG    133        //Set Event Record  Parameters

#define NET_DVR_GET_FTPCFG            134        //get ftp parameters
#define NET_DVR_SET_FTPCFG            135        //set ftp parameters

#define NET_DVR_GET_AUXOUTCFG        140        //Get External Alarm Configuration
#define NET_DVR_SET_AUXOUTCFG        141        //Set External Alarm Configuration
#define NET_DVR_GET_PREVIEWCFG_AUX     142        //Get - S device dual output parameters
#define NET_DVR_SET_PREVIEWCFG_AUX    143        //Set - S device dual output parameters

#define NET_DVR_GET_PASSWORD_MANAGE_CFG 144        //get password manage parameters
#define NET_DVR_SET_PASSWORD_MANAGE_CFG    145        //set password manage parameters
#define NET_DVR_UNLOCK_USER             146        //unlock user
#define NET_DVR_GET_SECURITY_CFG         147        //Get Security parameters
#define NET_DVR_SET_SECURITY_CFG         148        //Set Security parameters
#define    NET_DVR_GET_LOCKED_INFO_LIST    149        //get all locked info


/*********************************Intelligence APIs Begin***************************************/

//VCA  (NET_VCA_RULECFG) 
#define NET_DVR_SET_RULECFG                    152  //Set rule of VCA
#define NET_DVR_GET_RULECFG                    153     //Get rule of VCA
//Track parameters of Speed dome (NET_DVR_TRACK_CFG) 
#define NET_DVR_SET_TRACK_CFG                160  //Set Speed dome config 
#define NET_DVR_GET_TRACK_CFG                161  //Get Speed dome config

//Config Commands for Getting Stream
#define NET_DVR_SET_IVMS_STREAMCFG            162     //Set IVMS Parameter for getting stream
#define NET_DVR_GET_IVMS_STREAMCFG            163     //Get IVMS Parameter

//Intelligent control parameter
#define NET_DVR_SET_VCA_CTRLCFG                164     //Set intelligent control parameter
#define NET_DVR_GET_VCA_CTRLCFG                165     //Get intelligent control parameter

//Mask Area,  NET_VCA_MASK_REGION_LIST
#define NET_DVR_SET_VCA_MASK_REGION            166     //Set Mask Area 
#define NET_DVR_GET_VCA_MASK_REGION            167     //Get Mask Area 

//Get/Set Enter ATM Region Commands,  NET_VCA_ENTER_REGION
#define NET_DVR_SET_VCA_ENTER_REGION        168     //Set region parameter
#define NET_DVR_GET_VCA_ENTER_REGION        169     //Get region parameter

//NET_VCA_LINE_SEGMENT_LIST
#define NET_DVR_SET_VCA_LINE_SEGMENT 170     //set vca line segment
#define NET_DVR_GET_VCA_LINE_SEGMENT 171     //get vca line segment

// ivms mask region,  NET_IVMS_MASK_REGION_LIST
#define NET_DVR_SET_IVMS_MASK_REGION        172     //SetIVMS mask region parameter 
#define NET_DVR_GET_IVMS_MASK_REGION        173     //GetIVMS mask region parameter 
// ivms enter detecting region,  NET_IVMS_ENTER_REGION
#define NET_DVR_SET_IVMS_ENTER_REGION        174     //Set IVMS enter region parameter 
#define NET_DVR_GET_IVMS_ENTER_REGION        175     //Get IVMS enter region parameter 

//IVMS VCA Config Commands
#define NET_DVR_SET_IVMS_BEHAVIORCFG        176    //Set IVMS VCA rule 
#define NET_DVR_GET_IVMS_BEHAVIORCFG        177    //Get IVMS VCA rule 

// IVMS Playback Search
#define NET_DVR_IVMS_SET_SEARCHCFG            178     //SetIVMS Playback Search parameter 
#define NET_DVR_IVMS_GET_SEARCHCFG            179       //GetIVMS Playback Search parameter 

// SDK_V35
#define NET_DVR_SET_POSITION_TRACK            180  // Set track scene configuration info
#define NET_DVR_GET_POSITION_TRACK            181  // Get track scene configuration info

#define NET_DVR_SET_CALIBRATION                182  // Set calibration info
#define NET_DVR_GET_CALIBRATION                183  // Get calibration info

#define NET_DVR_SET_PDC_RULECFG                184  // Set PDC counting rule
#define NET_DVR_GET_PDC_RULECFG                185  // Get PDC counting rule

#define NET_DVR_SET_PU_STREAMCFG            186  // Set PU stream configuration info
#define NET_DVR_GET_PU_STREAMCFG            187  // Get PU stream configuration info

#define NET_VCA_SET_IVMS_BEHAVIOR_CFG        192  // Set IVMS VCA without time period settings
#define NET_VCA_GET_IVMS_BEHAVIOR_CFG        193  // Get IVMS VCA without time period settings

//Global Target Size filter
#define NET_VCA_SET_SIZE_FILTER                194  //Set global target size filter
#define NET_VCA_GET_SIZE_FILTER                195  //Get global target size filter

#define NET_DVR_SET_TRACK_PARAMCFG            196  // Set local menu rules of speed dome
#define NET_DVR_GET_TRACK_PARAMCFG            197  // Get local menu rules of speed dome

#define NET_DVR_SET_DOME_MOVEMENT_PARAM        198  // Set movement parameters of speed dome
#define NET_DVR_GET_DOME_MOVEMENT_PARAM        199  // Get movement parameters of speed dome

/**************************************Intelligent APIs Begin**********************************/

#define NET_DVR_GET_PICCFG_EX        200        //Get Image Parameters  (Extended) 
#define NET_DVR_SET_PICCFG_EX        201        //Set Image Parameters  (Extended) 
#define NET_DVR_GET_USERCFG_EX         202        //Get User Parameters (Extended) 
#define NET_DVR_SET_USERCFG_EX        203        //Set User Parameters (Extended) 
#define NET_DVR_GET_COMPRESSCFG_EX    204        //Get Compression Parameters  (Extended) 
#define NET_DVR_SET_COMPRESSCFG_EX    205        //Set Compression Parameters  (Extended) 


#define NET_DVR_GET_NETAPPCFG        222        //Get Network Application Parameters NTP/DDNS/EMAIL
#define NET_DVR_SET_NETAPPCFG        223        //Set Network Application Parameters NTP/DDNS/EMAIL
#define NET_DVR_GET_NTPCFG            224        //Get Network Application Parameters NTP
#define NET_DVR_SET_NTPCFG            225        //Set Network Application Parameters NTP
#define NET_DVR_GET_DDNSCFG            226        //Get Network Application Parameters DDNS
#define NET_DVR_SET_DDNSCFG            227        //Set Network Application Parameters DDNS

//Corresponding with NET_DVR_EMAILPARA
#define NET_DVR_GET_EMAILCFG        228        //Get EMAIL Configuration
#define NET_DVR_SET_EMAILCFG        229        //Set EMAIL Configuration

#define NET_DVR_GET_NFSCFG            230        // NFS disk configuration 
#define NET_DVR_SET_NFSCFG            231        // NFS disk configuration 

#define NET_DVR_GET_SHOWSTRING_EX    238        //Get Extended OSD Parameters 
#define NET_DVR_SET_SHOWSTRING_EX    239        //Set Extended OSD Parameters
#define NET_DVR_GET_NETCFG_OTHER    244        //Get Network Parameters
#define NET_DVR_SET_NETCFG_OTHER    245        //Set Network Parameters 

//NET_DVR_EMAILCFG
#define NET_DVR_GET_EMAILPARACFG    250        //Get EMAIL parameters
#define NET_DVR_SET_EMAILPARACFG    251        //Setup EMAIL parameters


#define NET_DVR_GET_DDNSCFG_EX        274        //Get Extended DDNS Parameters
#define NET_DVR_SET_DDNSCFG_EX        275        //Set Extended DDNS Parameters


#define    NET_DVR_SET_PTZPOS            292        //Set PTZ Position
#define    NET_DVR_GET_PTZPOS            293        //Get PTZ Position
#define    NET_DVR_GET_PTZSCOPE        294        //Get PTZ Scope

#define NET_DVR_GET_AP_INFO_LIST                    305//Get wireless network resource settings
#define NET_DVR_SET_WIFI_CFG                        306    //Set wireless parameters for IP device
#define NET_DVR_GET_WIFI_CFG                        307    //Get wireless parameters for IP device
#define NET_DVR_SET_WIFI_WORKMODE                    308    //Set the network interface working mode of IP device 
#define NET_DVR_GET_WIFI_WORKMODE                    309    //Get the network interface working mode of IP device 
#define    NET_DVR_GET_WIFI_STATUS                        310    //Get wireless status for IP device

/*********************************Intelligent Traffic Event Begin***************************************/
#define NET_DVR_GET_REFERENCE_REGION        400     // Get reference region
#define NET_DVR_SET_REFERENCE_REGION        401     //Set reference region

#define NET_DVR_GET_TRAFFIC_MASK_REGION     402     //Get traffic event mask region
#define NET_DVR_SET_TRAFFIC_MASK_REGION     403     //Set traffic event mask region

// #define NET_DVR_GET_SCENE_MODE           404     // Get scenario mode
// #define NET_DVR_SET_SCENE_MODE           405     // Set scenario mode 

#define NET_DVR_SET_AID_RULECFG             404     // Set traffic event rule parameters
#define NET_DVR_GET_AID_RULECFG             405     // Get traffic event rule parameters

#define NET_DVR_SET_TPS_RULECFG             406     // Set traffic rule statistics
#define NET_DVR_GET_TPS_RULECFG             407     // Get traffic rule statistics    

#define NET_DVR_SET_LANECFG                    408        // Set traffic lane rules
#define    NET_DVR_GET_LANECFG                     409        // Get traffic lane rules
#define NET_DVR_GET_VCA_RULE_COLOR_CFG      410     // Get VCA Rule Relate Color Config
#define NET_DVR_SET_VCA_RULE_COLOR_CFG      411     // Set VCA Rule Relate Color Config     
#define NET_DVR_GET_SWITCH_LAMP_CFG         412     // Get Switch lamp Config
#define NET_DVR_SET_SWITCH_LAMP_CFG         413     // Set Switch lamp Config


/*********************************Intelligent traffic events end***************************************/
#define NET_DVR_SET_FACEDETECT_RULECFG      420      // Set face detection rule
#define NET_DVR_GET_FACEDETECT_RULECFG      421      // Get face detection rule

#define NET_DVR_SET_VEHICLE_RECOG_TASK      422      // Set Vehicle two recognition tasks 
#define NET_DVR_GET_VEHICLE_RECOG_TASK      423      // Get Vehicle two recognition tasks

#define NET_DVR_SET_TIMECORRECT                432      //set time corrrect(only operation,not configure)
#define    NET_DVR_GET_CONNECT_LIST            433         //get connect list
/***************************DS9000 New Commands (_V30)  begin *****************************/
//Network (NET_DVR_NETCFG_V30) 
#define NET_DVR_GET_NETCFG_V30                1000     //Get  Network  Parameters
#define NET_DVR_SET_NETCFG_V30                1001     //Set  Network  Parameters

//Image (NET_DVR_PICCFG_V30) 
#define NET_DVR_GET_PICCFG_V30                1002     //Get Image Parameters
#define NET_DVR_SET_PICCFG_V30                1003     //Set Image Parameters

//Record (NET_DVR_RECORD_V30) 
#define NET_DVR_GET_RECORDCFG_V30            1004        //Get Record Parameters
#define NET_DVR_SET_RECORDCFG_V30            1005     //Set Record Parameters

//User (NET_DVR_USER_V30) 
#define NET_DVR_GET_USERCFG_V30             1006     //Get User Parameters
#define NET_DVR_SET_USERCFG_V30                1007     //Set User Parameters

//Record (NET_DVR_RECORD_V40)
#define NET_DVR_GET_RECORDCFG_V40            1008    //Get Record Parameters(Extended)
#define NET_DVR_SET_RECORDCFG_V40            1009    //Set Record Parameters(Extended)

//9000DDNS Config (NET_DVR_DDNSPARA_V30) 
#define NET_DVR_GET_DDNSCFG_V30                1010     //Get DDNS  (9000Extended) 
#define NET_DVR_SET_DDNSCFG_V30                1011     //Set DDNS  (9000Extended) 

//EMAIL  (NET_DVR_EMAILCFG_V30) 
#define NET_DVR_GET_EMAILCFG_V30            1012     //Get EMAIL Configuration
#define NET_DVR_SET_EMAILCFG_V30            1013     //Set EMAIL Configuration

#define NET_DVR_GET_NETCFG_V50     1015    //Get network parameter configuration (V50) 
#define NET_DVR_SET_NETCFG_V50     1016    //Set network parameter configuration (V50) 

#define NET_GET_CRUISEPOINT_V40                1018     //Get CruisePoint V40

//Cruise  (NET_DVR_CRUISE_PARA) 
#define NET_DVR_GET_CRUISE                    1020        
#define NET_DVR_SET_CRUISE                    1021        


//Alarm input   (NET_DVR_ALARMINCFG_V30) 
#define NET_DVR_GET_ALARMINCFG_V30            1024        
#define NET_DVR_SET_ALARMINCFG_V30            1025

//Alarm output   (NET_DVR_ALARMOUTCFG_V30) 
#define NET_DVR_GET_ALARMOUTCFG_V30            1026        
#define NET_DVR_SET_ALARMOUTCFG_V30            1027

//Video output   (NET_DVR_VIDEOOUT_V30) 
#define NET_DVR_GET_VIDEOOUTCFG_V30            1028        
#define NET_DVR_SET_VIDEOOUTCFG_V30            1029    

//OSD   (NET_DVR_SHOWSTRING_V30) 
#define NET_DVR_GET_SHOWSTRING_V30            1030        
#define NET_DVR_SET_SHOWSTRING_V30            1031

//Exception   (NET_DVR_EXCEPTION_V30) 
#define NET_DVR_GET_EXCEPTIONCFG_V30        1034        
#define NET_DVR_SET_EXCEPTIONCFG_V30        1035

//RS232   (NET_DVR_RS232CFG_V30) 
#define NET_DVR_GET_RS232CFG_V30            1036        
#define NET_DVR_SET_RS232CFG_V30            1037

//Structure of Setting Network Hard Disk Drive   (NET_DVR_NET_DISKCFG struct) 
#define    NET_DVR_GET_NET_DISKCFG                1038        //Get the configuration of Network Hard Disk Drive    
#define    NET_DVR_SET_NET_DISKCFG                1039        //Set the configuration of Configuring Network Hard Disk Drive


//Encoding   (NET_DVR_COMPRESSIONCFG_V30) 
#define NET_DVR_GET_COMPRESSCFG_V30            1040        
#define NET_DVR_SET_COMPRESSCFG_V30            1041        

//RS485   (NET_DVR_DECODERCFG_V30) 
#define NET_DVR_GET_DECODERCFG_V30            1042        //Get Decoder Parameters
#define NET_DVR_SET_DECODERCFG_V30            1043        //Set Decoder parameters

//Preview   (NET_DVR_PREVIEWCFG_V30) 
#define NET_DVR_GET_PREVIEWCFG_V30            1044        //Get Preview Parameters
#define NET_DVR_SET_PREVIEWCFG_V30            1045        //Set Preview Parameters

//AUX Preview  (NET_DVR_PREVIEWCFG_AUX_V30) 
#define NET_DVR_GET_PREVIEWCFG_AUX_V30        1046        //Get AUX Preview Parameters
#define NET_DVR_SET_PREVIEWCFG_AUX_V30        1047        //Set AUX Preview Parameters

//IP Channel Configuration  (NET_DVR_IPPARACFG) 
#define NET_DVR_GET_IPPARACFG                1048        //Get IP Channel Configuration info 
#define NET_DVR_SET_IPPARACFG                1049        //Set IP Channel Configuration info 

//IP Alarm In Configuration  (NET_DVR_IPALARMINCFG) 
#define NET_DVR_GET_IPALARMINCFG            1050        //Get IP Alarm In Configuration info
#define NET_DVR_SET_IPALARMINCFG            1051        //Set IP Alarm In Configuration info

//IP Alarm Out Configuration  (NET_DVR_IPALARMOUTCFG) 
#define NET_DVR_GET_IPALARMOUTCFG            1052        //Get IP Alarm Out Configuration info  
#define NET_DVR_SET_IPALARMOUTCFG            1053        //Set IP Alarm Out Configuration info 

//HD management Configuration  (NET_DVR_HDCFG) 
#define NET_DVR_GET_HDCFG                    1054        //Get HD management Configuration
#define NET_DVR_SET_HDCFG                    1055        //Get HD management Configuration

//HD Group Configuration  (NET_DVR_HDGROUP_CFG) 
#define NET_DVR_GET_HDGROUP_CFG                1056        //Get HD Group Configuration Parameters
#define NET_DVR_SET_HDGROUP_CFG                1057        //Set HD Group Configuration Parameters

//Device AudioTalk Configuration (NET_DVR_COMPRESSION_AUDIO) 
#define NET_DVR_GET_COMPRESSCFG_AUD            1058        //Get AudioTalk Configuration Parameters
#define NET_DVR_SET_COMPRESSCFG_AUD            1059        //Set AudioTalk Configuration Parameters

//2008- 08- 25
//IP Camera parameter (NET_DVR_IPPARACFG_V31 struct) 
#define NET_DVR_GET_IPPARACFG_V31            1060        //Get IP device parameter 
#define NET_DVR_SET_IPPARACFG_V31            1061        //Set IP device parameter 

//Channel resource configuration(NET_DVR_IPPARACFG_V40 structure)
#define NET_DVR_GET_IPPARACFG_V40            1062        // Get IP device parameter V40
#define NET_DVR_SET_IPPARACFG_V40            1063        // Set IP device parameter V40



//2009- 10- 26 snap device begin

#define NET_DVR_GET_CCDPARAMCFG              1067       //Get IPC CCD parameters
#define NET_DVR_SET_CCDPARAMCFG              1068       //Set IPC CCD parameters

#define NET_DVR_GET_IOINCFG                     1070       //Get I0 input parameters
#define NET_DVR_SET_IOINCFG                     1071        //Set IO input parameters

#define NET_DVR_GET_IOOUTCFG                 1072       //Get I0 output parameters
#define NET_DVR_SET_IOOUTCFG                 1073        //Set IP output parameters

#define NET_DVR_GET_FLASHCFG                 1074       //Get io flash parameters
#define NET_DVR_SET_FLASHCFG                 1075        //Set io flash parameters

#define NET_DVR_GET_LIGHTSNAPCFG             1076       //Get light parameters
#define NET_DVR_SET_LIGHTSNAPCFG             1077        //Set light parameters

#define NET_DVR_GET_MEASURESPEEDCFG             1078       //Get measure speed parameters
#define NET_DVR_SET_MEASURESPEEDCFG             1079        //Set measure speed parameters

#define NET_DVR_GET_IMAGEOVERLAYCFG             1080       //Get image overlay parameters
#define NET_DVR_SET_IMAGEOVERLAYCFG             1081       //Set image overlay parameters

#define NET_DVR_GET_SNAPCFG                     1082       //Get single IO parameters
#define NET_DVR_SET_SNAPCFG                     1083       //Set single IO parameters

#define NET_DVR_GET_VTPPARAM                 1084       //Get virtual circuit parameters
#define NET_DVR_SET_VTPPARAM                 1085       //Set virtual circuit parameters

#define NET_DVR_GET_SNAPENABLECFG             1086       //Get snap enable parameters
#define NET_DVR_SET_SNAPENABLECFG             1087       //Set snap enable parameters

#define NET_DVR_GET_POSTEPOLICECFG           1088       //Get police parameters
#define NET_DVR_SET_POSTEPOLICECFG           1089       //Set police parameters

#define NET_DVR_GET_JPEGCFG_V30                 1090        //Get JPEG parameters
#define NET_DVR_SET_JPEGCFG_V30                 1091        //Set JPEG parameters

#define NET_DVR_GET_SPRCFG                     1092       //Get configuration of license plate recognition
#define NET_DVR_SET_SPRCFG                     1093       //Set configuration of license plate recognition

#define NET_DVR_GET_PLCCFG                   1094       //Get brightness compensation configuration of license plate
#define NET_DVR_SET_PLCCFG                   1095       //Set brightness compensation configuration of license plate

#define NET_DVR_GET_DEVICESTATECFG           1096       //Get current status of device
#define NET_DVR_SET_CALIBRATE_TIME           1097       //Set calibrate time
#define NET_DVR_GET_CALIBRATE_TIME           1098       //Get calibrate time

#define NET_DVR_GET_DEVICECFG_V40             1100       //Get extended device parameters 
#define NET_DVR_SET_DEVICECFG_V40             1101       //Set extended device parameters 

#define NET_DVR_GET_ZEROCHANCFG              1102        //Get Zero channel compression parameters
#define NET_DVR_SET_ZEROCHANCFG               1103        //Set Zero channel compression parameters

#define NET_DVR_GET_ZERO_PREVIEWCFG_V30      1104       //Get Zero channel live view parameters
#define NET_DVR_SET_ZERO_PREVIEWCFG_V30      1105       //Set Zero channel live view parameters


#define NET_DVR_SET_ZERO_ZOOM                 1106       //Set Zero channel zoom configuration 
#define NET_DVR_GET_ZERO_ZOOM                 1107       //Get Zero channel zoom configuration 

//2010- 04- 13 Add NAT configuration
#define    NET_DVR_NATASSOCIATECFG_GET          1110       //Get NAT function configuration info
#define    NET_DVR_NATASSOCIATECFG_SET             1111       //Set NAT function configuration info

#define NET_DVR_GET_SNMPCFG                    1112       //Get SNMP parameters
#define NET_DVR_SET_SNMPCFG                   1113       //Set SNMP parameters

#define NET_DVR_GET_SNMPCFG_V30                1114        //Get SNMPv30 parameters 
#define NET_DVR_SET_SNMPCFG_V30               1115        //Set SNMPv30 parameters

//2010- 06- 01 Video Management System alarm configuration
#define    NET_DVR_VIDEOPLATFORMALARMCFG_GET      1130       //Get Video Management System alarm configuration
#define    NET_DVR_VIDEOPLATFORMALARMCFG_SET     1131       //Set Video Management System alarm configuration

#define NET_DVR_GET_RAID_ADAPTER_INFO        1134       //Get RAID adapter's information
#define NET_DVR_SET_RAID_ADAPTER_INFO        1135       //Get adapter information
//Big Screen Splice
#define    NET_DVR_MATRIX_BIGSCREENCFG_GET         1140       //Get Parameter
#define    NET_DVR_MATRIX_BIGSCREENCFG_SET         1141        //Set Parameter

#define NET_DVR_GET_MB_PLATFORMPARA             1145        //Get platform parameter
#define NET_DVR_SET_MB_PLATFORMPARA             1146        //Set platform parameter
#define NET_DVR_GET_MB_DEVSTATUS             1147        //Get mobile device status

#define  NET_DVR_GET_DECODER_JOINT_CHAN         1151
#define  NET_DVR_SET_DECODER_JOINT_CHAN         1152
//Multi network card parameter
#define NET_DVR_GET_NETCFG_MULTI             1161        //Get multi network card parameter
#define NET_DVR_SET_NETCFG_MULTI             1162        //Set multi network card parameter
#define NET_DVR_GET_NETCFG_MULTI_V50         1163        //Get multi network card parameter(group)
#define NET_DVR_SET_NETCFG_MULTI_V50         1164        //Set multi network card parameter(group)

#define NET_DVR_GET_CMSPARA                     1170       //Get CMS CFG
#define NET_DVR_SET_CMSPARA                     1171       //Set CMS CFG
#define NET_DVR_GET_DIALSTATUS                 1172       //Get Dial Status
#define NET_DVR_GET_SMSRELATIVEPARA             1173       //Get SMS Relative CFG
#define NET_DVR_SET_SMSRELATIVEPARA             1174       //Set SMS Relative CFG
#define NET_DVR_GET_PINSTATUS                 1175       //Get Pin Status
#define NET_DVR_SET_PINCMD                     1176       //Set PIN CMD

#define NET_DVR_SET_SENSOR_CFG                 1180       //Set sensor parameter 
#define NET_DVR_GET_SENSOR_CFG                 1181       //Get sensor parameter 
#define NET_DVR_SET_ALARMIN_PARAM             1182        //Set alarm input parameter 
#define NET_DVR_GET_ALARMIN_PARAM             1183        //Get alarm input parameter 
#define NET_DVR_SET_ALARMOUT_PARAM             1184        //Set alarm output parameter 
#define NET_DVR_GET_ALARMOUT_PARAM             1185        //Get alarm output parameter 
#define NET_DVR_SET_SIREN_PARAM                 1186        //Set siren parameter 
#define NET_DVR_GET_SIREN_PARAM                 1187        //Get siren parameter 
#define NET_DVR_SET_ALARM_RS485CFG             1188        //Set alarm host RS-485 parameter 
#define NET_DVR_GET_ALARM_RS485CFG             1189        //Get alarm host RS-485 parameter 
#define NET_DVR_GET_ALARMHOST_MAIN_STATUS     1190        //Get alarm host main status 
#define NET_DVR_GET_ALARMHOST_OTHER_STATUS     1191        //Get alarm host other status
#define NET_DVR_SET_ALARMHOST_ENABLECFG         1192        //Set alarm host enable status
#define NET_DVR_GET_ALARMHOST_ENABLECFG         1193        //Get alarm host enable status
#define NET_DVR_SET_ALARM_CAMCFG             1194        //Set configation of video integrated platform alarm triggering CAM operation
#define NET_DVR_GET_ALARM_CAMCFG             1195        //Get configation of video integrated platform alarm triggering CAM operation
#define NET_DVR_GET_GATEWAY_CFG              1196       //Get gateway configuration 
#define NET_DVR_SET_GATEWAY_CFG              1197       //Set gateway configuration
#define NET_DVR_GET_ALARMDIALMODECFG         1198        //Get alarm dial parameter
#define NET_DVR_SET_ALARMDIALMODECFG         1199        //Set alarm dial parameter
#define NET_DVR_SET_ALARMIN_PARAM_V50            1200        // Set alarm input parameterV50
#define NET_DVR_GET_ALARMIN_PARAM_V50            1201            // Get alarm input parameterV50
#define    NET_DVR_SET_WINCFG                        1202//set windows cfg

#define NET_DVR_GET_ALARMHOSTDIALSETUPMODE     1204        //Get alarm dial setup mode
#define NET_DVR_SET_ALARMHOSTDIALSETUPMODE     1205        //Set alarm dial setup mode

//video alarm host V1.3
#define NET_DVR_SET_SUBSYSTEM_ALARM             1210        //Set system alarm
#define NET_DVR_GET_SUBSYSTEM_ALARM             1211        //get system alarm
#define NET_DVR_GET_WHITELIST_ALARM             1215        //set whitelist alarm
#define NET_DVR_SET_WHITELIST_ALARM             1216        //get whitelist alarm
#define    NET_DVR_GET_ALARMHOST_MODULE_LIST     1222        //get All module
#define NET_DVR_SET_PRIOR_ALARM                 1223        //set prior alarm
#define NET_DVR_GET_PRIOR_ALARM                 1224        //set prior alarm
#define NET_DVR_SET_TAMPER_ALARMIN_PARAM     1225        // set tamper alarm in param
#define NET_DVR_GET_TAMPER_ALARMIN_PARAM     1226        // get tamper alarm in param

#define NET_DVR_GET_HOLIDAY_PARAM_CFG        1240       //Get holiday parameter
#define NET_DVR_SET_HOLIDAY_PARAM_CFG        1241       //Set holiday parameter

#define NET_DVR_GET_MOTION_HOLIDAY_HANDLE    1242       //Get holiday alarm handling mode of motion detection
#define NET_DVR_SET_MOTION_HOLIDAY_HANDLE    1243       //Set holiday alarm handling mode of motion detection

#define NET_DVR_GET_VILOST_HOLIDAY_HANDLE    1244       //Get holiday alarm handling mode of video signal lost
#define NET_DVR_SET_VILOST_HOLIDAY_HANDLE    1245       //Set holiday alarm handling mode of video signal lost

#define NET_DVR_GET_HIDE_HOLIDAY_HANDLE      1246       //Get holiday alarm handling mode of video tampering
#define NET_DVR_SET_HIDE_HOLIDAY_HANDLE      1247       //Set holiday alarm handling mode of video tampering

#define NET_DVR_GET_ALARMIN_HOLIDAY_HANDLE   1248       //Get holiday alarm handling mode of alarm input
#define NET_DVR_SET_ALARMIN_HOLIDAY_HANDLE   1249       //Set holiday alarm handling mode of alarm input

#define NET_DVR_GET_ALARMOUT_HOLIDAY_HANDLE  1250       //Get holiday alarm handling mode of alarm output
#define NET_DVR_SET_ALARMOUT_HOLIDAY_HANDLE  1251       //Set holiday alarm handling mode of alarm output

#define NET_DVR_GET_HOLIDAY_RECORD           1252       //Get holiday recording parameter
#define NET_DVR_SET_HOLIDAY_RECORD           1253       //Set holiday recording parameter

#define NET_DVR_GET_NETWORK_BONDING          1254       //Get BONDING network card parameter
#define NET_DVR_SET_NETWORK_BONDING          1255       //Set BONDING network card parameter

#define NET_DVR_GET_LINK_STATUS              1256       //Get link status of channel

#define NET_DVR_GET_DISK_QUOTA_CFG           1278       //Get disk quota configuration
#define NET_DVR_SET_DISK_QUOTA_CFG           1279       //Set disk quota configuration

#define NET_DVR_GET_JPEG_CAPTURE_CFG         1280       //Get capture configuration
#define NET_DVR_SET_JPEG_CAPTURE_CFG         1281       //Set capture configuration

#define NET_DVR_GET_SCHED_CAPTURECFG         1282       //Get capture schedule configuration
#define NET_DVR_SET_SCHED_CAPTURECFG         1283       //Set capture schedule configuration

#define NET_DVR_GET_VGA_PREVIEWCFG           1284       //Get VGA preview configuration
#define NET_DVR_SET_VGA_PREVIEWCFG           1285       //Set VGA preview configuration 

#define NET_DVR_GET_VIDEO_INPUT_EFFECT       1286       //Get the video effect
#define NET_DVR_SET_VIDEO_INPUT_EFFECT       1287       //Set the video effect

#define NET_DVR_GET_STORAGE_SERVER_SWITCH     1290       //Get Storage Server Switch
#define NET_DVR_SET_STORAGE_SERVER_SWITCH     1291       //Set Storage Server Switch

#define NET_DVR_GET_OPTICAL_CHANNEL             1300        //Get coder subsystem optical channel relation
#define NET_DVR_SET_OPTICAL_CHANNEL             1301        //Set coder subsystem optical channel relation
#define NET_DVR_GET_FIBER_CASCADE             1302        //Get fiber cascade mode
#define NET_DVR_SET_FIBER_CASCADE             1303        //Set fiber cascade mode
#define NET_DVR_GET_SPARTAN_STATUS             1304        //Get spatan status
#define NET_DVR_SET_SPARTAN_STATUS             1305        //Set spatan status
#define NET_DVR_GET_ETHERNET_CHANNEL         1306        //Get ethernet channel configuration
#define NET_DVR_SET_ETHERMET_CHANNEL         1307        //Set ethernet channel configuration
#define NET_DVR_OPTICAL_REBOOT                 1320        //Reboot optical transceiver
#define NET_DVR_SET_AUDIOCHAN_CFG            1321        //set audio switch configuration
#define NET_DVR_GET_AUDIOCHAN_CFG            1322        //get audio switch configuration

//SDI1.0
#define NET_DVR_SET_MATRIX_BASE_CFG             1332     //set SDI matrix base config
#define NET_DVR_GET_MATRIX_BASE_CFG             1333     //get SDI matrix base config
#define NET_DVR_SWITCH_MATRIX_IO                1334     //switch matrix the relation of input and ouput
#define NET_DVR_GET_MATRIX_IO_RELATION          1335     //get matrix IO relation 

#define    NET_DVR_V6PSUBSYSTEMARAM_GET         1501        //get V6 subsystem config
#define    NET_DVR_V6PSUBSYSTEMARAM_SET         1502        //set V6 subsystem config
#define    NET_DVR_GET_ALLWINCFG                 1503        //get screen window information
#define    NET_DVR_BIGSCREENASSOCIATECFG_GET     1511 //get big screen associate information
#define    NET_DVR_BIGSCREENASSOCIATECFG_SET     1512 //et big screen associate information

#define    NET_DVR_GETSCREENINFO                 1601        //Get big screen information
#define    NET_DVR_SETSCREENINFO                 1602        //Set big screen information
#define    NET_DVR_GET_SCREEN_WINCFG             1603        //Get single window parameter 
#define    NET_DVR_LAYOUTLIST_GET                  1605        //Get layout list
#define    NET_DVR_SET_LAYOUTCFG                 1606        //Set layout
#define    NET_DVR_LAYOUTCTRL                     1607        //Layout control,1-open,2-close
#define    NET_DVR_INPUTLIST_GET                 1608        //Get signal source list
#define    NET_DVR_SET_INPUTSTREAMCFG             1609        //Set signal source
#define    NET_DVR_OUTPUT_SET                     1610        //Set output parameter
#define    NET_DVR_OUTPUT_GET                     1611        //Get output parameter
//2011-11-2
#define    NET_DVR_SET_OSDCFG                     1612        //Set OSD parameter
#define    NET_DVR_GET_OSDCFG                     1613        //Get OSD parameter
#define    NET_DVR_BIGSCREEN_GETSERIAL             1614        //Get serial information
#define    NET_DVR_GET_PLANLIST                1615        //get plan list
#define    NET_DVR_SET_PLAN                    1616        //set plan
#define    NET_DVR_CTRL_PLAN                    1617        //control plan
#define    NET_DVR_GET_DEVICE_RUN_STATUS        1618        //get the running status of the device
#define NET_DVR_GET_EXTERNAL_MATRIX_CFG        1619        //get matrix config
#define    NET_DVR_SET_EXTERNAL_MATRIX_CFG        1620        //set matrix config
#define    NET_DVR_GET_OUTPUT_SCREEN_RELATION    1621        //get the relation of screen and output channel
#define    NET_DVR_SET_OUTPUT_SCREEN_RELATION    1622        //set the relation of screen and output channel
#define NET_DVR_GET_VCS_USER_CFG            1623        //get user config
#define    NET_DVR_SET_VCS_USER_CFG            1624        //set user config
#define    NET_DVR_CONTROL_SCREEN                1625        //control screen
#define    NET_DVR_GET_EXTERNAL_MATRIX_CFG_V50        1626    //get matrix config
#define    NET_DVR_SET_EXTERNAL_MATRIX_CFG_V50        1627    //set matrix config
/********************************dvcs begin****************************/
/*1650~1700*/
#define NET_DVR_GET_DEV_BASEINFO             1650        // get single sub device base information
#define NET_DVR_SET_DEV_BASEINFO             1651        // set single sub device base information
#define NET_DVR_GET_DEV_NETINFO                 1652        // get single sub device net information
#define NET_DVR_SET_DEV_NETINFO                 1653        // set single sub device net information
#define NET_DVR_GET_SIGNAL_SOURCE_INFO         1654        // get signal source information
#define NET_DVR_SET_SIGNAL_SOURCE_INFO         1655        // set signal source information
#define NET_DVR_ADJUST_PIC_V40                 1656        // adjust picture
#define NET_DVR_RESTORE_V40                     1657        // restore default
#define    NET_DVR_SET_NET_SIGNAL                 1658        // set net signal
#define NET_DVR_REBOOT_V40                     1659        // reboot 
#define NET_DVR_CONTROL_PICTURE_V41             1660        // control picture 
#define NET_DVR_GET_AUTO_REBOOT_CFG          1710       // get auto reboot config
#define NET_DVR_SET_AUTO_REBOOT_CFG          1711       // set auto reboot config


#define     NET_DVR_GET_TRUNK_USE_STATE     1713    //Get trunk use state
#define     NET_DVR_SET_PTZ_CTRL_INFO         1714    //Set PTZ control information
#define     NET_DVR_GET_PTZ_CTRL_INFO         1715    //Get PTZ control information
#define     NET_DVR_GET_PTZ_STATUS             1716    //Get PTZ status
#define        NET_DVR_GET_DISP_ROUTE_LIST        1717    //Get disp route list

#define NET_DVR_GET_DEC_RESOURCE_LIST            1720//get available decode resource list
#define NET_DVR_SET_DEC_RESOURCE_LIST            1721//pre alloc decode resource
#define NET_DVR_GET_DEC_YUV                        1722//get decode channel relate YUV
#define NET_DVR_SET_DEC_YUV                        1723//set  decode channel relate YUV
#define NET_DVR_GET_DEC_RESOUCE                    1724//apply decode resource
#define NET_DVR_FREE_DEC_RESOURCE                1725//release decode resource

#define NET_DVR_SET_VIDEOWALLDISPLAYMODE        1730    //set video wall display mode
#define NET_DVR_GET_VIDEOWALLDISPLAYMODE        1731    //get video wall display mode
#define NET_DVR_GET_VIDEOWALLDISPLAYNO          1732    //get No. of video wall display channels
#define    NET_DVR_SET_VIDEOWALLDISPLAYPOSITION    1733    //set the position of each display channel
#define    NET_DVR_GET_VIDEOWALLDISPLAYPOSITION    1734    //get the position of each display channel
#define NET_DVR_GET_VIDEOWALLWINDOWPOSITION     1735    //get the position of each window on the video wall
#define NET_DVR_SET_VIDEOWALLWINDOWPOSITION     1736    //set the position of each window on the video wall
#define    NET_DVR_VIDEOWALLWINDOW_CLOSEALL        1737    //close all windows on the video wall
#define    NET_DVR_SET_VIRTUALLED                    1738    //set virtual led config
#define    NET_DVR_GET_VIRTUALLED                    1739    //get virtual led config
#define NET_DVR_GET_IMAGE_CUT_MODE              1740    //get the mode of image cut
#define NET_DVR_SET_IMAGE_CUT_MODE              1741    //set the mode of image cut
#define NET_DVR_GET_USING_SERIALPORT            1742    //get current using serial port
#define NET_DVR_SET_USING_SERIALPORT            1743    //set current using serial port
#define NET_DVR_SCENE_CONTROL                   1744    //scene control
#define NET_DVR_GET_CURRENT_SCENE               1745    //get current scene
#define NET_DVR_GET_VW_SCENE_PARAM              1746    //get video wall scene parameter
#define NET_DVR_SET_VW_SCENE_PARAM              1747    //set video wall scene parameter
#define NET_DVR_DISPLAY_CHANNO_CONTROL          1748    //display channel No. display control
#define NET_DVR_GET_WIN_DEC_INFO                1749    //get window decode information
#define NET_DVR_RESET_VIDEOWALLDISPLAYPOSITION  1750  //Cancel the TV wall output interface binding
#define NET_DVR_SET_VW_AUDIO_CFG                1752    //set audio configure 
#define    NET_DVR_GET_VW_AUDIO_CFG                1753    //get audio configure 
#define NET_DVR_GET_GBT28181_DECCHANINFO_CFG    1754    //get decode channel information in the device using GBT28181 protocol
#define NET_DVR_SET_GBT28181_DECCHANINFO_CFG    1755    //set decode channel information in the device using GBT28181 protocol
#define    NET_DVR_SET_MAINBOARD_SERIAL            1756    //set main board serial parameter
#define    NET_DVR_GET_MAINBOARD_SERIAL            1757    //get main board serial parameter
#define NET_DVR_GET_SUBBOARD_INFO               1758    //get sub board information
#define NET_DVR_GET_SUBBOARD_EXCEPTION          1759    //get exception sub board information

#define NET_DVR_GET_CAMERACHAN_SERIALCFG        1760   //get Camera related serial port configuration
#define NET_DVR_SET_CAMERACHAN_SERIALCFG        1761   //set Camera related serial port configuration
#define NET_DVR_GET_MATRIX_STATUS                1762   //get matrix status
#define    NET_SET_MULTIFUNCTION_SERIALCFG         1763   //set multi function serial port configuration
#define    NET_GET_MULTIFUNCTION_SERIALCFG            1764   //get multi function serial port configuration
#define NET_DVR_PTZ_3D_SPEED                    1765   //3D PTZ control with speed

#define NET_DVR_GET_SIGNAL_JOINT                1766   //get signal joint configuration
#define NET_DVR_SET_SIGNAL_JOINT                1767   //set signal joint configuration
#define NET_DVR_SIGNAL_CUT                        1768   //cut signal
#define NET_DVR_DYNAMIC_DECODE_BATCH            1769   //start batch dynamic decode
#define NET_DVR_DECSWITCH_SET_BATCH                1770   //batch decode switch set
#define NET_DVR_DECSWITCH_GET_BATCH                1771   //batch decode switch get
#define NET_DVR_GET_ALL_SIGNAL_JOINT            1772   //get all joint signal configuration
#define    NET_DVR_GET_PLAYING_PLAN                1773   //get current playing plan No.
#define NET_DVR_WALL_RELATION_GET                1774   //get device wall and real wall relation configuration
#define NET_DVR_WALL_RELATION_SET                1775   //set device wall and real wall relation configuration
#define    NET_DVR_SET_INPUTSTREAMCFG_V40            1776   //set input signal configuration
#define NET_DVR_PTZCFG_INPUTSTREAM_GET            1777   //get input signal PTZ configuration
#define NET_DVR_PTZCFG_INPUTSTREAM_SET            1778   //set input signal PTZ configuration
#define NET_DVR_SIGNAL_CUTPARAM_GET                1779   //get input signal cut parameter

#define NET_DVR_GET_SUBSYSTEM_NETCFG            1780    // Get Subsystem netcard parameter
#define NET_DVR_SET_SUBSYSTEM_NETCFG              1781    // Set Subsystem netcard parameter
#define    NET_DVR_DEL_SIGNAL_JOINT                1782    //delete joint signal

#define NET_DVR_GET_PICTURE_INFO                1783     //get picture information
#define NET_DVR_SET_PICTURE_INFO                1784     //set picture information
#define NET_DVR_GET_VIDEO_INFO                    1785     //get video information
#define NET_DVR_SET_VIDEO_INFO                    1786     //set video information
#define NET_DVR_SET_PLAYLIST                    1787     //set play list
#define NET_DVR_GET_PLAYLIST                    1788     //get play list
#define NET_DVR_GET_ALL_PLAYLIST                1789     //get all play list
#define NET_DVR_PLAYITEM_CONTROL                1790     //play item control
#define NET_DVR_SET_PLAYPLAN_TEMPLATE            1791     //set play plan
#define NET_DVR_GET_PLAYPLAN_TEMPLATE            1792     //get play plan
#define NET_DVR_GET_ALL_PLAYPLAN_TEMPLATE        1793     //get all play plan
#define NET_DVR_SET_WINDOW_PLAYPLAN                1794     //set window's play plan
#define NET_DVR_GET_WINDOW_PLAYPLAN                1795     //get window's play plan
#define NET_DVR_TOPLAY_ITEM                        1796     //assign play item
#define NET_DVR_DEVICE_PLAY_CONTROL                1797     //paly control
#define NET_DVR_GET_PLAY_INFO                    1798     //get current play information
#define NET_DVR_GET_ALL_PICTURE_INFO            1799     //get all pictures's information
#define NET_DVR_GET_ALL_VIDEO_INFO                1800     //get all videos's information
#define NET_DVR_DELETE_VIDEO_FILE                1801     //delete video file

#define NET_DVR_GET_ALARMHOSTSUBSYSTEM_CFG     2001        //    Get alarm subsystem
#define NET_DVR_SET_ALARMHOSTSUBSYSTEM_CFG     2002        //    Set alarm subsystem
#define NET_DVR_GETEXTENDALARMININFO         2003        //    Get alarm info
#define NET_DVR_MODIFYALARMINNO              2004        //    mod alarm info

#define NET_DVR_GET_ALARMHOST_WIRELESS_NETWORK_CFG         2005        // Get GPRS info
#define    NET_DVR_SET_ALARMHOST_WIRELESS_NETWORK_CFG         2006        // Set GPRS info
#define    NET_DVR_GET_ALARMHOST_NETCFG         2007        // Get Net info
#define    NET_DVR_SET_ALARMHOST_NETCFG         2008        // Set Net info

#define     NET_DVR_GET_LED_SCREEN_CFG        2009    // Get LED Parameter
#define     NET_DVR_SET_LED_SCREEN_CFG        2010    // Set LED Parameter
#define     NET_DVR_GET_LED_CONTENT_CFG        2011    // Get LED Content
#define        NET_DVR_SET_LED_CONTENT_CFG        2012    // Set LED Content
#define     NET_DVR_TURNON_LED                2013    // turn on LED
#define     NET_DVR_TURNOFF_LED                2014    // turn off LED
#define     NET_DVR_GET_LED_TIMER_SWITCH    2015    // Get LED timer switch
#define     NET_DVR_SET_LED_TIMER_SWITCH    2016    // Set LED timer switch
#define     NET_DVR_SET_LED_BRIGHTNESS        2017    // set LED brightness
#define     NET_DVR_GET_LED_TIMER_BRIGHTNESS 2018    // set timer brightness
#define     NET_DVR_SET_LED_TIMER_BRIGHTNESS 2019    // get timer brightness
#define     NET_DVR_LED_CHECKTIME            2020    // LED checktime

//2009-2020,2023 use for DS-19C08-JN V2.0
#define     NET_DVR_GET_ALARMHOST_AUDIO_ASSOCIATE_ALARM        2021 //Get audio associate alarm
#define     NET_DVR_SET_ALARMHOST_AUDIO_ASSOCIATE_ALARM        2022 //set audio associate alarm

#define        NET_DVR_GET_LED_STATUS            2023        //get LED status

#define NET_DVR_CLOSE_SUBSYSTEM_FAULT_ALARM        2027       // Close subsystem fault alarm
#define NET_DVR_SET_SUBSYSTEM_BYPASS            2028       // subsystem bypass
#define NET_DVR_CANCEL_SUBSYSTEM_BYPASS            2029       // subsystem bypass resume

#define  NET_DVR_GET_ALARMHOST_SUBSYSTEM_CFG_EX                2030            //Get subsystem external config parameter
#define     NET_DVR_SET_ALARMHOST_SUBSYSTEM_CFG_EX                2031            //Set subsystem external config parameter
#define  NET_DVR_GET_ALARMHOST_PRINTER_CFG                    2032            //Get Printer config parameter
#define     NET_DVR_SET_ALARMHOST_PRINTER_CFG                    2033            //Set Printer config parameter
#define     NET_DVR_GET_ALARMHOST_ZONE_LIST_IN_SUBSYSTEM        2034            //Get all zones in the subsystem
#define     NET_DVR_GET_ALARMHOST_TRIGGER_LIST                    2035            //Get all the triggers
#define     NET_DVR_ARM_ALARMHOST_SUBSYSTEM                    2036            //subsystem arm and disarm
#define     NET_DVR_GET_ALARMHOST_EVENT_TRIG_ALARMOUT_CFG        2037            //Get event cause alarm out config parameter
#define  NET_DVR_SET_ALARMHOST_EVENT_TRIG_ALARMOUT_CFG        2038            //Set event cause alarm out config parameter
#define     NET_DVR_GET_ALARMHOST_FAULT_CFG                    2039            //Get fault process config parameter
#define  NET_DVR_SET_ALARMHOST_FAULT_CFG                    2040            //Set fault process config parameter
#define  NET_DVR_SEARCH_ARMHOST_EXTERNAL_MODULE             2041            //Auto search
#define     NET_DVR_REGISTER_ALARMHOST_EXTERNAL_MODULE            2042            //Auto register
#define  NET_DVR_CLOSE_ALARMHOST_OVERALL_FAULT_ALARM         2043            //Close Overall fault alarm

#define NET_DVR_GET_SAFETYCABIN_WORK_MODE            2044 //get safety cabin work mode parameter
#define NET_DVR_SET_SAFETYCABIN_WORK_MODE            2045 //set safety cabin work mode parameter
#define NET_DVR_GET_SAFETYCABIN_PERSON_SIGNAL_CFG   2046 //get safety cabin person signal parameter
#define NET_DVR_SET_SAFETYCABIN_PERSON_SIGNAL_CFG   2047 //set safety cabin person signal parameter

#define  NET_DVR_GET_ALARMHOST_MODULE_CFG                    2048            // get module config
//#define  NET_DVR_SET_ALARMHOST_MODULE_CFG                    2049            // set module config

/********************************DS_19DXX v20 begin****************************/
#define     NET_DVR_GET_ALARMHOST_EXTERNAL_DEVICE_STATE        2050        //get external device state
#define  NET_DVR_SET_ALARMHOST_EXTERNAL_DEVICE_LIMIT_VALUE  2051        //set limit value
#define  NET_DVR_GET_ALARMHOST_EXTERNAL_DEVICE_LIMIT_VALUE  2052        //get limit value
#define  NET_DVR_GET_ALARMHOST_SENSOR_JOINT_CFG                2053        // get sensor joint config
#define  NET_DVR_SET_ALARMHOST_SENSOR_JOINT_CFG                2054        // set sensor joint config
#define     NET_DVR_SET_ALARMHOST_RS485_SLOT_CFG                2055        // set slot config
#define  NET_DVR_GET_ALARMHOST_RS485_SLOT_CFG                2056        // get slot config
/********************************DS_19DXX v20  end****************************/

/********************************DS_19DXX 104 protocol begin****************************/
#define NET_DVR_GET_ALL_VARIABLE_INFO      2057   // get all variable info
#define NET_DVR_GET_ALARM_POINT_CFG       2058   // get point config
#define NET_DVR_SET_ALARM_POINT_CFG       2059   // set point config
#define NET_DVR_GET_HISTORY_VALUE          2060   // get history value
#define NET_DVR_GET_ALARMHOST_ALARM_MODE  2061   // get alarm mode
#define NET_DVR_SET_ALARMHOST_ALARM_MODE  2062   // set alarm mode
/********************************DS_19DXX 104 protocol end****************************/

/*************************************DS-19D00-0402BN(0601BN) begin*************************************/
#define NET_DVR_GET_ALARMHOST_SENSOR_VALUE    2063   // get sensor value
/*************************************DS-19D00-0402BN(0601BN) end*************************************/

/*************************************alarm host 2.0 begin*************************************/
#define NET_DVR_GET_ALARMHOST_REPORT_CENTER_V40    2064   // get data report mode v30
#define NET_DVR_SET_ALARMHOST_REPORT_CENTER_V40    2065   // set data report mode v30
#define NET_DVR_GET_OUTPUT_SCHEDULE_RULECFG        2068   // get output schedule rule
#define NET_DVR_SET_OUTPUT_SCHEDULE_RULECFG     2069   // set output schedule rule
/************************************ alarm host2.0 end**************************************/

/*********************************EHOME begin******************************/
#define NET_DVR_GET_CMS_CFG                     2070
#define    NET_DVR_SET_CMS_CFG                        2071
#define NET_DVR_GET_PASSTHROUGH_CAP  2073
/*********************************EHOME end******************************/
#define NET_DVR_GET_ALARMHOST_MAIN_STATUS_V40    2072 
#define NET_DVR_GET_ALARMHOST_MAIN_STATUS_V51    2083

/*************************************video alarm host v1.3 begin*************************************/
#define NET_DVR_GET_ALARM_CAPTRUE_CFG                 2074
#define    NET_DVR_SET_ALARM_CAPTRUE_CFG                2075
#define NET_DVR_GET_ONE_OUTPUT_SCH_RULECFG_V40        2078   // get one output schedule rule V40
#define NET_DVR_SET_ONE_OUTPUT_SCH_RULECFG_V40        2079   // set one output schedule rule V40
#define NET_DVR_GET_OUTPUT_SCHEDULE_RULECFG_V40        2080   // get output schedule rule V40
#define NET_DVR_SET_OUTPUT_SCHEDULE_RULECFG_V40     2081   // Set output schedule rule V40
#define  NET_DVR_ALARMHOST_CLOSE_SUBSYSTEM  2082  //close subsystem
/*************************************video alarm host v1.3 end**************************************/

#define NET_DVR_GET_WEEK_PLAN_CFG               2100    //get door status week plan config 
#define NET_DVR_SET_WEEK_PLAN_CFG               2101    //set door status week plan config 
#define NET_DVR_GET_DOOR_STATUS_HOLIDAY_PLAN    2102    //get door status holiday week plan config 
#define NET_DVR_SET_DOOR_STATUS_HOLIDAY_PLAN    2103    //set door status holiday week plan config
#define NET_DVR_GET_DOOR_STATUS_HOLIDAY_GROUP   2104    //get door holiday group parameter
#define NET_DVR_SET_DOOR_STATUS_HOLIDAY_GROUP   2105    //set door holiday group parameter
#define NET_DVR_GET_DOOR_STATUS_PLAN_TEMPLATE   2106    //get door status plan template parameter
#define NET_DVR_SET_DOOR_STATUS_PLAN_TEMPLATE   2107    //set door status plan template parameter
#define NET_DVR_GET_DOOR_CFG                    2108    //get door parameter
#define NET_DVR_SET_DOOR_CFG                    2109    //set door parameter
#define NET_DVR_GET_DOOR_STATUS_PLAN            2110    //get door status plan parameter
#define NET_DVR_SET_DOOR_STATUS_PLAN            2111    //set door status plan parameter
#define NET_DVR_GET_GROUP_CFG                   2112    //get group parameter
#define NET_DVR_SET_GROUP_CFG                   2113    //set group parameter
#define NET_DVR_GET_MULTI_CARD_CFG              2114    //get multi card parameter
#define NET_DVR_SET_MULTI_CARD_CFG              2115    //set multi card parameter
#define NET_DVR_GET_CARD_CFG                    2116    //get card parameter
#define NET_DVR_SET_CARD_CFG                    2117    //set card parameter
#define NET_DVR_CLEAR_ACS_PARAM                    2118    //clear access card parameter
#define NET_DVR_GET_SNEAK_CFG                    2119    //get sneak parameter
#define NET_DVR_SET_SNEAK_CFG                   2120    //set sneak parameter
#define NET_DVR_GET_MULTI_DOOR_INTERLOCK_CFG    2121    //get multi door interlock parameter
#define NET_DVR_SET_MULTI_DOOR_INTERLOCK_CFG    2122    //set multi door interlock parameter
#define NET_DVR_GET_ACS_WORK_STATUS                2123    //get device work status 
#define NET_DVR_GET_VERIFY_WEEK_PLAN            2124    //get reader card verfy week plan 
#define NET_DVR_SET_VERIFY_WEEK_PLAN            2125    //set reader card verfy week plan 
#define NET_DVR_GET_CARD_RIGHT_WEEK_PLAN        2126    //get card right week plan 
#define NET_DVR_SET_CARD_RIGHT_WEEK_PLAN        2127    //set card right week plan 
#define NET_DVR_GET_VERIFY_HOLIDAY_PLAN         2128    //get card reader verify holiday plan 
#define NET_DVR_SET_VERIFY_HOLIDAY_PLAN         2129    //set card reader verify holiday plan 
#define NET_DVR_GET_CARD_RIGHT_HOLIDAY_PLAN     2130    //get card right holiday plan 
#define NET_DVR_SET_CARD_RIGHT_HOLIDAY_PLAN     2131    //set card right holiday plan
#define NET_DVR_GET_VERIFY_HOLIDAY_GROUP        2132    //get card reader verify holiday group 
#define NET_DVR_SET_VERIFY_HOLIDAY_GROUP        2133    //set card reader verify holiday group 
#define NET_DVR_GET_CARD_RIGHT_HOLIDAY_GROUP    2134    //get card right holiday group 
#define NET_DVR_SET_CARD_RIGHT_HOLIDAY_GROUP    2135    //set card right holiday group 
#define NET_DVR_GET_VERIFY_PLAN_TEMPLATE        2136    //get card reader verify plan template 
#define NET_DVR_SET_VERIFY_PLAN_TEMPLATE        2137    //set card reader verify plan template 
#define NET_DVR_GET_CARD_RIGHT_PLAN_TEMPLATE    2138    //get card right plan template 
#define NET_DVR_SET_CARD_RIGHT_PLAN_TEMPLATE    2139    //set card right plan template 
#define NET_DVR_GET_CARD_READER_CFG                2140    //get card reader parameter
#define NET_DVR_SET_CARD_READER_CFG             2141    //set card reader parameter
#define NET_DVR_GET_CARD_READER_PLAN            2142    //get card reader verify plan parameter
#define NET_DVR_SET_CARD_READER_PLAN            2143    //set card reader verify plan parameter
#define NET_DVR_GET_CASE_SENSOR_CFG                2144    //get case sensor parameter
#define NET_DVR_SET_CASE_SENSOR_CFG             2145    //set case sensor parameter
#define NET_DVR_GET_CARD_READER_ANTI_SNEAK_CFG  2146    //get card readfer anti sneak parameter
#define NET_DVR_SET_CARD_READER_ANTI_SNEAK_CFG  2147    //set card readfer anti sneak parameter
#define NET_DVR_GET_PHONE_DOOR_RIGHT_CFG        2148    //get phone door right parameter
#define NET_DVR_SET_PHONE_DOOR_RIGHT_CFG        2149    //set phone door right parameter
#define NET_DVR_GET_FINGERPRINT_CFG             2150    //get fingerprint parameter
#define NET_DVR_SET_FINGERPRINT_CFG             2151    //set fingerprint parameter
#define NET_DVR_DEL_FINGERPRINT_CFG             2152    //delete fingerprint parameter
#define NET_DVR_GET_EVENT_CARD_LINKAGE_CFG      2153    //get event card linkage parameter
#define NET_DVR_SET_EVENT_CARD_LINKAGE_CFG      2154    //set event card linkage parameter
#define NET_DVR_GET_ANTI_SNEAK_HOST_CFG            2155    //get anti sneak host parameter
#define NET_DVR_SET_ANTI_SNEAK_HOST_CFG         2156    //set anti sneak host parameter
#define NET_DVR_GET_READER_ANTI_SNEAK_HOST_CFG  2157    //get reader anti sneak host parameter
#define NET_DVR_SET_READER_ANTI_SNEAK_HOST_CFG  2158    //set reader anti sneak host parameter
#define NET_DVR_GET_ACS_CFG                     2159    //get acs parameter
#define NET_DVR_SET_ACS_CFG                     2160    //set acs parameter
#define NET_DVR_GET_CARD_PASSWD_CFG                2161    //get card passwd parameter
#define NET_DVR_SET_CARD_PASSWD_CFG             2162    //set card passwd parameter
#define NET_DVR_GET_CARD_USERINFO_CFG           2163    //get card userinfo cfg
#define NET_DVR_SET_CARD_USERINFO_CFG           2164    //set card userinfo cfg


#define NET_DVR_GET_ACS_EXTERNAL_DEV_CFG        2165   //get ACS external device parameter
#define NET_DVR_SET_ACS_EXTERNAL_DEV_CFG        2166   //set ACS external device parameter
#define NET_DVR_GET_PERSONNEL_CHANNEL_CFG        2167   //get personnel channel parameter
#define NET_DVR_SET_PERSONNEL_CHANNEL_CFG        2168   //set personnel channel parameter
#define NET_DVR_SET_PLATFORM_VERIFY_CFG         2169    //The result issued by platform authentication
#define NET_DVR_GET_PERSON_STATISTICS_CFG        2170   //Get the number of statistical parameters 
#define NET_DVR_SET_PERSON_STATISTICS_CFG        2171   //Set the number of statistical parameters 
#define NET_DVR_GET_ACS_SCREEN_DISPLAY_CFG        2172   //The screen for the string parameters 
#define NET_DVR_SET_ACS_SCREEN_DISPLAY_CFG        2173   //String to use screen display parameters 
#define NET_DVR_GET_GATE_TIME_CFG               2174    //Access channel gate time parameter 
#define NET_DVR_SET_GATE_TIME_CFG               2175    //Setting up the staff channel gate time parameters 
#define NET_DVR_GET_LOCAL_CONTROLLER_STATUS     2176    //Access to on-site controller state 
#define NET_DVR_GET_ONLINE_LOCAL_CONTROLLER     2177    //Search online on the controller 
#define NET_DVR_GET_CARD_CFG_V50                2178    //Parameters to acquire new CARDS (V50)
#define NET_DVR_SET_CARD_CFG_V50                2179    //Setting up the new parameters (V50)
#define NET_DVR_GET_ACS_WORK_STATUS_V50            2180    //Access door host working condition (V50)
#define NET_DVR_GET_EVENT_CARD_LINKAGE_CFG_V50  2181    //Get event card number linkage configuration parameters (V50)
#define NET_DVR_SET_EVENT_CARD_LINKAGE_CFG_V50  2182    //Set up the event card number linkage configuration parameters (V50)
#define NET_DVR_GET_FINGERPRINT_CFG_V50         2183    //get fingerprint parameter (V50)
#define NET_DVR_SET_FINGERPRINT_CFG_V50         2184    //set fingerprint parameter (V50)

#define NET_DVR_GET_SAFETYCABIN_STATE            2197    //get safetycabin state
#define NET_DVR_GET_RS485_CASCADE_CFG            2198    //get Rs485 cascade cfg
#define NET_DVR_SET_RS485_CASCADE_CFG            2199    //set Rs485 cascade cfg

/*************************************video alarm host 2.0 begin*************************************/
#define NET_DVR_GET_REMOTECONTROLLER_PERMISION_CFG        2200    //get remotecontroller Permission config
#define NET_DVR_SET_REMOTECONTROLLER_PERMISION_CFG        2201    //set remotecontroller Permission config
#define NET_DVR_GET_KEYBOARD_CFG                        2202    //get keyborad config
#define NET_DVR_SET_KEYBOARD_CFG                        2203    //set keyborad config
#define    NET_DVR_GET_ALARMHOST_WIRELESS_BUSINNESS_INFO    2204    //wireless service query
#define    NET_DVR_GET_ALL_REMOTECONTROLLER_LIST            2205    //get all remote controller
#define    NET_DVR_GET_PREVIEW_DELAY_CFG                    2206    //get delay preview config
#define    NET_DVR_SET_PREVIEW_DELAY_CFG                    2207    //set delay preview config
#define NET_DVR_GET_ZONE_CHANNEL_LINKAGE_CFG            2208    //get alarm zone linkage channel config
#define NET_DVR_SET_ZONE_CHANNEL_LINKAGE_CFG            2209    //set alarm zone linkage channel config 
#define NET_DVR_GET_CENTER_SERVER_CFG                    2210    //get alarm center server config
#define NET_DVR_SET_CENTER_SERVER_CFG                    2211    //set alarm center server config
/*************************************video alarm host 2.0 end*************************************/

/********************************energence alarm product V1.0.0 begin********************************/
#define NET_DVR_GET_EMERGENCE_ALARM_PRODUCT_CAP            2212    //get emergence alarm product ability
#define NET_DVR_GET_CALL_WAITTING_CFG_CAP                2213    //get call waiting configure ability
#define NET_DVR_GET_CALL_WAITTING_CFG                    2214    //get call waiting configure
#define NET_DVR_SET_CALL_WAITTING_CFG                    2215    //set call waiting configure
#define NET_DVR_GET_ALARM_LAMP_CFG_CAP                    2216    //get alarm lamp configure ability
#define NET_DVR_GET_ALARM_LAMP_CFG                        2217    //get alarm lamp configure
#define NET_DVR_SET_ALARM_LAMP_CFG                        2218    //set alarm lamp configure
#define NET_DVR_GET_VOICE_PROMPTION_CFG_CAP                2219    //get voice promption configure ability
#define NET_DVR_GET_VOICE_PROMPTION_CFG                    2220    //get voice promption configure
#define NET_DVR_SET_VOICE_PROMPTION_CFG                    2221    //set voice promption configure
#define NET_DVR_GET_EMERGENCE_ALARM_RESPONSE_CAP        2222    //get emergence alarm response ability
#define NET_DVR_EMERGENCE_ALARM_RESPONSE_CTRL            2223    //emergence alarm response ctrl
/********************************energence alarm product V1.0.0 end**********************************/

//net alarm host V2.2
#define NET_DVR_GET_ALARMHOST_NETCFG_V50                2224    //Get Net infoV50
#define NET_DVR_SET_ALARMHOST_NETCFG_V50                2225    //Set Net info V50
#define    NET_DVR_REGISTER_ALARM_RS485                    2226    //Re-register RS485

#define NET_DVR_GET_ALARMIN_PARAM_LIST                    2227    //Get sector parameter list 

#define NET_DVR_GET_ALARMHOST_OTHER_STATUS_V50            2228
#define NET_DVR_GET_ALARMHOST_OTHER_STATUS_V51            2236
#define NET_DVR_GET_ALARMIN_ASSOCIATED_CHAN_LIST        2229

#define NET_DVR_GET_ALARMIN_TRIGGER                     2230    //get alarm in trigger
#define NET_DVR_SET_ALARMIN_TRIGGER                     2231    //set alarm in trigger
#define NET_DVR_GET_EMERGENCY_CALL_HELP_TRIGGER         2232    //get emergency call help trigger
#define NET_DVR_SET_EMERGENCY_CALL_HELP_TRIGGER         2233    //set emergency call help trigger
#define NET_DVR_GET_CONSULT_TRIGGER                     2234    //get consult trigger
#define NET_DVR_SET_CONSULT_TRIGGER                     2235    //set consult trigger
#define NET_DVR_GET_ALARMIN_PARAM_LIST_V50              2237    //Get sector parameter list V50

#define NET_DVR_GET_CARD_RIGHT_WEEK_PLAN_V50    2304  //Access card right V50 weeks plan parameters
#define NET_DVR_SET_CARD_RIGHT_WEEK_PLAN_V50    2305  //Set card right V50 weeks plan parameters 

#define NET_DVR_GET_CARD_RIGHT_HOLIDAY_PLAN_V50    2310  //Access card right parameters V50 holiday plan  
#define NET_DVR_SET_CARD_RIGHT_HOLIDAY_PLAN_V50    2311  //Set card right parameters V50 holiday plan

#define NET_DVR_GET_CARD_RIGHT_HOLIDAY_GROUP_V50      2316 //Access card right parameters V50 holiday group
#define NET_DVR_SET_CARD_RIGHT_HOLIDAY_GROUP_V50      2317 //Set card right parameters V50 holiday group

#define NET_DVR_GET_CARD_RIGHT_PLAN_TEMPLATE_V50     2322 //Access card right parameters V50 plan template
#define NET_DVR_SET_CARD_RIGHT_PLAN_TEMPLATE_V50     2323//Set card right parameters V50 plan template

/******************economical fingerprint access control product V1.0**************************/
#define NET_DVR_GET_SCHEDULE_INFO                       2500    //get schedule info
#define NET_DVR_GET_ATTENDANCE_SUMMARY_INFO             2501    //get attendance summary info
#define NET_DVR_GET_ATTENDANCE_RECORD_INFO              2502    //get attendance record info
#define NET_DVR_GET_ABNORMAL_INFO                       2503    //get abnormal
/******************economical fingerprint access control product V1.0**************************/

/*************************************vide acs integrated machine 1.0 begin**************************************/
#define NET_DVR_CAPTURE_FINGERPRINT_INFO                2504    //capture fingerprint info
/*************************************vide acs integrated machine 1.0 end**************************************/

/*************************************face acs integrated machine 1.0 begin**************************************/
#define NET_DVR_GET_CARD_READER_CFG_V50                2505    //get card reader param(V50)
#define NET_DVR_SET_CARD_READER_CFG_V50             2506    //set card reader param(V50)
#define NET_DVR_GET_FACE_PARAM_CFG                  2507    //get face param
#define NET_DVR_SET_FACE_PARAM_CFG                  2508    //set face param
#define NET_DVR_DEL_FACE_PARAM_CFG                  2509    //del face param
#define    NET_DVR_CAPTURE_FACE_INFO                    2510    //capture face info
/*************************************face acs integrated machine 1.0 end**************************************/
#define NET_DVR_GET_REGISTER_INFO                   2511    //get register info

#define NET_DVR_GET_SMSRELATIVEPARA_V50             2512    //get sms relative param v50 
#define NET_DVR_SET_SMSRELATIVEPARA_V50             2513    //set sms relative param v50
#define NET_DVR_GET_ACS_EVENT                       2514    //get device acs enent
#define NET_DVR_GET_MULTI_CARD_CFG_V50              2515    //get multi card cfg v50
#define NET_DVR_SET_MULTI_CARD_CFG_V50              2516    //set multi card cfg v50
#define NET_DVR_DEL_FINGERPRINT_CFG_V50             2517    //delete finger print cfg v50 
#define NET_DVR_GET_EVENT_CARD_LINKAGE_CFG_V51      2518    //Get event card number linkage configuration parameters (V51)
#define NET_DVR_SET_EVENT_CARD_LINKAGE_CFG_V51      2519    //Set up the event card number linkage configuration parameters (V51)

/*************************************Embedded intelligent terminal 1.0 begin**************************************/
#define NET_DVR_BULK_UPLOAD_BLACK_LIST_PICTURE          2520       //Bulk upload blacklist image 
#define NET_DVR_BULK_UPLOAD_ID_BLACK_LIST        2521        //Bulk upload blacklist
#define NET_DVR_GET_FAILED_FACE_INFO             2522        //when upgrade device,get the failed face info
#define NET_DVR_GET_FACE_AND_TEMPLATE          2523       //get face and template data
#define NET_DVR_SET_FACE_AND_TEMPLATE          2524       //set face and template data
/*************************************Embedded intelligent terminal 1.0 end**************************************/

#define NET_DVR_SET_EXAM_INFO                       2530    //set exam info
#define NET_DVR_SET_EXAMINEE_INFO                   2531    //set examinee info
#define NET_DVR_SEARCH_EXAM_COMPARE_RESULT          2532    //search exam compare result
#define NET_DVR_BULK_CHECK_FACE_PICTURE             2533    //check pictures
#define NET_DVR_JSON_CONFIG                         2550    //JSON 
#define NET_DVR_FACE_DATA_RECORD                    2551    //face data record
#define NET_DVR_FACE_DATA_SEARCH                    2552    //face data search
#define NET_DVR_FACE_DATA_MODIFY                    2553    //face data modify

#define NET_DVR_GET_ALL_ALARM_RS485CFG            2705
#define NET_DVR_GET_ALL_ALARMHOST_RS485_SLOT_CFG        2706
#define NET_DVR_GET_DEVICE_SELF_CHECK_STATE        2707
#define NET_DVR_GET_ALL_ALARM_POINT_CFG            2708
#define NET_DVR_GET_ALL_ALARM_SENSOR_CFG        2709
#define NET_DVR_GET_ALL_ALARM_SENSOR_JOINT        2710
#define NET_DVR_GET_AIR_CONDITION_PARAM            2711
#define NET_DVR_GET_OUT_SCALE_CFG                2712        
#define NET_DVR_SET_OUT_SCALE_CFG                2713        
#define NET_DVR_GET_ALARM_CHAN_ABLITITY            2714

#define NET_DVR_GET_ALARMCENTER_NETCFG            2715        
#define NET_DVR_SET_ALARMCENTER_NETCFG            2716


#define NET_ITC_GET_TRIGGERCFG               3003       //Get trigger configuration
#define NET_ITC_SET_TRIGGERCFG               3004        //Set trigger configuration
#define NET_ITC_GET_IOOUT_PARAM_CFG             3005        //Get io out configuration(3.1)
#define NET_ITC_SET_IOOUT_PARAM_CFG             3006        //Set io out configuration(3.1)
#define NET_DVR_GET_CAMERA_SETUPCFG             3007        //Get the camera Erection Parameters
#define NET_DVR_SET_CAMERA_SETUPCFG             3008        //Set the camera Erection Parameters
#define NET_ITC_GET_TRIGGER_DEFAULTCFG       3013        //Get trigger default configuration
#define NET_DVR_GET_STATUS_DETECTCFG         3015        //Get status detect configuration
#define NET_DVR_SET_STATUS_DETECTCFG         3016        //Set statue detect configuration
#define NET_ITC_GET_VIDEO_TRIGGERCFG         3017        //Get video epolice configuration
#define NET_ITC_SET_VIDEO_TRIGGERCFG         3018        //Set video epolice configuration
#define NET_DVR_GET_TPS_ALARMCFG             3019        //Get traffic statistics alarm parameters
#define NET_DVR_SET_TPS_ALARMCFG             3020        //Set traffic statistics alarm parameters
#define NET_DVR_GET_REDAREACFG               3100        //Get red area configuration
#define NET_DVR_SET_REDAREACFG               3101        //Set red area configuration
#define    NET_DVR_GET_TEST_SPOT                 3102       //Get SPOT port the test total number of steps and the first steps
#define    NET_DVR_SET_TEST_SPOT                 3103       //Set SPOT port the test total number of steps and the first steps
#define NET_DVR_GET_CABINETCFG                 3104       //Get CabinetCfg Param
#define NET_DVR_SET_CABINETCFG                 3105       //Set CabinetCfg Param
#define NET_DVR_VEHICLE_CHECK_START             3106       //black list check data pass back
#define NET_DVR_SET_CAPTUREPIC_CFG             3107        //set capture picture param
#define NET_DVR_GET_CAPTUREPIC_CFG             3108        //get capture picture param
#define NET_DVR_SET_MOBILEPLATE_RECOG_CFG     3109        //set plate recognize parm
#define NET_DVR_GET_MOBILEPLATE_RECOG_CFG     3110        //get plate recognize parm
#define NET_DVR_SET_MOBILE_RADAR_CFG         3111        //set radar configure parm
#define NET_DVR_GET_MOBILE_RADAR_CFG         3112        //get radar configure parm
#define NET_DVR_SET_MOBILE_LOCALPLATECHK_CFG 3113        //set black list compare configure parm
#define NET_DVR_GET_MOBILE_LOCALPLATECHK_CFG 3114        //get black list compare configure parm

#define  NET_ITC_GET_ICRCFG                        3115   //Get ICR Param Cfg
#define  NET_ITC_SET_ICRCFG                        3116   //Set ICR Param Cfg
#define  NET_ITC_GET_RS485_ACCESSINFO            3117   //Get Rs485 Access Info 
#define  NET_ITC_SET_RS485_ACCESSINFO            3118   //Set Rs485 Access Info
#define  NET_ITC_GET_EXCEPTIONCFG                 3119   //Get Exception Info Cfg 
#define  NET_ITC_SET_EXCEPTIONCFG                3120   //Set Exception Info Cfg
#define  NET_ITC_GET_FTPCFG                        3121   //Get ITC  FTP Param Cfg
#define  NET_ITC_SET_FTPCFG                        3122   //Set ITC  FTP Param Cfg

//2013-11-04 PJ01R2013091201
#define  NET_DVR_VEHICLE_CONTROL_LIST_START     3123   //Vehicle Control List Start
#define  NET_DVR_GET_ALL_VEHICLE_CONTROL_LIST   3124   //Get Vehicle Control List
#define  NET_DVR_VEHICLE_DELINFO_CTRL            3125   //Delete Vehicle Info
#define  NET_DVR_GET_ENTRANCE_PARAMCFG            3126   //Get Entrance Param CFG
#define  NET_DVR_SET_ENTRANCE_PARAMCFG            3127   //Set Entrance Param CFG
#define  NET_DVR_BARRIERGATE_CTRL               3128   //Barrier Gate Ctrl
#define  NET_DVR_GATELAMP_CTRL                  3129   //Gate Lamp
#define  NET_DVR_GET_CURTRIGGERMODE             3130   //Get Cur Trigger Mode
#define  NET_DVR_GET_GPSDATACFG                    3131   //Get GPS Param
#define  NET_DVR_SET_GPSDATACFG                    3132   //Set GPS Param
#define  NET_DVR_VEHICLELIST_CTRL_START            3133   //Start Vehicle List Ctrl

//Capture trigger mode support association Alarm time and Upload Center
#define  NET_DVR_GET_GUARDCFG                   3134   //Get 
#define  NET_DVR_SET_GUARDCFG                   3135   //Set

//Snap Picture Info
#define NET_DVR_GET_SNAPINFO_CFG                3136   //Get 
#define NET_DVR_SET_SNAPINFO_CFG                3137   //Set

//Snap Picture Info Expansion
#define  NET_DVR_GET_SNAPINFO_CFG_V40           3138   //Get 
#define  NET_DVR_SET_SNAPINFO_CFG_V40           3139   //Set

#define  NET_DVR_SET_CURTRIGGERMODE                3140   //Set device Current Trigger Mode (Only IPC/D)
#define     NET_DVR_GET_TRAFFIC_DATA                3141   //Get Traffic Data
#define     NET_DVR_GET_TRAFFIC_FLOW                3142   //Get Traffic Flow
#define  NET_DVR_PARKING_VEHICLE_SEND           3143   //Parking Vehicle Send
#define  NET_DVR_PARKING_CARD_SEND              3144   //Send Parking Card Info
#define     NET_DVR_PARKING_CARD_CTRL                3145    //Parking card control interface

#define    NET_DVR_GET_ALARMCTRL_CAPABILITIES        3146   //Get Alarm Ctrl Capabilties
#define    NET_DVR_SET_ALARMCTRL_CFG                3147   //Set Alarm Ctrl 
#define    NET_DVR_GET_ALARMCTRL_CFG                3148   //Get Alarm Ctrl

#define NET_DVR_GET_AUDIO_INPUT              3201        //Get audio in info
#define NET_DVR_SET_AUDIO_INPUT              3202        //Set audio in info
#define NET_DVR_GET_CAMERA_DEHAZE_CFG        3203        //Get fog remove configuration
#define NET_DVR_SET_CAMERA_DEHAZE_CFG        3204        //Set fog remove configuration
#define NET_DVR_REMOTECONTROL_ALARM          3205        //remote control alarm
#define NET_DVR_REMOTECONTROL_DISALARM       3206        //remote control disalarm
#define NET_DVR_REMOTECONTROL_STUDY          3207        //remote control study
#define NET_DVR_WIRELESS_ALARM_STUDY         3208        //wireless alarm study
#define NET_IPC_GET_AUX_ALARMCFG             3209        //get aux alarm configuration
#define NET_IPC_SET_AUX_ALARMCFG             3210        //set aux alarm configuration
#define NET_DVR_GET_PREVIEW_DISPLAYCFG         3211        //Get preview shows the parameters
#define NET_DVR_SET_PREVIEW_DISPLAYCFG         3212        //Set preview shows the parameters
#define NET_DVR_REMOTECONTROL_PTZ            3213       //Remote control of PTZ
#define NET_DVR_REMOTECONTROL_PRESETPOINT    3214       //Remote Control preset point
#define NET_DVR_REMOTECONTROL_CRUISE         3215       //Remote control cruise

#define NET_DVR_GET_MULTI_STREAM_COMPRESSIONCFG  3216    //Get muti stream compressioncfg
#define NET_DVR_SET_MULTI_STREAM_COMPRESSIONCFG  3217    //Set muti stream compressioncfg

#define NET_DVR_GET_WPSCFG                     3218        //Get WPS configuration
#define NET_DVR_SET_WPSCFG                     3219        //Set WPS configuration
#define NET_DVR_WPS_CONNECT                  3220        //WPS connect
#define NET_DVR_GET_DEVICE_PIN               3221        //Get device PIN
#define NET_DVR_UPDATE_PIN                   3223        //Update device PIN
#define NET_DVR_GET_PRESETCFG                3224        //Get preset point parameters
#define NET_DVR_GET_PTZCRUISECFG             3225        //Get cruise path parameters
#define NET_DVR_GET_PRESET_NUM                 3226        //Access to preset point number
#define NET_DVR_GET_PTZCRUISE_NUM             3227        //Access to the cruise path number

#define NET_DVR_GET_MOTION_TRACK_CFG         3228        //Access to track parameters
#define NET_DVR_SET_MOTION_TRACK_CFG         3229        //Set the track parameter
#define NET_DVR_CLEAR_IPC_PARAM                 3230       //To empty the front-end parameters 

#define NET_DVR_GET_IPADDR_FILTERCFG         3232        //Get IP address filter
#define NET_DVR_SET_IPADDR_FILTERCFG         3233        //Set IP address filter

#define NET_DVR_GET_LOGO_OVERLAYCFG             3234       //Get LOGO overlay configuration 
#define NET_DVR_SET_LOGO_OVERLAYCFG             3235       //Set LOGO overlay configuration
#define NET_DVR_GET_IPV6_LIST                3236        //Get all IPV6 address of the network card information
#define NET_DVR_GET_AUDIOOUT_VOLUME          3237 
#define NET_DVR_SET_AUDIOOUT_VOLUME          3238
#define NET_DVR_GET_FUZZY_UPGRADE            3239        //Get fuzzy matching information upgrade
#define NET_DVR_GET_BV_CORRECT_PARAM         3240        //Get the camera calibration parameters
#define NET_DVR_SET_BV_CORRECT_PARAM         3241        //Set the camera calibration parameters
#define NET_DVR_GET_OUTPUT_VIDEO_TYPE        3242        //Get Output Video Type
#define NET_DVR_SET_OUTPUT_VIDEO_TYPE        3243        //Set Output Video Type
#define NET_DVR_FISHEYE_CFG                  3244    //Create long link of fisheye
#define NET_DVR_GET_PTZ_POINT                3245    //Get ptz position
#define NET_DVR_SET_PTZ_POINT                3246    //Set ptz position
#define NET_DVR_REMOTECONTROL_DEV_PARAM      3247    //Set params of the logon device
#define NET_DVR_GET_FISHEYE_STREAM_STATUS    3248    //Get stream status of fisheye

#define NET_DVR_GET_GBT28181_ACCESS_CFG            3249 // Get GBT28181 Protocol Access Cfg        
#define NET_DVR_SET_GBT28181_ACCESS_CFG            3250 // Set GBT28181 Protocol Access Cfg
#define NET_DVR_GET_GBT28181_CHANINFO_CFG        3251 // Get GBT28181 Protocol Access Dev Channel Info
#define NET_DVR_SET_GBT28181_CHANINFO_CFG        3252 // Set GBT28181 Protocol Access Dev Channel Info
#define NET_DVR_GET_GBT28181_ALARMINCFG            3253 // Get GBT28181 Protocol Access Alarm Info
#define NET_DVR_SET_GBT28181_ALARMINCFG            3254 // Set GBT28181 Protocol Access Alarm Info
#define NET_DVR_GET_ISP_CAMERAPARAMCFG            3255 // Get ISP Camera Info cfg
#define NET_DVR_SET_ISP_CAMERAPARAMCFG            3256 // Set ISP Camera Info cfg
#define NET_DVR_GET_DEVSERVER_CFG                3257 // Get DevServer cfg
#define NET_DVR_SET_DEVSERVER_CFG                3258 // Set DevServer cfg

//2013-11-25
#define    NET_DVR_GET_WIPERINFO_CFG                3259   //Get Wiper Info
#define    NET_DVR_SET_WIPERINFO_CFG                3260   //Set Wiper Info
#define NET_DVR_GET_TRACK_DEV_PARAM             3261   //Get Track Device Param
#define NET_DVR_SET_TRACK_DEV_PARAM             3262   //Set Track Device Param
#define NET_DVR_GET_PTZ_TRACK_PARAM             3263   //Get PTZ Track Param
#define NET_DVR_SET_PTZ_TRACK_PARAM             3264   //Set PTZ Track Param
#define NET_DVR_GET_CENTER_POINT_CFG            3265   //get center point parameters
#define NET_DVR_SET_CENTER_POINT_CFG            3266   //set center point parameters
#define NET_DVR_GET_CENTER_POINT_CFG_CAPABILITIES        3267    //get center point parameters capabilities
#define NET_DVR_GET_FISHEYE_CAPABILITIES        3268        //get fisheye capabilities

#define NET_DVR_GET_BASICPARAMCFG                3270 //Get the basic parameters of PTZ configuration information         
#define NET_DVR_SET_BASICPARAMCFG                3271 //set the basic parameters of PTZ configuration information
#define NET_DVR_GET_PTZOSDCFG                    3272 //get PTZ OSD configuration parameter information        
#define NET_DVR_SET_PTZOSDCFG                    3273 //Set PTZ OSD configuration parameter information
#define NET_DVR_GET_POWEROFFMEMCFG                3274 //get power down memory model parameter information    
#define NET_DVR_SET_POWEROFFMEMCFG                3275 //set power down memory model parameter information
#define NET_DVR_GET_LIMITCFG                    3276 //get the limiting parameter configuration information    
#define NET_DVR_SET_LIMITCFG                    3277 //set the limiting parameter configuration information
#define NET_DVR_PTZLIMIT_CTRL                    3278 //clearance limit parameter control    

#define NET_DVR_PTZ_CLEARCTRL                    3279 //clear configuration information control interface    
#define NET_DVR_GET_PRIORITIZECFG                3281 //get Haeundae priority configuration information    
#define NET_DVR_SET_PRIORITIZECFG                3282 //set Haeundae priority configuration information
#define NET_DVR_PTZ_INITIALPOSITIONCTRL            3283 //zero azimuth control    
#define NET_DVR_GET_PRIVACY_MASKSCFG            3285 //get privacy parameter
#define NET_DVR_SET_PRIVACY_MASKSCFG            3286 //set privacy parameter
#define NET_DVR_GET_PTZLOCKCFG                    3287 //get Haeundae lock information    
#define NET_DVR_SET_PTZLOCKCFG                    3288 //set Haeundae lock information
#define NET_DVR_PTZ_ZOOMRATIOCTRL                3289 //set the tracking rate    
#define NET_DVR_GET_PTZLOCKINFO                    3290 //get Haeundae locking seconds remaining
#define NET_DVR_GET_PRIVACY_MASKS_ENABLECFG        3291 //get the global enable    
#define NET_DVR_SET_PRIVACY_MASKS_ENABLECFG        3292 //set the global enable
#define NET_DVR_GET_SMARTTRACKCFG                3293 //get acquisition intelligent motion tracking configuration information    
#define NET_DVR_SET_SMARTTRACKCFG                3294 //set acquisition intelligent motion tracking configuration information
#define NET_DVR_GET_EPTZ_CFG                    3295 //get EPTZ parameters
#define NET_DVR_SET_EPTZ_CFG                    3296 //set EPTZ parameters
#define NET_DVR_GET_EPTZ_CFG_CAPABILITIES        3297 //get EPTZ parameters capabilities

#define NET_DVR_GET_LOW_LIGHTCFG            3303       
#define NET_DVR_SET_LOW_LIGHTCFG            3304    

#define NET_DVR_GET_FOCUSMODECFG            3305       
#define NET_DVR_SET_FOCUSMODECFG            3306       

#define NET_DVR_GET_INFRARECFG              3307       
#define NET_DVR_SET_INFRARECFG              3308      

#define NET_DVR_GET_AEMODECFG               3309       
#define NET_DVR_SET_AEMODECFG               3310       

#define NET_DVR_CONTROL_RESTORE_SUPPORT     3311   // Restore the front end of the default parameters (parameter capabilities, some front-end parameters to configure the associated recovery)
#define NET_DVR_CONTROL_RESTART_SUPPORT     3312   

#define NET_DVR_CONTROL_PTZ_PATTERN         3313 //PTZ Pattern
#define NET_DVR_GET_PTZ_PARKACTION_CFG      3314       //Get PTZ Parkaction configuration
#define NET_DVR_SET_PTZ_PARKACTION_CFG      3315    //Set PTZ Parkaction configuration
#define NET_DVR_CONTROL_PTZ_MANUALTRACE     3316       //PTZ manual trace

#define NET_DVR_GET_ROI_DETECT_NUM            3349 //Get the number of ROI detection area number
#define NET_DVR_GET_ROI_DETECT                3350 //Get ROI detection area configuration
#define NET_DVR_SET_ROI_DETECT                3351 //Set ROI detection area configuration
#define NET_DVR_GET_FACE_DETECT                3352 //Get face detection configuration
#define NET_DVR_SET_FACE_DETECT                3353 //Set face detection configuration
#define NET_DVR_GET_CORRIDOR_MODE            3354 //Get corridor mode configuration
#define NET_DVR_SET_CORRIDOR_MODE            3355 //Set corridor mode configuration

//2013-07-16
#define NET_DVR_GET_SCENECHANGE_DETECTIONCFG    3356 //Get the scene change the alarm configuration 
#define NET_DVR_SET_SCENECHANGE_DETECTIONCFG    3357 //Set the scene change the alarm configuration 

#define NET_DVR_GET_TRAVERSE_PLANE_DETECTION    3360 
#define NET_DVR_SET_TRAVERSE_PLANE_DETECTION    3361 
#define NET_DVR_GET_FIELD_DETECTION             3362 //Get the field detection configuration
#define NET_DVR_SET_FIELD_DETECTION             3363 //Set the field detection configuration
#define NET_DVR_GET_DEFOCUSPARAM                3364 //Get the defouce detection configuration
#define NET_DVR_SET_DEFOCUSPARAM                3365 //Set the defouce detection configuration
#define NET_DVR_GET_AUDIOEXCEPTIONPARAM         3366 //Get the aduio exception configuration
#define NET_DVR_SET_AUDIOEXCEPTIONPARAM         3367 //Set the aduio exception configuration
#define NET_DVR_GET_CCDPARAMCFG_EX              3368 //Get the CCD configuration
#define NET_DVR_SET_CCDPARAMCFG_EX              3369 //Set the CCD configuration
#define NET_DVR_START_GET_INPUTVOLUME           3370 //Get the inputvolume

#define NET_DVR_SET_SCH_TASK                3380 //Set PTZ schdule tasks
#define NET_DVR_GET_SCH_TASK                3381 //Get PTZ schdule tasks
#define NET_DVR_SET_PRESET_NAME                3382 //Set the name of preset
#define NET_DVR_GET_PRESET_NAME                3383 //Get the name of preset
#define NET_DVR_SET_AUDIO_NAME                3384 //set the name of audio
#define NET_DVR_GET_AUDIO_NAME                3385  //get the name of audio

//[add] by zja 2013-10-29 10:55:31  IPC 5.1.4 resume initial tracking position 
#define NET_DVR_RESUME_INITRACKPOS              3386  //resume initial tracking position 

#define NET_DVR_NTP_SERVER_TEST                    3387    //NTP server test
#define    NET_DVR_NAS_SERVER_TEST                    3388    //NAS server test
#define    NET_DVR_EMAIL_SERVER_TEST                3389    //Email server test
#define    NET_DVR_FTP_SERVER_TEST                    3390    //FTP server test
#define    NET_DVR_IP_TEST                            3391    //IP conflict test
#define NET_DVR_GET_NET_DISKCFG_V40             3392 //Get net disk mount config v40
#define NET_DVR_SET_NET_DISKCFG_V40                3393 //Set net disk mount config v40

///20140220 IPC5.1.6 BEGIN
#define        NET_DVR_GET_IOOUT_CFG                3394    //    get supplement light configuration
#define        NET_DVR_SET_IOOUT_CFG                3395    //    set supplement light configuration

#define        NET_DVR_GET_SIGNAL_SYNC                3396    //     get signal light sync configuration
#define        NET_DVR_SET_SIGNAL_SYNC                3397    //     set signal light sync configuration    

#define        NET_DVR_GET_EZVIZ_ACCESS_CFG        3398    //    get EZVIZ access configuration
#define        NET_DVR_SET_EZVIZ_ACCESS_CFG        3399    //    set EZVIZ access configuration
///20140220 IPC5.1.6 end

#define    NET_DVR_GET_SCHEDULE_AUTO_TRACK_CFG        3400    //get schedule auto tracking configuration
#define    NET_DVR_SET_SCHEDULE_AUTO_TRACK_CFG        3401    //set schedule auto tracking configuration
#define    NET_DVR_MAKE_I_FRAME                    3402    //Make I Frame

//PJ01D2013032803  2014-03-04
#define  NET_DVR_GET_ALARM_RELATE                3403   //Get Alarm Relate
#define  NET_DVR_SET_ALARM_RELATE                3404   //Set Alarm Relate


/************************* IPC5.1.7  Begin 2014-03-21****************************/
#define NET_DVR_GET_PDC_RULECFG_V42             3405    //Set Traffic statistics
#define NET_DVR_SET_PDC_RULECFG_V42             3406    //Get Traffic statistics
#define NET_DVR_GET_HEATMAP_CFG                 3407    //Set Heat Map
#define NET_DVR_SET_HEATMAP_CFG                 3408    //Get Heat Map
/************************* IPC5.1.7  End 2014-03-21*****************************/

#define NET_DVR_REMOTECONTROL_LINEARSCAN        3409    //Set the left and right boundary parameters 2014-03-15
#define NET_DVR_DPC_CTRL                        3410    //DPC Ctrl
#define NET_DVR_FFC_MANUAL_CTRL                 3411    //FFC Manual Ctrl
#define NET_DVR_FFC_BACKCOMP_CTRL               3412    //FFC Background Ctrl 
#define NET_DVR_GET_FOCUSING_POSITION_STATE     3413    //Get Focusing Position State
#define NET_DVR_GET_PRIVATE_PROTOCOL_CFG        3414   //Get Private Protocol Cfg
#define NET_DVR_SET_PRIVATE_PROTOCOL_CFG        3415   //Set Private Protocol Cfg
#define NET_DVR_COMPLETE_RESTORE_CTRL           3420    //Complete Restore Ctrl

#define NET_DVR_CLOUDSTORAGE_SERVER_TEST        3421  //Cloud Storage Server Ctrl
#define NET_DVR_PHONE_NUM_TEST                  3422  //Phone Num Test
#define NET_DVR_GET_REMOTECONTROL_STATUS        3423  //Remote Control Status
#define NET_DVR_GET_MONITOR_LOCATION_INFO        3424  //Get Monitor Location Info
#define NET_DVR_SET_MONITOR_LOCATION_INFO        3425  //Set Monitor Location Info

#define    NET_DVR_GET_SMART_CAPABILITIES                3500    //get smart ability
#define    NET_DVR_GET_EVENT_TRIGGERS_CAPABILITIES        3501    //get event trigger ability
#define    NET_DVR_GET_REGION_ENTRANCE_CAPABILITIES    3502    //get region entrance detection ability
#define    NET_DVR_GET_REGION_ENTR_DETECTION            3503    //get region entrance detection configuration
#define    NET_DVR_SET_REGION_ENTR_DETECTION            3504    //set region entrance detection configuration
#define    NET_DVR_GET_REGION_ENTR_REGION                3505    //get region entrance detection single region configuration
#define    NET_DVR_SET_REGION_ENTR_REGION                3506    //set region entrance detection single region configuration
#define    NET_DVR_GET_REGION_ENTR_TRIGGER                3507    //get region entrance detection trigger configuration
#define    NET_DVR_SET_REGION_ENTR_TRIGGER                3508    //set region entrance detection trigger configuration
#define    NET_DVR_GET_REGION_ENTR_SCHEDULE            3509    //get region entrance detection arm schedule configuration
#define    NET_DVR_SET_REGION_ENTR_SCHEDULE            3510    //set region entrance detection arm schedule configuration
#define    NET_DVR_GET_REGION_EXITINT_CAPABILITIES        3511    //get region exit detection ability
#define    NET_DVR_GET_REGION_EXITING_DETECTION        3512    //get region exit detection configuration
#define    NET_DVR_SET_REGION_EXITING_DETECTION        3513    //set region exit detection configuration
#define    NET_DVR_GET_REGION_EXITING_REGION            3514    //get region exit detection single region configuration
#define    NET_DVR_SET_REGION_EXITING_REGION            3515    //set region exit detection single region configuration
#define    NET_DVR_GET_REGION_EXIT_TRIGGER                3516    //get region exit detection trigger configuration
#define    NET_DVR_SET_REGION_EXIT_TRIGGER                3517    //set region exit detection trigger configuration
#define    NET_DVR_GET_REGION_EXIT_SCHEDULE            3518    //get region exit detection arm schedule configuration
#define    NET_DVR_SET_REGION_EXIT_SCHEDULE            3519    //set region exit detection arm schedule configuration
#define    NET_DVR_GET_LOITERING_CAPABILITIES            3520    //get region loiter detection ability
#define    NET_DVR_GET_LOITERING_DETECTION                3521    //get region loiter detection configuration
#define    NET_DVR_SET_LOITERING_DETECTION                3522    //set region loiter detection configuration
#define    NET_DVR_GET_LOITERING_REGION                3523    //get region loiter detection single region configuration
#define    NET_DVR_SET_LOITERING_REGION                3524    //set region loiter detection single region configuration
#define    NET_DVR_GET_LOITERING_TRIGGER                3525    //get region loiter detection trigger configuration
#define    NET_DVR_SET_LOITERING_TRIGGER                3526    //set region loiter detection trigger configuration
#define    NET_DVR_GET_LOITERING_SCHEDULE                3527    //get region loiter detection arm schedule configuration
#define    NET_DVR_SET_LOITERING_SCHEDULE                3528    //set region loiter detection arm schedule configuration
#define    NET_DVR_GET_GROUPDETECTION_CAPABILITIES        3529    //get region group detection ability
#define    NET_DVR_GET_GROUP_DETECTION                    3530    //get region group detection configuration
#define    NET_DVR_SET_GROUP_DETECTION                    3531    //set region group detection configuration
#define    NET_DVR_GET_GROUPDETECTION_REGION            3532    //get region group detection single region configuration
#define    NET_DVR_SET_GROUPDETECTION_REGION            3533    //set region group detection single region configuration
#define    NET_DVR_GET_GROUPDETECTION_TRIGGER            3534    //get region group detection trigger configuration
#define    NET_DVR_SET_GROUPDETECTION_TRIGGER            3535    //set region group detection trigger configuration
#define    NET_DVR_GET_GROUPDETECTION_SCHEDULE            3536    //get region group detection arm schedule configuration
#define    NET_DVR_SET_GROUPDETECTION_SCHEDULE            3537    //set region group detection arm schedule configuration
#define    NET_DVR_GET_RAPIDMOVE_CAPABILITIES            3538    //get region rapid move detection ability
#define    NET_DVR_GET_RAPIDMOVE_DETECTION                3539    //get region rapid move detection configuration
#define    NET_DVR_SET_RAPIDMOVE_DETECTION                3540    //set region rapid move detection configuration
#define    NET_DVR_GET_RAPIDMOVE_REGION                3541    //get region rapid move detection single region configuration
#define    NET_DVR_SET_RAPIDMOVE_REGION                3542    //set region rapid move detection single region configuration
#define    NET_DVR_GET_RAPIDMOVE_TRIGGER                3543    //get region rapid move detection trigger configuration
#define    NET_DVR_SET_RAPIDMOVE_TRIGGER                3544    //set region rapid move detection trigger configuration
#define    NET_DVR_GET_RAPIDMOVE_SCHEDULE                3545    //get region rapid move detection arm schedule configuration
#define    NET_DVR_SET_RAPIDMOVE_SCHEDULE                3546    //set region rapid move detection arm schedule configuration
#define    NET_DVR_GET_PATKING_CAPABILITIES            3547    //get region park detection ability
#define    NET_DVR_GET_PARKING_DETECTION               3548    //get region park detection configuration
#define    NET_DVR_SET_PARKING_DETECTION                3549    //set region park detection configuration
#define    NET_DVR_GET_PARKING_REGION                    3550    //get region park detection single region configuration
#define    NET_DVR_SET_PARKING_REGION                    3551    //set region park detection single region configuration
#define    NET_DVR_GET_PARKING_TRIGGER                    3552    //get region park detection trigger configuration
#define    NET_DVR_SET_PARKING_TRIGGER                    3553    //set region park detection trigger configuration
#define    NET_DVR_GET_PARKING_SCHEDULE                3554    //get region park detection arm schedule configuration
#define    NET_DVR_SET_PARKING_SCHEDULE                3555    //set region park detection arm schedule configuration
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_CAPABILITIES    3556    //get region unattended baggage detection ability
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_DETECTION    3557    //get region unattended baggage detection configuration
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_DETECTION    3558    //set region unattended baggage detection configuration
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_REGION        3559    //get region unattended baggage detection single region configuration
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_REGION        3560    //set region unattended baggage detection single region configuration
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_TRIGGER        3561    //get region unattended baggage detection trigger configuration
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_TRIGGER        3562    //set region unattended baggage detection trigger configuration
#define    NET_DVR_GET_UNATTENDED_BAGGAGE_SCHEDULE        3563    //get region unattended baggage detection arm schedule configuration
#define    NET_DVR_SET_UNATTENDED_BAGGAGE_SCHEDULE        3564    //set region unattended baggage detection arm schedule configuration
#define    NET_DVR_GET_ATTENDEDBAGGAGE_CAPABILITIES    3565    //get region attended baggage detection ability
#define    NET_DVR_GET_ATTENDEDBAGGAGE_DETECTION        3566    //get region attended baggage detection configuration
#define    NET_DVR_SET_ATTENDEDBAGGAGE_DETECTION        3567    //set region attended baggage detection configuration
#define    NET_DVR_GET_ATTENDEDBAGGAGE_REGION            3568    //get region attended baggage detection single region configuration
#define    NET_DVR_SET_ATTENDEDBAGGAGE_REGION            3569    //set region attended baggage detection single region configuration
#define    NET_DVR_GET_ATTENDEDBAGGAGE_TRIGGER            3570    //get region attended baggage detection trigger configuration
#define    NET_DVR_SET_ATTENDEDBAGGAGE_TRIGGER            3571    //set region attended baggage detection trigger configuration
#define    NET_DVR_GET_ATTENDEDBAGGAGE_SCHEDULE        3572    //get region attended baggage detection arm schedule configuration
#define    NET_DVR_SET_ATTENDEDBAGGAGE_SCHEDULE        3573    //set region attended baggage detection arm schedule configuration
#define    NET_DVR_GET_REGIONCLIP_CAPABILITIES            3574    //get region clip ability
#define    NET_DVR_GET_REGION_CLIP                     3575    //get region clip configuration
#define    NET_DVR_SET_REGION_CLIP                     3576    //set region clip configuration
#define    NET_DVR_GET_NETWORK_CAPABILITIES            3577    //get network ability
#define    NET_DVR_GET_WIRELESS_DIAL                     3578    //get wireless dial configuration
#define    NET_DVR_SET_WIRELESS_DIAL                     3579    //set wireless dial configuration
#define    NET_DVR_GET_WIRELESSDIAL_CAPABILITIES        3580    //get wireless dial configuration ability
#define    NET_DVR_GET_WIRELESSDIAL_SCHEDULE            3581    //get wireless dial schedule configuration
#define    NET_DVR_SET_WIRELESSDIAL_SCHEDULE            3582    //set wireless dial schedule configuration
#define    NET_DVR_GET_WIRELESSDIAL_STATUS             3583    //get wireless dial status
#define    NET_DVR_GET_REGION_ENTRANCE_SCHEDULE_CAPABILITIES    3584    //get region entrance detection arm schedule ability
#define    NET_DVR_GET_REGION_EXITING_SCHEDULE_CAPABILITIES    3585    //get region exit detection arm schedule ability
#define    NET_DVR_GET_LOITERING_SCHEDULE_CAPABILITIES    3586    //get region loiter detection arm schedule ability
#define    NET_DVR_GET_GROUP_SCHEDULE_CAPABILITIES    3587    //get region group detection arm schedule ability
#define    NET_DVR_GET_RAPIDMOVE_SCHEDULE_CAPABILITIES    3588    //get region rapid move detection arm schedule ability
#define    NET_DVR_GET_PARKING_SCHEDULE_CAPABILITIES    3589    //get region park detection arm schedule ability
#define    NET_DVR_GET_UNATTENDEDBAGGAGE_SCHEDULE_CAPABILITIES    3590    //get region unattended baggage detection arm schedule ability
#define    NET_DVR_GET_ATTENDEDBAGGAGE_SCHEDULE_CAPABILITIES    3591    //get region attended baggage detection arm schedule ability
#define    NET_DVR_GET_WIRELESSDIAL_SCHEDULE_CAPABILITIES    3592    //get wireless dial schedule ability
#define    NET_DVR_WIRELESSDIAL_CONNECT    3593    //control connect wireless dial

#define    NET_DVR_GET_LITESTORAGE                    3594    
#define    NET_DVR_SET_LITESTORAGE                    3595    
#define    NET_DVR_GET_LITESTORAGE_CAPABILITIES    3596    

#define    NET_DVR_GET_VEHICLE_CAPABILITIES    3597
#define    NET_DVR_GET_VEHICLE_CALIBRATION     3598    

#define    NET_DVR_GET_SLAVECAMERA_CAPABILITIES    3599    //Get SlaveCamera IP Info Capabilities    
#define    NET_DVR_GET_SLAVECAMERA                    3600    //Get SlaveCamera IP Info
#define    NET_DVR_SET_SLAVECAMERA                    3601    //Set SlaveCamera IP Info
#define    NET_DVR_GET_SLAVECAMERA_STATUS            3602    //Get SlaveCamera Link Status
#define    NET_DVR_GET_SLAVECAMERA_CALIB_CAPABILITIES    3603  //Get SlaveCamera Calib Capabilities    
#define    NET_DVR_GET_SLAVECAMERA_CALIB            3604    //Get SlaveCamera Calib Param
#define    NET_DVR_SET_SLAVECAMERA_CALIB            3605    //Set SlaveCamera Calib Param
#define NET_DVR_GET_PHY_RATIO                    3606    //Get Physics Ratio Coordinate Info    
#define NET_DVR_SET_PHY_RATIO                    3607    //Set Physics Ratio Coordinate Info
#define NET_DVR_GET_MASTERSLAVETRACKING_CAPABILITIES   3608  //Get MasterSlaveTracking Capabilities 
#define    NET_DVR_SET_TRACKINGRATIO                3610    //Set SlaveCamera Tracking Ratio 
#define    NET_DVR_GET_TRACKING                    3611    //Get tracking param
#define    NET_DVR_SET_TRACKING                    3612    //Set tracking param
#define    NET_DVR_GET_TRACKING_CAPABILITIES        3613    //Get tracking param capabilities
#define    NET_DVR_GET_SLAVECAMERA_CALIB_V50        3614    //Get SlaveCamera Calib Param V50
#define    NET_DVR_SET_SLAVECAMERA_CALIB_V50        3615    //Set SlaveCamera Calib Param V50
#define    NET_DVR_SET_TRACKINGRATIO_MANUAL        3616    //Set Tracking Ratio Manual Coefficient
#define    NET_DVR_GET_TRACKINGRATIO_MANUAL        3617    //Get Tracking Ratio Manual Coefficient
#define    NET_DVR_SET_TRACK_INITPOSTION            3618    //Set Tracking InitPostion 
#define    NET_DVR_GET_PTZ_CAPABILITIES            3619    //Get PTZ Capabilities

#define    NET_DVR_GET_THERMOMETRY_BASICPARAM_CAPABILITIES    3620 //Get Thermometry Basic Param capabilities
#define    NET_DVR_GET_THERMOMETRY_BASICPARAM      3621    //Get Thermometry Basic Param
#define    NET_DVR_SET_THERMOMETRY_BASICPARAM        3622    //Set Thermometry Basic Param
#define    NET_DVR_GET_THERMOMETRY_SCENE_CAPABILITIES    3623 //Get Thermometry Scene capabilities
#define    NET_DVR_GET_THERMOMETRY_PRESETINFO      3624    //Get Thermometry Preset Info
#define    NET_DVR_SET_THERMOMETRY_PRESETINFO        3625    //Set Thermometry Preset Info
#define    NET_DVR_GET_THERMOMETRY_ALARMRULE_CAPABILITIES    3626 //Get Thermometry Alarm Rule Capabilities
#define    NET_DVR_GET_THERMOMETRY_ALARMRULE       3627    //Get Thermometry Alarm Rule
#define    NET_DVR_SET_THERMOMETRY_ALARMRULE        3628    //Set Thermometry Alarm Rule
#define    NET_DVR_GET_REALTIME_THERMOMETRY        3629    //Get Realtime Thermometry
#define    NET_DVR_GET_THERMOMETRY_DIFFCOMPARISON  3630    //Get Thermometry Temperature difference
#define    NET_DVR_SET_THERMOMETRY_DIFFCOMPARISON    3631    //Set Thermometry Temperature difference
#define    NET_DVR_GET_THERMOMETRY_TRIGGER            3632    //Get Thermometry Trigger
#define    NET_DVR_SET_THERMOMETRY_TRIGGER            3633    //Set Thermometry Trigger

#define    NET_DVR_GET_THERMAL_CAPABILITIES        3634    //Get Thermal Capabilities
#define    NET_DVR_GET_FIREDETECTION_CAPABILITIES    3635    //Get FireDetection Capabilities
#define    NET_DVR_GET_FIREDETECTION               3636    //Get FireDetection
#define    NET_DVR_SET_FIREDETECTION               3637    //Set FireDetection
#define    NET_DVR_GET_FIREDETECTION_TRIGGER       3638    //Get FireDetection Trigger
#define    NET_DVR_SET_FIREDETECTION_TRIGGER        3639    //Set FireDetection Trigger

#define    NET_DVR_GET_OIS_CAPABILITIES            3640    //Get OIS Capabilities
#define    NET_DVR_GET_OIS_CFG                     3641    //Get OIS Info
#define    NET_DVR_SET_OIS_CFG                     3642    //Set OIS Info
#define    NET_DVR_GET_MACFILTER_CAPABILITIES      3643    //Get MAC Filter Capabilities
#define    NET_DVR_GET_MACFILTER_CFG               3644    //Get MAC Filter
#define    NET_DVR_SET_MACFILTER_CFG               3645    //Set MAC Filter
#define    NET_DVR_GET_EAGLEFOCUS_CALCFG_CAPABILITIES   3646    //Get Elagle Focus Calib Capabilities
#define    NET_DVR_GET_EAGLEFOCUSING_CALCFG        3647    //Get Elagle Focus Calib
#define    NET_DVR_SET_EAGLEFOCUSING_CALCFG        3648    //Set Elagle Focus Calib
#define    NET_DVR_GET_EAGLEFOCUSING_CFG_CAPABILITIES   3649   //Get Elagle Focus Capabilities
#define    NET_DVR_GET_EAGLEFOCUSING_CTRL          3650    //Get Elagle Focus
#define    NET_DVR_SET_EAGLEFOCUSING_CTRL          3651    //Set Elagle Focus 
#define    NET_DVR_GET_PXOFFLINE_CAPABILITIES      3652    //PX Offline Configuration capabilities
#define    NET_DVR_SET_PXOFFLINE_CFG                3653    //Set PX Offline Configuration
#define    NET_DVR_GET_PXOFFLINE_CFG                3654    //Get PX Offline Configuration
#define    NET_DVR_GET_PAPERCHARGEINFO_CAPABILITIES  3655  //Get parking lot entrance ticket information capabilities
#define    NET_DVR_SET_PAPERCHARGEINFO                3656    //Set parking lot entrance ticket information
#define    NET_DVR_GET_PARKINGSAPCE_CAPABILITIES    3657    //Get Parking sapce Capabilities
#define    NET_DVR_SET_PARKINGSAPCE_INFO            3658    //Set Parking sapce Info
#define    NET_DVR_GET_PXMULTICTRL_CAPABILITIES    3659    //PX Multi Ctrl Configuration Capabilities
#define    NET_DVR_GET_CHARGEACCOUNT_CAPABILITIES    3661    //Get Charge Account Info Capabilities
#define    NET_DVR_SET_CHARGE_ACCOUNTINFO          3662    //Set Charge Account Info
#define    NET_DVR_SET_PXMULTICTRL_CFG                3663    //Set PX Multi Ctrl Configuration
#define    NET_DVR_GET_PXMULTICTRL_CFG                3664    //Get PX Multi Ctrl Configuration
#define    NET_DVR_GET_TME_CHARGERULE              3665    //Get Entrance Vehicle Card
#define    NET_DVR_SET_TME_CHARGERULE               3666    //Set Entrance Vehicle Card
#define    NET_DVR_GET_TME_CHARGERULE_CAPABILITIES 3667    //Get Entrance Vehicle Card Capabilities
#define    NET_DVR_GET_ILLEGALCARDFILTERING_CAPABILITIES  3668    //Get Illegal card filtering Capabilities
#define    NET_DVR_GET_ILLEGALCARDFILTERING_CFG    3669    //Get Illegal card filtering
#define    NET_DVR_SET_ILLEGALCARDFILTERING_CFG    3670    //Set Illegal card filtering
#define    NET_DVR_GET_LEDDISPLAY_CAPABILITIES        3671    //Get LED Display Capabilities
#define    NET_DVR_SET_LEDDISPLAY_CFG              3672    //Set LED Display Cfg
#define    NET_DVR_GET_LEDDISPLAY_CFG              3673    //Get LED Display Cfg
#define    NET_DVR_GET_VOICEBROADCAST_CAPABILITIES    3674    //Get VoiceBroadcast Capabilities
#define    NET_DVR_SET_VOICEBROADCAST_CFG          3675    //Set VoiceBroadcast Cfg
#define    NET_DVR_GET_PAPERPRINTFORMAT_CAPABILITIES    3676//Get Paper Print Format Capabilities
#define    NET_DVR_GET_PAPERPRINTFORMAT_CFG        3677    //Get Paper Print Format Cfg
#define    NET_DVR_SET_PAPERPRINTFORMAT_CFG        3678    //Set Paper Print Format Cfg
#define    NET_DVR_GET_LOCkGATE_CAPABILITIES       3679    //Get Lock Gate Capabilities
#define    NET_DVR_GET_LOCKGATE_CFG                3680    //Get Lock Gate Cfg
#define    NET_DVR_SET_LOCKGATE_CFG                3681    //Set Lock Gate Cfg
#define NET_DVR_GET_PARKING_DATASTATE            3682    //Get Parking Data State
#define NET_DVR_SET_PARKING_DATASTATE           3683    //Set Parking Data State
#define    NET_DVR_GET_TME_CAPABILITIES            3684    //Get TME Capabilities

#define    NET_DVR_GET_TMEVOICE_CAPABILITIES       3686    //Get TME Voice Capabilities
#define    NET_DVR_SET_TMEVOICE_CFG                3687    //Set TME Voice CFG
#define    NET_DVR_GET_TMEVOICE_CFG                3688    //Get TME Voice CFG
#define    NET_DVR_DEL_TMEVOICE_CFG                3689    //Delete TME Voice CFG
#define    NET_DVR_GET_POSITION                    3698    //Get Soft Position Work Mode Param
#define    NET_DVR_SET_POSITION                    3699    //Set Soft Position Work Mode Param
#define    NET_DVR_GET_CENTRALIZEDCTRL_CAPABILITIES    3700//Get Centralized Ctrl Capbailities
#define    NET_DVR_GET_CENTRALIZEDCTRL                3701    //Get Centralized Ctrl
#define    NET_DVR_SET_CENTRALIZEDCTRL              3702    //Set Centralized Ctrl
#define    NET_DVR_GET_COMPASS_CAPABILITIES        3703    //Get Compass Capabilities
#define    NET_DVR_GET_VANDALPROOFALARM              3704    //Get Vandalproof Alarm
#define    NET_DVR_SET_VANDALPROOFALARM            3705    //Set Vandalproof Alarm
#define    NET_DVR_COMPASS_CALIBRATE_CTRL            3706    //Compass Calibrate Ctrl
#define    NET_DVR_COMPASS_NORTH_CTRL                3707    //Compass North Ctrl
#define    NET_DVR_GET_AZIMUTHINFO                    3708    //Get Azimuth Info
#define    NET_DVR_GET_SATELLITETIME                3709    //Get Satellite positioning Cfg
#define    NET_DVR_SET_SATELLITETIME                3710    //Set Satellite positioning Cfg
#define    NET_DVR_GET_GISINFO                     3711    //Get DIS Info
#define    NET_DVR_GET_STREAMING_CAPABILITIES        3712    //Get Streaming Capabilities 
#define    NET_DVR_GET_REFRESHFRAME_CAPABILITIES    3713    //Get Refresh Frame Capabilities
#define    NET_DVR_STREAMING_REFRESH_FRAME            3714    //Streaming Refresh Frame
#define    NET_DVR_FACECAPTURE_STATISTICS            3715    //Face Capture Statistic

#define    NET_DVR_GET_WIRELESSSERVER_CAPABILITIES    3716    //get wireless server capabilities
#define    NET_DVR_GET_WIRELESSSERVER                3717    //get wireless server
#define    NET_DVR_SET_WIRELESSSERVER                3718    //set wireless server
#define    NET_DVR_GET_CONNECT_LIST_CAPABILITIES    3719    //get connect list capabilities
#define    NET_DVR_GET_THSCREEN_CAPABILITIES        3720    //Get Thscreen capabilities
#define    NET_DVR_GET_THSCREEN                    3721    //Get Thscreen

#define    NET_DVR_GET_EXTERNALDEVICE_CAPABILITIES    3722    //Get External Device Capabilities
#define    NET_DVR_GET_EXTERNALDEVICE              3723    //Get External Device
#define    NET_DVR_SET_EXTERNALDEVICE                3724    //Set External Device
#define    NET_DVR_GET_LEDDISPLAYINFO_CAPABILITIES    3725   //Get Led Display Info Capabilities
#define    NET_DVR_SET_LEDDISPLAYINFO                3726   //Set Led Display Info 
#define    NET_DVR_GET_SUPPLEMENTLIGHT_CAPABILITIES 3727   //get Builtin supplement Light Capabilities
#define    NET_DVR_GET_SUPPLEMENTLIGHT                 3728    //get Builtin supplement Light
#define    NET_DVR_SET_SUPPLEMENTLIGHT                 3729    //set Builtin supplement Light
#define    NET_DVR_SET_THSCREEN                     3730   //Set Thscreen
#define    NET_DVR_GET_LOWPOWER_CAPABILITIES        3731   //Get Low Power Capabilities
#define    NET_DVR_GET_LOWPOWER                     3732    //Get Low Power Cfg
#define    NET_DVR_SET_LOWPOWER                     3733    //Set Low Power Cfg
#define    NET_DVR_GET_ZOOMLINKAGE_CAPABILITIES     3734   //Get Zoom Linkage Capabilities
#define    NET_DVR_GET_ZOOMLINKAGE                     3735    //Get Zoom Linkage
#define    NET_DVR_SET_ZOOMLINKAGE                     3736    //Set Zoom Linkage
#define    NET_DVR_THSCREEN_TIMING                     3737    //ThScreen Timing

#define NET_DVR_GET_OSD_BATTERY_POWER_CFG        3741        //get osd battery power parameter
#define NET_DVR_SET_OSD_BATTERY_POWER_CFG        3742        //set osd battery power parameter
#define    NET_DVR_GET_OSD_BATTERY_POWER_CFG_CAPABILITIES    3743//get osd battery power parameter Capabilities
#define    NET_DVR_GET_VANDALPROOFALARM_TRIGGER    3744    //Get VandalProof alarm Trigger
#define    NET_DVR_SET_VANDALPROOFALARM_TRIGGER    3745    //Set VandalProof alarm Trigger
#define    NET_DVR_GET_PANORAMAIMAGE_CAPABILITIES    3746    //Get panorama image Capabilities 
#define    NET_DVR_GET_PANORAMAIMAGE                3747    //Get panorama image param 
#define    NET_DVR_SET_PANORAMAIMAGE                3748    //Set panorama image param 
#define    NET_DVR_GET_STREAMENCRYPTION            3749    //Get Stream Encryption param
#define    NET_DVR_SET_STREAMENCRYPTION            3750    //Set Stream Encryption param
#define    NET_DVR_GET_STREAMENCRYPTION_CAPABILITIES 3751  //Get Stream Encryption Capabilities
#define    NET_DVR_GET_REVISE_GPS_CAPABILITIES     3752    //Get Revise GPS Capabilities
#define    NET_DVR_GET_REVISE_GPS                  3753    //Get Revise GPS CFG    
#define    NET_DVR_SET_REVISE_GPS                  3754    //Set Revise GPS CFG
#define NET_DVR_GET_PDC_RECOMMEND                3755    //get PDC Recommend value
#define NET_DVR_REMOVE_FLASHSTORAGE                3756    //Remove PDC Flash Storage
#define    NET_DVR_GET_COUNTING_CAPABILITIES        3757    //get PDC(counting) capabilities
#define    NET_DVR_SET_SENSOR_ADJUSTMENT            3758    //Set Sensor Adjustment
#define    NET_DVR_GET_SENSOR_ADJUSTMENT_CAPABILITIES        3759    //Get Sensor Adjustment capabilities
#define    NET_DVR_GET_WIRELESSSERVER_FULLVERSION_CFG         3760    //Get wifi Cfg(Full Version)
#define    NET_DVR_SET_WIRELESSSERVER_FULLVERSION_CFG         3761    //Set wifi Cfg(Full Version)

#define    NET_DVR_GET_ONLINEUSER_INFO                3762    //get online user info
#define    NET_DVR_GET_SENSOR_ADJUSTMENT_INFO        3763    //get the sensor adjustment info
#define NET_DVR_SENSOR_RESET_CTRL               3764    //Sensor adjustment reset
#define    NET_DVR_GET_POSTRADAR_CAPABILITIES        3765    //Get Post Radar Capabilities
#define    NET_DVR_GET_POSTRADARSPEED_CFG          3766    //Get Post Radar Speed Cfg
#define    NET_DVR_SET_POSTRADARSPEED_CFG          3767    //Set Post Radar Speed Cfg
#define    NET_DVR_GET_POSTRADARSPEED_RECOM_CFG    3768    //Get Post Radar Speed Recom Cfg
#define    NET_DVR_GET_POSTRADARPARAM_CFG          3769    //Get Post Radar Param Cfg
#define    NET_DVR_SET_POSTRADARPARAM_CFG          3770    //Set Post Radar Param Cfg
#define    NET_DVR_GET_POSTRADARPARAM_RECOM_CFG    3771    //Get Post Radar Param Recom Cfg
#define NET_DVR_GET_ENCRYPT_DEVICE_INFO         3772   //get encrypt device info
#define NET_DVR_GET_ANR_ARMING_HOST             3773  //Get offline continuingly host information 
#define NET_DVR_GET_FIRMWARE_VERSION    3776    //GET firmware version
/********************************The IPC baseline FF license plate ****************************/
#define    NET_DVR_GET_FTP_CAPABILITIES         3782    //Access to FTP ability
#define    NET_DVR_GET_FTPUPLOAD_CFG             3783    //Get for FTP upload information structured parameters 
#define    NET_DVR_SET_FTPUPLOAD_CFG             3784    //set the FTP upload information structured parameters  
#define NET_DVR_GET_VEHICLE_INFORMATION         3785 //Get vehicle information 
#define    NET_DVR_GET_DDNS_COUNTRY_ABILITY        3800    //Get DDNS country Ability 
#define NET_DVR_GET_DEVICECFG_V50    3801    //Get equipment parameters V50
#define NET_DVR_SET_DEVICECFG_V50    3802    //Set equipment parameters V50
#define NET_DVR_SET_VEHICLE_RECOG_TASK_V50    3851  //Set vehicle recog task V50 EX
#define    NET_DVR_GET_SMARTCALIBRATION_CAPABILITIES    3900    //Get Smart behavior calibration filter size function Capabilities
#define NET_DVR_GET_TEMPERATURE_TRIGGER              3903    //Get Temperture trigger
#define NET_DVR_SET_TEMPERATURE_TRIGGER              3904    //Set Temperture trigger
#define    NET_DVR_GET_SMARTCALIBRATION_CFG             3910        //Get Smart behavior calibration filter size function 
#define    NET_DVR_SET_SMARTCALIBRATION_CFG             3911        //Set Smart behavior calibration filter size function
#define NET_DVR_POST_SETUP_CALIB                     3912  //Set up calibration 
#define NET_DVR_SET_POS_INFO_OVERLAY                 3913//Set the Pos information code superposition of flow control
#define NET_DVR_GET_POS_INFO_OVERLAY                 3914//Superposition of Pos information stream control 
#define NET_DVR_GET_CAMERA_WORK_MODE                 3915  //Set the camera work mode parameters camera work mode 
#define NET_DVR_SET_CAMERA_WORK_MODE                 3916  //Get the camera work mode parameters camera work mode 
#define NET_DVR_GET_RESOLUTION_SWITCH_CAPABILITIES   3917  //get resolution switch capabilities
#define NET_DVR_GET_RESOLUTION_SWITCH                3918  //get resolution switch
#define NET_DVR_SET_RESOLUTION_SWITCH                3919  //set resolution switch
#define NET_DVR_GET_VEHICLLE_RESULT_CAPABILITIES     3951   //get the results of vehicle information ability 
#define NET_DVR_GET_CALIB_CAPABILITIES               3952//Get setup calibration capability
#define NET_DVR_GET_POSINFO_OVERLAY_CAPABILITIES     3953//Get Pos stack capability
#define NET_SDK_FINDMEDICALFILE      3954    //search medical record files
#define NET_SDK_FINDMEDICALPICTURE   3955    //search medical pictures
#define NET_DVR_SET_POSINFO_OVERLAY                  3960//Set Pos overlay
#define NET_DVR_GET_POSINFO_OVERLAY                  3961//Get Pos overlay
#define NET_DVR_GET_FACELIB_TRIGGER                  3962   //get face lib trigger
#define NET_DVR_SET_FACELIB_TRIGGER                  3963   //set face lib trigger
#define NET_DVR_GET_FACECONTRAST_TRIGGER             3965//Get face alignment linkage configuration
#define NET_DVR_SET_FACECONTRAST_TRIGGER             3966//Set face alignment linkage configuration
#define NET_DVR_GET_FACECONTRAST_SCHEDULE_CAPABILITIES 3967 //Get on face time defending ability
#define NET_DVR_GET_FACECONTRAST_SCHEDULE            3968//Get face time allocation ratio
#define NET_DVR_SET_FACECONTRAST_SCHEDULE            3969//Configuration settings on face deployment time
#define NET_DVR_GET_FACELIB_SCHEDULE_CAPABILITIES    3970 //get face lib schedule capabilities
#define NET_DVR_GET_VCA_VERSION_LIST                 3973//Get algorithm library version
#define NET_DVR_GET_SETUP_CALIB                      3974//Set up calibration
#define NET_DVR_GET_PANORAMA_LINKAGE                 3975//Get to upload screenshots linkage configuration
#define NET_DVR_SET_PANORAMA_LINKAGE                 3976//Set the upload to capture linkage configuration
#define NET_DVR_GET_FACELIB_SCHEDULE                 3977 //get face lib schedule
#define NET_DVR_SET_FACELIB_SCHEDULE                 3978 //t facelib schedule
#define NET_DVR_GET_SOFTWARE_SERVICE_CAPABILITIES    3980//Get the ability of service 
#define NET_DVR_GET_SOFTWARE_SERVICE                 3981//Get software service configuration 
#define NET_DVR_SET_SOFTWARE_SERVICE                 3982//Set software and services 
#define NET_DVR_GET_PREVIEW_MODE_CAPABILITIES        3983//Get preview mode configuration
#define NET_DVR_SET_EAGLE_FOCUS_GOTOSCENE            3984//The eagle focus set camera turns to the specified scene ID
#define NET_DVR_EAGLE_FOCUS_SCENE_DEL                3985//Remove the focus of the eagle calibration scene
#define NET_DVR_GET_SAFETY_HELMET_TRIGGER            3986  //Get Safety helmet detection linkage configuration
#define NET_DVR_SET_SAFETY_HELMET_TRIGGER            3987  //Set Safety helmet detection linkage configuration
#define NET_DVR_GET_SAFETY_HELMET_SCHEDULE_CAPABILITIES 3988 //Get Safety helmet detection schedule capabilities
#define NET_DVR_GET_SAFETY_HELMET_SCHEDULE            3989//Get Safety helmet detection schedule configuration
#define NET_DVR_SET_SAFETY_HELMET_SCHEDULE            3990//Set Safety helmet detection schedule configuration

#define NET_DVR_GET_SIGN_ABNORMAL_TRIGGER            4150   //Get sign abnormal linkage configuration
#define NET_DVR_SET_SIGN_ABNORMAL_TRIGGER            4151   //Set sign abnormal linkage configuration
#define NET_DVR_ONE_KEY_CONFIG_SAN_V50               4152  //One key configuration SAN (V50) 
#define NET_DVR_GET_HDCFG_V50                        4153  //Get hard disk information parameters V50
#define NET_DVR_SET_HDCFG_V50                        4154  //Set hard disk information parameters V50
#define NET_DVR_GET_HDVOLUME_CFG                     4155  //Get hard disk volume information
#define NET_DVR_SET_HDVOLUME_CFG                     4156  //Set hard disk volume information
#define NET_DVR_GET_POWER_SUPPLY_CABINET_TRIGGER     4157  //get ITS Monitor linkage config
#define NET_DVR_SET_POWER_SUPPLY_CABINET_TRIGGER     4158  //set ITS Monitor linkage config
#define NET_DVR_GET_SENSOR_TRIGGER                   4159  //get Sensor Port linkage config
#define NET_DVR_SET_SENSOR_TRIGGER                   4160  //set Sensor Port linkage config
#define	NET_DVR_GET_FACESNAP_TRIGGER                 4161  //Get FaceSnap Trigger
#define	NET_DVR_SET_FACESNAP_TRIGGER	             4162  //Set FaceSnap Trigger
#define NET_DVR_GET_FACESNAP_SCHEDULE_CAPABILITIES   4163  //Get FaceSnap Scheule Time Capabilities
#define NET_DVR_GET_FACESNAP_SCHEDULE                4164  //Get FaceSnap Scheule Time
#define NET_DVR_SET_FACESNAP_SCHEDULE                4165  //Set FaceSnap Scheule Time

#define NET_DVR_SET_SCREEN_SWITCH                    4171  //Image switching control
#define NET_DVR_GET_BV_CALIB_PIC                     4172  //Get the device to grab images and additional information
#define NET_DVR_GET_BV_CALIB_RESULT                  4173  //Get the binocular calib result
#define NET_DVR_GET_BV_HCORRECTION                   4174  //Get the binocular height correction data
#define NET_DVR_DEL_BV_CALIB_PIC                     4175  //Delete the sample image
#define NET_DVR_GET_TV_SCREEN_CFG                    4176  //Get the broadcast screen stay time configuration
#define NET_DVR_SET_TV_SCREEN_CFG                    4177  //Set the broadcast screen stay time configuration
#define NET_DVR_ADJUST_BV_CALIB                      4178  //Adjust the binocular calibration
#define NET_DVR_GET_HUMAN_CALIB                      4179  //Get human position calibration cfg
#define NET_DVR_SET_HUMAN_CALIB                      4180  //Set human position calibration cfg
#define NET_DVR_GET_USERCFG_V51                      4181    //Get user parameters
#define NET_DVR_SET_USERCFG_V51                      4182    //Set user parameters
#define NET_DVR_GET_SOFTIO_TRIGGER                   4183   //Get the SoftIO linkage configuration
#define NET_DVR_SET_SOFTIO_TRIGGER                   4184   //Set the SoftIO linkage configuration
#define NET_DVR_GET_SOFTIO_SCHEDULE_CAPABILITIES     4185 //Get the SoftIO schedule time capabilities
#define NET_DVR_GET_SOFTIO_SCHEDULE                  4186 //Get the SoftIO schedule time
#define NET_DVR_SET_SOFTIO_SCHEDULE                  4187 //Set the SoftIO schedule time
#define NET_DVR_GET_HFPD_TRIGGER                     4188 //Get the HFPD linkage configuration
#define NET_DVR_SET_HFPD_TRIGGER                     4189 //Set the HFPD linkage configuration
#define NET_DVR_GET_HFPD_SCHEDULE_CAPABILITIES       4190 //Get the HFPD schedule time capabilities
#define NET_DVR_GET_HFPD_SCHEDULE                    4191 //Get the HFPD schedule time
#define NET_DVR_SET_HFPD_SCHEDULE                    4192 //Set the HFPD schedule time
#define	NET_DVR_GET_ALARM_INFO                       4193	//Get alarm information
#define NET_DVR_GET_USERCFG_V52                      4194    //Get user parameters V52
#define NET_DVR_SET_USERCFG_V52                      4195    //Set user parameters V52


/********************************NVR_Prodection Line****************************/
#define NET_DVR_GET_MUTEX_FUNCTION              4353  //get mutex function information

#define NET_DVR_GET_SINGLE_CHANNELINFO          4360  //get single channel information
#define NET_DVR_GET_CHANNELINFO                 4361  //get channnel information
#define NET_DVR_CHECK_LOGIN_PASSWORDCFG             4362  //admin login password check
#define NET_DVR_GET_SINGLE_SECURITY_QUESTION_CFG        4363    //get single device security question
#define NET_DVR_SET_SINGLE_SECURITY_QUESTION_CFG        4364    //set single device security question
#define NET_DVR_GET_SECURITY_QUESTION_CFG       4365    //get device security question
#define NET_DVR_SET_SECURITY_QUESTION_CFG       4366    //set device security question
#define NET_DVR_GET_ONLINEUSERLIST_SC           4367  //remote get user login inf (short connect)

#define    NET_DVR_GET_BLACKLIST_FACECONTRAST_TRIGGER   4368   //GET BLACKLIST FACECONTRAST TRIGGER
#define    NET_DVR_SET_BLACKLIST_FACECONTRAST_TRIGGER   4369   //SET BLACKLIST FACECONTRAST TRIGGER
#define    NET_DVR_GET_WHITELIST_FACECONTRAST_TRIGGER   4370   //GET WHITELIST FACECONTRAST TRIGGER
#define    NET_DVR_SET_WHITELIST_FACECONTRAST_TRIGGER   4371   //SET WHITELIST FACECONTRAST TRIGGER
#define    NET_DVR_GET_BLACKLIST_FACECONTRAST_SCHEDULE_CAPABILITIES 4372 //GET BLACKLIST FACECONTRAST SCHEDULE CAPABILITIES
#define NET_DVR_GET_BLACKLIST_FACECONTRAST_SCHEDULE  4373   //GET_BLACKLIST FACECONTRAST SCHEDULE
#define NET_DVR_SET_BLACKLIST_FACECONTRAST_SCHEDULE  4374   //SET_BLACKLIST FACECONTRAST SCHEDULE
#define NET_DVR_GET_WHITELIST_FACECONTRAST_SCHEDULE_CAPABILITIES 4375 //GET WHITELIST FACECONTRAST SCHEDULE CAPABILITIES
#define NET_DVR_GET_WHITELIST_FACECONTRAST_SCHEDULE  4376 //GET WHITELIST  FACECONTRAST SCHEDULE
#define NET_DVR_SET_WHITELIST_FACECONTRAST_SCHEDULE  4377 //SET WHITELIST FACECONTRAST SCHEDULE

#define NET_DVR_GET_HUMAN_RECOGNITION_SCHEDULE_CAPABILITIES 4378 //GET HUMAN RECOGNITION SCHEDULE CAPABILITIES
#define NET_DVR_GET_HUMAN_RECOGNITION_SCHEDULE 4379 //GET HUMAN RECOGNITION SCHEDULE
#define NET_DVR_SET_HUMAN_RECOGNITION_SCHEDULE 4380 //SET HUMAN RECOGNITION SCHEDULE
#define NET_DVR_GET_HUMAN_RECOGNITION_TRIGGER               4381 //GET HUMAN RECOGNITION TRIGGER
#define NET_DVR_SET_HUMAN_RECOGNITION_TRIGGER               4382 //SET HUMAN RECOGNITION TRIGGER
#define NET_DVR_GET_GBT28181_AUDIO_OUTPUT_CFG               4383 //GET GBT28181 AUDIO OUTPUT CFG
#define NET_DVR_SET_GBT28181_AUDIO_OUTPUT_CFG               4384 //SET GBT28181 AUDIO OUTPUT CFG

#define NET_DVR_GET_STUDENTS_STOODUP_TRIGGER         4386   //Get students to stand up to detect linkage configuration 
#define NET_DVR_SET_STUDENTS_STOODUP_TRIGGER         4387   //Set students to stand up to detect linkage configuration 
#define NET_DVR_GET_FRAMES_PEOPLE_COUNTING_SCHEDULE_CAPABILITIES    4388 //Get regional people counting schedule ability 
#define NET_DVR_GET_FRAMES_PEOPLE_COUNTING_SCHEDULE  4389    //Get regional people counting schedule
#define NET_DVR_SET_FRAMES_PEOPLE_COUNTING_SCHEDULE  4390    //Set regional people counting schedule
#define NET_DVR_GET_FRAMES_PEOPLE_COUNTING_TRIGGER   4391   //Get regional people counting trigger
#define NET_DVR_SET_FRAMES_PEOPLE_COUNTING_TRIGGER   4392   //Set regional people counting trigger
#define NET_DVR_GET_PERSONDENSITY_TRIGGER   4393   //Get linkage of the personnel density test configuration 
#define NET_DVR_SET_PERSONDENSITY_TRIGGER   4394   //Set linkage of the personnel density test configuration 
#define NET_DVR_GET_PERSONDENSITY_SCHEDULE_CAPABILITIES 4395 //Get personnel density detection protection time configuration capabilities
#define NET_DVR_GET_PERSONDENSITY_SCHEDULE 4396 //Get personnel density detection protection time configuration
#define NET_DVR_SET_PERSONDENSITY_SCHEDULE 4397 //Set personnel density detection protection time configuration

#define NET_DVR_GET_STUDENTS_STOODUP_SCHEDULE_CAPABILITIES  4398 //Get students to stand up detection protection ability 
#define NET_DVR_GET_STUDENTS_STOODUP_SCHEDULE        4399    //Get students to stand up detection protection
#define NET_DVR_SET_STUDENTS_STOODUP_SCHEDULE        4400    //Set students to stand up detection protection

#define NET_DVR_SET_FACE_THERMOMETRY_TRIGGER         4401 //SET FACE THERMOMETRY TRIGGER
#define NET_DVR_GET_FACE_THERMOMETRY_SCHEDULE_CAPABILITIES 4402 //GET FACE THERMOMETRY SCHEDULE CAPABILITIES
#define NET_DVR_GET_FACE_THERMOMETRY_SCHEDULE        4403 //GET FACE THERMOMETRY SCHEDULE
#define NET_DVR_SET_FACE_THERMOMETRY_SCHEDULE        4404 //SET FACE THERMOMETRY SCHEDULE
#define NET_DVR_GET_FACE_THERMOMETRY_TRIGGER         4405 //GET FACE THERMOMETRY TRIGGER
#define	NET_DVR_GET_PERSONQUEUE_TRIGGER   4406   //GET PERSONQUEUE TRIGGER
#define	NET_DVR_SET_PERSONQUEUE_TRIGGER	  4407   //SET PERSONQUEUE TRIGGER
#define	NET_DVR_GET_PERSONQUEUE_SCHEDULE_CAPABILITIES	4408 //GET PERSONQUEUE SCHEDULE CAPABILITIES
#define	NET_DVR_GET_PERSONQUEUE_SCHEDULE	4409	//GET PERSONQUEUE SCHEDULE
#define	NET_DVR_SET_PERSONQUEUE_SCHEDULE	4410	//SET PERSONQUEUE SCHEDULE

#define NET_DVR_GET_FACESNAPCFG              5001       //Get face snap configuration
#define NET_DVR_SET_FACESNAPCFG              5002       //Set face snap configuration
#define NET_DVR_GET_DEVACCESS_CFG            5005       //Get device access configuration
#define NET_DVR_SET_DEVACCESS_CFG            5006       //Set device access configuration
#define NET_DVR_GET_SAVE_PATH_CFG            5007       //Get storage information parameter
#define NET_DVR_SET_SAVE_PATH_CFG            5008       //Set storage information parameter
#define NET_VCA_GET_RULECFG_V41                 5011        //Get behavior analysis parameters (extended)
#define NET_VCA_SET_RULECFG_V41                 5012        //Set behavior analysis parameters (extended)
#define NET_DVR_GET_AID_RULECFG_V41          5013       //Get traffic event rule parameters(extended)
#define NET_DVR_SET_AID_RULECFG_V41          5014       //Set traffic event rule parameters(extended)
#define NET_DVR_GET_TPS_RULECFG_V41          5015       //Get traffic rule statistics(extended)
#define NET_DVR_SET_TPS_RULECFG_V41          5016       //Set traffic rule statistics(extended)
#define NET_VCA_GET_FACEDETECT_RULECFG_V41   5017       //Get ATM face detect analysis parameters(extended) 
#define NET_VCA_SET_FACEDETECT_RULECFG_V41   5018       //Set ATM face detect analysis parameters(extended) 
#define NET_DVR_GET_PDC_RULECFG_V41          5019       //Get PDC analysis parameters(extended)
#define NET_DVR_SET_PDC_RULECFG_V41          5020       //Set PDC analysis parameters(extended)
#define NET_DVR_GET_TRIAL_VERSION_CFG        5021       //Get trial version
#define NET_DVR_GET_VCA_CTRLINFO_CFG         5022       //Get vca ctrl info(extended)
#define NET_DVR_SET_VCA_CTRLINFO_CFG         5023       //Set vca ctrl info(extended)
#define NET_DVR_SYN_CHANNEL_NAME             5024       //Syn channel name
#define NET_DVR_GET_RESET_COUNTER            5025       //Get reset counter
#define NET_DVR_SET_RESET_COUNTER            5026       //Set reset counter
#define NET_DVR_GET_OBJECT_COLOR             5027       //Get object color attribute
#define NET_DVR_SET_OBJECT_COLOR             5028       //Set object color attribute
#define NET_DVR_GET_AUX_AREA                 5029       //Get auxiliary area list
#define NET_DVR_SET_AUX_AREA                 5030       //Set auxiliary area list
#define NET_DVR_GET_CHAN_WORKMODE            5031       //Get channel workmode
#define NET_DVR_SET_CHAN_WORKMODE            5032       //Set channel workmode
#define NET_DVR_GET_SLAVE_CHANNEL            5033       //Get slave channel parameters
#define NET_DVR_SET_SLAVE_CHANNEL            5034       //Set slave channel parameters
#define NET_DVR_GET_VQD_EVENT_RULE           5035       //Get VQD event rule
#define NET_DVR_SET_VQD_EVENT_RULE           5036       //Set VQD event rule
#define NET_DVR_GET_BASELINE_SCENE           5037       //Get baseline scene parameters
#define NET_DVR_SET_BASELINE_SCENE           5038       //Set baseline scene parameters
#define NET_DVR_CONTROL_BASELINE_SCENE       5039       //Operation on baseline scene
#define NET_DVR_SET_VCA_DETION_CFG             5040        //set vca detion cfg
#define NET_DVR_GET_VCA_DETION_CFG             5041        //get vca detion cfg
#define NET_DVR_GET_STREAM_ATTACHINFO_CFG    5042       //get stream attach parameters
#define NET_DVR_SET_STREAM_ATTACHINFO_CFG    5043       //set stream attach parameters

#define NET_DVR_GET_BV_CALIB_TYPE            5044       //Get Calib Type
#define NET_DVR_CONTROL_BV_SAMPLE_CALIB      5045       //Sample Calib 
#define NET_DVR_GET_BV_SAMPLE_CALIB_CFG      5046       //Get Sample Calib Point
#define NET_DVR_GET_RULECFG_V42                 5049       //Get rule V42 of VCA
#define NET_DVR_SET_RULECFG_V42                 5050       //Set rule V42 of VCA
#define NET_DVR_SET_VCA_DETION_CFG_V40         5051       //set vca detion cfg
#define NET_DVR_GET_VCA_DETION_CFG_V40       5052       //get vca detion cfg
#define NET_DVR_SET_FLASH_CFG                5110       //Write data to the Flash test 
/********************************ITS****************************/
//2014-12-03  
#define    NET_DVR_GET_T1TEST_CFG   5053     //Production line test configuration interface (get)
#define    NET_DVR_SET_T1TEST_CFG   5054     //Production line test configuration interface (set)

#define NET_ITS_GET_OVERLAP_CFG_V50             5055       //Get Overlap Cfg V50
#define NET_ITS_SET_OVERLAP_CFG_V50             5056       //Set Overlap Cfg V50
#define NET_DVR_GET_PARKLAMP_STATE             5057       //Get  Access to parking signal status information
#define NET_DVR_GET_CLOUDSTORAGE_CFG         5058       //Gets the cloud storage configuration parameters
#define NET_DVR_SET_CLOUDSTORAGE_CFG         5059       //Sets the cloud storage configuration parameters

#define NET_ITS_GET_BASE_INFO                 5060        //Get ITS base information
#define NET_DVR_GET_SENSOR_INFO              5061       //Get Sensor Cfg
#define    NET_DVR_SET_SENSOR_SWITCH             5062       //Set Sensor Switch
#define NET_ITS_GET_IMGMERGE_CFG             5063        //Get image merge configuration
#define NET_ITS_SET_IMGMERGE_CFG             5064        //Set image merge configuration
#define NET_ITS_GET_UPLOAD_CFG                 5065        //Get upload data configuration
#define NET_ITS_SET_UPLOAD_CFG                 5066        //Set upload data configuration
#define    NET_DVR_GET_SENSOR_PORT_CAPABILITIES 5067       //Get Sensor Port Capabilities
#define NET_ITS_GET_WORKSTATE                 5069        //Get ITS work state
#define NET_ITS_GET_IPC_CHAN_CFG             5070        //Get ITS IPC channel configuration
#define NET_ITS_SET_IPC_CHAN_CFG             5071        //Set ITS IPC channel configuration
#define NET_ITS_GET_OVERLAP_CFG                 5072        //Get overlap configuration
#define NET_ITS_SET_OVERLAP_CFG                 5073        //Set overlap configuration
#define NET_DVR_GET_TRIGGEREX_CFG            5074       //Get Trigger Configuration
#define NET_DVR_SET_TRIGGEREX_CFG            5075       //Set Trigger Configuration
#define NET_ITS_GET_ROAD_INFO                 5076        //Get road information

#define NET_ITS_REMOTE_DEVICE_CONTROL         5077        //Set Remote device control
#define NET_ITS_GET_GATEIPC_CHAN_CFG         5078        //Get the synchronization host configuration
#define NET_ITS_SET_GATEIPC_CHAN_CFG         5079        //Set the synchronization host configuration
#define NET_ITS_TRANSCHAN_START              5080       //Start Synchronous data server
#define NET_ITS_GET_ECTWORKSTATE             5081       //Get the import and export terminal state
#define NET_ITS_GET_ECT_CHAN_INFO            5082       //Get the import and export terminal channel status
#define NET_DVR_GET_HEATMAP_RESULT           5083       //Get Heat Map 2014-03-21

//2013-11-19
#define NET_DVR_SET_ITS_EXDEVCFG             5084       //Set ITS CFG
#define NET_DVR_GET_ITS_EXDEVCFG             5085       //Get ITS CFG
#define NET_DVR_GET_ITS_EXDEVSTATUS             5086       //Get ITS Device Status
#define NET_DVR_SET_ITS_ENDEVCMD             5087       //Set ITS Control
#define NET_DVR_SET_ENISSUED_DATADEL         5088       //Set ITS Data Delete

#define NET_DVR_GET_PDC_RESULT               5089       //Passenger flow data query 2014-03-21

#define NET_ITS_GET_LAMP_CTRLCFG             5090       //Get inside and outside the lamp parameters 
#define NET_ITS_SET_LAMP_CTRLCFG             5091       //Set inside and outside the lamp parameters 
#define NET_ITS_GET_PARKSPACE_ATTRIBUTE_CFG  5092       //Get special parking space parameters 
#define NET_ITS_SET_PARKSPACE_ATTRIBUTE_CFG  5093       //Set special parking space parameters 
#define NET_ITS_SET_LAMP_EXTERNAL_CFG        5095       //Set external control configuration parameters
#define NET_ITS_SET_COMPEL_CAPTURE           5096       //Set the parking enforcement 

#define  NET_DVR_SET_TIMESIGN_CFG            5097       //Set Custom Set Time Sign
#define  NET_DVR_GET_TIMESIGN_CFG            5098       //Get Custom Set Time Sign
#define NET_DVR_GET_SIGNALLAMP_STATUS        5099       //Signal lamp detection

#define NET_DVR_GET_MONITOR_PLAN_VQD         5100       //long connection to obtain diagnostic server program
#define NET_DVR_GET_MONITORID_VQD            5101       //long connection for monitoring points within the corresponding plan
#define NET_DVR_SET_MONITOR_INFO             5102       //monitoring points within the volume set plan 
#define NET_DVR_DEL_MONITOR_PLAN_VQD         5103       //delete plan
#define NET_DVR_GET_MONITOR_VQD_STATUS       5104       //platform state to query the server for diagnosis
#define NET_DVR_GET_RECORD_INFO              5105       //access to resources pictures inquiries
#define NET_DVR_GET_MONITOR_VQDCFG           5106       //Get server monitoring points
#define NET_DVR_SET_MONITOR_VQDCFG           5107       //set server monitoring points
#define NET_DVR_SET_MONITOR_PLAN_VQDCFG      5108       //settings management plan (individual plan)

#define NET_DVR_SCENE_CHANGE_UPDATE             5109        //scene change update

#define NET_DVR_GET_CALIBRATE_POINT          5153       //Normalized coordinate transformation (Shot the ball linkage equipment external interactive command code Baseline code does not realize, prevent conflict, submitted to the baseline )

#define NET_DVR_GET_SCENE_CFG                5201       //Get scene configuration
#define NET_DVR_SET_SCENE_CFG                5202       //Set scene configuration
#define NET_DVR_GET_SCENE_REFERENCE_REGION   5203       //Get scene reference region
#define NET_DVR_SET_SCENE_REFERENCE_REGION   5204       //Set scene reference region
#define NET_DVR_GET_SCENE_CALIBRATION        5205       //Get scene calibration
#define NET_DVR_SET_SCENE_CALIBRATION        5206       //Set scene calibration
#define NET_DVR_GET_SCENE_MASK_REGION        5207       //Get scene mask region
#define NET_DVR_SET_SCENE_MASK_REGION        5208       //Set scene mask region
#define    NET_DVR_GET_SCENE_LANECFG             5209       //Get scene lane rule parameters
#define NET_DVR_SET_SCENE_LANECFG             5210       //Set scene lane rule parameters
#define NET_DVR_GET_SCENE_AID_RULECFG        5211       //Get scene traffic event rule parameters
#define NET_DVR_SET_SCENE_AID_RULECFG        5212       //Set scene traffic event rule parameters
#define NET_DVR_GET_SCENE_TPS_RULECFG        5213       //Get scene traffic rule statistics
#define NET_DVR_SET_SCENE_TPS_RULECFG        5214       //Set scene traffic rule statistics
#define NET_DVR_GET_SCENE_TIME_CFG           5215       //Get scene effective time configuration
#define NET_DVR_SET_SCENE_TIME_CFG           5216       //Set scene effective time configuration
#define NET_DVR_GET_FORENSICS_MODE           5217       //Get forensics mode
#define NET_DVR_SET_FORENSICS_MODE           5218       //Set forensics mode
#define NET_DVR_FORCESTOP_FORENSICS_CTRL     5219       //Force stop Forensics Ctrl

#define NET_DVR_GET_ALARM_PROCESS_CFG           5220
#define NET_DVR_SET_ALARM_PROCESS_CFG           5221
#define NET_DVR_GET_BLACKLIST_ALARM_INFO        5222
#define NET_DVR_GET_STORAGE_RESOURCE_CFG        5225
#define NET_DVR_SET_STORAGE_RESOURCE_CFG        5226
#define NET_DVR_DEL_BLACKLIST_ALARM_RECORD        5227
#define NET_DVR_SET_BLACKLIST_GROUP_INFO        5229
#define NET_DVR_DEL_BLACKLIST_GROUP_INFO        5230
#define NET_DVR_GET_BLACKLIST_GROUP_INFO        5231
#define NET_DVR_SET_BLACKLIST_GROUP_RECORD_CFG    5232
#define NET_DVR_GET_BLACKLIST_GROUP_RECORD_CFG    5234
#define NET_DVR_DEL_BLACKLIST_GROUP_RECORD_CFG    5235
#define    NET_DVR_GET_AREA_MONITOR_CFG            5236
#define    NET_DVR_SET_AREA_MONITOR_CFG            5237
#define    NET_DVR_DEL_AREA_MONITOR_CFG            5238
#define NET_DVR_RETRIEVAL_SNAP_RECORD            5240
#define NET_DVR_GET_ALARMLIST                    5241
#define NET_DVR_DETECT_IMAGE                    5242
#define NET_DVR_GET_SNAP_RECORD                 5243
#define NET_DVR_DEL_SNAP_RECORD                 5244
#define NET_DVR_GET_FACE_RECORD                 5245
#define NET_DVR_SET_FACE_RECORD                    5246
#define NET_DVR_DEL_FACE_RECORD                    5247
#define NET_DVR_GET_FACE_DATABASE                5248
#define NET_DVR_SET_FACE_DATABASE                5249
#define NET_DVR_DEL_FACE_DATABASE                5250
#define NET_DVR_RETRIEVAL_FACE_DATABASE            5251
#define NET_DVR_SET_BLACKLIST_REL_DEV_CFG        5252
#define NET_DVR_DEL_BLACKLIST_REL_DEV            5253

//NVR which has 64 IPC: Get the information of disk raid.
#define NET_DVR_GET_DISK_RAID_INFO             6001       //Get the information of disk raid
#define NET_DVR_SET_DISK_RAID_INFO             6002       //Set the information of disk raid
#define NET_DVR_GET_DVR_SYNCHRONOUS_IPC      6005       //Set the parameter which is used to synchronise IPC.
#define NET_DVR_SET_DVR_SYNCHRONOUS_IPC      6006       //Get the parameter which is used to synchronise IPC.
#define NET_DVR_SET_DVR_IPC_PASSWD             6008        //Set the password of IPC.
#define NET_DVR_GET_DEVICE_NET_USING_INFO     6009        //Get the using information of device net.
#define NET_DVR_SET_DVR_IPC_NET              6012        //Set the IP of IPC.
#define NET_DVR_GET_RECORD_CHANNEL_INFO      6013        //Get record channel information
#define NET_DVR_SET_RECORD_CHANNEL_INFO      6014        //Set record channel information

#define NET_DVR_MOUNT_DISK                     6015       // Mount disk
#define NET_DVR_UNMOUNT_DISK                 6016       // Unmount disk

// CVR 
#define NET_DVR_GET_STREAM_SRC_INFO             6017        //Get stream source information
#define NET_DVR_SET_STREAM_SRC_INFO             6018        //Set stream source information
#define NET_DVR_GET_STREAM_RECORD_INFO         6019        //Get stream record information
#define NET_DVR_SET_STREAM_RECORD_INFO         6020        //Set stream record information
#define NET_DVR_GET_STREAM_RECORD_STATUS     6021        //Get stream record status
#define NET_DVR_SET_STREAM_RECORD_STATUS     6022        //Set stream record status
#define NET_DVR_GET_STREAM_INFO                 6023        //Get stream ID info
#define NET_DVR_GET_STREAM_SRC_INFO_V40         6024       //Get stream source information Expend
#define NET_DVR_SET_STREAM_SRC_INFO_V40       6025       //Set stream source information Expend
#define NET_DVR_GET_RELOCATE_INFO            6026       //Get N+0 relocate info
#define NET_DVR_START_GOP_INFO_PASSBACK      6032       //VCA or Smart Info Pass Back
#define NET_DVR_GET_CHANS_RECORD_STATUS_CFG  6035       //Get Chan Record Status
#define NET_DVR_SET_CHANS_RECORD_STATUS_CFG  6036       //Set Chan Record Status


//NVR:96xx
#define NET_DVR_GET_IP_ALARM_GROUP_NUM         6100  
#define NET_DVR_GET_IP_ALARM_IN                 6101  
#define NET_DVR_GET_IP_ALARM_OUT             6102
//9000 v2.2
#define NET_DVR_GET_FTPCFG_SECOND             6103          //Get FTP parameter to which upload the picture
#define NET_DVR_SET_FTPCFG_SECOND             6104          //Set FTP parameter to which upload the picture

#define NET_DVR_GET_DEFAULT_VIDEO_EFFECT     6105        //Get default video effect
#define NET_DVR_SET_VIDEO_EFFECT             6106       //Set video effect

#define NET_DVR_DEL_INVALID_DISK             6107       // Delete invalid disk

#define NET_DVR_GET_DRAWFRAME_DISK_QUOTA_CFG 6109        //Get disk quota of frame extracting channel
#define NET_DVR_SET_DRAWFRAME_DISK_QUOTA_CFG 6110        //Set disk quota of frame extracting channel

#define NET_DVR_GET_NAT_CFG                  6111       //Get NAT parameter
#define NET_DVR_SET_NAT_CFG                  6112       //Set NAT parameter  

#define NET_DVR_GET_AES_KEY                  6113       //Get device's AES key

#define NET_DVR_GET_POE_CFG                  6114        //Get POE parameter
#define NET_DVR_SET_POE_CFG                  6115        //Set POE parameter

#define NET_DVR_GET_CUSTOM_PRO_CFG           6116        //Get customized protocol parameter 
#define NET_DVR_SET_CUSTOM_PRO_CFG           6117        //Set customized protocol parameter  

#define NET_DVR_GET_STREAM_CABAC             6118        //Get Stream CABAC
#define NET_DVR_SET_STREAM_CABAC             6119        //Set Stream CABAC

#define NET_DVR_GET_ESATA_MINISAS_USAGE_CFG     6120        //Get eSATA & miniSAS usage
#define NET_DVR_SET_ESATA_MINISAS_USAGE_CFG     6121        //Set eSATA & miniSAS usage

#define NET_DVR_GET_HDCFG_V40                 6122        //Get hard disk info
#define NET_DVR_SET_HDCFG_V40                 6123        //Set hard disk info

#define NET_DVR_GET_POE_CHANNEL_ADD_MODE     6124        //Get POE channel add mode
#define NET_DVR_SET_POE_CHANNEL_ADD_MODE     6125        //Set POE channel add mode

#define NET_DVR_GET_DIGITAL_CHANNEL_STATE    6126        //Get digital channel state


#define   NET_DVR_GET_BONJOUR_CFG           6127 
#define   NET_DVR_SET_BONJOUR_CFG           6128 


#define NET_DVR_GET_SOCKS_CFG                6130        
#define NET_DVR_SET_SOCKS_CFG                  6131      

#define    NET_DVR_GET_QOS_CFG                    6132    
#define NET_DVR_SET_QOS_CFG                    6133

#define NET_DVR_GET_HTTPS_CFG                6134    
#define NET_DVR_SET_HTTPS_CFG                6135

#define NET_DVR_GET_WD1_CFG                 6136     //get WD1 Enable status
#define NET_DVR_SET_WD1_CFG                 6137     //set WD1 Enable status

#define NET_DVR_CREATE_CERT                 6138       
#define NET_DVR_DELETE_CERT                 6139      


#define NET_DVR_GET_RECORD_LOCK_PERCENTAGE    6140        //Get record lock percentage
#define NET_DVR_SET_RECORD_LOCK_PERCENTAGE  6141        //Set record lock percentage

#define NET_DVR_CMD_TRIGGER_PERIOD_RECORD    6144        //Comand trigger period record
#define NET_DVR_UPLOAD_CERT                 6145      
#define NET_DVR_DOWNLOAD_CERT               6146      
#define NET_DVR_GET_CERT                    6147

#define NET_DVR_GET_POS_FILTER_CFG                6148    //Get POS Filter Cfg
#define NET_DVR_SET_POS_FILTER_CFG                6149    //Set POS Filter Cfg
#define NET_DVR_GET_CONNECT_POS_CFG                6150    //Get DVR and POS Connect Cfg
#define NET_DVR_SET_CONNECT_POS_CFG                6151    //Set DVR and POS Connect Cfg
#define NET_DVR_GET_CHAN_FILTER_CFG                6152    //Get Filter and Channel Relationship  
#define NET_DVR_SET_CHAN_FILTER_CFG                6153    //Set Filter and Channel Relationship  


#define NET_DVR_GET_FTPCFG_V40                6162    //Get FTP information
#define NET_DVR_SET_FTPCFG_V40                6163    //Set FTP information

#define NET_DVR_GET_MONTHLY_RECORD_DISTRIBUTION 6164   
#define NET_DVR_GET_ACCESS_DEVICE_CHANNEL_INFO  6165   
#define NET_DVR_GET_PREVIEW_SWITCH_CFG            6166   
#define NET_DVR_SET_PREVIEW_SWITCH_CFG            6167   

//Netra3.0.0
#define NET_DVR_GET_N_PLUS_ONE_WORK_MODE            6168    //Get N+1 work mode
#define NET_DVR_SET_N_PLUS_ONE_WORK_MODE            6169    //Set N+1 work mode

#define NET_DVR_GET_HD_STATUS                         6170    //Get HD status
#define NET_DVR_SET_HD_STATUS                         6171    //Set HD status

#define NET_DVR_IMPORT_IPC_CFG_FILE                    6172    //Import ip access config file
#define NET_DVR_EXPORT_IPC_CFG_FILE                    6173    //Export ip access config file 
#define NET_DVR_UPGRADE_IPC                            6174    //Upgrade ip channel

#define NET_DVR_GET_RAID_BACKGROUND_TASK_SPEED        6175    
#define NET_DVR_SET_RAID_BACKGROUND_TASK_SPEED        6176    



//marvell 256 NVR
#define NET_DVR_GET_EXCEPTIONCFG_V40                6177    //Get Exception Cfg 
#define NET_DVR_SET_EXCEPTIONCFG_V40                6178    //Set Exception Cfg 
#define NET_DVR_GET_PICCFG_V40                      6179    //Get Picture Param Cfg
#define NET_DVR_SET_PICCFG_V40                      6180    //Set Picture Param Cfg
#define NET_DVR_GET_ALARMINCFG_V40                  6181    //Get AlarmIn Cfg
#define NET_DVR_SET_ALARMINCFG_V40                  6182    //Set AlarmIn Cfg
#define NET_DVR_GET_IPALARMINCFG_V40                6183    //Get IP AlarmIn Cfg
#define NET_DVR_GET_IPALARMOUTCFG_V40               6185    //Set IP AlarmIn Cfg 
#define NET_DVR_GET_USERCFG_V40                     6187    //Get User Cfg
#define NET_DVR_SET_USERCFG_V40                     6188    //Set User Cfg
#define NET_DVR_GET_WORK_STATUS                     6189    //Get Device Work Status
#define NET_DVR_GET_JPEG_CAPTURE_CFG_V40            6190    //Get JPEG Capture Cfg
#define NET_DVR_SET_JPEG_CAPTURE_CFG_V40            6191    //Set JPEG Capture Cfg
#define NET_DVR_GET_HDGROUP_CFG_V40                 6192    //Get HD Group Cfg
#define NET_DVR_SET_HDGROUP_CFG_V40                 6193    //Set HD Group Cfg
#define NET_DVR_GET_SMD_HOLIDAY_HANDLE              6194    //Get SMD holiday handle cfg
#define NET_DVR_SET_SMD_HOLIDAY_HANDLE              6195    //Set SMD holiday handle cfg
#define NET_DVR_GET_PIC_MODEL_CFG                   6196    //Get picture model cfg
#define NET_DVR_SET_PIC_MODEL_CFG                   6197    //Set picture model cfg
#define NET_DVR_START_LOCAL_MOUSE_EVENT             6198    
#define NET_DVR_START_SIMULARE_MOUSE_EVENT          6199    
#define NET_DVR_GET_WORK_STATUS_V50                6200
#define NET_DVR_GET_ACCESS_CAMERA_INFO        6201        // Get access camera information
#define NET_DVR_SET_ACCESS_CAMERA_INFO      6202        // Set access camera information
#define NET_DVR_PULL_DISK                    6203        // Pull disk
#define NET_DVR_SCAN_RAID                    6204        // Scan raid

// CVR 2.0.X
#define NET_DVR_GET_USER_RIGHT_CFG                6210        // Get user right
#define NET_DVR_SET_USER_RIGHT_CFG                6211        // Set user right

#define NET_DVR_ONE_KEY_CONFIG                    6212        // CVR One key config
#define NET_DVR_RESTART_SERVICE                    6213        // Restart service

#define NET_DVR_GET_MAX_MACHINE_NUM_CFG            6214        // Get max machine
#define NET_DVR_SET_MAX_MACHINE_NUM_CFG            6215        // Set max machine

#define NET_DVR_ADD_DEVICE                        6216        //N+1 Add device
#define NET_DVR_DEL_DEVICE                        6217        //N+1 Del device

#define NET_DVR_GET_DATA_CALLBACK_CFG            6218        // Get data callback config
#define NET_DVR_SET_DATA_CALLBACK_CFG            6219        // Set data callback config

#define NET_DVR_CLONE_LUN                        6220    //Clone Lun
#define NET_DVR_EXPAND_LUN                        6221    //Expand Lun

#define NET_DVR_GET_N_PLUS_ONE_DEVICE_INFO        6222    //Get N+1 device infomation
#define NET_DVR_MODIFY_DVR_NET_DISK                6223    //Mod DVR net disk
//#define NET_DVR_DEL_DVR_NET_DISK                6224    //Delete DVR net disk

#define NET_DVR_CREATE_NAS                        6225    //Create NAS
#define NET_DVR_DELETE_NAS                        6226    //Delete NAS 

#define NET_DVR_OPEN_ISCSI                         6227    //Open iSCSI
#define NET_DVR_CLOSE_ISCSI                        6228    //Close iSCSI 

#define NET_DVR_GET_FC                            6229    //Get FC info
#define NET_DVR_OPEN_FC                             6230    //Open FC
#define NET_DVR_CLOSE_FC                         6231    //Close FC    

#define NET_DVR_ONE_KEY_CONFIG_SAN                6232  // One key config SAN

//CVR2.3.2

#define NET_DVR_RECORD_CHECK                        6233  //check record integrity
#define NET_DVR_ADD_RECORD_PASSBACK_TASK_MANUAL        6234  //add record passback task
#define NET_DVR_GET_ALL_RECORD_PASSBACK_TASK_MANUAL    6235  //get all record passback task
#define NET_DVR_RECORD_PASSBACK_TASK_MANUAL_CTRL    6236  //record passback control
#define NET_DVR_DEL_RECORD_PASSBACK_TASK_MANUAL        6237  //delete record passback task
#define NET_DVR_GET_RECORD_PASSBACK_PLAN_CFG        6238  //get reocrd passback plan config
#define NET_DVR_SET_RECORD_PASSBACK_PLAN_CFG        6239  //set reocrd passback plan config
#define NET_DVR_GET_DEV_STORAGE_CFG                    6240  //get device storage config
#define NET_DVR_GET_ONLINE_USER_CFG                    6241  //get online user config
#define NET_DVR_GET_RECORD_SEGMENT_CFG                6242  //get all record segment

#define NET_DVR_GET_REC_PASSBACK_TASK_EXECUTABLE    6243    //search manual passback task executable 
#define NET_DVR_GET_STREAM_MEDIA_CFG                6244    //get record passback by stream config(stream ID)
#define NET_DVR_SET_STREAM_MEDIA_CFG                6245    //set record passback by stream config(stream ID)
#define NET_DVR_GET_USERCFG_V50                     6246  //get User config V50
#define NET_DVR_SET_USERCFG_V50                     6247  //set User config V50

#define NET_DVR_GET_RECORD_PASSBACK_BASIC_CFG_CAP    6248  //get ability to function based configuration CVR comes back 
#define NET_DVR_GET_RECORD_PASSBACK_BASIC_CFG        6249  //get CVR back function based configuration 
#define NET_DVR_SET_RECORD_PASSBACK_BASIC_CFG        6250  //set CVR back function based configuration
#define NET_DVR_ONE_KEY_CONFIG_V50                    6251  //one key configuration CVR (V50) 
#define NET_DVR_GET_RACM_CAP                        6252  //get the total capacity (RACM) 
#define NET_DVR_GET_THUMBNAILS                        6253  //download time interval thumbnail (support flow ID) 
#define NET_DVR_ADD_RECORD_PASSBACK_TASK_MANUAL_V50        6254  //add record passback task (V50)
#define NET_DVR_GET_RECORD_PASSBACK_HISTORY_PLAN_CFG_CAP    6255  //Get CVR back history record planning ability 
#define NET_DVR_GET_RECORD_PASSBACK_HISTORY_PLAN_CFG        6256  //Get CVR back history record planning configuration 
#define NET_DVR_SET_RECORD_PASSBACK_HISTORY_PLAN_CFG        6257  //Set CVR back history record planning configuration 
#define NET_DVR_ONE_KEY_CONFIG_V51                          6258  //one key configuration CVR (V51) 

#define NET_DVR_GET_RECORD_PACK                     6301    //Get video package parameters
#define NET_DVR_SET_RECORD_PACK                    6302    //Set video package parameters
#define NET_DVR_GET_CLOUD_STORAGE_CFG           6303     //Get Dev Cur Work Mode
#define NET_DVR_SET_CLOUD_STORAGE_CFG           6304    //Set Dev Cur Work Mode
#define NET_DVR_GET_GOP_INFO                    6305    //Get GOP Info
#define NET_DVR_GET_PHY_DISK_INFO               6306    //Get physical disk info     

#define NET_DVR_GET_RECORDING_AUTO_TRACK_CFG    6307    //Get SDI config
#define NET_DVR_SET_RECORDING_AUTO_TRACK_CFG    6308    //Set SDI config

#define NET_DVR_GET_RECORDING_PUBLISH_CFG        6309  //Get one key publish info 
#define NET_DVR_SET_RECORDING_PUBLISH_CFG        6310  //Set one key publish info

#define NET_DVR_RECORDING_ONEKEY_CONTROL        6311  //recording host control

#define NET_DVR_GET_RECORDING_END_TIME        6312  //get recording remaining time

#define NET_DVR_RECORDING_PUBLISH                6313  //one key publish record

#define NET_DVR_GET_CURRICULUM_CFG            6314    //Get course config
#define NET_DVR_SET_CURRICULUM_CFG            6315    //Set course config

#define NET_DVR_GET_COURSE_INDEX_CFG        6316    //Get course index
#define NET_DVR_SET_COURSE_INDEX_CFG        6317  //Set course index

#define    NET_DVR_GET_PPT_CHANNEL                6318    //get PPT channel
#define    NET_DVR_GET_PPT_DETECT_CFG            6319    //get PPT detect param
#define    NET_DVR_SET_PPT_DETECT_CFG            6320    //set PPT detect param

#define NET_DVR_GET_RECORDINGHOST_CFG        6321    //Get record host config
#define NET_DVR_SET_RECORDINGHOST_CFG        6322    //Set record host config
#define NET_DVR_GET_BACKUP_RECORD_CFG           6323    //Get backup record Cfg
#define NET_DVR_SET_BACKUP_RECORD_CFG           6324    //Set backup record Cfg


#define NET_DVR_GET_AUDIO_ACTIVATION_CFG        6326    //get audio activation cfg
#define NET_DVR_SET_AUDIO_ACTIVATION_CFG        6327    //set audio activation cfg
#define NET_DVR_GET_DECODERCFG_V40              6328    //get decodercfg v40
#define NET_DVR_SET_DECODERCFG_V40                6329    //set decodercfg v40

#define NET_DVR_INFRARED_OUTPUT_CONTROL         6330   //infrared output control
#define NET_DVR_GET_INFRARED_CMD_NAME_CFG       6331   //get infrared cmd name cfg
#define NET_DVR_SET_INFRARED_CMD_NAME_CFG       6332   //set infrared cmd name cfg
#define NET_DVR_START_INFRARED_LEARN            6333   //infrared learn
#define NET_DVR_GET_TRIAL_SYSTEM_CFG            6334   //get trial system cfg
#define NET_DVR_SET_CASE_INFO                    6335    //case info
#define NET_DVR_GET_TRIAL_MICROPHONE_STATUS        6336  //get microphone status
#define NET_DVR_SET_TRIAL_MICROPHONE_STATUS        6337  //set microphone status
#define NET_DVR_GET_TRIAL_HOST_STATUS            6338  //get trial host status
#define NET_DVR_GET_LAMP_OUT                    6339  //get lamp out
#define NET_DVR_SET_LAMP_OUT                    6340  //set lamp out
#define NET_DVR_LAMP_REMOTE_CONTROL                6341  // LAMP control
#define NET_DVR_REMOTE_CONTROL_PLAY                6342  //remote control
#define NET_DVR_GET_LOCAL_INPUT_CFG                6343  //get local input cfg
#define NET_DVR_SET_LOCAL_INPUT_CFG                6344  //set local input cfg
#define NET_DVR_GET_CASE_INFO                    6345  //get case info

#define NET_DVR_INQUEST_GET_CDW_STATUS         6350  
#define NET_DVR_GET_MIX_AUDIOIN_CFG             6351  //Get mix audioin Cfg
#define NET_DVR_SET_MIX_AUDIOIN_CFG             6352  //Set mix audioin Cfg
#define NET_DVR_GET_MIX_AUDIOOUT_CFG            6353  //Get mix audioout Cfg
#define NET_DVR_SET_MIX_AUDIOOUT_CFG            6354  //Set mix audioout Cfg
#define NET_DVR_GET_AUDIOIN_VOLUME_CFG          6355  //Get AudioIn Volume Cfg
#define NET_DVR_SET_AUDIOIN_VOLUME_CFG          6356  //Set AudioIn Volume Cfg
#define NET_DVR_GET_AREA_MASK_CFG               6357  //Get Mask Area Cfg
#define NET_DVR_SET_AREA_MASK_CFG               6358  //Set Mask Area Cfg
#define NET_DVR_GET_AUDIO_DIACRITICAL_CFG       6359  //Get Audio Diacritical Cfg
#define NET_DVR_SET_AUDIO_DIACRITICAL_CFG       6360  //Set Audio Diacritical Cfg
#define NET_DVR_GET_WIFI_DHCP_ADDR_CFG          6361  //Get WIFI DHCP addr Cfg
#define NET_DVR_SET_WIFI_DHCP_ADDR_CFG          6362  //Set Get WIFI DHCP addr
#define NET_DVR_GET_WIFI_CLIENT_LIST_INFO       6363  //Get Wifi Client List
#define NET_DVR_REMOTECONTROL_POWER_ON            6364  //remote  control power on
#define NET_DVR_GET_MULTISTREAM_RELATION_CHAN_CFG      6365  //Get Multi Stream relate Channel Cfg
#define NET_DVR_SET_MULTISTREAM_RELATION_CHAN_CFG     6366  //Set Multi Stream relate Channel Cfg
#define NET_DVR_GET_VIDEOOUT_RESOLUTION_CFG        6367  //Get Local videoout resolution Cfg
#define NET_DVR_SET_VIDEOOUT_RESOLUTION_CFG        6368  //Set Local videoout resolution Cfg
#define NET_DVR_GET_AUDIOOUT_VOLUME_CFG         6369 //Get AudioOut Volume Cfg
#define NET_DVR_SET_AUDIOOUT_VOLUME_CFG         6370 //Set AudioOut Volume Cfg
#define NET_DVR_INQUEST_PAUSE_CDW               6371  //pause CDW
#define NET_DVR_INQUEST_RESUME_CDW              6372  //Resume CDW
#define NET_DVR_GET_INPUT_CHAN_CFG              6373  //Get Input Channel Cfg
#define NET_DVR_SET_INPUT_CHAN_CFG              6374  //Set Input Channel Cfg

#define NET_DVR_GET_INQUEST_MIX_AUDIOIN_CFG        6375    //Get inquest mix audioIn Cfg 
#define NET_DVR_SET_INQUEST_MIX_AUDIOIN_CFG        6376    //Set inquest mix audioIn Cfg
#define    NET_DVR_CASE_INFO_CTRL                    6377    //case info control 
#define NET_DVR_GET_INQUEST_USER_RIGHT            6378    //Get inquest user right Cfg
#define NET_DVR_SET_INQUEST_USER_RIGHT            6379    //Set inquest user right Cfg
#define NET_DVR_GET_INQUEST_CASE_INFO            6380    //Get inquest case info
#define NET_DVR_SET_INQUEST_CASE_INFO            6381    //Set inquest case info

#define    NET_DVR_GET_FILM_MODE_CFG               6387    //Get Film Mode Cfg
#define    NET_DVR_SET_FILM_MODE_CFG               6388    //Set Film Mode Cfg
#define    NET_DVR_GET_FILM_MODE_CFG_CAP            6389    //Set Film Mode Capabilities

#define    NET_DVR_GET_DIRECTED_STRATEGY_CFG       6390    //Get Directed Strategy Cfg
#define    NET_DVR_SET_DIRECTED_STRATEGY_CFG        6391    //Set Directed Strategy Cfg
#define    NET_DVR_GET_DIRECTED_STRATEGY_CFG_CAP    6392    //Get Directed Strategy Capabilities
#define    NET_DVR_GET_FRAME_CFG                    6393    //Get Frame Cfg
#define    NET_DVR_SET_FRAME_CFG                    6394    //Set Frame Cfg
#define    NET_DVR_GET_FRAME_CFG_CAP                6395    //Get Frame Capabilities

#define    NET_DVR_GET_AUDIO_EFFECTIVE_CFG            6396    //Get Audio Effective Cfg
#define    NET_DVR_SET_AUDIO_EFFECTIVE_CFG            6397    //Set Audio Effective Cfg
#define    NET_DVR_GET_AUDIO_EFFECTIVE_CFG_CAP        6398    //Get Audio Effective Capabilities
#define    NET_DVR_GET_RECORD_VIDEO_CFG              6399    //Get Record Video Cfg
#define    NET_DVR_SET_RECORD_VIDEO_CFG            6400    //Set Record Video Cfg


#define NET_DVR_GET_OUTPUT_CFG              6401       //get output config
#define NET_DVR_SET_OUTPUT_CFG              6402       //set output config
#define NET_DVR_CODER_DISPLAY_START         6403       //start display
#define NET_DVR_CODER_DISPLAY_STOP          6404       //stop display
#define NET_DVR_GET_WINDOW_STATUS           6405       //get display window status

#define NET_DVR_GET_VQD_LOOP_DIAGNOSE_CFG   6406        //Get VQD Loop Diagnose Cfg 
#define NET_DVR_SET_VQD_LOOP_DIAGNOSE_CFG   6407        //Set VQD Loop Diagnose Cfg 
#define NET_DVR_GET_VQD_DIAGNOSE_INFO       6408        //Manually get VQD diagnose info

#define    NET_DVR_RECORDING_PUBLISH_FILE            6421        //Set Recording Publish File
#define    NET_DVR_GET_RECORDING_PUBLISH_FILE_CAP    6422        //Get Recording Publish File Capabilities
#define    NET_DVR_GET_PUBLISH_PROGRESS            6423           //Get Publish Progress
#define    NET_DVR_GET_RECORD_VIDEO_CFG_CAP    6424        //Get Record Video Capabilities
#define    NET_DVR_GET_RTMP_CFG                6425        //Get RTMP Cfg
#define    NET_DVR_SET_RTMP_CFG                6426        //Set RTMP Cfg
#define    NET_DVR_GET_RTMP_CFG_CAP            6427        //Get RTMP Capabilities
#define    NET_DVR_DEL_BACKGROUND_PIC                6428        //Delect BackGround Picture
#define    NET_DVR_GET_BACKGROUND_PIC_CFG            6429    //Get BackGround Picture 
#define    NET_DVR_GET_BACKGROUND_PIC_INFO            6430        //Get BackGround Picture Info
#define    NET_DVR_SET_BACKGROUND_PIC_INFO            6431        //Set BackGround Picture Info
#define    NET_DVR_GET_BACKGROUND_PIC_INFO_CAP      6432           //Get BackGround Picture Info Capabilities
#define    NET_DVR_GET_RECORD_HOST_CAP                6433        //Get Record Host Capabilities
#define NET_DVR_GET_COURSE_LIST                 6434    //get course list
#define    NET_DVR_GET_RECORD_STATUS                6435 //get record status
#define    NET_DVR_MANUAL_CURRICULUM_CONTROL        6436    //manual curriculum control
#define    NET_DVR_GET_IMAGE_DIFF_DETECTION_CFG        6437    //get image diff detection cfg
#define    NET_DVR_SET_IMAGE_DIFF_DETECTION_CFG        6438    //set image diff detection cfg
#define    NET_DVR_GET_IMAGE_DIFF_DETECTION_CFG_CAP    6439    //get image diff detection cfg Capabilities
#define    NET_DVR_GET_RECORDING_PUBLISH_FILE_INFO    6440    //get recording publish file cfg
#define    NET_DVR_SET_RECORDING_PUBLISH_FILE_INFO    6441    //set recording publish file cfg
#define    NET_DVR_GET_RECORDING_PUBLISH_FILE_INFO_CAP        6442    //get recording publish file cfg Capabilities
#define    NET_DVR_MANUAL_CURRICULUM_CONTROL_CAP        6443    //get manual curriculum control Capabilities
#define NET_DVR_GET_STATISTIC_DATA_LIST             6444    //get list statistics 

#define    NET_DVR_GET_DEVICE_LAN_ENCODE        6501        //get device language encode format
#define NET_DVR_GET_GBT28181_SERVICE_CFG        6503    //Get GB28181 Server Cfg
#define NET_DVR_SET_GBT28181_SERVICE_CFG        6504    //Set GB28181 Server Cfg
#define NET_DVR_GET_GBT28181_SERVICE_CAPABILITIES 6505  //Get GB28181 Server Capabilities

#define NET_DVR_GET_CLOUD_URL               6506    //get cloud storage url
#define NET_DVR_GET_CLOUD_URL_CAP           6507    //get cloud storage url-ability
#define NET_DVR_GET_CLOUD_CFG               6508    //get cloud storage configure parameter
#define NET_DVR_SET_CLOUD_CFG               6509    //set cloud storage configure parameter
#define NET_DVR_GET_CLOUD_CFG_CAP           6510    //get cloud storage configure parameter-ability
#define NET_DVR_GET_CLOUD_UPLOADSTRATEGY    6511    //get cloud storage upload strategy
#define NET_DVR_SET_CLOUD_UPLOADSTRATEGY    6512    //set cloud storage upload strategy
#define NET_DVR_GET_CLOUDSTORAGE_UPLOADSTRATEGY_CAP     6513    //cloud storage upload strategy-ability

#define    NET_DVR_GET_VIDEO_IMAGE_DB_CFG        6601        //Get Video Image DB CFG
#define    NET_DVR_SET_VIDEO_IMAGE_DB_CFG        6602        //Set Video Image DB CFG
#define    NET_DVR_GET_VIDEO_IMAGE_DB_CFG_CAP    6603        //Get Video Image DB CFG Capabilities
#define    NET_DVR_GET_FILE_INFO_BY_ID            6604        //Get File Info
#define    NET_DVR_QUERY_FILE_INFO_CAP            6605        //Get File Info Capabilities
#define    NET_DVR_DEL_FILE_FROM_DB            6606        //Del File From DB
#define    NET_DVR_GET_VIDEO_IMAGE_DB_CAP        6607        //Get Video All Capabilities

#define NET_DVR_GET_FIGURE                    6610        //Get Figure picture

#define    NET_DVR_SYNC_IPC_PASSWD                  6621    //Sync IPC PASSWORD
#define    NET_DVR_GET_VEHICLE_BLACKLST_SCHEDULE 6622    //Get Blacklist schedule
#define    NET_DVR_SET_VEHICLE_BLACKLST_SCHEDULE 6623    //Set Blacklist schedule
#define    NET_DVR_GET_VEHICLE_WHITELST_SCHEDULE 6624    //Get Whitelist schedule
#define    NET_DVR_SET_VEHICLE_WHITELST_SCHEDULE 6625    //Set Whitelist schedule

#define    NET_DVR_GET_VEHICLE_BLACKLIST_EVENT_TRIGGER     6626    //Get black list event
#define    NET_DVR_SET_VEHICLE_BLACKLIST_EVENT_TRIGGER     6627    //Set black list event

#define    NET_DVR_GET_VEHICLE_WHITELIST_EVENT_TRIGGER     6628    //Get white list event
#define    NET_DVR_SET_VEHICLE_WHITELIST_EVENT_TRIGGER     6629    //Set white list event


#define    NET_DVR_GET_TRAFFIC_CAP                         6630    //Get traffic cap
#define    NET_DVR_GET_VEHICLE_ALLLIST_EVENT_TRIGGER     6631    //Get All VehicleList Event Trigger Cfg
#define    NET_DVR_SET_VEHICLE_ALLLIST_EVENT_TRIGGER     6632    //Set All VehicleList Event Trigger Cfg
#define    NET_DVR_GET_VEHICLE_OTHERLIST_EVENT_TRIGGER     6633    //Get Other VehicleList Event Trigger Cfg
#define    NET_DVR_SET_VEHICLE_OTHERLIST_EVENT_TRIGGER     6634    //Set Other VehicleList Event Trigger Cfg

#define    NET_DVR_GET_STORAGEDETECTION_EVENT_TRIGGER     6635    //Get Storage Detection Event Trigger
#define    NET_DVR_SET_STORAGEDETECTION_EVENT_TRIGGER     6636    //Set Storage Detection Event Trigger
#define    NET_DVR_GET_STORAGEDETECTION_SCHEDULE_CAPABILITIES    6637    //Get Storage Detection Schedule Capabilities
#define    NET_DVR_GET_STORAGEDETECTION_SCHEDULE         6638    //Get Storage Detection Schedule
#define    NET_DVR_SET_STORAGEDETECTION_SCHEDULE         6639    //Set Storage Detection Schedule
#define    NET_DVR_GET_STORAGEDETECTION_STATE             6640    //Get Storage Detection State


#define    NET_DVR_GET_STORAGEDETECTION_RWLOCK             6646    //Get Storage Detection RwLock
#define    NET_DVR_GET_STORAGEDETECTION_RWLOCK_CAPABILITIES    6647    //Get Storage Detection RwLock Capabilities
#define    NET_DVR_SET_STORAGEDETECTION_RWLOCK             6648    //Set Storage Detection RwLock
#define    NET_DVR_GET_PTZTRACKSTATUS                     6649    //Get Ptz Track Status


#define    NET_DVR_SET_STORAGEDETECTION_UNLOCK             6653    //Set Storage Detection UnLock
#define    NET_DVR_GET_STORAGEDETECTION_UNLOCK_CAPABILITIES    6654    //Get Storage Detection UnLock Capabilities

#define    NET_DVR_SET_SHIPSDETECTION_CFG                 6655    //Set the ship detection parameter configuration 
#define    NET_DVR_GET_SHIPSDETECTION_CFG                 6656    //Get ship detection parameter configuration 
#define    NET_DVR_GET_SHIPSDETECTION_CAPABILITIES         6657    //Get ship detection parameters configuration ability 
#define    NET_DVR_GET_SHIPSDETECTION_COUNT               6658    //Get ships counting information 
#define    NET_DVR_SHIPSCOUNT_DELETE_CTRL                  6659   //Empty vessels counting information

#define    NET_DVR_GET_BAREDATAOVERLAY_CAPABILITIES     6660   //Get Bare Data Overlay Capablities
#define    NET_DVR_SET_BAREDATAOVERLAY_CFG                 6661    //Set Bare Data Overlay Cfg
#define    NET_DVR_GET_BAREDATAOVERLAY_CFG                 6662    //Get Bare Data Overlay Cfg
#define    NET_DVR_GET_SHIPSDETECTION_SCHEDULE             6663    //Get ship detection protection time configuration 
#define    NET_DVR_SET_SHIPSDETECTION_SCHEDULE             6664    //Set the ship detection protection time configuration
#define NET_DVR_GET_SHIPSDETECTION_EVENT_TRIGGER     6665    //Get ships to detect linkage configuration  
#define    NET_DVR_SET_SHIPSDETECTION_EVENT_TRIGGER     6666    //Set the ship detection linkage configuration 
#define    NET_DVR_GET_SHIPSDETECTION_SCHEDULE_CAPABILITIES    6667    //Get ship detection protection time ability 

#define    NET_DVR_FIRE_FOCUSZOOM_CTRL                  6670   //Fire Focus Zoom Ctrl
#define    NET_DVR_GET_FIREDETECTION_SCHEDULE_CAPABILITIES    6671 //Get fire detection protection time ability
#define    NET_DVR_GET_FIREDETECTION_SCHEDULE    6672    //Get fire detection protection time configuration
#define    NET_DVR_SET_FIREDETECTION_SCHEDULE    6673    //Set fire detection protection time configuration
#define    NET_DVR_GET_MANUALRANGING_CAPABILITIES    6675    //Get Manual Rangin Capbailities


#define    NET_DVR_SET_MANUALRANGING           6677        //Set Manual Rangin
#define    NET_DVR_GET_MANUALDEICING_CAPABILITIES    6678    //Get Manual Deicing capabilities
#define    NET_DVR_SET_MANUALDEICING           6679        //Set Manual Deicing
#define    NET_DVR_GET_MANUALDEICING           6680        //Get Manual Deicing

#define    NET_DVR_GET_THERMALPOWER_CAPABILITIES   6689    //Get Thermal power capablities
#define    NET_DVR_GET_THERMALPOWER                6690    //Get Thermal power
#define    NET_DVR_SET_THERMALPOWER                6691    //Set Thermal power
#define    NET_DVR_GET_PTZABSOLUTEEX_CAPABILITIES  6695    //GET absolute PTZ ex cability
#define    NET_DVR_GET_PTZABSOLUTEEX               6696    //GET absolute PTZ ex config
#define    NET_DVR_SET_PTZABSOLUTEEX               6697    //SET absolute PTZ ex config

#define    NET_DVR_GET_CRUISE_CAPABILITIES              6698    //Get equipment cruise mode configuration 
#define    NET_DVR_GET_CRUISE_INFO                      6699    //Get equipment cruise mode 
#define    NET_DVR_GET_TEMP_HUMI_CAPABILITIES           6700    //Get temperature and humidity real-time ability 
#define  NET_DVR_GET_TEMP_HUMI_INFO                  6701   //Get temperature and humidity real-time

#define    NET_DVR_GET_MANUALTHERM_INFO                 6706   //Get manual temperature measurement in real time 
#define    NET_DVR_GET_MANUALTHERM_CAPABILITIES         6707   //Get manual measuring temperature real-time ability 
#define    NET_DVR_SET_MANUALTHERM                      6708     //Set manual temperature measurement data 

//NVR - 96000
#define    NET_DVR_GET_ACCESSORY_CARD_INFO_CAPABILITIES    6709 //Accessories plate information ability
#define    NET_DVR_GET_ACCESSORY_CARD_INFO                    6710 //For accessories plate information 

#define    NET_DVR_GET_THERMINTELL_CAPABILITIES            6711 //Get thermal intelligent configuration capbailities
#define    NET_DVR_GET_THERMINTELL                         6712 //Get thermal intelligent configuration parameters 
#define    NET_DVR_SET_THERMINTELL                         6713 //Set thermal intelligent configuration parameters 
#define NET_GET_CRUISEPOINT_V50                         6714     //Cruise Point V50
#define    NET_DVR_GET_MANUALTHERM_BASIC_CAPABILITIES        6715   //Get temperature measuring basic parameters configuration manually
#define    NET_DVR_SET_MANUALTHERM_BASICPARAM              6716     //Set the manual temperature measuring basic parameters 
#define    NET_DVR_GET_MANUALTHERM_BASICPARAM              6717     //Get the manual temperature measuring basic parameters 

#define    NET_DVR_GET_FIRESHIELDMASK_CAPABILITIES            6718 

#define NET_DVR_GET_HIDDEN_INFORMATION_CAPABILITIES    6720 //The allocation of hidden information capacity 
#define NET_DVR_GET_HIDDEN_INFORMATION                 6721 //get Hidden information parameters 
#define NET_DVR_SET_HIDDEN_INFORMATION                 6722 //Set the hidden information parameters 

#define    NET_DVR_SET_FIRESHIELDMASK_CFG                  6723    
#define    NET_DVR_GET_FIRESHIELDMASK_CFG                  6724     
#define    NET_DVR_GET_SMOKESHIELDMASK_CAPABILITIES            6725   
#define    NET_DVR_SET_SMOKESHIELDMASK_CFG                     6726     
#define    NET_DVR_GET_SMOKESHIELDMASK_CFG                     6727        

#define    NET_DVR_GET_AREASCAN_CAPABILITIES                  6728        
#define    NET_DVR_GET_AREASCAN_CFG                          6730        

#define    NET_DVR_DEL_AREASCAN_CFG                          6731        
#define    NET_DVR_AREASCAN_INIT_CTRL                        6732       
#define    NET_DVR_AREASCAN_CONFIRM_CTRL                     6733        
#define    NET_DVR_AREASCAN_STOP_CTRL                        6734        
#define    NET_DVR_SAVE_SCANZOOM_CTRL                        6735        
#define    NET_DVR_GET_SCANZOOM_CTRL                         6736 
#define    NET_DVR_DEL_FIRESHIELDMASK_CTRL                   6737        
#define    NET_DVR_DEL_SMOKESHIELDMASK_CTRL                  6738

#define    NET_DVR_GET_DENSEFOG_EVENT_TRIGGER     6740    //Get dense fog to detect linkage configuration
#define    NET_DVR_SET_DENSEFOG_EVENT_TRIGGER     6741    //Set dense fog to detect linkage configuration
#define    NET_DVR_SET_DENSEFOGDETECTION_CFG    6742    //Get dense fog to detect parameters configuration
#define    NET_DVR_GET_DENSEFOGDETECTION_CFG    6743    //Set dense fog to detect parameters configuration
#define    NET_DVR_GET_DENSEFOGDETECTION_CAPABILITIES    6744    //Get dense fog to detect parameters configuration capacity

#define    NET_DVR_GET_THERMOMETRY_SCHEDULE_CAPABILITIES    6750 //Get Temperature detection protection time ability
#define    NET_DVR_GET_THERMOMETRY_SCHEDULE    6751    //Get Temperature detection protection time configuration 
#define    NET_DVR_SET_THERMOMETRY_SCHEDULE    6752    //SetTemperature detection protection time configuration 
#define    NET_DVR_GET_TEMPERTURE_SCHEDULE_CAPABILITIES    6753 //Get differential protection time ability 
#define    NET_DVR_GET_TEMPERTURE_SCHEDULE    6754    //Get differential protection time configuration 
#define    NET_DVR_SET_TEMPERTURE_SCHEDULE    6755    //SetDifferential protection time configuration 
#define NET_DVR_GET_SEARCH_LOG_CAPABILITIES        6756    //Log types support ability
#define    NET_DVR_GET_VEHICLEFLOW    6758    //Get vehicle flow configuration
#define NET_DVR_GET_IPADDR_FILTERCFG_V50        6759  //Get IP address filter configuration
#define NET_DVR_SET_IPADDR_FILTERCFG_V50        6760  //Get IP address filter configuration 
#define    NET_DVR_GET_TEMPHUMSENSOR_CAPABILITIES    6761//Get temperature and humidity sensor capabilities
#define    NET_DVR_GET_TEMPHUMSENSOR    6762    //Get temprature and humidity sensor configuration
#define    NET_DVR_SET_TEMPHUMSENSOR    6763    //Set temprature and humidity sensor configuration

#define    NET_DVR_GET_THERMOMETRY_MODE_CAPABILITIES  6764  //Get Thermometry Mode Capability
#define    NET_DVR_GET_THERMOMETRY_MODE               6765  //Get Thermometry Mode
#define    NET_DVR_SET_THERMOMETRY_MODE               6766  //Set Thermometry Mode

#define    NET_DVR_GET_THERMAL_PIP_CAPABILITIES    6767    //Get thermal imaging picture in picture configuration ability 
#define    NET_DVR_GET_THERMAL_PIP   6768    //Get thermal imaging picture in picture configuration parameters 
#define    NET_DVR_SET_THERMAL_PIP   6769    //Set thermal imaging picture in picture configuration parameters 
#define    NET_DVR_GET_THERMAL_INTELRULEDISPLAY_CAPABILITIES    6770    //Get thermal imaging smart rules display ability 
#define    NET_DVR_GET_THERMAL_INTELRULE_DISPLAY   6771    //Get thermal imaging smart rules display parameters
#define    NET_DVR_SET_THERMAL_INTELRULE_DISPLAY   6772    //Set thermal imaging smart rules display parameters
#define    NET_DVR_GET_THERMAL_ALGVERSION   6773   //Get thermal Algorithm library Version
#define    NET_DVR_GET_CURRENT_LOCK_CAPABILITIES    6774    //Get Current Lock Capabilities
#define    NET_DVR_GET_CURRENT_LOCK   6775    //Get Current Lock Cfg
#define    NET_DVR_SET_CURRENT_LOCK   6776    //Set Current Lock Cfg

#define    NET_DVR_DEL_MANUALTHERM_RULE  6778  //Delete Manual Therm Rule
#define NET_DVR_GET_UPGRADE_INFO    6779    //Get upgrade information

#define    NET_DVR_SWITCH_TRANSFER  7000  

#define NET_DVR_GET_MB_POWERCTRLPARA            8000//get start control parm
#define    NET_DVR_SET_MB_POWERCTRLPARA            8001//set start control parm
#define NET_DVR_GET_AUTOBACKUPPARA                8002//get auto backup parm
#define NET_DVR_SET_AUTOBACKUPPARA                8003//set auto backup parm
#define NET_DVR_GET_MB_GPSPARA                    8004//get GPS parm
#define NET_DVR_SET_MB_GPSPARA                    8005//set GPS parm
#define NET_DVR_GET_MB_SENSORINPARA                8006//get SENSOR parm 
#define NET_DVR_SET_MB_SENSORINPARA                8007//set SENSOR parm
#define NET_DVR_GET_GSENSORPARA                    8008//get GSENSOR parm
#define NET_DVR_SET_GSENSORPARA                    8009//set GSENSORparm
#define NET_DVR_GET_MB_DOWNLOADSVRPARA            8010//get load server parm
#define NET_DVR_SET_MB_DOWNLOADSVRPARA            8011//set load server parm
#define NET_DVR_GET_PLATERECOG_PARA                8012//get License plate recognition parm
#define NET_DVR_SET_PLATERECOG_PARA                8013//set License plate recognition parm
#define NET_DVR_GET_ENFORCESYS_PARA                8014//get Vehicle inspection parm
#define NET_DVR_SET_ENFORCESYS_PARA                8015//set Vehicle inspection parm
#define NET_DVR_GET_GPS_DATA                    8016 //get GPS parm 
#define NET_DVR_GET_ANALOG_ALARMINCFG            8017//get analog alarm in parm
#define NET_DVR_SET_ANALOG_ALARMINCFG            8018//set analog alarm in parm

#define NET_DVR_GET_SYSTEM_CAPABILITIES         8100 //Access to system capacity of the equipment 
#define NET_DVR_GET_EAGLEEYE_CAPABILITIES       8101 //Acquire equipment eagle eye 
#define NET_DVR_GET_SLAVECAMERA_CALIB_V51       8102    //get camera calibration configuration V51
#define NET_DVR_SET_SLAVECAMERA_CALIB_V51       8103    //set the camera calibration configuration V51
#define NET_DVR_SET_GOTOSCENE                   8105  //Set the main camera to the specified scenario ID

//I, K, E series NVR product upgrade 
#define NET_DVR_GET_PTZ_NOTIFICATION        8201//Get multi-channel linkage PTZ events
#define NET_DVR_SET_PTZ_NOTIFICATION        8202//Set multi-channel linkage PTZ events
/*****************************video start****************************/
#define    NET_DVR_MATRIX_WALL_SET                    9001  //set video wall configuration
#define    NET_DVR_MATRIX_WALL_GET                    9002  //get video wall configuration
#define    NET_DVR_WALLWIN_GET                        9003  //get video wall window configuration 
#define    NET_DVR_WALLWIN_SET                        9004  //set video wall window configuration 
#define    NET_DVR_WALLWINPARAM_SET                9005  //set video wall related parameter
#define    NET_DVR_WALLWINPARAM_GET                9006  //get video wall related parameter
#define NET_DVR_WALLSCENEPARAM_GET                9007  //get scene parameter
#define NET_DVR_WALLSCENEPARAM_SET                9008  //set scene parameter
#define NET_DVR_MATRIX_GETWINSTATUS             9009  //get window decode status
#define    NET_DVR_GET_WINASSOCIATEDDEVINFO        9010  //get resource information associated with the window in video wall
#define    NET_DVR_WALLOUTPUT_GET                    9011  //get output configuration
#define    NET_DVR_WALLOUTPUT_SET                    9012  //set output configuration
#define NET_DVR_GET_UNITEDMATRIXSYSTEM          9013  //get video platform united system info
#define NET_DVR_GET_WALL_CFG                    9014  //get wall param
#define NET_DVR_SET_WALL_CFG                    9015  //set wall param
#define NET_DVR_CLOSE_ALL_WND                    9016  //close all window
#define NET_DVR_SWITCH_WIN_TOP                  9017  //move window to top layer
#define NET_DVR_SWITCH_WIN_BOTTOM               9018  //move window to bottom layer
#define    NET_DVR_CLOSE_ALL_WND_V41                9019  //close all windows in the wall
#define    NET_DVR_GET_WALL_WINDOW_V41                9020  //get windows in the wall
#define    NET_DVR_SET_WALL_WINDOW_V41                9021  //set windows in the wall
#define    NET_DVR_GET_CURRENT_SCENE_V41            9022  //get current scene 
#define    NET_DVR_GET_WALL_SCENE_PARAM_V41        9023  //get wall scene
#define    NET_DVR_SET_WALL_SCENE_PARAM_V41        9024  //set wall scene
#define NET_DVR_GET_MATRIX_LOGO_CFG             9025  //set logo configuration
#define NET_DVR_SET_MATRIX_LOGO_CFG             9026  //get logo configuration
#define NET_DVR_GET_WIN_LOGO_CFG                9027  //get window logo configuration
#define NET_DVR_SET_WIN_LOGO_CFG                9028  //set window logo configuration
#define NET_DVR_DELETE_LOGO                     9029  //delete logo
#define NET_DVR_SET_DISPLAY_EFFECT_CFG            9030  //set display effect v41
#define NET_DVR_GET_DISPLAY_EFFECT_CFG            9031  //get display effect v41
#define NET_DVR_DEC_PLAY_REMOTE_FILE            9032  //decoder play remote file
#define NET_DVR_DEC_PLAY_REMOTE_FILE_V50        9314  //decoder play remote file V50
#define NET_DVR_GET_WIN_ZOOM_STATUS             9033  //get window electronic enlargement status
#define NET_DVR_GET_ALL_MATRIX_LOGOCFG          9034  //get all logos' configuration
/*****************************video end******************************/

/***********************************LCD Screen begin********************************/
#define NET_DVR_SIMULATE_REMOTE_CONTROL         9035    //Simulate Remote Control 2013-09-05
#define NET_DVR_SET_SCREEN_SIGNAL_CFG            9036    //Set Screen Signal CFG
#define    NET_DVR_GET_SCREEN_SIGNAL_CFG            9037    //Get Screen Signal CFG
#define NET_DVR_SET_SCREEN_SPLICE_CFG              9038    //Set Screen Splice CFG
#define    NET_DVR_GET_SCREEN_SPLICE_CFG            9039    //Get Screen Splice CFG
#define NET_DVR_GET_SCREEN_FAN_WORK_MODE         9040    //Get Screen Fan Work Mode
#define NET_DVR_SET_SCREEN_FAN_WORK_MODE         9041    //Set Screen Fan Work Mode
//#define NET_DVR_UPGRADE_LCD                      9042    //LCD Upgrade
#define NET_DVR_SHOW_SCREEN_WORK_STATUS          9044    //Show Screen Work Status
#define NET_DVR_GET_VGA_CFG                      9045    //Get VGA 
#define NET_DVR_SET_VGA_CFG                      9046    //Set VGA
#define NET_DVR_GET_SCREEN_MENU_CFG                9048    //Get Screen Menu
#define NET_DVR_SET_SCREEN_MENU_CFG              9049    //Set Screen Menu
#define NET_DVR_SET_SCREEN_DISPLAY_CFG          9050    //set screen display CFG 2013-08-28
#define    NET_DVR_GET_SCREEN_DISPLAY_CFG            9051    //get screen display CFG 2013-08-28
#define NET_DVR_SET_FUSION_CFG                    9052    //set picture fusion configuration
#define NET_DVR_GET_FUSION_CFG                    9053    //get picture fusion configuration
#define NET_DVR_SET_PIP_CFG                      9060    //Set Pip Cfg
#define    NET_DVR_GET_PIP_CFG                        9061    //Get Pip Cfg
#define NET_DVR_SET_DEFOG_LCD                      9073    //Set Defog 
#define    NET_DVR_GET_DEFOG_LCD                    9074    //Get Defog 
#define NET_DVR_SHOW_IP                          9075    //Show IP
#define NET_DVR_SCREEN_MAINTENANCE_WALL            9076    //Screen Maintenance Wall
#define NET_DVR_SET_SCREEN_POS                  9077    //Set Screen Pos
#define    NET_DVR_GET_SCREEN_POS                    9078    //Get Screen Pos
/***********************************LCD Screen end********************************/

/*******************************LCD Screen V1.2 begin******************************************/
#define    NET_DVR_SCREEN_INDEX_SET                9079    //Set screen index parameter
#define    NET_DVR_SCREEN_INDEX_GET                9080    //Get screen index parameter
#define NET_DVR_SCREEN_SPLICE_SET               9081    //Set screen splice parameter
#define NET_DVR_SCREEN_SPLICE_GET               9082    //Get screen splice parameter
#define NET_DVR_SET_SCREEN_PARAM                9083    //Set screen parameter
#define NET_DVR_GET_SCREEN_PARAM                9084    //Get screen parameter
#define NET_DVR_SET_SWITCH_CFG                  9085    //Set time switch parameter
#define NET_DVR_GET_SWITCH_CFG                  9086    //Get time switch parameter
#define NET_DVR_SET_POWERON_DELAY_CFG           9087    //Set delay power on parameter
#define NET_DVR_GET_POWERON_DELAY_CFG           9088    //Get delay power on parameter
#define    NET_DVR_SET_SCREEN_POSITION                9089    //Set screen position
#define    NET_DVR_GET_SCREEN_POSITION                9090    //Get screen position
#define NET_DVR_SCREEN_SCENE_CONTROL            9091    //Screen scene control 
#define NET_DVR_GET_CURRENT_SCREEN_SCENE        9092    //Get current screen index
#define NET_DVR_GET_SCREEN_SCENE_PARAM          9093    //Get screen scene parameter
#define NET_DVR_SET_SCREEN_SCENE_PARAM          9094    //Set screen scene parameter
#define NET_DVR_GET_EXTERNAL_MATRIX_RELATION    9095    //Get the relation input and output between external matrix

/*******************************LCD Screen V1.2 end ******************************************/

#define     NET_DVR_GET_LCD_AUDIO_CFG            9096     //Get LCDScreen Audio
#define     NET_DVR_SET_LCD_AUDIO_CFG            9097     //Set LCDScreen Audio
#define     NET_DVR_GET_LCD_WORK_STATE            9098     //Get LCD work state
#define     NET_DVR_GET_BOOT_LOGO_CFG            9099    //Get boot logo 
#define     NET_DVR_SET_BOOT_LOGO_CFG            9100    //Set boot logo


#define NET_DVR_GET_STREAM_DST_COMPRESSIONINFO    9101  //get target compression information
#define NET_DVR_SET_STREAM_DST_COMPRESSIONINFO  9102  //set target compression information
#define NET_DVR_GET_STREAM_TRANS_STATUS            9103  //get stream transcode status
#define NET_DVR_GET_DEVICE_TRANS_STATUS            9104  //get device transcode status
#define NET_DVR_GET_ALLSTREAM_SRC_INFO          9105  //get all stream source information
#define NET_DVR_GET_BIG_SCREEN_AUDIO            9106  //get big screen audio information
#define NET_DVR_SET_BIG_SCREEN_AUDIO            9107  //set big screen audio information
#define NET_DVR_GET_DEV_WORK_MODE                9108  //get transcode device work mode
#define NET_DVR_SET_DEV_WORK_MODE                9109  //set transcode device work mode
#define NET_DVR_APPLY_TRANS_CHAN                9110  //apply transcode channel by stream ID
#define NET_DVR_GET_DISPCHAN_CFG                9111  //get display channel configure batch
#define NET_DVR_SET_DISPCHAN_CFG                9112  //set display channel configure batch
#define NET_DVR_GET_DEC_CHAN_STATUS                9113  //get decode channel status
#define NET_DVR_GET_DISP_CHAN_STATUS            9114  //get display channel status        
#define NET_DVR_GET_ALARMIN_STATUS                9115  //get alarm in status
#define NET_DVR_GET_ALARMOUT_STATUS                9116  //get alarm out status
#define NET_DVR_GET_AUDIO_CHAN_STATUS            9117  //get audio channel status

#define  NET_DVR_GET_VIDEO_AUDIOIN_CFG            9118   //get Audio video input parameters
#define  NET_DVR_SET_VIDEO_AUDIOIN_CFG            9119   //set Audio video input parameters

#define    NET_DVR_SET_BASEMAP_CFG                    9120  //set basemap config
#define NET_DVR_GET_BASEMAP_CFG                    9121  //get basemap config
#define NET_DVR_GET_VIRTUAL_SCREEN_CFG          9122  //get virtual screen config
#define NET_DVR_SET_VIRTUAL_SCREEN_CFG          9123  //set virtual screen config
#define NET_DVR_GET_BASEMAP_WIN_CFG                9124  //get basemap window config
#define NET_DVR_SET_BASEMAP_WIN_CFG                9125  //set basemap window config
#define NET_DVR_DELETE_PICTURE                    9126  //delete basemap picture
#define NET_DVR_GET_BASEMAP_PIC_INFO            9127  //get basemap picture information
#define    NET_DVR_SET_BASEMAP_WIN_CFG_V40         9128  //set base map window configuration V40
#define NET_DVR_GET_BASEMAP_WIN_CFG_V40         9129  //get base map window configuration V40

#define NET_DVR_GET_DEC_VCA_CFG                    9130    //get the vca alarm configure from decoder
#define NET_DVR_SET_DEC_VCA_CFG                    9131    //set the vca alarm configure from decoder

#define NET_DVR_SET_VS_INPUT_CHAN_INIT_ALL  9132  //Initializes the virtual screen all input channels 
#define NET_DVR_GET_VS_INPUT_CHAN_INIT_ALL  9133  //Get virtual screen all input channels initialization parameters
#define NET_DVR_GET_VS_INPUT_CHAN_INIT 9134  //Get virtual screen a single input channel initialization parameters
#define NET_DVR_GET_VS_INPUT_CHAN_CFG  9135  //Get virtual screen input channel configuration parameters 

#define NET_DVR_GET_TERMINAL_CONFERENCE_STATUS    9136    
#define NET_DVR_GET_TERMINAL_INPUT_CFG_CAP        9137    
#define NET_DVR_GET_TERMINAL_INPUT_CFG            9138    
#define NET_DVR_SET_TERMINAL_INPUT_CFG            9139    

#define NET_DVR_GET_CONFERENCE_REGION_CAP        9140    
#define NET_DVR_GET_CONFERENCE_REGION            9141    
#define NET_DVR_SET_CONFERENCE_REGION            9142    
#define NET_DVR_GET_TERMINAL_CALL_CFG_CAP        9143    
#define NET_DVR_GET_TERMINAL_CALL_CFG            9144    
#define NET_DVR_SET_TERMINAL_CALL_CFG            9145    
#define NET_DVR_GET_TERMINAL_CTRL_CAP            9146
#define NET_DVR_TERMINAL_CTRL                    9147    
#define    NET_DVR_GET_CALL_QUERY_CAP                9148    
#define NET_DVR_GET_CALLINFO_BY_COND            9149    
#define    NET_DVR_SET_FUSION_SCALE                9150    //set camera fusion scale
#define NET_DVR_GET_FUSION_SCALE                9151    //get camera fusion scale
#define NET_DVR_GET_VCS_CAP                        9152
#define NET_DVR_GET_TERMINAL_GK_CFG_CAP            9153    //get terminal register GK abilities
#define NET_DVR_GET_TERMINAL_GK_CFG                9154    //get terminal terminal register gk parameter
#define NET_DVR_SET_TERMINAL_GK_CFG                9155    //set terminal register gk parameter
#define NET_DVR_GET_MCU_CONFERENCESEARCH_CAP    9156    //get MCU conference search abilities
#define NET_DVR_SET_VS_INPUT_CHAN_CFG  9157  //Set virtual screen input channel configuration parameters
#define NET_DVR_GET_VS_NETSRC_CFG      9158  //Get virtual screen network source parameters
#define NET_DVR_SET_VS_NETSRC_CFG      9159  //Set virtual screen network source parameters
#define    NET_DVR_GET_LLDP_CFG                    9160    //set LLDP parameter
#define    NET_DVR_SET_LLDP_CFG                    9161    //get LLDP parameter
#define NET_DVR_GET_LLDP_CAP                    9162    //get LLDP abilities
#define    NET_DVR_GET_FIBER_CONVERT_BASIC_INFO    9163    //get fiber basic information
#define    NET_DVR_GET_FIBER_CONVERT_WORK_STATE    9164    //get fiber work status
#define    NET_DVR_GET_FIBER_CONVERT_TOPOLOGY      9165    //get fiber topology
#define    NET_DVR_GET_FC_PORT_REMARKS                9166    //get fiber port remarks
#define    NET_DVR_SET_FC_PORT_REMARKS                9167    //set fiber port remarks
#define NET_DVR_GET_PORT_REMARKS_CAP            9168    //get fiber port remarks abilities

#define NET_DVR_GET_MCU_CONFERENCECONTROL_CAP   9169    //get MCU conference control abilities
#define NET_DVR_GET_MCU_TERMINALCONTROL_CAP     9170    //get MCU terminal control abilities
#define NET_DVR_GET_MCU_TERIMINALGROUP_CAP      9171    //get MCU terminal group abilities
#define NET_DVR_GET_MCU_TERMINAL_CAP            9174    //get MCU terminal ability
#define NET_DVR_GET_MCU_CONFERENCE_CAP          9175    //get MCU conference ability
#define NET_DVR_GET_MCU_GK_CFG_CAP              9176    //get MCUGK config ability
#define NET_DVR_GET_MCU_GK_SERVER_CAP           9177    //get MCUGK server ability

#define NET_DVR_GET_EDID_CFG_FILE_INFO  9178  //get EDID file information
#define NET_DVR_GET_EDID_CFG_FILE_INFO_LIST  9179  //get EDID file information list
#define NET_DVR_SET_EDID_CFG_FILE_INFO  9180  //set EDID file information
#define NET_DVR_DEL_EDID_CFG_FILE_INFO  9181  //delete EDID file information (include file)
#define NET_DVR_GET_EDID_CFG_FILE_INFO_CAP  9182  //get EDID file information capabilities

#define NET_DVR_GET_SUBWND_DECODE_OSD  9183  //get information on child window decoding OSD
#define NET_DVR_GET_SUBWND_DECODE_OSD_ALL  9184  //get information on all child window decoding OSD
#define NET_DVR_SET_SUBWND_DECODE_OSD  9185  //set information on child window decoding OSD
#define NET_DVR_GET_SUBWND_DECODE_OSD_CAP  9186  //get information on child window decoding OSD capabilities
#define NET_DVR_GET_DECODE_CHANNEL_OSD  9187  //get decode channel OSD info
#define NET_DVR_SET_DECODE_CHANNEL_OSD  9188  //set decode channel OSD info

#define NET_DVR_GET_OUTPUT_PIC_INFO             9200    //get output picture information 
#define NET_DVR_SET_OUTPUT_PIC_INFO             9201    //set output picture information
#define NET_DVR_GET_OUTPUT_PIC_WIN_CFG          9202    //get output picture window parameter
#define NET_DVR_SET_OUTPUT_PIC_WIN_CFG          9203    //set output picture window parameter
#define NET_DVR_GET_OUTPUT_ALL_PIC_WIN_CFG      9204    //get all output picture window parameter
#define NET_DVR_DELETE_OUPUT_PIC                9205    //delete output picture 
#define NET_DVR_GET_OUTPUT_OSD_CFG              9206    //get output OSD parameter
#define NET_DVR_SET_OUTPUT_OSD_CFG              9207    //set output OSD parameter
#define NET_DVR_GET_OUTPUT_ALL_OSD_CFG          9208    //get all the output OSD parameter
#define NET_DVR_GET_CHAN_RELATION               9209    //get encode relate resource 
#define NET_DVR_SET_CHAN_RELATION               9210    //set encode relate resource
#define NET_DVR_GET_ALL_CHAN_RELATION           9211    //get all encode relate resource  
#define  NET_DVR_GET_NS_RING_CFG                9212    //get fiber board ring configure
#define  NET_DVR_SET_NS_RING_CFG                   9213    //set fiber board ring configure
#define  NET_DVR_GET_NS_RING_STATUS              9214    //get fiber ring status
#define NET_DVR_GET_OPTICAL_PORT_INFO            9220    //get optical port information
#define NET_DVR_SET_OPTICAL_PORT_INFO            9221    //set optical port information
#define NET_DVR_GET_OPTICAL_CHAN_RELATE_CFG        9222    //get coder channel related optical port information
#define NET_DVR_SET_OPTICAL_CHAN_RELATE_CFG        9223    //set coder channel related optical port information
#define NET_DVR_GET_WIN_ROAM_SWITCH_CFG         9224    //Get roaming decoder window switch parameters 
#define NET_DVR_SET_WIN_ROAM_SWITCH_CFG         9225    //Set roaming decoder window switch parameters 
#define    NET_DVR_START_SCREEN_CRTL                9226    //Start Screen Control
#define    NET_DVR_GET_SCREEN_FLIE_LIST            9227    //Get the screen file list
#define    NET_DVR_GET_SCREEN_FILEINFO                9228    //Get screen file information parameters
#define    NET_DVR_SET_SCREEN_FILEINFO             9229    //Set screen file information parameters

/*******************************LED begin***************************************/
#define NET_DVR_GET_LED_OUTPUT_CFG                9230    //get led send card output parameters
#define NET_DVR_SET_LED_OUTPUT_CFG                9231    //set led send card output parameters
#define NET_DVR_GET_LED_OUTPUT_PORT_CFG            9232    //get led send card output port parameters
#define NET_DVR_SET_LED_OUTPUT_PORT_CFG            9233    //set led send card output port parameters
#define NET_DVR_GET_LED_DISPLAY_AREA_CFG        9234    //get led send card display area
#define NET_DVR_SET_LED_DISPLAY_AREA_CFG        9235    //set led send card display area
#define NET_DVR_GET_LED_PORT_CFG                9236    //get led send card port parameters
#define NET_DVR_SET_LED_PORT_CFG                9237    //set led send card port parameters
#define NET_DVR_GET_LED_DISPLAY_CFG                9238    //get led send card display parameters
#define NET_DVR_SET_LED_DISPLAY_CFG                9239    //set led send card display parameters
#define NET_DVR_GET_ALL_LED_PORT_CFG            9240    //get led all port parameters
#define NET_DVR_SAVE_LED_CONFIGURATION            9241    //save led configuration
#define NET_DVR_GET_LED_TEST_SIGNAL_CFG            9242    //get led test signal parameters
#define NET_DVR_SET_LED_TEST_SIGNAL_CFG            9243    //set led test signal parameters
#define NET_DVR_GET_LED_NOSIGNAL_CFG            9244    //get led no signal display parameters
#define NET_DVR_SET_LED_NOSIGNAL_CFG            9245    //set led no signal display parameters
#define NET_DVR_GET_LED_INPUT_CFG                9246    //get led send card input parameters
#define NET_DVR_SET_LED_INPUT_CFG                9247    //get led send card input parameters
#define NET_DVR_GET_LED_RECV_GAMMA_CFG            9248    //get receive card GAMMA table parameters
#define NET_DVR_SET_LED_RECV_GAMMA_CFG            9249    //set led receive card GAMMA table parameters
#define NET_DVR_GET_LED_RECV_CFG                9250    //get led receive card basic parameters
#define NET_DVR_SET_LED_RECV_CFG                9251    //set led receive card basic parameters
#define NET_DVR_GET_LED_RECV_ADVANCED_CFG        9252    //get led receive card advanced parameters
#define NET_DVR_SET_LED_RECV_ADVANCED_CFG        9253    //set led receive card advanced parameters
#define NET_DVR_GET_LED_SCREEN_DISPLAY_CFG        9254    //get led screen display parameters
#define NET_DVR_SET_LED_SCREEN_DISPLAY_CFG        9255    //set led screen display parameters
/*******************************LED end*****************************************/

#define    NET_DVR_GET_SCREEN_CONFIG               9260    //Get the server screen parameter
#define    NET_DVR_SET_SCREEN_CONFIG               9261    //Set the server screen parameter 
#define NET_DVR_GET_SCREEN_CONFIG_CAP              9262    //Ability to screen server parameters were obtained 

#define    NET_DVR_GET_SCHEDULE_PUBLISH_PROGRESS    9271    //get schedule publish progress
#define    NET_DVR_GET_PUBLISH_UPGRADE_PROGRESS    9272    //get info publish termal upgrade progress

#define NET_DVR_GET_INSERTPLAY_PROGRESS            9273    //get insert play progress

#define NET_DVR_GET_INPUT_BOARD_CFG                9281    //get input board configuration
#define NET_DVR_GET_INPUT_BOARD_CFG_LIST        9282    //get input board configuration list
#define NET_DVR_SET_INPUT_BOARD_CFG                9283    //set input board configuration

#define NET_DVR_GET_INPUT_SOURCE_TEXT_CAP    9284
#define NET_DVR_GET_INPUT_SOURCE_TEXT_CFG    9285
#define NET_DVR_GET_INPUT_SOURCE_TEXT_CFG_LSIT 9286    
#define NET_DVR_SET_INPUT_SOURCE_TEXT_CFG    9287
#define NET_DVR_SET_INPUT_SOURCE_TEXT_CFG_LIST 9288
#define NET_DVR_GET_INPUT_SOURCE_RESOLUTION_CAP    9289
#define NET_DVR_GET_INPUT_SOURCE_RESOLUTION_CFG    9290
#define NET_DVR_GET_INPUT_SOURCE_RESOLUTION_CFG_LIST    9291
#define NET_DVR_SET_INPUT_SOURCE_RESOLUTION_CFG    9292
#define NET_DVR_SET_INPUT_SOURCE_RESOLUTION_CFG_LIST  9293
#define NET_DVR_GET_LED_AREA_INFO_LIST  9295
#define NET_DVR_GET_DISPINPUT_CFG  9296  //get display input parameters
#define NET_DVR_GET_DISPINPUT_CFG_LIST  9297  //get all display input parameters
#define NET_DVR_SET_DISPINPUT_CFG  9298  //set display input parameters
#define NET_DVR_GET_DISPINPUT_CFG_CAP  9299  //get display input parameters capabilities

#define NET_DVR_GET_CURRENT_VALID_PORT          9300    //get current valid port
#define    NET_DVR_SET_ONLINE_UPGRADE                9301    //allow the device upgrade online
#define NET_DVR_GET_ONLINEUPGRADE_PROGRESS      9302    //get online upgrade progress
#define    NET_DVR_GET_FIRMWARECODE                9303    //get firmware code
#define NET_DVR_GET_ONLINEUPGRADE_SERVER        9304    //get upgrade server status
#define NET_DVR_GET_ONLINEUPGRADE_VERSION       9305    //get new version information
#define NET_DVR_GET_RECOMMEN_VERSION            9306    //check the version is recommened
#define NET_DVR_GET_ONLINEUPGRADE_ABILITY       9309    //get the ability of online upgrade

#define    NET_DVR_GET_FIBER_CONVERT_BASIC_INFO_V50     9310
#define    NET_DVR_GET_FIBER_CONVERT_WORK_STATE_V50     9311

#define NET_SDK_LED_SCREEN_CHECK            9312
#define NET_SDK_GENERATE_OUTPUT_CONTROL	    9315

//DS-19D2000-S V2.0 update alarm linkage parameter code
#define  NET_DVR_GET_ALARM_LINKAGE_CFG    9316    //get DH alarm linkage parameter
#define  NET_DVR_SET_ALARM_LINKAGE_CFG    9317    //get DH alarm linkage parameter


#define NET_DVR_GET_RS485_WORK_MODE             10001 //get RS485 serial port work mode
#define NET_DVR_SET_RS485_WORK_MODE             10002 //set Rs485 serial port work mode
#define NET_DVR_GET_SPLITTER_TRANS_CHAN_CFG     10003 //get splitter transparent channel config
#define NET_DVR_SET_SPLITTER_TRANS_CHAN_CFG     10004 //set splitter transparent channel config


#define NET_DVR_GET_RS485_PROTOCOL_VERSION              10301       //get rs485 protocol version
#define	 NET_DVR_ALARMHOST_REGISTER_DETECTOR  10302			//auto registor detector




#define  NET_DVR_GET_SIP_CFG                    11001   //IP View get SIP config
#define  NET_DVR_SET_SIP_CFG                    11002   //IP View set SIP config
#define  NET_DVR_GET_IP_VIEW_DEVCFG                11003   //IP View get sub device config
#define  NET_DVR_SET_IP_VIEW_DEVCFG                11004   //IP View set sub device config
#define  NET_DVR_GET_IP_VIEW_AUDIO_CFG            11005   //IP View get audio config
#define  NET_DVR_SET_IP_VIEW_AUDIO_CFG            11006   //IP View set audio config
#define     NET_DVR_GET_IP_VIEW_CALL_CFG            11007   //IP View get call config
#define  NET_DVR_SET_IP_VIEW_CALL_CFG            11008   //IP View set call config
#define     NET_DVR_GET_AUDIO_LIMIT_ALARM_CFG        11009    //IP View get audio limit alarm config
#define     NET_DVR_SET_AUDIO_LIMIT_ALARM_CFG        11010    //IP View set audio limit alarm config
#define     NET_DVR_GET_BUTTON_DOWN_ALARM_CFG        11011    //IP View get button down alarm config
#define     NET_DVR_SET_BUTTON_DOWN_ALARM_CFG        11012    //IP View set button down alarm config

#define NET_DVR_GET_ISCSI_CFG                   11070      //Get ISCSI storage configuration protocol
#define NET_DVR_SET_ISCSI_CFG                   11071      //Set ISCSI storage configuration protocol
/*************************Parameter Configure Commands end*******************************/
#define NET_DVR_GET_SECURITYMODE                12004   
//2013-11-21 Get Temperature Humidity
#define NET_DVR_GET_TEMP_HUMI                   12005

//2014-02-15 Civil IPC test project
#define  NET_DVR_SET_ALARMSOUNDMODE             12006   //Set Alarm Sound Mode
#define  NET_DVR_GET_ALARMSOUNDMODE             12007   //Get Alarm Sound Mode
#define    NET_DVR_SET_IPDEVICE_ACTIVATED       13000//activate ipc by nvr
#define NET_DVR_GET_DIGITAL_CHAN_SECURITY_STATUS    13001   //get ip device security status
#define    NET_DVR_GET_ACTIVATE_IPC_ABILITY     13003    //get ability of activate ipc by nvr

#define NET_DVR_GET_VIDEO_INTERCOM_DEVICEID_CFG  16001  //Get Video intercom DeviceID config
#define NET_DVR_SET_VIDEO_INTERCOM_DEVICEID_CFG  16002  //Set Video intercom DeviceID config
#define NET_DVR_SET_PRIVILEGE_PASSWORD           16003  //Get Privilege password
#define NET_DVR_GET_OPERATION_TIME_CFG           16004  //Get Opreation Time Config
#define NET_DVR_SET_OPERATION_TIME_CFG           16005  //Set Opreation Time Config
#define NET_DVR_GET_VIDEO_INTERCOM_RELATEDEV_CFG 16006  //Get related Device Config
#define NET_DVR_SET_VIDEO_INTERCOM_RELATEDEV_CFG 16007  //Set related Device Config
#define NET_DVR_REMOTECONTROL_NOTICE_DATA        16008  //Notice Data
#define NET_DVR_REMOTECONTROL_GATEWAY            16009  //remote control Gateway
#define NET_DVR_REMOTECONTROL_OPERATION_AUTH     16010  //Remote Control operation auth

#define NET_DVR_GET_VIDEO_INTERCOM_IOIN_CFG      16016  //Get IO In Cfg
#define NET_DVR_SET_VIDEO_INTERCOM_IOIN_CFG      16017  //Set IO In Cfg
#define NET_DVR_GET_VIDEO_INTERCOM_IOOUT_CFG     16018  //Get IO Out Cfg
#define NET_DVR_SET_VIDEO_INTERCOM_IOOUT_CFG     16019  //Set IO Out Cfg
#define NET_DVR_GET_ELEVATORCONTROL_CFG          16020  //Get Elevator control Cfg
#define NET_DVR_SET_ELEVATORCONTROL_CFG          16021  //Set Elevator control Cfg
#define NET_DVR_GET_VIDEOINTERCOM_STREAM         16022  //Get Stream Cfg
#define NET_DVR_SET_VIDEOINTERCOM_STREAM         16023  //Set Stream Cfg
#define NET_DVR_GET_WDR_CFG                      16024  //Get WDR Cfg
#define NET_DVR_SET_WDR_CFG                      16025  //Set WDR Cfg
#define NET_DVR_GET_VIS_DEVINFO                  16026  //Get VIS Device Info
#define NET_DVR_GET_VIS_REGISTER_INFO            16027  //Get VIS Register Info
#define NET_DVR_GET_ELEVATORCONTROL_CFG_V40      16028  //Get Elevator control Cfg V40
#define NET_DVR_SET_ELEVATORCONTROL_CFG_V40      16029  //Set Elevator control Cfg  V40
#define NET_DVR_GET_CALL_ROOM_CFG                 16030  //Get Room Call Config
#define NET_DVR_SET_CALL_ROOM_CFG                 16031  //Set Room Call Config
#define NET_DVR_VIDEO_CALL_SIGNAL_PROCESS        16032  //Video Call Signal Process
#define NET_DVR_GET_CALLER_INFO                  16033  //get caller info
#define NET_DVR_GET_CALL_STATUS                  16034  //get call status
#define NET_DVR_GET_SERVER_DEVICE_INFO           16035  //get server device infi
#define NET_DVR_SET_CALL_SIGNAL                  16036  //set call signal
#define NET_DVR_GET_VIDEO_INTERCOM_ALARM_CFG       16037    //get video intercom alarm cfg
#define NET_DVR_SET_VIDEO_INTERCOM_ALARM_CFG       16038    //set video intercom alarm cfg
#define NET_DVR_GET_RING_LIST                    16039    //get ring list

#define NET_DVR_GET_ROOM_CUSTOM_CFG             16040  //get room custom cfg
#define NET_DVR_SET_ROOM_CUSTOM_CFG             16041  //set room custom cfg
#define NET_DVR_GET_ELEVATORCONTROL_CFG_V50     16042  //Get Elevator control Cfg V50
#define NET_DVR_SET_ELEVATORCONTROL_CFG_V50     16043  //Set Elevator control Cfg V50
#define NET_DVR_GET_SIP_CFG_V50                 16044   //Get SIP config V50
#define NET_DVR_SET_SIP_CFG_V50                 16045   //Set SIP config V50
#define NET_DVR_GET_NOTICE_VIDEO_DATA           16050  //Get Notice Video Data

#define    NET_DVR_DEBUGINFO_START                     18000    //Debug Info Start
#define    NET_DVR_AUTO_TEST_START                     18001    //Start auto test

/***************************DS9000 New Commands (_V30)  end *****************************/
//[add] by zja 2013-10-29 10:47:57
#define NET_DVR_GET_SELFCHECK_RESULT        20000    //Get selfcheck status 
#define NET_DVR_SET_TEST_COMMAND            20001    //Set test control command
#define NET_DVR_SET_TEST_DEVMODULE          20002    //set the contorl command of the hardware module
#define NET_DVR_GET_TEST_DEVMODULE          20003    //get the contorl command of the hardware module


#define NET_DVR_SET_AUTOFOCUS_TEST          20004    //Set Autofocus Test 2013-10-26
#define NET_DVR_CHECK_USER_STATUS           20005    //Detect the user is online
#define NET_DVR_GET_TEST_COMMAND            20010    //Get test control command
#define NET_DVR_GET_DIAL_SWITCH_CFG         20200    //Get Dial Switch 
#define NET_DVR_SET_AGING_TRICK_SCAN          20201  //Set the tool parameters before and after aging 
#define NET_DVR_GET_ECCENTRIC_CORRECT_STATE   20202  //Capture the eccentric calibration status 
#define	NET_DVR_GET_THERMOMETRYRULE_TEMPERATURE_INFO   23001
#define  NET_DVR_T1_TEST_CMD                     131073 


// American branch office coustom
#define NET_DVR_GET_MEMU_OUTPUT_MODE         155649        //Get menu output mode
#define NET_DVR_SET_MEMU_OUTPUT_MODE         155650        //Set menu output mode


#define NET_DVR_GET_DEV_LOGIN_RET_INFO      16777200  //get device login return parameters

/*******************Return Value of File&Log Query API*************************/
#define NET_DVR_FILE_SUCCESS            1000    //Get log information
#define NET_DVR_FILE_NOFIND                1001    //No log
#define NET_DVR_ISFINDING                1002    //On searching
#define    NET_DVR_NOMOREFILE                1003    //No more files
#define    NET_DVR_FILE_EXCEPTION            1004    //Error on log query

//alarm of plate: NET_DVR_PLATE_RESULT

/*************Operation Exception**********************/
#define EXCEPTION_EXCHANGE                0x8000    //Network user exception
#define EXCEPTION_AUDIOEXCHANGE            0x8001    //Network voice talk exception
#define EXCEPTION_ALARM                    0x8002    //Alarm exception
#define EXCEPTION_PREVIEW                0x8003    //Network preview exception
#define EXCEPTION_SERIAL                0x8004    //Transparent channel exception
#define EXCEPTION_RECONNECT                0x8005    //Network preview reconnected
#define EXCEPTION_ALARMRECONNECT        0x8006    //Alarm reconnected
#define EXCEPTION_SERIALRECONNECT        0x8007    //Transparent channel reconnected
#define SERIAL_RECONNECTSUCCESS            0x8008    //Transparent reconnected success
#define EXCEPTION_PLAYBACK                0x8010    //Playback exception
#define EXCEPTION_DISKFMT                0x8011    //Hard Disk format exception
#define EXCEPTION_PASSIVEDECODE            0x8012  //Passive decode exception
#define EXCEPTION_EMAILTEST                0x8013  //Email test exception    
#define EXCEPTION_BACKUP                0x8014  //Backup exception
#define PREVIEW_RECONNECTSUCCESS        0x8015  //Network preview reconnected successfully
#define ALARM_RECONNECTSUCCESS            0x8016  //Alarm reconnected successfully
#define RESUME_EXCHANGE                    0x8017    //User interaction resume

#define NETWORK_FLOWTEST_EXCEPTION      0x8018  // Network flow exception
//2011-11-24
#define EXCEPTION_PICPREVIEWRECONNECT    0x8019    //Picture Preview reconnect
#define PICPREVIEW_RECONNECTSUCCESS        0x8020    //Picture Preview reconnect successfully
#define EXCEPTION_PICPREVIEW            0x8021    //Picture Preview exception
#define    EXCEPTION_MAX_ALARM_INFO        0x8022    //too many alarm info
#define EXCEPTION_LOST_ALARM            0x8023    //lost alarm
#define EXCEPTION_PASSIVETRANSRECONNECT 0x8024  //Passive trans code reconnect
#define PASSIVETRANS_RECONNECTSUCCESS   0x8025  //Passive trans code reconnect success
#define EXCEPTION_PASSIVETRANS          0x8026  //Passive trans code exception

#define EXCEPTION_RELOGIN                0x8040    //User Relogin 
#define RELOGIN_SUCCESS                    0x8041    //User Relogin Success
#define EXCEPTION_PASSIVEDECODE_RECONNNECT  0x8042  //Passive decode reconnect
#define EXCEPTION_CLUSTER_CS_ARMFAILED      0x8043  //cluster arm cs exception

#define EXCEPTION_RELOGIN_FAILED                0x8044   //Relogin failed,stop relogin
#define EXCEPTION_PREVIEW_RECONNECT_CLOSED      0x8045   //stop preveiw reconnect
#define EXCEPTION_ALARM_RECONNECT_CLOSED        0x8046   //stop alarm reconnect
#define EXCEPTION_SERIAL_RECONNECT_CLOSED       0x8047   //stop serial reconnect
#define EXCEPTION_PIC_RECONNECT_CLOSED          0x8048   //stop picture reconnect
#define EXCEPTION_PASSIVE_DECODE_RECONNECT_CLOSED 0x8049 //stop passive decode reconnect
#define EXCEPTION_PASSIVE_TRANS_RECONNECT_CLOSED 0x804a  //stop passive transcoding reconnect
/********************Preview Callback Function*********************/
#define NET_DVR_SYSHEAD                    1    //System header
#define NET_DVR_STREAMDATA                2    //stream data
#define NET_DVR_AUDIOSTREAMDATA            3    //Audio Stream data
#define NET_DVR_STD_VIDEODATA            4    //Standard video stream data
#define NET_DVR_STD_AUDIODATA            5    //Standard audio stream data
#define NET_DVR_SDP                        6   //SDP data(valid for rtsp protocol) 
#define NET_DVR_CHANGE_FORWARD            10  //stream change from reverse to forward  
#define NET_DVR_CHANGE_REVERSE            11  //stream change from forward to reverse
#define NET_DVR_PLAYBACK_ALLFILEEND      12  //Play back All File End
#define NET_DVR_VOD_DRAW_FRAME              13  //vod draw Frame
#define NET_DVR_VOD_DRAW_DATA               14  //vod drawing
#define NET_DVR_PRIVATE_DATA            112 //Private data

/******************************Abilities Set*********************************/
//Capabilities
#define DEVICE_SOFTHARDWARE_ABILITY   0x001  //Software / hardware abilities of the device
#define DEVICE_NETWORK_ABILITY        0x002  //Network abilities of the device
#define DEVICE_ENCODE_ALL_ABILITY     0x003  //Encode abilities of the device
#define    DEVICE_ENCODE_CURRENT         0x004  //Current encode ability of the device
#define IPC_FRONT_PARAMETER              0x005     //Network camera parameters
#define IPC_UPGRADE_DESCRIPTION          0x006     //Network camera upgrade info
#define DEVICE_RAID_ABILITY           0x007  //RAID 
#define DEVICE_ENCODE_ALL_ABILITY_V20 0x008     //Encode abilities of the device 2.0
#define IPC_FRONT_PARAMETER_V20          0x009     //Network camera parameters 2.0
#define DEVICE_ALARM_ABILITY          0x00a  //alarm ability
#define DEVICE_DYNCHAN_ABILITY          0x00b  //device dyn channel ability
#define DEVICE_USER_ABILITY           0x00c  //user ability
#define DEVICE_NETAPP_ABILITY         0x00d  //net app ability
#define DEVICE_VIDEOPIC_ABILITY       0x00e  //video picture ability
#define DEVICE_JPEG_CAP_ABILITY       0x00f  //JPEG capture ability
#define DEVICE_SERIAL_ABILITY         0x010  //RS232 and RS485 ability
#define DEVICE_ABILITY_INFO              0x011     //Device common ability
#define STREAM_ABILITY                0x012  //Stream ability
#define SYSTEM_MANAGEMENT_ABILITY     0x013  //Device system management ability
#define IP_VIEW_DEV_ABILITY              0x014  //IP VIEW ability
#define VCA_DEV_ABILITY               0x100  //Intelligent analysis ability of the device
#define VCA_CHAN_ABILITY              0x110  //VCA ability of the device
#define TRANSFER_ABILITY              0x120 
#define MATRIXDECODER_ABILITY         0x200  //display and decoding ability of the multi-channel decoder
#define VIDEOPLATFORM_ABILITY         0x210  //Ability set of video management system
#define WALL_ABILITY                  0x212  //ability set of video wall
#define MATRIX_ABILITY                0x213  //ability set of SDI matrix 
#define VIDEOPLATFORM_ABILITY_V40     0x230  //ability set of Multi-function Video Center
#define MATRIXDECODER_ABILITY_V41     0x260  //decoder ability
#define DECODER_ABILITY               0x261  //decoder ability
#define CODECARD_ABILITY              0x271  //coder card server ability
#define SNAPCAMERA_ABILITY            0x300  //Ability set for the camera
#define ITC_TRIGGER_MODE_ABILITY      0x301  //IPC Trigger mode ability
#define COMPRESSIONCFG_ABILITY        0x400  //Get compression parameter abilities
#define COMPRESSION_LIMIT             0x401  //get compression ability between main and sub stream
#define PIC_CAPTURE_ABILITY           0x402  //get picture capture ability 
#define IT_DEVICE_ABILITY             0x501  //ITS ability
#define    SCREENCONTROL_ABILITY          0x600  //Ability of screen controller
#define    SCREENSERVER_ABILITY          0x610  //Ability of screen server
#define FISHEYE_ABILITY               0x700  //Fisheye ability
#define LCD_SCREEN_ABILITY              0x800     //Ability of LCD Screen 
#define ACS_ABILITY                   0x801  //Ability of Access Control System  
#define MERGEDEV_ABILITY              0x802  //Ability of merge code device
#define CAM_FUSION_ABILITY            0x803  //Camera fusion ability
#define OPTICAL_DEV_ACCESS_ABILITY    0x805  //Node optical device access ability
#define NET_RING_ABILITY              0x806     //Net ring ability
#define LED_ABILITY                      0x807     //LED screen ability
#define SCREEN_EXCHANGE_ABILITY       0x80b  //Screen interactive ability
#define REMOTE_NETMGR_FOT_ABILITY   0x80e   //Remote network management FOT ability

//board exception type
//main type
#define EXCEPTION_MAJOR_MAINBOARD_BOOT                    0x1  //main board boot exception
//sub type
#define EXCEPTION_MINOR_PCIE_SCAN                        0x1  //PCIE scan exception 
#define EXCEPTION_MINOR_DOWNLOAD_SUBBOARD                 0xa  //download sub board exception

//main type
#define EXCEPTION_MAJOR_SUBBOARD_BOOT                    0x2  //sub board boot exception
//sub type
#define EXCEPTION_MINOR_INEXISTENCE                       0x1  //sub board not found
#define EXCEPTION_MINOR_UBOOT_DOWNLOAD                  0xa  //uboot download exception
#define EXCEPTION_MINOR_UBOOT_INIT                      0xe  //uboot initialization fail
#define EXCEPTION_MINOR_ROOTFS_DOWNLOAD                 0x14  //rootfs.img download fail
#define EXCEPTION_MINOR_UIMAGE_DOWNLOAD                 0x19  //uImage download fail
#define EXCEPTION_MINOR_UBOOT_SETBOOTFLAG               0x1e  //uboot boot flags exception    
#define EXCEPTION_MINOR_ROOTFS_BOOT_SUBBOARD            0x23  //rootfs boot exception
#define EXCEPTION_MINOR_NEED_FILE_FINISH                0x28  //sub board file transfer exception

//main type
#define EXCEPTION_MAJOR_SUBBOARD_HARDWARE                0x3  //sub board hardware exception
//sub type
#define EXCEPTION_MINOR_AD                               0x1  //AD exception  
#define EXCEPTION_MINOR_DA                                 0xa  //DA exception
#define EXCEPTION_MINOR_TIMER                            0xb     //timer exception

//main type
#define EXCEPTION_MAJOR_FPGA                            0x4  //FPGA exception
//sub type
#define EXCEPTION_MINOR_IDLE                              0x1  //IDLE exception  
#define EXCEPTION_MINOR_LANE                             0xa  //LANE exception
#define EXCEPTION_MINOR_REGISTER_ALL_F                     0xe  //FPGA register all F
#define EXCEPTION_MINOR_MEMORY_INIT_FAIL                 0x14 //FPGA memory initialization fail
//main type
#define EXCEPTION_MAJOR_DSP                                0x5  //DSP exception

//main type
#define EXCEPTION_MAJOR_ARM                                0x6  //ARM exception

//main type
#define EXCEPTION_MAJOR_BACKBOARD                        0x7  //back board exception
//sub type
#define EXCEPTION_MINOR_BACKBOARD_TYPE                   0x1  //get back board type fail
#define EXCEPTION_MINOR_SERDES                           0xa  //serdes exception   
#define EXCEPTION_MINOR_CLOCK                             0xe  //clock exception
#define EXCEPTION_MINOR_SYNCH                             0x14 //synchronous signal exception


//main type
#define EXCEPTION_MAJOR_SUBBOARD_NET                    0x8  //sub board network exception
//sub type
#define EXCEPTION_MINOR_IP_CONFLICT                       0x1  //IP conflict
#define EXCEPTION_MINOR_DISCONNECT                         0x14 //network disconnect

//alarm callback
#define COMM_ALARM                      0x1100  //8000 Upload alarm message

//corresponding to NET_VCA_RULE_ALARM
#define COMM_ALARM_RULE                  0x1102  //VCA alarm info
#define COMM_ALARM_PDC                0x1103  //PDC alarm info
#define COMM_ALARM_AID                0x1110  //Traffic event alarm info
#define COMM_ALARM_VIDEOPLATFORM      0x1104  //Video Management System alarm
#define COMM_ALARM_ALARMHOST          0x1105  //Network alarm host alarm 
#define COMM_ALARM_FACE               0x1106  //Face detection recognition alarm information
#define COMM_RULE_INFO_UPLOAD         0x1107  //Event data information upload
#define COMM_ALARM_AID                0x1110  //Traffic event alarm info
#define COMM_ALARM_TPS                0x1111  //Traffic statistics alarm info
#define COMM_UPLOAD_FACESNAP_RESULT   0x1112  //Upload face snap result
#define COMM_ALARM_TFS                0x1113  //Traffic forensic alarm info
#define COMM_ALARM_TPS_V41            0x1114  //Traffic statistics alarm info(extended)
#define COMM_ALARM_AID_V41            0x1115  //Traffic event alarm info(extended)
#define COMM_ALARM_VQD_EX             0x1116  //Video quality diagnosis alarm(extended)
#define COMM_ALARM_NOTIFICATION_REPORT 0x1117 //Notification report
#define COMM_SENSOR_VALUE_UPLOAD      0x1120  //Sensor data realtime upload
#define COMM_SENSOR_ALARM                0x1121  //Analog alarm upload
#define COMM_SWITCH_ALARM              0x1122    
#define COMM_ALARMHOST_EXCEPTION      0x1123  //Alarm host exception alarm
#define COMM_ALARMHOST_SAFETYCABINSTATE 0x1125//SafetyCabin State
#define COMM_ALARMHOST_ALARMOUTSTATUS 0x1126  //Alarm Out Status
#define COMM_ALARMHOST_CID_ALARM       0x1127  // CID ALARM
#define    COMM_ALARMHOST_EXTERNAL_DEVICE_ALARM 0x1128    // external device alarm
#define COMM_ALARMHOST_DATA_UPLOAD    0x1129  //Alarm data upload
#define COMM_FACECAPTURE_STATISTICS_RESULT   0x112a  //face Capture Statistics Result
#define COMM_ALARM_WIRELESS_INFO     0x122b  // wirless info upload
#define COMM_SCENECHANGE_DETECTION_UPLOAD    0x1130    //Scene change alarm upload 2013-7-16
#define COMM_CROSSLINE_ALARM                0x1131  //CrossLine Alram 
#define COMM_UPLOAD_VIDEO_INTERCOM_EVENT     0x1132  //upload video intercon event
#define COMM_ALARM_VIDEO_INTERCOM               0x1133  //upload video intercon alarm
#define COMM_UPLOAD_NOTICE_DATA                 0x1134  //upload notice data
#define COMM_ALARM_AUDIOEXCEPTION     0x1150  //Aduio alarm info
#define COMM_ALARM_DEFOCUS            0x1151  //Defous alarm info
#define COMM_ALARM_ALARMGPS                  0x1202  //GPS alarm info upload
#define    COMM_TRADEINFO                  0x1500  //ATM DVR transaction information
//NET_DVR_PLATE_RESULT
#define COMM_UPLOAD_PLATE_RESULT      0x2800  //Uploaded License info
#define COMM_ITC_STATUS_DETECT_RESULT 0x2810  //status detect
#define COMM_IPC_AUXALARM_RESULT      0x2820  //PIR alarm\wireless alarm\callhelp alarm
#define COMM_SNAP_MATCH_ALARM         0x2902  //blacklist comparison result upload
#define COMM_ITS_PLATE_RESULT            0x3050  //ITS plate result upload
#define    COMM_ITS_TRAFFIC_COLLECT      0x3051  //ITS traffic collect upload
#define COMM_ITS_GATE_VEHICLE          0x3052  //Gate vehicle snapshot data upload
#define COMM_ITS_GATE_FACE            0x3053  //Gate vehicle Face data upload
#define COMM_ITS_GATE_COSTITEM          0x3054  //Gate Costitem 2013-11-19
#define COMM_ITS_GATE_HANDOVER          0x3055  //Gate Handover  2013-11-19
#define COMM_ITS_PARK_VEHICLE         0x3056  //Parking data upload
#define COMM_ITS_BLACKLIST_ALARM      0x3057  //BlackList data upload
#define COMM_VEHICLE_CONTROL_LIST_DSALARM    0x3058  //Vehicle Control List Alarm 2013-11-04
#define COMM_VEHICLE_CONTROL_ALARM           0x3059  //Vehicle Alarm 2013-11-04
#define COMM_FIRE_ALARM                      0x3060  //Fire Alarm 2013-11-04
#define COMM_ITS_GATE_ALARMINFO       0x3061      //ITS gate Alarm Info
#define COMM_VEHICLE_RECOG_RESULT     0x3062  //Upload a secondary result of the vehicle identification 2014-11-12 
#define COMM_PLATE_RESULT_V50         0x3063  //Plate Result V50

#define COMM_GATE_CHARGEINFO_UPLOAD          0x3064  //Charge Info Upload
#define COMM_TME_VEHICLE_INDENTIFICATION     0x3065  //TME Vehicle upload
#define COMM_GATE_CARDINFO_UPLOAD            0x3066  //Entrance card information upload

#define COMM_ALARM_SENSORINFO_UPLOAD  0x3077  //Sensor Info Upload
#define COMM_ALARM_CAPTURE_UPLOAD      0x3078  //Capture Upload
#define COMM_ITS_RADARINFO            0x3079  //Radar Alarm Info

#define COMM_SIGNAL_LAMP_ABNORMAL     0x3080  //Signal Lamp Abnormal

#define COMM_ALARM_TPS_REAL_TIME      0x3081  //TPS Real Time
#define COMM_ALARM_TPS_STATISTICS     0x3082  //TPS Statistics

#define COMM_ALARM_V30                  0x4000  //9000 upload alarm message
#define COMM_IPCCFG                      0x4001  //9000 IPC configuration changed,  upload with push mode
#define COMM_IPCCFG_V31                  0x4002  //Initiative alarm upload when IPC connection configuration changes on 9000 device,  extended for 9000_1.1
#define COMM_IPCCFG_V40                  0x4003  //Alarm information upload when IPC connection configuration of IVMS-2000 or NVR changes
#define COMM_ALARM_DEVICE             0x4004
#define COMM_ALARM_CVR                  0x4005  //CVR 2.0.X alarm
#define COMM_ALARM_HOT_SPARE          0x4006  //Hot alarm exception(N+1 abnormal alarm)
#define COMM_ALARM_V40                  0x4007  //upload alarm message(Expend)
#define COMM_UPLOAD_HEATMAP_RESULT    0x4008 //Heat Map 2014-03-21
#define COMM_ALARM_DEVICE_V40         0x4009  
#define COMM_ALARM_FACE_DETECTION     0x4010 //Face Detection
#define COMM_ALARM_TARGET_LEFT_REGION  0x4011 // Target left Region 
#define COMM_GISINFO_UPLOAD           0x4012 //GIS Info upload
#define COMM_VANDALPROOF_ALARM        0x4013 // prevent damage
#define COMM_PEOPLE_DETECTION_UPLOAD  0x4014 //People Detection Upload
#define COMM_ALARM_STORAGE_DETECTION  0x4015 //Storge Detection Alarm
#define COMM_MVM_REGISTER             0x4016 //Magnetic Vehicle Manager register info
#define COMM_MVM_STATUS_INFO          0x4017 //Magnetic Vehicle Manager status info upload
#define COMM_UPLOAD_HEATMAP_RESULT_PDC           0x4018 //Heat map result pdc
#define COMM_UPLOAD_HEATMAP_RESULT_DURATION      0x4019 //Heat map result duration
#define COMM_UPLOAD_HEATMAP_RESULT_INTERSECTION  0x4020 //Heat map result intersection
#define COMM_UPLOAD_AIOP_VIDEO        0x4021 //AIOP Video
#define COMM_UPLOAD_AIOP_PICTURE      0x4022 //AIOP Picture
#define COMM_UPLOAD_AIOP_POLLING_SNAP        0x4023 //polling snap
#define COMM_UPLOAD_AIOP_POLLING_VIDEO       0x4024 //polling video
#define    COMM_ITS_ROAD_EXCEPTION          0x4500  //ITS road exception upload
#define    COMM_ITS_EXTERNAL_CONTROL_ALARM        0x4520 //External control Alarm
#define COMM_ALARM_SHIPSDETECTION      0x4521  //Ships Detection

#define COMM_VCA_DBD_ALARM 0x4550       //dbd alarm
#define COMM_VCA_ADAS_ALARM 0x4551      //adas alarm
#define COMM_VEH_REALTIME_INFO 0x4552   //vehicel realtime info

#define COMM_FIREDETECTION_ALARM      0x4991  //Fire Detection Alarm
#define COMM_ALARM_DENSEFOGDETECTION    0x4992     //Fog Detection Alarm
#define COMM_VCA_ALARM                     0x4993     //VCA Detection Alarm
#define  COMM_FACE_THERMOMETRY_ALARM       0x4994 //face temp Alarm

#define  COMM_TAPE_ARCHIVE_ALARM        0x4996 //Tape archive alarm

#define    COMM_SCREEN_ALARM              0x5000  //Alarm type
#define COMM_DVCS_STATE_ALARM          0x5001  // alarm of dvcs
#define COMM_ALARM_ACS                  0x5002  //access card alarm
#define COMM_ALARM_FIBER_CONVERT      0x5003  //fiber convert alarm 
#define COMM_ALARM_SWITCH_CONVERT     0x5004  //switch alarm
#define COMM_ALARM_DEC_VCA            0x5010  //vca decode alarm 
#define COMM_ALARM_LCD                  0x5011   //LCD alarm 
#define COMM_CONFERENCE_CALL_ALARM      0x5012  //conference call alarm
#define COMM_ALARM_WALL_CONFERNECE  0x5015

#define COMM_DIAGNOSIS_UPLOAD         0x5100  //alarm of VQD
#define COMM_HIGH_DENSITY_UPLOAD      0x5101  //high density status upload

#define COMM_ID_INFO_ALARM                   0x5200  //id info alarm
#define COMM_PASSNUM_INFO_ALARM              0x5201  //pass number info alarm
#define COMM_PASSPORT_ALARM                   0x5202  //passport alarm

#define COMM_THERMOMETRY_DIFF_ALARM   0x5211  //Thermometry Difference Alarm
#define COMM_THERMOMETRY_ALARM        0x5212  //Thermometry Alarm
#define COMM_PANORAMIC_LINKAGE_ALARM         0x5213  //Panoramic linkage Alarm
#define COMM_TAG_INFO_ALARM           0x5215  //Tag Information Upload

#define COMM_ALARM_VQD                0x6000  //VQD alarm up 
#define COMM_PUSH_UPDATE_RECORD_INFO  0x6001  //Push mode record info upload
#define COMM_SWITCH_LAMP_ALARM        0x6002  //Swicth lamp Alarm
#define COMM_INQUEST_ALARM      0x6005  //Inquest alarm
#define COMM_VIDEO_PARKING_POLE_ALARM       0x6006  //Video Parking Pole Alarm
#define COMM_GPS_STATUS_ALARM         0x6010  // GPS status upload
#define COMM_BASE_STATION_INFO_ALARM  0x6011  // Base Station upload
#define COMM_ALARM_SUBSCRIBE_EVENT    0x6012  //Subscription results reported
#define COMM_FACESNAP_RAWDATA_ALARM   0x6015  //Face Snap Raw Data Alarm
#define COMM_CLUSTER_ALARM       0x6020
#define COMM_ISAPI_ALARM              0x6009  //ISAPI alarm

//PJ01C20170209084 super-brainNVS customization dedicated
#define COMM_FRAMES_PEOPLE_COUNTING_ALARM	 0x6069	 //Single frame people count result upload 

#define  COMM_SIGN_ABNORMAL_ALARM            0x6120 //Sign abnormal alarm
#define  COMM_HFPD_ALARM                     0x6121 //High frequency personnel detection alarm

#define   COMM_HCU_ALARM  0x6150  //HCU Alarm, SDK lib not support

#define  COMM_DEV_STATUS_CHANGED             0x7000  //Device status change alarm upload

/* Device model*/
#define DVR                            1                //Undefined DVR
#define ATMDVR                        2                //ATM DVR
#define DVS                            3                //DVS
#define DEC                            4                //6001DI 
#define ENC_DEC                        5                //6001FI 
#define DVR_HC                        6                //8000HCI
#define DVR_HT                        7                //8000HTI
#define DVR_HF                        8                //8000HFI
#define DVR_HS                        9                //8000HSI DVR (no audio) 
#define DVR_HTS                        10              //8016HTS DVR (no audio) 
#define DVR_HB                        11              //HB DVR (SATA HD)  
#define DVR_HCS                        12              //8000HCS DVR 
#define DVS_A                        13              //DVS with ATA Hard disk 
#define DVR_HC_S                    14              //8000HCI- S 
#define DVR_HT_S                    15              //8000HTI- S 
#define DVR_HF_S                    16              //8000HFI- S 
#define DVR_HS_S                    17              //8000HSI- S 
#define ATMDVR_S                    18              //ATM- S 
#define DVR_7000H                    19                //7000HI Series
#define DEC_MAT                        20              //Multichannel Decoder
#define DVR_MOBILE                    21                //Mobile DVR           
#define DVR_HD_S                    22              //8000HDI- S 
#define DVR_HD_SL                    23                //8000HDI- SL
#define DVR_HC_SL                    24                //8000HCI- SL
#define DVR_HS_ST                    25                //8000HSI- ST
#define DVS_HW                        26              //6000HW 
#define DS630X_D                    27                //DS630X_DI
#define DS640X_HD                    28                //DS640X_HDI
#define DS610X_D                    29              //610X Decoder
#define IPCAM                        30                //IP Camera
#define MEGA_IPCAM                    31                //Mega Pixels IP Camera
#define IPCAM_X62MF                    32                //862MF IP Camera
#define ITCCAM                      35              //ITC Camera
#define IVS_IPCAM                   36              //VCA ITC Camera
#define ZOOMCAM                     38              //ZOOM Camera
#define IPDOME                      40                 //IP Speed Dome
#define IPDOME_MEGA200              41                 //Mega Pixels IP Dome (2 million) 
#define IPDOME_MEGA130              42                 //Mega Pixels IP Dome (1.3 million) 
#define IPDOME_AI                   43              //IP AI Dome
#define TII_IPCAM                   44              //Thermal infrared imaging IP camera
#define IPTC_DOME                   45              /*IPTC Dome*/
#define DS_2DP_Z                    46              /*Spherical eagle eye (large) */
#define DS_2DP                      47              /*The spherical eagle eye (small) */
#define ITS_WMS                      48              /*Weighing data management server*/
#define IPMOD                        50                //IP Model
#define TRAFFIC_YTDOME              51              //Intelligence Cloud Terrace
#define TRAFFIC_RDDOME              52              //Radar Intelligence Cloud Terrace
#define IDS6101_HF_A                61              //61ATM
#define IDS6002_HF_B                62              //Tracked by two camera:  iDS6002- HF/B
#define IDS6101_HF_B                63              //VCA:  iDS6101- HF/B
#define IDS52XX                        64              //Intelligent Analysis:  IVMS
#define IDS90XX                        65                //9000 with intelligent function
#define IDS8104_AHL_S_HX            66              //Face Recognition ATM
#define IDS8104_AHL_S_H             67              //Private Face Recognition ATM
#define IDS91XX                        68                //9100 with intelligent function
#define IIP_CAM_B                   69              //intelligent behavior analyze IP camera
#define IIP_CAM_F                   70              //intelligent face analyze IP camera
#define DS71XX_H                    71                //DS71XXHI_S 
#define DS72XX_H_S                    72                //DS72XXHI_S 
#define DS73XX_H_S                    73                //DS73XXHI_S 
#define DS72XX_HF_S                 74              //DS72XX_HF_S
#define DS73XX_HFI_S                75              //DS73XX_HFI_S
#define DS76XX_H_S                    76                //DVR, e.g. DS7604_HI_S 
#define DS76XX_N_S                    77                //NVR, e.g. DS7604_NI_S 
#define DS_TP3200_EC                   78              //DS_TP3200_EC
#define DS81XX_HS_S                    81                //DS81XX_HSI_S 
#define DS81XX_HL_S                    82                //DS81XX_HLI_S 
#define DS81XX_HC_S                    83                //DS81XX_HCI_S 
#define DS81XX_HD_S                    84                //DS81XX_HDI_S 
#define DS81XX_HE_S                    85                //DS81XX_HE_S 
#define DS81XX_HF_S                    86                //DS81XX_HFI_S 
#define DS81XX_AH_S                    87                //DS81XX_AHI_S 
#define DS81XX_AHF_S                88                //DS81XX_AHFI_S 
#define DS90XX_HF_S                    90              //DS90XX_HFI_S
#define DS91XX_HF_S                    91              //DS91XX_HFI_S
#define DS91XX_HD_S                    92              //91XXHDI- S (MD) 
#define IDS90XX_A                    93                //9000 intelligent ATM
#define IDS91XX_A                    94                //9100 intelligent ATM
#define DS95XX_N_S                    95              //DS95XX_NI_S NVR with no output interfaces
#define DS96XX_N_SH                    96              //DS96XX_NI_SH NVR
#define DS90XX_HF_SH                97              //DS90XX_HFI_SH    
#define DS91XX_HF_SH                98              //DS91XX_HFI_SH 
#define DS_B10_XY                   100             //Video integrated platform Device Type (X: Encoder Number, Y: Decoder Number) 
#define DS_6504HF_B10               101             //Video integrated platform Encoder
#define DS_6504D_B10                102             //Video integrated platform Decoder
#define DS_1832_B10                 103                //Video integrated platform code splitter
#define DS_6401HFH_B10              104             //Video integrated platform optical
#define DS_65XXHC                    105                //65XXHCI DVS
#define DS_65XXHC_S                    106                //65XXHCI- SATA DVS
#define DS_65XXHF                    107                //65XXHFI DVS
#define DS_65XXHF_S                    108                //65XXHFI- SATA DVS
#define DS_6500HF_B                 109             //DS- 6500 series rack mount DVS
#define IVMS_6200_C                 110             //IVMS- 6200 (/C)   
#define IVMS_6200_B                 111             //IVMS- 6200 (/B) 
#define DS_72XXHV_ST15                112                //72XXHVI_ST  Hi3515 DVR
#define DS_72XXHV_ST20                113                //72XXHVI_ST  Hi3520 DVR
#define IVMS_6200_T                    114             //IVMS- 6200 (/T) 
#define IVMS_6200_BP                115             //IVMS- 6200 (/BP) 
#define DS_81XXHC_ST                116                //DS_81XXHC_ST
#define DS_81XXHS_ST                117                //DS_81XXHS_ST
#define DS_81XXAH_ST                118                //DS_81XXAH_ST ATM
#define DS_81XXAHF_ST                119                //DS_81XXAHF_ST ATM
#define DS_66XXDVS                    120                //66XX DVS

#define DS_1964_B10                 121             /*DS-1964-B10*/
#define DS_B10N04_IN                122             /*DS-B10N04-IN*/
#define DS_B10N04_OUT                123             /*DS-B10N04-OUT */
#define DS_B10N04_INTEL             124             /*DS-B10N04-INTEL*/
#define DS_6408HFH_B10E_RM          125             //DS-6408HFH-B10E-RM
#define DS_B10N64F1_RTM             126             //DS-B10N64F1-RTM
#define DS_B10N64F1D_RTM            127             //DS-B10N64F1D-RTM
#define DS_B10_SDS                  128             //DS-B10-SDS
#define DS_B10_DS                   129             //DS-B10-DS
#define DS_6401HFH_B10V                130             //DS-6401HFH-B10V
#define DS_6504D_B10B               131             /*DS-6504D-B10B*/
#define DS_6504D_B10H               132             /*DS-6504D-B10H*/
#define DS_6504D_B10V               133             /*DS-6504D-B10V*/
#define DS_6408HFH_B10S                134             //DS-6408HFH-B10S 
#define DS_18XX_N                      135             /* DS-18XX-N*/ 
#define DS_6504HF_B10F_CLASS        136                //DS-6504HF-B10F-CLASS

#define DS_18XX_PTZ                    141                
#define DS_19AXX                    142                
#define DS_19BXX                    143                
#define DS_19CXX                    144                
#define DS_19DXX                    145                //DS_19DXX    
#define DS_19XX                     146             //DS_19XX
#define DS_19SXX                    147                //DS_19SXX
#define DS_1HXX                        148                //CS
#define DS_PEAXX                    149                //DS_PEAXX
#define DS_PWXX                        150
#define DS_PMXX                     151
#define DS_19DXX_S                  152
#define DS_PWAXX                    153                 /* Axiom Hub */
#define DS_PHAXX                    154                 /* Axiom Hybrid */

//2011-11-30
#define    DS_C10H                        161                /*CVCS*/
#define DS_C10N_BI                    162                //DVCS BNC processor 
#define DS_C10N_DI                    163                //DVCS RGB processor
#define DS_C10N_SI                    164                //DVCS STREAM processor
#define DS_C10N_DO                    165                //DVCS DISP processor
#define DS_C10N_SERVER                166                //DVCS SERVER

#define IDS_8104_AHFL_S_H           171             //8104ATM 
#define IDS_65XX_HF_A               172             //65 ATM
#define IDS90XX_HFI_RH              173             //9000 intelligent RH
#define IDS91XX_HFI_RH              174             //9100 intelligent RH
#define IDS_65XX_HF_B               175             //65 behavior analyze
#define IDS_65XX_HF_P               176             //65 plate recognize
#define IVMS_6200_F                 177             //IVMS-6200(/F)
#define IVMS_6200_A                 178             //IVMS-6200(/A)
#define IVMS_6200_F_S                 179             // IVMS-6200(/F_S)

#define DS90XX_HF_RH                181             //9000 RH
#define DS91XX_HF_RH                182             //9100 RH
#define DS72XXHVI_S                 183             //DVR DS-7204HVI-ST/SE 
#define DS81XXHW_S                    185                //81 Resolution 960 
#define DS81XXHW_ST                    186             //DS81XXHW_ST
#define DS91XXHW_ST                    187             //DS91XXHW_ST
#define DS91XX_ST                    188             //DS91XX_ST
#define DS81XX_ST                    189             //DS81XX_ST
#define DS81XXHX_ST                    190             //DS81XXHDI_ST,DS81XXHE_ST ky2012
#define DS73XXHX_ST                    191             //DS73XXHI_ST ky2012
#define DS81XX_SH                   192             //Inquest81SH,81SHF
#define DS81XX_SN                   193             //Inquest81SNL

#define DS96XXN_ST                  194             //NVR:DS96xxN_ST
#define DS86XXN_ST                  195             //NVR:DS86xxN_ST
#define DS80XXHF_ST                 196             //DVR:DS80xxHF_ST
#define DS90XXHF_ST                 197             //DVR:DS90xxHF_ST
#define DS76XXN_ST                  198             //NVR:DS76xxN_ST

#define ENCODER_SERVER                200                // ENCODER_SERVER
#define DECODER_SERVER              201             // DECODER_SERVER
#define PCNVR_SERVER                202             // PCNVR_SERVER
#define CVR_SERVER                  203             // CVR
#define DS_91XXHFH_ST                204             // 91HD-SDI
#define DS_66XXHFH                    205             // 66 decoder
#define    TRAFFIC_TS_SERVER            210                //ITS server
#define    TRAFFIC_VAR                    211                //ITS VAR
#define IPCALL                      212             //IP call
#define SAN_SERVER                  213                //SAN

#define DS_B11_M_CLASS                 301             /*Video platform B11*/
#define DS_B12_M_CLASS                  302             /*Video platform B12*/
#define DS_6504HF_B11_CLASS         303             /*inter encoder of video platform*/
#define DS_6504HF_B12_CLASS         304              /*inter encoder of video platform*/
#define  DS_6401HFH_B11V_CLASS         305     //VGA HD encoder
#define  DS_6401HFH_B12V_CLASS         306     //VGA HD encoder
#define  DS_6408HFH_B11S_CLASS         307     //SDI encoder
#define  DS_6408HFH_B12S_CLASS      308     //SDI encoder
#define  DS_6504D_B11H_CLASS        309   /*inter HD decoder of video platform*/
#define  DS_6504D_B11B_CLASS        310    /*inter SD decoder of video platform*/
#define  DS_6504D_B12B_CLASS        311       /*inter SD decoder of video platform*/
#define  DS_6504D_B11V_CLASS        312      /*inter VGA decoder of video platform*/
#define  DS_6504D_B12V_CLASS        313     /*inter VGA decoder of video platform*/
//B10
#define  DS_6401HFH_B10R_CLASS         314     //B10 RGB HD encoder
#define  DS_6401HFH_B10D_CLASS         315     //B10 DVI HD encoder
#define  DS_6401HFH_B10H_CLASS         316     //B10 HDMI HD encoder
//B11
#define  DS_6401HFH_B11R_CLASS         317     //B11 RGB HD encoder
#define  DS_6401HFH_B11D_CLASS         318     //B11 DVI HD encoder
#define  DS_6401HFH_B11H_CLASS         319     //B11 HDMI HD encoder
//B12
#define  DS_6401HFH_B12R_CLASS         320     //B12 RGB HD encoder
#define  DS_6401HFH_B12D_CLASS         321     //B12 DVI HD encoder
#define  DS_6401HFH_B12H_CLASS         322     //B12 HDMI HD encoder
#define  DS_65XXD_B10Ex_CLASS        323     //netra HD decoder
//B10 V2.1
#define  DS_6516HW_B10_CLASS        324     //netra encoder of B10
#define  DS_6401HFH_B10F_RX_CLASS   326        //optical interface encoder(support 1/2 optical access)
#define  DS_6502HW_B10F_RX_CLASS    327        //960H optical interface encoder(support 1/4/8 optical access)
#define  DS_6504D_B11Ex_CLASS        328     //netra HD decoder
#define  DS_6504D_B12Ex_CLASS        329     //netra HD decoder
#define  DS_6512_B11_CLASS            330     //netra encoder
#define  DS_6512_B12_CLASS            331     //netra encoder
#define  DS_6504D_B10H_CLASS        332     //inter HD decoder of video platform
#define  DS_65XXT_B10_CLASS         333     //transcoder of video platform
#define  DS_65XXD_B10_CLASS         335     //65XXD decoder of video platform
#define  DS_IVMSE_B10X_CLASS        336     //X86 service
#define  DS_6532D_B10ES_CLASS        337     //enhance decode board_SDI(b10)
#define  DS_6508HFH_B10ES_CLASS        338     //SDI encoder
#define  DS_82NCG_CLASS                340     //DS_82NCG
#define  DS_82VAG_CLASS                341     //DS_82VAG 
#define  DS_1802XXF_B10_CLASS       342     //DS_1802XXF_B10
#define  iDS_6504_B10EVAC_CLASS     343     //intelligence sub system
#define  iDS_6504_B10EDEC_CLASS     344     //intelligence sub system
#define  DS_6402HFH_B10EV_CLASS     345     //netra encoder(VGA)
#define  DS_6402HFH_B10ED_CLASS     346     //netra encoder(DVI)
#define  DS_6402HFH_B10EH_CLASS     347     //netra encoder(HDMI)
#define  DS_6404HFH_B10T_RX_CLASS   348     //fiber access encoder
#define  DS_6504D_AIO_CLASS         349        //netra HD decoder
#define  DS_IVMST_B10_CLASS            350        //stream transform sub system
#define  DS_6402_AIO_CLASS          351     //netra encoder
#define  DS_iVMSE_AIO_CLASS         352     //x86 server sub system
#define  DS_AIO_M_CLASS             353     //Integrated machine


#define  DS_6508HF_B10E_CLASS        355        //BNC encoder
#define  DS_6404HFH_B10ES_CLASS        356        //SDI encoder
#define  DS_6402HFH_B10ER_CLASS        358        //RGB encoder
#define  DS_6404HFH_B10T_RM_CLASS    361        //fiber encoder
#define  DS_6516D_B10EB_CLASS        362        //BNC decoder
#define  DS_6516D_B10ES_CLASS        363        //SDI decoder

//DVI/HDMI/VGA free show decoder share one type
#define DS_6508D_B10FH_CLASS        364
#define DS_6508D_B10FD_CLASS        364
#define DS_6508D_B10FV_CLASS        364

#define  DS_6508_B11E_CLASS            365        //BNC encoder
#define  DS_6402_B11ES_CLASS        366        //SDI encoder
#define  DS_6402_B11EV_CLASS        367        //VGA encoder
#define  DS_6402_B11ER_CLASS        368        //RGB encoder
#define  DS_6402_B11ED_CLASS        369        //DVI encoder
#define  DS_6402_B11EH_CLASS        370        //HDMI encoder
#define  DS_6516D_B11EB_CLASS        371        //BNC decoder
#define  DS_6516D_B11ES_CLASS        372        //SDI decoder

#define  DS_6508_B12E_CLASS         373     //BNC encoder
#define     DS_6402_B12ES_CLASS        375        //SDI encoder
#define  DS_6402_B12EV_CLASS        376        //VGA encoder
#define  DS_6402_B12ER_CLASS        377        //RGB encoder
#define  DS_6402_B12ED_CLASS        378        //DVI encoder
#define  DS_6402_B12EH_CLASS        379        //HDMI encoder
#define  DS_6516D_B12EB_CLASS        380        //BNC decoder

#define  DS_iVMSE_AIO_8100x_CLASS   381     //iVMSE 8100X sub system
#define  DS_iVMSE_AIO_87x_CLASS     382     //iVMSE 87X sub system
#define  DS_6532D_B11ES_CLASS        384        //enhance decode board_SDI(b11)
#define  DS_6532D_B12ES_CLASS        385        //enhance decode board_SDI(b12)
#define  DS_B20_MSU_NP              400     //DS_B20_MSU_NP
#define  DS_6416HFH_B20S            401     //6416HFH_B20S encoder
#define  DS_6416HFH_B20_RM          402     //6416HFH_B20_RM encoder
#define  DS_6564D_B20D              403     //6564D_B20D decoder
#define  DS_6564D_B20H              404     //6564D_B20H decoder
#define  DS_6564D_B20V              405        //6564D_B20V decoder
#define  DS_6408HFH_B20V            407     //6408HFH_B20V encoder
#define  DS_MMC_B20_CLASS           408     //DS_MMC_B20_
#define  DS_CARD_CHIP_B20_CLASS     409     //DS_CARD_CHIP_B20
#define  DS_6564D_B20B_DEV_CLASS    410     //BNC decoder
#define  DS_6564D_B20S_DEV_CLASS    411     //SDI decoder
#define  DS_6532HF_B20B_DEV_CLASS   412     //BNC encoder
#define  DS_6408HFH_B20D_DEV_CLASS  413     //DVI encoder
#define  DS_6408HFH_B20H_DEV_CLASS  414     //HDMI encoder
#define  DS_IVMSE_B20_CLASS            415     //x86 server sub system
#define  DS_6402HFH_B20Y_DEV_CLASS  416     //YUV encoder
#define  DS_6508HW_B20_DEV_CLASS    417     //HW encoder
#define  DS_B20N128Fx_B20_DEV_CLASS 418     //cascade sub system
#define  DS_AIO_MCU_NP_DEV_CLASS    419     //AIO main board
#define  DS_6402_AIO_EV_DEV_CLASS   420     //VGA coder
#define  DS_6508D_AIO_EV_DEV_CLASS  421     //VGA decoder
#define  DS_6508D_AIO_ED_DEV_CLASS  422     //DVI decoder
#define  DS_6508D_AIO_EH_DEV_CLASS  423     //HDMI decoder
#define  DS_6508HD_B20F_DEV_CLASS    424     //enhanced decoder
#define  DS_6402HFH_B20ES_DEV_CLASS 425     //3G SID coder
#define  DS_6532D_B20_DEV_CLASS     426     //B20 decoder            
#define  DS_IVMST_B20_DEV_CLASS     427     //X86 service sub system
#define  DS_6416HFH_B20DD_DEV_CLASS 428     //Dual link DVI coder
#define  DS_6441VS_B20_DEV_CLASS    429        //signal joint sub system
#define  DS_6404HFH_B20T_CLASS         431        //TVI coder
#define  DS_FS22_B20_DEV_CLASS         432        //fiber switcher sub system
#define  DS_IVMSE_B20UH_DEV_CLASS   433     //Ultra HD input sub system
#define  IDS_6524J_B20_DEV_CLASS    434
#define  IDS_6532B_B20_DEV_CLASS    435
#define  DS_6404HFH_B20Fx_DEV_CLASS 436        //node optical device input coder
#define  DS_N128x_B20Fy_CLASS        437     //cascade sub system
#define  DS_181600F_B20_CLASS        438     //net fiber sub system
#define  DS_6904UD_B20H_CLASS       439     //Ultra HD decoder
#define  DS_B21_MCU_NP_CLASS        440     //DS_B21_MCU_NP_CLASS
#define  DS_C10S                    501     //C10S Video Wall Controller
#define  DS_C10N_SDI                551        //SDI processor
#define  DS_C10N_BIW                552        //8 channels BNC processor
#define  DS_C10N_DON                553        //display processor
#define  DS_C10N_TVI                554     //TVI processor
#define  DS_C10N_DI2                555     //2 channels DVI processor 
#define  DS_C10N_AUDIO_OUT          556     //DVI,HDMI,VGA display processor with audio output
#define  DS_C10N_AUDIO_IN           557     //DVI,HDMI,VGA processor with audio input

//Soft server version of the distributed screen controller
#define  DS_C20N                    570     //C20N server
#define  DS_C20N_BNC                571     //C20N BNC input device
#define  DS_C20N_DVI                572     //C20N DVI input device 
#define  DS_C20N_DP                 573     //C20N DP input device
#define  DS_C20N_OUT                574     //output device

//Hard server version of the distributed screen controller 
#define DS_C20N_VWMS                5351    //Server
#define DS_C20N_DI2                 5352    //Two channels DVI input device
#define DS_C20N_DO2                 5353    //Two channels DVI output device
#define DS_C20N_UHDI                5354    //DP/HDMI one channel 4K high-definition input device
#define DS_C20N_YI2                 5355    //double channels YPbPr input device

#define DS_C12N_VWMS                5356
#define DS_C12N_DO                  5357
#define DS_C12N_HOE                 5358

#define DS_C20N_HI2             5359 // HDMI-input node(2 line)
#define DS_C20N_VI2             5360 //VGA-input node(2 line)
#define DS_C20N_SI2             5361 //SDI-input node(2 line)
#define DS_C20N_HO2             5362 //HDMI-output node(2 line)
#define DS_C20N_S24G            5363 //C20N-KMB-switch(24 line)
#define DS_C20N_S24X            5364 //C20N-GB-switch(24 line)

//Holographic display device
#define DS_D1HXX                    5591    //holographic display device

#define ELEVATO_BRIDGE  5751  //wireless elevator bridge
#define DS_3WF01S_5NG_M  5752  //5.8G wireless construction site bridge(1 kilometer outside)
#define DS_3WF0EC_2N_D  5753  //2.4G wireless construction site bridge(half kilometer outside)

#define DS_19M00_MN                    601        //network module

#define DS64XXHD_T                    701        //64-T Decoder

#define DS_65XXD                    703     //65 Decoder
#define DS63XXD_T                    704        //63-T Decoder
#define DS_64XXHD_S                 706     //64XXHD-S Decoder
#define DS_68XXT                    707        //multi transcoder
#define DS_65XXD_T                  708     //65D-T Decoder
#define DS_65XXHD_T                 709     //65HD-T Decoder
#define DS_69XXUD                   710     //69XXUD Decoder
#define DS_65XXUD                   711     //65XXUD Decoder
#define DS_65XXUD_L                 712     //65XXUD_L Decoder
#define DS_65XXUD_T                 713     //65XXUD_T Decoder
#define DS_69XXHD                   5001    //69XXHD Decoder

#define DS_D20XX                    750     //LCD Screen
//SDI matrix
#define DS_C50S                     751     //SDI Matrix
#define DS_D50XX                    752     //LCD Screen
#define DS_D40                      760     //LED screen controller

#define DS_65VMXX                   770     //conference system server
#define DS_65VTXX                   771     //conference system terminal
#define DS_65VTA                    772     //conference system Integrated terminal
#define DS_65VT_RX                  773     //Interactive teaching terminal
#define DS_65VM_MCU_NP              774     //multiple MCU
#define DS_65VT0010                 5571    //unit type terminal
#define DS_65VM_MCU                 5572    //High density MCU main bord
#define DS_65VM_MPC                 5573    //High density MCU resoure bord
#define DS_65VT2XXYR_SF             5574    //Judicial interrogate terminal
#define DS_65VT0XXY                 5575    //Video conference big terminal
#define DS_65VT0010Z                5576    //smart unit type terminal
#define DS_65VT0050Z                5577    //smart video conference big terminal
#define DS_65VS0XXXS                5878    //opensips sip server
#define DS_65VS0XXXM                5879    //video conference control platform

#define DS_CS_SERVER                800     //Virtual screen server
#define DS_68GAP_MCU                831     //video gap
#define DS_K260X                    850     //Access control system
#define DS_K1TXXX                   851     //
#define DS_K280X                    852     //
#define DS_K1T80X                   854     //
#define RAC_6X00                    856     //
#define DS_K2602_AX                 857     //
#define DS_K1T803F                  858     //
#define DS_K2700                    859     //
#define DS_K270X                    860     //
#define DS_K1T500S                  861     //
#define DS_K1A801F                  862     //
#define DS_K1T600X                  863     //
#define DS_K22X                     864     //
#define DS_K2M0016AX                865     //
#define DS_K2602S_AX                867     //
#define DS_K560XX                   870     //Vertical/Desktop identification intelligent terminal
#define DS_K260X_E                  873     //
#define DS_K5603X                   874     //Embedded Vertical identification intelligent terminal
#define DS_K3M200X                  875     //
#define DS_K3M100X                  879     //
#define DS_K1T8101XT                881     //
#define DS_K1T8101XX                882     //
#define DS_K5604                    883      //5604
#define DS_K1T607XXXX               884     //DS_K1T607(M/MF/E/EF/MG/MFG/MW/MFW/TM/TMF/TE/TEF/TMG/TMFG/TMW/TMFW)
#define DS_K1A850X                  885     //
#define DS_K1T800X                  886     //
#define DS_K1T610XXXX               887     //DS_K1T610(M/MF/E/EF/MG/MFG/MW/MFW/TM/TMF/TE/TEF/TMG/TMFG/TMW/TMFW)
#define DS_K1T8115X                 888     //DS-K1T8115,DS-K1T8115M,DS-K1T8115M-Z
#define DS_K1T815LC_M               889     //
#define DS_K1T606M_Z                890     //

#define DS_6800M                    900     //68M merger
#define DS_68NTH                    901     //information publish device
#define DS_D60S                     902     //information publish server
#define    DS_D10                        931        //Rear-projection device
#define DS_3K0X_NM                    951        //Fiber Converter
#define DS_3E2328                    952     //100M Switches
#define DS_3E1528                    953     //1000M Switches
#define DS_D51OPSXX                 972     //OPS computer box
#define IP_PTSYS_MEGA200            1001    //IP_PTSYS_MEGA200
#define IPCAM_FISHEYE               1002    //Fisheye IP Camera
#define IPCAM_FISHEYE_E             1003    //Economic Fisheye IP Camera
#define IPCAM_365                    1010    //IPC CAM support 365 platform
#define IPCAM_R0                    1011    //IPC CAM support A5S platform
#define IPCAM_R1                    1012    //IPC CAM support 385 platform
#define IPCAM_R2                    1013    //IPC CAM support R2 platform
#define IPCAM_R3                    1014    //IPC CAM support 8127 platform
#define IPCAM_R4                    1015    //IPC CAM support S2 platform

#define IPDOME_365                    1110    //IPD CAM support 365 platform
#define IPDOME_R0                    1111    //IPD CAM support A5S platform
#define IPDOME_R1                    1112    //IPD CAM support 385 platform
#define IPDOME_R2                    1113    //IPD CAM support R2 platform
#define IPDOME_R3                    1114    //IPD CAM support 8127 platform
#define IPDOME_R4                    1115    //IPD CAM support S2 platform
#define ITCCAM_R3                    1211    //ITCCAM support 8127 platform

#define UAV_S                       1300    //Ummanned Aerial Vehicle - Station

//Add Device Type 2013-11-19
#define  TRAFFIC_ECT                1400  //ECT Device Type
#define  TRAFFIC_PARKING_SERVER     1401  //Parking Server
#define  TRAFFIC_TME                1402  //Entrance control machine
// DVR
#define DS90XXHW_ST                    2001    // DS90XXHW_ST
#define DS72XXHX_SH                 2002    // DS-72xxHV_SH, DS-72xxHF-SH 
#define DS_92XX_HF_ST                2003    // DS-92XX-HF-ST 
#define DS_91XX_HF_XT                2004    // NETRET_9100DVR_HF_XT
#define DS_90XX_HF_XT               2005    // NETRET_9000DVR_HF_XT 
#define DS_73XXHX_SH                2006    // NETRET_7300DVR_HX_SH  
#define DS_72XXHFH_ST                2007    // NETRET_7200DVR_HFH_ST

//DS_67XX

#define DS_67XXHF_SATA              2008    // DS-67XXHF-SATA
#define DS_67XXHW                   2009    // DS-67XXHW 
#define DS_67XXHW_SATA              2010    // DS-67XXHW-SATA
#define DS_67XXHF                   2011    // DS-67XXHF

//Netra2.3
#define DS_72XXHF_SV                 2012   // DS-72xxHF-SV 
#define DS_72XXHW_SV                 2013   // DS-72xxHW-SV

#define DS_81XXHX_SH                2014   // NETRET_8100DVR_HX_SH

#define DS_71XXHX_SL                2015    // KY2013 DVR

#define DS_76XXH_ST                    2016    // Netra DS_76XXH_ST


#define DS_73XXHFH_ST               2017   //NETRET_7300HFH_ST
#define DS_81XXHFH_ST               2018   //NETRET_8100HFH_ST

#define DS_72XXHFH_SL                2019    //hi3521 
#define DS_FDXXCGA_FLT                2020    //2 HD ATM

#define IDS_91XX_HF_ST_A            2100    //iDS-9100HF-ST/A
#define IDS_91XX_HF_ST_B            2101    //iDS-9100HF-ST/B
#define IDS_90XX_HF_ST_A            2102    //iDS-9000HF-ST/A
#define IDS_90XX_HF_ST_B            2103    //iDS-9000HF-ST/B
#define IDS_81XX_HF_ST_A            2104    //iDS-8100HF-ST/A
#define IDS_81XX_HF_ST_B            2105    //iDS-8100HF-ST/B
#define IDS_80XX_HF_ST_A            2106    //iDS-8000HF-ST/A
#define IDS_80XX_HF_ST_B            2107    //iDS-8000HF-ST/B
#define IDS_8104_AHFL_ST            2108    //iDS-8104-AHFL-ST
#define IDS_2CD6812F_C              2109    //iDS_2CD6812F_C


// NVR
#define DS_77XXN_ST                    2201            // Netra NVR DS-77XXHF-ST
#define DS_95XX_N_ST                2202            // Netra 95XXN_ST NVR          
#define DS_85XX_N_ST                2203            // Netra 85XXN_ST NVR
#define DS_96XX_N_XT                2204            // NETRET_9600NVR_N_XT
#define DS_76XX_N_SE                2205            // NETRET_7600NVR_N_SE

//Inquest DVR
#define DS_86XXSN_SX                2206    // NETRET_8608NVR_SX,Include DS-8608SNL-SP,DS-8608SNL-ST,DS-8608SN-SP,DS-8608SN-ST

//#define DS_96XX_N_RX                2207  //Netra DS-96XX-N-RX
#define DS_71XXN_SL                    2208  //8107 DS-71XXN-SL for civil use
#define CS_N1_1XX                    2209  //8107 CS_N1_1XX,civil

#define DS_71XXN_SN                    2210    //NETRET_71XX_N_SN  
#define CS_N1_2XX                    2211    //NETRET_N1_2XX   
#define DS_76XX_N_SHT                2212    //NETRET_76XX_N_SHT  

#define DS_96XXX_N_E                2213    //NVR 

#define    DS_76XXN_EX                    2214 /* HISI3535  76 78 Series NVR, Note: Includes 4,8,16 road E1 / N / P devic;  8,16, 32 road, / N / P device */
#define DS_77XXN_E4                    2215/* HISI3535  77 Series NVR,  Note: Includes 8,16, 32 road, / N / P device*/
#define DS_86XXN_E8                    2216/* HISI3535  86Series NVR, Includes 8,16 32 road, / N / P device*/
#define DS_9616N_H8                 2217   //DS_9616N_H8
#define DS_72XXHX_EX_GXY            2218   //72 series wireless DVR/NVR 
#define DS_76XXN_EX_GXY             2219   //76 series wireless NVR
#define DS_72XXHXH_SH_21            2220   //  72XXHXH_SH_21
#define DS_72XXHXH_SH_31            2221  //  72XXHXH_SH_31
#define DS_73XXHXH_SH_31            2222  // 73XXHXH_SH_31
#define DS_81XXHXH_SH_31            2223  //  81XXHXH_SH_31
#define DS_71XXHXH_SH_21            2224  // 71XXHXH_SH_21
#define DS_71XXHXH_SH_31            2225  // 71XXHXH_SH_31
#define DS_NBXX_N_E1_X              2226  //NBXX_N_E1_X
#define DS_96XXN_FX                 2230
#define DS_86XXN_FX                 2231
#define DS_96XXXN_HX                2232  

#define DS_86XXN_I                    2233    //DS_86XXN_I
#define DS_77XX_N_I                    2234    //DS_77XX_N_I
#define DS_76XX_N_I                    2235    //DS_76XX_N_I
#define DS_78XX_N_I                    2236    //DS_78XX_N_I
#define DS_96XXXN_IX                 2237    //DS-96XXX_N_I(DS-96128N-I16,DS-96128N-I24,DS-96256N-I16,DS-96256N-I24)

#define DS_90XXHXH_XT               2238    //DS_90XXHXH_XT(DS-9016HQH-XT)

//PCNVR
#define PCNVR_IVMS_4200             2301    //PCNVR_IVMS_4200

#define IVMS_6200_TP                2401    //iVMS-6200/TP
#define IVMS_6200_TF                2402    //iVMS-6200/TF
#define IVMS_6200_D                 2403   //iVMS-6200(/D)
#define IDS_81XXAHW_ST              2405   //iDS-81xxAHW-ST
#define IDS_81XXAHW_SP              2406   //iDS-81xxAHW-SP
#define IDS_81XXAHWL_ST             2407   //iDS-81xxAHWL-ST 
#define IDS_81XXAHWL_SP             2408   //iDS-81xxAHWL-SP
#define IDS_9616N_H8                2409   //iDS_9616N_H8
#define IVMS_6200_SMD               2500   //IVMS_6200_SMD

//HISI3531 ATM DVR
#define DS_81XXAHW_ST                2501
#define DS_81XXAHW_SP                2502
#define DS_81XXAHWL_ST                2503
#define DS_81XXAHWL_SP                2504

//TVI ATM
#define DS_81XXAHGH_E4                2601    //DS_81XXAHGH_E4

#define DS_6904UD_AIOE_H_CLASS      4002    //Integrated machine
#define DS_6402HFH_B21B_CLASS       4005    //B21 BNC coder
#define DS_6902UD_B21H_CLASS        4006    //B21 HDMI decoder
#define DS_6902UD_B21D_CLASS        4007    //B21 DVI decoder
#define DS_6902UD_B21V_CLASS        4008    //B21 VGA decoder
#define DS_6904UD_B20D_CLASS        4010    //B20 DVI decoder
#define DS_6904UD_B20V_CLASS        4011    //B20 VGA decoder

//B21 all-in-one device
#define DS_AIOH_MCU_NP              4042    //main control board
#define DS_6404HFH_AIOH_D           4043    //4 channels DVI input board
#define DS_6908UD_AIOH_D            4044    //4 channels DVI output board
#define DS_6908UD_AIOH_H            4045    //4 channels HDMI output board

//decode all-in-one device
#define DS_69XXUD_B                 4046    //main control board
#define DS_6404HFH_I                4047    //4 channels DVI input board
#define DS_6904UD_O                 4048    //8 channels HDMI output board

//Y10 series
//video cloud magic cube
#define DS_Y10_MCU                  5771    //main board
#define DS_Y10_SW1                  5772    //switch board
#define DS_6516UD_Y10D              5773    //8 channels DVI video output board 
#define DS_6532UD_Y10D              5774    //16 channels DVI video output board
#define DS_6E2724_Y10               5775    //encode access board of 24 10G ports
#define DS_68SAA_AA_Y10             5776    //double channels 2620, 32G memory service board
#define DS_68SBA_AA_Y10             5777    //double channels 2630, 32G memory service board
#define DS_68SCA_AA_Y10             5778    //double channels 2650, 32G memory service board
#define DS_68GPU_A1_Y10             5779    //P4 display board


#define DS_B80_MCU                 5821//main bord
#define DS_B80_SW                  5822//switch bord
#define DS_B80_SR_01               5823//service board
#define DS_B80_AI04                5824//smart analyze board
#define DS_B80_ST                  5825//store board

//Gateway
#define DS_3LGCX                   5841 //general IOT gateway
#define DS_3LGRX                   5842//LoRa gateway
#define DS_3LGT4                   5843    //elevator gateway
#define DS_3LGT40_N 			   5844    //NB-IoT elevator gateway

#define IDS_90XX_HXH_XX_S            6001    //iDS-9016HUHI-K8/S
#define IDS_90XX_HXH_XX_FA           6002    //iDS-9016HUHI-K8/FA

#define DS_81XX_SHXL_K4               6101    //DS-8104SHFH(L)-K4/4P

#define DS_8116THFHL_F4               6201    //DS-8116THFHL-F4

#define DS_81XXAHQ_E4                 6301    //DS_81XXAHQ_E4(TVI ATM)
#define IDS_81XXAHQ_E4                6302    //IDS_81XXAHQ_E4(Smart TVI ATM)

#define IDS_86XX_NX_A               7501    //IDS_86XX_NX_A(iDS-8632NX-I8/A)
#define IDS_96XX_NX_S               7502    //IDS_96XX_NX_S 
#define IDS_96XX_NX_V               7503    //iDS-9632NX-I8/V
#define IDS_96XX_NX_FA              7504    //iDS-9632NX-I8/FA
#define IDS_86XX_NX_IX_B            7505    //iDS-8632NX-I8/B
#define IDS_67XX_NX_S_X             7506    //IDS_67XX_NX/S_X

#define IDS_ECDXX_HE                8001//iDS-ECD8092-H/BNSE
#define IDS_ECDXX_HT                8002//iDS-ECD8092-H/T

#define IDS_ECDXX_E                 8101//iDS-ECD8012-H/E

#define IDS_EPTXX_HF                8201//iDS-EPT8142-H/F

#define DS_2CD69XXX_I               8351    //DS_2CD69XXX_I
#define DS_TRIXX                    8471    //DS_TRI900

#define DS_IEXX_E_J                 11501    //DS_IEXX_E_J(DS-IE6316-E/J)

#define IDS_67XX_NX_A               12501    //IDS_67XX_NX_A(iDS-6704NX/A)
#define IDS_67XX_NX_L               12502    //IDS_67XX_NX_L(iDS-6760NX/L)
#define IDS_ENIXX_XHE               12503    //IDS_ENIXX_XHE(iDS-ENI6001-H/E)
#define IDS_67XX_NX_V               12504    //iDS-6716NX/V
#define IDS_67XX_NX_B               12505    //iDS-6708NX/B

#define DS_IE63XX_E_FA              13001 
#define DS_DS_GPKIA                 13002 
#define DS_DS_PURE                  13003 
#define DS_DS_FS                    13004
#define DS_DS_FD                    13005
#define DS_DS_BLADE                 13006
#define DS_DS_HMCP                  13007
#define DS_LNX_RF                   13501
#define DS_PA_RADAR                 13551
#define DS_PERIMETER_RADAR          13552
#define DS_N1104X                   14001
#define DS_N1103X                   14002
#define NP_FSC201                   14003
#define NP_FDC240                   14004
#define DS_N1107                    14005

//switch
#define DS_3E11XX     5681    //100M switch
#define DS_3E13XX     5682    //1000M up-link switch
#define DS_3E15XX     5683    //1000M switch
#define DS_3E11XXP     5684    //100M POE switch
#define DS_3E13XXP     5685    //1000M up-link POE switch
#define DS_3E15XXP     5686    //1000M switch


//fiber
#define DS_3D01R_NM     5691    //fiber send card
#define DS_3D01T_NM     5692    //fiber receive card
#define DS_3K02_RNM     5693    //fiber manage card




/**********************Device model end***********************/

/**********************Device Class begin**********************/

/* dvr 1-50 */
#define DEV_CLASS_DVR      1          //dvr 
#define DEV_CLASS_INTERROGATION  2    //Interrogation
#define DEV_CLASS_SIMPLE_TRAIL  3    //simple trail
#define DEV_CLASS_TRAIL  4           //trail
#define DEV_CLASS_RECORD_PLAY  5     //record play
#define DEV_CLASS_ATM 6           //ATM

/* dvs 51-100 */
#define DEV_CLASS_DVS 51          //dvs

/* nvr 101-150 */
#define DEV_CLASS_NVR 101          //nvr

/* ipc 151-200 */
#define DEV_CLASS_GUN 151          //ipc gun
#define DEV_CLASS_BALL 152          //ipc ball
#define DEV_CLASS_SNAP 153          //snap
#define DEV_CLASS_INTELLI_TILT 154   //intrllt tilt
#define DEV_CLASS_FISH_EYE 155          //fish eye
#define DEV_CLASS_2DP_Z 156         //2DP_Z
#define DEV_CLASS_2DP 157   //2DP
#define DEV_CLASS_PT 158   //PT
#define DEV_CLASS_TRI 159   //TRI

/* CVR 201 - 250*/
#define DEV_CLASS_CVR 201          //CVR

/* Transfer & Display 251 - 300*/
#define DEV_CLASS_B20 251          //B20
#define DEV_CLASS_B10 252          //B10
#define DEV_CLASS_DECODER 253      //DECODER
#define DEV_CLASS_MATRIXMANAGEDEVICE 254      //MATRIXMANAGEDEVICE
#define DEV_CLASS_OTICAL 255      //OTICA
#define DEV_CLASS_CODESPITTER 256      //CODESPITTER
#define DEV_CLASS_ALARMHOST 257      //ALARMHOST
#define DEV_CLASS_MOVING_RING 258      //MOVING_RING
#define DEV_CLASS_CVCS 259      //CVCS
#define DEV_CLASS_DVCS 260      //DVCS
#define DEV_CLASS_TRANSCODER 261      //TRANSCODER
#define DEV_CLASS_LCD_SCREEN 262      //LCD SCREEN
#define DEV_CLASS_LED_SCREEN 263      //LED SCREEN
#define DEV_CLASS_MATRIX 264      //MATRIX
#define DEV_CLASS_CONFERENCE_SYSTEM 265      //CONFERENCE_SYSTEM
#define DEV_CLASS_INFORMATION_RELEASE_EQUIPMENT  266      // Information release equipment 
#define DEV_CLASS_NET_GAP 267      //net gap
#define DEV_CLASS_MERGE 268      //merge
#define DEV_CLASS_REAR_PROJECTION 269      //rear projection
#define DEV_CLASS_SWITCH 270      //switch
#define DEV_CLASS_FIBER_CONVERTER 271      //fiber converter
#define DEV_CLASS_SCREEN_SERVER 272      //screen server
#define DEV_CLASS_SCE_SERVER 273      //SCE server
#define DEV_CLASS_WIRELESS_TRANS  274    //wireless transmission equipment
#define DEV_CLASS_Y10_SERIES      275    //Y10 series
#define DEV_CLASS_SAFETY_MAVHINE  276    //safety mavhine
#define DEV_CLASS_IOTGATEWAY 277    //IOT gateway
/* ALARM 301 - 350*/
#define DEV_CLASS_VIDEO_ALARM_HOST 301          //video alarm host
#define DEV_CLASS_NET_ALARM_HOST 302          //net alarm host
#define DEV_CLASS_ONE_KEY_ALARM 303      //one key alarm
#define DEV_CLASS_WIRELESS_ALARM_HOST 304      //wireless alarm host
#define DEV_CLASS_ALARM_MODULE 305      //Alarm MOdule
#define DEV_CLASS_HOME_ALARM_HOST 306      //home alarm host
#define DEV_CLASS_HYBRID_ALARM_HOST 307      //hybrid alarm host

/* access control 351 - 400*/
#define DEV_CLASS_ACCESS_CONTROL 351          //access control

/* video intercom 401 - 450*/
#define DEV_CLASS_VIDEO_INTERCOM 401          //video intercom

/* UNNanned aerial vehicle 451 - 500*/
#define DEV_CLASS_UMMANNED_AERIAL_VEHICLE 451          //UNNanned aerial vehicle

/* mobile: 501-550*/
#define DEV_CLASS_MOBILE 501          //mobile

/* mobile vehicle: 551-600*/
#define DEV_CLASS_MOBILE_VEHICLE 551          //mobile vehicle

//Intelligent analyzer :601-650
#define DEV_CLASS_INTELLIGENT_ANALYZER 601  //Intelligent analyzer 

//Intelligent traffic server :651-700
#define DEV_CLASS_INTELLIGENT_TRAFFIC_SERVER 651  //Intelligent traffic server 
#define DS_TP2200_EC                         652  //

/* nvs 701-750 */
#define DEV_CLASS_NVS 701          //nvs

/*RFID 751-800*/
#define DS_TRI21A_1_P 751   //RFID

/* 801-850 */
#define DS_CLASS_FA              801 
#define DS_CLASS_PURE            802 
#define DS_CLASS_FS              803
#define DS_CLASS_FD              804
#define DS_CLASS_HAWK            805
#define DS_CLASS_BLADE           806
#define DS_CLASS_HMCP            807

/* smartlock 851 - 900*/
#define DEV_CLASS_SMART_LOCK     851

/* radar 901 - 950*/
#define DEV_CLASS_RADAR          901

/*panorama detail camera:8451-8470*/
#define iDS_PT              8451  //panorama detail camera

/* other class 65534 */
#define DEV_CLASS_DEFAULT 65534   //default
/**********************Device Class end**********************/

/************************DVR Log begin***************************/

/* Alarm */
//Main Type
#define MAJOR_ALARM                        0x1
//Hypo- Type
#define MINOR_ALARM_IN                    0x1   //Alarm input 
#define MINOR_ALARM_OUT                    0x2   //Alarm output
#define MINOR_MOTDET_START                0x3   //Motion detection alarm start 
#define MINOR_MOTDET_STOP                0x4   //Motion detection alarm stop
#define MINOR_HIDE_ALARM_START            0x5   //Mask alarm start 
#define MINOR_HIDE_ALARM_STOP            0x6   //Mask alarm stop 
#define MINOR_VCA_ALARM_START            0x7   //VCA alarm start 
#define MINOR_VCA_ALARM_STOP            0x8   //VCA alarm stop
#define MINOR_ITS_ALARM_START           0x09  // Traffic event alarm start
#define MINOR_ITS_ALARM_STOP            0x0A  //Traffic event alarm stop
#define MINOR_NETALARM_START            0x0b  //Net alarm start
#define MINOR_NETALARM_STOP             0x0c  //Net alarm stop
//2012-4-5 IPC PIR\wireless\callhelp
#define MINOR_WIRELESS_ALARM_START        0x0e  /* wireless alarm start */
#define MINOR_WIRELESS_ALARM_STOP          0x0f /* wireless alarm stop */
#define MINOR_PIR_ALARM_START           0x10  /* PIR alarm start */
#define MINOR_PIR_ALARM_STOP               0x11  /* PIR alarm stop */
#define MINOR_CALLHELP_ALARM_START      0x12  /* callhelp start */
#define MINOR_CALLHELP_ALARM_STOP          0x13  /* callhelp stop */
#define MINOR_IPCHANNEL_ALARMIN_START   0x14  //IP channel alarm in start: It happens whenPCNVR receives the alarm in from its IP channel.After 10s,  "IP channel alarm in stop" happens if PCNVR can't receive it.  
#define MINOR_IPCHANNEL_ALARMIN_STOP    0x15  //IP channel alarm in stop. 
#define MINOR_DETECTFACE_ALARM_START    0x16  /* Face detection alarm start */
#define MINOR_DETECTFACE_ALARM_STOP      0x17  /* Face detection alarm stop */
#define MINOR_VQD_ALARM_START           0x18  //VQD alarm start
#define MINOR_VQD_ALARM_STOP            0x19  //VQD alarm stop 
#define MINOR_VCA_SECNECHANGE_DETECTION 0x1a  //Sencne Change Detection 2013-07-16 

#define MINOR_SMART_REGION_EXITING_BEGIN                0x1b  //Region Exiting Begin
#define MINOR_SMART_REGION_EXITING_END                  0x1c  //Region Exiting End
#define MINOR_SMART_LOITERING_BEGIN                     0x1d  //Loitering Begin
#define MINOR_SMART_LOITERING_END                       0x1e  //Loitering End

#define MINOR_VCA_ALARM_LINE_DETECTION_BEGIN            0x20  
#define MINOR_VCA_ALARM_LINE_DETECTION_END                0x21 
#define MINOR_VCA_ALARM_INTRUDE_BEGIN                      0x22  //field start    
#define MINOR_VCA_ALARM_INTRUDE_END                           0x23  //field stop    
#define MINOR_VCA_ALARM_AUDIOINPUT                        0x24   //Audio Exception
#define MINOR_VCA_ALARM_AUDIOABNORMAL                     0x25   //Voice ABNORMAL 
#define MINOR_VCA_DEFOCUS_DETECTION_BEGIN                0x26  //defous detection start
#define MINOR_VCA_DEFOCUS_DETECTION_END                    0x27  //defous detection end
#define MINOR_EXT_ALARM                                    0x28             /*IPC External alarm*/
#define MINOR_VCA_FACE_ALARM_BEGIN                        0x29       /*face detect begin*/
#define MINOR_SMART_REGION_ENTRANCE_BEGIN               0x2a  //Region Entrance Begin
#define MINOR_SMART_REGION_ENTRANCE_END                 0x2b  //Region Entrance End
#define MINOR_SMART_PEOPLE_GATHERING_BEGIN              0x2c  //People Gathering Begin
#define MINOR_SMART_PEOPLE_GATHERING_END                0x2d  //People Gathering End
#define MINOR_SMART_FAST_MOVING_BEGIN                   0x2e  //Fast Moving Begin
#define MINOR_SMART_FAST_MOVING_END                     0x2f  //Fast Moving End

#define MINOR_VCA_FACE_ALARM_END                        0x30       /*face detect end*/
#define MINOR_VCA_SCENE_CHANGE_ALARM_BEGIN                0x31   /*scene change start*/
#define MINOR_VCA_SCENE_CHANGE_ALARM_END                0x32   /*scene change end*/
#define MINOR_VCA_ALARM_AUDIOINPUT_BEGIN                0x33   /*audio in put start*/
#define MINOR_VCA_ALARM_AUDIOINPUT_END                    0x34   /*audio in put end*/
#define MINOR_VCA_ALARM_AUDIOABNORMAL_BEGIN                0x35  /*audio abnormal start*/
#define MINOR_VCA_ALARM_AUDIOABNORMAL_END                0x36  /*audio abnormal end*/

#define MINOR_VCA_LECTURE_DETECTION_BEGIN               0x37  //Lecture Alarm Begin
#define MINOR_VCA_LECTURE_DETECTION_END                 0x38  //Lecture Alarm End
#define MINOR_VCA_SITDOWN_DETECTION                         0x38  //Sit Down Detection Alarm
#define MINOR_VCA_ALARM_AUDIOSTEEPDROP                  0x39  //Audio Decibel Steep Drop 2014-03-21
#define MINOR_VCA_ANSWER_DETECTION_BEGIN                0x3a //Answer Detection Begin 
#define MINOR_VCA_ANSWER_DETECTION_END                  0x3b //Answer Detection End

#define MINOR_SMART_PARKING_BEGIN                       0x3c   //Parking Begin
#define MINOR_SMART_PARKING_END                         0x3d   //Parking End
#define MINOR_SMART_UNATTENDED_BAGGAGE_BEGIN            0x3e   //Unattended Baggage Begin
#define MINOR_SMART_UNATTENDED_BAGGAGE_END              0x3f   //Unattended Baggage End
#define MINOR_SMART_OBJECT_REMOVAL_BEGIN                0x40   //Object Removal Begin
#define MINOR_SMART_OBJECT_REMOVAL_END                  0x41   //Object Removal End
#define MINOR_SMART_VEHICLE_ALARM_START                 0x46   //Vehicle alarm Begin
#define MINOR_SMART_VEHICLE_ALARM_STOP                  0x47   //Vehicle alarm Begin
#define MINOR_THERMAL_FIREDETECTION                     0x48   //Fire Detection Begin
#define MINOR_THERMAL_FIREDETECTION_END                 0x49   //Fire Detection End
#define MINOR_SMART_VANDALPROOF_BEGIN                   0x50   //Vandalproof Detection Begin
#define MINOR_SMART_VANDALPROOF_END                     0x51   //Vandalproof Detection End

#define MINOR_FACESNAP_MATCH_ALARM_START                0x55  /*Face snap match alarm start*/
#define MINOR_FACESNAP_MATCH_ALARM_STOP                 0x56  /*Face snap match alarm stop*/
#define MINOR_WHITELIST_FACESNAP_MATCH_ALARM_START      0x57  /*White list facecontrast alarm start*/
#define MINOR_WHITELIST_FACESNAP_MATCH_ALARM_STOP       0x58  /*White list facecontrast alarm end*/

#define MINOR_THERMAL_SHIPSDETECTION                    0x5a   //Thermal Ship Detection
#define MINOR_THERMAL_THERMOMETRY_EARLYWARNING_BEGIN    0x5b   //Thermal Thermometry Early Warning Begin
#define MINOR_THERMAL_THERMOMETRY_EARLYWARNING_END      0x5c   //Thermal Thermometry Early Warning End
#define MINOR_THERMAL_THERMOMETRY_ALARM_BEGIN           0x5d   //Thermal Thermometry Alarm Begin
#define MINOR_THERMAL_THERMOMETRY_ALARM_END             0x5e   //Thermal Thermometry Alarm End
#define MINOR_THERMAL_THERMOMETRY_DIFF_ALARM_BEGIN      0x5f   //Thermal Thermometry diff Alarm Begin
#define MINOR_THERMAL_THERMOMETRY_DIFF_ALARM_END        0x60   //Thermal Thermometry diff Alarm End
#define MINOR_FACE_THERMOMETRY_ALARM                0x63   //face Thermometry Alarm
#define MINOR_SMART_DENSEFOGDETECTION_BEGIN         0x6e  //Dense fog detection Begin
#define MINOR_SMART_DENSEFOGDETECTION_END        0x6f  //Dense fog detection End
#define MINOR_RUNNING_ALARM                         0x70   //Run detection
#define MINOR_RETENTION_ALARM                       0x71   //Detention detection
#define MINOR_SAFETY_HELMET_ALARM_START             0x72  /*No Safety Helmet Alarm Start*/
#define MINOR_SAFETY_HELMET_ALARM_STOP              0x73  /*No Safety Helmet Alarm End*/
#define MINOR_HFPD_ALARM_START                      0x74  /*HFPD alarm start*/
#define MINOR_HFPD_ALARM_STOP                       0x75  /*HFPD alarm stop*/
#define MINOR_MIXED_TARGET_ALARM_START              0x76  /*Mixed target alarm start*/
#define MINOR_MIXED_TARGET_ALARM_STOP               0x77  /*Mixed target alarm stop*/
#define MINOR_VCA_GET_UP_ALARM_BEGIN        0x80   //get up alarm begin
#define MINOR_VCA_GET_UP_ALARM_END        0x81   //get up alarm end
#define MINOR_VCA_ADV_REACH_HEIGHT_ALARM_BEGIN      0x82   //adv reach height alarm begin
#define MINOR_VCA_ADV_REACH_HEIGHT_ALARM_END        0x83   //adv reach height alarm end
#define MINOR_VCA_TOILET_TARRY_ALARM_BEGIN        0x84   //toilet tarry alarm begin
#define MINOR_VCA_TOILET_TARRY_ALARM_END        0x85   //toilet tarry alarm end
#define MINOR_HUMAN_RECOGNITION_ALARM_BEGIN         0x86   //humanrecognition alarm begin
#define MINOR_HUMAN_RECOGNITION_ALARM_END           0x87   //humanrecognition alarm end
#define MINOR_STUDENTS_STOODUP_ALARM_BEGIN          0x88   //Students stoodup alarm begin
#define MINOR_STUDENTS_STOODUP_ALARM_END            0x89   //Students stoodup alarm end
#define MINOR_FRAMES_PEOPLE_COUNTING_ALARM          0x8a   //Frames People Counting Alarm
#define MINOR_FACE_SNAP_ALARM_BEGIN                 0x8b   //Face snap alarm begin
#define MINOR_FACE_SNAP_ALARM_END                   0x8c   //Face snap alarm end
#define MINOR_TEACHER_BEHAVIOR_DETECT_ALARM_BEGIN   0x8d   //Teacher behavior detect alarm begin
#define MINOR_TEACHER_BEHAVIOR_DETECT_ALARM_END     0x8e   //
#define MINOR_PERIMETER_CAPTURE_ALARM_BEGIN         0x8f   //perimeterCapture alarm begin
#define MINOR_PERIMETER_CAPTURE_ALARM_END           0x90   //perimeterCapture alarm end
#define MINOR_UNREGISTERED_STREET_VENDOR_ALARM      0x91  //unregistered street vendor alarm

#define MINOR_PERSON_QUEUE_TIME_ALARM_BEGIN         0x92   //Queue time detection alarm begin
#define MINOR_PERSON_QUEUE_TIME_ALARM_END           0x93   //Queue time detection alarm end
#define MINOR_PERSON_QUEUE_COUNTING_ALARM_BEGIN     0x94   //Queue cpunting detection alarm begin
#define MINOR_PERSON_QUEUE_COUNTING_ALARM_END       0x95   //Queue cpunting detection alarm end
#define MINOR_FACE_SNAP_MATCH_FAILURE_ALARM_START   0x96   //Face snap match failure alarm start
#define MINOR_FACE_SNAP_MATCH_FAILURE_ALARM_END     0x97   //Face snap match failure alarm end


#define MINOR_ACCESS_CONTROLLER_EVENT               0x100  //access controller event
#define MINOR_VIDEO_INTERCOM_EVENT                  0x101  //video intercom event
#define MINOR_GJD_EVENT                             0x102  //GJD event
#define MINOR_LUMINITE_EVENT                        0x103  //LUMINITE event
#define MINOR_OPTEX_EVENT                           0x104  //OPTEX event
#define MINOR_CAMERA_DETECTOR_EVENT                 0x105  //camera detector event
#define MINOR_SECURITY_CONTROL_PANEL_EVENT          0x106  //security control panel event

#define MINOR_VCA_SPACE_CHANGE_START                0x10c //Space change detect start
#define MINOR_VCA_SPACE_CHANGE_STOP                 0x10d //Space change detect end
#define MINOR_MANUAL_ALARM                          0x10e //Manual alarm
#define MINOR_DETECTOR_ALARM                        0x10f //Detector alarm
#define MINOR_LINKAGE_ALARM                         0x110 //Linkage alarm
#define MINOR_VCA_SITUATION_ANALYSIS_START          0x111 //Situational analysis testing begin
#define MINOR_VCA_SITUATION_ANALYSIS_STOP           0x112 //Situational analysis testing end
#define MINOR_FIRE_ALARM                            0x113 //Fire alarm
#define MINOR_SUPERVISE_ALARM                       0x114 //supervise Alarm
#define MINOR_SHIELD_ALARM                          0x115 //shield Alarm
#define MINOR_ABNORMAL_ALARM                        0x116 //abnormal alarm
#define MINOR_RESIDUAL_CURRENT_ALARM                0x117 //resiidual current alarm
#define MINOR_TEMPERATURE_ALARM                     0x118 //temperature alarm
#define MINOR_ARC_ALARM                             0x119 //arc alarm

//0x400-0x1000 access card alarm 
#define MINOR_ALARMIN_SHORT_CIRCUIT                 0x400  //region short circuit 
#define MINOR_ALARMIN_BROKEN_CIRCUIT                0x401  //region broken circuit
#define MINOR_ALARMIN_EXCEPTION                     0x402  //region exception 
#define MINOR_ALARMIN_RESUME                        0x403  //region resume 
#define MINOR_HOST_DESMANTLE_ALARM                  0x404  //host desmantle alarm 
#define MINOR_HOST_DESMANTLE_RESUME                 0x405  //host desmantle resume 
#define MINOR_CARD_READER_DESMANTLE_ALARM           0x406  //card reader desmantle alarm 
#define MINOR_CARD_READER_DESMANTLE_RESUME          0x407  //card reader desmantle resume
#define MINOR_CASE_SENSOR_ALARM                     0x408  //case sensor alarm 
#define MINOR_CASE_SENSOR_RESUME                    0x409  //case sensor resume 
#define MINOR_STRESS_ALARM                          0x40a  //stress alarm 
#define MINOR_OFFLINE_ECENT_NEARLY_FULL             0x40b  //offline ecent nearly full 
#define MINOR_CARD_MAX_AUTHENTICATE_FAIL            0x40c  //card max authenticate fall  
#define MINOR_SD_CARD_FULL                          0x40d  //SD card is full
#define MINOR_LINKAGE_CAPTURE_PIC                   0x40e  //lingage capture picture
#define MINOR_SECURITY_MODULE_DESMANTLE_ALARM        0x40f  //Door control security module desmantle alarm
#define MINOR_SECURITY_MODULE_DESMANTLE_RESUME        0x410  //Door control security module desmantle resume
#define MINOR_POS_START_ALARM                       0x411  //POS Start
#define MINOR_POS_END_ALARM                         0x412  //POS end
#define MINOR_FACE_IMAGE_QUALITY_LOW                0x413  //face image quality low
#define MINOR_FINGE_RPRINT_QUALITY_LOW              0x414  //finger print quality low
#define MINOR_FIRE_IMPORT_SHORT_CIRCUIT             0x415  //Fire import short circuit
#define MINOR_FIRE_IMPORT_BROKEN_CIRCUIT            0x416  //Fire import broken circuit
#define MINOR_FIRE_IMPORT_RESUME                    0x417  //Fire import resume
#define MINOR_FIRE_BUTTON_TRIGGER                   0x418  //fire button trigger
#define MINOR_FIRE_BUTTON_RESUME                    0x419  //fire button resume
#define MINOR_MAINTENANCE_BUTTON_TRIGGER            0x41a  //maintenance button trigger
#define MINOR_MAINTENANCE_BUTTON_RESUME             0x41b  //maintenance button resume
#define MINOR_EMERGENCY_BUTTON_TRIGGER              0x41c  //emergency button trigger
#define MINOR_EMERGENCY_BUTTON_RESUME               0x41d  //emergency button resume
#define MINOR_DISTRACT_CONTROLLER_ALARM             0x41e  //distract controller alarm
#define MINOR_DISTRACT_CONTROLLER_RESUME            0x41f  //distract controller resume

#define MINOR_PERSON_DENSITY_DETECTION_START        0x420  //Person Density Detection Start
#define MINOR_PERSON_DENSITY_DETECTION_END          0x421  //Person Density Detection Start

#define MINOR_CHANNEL_CONTROLLER_DESMANTLE_ALARM    0x422  //channel controller desmantle alarm
#define MINOR_CHANNEL_CONTROLLER_DESMANTLE_RESUME   0x423  //channel controller desmantle resume
#define MINOR_CHANNEL_CONTROLLER_FIRE_IMPORT_ALARM  0x424  //channel controller fire import alarm
#define MINOR_CHANNEL_CONTROLLER_FIRE_IMPORT_RESUME 0x425  //channel controller fire import resume

#define MINOR_HEART_RATE_ABNORMAL_BEGIN             0x426    //Abnormal heart rate alarm begin
#define MINOR_HEART_RATE_ABNORMAL_END               0x427    //Abnormal heart rate alarm end
#define MINOR_BLOOD_OXYGEN_ABNORMAL_BEGIN           0x428    //Blood oxygen abnormal alarm begin
#define MINOR_BLOOD_OXYGEN_ABNORMAL_END             0x429    //Blood oxygen abnormal alarm end
#define MINOR_SYSTOLIC_BLOOD_PRESSURE_ABNORMAL_BEGIN   0x42a    //Blood pressure systolic abnormal alarm begin
#define MINOR_SYSTOLIC_BLOOD_PRESSURE_ABNORMAL_END     0x42b    //Blood pressure systolic abnormal alarm end
#define MINOR_DIASTOLIC_BLOOD_PRESSURE_ABNORMAL_BEGIN  0x42c    //Blood pressure diastolic abnormal alarm begin
#define MINOR_DIASTOLIC_BLOOD_PRESSURE_ABNORMAL_END    0x42d    //Blood pressure diastolic abnormal alarm end
#define MINOR_VCA_LEAVE_POSITION_START              0x42e//Leave position start
#define MINOR_VCA_LEAVE_POSITION_STOP               0x42f//Leave position end
#define MINOR_VCA_STOOODUP_START                    0x430//Stand up start
#define MINOR_VCA_STOOODUP_STOP                     0x431//Stand up end
#define MINOR_VCA_PEOPLENUM_CHANGE_START            0x434//People number change start
#define MINOR_VCA_PEOPLENUM_CHANGE_STOP             0x435//People number change end
#define MINOR_VCA_RUNNING_START                     0x438//Running start
#define MINOR_VCA_RUNNING_STOP                      0x439//Running end
#define MINOR_VCA_VIOLENT_MOTION_START              0x43a//Violent motion start
#define MINOR_VCA_VIOLENT_MOTION_STOP               0x43b//Violent motion end
#define MINOR_VCA_FAIL_DOWN_START                   0x43c//Fail down start
#define MINOR_VCA_FAIL_DOWN_STOP                    0x43d//Fail down end
#define MINOR_VCA_RETENTION_START                   0x43e//Rention start
#define MINOR_VCA_RETENTION_STOP                    0x43f//Rention end

#define MINOR_PRINTER_OUT_OF_PAPER               0x440   //printer no paper
#define MINOR_LEGAL_EVENT_NEARLY_FULL            0x442   //Offline legal event nearly full

#define MINOR_ALARM_CUSTOM1                         0x900  //alarm custom 1
#define MINOR_ALARM_CUSTOM2                         0x901  //alarm custom 2
#define MINOR_ALARM_CUSTOM3                         0x902  //alarm custom 3
#define MINOR_ALARM_CUSTOM4                         0x903  //alarm custom 4
#define MINOR_ALARM_CUSTOM5                         0x904  //alarm custom 5
#define MINOR_ALARM_CUSTOM6                         0x905  //alarm custom 6
#define MINOR_ALARM_CUSTOM7                         0x906  //alarm custom 7
#define MINOR_ALARM_CUSTOM8                         0x907  //alarm custom 8
#define MINOR_ALARM_CUSTOM9                         0x908  //alarm custom 9
#define MINOR_ALARM_CUSTOM10                        0x909  //alarm custom 10
#define MINOR_ALARM_CUSTOM11                        0x90a  //alarm custom 11
#define MINOR_ALARM_CUSTOM12                        0x90b  //alarm custom 12
#define MINOR_ALARM_CUSTOM13                        0x90c  //alarm custom 13
#define MINOR_ALARM_CUSTOM14                        0x90d  //alarm custom 14
#define MINOR_ALARM_CUSTOM15                        0x90e  //alarm custom 15
#define MINOR_ALARM_CUSTOM16                        0x90f  //alarm custom 16
#define MINOR_ALARM_CUSTOM17                        0x910  //alarm custom 17
#define MINOR_ALARM_CUSTOM18                        0x911  //alarm custom 18
#define MINOR_ALARM_CUSTOM19                        0x912  //alarm custom 19
#define MINOR_ALARM_CUSTOM20                        0x913  //alarm custom 20
#define MINOR_ALARM_CUSTOM21                        0x914  //alarm custom 21
#define MINOR_ALARM_CUSTOM22                        0x915  //alarm custom 22
#define MINOR_ALARM_CUSTOM23                        0x916  //alarm custom 23
#define MINOR_ALARM_CUSTOM24                        0x917  //alarm custom 24
#define MINOR_ALARM_CUSTOM25                        0x918  //alarm custom 25
#define MINOR_ALARM_CUSTOM26                        0x919  //alarm custom 26
#define MINOR_ALARM_CUSTOM27                        0x91a  //alarm custom 27
#define MINOR_ALARM_CUSTOM28                        0x91b  //alarm custom 28
#define MINOR_ALARM_CUSTOM29                        0x91c  //alarm custom 29
#define MINOR_ALARM_CUSTOM30                        0x91d  //alarm custom 30
#define MINOR_ALARM_CUSTOM31                        0x91e  //alarm custom 31
#define MINOR_ALARM_CUSTOM32                        0x91f  //alarm custom 32
#define MINOR_ALARM_CUSTOM33                        0x920  //alarm custom 33
#define MINOR_ALARM_CUSTOM34                        0x921  //alarm custom 34
#define MINOR_ALARM_CUSTOM35                        0x922  //alarm custom 35
#define MINOR_ALARM_CUSTOM36                        0x923  //alarm custom 36
#define MINOR_ALARM_CUSTOM37                        0x924  //alarm custom 37
#define MINOR_ALARM_CUSTOM38                        0x925  //alarm custom 38
#define MINOR_ALARM_CUSTOM39                        0x926  //alarm custom 39
#define MINOR_ALARM_CUSTOM40                        0x927  //alarm custom 40
#define MINOR_ALARM_CUSTOM41                        0x928  //alarm custom 41
#define MINOR_ALARM_CUSTOM42                        0x929  //alarm custom 42
#define MINOR_ALARM_CUSTOM43                        0x92a  //alarm custom 43
#define MINOR_ALARM_CUSTOM44                        0x92b  //alarm custom 44
#define MINOR_ALARM_CUSTOM45                        0x92c  //alarm custom 45
#define MINOR_ALARM_CUSTOM46                        0x92d  //alarm custom 46
#define MINOR_ALARM_CUSTOM47                        0x92e  //alarm custom 47
#define MINOR_ALARM_CUSTOM48                        0x92f  //alarm custom 48
#define MINOR_ALARM_CUSTOM49                        0x930  //alarm custom 49
#define MINOR_ALARM_CUSTOM50                        0x931  //alarm custom 50
#define MINOR_ALARM_CUSTOM51                        0x932  //alarm custom 51
#define MINOR_ALARM_CUSTOM52                        0x933  //alarm custom 52
#define MINOR_ALARM_CUSTOM53                        0x934  //alarm custom 53
#define MINOR_ALARM_CUSTOM54                        0x935  //alarm custom 54
#define MINOR_ALARM_CUSTOM55                        0x936  //alarm custom 55
#define MINOR_ALARM_CUSTOM56                        0x937  //alarm custom 56
#define MINOR_ALARM_CUSTOM57                        0x938  //alarm custom 57
#define MINOR_ALARM_CUSTOM58                        0x939  //alarm custom 58
#define MINOR_ALARM_CUSTOM59                        0x93a  //alarm custom 59
#define MINOR_ALARM_CUSTOM60                        0x93b  //alarm custom 60
#define MINOR_ALARM_CUSTOM61                        0x93c  //alarm custom 61
#define MINOR_ALARM_CUSTOM62                        0x93d  //alarm custom 62
#define MINOR_ALARM_CUSTOM63                        0x93e  //alarm custom 63
#define MINOR_ALARM_CUSTOM64                        0x93f  //alarm custom 64
#define MINOR_LOCK_HIJIACK_FINGER_ALARM         0x950       
#define MINOR_LOCK_HIJIACK_PASSWORD_ALARM       0x951       
#define MINOR_LOCK_PRY_DOOR_ALARM               0x952       
#define MINOR_LOCK_LOCKED_ALARM                 0x953       
#define MINOR_LOCK_BATTERLOW_ALARM              0x954      
#define MINOR_LOCK_BLACKLIST_DOOR_ALARM         0x955       
#define MINOR_LOCK_OFFLINE_ALARM                0x956       
#define MINOR_LOCK_UNCLOSED_ALARM               0x957       
#define MINOR_LOCK_NO_HOME_ALARM                0x958       
#define MINOR_LOCK_MAGNETOMETER_ALARM           0x959       
#define MINOR_LOCK_IR_DETECTOR_ALARM            0x95a       
#define MINOR_LOCK_FP_LOCKED_ALARM              0x95b       
#define MINOR_LOCK_PASSWORD_LOCKED_ALARM        0x95c       
#define MINOR_LOCK_HIJIACK_ALARM              0x95d 


//2018-04-23 General gateway alarm type log
#define MINOR_ALARMHOST_SHORT_CIRCUIT    	      0x1001      //Short circuit alarm
#define MINOR_ALARMHOST_BROKEN_CIRCUIT   		  0x1002       //Broken circuit alarm
#define MINOR_ALARMHOST_ALARM_RESET      	      0x1003       //alarm reset
#define MINOR_ALARMHOST_ALARM_NORMAL			  0x1004   	//Alarm resumes to normal
#define MINOR_ALARMHOST_PASSWORD_ERROR 		  0x1005		//Password error(consecutive times for password error)
#define MINOR_ALARMHOST_ID_CARD_ILLEGALLY 	  0x1006		//Illegal proximity card ID
#define MINOR_ALARMHOST_KEYPAD_REMOVE 		  0x1007	//Keypad tamper
#define MINOR_ALARMHOST_KEYPAD_REMOVE_RESTORE   0x1008	//Keypad tamper reset

#define MINOR_ALARMHOST_BELOW_ALARM_LIMIT1 	  0x1011	//Analog lower than alarm limit 1
#define MINOR_ALARMHOST_BELOW_ALARM_LIMIT2 	  0x1012    //Analog lower than alarm limit 2
#define MINOR_ALARMHOST_BELOW_ALARM_LIMIT3 	  0x1013    //Analog lower than alarm limit 3
#define MINOR_ALARMHOST_BELOW_ALARM_LIMIT4 	  0x1014    //Analog lower than alarm limit 4
#define MINOR_ALARMHOST_ABOVE_ALARM_LIMIT1 	  0x1015    //Analog higher than alarm limit 1
#define MINOR_ALARMHOST_ABOVE_ALARM_LIMIT2 	0x1016    //Analog higher than alarm limit 2
#define MINOR_ALARMHOST_ABOVE_ALARM_LIMIT3 	0x1017     //Analog higher than alarm limit 3
#define MINOR_ALARMHOST_ABOVE_ALARM_LIMIT4 	0x1018     //Analog higher than alarm limit 4

#define MINOR_ALARMHOST_VIRTUAL_DEFENCE_BANDIT 	0x1021      //Virtual zone bandit
#define MINOR_ALARMHOST_VIRTUAL_DEFENCE_FIRE 		0x1022       //virtual zone fire
#define MINOR_ALARMHOST_VIRTUAL_DEFENCE_URGENT 		0x1023       //virtual zone urgent

#define MINOR_UPS_ALARM			0x1028      //UPS alarm
#define MINOR_ELECTRICITY_METER_ALARM 0x1029     //electricity meter alarm
#define MINOR_SWITCH_POWER_ALARM	  0x1030     //switch power alarm
#define MINOR_GAS_DETECT_SYS_ALARM	  0x1031    //gas detect system alarm
#define MINOR_TRANSFORMER_TEMPRATURE_ALARM 0x1032     //transformer temprature alarm
#define MINOR_TEMP_HUMI_ALARM		0x1033   //temprature&huminity sensor alarm
#define MINOR_UPS_ALARM_RESTORE	0x1034    //UPS alarm restore
#define MINOR_ELECTRICITY_METER_ALARM_RESTORE 0x1035   //electricity meter alarm restore
#define MINOR_SWITCH_POWER_ALARM_RESTORE	0x1036   //switch power alarm restore
#define MINOR_GAS_DETECT_SYS_ALARM_RESTORE	  0x1037   //gas detect system alarm restore
#define MINOR_TRANSFORMER_TEMPRATURE_ALARM_RESTORE 0x1038            //transformer temprature alarm restore
#define MINOR_TEMP_HUMI_ALARM_RESTORE	0x1039     //temprature&huminity sensor alarm restore
#define MINOR_WATER_LEVEL_SENSOR_ALARM 		0x1040     //water level sensor alarm
#define MINOR_WATER_LEVEL_SENSOR_ALARM_RESTORE 	0x1041  //water level sensor alarm restore
#define MINOR_DUST_NOISE_ALARM 	0x1042  //dust and noise alarm
#define MINOR_DUST_NOISE_ALARM_RESTORE 	0x1043     //dust and noise alarm restore
#define MINOR_ENVIRONMENTAL_LOGGER_ALARM 	0x1044    //environmental logger alarm
#define MINOR_ENVIRONMENTAL_LOGGER_ALARM_RESTORE 0x1045            //environmental logger alarm restore

#define MINOR_TRIGGER_TAMPER    0x1046     //trigger tamper
#define MINOR_TRIGGER_TAMPER_RESTORE     0x1047    //trigger tamper restore
#define MINOR_EMERGENCY_CALL_HELP_ALARM    0x1048       //emergency call help alarm
#define MINOR_EMERGENCY_CALL_HELP_ALARM_RESTORE 0x1049            //emergency call help alarm restore
#define MINOR_CONSULTING_ALARM     0x1050    //consult alarm
#define MINOR_CONSULTING_ALARM_RESTORE   0x1051     //consult alarm restore
#define MINOR_ALARMHOST_ZONE_MODULE_REMOVE      0x1052    //zone module remove
#define MINOR_ALARMHOST_ZONE_MODULE_RESET     0x1053       //zone module reset

#define MINOR_ALARMHOST_ALARM_WIND_SPEED_ALARM      0x1054      //anemograph sensor alarm
#define MINOR_ALARMHOST_ALARM_WIND_SPEED_ALARM_RESTORE   0x1055      //anemograph sensor alarm restore
#define MINOR_ALARMHOST_ALARM_GENERATE_OUTPUT_ALARM   0x1056   //general output module alarm
#define MINOR_ALARMHOST_ALARM_GENERATE_OUTPUT_RESTORE    0x1057     //general output module alarm restore
#define MINOR_ALARMHOST_ALARM_SOAK_ALARM      0x1058      //soggy sensor alarm
#define MINOR_ALARMHOST_ALARM_SOAK_ALARM_RESTORE   0x1059  //soggy sensor alarm restore
#define MINOR_ALARMHOST_ALARM_SOLAR_POWER_ALARM    0x1060    //solar power sensor alarm
#define MINOR_ALARMHOST_ALARM_SOLAR_POWER_ALARM_RESTORE 0x1061   //solar power sensor alarm restore
#define MINOR_ALARMHOST_ALARM_SF6_ALARM   0x1062      //SF6 alarm host alarm
#define MINOR_ALARMHOST_ALARM_SF6_ALARM_RESTORE   0x1063    //SF6 alarm host alarm restore
#define MINOR_ALARMHOST_ALARM_WEIGHT_ALARM    0x1064      //weighing instrument alarm
#define MINOR_ALARMHOST_ALARM_WEIGHT_ALARM_RESTORE    0x1065   //weighing instrument alarm restore
#define MINOR_ALARMHOST_ALARM_WEATHER_ALARM   0x1066   //atmospherium system alarm
#define MINOR_ALARMHOST_ALARM_WEATHER_ALARM_RESTORE    0x1067     //atmospherium system alarm restore
#define MINOR_ALARMHOST_ALARM_FUEL_GAS_ALARM     0x1068  //Gas monitor system alarm
#define MINOR_ALARMHOST_ALARM_FUEL_GAS_ALARM_RESTORE  0x1069 //Gas monitor system alarm restore
#define MINOR_ALARMHOST_ALARM_FIRE_ALARM   0x1070  //fire disaster alarm system alarm
#define MINOR_ALARMHOST_ALARM_FIRE_ALARM_RESTORE    0x1071   //fire disaster alarm system alarm restore
#define  MINOR_ALARMHOST_WIRELESS_OUTPUT_MODULE_REMOVE     0x1072   //wireless output module alarm
#define  MINOR_ALARMHOST_WIRELESS_OUTPUT_MODULE_RESET    0x1073  //wireless output module alarm restore
#define  MINOR_ALARMHOST_WIRELESS_REPEATER_MODULE_REMOVE   0x1074  //wireless repeater tamper alarm

#define  MINOR_ALARMHOST_WIRELESS_SIREN_MODULE_REMOVE     0x1075  //wireless alarm number tamper alarm
#define  MINOR_ALARMHOST_WIRELESS_SIREN_MODULE_RESET     0x1076 //wireless alarm number tamper alarm restore

#define  MINOR_RS485_DEV_ALARM     0x1077   //rs485 device alarm (for unknown rs485 device type)
#define  MINOR_RS485_DEV_RESTORE    0x1078  //rs485 device restore (for unknown rs485 device type)
#define  MINOR_ALARMHOST_ALARM_HOST_ALARM     0x1079      //Alarm host alarm
#define  MINOR_ALARMHOST_ALARM_HOST_RESTORE    0x107a     //Alarm host restore

#define  MINOR_AIR_CONDITION_DEV_ALARM     0x107b      //Air condition alarm
#define  MINOR_AIR_CONDITION_DEV_RESTORE    0x107c     //Air condition restore

#define  MINOR_ALARMHOST_WIRELESS_REPEATER_MODULE_RESET  0x107d //wireless repeater tamper alarm restore

#define	 MINOR_ALARM_ELEVATOR_BREAKDOWN     0x107e//Elevator breakdown
#define  MINOR_WATER_PRESSURE_SENSOR_ALARM      0x107f    // water pressure sensor alarm
#define  MINOR_FLOW_SENSOR_ALARM                0x1080    // flow sensor alarm


/*Exception */
//Main Type
#define MAJOR_EXCEPTION                    0x2
//Hypo- Type
#define MINOR_SUBSYSTEM_ERROR           0x0a    /* subsystem error */
#define MINOR_RAID_ERROR                0x20    /* RAID Exception */
#define MINOR_VI_LOST                    0x21  //Video loss
#define MINOR_ILLEGAL_ACCESS            0x22  //Illegal access 
#define MINOR_HD_FULL                    0x23  //HD full 
#define MINOR_HD_ERROR                    0x24  //HD error 
#define MINOR_DCD_LOST                    0x25  //MODEM  off- line (Reserved)  
#define MINOR_IP_CONFLICT                0x26  //IP conflict 
#define MINOR_NET_BROKEN                0x27  //Network disconnected 
#define MINOR_REC_ERROR                 0x28  //Record error 
#define MINOR_IPC_NO_LINK               0x29  //IPC connection failed 
#define MINOR_VI_EXCEPTION              0x2a  //Video input error  (for analog channel only)  
#define MINOR_IPC_IP_CONFLICT           0x2b  //IPC IP conflict
#define MINOR_SENCE_EXCEPTION           0x2c  //Sence exception
#define MINOR_PIC_REC_ERROR             0x2d  //Snapshot error!
#define MINOR_VI_MISMATCH               0x2e  //Video format error.
#define MINOR_RESOLUTION_MISMATCH        0x2f    /*Resolution miamatch */

//2009- 12- 16 Add Video integrated platform Log Type
#define MINOR_FANABNORMAL                0x31  //Video integrated platform: fan abnormal
#define MINOR_FANRESUME                    0x32  //Video integrated platform: fan resume normal
#define MINOR_SUBSYSTEM_ABNORMALREBOOT    0x33  //Video integrated platform: 6467abnormal reboot
#define MINOR_MATRIX_STARTBUZZER        0x34  //Video integrated platform: dm6467 abnormal, start buzzer
//2010- 01- 22
#define MINOR_NET_ABNORMAL                0x35  //Net abnormal
#define MINOR_MEM_ABNORMAL                0x36  //Memory abnormal
#define MINOR_FILE_ABNORMAL                0x37  //File abnormal
#define MINOR_RS485_DEVICE_ABNORMAL        0x3a     /*RS485 connect status exception*/
#define MINOR_RS485_DEVICE_REVERT        0x3b    /*RS485 connect status exception recovry*/
#define MINOR_SCREEN_SUBSYSTEM_ABNORMALREBOOT   0x3c            //abnormal reboot
#define    MINOR_SCREEN_SUBSYSTEM_ABNORMALINSERT    0x3d            //sub board insert
#define    MINOR_SCREEN_SUBSYSTEM_ABNORMALPULLOUT    0x3e            //sub board pull out
#define    MINOR_SCREEN_ABNARMALTEMPERATURE        0x3f            //abnormal temperature
//2012-07-26
#define MINOR_HIGH_TEMPERATURE_PROTECT  0x40 //sub board high temperature protect
//Netra 2.2.2
#define MINOR_RECORD_OVERFLOW           0x41              //Record overflow
#define MINOR_DSP_ABNORMAL              0x42              //DSP abnormal
//Netra 3.0.0
#define MINOR_ANR_RECORD_FAIED                 0x43            /*ANR record failed*/ 
#define MINOR_SPARE_WORK_DEVICE_EXCEPT         0x44            /*Work device failed*/
#define MINOR_START_IPC_MAS_FAILED             0x45            /*Open IPC mas failed*/ 
#define MINOR_IPCM_CRASH                       0x46         /*IPCM crash*/
#define MINOR_POE_POWER_EXCEPTION              0x47         /*POE Power Exception*/
#define MINOR_UPLOAD_DATA_CS_EXCEPTION         0x48          //upload data to cs Exception/
#define MINOR_DIAL_EXCEPTION                   0x49
#define MINOR_AI_LOST                           0x52            /* audio lost */   


#define MINOR_SYNC_IPC_PASSWD                   0x53        /* Sync IPC password exception */
#define MINOR_EZVIZ_OFFLINE                        0x54        /* EZVIZ Offline*/      
#define MINOR_VQD_ABNORMAL                        0x55 //VQD anomalies 
#define MINOR_ACCESSORIES_PLATE                0x57 //accessories abnormal plate 
#define MINOR_KMS_EXPAMSION_DISK_LOST         0x58 // KMS Expansion disk lost 
#define MINOR_ABNORMAL_PORT                 0x59 // Abnormal port 
#define MINOR_CAMERA_ANGLE_ANOMALY          0x60//  Camera angle anomaly
#define MINOR_DATA_DISK_ERROE               0x61//  Data disk error  
#define MINOR_INTELLIGENT_SYSTEM_RUNNING_ERROR     0x62//  Intelligent system running error
#define MINOR_FACESNAP_RESOLUTION_OVERFLOW         0x63//  Face Snap Resolution Overflow
#define MINOR_SMD_RESOLUTION_OVERFLOW              0x64//  SMD Resolution Overflow
#define MINOR_AUDIO_LOSS_EXCEPTION                 0x65//  audio loss exception
#define MINOR_SAFETY_HELMET_EXCEPTION              0x66 // No Safety Helmet Exception
#define MINOR_VCA_PIC_LENGTH_OVERFLOW              0x67 // VCA picture length overflow
#define MINOR_FACE_MODEL_EXCEPTION                 0x68//  Face library model synchronization exception
#define MINOR_SSD_EXCEPTION                        0x69 // SSD exception
#define MINOR_CLUSTER_DEVICE_OFFLINE                 0x70 // cluster devie offline
#define MINOR_CLUSTER_CONFIG_FAILED                  0x71 // cluster config failed
#define MINOR_CLUSTER_DISASTER_TOLERANCE_EXCEPT      0x72 // cluster disaster tolerance except
#define MINOR_CLUSTER_STORFULL_EXCEPTION             0x73 //cluster storfull
#define MINOR_CLUSTER_VERSION_EXCEPTION              0x74  //cluster version exception
#define MINOR_CLUSTER_OFFLINENODE_EXCEPTION          0x75   //cluster offline node exciption
#define MINOR_CLUSTER_RECORDCYCLE_EXCEPTION          0x76   //cluster record cycle exception
#define MINOR_CLUSTER_IPCTRANSFER_EXCEPTION          0x77   //cluster IP transfer exception
#define MINOR_CLUSTER_IPCONFLICT_EXCEPTION           0x78   // cluster IP conflict

#define MINOR_GET_SUB_STREAM_FAILURE                 0x79//get sub stream failure
#define MINOR_HDD_SHM_DETECT_EXCEPTION               0x7a//The hard disk SHM detects the abnormality
#define MINOR_DEVICE_FORTIFY_FAILURE                 0x7b//The alarm of front-end device failed
#define MINOR_EVENT_UPLOAD_EXCEPTION                 0x7c //Event upload exception

//0x400-0x1000 access card exception type 
#define MINOR_DEV_POWER_ON                     0x400  //device power on 
#define MINOR_DEV_POWER_OFF                    0x401  //device power off
#define MINOR_WATCH_DOG_RESET                  0x402  //watch dog reset 
#define MINOR_LOW_BATTERY                      0x403  //low battery 
#define MINOR_BATTERY_RESUME                   0x404  //battery resume 
#define MINOR_AC_OFF                           0x405  //AC off
#define MINOR_AC_RESUME                        0x406  //AC resume 
#define MINOR_NET_RESUME                       0x407  //Net resume
#define MINOR_FLASH_ABNORMAL                   0x408  //FLASH abnormal 
#define MINOR_CARD_READER_OFFLINE              0x409  //card reader offline 
#define MINOR_CARD_READER_RESUME               0x40a  //card reader resume     
#define MINOR_INDICATOR_LIGHT_OFF              0x40b  //Indicator Light Off
#define MINOR_INDICATOR_LIGHT_RESUME           0x40c  //Indicator Light Resume
#define MINOR_CHANNEL_CONTROLLER_OFF           0x40d  //channel controller off
#define MINOR_CHANNEL_CONTROLLER_RESUME        0x40e  //channel controller resume
#define MINOR_SECURITY_MODULE_OFF              0x40f  //Door control security module off
#define MINOR_SECURITY_MODULE_RESUME           0x410  //Door control security module resume
#define MINOR_BATTERY_ELECTRIC_LOW             0x411  //battery electric low(only face device usage)
#define MINOR_BATTERY_ELECTRIC_RESUME          0x412  //battery electric resume(only face device usage)
#define MINOR_LOCAL_CONTROL_NET_BROKEN           0x413  //Local control net broken
#define MINOR_LOCAL_CONTROL_NET_RSUME           0x414  //Local control net resume
#define MINOR_MASTER_RS485_LOOPNODE_BROKEN     0x415  //Master RS485 loop node broken
#define MINOR_MASTER_RS485_LOOPNODE_RESUME     0x416  //Master RS485 loop node resume
#define MINOR_LOCAL_CONTROL_OFFLINE            0x417  //Local control offline
#define MINOR_LOCAL_CONTROL_RESUME             0x418  //Local control resume
#define MINOR_LOCAL_DOWNSIDE_RS485_LOOPNODE_BROKEN  0x419  //Local downside RS485 loop node broken
#define MINOR_LOCAL_DOWNSIDE_RS485_LOOPNODE_RESUME  0x41a  //Local downside RS485 loop node resume
#define MINOR_DISTRACT_CONTROLLER_ONLINE       0x41b  //distract controller online
#define MINOR_DISTRACT_CONTROLLER_OFFLINE      0x41c  //distract controller offline
#define MINOR_ID_CARD_READER_NOT_CONNECT       0x41d  //Id card reader not connected(intelligent dedicated)
#define MINOR_ID_CARD_READER_RESUME            0x41e  //Id card reader connection restored(intelligent dedicated)
#define MINOR_FINGER_PRINT_MODULE_NOT_CONNECT  0x41f  //fingerprint module is not connected(intelligent dedicated)
#define MINOR_FINGER_PRINT_MODULE_RESUME       0x420  //The fingerprint module connection restored(intelligent dedicated)
#define MINOR_CAMERA_NOT_CONNECT               0x421  //Camera not connected
#define MINOR_CAMERA_RESUME                    0x422  //Camera connection restored
#define MINOR_COM_NOT_CONNECT                  0x423  //COM not connected
#define MINOR_COM_RESUME                       0x424  //COM connection restored
#define MINOR_DEVICE_NOT_AUTHORIZE             0x425  //device are not authorized
#define MINOR_PEOPLE_AND_ID_CARD_DEVICE_ONLINE 0x426  //people and ID card device online
#define MINOR_PEOPLE_AND_ID_CARD_DEVICE_OFFLINE 0x427 //people and ID card device offline
#define MINOR_LOCAL_LOGIN_LOCK                 0x428  //local login lock
#define MINOR_LOCAL_LOGIN_UNLOCK               0x429  //local login unlock
#define MINOR_SUBMARINEBACK_COMM_BREAK         0x42a  //submarineback communicate break
#define MINOR_SUBMARINEBACK_COMM_RESUME        0x42b  //submarineback communicate resume
#define MINOR_MOTOR_SENSOR_EXCEPTION           0x42c  //motor sensor exception
#define MINOR_CAN_BUS_EXCEPTION                0x42d  //can bus exception
#define MINOR_CAN_BUS_RESUME                   0x42e  //can bus resume
#define MINOR_GATE_TEMPERATURE_OVERRUN         0x42f  //gate temperature over run
#define MINOR_IR_EMITTER_EXCEPTION             0x430  //IR emitter exception
#define MINOR_IR_EMITTER_RESUME                0x431  //IR emitter resume
#define MINOR_LAMP_BOARD_COMM_EXCEPTION        0x432  //lamp board communicate exception
#define MINOR_LAMP_BOARD_COMM_RESUME           0x433  //lamp board communicate resume
#define MINOR_IR_ADAPTOR_COMM_EXCEPTION        0x434  //IR adaptor communicate exception
#define MINOR_IR_ADAPTOR_COMM_RESUME           0x435  //IR adaptor communicate resume
#define MINOR_PRINTER_ONLINE                    0x436  //printer online
#define MINOR_PRINTER_OFFLINE                    0x437  //printer offline
#define MINOR_4G_MOUDLE_ONLINE       0x438  //4G module online
#define MINOR_4G_MOUDLE_OFFLINE         0x439  //4G module offline
#define MINOR_DSP_START_FAILED         0x43a  //DSP start exception
#define MINOR_SMART_REGULATION_NOT_ALLOWED         0x43b  //smart regulation not allowed


#define MINOR_EXCEPTION_CUSTOM1                 0x900  //exception custom 1
#define MINOR_EXCEPTION_CUSTOM2                 0x901  //exception custom 2
#define MINOR_EXCEPTION_CUSTOM3                 0x902  //exception custom 3
#define MINOR_EXCEPTION_CUSTOM4                 0x903  //exception custom 4
#define MINOR_EXCEPTION_CUSTOM5                 0x904  //exception custom 5
#define MINOR_EXCEPTION_CUSTOM6                 0x905  //exception custom 6
#define MINOR_EXCEPTION_CUSTOM7                 0x906  //exception custom 7
#define MINOR_EXCEPTION_CUSTOM8                 0x907  //exception custom 8
#define MINOR_EXCEPTION_CUSTOM9                 0x908  //exception custom 9
#define MINOR_EXCEPTION_CUSTOM10                0x909  //exception custom 10
#define MINOR_EXCEPTION_CUSTOM11                0x90a  //exception custom 11
#define MINOR_EXCEPTION_CUSTOM12                0x90b  //exception custom 12
#define MINOR_EXCEPTION_CUSTOM13                0x90c  //exception custom 13
#define MINOR_EXCEPTION_CUSTOM14                0x90d  //exception custom 14
#define MINOR_EXCEPTION_CUSTOM15                0x90e  //exception custom 15
#define MINOR_EXCEPTION_CUSTOM16                0x90f  //exception custom 16
#define MINOR_EXCEPTION_CUSTOM17                0x910  //exception custom 17
#define MINOR_EXCEPTION_CUSTOM18                0x911  //exception custom 18
#define MINOR_EXCEPTION_CUSTOM19                0x912  //exception custom 19
#define MINOR_EXCEPTION_CUSTOM20                0x913  //exception custom 20
#define MINOR_EXCEPTION_CUSTOM21                0x914  //exception custom 21
#define MINOR_EXCEPTION_CUSTOM22                0x915  //exception custom 22
#define MINOR_EXCEPTION_CUSTOM23                0x916  //exception custom 23
#define MINOR_EXCEPTION_CUSTOM24                0x917  //exception custom 24
#define MINOR_EXCEPTION_CUSTOM25                0x918  //exception custom 25
#define MINOR_EXCEPTION_CUSTOM26                0x919  //exception custom 26
#define MINOR_EXCEPTION_CUSTOM27                0x91a  //exception custom 27
#define MINOR_EXCEPTION_CUSTOM28                0x91b  //exception custom 28
#define MINOR_EXCEPTION_CUSTOM29                0x91c  //exception custom 29
#define MINOR_EXCEPTION_CUSTOM30                0x91d  //exception custom 30
#define MINOR_EXCEPTION_CUSTOM31                0x91e  //exception custom 31
#define MINOR_EXCEPTION_CUSTOM32                0x91f  //exception custom 32
#define MINOR_EXCEPTION_CUSTOM33                0x920  //exception custom 33
#define MINOR_EXCEPTION_CUSTOM34                0x921  //exception custom 34
#define MINOR_EXCEPTION_CUSTOM35                0x922  //exception custom 35
#define MINOR_EXCEPTION_CUSTOM36                0x923  //exception custom 36
#define MINOR_EXCEPTION_CUSTOM37                0x924  //exception custom 37
#define MINOR_EXCEPTION_CUSTOM38                0x925  //exception custom 38
#define MINOR_EXCEPTION_CUSTOM39                0x926  //exception custom 39
#define MINOR_EXCEPTION_CUSTOM40                0x927  //exception custom 40
#define MINOR_EXCEPTION_CUSTOM41                0x928  //exception custom 41
#define MINOR_EXCEPTION_CUSTOM42                0x929  //exception custom 42
#define MINOR_EXCEPTION_CUSTOM43                0x92a  //exception custom 43
#define MINOR_EXCEPTION_CUSTOM44                0x92b  //exception custom 44
#define MINOR_EXCEPTION_CUSTOM45                0x92c  //exception custom 45
#define MINOR_EXCEPTION_CUSTOM46                0x92d  //exception custom 46
#define MINOR_EXCEPTION_CUSTOM47                0x92e  //exception custom 47
#define MINOR_EXCEPTION_CUSTOM48                0x92f  //exception custom 48
#define MINOR_EXCEPTION_CUSTOM49                0x930  //exception custom 49
#define MINOR_EXCEPTION_CUSTOM50                0x931  //exception custom 50
#define MINOR_EXCEPTION_CUSTOM51                0x932  //exception custom 51
#define MINOR_EXCEPTION_CUSTOM52                0x933  //exception custom 52
#define MINOR_EXCEPTION_CUSTOM53                0x934  //exception custom 53
#define MINOR_EXCEPTION_CUSTOM54                0x935  //exception custom 54
#define MINOR_EXCEPTION_CUSTOM55                0x936  //exception custom 55
#define MINOR_EXCEPTION_CUSTOM56                0x937  //exception custom 56
#define MINOR_EXCEPTION_CUSTOM57                0x938  //exception custom 57
#define MINOR_EXCEPTION_CUSTOM58                0x939  //exception custom 58
#define MINOR_EXCEPTION_CUSTOM59                0x93a  //exception custom 59
#define MINOR_EXCEPTION_CUSTOM60                0x93b  //exception custom 60
#define MINOR_EXCEPTION_CUSTOM61                0x93c  //exception custom 61
#define MINOR_EXCEPTION_CUSTOM62                0x93d  //exception custom 62
#define MINOR_EXCEPTION_CUSTOM63                0x93e  //exception custom 63
#define MINOR_EXCEPTION_CUSTOM64                0x93f  //exception custom 64
#define MINOR_SWITCH_WIRED_NETWORK            0x950
#define MINOR_SWITCH_WIRELESS_NETWORK         0x951
#define MINOR_LOCK_ONLINE_RESUME              0x952

#define MINOR_SUBSYSTEM_IP_CONFLICT            0x4000        //subsystem IP conflict    
#define MINOR_SUBSYSTEM_NET_BROKEN             0x4001        //subsystem net broken
#define    MINOR_FAN_ABNORMAL                  0x4002        //fan abnormal
#define    MINOR_BACKPANEL_TEMPERATURE_ABNORMAL 0x4003        //back panel abnormal
#define    MINOR_SDCARD_ABNORMAL               0x4004  //SD Card Abnormal
#define    MINOR_SDCARD_DAMAGE                 0x4005  //SD Card Damage
#define    MINOR_POC_ABNORMAL				   0x4006   //device poc Abnormal
#define MINOR_MAIN_POWER_FAULT              0x4007 //main power fault
#define MINOR_BACK_UP_POWER_FAULT           0x4008 //back up power fault
#define MINOR_TAMPER_FAULT                  0x4009 //tamper fault
#define MINOR_RS232_FAULT                   0x400a //RS232 fault
#define MINOR_RS485_FAULT                   0x400b //RS485 fault
#define MINOR_LAN_STATUS_FAULT              0x400c //LAN status fault
#define MINOR_LAN_LINK1_FAULT               0x400d //LAN link1 fault
#define MINOR_LAN_LINK2_FAULT               0x400e //LAN link2 fault
#define MINOR_SIM_CARD_STATUS_FAULT         0x400f //SIM card status fault
#define MINOR_4G_LINK1_FAULT                0x4010 //4G link1 fault
#define MINOR_4G_LINK2_FAULT                0x4011 //4G link2 fault
#define MINOR_OTHER_FAULT                   0x4012 //other fault
#define MINOR_FIRE_CONTROL_CONNECT_FAULT    0x4013 //host link fault
#define MINOR_SENSOR_SHORT_CIRCUIT          0x4014 //sensor short circuit
#define MINOR_SENSOR_OPEN_CIRCUIT           0x4015 //sensor open circuit
#define MINOR_SENSOR_MIS_CONNECT            0x4016 //sensor misconnect
#define MINOR_SENSOR_FAULT_RESTORE          0x4017 //sensor fault restore
#define MINOR_DEVICE_FAULT                  0x4018 //device fault

//2018-04-23 General gateway exception type log
#define MINOR_ALARMHOST_WDT_RESET 			    0x1003    //WDT reset
#define MINOR_ALARMHOST_RTC_EXCEPTION 			0x1007    //RTC real-time clock exception

#define MINOR_ALARMHOST_TEL_LINE_CONNECT_FAILURE 	0x100a    //Telephone line is disconnected
#define MINOR_ALARMHOST_TEL_LINE_CONNECT_RESTORE 	0x100b    //Telephone line restore
#define MINOR_ALARMHOST_EXPANDER_BUS_LOSS 		0x100c    //Expansion bus module dropped
#define MINOR_ALARMHOST_EXPANDER_BUS_RESTORE 	0x100d    //Expansion bus module restore
#define MINOR_ALARMHOST_KEYPAD_BUS_LOSS 			0x100e    //Keyboard bus module dropped
#define MINOR_ALARMHOST_KEYPAD_BUS_RESTORE 		0x100f    //Keyboard bus module restore
#define MINOR_ALARMHOST_SENSOR_FAILURE 			0x1010    //Analog sensor failure
#define MINOR_ALARMHOST_SENSOR_RESTORE 			0x1011    //Analog sensor restore
#define MINOR_ALARMHOST_RS485_CONNECT_FAILURE 	0x1012    //RS485 channel is disconnected
#define MINOR_ALARMHOST_RS485_CONNECT_RESTORE 	0x1013    //RS485 channel disconnection restore

#define	MINOR_ALARMHOST_WIRED_NETWORK_ABNORMAL 	0x1015    //network abnormal
#define	MINOR_ALARMHOST_WIRED_NETWORK_RESTORE 		0x1016    //network restore
#define	MINOR_ALARMHOST_GPRS_ABNORMAL 				0x1017    //GPRS abnormal
#define	MINOR_ALARMHOST_GPRS_RESTORE 					0x1018    //GPRS restore
#define	MINOR_ALARMHOST_3G_ABNORMAL 					0x1019    //3G abnormal
#define	MINOR_ALARMHOST_3G_RESTORE 					0x101a    //3G restore
#define	MINOR_ALARMHOST_SIM_CARD_ABNORMAL 			0x101b    //SIM Card abnormal
#define	MINOR_ALARMHOST_SIM_CARD_RESTORE 			0x101c    //SIM Card restore

#define	MINOR_FORMAT_HDD_ERROR  0x1026 //format hard disk error
#define	MINOR_USB_ERROR		0x1027    //USB connect error
#define	MINOR_USB_RESTORE		0x1028    //USB connect restore
#define	MINOR_PRINT_ERROR	  0x1029    //printer error
#define	MINOR_PRINT_RESTORE   0x1030    //printer restore
#define  MINOR_ALARMHOST_SUBSYSTEM_COMMUNICATION_ERROR    0x1031  //subsystem communication error

#define  MINOR_MCU_RESTART    0x1035    //MCU restart
#define  MINOR_GPRS_MODULE_FAULT    0x1036  //GPRS Module Fault
#define  MINOR_TELEPHONE_MODULE_FAULT    0x1037     //Telephone Module Fault
#define  MINOR_WIFI_ABNORMAL  0x1038    //WIFI abnormal
#define  MINOR_WIFI_RESTORE    0x1039    //WIFI restore
#define  MINOR_RF_ABNORMAL   0x103a    //RF signal abnormal
#define  MINOR_RF_RESTORE     0x103b   //RF signal restore
#define  MINOR_DETECTOR_ONLINE   0x103c    //trigger online
#define  MINOR_DETECTOR_OFFLINE    0x103d    //trigger offline
#define  MINOR_DETECTOR_BATTERY_NORMAL    0x103e  //trigger battery normal
#define  MINOR_DETECTOR_BATTERY_LOW 0x103f  //trigger battery low power
#define  MINOR_DATA_TRAFFIC_OVERFLOW    0x1040    //traffic overflow
#define  MINOR_ALARMHOST_ZONE_MODULE_LOSS     0x1041    //zone module offline
#define  MINOR_ALARMHOST_ZONE_MODULE_RESTORE     0x1042    //zone module online
#define  MINOR_WIRELESS_OUTPUT_LOSS     0x1043    //wireless output module loss
#define  MINOR_WIRELESS_OUTPUT_RESTORE    0x1044    //wireless output module restore
#define  MINOR_WIRELESS_REPEATER_LOSS    0x1045    //wireless repeater loss
#define  MINOR_WIRELESS_REPEATER_RESTORE    0x1046    //wireless repeater restore
#define  MINOR_ALARMHOST_TRIGGER_MODULE_LOSS     0x1047    //trigger module loss
#define  MINOR_ALARMHOST_TRIGGER_MODULE_RESTORE    0x1048    //trigger module restore
#define  MINOR_ALARMHOST_WIRELESS_SIREN_LOSS    0x1049    //wireless siren loss
#define  MINOR_ALARMHOST_WIRELESS_SIREN_RESTORE     0x104a    //wireless siren  restore
#define  MINOR_TX1_SUB_SYSTEM_EXCEPTION             0x1050   /*TX1 sub system exception*/
#define  MINOR_TX1_REBOOT_EXCEPTION       0x1051   /*TX1 system reboot exception*/
#define  MINOR_TX1_SUB_SYSTEM_LOSS      0x1052   /*TX1 sub system loss*/
#define  MINOR_TX1_SUB_SYSTEM_RESTORE     0x1053   /*TX1 sub system restore*/
#define MINOR_WIRELESS_SPEED_EXCEPTION   0x1054   //wireless transmit speed exception

/* Operation */
//Main Type
#define MAJOR_OPERATION                    0x3

#define MINOR_VCA_MOTIONEXCEPTION        0x29  //VCA detect exception


//Hypo- Type
#define MINOR_START_DVR                    0x41    /* Power On */
#define MINOR_STOP_DVR                    0x42    /* Power off */
#define MINOR_STOP_ABNORMAL                0x43    /* Illegal shut down */
#define MINOR_REBOOT_DVR                0x44    /*Local reboot DVR*/

#define MINOR_LOCAL_LOGIN                0x50    /* Login  (local)  */
#define MINOR_LOCAL_LOGOUT                0x51    /* Logout  (local) */
#define MINOR_LOCAL_CFG_PARM            0x52    /* Configuration  (local)  */
#define MINOR_LOCAL_PLAYBYFILE            0x53    /* Playback  (local)  */
#define MINOR_LOCAL_PLAYBYTIME            0x54    /* Playback or download by time  (local) */
#define MINOR_LOCAL_START_REC            0x55    /* Start record  (local)  */
#define MINOR_LOCAL_STOP_REC            0x56    /* Stop record  (local) */
#define MINOR_LOCAL_PTZCTRL                0x57    /* PTZ control  (local)  */
#define MINOR_LOCAL_PREVIEW                0x58    /* Preview  (local)  (Reserved) */
#define MINOR_LOCAL_MODIFY_TIME         0x59    /* Change time  (local)  (Reserved)  */
#define MINOR_LOCAL_UPGRADE                0x5a    /* Upgrade  (local)  */
#define MINOR_LOCAL_RECFILE_OUTPUT      0x5b    /* Backup  (local)  */
#define MINOR_LOCAL_FORMAT_HDD          0x5c    /* HD format (local)  */
#define MINOR_LOCAL_CFGFILE_OUTPUT      0x5d    /* Export Configuration  (local)  */
#define MINOR_LOCAL_CFGFILE_INPUT       0x5e    /* Import Configuration  (local)  */
#define MINOR_LOCAL_COPYFILE            0x5f    /* Backup file  (local)  */
#define MINOR_LOCAL_LOCKFILE            0x60    /* File lockup  (local) Reboot IPC  (local)  */
#define MINOR_LOCAL_UNLOCKFILE          0x61    /* File unlock  (local)  */
#define MINOR_LOCAL_DVR_ALARM           0x62    /* Clear/Trigger Alarm  (Local) */
#define MINOR_IPC_ADD                   0x63    /* Add IPC  (local)  */
#define MINOR_IPC_DEL                   0x64    /* Delete IPC  (local) */
#define MINOR_IPC_SET                   0x65    /* Set IPC  (local)  */
#define MINOR_LOCAL_START_BACKUP        0x66    /* local start backup file */
#define MINOR_LOCAL_STOP_BACKUP            0x67    /* local stop backup file*/
#define MINOR_LOCAL_COPYFILE_START_TIME 0x68    /* local backup: file start time*/
#define MINOR_LOCAL_COPYFILE_END_TIME    0x69    /* local backup: file end time*/
#define MINOR_LOCAL_ADD_NAS             0x6a    /* Add network hard disk in local configuration  (NFS/iSCSI) */
#define MINOR_LOCAL_DEL_NAS             0x6b    /* Delete network hard disk in local configuration  (NFS/iSCSI) */
#define MINOR_LOCAL_SET_NAS             0x6c    /* Set network hard disk in local configuration  (NFS/iSCSI) */
#define MINOR_LOCAL_RESET_PASSWD        0x6d    /* Local Resume Admin's Password*/ 

#define MINOR_REMOTE_LOGIN                0x70    /* Login  (remote) */
#define MINOR_REMOTE_LOGOUT                0x71    /* Logout   (remote)  */
#define MINOR_REMOTE_START_REC            0x72    /* Start record  (remote) */
#define MINOR_REMOTE_STOP_REC            0x73    /* Stop record   (remote)  */
#define MINOR_START_TRANS_CHAN            0x74    /* Start transparent channel  (remote)  */
#define MINOR_STOP_TRANS_CHAN            0x75    /* Stop transparent channel  (remote)  */
#define MINOR_REMOTE_GET_PARM            0x76    /* Get parameter  (remote) */
#define MINOR_REMOTE_CFG_PARM            0x77    /* configuration  (remote) */
#define MINOR_REMOTE_GET_STATUS         0x78    /* Get status  (remote)  */
#define MINOR_REMOTE_ARM                0x79    /* On guard   (remote)  */
#define MINOR_REMOTE_DISARM                0x7a    /* Disarm   (remote)  */
#define MINOR_REMOTE_REBOOT                0x7b    /* Reboot   (remote)  */
#define MINOR_START_VT                    0x7c    /* Start voice talk */
#define MINOR_STOP_VT                    0x7d    /* Stop voice talk */
#define MINOR_REMOTE_UPGRADE            0x7e    /* upgrade  (remote)  */
#define MINOR_REMOTE_PLAYBYFILE         0x7f    /* Playback by file name  (remote)  */
#define MINOR_REMOTE_PLAYBYTIME         0x80    /* Playback by time  (remote)  */
#define MINOR_REMOTE_PTZCTRL            0x81    /* PTZ control  (remote)  */
#define MINOR_REMOTE_FORMAT_HDD         0x82    /* Format hard disk (remote)  */
#define MINOR_REMOTE_STOP               0x83    /* Shut Down  (remote)  */
#define MINOR_REMOTE_LOCKFILE            0x84    /* File lockup  (remote)  */
#define MINOR_REMOTE_UNLOCKFILE         0x85    /* File unlock  (remote */
#define MINOR_REMOTE_CFGFILE_OUTPUT     0x86    /* Export Configuration   (remote)  */
#define MINOR_REMOTE_CFGFILE_INTPUT     0x87    /* Import Configuration  (remote)  */
#define MINOR_REMOTE_RECFILE_OUTPUT     0x88    /* Backup recording files  (remote)  */
#define MINOR_REMOTE_DVR_ALARM          0x89    /* Trigger/clear alarm  (remote) */
#define MINOR_REMOTE_IPC_ADD            0x8a    /* Add IPC  (remote) */
#define MINOR_REMOTE_IPC_DEL            0x8b    /* Delete IPC  (remote) */
#define MINOR_REMOTE_IPC_SET            0x8c    /* Set  IPC  (remote) */
#define MINOR_REBOOT_VCA_LIB            0x8d    /* Reboot vca library*/
#define MINOR_REMOTE_ADD_NAS            0x8e    /* Remote add nas disk*/
#define MINOR_REMOTE_DEL_NAS            0x8f    /* Remote delete nas disk*/
#define MINOR_REMOTE_SET_NAS            0x90    /* Remote set nas disk*/
#define MINOR_SCHEDULE_ANGLECALIBRATION 0X9d    /*Periodic inclination calibration*/
#define MINOR_OTHER_OPERATE             0x200    /* other operations */
//2012-11-29 Netra2.3 
#define MINOR_LOCAL_OPERATE_LOCK        0x9d    /* local operate Lock*/
#define MINOR_LOCAL_OPERATE_UNLOCK      0x9e    /* local operate UnLock */
#define MINOR_REMOTE_DELETE_HDISK       0x9a    /* Remote delete HDisk */
#define MINOR_REMOTE_LOAD_HDISK         0x9b    /* Remote Load HDisk*/
#define MINOR_REMOTE_UNLOAD_HDISK       0x9c    /* Remote Unload HDisk   */

//2010- 05- 26 Add Inquest DVR Log Type
#define MINOR_LOCAL_START_REC_CDRW      0x91    /* Local start CD/DVD writing */
#define MINOR_LOCAL_STOP_REC_CDRW       0x92    /* Local stop CD/DVD writing */
#define MINOR_REMOTE_START_REC_CDRW     0x93    /* Remote Start CD/DVD writing  */
#define MINOR_REMOTE_STOP_REC_CDRW      0x94    /* Remote stop CD/DVD writing */

#define MINOR_LOCAL_PIC_OUTPUT            0x95    /* local save picture */ 
#define MINOR_REMOTE_PIC_OUTPUT            0x96    /* remote save picture */

//2011-07-26 Add 81 Inquest DVR Log Type
#define MINOR_LOCAL_INQUEST_RESUME      0x97    /* local resume inquest event*/
#define MINOR_REMOTE_INQUEST_RESUME     0x98    /* remote resume inquest event*/

#define MINOR_LOCAL_ADD_FILE            0x99       
#define MINOR_LOCAL_DEL_FILE            0x9f

#define MINOR_DELETE_LOGO               0xdd    /* delete logo */

#define MINOR_REMOTE_INQUEST_ADD_FILE   0x100       




//2009- 12- 16 Add Video integrated platform Log Type
#define MINOR_SUBSYSTEMREBOOT           0xa0    /*Video integrated platform: dm6467 normal reboot*/
#define MINOR_MATRIX_STARTTRANSFERVIDEO 0xa1    /*Video integrated platform: Matrix Switch start transmitting images*/
#define MINOR_MATRIX_STOPTRANSFERVIDEO    0xa2    /*Video integrated platform: Matrix Switching to stop transmission of images*/
#define MINOR_REMOTE_SET_ALLSUBSYSTEM   0xa3    /*Video integrated platform: Set all the 6467 sub- systems of information*/
#define MINOR_REMOTE_GET_ALLSUBSYSTEM   0xa4    /*Video integrated platform: Get all the 6467 sub- systems of information*/
#define MINOR_REMOTE_SET_PLANARRAY      0xa5    /*Video integrated platform: Set plan array*/
#define MINOR_REMOTE_GET_PLANARRAY      0xa6    /*Video integrated platform: Get plan array*/
#define MINOR_MATRIX_STARTTRANSFERAUDIO 0xa7    /*Video integrated platform: Start transmission Audio Matrix Switch */
#define MINOR_MATRIX_STOPRANSFERAUDIO   0xa8    /*Video integrated platform: Stop transmission Audio Matrix Switch*/
#define MINOR_LOGON_CODESPITTER         0xa9    /*Video integrated platform: Logon spitter code*/
#define MINOR_LOGOFF_CODESPITTER        0xaa    /*Video integrated platform: Logoff spitter code*/
//2010- 01- 22 Add Video integrated platform Log Type
#define MINOR_START_DYNAMIC_DECODE         0xb0    /*Start dynamic decode*/
#define MINOR_STOP_DYNAMIC_DECODE        0xb1    /*Stop dynamic decode*/
#define MINOR_GET_CYC_CFG                0xb2    /*Get cycle config*/
#define MINOR_SET_CYC_CFG                0xb3    /*Set cycle config*/
#define MINOR_START_CYC_DECODE            0xb4    /*Start cycle decode*/
#define MINOR_STOP_CYC_DECODE            0xb5    /*Stop cycle decode*/
#define MINOR_GET_DECCHAN_STATUS        0xb6    /*Get decode channel status*/
#define MINOR_GET_DECCHAN_INFO            0xb7    /*Get decode channel information*/
#define MINOR_START_PASSIVE_DEC            0xb8    /*Start passive*/
#define MINOR_STOP_PASSIVE_DEC            0xb9    /*Stop passive decode*/
#define MINOR_CTRL_PASSIVE_DEC            0xba    /*Passive decode control*/
#define MINOR_RECON_PASSIVE_DEC            0xbb    /*Passive decode reconnect*/
#define MINOR_GET_DEC_CHAN_SW            0xbc    /*Get decode channel switch*/
#define MINOR_SET_DEC_CHAN_SW            0xbd    /*Set decode channel switch*/
#define MINOR_CTRL_DEC_CHAN_SCALE        0xbe    /*Decode channel scale control*/
#define MINOR_SET_REMOTE_REPLAY            0xbf    /*Set remote replay*/
#define MINOR_GET_REMOTE_REPLAY            0xc0    /*Get remote replay*/
#define MINOR_CTRL_REMOTE_REPLAY        0xc1    /*Remote replay control*/
#define MINOR_SET_DISP_CFG                0xc2    /*Set display config*/
#define MINOR_GET_DISP_CFG                0xc3    /*Get display config*/
#define MINOR_SET_PLANTABLE                0xc4    /*Set plan table*/
#define MINOR_GET_PLANTABLE                0xc5    /*Get plan table*/
#define MINOR_START_PPPPOE                0xc6    /*Start pppoe*/
#define MINOR_STOP_PPPPOE                0xc7    /*Stop pppoe*/
#define MINOR_UPLOAD_LOGO                0xc8    /*Upload logo*/

#define MINOR_LOCAL_PIN                    0xc9    /* local PIN operation*/
#define MINOR_LOCAL_DIAL                0xca    /* local manual disconnect dialing*/    
#define MINOR_SMS_CONTROL                0xcb    /* SMS control on line/off line*/    
#define MINOR_CALL_ONLINE                0xcc    /* call control on line*/    
#define MINOR_REMOTE_PIN                0xcd    /* remote PIN operation*/


#define MINOR_REMOTE_ALARMOUT_OPEN_MAN  0xd6    /* remote mamual open alarmout */
#define MINOR_REMOTE_ALARMOUT_CLOSE_MAN 0xd7    /* remote mamual close alarmout*/
#define MINOR_DELETE_LOGO               0xdd    /* delete logo */
#define MINOR_REMOTE_INQUEST_DEL_FILE   0xde 

#define MINOR_LOCAL_CONF_REB_RAID       0x101           /*Rebuild configuration automatically and locally*/
#define MINOR_LOCAL_CONF_SPARE          0x102           /*Hot spare of local configuration*/
#define MINOR_LOCAL_ADD_RAID            0x103           /*Add RAID locally*/
#define MINOR_LOCAL_DEL_RAID            0x104           /*Delete RAID locally*/
#define MINOR_LOCAL_MIG_RAID            0x105           /*Migrate RAID locally*/
#define MINOR_LOCAL_REB_RAID            0x106           /*Rebuild RAID manually and locally*/
#define MINOR_LOCAL_QUICK_CONF_RAID     0x107           /*Quick local configuration by one key*/
#define MINOR_LOCAL_ADD_VD              0x108           /*Add visual disk locally*/
#define MINOR_LOCAL_DEL_VD              0x109           /*Delete visual disk locally*/
#define MINOR_LOCAL_RP_VD               0x10a           /*Repair visual disk locally*/
#define MINOR_LOCAL_FORMAT_EXPANDVD     0X10b           /*Expand volume of visual disk locally*/
#define MINOR_LOCAL_RAID_UPGRADE        0X10c           /*Upgrade RAID locally*/
#define MINOR_LOCAL_STOP_RAID           0x10d           /*Local stop RAID*/

#define MINOR_REMOTE_CONF_REB_RAID      0x111           /*Rebuild configuration automatically and remotely*/
#define MINOR_REMOTE_CONF_SPARE         0x112           /*Hot spare of remote configuration*/
#define MINOR_REMOTE_ADD_RAID           0x113           /*Add RAID remotely*/
#define MINOR_REMOTE_DEL_RAID           0x114           /*Delete RAID remotely*/
#define MINOR_REMOTE_MIG_RAID           0x115           /*Migrate RAID remotely*/
#define MINOR_REMOTE_REB_RAID           0x116           /*Rebuild RAID manually and remotely*/
#define MINOR_REMOTE_QUICK_CONF_RAID    0x117           /*Quick remote configuration by one key*/
#define MINOR_REMOTE_ADD_VD             0x118           /*Add visual disk remotely*/
#define MINOR_REMOTE_DEL_VD             0x119           /*Delete visual disk remotely*/
#define MINOR_REMOTE_RP_VD              0x11a           /*Repair visual disk remotely*/
#define MINOR_REMOTE_FORMAT_EXPANDVD    0X11b           /*Expand volume of visual disk remotely*/
#define MINOR_REMOTE_RAID_UPGRADE       0X11c           /*Upgrade RAID remotely*/  
#define MINOR_REMOTE_STOP_RAID          0x11d           /*Remote stop RAID*/

#define MINOR_LOCAL_START_PIC_REC        0x121           /*local start snapshot*/ 
#define MINOR_LOCAL_STOP_PIC_REC        0x122           /*local stop snapshot*/
#define MINOR_LOCAL_SET_SNMP            0x125           /*local set SNMP*/
#define MINOR_LOCAL_TAG_OPT                0x126           /*local operate label*/
#define MINOR_REMOTE_START_PIC_REC        0x131           /*remote start snapshot*/
#define MINOR_REMOTE_STOP_PIC_REC        0x132           /*remote stop snapshot*/
#define MINOR_REMOTE_SET_SNMP            0x135           /*remote set SNMP*/
#define MINOR_REMOTE_TAG_OPT            0x136           /*remote operate label*/  
#define MINOR_REMOTE_LOGIN_LOCK         0x137           //remote login lock
#define MINOR_REMOTE_LOGIN_UNLOCK       0x138          //remote login unlock
// 9000 v2.2.0
#define MINOR_LOCAL_VOUT_SWITCH         0x140    /* local video out switch*/
#define MINOR_STREAM_CABAC                 0x141    /* stream cabac configuration*/


//Netra 3.0.0
#define MINOR_LOCAL_SPARE_OPT           0x142   /*Local spare opration*/
#define MINOR_REMOTE_SPARE_OPT            0x143   /*Remote spare opration*/
#define MINOR_LOCAL_IPCCFGFILE_OUTPUT    0x144      /*Local export ipc config file*/
#define MINOR_LOCAL_IPCCFGFILE_INPUT      0x145   /*Local import ipc config file */
#define MINOR_LOCAL_IPC_UPGRADE         0x146   /*Local ipc upgrade */
#define MINOR_REMOTE_IPCCFGFILE_OUTPUT  0x147   /*Remote export ipc config file*/
#define MINOR_REMOTE_IPCCFGFILE_INPUT   0x148   /*Remote import ipc config file*/
#define MINOR_REMOTE_IPC_UPGRADE        0x149   /*Remote ipc upgrade*/

#define MINOR_LOCAL_UNLOAD_HDISK        0x150     /*Local unload hdisk*/
#define MINOR_LOCAL_AUDIO_MIX           0x151     /*Local audio mix*/
#define MINOR_REMOTE_AUDIO_MIX          0x152     /*Remote audio mix*/
#define MINOR_LOCAL_TRIAL_PAUSE         0x153     /*Local inquest pause*/
#define MINOR_LOCAL_TRIAL_RESUME        0x154     /*Local inquest resume*/
#define MINOR_REMOTE_TRIAL_PAUSE        0x155     /*Remote inquest paus*/
#define MINOR_REMOTE_TRIAL_RESUME       0x156     /*Remote inquest resume*/
#define MINOR_REMOTE_MODIFY_VERIFICATION_CODE   0x157 /*modify Remote verification code*/

#define MINOR_LOCAL_MAKECALL            0x180          /*Local make call*/
#define MINOR_LOCAL_REJECTCALL          0x181          /*Local reject call*/
#define MINOR_LOCAL_ANSWERCALL          0x182          /*Local answer call*/
#define MINOR_LOCAL_HANGUPCALL          0x183          /*Local hang up call*/

#define MINOR_REMOTE_MAKECALL           0x188          /*Remote make call*/
#define MINOR_REMOTE_REJECTCALL         0x189          /*Remote reject call*/
#define MINOR_REMOTE_ANSWERCALL         0x18a          /*Remote answer call*/
#define MINOR_REMOTE_HANGUPCALL         0x18b          /*Remote hang up call*/

#define MINOR_SET_MULTI_MASTER          0x201    /*set multi master*/
#define MINOR_SET_MULTI_SLAVE           0x202    /*set multi slave*/
#define MINOR_CANCEL_MULTI_MASTER       0x203    /*cancel multi master*/
#define MINOR_CANCEL_MULTI_SLAVE        0x204    /*cancel multi slave*/

#define MINOR_DISPLAY_LOGO                0x205    /*display LOGO*/
#define MINOR_HIDE_LOGO                 0x206    /*hide LOGO*/
#define MINOR_SET_DEC_DELAY_LEVEL       0x207    /*set delay level of decode*/
#define MINOR_SET_BIGSCREEN_DIPLAY_AREA 0x208    /*set big screen display area*/
#define MINOR_CUT_VIDEO_SOURCE          0x209    /*cut video source*/
#define MINOR_SET_BASEMAP_AREA          0x210    /*set basemap area*/
#define MINOR_DOWNLOAD_BASEMAP          0x211    /*download basemap*/
#define MINOR_CUT_BASEMAP               0x212    /*cut basemap*/
#define MINOR_CONTROL_ELEC_ENLARGE      0x213    /*control electronic amplification*/
#define MINOR_SET_OUTPUT_RESOLUTION     0x214    /*set output resolution*/
#define MINOR_SET_TRANCSPARENCY         0X215    /*set layer transparency*/
#define MINOR_SET_OSD                   0x216    /*set OSD*/
#define MINOR_RESTORE_DEC_STATUS        0x217    /*restore decode status after switching scene*/
#define MINOR_SCREEN_OPEN_SCREEN        0x218   //open screen
#define MINOR_SCREEN_CLOSE_SCREEN       0x219   //close screen
#define MINOR_SCREEN_SWITCH_SIGNAL      0x21a   //switch signal
#define MINOR_SCREEN_MODIFY_NETWORK     0x21b   //configure network parameters
#define MINOR_SCREEN_MODIFY_LEDRES      0x21c   //configure output LED resolution
#define MINOR_SCREEN_SHOW_NORMAL        0x21d   //configure window normal show module
#define MINOR_SCREEN_SHOW_TILE          0x21e   //configure window tile show module
#define MINOR_SCREEN_DEC_NORMAL         0x21f   //configure normal decode module
#define MINOR_SCREEN_DEC_LOWLATENCY     0x220   //configure low latency decode module
#define MINOR_SCREEN_MODIFY_SELFRES     0x221   //configure signal self-define resolution
#define MINOR_SCREEN_OUTPUT_POSITION    0x222   //configure ouput channel position
#define MINOR_SCREEN_IMAGE_ENHANCE      0x223   //image enhance
#define MINOR_SCREEN_JOIN_SIGNAL        0x224   //signal join
#define MINOR_SCREEN_SIGNAL_OSD         0x225   //signal OSD
#define MINOR_SCREEN_ASSOCIATED_INTERACTION 0x226   //signal associateed to interactive server
#define MINOR_SCREEN_MODIFY_MATRIX      0x227   //configure matrix
#define MINOR_SCREEN_WND_TOP_KEEP       0x228   //window top keep
#define MINOR_SCREEN_WND_OPEN_KEEP      0x229   //window open keep
#define MINOR_SCREEN_WALL_MIRROR        0x22a   //video wall area mirror
#define MINOR_SCREEN_UPLOAD_BASEMAP     0x22b   //upload basemap
#define MINOR_SCREEN_SHOW_BASEMAP       0x22c   //show basemap
#define MINOR_SCREEN_HIDE_BASEMAP       0x22d   //hide basemap
#define MINOR_SCREEN_MODIFY_SERIAL      0x22e   //configure serial port

#define MINOR_SCREEN_SET_INPUT            0x251    /*set input signal*/
#define MINOR_SCREEN_SET_OUTPUT            0x252    /*set output channel*/
#define MINOR_SCREEN_SET_OSD            0x253    /*set virtual LED*/
#define MINOR_SCREEN_SET_LOGO            0x254    /*set LOGO*/
#define MINOR_SCREEN_SET_LAYOUT            0x255    /*set layout*/
#define    MINOR_SCREEN_PICTUREPREVIEW        0x256     /*picture preview*/

#define MINOR_SCREEN_GET_OSD            0x257   /*get virtual LED*/
#define MINOR_SCREEN_GET_LAYOUT            0x258   /*get layout*/
#define MINOR_SCREEN_LAYOUT_CTRL        0x259   /*layout control*/
#define MINOR_GET_ALL_VALID_WND            0x260    /*get all valid window*/
#define MINOR_GET_SIGNAL_WND            0x261    /*get single window information*/
#define MINOR_WINDOW_CTRL                0x262    /*window control*/
#define MINOR_GET_LAYOUT_LIST            0x263    /*get layout list*/
#define MINOR_LAYOUT_CTRL                0x264    /*layout control*/
#define MINOR_SET_LAYOUT                0x265    /*set single layout*/
#define MINOR_GET_SIGNAL_LIST            0x266    /*get input signal list*/
#define MINOR_GET_PLAN_LIST                0x267    /*get plan list*/
#define MINOR_SET_PLAN                    0x268    /*set plan*/
#define MINOR_CTRL_PLAN                    0x269    /*plan control*/
#define MINOR_CTRL_SCREEN                0x270    /*screen control*/
#define MINOR_ADD_NETSIG                0x271    /*add net signal*/
#define MINOR_SET_NETSIG                0x272    /*mod net signal*/
#define MINOR_SET_DECBDCFG                0x273    /*set decoder parameter*/
#define MINOR_GET_DECBDCFG                0x274    /*get decoder parameter*/
#define MINOR_GET_DEVICE_STATUS            0x275    /*get device status*/
#define MINOR_UPLOAD_PICTURE            0x276    /*upload picture*/
#define MINOR_SET_USERPWD                0x277    /*set user name and password*/
#define MINOR_ADD_LAYOUT                0x278    /*add layout*/
#define MINOR_DEL_LAYOUT                0x279    /*delete layout*/
#define MINOR_DEL_NETSIG                0x280    /*delete net signal*/
#define MINOR_ADD_PLAN                    0x281    /*add plan*/
#define MINOR_DEL_PLAN                    0x282    /*delete plan*/
#define MINOR_GET_EXTERNAL_MATRIX_CFG    0x283    //get external matrix config
#define MINOR_SET_EXTERNAL_MATRIX_CFG    0x284    //set external matrix config
#define    MINOR_GET_USER_CFG                0x285    //get user config
#define    MINOR_SET_USER_CFG                0x286    //set user config
#define    MINOR_GET_DISPLAY_PANEL_LINK_CFG 0x287    //get display panel link config
#define    MINOR_SET_DISPLAY_PANEL_LINK_CFG 0x288    //set display panel link config
#define    MINOR_GET_WALLSCENE_PARAM    0x289        //get scene parameter
#define    MINOR_SET_WALLSCENE_PARAM    0x28a        //set scene parameter
#define    MINOR_GET_CURRENT_WALLSCENE        0x28b        //get current scene
#define    MINOR_SWITCH_WALLSCENE            0x28c        //switch scene
#define    MINOR_SIP_LOGIN                    0x28d        //SIP login
#define MINOR_VOIP_START                0x28e        //VOIP start
#define MINOR_VOIP_STOP                    0x28f        //VOIP stop
#define MINOR_WIN_TOP                   0x290       //move video wall window to top layer 
#define MINOR_WIN_BOTTOM                0x291       //move video wall window to bottom layer

//Netra 2.2.2
#define MINOR_LOCAL_LOAD_HDISK          0x300            //Load hard disk          
#define MINOR_LOCAL_DELETE_HDISK        0x301            //Delete Hard disk

//KY2013 3.0.0
#define MINOR_LOCAL_MAIN_AUXILIARY_PORT_SWITCH    0X302 //Local main and auxiliary port switch
#define MINOR_LOCAL_HARD_DISK_CHECK                0x303 //Local hard disk check

//Netra3.1.0
#define MINOR_LOCAL_CFG_DEVICE_TYPE        0x310    //local cfg dev type
#define MINOR_REMOTE_CFG_DEVICE_TYPE    0x311    //remote cfg dev type
#define MINOR_LOCAL_CFG_WORK_HOT_SERVER    0x312    //local cfg work hot server
#define MINOR_REMOTE_CFG_WORK_HOT_SERVER    0x313    //remote cfg work hot server
#define MINOR_LOCAL_DELETE_WORK            0x314    //local delete work
#define MINOR_REMOTE_DELETE_WORK        0x315    //remote delete work
#define    MINOR_LOCAL_ADD_WORK            0x316    //local add work
#define MINOR_REMOTE_ADD_WORK            0x317    //remote add work
#define MINOR_LOCAL_IPCHEATMAP_OUTPUT   0x318   //local Ip cheatmap output
#define MINOR_LOCAL_IPCHEATFLOW_OUTPUT  0x319   //local Ip cheatflow output
#define MINOR_REMOTE_SMS_SEND           0x350    /*remote send sms*/
#define MINOR_LOCAL_SMS_SEND            0x351   /*local  send sms*/
#define MINOR_ALARM_SMS_SEND            0x352   
#define MINOR_SMS_RECV                  0x353    
#define MINOR_LOCAL_SMS_SEARCH          0x354  /*Local Search SMS*/
#define MINOR_REMOTE_SMS_SEARCH         0x355   /*Remote Search SMS*/
#define MINOR_LOCAL_SMS_READ            0x356   /*local read SMS*/
#define MINOR_REMOTE_SMS_READ           0x357   /*Remote read SMS*/
#define MINOR_REMOTE_DIAL_CONNECT       0x358   /*Remote Dial */
#define MINOR_REMOTE_DIAL_DISCONN       0x359   /*Remote Disconnect Dial*/
#define MINOR_LOCAL_WHITELIST_SET       0x35A   /*local white list CFG*/
#define MINOR_REMOTE_WHITELIST_SET      0x35B   /*Remote white list CFG*/
#define MINOR_LOCAL_DIAL_PARA_SET       0x35C   /*local Dial Alarm CFG*/
#define MINOR_REMOTE_DIAL_PARA_SET      0x35D   /*Remote Dial Alarm CFG*/
#define MINOR_LOCAL_DIAL_SCHEDULE_SET   0x35E   /*local dial schedule CFG*/
#define MINOR_REMOTE_DIAL_SCHEDULE_SET  0x35F   /*Remote dial schedule CFG*/
#define MINOR_PLAT_OPER                 0x360   /*plat operation*/
#define MINOR_REMOTE_CFG_POE_WORK_MODE  0x361   //Remote poe work mode cfg
#define MINOR_LOCAL_CFG_POE_WORK_MODE   0x362   //Local poe work mode cfg
#define MINOR_REMOTE_CFG_FACE_CONTRAST  0x363   //Remote face contrast cfg
#define MINOR_LOCAL_CFG_FACE_CONTRAST   0x364   //Local face contrast cfg
#define MINOR_REMOTE_CFG_WHITELIST_FACE_CONTRAST   0x365//Remote white list face contrast cfg
#define MINOR_LOCAL_CFG_WHITELIST_FACE_CONTRAST    0x366//Local white list face contrast cfg
#define MINOR_LOCAL_CHECK_TIME          0x367   //Local manual timing
#define MINOR_VCA_ONEKEY_EXPORT_PICTURE 0x368 //One key export picture
#define MINOR_VCA_ONEKEY_DELETE_PICTURE 0x369 //One key delete picture
#define MINOR_VCA_ONEKEY_EXPORT_VIDEO   0x36a //One key export video
#define MINOR_VCA_ONEKEY_DELETE_VIDEO   0x36b //One key delete video
#define MINOR_REMOTE_CFG_WIRELESS_DIALPARAM 0x36c /* Remote configuration of wireless dialing parameters*/
#define MINOR_LOCAL_CFG_WIRELESS_DIALPARAM  0x36d /*Local configuration of wireless dialing parameters*/
#define MINOR_REMOTE_CFG_WIRELESS_SMSPARAM  0x36e /*Remote configuration of wireless SMS*/
#define MINOR_LOCAL_CFG_WIRELESS_SMSPARAM   0x36f /*Local configuration of wireless SMS*/
#define MINOR_REMOTE_CFG_WIRELESS_SMSSElFHELP  0x370 /*Remote configuration of wireless SMS self-help configuration parameters*/
#define MINOR_LOCAL_CFG_WIRELESS_SMSSElFHELP   0x371 /*Local configuration of wireless SMS self-configuration parameters*/
#define MINOR_REMOTE_CFG_WIRELESS_NETFLOWPARAM 0x372 /*Remote configuration of wireless traffic*/
#define MINOR_LOCAL_CFG_WIRELESS_NETFLOWPARAM  0x373 /*Local configuration of wireless traffic*/

//0x400-0x1000 ACS operator type
#define MINOR_REMOTE_OPEN_DOOR          0x400   //remote open door 
#define MINOR_REMOTE_CLOSE_DOOR         0x401   //remote close door (controlled)
#define MINOR_REMOTE_ALWAYS_OPEN        0x402   //remote always open door (free)
#define MINOR_REMOTE_ALWAYS_CLOSE       0x403   //remote always close door (forbiden)
#define MINOR_REMOTE_CHECK_TIME         0x404   //remote check time 
#define MINOR_NTP_CHECK_TIME            0x405   //ntp check time 
#define MINOR_REMOTE_CLEAR_CARD         0x406   //remote clear card
#define MINOR_REMOTE_RESTORE_CFG        0x407   //remote restore configure 
#define MINOR_ALARMIN_ARM               0x408   //alarm in arm 
#define MINOR_ALARMIN_DISARM            0x409   //alarm in disarm
#define MINOR_LOCAL_RESTORE_CFG         0x40a   //local configure restore
#define MINOR_REMOTE_CAPTURE_PIC        0x40b  //remote capture picture
#define MINOR_MOD_NET_REPORT_CFG        0x40c   //modify net report cfg
#define MINOR_MOD_GPRS_REPORT_PARAM     0x40d   //modify GPRS report param
#define MINOR_MOD_REPORT_GROUP_PARAM    0x40e   //modify report group param
#define    MINOR_UNLOCK_PASSWORD_OPEN_DOOR  0x40f  //unlock password open door
#define MINOR_AUTO_RENUMBER              0x410  //auto renumber
#define MINOR_AUTO_COMPLEMENT_NUMBER     0x411  //auto complement number
#define MINOR_NORMAL_CFGFILE_INPUT          0x412   //normal cfg file input
#define MINOR_NORMAL_CFGFILE_OUTTPUT     0x413   //normal cfg file output
#define MINOR_CARD_RIGHT_INPUT              0x414   //card right input
#define MINOR_CARD_RIGHT_OUTTPUT          0x415   //card right output
#define MINOR_LOCAL_USB_UPGRADE             0x416   //local USB upgrade
#define MINOR_REMOTE_VISITOR_CALL_LADDER     0x417  //visitor call ladder
#define MINOR_REMOTE_HOUSEHOLD_CALL_LADDER   0x418  //household call ladder
#define MINOR_REMOTE_ACTUAL_GUARD            0x419  //remote actual guard
#define MINOR_REMOTE_ACTUAL_UNGUARD          0x41a  //remote actual unguard
#define MINOR_REMOTE_CONTROL_NOT_CODE_OPER_FAILED     0x41b   //remote control not code operate failed
#define MINOR_REMOTE_CONTROL_CLOSE_DOOR               0x41c   //remote control close door
#define MINOR_REMOTE_CONTROL_OPEN_DOOR                0x41d   //remote control open door
#define MINOR_REMOTE_CONTROL_ALWAYS_OPEN_DOOR         0x41e   //remote control always open door

#define MINOR_OPERATION_CUSTOM1        0x900  //operation custom 1
#define MINOR_OPERATION_CUSTOM2        0x901  //operation custom 2
#define MINOR_OPERATION_CUSTOM3        0x902  //operation custom 3
#define MINOR_OPERATION_CUSTOM4        0x903  //operation custom 4
#define MINOR_OPERATION_CUSTOM5        0x904  //operation custom 5
#define MINOR_OPERATION_CUSTOM6        0x905  //operation custom 6
#define MINOR_OPERATION_CUSTOM7        0x906  //operation custom 7
#define MINOR_OPERATION_CUSTOM8        0x907  //operation custom 8
#define MINOR_OPERATION_CUSTOM9        0x908  //operation custom 9
#define MINOR_OPERATION_CUSTOM10       0x909  //operation custom 10
#define MINOR_OPERATION_CUSTOM11       0x90a  //operation custom 11
#define MINOR_OPERATION_CUSTOM12       0x90b  //operation custom 12
#define MINOR_OPERATION_CUSTOM13       0x90c  //operation custom 13
#define MINOR_OPERATION_CUSTOM14       0x90d  //operation custom 14
#define MINOR_OPERATION_CUSTOM15       0x90e  //operation custom 15
#define MINOR_OPERATION_CUSTOM16       0x90f  //operation custom 16
#define MINOR_OPERATION_CUSTOM17       0x910  //operation custom 17
#define MINOR_OPERATION_CUSTOM18       0x911  //operation custom 18
#define MINOR_OPERATION_CUSTOM19       0x912  //operation custom 19
#define MINOR_OPERATION_CUSTOM20       0x913  //operation custom 20
#define MINOR_OPERATION_CUSTOM21       0x914  //operation custom 21
#define MINOR_OPERATION_CUSTOM22       0x915  //operation custom 22
#define MINOR_OPERATION_CUSTOM23       0x916  //operation custom 23
#define MINOR_OPERATION_CUSTOM24       0x917  //operation custom 24
#define MINOR_OPERATION_CUSTOM25       0x918  //operation custom 25
#define MINOR_OPERATION_CUSTOM26       0x919  //operation custom 26
#define MINOR_OPERATION_CUSTOM27       0x91a  //operation custom 27
#define MINOR_OPERATION_CUSTOM28       0x91b  //operation custom 28
#define MINOR_OPERATION_CUSTOM29       0x91c  //operation custom 29
#define MINOR_OPERATION_CUSTOM30       0x91d  //operation custom 30
#define MINOR_OPERATION_CUSTOM31       0x91e  //operation custom 31
#define MINOR_OPERATION_CUSTOM32       0x91f  //operation custom 32
#define MINOR_OPERATION_CUSTOM33       0x920  //operation custom 33
#define MINOR_OPERATION_CUSTOM34       0x921  //operation custom 34
#define MINOR_OPERATION_CUSTOM35       0x922  //operation custom 35
#define MINOR_OPERATION_CUSTOM36       0x923  //operation custom 36
#define MINOR_OPERATION_CUSTOM37       0x924  //operation custom 37
#define MINOR_OPERATION_CUSTOM38       0x925  //operation custom 38
#define MINOR_OPERATION_CUSTOM39       0x926  //operation custom 39
#define MINOR_OPERATION_CUSTOM40       0x927  //operation custom 40
#define MINOR_OPERATION_CUSTOM41       0x928  //operation custom 41
#define MINOR_OPERATION_CUSTOM42       0x929  //operation custom 42
#define MINOR_OPERATION_CUSTOM43       0x92a  //operation custom 43
#define MINOR_OPERATION_CUSTOM44       0x92b  //operation custom 44
#define MINOR_OPERATION_CUSTOM45       0x92c  //operation custom 45
#define MINOR_OPERATION_CUSTOM46       0x92d  //operation custom 46
#define MINOR_OPERATION_CUSTOM47       0x92e  //operation custom 47
#define MINOR_OPERATION_CUSTOM48       0x92f  //operation custom 48
#define MINOR_OPERATION_CUSTOM49       0x930  //operation custom 49
#define MINOR_OPERATION_CUSTOM50       0x931  //operation custom 50
#define MINOR_OPERATION_CUSTOM51       0x932  //operation custom 51
#define MINOR_OPERATION_CUSTOM52       0x933  //operation custom 52
#define MINOR_OPERATION_CUSTOM53       0x934  //operation custom 53
#define MINOR_OPERATION_CUSTOM54       0x935  //operation custom 54
#define MINOR_OPERATION_CUSTOM55       0x936  //operation custom 55
#define MINOR_OPERATION_CUSTOM56       0x937  //operation custom 56
#define MINOR_OPERATION_CUSTOM57       0x938  //operation custom 57
#define MINOR_OPERATION_CUSTOM58       0x939  //operation custom 58
#define MINOR_OPERATION_CUSTOM59       0x93a  //operation custom 59
#define MINOR_OPERATION_CUSTOM60       0x93b  //operation custom 60
#define MINOR_OPERATION_CUSTOM61       0x93c  //operation custom 61
#define MINOR_OPERATION_CUSTOM62       0x93d  //operation custom 62
#define MINOR_OPERATION_CUSTOM63       0x93e  //operation custom 63
#define MINOR_OPERATION_CUSTOM64       0x93f  //operation custom 64
#define MINOR_SET_WIFI_PARAMETER               0x950
#define MINOR_EZVIZ_LOGIN                      0x951
#define MINOR_EZVIZ_LOGINOUT                   0x952
#define MINOR_LOCK_ADD                         0x953
#define MINOR_LOCK_DELETE                      0x954 
#define MINOR_LOCK_GET_STATUS                  0x955 
#define MINOR_LOCK_SET_TMP_PASSWORD            0x956 
#define MINOR_LOCK_SET_SILENT_MODE             0x957 
#define MINOR_LOCK_SET_LATE_WARNING            0x958  
#define MINOR_LOCK_IPC_ADD                     0x959 
#define MINOR_LOCK_IPC_REMOVE                  0x95a 
#define MINOR_LOCK_DETECTOR_ADD                0x95b 
#define MINOR_LOCK_DETECTOR_REMOVE             0x95c 
#define MINOR_LOCK_MESSAGE_REMINDING_OPEN      0x95d 
#define MINOR_LOCK_MESSAGE_REMINDING_CLOSE     0x95e 
#define MINOR_LOCK_SET_HEART_BEAT              0x95f 
#define MINOR_LOCK_REBOOT                      0x960 
#define MINOR_LOCK_CLEAR_USER                  0x961 
#define MINOR_LOCK_FORMAT                      0x962 
#define MINOR_LOCK_FINGER_CHANGE               0x963 
#define MINOR_LOCK_PASSWORD_CHANGE             0x964 
#define MINOR_LOCK_CARD_CHANGE                 0x965 
#define MINOR_LOCK_USER_CHANGE                 0x966 
#define MINOR_LOCK_SYSTEM_CHANGE               0x967 
#define MINOR_LOCK_CHANGE_ADD_UESR             0x968 
#define MINOR_LOCK_CHANGE_DEL_UESR             0x969 
#define MINOR_LOCK_CHANGE_CUSTOM_USER_NAME     0x96a 
#define MINOR_LOCK_CHANGE_REMOTE_DEVICE        0x96b 
#define MINOR_LOCK_CHANGE_ADD_FP               0x96c 
#define MINOR_LOCK_CHANGE_DEL_FP               0x96d 
#define MINOR_LOCK_CHANGE_ADD_PASSWORD         0x96e 
#define MINOR_LOCK_CHANGE_DEL_PASSWORD         0x96f
#define MINOR_LOCK_CHANGE_ADD_CARD             0x970
#define MINOR_LOCK_CHANGE_DEL_CARD             0x971
#define MINOR_LOCK_NETWORK_SWITCH              0x972 
#define MINOR_LOCK_CLEAR_NETWORK_DATA          0x973  
#define MINOR_LOCK_CLEAR_HOST_USER             0x974  
#define MINOR_LOCK_CLEAR_GUEST_USER            0x975  
#define MINOR_LOCK_CLEAN_ALL_REMOTE_DEVICE     0x976   
#define MINOR_LOCK_CLEAN_NORMAL_USER_FINGRT    0x977    
#define MINOR_LOCK_CLEAN_ALL_CARD              0x978    
#define MINOR_LOCK_CLEAN_ALL_PASSWORD          0x979   
#define MINOR_START_WIRELESSSERVER             0x97a    
#define MINOR_STOP_WIRELESSSERVER              0x97b    
#define MINOR_EMERGENCY_CARD_AUTH_NORMAL_CARD  0x97c
#define MINOR_CHANGE_ALWAYS_OPEN_RIGHT         0x97d
#define MINOR_LOCK_DOOR_BELL_EVENT             0x97e

//2018-04-23 General gateway operation type log
#define    MINOR_ALARMHOST_GUARD     		0x1010    //Normal arm
#define    MINOR_ALARMHOST_UNGUARD 		0x1011    //Normal disarm
#define    MINOR_ALARMHOST_BYPASS 				0x1012    //Bypass
#define    MINOR_ALARMHOST_DURESS_ACCESS 			0x1013    //Duress access

#define    MINOR_ALARMHOST_RS485_PARAM               0x1018   //Modify RS485 config parameter
#define    MINOR_ALARMHOST_ALARM_OUTPUT 				0x1019    //Control alarm output
#define    MINOR_ALARMHOST_ACCESS_OPEN 				0x101a    //Control access open
#define    MINOR_ALARMHOST_ACCESS_CLOSE 				0x101b    //Control access close
#define    MINOR_ALARMHOST_SIREN_OPEN 				0x101c    //Control siren open
#define    MINOR_ALARMHOST_SIREN_CLOSE 				0x101d    //Control siren close
#define    MINOR_ALARMHOST_MOD_ZONE_CONFIG 			0x101e    //Modify defense area configuration
#define    MINOR_ALARMHOST_MOD_ALARMOUT_CONIFG 	0x101f    //Modify alarmout configuration
#define    MINOR_ALARMHOST_MOD_ANALOG_CONFIG 		0x1020    //Modify analog configuration
#define    MINOR_ALARMHOST_RS485_CONFIG 				0x1021    //Modify RS-485 configuration
#define    MINOR_ALARMHOST_PHONE_CONFIG 				0x1022    //Modify dialing configuration
#define    MINOR_ALARMHOST_ADD_ADMIN 				0x1023    //Add administrator
#define    MINOR_ALARMHOST_MOD_ADMIN_PARAM 		0x1024    //Modify password of administrator
#define    MINOR_ALARMHOST_DEL_ADMIN 					0x1025    //Delete administrator
#define    MINOR_ALARMHOST_ADD_NETUSER 				0x1026    //Add network user
#define    MINOR_ALARMHOST_MOD_NETUSER_PARAM 		0x1027    //Modify password of network user
#define    MINOR_ALARMHOST_DEL_NETUSER 				0x1028    //Delete network user
#define    MINOR_ALARMHOST_ADD_OPERATORUSER 		0x1029    //Add operator user
#define    MINOR_ALARMHOST_MOD_OPERATORUSER_PW 	0x102a    //Modify operator user password
#define    MINOR_ALARMHOST_DEL_OPERATORUSER 		0x102b    //Delete operator user
#define    MINOR_ALARMHOST_ADD_KEYPADUSER 		0x102c    //Add user of keyboard or card reader 	
#define    MINOR_ALARMHOST_DEL_KEYPADUSER 		0x102d    //Delete user of keyboard or card reader


#define    MINOR_ALARMHOST_MOD_HOST_CONFIG          0x1032    //Modify host configuration
#define    MINOR_ALARMHOST_RESTORE_BYPASS 			0x1033    //Bypass restore

#define    MINOR_ALARMHOST_ALARMOUT_OPEN 			0x1034    //Open alarm out
#define    MINOR_ALARMHOST_ALARMOUT_CLOSE 			0x1035    //Close alarm out
#define    MINOR_ALARMHOST_MOD_SUBSYSTEM_PARAM 	0x1036    //Mod subsystem config
#define    MINOR_ALARMHOST_GROUP_BYPASS 				0x1037    //Group bypass
#define    MINOR_ALARMHOST_RESTORE_GROUP_BYPASS 	0x1038    //Restore group bypass
#define    MINOR_ALARMHOST_MOD_GRPS_PARAM 			0x1039    //Mod gprs parameter

#define    MINOR_ALARMHOST_MOD_REPORT_MOD 			0x103b    //Mod report config
#define    MINOR_ALARMHOST_MOD_GATEWAY_PARAM 		0x103c    //Mod gateway config

#define    MINOR_STAY_ARM 	0x104c    //stay arm
#define    MINOR_QUICK_ARM 			0x104d    //quick arm
#define    MINOR_AUTOMATIC_ARM 		0x104e    //auto arm
#define    MINOR_AUTOMATIC_DISARM 		0x104f    //auto disarm
#define    MINOR_KEYSWITCH_ARM 	0x1050  //key switch arm
#define    MINOR_KEYSWITCH_DISARM	0x1051  //key switch disarm
#define    MINOR_CLEAR_ALARM	0x1052    //clear alarm
#define    MINOR_MOD_FAULT_CFG		0x1053  //mod fault config
#define    MINOR_MOD_EVENT_TRIGGER_ALARMOUT_CFG	0x1054  //mod event cause alarm out 
#define    MINOR_SEARCH_EXTERNAL_MODULE  0x1055 //search external module
#define    MINOR_REGISTER_EXTERNAL_MODULE 0x1056  //register external module
#define    MINOR_CLOSE_KEYBOARD_ALARM	0x1057 //close keyboard alarm
#define    MINOR_MOD_3G_PARAM		0x1058  //modify 3G parameter
#define    MINOR_MOD_PRINT_PARAM 0x1059  //modify printer parameter
#define    MINOR_ALARMHOST_SD_CARD_FORMAT		0x1060    //SD card format
#define MINOR_ALARMHOST_SUBSYSTEM_UPGRADE  0x1061 //subsystem upgrade

#define MINOR_PLAN_ARM_CFG     0x1062 //arm plan config
#define MINOR_PHONE_ARM         0x1063 //phone arm
#define MINOR_PHONE_STAY_ARM     0x1064 //phone stay arm
#define MINOR_PHONE_QUICK_ARM   0x1065 //phone quick arm
#define MINOR_PHONE_DISARM     0x1066 //phone disarm
#define MINOR_PHONE_CLEAR_ALARM     0x1067 //phone clear alarm
#define MINOR_WHITELIST_CFG     0x1068 //white list config
#define MINOR_TIME_TRIGGER_CFG    0x1069 //turn on/off trigger config
#define MINOR_CAPTRUE_CFG     0x106a //capture config
#define MINOR_TAMPER_CFG    0x106b //tamper config

#define MINOR_REMOTE_KEYPAD_UPGRADE    0x106c //Remote Keypad Upgrade
#define MINOR_ONETOUCH_AWAY_ARMING  0x106d //One-touch Away Arming 
#define MINOR_ONETOUCH_STAY_ARMING     0x106e //One-touch Stay Arming
#define MINOR_SINGLE_PARTITION_ARMING_OR_DISARMING  0x106f //Single Partition Arming/Disarming  
#define MINOR_CARD_CONFIGURATION   0x1070 //Card Configuration
#define MINOR_CARD_ARMING_OR_DISARMING   0x1071 //Card Arming/Disarming
#define MINOR_EXPENDING_NETCENTER_CONFIGURATION    0x1072 //Expending Network Center Configuration
#define MINOR_NETCARD_CONFIGURATION    0x1073 //Network Card Configuration
#define MINOR_DDNS_CONFIGURATION      0x1074 //DDNS Configuration
#define MINOR_RS485BUS_CONFIGURATION    0x1075 // RS-485 Bus Configuration
#define MINOR_RS485BUS_RE_REGISTRATION     0x1076 //RS-486 Bus Re-registration

#define MINOR_REMOTE_OPEN_ELECTRIC_LOCK 0x1077 //remote open electric lock
#define MINOR_REMOTE_CLOSE_ELECTRIC_LOCK 0x1078 //remote close electric lock
#define MINOR_LOCAL_OPEN_ELECTRIC_LOCK 0x1079 //local open electric lock
#define MINOR_LOCAL_CLOSE_ELECTRIC_LOCK 0x107a //local close electric lock
#define MINOR_OPEN_ALARM_LAMP      0x107b //open alarm lamp(remote)
#define MINOR_CLOSE_ALARM_LAMP      0x107c //close alarm lamp(remote)
    

#define MINOR_TEMPORARY_PASSWORD   0x107d //

#define MINOR_HIDDNS_CONFIG     0x1082 // 
#define MINOR_REMOTE_KEYBOARD_UPDATA   0x1083 //
#define MINOR_ZONE_ADD_DETECTOR      0x1084 //
#define MINOR_ZONE_DELETE_DETECTOR    0x1085 //
#define MINOR_QUERY_DETECTOR_SIGNAL   0x1086 //
#define MINOR_QUERY_DETECTOR_BATTERY  0x1087 //
#define MINOR_SET_DETECTOR_GUARD    0x1088 //
#define MINOR_SET_DETECTOR_UNGUARD   0x1089 //
#define MINOR_WIRELESS_CONFIGURATION     0x108a  //config wireless parameter
#define MINOR_OPEN_VOICE        0x108b //
#define MINOR_CLOSE_VOICE       0x108c //
#define MINOR_ENABLE_FUNCTION_KEY     0x108d //
#define MINOR_DISABLE_FUNCTION_KEY      0x108e //
#define MINOR_READ_CARD    0x108f //patrol read card
#define MINOR_START_BROADCAST     0x1090 //open broadcast
#define MINOR_STOP_BROADCAST   0x1091 //close broadcast
#define MINOR_REMOTE_ZONE_MODULE_UPGRADE   0x1092 //
#define MINOR_NETWORK_MODULE_EXTEND   0x1093 //network module params cfg
#define MINOR_ADD_CONTROLLER 	0x1094 //add controller user
#define MINOR_DELETE_CONTORLLER 	0x1095 //delete controller user
#define MINOR_REMOTE_NETWORKMODULE_UPGRADE    0x1096 //
#define MINOR_WIRELESS_OUTPUT_ADD   0x1097 //
#define MINOR_WIRELESS_OUTPUT_DEL    0x1098 //
#define MINOR_WIRELESS_REPEATER_ADD   0x1099 //
#define MINOR_WIRELESS_REPEATER_DEL    0x109a //
#define MINOR_PHONELIST_CFG     0x109b //
#define MINOR_RF_SIGNAL_CHECK   0x109c // 
#define MINOR_USB_UPGRADE   0x109d // 
#define MINOR_DOOR_TIME_REMINDER_CFG 0x109f //
#define MINOR_WIRELESS_SIREN_ADD    0x1100 //
#define MINOR_WIRELESS_SIREN_DEL    0x1101 //
#define MINOR_OUT_SCALE_OPEN    0x1102 //
#define MINOR_OUT_SCALE_CLOSE    0x1103 //

#define  MINOR_ALARMHOST_4G_MODULS_START  0x1108  //4G module start
#define  MINOR_ALARMHOST_4G_MODULS_STOP  0x1109  //4G module stop

#define  MINOR_EZVIZ_CLOUD_START   0x1110   //EZVIZ start
#define  MINOR_EZVIZ_CLOUD_STOP    0x1111   //EZVIZ stop
#define  MINOR_SIPUA_GRID_START    0x1112   //SIP grid start
#define  MINOR_SIPUA_GRID_STOP    0x1113    //SIP grid stop

#define MINOR_MODBUS_FILE_DOWNLOAD   0x1114  //download modbus file
#define MINOR_MODBUS_FILE_UPLOAD      0x1115  //upload modbus file

#define MINOR_RS485_DLL_FILE_DOWNLOAD   0x1116  //download RS485 protocol library file
#define MINOR_RS485_DLL_FLIE_UPLOAD   0x1117  //upload RS485 protocol library file
#define MINOR_TX1_REBOOT              0x1118   //TX1 system reboot



//2012-03-05 ITC
#define MINOR_SET_TRIGGERMODE_CFG       0x1001  /*Set trigger configuration*/
#define MINOR_GET_TRIGGERMODE_CFG       0x1002  /*Get trigger configuration*/
#define MINOR_SET_IOOUT_CFG             0x1003  /*Set IO out configuration*/
#define MINOR_GET_IOOUT_CFG             0x1004  /*Get IO out configuration*/
#define MINOR_GET_TRIGGERMODE_DEFAULT   0x1005  /*Get trigger default configuration*/
#define MINOR_GET_ITCSTATUS             0x1006  /*Get status */
#define MINOR_SET_STATUS_DETECT_CFG     0x1007  /*Set status detect configuration*/
#define MINOR_GET_STATUS_DETECT_CFG     0x1008  /*Get status detect configuration*/
#define MINOR_SET_VIDEO_TRIGGERMODE_CFG 0x1009  /*Set video trigger configuration*/
#define MINOR_GET_VIDEO_TRIGGERMODE_CFG 0x100a  /*Get video trigger configuration*/

//2013-04-19 ITS
#define MINOR_LOCAL_ADD_CAR_INFO            0x2001  /*Local add car info*/
#define MINOR_LOCAL_MOD_CAR_INFO            0x2002  /*Local mode car info*/
#define MINOR_LOCAL_DEL_CAR_INFO            0x2003  /*Local delete car info*/
#define MINOR_LOCAL_FIND_CAR_INFO           0x2004  /*Local find car info*/
#define MINOR_LOCAL_ADD_MONITOR_INFO        0x2005  /*Local add monitor info*/
#define MINOR_LOCAL_MOD_MONITOR_INFO        0x2006  /*Local mode monitor info*/
#define MINOR_LOCAL_DEL_MONITOR_INFO        0x2007  /*Local delete monitor info*/
#define MINOR_LOCAL_FIND_MONITOR_INFO       0x2008  /*Local find monitor info*/
#define MINOR_LOCAL_FIND_NORMAL_PASS_INFO   0x2009  /*Local find normal pass info*/
#define MINOR_LOCAL_FIND_ABNORMAL_PASS_INFO   0x200a  /*Local find abnormal pass info*/
#define MINOR_LOCAL_FIND_PEDESTRIAN_PASS_INFO   0x200b  /*Local find pedestrian pass info*/
#define MINOR_LOCAL_PIC_PREVIEW             0x200c  /*Local picture preview*/
#define MINOR_LOCAL_SET_GATE_PARM_CFG           0x200d  /*Local set gate param configuration*/
#define MINOR_LOCAL_GET_GATE_PARM_CFG           0x200e  /*Local get gate param configuration*/
#define MINOR_LOCAL_SET_DATAUPLOAD_PARM_CFG     0x200f  /*Local set dataupload param configuration*/
#define MINOR_LOCAL_GET_DATAUPLOAD_PARM_CFG     0x2010  /*Local get dataupload param configuration*/
//2013-11-19 Log Type
#define MINOR_LOCAL_DEVICE_CONTROL                        0x2011      /*Local Device Control*/
#define MINOR_LOCAL_ADD_EXTERNAL_DEVICE_INFO              0x2012      /*Add External Device Info */
#define MINOR_LOCAL_MOD_EXTERNAL_DEVICE_INFO              0x2013      /*Modify External Device Info */
#define MINOR_LOCAL_DEL_EXTERNAL_DEVICE_INFO              0x2014      /*Delete External Device Info */
#define MINOR_LOCAL_FIND_EXTERNAL_DEVICE_INFO             0x2015      /*Find External Device Info */
#define MINOR_LOCAL_ADD_CHARGE_RULE                       0x2016      /*Add Charge rule */
#define MINOR_LOCAL_MOD_CHARGE_RULE                       0x2017      /*Modify Charge rule */
#define MINOR_LOCAL_DEL_CHARGE_RULE                       0x2018      /*Delete Charge rule */
#define MINOR_LOCAL_FIND_CHARGE_RULE                      0x2019      /*Find Charge rule */
#define MINOR_LOCAL_COUNT_NORMAL_CURRENTINFO              0x2020      /*Normal Current Info */
#define MINOR_LOCAL_EXPORT_NORMAL_CURRENTINFO_REPORT      0x2021      /*Normal Current Info Report */
#define MINOR_LOCAL_COUNT_ABNORMAL_CURRENTINFO            0x2022      /*Abnormal Current Info */
#define MINOR_LOCAL_EXPORT_ABNORMAL_CURRENTINFO_REPORT    0x2023      /*Abnormal Current Info Report */
#define MINOR_LOCAL_COUNT_PEDESTRIAN_CURRENTINFO          0x2024      /*Pedesteian Current Info */
#define MINOR_LOCAL_EXPORT_PEDESTRIAN_CURRENTINFO_REPORT  0x2025      /*Pedesteian Current Info Report*/
#define MINOR_LOCAL_FIND_CAR_CHARGEINFO                   0x2026      /*Find Car Charge Info */
#define MINOR_LOCAL_COUNT_CAR_CHARGEINFO                  0x2027      /*Count Car Charge Info */
#define MINOR_LOCAL_EXPORT_CAR_CHARGEINFO_REPORT          0x2028      /*Export Car Charge Info Report */
#define MINOR_LOCAL_FIND_SHIFTINFO                        0x2029      /*Find Shift Info */
#define MINOR_LOCAL_FIND_CARDINFO                         0x2030      /*Find Card Info */
#define MINOR_LOCAL_ADD_RELIEF_RULE                       0x2031      /*Add Relief Rule*/
#define MINOR_LOCAL_MOD_RELIEF_RULE                       0x2032      /*Modify Relief Rule */
#define MINOR_LOCAL_DEL_RELIEF_RULE                       0x2033      /*Delete Relief Rule  */
#define MINOR_LOCAL_FIND_RELIEF_RULE                      0x2034      /*find Relief Rule */
#define MINOR_LOCAL_GET_ENDETCFG                          0x2035      /*local Get entrance control machine offline detection configuration */ 
#define MINOR_LOCAL_SET_ENDETCFG                          0x2036      /*local Set entrance control machine offline detection configuration*/
#define MINOR_LOCAL_SET_ENDEV_ISSUEDDATA                  0x2037      /*local setting entrance control machine issued card information */
#define MINOR_LOCAL_DEL_ENDEV_ISSUEDDATA                  0x2038      /*local Delete entrance control machine issued card information*/

#define MINOR_REMOTE_DEVICE_CONTROL                       0x2101      /*Remote device control*/
#define MINOR_REMOTE_SET_GATE_PARM_CFG                    0x2102      /*Remote set gate param configuration*/
#define MINOR_REMOTE_GET_GATE_PARM_CFG                    0x2103      /*Remote get gate param configuration*/
#define MINOR_REMOTE_SET_DATAUPLOAD_PARM_CFG              0x2104      /*Remote set dataupload param configuration*/
#define MINOR_REMOTE_GET_DATAUPLOAD_PARM_CFG              0x2105      /*Remote get dataupload param configuration*/
#define MINOR_REMOTE_GET_BASE_INFO                        0x2106      /*Remote get base info*/
#define MINOR_REMOTE_GET_OVERLAP_CFG                      0x2107      /*Remote get overlap configuration*/              
#define MINOR_REMOTE_SET_OVERLAP_CFG                      0x2108      /*Remote set overlap configuration*/ 
#define MINOR_REMOTE_GET_ROAD_INFO                        0x2109      /*Remote get road info*/
#define MINOR_REMOTE_START_TRANSCHAN                      0x210a      /*Remote start transchan*/
#define MINOR_REMOTE_GET_ECTWORKSTATE                     0x210b      /*Remote get ect work state*/
#define MINOR_REMOTE_GET_ECTCHANINFO                      0x210c      /*Remote get ect channel info*/

//Remote control 2013-11-19
#define MINOR_REMOTE_ADD_EXTERNAL_DEVICE_INFO             0x210d      /*Remote add external equipment information */
#define MINOR_REMOTE_MOD_EXTERNAL_DEVICE_INFO             0x210e      /*Remote modify the external equipment information */
#define MINOR_REMOTE_GET_ENDETCFG                         0x210f      /*Remote obtain entrance control machine offline detection configuration */ 
#define MINOR_REMOTE_SET_ENDETCFG                         0x2110      /*Remote setup entrance control machine with off-line detection*/
#define MINOR_REMOTE_ENDEV_ISSUEDDATA                     0x2111      /*Remote setup entrance control machine issued card information */
#define MINOR_REMOTE_DEL_ENDEV_ISSUEDDATA                 0x2112      /*Remote wipe out entrance control machine issued card information */

#define MINOR_REMOTE_ON_CTRL_LAMP           0x2115  /*Open remote control parking lights */       
#define MINOR_REMOTE_OFF_CTRL_LAMP          0x2116  /*Close remote control parking lights */
//Netra3.1.0
#define MINOR_SET_VOICE_LEVEL_PARAM         0x2117  /*set voice level param*/
#define MINOR_SET_VOICE_INTERCOM_PARAM      0x2118  /*set voice intercom param */
#define MINOR_SET_INTELLIGENT_PARAM         0x2119  /*intelligent param*/ 
#define MINOR_LOCAL_SET_RAID_SPEED          0x211a  /*set local raid speed*/
#define MINOR_REMOTE_SET_RAID_SPEED         0x211b /*set remote raid speed*/

//Nerta3.1.2
#define MINOR_REMOTE_CREATE_STORAGE_POOL    0x211c   //remote create Storage pool
#define MINOR_REMOTE_DEL_STORAGE_POOL       0x211d    //remote delete Storage pool

#define MINOR_REMOTE_DEL_PIC                0x2120   //remote delete pic 
#define MINOR_REMOTE_DEL_RECORD             0x2121   //remote delete record
#define MINOR_REMOTE_CLOUD_ENABLE           0x2123   //remote set cloud System enable
#define MINOR_REMOTE_CLOUD_DISABLE          0x2124   //remote set cloud System disable
#define MINOR_REMOTE_CLOUD_MODIFY_PARAM     0x2125   //remote modify cloud Storage param
#define MINOR_REMOTE_CLOUD_MODIFY_VOLUME    0x2126   //remote modift cloud Storage volume
#define MINOR_REMOTE_GET_GB28181_SERVICE_PARAM    0x2127  //Remote Get GB28181 Cfg
#define MINOR_REMOTE_SET_GB28181_SERVICE_PARAM    0x2128  //Remote Set GB28181 Cfg
#define MINOR_LOCAL_GET_GB28181_SERVICE_PARAM     0x2129  //local Get GB28181 Cfg
#define MINOR_LOCAL_SET_GB28181_SERVICE_PARAM     0x212a  //local Set GB28181 Cfg
#define MINOR_REMOTE_SET_SIP_SERVER               0x212b  //Remote Set SIP SERVER Cfg
#define MINOR_LOCAL_SET_SIP_SERVER                0x212c  //Local Set SIP SERVER Cfg
#define MINOR_LOCAL_BLACKWHITEFILE_OUTPUT         0x212d  //Local output black white file
#define MINOR_LOCAL_BLACKWHITEFILE_INPUT          0x212e  //Local input black white file
#define MINOR_REMOTE_BALCKWHITECFGFILE_OUTPUT     0x212f  //Remote output black white file
#define MINOR_REMOTE_BALCKWHITECFGFILE_INPUT      0x2130  //Remote input black white file


#define MINOR_REMOTE_CREATE_MOD_VIEWLIB_SPACE        0x2200    //Remote create or mod view lib space
#define MINOR_REMOTE_DELETE_VIEWLIB_FILE            0x2201  //Remote delete view lib file
#define MINOR_REMOTE_DOWNLOAD_VIEWLIB_FILE            0x2202    //Remote download view lib file
#define MINOR_REMOTE_UPLOAD_VIEWLIB_FILE            0x2203    //Remote upload view lib file
#define MINOR_LOCAL_CREATE_MOD_VIEWLIB_SPACE        0x2204    //local create or mod view lib space

#define MINOR_LOCAL_SET_DEVICE_ACTIVE   0x3000  //local activate device
#define MINOR_REMOTE_SET_DEVICE_ACTIVE  0x3001  //remote activate device
#define MINOR_LOCAL_PARA_FACTORY_DEFAULT    0x3002  //local parameter factory default
#define MINOR_REMOTE_PARA_FACTORY_DEFAULT   0x3003  //remote parameter factory default

/*info publish server operation log*/
//minor type:
#define MINOR_UPLAOD_STATIC_MATERIAL                0x2401  //static material upload
#define MINOR_UPLOAD_DYNAMIC_MATERIAL               0x2402  //dynamic material upload
#define MINOR_DELETE_MATERIAL                       0x2403  //delete material
#define MINOR_DOWNLOAD_STATIC_MATERIAL              0x2404  //static material download
#define MINOR_COVER_STATIC_MATERIAL                 0x2405  //static material cover
#define MINOR_APPROVE_MATERIAL                      0x2406  //material approve
#define MINOR_UPLAOD_PROGRAM                        0x2407  //add program
#define MINOR_DOWNLOAD_PROGRAM                      0x2408  //get program
#define MINOR_DELETE_PROGRAM                        0x2409  //delete program
#define MINOR_MODIFY_PROGRAM                        0x240a  //program attribute modify
#define MINOR_APPROVE_PRAGRAM                       0x240b  //program approve
#define MINOR_UPLAOD_SCHEDULE                       0x240c  //add schedule
#define MINOR_DOWNLOAD_SCHEDULE                     0x240d  //get schedule
#define MINOR_DELETE_SCHEDULE                       0x240e  //delete schedule
#define MINOR_MODIFY_SCHEDULE                       0x240f  //modify schedule attribute
#define MINOR_RELEASE_SCHEDULE                      0x2410  //publish schedule
#define MINOR_ADD_TERMINAL                          0x2411  //add terminal
#define MINOR_DELETE_TERMINAL                       0x2412  //delete terminal
#define MINOR_MODIFY_TERMIANL_PARAM                 0x2413  //set terminal param           
#define MINOR_MODIFY_TERMIANL_PLAY_PARAM            0x2414  //set terminal play parma
#define MINOR_ADD_TERMIANL_GROUP                    0x2415  //add terminal group
#define MINOR_MODIFY_TERMINAL_GROUP_PARAM           0x2416  //modify terminal pram
#define MINOR_DELETE_TERMIANL_GROUP                 0x2417  //delete terminal group
#define MINOR_TERMINAL_PLAY_CONTROL                 0x2418  //terminal play control
#define MINOR_TERMINAL_ON_OFF_LINE                  0x2419  //terminal on and off line
#define MINOR_SET_SWITCH_PLAN                       0x241a  //set terminal switch on plan
#define MINOR_SET_VOLUME_PLAN                       0x241b  //set terminal volume plan
#define MINOR_TERMINAL_SCREENSHOT                   0x241c  //terminal screenshot
#define MINOR_SYSTEM_TIME_CFG                       0x241d      //system timeing
#define MINOR_ADD_USER_CFG                          0x241e    //add user information
#define MINOR_DEL_USER_CFG                          0x241f    //delete user information
#define MINOR_REMOTE_MANAGE_HDD                     0x2420   //remote manage HDD
#define MINOR_TERMINAL_UPDATE_START                 0x2421   //terminal update
#define MINOR_SVR_RESTORE_DEFAULT_PARAM             0x2422   //server remote restore default
#define MINOR_SVR_REMOTE_RESTORE_FACTORY            0x2423   //server remote restore factory
#define MINOR_SVR_REMOTE_REBOOT                     0x2424   //server remote reboot
#define MINOR_SVR_MODIFY_NETWORK_PARAM              0x2425   //server network parameter modified
#define MINOR_SVR_SOFTWARE_UPGRADE                  0x2426     //server software upgrade

#define MINOR_BACKUP_DATA                           0xc41  //data backup
#define MINOR_TRANSFER_DATA                         0xc42  //data transfer
#define MINOR_RESTORE_DATA                          0xc43  //data restore
#define MINOR_SET_INPUT_PLAN                        0xc44 //set terminal input plan
#define MINOR_TERMINAL_ADB                          0xc45//terminal adb config
#define MINOR_TERMINAL_VOLUME                       0xc46  //terminal volume config
#define MINOR_TERMINAL_LOGO                         0xc47 //terminal logo config
#define MINOR_TERMINAL_DEFAULT_SCHEDULE             0xc48 //default schedule config
#define MINOR_TERMINAL_PASSWORD                     0xc49 //terminal password
#define MINOR_TERMINAL_IP                           0xc4a//terminal ip config
#define MINOR_TERMINAL_RELATE_IPC                   0xc4b//terminal relate IPC
#define MINOR_TERMINAL_SERVER                       0xc4c//terminal server config
#define MINOR_TERMINAL_SADP                         0xc4d//terminal sadp config
#define MINOR_TERMINAL_TIMEZONE                     0xc4e//terminal timezone config
#define MINOR_TERMINAL_TEMP_PROTECT                 0xc4f//terminal temperature protect
#define MINOR_ADD_ORGANIZATION                      0xc50 //add organization
#define MINOR_DELETE_ORGANIZATION                   0xc51 //delete organization
#define MINOR_MODIFY_ORGANIZATION                   0xc52 //modify organization
#define MINOR_WEATHER_FACTORY                       0xc53 //weather factory 
#define MINOR_SADP_ENABLE                           0xc54 //sadp enable
#define MINOR_SSH_ENABLE                            0xc55 //SSH enable
#define MINOR_MODIFY_MATERIAL                       0xc56 //modify material 
#define MINOR_INSERT_CHARACTER                      0xc57 //insert character
#define MINOR_TERMINAL_BACKLIGHT                    0xc58 //config terminal backlight

#define MINOR_REMOTE_CONFERENCE_CONFIG             0x2501  //MCU conference config
#define MINOR_REMOTE_TERMINAL_CONFIG               0x2502  //MCU terminal config
#define MINOR_REMOTE_GROUP_CONFIG                  0x2503  //MCU group config
#define MINOR_REMOTE_CONFERENCE_CTRL               0x2504  //MCU conference config
#define MINOR_REMOTE_TERMINAL_CTRL                 0x2505  //MCU terminal control

//NVR
#define MINOR_LOCAL_RESET_LOGIN_PASSWORD           0x2600    /* local reset login password*/ 
#define MINOR_REMOTE_RESET_LOGIN_PASSWORD          0x2601    /* remote reset login password*/
#define MINOR_LOCAL_FACE_BASE_CREATE        0x2602    /* local face base creat*/ 
#define MINOR_REMOTE_FACE_BASE_CREATE       0x2603    /* remote face base creat*/
#define MINOR_LOCAL_FACE_BASE_MODIFY        0x2604    /* local face base mod*/ 
#define MINOR_REMOTE_FACE_BASE_MODIFY      0x2605    /*remote face base mod*/
#define MINOR_LOCAL_FACE_BASE_DELETE        0x2606    /* local face base del*/ 
#define MINOR_REMOTE_FACE_BASE_DELETE       0x2607    /* remote face base del*/
#define MINOR_LOCAL_FACE_DATA_APPEND        0x2608    /* local face data append*/ 
#define MINOR_REMOTE_FACE_DATA_APPEND       0x2609    /*remote face data append*/
#define MINOR_LOCAL_FACE_DATA_SEARCH       0x2610    /* local face data search*/ 
#define MINOR_REMOTE_FACE_DATA_SEARCH       0x2611    /*remote face data search*/
#define MINOR_LOCAL_FACE_DATA_ANALYSIS        0x2612    /*local face data analysis*/ 
#define MINOR_REMOTE_FACE_DATA_ANALYSIS       0x2613    /*remote face data analysis*/
#define MINOR_LOCAL_FACE_DATA_EDIT            0x2614    /* local face data edit*/ 
#define MINOR_REMOTE_FACE_DATA_EDIT           0x2615    /* remote face data edit*/

#define MINOR_LOCAL_FACE_DATA_DELETE          0x2616    /* local face data delete*/ 
#define MINOR_REMOTE_FACE_DATA_DELET          0x2617    /* remote face data delete*/

#define MINOR_LOCAL_VCA_ANALYSIS_CFG          0x2618    /* local vca analysis config*/ 
#define MINOR_REMOTE_VCA_ANALYSIS_CFG         0x2619    /* remote vca analysis config*/

#define MINOR_LOCAL_FACE_BASE_IMPORT          0x261a    /* local face base import*/ 
#define MINOR_LOCAL_FACE_BASE_EXPORT          0x261b    /* local face base export*/
#define MINOR_REMOTE_CLUSTER_MODE_CONFIG      0x261c    /* remote cluster mode config*/
#define MINOR_LOCAL_CLUSTER_MODE_CONFIG       0x261d    /* local cluster mode config*/
#define MINOR_REMOTE_CLUSTER_NETWORK_CONFIG   0x261e    /* remote cluster network config*/
#define MINOR_LOCAL_CLUSTER_NETWORK_CONFIG    0x261f    /* local cluster network config*/
#define MINOR_REMOTE_CLUSTER_ADD_DEVICE       0x2620    /* remote cluster add device*/
#define MINOR_LOCAL_CLUSTER_ADD_DEVICE        0x2621    /* local cluster add device*/
#define MINOR_REMOTE_CLUSTER_DEL_DEVICE       0x2622    /* remote cluster del device*/
#define MINOR_LOCAL_CLUSTER_DEL_DEVICE        0x2623    /* local cluster add device*/
#define MINOR_REMOTE_HFPD_CFG                 0x2624    /* remote HFPD config*/
#define MINOR_REMOTE_FACE_CONTRAST_TASK       0x2625    /* remote face contrast task */

#define MINOR_REMOTE_IOTCFGFILE_INPUT          0x2627//remote input iot cfg file
#define MINOR_REMOTE_IOTCFGFILE_OUTPUT        0x2628//remote output iot cfg file
#define MINOR_LOCAL_IOT_ADD                     0x2629//local add iot channel
#define MINOR_REMOTE_IOT_ADD                    0x262a//remote add iot channel
#define MINOR_LOCAL_IOT_DEL                      0x262b//local delete iot channel
#define MINOR_REMOTE_IOT_DEL                    0x262c//remote delete iot channel
#define MINOR_LOCAL_IOT_SET                      0x262d//local set iot channel
#define MINOR_REMOTE_IOT_SET                    0x262e//remote set iot channel
#define MINOR_LOCAL_IOTCFGFILE_INPUT            0x262f //local input iot cfg file
#define MINOR_LOCAL_IOTCFGFILE_OUTPUT          0x2630//local output iot cfg file
#define MINOR_LOCAL_VAD_CFG                    0x2631  /* Local voice activity detection configuration*/
#define MINOR_REMOTE_VAD_CFG                   0x2632  /* Remote voice activity detection configuration*/
#define MINOR_LOCAL_ADDRESS_FILTER_CONFIG     0x2633    /* Local address filtering configuration*/ 
#define MINOR_REMOTE_ADDRESS_FILTER_CONFIG    0x2634    /* Remote address filtering configuration*/
#define MINOR_LOCAL_POE_CFG                   0x2635    /*Local POE configuration*/ 
#define MINOR_REMOTE_POE_CFG                   0x2636    /*Remote POE configuration*/
#define MINOR_LOCAL_RESET_CHANNEL_PASSWORD        0x2637    /*Resets the channel password locally*/ 
#define MINOR_REMOTE_RESET_CHANNEL_PASSWORD       0x2638    /*Resetting the channel password remotely*/
#define MINOR_LOCAL_SSD_UPGRADE_START                   0x2639    /*Local SSD file system upgrade starts*/ 
#define MINOR_LOCAL_SSD_UPGRADE_STOP                    0x2640    /*Local SSD file system upgrade stop*/
#define MINOR_REMOTE_SSD_UPGRADE_START                   0x2641    /*Remote SSD file system upgrade starts*/ 
#define MINOR_REMOTE_SSD_UPGRADE_STOP                    0x2642    /*Remote SSD file system upgrade stop*/
#define MINOR_LOCAL_SSD_FORMAT_START                   0x2643    /*Local SSD file system format starts*/ 
#define MINOR_LOCAL_SSD_FORMAT_STOP                    0x2644    /*Local SSD file system format stop*/
#define MINOR_REMOTE_SSD_FORMAT_START                   0x2645    /*Remote SSD file system format starts*/ 
#define MINOR_REMOTE_SSD_FORMAT_STOP                    0x2646    /*Remote SSD file system format stop*/
#define MINOR_LOCAL_AUTO_SWITCH_CONFIG                  0x2647    /* Local Auto Switch Config*/ 
#define MINOR_REMOTE_AUTO_SWITCH_CONFIG                 0x2648    /* Remote Auto Switch Config*/

#define MINOR_LOCAL_SSD_INITIALIZATION_START            0x264a    /* Local SSD initialization start*/ 
#define MINOR_LOCAL_SSD_INITIALIZATION_END              0x264b    /* Local SSD initialization end*/
#define MINOR_REMOTE_SSD_INITIALIZATION_START           0x264c    /* Remote SSD initialization start*/
#define MINOR_REMOTE_SSD_INITIALIZATION_END             0x264d    /* Remote SSD initialization end*/

//AI Platform
#define MINOR_REMOTE_AI_MODEL_ADD    0x2650//model add
#define MINOR_REMOTE_AI_MODEL_QUERY    0x2651//model query
#define MINOR_REMOTE_AI_MODEL_DELETE    0x2652//model delete
#define MINOR_REMOTE_AI_MODEL_UPDATE    0x2653//model update
#define MINOR_REMOTE_AI_PICTURE_POLLING_TASK_ADD    0x2654//picture polling task add
#define MINOR_REMOTE_AI_PICTURE_POLLING_TASK_QUERY    0x2655//picture polling task query
#define MINOR_REMOTE_AI_PICTURE_POLLING_TASK_DELETE    0x2656//picture polling task delete
#define MINOR_REMOTE_AI_PICTURE_POLLING_TASK_MODIFY    0x2657//picture polling task modify
#define MINOR_REMOTE_AI_VIDEO_POLLING_TASK_ADD    0x2658//video polling task add
#define MINOR_REMOTE_AI_VIDEO_POLLING_TASK_QUERY    0x2659//video polling task query
#define MINOR_REMOTE_AI_VIDEO_POLLING_TASK_DELETE    0x265A//video polling task delete
#define MINOR_REMOTE_AI_VIDEO_POLLING_TASK_MODIFY    0x265B//video polling task modify
#define MINOR_REMOTE_AI_PICTURE_TASK_ADD    0x265C//picture task add
#define MINOR_REMOTE_AI_PICTURE_TASK_QUERY    0x265D//picture task query
#define MINOR_REMOTE_AI_PICTURE_TASK_DELETE    0x265E//picture task delete
#define MINOR_REMOTE_AI_PICTURE_TASK_MODIFY    0x265F//picture task modify
#define MINOR_REMOTE_AI_VIDEO_TASK_ADD    0x2660//video task add
#define MINOR_REMOTE_AI_VIDEO_TASK_QUERY    0x2661//video task add
#define MINOR_REMOTE_AI_VIDEO_TASK_DELETE    0x2662//video task delete
#define MINOR_REMOTE_AI_VIDEO_TASK_MODIFY    0x2663//video task modify


#define MINOR_STOP_SOUND                0x2700   /*stop sound*/
#define MINOR_SELF_CHECK                0x2701   /*self check*/
#define MINOR_DUTY_CHECK                0x2702   /*duty check*/
#define MINOR_SWITCH_SIMPLE_WORKMODE    0x2703   /*switch simple workmode*/
#define MINOR_SWITCH_NORMAL_WORKMODE    0x2704   /*switch normal workmode*/

/*Additional Log Info*/
//Main Type
#define MAJOR_INFORMATION                0x4     /*Extra Info*/
//Hypo- Type
#define MINOR_HDD_INFO                  0xa1 //HD info*/
#define MINOR_SMART_INFO                0xa2 //SMART info*/
#define MINOR_REC_START                 0xa3 //Start record*/
#define MINOR_REC_STOP                  0xa4 //Stop record */
#define MINOR_REC_OVERDUE                0xa5 //Record overdue*/
#define MINOR_LINK_START                0xa6 //start to link device
#define MINOR_LINK_STOP                    0xa7 //stop to link device
#define MINOR_NET_DISK_INFO                0xa8 //Network hard disk info
#define MINOR_RAID_INFO                 0xa9 //raid Info
#define MINOR_RUN_STATUS_INFO           0xaa //run status info

//Netra3.0.0
#define MINOR_SPARE_START_BACKUP        0xab   /*Spare start backup*/
#define MINOR_SPARE_STOP_BACKUP            0xac   /*Spare stop backup*/
#define MINOR_SPARE_CLIENT_INFO         0xad   /*Spare client infomation*/
#define MINOR_ANR_RECORD_START            0xae   /*ANR record start*/
#define MINOR_ANR_RECORD_END            0xaf   /*ANR record end*/
#define MINOR_ANR_ADD_TIME_QUANTUM        0xb0    /*ANR add time quantum*/
#define MINOR_ANR_DEL_TIME_QUANTUM        0xb1    /*ANR del time quantum*/

#define MINOR_PIC_REC_START             0xb3 //start snapshot     
#define MINOR_PIC_REC_STOP              0xb4 //stop snapshot 
#define MINOR_PIC_REC_OVERDUE           0xb5 //delete delayed picture

//Netra3.1.0
#define  MINOR_CLIENT_LOGIN             0xb6   /*login serice success*/
#define  MINOR_CLIENT_RELOGIN            0xb7   /*relogin serice*/
#define  MINOR_CLIENT_LOGOUT            0xb8   /*logout serice s*/
#define  MINOR_CLIENT_SYNC_START        0xb9   /*record sync start */
#define  MINOR_CLIENT_SYNC_STOP            0xba   /*record sync stop*/
#define  MINOR_CLIENT_SYNC_SUCC            0xbb   /*record sync success*/
#define  MINOR_CLIENT_SYNC_EXCP            0xbc   /*record sync excption*/
#define  MINOR_GLOBAL_RECORD_ERR_INFO   0xbd   /*global record err info*/
#define  MINOR_BUFFER_STATE             0xbe   /*The state of the buffer logging*/
#define  MINOR_DISK_ERRORINFO_V2        0xbf   /*Disk error details V2*/
#define  MINOR_CS_DATA_EXPIRED          0xc0   //cloud storage data out of date
#define  MINOR_PLAT_INFO                0xc1   //plat operation info
#define  MINOR_DIAL_STAT                0xc2   /*dial statues*/
#define  MINOR_UNLOCK_RECORD            0xc3   //unlock Record
#define  MINOR_VIS_ALARM                0xc4   //VIS Alarm
#define  MINOR_TALK_RECORD              0xc5   //talk Record
#define MINOR_ACCESSORIES_MESSAGE       0xc6 //Accessories plate information 
#define MINOR_KMS_EXPAMSION_DISK_INSERT 0xc7// KMS Expansion disc insert 
#define MINOR_IPC_CONNECT               0xc8//  IPC connect information
#define MINOR_INTELLIGENT_BOARD_STATUS  0xc9//  Intelligent board status
#define MINOR_IPC_CONNECT_STATUS        0xca//  IPC connect status
#define MINOR_AUTO_TIMING               0xcb  //Automatic correcting time 
#define MINOR_EZVIZ_OPERATION           0xcc   //Fluorite running state 
#define MINOR_CLUSTER_DEVICE_ONLINE     0xcd   //cluster device online
#define MINOR_CLUSTER_MGR_SERVICE_STARTUP 0xce   //cluster management service start up
#define MINOR_CLUSTER_BUSINESS_TRANSFER 0xcf   //cluster business transfer
#define MINOR_CLUSTER_STATUS            0xd0   //cluster status
#define MINOR_CLUSTER_CS_STATUS            0xd1   //cluster cs nvr send status to CM failed 
#define MINOR_CLUSTER_CM_STATUS            0xd2   //CM role change
#define MINOR_VOICE_START_DETECTED         0xd3  /*Voice start detected*/
#define MINOR_VOICE_END_DETECTED           0xd4  /*Voice end detected*/
#define MINOR_DOUBLE_VERIFICATION_PASS     0xd5  /*Double verification pass*/
#define MINOR_WIRELESS_RUNNING_STATUS      0xd6  /*Wireless running status*/
#define MINOR_SYSTEM_DATA_SYNCHRONIZATION  0xd7  /*System data synchronization*/

/*event*/
//major event
#define MAJOR_EVENT                             0x5     /*event*/
//minor type 
#define MINOR_LEGAL_CARD_PASS                   0x01    //legal card pass
#define MINOR_CARD_AND_PSW_PASS                 0x02    //swipe and password pass 
#define MINOR_CARD_AND_PSW_FAIL                 0x03    //swipe and password fail
#define MINOR_CARD_AND_PSW_TIMEOUT              0x04    //swipe and password timeout 
#define MINOR_CARD_AND_PSW_OVER_TIME            0x05    //swipe and password over time 
#define MINOR_CARD_NO_RIGHT                     0x06    //card no right 
#define MINOR_CARD_INVALID_PERIOD               0x07    //invalid period 
#define MINOR_CARD_OUT_OF_DATE                  0x08    //card out of date
#define MINOR_INVALID_CARD                      0x09    //invalid card 
#define MINOR_ANTI_SNEAK_FAIL                   0x0a    //anti sneak fail 
#define MINOR_INTERLOCK_DOOR_NOT_CLOSE          0x0b    //interlock door doesn't close 
#define MINOR_NOT_BELONG_MULTI_GROUP            0x0c    //card no belong multi group 
#define MINOR_INVALID_MULTI_VERIFY_PERIOD       0x0d    // invalid multi verify period 
#define MINOR_MULTI_VERIFY_SUPER_RIGHT_FAIL     0x0e    //have no super right  in multi verify mode
#define MINOR_MULTI_VERIFY_REMOTE_RIGHT_FAIL    0x0f    //have no remote right in multi verify mode
#define MINOR_MULTI_VERIFY_SUCCESS              0x10    // success in multi verify mode 
#define MINOR_LEADER_CARD_OPEN_BEGIN            0x11    // leader card begin to open 
#define MINOR_LEADER_CARD_OPEN_END              0x12    // leader card end to open 
#define MINOR_ALWAYS_OPEN_BEGIN                 0x13    // always open begin 
#define MINOR_ALWAYS_OPEN_END                   0x14    //always open end 
#define MINOR_LOCK_OPEN                         0x15    //lock open 
#define MINOR_LOCK_CLOSE                        0x16    //lock close 
#define MINOR_DOOR_BUTTON_PRESS                 0x17    //press door open button
#define MINOR_DOOR_BUTTON_RELEASE               0x18    //release door open button 
#define MINOR_DOOR_OPEN_NORMAL                  0x19    //door open normal 
#define MINOR_DOOR_CLOSE_NORMAL                 0x1a    //door close normal 
#define MINOR_DOOR_OPEN_ABNORMAL                0x1b    //open door abnormal 
#define MINOR_DOOR_OPEN_TIMEOUT                 0x1c    //open door timeout 
#define MINOR_ALARMOUT_ON                       0x1d    //alarm out turn on 
#define MINOR_ALARMOUT_OFF                      0x1e    //alarm out turn off 
#define MINOR_ALWAYS_CLOSE_BEGIN                0x1f    //always close begin 
#define MINOR_ALWAYS_CLOSE_END                  0x20    //always close end                          
#define MINOR_MULTI_VERIFY_NEED_REMOTE_OPEN     0x21    //need remote open in multi verify mode 
#define MINOR_MULTI_VERIFY_SUPERPASSWD_VERIFY_SUCCESS  0x22  //superpasswd verify success in multi verify mode 
#define MINOR_MULTI_VERIFY_REPEAT_VERIFY        0x23    //repeat verify in multi verify mode 
#define MINOR_MULTI_VERIFY_TIMEOUT               0x24    //timeout in multi verify mode 
#define MINOR_DOORBELL_RINGING                  0x25    //doorbell ringing
#define MINOR_FINGERPRINT_COMPARE_PASS          0x26    //fingerprint compare pass
#define MINOR_FINGERPRINT_COMPARE_FAIL          0x27    //fingerprint compare fail
#define MINOR_CARD_FINGERPRINT_VERIFY_PASS              0x28    //card and fingerprint verify pass
#define MINOR_CARD_FINGERPRINT_VERIFY_FAIL              0x29    //card and fingerprint verify fail
#define MINOR_CARD_FINGERPRINT_VERIFY_TIMEOUT           0x2a    //card and fingerprint verify timeout
#define MINOR_CARD_FINGERPRINT_PASSWD_VERIFY_PASS       0x2b    //card and fingerprint and passwd verify pass
#define MINOR_CARD_FINGERPRINT_PASSWD_VERIFY_FAIL       0x2c    //card and fingerprint and passwd verify fail
#define MINOR_CARD_FINGERPRINT_PASSWD_VERIFY_TIMEOUT    0x2d    //card and fingerprint and passwd verify timeout
#define MINOR_FINGERPRINT_PASSWD_VERIFY_PASS            0x2e    //fingerprint and passwd verify pass
#define MINOR_FINGERPRINT_PASSWD_VERIFY_FAIL            0x2f    //fingerprint and passwd verify fail
#define MINOR_FINGERPRINT_PASSWD_VERIFY_TIMEOUT         0x30    //fingerprint and passwd verify timeout
#define MINOR_FINGERPRINT_INEXISTENCE                   0x31    //fingerprint inexistence
#define MINOR_CARD_PLATFORM_VERIFY                      0x32    //card platform verify
#define MINOR_CALL_CENTER                               0x33    //call center
#define MINOR_FIRE_RELAY_TURN_ON_DOOR_ALWAYS_OPEN       0x34    //fire relay turn on door always open
#define MINOR_FIRE_RELAY_RECOVER_DOOR_RECOVER_NORMAL    0x35    //fire relay recover door recover normal
#define MINOR_FACE_AND_FP_VERIFY_PASS                   0x36    //face and finger print verify pass
#define MINOR_FACE_AND_FP_VERIFY_FAIL                   0x37    //face and finger print verify fail
#define MINOR_FACE_AND_FP_VERIFY_TIMEOUT                0x38    //face and finger print verify timeout
#define MINOR_FACE_AND_PW_VERIFY_PASS                   0x39    //face and password verify pass
#define MINOR_FACE_AND_PW_VERIFY_FAIL                   0x3a    //face and password verify fail
#define MINOR_FACE_AND_PW_VERIFY_TIMEOUT                0x3b    //face and password verify timeout
#define MINOR_FACE_AND_CARD_VERIFY_PASS                 0x3c    //face and card verify pass
#define MINOR_FACE_AND_CARD_VERIFY_FAIL                 0x3d    //face and card verify fail
#define MINOR_FACE_AND_CARD_VERIFY_TIMEOUT              0x3e    //face and card verify timeout
#define MINOR_FACE_AND_PW_AND_FP_VERIFY_PASS            0x3f    //face and password and finger print verify pass
#define MINOR_FACE_AND_PW_AND_FP_VERIFY_FAIL            0x40    //face and password and finger print verify fail
#define MINOR_FACE_AND_PW_AND_FP_VERIFY_TIMEOUT         0x41    //face and password and finger print verify timeout
#define MINOR_FACE_CARD_AND_FP_VERIFY_PASS              0x42    //face and card and finger print verify pass
#define MINOR_FACE_CARD_AND_FP_VERIFY_FAIL              0x43    //face and card and finger print verify fail
#define MINOR_FACE_CARD_AND_FP_VERIFY_TIMEOUT           0x44    //face and card and finger print verify timeout
#define MINOR_EMPLOYEENO_AND_FP_VERIFY_PASS             0x45    //employee and finger print verify pass
#define MINOR_EMPLOYEENO_AND_FP_VERIFY_FAIL             0x46    //employee and finger print verify fail
#define MINOR_EMPLOYEENO_AND_FP_VERIFY_TIMEOUT          0x47    //employee and finger print verify timeout
#define MINOR_EMPLOYEENO_AND_FP_AND_PW_VERIFY_PASS      0x48    //employee and finger print and password verify pass
#define MINOR_EMPLOYEENO_AND_FP_AND_PW_VERIFY_FAIL      0x49    //employee and finger print and password verify fail
#define MINOR_EMPLOYEENO_AND_FP_AND_PW_VERIFY_TIMEOUT   0x4a    //employee and finger print and password verify timeout
#define MINOR_FACE_VERIFY_PASS                          0x4b    //face verify pass
#define MINOR_FACE_VERIFY_FAIL                          0x4c    //face verify fail
#define MINOR_EMPLOYEENO_AND_FACE_VERIFY_PASS           0x4d    //employee no and face verify pass
#define MINOR_EMPLOYEENO_AND_FACE_VERIFY_FAIL           0x4e    //employee no and face verify fail
#define MINOR_EMPLOYEENO_AND_FACE_VERIFY_TIMEOUT        0x4f    //employee no and face verify time out
#define MINOR_FACE_RECOGNIZE_FAIL                       0x50    //face recognize fail
#define MINOR_FIRSTCARD_AUTHORIZE_BEGIN                    0x51    //first card authorize begin
#define MINOR_FIRSTCARD_AUTHORIZE_END                    0x52    //first card authorize end
#define MINOR_DOORLOCK_INPUT_SHORT_CIRCUIT                0x53    //door lock input short circuit
#define MINOR_DOORLOCK_INPUT_BROKEN_CIRCUIT                0x54    //door lock input broken circuit
#define MINOR_DOORLOCK_INPUT_EXCEPTION                    0x55    //door lock input exception
#define MINOR_DOORCONTACT_INPUT_SHORT_CIRCUIT            0x56    //door contact input short circuit
#define MINOR_DOORCONTACT_INPUT_BROKEN_CIRCUIT            0x57    //door contact input broken circuit
#define MINOR_DOORCONTACT_INPUT_EXCEPTION                0x58    //door contact input exception
#define MINOR_OPENBUTTON_INPUT_SHORT_CIRCUIT            0x59    //open button input short circuit
#define MINOR_OPENBUTTON_INPUT_BROKEN_CIRCUIT            0x5a    //open button input broken circuit
#define MINOR_OPENBUTTON_INPUT_EXCEPTION                0x5b    //open button input exception
#define MINOR_DOORLOCK_OPEN_EXCEPTION                    0x5c    //door lock open exception
#define MINOR_DOORLOCK_OPEN_TIMEOUT                        0x5d    //door lock open timeout
#define MINOR_FIRSTCARD_OPEN_WITHOUT_AUTHORIZE            0x5e    //first card open without authorize
#define MINOR_CALL_LADDER_RELAY_BREAK                   0x5f    //call ladder relay break
#define MINOR_CALL_LADDER_RELAY_CLOSE                   0x60    //call ladder relay close
#define MINOR_AUTO_KEY_RELAY_BREAK                      0x61    //auto key relay break
#define MINOR_AUTO_KEY_RELAY_CLOSE                      0x62    //auto key relay close
#define MINOR_KEY_CONTROL_RELAY_BREAK                   0x63    //key control relay break
#define MINOR_KEY_CONTROL_RELAY_CLOSE                   0x64    //key control relay close
#define MINOR_EMPLOYEENO_AND_PW_PASS                    0x65    //minor employee no and password pass
#define MINOR_EMPLOYEENO_AND_PW_FAIL                    0x66    //minor employee no and password fail
#define MINOR_EMPLOYEENO_AND_PW_TIMEOUT                 0x67    //minor employee no and password timeout
#define MINOR_HUMAN_DETECT_FAIL                         0x68    //human detect fail
#define MINOR_PEOPLE_AND_ID_CARD_COMPARE_PASS           0x69    //the comparison with people and id card success
#define MINOR_PEOPLE_AND_ID_CARD_COMPARE_FAIL           0x70    //the comparison with people and id card failed
#define MINOR_CERTIFICATE_BLACK_LIST                    0x71    //black list
#define MINOR_LEGAL_MESSAGE                             0x72    //legal message
#define MINOR_ILLEGAL_MESSAGE                           0x73    //illegal messag
#define MINOR_MAC_DETECT                                0x74    //mac detect
#define MINOR_DOOR_OPEN_OR_DORMANT_FAIL                 0x75    //door open or dormant fail
#define MINOR_AUTH_PLAN_DORMANT_FAIL                    0x76    //auth plan dormant fail
#define MINOR_CARD_ENCRYPT_VERIFY_FAIL                  0x77    //card encrypt verify fail
#define MINOR_SUBMARINEBACK_REPLY_FAIL                  0x78    //submarineback reply fail
#define MINOR_DOOR_OPEN_OR_DORMANT_OPEN_FAIL            0x82    //door open or dormant open fail
#define MINOR_HEART_BEAT                                0x83    //heart beat event
#define MINOR_DOOR_OPEN_OR_DORMANT_LINKAGE_OPEN_FAIL    0x84    //door open or dormant linkage open fail 
#define MINOR_TRAILING                                  0x85    //trailing
#define MINOR_REVERSE_ACCESS                            0x86    //reverse access
#define MINOR_FORCE_ACCESS                              0x87    //force access
#define MINOR_CLIMBING_OVER_GATE                        0x88    //climbing over gate
#define MINOR_PASSING_TIMEOUT                           0x89    //passing timeout
#define MINOR_INTRUSION_ALARM                           0x8a    //intrusion alarm
#define MINOR_FREE_GATE_PASS_NOT_AUTH                   0x8b    //free gate pass not auth
#define MINOR_DROP_ARM_BLOCK                            0x8c    //drop arm block
#define MINOR_DROP_ARM_BLOCK_RESUME                     0x8d    //drop arm block resume
#define MINOR_LOCAL_FACE_MODELING_FAIL                  0x8e   //device upgrade with module failed
#define MINOR_STAY_EVENT                                0x8f    //stay event
#define MINOR_PASSWORD_MISMATCH                         0x97    //password mismatch
#define MINOR_EMPLOYEE_NO_NOT_EXIST                     0x98    //employee no not exist
#define MINOR_COMBINED_VERIFY_PASS                      0x99    //combined verify pass
#define MINOR_COMBINED_VERIFY_TIMEOUT                   0x9a    //combined verify timeout
#define MINOR_VERIFY_MODE_MISMATCH                      0x9b    //verify mode mismatch
#define MINOR_PASSPORT_VERIFY_FAIL                      0xa1    //passport info verify failed
#define MINOR_INFORMAL_MIFARE_CARD_VERIFY_FAIL          0xa2   //informal mifare card verify failed
#define MINOR_CPU_CARD_ENCRYPT_VERIFY_FAIL              0xa3   //CPU card encrypt verify failed
#define MINOR_NFC_DISABLE_VERIFY_FAIL                   0xa4   //NFC disable verify failed

#define MINOR_EVENT_CUSTOM1                         0x500  //event custom 1
#define MINOR_EVENT_CUSTOM2                         0x501  //event custom 2
#define MINOR_EVENT_CUSTOM3                         0x502  //event custom 3
#define MINOR_EVENT_CUSTOM4                         0x503  //event custom 4
#define MINOR_EVENT_CUSTOM5                         0x504  //event custom 5
#define MINOR_EVENT_CUSTOM6                         0x505  //event custom 6
#define MINOR_EVENT_CUSTOM7                         0x506  //event custom 7
#define MINOR_EVENT_CUSTOM8                         0x507  //event custom 8
#define MINOR_EVENT_CUSTOM9                         0x508  //event custom 9
#define MINOR_EVENT_CUSTOM10                        0x509  //event custom 10
#define MINOR_EVENT_CUSTOM11                        0x50a  //event custom 11
#define MINOR_EVENT_CUSTOM12                        0x50b  //event custom 12
#define MINOR_EVENT_CUSTOM13                        0x50c  //event custom 13
#define MINOR_EVENT_CUSTOM14                        0x50d  //event custom 14
#define MINOR_EVENT_CUSTOM15                        0x50e  //event custom 15
#define MINOR_EVENT_CUSTOM16                        0x50f  //event custom 16
#define MINOR_EVENT_CUSTOM17                        0x510  //event custom 17
#define MINOR_EVENT_CUSTOM18                        0x511  //event custom 18
#define MINOR_EVENT_CUSTOM19                        0x512  //event custom 19
#define MINOR_EVENT_CUSTOM20                        0x513  //event custom 20
#define MINOR_EVENT_CUSTOM21                        0x514  //event custom 21
#define MINOR_EVENT_CUSTOM22                        0x515  //event custom 22
#define MINOR_EVENT_CUSTOM23                        0x516  //event custom 23
#define MINOR_EVENT_CUSTOM24                        0x517  //event custom 24
#define MINOR_EVENT_CUSTOM25                        0x518  //event custom 25
#define MINOR_EVENT_CUSTOM26                        0x519  //event custom 26
#define MINOR_EVENT_CUSTOM27                        0x51a  //event custom 27
#define MINOR_EVENT_CUSTOM28                        0x51b  //event custom 28
#define MINOR_EVENT_CUSTOM29                        0x51c  //event custom 29
#define MINOR_EVENT_CUSTOM30                        0x51d  //event custom 30
#define MINOR_EVENT_CUSTOM31                        0x51e  //event custom 31
#define MINOR_EVENT_CUSTOM32                        0x51f  //event custom 32
#define MINOR_EVENT_CUSTOM33                        0x520  //event custom 33
#define MINOR_EVENT_CUSTOM34                        0x521  //event custom 34
#define MINOR_EVENT_CUSTOM35                        0x522  //event custom 35
#define MINOR_EVENT_CUSTOM36                        0x523  //event custom 36
#define MINOR_EVENT_CUSTOM37                        0x524  //event custom 37
#define MINOR_EVENT_CUSTOM38                        0x525  //event custom 38
#define MINOR_EVENT_CUSTOM39                        0x526  //event custom 39
#define MINOR_EVENT_CUSTOM40                        0x527  //event custom 40
#define MINOR_EVENT_CUSTOM41                        0x528  //event custom 41
#define MINOR_EVENT_CUSTOM42                        0x529  //event custom 42
#define MINOR_EVENT_CUSTOM43                        0x52a  //event custom 43
#define MINOR_EVENT_CUSTOM44                        0x52b  //event custom 44
#define MINOR_EVENT_CUSTOM45                        0x52c  //event custom 45
#define MINOR_EVENT_CUSTOM46                        0x52d  //event custom 46
#define MINOR_EVENT_CUSTOM47                        0x52e  //event custom 47
#define MINOR_EVENT_CUSTOM48                        0x52f  //event custom 48
#define MINOR_EVENT_CUSTOM49                        0x530  //event custom 49
#define MINOR_EVENT_CUSTOM50                        0x531  //event custom 50
#define MINOR_EVENT_CUSTOM51                        0x532  //event custom 51
#define MINOR_EVENT_CUSTOM52                        0x533  //event custom 52
#define MINOR_EVENT_CUSTOM53                        0x534  //event custom 53
#define MINOR_EVENT_CUSTOM54                        0x535  //event custom 54
#define MINOR_EVENT_CUSTOM55                        0x536  //event custom 55
#define MINOR_EVENT_CUSTOM56                        0x537  //event custom 56
#define MINOR_EVENT_CUSTOM57                        0x538  //event custom 57
#define MINOR_EVENT_CUSTOM58                        0x539  //event custom 58
#define MINOR_EVENT_CUSTOM59                        0x53a  //event custom 59
#define MINOR_EVENT_CUSTOM60                        0x53b  //event custom 60
#define MINOR_EVENT_CUSTOM61                        0x53c  //event custom 61
#define MINOR_EVENT_CUSTOM62                        0x53d  //event custom 62
#define MINOR_EVENT_CUSTOM63                        0x53e  //event custom 63
#define MINOR_EVENT_CUSTOM64                        0x53f  //event custom 64

#define MINOR_LOCK_FINGER_OPEN_DOOR          0x600    
#define MINOR_LOCK_PASSWORD_OPEN_DOOR        0x601    
#define MINOR_LOCK_CARD_OPEN_DOOR            0x602    
#define MINOR_LOCK_CENTER_OPEN_DOOR          0x603    
#define MINOR_LOCK_APP_OPEN_DOOR             0x604   
#define MINOR_LOCK_KEY_OPEN_DOOR             0x605   
#define MINOR_LOCK_REMOTE_DEVICE_OPEN_DOOR   0x606    
#define MINOR_LOCK_TMP_PASSWORD_OPEN_DOOR    0x607    
#define MINOR_LOCK_BLUETOOTH_OPEN_DOOR       0x608 
#define MINOR_LOCK_MULTI_OPEN_DOOR          0x609 

//2018-04-23 General gateway event type log
#define   MINOR_ALARMHOST_SCHOOLTIME_IRGI_B   0x1001     //B code timing
#define   MINOR_ALARMHOST_SCHOOLTIME_SDK     0x1002     //SDK timing
#define   MINOR_ALARMHOST_SCHOOLTIME_SELFTEST    0x1003   //Scheduled self-test timing
#define  MINOR_ALARMHOST_SUBSYSTEM_ABNORMALINSERT   0x1004  //subSystem abnormal insert 
#define  MINOR_ALARMHOST_SUBSYSTEM_ABNORMALPULLOUT   0x1005  //subSystem abnormal pull out

#define  MINOR_ALARMHOST_AUTO_ARM    0x1006  //auto arm
#define  MINOR_ALARMHOST_AUTO_DISARM    0x1007  //auto disarm
#define  MINOR_ALARMHOST_TIME_TIGGER_ON    0x1008  //turn on tigger on time
#define  MINOR_ALARMHOST_TIME_TIGGER_OFF   0x1009  //turn off tigger on time
#define  MINOR_ALARMHOST_AUTO_ARM_FAILD    0x100a  //auto arm failed
#define  MINOR_ALARMHOST_AUTO_DISARM_FAILD    0x100b  //auto disarm failed
#define  MINOR_ALARMHOST_TIME_TIGGER_ON_FAILD   0x100c  //turn on tigger on time failed
#define  MINOR_ALARMHOST_TIME_TIGGER_OFF_FAILD    0x100d  //turn off tigger on time failed
#define  MINOR_ALARMHOST_MANDATORY_ALARM    0x100e  //mandatory alarm
#define  MINOR_ALARMHOST_KEYPAD_LOCKED  0x100f  //keypad locked
#define  MINOR_ALARMHOST_USB_INSERT   0x1010  //USB insert 
#define  MINOR_ALARMHOST_USB_PULLOUT   0x1011 //USB pull out
#define  MINOR_ALARMHOST_4G_MODULS_ONLINE  0x1012  //4G module online
#define  MINOR_ALARMHOST_4G_MODULS_OFFLINE  0x1013  //4Gmodule offline

#define  MINOR_EZVIZ_CLOUD_ONLINE   0x1014   //EZVIZ on line
#define  MINOR_EZVIZ_CLOUD_OFFLINE    0x1015   //EZVIZ off line

#define  MINOR_SIPUA_GRID_ONLINE     0x1016   //SIP grid on line
#define  MINOR_SIPUA_GRID_OFFLINE    0x1017   //SIP grid off line

#define  MINOR_INTERNET_ACCESS_CONNECTED  0x1018   //Internet access connected
#define  MINOR_INTERNET_ACCESS_BREAK  0x1019  //Internet access break

#define  MINOR_WIRELESS_CONNECTED   0x101a  //Wireless connected
#define  MINOR_WIRELESS_BREAK     0x101b   //Wireless break
#define  MINOR_PORT_LINK_DOWN    0x101c  //port network link down
#define  MINOR_PORT_LINK_UP    0x101d  //port network link up
#define  MINOR_POE_PORT_POWER_ON    0x101e  //POE port power on
#define  MINOR_POE_PORT_POWER_OFF    0x101f  //POE port power off
#define  MINOR_POE_TOTAL_POWER_MAX    0x1020  //POE total power to poe-max
#define  MINNOR_POE_TOTAL_POWER_RESUME   0x1021  //POE total power resume


typedef enum tagALARMHOST_MAJOR_TYPE
{
    MAJOR_ALARMHOST_ALARM = 1,
    MAJOR_ALARMHOST_EXCEPTION,
    MAJOR_ALARMHOST_OPERATION,
    MAJ0R_ALARMHOST_EVENT
}ALARMHOST_MAJOR_TYPE;

typedef enum tagALARMHOST_MINOR_TYPE
{
    // Alarm 
    MINOR_SHORT_CIRCUIT = 0x01,      // Short circuit alarm
    MINOR_BROKEN_CIRCUIT,           // Broken circuit alarm
    MINOR_ALARM_RESET,              // Alarm reset 
    MINOR_ALARM_NORMAL,                // Alarm resumes to normal
    MINOR_PASSWORD_ERROR,            // Password error(consecutive times for password error)
    MINOR_ID_CARD_ILLEGALLY,        // Illegal proximity card ID
    MINOR_KEYPAD_REMOVE,            // Keypad tamper
    MINOR_KEYPAD_REMOVE_RESTORE,    // Keypad tamper reset
    MINOR_DEV_REMOVE,                // Device tamper
    MINOR_DEV_REMOVE_RESTORE,        // Device tamper reset
    MINOR_BELOW_ALARM_LIMIT1,        // Analog lower than alarm limit 1
    MINOR_BELOW_ALARM_LIMIT2,        // Analog lower than alarm limit 2
    MINOR_BELOW_ALARM_LIMIT3,        // Analog lower than alarm limit 3
    MINOR_BELOW_ALARM_LIMIT4,        // Analog lower than alarm limit 4
    MINOR_ABOVE_ALARM_LIMIT1,        // Analog higher than alarm limit 1
    MINOR_ABOVE_ALARM_LIMIT2,        // Analog higher than alarm limit 2
    MINOR_ABOVE_ALARM_LIMIT3,        // Analog higher than alarm limit 3
    MINOR_ABOVE_ALARM_LIMIT4,        // Analog higher than alarm limit 4
    MINOR_URGENCYBTN_ON,            // Urgency button on
    MINOR_URGENCYBTN_OFF,            // Urgency button off
    MINOR_VIRTUAL_DEFENCE_BANDIT,            //Virtual zone bandit
    MINOR_VIRTUAL_DEFENCE_FIRE,                //virtual zone fire
    MINOR_VIRTUAL_DEFENCE_URGENT,            //virtual zone urgent
    MINOR_ALARMHOST_MOTDET_START,            //start move detection
    MINOR_ALARMHOST_MOTDET_STOP,            //stop move detection
    MINOR_ALARMHOST_HIDE_ALARM_START,        //start hide alarm
    MINOR_ALARMHOST_HIDE_ALARM_STOP,        //stop hide alarm
    MINOR_ALARMHOST_UPS_ALARM,                //UPS alarm
    MINOR_ALARMHOST_ELECTRICITY_METER_ALARM, //electricity meter alarm
    MINOR_ALARMHOST_SWITCH_POWER_ALARM,      //switch power alarm
    MINOR_ALARMHOST_GAS_DETECT_SYS_ALARM,      //gas detect system alarm
    MINOR_ALARMHOST_TRANSFORMER_TEMPRATURE_ALARM, //transformer temprature alarm
    MINOR_ALARMHOST_TEMP_HUMI_ALARM,            //temprature&huminity sensor alarm
    MINOR_ALARMHOST_UPS_ALARM_RESTORE,    //UPS alarm restore
    MINOR_ALARMHOST_ELECTRICITY_METER_ALARM_RESTORE, //electricity meter alarm restore
    MINOR_ALARMHOST_SWITCH_POWER_ALARM_RESTORE,      //switch power alarm restore
    MINOR_ALARMHOST_GAS_DETECT_SYS_ALARM_RESTORE,      //gas detect system alarm restore
    MINOR_ALARMHOST_TRANSFORMER_TEMPRATURE_ALARM_RESTORE, //transformer temprature alarm restore
    MINOR_ALARMHOST_TEMP_HUMI_ALARM_RESTORE,          //temprature&huminity sensor alarm restore
    MINOR_ALARMHOST_WATER_LEVEL_SENSOR_ALARM,            //water level sensor alarm
    MINOR_ALARMHOST_WATER_LEVEL_SENSOR_ALARM_RESTORE,    //water level sensor alarm restore
    MINOR_ALARMHOST_DUST_NOISE_ALARM,                    //dust and noise alarm
    MINOR_ALARMHOST_DUST_NOISE_ALARM_RESTORE,            //dust and noise alarm restore
    MINOR_ALARMHOST_ENVIRONMENTAL_LOGGER_ALARM,            //environmental logger alarm
    MINOR_ALARMHOST_ENVIRONMENTAL_LOGGER_ALARM_RESTORE,    //environmental logger alarm restore

    MINOR_ALARMHOST_TRIGGER_TAMPER,                //trigger tamper
    MINOR_ALARMHOST_TRIGGER_TAMPER_RESTORE,                //trigger tamper restore
    MINOR_ALARMHOST_EMERGENCY_CALL_HELP_ALARM,            //emergency call help alarm
    MINOR_ALARMHOST_EMERGENCY_CALL_HELP_ALARM_RESTORE,    //emergency call help alarm restore
    MINOR_ALARMHOST_CONSULTING_ALARM,                     //consult alarm
    MINOR_ALARMHOST_CONSULTING_ALARM_RESTORE,             //consult alarm restore
    MINOR_ZONE_MODULE_REMOVE,            // zone module remove
    MINOR_ZONE_MODULE_RESET,    // zone module reset

    MINOR_ALARM_WIND_SPEED_ALARM,
    MINOR_ALARM_WIND_SPEED_ALARM_RESTORE,
    MINOR_ALARM_GENERATE_OUTPUT_ALARM,
    MINOR_ALARM_GENERATE_OUTPUT_RESTORE,
    MINOR_ALARM_SOAK_ALARM,
    MINOR_ALARM_SOAK_ALARM_RESTORE,
    MINOR_ALARM_SOLAR_POWER_ALARM,
    MINOR_ALARM_SOLAR_POWER_ALARM_RESTORE,
    MINOR_ALARM_SF6_ALARM,
    MINOR_ALARM_SF6_ALARM_RESTORE,
    MINOR_ALARM_WEIGHT_ALARM,
    MINOR_ALARM_WEIGHT_ALARM_RESTORE,
    MINOR_ALARM_WEATHER_ALARM,
    MINOR_ALARM_WEATHER_ALARM_RESTORE,
    MINOR_ALARM_FUEL_GAS_ALARM,
    MINOR_ALARM_FUEL_GAS_ALARM_RESTORE,
    MINOR_ALARM_FIRE_ALARM,
    MINOR_ALARM_FIRE_ALARM_RESTORE,

    MINOR_WIRELESS_OUTPUT_MODULE_REMOVE,            // wireless output module remove
    MINOR_WIRELESS_OUTPUT_MODULE_RESET,    // wireless output module reset
    MINOR_WIRELESS_REPEATER_MODULE_REMOVE,            // wireless repeater module remove
    MINOR_WIRELESS_REPEATER_MODULE_RESET,    // wireless repeater module reset
    MINOR_WIRELESS_SIREN_MODULE_REMOVE,            // wireless siren module remove
    MINOR_WIRELESS_SIREN_MODULE_RESET,    // wireless siren module reset
    MINOR_SOUND_INTENSITY_RISE,         // sound intensity rise
    MINOR_SOUND_INTENSITY_RISE_RESET,   // sound intensity rise reset
    MINOR_SOUND_INTENSITY_DROP,         // sound intensity drop
    MINOR_SOUND_INTENSITY_DROP_RESET,   // sound intensity drop reset
    MINOR_AUDIO_INPUT_EXCEPTION,        // audio input exception
    MINOR_AUDIO_INPUT_EXCEPTION_RESET,  // audio input exception reset

    // Exception
    MINOR_POWER_ON = 0x01,        // Power on
    MINOR_POWER_OFF,                // Power off
    MINOR_WDT_RESET,                // WDT reset
    MINOR_LOW_BATTERY_VOLTAGE,        // Low battery voltage
    MINOR_AC_LOSS,                    // AC loss
    MINOR_AC_RESTORE,                // AC restore
    MINOR_RTC_EXCEPTION,            // RTC real-time clock exception
    MINOR_NETWORK_CONNECT_FAILURE,    // Network is disconnected
    MINOR_NETWORK_CONNECT_RESTORE,    // Network connection restore
    MINOR_TEL_LINE_CONNECT_FAILURE,    // Telephone line is disconnected
    MINOR_TEL_LINE_CONNECT_RESTORE,    // Telephone line restore
    MINOR_EXPANDER_BUS_LOSS,        // Expansion bus module dropped
    MINOR_EXPANDER_BUS_RESTORE,        // Expansion bus module restore
    MINOR_KEYPAD_BUS_LOSS,            // Keyboard bus module dropped
    MINOR_KEYPAD_BUS_RESTORE,        // Keyboard bus module restore 
    MINOR_SENSOR_FAILURE,            // Analog sensor failure
    MINOR_SENSOR_RESTORE,            // Analog sensor restore
    MINOR_RS485_CONNECT_FAILURE,    // RS485 channel is disconnected
    MINOR_RS485_CONNECT_RESTORE,    // RS485 channel disconnection restore
    MINOR_BATTERT_VOLTAGE_RESTORE,  // Battery voltage resume to normal 
    MINOR_WIRED_NETWORK_ABNORMAL,    // network abnormal
    MINOR_WIRED_NETWORK_RESTORE,    // network restore
    MINOR_GPRS_ABNORMAL,            // GPRS abnormal
    MINOR_GPRS_RESTORE,                // GPRS restore
    MINOR_3G_ABNORMAL,                // 3G abnormal
    MINOR_3G_RESTORE,                // 3G restore
    MINOR_SIM_CARD_ABNORMAL,        // SIM Card abnormal
    MINOR_SIM_CARD_RESTORE,            // SIM Card restore
    MINOR_ALARMHOST_VI_LOST,        // video lost
    MINOR_ALARMHOST_ILLEGAL_ACCESS,    // illegnal access
    MINOR_ALARMHOST_HD_FULL,        // hard disk full
    MINOR_ALARMHOST_HD_ERROR,        // hard disk error
    MINOR_ALARMHOST_DCD_LOST,        // MODEM lost
    MINOR_ALARMHOST_IP_CONFLICT,    // IP  conflict
    MINOR_ALARMHOST_NET_BROKEN,        // network broken
    MINOR_ALARMHOST_REC_ERROR,      // record error
    MINOR_ALARMHOST_VI_EXCEPTION,   // video exception
    MINOR_ALARMHOST_FORMAT_HDD_ERROR, //format hard disk error
    MINOR_ALARMHOST_USB_ERROR,        //USB connect error
    MINOR_ALARMHOST_USB_RESTORE,    //USB connect restore
    MINOR_ALARMHOST_PRINT_ERROR,    //printer error
    MINOR_ALARMHOST_PRINT_RESTORE,    //printer restore
    MINOR_SUBSYSTEM_COMMUNICATION_ERROR, //subsystem communication error
    MINOR_ALARMHOST_IPC_NO_LINK,        //IPC connection failed 
    MINOR_ALARMHOST_IPC_IP_CONFLICT,//IPC IP conflict
    MINOR_ALARMHOST_VI_MISMATCH,    //Video format error.
    MINOR_ALARMHOST_MCU_RESTART,    //MCU restart
    MINOR_ALARMHOST_GPRS_MODULE_FAULT,                     //GPRS Module Fault
    MINOR_ALARMHOST_TELEPHONE_MODULE_FAULT,                 //Telephone Module Fault
    MINOR_ALARMHOST_WIFI_ABNORMAL,
    MINOR_ALARMHOST_WIFI_RESTORE,
    MINOR_ALARMHOST_RF_ABNORMAL,
    MINOR_ALARMHOST_RF_RESTORE,
    MINOR_ALARMHOST_DETECTOR_ONLINE,
    MINOR_ALARMHOST_DETECTOR_OFFLINE,
    MINOR_ALARMHOST_DETECTOR_BATTERY_NORMAL,
    MINOR_ALARMHOST_DETECTOR_BATTERY_LOW,
    MINOR_ALARMHOST_DATA_TRAFFIC_OVERFLOW,
    MINOR_ZONE_MODULE_LOSS,
    MINOR_ZONE_MODULE_RESTORE,
    MINOR_ALARMHOST_WIRELESS_OUTPUT_LOSS,   //wireless output module loss
    MINOR_ALARMHOST_WIRELESS_OUTPUT_RESTORE,   //wireless output module restore
    MINOR_ALARMHOST_WIRELESS_REPEATER_LOSS,   //wireless repeater loss
    MINOR_ALARMHOST_WIRELESS_REPEATER_RESTORE,   //wireless repeater restore
    MINOR_TRIGGER_MODULE_LOSS,            // trigger module loss
    MINOR_TRIGGER_MODULE_RESTORE,        // trigger module restore
    MINOR_WIRELESS_SIREN_LOSS,            // wireless siren loss
    MINOR_WIRELESS_SIREN_RESTORE,    // wireless siren  restore
    MINOR_ALARMHOST_WIRELESS_RS485_LOSS, //wireless RS485 module loss
    MINOR_ALARMHOST_WIRELESS_RS485_RESTORE, //wireless RS485 module loss restore


    // Operation
    MINOR_GUARD = 0x01,        // Normal arm
    MINOR_UNGUARD,                    // Normal disarm
    MINOR_BYPASS,                    // Bypass
    MINOR_DURESS_ACCESS,            // Duress access
    MINOR_ALARMHOST_LOCAL_REBOOT,    // Local reboot
    MINOR_ALARMHOST_REMOTE_REBOOT,    // Remote reboot
    MINOR_ALARMHOST_LOCAL_UPGRADE,    // Local upgrade
    MINOR_ALARMHOST_REMOTE_UPGRADE,    // Remote upgrade
    MINOR_RECOVERY_DEFAULT_PARAM,    // Recovery default parameter
    MINOR_ALARM_OUTPUT,                // Control alarm output 
    MINOR_ACCESS_OPEN,                // Control access open
    MINOR_ACCESS_CLOSE,                // Control access close
    MINOR_SIREN_OPEN,                // Control siren open
    MINOR_SIREN_CLOSE,                // Control siren close
    MINOR_MOD_ZONE_CONFIG,              // Modify defense area configuration
    MINOR_MOD_ALARMOUT_CONIFG,        // Control alarmout configuration
    MINOR_MOD_ANALOG_CONFIG,        // Modify analog configuration
    MINOR_RS485_CONFIG,                // Modify RS-485 configuration
    MINOR_PHONE_CONFIG,                // Modify dialing configuration
    MINOR_ADD_ADMIN,                // Add administrator
    MINOR_MOD_ADMIN_PARAM,            // Modify password of administrator
    MINOR_DEL_ADMIN,                // Delete administrator
    MINOR_ADD_NETUSER,                // Add network user
    MINOR_MOD_NETUSER_PARAM,        // Modify password of network user
    MINOR_DEL_NETUSER,                // Delete network user
    MINOR_ADD_OPERATORUSER,            // Add operator user
    MINOR_MOD_OPERATORUSER_PW,        // Add operator user
    MINOR_DEL_OPERATORUSER,            // Add operator user
    MINOR_ADD_KEYPADUSER,            // Add user of keyboard or card reader    
    MINOR_DEL_KEYPADUSER,            // Delete user of keyboard or card reader
    MINOR_REMOTEUSER_LOGIN,            // Remote login
    MINOR_REMOTEUSER_LOGOUT,        // Remote logout
    MINOR_REMOTE_GUARD,                // Remotely fortify
    MINOR_REMOTE_UNGUARD,            // Remotely cancel fortification
    MINOR_MOD_HOST_CONFIG,          // Modify host configuration
    MINOR_RESTORE_BYPASS,            // Bypass restore
    MINOR_ALARMOUT_OPEN,            // Open alarm out
    MINOR_ALARMOUT_CLOSE,            // Close alarm out
    MINOR_MOD_SUBSYSTEM_PARAM,        // Mod subsystem config
    MINOR_GROUP_BYPASS,                // Group bypass
    MINOR_RESTORE_GROUP_BYPASS,        // Restore group bypass
    MINOR_MOD_GRPS_PARAM,            // Mod gprs parameter
    MINOR_MOD_NET_REPORT_PARAM,        // Mod net report config
    MINOR_MOD_REPORT_MOD,            // Mod report config
    MINOR_MOD_GATEWAY_PARAM,        // Mod gateway config
    MINOR_ALARMHOST_REMOTE_START_REC,        // Start remote record
    MINOR_ALARMHOST_REMOTE_STOP_REC,        // Stop remote record
    MINOR_ALARMHOST_START_TRANS_CHAN,        // Start trans channel
    MINOR_ALARMHOST_STOP_TRANS_CHAN,        // Stop trans channel
    MINOR_ALARMHOST_START_VT,                // Start voice intercom
    MINOR_ALARMHOST_STOP_VTM,                // Stop voice intercom
    MINOR_ALARMHOST_REMOTE_PLAYBYFILE,        // Remote playback by file name
    MINOR_ALARMHOST_REMOTE_PLAYBYTIME,      // Remote playback by time
    MINOR_ALARMHOST_REMOTE_PTZCTRL,            // Remote PTZ control
    MINOR_ALARMHOST_REMOTE_FORMAT_HDD,      // Remote Format hard disk
    MINOR_ALARMHOST_REMOTE_LOCKFILE,        // Remote lock file
    MINOR_ALARMHOST_REMOTE_UNLOCKFILE,      // Remote unlock file
    MINOR_ALARMHOST_REMOTE_CFGFILE_OUTPUT,  // Remote Import config file
    MINOR_ALARMHOST_REMOTE_CFGFILE_INTPUT,  // Remote Export config file
    MINOR_ALARMHOST_REMOTE_RECFILE_OUTPUT,  // Remote Export record file

    MINOR_ALARMHOST_STAY_ARM,                        //stay arm
    MINOR_ALARMHOST_QUICK_ARM,                        //quick arm
    MINOR_ALARMHOST_AUTOMATIC_ARM,                    //auto arm
    MINOR_ALARMHOST_AUTOMATIC_DISARM,                //auto disarm
    MINOR_ALARMHOST_KEYSWITCH_ARM,                    //key switch arm
    MINOR_ALARMHOST_KEYSWITCH_DISARM,                //key switch disarm
    MINOR_ALARMHOST_CLEAR_ALARM,                    //clear alarm
    MINOR_ALARMHOST_MOD_FAULT_CFG,                    //mod fault config
    MINOR_ALARMHOST_MOD_EVENT_TRIGGER_ALARMOUT_CFG,    //mod event cause alarm out 
    MINOR_ALARMHOST_SEARCH_EXTERNAL_MODULE,            //search external module
    MINOR_ALARMHOST_REGISTER_EXTERNAL_MODULE,        //register external module
    MINOR_ALARMHOST_CLOSE_KEYBOARD_ALARM,            //close keyboard alarm
    MINOR_ALARMHOST_MOD_3G_PARAM,                    //modify 3G parameter
    MINOR_ALARMHOST_MOD_PRINT_PARAM, //modify printer parameter
    MINOR_SD_CARD_FORMAT,        //SD card format
    MINOR_SUBSYSTEM_UPGRADE,        //subsystem upgrade

    MINOR_ALARMHOST_PLAN_ARM_CFG,    //arm plan config 
    MINOR_ALARMHOST_PHONE_ARM,        //phone arm
    MINOR_ALARMHOST_PHONE_STAY_ARM,    //phone stay arm
    MINOR_ALARMHOST_PHONE_QUICK_ARM,//phone quick arm
    MINOR_ALARMHOST_PHONE_DISARM,    //phone disarm
    MINOR_ALARMHOST_PHONE_CLEAR_ALARM,    //phone clear alarm
    MINOR_ALARMHOST_WHITELIST_CFG,    //white list config
    MINOR_ALARMHOST_TIME_TRIGGER_CFG,            //turn on/off trigger config
    MINOR_ALARMHOST_CAPTRUE_CFG,                //capture config
    MINOR_ALARMHOST_TAMPER_CFG,                //tamper config

    MINOR_ALARMHOST_REMOTE_KEYPAD_UPGRADE,               //Remote Keypad Upgrade
    MINOR_ALARMHOST_ONETOUCH_AWAY_ARMING,                //One-touch Away Arming
    MINOR_ALARMHOST_ONETOUCH_STAY_ARMING,                //One-touch Stay Arming
    MINOR_ALARMHOST_SINGLE_PARTITION_ARMING_OR_DISARMING,    //Single Partition Arming/Disarming 
    MINOR_ALARMHOST_CARD_CONFIGURATION,         //Card Configuration
    MINOR_ALARMHOST_CARD_ARMING_OR_DISARMING,         //Card Arming/Disarming
    MINOR_ALARMHOST_EXPENDING_NETCENTER_CONFIGURATION,         //Expending Network Center Configuration
    MINOR_ALARMHOST_NETCARD_CONFIGURATION,         //Network Card Configuration
    MINOR_ALARMHOST_DDNS_CONFIGURATION,         //DDNS Configuration
    MINOR_ALARMHOST_RS485BUS_CONFIGURATION,        // RS-485 Bus Configuration
    MINOR_ALARMHOST_RS485BUS_RE_REGISTRATION,            //RS-486 Bus Re-registration

    MINOR_ALARMHOST_REMOTE_OPEN_ELECTRIC_LOCK,    //remote open electric lock
    MINOR_ALARMHOST_REMOTE_CLOSE_ELECTRIC_LOCK,    //remote close electric lock
    MINOR_ALARMHOST_LOCAL_OPEN_ELECTRIC_LOCK,    //local open electric lock
    MINOR_ALARMHOST_LOCAL_CLOSE_ELECTRIC_LOCK,    //local close electric lock
    MINOR_ALARMHOST_OPEN_ALARM_LAMP,            //open alarm lamp(remote)
    MINOR_ALARMHOST_CLOSE_ALARM_LAMP,            //close alarm lamp(remote)


    MINOR_ALARMHOST_TEMPORARY_PASSWORD,
    MINOR_ALARMHOST_ONEKEY_AWAY_ARM,
    MINOR_ALARMHOST_ONEKEY_STAY_ARM,
    MINOR_ALARMHOST_SINGLE_ZONE_ARM,
    MINOR_ALARMHOST_SINGLE_ZONE_DISARM,
    MINOR_ALARMHOST_HIDDNS_CONFIG,
    MINOR_ALARMHOST_REMOTE_KEYBOARD_UPDATA,
    MINOR_ALARMHOST_ZONE_ADD_DETECTOR,
    MINOR_ALARMHOST_ZONE_DELETE_DETECTOR,
    MINOR_ALARMHOST_QUERY_DETECTOR_SIGNAL,
    MINOR_ALARMHOST_QUERY_DETECTOR_BATTERY,
    MINOR_ALARMHOST_SET_DETECTOR_GUARD,
    MINOR_ALARMHOST_SET_DETECTOR_UNGUARD,
    MINOR_ALARMHOST_SET_WIFI_PARAMETER,
    MINOR_ALARMHOST_OPEN_VOICE,
    MINOR_ALARMHOST_CLOSE_VOICE,
    MINOR_ALARMHOST_ENABLE_FUNCTION_KEY,
    MINOR_ALARMHOST_DISABLE_FUNCTION_KEY,
    MINOR_ALARMHOST_READ_CARD,            //patrol read card
    MINOR_ALARMHOST_START_BROADCAST,             //open broadcast
    MINOR_ALARMHOST_STOP_BROADCAST,               //close broadcast
    MINOR_ALARMHOST_REMOTE_ZONE_MODULE_UPGRADE,
    MINOR_ALARMHOST_NETWORK_MODULE_EXTEND,    //network module params cfg
    MINOR_ALARMHOST_ADD_CONTROLLER,		//add controller user
    MINOR_ALARMHOST_DELETE_CONTORLLER,		//delete controller user
    MINOR_ALARMHOST_REMOTE_NETWORKMODULE_UPGRADE,
    MINOR_ALARMHOST_WIRELESS_OUTPUT_ADD,
    MINOR_ALARMHOST_WIRELESS_OUTPUT_DEL,
    MINOR_ALARMHOST_WIRELESS_REPEATER_ADD,
    MINOR_ALARMHOST_WIRELESS_REPEATER_DEL,
    MINOR_ALARMHOST_PHONELIST_CFG,
    MINOR_ALARMHOST_RF_SIGNAL_CHECK,
    MINOR_ALARMHOST_USB_UPGRADE,
    MINOR_ALARMHOST_DOOR_TIME_REMINDER_CFG,
    MINOR_ALARMHOST_WIRELESS_SIREN_ADD,
    MINOR_ALARMHOST_WIRELESS_SIREN_DEL,
    MINOR_ALARMHOST_OUT_SCALE_OPEN,
    MINOR_ALARMHOST_OUT_SCALE_CLOSE,

    MINOR_ALARMHOST_LOCAL_SET_DEVICE_ACTIVE = 0xf0,        //local activate device
    MINOR_ALARMHOST_REMOTE_SET_DEVICE_ACTIVE = 0xf1,        //remote activate device
    MINOR_ALARMHOST_LOCAL_PARA_FACTORY_DEFAULT = 0xf2,    //local parameter factory default
    MINOR_ALARMHOST_REMOTE_PARA_FACTORY_DEFAULT = 0xf3,    //remote parameter factory default

    // Event 
    MINOR_SCHOOLTIME_IRGI_B = 0x01,        // B code timing
    MINOR_SCHOOLTIME_SDK,                // SDK timing
    MINOR_SCHOOLTIME_SELFTEST,            // Scheduled self-test timing
    MINOR_SUBSYSTEM_ABNORMALINSERT,        //subSystem abnormal insert
    MINOR_SUBSYSTEM_ABNORMALPULLOUT,        //subSystem abnormal pullout

    MINOR_AUTO_ARM,                //auto arm
    MINOR_AUTO_DISARM,            //auto disarm
    MINOR_TIME_TIGGER_ON,                        //turn on tigger on time
    MINOR_TIME_TIGGER_OFF,                        //turn off tigger on time
    MINOR_AUTO_ARM_FAILD,            //auto arm failed
    MINOR_AUTO_DISARM_FAILD,        //auto disarm failed
    MINOR_TIME_TIGGER_ON_FAILD,                        //turn on tigger on time failed
    MINOR_TIME_TIGGER_OFF_FAILD,                        //turn off tigger on time failed
    MINOR_MANDATORY_ALARM,                //mandatory alarm
    MINOR_KEYPAD_LOCKED,            //keypad locked
    MINOR_USB_INSERT,
    MINOR_USB_PULLOUT,
}ALARMHOST_MINOR_TYPE;
/*
If the main type of the log is MAJOR_OPERATION=03 (Operation) And Sub type is
MINOR_LOCAL_CFG_PARM=0x52 (local configuration)
MINOR_REMOTE_GET_PARM=0x76 (remote get configuration)
MINOR_REMOTE_CFG_PARM=0x77 (remote set configuration)
dwParaType:  is valid,  and the relative definition is listed as below:
*/
#define PARA_VIDEOOUT      0x1
#define PARA_IMAGE          0x2
#define PARA_ENCODE          0x4
#define PARA_NETWORK      0x8
#define PARA_ALARM          0x10
#define PARA_EXCEPTION      0x20
#define PARA_DECODER      0x40    /*Decoder*/
#define PARA_RS232          0x80
#define PARA_PREVIEW      0x100
#define PARA_SECURITY      0x200
#define PARA_DATETIME      0x400
#define PARA_FRAMETYPE      0x800    /*Frame Type*/
#define PARA_DETECTION    0x1000   //Detection config
#define PARA_VCA_RULE     0x1001   //Rules of conduct 
#define PARA_VCA_CTRL     0x1002   //Intelligent control information configured
#define PARA_VCA_PLATE      0x1003   //  License Plate Recognition

#define PARA_CODESPLITTER 0x2000 /*spitter code parameter*/
//2010- 01- 22 
#define PARA_RS485          0x2001            /* RS485 config info*/
#define PARA_DEVICE          0x2002            /* Device config info*/
#define PARA_HARDDISK      0x2003            /* HD config info */
#define PARA_AUTOBOOT      0x2004            /* Auto-reboot info*/
#define PARA_HOLIDAY      0x2005            /* Holiday info*/            
#define PARA_IPC          0x2006            /* IPC channel info */

typedef enum tagCharEncodeType
{
    ENUM_MEM_CHAR_ENCODE_ERR = -1,         //Error   
    ENUM_MEM_CHAR_ENCODE_NO = 0,          //Don't know.
    ENUM_MEM_CHAR_ENCODE_CN = 1,          //EUC-CN, GB2312
    ENUM_MEM_CHAR_ENCODE_GBK = 2,          //GBK
    ENUM_MEM_CHAR_ENCODE_BIG5 = 3,          //BIG5
    ENUM_MEM_CHAR_ENCODE_JP = 4,          //JISX0208-1, EUC-JP
    ENUM_MEM_CHAR_ENCODE_KR = 5,          //EUC-KR
    ENUM_MEM_CHAR_ENCODE_UTF8 = 6,          //UTF-8
    ENUM_MEM_CHAR_ENCODE_ISO8859_1 = 7,    //ISO-8859-n: ENUM_MEM_CHAR_ENCODE_ISO8859_1 + n -1
    ENUM_MEM_CHAR_ENCODE_UNICODE = 8,       //Unicode
}CHAR_ENCODE_TYPE;

//Time correction structure
typedef struct
{
    DWORD dwYear;             //Year
    DWORD dwMonth;             //Month
    DWORD dwDay;             //Day
    DWORD dwHour;             //Hour
    DWORD dwMinute;         //Minute
    DWORD dwSecond;         //Second
}NET_DVR_TIME, *LPNET_DVR_TIME;

typedef struct tagNET_DVR_TIME_V30
{
    WORD wYear;
    BYTE byMonth;
    BYTE byDay;
    BYTE byHour;
    BYTE byMinute;
    BYTE bySecond;
    BYTE    byISO8601;      
    WORD wMilliSec;
    char    cTimeDifferenceH;  		
    char    cTimeDifferenceM;         
}NET_DVR_TIME_V30, *LPNET_DVR_TIME_V30;

typedef struct tagNET_DVR_TIME_SEARCH
{
    WORD     wYear;
    BYTE    byMonth;
    BYTE     byDay;
    BYTE     byHour;
    BYTE     byMinute;
    BYTE     bySecond;
    char cTimeDifferenceH;        //The time difference between with the international standard time (hours), - 12 ... + 14
    char cTimeDifferenceM;        //The time difference between with the international standard time (minutes),-30, 0, 30, 45
    BYTE     byLocalOrUTC;      //0-cTimeDifferenceH&cTimeDifferenceM is invalid 1- TimeDifference is valid
    WORD     wMillisecond;
}NET_DVR_TIME_SEARCH, *LPNET_DVR_TIME_SEARCH;

typedef struct tagNET_DVR_TIME_SEARCH_COND
{
    WORD wYear;
    BYTE byMonth;
    BYTE byDay;
    BYTE byHour;
    BYTE byMinute;
    BYTE bySecond;
    BYTE byLocalOrUTC;  //0-cTimeDifferenceH&cTimeDifferenceM is invalid 1- TimeDifference is valid
    WORD wMillisecond;      
    char cTimeDifferenceH;   //The time difference between with the international standard time (hours), - 12 ... + 14
    char cTimeDifferenceM;   //The time difference between with the international standard time (minutes),-30, 0, 30, 45
}NET_DVR_TIME_SEARCH_COND, *LPNET_DVR_TIME_SEARCH_COND;


typedef struct tagNET_DVR_TIME_V50
{
    WORD 		wYear;		
    BYTE		byMonth;   
    BYTE 		byDay;		
    BYTE 		byHour;		
    BYTE 		byMinute;	
    BYTE 		bySecond;	
    BYTE   	    byISO8601;  //0-cTimeDifferenceH&cTimeDifferenceM is invalid 1- TimeDifference is valid
    WORD  	    wMillisecond;       
    char cTimeDifferenceH;   //time difference with UTC(HOUR)
    char cTimeDifferenceM;   //time difference with UTC(MINUTE)
}NET_DVR_TIME_V50, *LPNET_DVR_TIME_V50;

typedef struct  tagNET_DVR_CALIBRATE_TIME
{
    DWORD  dwSize;
    NET_DVR_TIME struTime;
    WORD wMilliSec;
    BYTE byRes[14];
}NET_DVR_CALIBRATE_TIME, *LPNET_DVR_CALIBRATE_TIME;

/*
IP Address
*/
typedef struct
{
    char    sIpV4[16];                         //IPv4 Address 
    BYTE    byIPv6[128];                     //Reserved 
}NET_DVR_IPADDR, *LPNET_DVR_IPADDR;

//Log Info (9000extended) 
typedef struct
{
    NET_DVR_TIME strLogTime;
    DWORD    dwMajorType;     //Main type 1- alarm;  2- abnormal;  3- operation;  0xff- all 
    DWORD    dwMinorType;     //Hypo- Type 0- all; 
    BYTE    sPanelUser[MAX_NAMELEN];  //user ID for local panel operation
    BYTE    sNetUser[MAX_NAMELEN]; //user ID for network operation
    NET_DVR_IPADDR    struRemoteHostAddr; //remote host IP
    DWORD    dwParaType; //parameter type,  for 9000 series MINOR_START_VT/MINOR_STOP_VT,  channel of the voice talking
    DWORD    dwChannel; //channel number
    DWORD    dwDiskNumber; //HD number
    DWORD    dwAlarmInPort; //alarm input port
    DWORD    dwAlarmOutPort; //alarm output port
    DWORD   dwInfoLen;
    char    sInfo[LOG_INFO_LEN];
}NET_DVR_LOG_V30, *LPNET_DVR_LOG_V30;

//Log Info
typedef struct
{
    NET_DVR_TIME strLogTime;
    DWORD    dwMajorType;     //MMain type 1- alarm;  2- abnormal;  3- operation;  0xff- all 
    DWORD    dwMinorType; //Hypo- Type 0- all; 
    BYTE    sPanelUser[MAX_NAMELEN];  //user ID for local panel operation
    BYTE    sNetUser[MAX_NAMELEN]; //user ID for network operation
    char    sRemoteHostAddr[16]; //remote host IP
    DWORD    dwParaType; //parameter type
    DWORD    dwChannel; //channel number
    DWORD    dwDiskNumber; //HD number
    DWORD    dwAlarmInPort; //alarm input port
    DWORD    dwAlarmOutPort; //alarm output port
}NET_DVR_LOG, *LPNET_DVR_LOG;

typedef struct tagNET_DVR_FIND_LOG_COND
{
    DWORD            dwSelectMode;  // 0-all;1-with type;2-with time;3-with time and type;
    DWORD            dwMainType;	
    DWORD            dwSubType;	
    NET_DVR_TIME_V50 struStartTime; 
    NET_DVR_TIME_V50 struEndTime;   
    BOOL 		     bOnlySmart;    
    BYTE             byRes[128];
}NET_DVR_FIND_LOG_COND, *LPNET_DVR_FIND_LOG_COND;


typedef struct
{
    NET_DVR_TIME_V50 	struLogTime;  
    DWORD               dwMajorType;     //MMain type 1- alarm;  2- abnormal;  3- operation;  0xff- all 
    DWORD               dwMinorType; //Hypo- Type 0- all; 
    BYTE                sPanelUser[MAX_NAMELEN];  //user ID for local panel operation
    BYTE                sNetUser[MAX_NAMELEN]; //user ID for network operation
    NET_DVR_IPADDR      struRemoteHostAddr; //remote host IP
    DWORD               dwParaType; //parameter type
    DWORD               dwChannel; //channel number
    DWORD               dwDiskNumber; //HD number
    DWORD               dwAlarmInPort; //alarm input port
    DWORD               dwAlarmOutPort; //alarm output port
    DWORD               dwInfoLen;
    char                sInfo[LOG_INFO_LEN];
    BYTE                byRes[128];
}NET_DVR_LOG_V50, *LPNET_DVR_LOG_V50;

/************************DVR Log end***************************/

/*************************************************
Parameters configuration structure (_V30 is for 9000)
**************************************************/

/////////////////////////////////////////////////////////////////////////
#define    MAX_TIMESIGN_LEN    32 //Custom Set Time Sign Info Length
typedef  struct tagNET_DVR_TIMESIGN_CFG
{
    DWORD  dwSize;
    BYTE  byCustomSetTimeSign[MAX_TIMESIGN_LEN/*32*/];//Custom Set Time Sign
    BYTE  byRes[96];
}NET_DVR_TIMESIGN_CFG, *LPNET_DVR_TIMESIGN_CFG;

typedef struct tagNET_DVR_TIME_EX
{
    WORD wYear;
    BYTE byMonth;
    BYTE byDay;
    BYTE byHour;
    BYTE byMinute;
    BYTE bySecond;
    BYTE byRes;
}NET_DVR_TIME_EX, *LPNET_DVR_TIME_EX;

//Time Segment (Sub structure) 
typedef struct
{
    //Start
    BYTE byStartHour;
    BYTE byStartMin;
    //End
    BYTE byStopHour;
    BYTE byStopMin;
}NET_DVR_SCHEDTIME, *LPNET_DVR_SCHEDTIME;

/*Handling way of Alarm & Exception*/
#define NOACTION            0x0                /*Don't Respond*/
#define WARNONMONITOR        0x1                /*Warning on Monitor*/
#define WARNONAUDIOOUT        0x2                /*Audio Warning*/
#define UPTOCENTER            0x4                /*Upload to center*/
#define TRIGGERALARMOUT        0x8                /*Trigger Alarm Output*/
#define TRIGGERCATPIC        0x10            /*capture picture and E-mail*/
#define SEND_PIC_FTP        0x200           /*capture picture and upload to ftp*/

typedef struct tagNET_DVR_HANDLEEXCEPTION_V41
{
    DWORD   dwHandleType;        //Way to handle,  result of operation OR    
    /*0x00:  No response*/
    /*0x01:  Alarm on monitor*/
    /*0x02:  Audio Alarm*/
    /*0x04:  Upload to center*/
    /*0x08:  Trigger alarm output*/
    /*0x10:  Grab JPEG image and EMail it*/
    /*0x20:  wireless voice and light alarm*/
    /*0x40:  Trigger electric map(only PCNVR supports)*/
    /*0x200: capture jpeg and update to FTP*/
    /*0x4000: white light alarm*/
    /*0x10000: SMS alarm*/
    DWORD   dwMaxRelAlarmOutChanNum; //the max of dvr support can trigger the alarm output channel number (read-only)
    DWORD   dwRelAlarmOut[MAX_ALARMOUT_V40];  //Trigger an alarm channel ,  Encountered 0xffffffff follow-up without alarm trigger channel  
    BYTE    byRes[64];
}NET_DVR_HANDLEEXCEPTION_V41, *LPNET_DVR_HANDLEEXCEPTION_V41;

//Handle Alarm & Exception
typedef struct  tagNET_DVR_HANDLEEXCEPTION_V40
{
    DWORD   dwHandleType;        //Way to handle,  result of operation OR   
    /*0x00:  No response*/
    /*0x01:  Alarm on monitor*/
    /*0x02:  Audio Alarm*/
    /*0x04:  Upload to center*/
    /*0x08:  Trigger alarm output*/
    /*0x10:  Grab JPEG image and EMail it*/
    /*0x20:  wireless voice and light alarm*/
    /*0x40:  Trigger electric map(only PCNVR supports)*/
    /*0x80:  alarm trigger recording (currently only PCNVR support)*/
    /*0x100: alarm trigger PTZ preset point (currently only PCNVR support)*/
    /*0x200: capture jpeg and update to FTP*/
    /*0x400: virtual intersecting detection of linkage focus mode (provides a configuration item, the original equipment automatically) IPC5.1.0*/
    /*0x800: PTZ track linkage*/
    /*0x1000:capture jpeg and update to cloud*/
    /*0x2000:short message alarm*/
    /*0x4000:white light alarm*/
    /*0x8000:audio alarm*/
    DWORD  dwMaxRelAlarmOutChanNum;        //the max of dvr support can trigger the alarm output channel number (read-only)
    DWORD  dwRelAlarmOutChanNum;           //The actual number of alarm out channels set
    DWORD   dwRelAlarmOut[MAX_CHANNUM_V30]; //Trigger an alarm channel ,  Encountered 0xffffffff follow-up without alarm trigger channel
    BYTE    byWhiteLightDurationTime;//White Light Duration Time(1-60s)
    BYTE    byBrightness;//brightness,range:0-100,default:50
    BYTE    byAudioType;//Audio type
    BYTE    byTimes;//Audio alarm times, range:0-9,default:2, 0xff-continue
    BYTE    byRes[60];
}NET_DVR_HANDLEEXCEPTION_V40, *LPNET_DVR_HANDLEEXCEPTION_V40;

typedef struct
{
    DWORD    dwHandleType;     /*Way to handle,  result of operation OR*/
    /*0x00:  No response*/
    /*0x01:  Alarm on monitor*/
    /*0x02:  Audio Alarm*/
    /*0x04:  Upload to center*/
    /*0x08:  Trigger alarm output*/
    /*0x10:  Grab JPEG image and EMail it*/
    /*0x20:  wireless voice and light alarm*/
    /*0x40:  Trigger electric map(only PCNVR supports)*/
    /*0x200: capture jpeg and update to FTP*/
    /*0x2000:sms alarm*/
    BYTE byRelAlarmOut[MAX_ALARMOUT_V30];
    //Alarm out channel,  1 means trigger this channel
}NET_DVR_HANDLEEXCEPTION_V30, *LPNET_DVR_HANDLEEXCEPTION_V30;

//Handle Alarm & Exception  (sub structure) 
typedef struct
{
    DWORD    dwHandleType;             /*Way to handle,  result of operation OR*/
    /*0x00:  No response*/
    /*0x01:  Alarm on monitor*/
    /*0x02:  Audio Alarm*/
    /*0x04:  Upload to center*/
    /*0x08:  Trigger alarm output*/
    /*0x10:  Grab JPEG image and EMail it*/
    BYTE byRelAlarmOut[MAX_ALARMOUT];  //Alarm out channel,  1 means trigger this channel
}NET_DVR_HANDLEEXCEPTION, *LPNET_DVR_HANDLEEXCEPTION;

//DVR Device Parameters
typedef struct
{
    DWORD dwSize;
    BYTE sDVRName[NAME_LEN];    //DVR Name
    DWORD dwDVRID;                 //DVR ID for IR Control //V1.4 (0- 99) ,  V1.5 (0- 255) 
    DWORD dwRecycleRecord;         //cycle Record, 0: No cycle;  1: cycle
    //The variable below is read only
    BYTE sSerialNumber[SERIALNO_LEN];     //SN
    DWORD dwSoftwareVersion;             //software version, high 16 bits is main version,  low 16 bits is hypo- version
    DWORD dwSoftwareBuildDate;             //build date, 0xYYYYMMDD
    DWORD dwDSPSoftwareVersion;         //DSP software version,  high 16 bits is main version,  low 16 bits is hypo- version
    DWORD dwDSPSoftwareBuildDate;         // DSP software build date, 0xYYYYMMDD
    DWORD dwPanelVersion;                 // Front panel version,  high 16 bits is main version,  low 16 bits is hypo- version
    DWORD dwHardwareVersion;     //Hardware version,  high 16 bits is main version,  low 16 bits is hypo- version
    BYTE byAlarmInPortNum;         //Number of alarm input
    BYTE byAlarmOutPortNum;     //Number of alarm output
    BYTE byRS232Num;             //Number of DVR RS232 ports
    BYTE byRS485Num;             //Number of DVR RS485 ports
    BYTE byNetworkPortNum;         //Number of network ports
    BYTE byDiskCtrlNum;         //Number of DVR hardware controllers
    BYTE byDiskNum;             //DVR Hard disk number
    BYTE byDVRType;             //DVR Model,  1: DVR 2: ATM DVR 3: DVS ......
    BYTE byChanNum;             //DVR channel number
    BYTE byStartChan;             //First channel's No. e.g.,  DVS- 1, DVR -  1
    BYTE byDecordChans;         //Number of decoding channels
    BYTE byVGANum;                 //Number of VGA ports
    BYTE byUSBNum;                 //Number of USB ports
    BYTE byAuxoutNum;             //Number of AUX ports
    BYTE byAudioNum;             //Number of audio ports
    BYTE byIPChanNum;             //Maximum number of IP channels
}NET_DVR_DEVICECFG, *LPNET_DVR_DEVICECFG;

/*
Network structure  (9000)
*/
typedef struct
{
    NET_DVR_IPADDR    struDVRIP;               //DVR IP address
    NET_DVR_IPADDR    struDVRIPMask;             //DVR IP Mask
    DWORD    dwNetInterface;                    //Network port,  1- 10MBase- T, 2- 10MBase- T full duplex,  3- 100MBase- TX, 4- 100M full duplex,  5- 10M/100M adaptive
    WORD    wDVRPort;                         //Port
    WORD    wMTU;                             //MTU,  1500 by default
    BYTE    byMACAddr[MACADDR_LEN];         //MAC address
    BYTE    byEthernetPortNo;               //Ethernet port: 0 - invalid, 1 - port 0, 2- port 1 and so on,  (read-only)
    BYTE    byRes[1];
}NET_DVR_ETHERNET_V30, *LPNET_DVR_ETHERNET_V30;

/*
Network data structure (Sub structure)
*/
typedef struct
{
    char sDVRIP[16];              //DVR IP address
    char sDVRIPMask[16];          //DVR IP Mask
    DWORD dwNetInterface;         //Network interface: 1- 10MBase- T, 2- 10MBase- T full duplex, 3- 100MBase- TX, 4- 100M full duplex, 5- 10M/100M adaptive
    WORD wDVRPort;                   //Port
    BYTE byMACAddr[MACADDR_LEN];  //Mac address
}NET_DVR_ETHERNET;

//pppoe structure
typedef struct
{
    DWORD    dwPPPOE;                                         //0- disable, 1- enable
    BYTE    sPPPoEUser[NAME_LEN];                             //PPPoE user name
    char    sPPPoEPassword[PASSWD_LEN];                     //PPPoE password
    NET_DVR_IPADDR    struPPPoEIP;                             //PPPoE IP address
}NET_DVR_PPPOECFG, *LPNET_DVR_PPPOECFG;

//Network Configure Structure  (9000DVR extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_ETHERNET_V30    struEtherNet[MAX_ETHERNET];     //Network Port
    NET_DVR_IPADDR    struRes1[2];                             //Reserved
    NET_DVR_IPADDR    struAlarmHostIpAddr;                     //IP address of Alarm Host 
    BYTE    byRes2[4];                                         //Reserved 
    WORD    wAlarmHostIpPort;                                 //Port of Alarm Host 
    BYTE    byUseDhcp;                                      //Enable DHCP or not 0xff- invalid 0- disable 1- enable
    BYTE    byIPv6Mode;                                     //IPv6 allocation, 0 - route bulletin, 1 - manually set, 2 - Enable DHCP-assigned
    NET_DVR_IPADDR    struDnsServer1IpAddr;                     //IP address of DNS 1
    NET_DVR_IPADDR    struDnsServer2IpAddr;                     //IP address of DNS 2
    BYTE    byIpResolver[MAX_DOMAIN_NAME];                     //IP address or domain name of analysis server
    WORD    wIpResolverPort;                                 //Port of IP analysis server
    WORD    wHttpPortNo;                                     //HTTP port 
    NET_DVR_IPADDR    struMulticastIpAddr;                     //Multicast group address 
    NET_DVR_IPADDR    struGatewayIpAddr;                         //Gateway address 
    NET_DVR_PPPOECFG struPPPoE;
    BYTE    byEnablePrivateMulticastDiscovery;              //Private Multicast Discovery,0~Default,1~Enable,2-Disable
    BYTE    byEnableOnvifMulticastDiscovery;                //Onvif Multicast Discovery,0~Default,1~Enable,2-Disable
    BYTE    byEnableDNS; //DNS Atuo enable, 0-Res,1-open, 2-close
    BYTE    byRes[61];
} NET_DVR_NETCFG_V30, *LPNET_DVR_NETCFG_V30;

//Netcard Configure Structure
typedef struct
{
    NET_DVR_IPADDR struDVRIP;                  /*Network card IP address */
    NET_DVR_IPADDR struDVRIPMask;              /*Network card IP address mask*/
    DWORD dwNetInterface;                      /*Network port,  1- 10MBase- T 2- 10MBase- T full duplex  3- 100MBase- TX 4- 100M full duplex  5- 10M/100M adaptive*/
    BYTE byCardType;  //Network card type,0-Normal network card,1-internal network card ,2-external network card
    BYTE    byEnableDNS; //DNS Auto Enabled,0 - res, 1 - open, 2 - close
    WORD wMTU;                                  /*MTU,  1500 by default*/
    BYTE byMACAddr[MACADDR_LEN];              /*Mac address*/
    BYTE byEthernetPortNo;               //Ethernet port: 0 - invalid, 1 - port 0, 2- port 1 and so on,  (read-only)
    BYTE byRes2[1];                          /*Reserved*/
    BYTE byUseDhcp;                          /* Enable DHCP or not 0xff- invalid 0- disable 1- enable*/
    BYTE byRes3[3];                             /*Reserved*/
    NET_DVR_IPADDR struGatewayIpAddr;          /*Gateway address*/
    NET_DVR_IPADDR struDnsServer1IpAddr;      /*IP address of DNS 1*/
    NET_DVR_IPADDR struDnsServer2IpAddr;      /*IP address of DNS 2*/
}NET_DVR_ETHERNET_MULTI, *LPNET_DVR_ETHERNET_MULTI;

//Multi Netcard Configure Structure
typedef struct
{
    DWORD  dwSize;
    BYTE   byDefaultRoute;           /* Default route, 0:  struEtherNet[0], 1:  struEtherNet[1] */
    BYTE   byNetworkCardNum;         //Network card sum
    BYTE   byWorkMode;   //Work mode,0-normal multi network card mode,1-internal and external network isolation mode
    BYTE   byRes;
    NET_DVR_ETHERNET_MULTI struEtherNet[MAX_NETWORK_CARD];  /* Network Port*/
    NET_DVR_IPADDR         struManageHost1IpAddr;        /* Manage host 1 IP */
    NET_DVR_IPADDR         struManageHost2IpAddr;        /* Manage host 2 IP */
    NET_DVR_IPADDR           struAlarmHostIpAddr;          /* Alarm host IP 1 */
    WORD wManageHost1Port;      /* Manage host 1 port */
    WORD wManageHost2Port;      /* Manage host 2 port */
    WORD wAlarmHostIpPort;      /* Alarm host port */
    BYTE  byIpResolver[MAX_DOMAIN_NAME];      /* IP address or domain name of analysis serve */
    WORD wIpResolverPort;                    /* Port of IP analysis server */
    WORD wDvrPort;                            //DVR port ,  default 8000 
    WORD wHttpPortNo;                        /* HTTP port */
    WORD wDvrPort2; //DVR port 2
    BYTE byRes2[4];
    NET_DVR_IPADDR   struMulticastIpAddr;          /* Multicast group address */
    NET_DVR_PPPOECFG struPPPoE;
    BYTE byRes3[24];
}NET_DVR_NETCFG_MULTI, *LPNET_DVR_NETCFG_MULTI;

//Network Configure Structure
typedef struct
{
    DWORD dwSize;
    NET_DVR_ETHERNET struEtherNet[MAX_ETHERNET];         /* Network Port */
    char sManageHostIP[16];         //IP address of remote management host
    WORD wManageHostPort;         //Port of remote management Host
    char sIPServerIP[16];        //Address of IPServer
    char sMultiCastIP[16];      //Multicast group address
    char sGatewayIP[16];            //Gateway address
    char sNFSIP[16];             //IP address of NFS host
    BYTE sNFSDirectory[PATHNAME_LEN]; //NFS directory
    DWORD dwPPPOE;                 //0- disable, 1- enable
    BYTE sPPPoEUser[NAME_LEN];     //PPPoE username
    char sPPPoEPassword[PASSWD_LEN]; // PPPoE password
    char sPPPoEIP[16];             //PPPoE IP address  (read only) 
    WORD wHttpPort;                 //HTTP port
}NET_DVR_NETCFG, *LPNET_DVR_NETCFG;

//Network Configure Structure(V50)
typedef struct tagNET_DVR_NETCFG_V50
{
    DWORD dwSize;
    NET_DVR_ETHERNET_V30    struEtherNet[MAX_ETHERNET];        //Network Port
    NET_DVR_IPADDR    struRes1[2];                            /*reserve*/
    NET_DVR_IPADDR    struAlarmHostIpAddr;                    /* IP address of remote management host */
    BYTE    byRes2[4];                                        /* reserve */
    WORD    wAlarmHostIpPort;                                /* Port of remote management Host */
    BYTE    byUseDhcp;                                      /* Whether to enable the DHCP 0xff- invalid 0- enabled 1- not enabled */
    BYTE    byIPv6Mode;                                        //IPv6 allocation, 0- routing announcement, 1- manually, 2- enable DHCP allocation 
    NET_DVR_IPADDR    struDnsServer1IpAddr;                    /* IP address of the domain name server 1  */
    NET_DVR_IPADDR    struDnsServer2IpAddr;                    /* IP address of the domain name server 2  */
    BYTE    byIpResolver[MAX_DOMAIN_NAME];                    /* IP parse server domain name or IP address */
    WORD    wIpResolverPort;                                /* Parsing IP server port number */
    WORD    wHttpPortNo;                                    /* HTTP port number  */
    NET_DVR_IPADDR    struMulticastIpAddr;                    /* Multicast group address */
    NET_DVR_IPADDR    struGatewayIpAddr;                        /* Gateway address  */
    NET_DVR_PPPOECFG struPPPoE;
    BYTE    byEnablePrivateMulticastDiscovery;                //Private multicast search, 0- default, 1- enabled, 2 - disabled 
    BYTE    byEnableOnvifMulticastDiscovery;                //Onvif multicast search, 0- default, 1- enabled, 2 - disabled 
    WORD    wAlarmHost2IpPort;                                /* Alarm host 2 port */
    NET_DVR_IPADDR    struAlarmHost2IpAddr;                    /* Alarm host 2 IP addresses */
    BYTE    byEnableDNS; //DNS Enabled, 0-close,1-open 
    BYTE    byRes[599];
}NET_DVR_NETCFG_V50, *LPNET_DVR_NETCFG_V50;

//sip 
typedef struct tagNET_DVR_SIP_CFG
{
    DWORD dwSize;
    BYTE byEnableAutoLogin;    //Enable auto login,0-disable,1-enable
    BYTE byLoginStatus;  //login status,0-not login,1-logined
    BYTE byRes1[2];
    NET_DVR_IPADDR stuServerIP;  //SIP server IP
    WORD wServerPort;    //SIP server port
    BYTE byRes2[2];
    BYTE byUserName[NAME_LEN];  //user name
    BYTE byPassWord[PASSWD_LEN]; //user password
    BYTE byLocalNo[MAX_NUMBER_LEN];
    BYTE byDispalyName[MAX_NAME_LEN]; //device name
    WORD wLocalPort;     //local port
    BYTE byLoginCycle;   //login cycle,1-99min
    BYTE byType;//0-IP/IPV6,1-domain name
    BYTE byDomainName[MAX_DOMAIN_NAME]; //domain name
    BYTE byRes[64];
}NET_DVR_SIP_CFG, *LPNET_DVR_SIP_CFG;

typedef struct tagNET_DVR_SIP_CFG_V50
{
    DWORD dwSize;
    BYTE byEnableAutoLogin;    //Enable auto login,0-disable,1-enable
    BYTE byLoginStatus;   //login status,0-not login,1-logined
    BYTE byRes1[2];
    NET_DVR_IPADDR stuServerIP;  //SIP server IP
    WORD wServerPort;     //SIP server port
    BYTE byRes2[2];
    BYTE byUserName[NAME_LEN];  //user name
    BYTE byPassWord[PASSWD_LEN];//user password
    BYTE byLocalNo[MAX_NUMBER_LEN];
    BYTE byDispalyName[MAX_NAME_LEN];  //device name
    WORD wLocalPort;     //local port
    BYTE byLoginCycle;   //login cycle,1-99min
    BYTE byRes3;
    BYTE bySIPServerDomain[MAX_DOMAIN_NAME];  //sip server domain 
    NET_DVR_IPADDR stuSTUNServerIP;  // STUN server IP
    BYTE bySTUNServerDomain[MAX_DOMAIN_NAME];  //STUN server domain
    WORD wSTUNServerPort;    // STUN server port 
    BYTE byRes4[2];
    NET_DVR_IPADDR stuProxyServerIP;  //proxy server IP
    BYTE byProxyServerDomain[MAX_DOMAIN_NAME];  //proxy server domain
    WORD wProxyServerPort;    // proxy server port
    BYTE byRes[258];
}NET_DVR_SIP_CFG_V50, *LPNET_DVR_SIP_CFG_V50;

typedef struct tagNET_DVR_IP_VIEW_DEVCFG
{
    DWORD dwSize;
    BYTE  byDefaultRing; //default ring,[1-6]
    BYTE  byRingVolume;  //ring volume,[0-9]
    BYTE  byInputVolume; //input ring volume,[0-6]
    BYTE  byOutputVolume; //output ring volume[0-9]
    WORD  wRtpPort;  //Rtp port
    BYTE  byRes1[2];
    DWORD dwPreviewDelayTime; //preview delay time,0-30s
    BYTE  byRes2[64];
}NET_DVR_IP_VIEW_DEVCFG, *LPNET_DVR_IP_VIEW_DEVCFG;

typedef struct tagNET_DVR_IP_VIEW_AUDIO_CFG
{
    DWORD dwSize;
    BYTE  byAudioEncPri1; //audio encode priority1,0-G722,1-G711_U,2-G711_A, 5-MPEG2,6-G726,7-AAC
    BYTE  byAudioEncPri2; //audio encode priority2,0-G722,1-G711_U,2-G711_A, 5-MPEG2,6-G726,7-AAC
    WORD  wAudioPacketLen1; //audio encode packet len1
    WORD  wAudioPacketLen2; //audio encode packet len2
    BYTE  byRes[30];
}NET_DVR_IP_VIEW_AUDIO_CFG, *LPNET_DVR_IP_VIEW_AUDIO_CFG;

typedef struct tagNET_DVR_IP_VIEW_CALL_CFG
{
    DWORD dwSize;
    BYTE  byEnableAutoResponse; //enable auto-response,0-disable,1-enable
    BYTE  byAudoResponseTime; //auto-response time,0-30s
    BYTE  byRes1[2];
    BYTE  byEnableAlarmNumber1; //enable alarm number1,0-disable,1-enable
    BYTE  byRes2[3];
    BYTE  byAlarmNumber1[MAX_NUMBER_LEN]; //alarm number1
    BYTE  byEnableAlarmNumber2; //alarm number2,0-diable,1-enable
    BYTE  byRes3[3];
    BYTE  byAlarmNumber2[MAX_NUMBER_LEN]; //alarm number2
    BYTE  byRes4[72];
}NET_DVR_IP_VIEW_CALL_CFG, *LPNET_DVR_IP_VIEW_CALL_CFG;
//Channel Image structure

typedef struct
{
    DWORD     dwMaxRecordChanNum;
    DWORD     dwCurRecordChanNum;
    DWORD     dwRelRecordChan[MAX_CHANNUM_V30];
    BYTE       byRes[64];
} NET_DVR_RECORDCHAN, *LPNET_DVR_RECORDCHAN;

//Motion detection structure (sub structure)  (9000 extended) 
typedef struct
{
    BYTE byMotionScope[64][96];                                     /*Motion detection area, 0- 96 bits stand for 64 lines and there are 96*64 small areas,  1- - it is motion detection area, 0- - not*/
    BYTE byMotionSensitive;                                         /*sensitive grade of motion detection,  0 -  5 (5 is most sensitive) ,  oxff turn off*/
    BYTE byEnableHandleMotion;                                         /* Process motion alarm  0- No 1- Yes*/
    BYTE byEnableDisplay;    /*Display motion detect,0- No 1- Yes*/
    char reservedData;
    NET_DVR_HANDLEEXCEPTION_V30 struMotionHandleType;                 /* The way to process */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; /*Guard time*/
    BYTE byRelRecordChan[MAX_CHANNUM_V30];                             /* Channel triggered to record*/
}NET_DVR_MOTION_V30, *LPNET_DVR_MOTION_V30;

//Motion detection structure (sub structure) 
typedef struct
{
    BYTE byMotionScope[18][22];     /*motion detection area,  22*18 blocks in total,  1- - it's motion detection area,  0- - not*/
    BYTE byMotionSensitive;         /*sensitive grade of motion detection,  0 -  5 (5 is most sensitive) ,  oxff turn off*/
    BYTE byEnableHandleMotion;     /* process motion detection or not */
    BYTE byEnableDisplay;    /*Display motion detect,0- No 1- Yes*/
    char reservedData;
    NET_DVR_HANDLEEXCEPTION strMotionHandleType;     /* method to process alarm */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT]; //Guard time
    BYTE byRelRecordChan[MAX_CHANNUM];                 //Channel triggered to record*/
}NET_DVR_MOTION, *LPNET_DVR_MOTION;


typedef struct
{
    DWORD dwEnableHideAlarm;                 /* Enable tamper alarm or not , 0- disable, 1- low sensitivity 2- Middle 3- High*/
    WORD wHideAlarmAreaTopLeftX;             /* X- coordinate of tamper area */
    WORD wHideAlarmAreaTopLeftY;             /* Y- coordinate of tamper area */
    WORD wHideAlarmAreaWidth;                 /* Width of tampered area */
    WORD wHideAlarmAreaHeight;                 /* Height of tampered area*/

    DWORD   dwHandleType;           /* Way to handle the alarm */
    /*0x00:  No response*/
    /*0x01:  Alarm on monitor*/
    /*0x02:  Audio Alarm*/
    /*0x04:  Upload to center*/
    /*0x08:  Trigger alarm output*/
    /*0x10:  Grab JPEG image and EMail it*/
    /*0x20:  wireless voice and light alarm*/
    /*0x40:  Trigger electric map(only PCNVR supports)*/
    /*0x200: capture jpeg and update to FTP*/
    /*0x1000:capture jpeg and update to cloud*/
    DWORD   dwMaxRelAlarmOutChanNum;
    DWORD   dwRelAlarmOut[MAX_ALARMOUT_V40];
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; /*alarm Time*/
    BYTE  byRes[64];
}NET_DVR_HIDEALARM_V40, *LPNET_DVR_HIDEALARM_V40; //Tamper Alarm  

//Tamper Alarm  (sub structure)  (9000 extended)   area size:  704*576
typedef struct
{
    DWORD dwEnableHideAlarm;                 /* Enable tamper alarm or not , 0- disable, 1- low sensitivity 2- Middle 3- High*/
    WORD wHideAlarmAreaTopLeftX;             /* X- coordinate of tamper area */
    WORD wHideAlarmAreaTopLeftY;             /* Y- coordinate of tamper area */
    WORD wHideAlarmAreaWidth;                 /* Width of tampered area */
    WORD wHideAlarmAreaHeight;                 /* Height of tampered area*/
    NET_DVR_HANDLEEXCEPTION_V30 strHideAlarmHandleType;     /* Way to handle alarm */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; //Guard time
}NET_DVR_HIDEALARM_V30, *LPNET_DVR_HIDEALARM_V30;

//Tamper Alarm  (sub structure)  area size:  704*576
typedef struct
{
    DWORD dwEnableHideAlarm;                 /* Enable tamper alarm or not , 0- disable, 1- low sensitivity 2- Middle 3- High*/
    WORD wHideAlarmAreaTopLeftX;             /* X- coordinate of tamper area */
    WORD wHideAlarmAreaTopLeftY;             /* Y- coordinate of tamper area */
    WORD wHideAlarmAreaWidth;                 /* Width of tampered area */
    WORD wHideAlarmAreaHeight;                 /* Height of tampered area*/
    NET_DVR_HANDLEEXCEPTION strHideAlarmHandleType;     /* Way to handle the alarm */
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT]; //Guard time
}NET_DVR_HIDEALARM, *LPNET_DVR_HIDEALARM;

//Signal Lost Alarm (sub structure)  (9000 extended) 
typedef struct
{
    BYTE byEnableHandleVILost;     /* Respond the alarm or not */
    NET_DVR_HANDLEEXCEPTION_V30 strVILostHandleType;     /* Way to respond*/
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; //Guard time
}NET_DVR_VILOST_V30, *LPNET_DVR_VILOST_V30;

//Signal Lost Alarm (sub structure) 
typedef struct
{
    BYTE byEnableHandleVILost;     /* Respond the alarm or not */
    NET_DVR_HANDLEEXCEPTION strVILostHandleType;     /* Way to respond*/
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT]; //Guard time
}NET_DVR_VILOST, *LPNET_DVR_VILOST;

//Tampered Area (sub structure) 
typedef struct
{
    WORD wHideAreaTopLeftX;                 /* X- coordinate of tamper area */
    WORD wHideAreaTopLeftY;                 /* Y- coordinate of tamper area */
    WORD wHideAreaWidth;                 /* Width of tampered area */
    WORD wHideAreaHeight;                 /* Height of tampered area*/
}NET_DVR_SHELTER, *LPNET_DVR_SHELTER;

typedef struct
{
    BYTE byBrightness;       /*Brightness, 0- 255*/
    BYTE byContrast;         /*contrast, 0- 255*/
    BYTE bySaturation;       /*Saturation, 0- 255*/
    BYTE byHue;                 /*Hue, 0- 255*/
}NET_DVR_COLOR, *LPNET_DVR_COLOR;

typedef struct
{
    BYTE byRed;
    BYTE byGreen;
    BYTE byBlue;
    BYTE byRes;        //res
}NET_DVR_RGB_COLOR, *LPNET_DVR_RGB_COLOR;

//Point
typedef struct tagNET_VCA_POINT
{
    float fX;                                 //X axis coordinate,  0.001~1
    float fY;                                 //Y axis coordinate,  0.001~1
}NET_VCA_POINT, *LPNET_VCA_POINT;

//Video Structure (9000 extended) 
typedef struct
{
    DWORD dwSize;
    BYTE sChanName[NAME_LEN];
    DWORD dwVideoFormat;     /* Read only,  Video Standard 1- NTSC 2- PAL*/
    BYTE  byReservedData[64]; /*Reserved*/
    //Display Channel Name
    DWORD dwShowChanName;  // Display channel name or not, 0- no, 1- display size = 704*576
    WORD wShowNameTopLeftX;                 /* X- coordinate of display position */
    WORD wShowNameTopLeftY;                 /* Y- coordinate of display position  */
    //Signal lost Alarm
    NET_DVR_VILOST_V30 struVILost;
    NET_DVR_VILOST_V30 struRes;         /*Reserved*/
    //Motion detection
    NET_DVR_MOTION_V30 struMotion;
    //Tamper alarm
    NET_DVR_HIDEALARM_V30 struHideAlarm;
    //Tampered Area 704*576
    DWORD dwEnableHide;         /* Enable Tamper Alarm , 0- disable, 1- enable*/
    NET_DVR_SHELTER struShelter[MAX_SHELTERNUM];
    //OSD
    DWORD dwShowOsd;         // Display OSD or not, 0- No OSD, 1- Display Area for display:  704*576
    WORD wOSDTopLeftX;                 /* X- coordinate of OSD */
    WORD wOSDTopLeftY;                 /* Y- coordinate of OSD*/
    BYTE byOSDType;                     /* OSD Type  (format of Year/Month/Day)  */
    /* 0: XXXX- XX- XX Year Month Day */
    /* 1: XX- XX- XXXX Month Day Year */
    /* 2: XXXXYearXXNonthXXDay */
    /* 3: XXMonthXXDayXXXXYear */
    /* 4: XX- XX- XXXX Day Month Year*/
    /* 5: XXDayXXMonthXXXXYear */
    /* 6: xx/xx/xxxx(Month/Day/Year) */
    /* 7: xxxx/xx/xx(Year/Month/Day) */
    /* 8: xx/xx/xxxx(Day/Month/Year)*/
    BYTE byDispWeek;                 /* display Week */
    BYTE byOSDAttrib;                 /* OSD attribute:  Transparent, Flash */
    /* 1:  Transparent, Flash */
    /* 2:  Transparent, not Flash */
    /* 3:  Flash, not Transparent */
    /* 4:  not Transparent,  not Flash */
    BYTE byHourOSDType;                 /* : 24- Hour system, 12- Hour system */
    BYTE byFontSize;
    BYTE byOSDColorType;    //0-OSD Color type(black or white);1-custom
    BYTE byAlignment;//0- adaptive, 1- right aligned 2- left aligned, 3 - gb model, 4-all right aligned, 5-all left aligned
    BYTE byOSDMilliSecondEnable;//OSD MilliSecond Enable
    NET_DVR_RGB_COLOR    struOsdColor;//OSD color
    DWORD dwBoundary; //boundary value
    NET_DVR_RGB_COLOR struOsdBkColor;
    BYTE byOSDBkColorMode;
    BYTE    byUpDownBoundary;//minimum characters of up-down boundary,character range[0,1,2],unused in global(byAlignment) mode
    BYTE    byLeftRightBoundary;//minimum characters of left-right boundary,character range[0,1,2],unused in global(byAlignment) mode
    BYTE byRes[45];
}NET_DVR_PICCFG_V30, *LPNET_DVR_PICCFG_V30;

//Video Structure (SDK_V14 extended) 
typedef struct
{
    DWORD dwSize;
    BYTE sChanName[NAME_LEN];
    DWORD dwVideoFormat;     /* Read only,  Video Standard 1- NTSC 2- PAL*/
    BYTE byBrightness;      /*0-255*/
    BYTE byContrast;        /*0-255*/
    BYTE bySaturation;      /*0-255 */
    BYTE byHue;                /*0-255*/
    //Display Channel Name
    DWORD dwShowChanName;  // Display channel name or not, 0- no, 1- display size = 704*576
    WORD wShowNameTopLeftX;                 /* X- coordinate of display position */
    WORD wShowNameTopLeftY;                 /* Y- coordinate of display position  */
    //Signal lost Alarm
    NET_DVR_VILOST struVILost;
    //Motion Detection
    NET_DVR_MOTION struMotion;
    //Tamper Alarm
    NET_DVR_HIDEALARM struHideAlarm;
    //Tamper Area size:  704*576
    DWORD dwEnableHide;         /* Enable Tamper Alarm , 0- disable, 1- enable**/
    NET_DVR_SHELTER struShelter[MAX_SHELTERNUM];
    //OSD
    DWORD dwShowOsd;                 // Display OSD or not, 0- No OSD, 1- Display Area for display:  704*576
    WORD wOSDTopLeftX;                 /* X- coordinate of OSD */
    WORD wOSDTopLeftY;                 /* Y- coordinate of OSD*/
    BYTE byOSDType;                     /* OSD Type  (format of Year/Month/Day)  */
    /* 0:  XXXX- XX- XX Year/Month/Day */
    /* 1:  XX- XX- XXXX Month/Day/Year */
    /* 2:  XXXXYearXXNonthXXDay */
    /* 3:  XXMonthXXDayXXXXYear */
    /* 4:  XX- XX- XXXX Day Month Year*/
    /* 5:  XXDayXXMonthXXXXYear */
    /*6: xx/xx/xxxx(Month/Day/Year) */
    /*7: xxxx/xx/xx(Year/Month/Day) */
    /*8: xx/xx/xxxx(Day/Month/Year)*/
    BYTE byDispWeek;                 /* display Week */
    BYTE byOSDAttrib;                 /* OSD attribute:  Transparent, Flash */
    /* 1:  Transparent, Flash */
    /* 2:  Transparent, not Flash */
    /* 3:  Flash, not Transparent */
    /* 4:  not Transparent,  not Flash */
    BYTE byHourOsdType;     //hour: 0- 24 hours, 1- am/pm
}NET_DVR_PICCFG_EX, *LPNET_DVR_PICCFG_EX;

//Video Structure (SDK_V14 extended) 
typedef struct
{
    DWORD dwSize;
    BYTE sChanName[NAME_LEN];
    DWORD dwVideoFormat;     /* Read only,  Video Standard 1- NTSC 2- PAL*/
    BYTE byBrightness;      /*0-255*/
    BYTE byContrast;        /*0-255*/
    BYTE bySaturation;      /*0-255 */
    BYTE byHue;                /*0-255*/
    //Display Channel Name
    DWORD dwShowChanName;  // Display channel name or not, 0- no, 1- display size = 704*576
    WORD wShowNameTopLeftX;                 /* X- coordinate of display position */
    WORD wShowNameTopLeftY;                 /* Y- coordinate of display position  */
    //Signal lost Alarm
    NET_DVR_VILOST struVILost;
    //Motion Detection
    NET_DVR_MOTION struMotion;
    //Tamper Alarm
    NET_DVR_HIDEALARM struHideAlarm;
    //Tamper Area size:  704*576
    DWORD dwEnableHide;         /* Enable Tamper Alarm , 0- disable, 1- enable*/
    WORD wHideAreaTopLeftX;                 /* X- coordinate of tampered area*/
    WORD wHideAreaTopLeftY;                 /* Y- coordinate of tampered area */
    WORD wHideAreaWidth;                 /* Width of tampered area */
    WORD wHideAreaHeight;                 /* Height of tampered area */
    //OSD
    DWORD dwShowOsd;                 // Display OSD or not, 0- No OSD, 1- Display Area for display:  704*576
    WORD wOSDTopLeftX;                 /* X- coordinate of OSD */
    WORD wOSDTopLeftY;                 /* Y- coordinate of OSD*/
    BYTE byOSDType;                     /* OSD Type  (format of Year/Month/Day)  */
    /* 0:  XXXX- XX- XX Year/Month/Day */
    /* 1:  XX- XX- XXXX Month/Day/Year */
    /* 2:  XXXXYearXXNonthXXDay */
    /* 3:  XXMonthXXDayXXXXYear */
    /* 4:  XX- XX- XXXX Day Month Year*/
    /* 5:  XXDayXXMonthXXXXYear */
    /*6: xx/xx/xxxx(Month/Day/Year) */
    /*7: xxxx/xx/xx(Year/Month/Day) */
    /*8: xx/xx/xxxx(Day/Month/Year)*/
    BYTE byDispWeek;                 /* display Week */
    BYTE byOSDAttrib;                 /* OSD attribute:  Transparent, Flash */
    /* 1:  Transparent, Flash */
    /* 2:  Transparent, not Flash */
    /* 3:  Flash, not Transparent */
    /* 4:  not Transparent,  not Flash */
    char reservedData2;
}NET_DVR_PICCFG, *LPNET_DVR_PICCFG;

typedef enum _BITRATE_ENCODE_INDEX_
{
    BITRATE_ENCODE_def = 0,
    BITRATE_ENCODE_8kps = 1,
    BITRATE_ENCODE_16kps = 2,
    BITRATE_ENCODE_32kps = 3,
    BITRATE_ENCODE_64kps = 4,
    BITRATE_ENCODE_128kps = 5,
    BITRATE_ENCODE_192kps = 6,
    BITRATE_ENCODE_40kps = 7,
    BITRATE_ENCODE_48kps = 8,
    BITRATE_ENCODE_56kps = 9,
    BITRATE_ENCODE_80kps = 10,
    BITRATE_ENCODE_96kps = 11,
    BITRATE_ENCODE_112kps = 12,
    BITRATE_ENCODE_144kps = 13,
    BITRATE_ENCODE_160kps = 14,
    BITRATE_ENCODE_224kps = 15,
    BITRATE_ENCODE_256kps = 16,
    BITRATE_ENCODE_320kps = 17
}BITRATE_ENCODE_INDEX;

//Encoding Parameters (Sub Strut)  (9000 extended) 
typedef struct
{
    BYTE byStreamType;         //Stream type 0- video,  1- video&audio,  when it stands for compression parameters,  the highest bit stands for whether adopt encoding parameters
    /*Resolution 0-DCIF                 1-CIF,                     2-QCIF,                 3-4CIF,
            4-2CIF                                                 6-QVGA(320*240),        7-QQVGA(160*120),
            12-384*288                  13-576*576,
            16-VGA(640*480),          17-UXGA(1600*1200),      18-SVGA(800*600),       19-HD720p(1280*720),
            20-XVGA,                    21-HD900p,                 22-1360*1024,           23-1536*1536,
            24-1920*1920,               27-HD1080i,
            28-2560*1920,               29-1600*304,               30-2048*1536,           31-2448*2048,
            32-2448*1200,               33-2448*800,               34-XGA(1024*768),    35-SXGA(1280*1024),
            36-WD1(960*576/960*480),    37-1080i,                  38-WSXGA(1440*900),     39-HD_F(1920*1080/1280*720),
            40-HD_H(1920*540/1280*360), 41-HD_Q(960*540/630*360),  42-2336*1744,           43-1920*1456,
            44-2592*2048,               45-3296*2472,              46-1376*768,            47-1366*768,
            48-1360*768,                49-WSXGA+,                 50-720*720,             51-1280*1280,
            52-2048*768,                53-2048*2048,              54-2560*2048,           55-3072*2048,
            56-2304*1296                57-WXGA(1280*800),         58-1600*600,            59-1600*900,
            60-2752*2208,                61-retain,                 62-4000*3000,           63-4096*2160,
            64-3840*2160,                65-4000*2250,              66-3072*1728,           67-2592*1944,
            68-2464*1520,               69-1280*1920,              70-2560*1440,           71-1024*1024,
            72-160*128,                 73-324*240,                74-324*256,             75-336*256,
            76-640*512,                 77-2720*2048,              78-384*256,             79-384*216,
            80-320*256,                 81-320*180,                82-320*192,             83-512*384,
            84-325*256,                 85-256*192,                86-640*360,               87-1776x1340,
            88-1936x1092,                89-2080x784,               90-2144x604,            91-1920*1200,
            92-4064*3040,               93-3040*3040,              94-3072*2304,           95-3072*1152,
            96-2560*2560,               97-2688*1536,              98-2688*1520,           99-3072*3072,
            100-3392*2008,,             101-4000*3080,             102-960*720,            103-1024*1536,
            104-704*1056,               105-352*528,               106-2048*1530,          107-2560*1600,
            108-2800*2100,              109-4088*4088,             110-4000*3072           111-960*1080(1080p Lite)
            112-640*720(half 720p),     113-640*960,               114-320*480,             115-3840*2400,
            116-3840*1680,              117-2560*1120,             118-704*320,             119-1200*1920,
            120-480*768,                121-768*480,               122-320*512,             123-512*320,
            124-4096*1800,              125-1280*560,              126-2400*3840,          127-480*272,
            128-512*272,                129-2592*2592,             130-1792*2880,          131-1600*2560,
            132-2720*1192,              133-3MP(1920*1536/2048*1536),                     134-5MP(2560*1944),
            135-2560*960,               136-2064*1544              137-4096*1200,
            138-3840*1080               139-2720*800               140-512*232             141-704*200,
            142-512*152,                143-2048*896               144-2048*600            145-1280*376,
            146-2592*1520,              147-2592*1536,             148-3072*8192,          149-768*2048,
            150-8208*3072,              151-4096*1536,             152-6912*2800,          153-3456*1400
            154-480*720,                155-800*450,               156-480*270,            157-2560*1536,
            160-3264*2448,              161-288*320,               162-144*176,            163-480*640,
            164-240*320,                165-120*160,               166-576*720,            167-720*1280,
            168-576*960,                169-2944*1656,             170-432*240,            171-2160*3840,
            172-1080*1920,              173-7008*1080,             174-3504*540,           175-1752*270,
            176-876*135,                177-4096*1440,             178-4096*1080,          179-1536*864,
            180-180*240,                181-360*480,               182-540*720,            183-720*960,
            184-960*1280,               185-1080*1440,
            186-3200*1800,              187-1752*272,              188-872*136,            189-1280*1440,
            190-3520*544,               191-1728*256,              192-864*128,            193-5470*3684,
            194-2560*750,               195-1600*480,              196-1024*300,           197-848*480,
            198-8160*3616,				199-8160*2304,             200-4064*2560,          201-1400*1050,
            202-2688*1512,              203-704*288,               204-1560*656,           205-3072*1280,
            206-4320*1808,              207-6120*2560,              208-1280*960,          209-3000*3000,
            210-2032*3616,              211-7680*4320,             212-5760*3240,          213-3264*1836,
            214-2712*1536,              215-1080*720(occupied untested), 216-360x640(occupied untested),
            217-1440*812,               218-8160*2416,              219-5760*1712,          220-4080*1200,          
            221-6144*2560,              222-1568*656,               223-4096*1808,          224-2720*1200,
            225-2896*848,               226-2048*608,               227-3840*1120,          228-2720*784,
            229-1920*560,               230-1360*400,               231-704*208,            232-496*144,
            233-352*128,                234-512*240,                235-512*160,            236-368*128,
            237-256*128,                 238-2048*592,               239-1456*416,           240-1024*304,
            241-1280*368,               242-912*256,                243-640*192,            244-252*112(not use),
            245-576*704[P]/480*704[N]   246-5760*1696               247-8160*2400                248-5520*2400
            249-2784*800                250-1968*848                251-1392*608                 252-2736*1184
            253-1920*848                254-5520*1600
            0xff-Auto(use current resolution)
            256-3888*1696                257-2784*1200               258-496*224              259-352*160
            260-912*400                  261-640*288                 262-1456*640             263-1024*448
            264-2896*1280                265-2544*1088               266-2736*768             267-1920*544
            268-3840*1696                269-2880*848                270-5424*2400            271-5760*1696
            272-848*384                  273-912*272                 274-1360*608             275-1456*432
            276-2736*1200
            */
    BYTE byResolution;
    BYTE byBitrateType;         //Bitrate Type 0: VBR, 1: CBR
    BYTE byPicQuality;         //Image Quality 0- best 1- much better 2- better 3- Normal 4- worse 5- worst
    /*video bit rate 0- reserved 1- 16K 2- 32K 3- 48k 4- 64K 5- 80K 6- 96K 7- 128K 8- 160k 9- 192K 10- 224K 11- 256K 12- 320K
    13-384K 14-448K 15-512K 16-640K 17-768K 18-896K 19-1024K 20-1280K 21-1536K 22-1792K 23-2048K  24-3072K 25-4096K 26-8192K 27-16384K
    if The highest bit (31 bit)  is 1,  it stands for user defined bit rate,  0- 30 is the value of bit rate*/
    DWORD dwVideoBitrate;
    DWORD dwVideoFrameRate; //Frame rate 0- full;  1- 1/16;  2- 1/8;  3- 1/4;  4- 1/2;  5- 1;  6- 2;  7- 4;  8- 6;  9- 8;  10- 10;  11- 12;  12- 16;  13- 20; 14- 15;  15- 18;  16- 22; 
    //17-25;18-30;19-35;20-40;21-45;22-50;23-55;24-60,25-3;26-5;27-7;28-9;29-100; 30-120;31-24;32-48,33-8.3,0xfffffffe-auto
    WORD  wIntervalFrameI;  //interval of I frame
    BYTE  byIntervalBPFrame;//0- BBP frame;  1- BP frame;  2- P frame only(2006-08-11 Add single P frame).
    BYTE  byres1;           //reserve
    BYTE  byVideoEncType;   //Video Code Type:  0-private h264,1-standard H264,2-standard MPEG4,7-M-JPEG,8-MPEG2,9-SVAC, 10-Standard h265, 0xfe- auto,0xff-invalid 
    BYTE  byAudioEncType;   //Audio Code Type:  0- G722; 1- G711_U; 2- G711_A;5-MP2L2;6-G726;7-AAC,8-PCM;12-AAC_LC;13-AAC_LD;14-Opus;15-MP3;
    BYTE  byVideoEncComplexity; //Video encode complexity, 0-low,1-middle,2-high
    BYTE  byEnableSvc; //0 - do not enable the SVC function; 1 - enable SVC function; 2-Auto SVC
    BYTE  byFormatType; //video format type,1-original,2-RTP,3-PS,4-TS,5-private,6-FLV,7-ASF,8-3GP,9-RTP+PS(GB28181),0xff-Invalid
    BYTE  byAudioBitRate; // audioBitRate refer to BITRATE_ENCODE_INDEX
    BYTE  byStreamSmooth;    //stream smoothing 1~100(1-(Clear),..., 100-(Smooth))
    BYTE  byAudioSamplingRate;//AudioSamplingRate 0-default,1-16kHZ, 2-32kHZ,3-48kHZ, 4- 44.1kHZ,5-8kHZ
    BYTE  bySmartCodec;//bit0:High performance code: 0-Close,1-Open;bit1 Low Bit Rate:0-Close,1-Open
    BYTE  byDepthMapEnable;// Depth Map Enable,0-Close,1-Open
    WORD  wAverageVideoBitrate;// Average Video Bitrate
}NET_DVR_COMPRESSION_INFO_V30, *LPNET_DVR_COMPRESSION_INFO_V30;

//Encoding Parameters  (9000 extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO_V30 struNormHighRecordPara;     //Record,  corresponding to 8000's normal
    NET_DVR_COMPRESSION_INFO_V30 struRes;                     //Reserved char reserveData[28]; 
    NET_DVR_COMPRESSION_INFO_V30 struEventRecordPara;        //Encoding parameters triggered by Events
    NET_DVR_COMPRESSION_INFO_V30 struNetPara;                //network transfer
}NET_DVR_COMPRESSIONCFG_V30, *LPNET_DVR_COMPRESSIONCFG_V30;

//Encoding Parameters (Sub Strut) 
typedef struct
{
    BYTE byStreamType;         //Stream type 0- video,  1- video&audio,  when it stands for compression parameters,  the hightest bit stands for whether adopt encoding parameters
    BYTE byResolution;       //Resolution 0- DCIF 1- CIF,  2- QCIF,  3- 4CIF,  4- 2CIF,  5- 2QCIF (352X144)  (for Mobile DVR) 
    BYTE byBitrateType;         //Bit rate type 0: VBR, 1: CBR, 2:LBR
    BYTE  byPicQuality;         //Image Quality 0- best 1- much better 2- better 3- Normal 4- worse 5- worst
    DWORD dwVideoBitrate;      //video bit rate 0- reserved 1- 16K (reserved)  2- 32K 3- 48k 4- 64K 5- 80K 6- 96K 7- 128K 8- 160k 9- 192K 10- 224K 11- 256K 12- 320K
    // 13- 384K 14- 448K 15- 512K 16- 640K 17- 768K 18- 896K 19- 1024K 20- 1280K 21- 1536K 22- 1792K 23- 2048K
    //if The highest bit (31 bit)  is 1,  it stands for user defined bit rate,  0- 30 is the value of bit rate (MIN- 32K) 
    DWORD dwVideoFrameRate;     //Frame rate 0- full;  1- 1/16;  2- 1/8;  3- 1/4;  4- 1/2;  5- 1;  6- 2;  7- 4;  8- 6;  9- 8;  10- 10;  11- 12;  12- 16;  13- 20; 
}NET_DVR_COMPRESSION_INFO, *LPNET_DVR_COMPRESSION_INFO;

//Encoding Parameters
typedef struct
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO struRecordPara;  //Record triggered by events
    NET_DVR_COMPRESSION_INFO struNetPara;     //Network transfer (reserved) 
}NET_DVR_COMPRESSIONCFG, *LPNET_DVR_COMPRESSIONCFG;

//Encoding Parameters (Sub Strut)  (extended)  Add I Frame interval
typedef struct
{
    BYTE byStreamType;         //Stream type 0- video,  1- video&audio, 
    BYTE byResolution;          //Resolution 0- DCIF 1- CIF,  2- QCIF,  3- 4CIF,  4- 2CIF,  5- 2QCIF (352X144)  (for Mobile DVR) 
    BYTE byBitrateType;         //Bit rate type 0: VBR, 1: CBR, 2:LBR
    BYTE  byPicQuality;         //Image Quality 0- best 1- much better 2- better 3- Normal 4- worse 5- worst
    DWORD dwVideoBitrate;      //video bit rate 0- reserved 1- 16K (reserved)  2- 32K 3- 48k 4- 64K 5- 80K 6- 96K 7- 128K 8- 160k 9- 192K 10- 224K 11- 256K 12- 320K
    // 13- 384K 14- 448K 15- 512K 16- 640K 17- 768K 18- 896K 19- 1024K 20- 1280K 21- 1536K 22- 1792K 23- 2048K
    //if The highest bit (31 bit)  is 1,  it stands for user defined bit rate,  0- 30 is the value of bit rate (MIN- 32K MAX- 8192K) 
    DWORD dwVideoFrameRate;     //Frame rate 0- full;  1- 1/16;  2- 1/8;  3- 1/4;  4- 1/2;  5- 1;  6- 2;  7- 4;  8- 6;  9- 8;  10- 10;  11- 12;  12- 16;  13- 20, 14- 15,  15- 18,  16- 22; 
    WORD  wIntervalFrameI;   //I Frame interval
    //2006- 08- 11 Add single P frame
    BYTE  byIntervalBPFrame; //0- BBP frame;  1- BP frame;  2- P frame only.
    BYTE  byRes;
}NET_DVR_COMPRESSION_INFO_EX, *LPNET_DVR_COMPRESSION_INFO_EX;

//Encoding Parameters  (extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO_EX struRecordPara;  //Record
    NET_DVR_COMPRESSION_INFO_EX struNetPara;     //Network Transfer
}NET_DVR_COMPRESSIONCFG_EX, *LPNET_DVR_COMPRESSIONCFG_EX;


//Parameters Configure of Recording in Time segment  (Sub Strut) 
typedef struct
{
    NET_DVR_SCHEDTIME struRecordTime;
    BYTE byRecordType;     //0: Time Record, 1: Motion detection, 2: Alarm record, 3: Motion|alarm, 4: Motion&Alarm,  5: Triggered by Commands,  6:  Intelligent Record,10-PIR,11-wireless,12-callhelp,13-all,14-Intelligent Transportation,15-NULL,16-Field dection,17-audio Exception
    char reservedData[3];
}NET_DVR_RECORDSCHED, *LPNET_DVR_RECORDSCHED;

//Record All- day 
typedef struct
{
    WORD wAllDayRecord;                 /* Enable record all- day or not; 0- disable, 1- enable*/
    BYTE byRecordType;                 //0: Time Record, 1: Motion detection, 2: Alarm record, 3: Motion|alarm, 4: Motion&Alarm,  5: Triggered by Commands,  6:  Intelligent Record,10-PIR,11-wireless,12-callhelp,13-motion|alarm|PIR|wireless|callhelp,14-Intelligent Transportation, 20-face detection
    char reservedData;
}NET_DVR_RECORDDAY, *LPNET_DVR_RECORDDAY;

//Recording Parameters  (9000 extended) 
typedef struct
{
    DWORD    dwSize;
    DWORD    dwRecord;                           /*Record or not 0- not 1- Record*/
    NET_DVR_RECORDDAY    struRecAllDay[MAX_DAYS];
    NET_DVR_RECORDSCHED    struRecordSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
    DWORD    dwRecordTime;                     /* post record time  0- 5Seconds,  1- 10Seconds,  2- 30Seconds,  3- 1 Minutes,  4- 2Minutes, ,  5- 5Minutes, ,  6- 10Minutes, */
    DWORD    dwPreRecordTime;                 /* Pre- record time 0- disable 1- 5Seconds 2- 10Seconds 3- 15Seconds 4- 20Seconds 5- 25Seconds 6- 30Seconds 7- 0xffffffff */
    DWORD    dwRecorderDuration;                 /*  */
    BYTE    byRedundancyRec;                  /*Redundancy record to backup important data: 0/1*/
    BYTE    byAudioRec;                         /*Record audio or not*/
    BYTE    byStreamType;                    /* 0-main stream,1-sub stream,2-main&sub 3-stream3*/
    BYTE    byPassbackRecord;
    WORD    wLockDuration;
    BYTE    byRecordBackup;
    BYTE     bySVCLevel;    //SVC frame type:0-no frame,1-half frame 2-three fourths frame
    BYTE    byRecordManage;   //record manage 0-enable, 1-disable
    BYTE    byExtraSaveAudio;
    BYTE   byIntelligentRecord; //open smart record 0-no 1-yes
    BYTE    byReserve;
}NET_DVR_RECORD_V30, *LPNET_DVR_RECORD_V30;


//Parameters Configure of Recording in Time segment  (Sub Strut) 
typedef struct
{
    NET_DVR_SCHEDTIME  struRecordTime;
    //0: Time Record, 1: Motion detection, 2: Alarm record, 3: Motion|alarm, 4: Motion&Alarm,  5: Triggered by Commands,
    //6: Intelligent Record,10: PIR, 11: wireless,12: callhelp, 13: Event all, 
    //14: Intelligent Transportation, 15: NULL, 16: Field dection, 17: audio Exception
    //18: Sence Exception Detection, 
    //19: Smart Detection(Traverse Plane Dection|Field Dection|audio Exception Dection|Sence Exception Detection|Face detection), 
    //20: face detection
    BYTE byRecordType;
    BYTE byRes[31];
}NET_DVR_RECORDSCHED_V40, *LPNET_DVR_RECORDSCHED_V40;

//Record All- day
typedef struct
{
    BYTE byAllDayRecord;/* Enable record all- day or not; 0- disable, 1- enable*/
    //0: Time Record, 1: Motion detection, 2: Alarm record, 3: Motion|alarm, 4: Motion&Alarm,  5: Triggered by Commands,
    //6: Intelligent Record,10: PIR, 11: wireless,12: callhelp, 13: Event all, 
    //14: Intelligent Transportation, 15: NULL, 16: Field dection, 17: audio Exception
    //18: Sence Exception Detection, 
    //19: Smart Detection(Traverse Plane Dection|Field Dection|audio Exception Dection|Sence Exception Detection|Face detection), 
    //20: face detection
    BYTE byRecordType;
    BYTE byRes[62];
}NET_DVR_RECORDDAY_V40, *LPNET_DVR_RECORDDAY_V40;

typedef struct
{
    DWORD    dwSize;
    DWORD    dwRecord;                           /*Record or not 0- not 1- Record*/
    NET_DVR_RECORDDAY_V40    struRecAllDay[MAX_DAYS];
    NET_DVR_RECORDSCHED_V40    struRecordSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
    DWORD    dwRecordTime;                     /* post record time  0- 5Seconds,  1- 10Seconds,  2- 30Seconds,  3- 1 Minutes,  4- 2Minutes, ,  5- 5Minutes, ,  6- 10Minutes, */
    DWORD    dwPreRecordTime;                 /* Pre- record time 0- disable 1- 5Seconds 2- 10Seconds 3- 15Seconds 4- 20Seconds 5- 25Seconds 6- 30Seconds 7- 0xffffffff */
    DWORD    dwRecorderDuration;                 /*  */
    BYTE    byRedundancyRec;                  /*Redundancy record to backup important data: 0/1*/
    BYTE    byAudioRec;                         /*Record audio or not*/
    BYTE    byStreamType;                    /* 0-main stream,1-sub stream,2-main&sub,3-stream3*/
    BYTE    byPassbackRecord;
    WORD    wLockDuration;
    BYTE    byRecordBackup;
    BYTE     bySVCLevel;    //SVC frame type:0-no frame,1-half frame 2-three fourths frame
    BYTE    byRecordManage;
    BYTE    byExtraSaveAudio;
    BYTE   byIntelligentRecord; //open smart record 0-no 1-yes
    BYTE    byRes[125];
}NET_DVR_RECORD_V40, *LPNET_DVR_RECORD_V40;

//Recording Parameters
typedef struct
{
    DWORD dwSize;
    DWORD dwRecord;       /*Record or not 0- not 1- Record*/
    NET_DVR_RECORDDAY struRecAllDay[MAX_DAYS];
    NET_DVR_RECORDSCHED struRecordSched[MAX_DAYS][MAX_TIMESEGMENT];
    DWORD dwRecordTime;         /* Pre- record time*/
    DWORD dwPreRecordTime;     /* Pre- record time 0- disable 1- 5Seconds 2- 10Seconds 3- 15Seconds 4- 20Seconds 5- 25Seconds 6- 30Seconds 7- 0xffffffff  (A.F.A.P) */
}NET_DVR_RECORD, *LPNET_DVR_RECORD;

//PTZ protocol structure configuration
typedef struct
{
    DWORD dwType;                /*Type value of decoder,  increase from 1 by degrees*/
    BYTE  byDescribe[DESC_LEN];  /*Description of decoder,  same with 8000*/
}NET_DVR_PTZ_PROTOCOL;

typedef struct
{
    DWORD   dwSize;
    NET_DVR_PTZ_PROTOCOL struPtz[PTZ_PROTOCOL_NUM]; /*200 PTZ protocols in total*/
    DWORD   dwPtzNum;            /*Number of valid PTZ protocol, Start from 0*/
    BYTE    byRes[8];
}NET_DVR_PTZCFG, *LPNET_DVR_PTZCFG;

typedef struct tagNET_DVR_SERIALSTART_V40
{
    DWORD  dwSize;
    DWORD  dwSerialType;
    BYTE   bySerialNum;
    BYTE   byRes[255];
}NET_DVR_SERIALSTART_V40, *LPNET_DVR_SERIALSTART_V40;


typedef struct tagNET_DVR_DECODERCFG_V40
{
    DWORD    dwSize;
    DWORD     dwBaudRate;
    BYTE     byDataBit;
    BYTE     byStopBit;
    BYTE     byParity;
    BYTE     byFlowcontrol;
    WORD     wDecoderType;
    WORD     wDecoderAddress;
    BYTE     bySetPreset[MAX_PRESET_V30];
    BYTE     bySetCruise[MAX_CRUISE_V30];
    BYTE     bySetTrack[MAX_TRACK_V30];
    BYTE     bySerialNO;
    BYTE     byWorkMode;
    BYTE     byRes[254];
}NET_DVR_DECODERCFG_V40, *LPNET_DVR_DECODERCFG_V40;

typedef	struct tagNET_DVR_THERMOMETRYRULE_TEMPERATURE_INFO
{
    float fMaxTemperature;
    float fMinTemperature;
    float fAverageTemperature;
    NET_VCA_POINT struHighestPoint; 
    NET_VCA_POINT struLowestPoint; 
    BYTE  byIsFreezedata;
    BYTE  byRes[15];
}NET_DVR_THERMOMETRYRULE_TEMPERATURE_INFO, *LPNET_DVR_THERMOMETRYRULE_TEMPERATURE_INFO;

#define IPC_PROTOCOL_NUM      50   //max number of IP camera protocol

//PTZ protocol structure configuration
typedef struct tagNET_DVR_PROTO_TYPE
{
    DWORD dwType;                /*Type value of IP camera protocol,  increase from 0 by degrees*/
    BYTE  byDescribe[DESC_LEN];  /*Description of IP camera protocol,  same with 8000*/
}NET_DVR_PROTO_TYPE, *LPNET_DVR_PROTO_TYPE;

typedef struct
{
    DWORD   dwSize;
    DWORD   dwProtoNum;            /*Number of valid PTZ protocol, Start from 0*/
    NET_DVR_PROTO_TYPE struProto[IPC_PROTOCOL_NUM]; /*200 PTZ protocols in total*/
    BYTE    byRes[8];
}NET_DVR_IPC_PROTO_LIST, *LPNET_DVR_IPC_PROTO_LIST;

//PTZ protocol V41
typedef struct tagNET_DVR_IPC_PROTO_LIST_V41
{
    DWORD   dwSize;
    DWORD   dwProtoNum;  /*Number of valid PTZ protocol, Start from 0*/
    BYTE    *pBuffer;    //protocol buffer , there are dwProtoNum INTER_PROTO_TYPE structure   
    DWORD   dwBufferLen; //bufffer length
    BYTE    byRes[32];
}NET_DVR_IPC_PROTO_LIST_V41, *LPNET_DVR_IPC_PROTO_LIST_V41;

/***************************PTZ Protocol (end) ******************************/

//PTZ configuration  (9000 extended) 
typedef struct
{
    DWORD dwSize;
    DWORD dwBaudRate;   //Baud rate (bps) , 0- 50, 1- 75, 2- 110, 3- 150, 4- 300, 5- 600, 6- 1200, 7- 2400, 8- 4800, 9- 9600, 10- 19200,  11- 38400, 12- 57600, 13- 76800, 14- 115.2k; 
    BYTE byDataBit;     //Data bit 0- 5Seconds, 1- 6bit, 2- 7bit, 3- 8bit; 
    BYTE byStopBit;     //Stop bit 0- 1bit, 1- 2bit; 
    BYTE byParity;      //Parity 0- No parity, 1- odd, 2- even; 
    BYTE byFlowcontrol; //Flow control:  0- None, 1- software , 2- Hardware
    WORD wDecoderType;  //Decoder Type,  corresponding to PTZ list
    WORD wDecoderAddress;               //Decoder address: 0 -  255
    BYTE bySetPreset[MAX_PRESET_V30]; //Configure Preset or not, 0- No, 1- Yes
    BYTE bySetCruise[MAX_CRUISE_V30]; //Configure Cruise or not:  0- No, 1- Yes 
    BYTE bySetTrack[MAX_TRACK_V30];   //Configure Track or not, 0- No, 1- Yes
}NET_DVR_DECODERCFG_V30, *LPNET_DVR_DECODERCFG_V30;

//PTZ decoder configuration
typedef struct
{
    DWORD dwSize;
    DWORD dwBaudRate;   //Baud rate (bps) , 0- 50, 1- 75, 2- 110, 3- 150, 4- 300, 5- 600, 6- 1200, 7- 2400, 8- 4800, 9- 9600, 10- 19200,  11- 38400, 12- 57600, 13- 76800, 14- 115.2k; 
    BYTE byDataBit;     //Data bit 0- 5bit, 1- 6bit, 2- 7bit, 3- 8bit; 
    BYTE byStopBit;     //Stop bit 0- 1bit, 1- 2bit; 
    BYTE byParity;      //Parity 0- No parity, 1- odd, 2- even; 
    BYTE byFlowcontrol; //Flow control:  0- None, 1- software , 2- Hardware

    WORD wDecoderType;       //Decoder Type,  0- YouLi, 1- LiLin- 1016, 2- LiLin- 820, 3- Pelco- p, 4- DM DynaColor, 5- HD600, 6- JC- 4116, 7- Pelco- d WX, 8- Pelco- d PICO
    WORD wDecoderAddress;      //Decoder Address: 0 -  255
    BYTE bySetPreset[MAX_PRESET];         //Configure Preset or not, 0- No, 1- Yes
    BYTE bySetCruise[MAX_CRUISE];         //Configure Cruise or not:  0- No, 1- Yes 
    BYTE bySetTrack[MAX_TRACK];         //Configure Track or not, 0- No, 1- Yes
}NET_DVR_DECODERCFG, *LPNET_DVR_DECODERCFG;

//ppp parameters configuration (Sub Struct) 
typedef struct
{
    NET_DVR_IPADDR struRemoteIP;     //Remote IP
    NET_DVR_IPADDR struLocalIP;     //Local IP
    char sLocalIPMask[16];             //Local Mask
    BYTE sUsername[NAME_LEN];         //Username 
    BYTE sPassword[PASSWD_LEN];     //Password 
    BYTE byPPPMode;                 //PPP mode,  0- active, 1- passive
    BYTE byRedial;                     //Callback or not : 0- No, 1- Yes
    BYTE byRedialMode;                 //Callback, 0- user specified, 1- preseted number
    BYTE byDataEncrypt;             //Encrypt Data , 0- No, 1- Yes
    DWORD dwMTU;                     //MTU
    char sTelephoneNumber[PHONENUMBER_LEN];    //Telephone number
}NET_DVR_PPPCFG_V30, *LPNET_DVR_PPPCFG_V30;

//ppp parameters configuration (Sub Struct) 
typedef struct
{
    char sRemoteIP[16];             //Remote IP
    char sLocalIP[16];                 //Local IP
    char sLocalIPMask[16];             //Local Mask
    BYTE sUsername[NAME_LEN];         //Username 
    BYTE sPassword[PASSWD_LEN];     //Password 
    BYTE byPPPMode;                 //PPP mode,  0- active, 1- passive
    BYTE byRedial;                     //Callback or not : 0- No, 1- Yes
    BYTE byRedialMode;                 //Callback, 0- user specified, 1- preset number
    BYTE byDataEncrypt;             //Encrypt Data , 0- No, 1- Yes
    DWORD dwMTU;                     //MTU
    char sTelephoneNumber[PHONENUMBER_LEN];    //Telephone number
}NET_DVR_PPPCFG, *LPNET_DVR_PPPCFG;

//RS232 Configuration (9000 extended) 
typedef struct
{
    DWORD dwBaudRate; //Baud rate (bps) , 0- 50, 1- 75, 2- 110, 3- 150, 4- 300, 5- 600, 6- 1200, 7- 2400, 8- 4800, 9- 9600, 10- 19200,  11- 38400, 12- 57600, 13- 76800, 14- 115.2k; 
    BYTE byDataBit;   //Data bit 0- 5bit, 1- 6bit, 2- 7bit, 3- 8bit; 
    BYTE byStopBit;   //Stop bit 0- 1bit, 1- 2bit; 
    BYTE byParity;    //Parity 0- No parity, 1- odd, 2- even; 
    BYTE byFlowcontrol; //Flow control:  0- None, 1- software , 2- Hardware
    DWORD dwWorkMode;   //Word mode, 0- 232 for PPP dial, 1- 232 for parameter control, 2- for transparent channel 3- ptz mode 4-Alarm mode 5-Matrix control,
    //6-Screen control, 7-Direct connect, 8-Keyboard control 9-Monitor control 10-PTZ control

}NET_DVR_SINGLE_RS232;

typedef struct tagNET_DVR_USB_RS232
{
    DWORD dwBaudRate; //Baud rate (bps) , 0- 50, 1- 75, 2- 110, 3- 150, 4- 300, 5- 600, 6- 1200, 7- 2400, 8- 4800, 9- 9600, 10- 19200,  11- 38400, 12- 57600, 13- 76800, 14- 115.2k; 
    BYTE byDataBit;   //Data bit 0- 5bit, 1- 6bit, 2- 7bit, 3- 8bit; 
    BYTE byStopBit;   //Stop bit 0- 1bit, 1- 2bit; 
    BYTE byParity;    //Parity 0- No parity, 1- odd, 2- even; 
    BYTE byFlowcontrol; //Flow control:  0- None, 1- software , 2- Hardware
    BYTE byVirtualSerialPort;  // Virtual Serial Port
    BYTE byRes[3];
}NET_DVR_USB_RS232, *LPNET_DVR_USB_RS232;

//RS232 Configuration (9000 extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_SINGLE_RS232 struRs232[MAX_SERIAL_PORT];/*note: this structure has change*/
    NET_DVR_PPPCFG_V30 struPPPConfig;
}NET_DVR_RS232CFG_V30, *LPNET_DVR_RS232CFG_V30;

//RS232 Configuration
typedef struct
{
    DWORD dwSize;
    DWORD dwBaudRate; //Baud rate (bps) , 0- 50, 1- 75, 2- 110, 3- 150, 4- 300, 5- 600, 6- 1200, 7- 2400, 8- 4800, 9- 9600, 10- 19200,  11- 38400, 12- 57600, 13- 76800, 14- 115.2k; 
    BYTE byDataBit;   //Data bit 0- 5bit, 1- 6bit, 2- 7bit, 3- 8bit; 
    BYTE byStopBit;   //Stop bit 0- 1bit, 1- 2bit; 
    BYTE byParity;    //Parity 0- No parity, 1- odd, 2- even; 
    BYTE byFlowcontrol; //Flow control:  0- None, 1- software , 2- Hardware
    DWORD dwWorkMode;   //Word mode, 0- 232 for PPP dial, 1- 232 for parameter control, 2- for transparent channel
    NET_DVR_PPPCFG struPPPConfig;
}NET_DVR_RS232CFG, *LPNET_DVR_RS232CFG;


typedef struct
{
    DWORD dwEnablePresetChan;
    DWORD dwPresetPointNo;
}NET_DVR_PRESETCHAN_INFO, LPNET_DVR_PRESETCHAN_INFO;

typedef struct
{
    DWORD dwEnableCruiseChan;
    DWORD dwCruiseNo;
}NET_DVR_CRUISECHAN_INFO, LPNET_DVR_CRUISECHAN_INFO;

typedef struct
{
    DWORD dwEnablePtzTrackChan;
    DWORD dwPtzTrackNo;
}NET_DVR_PTZTRACKCHAN_INFO, LPNET_DVR_PTZTRACKCHAN_INFO;

typedef struct tagNET_DVR_PTZ_NOTIFICATION_COND
{
    DWORD   dwSize;
    /*
    0-facedetection,
    1-vehicleDetection,
    2-scenechangedetection,
    3-LineDetection,
    4-regionEntrance,
    5-regionExiting,
    6-loitering,
    7-group,
    8-rapidMove,
    9-parking,
    10-unattendedBaggage,
    11-attendedBaggage,
    12-audioDetection,
    13-PIR,
    14-defocusDetection
    15-temperature,
    16-fireDetection,
    17-thermometry,
    18-shipsDetection
    19-fieldDetection
    20-blackListFaceContrast
    21-whiteListFaceContrast
    22-humanRecognition
    23- faceContrast
    */
    WORD    byEventType;
    BYTE    byRes[2];
    DWORD   dwChannel;
    BYTE    byRes1[128];
}NET_DVR_PTZ_NOTIFICATION_COND, *LPNET_DVR_PTZ_NOTIFICATION_COND;

typedef struct tagNET_DVR_PTZ_NOTIFICATION_CFG
{
    DWORD   dwSize;
    DWORD   dwEnablePresetChanNum;  //The number of points currently enabled preset 
    NET_DVR_PRESETCHAN_INFO struPresetChanInfo[MAX_CHANNUM_V40]; //Enable the preset point information (PTZ) associated linkage type 
    DWORD   dwEnableCruiseChanNum;  //The current enabled channel number of the cruise 
    NET_DVR_CRUISECHAN_INFO struCruiseChanInfo[MAX_CHANNUM_V40]; //Enable the cruise function channel information (PTZ) associated linkage type 
    DWORD   dwEnablePtzTrackChanNum;  //The current enabled holder channel number of the track 
    NET_DVR_PTZTRACKCHAN_INFO struPtzTrackInfo[MAX_CHANNUM_V40]; //Call holder track channel information (PTZ) associated linkage type 
    BYTE      byRes1[1024];
}NET_DVR_PTZ_NOTIFICATION_CFG, *LPNET_DVR_PTZ_NOTIFICATION_CFG;


typedef struct tagNET_DVR_PTZ_NOTIFICATION
{
    DWORD   dwSize;
    /*
    0-facedetection,
    1-vehicleDetection,
    2-scenechangedetection,
    3-LineDetection,
    4-regionEntrance,
    5-regionExiting,
    6-loitering,
    7-group,
    8-rapidMove,
    9-parking,
    10-unattendedBaggage,
    11-attendedBaggage,
    12-audioDetection,
    13-PIR,
    14-defocusDetection,
    15-temperature,
    16-fireDetection,
    17-thermometry,
    18-shipsDetection
    19-fieldDetection
    20-blackListFaceContrast
    21-whiteListFaceContrast
    22- humanRecognition
    */
    WORD    byEventType;
    BYTE    byRes[62];
    DWORD   dwEnablePresetChanNum;  //The number of points currently enabled preset 
    NET_DVR_PRESETCHAN_INFO struPresetChanInfo[MAX_CHANNUM_V40]; //Enable the preset point information (PTZ) associated linkage type 
    DWORD   dwEnableCruiseChanNum;  //The current enabled channel number of the cruise 
    NET_DVR_CRUISECHAN_INFO struCruiseChanInfo[MAX_CHANNUM_V40]; //Enable the cruise function channel information (PTZ) associated linkage type 
    DWORD   dwEnablePtzTrackChanNum;  //The current enabled holder channel number of the track 
    NET_DVR_PTZTRACKCHAN_INFO struPtzTrackInfo[MAX_CHANNUM_V40]; //Call holder track channel information (PTZ) associated linkage type 
    BYTE      byRes1[1024];
}NET_DVR_PTZ_NOTIFICATION, *LPNET_DVR_PTZ_NOTIFICATION;

#define NET_SDK_MAX_EVENT_NUM 64  //Maximum number of supported combined events

//Alarm Input Configuration
typedef struct tagNET_DVR_ALARMINCFG_V40
{
    DWORD dwSize;
    BYTE sAlarmInName[NAME_LEN];    //Name
    BYTE byAlarmType;                 //Alarm Type, 0: normally open, 1: normally close
    BYTE byAlarmInHandle;             //Handle alarm or not 0- No 1- Yes
    BYTE byChannel;                 //Intelligent recognition channel triggered by alarm input
    BYTE byInputType;                //Input type, 0 - switch 1 - semaphore 
    DWORD   dwHandleType;        //The way to handle alarm   
    /*0x00:  No response*/
    /*0x01:  Alarm on monitor*/
    /*0x02:  Audio Alarm*/
    /*0x04:  Upload to center*/
    /*0x08:  Trigger alarm output*/
    /*0x10:  Grab JPEG image and EMail it*/
    /*0x20:  wireless voice and light alarm*/
    /*0x40:  Trigger electric map(only PCNVR supports)*/
    /*0x200: capture jpeg and update to FTP*/
    /*0x1000:capture jpeg and update to cloud*/
    /*0x2000:SMS alarm*/
    DWORD   dwMaxRelAlarmOutChanNum; //Max RelAlarm Out Chan Num (read Only)
    DWORD   dwRelAlarmOutChanNum;
    DWORD   dwRelAlarmOut[MAX_ALARMOUT_V40]; //Alarm Out Chan No.
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//alarm Time

    DWORD   dwMaxRecordChanNum;
    DWORD   dwCurRecordChanNum;
    DWORD   dwRelRecordChan[MAX_CHANNUM_V40];
    DWORD   dwMaxEnablePtzCtrlNun;
    DWORD   dwEnablePresetChanNum;  //enable preset Num
    NET_DVR_PRESETCHAN_INFO struPresetChanInfo[MAX_CHANNUM_V40]; //Call preset Info
    BYTE    byPresetDurationTime[MAX_CHANNUM_V40];//Preset point time range 0-20s, the default 10s. 
    BYTE    byRes2[4];
    DWORD   dwEnableCruiseChanNum;  //enable Cruise Num
    NET_DVR_CRUISECHAN_INFO struCruiseChanInfo[MAX_CHANNUM_V40]; //Cruise Info
    DWORD   dwEnablePtzTrackChanNum;  //Track Num
    NET_DVR_PTZTRACKCHAN_INFO struPtzTrackInfo[MAX_CHANNUM_V40]; //Track No
    WORD   wEventType[NET_SDK_MAX_EVENT_NUM/*64*/]; /*Composite event types, each bit corresponding to an event type*/
    BYTE    byRes[128];
}NET_DVR_ALARMINCFG_V40, *LPNET_DVR_ALARMINCFG_V40;

//Alarm Input Configuration (9000 extended) 
typedef struct
{
    DWORD dwSize;
    BYTE sAlarmInName[NAME_LEN];     //Name 
    BYTE byAlarmType;                 //Alarm Type, 0: normally open, 1: normally close
    BYTE byAlarmInHandle;             //Handle alarm or not 0- No 1- Yes
    BYTE byChannel;                 //Intelligent recognition channel triggered by alarm input
    BYTE byInputType;                //Input type, 0 - switch 1 - semaphore 
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;     //The way to handle alarm 
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; //Guard time
    BYTE byRelRecordChan[MAX_CHANNUM_V30];         //Channel triggered to record,  1- - trigger
    BYTE byEnablePreset[MAX_CHANNUM_V30];         //Call preset or not 0- No, 1- Yes
    BYTE byPresetNo[MAX_CHANNUM_V30];             //Preset No. One alarm input can trigger several presets,  0xff- disable
    BYTE byRes2[192];                             //Reserved
    BYTE byEnableCruise[MAX_CHANNUM_V30];         //Call Cruise or not 0- No, 1- Yes
    BYTE byCruiseNo[MAX_CHANNUM_V30];             //Cruise No.
    BYTE byEnablePtzTrack[MAX_CHANNUM_V30];     //Call Track or not 0- No, 1- Yes
    BYTE byPTZTrack[MAX_CHANNUM_V30];             //Track No. 
    BYTE byRes3[16];
}NET_DVR_ALARMINCFG_V30, *LPNET_DVR_ALARMINCFG_V30;

//Alarm Input Configuration
typedef struct
{
    DWORD dwSize;
    BYTE sAlarmInName[NAME_LEN];     //Name 
    BYTE byAlarmType;                 //Alarm Type, 0: normally open, 1: normally close
    BYTE byAlarmInHandle;             //Handle alarm or not 0- No 1- Yes
    BYTE byChannel;                 //Intelligent recognition channel triggered by alarm input
    BYTE byRes;
    NET_DVR_HANDLEEXCEPTION struAlarmHandleType; //The way to handle alarm 
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT]; //Guard time
    BYTE byRelRecordChan[MAX_CHANNUM];         //Channel triggered to record,  1- - trigger
    BYTE byEnablePreset[MAX_CHANNUM];         //Call preset or not 0- No, 1- Yes
    BYTE byPresetNo[MAX_CHANNUM];             //Preset No. One alarm input can trigger several presets,  set 0xff to disable
    BYTE byEnableCruise[MAX_CHANNUM];         //Call Cruise or not 0- No, 1- Yes
    BYTE byCruiseNo[MAX_CHANNUM];             //Cruise No.
    BYTE byEnablePtzTrack[MAX_CHANNUM];     //Call Track or not 0- No, 1- Yes
    BYTE byPTZTrack[MAX_CHANNUM];             //Track No. 
}NET_DVR_ALARMINCFG, *LPNET_DVR_ALARMINCFG;

typedef struct tagNET_DVR_MB_AUTOWORKPARA
{

    BYTE    byCurPowerCtrlType;   /*parent start control type 0:  reserved,  1:  delay shutdown,  2:  auto start and shutdown*/
    BYTE    byRes[3];
    NET_DVR_SCHEDTIME    struWorkTime[MAX_DAYS][2];
}NET_DVR_MB_AUTOWORKPARA, *LPNET_DVR_MB_AUTOWORKPARA;

//analogy input Configuration
typedef struct tagNet_DVR_ANALOG_ALARMINCFG
{
    DWORD     dwSize;
    BYTE        byEnableAlarmHandle; //Handle alarm or not 0- No 1- Yes
    BYTE        byRes1[3];
    BYTE        byAlarmInName[NAME_LEN]; //Name 
    WORD        wAlarmInUpper; //The analog input voltage under limit,The actual value*10,[0~360]
    WORD        wAlarmInLower; //The analog input voltage upper limit,The actual value*10,[0~360] 
    NET_DVR_HANDLEEXCEPTION_V30 struAlarmHandleType;    //The way to handle alarm 
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Guard time
    BYTE        byRelRecordChan[MAX_CHANNUM_V30]; //Channel triggered to record
    BYTE        byRes2[100];
}NET_DVR_ANALOG_ALARMINCFG, *LPNET_DVR_ANALOG_ALARMINCFG;


typedef struct tagNET_DVR_ALARMINFO_FIXED_HEADER
{
    DWORD dwAlarmType;              /*0- sensor alarm; 1- hard disk full; 2- video lost; 3- motion detection; 4- hard disk unformatted; 5- hard disk error; 6- tampering detection; 7- unmatched video output standard; 8- illegal operation; 9- video exception; 0xa- record exception
                        11- Vca scene change 12-Array exception 13 resolution dismatch,14-alloc decode resource fail,15-VCA detect,19-audio input lost, 20-record on,21-record off,22-vehicle detection exception, 23-pulse alarm,24-face lib disk alarm,25-face lib change,26-face picture change,28-camera angle anomaly*/
    NET_DVR_TIME_EX struAlarmTime;    //alarm Time
    union
    {
        BYTE    byUnionLen[116];
        struct
        {
            DWORD    dwAlarmInputNo;
            DWORD    dwTrigerAlarmOutNum;
            DWORD    dwTrigerRecordChanNum;
        }struIOAlarm;    // sensor alarm 
        struct
        {
            DWORD    dwAlarmChanNum;
        }struAlarmChannel;    // dwAlarmType is 2,3,6,9,10,13 or 28 Effective
        struct
        {
            DWORD    dwAlarmHardDiskNum;    /*it stands for Hard Disk,  dwDiskNumber*/
        }struAlarmHardDisk;/*When dwAlarmType is 1, 4 or 5,  it stands for Hard Disk,  dwDiskNumber[0] is the first disk*/
        struct
        {
            BYTE       bySubAlarmType;  //alarm type,1-delay record; 
            BYTE       byRes1[3]; //res
            NET_DVR_TIME_EX  struRecordEndTime; //record end 
        }struRecordingHost;  //record host alarm
    }uStruAlarm;
    DWORD*  pRes;    //res
    BYTE   byTimeDiffFlag;      /*Time difference is valid or not 0-invalid 1-valid */
    char   cTimeDifferenceH;         /*Time difference(HOUR) from UTC */
    char   cTimeDifferenceM;      	/*Time difference(MINUTE) from UTC*/
    BYTE   byRes2[5];
}NET_DVR_ALRAM_FIXED_HEADER, *LPNET_DVR_ALARM_FIXED_HEADER;

//Upload Alarm Information(256 NVR extended)
typedef struct NET_DVR_ALARMINFO_V40
{
    NET_DVR_ALRAM_FIXED_HEADER     struAlarmFixedHeader;
    DWORD*                        pAlarmData;
}NET_DVR_ALARMINFO_V40, *LPNET_DVR_ALARMINFO_V40;

//Upload Alarm Information  (9000 extended) 
typedef struct
{
    DWORD dwAlarmType; /*0- sensor alarm; 1- hard disk full; 2- video lost; 3- motion detection; 4- hard disk unformatted; 5- hard disk error; 6- tampering detection; 7- unmatched video output standard; 8- illegal operation; 9- video exception; 0xa- record exception
                       11- Vca scene change 12-Array exception 13 resolution dismatch,14-alloc decode resource fail,15-VCA detect, 16-POE power supply abnormal alarm,17-Flash anomaly ,18-Disk full load anomaly,19-audio input lost, 20-record on, 21-record off,22-vehicle detection exception, 23-pulse alarm,24-face lib disk alarm,25-face lib change,26-face picture change,28-camera angle anomaly
                       ,29-battery low,30-Lack of SD card*/
    DWORD dwAlarmInputNumber; /*Alarm input Port*/
    BYTE byAlarmOutputNumber[MAX_ALARMOUT_V30]; /*State of Alarm output channel, 1- - Triggered*/
    BYTE byAlarmRelateChannel[MAX_CHANNUM_V30]; /*channels triggered to record, 1- recording,  dwAlarmRelateChannel[0] is the first channel*/
    BYTE byChannel[MAX_CHANNUM_V30]; /*If the dwAlarmType is 2, 3 , 6,14, 19 or 28 it stands for channel, dwChannel[0] is the first channel*/
    BYTE byDiskNumber[MAX_DISKNUM_V30]; /*When dwAlarmType is 1, 4 or 5,  it stands for Hard Disk,  dwDiskNumber[0] is the first disk*/
}NET_DVR_ALARMINFO_V30, *LPNET_DVR_ALARMINFO_V30;

typedef struct tagNET_DVR_ALARM_HOT_SPARE
{
    DWORD  dwSize;
    DWORD  dwExceptionCase;   //alarm reason   0-net exception
    NET_DVR_IPADDR  struDeviceIP;    //Device IP
    BYTE    byRes[256];
}NET_DVR_ALARM_HOT_SPARE, *LPNET_DVR_ALARM_HOT_SPARE;

typedef struct
{
    DWORD dwAlarmType; /*0- sensor alarm; 1- hard disk full; 2- video lost; 3- motion detection; 4- hard disk unformatted; 5- hard disk error; 6- tampering detection; 7- unmatched video output standard; 8- illegal operation; 9- video exception; 0xa- record exception*/
    DWORD dwAlarmInputNumber; /*Alarm input Port*/
    DWORD dwAlarmOutputNumber[MAX_ALARMOUT]; /*State of Alarm output channel, 1- - Triggered*/
    DWORD dwAlarmRelateChannel[MAX_CHANNUM]; /*channels triggered to record, 1- recording,  dwAlarmRelateChannel[0] is the first channel*/
    DWORD dwChannel[MAX_CHANNUM]; /*If the dwAlarmType is 2, 3 or 6, it stands for channel, dwChannel[0] is the first channel*/
    DWORD dwDiskNumber[MAX_DISKNUM]; /*When dwAlarmType is 1, 4 or 5,  it stands for Hard Disk,  dwDiskNumber[0] is the first disk*/
}NET_DVR_ALARMINFO, *LPNET_DVR_ALARMINFO;

//////////////////////////////////////////////////////////////////////////////////////
//IP Camera Parameter
/* IP Device */
//extended ipc connection functions,  support add IPC domain name

#define  DEV_ID_LEN           32    
typedef struct tagNET_DVR_IPDEVINFO_V31
{
    BYTE byEnable;                     //Valid status for IP device
    BYTE byProType;                 //Protocol type,  0- private (default) ,  1-  Panasonic,  2-  SONY
    BYTE byEnableQuickAdd;          //0-  does not support quick adding of IP device;  1-   enable quick adding of IP device
    //Quick add of device IP and protocol,  fill in the other parameters as system default 
    BYTE byCameraType;    //Channel access camera type
    BYTE sUserName[NAME_LEN];         //user name
    BYTE sPassword[PASSWD_LEN];     //Password
    BYTE byDomain[MAX_DOMAIN_NAME]; //Domain name of the device
    NET_DVR_IPADDR struIP;             //IP
    WORD wDVRPort;                      //Port number
    BYTE  szDeviceID[DEV_ID_LEN];  //Device ID 
    BYTE byEnableTiming;  //0- retention, 1- disable NVR to automatic timing for IPC, 2- enable NVR to automatic timing for IPC
    BYTE byCertificateValidation;//Certificate authentication
    // byCertificateValidation:bit0:0- certificate validation is not enabled 1- certificate validation is enabled
    // byCertificateValidation:bit1:0- no default communication port 1- enable default communication port
}NET_DVR_IPDEVINFO_V31, *LPNET_DVR_IPDEVINFO_V31;

typedef struct
{
    DWORD dwEnable;                 /* Enable this device */
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];     /* Password */
    NET_DVR_IPADDR struIP;             /* IP address */
    WORD wDVRPort;                      /* Port */
    BYTE byRes[34];                 /* Reserved */
}NET_DVR_IPDEVINFO, *LPNET_DVR_IPDEVINFO;

/* IP Channel parameters */
typedef struct
{
    BYTE byEnable;                     //0- Failed to connect IP device; 1- Successfully; 
    BYTE byIPID;                     //ID of IP device,  low 8 bit 
    BYTE byChannel;                 //Channel No. 
    BYTE byIPIDHigh;                //ID of IP device,  high 8 bit 
    BYTE byTransProtocol;            //Trans Protocol Type 0-TCP/auto (Determined by the device),1-UDP 2-Multicast 3-only TCP 4-auto
    BYTE byGetStream;         /* Whether to get stream,0-yes,1-no*/
    BYTE byres[30];                    /* Reserved */
} NET_DVR_IPCHANINFO, *LPNET_DVR_IPCHANINFO;

/* Struct of connecting IP device*/
typedef struct
{
    DWORD dwSize;                                          /* Structure Size */
    NET_DVR_IPDEVINFO  struIPDevInfo[MAX_IP_DEVICE];     /* IP Device */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];         /* Enable analog channel or not, channel 1 (low bit)  to channel 32 (high bit) , 0- invalid;  1- valid */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];   /* IP Channel */
}NET_DVR_IPPARACFG, *LPNET_DVR_IPPARACFG;

typedef struct tagNET_DVR_IPPARACFG_V31
{
    DWORD dwSize;                                          /* Structure size */
    NET_DVR_IPDEVINFO_V31  struIPDevInfo[MAX_IP_DEVICE]; /* IP device */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];         /* Enable/disable analog channels,  stands for channel 1- 32 ,  0- disable;  1- enable */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];      /* IP channel*/
}NET_DVR_IPPARACFG_V31, *LPNET_DVR_IPPARACFG_V31;

typedef  struct tagNET_DVR_IPSERVER_STREAM
{
    BYTE    byEnable;   //Is enable
    BYTE    byRes[3];
    NET_DVR_IPADDR struIPServer;   //IPServer Address
    WORD  wPort;                   //IPServer port
    WORD  wDvrNameLen;             //DVR Name Length
    BYTE   byDVRName[NAME_LEN];    //DVR Name
    WORD  wDVRSerialLen;           //Serial Length
    WORD  byRes1[2];               //reserved
    BYTE   byDVRSerialNumber[SERIALNO_LEN];    //DVR Serial
    BYTE   byUserName[NAME_LEN];               //DVR User name
    BYTE   byPassWord[PASSWD_LEN];             //DVR User password
    BYTE    byChannel;                         //DVR channel
    BYTE   byRes2[11];              //Reserved
}NET_DVR_IPSERVER_STREAM, *LPNET_DVR_IPSERVER_STREAM;

/*the configuration of stream server*/
typedef struct tagNET_DVR_STREAM_MEDIA_SERVER_CFG
{
    BYTE    byValid;            //Is enable
    BYTE    byRes1[3];
    NET_DVR_IPADDR  struDevIP;  //stream server IP    
    WORD    wDevPort;            //stream server Port    
    BYTE    byTransmitType;        //Protocol: 0-TCP, 1-UDP
    BYTE    byRes2[69];
}NET_DVR_STREAM_MEDIA_SERVER_CFG, *LPNET_DVR_STREAM_MEDIA_SERVER_CFG;

//device information
typedef struct tagNET_DVR_DEV_CHAN_INFO
{
    NET_DVR_IPADDR     struIP;            //DVR IP address
    WORD     wDVRPort;                 //DVR PORT
    BYTE     byChannel;                //Channel
    BYTE    byTransProtocol;        //Transmit protocol:0-TCP,1-UDP
    BYTE    byTransMode;            //Stream mode: 0-mian stream 1-sub stream
    BYTE    byFactoryType;            /*IPC factory type*/
    BYTE    byDeviceType; //Device type(Used by videoplatfom VCA card),1-decoder(use decode channel No. or display channel depends on byVcaSupportChanMode in videoplatform ability struct),2-coder
    BYTE    byDispChan;//Display channel No. used by VCA configuration
    BYTE    bySubDispChan;//Display sub channel No. used by VCA configuration
    BYTE    byResolution;    //Resolution: 1-CIF 2-4CIF 3-720P 4-1080P 5-500w used by big screen controler
    BYTE    byRes[2];
    BYTE    byDomain[MAX_DOMAIN_NAME];    //Device domain name
    BYTE    sUserName[NAME_LEN];    //Remote device user name
    BYTE    sPassword[PASSWD_LEN];    //Remote device password
}NET_DVR_DEV_CHAN_INFO, *LPNET_DVR_DEV_CHAN_INFO;

typedef struct tagNET_DVR_PU_STREAM_CFG
{
    DWORD                                dwSize;
    NET_DVR_STREAM_MEDIA_SERVER_CFG    struStreamMediaSvrCfg;
    NET_DVR_DEV_CHAN_INFO                struDevChanInfo;
}NET_DVR_PU_STREAM_CFG, *LPNET_DVR_PU_STREAM_CFG;

typedef struct tagNET_DVR_DDNS_STREAM_CFG
{
    BYTE   byEnable;   //Is Enable.
    BYTE   byRes1[3];
    NET_DVR_IPADDR  struStreamServer;   //Stream server IP
    WORD   wStreamServerPort;           //Stream server Port   
    BYTE   byStreamServerTransmitType;  //Stream protocol
    BYTE   byRes2;
    NET_DVR_IPADDR   struIPServer;      //IPserver IP
    WORD   wIPServerPort;               //IPserver Port
    BYTE   byRes3[2];
    BYTE   sDVRName[NAME_LEN];     //DVR Name
    WORD   wDVRNameLen;            //DVR Name Len
    WORD   wDVRSerialLen;          //Serial Len
    BYTE   sDVRSerialNumber[SERIALNO_LEN];    //Serial number
    BYTE   sUserName[NAME_LEN];   //the user name which is used to login DVR.
    BYTE   sPassWord[PASSWD_LEN]; //the password which is used to login DVR.
    WORD   wDVRPort;        //DVR port
    BYTE   byRes4[2];
    BYTE   byChannel;       //channel
    BYTE   byTransProtocol; //protocol 
    BYTE   byTransMode;     //transform mode
    BYTE   byFactoryType;   //The type of factory who product the device.
}NET_DVR_DDNS_STREAM_CFG, *LPNET_DVR_DDNS_STREAM_CFG;

#define MAX_LICENSE_LEN_EX                    32        //Max. length of the license number
typedef    struct
{
    DWORD    dwSize;
    NET_DVR_TIME_EX    strStartTime;  //start time 
    NET_DVR_TIME_EX    strStopTime;  //end time 
    char     sLicense[MAX_LICENSE_LEN_EX/*32*/];    //vechial number
    // area index 0-res,1-(Europe Region),2-(Russian Region),3-(EU&CIS) ,4-(Middle East),0xff-all
    DWORD      dwChannel;
    BYTE      byRegion;
    BYTE      byRes[127];
}NET_DVR_VEHICLE_INFO_COND, *LPNET_DVR_VEHICLE_INFO_COND;

typedef  struct
{
    DWORD     dwSize;
    DWORD     dwIndex;//index    
    BYTE    byDeviceID[DEVICE_ID_LEN/*48*/];    //device num
    BYTE    byBelieve;//,0-100    
    BYTE    byDir;//derection,0-none,1-reverse,2-positive,3-unknown
    BYTE    byLineID;//
    BYTE    byRes1;
    NET_DVR_TIME_EX  struSnapTime;//snap time
    char    sLicense[MAX_LICENSE_LEN_EX/*32*/];        //vehicle num
    BYTE    byMonitoringSiteID[MONITORSITE_ID_LEN /*48*/];    //
    BYTE    byCountry; // conutry index,COUNTRY_INDEX(no support"COUNTRY_ALL = 0xff, //ALL ")
    BYTE    byMatchingResult;//match result:0-res,1-whitelist,2-blacklist,3-otherlist
    BYTE    byArea;                         //Area of  The United Arab Emirates, refer to EMI_AREA
    BYTE    byPlateType;                    //Plate Type, refer to VCA_PLATE_TYPE
    char    sDeviceName[NAME_LEN/*32*/];    //Device Name
    BYTE  	byPlateColor;						//Plate Color,VCA_PLATE_COLOR
    BYTE  	byPlateSize;						//Plate Size,0~unknown,1~long,2~short
    BYTE    byRes2[2];
    char    sPlateCategory[MAX_CATEGORY_LEN/*8*/];		//Plate Category
    char    sPlateImageURL[URL_LEN_V40/*256*/];         //Plate Image URL
    char    sEffectiveTime[ISO_8601_LEN/*32*/];    //Plate Effective Time, ISO8601 time, 2009-11-14T15:27Z
    BYTE    byRes[176];
}NET_DVR_VEHICLE_INFO_CFG, *LPNET_DVR_VEHICLE_INFO_CFG;

#define URL_LEN     240   //URL length
typedef struct tagNET_DVR_PU_STREAM_URL
{
    BYTE    byEnable;
    BYTE    strURL[URL_LEN];
    BYTE    byTransPortocol; // transport protocol type  0-tcp  1-UDP
    WORD    wIPID;  //Device ID,wIPID = iDevInfoIndex + iGroupNO*64 +1
    BYTE    byChannel;  //channel NO.
    BYTE    byRes[7];
}NET_DVR_PU_STREAM_URL, *LPNET_DVR_PU_STREAM_URL;

typedef  struct tagNET_DVR_HKDDNS_STREAM
{
    BYTE    byEnable;   //Is enable
    BYTE    byRes[3];
    BYTE    byDDNSDomain[64];    // hiDDNS domain
    WORD    wPort;                   //IPServer port
    WORD    wAliasLen;               //Alias Length
    BYTE    byAlias[NAME_LEN];         //Alias
    WORD    wDVRSerialLen;           //Serial Length
    BYTE    byRes1[2];               //reserved
    BYTE    byDVRSerialNumber[SERIALNO_LEN];    //DVR Serial
    BYTE    byUserName[NAME_LEN];               //DVR User name
    BYTE    byPassWord[PASSWD_LEN];             //DVR User passward
    BYTE    byChannel;                          //DVR channel
    BYTE    byRes2[11];              //Reserved
}NET_DVR_HKDDNS_STREAM, *LPNET_DVR_HKDDNS_STREAM;

typedef struct tagNET_DVR_IPCHANINFO_V40
{
    BYTE    byEnable;                /* Enable */
    BYTE    byRes1;
    WORD    wIPID;                  //IP ID
    DWORD     dwChannel;                //channel
    BYTE    byTransProtocol;        //Trans protocol,0-TCP,1-UDP, 2-multicast, 3-rtsp, 0xff-auto (auto)
    BYTE    byTransMode;            //Trans mode 0-main, 1-sub
    BYTE    byFactoryType;            /*Factory type*/
    BYTE    byRes;
    BYTE    strURL[URL_LEN/*240*/];   /*RTSP protocol fetch stream URL (valid only for RTSP protocol)*/
}NET_DVR_IPCHANINFO_V40, *LPNET_DVR_IPCHANINFO_V40;

// Brainare CVR
#define MAX_ID_COUNT    256
#define MAX_STREAM_ID_COUNT    1024
#define STREAM_ID_LEN   32
#define PLAN_ID_LEN  32

#define LEN_32                    32
#define LEN_31                    31
#define DEVICE_NO_LEN  24
#define MAX_VOLUMENAME_LEN 32   //volume name lenth
#define MAX_VAG_CHANNO_LEN  32  

#define MAX_STREAM_ID_NUM    30

typedef struct tagNET_DVR_RTSP_PROTOCAL_CFG
{
    BYTE    byEnable;
    BYTE    byLocalBackUp; //enable local backup 0-disable ,1-enable
    BYTE    byRes[2];
    BYTE    strURL[URL_LEN_V40];
    DWORD   dwProtocalType;
    BYTE    sUserName[NAME_LEN];
    BYTE    sPassWord[PASSWD_LEN];
    BYTE    byAddress[MAX_DOMAIN_NAME];  //Encoder IP or domain name, the device needs to resolve Analytical methods exist for the letters and there '.' Is considered to be the domain name, IP address otherwise
    WORD    wPort;
    BYTE    byRes1[122];
}NET_DVR_RTSP_PROTOCAL_CFG, *LPNET_DVR_RTSP_PROTOCAL_CFG;


// Stream info
typedef struct tagNET_DVR_STREAM_INFO
{
    DWORD dwSize;
    BYTE  byID[STREAM_ID_LEN];      //ID
    DWORD dwChannel;                //Relation channel, 0xffffffff: not related
    BYTE  byRes[32];
}NET_DVR_STREAM_INFO, *LPNET_DVR_STREAM_INFO;


typedef union tagNET_DVR_GET_STREAM_UNION
{
    NET_DVR_IPCHANINFO      struChanInfo;         //Get stream from Device.
    NET_DVR_IPSERVER_STREAM struIPServerStream;  //Get stream from Device which register the IPServer
    NET_DVR_PU_STREAM_CFG   struPUStream;         //Get stream from stream server.
    NET_DVR_DDNS_STREAM_CFG struDDNSStream;      //Get stream by IPserver and stream server.
    NET_DVR_PU_STREAM_URL   struStreamUrl;        //get stream through stream server by url.
    NET_DVR_HKDDNS_STREAM struHkDDNSStream;   //get stream through hiDDNS
    NET_DVR_IPCHANINFO_V40 struIPChan; //Get stream from device(Extend)
}NET_DVR_GET_STREAM_UNION, *LPNET_DVR_GET_STREAM_UNION;

typedef enum
{
    NET_SDK_IP_DEVICE = 0,
    NET_SDK_STREAM_MEDIA,
    NET_SDK_IPSERVER,
    NET_SDK_DDNS_STREAM_CFG,
    NET_SDK_STREAM_MEDIA_URL,
    NET_SDK_HKDDNS,
    NET_SDK_IP_DEVICE_ADV,
    NET_SDK_IP_DEVICE_V40,
    NET_SDK_RTSP
}GET_STREAM_TYPE;

typedef struct tagNET_DVR_STREAM_MODE
{
    BYTE    byGetStreamType; //the type of gettin stream:0-Get stream from Device, 1-Get stream fram stream server, 
    //2-Get stream from Device which register the IPServer, 3.Get stream by IPserver and stream server
    //4-get stream by url,5-hkDDNS,6-Get stream from Device,NET_DVR_IPCHANINFO_V40,7- Get Stream by Rtsp Protocal 
    BYTE    byRes[3];        //reserved
    NET_DVR_GET_STREAM_UNION uGetStream;    //the union of different getting stream type.
}NET_DVR_STREAM_MODE, *LPNET_DVR_STREAM_MODE;


typedef struct tagNET_DVR_IPPARACFG_V40
{
    DWORD      dwSize;                        //Size
    DWORD        dwGroupNum;                    //The number of group    
    DWORD      dwAChanNum;                    //The number of simulate channel
    DWORD      dwDChanNum;                  //the number of IP channel
    DWORD      dwStartDChan;                //the begin NO. of IP channel
    BYTE       byAnalogChanEnable[MAX_CHANNUM_V30];    //Is simulate channel enable? represent by bit
    NET_DVR_IPDEVINFO_V31   struIPDevInfo[MAX_IP_DEVICE_V40];      //IP device
    NET_DVR_STREAM_MODE  struStreamMode[MAX_CHANNUM_V30];
    BYTE            byRes2[20];                 //reserved
}NET_DVR_IPPARACFG_V40, *LPNET_DVR_IPPARACFG_V40;


typedef struct tagNET_DVR_ALARMINFO_DEV
{
    DWORD     dwAlarmType;    //type
    NET_DVR_TIME   struTime;  //time
    BYTE       byRes[32];     //reserved
    DWORD      dwNumber;      //number
    WORD       *pNO;
}NET_DVR_ALARMINFO_DEV, *LPNET_DVR_ALARMINFO_DEV;

/* Alarm output channel */
typedef struct
{
    BYTE byIPID;                     /* ID of IP device,  the range:  1 to MAX_IP_DEVICE */
    BYTE byAlarmOut;                 /* Alarm output NO. */
    BYTE byRes[18];                 /* Reserved */
}NET_DVR_IPALARMOUTINFO, *LPNET_DVR_IPALARMOUTINFO;

/* IP Alarm output configuration */
typedef struct
{
    DWORD dwSize;                                                 /*struct size */
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT]; /* IP alarm output */
}NET_DVR_IPALARMOUTCFG, *LPNET_DVR_IPALARMOUTCFG;


/* Alarm output parameters */
typedef struct tagNET_DVR_IPALARMOUTINFO_V40
{
    DWORD dwIPID;                    /* ID of IP device,  the range:  1 to MAX_IP_DEVICE*/
    DWORD dwAlarmOut;                /* Alarm Out NO. */
    BYTE  byRes[32];                /* Reserved */
}NET_DVR_IPALARMOUTINFO_V40, *LPNET_DVR_IPALARMOUTINFO_V40;

typedef struct tagNET_DVR_IPALARMOUTCFG_V40
{
    DWORD   dwSize;
    DWORD   dwCurIPAlarmOutNum;
    NET_DVR_IPALARMOUTINFO_V40 struIPAlarmOutInfo[MAX_IP_ALARMOUT_V40];
    BYTE     byRes[256];
}NET_DVR_IPALARMOUTCFG_V40, *LPNET_DVR_IPALARMOUTCFG_V40;

/* Alarm input parameters */
typedef struct
{
    BYTE byIPID;                     /* ID of IP device,  the range:  1 to MAX_IP_DEVICE */
    BYTE byAlarmIn;                 /* Alarm input NO. */
    BYTE byRes[18];                 /* Reserved */
}NET_DVR_IPALARMININFO, *LPNET_DVR_IPALARMININFO;

/* IP Alarm input configuration */
typedef struct
{
    DWORD dwSize;                                              /*struct size */
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];  /* IP alarm input */
}NET_DVR_IPALARMINCFG, *LPNET_DVR_IPALARMINCFG;

/* IP Alarm input configuration */
typedef struct tagNET_DVR_IPALARMININFO_V40
{
    DWORD dwIPID;                    /* ID of IP device,  the range:  1 to MAX_IP_DEVICE */
    DWORD dwAlarmIn;                /* Alarm input NO. */
    BYTE  byRes[32];
}NET_DVR_IPALARMININFO_V40, *LPNET_DVR_IPALARMININFO_V40;

typedef struct tagNET_DVR_IPALARMINCFG_V40
{
    DWORD   dwSize;
    DWORD   dwCurIPAlarmInNum;
    NET_DVR_IPALARMININFO_V40 struIPAlarmInInfo[MAX_IP_ALARMIN_V40];
    BYTE     byRes[256];
}NET_DVR_IPALARMINCFG_V40, *LPNET_DVR_IPALARMINCFG_V40;


//IP Camera alarm info
typedef struct
{
    NET_DVR_IPDEVINFO  struIPDevInfo[MAX_IP_DEVICE];             /* IP Device */
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];                 /* Enable analog channel or not, 0- Enable;  1- Disable */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];              /* IP Channel */
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];     /* IP Alarm input */
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT];  /* IP Alarm output */
}NET_DVR_IPALARMINFO, *LPNET_DVR_IPALARMINFO;

//IPC configuration change alarm  (Extended for 9000_1.1) 
typedef struct tagNET_DVR_IPALARMINFO_V31
{
    NET_DVR_IPDEVINFO_V31  struIPDevInfo[MAX_IP_DEVICE];         /* IP device*/
    BYTE byAnalogChanEnable[MAX_ANALOG_CHANNUM];                 /* Enable/ disable analog channel,  0-  disable;  1- enable */
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_IP_CHANNEL];              /* IP channel */
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];     /* IP alarm input */
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT];  /* IP alarm output */
}NET_DVR_IPALARMINFO_V31, *LPNET_DVR_IPALARMINFO_V31;

typedef struct tagNET_DVR_IPALARMINFO_V40
{
    NET_DVR_IPDEVINFO_V31 struIPDevInfo[MAX_IP_DEVICE_V40];     //IP device
    BYTE     byAnalogChanEnable[MAX_CHANNUM_V30];               //Enable analog channel or not: 0- disable, 1- enable
    NET_DVR_IPCHANINFO struIPChanInfo[MAX_CHANNUM_V30];            //IP channel
    NET_DVR_IPALARMININFO struIPAlarmInInfo[MAX_IP_ALARMIN];    //IP alarm input 
    NET_DVR_IPALARMOUTINFO struIPAlarmOutInfo[MAX_IP_ALARMOUT]; //IP alarm output   
    BYTE                    byRes[20];                          //Reserved
}NET_DVR_IPALARMINFO_V40, *LPNET_DVR_IPALARMINFO_V40;

typedef enum _HD_STAT_
{
    HD_STAT_OK = 0,   /* Normal */
    HD_STAT_UNFORMATTED = 1,   /* Raw */
    HD_STAT_ERROR = 2,   /* Error */
    HD_STAT_SMART_FAILED = 3,   /* SMART State */
    HD_STAT_MISMATCH = 4,   /* Unmatched */
    HD_STAT_IDLE = 5,   /* Sleep*/
    NET_HD_STAT_OFFLINE = 6,   /* Net Disk is off line */
    HD_RIADVD_EXPAND = 7,   /* riad virtual disk expand */
    HD_STAT_REPARING = 10,  /* disk is repairing */
    HD_STAT_FORMATING = 11,  /* disk is formating */
}HD_STAT;

//Configuration of local Hard Disk
typedef struct
{
    DWORD dwHDNo;          /*Hard Disk No.  (0~MAX_DISKNUM_V30- 1)  */
    DWORD dwCapacity;      /*Capacity (Read only) */
    DWORD dwFreeSpace;     /*Free space (Read only) */
    DWORD dwHdStatus;      /*Disk status (Read only)  0- Normal,  1- Raw,  2- Error,  3- SMART State,  4- Unmatched,  5- Sleep*/
    /* 6 - network hard disk is not online 7 - the virtual disk scalable 10 - hard drive being repaired*/
    /* 11 - hard disk is formatted 12 - hard drive is waiting for formatting 13 - hard uninstalled */
    /*14 - the local hard disk does not exist 15 - (network hard drive being deleted),16-locked*/
    BYTE  byHDAttr;        /*0- Default,  1- Redundancy;  2- Read only, , 3- backup, use for CVR,4-NotRW*/
    BYTE  byHDType;           /*0- Local HD,1-ESATA HD,2-NAS HD,3-iSCSI HD 4-Array Virtual Disk,5-SD card,,6-minSAS*/
    BYTE  byDiskDriver;    //The value means its ANSC character, added for IVMS device
    BYTE  byRes1;
    DWORD dwHdGroup;       //Disk Group  (1- MAX_HD_GROUP) 
    BYTE  byRecycling;       //  0:no reuse,1:reuse
    BYTE  bySupportFormatType;    /*only supports byHDType=5(SD card);
                                  bySupportFormatType=0, the device will format the hard disk with its default type.
                                  bySupportFormatType: bit0:0 - representative does not support FAT32 format type, 1 - on behalf of the support;
                                  bySupportFormatType: bit1:0 - representative does not support corruption format type, 1 - on behalf of the support;*/
    BYTE  byFormatType;         /* 0- device default format type,1- specify FAT32 format (byHDType=5(SD card),2- specify EXT4 format (byHDType=5(SD card))*/
    BYTE  byRes2;
    DWORD  dwStorageType;    //by bit 0-not support      none 0-support
    // dwStorageType & 0x1 for common record
    // dwStorageType & 0x2  for drawframe record
    // dwStorageType & 0x4  for picture

    DWORD dwPictureCapacity;  //Hard picture capacity (not set) Unit: MB
    DWORD dwFreePictureSpace; //Remaining the pictures space (not set), unit: MB
    BYTE  byRes3[104];
}NET_DVR_SINGLE_HD, *LPNET_DVR_SINGLE_HD;

typedef struct
{
    DWORD dwSize;
    DWORD dwHDCount;                               //Number of Disk (Read only)
    NET_DVR_SINGLE_HD struHDInfo[MAX_DISKNUM_V30]; //Reboot Device to take effect
}NET_DVR_HDCFG, *LPNET_DVR_HDCFG;

//Configuration of local Hard Disk
typedef struct
{
    DWORD dwHDNo;         /*Hard Disk No.  (0~MAX_DISKNUM_V30- 1)  */
    DWORD dwCapacity;     /*Capacity (Read only) */
    DWORD dwFreeSpace;    /*Free space (Read only) */
    DWORD dwHdStatus;     /*Disk status (Read only)  0- Normal,  1- Raw,  2- Error,  3- SMART State,  4- Unmatched,  5- Sleep*/
    /* 6 - network hard disk is not online 7 - the virtual disk scalable 10 - hard drive being repaired*/
    /* 11 - hard disk is formatted 12 - hard drive is waiting for formatting 13 - hard uninstalled */
    /*14 - the local hard disk does not exist 15 - (network hard drive being deleted),16-locked, 17-Warning (at any time may become bad disc),
    18-Bad disk (hard disk have been damaged), 19-Hidden disk (abnormal was kicked out of array and a bad sectors, for example), 20-Unauthorized (not testing, need to test the disk in the CVR)
    21-Not formatted on the recording host*/
    BYTE  byHDAttr;       /*0- Default,  1- Redundancy;  2- Read only, , 3- backup, use for CVR,4-NotRW*/
    BYTE  byHDType;          /*0- Local HD,1-ESATA HD,2-NAS HD,3-iSCSI HD 4-Array Virtual Disk,5-SD card,,6-minSAS*/
    BYTE  byDiskDriver;   //The value means its ANSC character, added for IVMS device
    BYTE  byGenusGruop;  //Genus group: 0 - retention, 1- array, 2 - storage pool, 3 - array play set, 4 - an uninitialized, 5 - invalid disk, 6 - regional hot standby, 7 - global hot standby, read-only 
    DWORD dwHdGroup;      //Disk Group  (1- MAX_HD_GROUP)
    BYTE  byRecycling;   //  0:no reuse,1:reuse
    BYTE  bySupportFormatType;    /*only supports byHDType=5(SD card);
                                  bySupportFormatType=0, the device will format the hard disk with its default type.
                                  bySupportFormatType: bit0:0 - representative does not support FAT32 format type, 1 - on behalf of the support;
                                  bySupportFormatType: bit1:0 - representative does not support corruption format type, 1 - on behalf of the support;*/
    BYTE  byFormatType;         /* 0- device default format type,1- specify FAT32 format (byHDType=5(SD card),2- specify EXT4 format (byHDType=5(SD card))*/
    BYTE  byRes2;
    DWORD  dwStorageType;    //by bit 0-not support      none 0-support
    // dwStorageType & 0x1 for common record
    // dwStorageType & 0x2  for drawframe record
    // dwStorageType & 0x4  for picture

    DWORD dwPictureCapacity; //Hard picture capacity (not set) Unit: MB
    DWORD dwFreePictureSpace; //Remaining the pictures space (not set), unit: MB
    BYTE  byDiskLocation[NET_SDK_DISK_LOCATION_LEN/*16*/];//Hard disk location, read-only 
    BYTE  bySupplierName[NET_SDK_SUPPLIER_NAME_LEN/*32*/];//Supplier name, read-only 
    BYTE  byDiskModel[NET_SDK_DISK_MODEL_LEN /*64*/];//Drive model, read-only 
    char  szHDLocateIP[SDK_MAX_IP_LEN];//HDD IP
    BYTE  byRes3[80];
}NET_DVR_SINGLE_HD_V50, *LPNET_DVR_SINGLE_HD_V50;

typedef struct
{
    DWORD dwSize;
    DWORD dwHDCount;          /*Number of Disk (Read only)*/
    NET_DVR_SINGLE_HD_V50 struHDInfoV50[MAX_DISKNUM_V30];
    BYTE  byRes[128];
}NET_DVR_HDCFG_V50, *LPNET_DVR_HDCFG_V50;

typedef struct tagNET_DVR_HARD_DISK_SINGLE_VOLUME_INFO
{
    DWORD  dwSize;
    BYTE  byHDVolumeNo;      /*Hard disk volume ID (not set)*/
    BYTE  byType;       /*Hard disk volume type: 0-video volume 1-archive volume 2-file volume 3-picture volume */
    BYTE  byRes1[2];
    DWORD  dwCapacity;     /*Hard disk volume capacity, unit MB (not set)*/
    DWORD  dwFreeSpace;    /*Hard disk volume the remaining space, the unit MB (not set) */
    BYTE  byHDVolumeName[NET_SDK_DISK_VOLUME_LEN/*36*/];  /*Hard disk volume name (not set)*/
    BYTE  byLoopCover;    /*Whether circulation coverage: 0 - acyclic coverage, 1 - cycle cover (hard disk volume after full cycle cover the old video)*/
    BYTE  byRes[63];
}NET_DVR_HARD_DISK_SINGLE_VOLUME_INFO, *LPNET_DVR_HARD_DISK_SINGLE_VOLUME_INFO;

typedef struct tagNET_DVR_HARD_DISK_VOLUME_INFO
{
    DWORD  dwSize;
    DWORD  dwHDVolumeCount;      //Number of Volume (Read only)
    NET_DVR_HARD_DISK_SINGLE_VOLUME_INFO struSingleVolumeInfo[NET_SDK_MAX_DISK_VOLUME/*33*/];    /*single disk volume information*/
    BYTE  byRes[128];
}NET_DVR_HARD_DISK_VOLUME_INFO, *LPNET_DVR_HARD_DISK_VOLUME_INFO;


//Local Disk Group Configuration
typedef struct tagNET_DVR_SINGLE_HDGROUP_V40
{
    DWORD     dwHDGroupNo;       /*Group NO. (Read only)  1- MAX_HD_GROUP*/
    DWORD      dwRelRecordChan[MAX_CHANNUM_V40];  /*Corresponding Channel of HD Group,*/
    BYTE       byRes[64];
}NET_DVR_SINGLE_HDGROUP_V40, *LPNET_DVR_SINGLE_HDGROUP_V40;

typedef struct tagNET_DVR_HDGROUP_CFG_V40
{
    DWORD      dwSize;
    DWORD     dwMaxHDGroupNum;           /*Total groups (Read only) */
    DWORD     dwCurHDGroupNum;       /*Cur groups (Read only) */
    NET_DVR_SINGLE_HDGROUP_V40 struHDGroupAttr[MAX_HD_GROUP]; //Reboot Device to take effect
    BYTE       byRes[128];
}NET_DVR_HDGROUP_CFG_V40, *LPNET_DVR_HDGROUP_CFG_V40;


//Local Disk Group Configuration
typedef struct
{
    DWORD dwHDGroupNo;        /*Group NO. (Read only)  1- MAX_HD_GROUP*/
    BYTE byHDGroupChans[MAX_CHANNUM_V30];  /*Corresponding Channel of HD Group,  0- Not record in this group, 1- Record in this group*/
    BYTE byRes[8];
}NET_DVR_SINGLE_HDGROUP, *LPNET_DVR_SINGLE_HDGROUP;

typedef struct
{
    DWORD dwSize;
    DWORD dwHDGroupCount;         /*Total groups (Read only) */
    NET_DVR_SINGLE_HDGROUP struHDGroupAttr[MAX_HD_GROUP]; //Reboot Device to take effect
}NET_DVR_HDGROUP_CFG, *LPNET_DVR_HDGROUP_CFG;


//Display Scale Configuration
typedef struct
{
    DWORD dwSize;
    DWORD dwMajorScale;     /* Main Screen  0- No Scale, 1- Scale*/
    DWORD dwMinorScale;     /* AUX Screen   0- No Scale, 1- Scale*/
    DWORD dwRes[2];
}NET_DVR_SCALECFG, *LPNET_DVR_SCALECFG;



//DVR Alarm output (9000 extended) 
typedef struct
{
    DWORD dwSize;
    BYTE sAlarmOutName[NAME_LEN];     /* Name */
    DWORD dwAlarmOutDelay;             /* Alarm Duration (- 1- - Stop manually)  */
    //0- 5 Sec, 1- 10Sec, 2- 30Sec, 3- 1Min, 4- 2Min, 5- 5Min, 6- 10Min, 7- Stop Manually,8-1Sec,9-2Sec,10-3Sec,11-4Sec
    NET_DVR_SCHEDTIME struAlarmOutTime[MAX_DAYS][MAX_TIMESEGMENT_V30]; /* Time Segment for Alarm output */
    BYTE byAlarmOutHandle;            /* 0 deal,1 not deal*/
    BYTE byNormalSatus;            /* 0-open 1-cloae*/
    BYTE byRes[14];
}NET_DVR_ALARMOUTCFG_V30, *LPNET_DVR_ALARMOUTCFG_V30;

//DVR Alarm output
typedef struct
{
    DWORD dwSize;
    BYTE sAlarmOutName[NAME_LEN];     /* Name */
    DWORD dwAlarmOutDelay;     /* Alarm Duration (- 1- - Stop manually)  */
    //0- 5Sec, 1- 10Sec, 2- 30Sec, 3- 1Min, 4- 2Min, 5- 5Min, 6- 10Min, 7- Stop Manually
    NET_DVR_SCHEDTIME struAlarmOutTime[MAX_DAYS][MAX_TIMESEGMENT];  /* Time Segment for Alarm output */
}NET_DVR_ALARMOUTCFG, *LPNET_DVR_ALARMOUTCFG;

//DVR Local Preview (9000 extended) 
typedef struct
{
    DWORD dwSize;
    BYTE byPreviewNumber; //Mode of preview channels, 0- 1 window, 1- 4 windows, 2- 9 windows, 3- 16 windows, 0xff:  largest
    BYTE byEnableAudio; //Preview audio, 0- No, 1- Yes
    WORD wSwitchTime; //duration to switch, 0- disable, 1- 5s, 2- 10s, 3- 20s, 4- 30s, 5- 60s, 6- 120s, 7- 300s
    BYTE bySwitchSeq[MAX_PREVIEW_MODE][MAX_WINDOW_V30]; //Order to switch,  lSwitchSeq[i]==0xff- not used
    BYTE byRes[24];
}NET_DVR_PREVIEWCFG_V30, *LPNET_DVR_PREVIEWCFG_V30;
//DVR Local Preview 
typedef struct
{
    DWORD dwSize;
    BYTE byPreviewNumber; //Number of preview channels, 0- 1 window, 1- 4 windows, 2- 9 windows, 3- 16 windows, 0xff:  largest
    BYTE byEnableAudio; //Preview audio, 0- No, 1- Yes
    WORD wSwitchTime; //duration to switch, 0- disable, 1- 5s, 2- 10s, 3- 20s, 4- 30s, 5- 60s, 6- 120s, 7- 300s
    BYTE bySwitchSeq[MAX_WINDOW]; //Order to switch,  lSwitchSeq[i] 0xff- not used
}NET_DVR_PREVIEWCFG, *LPNET_DVR_PREVIEWCFG;

//DVR video output
typedef struct
{
    WORD wResolution;                                 /* Resolution */
    WORD wFreq;                                     /* Refresh rate */
    DWORD dwBrightness;                             /* Brightness */
}NET_DVR_VGAPARA;

/*
* MATRIX Output Configuration
*/
typedef struct
{
    WORD    wOrder[MAX_ANALOG_CHANNUM];         /* Preview order,  0xff means this channel is disabled */
    WORD    wSwitchTime;                         /* Time to witch */
    BYTE    res[14];
}NET_DVR_MATRIXPARA_V30, *LPNET_DVR_MATRIXPARA_V30;

typedef struct
{
    WORD wDisplayLogo;                         /* Display Channel No. */
    WORD wDisplayOsd;                         /* Display Time */
}NET_DVR_MATRIXPARA;

typedef struct
{
    BYTE byVideoFormat;                     /* Video Standard, 0- PAL, 1- NTSC */
    BYTE byMenuAlphaValue;                     /* the contrast between Menu and background image */
    WORD wScreenSaveTime;                     /* Screen Saver 0- Never, 1- 1Min, 2- 2Min, 3- 5Min, 4- 10Min, 5- 20Min, 6- 30Min */
    WORD wVOffset;                             /* Offset of video output */
    WORD wBrightness;                         /* Brightness*/
    BYTE byStartMode;                         /* Video output mode (0: Menu, 1: Preview) */
    BYTE byEnableScaler;                    /* Enable Scale  (0- Disable,  1- Enable) */
}NET_DVR_VOOUT;

//DVR Video output  (9000 extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_VOOUT struVOOut[MAX_VIDEOOUT_V30];
    NET_DVR_VGAPARA struVGAPara[MAX_VGA_V30];                     /* VGA Parameter */
    NET_DVR_MATRIXPARA_V30 struMatrixPara[MAX_MATRIXOUT];         /* MATRIX Parameter */
    BYTE byRes[16];
}NET_DVR_VIDEOOUT_V30, *LPNET_DVR_VIDEOOUT_V30;

//DVR Video Output
typedef struct
{
    DWORD dwSize;
    NET_DVR_VOOUT struVOOut[MAX_VIDEOOUT];
    NET_DVR_VGAPARA struVGAPara[MAX_VGA];     /* VGA Parameter */
    NET_DVR_MATRIXPARA struMatrixPara;         /* MATRIX Parameter */
}NET_DVR_VIDEOOUT, *LPNET_DVR_VIDEOOUT;



//Single User Parameters (Sub Struct)  (256NVR  extended) 
typedef struct tagNET_DVR_USER_INFO_V40
{
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];     /* Password */
    BYTE byLocalRight[MAX_RIGHT];     /* Local privilege */
    /*
    array 0:  local PTZ control
    array 1:  local manual record
    array 2:  local playback
    array 3:  local configuration
    array 4:  local log & status query
    array 5:  local advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  local parameter check
    array 7:  local analog & IP camera management
    array 8:  local backup
    array 9:  local shut down/reboot
    */

    BYTE byRemoteRight[MAX_RIGHT]; /* remote privilege settings */
    /*
    array 0:  remote PTZ control
    array 1:  remote manual record
    array 2:  remote playback
    array 3:  remote configuration
    array 4:  remote log & status query
    array 5:  remote advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  remote start voice talk
    array 7:  remote preview
    array 8: remote alarm upload to center,  alarm output
    array 9: remote control local output
    array 10: remote serial port control
    array 11:  remote parameter query
    array 12:  remote analog & IP camera management
    array 13:  remote shut down/reboot
    */
    DWORD    dwNetPreviewRight[MAX_CHANNUM_V40];            /* remote preview channel No., Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalRecordRight[MAX_CHANNUM_V40];            /* local record channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetRecordRight[MAX_CHANNUM_V40];            /* remote record channel ,  Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPlaybackRight[MAX_CHANNUM_V40];            /* local playback channel ,Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetPlaybackRight[MAX_CHANNUM_V40];            /* remote record channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPTZRight[MAX_CHANNUM_V40];                /* local PTZ channel ,  Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetPTZRight[MAX_CHANNUM_V40];                /* remote PTZ channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalBackupRight[MAX_CHANNUM_V40];            /* local backup channel, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    NET_DVR_IPADDR struUserIP;         /* User IP  (0 stands for no IP restriction)  */
    BYTE byMACAddr[MACADDR_LEN];     /* MAC */
    BYTE byPriority;                 /* Priority settings ,  0xff-  disable ,  0- low,  1- Mid,  2- High */
    /*
    Low-Default privileges including local/remote playback,  log & status query,  reboot/shut down.
    Mid-Include local/remote PTZ control,  manual record,  voice talk,  playback,  log & status query,  reboot/shut down,  log backup and remote preview.
    High-Administrator
    */
    BYTE    byAlarmOnRight;         // Alarm In guard privileges
    BYTE    byAlarmOffRight;        // Alarm In unguard privileges
    BYTE    byBypassRight;          // Alarm In bypass privileges
    BYTE    byRes1[2];
    BYTE    byPublishRight[MAX_RIGHT];  //Information release proprietary rights
    /*An array of 0: material audit jurisdiction*/
    /*An array of 1: program audit authority*/
    /*An array of 2: schedule audit jurisdiction*/
    /*Array 3: upload material privileges*/
    /*An array of 4: new program permissions*/
    /*An array of 5: new schedule*/
    /*An array of 6: information broadcast rights*/
    /*An array of 7: terminal management authority*/
    /*An array of 8: business intelligence*/
    BYTE    byRes[84];
}NET_DVR_USER_INFO_V40, *LPNET_DVR_USER_INFO_V40;

typedef struct tagNET_DVR_USER_INFO_V51
{
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];     /* Password */
    BYTE byLocalRight[MAX_RIGHT];     /* Local privilege */
    /*
    array 0:  local PTZ control
    array 1:  local manual record
    array 2:  local playback
    array 3:  local configuration
    array 4:  local log & status query
    array 5:  local advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  local parameter check
    array 7:  local analog & IP camera management
    array 8:  local backup
    array 9:  local shut down/reboot
    array 10:  local preview
    */

    BYTE byRemoteRight[MAX_RIGHT]; /* remote privilege settings */
    /*
    array 0:  remote PTZ control
    array 1:  remote manual record
    array 2:  remote playback
    array 3:  remote configuration
    array 4:  remote log & status query
    array 5:  remote advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  remote start voice talk
    array 7:  remote preview
    array 8: remote alarm upload to center,  alarm output
    array 9: remote control local output
    array 10: remote serial port control
    array 11:  remote parameter query
    array 12:  remote analog & IP camera management
    array 13:  remote shut down/reboot
    */
    DWORD    dwNetPreviewRight[MAX_CHANNUM_V40];            /* remote preview channel No., Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalRecordRight[MAX_CHANNUM_V40];            /* local record channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetRecordRight[MAX_CHANNUM_V40];            /* remote record channel ,  Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPlaybackRight[MAX_CHANNUM_V40];            /* local playback channel ,Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetPlaybackRight[MAX_CHANNUM_V40];            /* remote record channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPTZRight[MAX_CHANNUM_V40];                /* local PTZ channel ,  Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetPTZRight[MAX_CHANNUM_V40];                /* remote PTZ channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalBackupRight[MAX_CHANNUM_V40];            /* local backup channel, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPreviewRight[MAX_CHANNUM_V40/*512*/];		/* local preview channel, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    NET_DVR_IPADDR struUserIP;         /* User IP  (0 stands for no IP restriction)  */
    BYTE byMACAddr[MACADDR_LEN];     /* MAC */
    BYTE byPriority;                 /* Priority settings ,  0xff-  disable ,  0- low,  1- Mid,  2- High */
    /*
    Low-Default privileges including local/remote playback,  log & status query,  reboot/shut down.
    Mid-Include local/remote PTZ control,  manual record,  voice talk,  playback,  log & status query,  reboot/shut down,  log backup and remote preview.
    High-Administrator
    */
    BYTE    byAlarmOnRight;         // Alarm In guard privileges
    BYTE    byAlarmOffRight;        // Alarm In unguard privileges
    BYTE    byBypassRight;          // Alarm In bypass privileges
    BYTE    byRes1[2];
    BYTE    byPublishRight[MAX_RIGHT];  //Information release proprietary rights
    /*An array of 0: material audit jurisdiction*/
    /*An array of 1: program audit authority*/
    /*An array of 2: schedule audit jurisdiction*/
    /*Array 3: upload material privileges*/
    /*An array of 4: new program permissions*/
    /*An array of 5: new schedule*/
    /*An array of 6: information broadcast rights*/
    /*An array of 7: terminal management authority*/
    /*An array of 8: business intelligence*/
    DWORD    dwPasswordValidity;   //Password validity, only the administrator user can modify, unit: day, fill in 0 means permanent effective
    BYTE    byKeypadPassword[PASSWD_LEN/*16*/];    //keypad password
    BYTE    byUserOperateType;    //user operate type:1-network user,2-keypad user,3-network user+keypad user
    BYTE    byRes[1007];
}NET_DVR_USER_INFO_V51, *LPNET_DVR_USER_INFO_V51;

typedef struct  tagNET_DVR_USER_V51
{
    DWORD dwSize;
    DWORD dwMaxUserNum;
    NET_DVR_USER_INFO_V51 struUser[MAX_USERNUM_V30];
    char    sloginPassword[PASSWD_LEN/*16*/];
    BYTE     byRes[240];
}NET_DVR_USER_V51, *LPNET_DVR_USER_V51;

typedef struct tagNET_DVR_USER_INFO_V52
{
    BYTE    sUserName[NAME_LEN/*32*/];            /* Username */
    BYTE    sPassword[PASSWD_LEN/*16*/];            /* Password */
    BYTE    byLocalRight[MAX_RIGHT/*32*/];    /* Local privilege */
    /*
    array 0:  local PTZ control
    array 1:  local manual record
    array 2:  local playback
    array 3:  local configuration
    array 4:  local log & status query
    array 5:  local advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  local parameter check
    array 7:  local analog & IP camera management
    array 8:  local backup
    array 9:  local shut down/reboot
    array 10:  local preview
    */
    BYTE    byRemoteRight[MAX_RIGHT/*32*/];/* remote privilege settings */
    /*
    array 0:  remote PTZ control
    array 1:  remote manual record
    array 2:  remote playback
    array 3:  remote configuration
    array 4:  remote log & status query
    array 5:  remote advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  remote start voice talk
    array 7:  remote preview
    array 8: remote alarm upload to center,  alarm output
    array 9: remote control local output
    array 10: remote serial port control
    array 11:  remote parameter query
    array 12:  remote analog & IP camera management
    array 13:  remote shut down/reboot
    */
    DWORD    dwNetPreviewRight[MAX_CHANNUM_V40];            /* remote preview channel No., Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalRecordRight[MAX_CHANNUM_V40];            /* local record channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetRecordRight[MAX_CHANNUM_V40];            /* remote record channel ,  Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPlaybackRight[MAX_CHANNUM_V40];            /* local playback channel ,Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetPlaybackRight[MAX_CHANNUM_V40];            /* remote record channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPTZRight[MAX_CHANNUM_V40];                /* local PTZ channel ,  Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetPTZRight[MAX_CHANNUM_V40];                /* remote PTZ channel , Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalBackupRight[MAX_CHANNUM_V40];            /* local backup channel, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalPreviewRight[MAX_CHANNUM_V40/*512*/];		/* local preview channel, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalDoubleVerificationPlaybackRight[MAX_CHANNUM_V40/*512*/];            /* local double verification playback, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwLocalDoubleVerificationBackupRight[MAX_CHANNUM_V40/*512*/];            /* local double verification backup, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    DWORD    dwNetDoubleVerificationPlaybackRight[MAX_CHANNUM_V40/*512*/];            /* remote double verification playback, Front to back order, met 0xFFFFFFFF follow-up are invalid*/
    NET_DVR_IPADDR    struUserIP;                /* User IP  (0 stands for no IP restriction)  */
    BYTE     byMACAddr[MACADDR_LEN/*6*/];    /* MAC */
    BYTE     byPriority;                /* Priority settings ,  0xff-  disable ,  0- low,  1- Mid,  2- High */
    /*
    Low-Default privileges including local/remote playback,  log & status query,  reboot/shut down.
    Mid-Include local/remote PTZ control,  manual record,  voice talk,  playback,  log & status query,  reboot/shut down,  log backup and remote preview.
    High-Administrator
    */
    BYTE    byAlarmOnRight;         // Alarm In guard privileges
    BYTE    byAlarmOffRight;        // Alarm In unguard privileges
    BYTE    byBypassRight;          // Alarm In bypass privileges
    BYTE    byRes1[2];
    BYTE    byPublishRight[MAX_RIGHT];  //Information release proprietary rights
    /*An array of 0: material audit jurisdiction*/
    /*An array of 1: program audit authority*/
    /*An array of 2: schedule audit jurisdiction*/
    /*Array 3: upload material privileges*/
    /*An array of 4: new program permissions*/
    /*An array of 5: new schedule*/
    /*An array of 6: information broadcast rights*/
    /*An array of 7: terminal management authority*/
    /*An array of 8: business intelligence*/
    DWORD    dwPasswordValidity;   //Password validity, only the administrator user can modify, unit: day, fill in 0 means permanent effective
    BYTE    byKeypadPassword[PASSWD_LEN/*16*/];    //keypad password
    BYTE    byUserOperateType;    //user operate type:1-network user,2-keypad user,3-network user+keypad user
    BYTE    byRes[1007];
}NET_DVR_USER_INFO_V52, *LPNET_DVR_USER_INFO_V52;

typedef struct  tagNET_DVR_USER_V52
{
    DWORD dwSize;
    DWORD dwMaxUserNum;
    NET_DVR_USER_INFO_V52 struUser[MAX_USERNUM_V30/*32*/];
    char    sloginPassword[PASSWD_LEN/*16*/];
    BYTE     byRes[240];
}NET_DVR_USER_V52, *LPNET_DVR_USER_V52;


//Single User Parameters (Sub Struct)  (9000 extended) 
typedef struct
{
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];     /* Password */
    BYTE byLocalRight[MAX_RIGHT];     /* Local privilege */
    /*
    array 0:  local PTZ control
    array 1:  local manual record
    array 2:  local playback
    array 3:  local configuration
    array 4:  local log & status query
    array 5:  local advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  local parameter check
    array 7:  local analog & IP camera management
    array 8:  local backup
    array 9:  local shut down/reboot
    */

    BYTE byRemoteRight[MAX_RIGHT]; /* remote privilege settings */
    /*
    array 0:  remote PTZ control
    array 1:  remote manual record
    array 2:  remote playback
    array 3:  remote configuration
    array 4:  remote log & status query
    array 5:  remote advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6:  remote start voice talk
    array 7:  remote preview
    array 8: remote alarm upload to center,  alarm output
    array 9: remote control local output
    array 10: remote serial port control
    array 11:  remote parameter query
    array 12:  remote analog & IP camera management
    array 13:  remote shut down/reboot
    */
    BYTE byNetPreviewRight[MAX_CHANNUM_V30];         /* remote preview channel ,  0- enable,  1- disable*/
    BYTE byLocalPlaybackRight[MAX_CHANNUM_V30];         /* local playback channel ,  0- enable,  1- disable*/
    BYTE byNetPlaybackRight[MAX_CHANNUM_V30];         /* remote playback channel ,  0- enable,  1- disable*/
    BYTE byLocalRecordRight[MAX_CHANNUM_V30];         /* local record channel ,  0- enable,  1- disable*/
    BYTE byNetRecordRight[MAX_CHANNUM_V30];         /* remote record channel ,  0- enable,  1- disable*/
    BYTE byLocalPTZRight[MAX_CHANNUM_V30];         /* local PTZ channel ,  0- enable,  1- disable*/
    BYTE byNetPTZRight[MAX_CHANNUM_V30];             /* remote PTZ channel ,  0- enable,  1- disable*/
    BYTE byLocalBackupRight[MAX_CHANNUM_V30];         /* local backup channel ,  0- enable,  1- disable*/
    NET_DVR_IPADDR struUserIP;         /* User IP  (0 stands for no IP restriction)  */
    BYTE byMACAddr[MACADDR_LEN];     /* MAC */
    BYTE byPriority;                 /* Priority settings ,  0xff-  disable ,  0- low,  1- Mid,  2- High */
    /*
    Low-Default privileges including local/remote playback,  log & status query,  reboot/shut down.
    Mid-Include local/remote PTZ control,  manual record,  voice talk,  playback,  log & status query,  reboot/shut down,  log backup and remote preview.
    High-Administrator
    */
    BYTE    byAlarmOnRight;         // Alarm In guard privileges
    BYTE    byAlarmOffRight;        // Alarm In unguard privileges
    BYTE    byBypassRight;          // Alarm In bypass privileges
    BYTE    byRes[14];
}NET_DVR_USER_INFO_V30, *LPNET_DVR_USER_INFO_V30;

//Single User Parameters (SDK_V15extended)  (Sub Structure) 
typedef struct
{
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];     /* Password */
    DWORD dwLocalRight[MAX_RIGHT];     /* privilege */
    /*
    array 0- local PTZ control
    array 1- local manual record
    array 2- local playback
    array 3- local configuration
    array 4- local log & status query
    array 5- local advanced settings  (upgrade,  format,  reboot,  shut down)
    */
    DWORD dwLocalPlaybackRight;         /*  local playback channel. 1 bit0 - -  channel 1*/
    DWORD dwRemoteRight[MAX_RIGHT];     /* privilege */
    /*
    array 0- remote  PTZ control
    array 1- remote manual record
    array 2- remote playback
    array 3- remote configuration
    array 4- remote log & status query
    array 5- remote advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6- remote start voice talk
    array 7- remote preview
    array 8- remote alarm upload to center,  alarm output
    array 9- remote control local output
    array 10- remote serial port control
    */
    DWORD dwNetPreviewRight;         /* remote preview channel number,  bit0 - -  channel 1*/
    DWORD dwNetPlaybackRight;         /* remote playback channel number,  bit0 - -  channel 1*/
    char sUserIP[16];                 /* User IP  (0 stands for no IP restriction)  */
    BYTE byMACAddr[MACADDR_LEN];     /* MAC */
}NET_DVR_USER_INFO_EX, *LPNET_DVR_USER_INFO_EX;

//Single User Parameters (Sub Structure) 
typedef struct
{
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];     /* Password */
    DWORD dwLocalRight[MAX_RIGHT];     /* privilege */
    /*
    array 0- local PTZ control
    array 1- local manual record
    array 2- local playback
    array 3- local configuration
    array 4- local log & status query
    array 5- local advanced settings  (upgrade,  format,  reboot,  shut down)
    */
    DWORD dwRemoteRight[MAX_RIGHT]; /* privilege */
    /*
    array 0- remote  PTZ control
    array 1- remote manual record
    array 2- remote playback
    array 3- remote configuration
    array 4- remote log & status query
    array 5- remote advanced settings  (upgrade,  format,  reboot,  shut down)
    array 6- remote start voice talk
    array 7- remote preview
    array 8- remote alarm upload to center,  alarm output
    array 9- remote control local output
    array 10- remote serial port control
    */
    char sUserIP[16];                 /* User IP  (0 stands for no IP restriction)  */
    BYTE byMACAddr[MACADDR_LEN];     /* MAC */
}NET_DVR_USER_INFO, *LPNET_DVR_USER_INFO;


//DVR User Parameters (256 NVR extended)
typedef struct  tagNET_DVR_USER_V40
{
    DWORD dwSize;
    DWORD dwMaxUserNum;
    NET_DVR_USER_INFO_V40 struUser[MAX_USERNUM_V30];
}NET_DVR_USER_V40, *LPNET_DVR_USER_V40;
typedef struct  tagNET_DVR_USER_V50
{
    DWORD dwSize;
    DWORD dwMaxUserNum;
    NET_DVR_USER_INFO_V40 struUser[MAX_USERNUM_V30];
    char    sloginPassword[PASSWD_LEN/*16*/];
    BYTE     byRes[240];
}NET_DVR_USER_V50, *LPNET_DVR_USER_V50;
//DVR User Parameters (9000extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_USER_INFO_V30 struUser[MAX_USERNUM_V30];
}NET_DVR_USER_V30, *LPNET_DVR_USER_V30;

//DVR User Parameters (SDK_V15extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_USER_INFO_EX struUser[MAX_USERNUM];
}NET_DVR_USER_EX, *LPNET_DVR_USER_EX;

//DVR User Parameters
typedef struct
{
    DWORD dwSize;
    NET_DVR_USER_INFO struUser[MAX_USERNUM];
}NET_DVR_USER, *LPNET_DVR_USER;

//DVR Exception Parameters (256NVR extended)
typedef struct tagNET_DVR_EXCEPTION_V40
{
    DWORD             dwSize;
    DWORD             dwMaxGroupNum;
    NET_DVR_HANDLEEXCEPTION_V41 struExceptionHandle[MAX_EXCEPTIONNUM_V30];
    BYTE                byRes[128];
}NET_DVR_EXCEPTION_V40, *LPNET_DVR_EXCEPTION_V40;

//DVR Exception Parameters (9000extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_HANDLEEXCEPTION_V30 struExceptionHandleType[MAX_EXCEPTIONNUM_V30];
    /*array 0-  hard disk is full,  1-  hard disk error,  2-  signal lost,  3-  network link is broken,  4- illegal access,  5-  input/output video standard not match,  6- overspeed Car (for mobile DVR) ,  7- record exception 8-raid exception 9-resolusion mismatch 10-speed exceed 11-spare exception\
    12-temperature abnormal, 13-subsystem abnormal, 14-fan abnormal, , 15-POE Power Exception*/
}NET_DVR_EXCEPTION_V30, *LPNET_DVR_EXCEPTION_V30;

//DVR Exception Parameters
typedef struct
{
    DWORD dwSize;
    NET_DVR_HANDLEEXCEPTION struExceptionHandleType[MAX_EXCEPTIONNUM];
    /*array 0-  hard disk is full,  1-  hard disk error,  2-  signal lost,  3-  network link is broken,  4- illegal access,  5-  input/output video standard not match,  6- overspeed Car (for mobile DVR) */
}NET_DVR_EXCEPTION, *LPNET_DVR_EXCEPTION;

//Channel State (9000 extended) 
typedef struct
{
    BYTE byRecordStatic;  //whether the channel is in recording,  0-  no,  1-  yes
    BYTE bySignalStatic;  //video signal status,  0-  normal,  1-  lost
    BYTE byHardwareStatic; //the channel hardware status,  0-  normal,  1-  abnormal,  e.g. DSP is not work
    BYTE byRes1;         //Reserved
    DWORD dwBitRate;     //actual bit rate
    DWORD dwLinkNum;     //connected client number
    NET_DVR_IPADDR struClientIP[MAX_LINK]; //client IP referred to NET_DVR_IPADDR
    DWORD dwIPLinkNum; //if the current channel is set as IPC channel,  then this parameter represents the current connected IP channel number.
    BYTE byExceedMaxLink;   // 0-less than 6 link, 1 more than 6 link
    BYTE byRes[3];
    DWORD dwAllBitRate;      //All Bit Rate
    DWORD dwChannelNo;    //cur chanNo, 0xffffffff  is  invalid
}NET_DVR_CHANNELSTATE_V30, *LPNET_DVR_CHANNELSTATE_V30;

//Channel State
typedef struct
{
    BYTE byRecordStatic;        //Whether the channel is in recording,  0-  no,  1-  yes
    BYTE bySignalStatic;        //Video signal status,  0-  normal,  1-  lost
    BYTE byHardwareStatic;      //The channel hardware status,  0-  normal,  1-  abnormal,  e.g. DSP is not work
    char reservedData;             //Reserved
    DWORD dwBitRate;             //Actual bit rate
    DWORD dwLinkNum;             //Connected client number
    DWORD dwClientIP[MAX_LINK]; //Client IP
}NET_DVR_CHANNELSTATE, *LPNET_DVR_CHANNELSTATE;

//Hard Disk Status
typedef struct
{
    DWORD dwVolume; //Capacity
    DWORD dwFreeSpace; //Free Space
    DWORD dwHardDiskStatic;  //HD status: 0- active; 1- sleep mode; 2- abnormal;  3-  sleep mode error, 4-not format, 5- can't connect(net disk) 6- being formating.
}NET_DVR_DISKSTATE, *LPNET_DVR_DISKSTATE;

//DVR Work State (256 NVR extended)
typedef struct tagNET_DVR_WORKSTATE_V40
{
    DWORD   dwSize;
    DWORD   dwDeviceStatic;      //the device's status,  0-  normal,  1-  the occupancy of CPU is too high,  more than 85%,  2- hardware error,  e.g. the serial ports do not work
    NET_DVR_DISKSTATE  struHardDiskStatic[MAX_DISKNUM_V30];
    NET_DVR_CHANNELSTATE_V30 struChanStatic[MAX_CHANNUM_V40/*512*/];//chan Status
    DWORD   dwHasAlarmInStatic[MAX_ALARMIN_V40/*512*/];
    DWORD   dwHasAlarmOutStatic[MAX_ALARMOUT_V40/*512*/];
    DWORD   dwLocalDisplay;         //Local display status,  0-  normal,  1- abnormal
    BYTE    byAudioInChanStatus[MAX_AUDIO_V30/*2*/];//Audio channel status,  0- unused;  1- on using; 0xff- invalid
    BYTE    byRes1[2];
    float    fHumidity;    //0.0 ~ 100.0
    float    fTemperature;    //-20.0 ~ 90.0
    BYTE    byRes[116];
}NET_DVR_WORKSTATE_V40, *LPNET_DVR_WORKSTATE_V40;


typedef struct tagNET_DVR_GETWORKSTATE_COND
{
    DWORD   dwSize;
    BYTE    byFindHardByCond; /*0-find all Hard */
    BYTE    byFindChanByCond;  /*0-find All Chan,and The dwFindChanNum is invalid, else The dwFindChanNum is valid*/
    BYTE    byRes1[2];
    DWORD   dwFindHardStatus[MAX_DISKNUM_V30/*33*/]; /*To find the hard disk No. , according to the values, the values of the order, met 0xFFFFFFFF that subsequent invalid */
    DWORD   dwFindChanNo[MAX_CHANNUM_V40/*512*/]; /*To find the Chan No. ,according to the values,,according to the values, the values of the order, met 0xFFFFFFFF that subsequent invalid */
    BYTE     byRes[64];
}NET_DVR_GETWORKSTATE_COND, *LPNET_DVR_GETWORKSTATE_COND;

//DVR Work State (9000 extended) 
typedef struct
{
    DWORD dwDeviceStatic;      //the device's status,  0-  normal,  1-  the occupancy of CPU is too high,  more than 85%,  2- hardware error,  e.g. the serial ports do not work
    NET_DVR_DISKSTATE  struHardDiskStatic[MAX_DISKNUM_V30];
    NET_DVR_CHANNELSTATE_V30 struChanStatic[MAX_CHANNUM_V30]; //channel status  as NET_DVR_CHANNELSTATE
    BYTE  byAlarmInStatic[MAX_ALARMIN_V30];  //alarm input status,  0-  no alarm,  1- alarm
    BYTE  byAlarmOutStatic[MAX_ALARMOUT_V30];  //alarm output status,  0- no output,  1- alarm output
    DWORD  dwLocalDisplay; //Local display status,  0-  normal,  1- abnormal
    BYTE  byAudioChanStatus[MAX_AUDIO_V30]; //Audio channel status,  0- unused;  1- on using; 0xff- invalid
    BYTE  byRes[10];
}NET_DVR_WORKSTATE_V30, *LPNET_DVR_WORKSTATE_V30;

//DVR Status Structure 
typedef struct
{
    DWORD dwDeviceStatic;      //the device's status,  0-  normal,  1-  the occupancy of CPU is too high,  more than 85%,  2- hardware error,  e.g. the serial ports do not work
    NET_DVR_DISKSTATE  struHardDiskStatic[MAX_DISKNUM];
    NET_DVR_CHANNELSTATE struChanStatic[MAX_CHANNUM]; //channel status  as NET_DVR_CHANNELSTATE
    BYTE  byAlarmInStatic[MAX_ALARMIN];             //alarm input status,  0-  no alarm,  1- alarm
    BYTE  byAlarmOutStatic[MAX_ALARMOUT];         //alarm output status,  0- no output,  1- alarm output
    DWORD  dwLocalDisplay;                         //Local display status,  0-  normal,  1- abnormal
}NET_DVR_WORKSTATE, *LPNET_DVR_WORKSTATE;



/************************ Alarm-host log searching begin************************************************/
typedef struct tagNET_DVR_ALARMHOST_SEARCH_LOG_PARAM
{
    WORD            wMajorType;        // Major type
    WORD            wMinorType;        // Minor type 
    NET_DVR_TIME    struStartTime;    // Start time 
    NET_DVR_TIME    struEndTime;    // End time
    BYTE            byRes[8];        // Reserved
}NET_DVR_ALARMHOST_SEARCH_LOG_PARAM, LPNET_DVR_ALARMHOST_SEARCH_LOG_PARAM;

typedef struct tagNET_DVR_ALARMHOST_LOG_RET
{
    NET_DVR_TIME    struLogTime;                // Log time
    BYTE            sUserName[NAME_LEN];        // Operator user
    NET_DVR_IPADDR    struIPAddr;                 // Operator IP address
    WORD            wMajorType;                 // Major type 
    WORD            wMinorType;                 // Minor type
    WORD            wParam;                        // Operation parameter
    BYTE            byRes[10];
    DWORD            dwInfoLen;                    // Length of description information
    char            sInfo[LOG_INFO_LEN];        // Description information
}NET_DVR_ALARMHOST_LOG_RET, *LPNET_DVR_ALARMHOST_LOG_RET;

/************************* Alarm-host log searching end***********************************************/

//Alarm output state (9000 extended) 
typedef struct
{
    BYTE Output[MAX_ALARMOUT_V30];
}NET_DVR_ALARMOUTSTATUS_V30, *LPNET_DVR_ALARMOUTSTATUS_V30;

//Alarm output state
typedef struct
{
    BYTE Output[MAX_ALARMOUT];
}NET_DVR_ALARMOUTSTATUS, *LPNET_DVR_ALARMOUTSTATUS;

//Transaction Info
typedef struct
{
    USHORT m_Year;
    USHORT m_Month;
    USHORT m_Day;
    USHORT m_Hour;
    USHORT m_Minute;
    USHORT m_Second;
    BYTE DeviceName[24];     //Device name
    DWORD dwChannelNumer;     //Channel name
    BYTE CardNumber[32];     //Credit Card No.
    char cTradeType[12];     //Transaction type    
    DWORD dwCash;             //Transaction money 
}NET_DVR_TRADEINFO, *LPNET_DVR_TRADEINFO;


//Special for ATM
/****************************ATM (begin) ***************************/
#define NCR                0
#define DIEBOLD            1
#define WINCOR_NIXDORF    2
#define SIEMENS            3
#define OLIVETTI        4
#define FUJITSU            5
#define HITACHI            6
#define SMI                7
#define IBM                8
#define BULL            9
#define YiHua            10
#define LiDe            11
#define GDYT            12
#define Mini_Banl        13
#define GuangLi            14
#define DongXin            15
#define ChenTong        16
#define NanTian            17
#define XiaoXing        18
#define GZYY            19
#define QHTLT            20
#define DRS918            21
#define KALATEL            22
#define NCR_2            23    
#define NXS                24


/*Frame Type*/
typedef struct
{
    BYTE code[12];         /* code */
}NET_DVR_FRAMETYPECODE;

//ATM Parameters
typedef struct
{
    DWORD dwSize;
    char sATMIP[16];                             /* ATM IP */
    DWORD dwATMType;                             /* ATM Type*/
    DWORD    dwInputMode;                         /* 0-  network listening 1- network receive; 2-directly input via serial port; 3-input ATM command via serial port*/
    DWORD    dwFrameSignBeginPos;                 /* the start position of Message flag*/
    DWORD    dwFrameSignLength;                     /* the length of Message flag */
    BYTE    byFrameSignContent[12];             /* the content of Message flag */
    DWORD    dwCardLengthInfoBeginPos;             /* offset of credit card No. length information */
    DWORD    dwCardLengthInfoLength;             /* the length of the card length information */
    DWORD    dwCardNumberInfoBeginPos;             /* Start position of the card number information */
    DWORD    dwCardNumberInfoLength;             /* Length of the card number information */
    DWORD    dwBusinessTypeBeginPos;             /* the offset of operation type information */
    DWORD    dwBusinessTypeLength;                 /* the length of the operation type */
    NET_DVR_FRAMETYPECODE    frameTypeCode[10];     /* type */
}NET_DVR_FRAMEFORMAT, *LPNET_DVR_FRAMEFORMAT;

//SDK_V31 ATM
/*1.1.1.18    Structure of package filter*/
typedef struct    tagNET_DVR_FILTER
{
    BYTE                    byEnable;             //0,  disable;  1,  enable
    BYTE                    byMode;             //0, ASCII; 1, HEX    
    BYTE                    byFrameBeginPos;    //begin position of target text  
    BYTE                    byRes;           //Reserved
    BYTE                     byFilterText[16];     //filter text
    BYTE                    byRes2[12];         //Reserved
}NET_DVR_FILTER, *LPNET_DVR_FILTER;

//Package structure of starting flag
typedef struct    tagNET_DVR_IDENTIFICAT
{
    BYTE                    byStartMode;         //start mode: 0, ASCII; 1, HEX
    BYTE                    byEndMode;             //end mode:  0, ASCII; 1, HEX
    BYTE                    byRes[2];           //Reserved
    NET_DVR_FRAMETYPECODE    struStartCode;         //start code
    NET_DVR_FRAMETYPECODE    struEndCode;         //end code
    BYTE                    byRes1[12];         //Reserved
}NET_DVR_IDENTIFICAT, *LPNET_DVR_IDENTIFICAT;

typedef struct    tagNET_DVR_PACKAGE_LOCATION/* package information position*/
{
    BYTE                     byOffsetMode;             /* 0, token (character flag mode) ; 1, fix (fix mode) */
    BYTE                    byRes1[3];                 // Reserved
    DWORD                      dwOffsetPos;             /*Used when mode is 1,  offset size*/
    NET_DVR_FRAMETYPECODE    struTokenCode;             /*Flag bit*/
    BYTE                    byMultiplierValue;         /*number of Flags*/
    BYTE                    byEternOffset;             /*extern offset*/
    BYTE                    byCodeMode;             /*0, ASCII; 1, HEX*/
    BYTE                     byRes2[9];                 //Reserved
}NET_DVR_PACKAGE_LOCATION, *LPNET_DVR_PACKAGE_LOCATION;


typedef struct    tagNET_DVR_PACKAGE_LENGTH//package length
{
    BYTE                    byLengthMode;             //length mode:  0,  variable;  1,  fixed ; 2, gotten from package (Used when setting the card number length ) 
    BYTE                    byRes1[3];              // Reserved
    DWORD                      dwFixLength;             //Used when mode is 1,  fixed length
    DWORD                    dwMaxLength;            //Maximum length  byLengthMode is 0 
    DWORD                    dwMinLength;            //Minimum length  byLengthMode is 0
    BYTE                    byEndMode;                 //Terminator:  0, ASCII; 1, HEX    
    BYTE                    byRes2[3];              //Reserved
    NET_DVR_FRAMETYPECODE    struEndCode;             //Terminator with variable length
    DWORD                    dwLengthPos;             //Used when length mode is 2,  card length position in the package
    DWORD                    dwLengthLen;             //Used when length mode is 2,  length of the card number length
    BYTE                    byRes3[8];              // Reserved
}NET_DVR_PACKAGE_LENGTH, *LPNET_DVR_PACKAGE_LENGTH;

typedef struct    tagNET_DVR_OSD_POSITION//OSD overlay position
{
    BYTE                    byPositionMode;         //Mode,  0:  not display,  1: Custom
    BYTE                    byRes1[3];              // Reserved
    DWORD                     dwPosX;                 //X- coordinator,  used when position mode is custom
    DWORD                    dwPosY;                 //Y- coordinator,  used when position mode is custom
    BYTE                    byRes2[8];              //Reserved
}NET_DVR_OSD_POSITION, *LPNET_DVR_OSD_POSITION;

typedef struct    tagNET_DVR_DATE_FORMAT//date display format
{
    BYTE                    byMonth;                 //Month, 0-mm; 1-mmm; 2-mmmm                            
    BYTE                     byDay;                     //Day, 0-dd;                                     
    BYTE                     byYear;                 //Year, 0-yy; 1-yyyy    
    BYTE                    byDateForm;             //0-5,  permutations and combinations of year, month, day
    BYTE                    byRes[20];              // Reserved
    char                    chSeprator[4];             //separator
    char                    chDisplaySeprator[4];     //display separator
    BYTE                    byDisplayForm;             //0-5, permutations and combinations of 3 items
    BYTE                    res[27];                // Reserved
}NET_DVR_DATE_FORMAT, *LPNET_DVR_DATE_FORMAT;
typedef struct    tagNET_DVRT_TIME_FORMAT//time display format
{
    BYTE                    byTimeForm;             //1. HH MM SS; 0. HH MM
    BYTE                     byRes1[23];             // Reserved
    BYTE                    byHourMode;             //0, 12; 1, 24 
    BYTE                    byRes2[3];              // Reserved
    char                    chSeprator[4];          //package separator,  reserved
    char                    chDisplaySeprator[4];     //display separator
    BYTE                    byDisplayForm;             //0~5,  permutations and combinations  of 3 items
    BYTE                    byRes3[3];              // Reserved
    BYTE                    byDisplayHourMode;         //0-12;  1- 24 
    BYTE                    byRes4[19];             // Reserved
}NET_DVR_TIME_FORMAT, *LPNET_DVR_TIME_FORMAT;

typedef struct tagNET_DVR_OVERLAY_CHANNEL
{
    BYTE                    byChannel[64]; //overlay channel,  Set 1 to display,  set 0 to hide
    DWORD                    dwDelayTime;             //overlay delay time
    BYTE                    byEnableDelayTime;         //enable or disable. Overlay delay is enabled,  in the absence of withdrawal card command 
    BYTE                    byRes[11];           // Reserved
}NET_DVR_OVERLAY_CHANNEL, *LPNET_DVR_OVERLAY_CHANNEL;

// Structure of Trading action
typedef struct tagNET_DVR_ATM_PACKAGE_ACTION
{
    NET_DVR_PACKAGE_LOCATION    struPackageLocation; // location of package
    NET_DVR_OSD_POSITION        struOsdPosition;     // OSD overlay position
    NET_DVR_FRAMETYPECODE        struActionCode;         //codes of trading type
    NET_DVR_FRAMETYPECODE        struPreCode;         //character before overlaying
    BYTE                    byActionCodeMode;         //codes of trading type. 0, ASCII; 1, HEX
    BYTE                    byRes[7];                // Reserved
}NET_DVR_ATM_PACKAGE_ACTION, *LPNET_DVR_ATM_PACKAGE_ACTION;

//  Date info of ATM package
typedef struct tagNET_DVR_ATM_PACKAGE_DATE
{
    NET_DVR_PACKAGE_LOCATION    struPackageLocation; // Position of date
    NET_DVR_DATE_FORMAT            struDateForm;         //date display mode
    NET_DVR_OSD_POSITION        struOsdPosition;     // OSD overly position
    BYTE                        res[8];              // Reserved
}NET_DVR_ATM_PACKAGE_DATE, *LPNET_DVR_ATM_PACKAGE_DATE;


//Time info of ATM package
typedef struct tagNET_DVR_ATM_PACKAGE_TIME
{
    NET_DVR_PACKAGE_LOCATION    location;         // Position of time
    NET_DVR_TIME_FORMAT            struTimeForm;     //display mode
    NET_DVR_OSD_POSITION        struOsdPosition; // OSD overly position
    BYTE                        byRes[8];         // Reserved
}NET_DVR_ATM_PACKAGE_TIME, *LPNET_DVR_ATM_PACKAGE_TIME;


//other info of  ATM package (Card SN.,  Transaction amount,  Transaction SN.) 
typedef struct tagNET_DVR_ATM_PACKAGE_OTHERS
{
    NET_DVR_PACKAGE_LOCATION    struPackageLocation;  //Position info
    NET_DVR_PACKAGE_LENGTH    struPackageLength;         //length Info
    NET_DVR_OSD_POSITION        struOsdPosition;     //overlay position
    NET_DVR_FRAMETYPECODE        struPreCode;         //character before overlaying
    BYTE                    res[8];                     //Reserved
}NET_DVR_ATM_PACKAGE_OTHERS, *LPNET_DVR_ATM_PACKAGE_OTHERS;


//User- defined Protocol
typedef struct tagNET_DVR_ATM_USER_DEFINE_PROTOCOL
{
    NET_DVR_IDENTIFICAT        struIdentification;   //Package Flag
    NET_DVR_FILTER             struFilter;  //Filter settings
    NET_DVR_ATM_PACKAGE_OTHERS struCardNoPara;  // Settings of overlay card number 
    NET_DVR_ATM_PACKAGE_ACTION struTradeActionPara[MAX_ACTION_TYPE];  //Settings of overlay trade action, 0- 9: InCard,  OutCard,  OverLay,  SetTime,  GetStatus,  Query,  WithDraw,  Deposit,  ChanPass,  Transfer
    NET_DVR_ATM_PACKAGE_OTHERS struAmountPara;  //Settings of overlay Transaction amount
    NET_DVR_ATM_PACKAGE_OTHERS struSerialNoPara;  //Settings of overlay trade SN
    NET_DVR_OVERLAY_CHANNEL    struOverlayChan;  //Settings of overlay channel
    NET_DVR_ATM_PACKAGE_DATE   struRes1;  //Settings of overlay data,  reserved
    NET_DVR_ATM_PACKAGE_TIME   struRes2;  //Settings of overlay time,  reserved
    BYTE                       byRes3[124];         //Reserved
}NET_DVR_ATM_USER_DEFINE_PROTOCOL, *LPNET_DVR_ATM_USER_DEFINE_PROTOCOL;

typedef struct tagNET_DVR_ATM_FRAMEFORMAT_V30
{
    DWORD                        dwSize;                 //structure size
    BYTE                        byEnable;                 /*0:  Enable,  1:  Disable*/
    BYTE                        byInputMode;             /*Input mode:  0- Network Listen,  1- Network Protocol,  2- Serial Listen,  3- Serial Protocol*/
    BYTE                        byRes1[34];              //Reserved 
    NET_DVR_IPADDR                struAtmIp;                 /*ATM IP,  used in network listen mode */
    WORD                        wAtmPort;                 /* Get port by card number,  Network Protocol mode or Serial server port mode*/
    BYTE                        byRes2[2];               // Reserved
    DWORD                        dwAtmType;                 /*ATM protocol type,  get from NET_DVR_ATM_PROTOCOL,  using user- defined protocol when the type is user_defined*/
    NET_DVR_ATM_USER_DEFINE_PROTOCOL   struAtmUserDefineProtocol;  //User- defined protocol,  using this definition when the ATM protocol is user- defined.
    BYTE                        byRes3[8];
}NET_DVR_ATM_FRAMEFORMAT_V30, *LPNET_DVR_ATM_FRAMEFORMAT_V30;

//ATM protocol type
typedef enum _ATM_PROTO_TYPE_
{
    ATM_PROTO_NCR = 0,//NCR
    ATM_PROTO_DIEBOLD = 1,//DIEBOLD
    ATM_PROTO_WINCOR_NIXDORF = 2,//WINCOR-NIXDORF
    ATM_PROTO_SIEMENS = 4,//SIEMENS
    ATM_PROTO_OLIVETTI = 5,//OLIVETTI
    ATM_PROTO_FUJITSU = 6,//FUJITSU
    ATM_PROTO_HITACHI = 7,//HITACHI
    ATM_PROTO_SMI = 8,//SMI
    ATM_PROTO_BULL = 9,//BULL
    ATM_PROTO_YIHUA = 10,//YIHUA
    ATM_PROTO_LIDE = 11,//LIDE
    ATM_PROTO_GDYT = 12,//GDYT
    ATM_PROTO_MINI_BANL = 13,//Mini-Banl
    ATM_PROTO_GUANGLI = 14,//GUANGLI
    ATM_PROTO_DONGXIN = 15,//DONGXIN
    ATM_PROTO_CHENTONG = 16,//CHENTONG
    ATM_PROTO_NANTIAN = 17,//NANTIAN
    ATM_PROTO_XIAOXING = 18,//XIAOXING
    ATM_PROTO_GZYY = 19,//GZYY
    ATM_PROTO_QHTLT = 20,//QHTLT
    ATM_PROTO_DRS918 = 21,//DRS918 
    ATM_PROTO_KALATEL = 22,//KALATEL 
    ATM_PROTO_NCR_2 = 23,//NCR_2
    ATM_PROTO_NXS = 24,//NXS
    ATM_PROTO_ICBC = 25,//ICBC
    ATM_PROTO_PSBC = 26,//PSBC
    ATM_PROTO_CUSTOM = 1025//CUSTOM
}ATM_PROTO_TYPE;

typedef struct  tagNET_DVR_ATM_PROTO_TYPE
{
    DWORD dwAtmType;  //ATM protocol type,  index SN,  and 1025 is for user- defined.
    char chDesc[ATM_DESC_LEN];  //Simple description of ATM protocol
}NET_DVR_ATM_PROTO_TYPE, *LPNET_DVR_ATM_PROTO_TYPE;  //Data structure of protocol information

typedef struct tagNET_DVR_ATM_PROTO_LIST    //ATM Protocol List
{
    DWORD                  dwAtmProtoNum;    // Number of protocol 
    NET_DVR_ATM_PROTO_TYPE struAtmProtoType[MAX_ATM_PROTOCOL_NUM];  //protocol list info
}NET_DVR_ATM_PROTO_LIST, *LPNET_DVR_ATM_PROTO_LIST;

typedef struct tagNET_DVR_ATM_PROTOCOL
{
    DWORD dwSize;
    NET_DVR_ATM_PROTO_LIST struNetListenList;  // Description of Network Listen protocol
    NET_DVR_ATM_PROTO_LIST struSerialListenList;  //Description of Serial Listen protocol
    NET_DVR_ATM_PROTO_LIST struNetProtoList;      //Description of Network protocol
    NET_DVR_ATM_PROTO_LIST struSerialProtoList;    //Description of Serial Protocol
    NET_DVR_ATM_PROTO_TYPE struCustomProto;         //User- defined protocol
}NET_DVR_ATM_PROTOCOL, *LPNET_DVR_ATM_PROTOCOL;
//SDK_V31

/*****************************DS- 6001D/F (begin) ***************************/
//DS- 6001D Decoder
typedef struct
{
    BYTE byEncoderIP[16];         //Server IP that decoder connected
    BYTE byEncoderUser[16];         //Server Username that decoder connected
    BYTE byEncoderPasswd[16];     //Server Password that decoder connected
    BYTE bySendMode;             //Server Connection Mode that decoder connected
    BYTE byEncoderChannel;         //Server Channel No. that decoder connected
    WORD wEncoderPort;             //Server Port that decoder connected
    BYTE reservedData[4];         //Reserved
}NET_DVR_DECODERINFO, *LPNET_DVR_DECODERINFO;

typedef struct
{
    BYTE byEncoderIP[16];         //Server IP that decoder connected
    BYTE byEncoderUser[16];         //Server Username that decoder connected
    BYTE byEncoderPasswd[16];     //Server Password that decoder connected
    BYTE byEncoderChannel;         //Server Channel No. that decoder connected
    BYTE bySendMode;             //Server Connection Mode that decoder connected
    WORD wEncoderPort;             //Server Port that decoder connected
    DWORD dwConnectState;         //Server State that decoder connected
    BYTE reservedData[4];         //Reserved
}NET_DVR_DECODERSTATE, *LPNET_DVR_DECODERSTATE;

/*Definition of Decoder Control Code */
#define NET_DEC_STARTDEC        1
#define NET_DEC_STOPDEC            2
#define NET_DEC_STOPCYCLE        3
#define NET_DEC_CONTINUECYCLE    4

/*Channel Connected Configuration*/
typedef struct
{
    char sDVRIP[16];                 /* DVR IP Address */
    WORD wDVRPort;                      /* Ports */
    BYTE sUserName[NAME_LEN];         /* Username */
    BYTE sPassword[PASSWD_LEN];         /* Password */
    BYTE byChannel;                     /* Channel No. */
    BYTE byLinkMode;                 /* Connection Mode */
    BYTE byLinkType;                 /* Stream for Connection  0- Main Stream 1- Sub Stream */
}NET_DVR_DECCHANINFO, *LPNET_DVR_DECCHANINFO;

/*Configuration of Each Decoding Channel*/
typedef struct
{
    BYTE    byPoolChans;             /*Switch channel number on each decoder channel,  range from 0- 4*/
    NET_DVR_DECCHANINFO struchanConInfo[MAX_DECPOOLNUM];
    BYTE    byEnablePoll;             /*enable switching or not:  0-  disable 1-  enable*/
    BYTE    byPoolTime;                 /*switching interval:  1- 10 sec;  2-  15 sec;  3-  20 sec;  4-  30 sec;   5-  45 sec;  6-  1min;  7-  2min;  8-  5min */
}NET_DVR_DECINFO, *LPNET_DVR_DECINFO;

/*Decoder Configuration*/
typedef struct
{
    DWORD    dwSize;
    DWORD    dwDecChanNum;          /*Number of decoding channels*/
    NET_DVR_DECINFO struDecInfo[MAX_DECNUM];
}NET_DVR_DECCFG, *LPNET_DVR_DECCFG;

//2005- 08- 01
/* Transparent Channel of Decoder */
typedef struct
{
    DWORD dwEnableTransPort;     /* Enable transparent channel or not:  0-  disable;  1-  enable*/
    char sDecoderIP[16];         /* DVR IP */
    WORD wDecoderPort;             /* Port number */
    WORD wDVRTransPort;             /* Configuration DVR output serial port:  1-  232;  2-  485 */
    char cReserve[4];
}NET_DVR_PORTINFO, *LPNET_DVR_PORTINFO;

typedef struct
{
    DWORD dwSize;
    NET_DVR_PORTINFO struTransPortInfo[MAX_TRANSPARENTNUM];  /* Array 0- - 232;  Array 1- - 485 */
}NET_DVR_PORTCFG, *LPNET_DVR_PORTCFG;

/* Remote Playback */
typedef struct
{
    DWORD dwSize;
    char sDecoderIP[16];         /* DVR IP*/
    WORD wDecoderPort;             /* Port */
    WORD wLoadMode;                 /* Playback Mode 1- by name 2- by time */
    union
    {
        BYTE byFile[100];         /* File Name */
        struct
        {
            DWORD dwChannel;
            BYTE sUserName[NAME_LEN];     /* Username for playback*/
            BYTE sPassword[PASSWD_LEN];     /* Password */
            NET_DVR_TIME struStartTime;     /* Start time of playback by time mode*/
            NET_DVR_TIME struStopTime;     /* End time */
        }bytime;
    }mode_size;
}NET_DVR_PLAYREMOTEFILE, *LPNET_DVR_PLAYREMOTEFILE;

/*Decoder Channel Status Structure */
typedef struct
{
    DWORD dwWorkType;         /*Work mode:  1-  switching;  2-  dynamic connect to decoder;  3-  playback by file;  4-  playback by time*/
    char sDVRIP[16];         /*Connected device IP*/
    WORD wDVRPort;             /*Connected port number*/
    BYTE byChannel;             /*Channel number */
    BYTE byLinkMode;         /*Connection mode */
    DWORD    dwLinkType;         /*Connection stream type:  0-  main stream;  1-  sub stream*/
    union
    {
        struct
        {
            BYTE sUserName[NAME_LEN];     /*Username*/
            BYTE sPassword[PASSWD_LEN];     /* Password */
            char cReserve[52];
        }userInfo;
        struct
        {
            BYTE   fileName[100];
        }fileInfo;
        struct
        {
            DWORD    dwChannel;
            BYTE    sUserName[NAME_LEN];     /*Username*/
            BYTE    sPassword[PASSWD_LEN];     /* Password */
            NET_DVR_TIME struStartTime;         /* Start position for playback by time */
            NET_DVR_TIME struStopTime;         /* End position for playback by time */
        }timeInfo;
    }objectInfo;
}NET_DVR_DECCHANSTATUS, *LPNET_DVR_DECCHANSTATUS;

typedef struct
{
    DWORD   dwSize;
    NET_DVR_DECCHANSTATUS struDecState[MAX_DECNUM];
}NET_DVR_DECSTATUS, *LPNET_DVR_DECSTATUS;
/*****************************DS- 6001D/F (end) ***************************/

//Single Character Struct  (Sub Struct) 
typedef struct
{
    WORD wShowString;                 //enable text overlay on preview image:  0- disable;  1- enable. The display area ranges totally 704*576 ,  with single character size as 32*32
    WORD wStringSize;                 /* text length,  no more than 44 text character */
    WORD wShowStringTopLeftX;         /* top left X axis position for text overlay*/
    WORD wShowStringTopLeftY;         /* top left Y axis position for text overlay */
    char sString[44];                 /* overlay text content*/
}NET_DVR_SHOWSTRINGINFO, *LPNET_DVR_SHOWSTRINGINFO;

//Text Overlay  (9000extended) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_SHOWSTRINGINFO struStringInfo[MAX_STRINGNUM_V30];                 /* Content for display */
}NET_DVR_SHOWSTRING_V30, *LPNET_DVR_SHOWSTRING_V30;

//Text Overlay extended (8 lines) 
typedef struct
{
    DWORD dwSize;
    NET_DVR_SHOWSTRINGINFO struStringInfo[MAX_STRINGNUM_EX];                 /* Content for display  */
}NET_DVR_SHOWSTRING_EX, *LPNET_DVR_SHOWSTRING_EX;

//Text Overlay 
typedef struct
{
    DWORD dwSize;
    NET_DVR_SHOWSTRINGINFO struStringInfo[MAX_STRINGNUM];                 /* Content for display  */
}NET_DVR_SHOWSTRING, *LPNET_DVR_SHOWSTRING;

/****************************DS9000 added Structure (begin) ******************************/

/*
EMAIL Parameters Struct
*/
typedef struct
{
    DWORD        dwSize;
    BYTE        sAccount[NAME_LEN];                 /* Email Account*/
    BYTE        sPassword[MAX_EMAIL_PWD_LEN];             /*Password */
    struct
    {
        BYTE    sName[NAME_LEN];                 /* sender name */
        BYTE    sAddress[MAX_EMAIL_ADDR_LEN];         /* sender address */
    }struSender;
    BYTE        sSmtpServer[MAX_EMAIL_ADDR_LEN];     /* SMTP server */
    BYTE        sPop3Server[MAX_EMAIL_ADDR_LEN];     /* POP3 server */
    struct
    {
        BYTE    sName[NAME_LEN];                 /* receiver Name */
        BYTE    sAddress[MAX_EMAIL_ADDR_LEN];         /* receiver address */
    }struReceiver[3];                             /* support up to 3 receivers */
    BYTE        byAttachment;                     /* with attached snapshot or not */
    BYTE        bySmtpServerVerify;                 /* Enable Email server authentication:  1- enable;  0- disable */
    BYTE        byMailInterval;                  /* mail interval 0- 2s,  1- 3s,  2- 4s. 3- 5s*/
    BYTE        byEnableSSL;                     //enable ssl
    WORD        wSmtpPort;                         //gmail default 465,  else default 25     
    BYTE        byEnableTLS;                    /*enable TLS*/
    BYTE        byStartTLS;                     /*Start TLS*/
    BYTE        byRes[72];                        /*res*/
} NET_DVR_EMAILCFG_V30, *LPNET_DVR_EMAILCFG_V30;

/*
DVR Cruise Structure
*/
typedef struct
{
    DWORD     dwSize;
    BYTE    byPresetNo[CRUISE_MAX_PRESET_NUMS];         /* Preset No. */
    BYTE     byCruiseSpeed[CRUISE_MAX_PRESET_NUMS];     /* Cruise Speed */
    WORD    wDwellTime[CRUISE_MAX_PRESET_NUMS];         /* Dwell time */
    BYTE    byEnableThisCruise;                         /* Enable this cruise */
    BYTE    res[15];
}NET_DVR_CRUISE_PARA, *LPNET_DVR_CRUISE_PARA;
/****************************DS9000 Added (end) ******************************/


//Time
typedef struct
{
    DWORD dwMonth;         //Month 0- 11 for 1- 12 month
    DWORD dwWeekNo;         //Week 0-  First Week 1- Second Week 2- Third Week 3- Fourth Week 4- last Week
    DWORD dwWeekDate;     //Day 0- Sun 1- Mon 2- Tue 3- Wed 4- Thu 5- Fri 6- Sat
    DWORD dwHour;         //begin/end hour,  begin hour ranges from 0- 23,  and end hour ranges from 1- 23
    DWORD dwMin;         //begin/stop minutes ranges from 0- 59
}NET_DVR_TIMEPOINT;

//Time Zone & DST 
typedef struct
{
    DWORD dwSize;
    DWORD dwZoneIndex; //Use cTimeDifferenceH or cTimeDifferenceM in NET_DVR_NTPPARA
    BYTE byRes1[12];             //Reserved
    DWORD dwEnableDST;         //enable DST,  0- disable;  1- enable
    BYTE byDSTBias;             //DST bias;  30min,  60min,  90min,  120min,  count with minute
    BYTE byRes2[3];
    NET_DVR_TIMEPOINT struBeginPoint;     //DST start time
    NET_DVR_TIMEPOINT struEndPoint;         //DST stop time
}NET_DVR_ZONEANDDST, *LPNET_DVR_ZONEANDDST;



//Image Quality
typedef struct
{
    /*Note:  If encoding resolution is VGA, it supports grabbing 0=CIF,  1=QCIF,  2=D1 image.
    But if encoding resolution is 3=UXGA (1600x1200) ,  4=SVGA (800x600) ,  5=HD720p (1280x720) ,  6=VGA,  7=XVGA,  and 8=HD900p it only support grabbing image with current resolution*/
    /*
       0-CIF,           1-QCIF,           2-D1,         3-UXGA(1600x1200), 4-SVGA(800x600),5-HD720p(1280x720),
       6-VGA,           7-XVGA,           8-HD900p,     9-HD1080,     10-2560*1920,
       11-1600*304,     12-2048*1536,     13-2448*2048,  14-2448*1200, 15-2448*800,
       16-XGA(1024*768), 17-SXGA(1280*1024),18-WD1(960*576/960*480),      19-1080i,      20-576*576,
       21-1536*1536,     22-1920*1920,      23-320*240,    24-720*720,    25-1024*768,
       26-1280*1280,     27-1600*600,       28-2048*768,   29-160*120,    55-3072*2048,
       64-3840*2160,     70-2560*1440,      75-336*256,
       78-384*256,         79-384*216,        80-320*256,    82-320*192,    83-512*384,
       127-480*272,      128-512*272,       161-288*320,   162-144*176,   163-480*640,
       164-240*320,      165-120*160,       166-576*720,   167-720*1280,  168-576*960,
       180-180*240,      181-360*480,       182-540*720,    183-720*960,  184-960*1280,
       185-1080*1440     215-1080*720(occupied untested),  216-360x640(occupied untested),
       245-576*704[P]/480*704[N](occupied untested)
       500-384*288,
       0xff-Auto(Use resolution of current stream)
       */
    WORD    wPicSize;
    WORD    wPicQuality; /* 0 -  the best,  1 -  better,  2 -  average;  */
}NET_DVR_JPEGPARA, *LPNET_DVR_JPEGPARA;

typedef struct tagNET_DVR_JPEGPICTURE_WITH_APPENDDATA
{
    DWORD   dwSize;
    DWORD   dwChannel;
    DWORD   dwJpegPicLen;
    char    *pJpegPicBuff;
    DWORD   dwJpegPicWidth;  
    DWORD   dwJpegPicHeight; 
    DWORD   dwP2PDataLen;
    char    *pP2PDataBuff;   
    BYTE    byIsFreezedata;//0-no 1-yes
    BYTE    byRes[255];
}NET_DVR_JPEGPICTURE_WITH_APPENDDATA, *LPNET_DVR_JPEGPICTURE_WITH_APPENDDATA;

typedef  struct
{
    NET_DVR_JPEGPARA  struParam;
    BYTE   byPicFormat;            // The equipment at 0 - Jpeg image format 
    BYTE   byCapturePicType;        // Equipment, scratching figure type 0 - equipment general figure, 1 - eagle eye calibration images ,3-fish circle picture
    BYTE   bySceneID;              //0-not support,1-scene1, 2-scene2 .....
    BYTE   byRes[253];
}NET_DVR_PICPARAM_V50, *LPNET_DVR_PICPARAM_V50;

/* aux video out parameter */
//AUX Output Parameter
typedef struct
{
    DWORD dwSize;
    DWORD dwAlarmOutChan;                        /* 0-main video output;  1-aux1 video output;  2-aux2 video output;  3-aux3 video output;  4-aux4 video output*/
    DWORD dwAlarmChanSwitchTime;                 /* : 1Sec -  10: 10Sec */
    DWORD dwAuxSwitchTime[MAX_AUXOUT];             /* aux output switch time:  0-  no switch;  1- 5sec; 2- 10sec; 3- 20sec; 4- 30sec; 5- 60sec; 6- 120sec; 7- 300sec*/
    BYTE  byAuxOrder[MAX_AUXOUT][MAX_WINDOW];     /* aux output preview sequence,  0xff means not preview the camera */
}NET_DVR_AUXOUTCFG, *LPNET_DVR_AUXOUTCFG;


//ntp
typedef struct
{
    BYTE sNTPServer[64];    /* Domain Name or IP address of NTP server */
    WORD wInterval;          /* adjust time interval (hours)  */
    BYTE byEnableNTP;     /* enable NPT client 0- no, 1- yes*/
    signed char cTimeDifferenceH;  /* Difference with Standard Time  (Hour) :  ranges from - 12... +13 */
    signed char cTimeDifferenceM; /* Difference with Standard Time  (Minute) */
    BYTE res1;
    WORD wNtpPort;          /* ntp server port (9000 added) ,  123 is default*/
    BYTE res2[8];
}NET_DVR_NTPPARA, *LPNET_DVR_NTPPARA;

//DDNS
typedef struct
{
    BYTE sUsername[NAME_LEN];   /* DDNS Username*/
    BYTE sPassword[PASSWD_LEN]; /*Password */
    BYTE sDomainName[64];        /* Domain name */
    BYTE byEnableDDNS;             /*Enable DDNS 0- disable, 1- enable*/
    BYTE res[15];
}NET_DVR_DDNSPARA, *LPNET_DVR_DDNSPARA;


typedef struct
{
    BYTE byHostIndex;                     /* 0- private DNS (Reserved)  1- Dyndns 2- PeanutHull 3- xw3322  */
    BYTE byEnableDDNS;                     /*enable DDNS:  0- disable;  1- enable*/
    WORD wDDNSPort;                         /* DDNS port */
    BYTE sUsername[NAME_LEN];             /* DDNS Username*/
    BYTE sPassword[PASSWD_LEN];             /* DDNS Password */
    BYTE sDomainName[MAX_DOMAIN_NAME];     /* DVR domain name*/
    BYTE sServerName[MAX_DOMAIN_NAME];     /* DDNS server domain name or IP */
    BYTE byRes[16];
}NET_DVR_DDNSPARA_EX, *LPNET_DVR_DDNSPARA_EX;

//9000extended
typedef struct
{
    BYTE byEnableDDNS;
    BYTE byHostIndex; /*0-IPServer 1-Dyndns 2-PeanutHull,3- NO-IP, 4- hiDDNS*/
    BYTE byRes1[2];
    struct
    {
        BYTE sUsername[NAME_LEN];             /* DDNS Username*/
        BYTE sPassword[PASSWD_LEN];         /* Password */
        BYTE sDomainName[MAX_DOMAIN_NAME];     /* DVR domain name */
        BYTE sServerName[MAX_DOMAIN_NAME];     /* DDNS server domain name or IP*/
        WORD wDDNSPort;                     /* Port */
        WORD    wCountryID;                    //Country ID,Only byHostIndex is 4 effective, 0 represents the default
        BYTE byStatus;                         /*DDNS status(ro),0-Meaningless,1-connAddrSrvfail\
        2-solveAddrMesFail,3-connHeartSrvfail,4-solveHeartMesFail, 5-connHostSrvfail,6-solveHostMesFail,7-registHostSuccess\
        8-registHostFail,9-sendHeartSuccess, 10-noDNSSrv,  11-DomainConflict,12-serviceException,13-needAuthentication\
        14-invalidAlias, 15-disable*/
        BYTE byRes[7];
    } struDDNS[MAX_DDNS_NUMS];
    BYTE byRes2[16];
}NET_DVR_DDNSPARA_V30, *LPNET_DVR_DDNSPARA_V30;

//email
typedef struct
{
    BYTE sUsername[64];   /* Email Account */
    BYTE sPassword[64];
    BYTE sSmtpServer[64];
    BYTE sPop3Server[64];
    BYTE sMailAddr[64];    /* email */
    BYTE sEventMailAddr1[64];   /* email for upload Alarm/Exception */
    BYTE sEventMailAddr2[64];
    BYTE res[16];
}NET_DVR_EMAILPARA, *LPNET_DVR_EMAILPARA;

//Network Parameter
typedef struct
{
    DWORD  dwSize;
    char  sDNSIp[16];                 /* DNS Server IP */
    NET_DVR_NTPPARA  struNtpClientParam;       /* NTP Parameters */
    NET_DVR_DDNSPARA struDDNSClientParam;      /* DDNS Parameters */
    BYTE res[464];             /* Reserved */
}NET_DVR_NETAPPCFG, *LPNET_DVR_NETAPPCFG;

//nfs Structure Configuration
typedef struct
{
    char sNfsHostIPAddr[16];
    BYTE sNfsDirectory[PATHNAME_LEN];         // PATHNAME_LEN = 128
}NET_DVR_SINGLE_NFS, *LPNET_DVR_SINGLE_NFS;

typedef struct
{
    DWORD  dwSize;
    NET_DVR_SINGLE_NFS struNfsDiskParam[MAX_NFS_DISK];
}NET_DVR_NFSCFG, *LPNET_DVR_NFSCFG;

typedef struct tagNET_DVR_ISCSI_CFG
{
    DWORD dwSize;                   // Structure size
    WORD wVrmPort;                  // VRM listening port
    BYTE byEnable;                  // Enable ISCSI storage or not
    BYTE byRes[69];                 // Reserved
    NET_DVR_IPADDR struVrmAddr;     // VRM IP address, 16-bit
    char chNvtIndexCode[64];        //nvt index Code 
}NET_DVR_ISCSI_CFG, *LPNET_DVR_ISCSI_CFG;

//Cruise Point Configuration (for private IP Speed Dome) 
typedef struct
{
    BYTE    PresetNum;     //Preset
    BYTE    Dwell;         //Dwell time
    BYTE    Speed;         //Speed
    BYTE    Reserve;     //Reserved
}NET_DVR_CRUISE_POINT, *LPNET_DVR_CRUISE_POINT;

typedef struct
{
    NET_DVR_CRUISE_POINT struCruisePoint[32];             //32 points in total
}NET_DVR_CRUISE_RET, *LPNET_DVR_CRUISE_RET;

/************************************Multi- Channel Decoder (begin) ***************************************/
typedef struct
{
    DWORD    dwSize;
    char    sFirstDNSIP[16];
    char    sSecondDNSIP[16];
    char    sRes[32];
}NET_DVR_NETCFG_OTHER, *LPNET_DVR_NETCFG_OTHER;

typedef struct
{
    char     sDVRIP[16];                 /* DVR IP */
    WORD     wDVRPort;                  /* Port */
    BYTE     byChannel;                 /* Channel No. */
    BYTE    byTransProtocol;             /* Network Protocol 0- TCP,  1- UDP */
    BYTE    byTransMode;                 /* Stream Type 0 -  Main Stream 1 -  Sub Stream*/
    BYTE    byRes[3];
    BYTE    sUserName[NAME_LEN];             /* DVR login user name */
    BYTE    sPassword[PASSWD_LEN];             /* DVR login Password */
}NET_DVR_MATRIX_DECINFO, *LPNET_DVR_MATRIX_DECINFO;

//Dynamic Decoding
typedef struct
{
    DWORD    dwSize;
    NET_DVR_MATRIX_DECINFO struDecChanInfo;         /*Info of Dynamic Decoding Channel*/
}NET_DVR_MATRIX_DYNAMIC_DEC, *LPNET_DVR_MATRIX_DYNAMIC_DEC;

typedef struct
{
    DWORD     dwSize;
    DWORD   dwIsLinked;          /* Network link status tag,  0:  Sleep,  1:  linking,  2:  linked,  3:  decoding */
    DWORD   dwStreamCpRate;      /* Stream copy rate,  X kbits/second */
    char    cRes[64];         /* Reserved */
}NET_DVR_MATRIX_DEC_CHAN_STATUS, *LPNET_DVR_MATRIX_DEC_CHAN_STATUS;

typedef struct
{
    DWORD    dwSize;
    NET_DVR_MATRIX_DECINFO struDecChanInfo;         /* Decode channel information  */
    DWORD    dwDecState;     /* 0- dynamic decode 1-  switch decode 2- playback by time 3- playback by file */
    NET_DVR_TIME StartTime;         /* start time for playback by time mode,  */
    NET_DVR_TIME StopTime;         /* stop time for playback by time mode */
    char    sFileName[128];         /* file name for playback by file mode */
}NET_DVR_MATRIX_DEC_CHAN_INFO, *LPNET_DVR_MATRIX_DEC_CHAN_INFO;

//Channel Connected Configuration 2007- 11- 05
typedef struct
{
    DWORD dwEnable;                     /*0- Disable 1- Enable*/
    NET_DVR_MATRIX_DECINFO struDecChanInfo;         /* Info of switching decoding channel */
}NET_DVR_MATRIX_DECCHANINFO, *LPNET_DVR_MATRIX_DECCHANINFO;

//2007- 11- 05 Configuration for each channel
typedef struct
{
    DWORD    dwSize;
    DWORD    dwPoolTime;             /*Switch interval */
    NET_DVR_MATRIX_DECCHANINFO struchanConInfo[MAX_CYCLE_CHAN];
}NET_DVR_MATRIX_LOOP_DECINFO, *LPNET_DVR_MATRIX_LOOP_DECINFO;

//2007- 12- 22
typedef struct
{
    BYTE    baudrate;          /* baud rate */
    BYTE    databits;         /* Data bit */
    BYTE    stopbits;         /* Stop bit*/
    BYTE    parity;             /* Parity digit */
    BYTE    flowcontrol;     /* Flow control */
    BYTE    res[3];
}TTY_CONFIG, *LPTTY_CONFIG;

typedef struct
{
    BYTE byTranChanEnable;     /* Open current transparent channel or not 0:  close 1:  open */
    /*
    There is a 232 interface and a 485 interface on the decoder,  which can all be set as transparent channel,  device number can be distributed as below:
    0 -  RS485; 1 -  RS232 Console
    */
    BYTE    byLocalSerialDevice;             /* Local serial device */
    /*
    *    Remote output serial device
    *    1- RS232
    *    2- RS485
    */
    BYTE    byRemoteSerialDevice;             /* Remote output serial device */
    BYTE    res1;                             /* Reserved */
    char    sRemoteDevIP[16];                 /* Remote Device IP */
    WORD    wRemoteDevPort;                     /* Remote Net Communication Port */
    BYTE    res2[2];                         /* Reserved */
    TTY_CONFIG RemoteSerialDevCfg;
}NET_DVR_MATRIX_TRAN_CHAN_INFO, *LPNET_DVR_MATRIX_TRAN_CHAN_INFO;

typedef struct
{
    DWORD dwSize;
    BYTE     by232IsDualChan;  /* Set full- duplex 232 transparent channel,  set value ranges from 1 to MAX_SERIAL_NUM */
    BYTE    by485IsDualChan;  /* Set full- duplex 485 transparent channel,  set value ranges from 1 to MAX_SERIAL_NUM */
    BYTE    res[2];     /* Reserved */
    NET_DVR_MATRIX_TRAN_CHAN_INFO struTranInfo[MAX_SERIAL_NUM]; /*Support to create transparent channel number up to MAX_SERIAL_NUM*/
}NET_DVR_MATRIX_TRAN_CHAN_CONFIG, *LPNET_DVR_MATRIX_TRAN_CHAN_CONFIG;

//2007- 12- 24 Merry Christmas Eve...
typedef struct
{
    DWORD    dwSize;
    char    sDVRIP[16];             /* DVR IP */
    WORD    wDVRPort;             /* Port */
    BYTE    byChannel;             /* Channel Port */
    BYTE     byReserve;
    BYTE    sUserName[NAME_LEN];         /* Username */
    BYTE    sPassword[PASSWD_LEN];         /* Password */
    DWORD    dwPlayMode;        /* 0- by file 1-  by time*/
    NET_DVR_TIME StartTime;
    NET_DVR_TIME StopTime;
    char    sFileName[128];
}NET_DVR_MATRIX_DEC_REMOTE_PLAY, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY;

/* Commands for playing file*/
#define NET_DVR_PLAYSTART        1//Start play
#define NET_DVR_PLAYSTOP        2//Stop play
#define NET_DVR_PLAYPAUSE        3//Pause
#define NET_DVR_PLAYRESTART        4//Restore
#define NET_DVR_PLAYFAST        5//Play Faster
#define NET_DVR_PLAYSLOW        6//Play Slower
#define NET_DVR_PLAYNORMAL        7//Normal Speed
#define NET_DVR_PLAYSTARTAUDIO    9//Open Audio
#define NET_DVR_PLAYSTOPAUDIO    10//Close Audio
#define NET_DVR_PLAYSETPOS        12//Change playing progress
#define NET_DVR_RESETBUFFER	    37  //reset matrix decode buffer(remote playback file)

typedef struct
{
    DWORD    dwSize;
    DWORD    dwPlayCmd;         /* Command of Play*/
    DWORD    dwCmdParam;         /* Parameter of Command*/
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_CONTROL, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_CONTROL;

typedef struct
{
    DWORD dwSize;
    DWORD dwCurMediaFileLen;         /* Current file length  */
    DWORD dwCurMediaFilePosition;     /* Current file position */
    DWORD dwCurMediaFileDuration;     /* Current file duration */
    DWORD dwCurPlayTime;             /* Current playback time  */
    DWORD dwCurMediaFIleFrames;         /* Current playback frame number  */
    DWORD dwCurDataType;             /* Current stream type,  19- file header,  20-  stream data,  21- end */
    BYTE res[72];
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_STATUS, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_STATUS;

typedef struct tagNet_DVR_IP_ADDRESS
{
    BYTE    byDevAddress[MAX_DOMAIN_NAME];    /*Dev ip*/
    WORD    wDevPort;       //dev Port
    BYTE     byres[134];
}NET_DVR_IP_ADDRESS, *LPNET_DVR_IP_ADDRESS;

typedef struct tagNet_DVR_DDNS_ADDRESS
{
    BYTE byDevAddress[MAX_DOMAIN_NAME];    /*DDNS Domain*/
    BYTE byDevDdns[MAX_DOMAIN_NAME];    /*Dev Address*/
    BYTE byDdnsType; //Domain Server type,0-IPServer 1-Dyndns 2-PeanutHull,//3- NO-IP, 4- hiDDNS
    BYTE byRes1[3];
    WORD wDevPort;       //Dev Port
    WORD wDdnsPort; //Dev Server Port
    BYTE byres[64];
}NET_DVR_DDNS_ADDRESS, *LPNET_DVR_DDNS_ADDRESS;

typedef struct tagNet_DVR_PLAY_BACK_BY_TIME
{
    NET_DVR_TIME StartTime;
    NET_DVR_TIME StopTime;
}NET_DVR_PLAY_BACK_BY_TIME, *LPNET_DVR_PLAY_BACK_BY_TIME;



typedef struct tagNet_DVR_MATRIX_DEC_REMOTE_PLAY_EX
{
    DWORD    dwSize;
    DWORD    dwDecChannel;  //Decode Channal NUM
    BYTE    byAddressType;  //Device Address Type,0-IP,1-DDNS
    BYTE    byChannelType;  //Channal Type,0-Normal Channal,1-Zero Channal,2-Stream ID
    BYTE    byres[2];
    BYTE    sUserName[NAME_LEN];        /* user */
    BYTE    sPassword[PASSWD_LEN];        /* password */
    DWORD    dwChannel;            /* Device Channal */
    BYTE    byStreamId[STREAM_ID_LEN];  //Stream ID
    DWORD    dwPlayMode;       /* 0-Play by name 1-play by time*/
    union
    {
        BYTE byRes[200];
        NET_DVR_IP_ADDRESS struIpAddr;
        NET_DVR_DDNS_ADDRESS struDdnsAddr;
    }unionAddr;

    union
    {
        BYTE byRes[128];
        NET_DVR_PLAY_BACK_BY_TIME struPlayBackByTime;
        char sFileName[128];
    }unionPlayBackInfo;
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_EX, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_EX;

typedef struct tagNET_DVR_MATRIX_DEC_REMOTE_PLAY_V50
{
    DWORD   dwSize;
    DWORD   dwDecChannel;
    BYTE    byAddressType;
    BYTE    byChannelType;
    BYTE    byStreamEncrypt;//stream encrypt enabled, 0-not support,1-support
	BYTE	byRes1[1];
    BYTE    sUserName[NAME_LEN];
    BYTE    sPassword[PASSWD_LEN];
    DWORD   dwChannel;
    BYTE    byStreamId[STREAM_ID_LEN];
    DWORD   dwPlayMode;
    union
    {
        BYTE byRes[200];
        NET_DVR_IP_ADDRESS struIpAddr;
        NET_DVR_DDNS_ADDRESS struDdnsAddr;
    }unionAddr;
    union
    {
        BYTE byRes[128];
        NET_DVR_PLAY_BACK_BY_TIME struPlayBackByTime;
        BYTE sFileName[128];
    }unionPlayBackInfo;
    NET_DVR_PU_STREAM_URL struURL;
    BYTE    sStreamPassword[STREAM_PASSWD_LEN];//stream password
    BYTE    byRes2[116];
}NET_DVR_MATRIX_DEC_REMOTE_PLAY_V50, *LPNET_DVR_MATRIX_DEC_REMOTE_PLAY_V50;

//Multi- channels Decoder new
typedef struct tagNET_MATRIX_PASSIVEMODE
{
    WORD    wTransProtol;         //Transfer Protocol, 0- TCP,  1- UDP,  2- MCAST
    WORD    wPassivePort;         //UDP port. When TCP,  use default value
    NET_DVR_IPADDR  struMcastIP; //Multicast address,  invalid when using TCP or UDP, 
    BYTE    byStreamType; /* play mode: REAL_TIME_STREAM (1) real-time, RECORD_STREAM (2) record */
    BYTE    byRes[7];
}NET_DVR_MATRIX_PASSIVEMODE, *LPNET_DVR_MATRIX_PASSIVEMODE;

typedef struct tagNET_DVR_MATRIX_TRAN_CHAN_INFO_V30
{
    BYTE byTranChanEnable;     /*Transparent Channel State:  0- Close,  1- Open */
    /*
    *    Multi- channel Decoder has 1 RS485 port and 1 RS232 Port,  both of them can be transparent channel. Device Number is :
    *    0 -  RS485
    *    1 -  RS232 Console
    */
    BYTE    byLocalSerialDevice;             /* Local serial device */
    /*
    *    Remote Serial Output Port:  one RS232 and one RS485
    *    1 -  RS232
    *    2 -  RS485
    */
    BYTE    byRemoteSerialDevice;             /* Remote output serial device */
    BYTE    res1;                             /* Reserved */
    // char    sRemoteDevIP[16];                 /* Remote Device IP */
    NET_DVR_IPADDR  struRemoteDevIP;
    WORD    wRemoteDevPort;                 /* Remote Net Communication Port */
    BYTE  byIsEstablished;     /* Establish Transparent channel: 0- Failure,  1- Success*/
    BYTE    res2;                     /* Reserved */
    TTY_CONFIG RemoteSerialDevCfg;
    BYTE      byUsername[NAME_LEN];          /* 32BYTES */
    BYTE       byPassword[PASSWD_LEN];      /* 16BYTES */
    DWORD   dwLocalSerialNo;
    DWORD   dwRemoteSerialNo;
    BYTE    byRes3[8];
}NET_DVR_MATRIX_TRAN_CHAN_INFO_V30, *LPNET_DVR_MATRIX_TRAN_CHAN_INFO_V30;

typedef struct tagMATRIX_TRAN_CHAN_CONFIG
{
    DWORD   dwSize;
    BYTE     by232IsDualChan;  /* Set this RS232 transparent channel as Duplex: 1 ~ MAX_SERIAL_NUM*/
    BYTE    by485IsDualChan;  /* Set this RS485 transparent channel as Duplex: 1 ~ MAX_SERIAL_NUM */
    BYTE    vyRes[2];     /* Reserved */
    NET_DVR_MATRIX_TRAN_CHAN_INFO_V30 struTranInfo[MAX_SERIAL_NUM]; /*Support MAX_SERIAL_NUM Transparent channels simultaneously*/
}NET_DVR_MATRIX_TRAN_CHAN_CONFIG_V30, *LPNET_DVR_MATRIX_TRAN_CHAN_CONFIG_V30;


typedef struct
{
    DWORD                                dwEnable;     /*0- Disable,  1- Enable*/
    NET_DVR_STREAM_MEDIA_SERVER_CFG    streamMediaServerCfg;
    NET_DVR_DEV_CHAN_INFO         struDevChanInfo;         /* Loop Decoding channel info */
}NET_DVR_MATRIX_CHAN_INFO_V30, *LPNET_DVR_CYC_SUR_CHAN_ELE_V30;

typedef struct  tagMATRIX_LOOP_DECINFO_V30
{
    DWORD                            dwSize;
    DWORD                            dwPoolTime;         /*Loop Interval*/
    NET_DVR_MATRIX_CHAN_INFO_V30    struchanConInfo[MAX_CYCLE_CHAN_V30];
    BYTE                               byRes[16];
} NET_DVR_MATRIX_LOOP_DECINFO_V30, *LPNET_DVR_MATRIX_LOOP_DECINFO_V30;


typedef struct tagDEC_MATRIX_CHAN_INFO
{
    DWORD    dwSize;
    NET_DVR_STREAM_MEDIA_SERVER_CFG streamMediaServerCfg;     /*Streaming Media Server Config*/
    NET_DVR_DEV_CHAN_INFO               struDevChanInfo;         /*Decoding Channel Info  */
    DWORD    dwDecState;         /*  0- Dynamic Decoding,  1- Loop Decoding 2- Playback by time,  3- Playback by file */
    NET_DVR_TIME StartTime;         /* Start time of playback by time */
    NET_DVR_TIME StopTime;             /* End time of playback by time */
    char    sFileName[128];         /* File name for playback by file */
    DWORD   dwGetStreamMode;     /*Fetch Stream Mode: 1- Positive, 2- Passive*/
    NET_DVR_MATRIX_PASSIVEMODE      struPassiveMode;
    BYTE    byRes[32];
}NET_DVR_MATRIX_DEC_CHAN_INFO_V30, *LPNET_DVR_MATRIX_DEC_CHAN_INFO_V30;

#define MAX_RESOLUTIONNUM    64 //Max resolution number
typedef struct tagNET_DVR_MATRIX_ABILITY
{
    DWORD dwSize;
    BYTE  byDecNums;
    BYTE  byStartChan;
    BYTE  byVGANums;
    BYTE  byBNCNums;
    BYTE  byVGAWindowMode[8][12];      /*Window Mode of VGA*/
    BYTE  byBNCWindowMode[4];            /*Window Mode of BNC*/
    BYTE  byDspNums;
    BYTE  byHDMINums; //HDMI display channel number  ( start from 25) 
    BYTE  byDVINums; //DVI display channel number  (start from 29) 
    BYTE  byRes1[13];
    BYTE  bySupportResolution[MAX_RESOLUTIONNUM]; //resolution enable, 1: enable, 0: unenable
    BYTE  byHDMIWindowMode[4][8]; //Window-split mode supported by HDMI
    BYTE  byDVIWindowMode[4][8]; //Window-split mode supported by DVI
    BYTE  byRes2[24];
}NET_DVR_MATRIX_ABILITY, *LPNET_DVR_MATRIX_ABILITY;
//Upload Logo
typedef struct tagNET_DVR_DISP_LOGOCFG
{
    DWORD        dwCorordinateX;     //X- coordinate for logo display 
    DWORD        dwCorordinateY;     //Y- coordinate for logo display 
    WORD        wPicWidth; //Picture width
    WORD        wPicHeight; //Picture height
    BYTE        byRes1[4];
    BYTE        byFlash;   //Flash or not:  1- Flash,  0- Not flash
    BYTE        byTranslucent;  //Translucence or not:  1- Yes,  0- NO
    BYTE        byRes2[6];                 //Reserved
    DWORD        dwLogoSize; //LOGO size including BMP file head
}NET_DVR_DISP_LOGOCFG, *LPNET_DVR_DISP_LOGOCFG;

/*Encoding Format*/
#define NET_DVR_ENCODER_UNKOWN         0 /*Unknown Format*/
#define NET_DVR_ENCODER_H264         1 /*private H264*/
#define NET_DVR_ENCODER_S264         2 /*Standard H264*/
#define NET_DVR_ENCODER_MPEG4         3 /*MPEG4*/
#define NET_DVR_ORIGINALSTREAM         4 /*Original Stream*/
#define NET_DVR_PICTURE                 5 /*Picture*/
#define NET_DVR_ENCODER_MJPEG         6
#define NET_DVR_ENCODER_MPEG2         7
#define NET_DVR_ENCODER_H265         8

#define NET_DVR_ENCODER_SVAC    9
#define NET_DVR_ENCODER_SMART264                   10/*Smart 264*/
#define NET_DVR_ENCODER_SMART265                   11/*Smart 265*/

/* Encapsulation Format */
#define NET_DVR_STREAM_TYPE_UNKOWN   0   /*Unknown Format*/
#define NET_DVR_STREAM_TYPE_PRIVT    1   /*private Format*/
#define NET_DVR_STREAM_TYPE_TS         7   /* TS */
#define NET_DVR_STREAM_TYPE_PS         8   /* PS */
#define NET_DVR_STREAM_TYPE_RTP         9   /* RTP */
#define NET_DVR_STREAM_TYPE_ORIGIN   10  //ORIGIN

/*State of decoding channel*/
typedef struct
{
    BYTE  byDecodeStatus;     /*Status:  0- Disabled,  1- Enabled*/
    BYTE  byStreamType;     /*Stream Type*/
    BYTE  byPacketType;     /*Encapsulation Type*/
    BYTE  byRecvBufUsage;     /*Usage of receiving buffer*/
    BYTE  byDecBufUsage;     /*Usage of decoding buffer*/
    BYTE  byFpsDecV;         /*video decoding frame*/
    BYTE  byFpsDecA;         /*audio decoding frame*/
    BYTE  byCpuLoad;         /*DSP CPU usage*/
    BYTE  byRes1[4];         //Reserved
    DWORD dwDecodedV;         /*Decoded Video Frame*/
    DWORD dwDecodedA;         /*Decoded Audio Frame*/
    WORD  wImgW;             /*Current Image size*/
    WORD  wImgH;
    BYTE  byVideoFormat;    /*inputted Video standard:  1- PAL,  2- NTSC*/
    BYTE  byRes2[3];
    DWORD  dwDecChan;       /*only valid for gettting all*/
    BYTE  byRes3[20];
}NET_DVR_MATRIX_CHAN_STATUS, *LPNET_DVR_MATRIX_CHAN_STATUS;

/*Status of Display Channel*/
#define NET_DVR_MAX_DISPREGION  16        /*Maximum display regions of each display channel*/


//resolution
typedef enum
{
    /*VGA*/
    VGA_NOT_AVALIABLE,
    VGA_THS8200_MODE_SVGA_60HZ,     // (800*600) 
    VGA_THS8200_MODE_SVGA_75HZ,     // (800*600) 
    VGA_THS8200_MODE_XGA_60HZ,      // (1024*768) 
    VGA_THS8200_MODE_XGA_75HZ,      // (1024*768) 
    VGA_THS8200_MODE_SXGA_60HZ,     // (1280*1024) 
    VGA_THS8200_MODE_720P_60HZ,     // (1280*720) 
    VGA_THS8200_MODE_1080I_60HZ,    // (1920*1080) 
    VGA_THS8200_MODE_1080P_30HZ,    // (1920*1080) 
    VGA_THS8200_MODE_UXGA_30HZ,    // (1600*1200) 
    /*HDMI*/
    HDMI_SII9134_MODE_XGA_60HZ,     // (1024*768) 
    HDMI_SII9134_MODE_SXGA_60HZ,    // (1280*1024) 
    HDMI_SII9134_MODE_SXGA2_60HZ,   // (1280*960) 
    HDMI_SII9134_MODE_720P_60HZ,    // (1280*720)     
    HDMI_SII9134_MODE_720P_50HZ,    // (1280*720)         
    HDMI_SII9134_MODE_1080I_60HZ,   // (1920*1080) 
    HDMI_SII9134_MODE_1080I_50HZ,   // (1920*1080)     
    HDMI_SII9134_MODE_1080P_25HZ,   // (1920*1080) 
    HDMI_SII9134_MODE_1080P_30HZ,   // (1920*1080) 
    HDMI_SII9134_MODE_1080P_50HZ,   // (1920*1080) 
    HDMI_SII9134_MODE_1080P_60HZ,   // (1920*1080) 
    HDMI_SII9134_MODE_UXGA_60HZ,    // (1600*1200) 
    /*DVI*/
    DVI_SII9134_MODE_XGA_60HZ,         // (1024*768) 
    DVI_SII9134_MODE_SXGA_60HZ,     // (1280*1024) 
    DVI_SII9134_MODE_SXGA2_60HZ,    // (1280*960) 
    DVI_SII9134_MODE_720P_60HZ,     // (1280*720)     
    DVI_SII9134_MODE_720P_50HZ,     // (1280*720)         
    DVI_SII9134_MODE_1080I_60HZ,    // (1920*1080) 
    DVI_SII9134_MODE_1080I_50HZ,    // (1920*1080) 
    DVI_SII9134_MODE_1080P_25HZ,    // (1920*1080) 
    DVI_SII9134_MODE_1080P_30HZ,    // (1920*1080) 
    DVI_SII9134_MODE_1080P_50HZ,    // (1920*1080) 
    DVI_SII9134_MODE_1080P_60HZ,    // (1920*1080) 
    DVI_SII9134_MODE_UXGA_60HZ      // (1600*1200) 
}VGA_MODE;

//low frame per second
#define           LOW_DEC_FPS_1_2                51
#define           LOW_DEC_FPS_1_4                52
#define           LOW_DEC_FPS_1_8                53
#define           LOW_DEC_FPS_1_16               54

/*Video Standard*/
typedef enum
{
    VS_NON = 0,
    VS_NTSC = 1,
    VS_PAL = 2
}VIDEO_STANDARD;

typedef struct tagNET_DVR_VGA_DISP_CHAN_CFG
{
    DWORD    dwSize;
    BYTE    byAudio;             /*Enable Audio, 0- No, 1- Yes*/
    BYTE    byAudioWindowIdx;       /*child window of enabled audio*/
    BYTE     byVgaResolution;       /*VGA resolution*/
    BYTE    byVedioFormat;          /*Video Standard,  1: NTSC, 2: PAL, 0- NON*/
    DWORD    dwWindowMode;         /*Windows layout mode gotten from Capability Set:  1, 2, 4, 9, 16 windows*/
    BYTE    byJoinDecChan[MAX_WINDOWS]; /*Decoding channel associated by each display window*/
    BYTE    byEnlargeStatus;           /*0: Enlarge, 1: not enlarge*/
    BYTE    byEnlargeSubWindowIndex; //Sub Window Index
    union
    {
        BYTE byRes[16];
        struct
        {
            /*Decoding sub system's slot number of the display window's corresponding decoding channel number*/
            BYTE     byJoinDecoderId[MAX_WINDOWS];
        }struVideoPlatform;
        struct
        {
            BYTE     byRes[16];
        }struNotVideoPlatform;
    }struDiff;
    /*diff union, 0- video platform integrated decoder, 1-others*/
    BYTE        byUnionType;
    BYTE        byScale; /*show mode,0-real,1-zoom(BNC)*/
}NET_DVR_VGA_DISP_CHAN_CFG, *LPNET_DVR_VGA_DISP_CHAN_CFG;

/*Status of Display Channel*/
#define NET_DVR_MAX_DISPREGION 16 /*Maximum display regions of each display channel*/
typedef struct
{
    BYTE  byDispStatus;           /*Display Status: 0- No Display, 1- Enabled*/
    BYTE  byBVGA;                 /*0- BNC, 1- VGA,  2- HDMI, 3- DVI*/
    BYTE  byVideoFormat;         /*Video Standard: 1- PAL,  2- NTSC*/
    BYTE  byWindowMode;         /*Current window Layout*/
    BYTE  byJoinDecChan[MAX_WINDOWS];         /*Decoding channel of each region*/
    BYTE  byFpsDisp[NET_DVR_MAX_DISPREGION];  /*Display frame rate of each region*/
    BYTE  byRes2[32];
}NET_DVR_DISP_CHAN_STATUS, *LPNET_DVR_DISP_CHAN_STATUS;

#define MAX_DECODECHANNUM   32//Maximum number of decoding channel
#define MAX_DISPCHANNUM   24//Maximum number of display channel
/*Decoder Status*/
typedef struct tagNET_DVR_DECODER_WORK_STATUS
{
    DWORD dwSize;
    NET_DVR_MATRIX_CHAN_STATUS struDecChanStatus[MAX_DECODECHANNUM];  /*Status of decoding channel*/
    NET_DVR_DISP_CHAN_STATUS   struDispChanStatus[MAX_DISPCHANNUM];   /*Status of display channel*/
    BYTE byAlarmInStatus[MAX_ANALOG_ALARMIN];          /*Status of Alarm input*/
    BYTE byAlarmOutStatus[MAX_ANALOG_ALARMOUT];        /*Status of Alarm output*/
    BYTE byAudioInChanStatus;           /*Status of intercom*/
    BYTE byRes[127];
}NET_DVR_DECODER_WORK_STATUS, *LPNET_DVR_DECODER_WORK_STATUS;

//2009- 12- 1 Add passive decode play control
typedef struct tagNET_DVR_PASSIVEDECODE_CONTROL
{
    DWORD    dwSize;
    DWORD    dwPlayCmd;         /* play command*/
    DWORD    dwCmdParam;         /* command parameter */
    BYTE    byRes[16]; //Reverse
}NET_DVR_PASSIVEDECODE_CONTROL, *LPNET_DVR_PASSIVEDECODE_CONTROL;

#define        PASSIVE_DEC_PAUSE                1    /*passive decode pause (only file stream valid) */
#define        PASSIVE_DEC_RESUME                2    /*passive decode resume (only file stream valid) */
#define     PASSIVE_DEC_FAST                  3   /*passive decode fast (only file stream valid) */
#define     PASSIVE_DEC_SLOW                4   /*passive decode slow (only file stream valid) */
#define     PASSIVE_DEC_NORMAL              5   /*passive decode normal*/
#define     PASSIVE_DEC_ONEBYONE              6   /*passive decode one by one (reserved) */
#define     PASSIVE_DEC_AUDIO_ON             7   /*passive decode open audio*/
#define     PASSIVE_DEC_AUDIO_OFF            8      /*passive decode close audio*/
#define        PASSIVE_DEC_RESETBUFFER            9   /*reset buffer */

//2009- 12- 16 scale control
typedef struct tagNET_DVR_MATRIX_DECCHAN_CONTROL
{
    DWORD    dwSize;
    BYTE    byDecChanScaleStatus; /*decode channel scale control, 1: scale display, 0: real display*/
    BYTE    byDecodeDelay;//Decoding delay: 0- default, 1- most real-time, 2- more real-time, 3- real-time and fluency, 4- more fluency, 5- most fluency, 0xff- automatically adjust     
    BYTE    byEnableSpartan;//motion fluency,0-off,1-on
    BYTE    byLowLight;      //low light, 0-close, 1-8 means low light level, the level is larger ,the power is bigger
    BYTE    byNoiseReduction; //3D reduce noise, 0-close, 1-open, 2-auto 
    BYTE    byDefog;         //consumption, 0-close 1-7 means level, the larger, the more power
    BYTE    byEnableVcaDec;    //decode show vca information,0-close,1-open
    BYTE    byEnableAudio; //open audio, 0-invalid, 1-open, 2-close
    DWORD   dwAllCtrlType;    //all window control type,valid for setting,each bit reference to one operation
    //dwAllCtrlType & 0x01, switch for vca decoding
    BYTE    byVolume; //volume,[0-100]
    BYTE    byRes[55];
}NET_DVR_MATRIX_DECCHAN_CONTROL, *LPNET_DVR_MATRIX_DECCHAN_CONTROL;

/************************************Decoder (end) ***************************************/

typedef struct tagNET_DVR_PANORAMA_LINKAGE
{
    DWORD            dwSize;
    BYTE             byEnable;//0- off, 1- turned on
    BYTE             byRes[127];
}NET_DVR_PANORAMA_LINKAGE, *LPNET_DVR_PANORAMA_LINKAGE;


typedef struct
{    /* 12 bytes */
    DWORD    dwSize;
    char    sUserName[32];
    char     sPassWord[32];
    char     sFromName[32];             /* Sender */
    char     sFromAddr[48];             /* Sender address */
    char     sToName1[32];             /* Receiver1 */
    char     sToName2[32];             /* Receiver2 */
    char     sToAddr1[48];             /* Receiver address1 */
    char     sToAddr2[48];             /* Receiver address2 */
    char    sEmailServer[32];         /* Email server address */
    BYTE    byServerType;             /* Email server type:  0- SMTP,  1- POP,  2- IMTP...*/
    BYTE    byUseAuthen;             /* Email server authentication method:  1- enable,  0- disable */
    BYTE    byAttachment;             /* enable attachment */
    BYTE    byMailinterval;         /* mail interval 0- 2s,  1- 3s,  2- 4s. 3- 5s*/
} NET_DVR_EMAILCFG, *LPNET_DVR_EMAILCFG;

typedef struct
{
    DWORD dwSize;
    NET_DVR_COMPRESSION_INFO_EX  struLowCompression;     // Time Record
    NET_DVR_COMPRESSION_INFO_EX  struEventCompression;     //  Triggered by events
}NET_DVR_COMPRESSIONCFG_NEW, *LPNET_DVR_COMPRESSIONCFG_NEW;

//Position info of Speed Dome
typedef struct
{
    WORD wAction; //invalid 
    WORD wPanPos; //pan position
    WORD wTiltPos; //tilt position
    WORD wZoomPos; //zoom position
}NET_DVR_PTZPOS, *LPNET_DVR_PTZPOS;

//PTZ Scope Structure 
typedef struct
{
    WORD wPanPosMin; //min pan position
    WORD wPanPosMax; //max pan position
    WORD wTiltPosMin; //min tilt position
    WORD wTiltPosMax; //max tilt position
    WORD wZoomPosMin; //min zoom factor
    WORD wZoomPosMax; //max zoom factor
}NET_DVR_PTZSCOPE, *LPNET_DVR_PTZSCOPE;

//rtsp Configuration (Special for IP camera) 
typedef struct
{
    DWORD dwSize;          //Length
    WORD  wPort;           //rtsp Port
    BYTE  byReserve[54];   //Reserved
}NET_DVR_RTSPCFG, *LPNET_DVR_RTSPCFG;


/********************************Interface Parameters Structure (begin) *********************************/

//NET_DVR_Login () 
typedef struct
{
    BYTE sSerialNumber[SERIALNO_LEN];   //SN
    BYTE byAlarmInPortNum;                 //DVR Alarm input
    BYTE byAlarmOutPortNum;             //DVR Alarm Output
    BYTE byDiskNum;                     //DVR Number of Hard Disk
    BYTE byDVRType;                     //DVR Type,  1: DVR 2: ATM DVR 3: DVS ......
    BYTE byChanNum;                     //DVR Number of Channel
    BYTE byStartChan;                     //The first Channel No. E.g. DVS- 1, DVR- 1
}NET_DVR_DEVICEINFO, *LPNET_DVR_DEVICEINFO;

//NET_DVR_Login_V30 () 
typedef struct
{
    BYTE sSerialNumber[SERIALNO_LEN];    //SN
    BYTE byAlarmInPortNum;                 //Number of Alarm input
    BYTE byAlarmOutPortNum;                 //Number of Alarm Output
    BYTE byDiskNum;                         //Number of Hard Disk
    BYTE byDVRType;                         //DVR Type,  1: DVR 2: ATM DVR 3: DVS ......
    BYTE byChanNum;                         //Number of Analog Channel
    BYTE byStartChan;                     //The first Channel No. E.g. DVS- 1, DVR- 1
    BYTE byAudioChanNum;                 //Number of Audio Channel
    BYTE byIPChanNum;                     //Maximum number of IP Channel  low
    BYTE byZeroChanNum;             //Zero channel encoding number//2010- 01- 16
    BYTE byMainProto;             //Main stream transmission protocol 0- private,  1- rtsp,2-both private and rtsp
    BYTE bySubProto;                 //Sub stream transmission protocol 0- private,  1- rtsp,2-both private and rtsp
    BYTE bySupport;         //Ability, the 'AND' result by bit: 0- not support;  1- support
    //bySupport & 0x1,  smart search
    //bySupport & 0x2,  backup
    //bySupport & 0x4,  get compression configuration ability
    //bySupport & 0x8,  multi network adapter
    //bySupport & 0x10, support remote SADP
    //bySupport & 0x20  support Raid card
    // bySupport & 0x40 support IPSAN directory search
    BYTE bySupport1;        // Ability expand, the 'AND' result by bit: 0- not support;  1- support
    // bySupport1 & 0x1, support snmp v30
    // bySupport1& 0x2,support distinguish download and playback
    //bySupport1 & 0x4, support deployment level
    //bySupport1 & 0x8, support vca alarm time extension 
    //bySupport1 & 0x10, support muti disks(more than 33)
    //bySupport1 & 0x20, support rtsp over http
    //bySupport1 & 0x40, support delay preview
    //bySuppory1 & 0x80 support NET_DVR_IPPARACFG_V40, in addition  support  License plate of the new alarm information
    BYTE bySupport2;        // Ability expand, the 'AND' result by bit: 0- not support;  1- support
    //bySupport & 0x1, decoder support get stream by URL
    //bySupport2 & 0x2,  support FTPV40
    //bySupport2 & 0x4,  support ANR
    //bySupport2 & 0x20, support get single item of device status
    //bySupport2 & 0x40,  support stream encryt
    WORD wDevType;              //device type
    BYTE bySupport3;        //Support  epresent by bit, 0 - not support 1 - support 
    //bySupport3 & 0x1- support batch config stream compress  
    //bySupport3 & 0x8  support use delay preview parameter when delay preview
    //bySupport3 & 0x10 support the interface of getting alarmhost main status V40
    BYTE byMultiStreamProto;//support multi stream, represent by bit, 0-not support ;1- support; bit1-stream 3 ;bit2-stream 4, bit7-main stream, bit8-sub stream
    BYTE byStartDChan;        //Start digital channel
    BYTE byStartDTalkChan;    //Start digital talk channel
    BYTE byHighDChanNum;        //Digital channel number high
    BYTE bySupport4;        //Support  epresent by bit, 0 - not support 1 - support
    //bySupport4 & 0x4 whether support video wall unified interface
    // bySupport4 & 0x80 Support device upload center alarm enable
    BYTE byLanguageType;    // support language type by bit,0-support,1-not support  
    //  byLanguageType 0 -old device
    //  byLanguageType & 0x1 support chinese
    //  byLanguageType & 0x2 support english
    BYTE byVoiceInChanNum;   //voice in chan num 
    BYTE byStartVoiceInChanNo; //start voice in chan num
    BYTE  bySupport5;  //0-no support,1-support,bit0-muti stream
    //bySupport5 &0x01support wEventTypeEx 
    //bySupport5 &0x04support sence expend
    BYTE  bySupport6;
    BYTE  byMirrorChanNum;    //mirror channel num,<it represents direct channel in the recording host>
    WORD  wStartMirrorChanNo;  //start mirror chan
    BYTE bySupport7;        //Support  epresent by bit, 0 - not support 1 - support 
    //bySupport7 & 0x1- supports INTER_VCA_RULECFG_V42 extension    
    // bySupport7 & 0x2  Supports HVT IPC mode expansion
    // bySupport7 & 0x04  Back lock time
    // bySupport7 & 0x08  Set the pan PTZ position, whether to support the band channel
    // bySupport7 & 0x10  Support for dual system upgrade backup
    // bySupport7 & 0x20  Support OSD character overlay V50
    // bySupport7 & 0x40  Support master slave tracking (slave camera)
    // bySupport7 & 0x80  Support message encryption 
    BYTE  byRes2;
}NET_DVR_DEVICEINFO_V30, *LPNET_DVR_DEVICEINFO_V30;

typedef struct tagNET_DVR_DEVICEINFO_V40
{
    NET_DVR_DEVICEINFO_V30 struDeviceV30;
    BYTE  bySupportLock;        //the device support lock function,this byte assigned by SDK.when bySupportLock is 1,dwSurplusLockTime and byRetryLoginTime is valid 
    BYTE  byRetryLoginTime;        //retry login times
    BYTE  byPasswordLevel;      //PasswordLevel,0-invalid,1-default password,2-valid password,3-risk password       
    BYTE  byProxyType;  //Proxy Type,0-not use proxy, 1-use socks5 proxy, 2-use EHome proxy
    DWORD dwSurplusLockTime;    //surplus locked time
    BYTE  byCharEncodeType;     //character encode type
    BYTE  bySupportDev5;//Support v50 version of the device parameters, device name and device type name length is extended to 64 bytes 
    BYTE  bySupport;  // capability set extension, bit and result: 0- no support, 1- support
    // bySupport & 0x1:0 - Reserved
    // bySupport & 0x2:0 - does not support changes to report 1- support change escalation
    BYTE  byLoginMode; //loginmodel 0-Private 1-ISAPI
    DWORD dwOEMCode;
    int iResidualValidity;
    BYTE  byResidualValidity;
    BYTE  byRes2[243];
}NET_DVR_DEVICEINFO_V40, *LPNET_DVR_DEVICEINFO_V40;

//sdk Network environment,  for update
typedef enum _SDK_NET_ENV
{
    LOCAL_AREA_NETWORK = 0,
    WIDE_AREA_NETWORK
}SDK_NETWORK_ENVIRONMENT;

//Display Mode
typedef enum
{
    NORMALMODE = 0,
    OVERLAYMODE
}DISPLAY_MODE;

//Send Mode
typedef enum
{
    PTOPTCPMODE = 0,
    PTOPUDPMODE,
    MULTIMODE,
    RTPMODE,
    RESERVEDMODE
}SEND_MODE;

//Grub Mode
typedef enum
{
    BMP_MODE = 0,         //BMP Mode
    JPEG_MODE = 1        //JPEG Mode 
}CAPTURE_MODE;

//Real time Audio mode
typedef enum
{
    MONOPOLIZE_MODE = 1, //exclusive mode
    SHARE_MODE = 2     //shared mode
}REALSOUND_MODE;

//Preview via software decoding
typedef struct
{
    LONG  lChannel; //channel no.
    LONG  lLinkMode; //If 31st bit is 0,  it means connect main stream,  is 1 means sub stream. Bit 0~bit 30 are used for link mode:  0:  TCP mode,  1:  UDP mode,  2:  Multi- play mode,  3:  RTP mode,4-RTP/RTSP,5-RSTP/HTTP
    HWND  hPlayWnd; // the play window's handle;  set NULL to disable preview
    char* sMultiCastIP;  //Multicast group
    BYTE byProtoType; //0-private protocol,1-RTSP protocol
    BYTE byRes[3];
}NET_DVR_CLIENTINFO, *LPNET_DVR_CLIENTINFO;

typedef struct tagNET_DVR_PREVIEWINFO{
    LONG    lChannel;         // Channel no.
    DWORD    dwStreamType;    // Stream type 0-main stream,1-sub stream,2-third stream,3-forth stream,4-fifth stream,5-sixth stream,7-seventh stream,8-eighth stream,9-ninth stream,10-tenth stream
    DWORD    dwLinkMode;        // Protocol type: 0-TCP, 1-UDP, 2-Muticast, 3-RTP,4-RTP/RTSP, 5-RSTP/HTTP
    HWND    hPlayWnd;        // Play window's handle;  set NULL to disable preview
    DWORD bBlocked;          //If data stream requesting process is blocked or not: 0-no, 1-yes  
    //if true, the SDK Connect failure return until 5s timeout  , not suitable for polling to preview.
    DWORD bPassbackRecord; //0- not enable  ,1 enable
    BYTE byPreviewMode;    // Preview mode 0-normal preview,2-delay preview
    BYTE byStreamID[STREAM_ID_LEN/*32*/];//Stream ID
    BYTE byProtoType; //0-private,1-RTSP
    BYTE byRes1;
    BYTE byVideoCodingType;
    DWORD dwDisplayBufNum; //soft player display buffer size(number of frames), range:1-50, default:1 
    BYTE byNPQMode;  //0-direct connect 1-by SMS
    BYTE byRes[215];
}NET_DVR_PREVIEWINFO, *LPNET_DVR_PREVIEWINFO;

//
typedef struct tagNET_DVR_PREVIEWINFO_SPECIAL
{
    char sURL[1024]; //instance:rtsp://admin:abcd12345@10.7.37.2:554/Streaming/Channels/101?transportmode=unicast
    DWORD dwLinkMode;//0:TCP,1:UDP,2-mcast,3-RTP,4-RTP/RTSP,5-RSTP/HTTP 
    HWND hPlayWnd;
    DWORD bBlocked;
    DWORD dwDisplayBufNum;
    BYTE byRes[64];
}NET_DVR_PREVIEWINFO_SPECIAL, *LPNET_DVR_PREVIEWINFO_SPECIAL;

//SDK information (9000 added) 
typedef struct
{
    DWORD dwTotalLoginNum;         //current login user operation number
    DWORD dwTotalRealPlayNum;     //current real play operation number
    DWORD dwTotalPlayBackNum;     //current playback or download operation number
    DWORD dwTotalAlarmChanNum;     //current alarm channel operation number
    DWORD dwTotalFormatNum;         //current HDD format operation number
    DWORD dwTotalFileSearchNum;     //current files search operation number
    DWORD dwTotalLogSearchNum;     //current logs search operation number
    DWORD dwTotalSerialNum;         //current transparent series port operation number
    DWORD dwTotalUpgradeNum;     //current upgrading operation number
    DWORD dwTotalVoiceComNum;     //current network voice communication operation number
    DWORD dwTotalBroadCastNum;     //current network broadcast voice communication operation number
    DWORD dwTotalListenNum;         //current net listen operation number
    DWORD dwEmailTestNum;        //current E- mail test operation number
    DWORD dwBackupNum;           //current backup  operation number
    DWORD dwTotalInquestUploadNum;  //current inquest upload operation number
    DWORD dwRes[6];
}NET_DVR_SDKSTATE, *LPNET_DVR_SDKSTATE;

//SDK Ability Information  (9000 added) 
typedef struct
{
    DWORD dwMaxLoginNum;         //maximum login user operation number MAX_LOGIN_USERS
    DWORD dwMaxRealPlayNum;         //maximum realplay operation number WATCH_NUM
    DWORD dwMaxPlayBackNum;         //maximum playback or download operation number WATCH_NUM
    DWORD dwMaxAlarmChanNum;     //maximum alarm channel operation number ALARM_NUM
    DWORD dwMaxFormatNum;         //maximum HDD format operation number SERVER_NUM
    DWORD dwMaxFileSearchNum;     //maximum files search operation number SERVER_NUM
    DWORD dwMaxLogSearchNum;     //maximum logs search operation number SERVER_NUM
    DWORD dwMaxSerialNum;         //maximum transparent series port operation number SERVER_NUM
    DWORD dwMaxUpgradeNum;         //maximum current upgrading operation number SERVER_NUM
    DWORD dwMaxVoiceComNum;         //maximum network voice communication operation number SERVER_NUM
    DWORD dwMaxBroadCastNum;     //maximum network broadcast voice communication operation number MAX_CASTNUM
    DWORD dwRes[10];
}NET_DVR_SDKABL, *LPNET_DVR_SDKABL;

//Alarm Device Infor
typedef struct
{
    BYTE byUserIDValid;                  /* Whether userID is valid,  0- invalid 1- valid. */
    BYTE bySerialValid;                  /* Whether serial number is valid,  0- invalid 1- valid.  */
    BYTE byVersionValid;                 /* Whether version number is valid,  0- invalid 1- valid. */
    BYTE byDeviceNameValid;              /* Whether device name is valid,  0- invalid 1- valid. */
    BYTE byMacAddrValid;                 /* Whether MAC address is valid,  0- invalid 1- valid. */
    BYTE byLinkPortValid;                /* Whether login port number is valid,  0- invalid 1- valid. */
    BYTE byDeviceIPValid;                /* Whether device IP is valid,  0- invalid 1- valid.*/
    BYTE bySocketIPValid;                /* Whether socket IP is valid,  0- invalid 1- valid. */
    LONG lUserID;                        /* NET_DVR_Login () effective when establishing alarm upload channel*/
    BYTE sSerialNumber[SERIALNO_LEN];     /* Serial number. */
    DWORD dwDeviceVersion;                 /* Version number,  2 high byte means the major version,  2 low byte means the minor version*/
    char sDeviceName[NAME_LEN];             /* Device name. */
    BYTE byMacAddr[MACADDR_LEN];         /* MAC address */
    WORD wLinkPort;                      /* link port */
    char sDeviceIP[128];                 /* IP address */
    char sSocketIP[128];                 /* alarm push- mode socket IP address. */
    BYTE byIpProtocol;                   /* IP protocol:  0- IPV4;  1- IPV6. */
    BYTE byRes1[2];
    BYTE bJSONBroken;                   //JSON Broken flag 0-not transmit 1-transmit
    WORD wSocketPort;
    BYTE byRes2[6];
}NET_DVR_ALARMER, *LPNET_DVR_ALARMER;

//Display Area Parameter of Hardware Decoding (Sub Structure) 
typedef struct
{
    long bToScreen;
    long bToVideoOut;
    long nLeft;
    long nTop;
    long nWidth;
    long nHeight;
    long nReserved;
}NET_DVR_DISPLAY_PARA, *LPNET_DVR_DISPLAY_PARA;

//Preview Parameter of Hardware Decoding
typedef struct
{
    LONG lChannel; // Channel No.
    LONG lLinkMode;  //0-  TCP;  1-  UDP;  2-  Multicast;  3-  RTP;  4-  PPPoE;  5-  128k;  6-  256k;  7-  384k;  8-  512k
    char* sMultiCastIP;
    NET_DVR_DISPLAY_PARA struDisplayPara;
}NET_DVR_CARDINFO, *LPNET_DVR_CARDINFO;

//Record Parameters
typedef struct
{
    char sFileName[100]; // File Name
    NET_DVR_TIME struStartTime; //Start time of the file
    NET_DVR_TIME struStopTime; //End time of the file
    DWORD dwFileSize; //File size
}NET_DVR_FIND_DATA, *LPNET_DVR_FIND_DATA;

//Record Parameters (9000) 
typedef struct
{
    char sFileName[100]; //File Name
    NET_DVR_TIME struStartTime; //Start time of the file
    NET_DVR_TIME struStopTime; //End time of the file
    DWORD dwFileSize; //File size
    char sCardNum[32];
    BYTE byLocked; //9000 DVR supports this, 1- file is locked, 0- file is Normal
    BYTE byFileType;   //File Type:  0:  scheduled record,  1:  Motion detection,  2:  alarm record,  3:  motion detection| alarm,  4:  motion detection & alarm 5:  command trigger,  6:  manually record
    //9-VCA alarm,10-PIR alarm,11-wireless alarm,12-callhelp alarm,14-Intelligent Transportation
    BYTE byRes[2];
}NET_DVR_FINDDATA_V30, *LPNET_DVR_FINDDATA_V30;

typedef struct
{
    char sFileName[100];
    NET_DVR_TIME struStartTime;
    NET_DVR_TIME struStopTime;
    DWORD dwFileSize;
    char sCardNum[32];
    BYTE byLocked;
    BYTE byFileType;
    BYTE byQuickSearch;
    BYTE byRes;
    DWORD dwFileIndex;
    BYTE byStreamType;
    BYTE byRes1[127];
}NET_DVR_FINDDATA_V40, *LPNET_DVR_FINDDATA_V40;


typedef struct tagNET_DVR_ADDRESS
{
    NET_DVR_IPADDR struIP;
    WORD wPort;
    BYTE byRes[2];
}NET_DVR_ADDRESS, *LPNET_DVR_ADDRESS;

typedef struct tagNET_DVR_FINDDATA_V50
{
    char sFileName[100];
    NET_DVR_TIME_SEARCH   struStartTime;
    NET_DVR_TIME_SEARCH   struStopTime;
    NET_DVR_ADDRESS struAddr; //address of vedio pieces , used by cluster playback
    DWORD   dwFileSize; //file size
    BYTE    byLocked; //is file locked?1-locked;0-unlock
    BYTE   byFileType; //file type ,same with V40
    BYTE   byQuickSearch; //0- normal,1- fast(calendar)query
    BYTE  byStreamType; //stream type:0- main stream,1- sub-stream,2- third stream
    DWORD  dwFileIndex; //file index
    char  sCardNum[32]; //card number
    BYTE   byRes[256];
}NET_DVR_FINDDATA_V50, *LPNET_DVR_FINDDATA_V50;

//Record Parameters (with Card No.) 
typedef struct
{
    char sFileName[100]; //File Name
    NET_DVR_TIME struStartTime; //Start time of the file
    NET_DVR_TIME struStopTime; //End time of the file
    DWORD dwFileSize; //File size
    char sCardNum[32];
}NET_DVR_FINDDATA_CARD, *LPNET_DVR_FINDDATA_CARD;


//Record Query Condition
typedef struct
{
    LONG lChannel; //channel number
    DWORD dwFileType; /*file record mode: 0xff - all,  0 - scheduled record,  1 - Motion detection,  2 - alarm record,  3:  motion detection| alarm,
                                      4 - motion detection & alarm, 5 - command trigger,  6 - manually record,7-VCA record,10-PIR alarm,11-wireless alarm,12-callhelp alarm,13-all Event alarm,14-Intelligent Transportation*/
    DWORD dwIsLocked; //whether file is locked,  0- normal;  1- locked;  0xff- all
    DWORD dwUseCardNo; //whether card no. is used
    BYTE sCardNumber[32]; //card no.
    NET_DVR_TIME struStartTime; //start time
    NET_DVR_TIME struStopTime; //end time
}NET_DVR_FILECOND, *LPNET_DVR_FILECOND;

// PTZ Image Zooming  (Special for private Speed dome) 
typedef struct
{
    int xTop;      //x coordinate of the origination point of the pane
    int yTop;      //y coordinate of the origination point of the pane
    int xBottom;   //x coordinate of the end point of the pane
    int yBottom;   //y coordinate of the end point of the pane
    int bCounter;  //reserve
}NET_DVR_POINT_FRAME, *LPNET_DVR_POINT_FRAME;

//audio encode type
typedef struct tagNET_DVR_COMPRESSION_AUDIO
{
    BYTE  byAudioEncType;    //AudioTalk Code Type 0-G722.1; 1-G711_U; 2-G711_A;5-MP2L2;6-G726;7-AAC,8-PCM;9-G722.1.C;12-AAC_LC;13-AAC_LD;14-Opus;
    BYTE  byAudioSamplingRate;//audio sample rate 0-default,1-16kHZ,2-32kHZ,3-48kHZ,4- 44.1kHZ,5-8kHZ
    BYTE  byAudioBitRate;// audio bitrate see BITRATE_ENCODE_INDEX
    BYTE  byres[4];//
    BYTE  bySupport;//bySupport Bit0- mp2l2 data is random length 
}NET_DVR_COMPRESSION_AUDIO, *LPNET_DVR_COMPRESSION_AUDIO;

//2009- 7- 22
#define IW_ESSID_MAX_SIZE                         32
#define WIFI_WEP_MAX_KEY_COUNT                     4
#define WIFI_WEP_MAX_KEY_LENGTH                     33
#define WIFI_WPA_PSK_MAX_KEY_LENGTH                 63
#define WIFI_WPA_PSK_MIN_KEY_LENGTH                 8
#define WIFI_MAX_AP_COUNT                         20
#define WIFI_WPA_PSK_MAX_HEXKEY_LENGTH           68   //WPA Hex Key Len

typedef struct tagNET_DVR_AP_INFO
{
    char  sSsid[IW_ESSID_MAX_SIZE];
    DWORD  dwMode;                         /* 0- mange mode; 1 ad- hoc mode, plz refer to NICMODE */
    DWORD  dwSecurity;            /*0 - not encrypted;  1 wep encrypted;  2 wpa- psk; 3 wpa- Enterprise; 4-WPA2_PSK;refer to WIFISECURITY*/
    DWORD  dwChannel;             /*1-11,  stands for 11 channels*/
    DWORD  dwSignalStrength;     /* Signal strength, 0 (lowest)- 100 (highest)*/
    DWORD  dwSpeed;                /* Signal speed, unit: 0.01mbps*/
}NET_DVR_AP_INFO, *LPNET_DVR_AP_INFO;

typedef struct tagNET_DVR_AP_INFO_LIST
{
    DWORD dwSize;
    DWORD dwCount;         /*Wireless AP number, should be less than 20*/
    NET_DVR_AP_INFO struApInfo[WIFI_MAX_AP_COUNT];
}NET_DVR_AP_INFO_LIST, *LPNET_DVR_AP_INFO_LIST;

typedef struct tagNET_DVR_WIFIETHERNET
{
    char    sIpAddress[16];                 /*IP*/
    char    sIpMask[16];                     /*Sub net mask*/
    BYTE    byMACAddr[MACADDR_LEN];         /*Physical address, read-only*/
    BYTE    byCloseWifi;        //whether close wifi,0-not close,1-close
    BYTE    bRes;
    DWORD    dwEnableDhcp;                 /*DHCP: 0-disable;  1- enable*/
    DWORD    dwAutoDns;                     /*Get DNS automatically after enable DHCP: 0-disable;  1-enable;  for cable network, DHCP will be set as 'get DNS automatically' mode*/
    char    sFirstDns[16];                          /*Preferred DNS*/
    char    sSecondDns[16];                      /*Alternate DNS*/
    char    sGatewayIpAddr[16];                  /*Network Gateway*/
    BYTE    bRes2[8];
}NET_DVR_WIFIETHERNET, *LPNET_DVR_WIFIETHERNET;

typedef struct tagNET_DVR_WIFI_CFG_EX
{
    NET_DVR_WIFIETHERNET struEtherNet;         /*WIFI port*/
    char sEssid[IW_ESSID_MAX_SIZE];      /*SSID*/
    DWORD dwMode;       /* 0- mange  mode; 1 ad- hoc mode*/
    DWORD dwSecurity;  /*0- no encryption; 1- wep encryption; 2 wpa- psk;3-WPA_ENTPRISE;4-WPA2_PSK,5-WPA2_ENTPRISE  */
    union
    {
        struct
        {
            DWORD dwAuthentication; /*0 - open mode;  1- share mode*/
            DWORD dwKeyLength; /* 0 - 64 bit;  1-  128bit;  2- 152 bit*/
            DWORD dwKeyType; /*0-HEX;  1-ASCI */
            DWORD dwActive; /*0- index: 0- - - 3 stands for the KEY mode*/
            char sKeyInfo[WIFI_WEP_MAX_KEY_COUNT][WIFI_WEP_MAX_KEY_LENGTH];
        }wep;
        struct
        {
            DWORD dwKeyLength; /*8~ 63 ASCII characters*/
            char sKeyInfo[WIFI_WPA_PSK_MAX_KEY_LENGTH];
            BYTE byEncryptType;  /*WPA/WPA2:0-AES, 1-TKIP*/
            char sNewKeyInfo[WIFI_WPA_PSK_MAX_HEXKEY_LENGTH/*68*/];//64bit WPA Hex Key 
            BYTE byKeyType;//Key Type
            BYTE byRes[7];
        }wpa_psk;
        struct
        {
            BYTE byEncryptType;  /*encry type,0-AES, 1-TKIP*/
            BYTE byAuthType; //auth type 0-EAP_TTLS,1-EAP_PEAP,2-EAP_TLS
            BYTE byRes[2];
            union
            {
                struct
                {
                    BYTE byEapolVersion; //EAPOL version,0-version1,1-version2
                    BYTE byAuthType; //inter auth type,0-PAP,1-MSCHAPV2
                    BYTE byRes1[2];
                    BYTE byAnonyIdentity[NAME_LEN]; //anony identity
                    BYTE byUserName[NAME_LEN];
                    BYTE byPassword[NAME_LEN];
                    BYTE byRes[44];
                }EAP_TTLS; //WPA-enterprise/WPA2-enterpris mode
                struct
                {
                    BYTE byEapolVersion; //EAPOL version,0-version1,1-version2
                    BYTE byAuthType; //inter auth type,0-PAP,1-MSCHAPV2
                    BYTE byPeapVersion; //PEAP version,0-version0,1-version1
                    BYTE byPeapLabel; //PEAP label,0-old label,1-new label
                    BYTE byAnonyIdentity[NAME_LEN]; //anony identity
                    BYTE byUserName[NAME_LEN];
                    BYTE byPassword[NAME_LEN];
                    BYTE byRes[44];
                }EAP_PEAP; //WPA-enterprise/WPA2-enterpris mode
                struct
                {
                    BYTE byEapolVersion; //EAPOL version,0-version1,1-version2
                    BYTE byRes1[3];
                    BYTE byIdentity[NAME_LEN]; //idetity
                    BYTE byPrivateKeyPswd[NAME_LEN];
                    BYTE byRes[76];
                }EAP_TLS;
            }auth_param;
        }wpa_wpa2; //WPA-enterprise/WPA2-enterpris mode
    }key;
}NET_DVR_WIFI_CFG_EX, *LPNET_DVR_WIFI_CFG_EX;

//WIFI configuration structure
typedef struct tagNET_DVR_WIFI_CFG
{
    DWORD dwSize;
    NET_DVR_WIFI_CFG_EX struWifiCfg;
}NET_DVR_WIFI_CFG, *LPNET_DVR_WIFI_CFG;

//wifi connection status
typedef     struct  tagNET_DVR_WIFI_CONNECT_STATUS
{
    DWORD        dwSize;
    BYTE        byCurStatus;    //1-connected,2-unconnected,3-connecting
    BYTE        byRes1[3];
    DWORD        dwErrorCode;    // valid when byCurStatus=2,1-username or password error,2-the router is nonexistent,3-unknown error
    BYTE        byRes[244];
}NET_DVR_WIFI_CONNECT_STATUS, *LPNET_DVR_WIFI_CONNECT_STATUS;

//WIFI working mode
typedef struct tagNET_DVR_WIFI_WORKMODE
{
    DWORD dwSize;
    DWORD dwNetworkInterfaceMode;  /*0- auto switch mode;  1- cable network*/
}NET_DVR_WIFI_WORKMODE, *LPNET_DVR_WIFI_WORKMODE;


//Structure parameters  
#define VCA_MAX_POLYGON_POINT_NUM        10        //Support polygon with up to 10 coordinates
#define MAX_RULE_NUM                    8        //Max. rule number
#define MAX_RULE_NUM_V42                16       //Max. rule number Expansion
#define MAX_TARGET_NUM                    30        //Max. target number
#define MAX_CALIB_PT                     6        //Max. calibration number
#define MIN_CALIB_PT                     4        //Min. calibration number
#define MAX_TIMESEGMENT_2                2        //Max. time periods number
#define DATA_INDEX_LEN                  64      //Data Index
#define MAX_DEV_DATAINDEX_LEN           64      //Device data index length
#define MAX_TRAFFIC_PICTURE_NUM         8      //Traffic Picture Num
#define MAX_LICENSE_LEN                    16        //Max. length of the license number
#define MAX_CARDNO_LEN                  48      //Max. Card No. 2013-11-04
#define MAX_DEBUGCMD_LEN                1024    //Debug CMD Len
#define MAX_DEBUGINFO_LEN               1400    //Debug Info Len
#define MAX_OPERATE_INDEX_LEN           32      //Max. Operate Index 2014-03-03
#define MAX_PLATE_NUM                    3        //license plate number
#define MAX_MASK_REGION_NUM                4       //Max. 4 mask area
#define MAX_SEGMENT_NUM                    6       //Max. segment number for camera calibration
#define MIN_SEGMENT_NUM                    3       //Min. segment number for camera calibration
#define MAX_REL_SNAPCHAN_NUM            3       //Max. relate snap channel number
#define MAX_PIC_SWITCH_STORAGE_SERVER   64      //Max. Storage Server Picture Type 
#define MAX_INFO_SWITCH_STORAGE_SERVER  64      //Max. Storage Server Add Info Type 
#define RTMP_URL_LEN                    128     //RTMP URL Len
#define MAX_ID_LEN_128                  128     //ID Len 128
#define MAX_VEHICLE_ID_LEN              32      //Max length of  vehicle ID 
#define LEN_PROPERTY                    128
//Intelligent config info
#define MAX_VCA_CHAN  16//Max. intelligent channel number
typedef struct tagNET_VCA_CTRLINFO
{
    BYTE   byVCAEnable;     //enable or disable intelligent function
    BYTE   byVCAType;       //intelligent analysis mode, VCA_CHAN_ABILITY_TYPE 
    BYTE   byStreamWithVCA; //include intelligent info in video stream
    BYTE   byMode;          //VCA_CHAN_MODE_TYPE for ATM intelligent analysis,TFS_CHAN_MODE_TYPE for TFS intelligent analysis
    BYTE   byControlType;   //control type,0-no,1-yes
    // byControlType &1 enable snap
    BYTE   byPicWithVCA;   //Alarm drawings superimposed target information (the target frame)
    BYTE   byRes[2];        //Reserved as 0 
}NET_VCA_CTRLINFO, *LPNET_VCA_CTRLINFO;

//Intelligent config info structure
typedef struct tagNET_VCA_CTRLCFG
{
    DWORD dwSize;
    NET_VCA_CTRLINFO  struCtrlInfo[MAX_VCA_CHAN];      //Config info, array 0 is corresponding to the 1st channel of the system
    BYTE byRes[16];
}NET_VCA_CTRLCFG, *LPNET_VCA_CTRLCFG;

//Intelligent device ability set
typedef struct tagNET_VCA_DEV_ABILITY
{
    DWORD dwSize;                //structure length
    BYTE byVCAChanNum;            //intelligent channel number
    BYTE byPlateChanNum;         //LPR channel number
    BYTE byBBaseChanNum;        //Basic VCA number
    BYTE byBAdvanceChanNum;    //Advanced VCA number
    BYTE byBFullChanNum;       //Complete VCA number
    BYTE byATMChanNum;            //Intelligent ATM number
    BYTE byPDCChanNum;         //PDC channel number
    BYTE byITSChanNum;         //Traffic event analysis channel number
    BYTE byBPrisonChanNum;        //VCA (prison surveillance version) channel number
    BYTE byFSnapChanNum;       //Face snap channel number
    BYTE byFSnapRecogChanNum;  //Face snap and recognize channel number
    BYTE byFRetrievalChanNum;  //Face retrieval channel number
    BYTE bySupport;            //ability, bit, 0-not support,1-support
    //bySupport & 0x1,support track 2012-3-22
    //bySupport & 0x2,support 128 channel 2012-12-27
    BYTE byFRecogChanNum;      //Face recognize channel number
    BYTE byBPPerimeterChanNum; //prison perimeter channel number
    BYTE byTPSChanNum;         //Traffic TPS channel number
    BYTE byTFSChanNum;         //Traffic TFS channel number
    BYTE byFSnapBFullChanNum;  //Face capture & behavioural analysis channel number
    BYTE byHeatMapChanNum;     //Heat Map Chan Num
    BYTE bySmartVehicleNum;  //SMART+Vehicle detection Chan Num
    BYTE bySmartHVTNum;     //SMART+HVT Chan Num
    BYTE bySmartNum;          //SMART  Num
    BYTE byVehicleNum;        //Vehicle detection Chan Num
    BYTE bySmartRoadDetectionNum; // SMART+Road Detection Chan Num
    BYTE bySmartFaceDetectionNum; // SMART+Face Detection Chan Num
    BYTE bySmartHeatMapNum; // SMART+Heat Map Chan Num
    BYTE byHumanRecognitionNum; //HumanRecognitionNum
    BYTE byEdcationStudentNum; //EdcationStudentNum
    BYTE byRoadDetectionNum;//Road Detection Num
    BYTE byPersonDensityDetection; //Personnel density detection num
    BYTE bySafetyHelmetDetection; //Safety helmet detection num
    BYTE byPerimeterCapture;//Perimeter Capture num
    BYTE byHeelPDC;//Heel PDC num
    BYTE by12MPLiveView;//1200 preview @20fps(4000*3000)
    BYTE byTeacherBehaviorDetectNum; //Teacher behavior detect num
    BYTE byMixedTargetDetection;     //Mixed target detection
    BYTE byFaceContrast;//face contrast
    BYTE byCityManagement;//city management
    BYTE byMixedTargetDetectionSmart;//Mixed target detection and Smart
    BYTE byRes;
}NET_VCA_DEV_ABILITY, *LPNET_VCA_DEV_ABILITY;


//VCA Abilities Set
typedef enum _VCA_ABILITY_TYPE_
{
    TRAVERSE_PLANE_ABILITY = 0x01,        //traverse plane
    ENTER_AREA_ABILITY = 0x02,        //Enter area
    EXIT_AREA_ABILITY = 0x04,        //Leave area
    INTRUSION_ABILITY = 0x08,        //Intrusion
    LOITER_ABILITY = 0x10,        //Loitering
    LEFT_TAKE_ABILITY = 0x20,        //Object left/take
    PARKING_ABILITY = 0x40,        //Illegal parking
    RUN_ABILITY = 0x80,        //Running
    HIGH_DENSITY_ABILITY = 0x100,       //People density
    LF_TRACK_ABILITY = 0x200,       //Auto-tracking of the speed dome
    VIOLENT_MOTION_ABILITY = 0x400,         //Violent motion
    REACH_HIGHT_ABILITY = 0x800,         //Reach High
    GET_UP_ABILITY = 0x1000,         //Get up
    LEFT_ABILITY = 0x2000,      //Item left
    TAKE_ABILITY = 0x4000,      //Item take
    LEAVE_POSITION = 0x8000,      //Leave position
    TRAIL_ABILITY = 0x10000,     //Trial
    KEY_PERSON_GET_UP_ABILITY = 0x20000,     //Key person get up
    STANDUP_ABILITY = 0x40000,     //Stand Up
    FALL_DOWN_ABILITY = 0x80000,     //Fall down
    AUDIO_ABNORMAL_ABILITY = 0x100000,    //Audio abnormal
    ADV_REACH_HEIGHT_ABILITY = 0x200000,    //Advance reach height
    TOILET_TARRY_ABILITY = 0x400000,    //Toilet tarry
    YARD_TARRY_ABILITY = 0x800000,    //Yard tarry
    ADV_TRAVERSE_PLANE_ABILITY = 0x1000000,   //Advance traverse plane
    LECTURE_ABILITY = 0x2000000,   //Teaching
    ANSWER_ABILITY = 0x4000000,   //Answer
    HUMAN_ENTER_ABILITY = 0x10000000,  //Human enter ATM, supported only in ATM_PANEL mode
    OVER_TIME_ABILITY = 0x20000000,  //Overtime, supported only in ATM_PANEL mode
    STICK_UP_ABILITY = 0x40000000,  //ATM stick-up
    INSTALL_SCANNER_ABILITY = 0x80000000   //Install scanner on ATM
}VCA_ABILITY_TYPE;

typedef enum _VCA_ABILITY_TYPE_EX_
{
    PEOPLENUM_CHANGE_ABILITY = 0x00000002, //PeopleNum Change
    SPACING_CHANGE_ABILITY = 0x00000004,   //Spacing Change
    EVENT_COMBINED_ABILITY = 0x00000008,   //Combined Event
    EVENT_SIT_QUIETLY = 0x00000010,     //Sit Quietly
    EVENT_HIGH_DENSITY_STATUS_ABILITY = 0x00000020,    //high density status
    EVENT_RUNNING = 0x00000040,        //running
    EVENT_RETENTION = 0x00000080, //retention
    EVENT_TEACHER_WRITING = 0x00000100   //Writing
}VCA_ABILITY_TYPE_EX;

//Intelligent channel type
typedef enum _VCA_CHAN_ABILITY_TYPE_
{
    VCA_BEHAVIOR_BASE = 1,     //Basic VCA
    VCA_BEHAVIOR_ADVANCE = 2,     //Advanced VCA
    VCA_BEHAVIOR_FULL = 3,     //FULL VCA
    VCA_PLATE = 4,     //LPR
    VCA_ATM = 5,     //ATM
    VCA_PDC = 6,     //PDC
    VCA_ITS = 7,     //Intelligent traffic surveillance
    VCA_BEHAVIOR_PRISON = 8,     //VCA (prison surveillance version)  
    VCA_FACE_SNAP = 9,     //Face snap
    VCA_FACE_SNAPRECOG = 10,    //Face snap and recognize
    VCA_FACE_RETRIEVAL = 11,    //Face retrieval
    VCA_FACE_RECOG = 12,    //Face recognize
    VCA_BEHAVIOR_PRISON_PERIMETER = 13,    //VCA (prison perimeter version)
    VCA_TPS = 14,    //TPS
    VCA_TFS = 15,    //TFS
    VCA_BEHAVIOR_FACESNAP = 16,    //FACESNAP and BEHAVIOR
    VCA_HEATMAP = 17,    //Heat Map
    VCA_SMART_VEHICLE_DETECTION = 18,    // SMART+ Vehicle detection
    VCA_SMART_HVT_DETECTION = 19,    // SMART+ HVT detection
    VCA_SMART_EVENT = 20,    // SMART Event
    VCA_VEHICLE_DETECTION = 21,    // Vehicle detection
    VCA_SMART_ROAD_DETECTION = 22,    // SMART + Road Detection
    VCA_SMART_FACE_DETECTION = 23,    // SMART + Face Detection
    VCA_SMART_HEATMAP = 24,     // SMART + Heat Map
    VCA_HUMAN_RECOGNITION = 25,       // human recognition
    VCA_EDUCATION_STUDENT_DETECTION = 26,  //education Student Detection
    VCA_ROAD_DETECTION = 27,      //Road Detection
    VCA_PERSON_DENSITY_DETECTION = 28,     //Personnel density detection
    VCA_PERIMETER_CAPTURE = 29,           //Perimeter Capture
    VCA_SAFETY_HELMET_DETECTION = 30,     //Safety helmet detection
    VCA_HEEL_PDC = 31,                     //Heel PDC
    VCA_12MPLIVE_VIEW = 32,                //1200W@20fps Preview
    VCA_TEACHER_BEHAVIOR_DETECTION = 33,    //Teacher behavior detection
    VCA_MIXED_TARGET_DETECTION = 34,        //mixed target detection
    VCA_FACE_CONTRAST = 35,                 //face contrast
    VCA_CITY_MANAGEMENT = 36,                //city manager
    VCA_MIXED_TARGET_DETECTION_SMART = 37    //mixed target detection and Smart
}VCA_CHAN_ABILITY_TYPE;

//Intelligent ATM Mode 
typedef enum _VCA_CHAN_MODE_TYPE_
{
    VCA_ATM_PANEL = 0,  //ATM front panel
    VCA_ATM_SURROUND = 1,  //ATM scenario
    VCA_ATM_FACE = 2,     //ATM face recognition & private ATM face detect
    VCA_ATM_SAFETYCABIN = 3  //ATM safetycabin
}VCA_CHAN_MODE_TYPE;


//Intelligent TFS Mode 
typedef enum _TFS_CHAN_MODE_TYPE_
{
    TFS_CITYROAD = 0,  //TFS city road
    TFS_FREEWAY = 1   //TFS free way
}TFS_CHAN_MODE_TYPE;

//Behavior scene mode
typedef enum _BEHAVIOR_SCENE_MODE_TYPE_
{
    BEHAVIOR_SCENE_DEFAULT = 0, //System default
    BEHAVIOR_SCENE_WALL = 1,    //Wall
    BEHAVIOR_SCENE_INDOOR = 2   //Indoor
}BEHAVIOR_SCENE_MODE_TYPE;

//Prison Mode 
typedef enum _BEHAVIOR_PRISON_MODE_TYPE_
{
    BEHAVIOR_PRISON = 0, //Prison
    BEHAVIOR_HEARING = 1, //Hearing
    BEHAVIOR_RECFIELD = 2  //Recfield
}BEHAVIOR_PRISON_MODE_TYPE, LPBEHAVIOR_PRISON_MODE_TYPE;

//Channel ability input
typedef struct tagNET_VCA_CHAN_IN_PARAM
{
    BYTE byVCAType;     //VCA_CHAN_ABILITY_TYPE enum
    BYTE byMode;         //VCA_CHAN_MODE_TYPE for ATM analysis; TFS_CHAN_MODE_TYPE for TFS analysis; when VCA_TYPE is traffic event, please refer to TRAFFIC_SCENE_MODE
    BYTE byRes[2];      //Reserved
}NET_VCA_CHAN_IN_PARAM, *LPNET_VCA_CHAN_IN_PARAM;


//Behavior ability set
typedef struct tagNET_VCA_BEHAVIOR_ABILITY
{
    DWORD dwSize;          //Structure length
    DWORD dwAbilityType;  //Support ability type by digit, please refer to VCA_ABILITY_TYPE
    BYTE byMaxRuleNum;      //Max. rule number
    BYTE byMaxTargetNum;  //Max. target number
    BYTE    bySupport;         //Function type supported (represented by digit)  
    // bySupport & 0x01 -Calibration
    BYTE byRes[5];         //Reserved as 0
    DWORD dwAbilityTypeEx;  //Support ability type by digit, please refer to VCA_ABILITY_TYPE_EX
}NET_VCA_BEHAVIOR_ABILITY, *LPNET_VCA_BEHAVIOR_ABILITY;

typedef struct tagNET_DVR_SCENE_CHANGE_UPDATE_PARAM
{
    DWORD    dwSize;
    BYTE    byIDCount;
    BYTE    byRes1[3];
    BYTE    byStreamID[MAX_STREAM_ID_NUM][STREAM_ID_LEN];
    BYTE    byRes[256];
}NET_DVR_SCENE_CHANGE_UPDATE_PARAM, *LPNET_DVR_SCENE_CHANGE_UPDATE_PARAM;

// Traffic ability structure
typedef struct tagNET_DVR_ITS_ABILITY
{
    DWORD     dwSize;             //Structure size
    DWORD     dwAbilityType;      //Supported ability list, see to ITS_ABILITY_TYPE
    BYTE     byMaxRuleNum;         //Max number of rules
    BYTE     byMaxTargetNum;     //Max number of targets
    BYTE    byRes[10];            //Reserved
}NET_DVR_ITS_ABILITY, *LPNET_DVR_ITS_ABILITY;

/***********************************end*******************************************/

/************************************Intelligent Parameter Structure*********************************/
//Public structure for intelligent functions
//Coordinates normalized, and the  floating-point value is the percentage of the current screen size
//Take accuracy of three decimal places

//Region
typedef struct tagNET_VCA_RECT
{
    float fX;                //X axis coordinate of the upper-left,  0.001~1
    float fY;                //Y axis coordinate of the upper-left,  0.001~1
    float fWidth;            //Region width,  0.001~1
    float fHeight;           //Region height,  0.001~1
}NET_VCA_RECT, *LPNET_VCA_RECT;

//Behavior event type
typedef enum _VCA_EVENT_TYPE_
{
    VCA_TRAVERSE_PLANE = 0x1,        //Traverse plane
    VCA_ENTER_AREA = 0x2,         //Enter area (region rule)
    VCA_EXIT_AREA = 0x4,         //Leave area (region rule)
    VCA_INTRUSION = 0x8,         //Intrusion (region rule)
    VCA_LOITER = 0x10,         //Loitering (region rule)
    VCA_LEFT_TAKE = 0x20,         //Object left or take (region rule)
    VCA_PARKING = 0x40,         //Illegal parking (region rule)
    VCA_RUN = 0x80,         //Running (region rule)
    VCA_HIGH_DENSITY = 0x100,         //People density (region rule)
    VCA_VIOLENT_MOTION = 0x200,      //Violent motion
    VCA_REACH_HIGHT = 0x400,      //Reach high
    VCA_GET_UP = 0x800,      //Get up
    VCA_LEFT = 0x1000,     //Item left
    VCA_TAKE = 0x2000,     //Item take
    VCA_LEAVE_POSITION = 0x4000,     //Leave position
    VCA_TRAIL = 0x8000,     //Trail
    VCA_KEY_PERSON_GET_UP = 0x10000,    //Key person get up
    VCA_STANDUP = 0x20000,    //Stand Up
    VCA_FALL_DOWN = 0x80000,    //Fall down
    VCA_AUDIO_ABNORMAL = 0x100000,   //Audio abnormal
    VCA_ADV_REACH_HEIGHT = 0x200000,   //Advance reach height
    VCA_TOILET_TARRY = 0x400000,   //Toilet tarry
    VCA_YARD_TARRY = 0x800000,   //Yard tarry
    VCA_ADV_TRAVERSE_PLANE = 0x1000000,  //Advance traverse plane
    VCA_LECTURE = 0x2000000,  //Lecture
    VCA_ANSWER = 0x4000000,  //Answer
    VCA_HUMAN_ENTER = 0x10000000, //Human enter ATM, supported only in ATM_PANEL mode
    VCA_OVER_TIME = 0x20000000, //Operation overtime, supported only in ATM_PANEL mode
    VCA_STICK_UP = 0x40000000, //ATM stick up (region rule)
    VCA_INSTALL_SCANNER = 0x80000000  //Install scanner on ATM (region rule)
}VCA_EVENT_TYPE;

//Behavior event type(extended)
typedef enum _VCA_RULE_EVENT_TYPE_EX_
{
    ENUM_VCA_EVENT_TRAVERSE_PLANE = 1,   //Traverse plane
    ENUM_VCA_EVENT_ENTER_AREA = 2,   //Enter area
    ENUM_VCA_EVENT_EXIT_AREA = 3,   //Leave area
    ENUM_VCA_EVENT_INTRUSION = 4,   //Intrusion
    ENUM_VCA_EVENT_LOITER = 5,   //Loitering
    ENUM_VCA_EVENT_LEFT_TAKE = 6,   //Object left or take
    ENUM_VCA_EVENT_PARKING = 7,   //Illegal parking
    ENUM_VCA_EVENT_RUN = 8,   //Running
    ENUM_VCA_EVENT_HIGH_DENSITY = 9,   //People density
    ENUM_VCA_EVENT_VIOLENT_MOTION = 10,  //Violent motion
    ENUM_VCA_EVENT_REACH_HIGHT = 11,  //Reach high
    ENUM_VCA_EVENT_GET_UP = 12,  //Get up
    ENUM_VCA_EVENT_LEFT = 13,  //Item left
    ENUM_VCA_EVENT_TAKE = 14,  //Item take
    ENUM_VCA_EVENT_LEAVE_POSITION = 15,  //Leave position
    ENUM_VCA_EVENT_TRAIL = 16,  //Trail
    ENUM_VCA_EVENT_KEY_PERSON_GET_UP = 17,  //Key person get up
    ENUM_VCA_EVENT_STANDUP = 18,  //Stand Up
    ENUM_VCA_EVENT_FALL_DOWN = 20,  //Fall down
    ENUM_VCA_EVENT_AUDIO_ABNORMAL = 21,  //Audio abnormal
    ENUM_VCA_EVENT_ADV_REACH_HEIGHT = 22,  //Advance reach height
    ENUM_VCA_EVENT_TOILET_TARRY = 23,  //Toilet tarry
    ENUM_VCA_EVENT_YARD_TARRY = 24,  //Yard tarry
    ENUM_VCA_EVENT_ADV_TRAVERSE_PLANE = 25,  //Advance traverse plane
    ENUM_VCA_EVENT_LECTURE = 26,  //Lecture
    ENUM_VCA_EVENT_ANSWER = 27,  //Answer
    ENUM_VCA_EVENT_HUMAN_ENTER = 29,  //Human enter ATM, supported only in ATM_PANEL mode  
    ENUM_VCA_EVENT_OVER_TIME = 30,  //Operation overtime, supported only in ATM_PANEL mode
    ENUM_VCA_EVENT_STICK_UP = 31,  //ATM stick up (region rule)
    ENUM_VCA_EVENT_INSTALL_SCANNER = 32,  //Install scanner on ATM (region rule)
    ENUM_VCA_EVENT_PEOPLENUM_CHANGE = 35,  //People Num Change
    ENUM_VCA_EVENT_SPACING_CHANGE = 36,  //Spacing Change
    ENUM_VCA_EVENT_COMBINED_RULE = 37,  //Combination Events
    ENUM_VCA_EVENT_SIT_QUIETLY = 38,   //Sit Quietly    
    ENUM_VCA_EVENT_HIGH_DENSITY_STATUS = 39,   //People density status
    ENUM_VCA_EVENT_RUNNING = 40, //Run detection
    ENUM_VCA_EVENT_RETENTION = 41, //Detention detection
    ENUM_VCA_EVENT_BLACKBOARD_WRITE = 42,   //Black Board Writing
    ENUM_VCA_EVENT_SITUATION_ANALYSIS = 43   //Situational analysis
} VCA_RULE_EVENT_TYPE_EX;

//Traverse plane direction
typedef enum _VCA_CROSS_DIRECTION_
{
    VCA_BOTH_DIRECTION,   // Bi-direction
    VCA_LEFT_GO_RIGHT,    // Left to right
    VCA_RIGHT_GO_LEFT     // Right to left
}VCA_CROSS_DIRECTION;

//Line
typedef struct tagNET_VCA_LINE
{
    NET_VCA_POINT struStart;     // start point
    NET_VCA_POINT struEnd;       // end point
}NET_VCA_LINE, *LPNET_VCA_LINE;

//Polygon
typedef struct tagNET_VCA_POLYGON
{
    DWORD dwPointNum;                                   //Valid point number , should be no less than 3 
    NET_VCA_POINT  struPos[VCA_MAX_POLYGON_POINT_NUM];  //Boundary point, up to 10 points for each polygon
}NET_VCA_POLYGON, *LPNET_VCA_POLYGON;

//Traverse plane 
typedef struct tagNET_VCA_TRAVERSE_PLANE
{
    NET_VCA_LINE struPlaneBottom;          //Bottom line of the alarm plane
    VCA_CROSS_DIRECTION dwCrossDirection;  //Traverse direction:  0- bi-directional, 1- left to right, 2- right to left
    BYTE bySensitivity;                    //[1,5]
    BYTE byPlaneHeight;                    //Height of the alarm plane
    BYTE byDetectionTarget;                //DetectionTarget: 0-all, 0x01-Human,0x02-Vehicle,0x04-Others
    BYTE byPriority;//byPriority,0-low,1-mid,2-high
    BYTE byRes2[36];
}NET_VCA_TRAVERSE_PLANE, *LPNET_VCA_TRAVERSE_PLANE;

typedef struct tagNET_VCA_SIT_QUIETLY
{
    NET_VCA_POLYGON struRegion;//Region
    DWORD   dwDuration;         // trigger after:  1- 3600 second   
    BYTE    byRes[4];
} NET_VCA_SIT_QUIETLY, *LPNET_VCA_SIT_QUIETLY;

//Enter or Leave area
typedef struct tagNET_VCA_AREA
{
    NET_VCA_POLYGON struRegion; //Region
    BYTE bySensitivity;        //Sensitiviity,[1,5]
    BYTE byDetectionTarget;    //DetectionTarget:0-all,0x01-Human,0x02-Vehicle,0x04-Others
    BYTE byPriority;//byPriority,0-low,1-mid,2-high
    BYTE byRes[5];
}NET_VCA_AREA, *LPNET_VCA_AREA;

//Mark the alarm snapshot according to the alarm delay time (alarm interval is consistent with IO alarm), send 1 snapshot every second
//Intrusion
typedef struct tagNET_VCA_INTRUSION
{
    NET_VCA_POLYGON struRegion; //region
    WORD wDuration;     // trigger after:  1- 120 second, suggested 5 
    BYTE bySensitivity;  //[1-100]
    BYTE byRate;
    BYTE byDetectionTarget;    //DetectionTarget: 0-all, 0x01-Human, 0x02-Vehicle,0x04-Others
    BYTE byPriority;//Priority,0-low,1-mid,2-high
    BYTE byRes[2];
}NET_VCA_INTRUSION, *LPNET_VCA_INTRUSION;

//Loitering
typedef struct tagNET_VCA_LOITER
{
    NET_VCA_POLYGON struRegion; //Region
    WORD wDuration;  //Trigger after: 1- 120 second, suggested 10
    BYTE bySensitivity;            //Sensitivity, [1,5]
    BYTE byres[1];
    DWORD dwLoiterDistance; //Total travel distance threshold 100-5000,default 1000cm
}NET_VCA_LOITER, *LPNET_VCA_LOITER;

//Object left or taken
typedef struct tagNET_VCA_TAKE_LEFT
{
    NET_VCA_POLYGON struRegion; //Region
    WORD wDuration;  //Trigger after: 1- 120 second, suggested 10
    BYTE bySensitivity;            //Sensitivity, value range: [1,5]
    BYTE byRes[5];
}NET_VCA_TAKE_LEFT, *LPNET_VCA_TAKE_LEFT;

//Illegal 
typedef struct tagNET_VCA_PARKING
{
    NET_VCA_POLYGON struRegion;     //Region
    WORD wDuration;                 //Trigger after: 1- 100 second, suggested 10
    BYTE bySensitivity;            //Sensitivity, value range: [1,5]
    BYTE byRes[5];
}NET_VCA_PARKING, *LPNET_VCA_PARKING;

//Running
typedef struct tagNET_VCA_RUN
{
    NET_VCA_POLYGON struRegion; //Region
    float   fRunDistance;         //Target running distance: [0.1,  1.00]
    BYTE    bySensitivity;    //Sensitivity, value range: [1,5]
    BYTE    byMode;             // 0- pixel mode, 1- actual mode
    BYTE    byDetectionTarget;    //DetectionTarget: 0-All, 0x01-human, 0x02-Vehicle
    BYTE    byRes;
}NET_VCA_RUN, *LPNET_VCA_RUN;

//People gathering
typedef struct tagNET_VCA_HIGH_DENSITY
{
    NET_VCA_POLYGON struRegion;     //Region
    float fDensity;                 //Density range:  [0.1,  1.0]
    BYTE            bySensitivity;    //Sensitivity, value range: [1,5]
    BYTE            byRes;          //Reserved
    WORD            wDuration;      //Threshold of triggering people aggregation alarm,value: 20-360s
}NET_VCA_HIGH_DENSITY, *LPNET_VCA_HIGH_DENSITY;

//Violent motion
typedef struct tagNET_VCA_VIOLENT_MOTION
{
    NET_VCA_POLYGON struRegion; //Region
    WORD  wDuration;            //Trigger after: 1- 120 second
    BYTE  bySensitivity;        //Sensitivity range: [1, 5]
    BYTE  byMode;               //0-Video only,1-Video and audio,2-Audio only
    BYTE  byRes[4];             //Reserved
}NET_VCA_VIOLENT_MOTION, *LPNET_VCA_VIOLENT_MOTION;

// Reach high
typedef struct tagNET_VCA_REACH_HIGHT
{
    NET_VCA_LINE struVcaLine;    //Alarm plane
    WORD wDuration;  //Trigger after: 1- 120 second
    BYTE    byRes[6];            // Reserved
}NET_VCA_REACH_HIGHT, *LPNET_VCA_REACH_HIGHT;

// Get up
typedef struct tagNET_VCA_GET_UP
{
    NET_VCA_POLYGON struRegion;  //Region
    WORD    wDuration;           //Trigger after: 1- 100 second
    BYTE    byMode;              //mode,0-big bed,1-wide bed,2-sitting
    BYTE    bySensitivity;       //Sensitivity range:[1,10]
    BYTE    byRes[4];            //Reserved
}NET_VCA_GET_UP, *LPNET_VCA_GET_UP;

// Items left
typedef struct tagNET_VCA_LEFT
{
    NET_VCA_POLYGON struRegion;        // Region 
    WORD            wDuration;         // Threshold of triggering itmes left alarm, value: 4-60s
    BYTE            bySensitivity;     //[1,5]
    BYTE            byRes[5];          // Reserved
}NET_VCA_LEFT, *LPNET_VCA_LEFT;

//Items take
typedef struct tagNET_VCA_TAKE
{
    NET_VCA_POLYGON struRegion;     // Region
    WORD            wDuration;      // Threshold of triggering itmes take alarm, value: 4-60s
    BYTE            bySensitivity;  //[1,5]
    BYTE            byRes[5];       // Reserved
}NET_VCA_TAKE, *LPNET_VCA_TAKE;

typedef struct tagNET_VCA_OVER_TIME
{
    NET_VCA_POLYGON     struRegion; // Region
    WORD               wDuration;   // Time threshold of operation alarm, value: 4s-60000s
    BYTE   byRes[6];                // Reserved
}NET_VCA_OVER_TIME, *LPNET_VCA_OVER_TIME;

typedef struct tagNET_VCA_HUMAN_ENTER
{
    DWORD                dwRes[23];            //Reserved
}NET_VCA_HUMAN_ENTER, *LPNET_VCA_HUMAN_ENTER;

//ATM stick up
typedef struct tagNET_VCA_STICK_UP
{
    NET_VCA_POLYGON struRegion; //Region
    WORD wDuration;  //Trigger after: 4- 60 second, suggested 10 second
    BYTE  bySensitivity;        // Sensitivity range: [1, 5]
    BYTE byRes[5];
}NET_VCA_STICK_UP, *LPNET_VCA_STICK_UP;

//Install scanner on ATM
typedef struct tagNET_VCA_SCANNER
{
    NET_VCA_POLYGON struRegion; //Region
    WORD wDuration;  // Scanner reading time: 4- 60 seconds
    BYTE  bySensitivity;        // Sensitivity range: [1, 5]
    BYTE byRes[5];
}NET_VCA_SCANNER, *LPNET_VCA_SCANNER;

//Leave position
typedef struct tagNET_VCA_LEAVE_POSITION
{
    NET_VCA_POLYGON   struRegion; //Region
    WORD wLeaveDelay;  //Alarm time of no people, unit: s
    WORD wStaticDelay; //Alarm time of sleeping, unit: s
    BYTE byMode;       //mode,0-leave,1-sleep,2-leave and sleep
    BYTE byPersonType; //Person on guard,0-single,1-couple
    BYTE   byOnPosition; //Number of posts, 1-10, default 1
    BYTE      bySensitivity;     //sensitivity, 1-5
}NET_VCA_LEAVE_POSITION, *LPNET_VCA_LEAVE_POSITION;

//Trail
typedef struct tagNET_VCA_TRAIL
{
    NET_VCA_POLYGON struRegion;//Region
    WORD  wRes;
    BYTE  bySensitivity;       /* Sensitivity range: [1, 5] */
    BYTE  byRes[5];
}NET_VCA_TRAIL, *LPNET_VCA_TRAIL;

//Fall down
typedef struct tagNET_VCA_FALL_DOWN
{
    NET_VCA_POLYGON struRegion;//Region
    WORD  wDuration;         /* Threshold of triggering itmes take alarm, value: 1-60s*/
    BYTE  bySensitivity;     /* Sensitivity range: [1, 5] */
    BYTE  byHeightThreshold; //Height Threshold,Range[0,250]
    BYTE  byRes[4];
}NET_VCA_FALL_DOWN, *LPNET_VCA_FALL_DOWN;

//Stand Up
typedef struct tagNET_VCA_STANDUP
{
    NET_VCA_POLYGON  struRegion; //Region
    BYTE  bySensitivity;     //Sensitivity range: [1, 100] 
    BYTE  byHeightThreshold; //Height Threshold,Range[0,250]
    WORD  wDuration;         //Threshold of triggering itmes take alarm, value: 1-60s
    BYTE  byRes[4];
}NET_VCA_STANDUP, *LPNET_VCA_STANDUP;


//People Num Change
typedef struct tagNET_VCA_PEOPLENUM_CHANGE
{
    NET_VCA_POLYGON  struRegion; //Region
    BYTE  bySensitivity;        //Sensitivity range: [1, 100] 
    BYTE  byPeopleNumThreshold; //People Num Threshold,range: [0,5]
    BYTE  byDetectMode;         //Detect Mode,Comparison People Num Threshold.1-Greater than,2- less than ,3-equal to ,4-Not equal to 
    BYTE  byNoneStateEffective; //None State Effective,0-Invalid,1-Effective
    WORD  wDuration;  //Threshold of triggering itmes take alarm, value:[1,3600]
    BYTE  byPeopleNum; //Number of alarm triggered, read only
    BYTE  byRes;
}NET_VCA_PEOPLENUM_CHANGE, *LPNET_VCA_PEOPLENUM_CHANGE;

//Spacing Change
typedef struct tagNET_VCA_SPACING_CHANGE
{
    NET_VCA_POLYGON  struRegion; //Region
    float fSpacingThreshold; //Spacing Threshold,range: [0,10.0],Unit: M
    BYTE  bySensitivity;     //Sensitivity range: [1, 100] 
    BYTE  byDetectMode;      //Detect Mode,Comparison Spacing Threshold.1-Greater than,2- less than
    WORD  wDuration;  //Threshold of triggering itmes take alarm, value:[1,3600]  
}NET_VCA_SPACING_CHANGE, *LPNET_VCA_SPACING_CHANGE;

//Audio abnormal
typedef struct tagNET_VCA_AUDIO_ABNORMAL
{
    WORD wDecibel;       //Audio decibel
    BYTE bySensitivity;  //Sensitivity range: [1, 100] 
    BYTE byAudioMode;    //Audio mode,0-enable sensitivity detect,1-enable decibel threshold,2-enable sensitivity and decibel threshold detect
    BYTE byEnable;       //0-disabled,1-enabled
    BYTE byThreshold;    //Sound threshold:[1,100]
    BYTE byRes[54];      //Reserved           
}NET_VCA_AUDIO_ABNORMAL, *LPNET_VCA_AUDIO_ABNORMAL;

//Sound intensity dropped 2014-03-21
typedef struct tagNET_DVR_AUDIO_STEEP_DROP
{
    BYTE  bySensitivity;   /* Sensitivity [1,100] */
    BYTE  byEnable;        //Enable
    BYTE  byRes[6];
}NET_DVR_AUDIO_STEEP_DROP, *LPNET_DVR_AUDIO_STEEP_DROP;

typedef struct tagNET_DVR_AUDIO_EXCEPTION
{
    DWORD                       dwSize;
    BYTE                        byEnableAudioInException;
    BYTE                        byRes1[3];
    NET_VCA_AUDIO_ABNORMAL      struAudioAbnormal;
    NET_DVR_SCHEDTIME           struAlarmSched[MAX_DAYS][MAX_TIMESEGMENT_V30];
    NET_DVR_HANDLEEXCEPTION_V40 struHandleException;
    DWORD                       dwMaxRelRecordChanNum;
    DWORD                       dwRelRecordChanNum;
    DWORD                       byRelRecordChan[MAX_CHANNUM_V30];
    NET_DVR_AUDIO_STEEP_DROP    struAudioSteepDrop;      //Sound intensity dropped
    BYTE                        byRes2[24];
}NET_DVR_AUDIO_EXCEPTION, *LPNET_DVR_AUDIO_EXCEPTION;

typedef struct tagNET_VCA_TOILET_TARRY
{
    NET_VCA_POLYGON struRegion;//region
    WORD wDelay;        //delay[1,3600],uint:s
    BYTE byRes[6];
}NET_VCA_TOILET_TARRY, *LPNET_VCA_TOILET_TARRY;

typedef struct tagNET_VCA_YARD_TARRY
{
    NET_VCA_POLYGON struRegion;//region
    WORD wDelay;        //delay[1,120],uint:s
    BYTE byRes[6];
}NET_VCA_YARD_TARRY, *LPNET_VCA_YARD_TARRY;

typedef struct tagNET_VCA_ADV_REACH_HEIGHT
{
    NET_VCA_POLYGON struRegion; //region
    DWORD dwCrossDirection;  //Cross direction(VCA_CROSS_DIRECTION)
    BYTE    byRes[4];        // 
}NET_VCA_ADV_REACH_HEIGHT, *LPNET_VCA_ADV_REACH_HEIGHT;

typedef struct tagNET_VCA_ADV_TRAVERSE_PLANE
{
    NET_VCA_POLYGON struRegion; //Region
    DWORD   dwCrossDirection;   //Cross direction(VCA_CROSS_DIRECTION)
    BYTE    bySensitivity;      //[1,5] 
    BYTE    byRes[3];            //Reserved
} NET_VCA_ADV_TRAVERSE_PLANE, *LPNET_VCA_ADV_TRAVERSE_PLANE;


typedef struct tagNET_VCA_SITDOWN
{
    NET_VCA_POLYGON struRegion;//Region
    BYTE bySensitivity;//Sensitivity Param[1-100]
    BYTE byRes[7];
}NET_VCA_SITDOWN, *LPNET_VCA_SITDOWN;

typedef struct tagNET_VCA_LECTURE
{
    NET_VCA_POLYGON struRegion;//Region
    WORD wDuration; //Duration: [1-10]
    BYTE bySensitivity; //Sensitivity,[1-100]
    BYTE byAlarmState;//Alarm State;0-Retain,1-Alarm Begin,2-Alarm end
    BYTE byTrackingMode;//Tracking Mode,0-Auto(Def),1-Horizontal,2-Vertical
    BYTE byZoomMode;//Zoom Mode, 0-Fixed(Def), 1-Auto
    BYTE byZoomOver;//0-Retain,1-Zoom Over
    BYTE byTrackStatus;
}NET_VCA_LECTURE, *LPNET_VCA_LECTURE;

typedef struct tagNET_VCA_ANSWER
{
    NET_VCA_POLYGON struRegion;//Region
    BYTE bySensitivity;//Sensitivity,[1-100]
    BYTE byAlarmState;//Alarm State:0-Retain,1-Alarm Begin,2-Alarm end
    BYTE byZoomOver;//0-Retain,1-Zoom Over
    BYTE byAnswerStudent;//0-Reserve,1-No Students Answer,2-A Student Answer,3-Many Students Answer,,4-one Student Answer
    BYTE byRes[4];
}NET_VCA_ANSWER, *LPNET_VCA_ANSWER;

//Rule Struct
typedef struct tagNET_VCA_RELATE_RULE_PARAM
{
    BYTE  byRuleID;  //Rule ID
    BYTE  byRes;
    WORD  wEventType;        //Event Type  See VCA_RULE_EVENT_TYPE_EX
}NET_VCA_RELATE_RULE_PARAM, *LPNET_VCA_RELATE_RULE_PARAM;

//Combined Rule
typedef struct tagNET_VCA_COMBINED_RULE_
{
    //Rule Sequence
    BYTE    byRuleSequence;
    BYTE    byRes[7];
    DWORD  dwMinInterval;    //Min Interval
    DWORD  dwMaxInterval;   //Max Interval
    NET_VCA_RELATE_RULE_PARAM  struRule1Raram;//Rule1
    NET_VCA_RELATE_RULE_PARAM  struRule2Raram;//Rule2
    BYTE    byRes1[36];
} NET_VCA_COMBINED_RULE, *LPNET_VCA_COMBINED_RULE;

//Writing 
typedef struct  tagNET_VCA_BLACKBOARD_WRITE
{
    NET_VCA_POLYGON struRegion;//Region
    BYTE    byTeacherState;//Teacher State
    BYTE    byWritingState;//Writing State
    BYTE    byWritingArea;//Writing Area
    BYTE    byRes[5];
}NET_VCA_BLACKBOARD_WRITE, *LPNET_VCA_BLACKBOARD_WRITE;

//People gathering status
typedef struct tagNET_VCA_HIGH_DENSITY_STATUS
{
    NET_VCA_POLYGON struRegion;        //Region
    float           fDensity;       //Density range:  [0.1,  1.0]
    BYTE            bySensitivity;    //Sensitivity, value range: [1,5]
    BYTE            byRes[3];
}NET_VCA_HIGH_DENSITY_STATUS, *LPNET_VCA_HIGH_DENSITY_STATUS;

//Run detection
typedef struct _NET_VCA_RUNNING_
{
    NET_VCA_POLYGON  struRegion;  //Regional scope
    DWORD  dwSpeed;      //Running speed, range [1,10]
    BYTE byRes[4];
}NET_VCA_RUNNING, *LPNET_VCA_RUNNING;

//Detention detection
typedef struct tagNET_VCA_RETENTION
{
    NET_VCA_POLYGON struRegion; // Regional scope
    WORD       wDuration;       //Trigger alarm time(60 - 3600 seconds) default 1800 seconds
    BYTE       byRes[6];
}NET_VCA_RETENTION, *LPNET_VCA_RETENTION;

//Situational analysis
typedef struct tagNET_VCA_SITUATION_ANALYSIS
{
    NET_VCA_POLYGON struRegion; // Area range
    WORD       wPeopleNum;       //Number of people in Area
    BYTE       byRes[6];
}NET_VCA_SITUATION_ANALYSIS, *LPNET_VCA_SITUATION_ANALYSIS;

//Alarm event parameters
typedef union tagNET_VCA_EVENT_UNION
{
    DWORD                      uLen[23];             //Parameters
    NET_VCA_TRAVERSE_PLANE     struTraversePlane;     //Traverse plane parameters 
    NET_VCA_AREA               struArea;             //Enter or Leave area
    NET_VCA_INTRUSION          struIntrusion;         //Intrusion
    NET_VCA_LOITER             struLoiter;             //Loitering
    NET_VCA_TAKE_LEFT          struTakeTeft;         //Object left or taken
    NET_VCA_PARKING            struParking;         //Illegal parking
    NET_VCA_RUN                struRun;             //Running
    NET_VCA_HIGH_DENSITY       struHighDensity;     //People gathering  
    NET_VCA_VIOLENT_MOTION     struViolentMotion;   //Violent motion
    NET_VCA_REACH_HIGHT        struReachHight;         //Reach High
    NET_VCA_GET_UP               struGetUp;             //Get up
    NET_VCA_LEFT               struLeft;            //Items left
    NET_VCA_TAKE               struTake;            //Items take
    NET_VCA_HUMAN_ENTER        struHumanEnter;      //Human entrance
    NET_VCA_OVER_TIME          struOvertime;        //Operation overtime
    NET_VCA_STICK_UP            struStickUp;         //ATM stick up
    NET_VCA_SCANNER            struScanner;         //Install scanner on ATM     
    NET_VCA_LEAVE_POSITION     struLeavePos;        //Parameter that leave the position
    NET_VCA_TRAIL              struTrail;           //Trail
    NET_VCA_FALL_DOWN          struFallDown;        //Fall down
    NET_VCA_AUDIO_ABNORMAL     struAudioAbnormal;   //Audio abnormal
    NET_VCA_ADV_REACH_HEIGHT   struReachHeight;     //Advance reach height
    NET_VCA_TOILET_TARRY       struToiletTarry;     //Toilet tarry
    NET_VCA_YARD_TARRY         struYardTarry;       //Yard tarry
    NET_VCA_ADV_TRAVERSE_PLANE struAdvTraversePlane;//Advance traverse plane
    NET_VCA_LECTURE            struLecture;            //Lecture
    NET_VCA_ANSWER             struAnswer;            //Answer
    NET_VCA_STANDUP               struStandUp;         //Stand Up
    NET_VCA_PEOPLENUM_CHANGE   struPeopleNumChange; //People Num Change
    NET_VCA_SPACING_CHANGE     struSpacingChange;   //Spacing Change
    NET_VCA_COMBINED_RULE      struCombinedRule;    //Combined Rule
    NET_VCA_SIT_QUIETLY        struSitQuietly;      //Sit Quietly
    NET_VCA_HIGH_DENSITY_STATUS struHighDensityStatus;        //People gathering status 
    NET_VCA_RUNNING     struRunning; //Running parameters
    NET_VCA_RETENTION   struRetention;//Detention detection
    NET_VCA_BLACKBOARD_WRITE   struBlackboardWrite; //Blackboard Write
    NET_VCA_SITUATION_ANALYSIS   struSituationAnalysis; //Situational analysis
}NET_VCA_EVENT_UNION, *LPNET_VCA_EVENT_UNION;

// Target size filter
typedef enum _VCA_SIZE_FILTER_MODE_
{
    IMAGE_PIX_MODE,   // Set by pixels
    REAL_WORLD_MODE,  // Set by actual size
    DEFAULT_MODE       // Default
}SIZE_FILTER_MODE;
//Size filter
typedef struct tagNET_VCA_SIZE_FILTER
{
    BYTE    byActive;             // Enable filter: 0- disable;  1- enable
    BYTE    byMode;             //SIZE_FILTER_MODE
    BYTE    byRes[2];           //Reserved as 0
    NET_VCA_RECT struMiniRect;  //Min. target region, 0 stands for no region settings
    NET_VCA_RECT struMaxRect;     //Max. target region, 0 stands for no region settings
}NET_VCA_SIZE_FILTER, *LPNET_VCA_SIZE_FILTER;

//Alarm rule configuration
typedef struct tagNET_VCA_ONE_RULE
{
    BYTE   byActive;                       //Activate rule settings: 0- disable;  1- enable
    BYTE   byRes[7];                       //Reserved as 0
    BYTE   byRuleName[NAME_LEN];           //Rule name
    VCA_EVENT_TYPE dwEventType;          //VCA event type
    NET_VCA_EVENT_UNION uEventParam;      //VCA event parameters
    NET_VCA_SIZE_FILTER  struSizeFilter; //Size filter
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2]; // Arm time
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;     //Handle method
    BYTE byRelRecordChan[MAX_CHANNUM_V30];             //Alarm trigger recording channel, 1- trigger recording on this channel
}NET_VCA_ONE_RULE, *LPNET_VCA_ONE_RULE;

typedef struct tagNET_VCA_DEV_INFO
{
    NET_DVR_IPADDR  struDevIP;  //PU address  
    WORD wPort;              //PU port number  
    BYTE byChannel;           //PU channel number
    BYTE byIvmsChannel;     // Ivms channel
} NET_VCA_DEV_INFO, *LPNET_VCA_DEV_INFO;

//VCA configuration structure
typedef struct tagNET_VCA_RULECFG
{
    DWORD  dwSize;             //Structure length
    BYTE    byPicProType;     //0- do not upload snapshot;  1 - Upload  snapshot on VCA alarm
    BYTE    byUpLastAlarm;  //2011-04-06 Whether upload last alarm firstly 
    BYTE   byPicRecordEnable;  /*2012-3-1 Whether record picture, 0-no,1-yes*/
    BYTE    byRes;
    NET_DVR_JPEGPARA struPictureParam;          //snapshot structure
    NET_VCA_ONE_RULE  struRule[MAX_RULE_NUM];   //Rule array
}NET_VCA_RULECFG, *LPNET_VCA_RULECFG;

typedef struct tagNET_DVR_TARGET_LEFT_REGION_ALARM
{
    DWORD     dwSize;
    DWORD     dwRelativeTime;
    DWORD        dwAbsTime;
    NET_VCA_DEV_INFO  struDevInfo;
    BYTE     byTargetType;
    BYTE     byLeftDirection;
    BYTE     byTargetStatus;
    BYTE     byRes[125];
}NET_DVR_TARGET_LEFT_REGION_ALARM, *LPNET_DVR_TARGET_LEFT_REGION_ALARM;

/* dbd alarm pic info */
typedef struct
{
    /*20-smoke, 21-using cellphone , 22-Fatigue driving , 23-The driver has no visual front, 24-no head, 25-has belt,
    26-Drivers pick up items, 27-Driver yawning, 28-drinking or eating, 29-chatting, 31-Drivers are not wearing work clothes*/
    DWORD dwPicType;                /* picture type */
    char *pPicBuf;                  /* xxx.jpg*/
    DWORD dwPicLen;                 /* picture length */
    DWORD dwTime;                   /* capture time */
    char *pVideoBuf;                 /* xxx.mp4*/
    DWORD dwVideoLen;               /* video length 20180518 */
    BYTE byRes[12];                /* res */
}NET_DVR_DBD_PICTURE_INFO, *LPNET_DVR_DBD_PICTURE_INFO;

/* dbd position info */
typedef struct
{/* 24 bytes */
    DWORD bValid;                   /* 1-valid */
    DWORD dwLongitude;              /* Longitude */
    DWORD dwLatitude;               /* Latitude */
    DWORD dwVehicleSpeed;           /* speed */
    DWORD dwVehicleDirection;       /* direction */
    DWORD dwAltitude;                  /* Altitude cm */
}NET_DVR_DBD_POSITION_INFO, *LPNET_DVR_DBD_POSITION_INFO;

/* dbd alarm state */
typedef struct
{/* 24 bytes */
    BYTE bySmoke;              /* smoke */
    BYTE byPhone;              /* uphone */
    BYTE byTiredDriving;       /* tired driving */
    BYTE byNoVisualFront;      /* no visual front */
    BYTE byNoHead;             /* no head */
    BYTE byWithoutBelt;        /* without belt */
    BYTE byPickingUpThing;     /* picking up thing */
    BYTE byYawn;               /* yawm */
    BYTE byEatOrDrink;         /* eat or drink something */
    BYTE byChatting;           /* chatting */
    BYTE byTampering;          /* tampering camera */
    BYTE byWithoutUniform;     /* without uniform */
    BYTE byRes[12];
}NET_DVR_DBD_ALARM_STATE, *LPNET_DVR_DBD_ALARM_STATE;

/* dbd amarm info */
typedef struct
{
    DWORD dwSize;               /* size */
    BYTE byChannel;            /* channel*/
    BYTE byLevel;              /*alarm level, 1*/
    BYTE byRes1[2];            /* res*/
    NET_VCA_DEV_INFO struIpcInfo;       		/* ipc info 24*/
    NET_DVR_DBD_POSITION_INFO struPosInfo;  /* position info  24*/
    NET_DVR_DBD_PICTURE_INFO struPicInfo;   /* picture info*/
    NET_DVR_DBD_ALARM_STATE struAlarmState; /* alarm state 24*/
    BYTE byRes2[20];           /* res   20*/
}NET_DVR_DBD_ALRAM_INFO, *LPNET_DVR_DBD_ALRAM_INFO;

/* ADAS alarm picture info */
typedef struct
{
    DWORD dwPicType;                /* picture type */
    char *pPicBuf;                  /* xxx.jpg */
    DWORD dwPicLen;                 /* picture length */
    DWORD dwTime;                   /* capture time */
    char *pVideoBuf;                /* xxx.mp4 */
    DWORD dwVideoLen;               /* video length 20180518 */
    BYTE byRes[12];                /* res */
} NET_DVR_ADAS_PICTURE_INFO, *LPNET_DVR_ADAS_PICTURE_INFO;

/* ADAS alarm position info */
typedef struct
{/* 24 bytes */
    DWORD dwValid;                   /* 1-valid */
    DWORD dwLongitude;              /* Longitude */
    DWORD dwLatitude;               /* Latitude */
    DWORD dwVehicleSpeed;           /* speed */
    DWORD dwVehicleDirection;       /* vehicle direction */
    DWORD dwAltitude;                  /* Altitude */
}NET_DVR_ADAS_POSITION_INFO, *LPNET_DVR_ADAS_POSITION_INFO;

/* ADAS alarm state */
typedef struct
{/* 24 bytes */
    BYTE dwFcw;              /* 0-none */
    BYTE dwLdw;              /* 0-none, 1-left, 2-right */
    BYTE dwHmw;       		 /* 0-none */
    BYTE dwPcw;      		 /* 0-none */
    BYTE dwBsd;             /* 0-none */
    BYTE byRes[19];
}NET_DVR_ADAS_ALARM_STATE, *LPNET_DVR_ADAS_ALARM_STATE;

/* ADAS alarm info */
typedef struct
{
    DWORD dwSize;               /* size */
    BYTE byChannel;            /* channel*/
    BYTE byRes1[3];            /* res*/
    NET_VCA_DEV_INFO struIpcInfo;       		/* ipc info 28*/
    NET_DVR_ADAS_POSITION_INFO struPosInfo;  /* position info 24*/
    NET_DVR_ADAS_PICTURE_INFO struPicInfo;   /* pciture info*/
    NET_DVR_ADAS_ALARM_STATE struAlarmState; /* alarm state 24*/
    BYTE byRes2[20];           /* res   20*/
}NET_DVR_ADAS_ALRAM_INFO, *LPNET_DVR_ADAS_ALRAM_INFO;

/* realtime vehicel info */
typedef struct
{
    DWORD dwSize;
    DWORD dwSpeedValue;         /* speed */
    DWORD dwSpeedPulse;         /* speed pulse */
    BYTE byUpgPercent;         /* upgrade progress,0-100,return 255 when failed, return 0 when started*/
    BYTE byRes1[3];
    DWORD dwVideoLostChans;    /*each bit stands for one channel, 0-normal, 1-videoloss*/
    BYTE byRes2[44];
}NET_DVR_VEH_REALTIME_DATA_INFO, *LPNET_DVR_VEH_REALTIME_DATA_INFO;

//Size filter strategy
typedef struct tagNET_VCA_FILTER_STRATEGY
{
    BYTE    byStrategy;      //0 - Disabled, 1-Width and height filter,2-Area filter
    BYTE    byRes[11];       //Reserved
}NET_VCA_FILTER_STRATEGY, *LPNET_VCA_FILTER_STRATEGY;

//Rule trigger param
typedef struct tagNET_VCA_RULE_TRIGGER_PARAM
{
    BYTE   byTriggerMode;   //Trigger mode,0- Disabled,1- Track point, 2- Target area 
    BYTE   byTriggerPoint;  //Trigger point,effective when track point is enabled, 0- Center,1-Up,2-Down
    BYTE   byRes1[2];       //Reserved
    float  fTriggerArea;    //Trigger area percent [0,100],effective when target area is enabled
    BYTE   byRes2[4];       //Reserved
}NET_VCA_RULE_TRIGGER_PARAM, *LPNET_VCA_RULE_TRIGGER_PARAM;


//Alarm rule configuration
typedef struct tagNET_VCA_ONE_RULE_V41
{
    BYTE   byActive; //Activate rule settings: 0- disable;  1- enable
    BYTE   byRes1[4];
    BYTE   byEventTypeFlag;  //Event Type Flag,0-dwEventType Effective,1-wEventTypeEx Effective                      
    WORD   wEventTypeEx; //Event type,substitute for dwEventType,refer to VCA_RULE_EVENT_TYPE_EX
    BYTE   byRuleName[NAME_LEN]; //Rule name
    VCA_EVENT_TYPE dwEventType;    //Event type,It is kept only for compatibility,in your new code,use wEventTypeEx instead
    NET_VCA_EVENT_UNION uEventParam; //VCA event parameters
    NET_VCA_SIZE_FILTER  struSizeFilter; //Size filter
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];// Arm time
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;     //Handle method
    BYTE   byRelRecordChan[MAX_CHANNUM_V30];       //Alarm trigger recording channel, 1- trigger recording on this channel
    WORD   wAlarmDelay; //Alarm delay,0-5s,1-10,2-30s,3-60s,4-120s,5-300s,6-600s
    BYTE   byRes2[2];                              //Reserved
    NET_VCA_FILTER_STRATEGY     struFilterStrategy; //Size filter strategy
    NET_VCA_RULE_TRIGGER_PARAM  struTriggerParam;   //Rule trigger param
    BYTE    byRes[32];                              //Reserved
}NET_VCA_ONE_RULE_V41, *LPNET_VCA_ONE_RULE_V41;

//VCA configuration structure
typedef struct tagNET_VCA_RULECFG_V41
{
    DWORD  dwSize;
    BYTE   byPicProType;    //0- do not upload snapshot;  1 - Upload  snapshot on VCA alarm
    BYTE   byUpLastAlarm; //2011-04-06 Whether upload last alarm firstly
    BYTE   byPicRecordEnable;  /*2012-3-1 Whether to enable the image storage, 0-Not enabled, 1-enabled*/
    BYTE   byRes1;
    NET_DVR_JPEGPARA struPictureParam;         //snapshot structure
    NET_VCA_ONE_RULE_V41  struRule[MAX_RULE_NUM];  //Rule array
    WORD   wRelSnapChan[MAX_REL_SNAPCHAN_NUM]; /*Relate snap channel,when the main channel alarms,together upload the relate channel picture
                                               0-unused,other- channel number*/
    BYTE   byRes[26]; //Reserved
}NET_VCA_RULECFG_V41, *LPNET_VCA_RULECFG_V41;

typedef struct NET_VCA_ONE_RULE_V42_
{
    BYTE           byActive;       //Activate rule settings: 0- disable;  1- enable
    BYTE        byEventPriority;//Event Priority 0-low,1-mid,2-high
    BYTE        byBackgroundSuppression;//0-close 1-open 2-auto
    BYTE           byRes1[3];
    WORD          wEventType;        //Event type,substitute for dwEventType,refer to VCA_RULE_EVENT_TYPE_EX
    BYTE        byRuleName[NAME_LEN/*32*/];        //Rule Name
    NET_VCA_EVENT_UNION  uEventParam;            //VCA event parameters
    NET_VCA_SIZE_FILTER  struSizeFilter;          //Size filter
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Alarm Time
    NET_DVR_HANDLEEXCEPTION_V40  struAlarmHandleType; //Alarm Handle Type
    DWORD       dwRelRecordChan[MAX_CHANNUM_V30];    //Alarm trigger recording channel, 1- trigger recording on this channel
    WORD          wAlarmDelay; //Alarm delay,0-5s,1-10,2-30s,3-60s,4-120s,5-300s,6-600s
    BYTE           byRes2[2];
    NET_VCA_FILTER_STRATEGY     struFilterStrategy;  //Size filter strategy
    NET_VCA_RULE_TRIGGER_PARAM     struTriggerParam;    //Rule trigger param
    BYTE byRes[32];
}NET_VCA_ONE_RULE_V42, *LPNET_VCA_ONE_RULE_V42;

typedef struct    tagNET_DVR_PTZ_POSITION
{
    // Enable/disable the video scene functions (for speed dome local video scene position configuration) , invalid for video scene rule configuration mode,
    BYTE byEnable;
    BYTE byRes1[3];   //Reserved
    BYTE byPtzPositionName[NAME_LEN];  //Video scene position name
    NET_DVR_PTZPOS struPtzPos;  //PTZ  coordinates
    BYTE byRes2[40];
}NET_DVR_PTZ_POSITION, *LPNET_DVR_PTZ_POSITION;

//VCA configuration structure V42
typedef struct tagNET_VCA_RULECFG_V42
{
    DWORD        dwSize;
    BYTE           byPicProType;        //0- do not upload snapshot;  1 - Upload  snapshot on VCA alarm
    BYTE        byUpLastAlarm;         //Whether upload last alarm firstly
    BYTE        byPicRecordEnable;  //Whether to enable the image storage, 0-Not enabled, 1-enabled
    BYTE        byRes1;
    NET_DVR_JPEGPARA       struPicParam;         //snapshot structure
    NET_VCA_ONE_RULE_V42  struRule[MAX_RULE_NUM_V42/*16*/];       //Rule array
    WORD        wRelSnapChan[MAX_REL_SNAPCHAN_NUM]; /*Relate snap channel,when the main channel alarms,together upload the relate channel picture
                                               0-unused,other- channel number*/
    BYTE        byTrackEnable; //Track Enable
    BYTE        byRes2;
    NET_DVR_PTZ_POSITION  struPTZPosition;  //PTZ Position
    WORD        wTrackDuration; //Track Duration
    WORD            wIntervalTime; //Single alarm interval (seconds) [1-7200] (default is 600)
    WORD            wHeightLimit;//Target detection height limit (CM) [0-250] (default 80cm), less than the height of the target will not be detected as a target
    BYTE            byRes[58];
}NET_VCA_RULECFG_V42, *LPNET_VCA_RULECFG_V42;

//Simplified target info structure
typedef struct tagNET_VCA_TARGET_INFO
{
    DWORD    dwID;                 //Target ID, the target ID will be 0 on high density alarm
    NET_VCA_RECT struRect;       //target brim rectangle
    BYTE      byRes[4];             //Reserved
}NET_VCA_TARGET_INFO, *LPNET_VCA_TARGET_INFO;

//Simplified rule info
typedef struct tagNET_VCA_RULE_INFO
{
    BYTE   byRuleID;              //Rule ID, 0- 7
    BYTE   bySceneID;             //Scenario ID, return 0 invalid
    WORD   wEventTypeEx;         //Event type,substitute for dwEventType,refer to VCA_RULE_EVENT_TYPE_EX
    BYTE   byRuleName[NAME_LEN]; //Rule name
    VCA_EVENT_TYPE  dwEventType; //Event type,It is kept only for compatibility,in your new code,use wEventTypeEx instead
    NET_VCA_EVENT_UNION uEventParam; //Event parameters
}NET_VCA_RULE_INFO, *LPNET_VCA_RULE_INFO;

//PU address info, (address of connected IP device for iVMS, or local address for the other intelligent devices)
// typedef struct tagNET_VCA_DEV_INFO
// {
//     NET_DVR_IPADDR  struDevIP;  //PU address  
//     WORD wPort;              //PU port number  
//     BYTE byChannel;           //PU channel number
//     BYTE byIvmsChannel;     // Ivms channel
// } NET_VCA_DEV_INFO,  *LPNET_VCA_DEV_INFO; 

//VCA upload info
typedef struct  tagNET_VCA_RULE_ALARM
{
    DWORD    dwSize;                         //Structure length
    DWORD    dwRelativeTime;                 //if byRelativeTimeFlag is true,  dwRelativeTime represent UTC time stamp
    DWORD    dwAbsTime;                     //Absolute time stamp
    NET_VCA_RULE_INFO     struRuleInfo;     //Event rule info
    NET_VCA_TARGET_INFO  struTargetInfo;     //Alarm target info
    NET_VCA_DEV_INFO       struDevInfo;         //PU device info
    DWORD    dwPicDataLen;     //Return snapshot length, 0- no snapshot;  others- snapshot data size followed*/
    BYTE     byPicType;    //0- normal picture, 1- contrast picture 
    BYTE     byRelAlarmPicNum; //Related alarm picture number
    BYTE     bySmart;   //IDS DEV Return 0(default),Smart Functiom Return 1
    BYTE     byPicTransType;        //Image data transmission: 0-binary; 1-url
    DWORD    dwAlarmID; //Alarm ID,marking the same group of alarmls,0-unused
    WORD     wDevInfoIvmsChannelEx;     //NET_VCA_DEV_INFO->byIvmsChannel
    BYTE     byRelativeTimeFlag;      /* dwRelativeTime is valid or not 0-invalid 1-valid */
    BYTE     byAppendInfoUploadEnabled; //Append Info Upload Enabled 0-n 1-y
    BYTE     *pAppendInfo;     //to NET_VCA_APPEND_INFO point,byAppendInfoUploadEnabled=1 avilibled
    BYTE     *pImage;    //Pointer to the snapshot picture
}NET_VCA_RULE_ALARM, *LPNET_VCA_RULE_ALARM;

typedef struct tagNET_VCA_APPEND_INFO
{
    DWORD   dwSize;
    DWORD   dwAppendPicLen;
    BYTE*   pAppendPicBuff;
    BYTE    byAppendPicType;
    BYTE    byUID[64];
    BYTE    byRes[63];
}NET_VCA_APPEND_INFO, *LPNET_VCA_APPEND_INFO;


//VCA info overlay via DSP
typedef struct tagNET_VCA_DRAW_MODE
{
    DWORD  dwSize;
    BYTE    byDspAddTarget;         //Overlay target info during encoding
    BYTE    byDspAddRule;             //Overlay rule info during encoding
    BYTE    byDspPicAddTarget;         //Overlay target info for snapshot
    BYTE    byDspPicAddRule;         //Overlay rule info for snapshot
    BYTE    byRes[4];
}NET_VCA_DRAW_MODE, *LPNET_VCA_DRAW_MODE;

//Object type
typedef enum tagOBJECT_TYPE_ENUM
{
    ENUM_OBJECT_TYPE_COAT = 1  //coat
}OBJECT_TYPE_ENUM;

//Object color condition
typedef struct tagNET_DVR_OBJECT_COLOR_COND
{
    DWORD  dwChannel;   //Channel number
    DWORD  dwObjType;   //Object type,refer to OBJECT_TYPE_ENUM
    BYTE   byRes[64];   //Reserved
}NET_DVR_OBJECT_COLOR_COND, *LPNET_DVR_OBJECT_COLOR_COND;

//Picture parameters
typedef struct tagNET_DVR_PIC
{
    BYTE   byPicType;        //Picture type,1-jpg
    BYTE   byRes1[3];        //Reserved
    DWORD  dwPicWidth;       //Picture width
    DWORD  dwPicHeight;      //Picture height
    DWORD  dwPicDataLen;     //Picture data length
    DWORD  dwPicDataBuffLen; //Picture buffer size
    BYTE*  byPicDataBuff;    //Picture buffer pointer
    BYTE   byRes2[40];       //Reserved
}NET_DVR_PIC, *LPNET_DVR_PIC;

//Object color union
typedef union tagNET_DVR_OBJECT_COLOR_UNION
{
    NET_DVR_COLOR  struColor;   //Color value
    NET_DVR_PIC    struPicture; //Picture
    BYTE           byRes[64];   //Reserved
}NET_DVR_OBJECT_COLOR_UNION, *LPNET_DVR_OBJECT_COLOR_UNION;

//Object color paraemters
typedef struct tagNET_DVR_OBJECT_COLOR
{
    DWORD  dwSize;       //Structure size
    BYTE   byEnable;     //0-disabled,1-enabled
    BYTE   byColorMode;  //Color mode,1-from color value,2-from picture
    BYTE   byRes1[2];    //Reserved
    NET_DVR_OBJECT_COLOR_UNION uObjColor; //Object color union,depends on the value of byColorMode
    BYTE   byRes2[64];   //Reserved
}NET_DVR_OBJECT_COLOR, *LPNET_DVR_OBJECT_COLOR;

//Area type
typedef enum tagAREA_TYPE_ENUM
{
    ENUM_OVERLAP_REGION = 1,//Overlap region
    ENUM_BED_LOCATION = 2   //Bed location
}AREA_TYPE_ENUM;

//Auxiliary area
typedef struct tagNET_DVR_AUXAREA
{
    DWORD  dwAreaType;   //Area type,refer to AREA_TYPE_ENUM
    BYTE   byEnable;     //0-disabled,1-enabled
    BYTE   byRes1[3];    //Reserved
    NET_VCA_POLYGON struPolygon; //Area polygon
    BYTE   byRes2[16];   //Reserved
}NET_DVR_AUXAREA, *LPNET_DVR_AUXAREA;

//Auxiliary area list
typedef struct tagNET_DVR_AUXAREA_LIST
{
    DWORD     dwSize;    //Structure size
    NET_DVR_AUXAREA struArea[MAX_AUXAREA_NUM]; //Auxiliary area list
    BYTE    byRes2[64];    //Reserved
}NET_DVR_AUXAREA_LIST, *LPNET_DVR_AUXAREA_LIST;

//Channel workmode
typedef enum tagCHAN_WORKMODE_ENUM
{
    ENUM_CHAN_WORKMODE_INDEPENDENT = 1,  //Independent
    ENUM_CHAN_WORKMODE_MASTER = 2,      //Master
    ENUM_CHAN_WORKMODE_SLAVE = 3        //Slave
}CHAN_WORKMODE_ENUM;

//Channel workmode parameters
typedef struct tagNET_DVR_CHANNEL_WORKMODE
{
    DWORD dwSize;        //Structure size
    BYTE  byWorkMode;    //Workmode,refer to CHAN_WORKMODE_ENUM
    BYTE  byRes[63];     //Reserved
}NET_DVR_CHANNEL_WORKMODE, *LPNET_DVR_CHANNEL_WORKMODE;

//Device channel
typedef struct tagNET_DVR_CHANNEL
{
    BYTE   byAddress[MAX_DOMAIN_NAME];    //Device ip or domain name
    WORD   wDVRPort;                     //Port
    BYTE   byRes1[2];                   //Reserved
    BYTE   sUserName[NAME_LEN];            //Username
    BYTE   sPassword[PASSWD_LEN];       //Password
    DWORD  dwChannel;                   //Channel number
    BYTE   byRes2[32];                  //Reserved
}NET_DVR_CHANNEL, *LPNET_DVR_CHANNEL;

//Slave channel union
typedef union tagNET_DVR_SLAVE_CHANNEL_UNION
{
    BYTE            byRes[152];        //Reserved
    DWORD           dwLocalChannel;    //Local channel
    NET_DVR_CHANNEL struRemoteChannel; //Remote channel
}NET_DVR_SLAVE_CHANNEL_UNION, *LPNET_DVR_SLAVE_CHANNEL_UNION;

//Slave channel parameters
typedef struct tagNET_DVR_SLAVE_CHANNEL_PARAM
{
    BYTE   byChanType;   //Slave channel type,1-local,2-remote
    BYTE   byRes1[3];    //Reserved
    NET_DVR_SLAVE_CHANNEL_UNION uSlaveChannel; //Slave channel union,depends on the value of byChanType
    BYTE   byRes2[64];   //Reserved
}NET_DVR_SLAVE_CHANNEL_PARAM, *LPNET_DVR_SLAVE_CHANNEL_PARAM;


//Slave channel config parameters
typedef struct tagNET_DVR_SLAVE_CHANNEL_CFG
{
    DWORD dwSize;   //Structure size
    NET_DVR_SLAVE_CHANNEL_PARAM struChanParam[MAX_SLAVE_CHANNEL_NUM];//Slave channel list
    BYTE  byRes[64];  //Reserved
}NET_DVR_SLAVE_CHANNEL_CFG, *LPNET_DVR_SLAVE_CHANNEL_CFG;

//Video quality diagnostic detect event
typedef enum tagVQD_EVENT_ENUM
{
    ENUM_VQD_EVENT_BLUR = 1,  //Image blurring
    ENUM_VQD_EVENT_LUMA = 2,  //Brightness abnormal 
    ENUM_VQD_EVENT_CHROMA = 3,  //Color cast
    ENUM_VQD_EVENT_SNOW = 4,  //Snow
    ENUM_VQD_EVENT_STREAK = 5,  //Streak
    ENUM_VQD_EVENT_FREEZE = 6,  //Freeze
    ENUM_VQD_EVENT_SIGNAL_LOSS = 7,  //Signal loss
    ENUM_VQD_EVENT_PTZ = 8,  //Ptz out of control
    ENUM_VQD_EVENT_SCNENE_CHANGE = 9,  //Scene change
    ENUM_VQD_EVENT_VIDEO_ABNORMAL = 10, //Video abnormal
    ENUM_VQD_EVENT_VIDEO_BLOCK = 11, //Video block
    ENUM_VQD_EVENT_CLARTY       = 12, //
    ENUM_VQD_EVENT_JITTER       = 13, //
    ENUM_VQD_EVENT_FLOWERS      = 14,
    ENUM_VQD_EVENT_NOISE        = 15,
    ENUM_VQD_EVENT_GHOST        = 16,
    ENUM_VQD_EVENT_PURPLE       = 17,
    ENUM_VQD_EVENT_ICR          = 18,
    ENUM_VQD_EVENT_PROTECTFILM  = 19
}VQD_EVENT_ENUM;

//Video quality diagnostic event condition
typedef struct tagNET_DVR_VQD_EVENT_COND
{
    DWORD dwChannel;   //Channel number
    DWORD dwEventType; //Event type,refer to VQD_EVENT_ENUM
    BYTE  byRes[64];   //Reserved
}NET_DVR_VQD_EVENT_COND, *LPNET_DVR_VQD_EVENT_COND;

//Video quality diagnostic event parameters
typedef struct tagNET_DVR_VQD_EVENT_PARAM
{
    BYTE   byThreshold;    //Alarm threshold [0,100]
    BYTE   byTriggerMode;  //Trigger mode,1-continuous,2-single
    BYTE   byUploadPic;    //0-Upload alarm picture,1-Not upload alarm pic,Whether or not,you can always get the lastest alarm picture of certain VQD event, refer to NET_DVR_StartDownload
    BYTE   byRes1;         //Reserved
    DWORD  dwTimeInterval; //Continuous alarm time interval(seconds)
    BYTE   byRes2[64];     //Reserved
}NET_DVR_VQD_EVENT_PARAM, *LPNET_DVR_VQD_EVENT_PARAM;

//Video quality diagnostic event rule
typedef struct tagNET_DVR_VQD_EVENT_RULE
{
    DWORD  dwSize;       //Structure size 
    BYTE   byEnable;     //0-disabled,1-enabled
    BYTE   byRes1[3];    //Reserved
    NET_DVR_VQD_EVENT_PARAM struEventParam; //VQD event parameters
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Detect time
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;  //Handle method
    BYTE   byRelRecordChan[MAX_IVMS_IP_CHANNEL]; //Recording channel triggered by alarm, 1-trigger recording on this channel
    BYTE   byRes2[128];   //Reserved
}NET_DVR_VQD_EVENT_RULE, *LPNET_DVR_VQD_EVENT_RULE;

//Baseline scene parameters
typedef struct tagNET_DVR_BASELINE_SCENE
{
    DWORD dwSize;     //Structure size
    BYTE  byEnable;   //0-disabled,1-enabled
    BYTE  byRes[63];  //Reserved
}NET_DVR_BASELINE_SCENE, *LPNET_DVR_BASELINE_SCENE;

//Operation of baseline scene
typedef struct tagNET_DVR_CONTROL_BASELINE_SCENE_PARAM
{
    DWORD dwSize;     //Structure size
    DWORD dwChannel;  //Channel number
    BYTE  byCommand;  //Operation type,1-Just reserved for future use,2-Update baselien scene
    BYTE  byRes[127];  //Reserved
}NET_DVR_CONTROL_BASELINE_SCENE_PARAM, *LPNET_DVR_CONTROL_BASELINE_SCENE_PARAM;

//Video quality diagnostic alarm
typedef struct tagNET_DVR_VQD_ALARM
{
    DWORD  dwSize;                //Structure size
    DWORD  dwRelativeTime;        //Relative time
    DWORD  dwAbsTime;              //Absolute time
    NET_VCA_DEV_INFO struDevInfo; //device info
    DWORD  dwEventType;           //VQD event type,refer to VQD_EVENT_ENUM
    float  fThreshold;            //Alarm threshold [0.000,1.000]
    DWORD  dwPicDataLen;          //Alarm picture data,if 0, there is no picture uploaded
    BYTE   *pImage;               //Pointer to picture data           
    BYTE   byRes[128];            //Reserved
}NET_DVR_VQD_ALARM, *LPNET_DVR_VQD_ALARM;

//Sub structure for calibration point
typedef struct tagNET_DVR_CB_POINT
{
    NET_VCA_POINT struPoint;      //calibration point, main camera (fixed camera) 
    NET_DVR_PTZPOS struPtzPos;    //Input PTZ position of the speed dome
    BYTE    byRes[8];
}NET_DVR_CB_POINT, LPNET_DVR_CB_POINT;

//Calibration parameters
typedef struct tagNET_DVR_TRACK_CALIBRATION_PARAM
{
    BYTE byPointNum;             //Valid calibration
    BYTE byRes[3];
    NET_DVR_CB_POINT  struCBPoint[MAX_CALIB_PT];  //Valid calibration group
}NET_DVR_TRACK_CALIBRATION_PARAM, *LPNET_DVR_TRACK_CALIBRATION_PARAM;

//Speed Dome configuration
typedef struct tagNET_DVR_TRACK_CFG
{
    DWORD dwSize;                       //Structure size    
    BYTE byEnable;                     //Enable/disable calibration
    BYTE byFollowChan;              //Corresponding channel calibrated
    BYTE byDomeCalibrate;             //Set calibration for auto-tracking speed dome, 1-enable, 0-disable 
    BYTE byRes;                     //Reserved
    NET_DVR_TRACK_CALIBRATION_PARAM  struCalParam;  //Calibration group
}NET_DVR_TRACK_CFG, *LPNET_DVR_TRACK_CFG;

//Tracking mode
typedef enum _TRACK_MODE_
{
    MANUAL_CTRL = 0,   //Manual tracking
    ALARM_TRACK,       //Alarm triggering tracking
    TARGET_TRACK       //Target tracking
}TRACK_MODE;

//Manual control mode
typedef struct tagNET_DVR_MANUAL_CTRL_INFO
{
    NET_VCA_POINT struCtrlPoint;
    BYTE  byRes[8];
}NET_DVR_MANUAL_CTRL_INFO, *LPNET_DVR_MANUAL_CTRL_INFO;

//Tracking mode
typedef struct tagNET_DVR_TRACK_MODE
{
    DWORD dwSize;            //Structure size
    BYTE byTrackMode;      //Tracking mode
    BYTE byRuleConfMode;   //Configuration of tracking mode: 0- local tracking mode config, 1- remote tracking mode config
    BYTE byRes[2];         //Reserved
    union
    {
        DWORD dwULen[4];
        NET_DVR_MANUAL_CTRL_INFO  struManualCtrl; //Manual tracking structure
    }uModeParam;
}NET_DVR_TRACK_MODE, *LPNET_DVR_TRACK_MODE;

typedef struct tagNET_DVR_ALARM_JPEG
{
    BYTE    byPicProType;             //Upload snapshot on alarm 0- disable;  1- upload
    BYTE    byRes[3];               //Reserved
    NET_DVR_JPEGPARA struPicParam;  //Snapshot structure
}NET_DVR_ALARM_JPEG, *LPNET_DVR_ALARM_JPEG;

/**********************ipc/d5.3.0********************************/
typedef struct tagNET_DVR_PHY_RATIO
{
    DWORD  dwSize;
    DWORD  dwPhysicsRatio;
    BYTE   byRes[60];
}NET_DVR_PHY_RATIO, *LPNET_DVR_PHY_RATIO;

typedef struct tagNET_DVR_SLAVECAMERA_COND
{
    DWORD            dwSize;
    DWORD            dwChannel;
    BYTE             byID;//SlaveCamera ID number [1,4]
    BYTE             byRes1[3];
    DWORD           dwSceneID;// scene Id 
    BYTE             byRes[56];
}NET_DVR_SLAVECAMERA_COND, *LPNET_DVR_SLAVECAMERA_COND;

typedef struct tagNET_DVR_SLAVECAMERA_CFG
{
    DWORD            dwSize;
    BYTE                 byAddressType;   //0-ipv4 ipv6 1-domain
    WORD                wPort;
    BYTE               byLoginStatus; /*Slave Camera Login Status 0-logout,1-login*/
    union
    {
        struct
        {
            BYTE            szDomain[MAX_DOMAIN_NAME/*64*/];
            BYTE            byRes1[80];
        }struDomain;
        struct
        {
            NET_DVR_IPADDR     struIp;
        } struAddrIP;
    }unionServer;
    BYTE                szUserName[NAME_LEN/*32*/];
    BYTE                szPassWord[PASSWD_LEN/*16*/];
    BYTE        byRes1[128];
}NET_DVR_SLAVECAMERA_CFG, *LPNET_DVR_SLAVECAMERA_CFG;

typedef struct tagNET_DVR_SLAVECAMERA_PARAM
{
    BYTE             byLinkStatus;// 0- offline,1-online
    BYTE             byRes[15];
}NET_DVR_SLAVECAMERA_PARAM, *LPNET_DVR_SLAVECAMERA_PARAM;

typedef struct tagNET_DVR_SLAVECAMERA_STATUS
{
    DWORD            dwSize;
    NET_DVR_SLAVECAMERA_PARAM  struSlaveCamera[MAX_SLAVECAMERA_NUM/*8*/];
    BYTE             byRes[64];
}NET_DVR_SLAVECAMERA_STATUS, *LPNET_DVR_SLAVECAMERA_STATUS;

typedef struct tagNET_PTZ_INFO
{
    float fPan;
    float fTilt;
    float fZoom;
    DWORD dwFocus;//0-100000
    BYTE  byRes[4];
}NET_PTZ_INFO, *LPNET_PTZ_INFO;

typedef struct tagNET_DVR_BV_CALIB_POSITION
{
    DWORD  dwSize;
    NET_PTZ_INFO struInitialPos;  //Initial Position
    NET_PTZ_INFO struAdjustPos;  //Adjust Position
    BYTE  byRes[300];
}NET_DVR_BV_CALIB_POSITION, *LPNET_DVR_BV_CALIB_POSITION;

typedef struct tagNET_DVR_HUMAN_CALIB_CFG
{
    DWORD  dwSize;
    NET_VCA_POINT struLeftPos;   //Human left position
    NET_VCA_POINT struRightPos;  //Human right position
    BYTE  byRes[300];
}NET_DVR_HUMAN_CALIB_CFG, *LPNET_DVR_HUMAN_CALIB_CFG;

typedef struct tagNET_DVR_CALIB_PARAM
{
    NET_PTZ_INFO   struPtzInfo;
    NET_VCA_POINT  struCalibCoordinates;
    int                iHorValue;
    int                iVerValue;
    BYTE      byRes[8];
}NET_DVR_CALIB_PARAM, *LPNET_DVR_CALIB_PARAM;

typedef struct tagNET_DVR_SLAVECAMERA_CALIB_CFG
{
    DWORD            dwSize;
    BYTE              byCalibMode;//0-res,1-auto, 2-manual
    BYTE             byRes[3];
    NET_DVR_CALIB_PARAM  struCalibParam[MAX_CALIB_NUM/*6*/];
    BYTE             byRes1[64];
}NET_DVR_SLAVECAMERA_CALIB_CFG, *LPNET_DVR_SLAVECAMERA_CALIB_CFG;

typedef struct tagNET_DVR_TRACKING
{
    DWORD dwSize;
    BYTE byEnable;      // 0-false,1-true
    BYTE byMode;        // 0-close,1-manual,2-auto
    WORD  wTrackingTime;// tracking Time:[0,60]s
    NET_VCA_POLYGON struRegion;
    BYTE byRes[64];
}NET_DVR_TRACKING, *LPNET_DVR_TRACKING;

typedef struct tagNET_DVR_SLAVECAMERA_CALIB_V50
{
    DWORD            dwSize;
    BYTE               byCalibMode;//0-Res,1-auto, 2-manual
    BYTE             byRes[3];
    NET_DVR_CALIB_PARAM  struCalibParam[MAX_CALIB_NUM_EX/*20*/];
    BYTE             byRes1[64];
}NET_DVR_SLAVECAMERA_CALIB_V50, *LPNET_DVR_SLAVECAMERA_CALIB_V50;

typedef struct tagNET_DVR_SLAVECAMERA_CALIB_V51
{
    DWORD            dwSize;
    BYTE                byCalibMode;//0-Res,1-auto, 2-manual
    BYTE             byRes[3];
    NET_DVR_CALIB_PARAM  struCalibParam[MAX_CALIB_NUM_EX/*20*/];
    BYTE            byRes1[512];
}NET_DVR_SLAVECAMERA_CALIB_V51, *LPNET_DVR_SLAVECAMERA_CALIB_V51;

//The special features at the structure (eagle eye) 
typedef    struct tagNET_DVR_CAPTURE_PICTURE_RESULT
{
    DWORD        dwSize;//The structure size 
    DWORD    dwReturnPicSize;//Returns the size of the image 
    BYTE        byRes[256];
}NET_DVR_CAPTURE_PICTURE_RESULT, *LPNET_DVR_CAPTURE_PICTURE_RESULT;

typedef struct tagNET_DVR_GOTOSCENE_COND
{
    DWORD            dwSize;
    DWORD            dwChannel;
    DWORD            dwSceneID;//scene id
    BYTE              byRes[512];
}NET_DVR_GOTOSCENE_COND, *LPNET_DVR_GOTOSCENE_COND;

typedef struct tagNET_DVR_TRACK_INITPOSTION
{
    DWORD            dwSize;
    DWORD            dwChannel;
    BYTE             byID;
    BYTE             byRes[127];
}NET_DVR_TRACK_INITPOSTION, *LPNET_DVR_TRACK_INITPOSTION;

typedef struct tagNET_DVR_MANUAL_TRACKRATIO
{
    DWORD            dwSize;
    BYTE             byCoefficient;//Track Ratio Coefficient [1,60]
    BYTE             byRes[127];
}NET_DVR_MANUAL_TRACKRATIO, *LPNET_DVR_MANUAL_TRACKRATIO;

/**********************ipc/d5.3.0********************************/

//iVMS rule structure
//Alarm rule structure
typedef struct tagNET_IVMS_ONE_RULE_
{
    BYTE    byActive;            /* active the rule, 0- disable,  else- yes */
    BYTE    byRes1[7];     //Reserved as 0
    BYTE   byRuleName[NAME_LEN];  //Rule name
    VCA_EVENT_TYPE dwEventType;    //VCA event type
    NET_VCA_EVENT_UNION uEventParam; //VCA parameters
    NET_VCA_SIZE_FILTER  struSizeFilter;   //Size filter
    BYTE byRes2[68];  /*Reserved as 0*/
}NET_IVMS_ONE_RULE, *LPNET_IVMS_ONE_RULE;

// iVMS rule structure
typedef struct tagNET_IVMS_RULECFG
{
    NET_IVMS_ONE_RULE  struRule[MAX_RULE_NUM];    //rule array
}NET_IVMS_RULECFG, *LPNET_IVMS_RULECFG;

// IVMS VCA configuration structure
typedef struct tagNET_IVMS_BEHAVIORCFG
{
    DWORD dwSize;
    BYTE    byPicProType;         //Upload snapshot on alarm: 0-disable;  else- upload
    BYTE    byRes[3];
    NET_DVR_JPEGPARA struPicParam;                  //snapshot structure
    NET_IVMS_RULECFG struRuleCfg[MAX_DAYS][MAX_TIMESEGMENT]; //corresponding rule on each time period
} NET_IVMS_BEHAVIORCFG, *LPNET_IVMS_BEHAVIORCFG;

//Sub structure of the iVMS sub stream query
typedef struct tagNET_IVMS_DEVSCHED
{
    NET_DVR_SCHEDTIME     struTime;        //time structure
    NET_DVR_PU_STREAM_CFG struPUStream;  //PU streaming parameters
}NET_IVMS_DEVSCHED, *LPNET_IVMS_DEVSCHED;

//iVMS configuration structure
typedef struct tagNET_IVMS_STREAMCFG
{
    DWORD dwSize;
    NET_IVMS_DEVSCHED    struDevSched[MAX_DAYS][MAX_TIMESEGMENT]; // Set PU streaming and rule by time period
} NET_IVMS_STREAMCFG, *LPNET_IVMS_STREAMCFG;

//Mask Area
typedef struct tagNET_VCA_MASK_REGION
{
    BYTE byEnable;             //Activate privacy mask,  0- disable, else- enable
    BYTE byRes[3];          //Reserved as 0
    NET_VCA_POLYGON  struPolygon;  //Mask Polygon
}NET_VCA_MASK_REGION, *LPNET_VCA_MASK_REGION;

//Mask region list structure
typedef struct tagNET_VCA_MASK_REGION_LIST
{
    DWORD dwSize;      //Structure length
    BYTE byRes[4];      //Reserved as 0
    NET_VCA_MASK_REGION  struMask[MAX_MASK_REGION_NUM];  //Mask region list structure
}NET_VCA_MASK_REGION_LIST, *LPNET_VCA_MASK_REGION_LIST;


//ATM Enter Region
typedef struct tagNET_VCA_ENTER_REGION//Mask the target entering the region to avoid interference on ATM detection
{
    DWORD dwSize;
    BYTE byEnable;             //Activate the function, 0- disable, else- enable
    BYTE byRes1[3];
    NET_VCA_POLYGON  struPolygon;  //Enter area
    BYTE byRes2[16];
}NET_VCA_ENTER_REGION, *LPNET_VCA_ENTER_REGION;

//IVMS mask region list
typedef struct tagNET_IVMS_MASK_REGION_LIST
{
    DWORD dwSize;     //Structure length
    NET_VCA_MASK_REGION_LIST struList[MAX_DAYS][MAX_TIMESEGMENT];
}NET_IVMS_MASK_REGION_LIST, *LPNET_IVMS_MASK_REGION_LIST;

//ATM enter area parameters of iVMS
typedef struct tagNET_IVMS_ENTER_REGION
{
    DWORD dwSize;
    NET_VCA_ENTER_REGION  struEnter[MAX_DAYS][MAX_TIMESEGMENT];  //Enter area
}NET_IVMS_ENTER_REGION, *LPNET_IVMS_ENTER_REGION;

// iVMS alarm upload structure
typedef struct tagNET_IVMS_ALARM_JPEG
{
    BYTE                byPicProType;
    BYTE                byRes[3];
    NET_DVR_JPEGPARA      struPicParam;
}NET_IVMS_ALARM_JPEG, *LPNET_IVMS_ALARM_JPEG;

// IVMS  Playback Search Config
typedef struct tagNET_IVMS_SEARCHCFG
{
    DWORD                        dwSize;
    NET_DVR_MATRIX_DEC_REMOTE_PLAY struRemotePlay; // Remote playback
    NET_IVMS_ALARM_JPEG         struAlarmJpeg;  // alarm snapshot upload config
    NET_IVMS_RULECFG           struRuleCfg;    //IVMS VCA rule config
}NET_IVMS_SEARCHCFG, *LPNET_IVMS_SEARCHCFG;

//Calibration parameters
typedef struct tagNET_DVR_TRACK_CALIBRATION_PARAM_V41
{
    BYTE byPointNum;    //Calibration point number
    BYTE byRes[3];        //Reserved
    NET_DVR_CB_POINT  struCBPoint[MAX_CALIB_PT]; //Calibration point group
    NET_DVR_PTZPOS struHorizonPtzPos;  //Horizontal positon of the track device
    BYTE byRes2[256];    //Reserved
}NET_DVR_TRACK_CALIBRATION_PARAM_V41, *LPNET_DVR_TRACK_CALIBRATION_PARAM_V41;

//Tracking device configuration parameters
typedef struct tagNET_DVR_TRACK_DEV_PARAM_
{
    DWORD  dwSize;         //Structure size
    BYTE   byEnable;       //Track device enabled, 0-disable, 1 -enable
    BYTE   byTransMode;    //Communication mode,0-NET SDK,1-Serial port 485
    BYTE   byRes1[2];       //Reserved
    NET_DVR_CHANNEL  struTrackDevChan; //Tracking device parameters    
    NET_DVR_TRACK_CALIBRATION_PARAM_V41 struCalParam; //Tracking device calibration parameters    
    BYTE    byRes2[256];    //Reserved
}NET_DVR_TRACK_DEV_PARAM, *LPNET_DVR_TRACK_DEV_PARAM;

/************************************end******************************************/
//NAS identification cfg
typedef struct tagNET_DVR_IDENTIFICATION_PARAM
{
    BYTE    sUserName[NAME_LEN];        /* username len 32*/
    BYTE    sPassword[PASSWD_LEN];        /* passwd len 16*/
    BYTE    byRes1[4];    //res
}NET_DVR_IDENTIFICATION_PARAM, *LPNET_DVR_IDENTIFICATION_PARAM;

typedef union tagNET_DVR_MOUNT_PARAM_UNION
{
    BYTE  uLen[52];                    //union len
    NET_DVR_IDENTIFICATION_PARAM struIdentificationParam;//(SMB/CIFS work)
} NET_DVR_MOUNT_PARAM_UNION, *LPNET_DVR_MOUNT_PARAM_UNION;

typedef struct tagNET_DVR_NAS_MOUNT_PARAM
{
    BYTE  byMountType; //0~res,1~NFS, 2~ SMB/CIFS
    BYTE  byRes[3];
    NET_DVR_MOUNT_PARAM_UNION uMountParam;
}NET_DVR_NAS_MOUNT_PARAM, *LPNET_DVR_NAS_MOUNT_PARAM;

typedef union tagNET_DVR_MOUNTMETHOD_PARAM_UNION
{
    BYTE  uLen[56]; //union len                   
    NET_DVR_NAS_MOUNT_PARAM struNasMountParam;//NAS mount type (byNetDiskType == NFS(NAS)) 
}NET_DVR_MOUNTMETHOD_PARAM_UNION, *LPNET_DVR_MOUNTMETHOD_PARAM_UNION;


//Network Disk configuration
typedef struct tagNET_DVR_SINGLE_NET_DISK_INFO
{
    BYTE byNetDiskType;                         //0- NFS, 1- iSCSI
    BYTE byRes1[3];                             //Reserved
    NET_DVR_IPADDR struNetDiskAddr;             //IP address
    BYTE sDirectory[PATHNAME_LEN];             // PATHNAME_LEN = 128
    WORD wPort;                                 //iSCSI port
    BYTE  byRes2[2];
    NET_DVR_MOUNTMETHOD_PARAM_UNION  uMountMethodParam;
    BYTE  byRes3[8];                //res
}NET_DVR_SINGLE_NET_DISK_INFO, *LPNET_DVR_SINGLE_NET_DISK_INFO;

#define MAX_NET_DISK    16//Max. HDD number

typedef struct tagNET_DVR_NET_DISKCFG
{
    DWORD  dwSize;
    NET_DVR_SINGLE_NET_DISK_INFO struNetDiskParam[MAX_NET_DISK];
}NET_DVR_NET_DISKCFG, *LPNET_DVR_NET_DISKCFG;

typedef struct tagNET_DVR_SINGLE_NET_DISK_INFO_V40
{
    BYTE byNetDiskType;                         //0- NFS, 1- iSCSI
    BYTE byRes1[3];                             //Reserved
    BYTE sDirectory[PATHNAME_LEN];             // PATHNAME_LEN = 128
    BYTE byDevAddr[MAX_DOMAIN_NAME];    /*domain*/
    WORD wPort;                                 //iSCSI port
    BYTE  byRes2[2];
    NET_DVR_MOUNTMETHOD_PARAM_UNION  uMountMethodParam;
    BYTE    byRes4[80];
}NET_DVR_SINGLE_NET_DISK_INFO_V40, *LPNET_DVR_SINGLE_NET_DISK_INFO_V40;

typedef struct tagNET_DVR_NET_DISKCFG_V40
{
    DWORD  dwSize;
    NET_DVR_SINGLE_NET_DISK_INFO_V40 struNetDiskParam[MAX_NET_DISK];
}NET_DVR_NET_DISKCFG_V40, *LPNET_DVR_NET_DISKCFG_V40;
//Event Type
//Main type
typedef enum _MAIN_EVENT_TYPE_
{
    EVENT_MOT_DET = 0,             //Motion Detect
    EVENT_ALARM_IN = 1,         //Alarm input
    EVENT_VCA_BEHAVIOR = 2,     //VCA
    EVENT_INQUEST = 3,            //Inquest Event
    EVENT_VCA_DETECTION = 4,    //intelligent detect
    EVENT_POS = 5,
    EVENT_TRIAL_CASE = 6,//case info
    EVENT_ACS_CASE = 7,  //case acs
    EVENT_IOT_CASE = 8,  //IOT linkage events
    EVENT_STREAM_INFO = 100     //Stream ID information
}MAIN_EVENT_TYPE;

typedef enum _VCA_DETECTION_MINOR_TYPE_
{
    EVENT_VCA_TRAVERSE_PLANE = 1,        //traverse plane
    EVENT_FIELD_DETECTION,             //field detection
    EVENT_AUDIO_INPUT_ALARM,      //audio input alarm
    EVENT_SOUND_INTENSITY_ALARM,   //sound intensity
    EVENT_FACE_DETECTION,             //face detection
    EVENT_VIRTUAL_FOCUS_ALARM, /*virtul focus*/
    EVENT_SCENE_CHANGE_ALARM, /*scene change*/
    EVENT_PIR_ALARM,
    EVENT_ENTER_REGION,                           //enter region
    EVENT_EXIT_REGION,                            //exit region
    EVENT_LOITERING,                               //loitering 
    EVENT_GROUPDETECTION,                       //group detection
    EVENT_RAPIDMOVE,                            //rapidmove
    EVENT_PARK,                              //park
    EVENT_UNATTENDED_BAGGAGE,                   //unattended baggage
    EVENT_ATTENDEDBAGGAGE,                      //attended baggage
    EVENT_VEHICLE_DETECTION,                     //vehicle detection
    EVENT_ALL = 0xffffffff                //all 
}VCA_DETECTION_MINOR_TYPE;

#define INQUEST_START_INFO        0x1001
#define INQUEST_STOP_INFO         0x1002
#define INQUEST_TAG_INFO          0x1003
#define INQUEST_SEGMENT_INFO      0x1004
#define INQUEST_CASE_INFO          0x1005

//VCA event type corresponding to the main event type, 0xffff stands for all
typedef enum _BEHAVIOR_MINOR_TYPE_
{
    EVENT_TRAVERSE_PLANE = 0,   //Traverse plane
    EVENT_ENTER_AREA,                 //target enter area (region rule)
    EVENT_EXIT_AREA,                 //target leave area  (region rule)
    EVENT_INTRUSION,                 //Intrusion  (region rule)
    EVENT_LOITER,                     //Loitering  (region rule)
    EVENT_LEFT_TAKE,                 //Object left or taken  (region rule)
    EVENT_PARKING,                     //Illegal parking  (region rule)
    EVENT_RUN,                         //Running (region rule)
    EVENT_HIGH_DENSITY,
    EVENT_STICK_UP,                    //Stick up, support area rule
    EVENT_INSTALL_SCANNER,            //Install scanner, support area rule
    EVENT_OPERATE_OVER_TIME,        //Operation overtime
    EVENT_FACE_DETECT,              //Exception face 
    EVENT_LEFT,                     //Items left
    EVENT_TAKE,                      //Items take
    EVENT_LEAVE_POSITION,         //Leave position
    EVENT_TRAIL_INFO = 16,            //Trial
    EVENT_HUMAN_ENTER = 18,                 //Human enter
    EVENT_FALL_DOWN_INFO = 19,                 //Fall down
    EVENT_OBJECT_PASTE = 20,        //object paste
    EVENT_FACE_CAPTURE_INFO = 21,                //Face capture
    EVENT_MULTI_FACES_INFO = 22,                  //Multi faces
    EVENT_AUDIO_ABNORMAL_INFO = 23,             //Audio abnormal
    EVENT_DETECT = 24,                    //smart detection
    EVENT_SUNGLASSES_FACE_INFO = 25,             //sunglasses face
    EVENT_CALLING_FACE_INFO = 26,                   //calling face
    EVENT_VIOLENT_MOTION = 27,                   //violent motion
    EVENT_SAFETY_HELMET = 28,                     //safety helmet detection
    EVENT_PEOPLE_NUM_CHANGE = 29,                 //people number change
    EVENT_GET_UP = 30,                            //get up
    EVENT_ADV_REACH_HEIGHT = 31,
    EVENT_STOOD_UP = 32,                           //stand up
    EVENT_PERSON_DENSITY = 33                     //pre-warning about density of people
}BEHAVIOR_MINOR_TYPE;

//Major type 6, minor type
typedef enum _TRIAL_CASE_MINOR_TYPE_
{
    TRIAL_START_INFO = 0x1001,    // trial start info
    TRIAL_STOP_INFO = 0x1002,        //trial stio info
    TRIAL_TAG_INFO = 0x1003,        //trial tag info
    TRIAL_SEGMENT_INFO = 0x1004,    // trial segment info
    TRIAL_JUDGE_CASE_INFO = 0x1005 //judge case info
}TRIAL_CASE_MINOR_TYPE;

// Major type 100, minor type
typedef enum _STREAM_INFO_MINOR_TYPE_
{
    EVENT_STREAM_ID = 0,                // all stream id record
    EVENT_TIMING = 1,                    // time record
    EVENT_MOTION_DETECT = 2,            // motion detect record
    EVENT_ALARM = 3,                    // alarm record
    EVENT_ALARM_OR_MOTION_DETECT = 4,    // alarm or motion detect record
    EVENT_ALARM_AND_MOTION_DETECT = 5,    // alarm and motion detect record
    EVENT_COMMAND_TRIGGER = 6,            // command trigger
    EVENT_MANNUAL = 7,                    // mannual record
    EVENT_BACKUP_VOLUME = 8,            // Backup volume
    STREAM_EVENT_SEMAPHORE,
    STREAM_EVENT_HIDE,
    STREAM_EVENT_INVERSE,
    STREAM_EVENT_VIDEO_LOST,
    STREAM_EVENT_WIRELESS_ALARM,
    STREAM_EVENT_PIR_ALARM,
    STREAM_EVENT_CALLHELP_ALARM,

    STREAM_EVENT_FACESNAP,
    STREAM_EVENT_FACE_DETECTION,
    STREAM_EVENT_ITS_PLATE,
    STREAM_EVENT_PDC,
    STREAM_EVENT_SCENECHANGE_DETECTION,
    STREAM_EVENT_DEFOCUS_DETECTION,
    STREAM_EVENT_AUDIOEXCEPTION,

    VCA_EVENT_TRAVERSE_PLANE,
    VCA_EVENT_INTRUSION,
    VCA_EVENT_ENTER_AREA,
    VCA_EVENT_EXIT_AREA,
    VCA_EVENT_LOITER,
    VCA_EVENT_HIGH_DENSITY,
    VCA_EVENT_RUN,
    VCA_EVENT_PARKING,
    VCA_EVENT_LEFT,
    VCA_EVENT_TAKE
}STREAM_INFO_MINOR_TYPE;



#define SEARCH_EVENT_INFO_LEN 300    //Event info length
#define CASE_NO_LEN                64
#define CASE_NAME_LEN            128
#define LITIGANT_LEN            32
#define CHIEF_JUDGE_LEN         32
#define     SEARCH_CASE_NO_LEN        56
#define  SEARCH_CASE_NAME_LEN    100
#define  SEARCH_LITIGANT_LEN    32
#define  SEARCH_CHIEF_JUDGE_LEN 32
#define     CASE_NO_RET_LEN        52
#define  CASE_NAME_RET_LEN        64
#define     LITIGANT_RET_LEN        24
#define     CHIEF_JUDGE_RET_LEN    24
#define  NET_SDK_CASETYPE_LEN      32
//Event search condition
typedef struct tagNET_DVR_SEARCH_EVENT_PARAM
{
    WORD wMajorType;             //0- Motion detect, 1- Alarm input,  2-  intelligent event
    WORD wMinorType;             //Sub type- diverse according to the main type, 0xffff- all
    NET_DVR_TIME struStartTime; //Search start and end time, (0,  0) stands for searching from the earliest time and get maximum 4000 events 
    NET_DVR_TIME struEndTime;
    BYTE            byLockType;        // 0xff-all,0-unlock,1-lock
    BYTE             byValue;            //0-by bit,1-by value
    BYTE             byRes[130];
    union
    {
        BYTE byLen[SEARCH_EVENT_INFO_LEN];
        struct//Alarm input
        {
            BYTE byAlarmInNo[MAX_ALARMIN_V30];     //Alarm input, if the byAlarmInNo[0] is set as 1, then it stands for event triggered by alarm input 1 
            BYTE byRes[SEARCH_EVENT_INFO_LEN - MAX_ALARMIN_V30];
        }struAlarmParam;

        struct//Alarm input -- By Value
        {
            WORD wAlarmInNo[128];     /*Alarm input No. ,according to the values*/
            BYTE byRes[44];
        }struAlarmParamByValue;

        struct//motion detect
        {
            BYTE byMotDetChanNo[MAX_CHANNUM_V30]; //Motion detect channel, if byMotDetChanNo[0] is set as 1, then it stands for event triggered by channel 1 motion detect
            BYTE byRes[SEARCH_EVENT_INFO_LEN - MAX_CHANNUM_V30];
        }struMotionParam;

        struct//motion detect -- By Value 
        {
            WORD wMotDetChanNo[64];        /* Motion detect channel No.,according to the values */
            BYTE byRes[172];
        }struMotionParamByValue;

        struct//VCA
        {
            BYTE byChanNo[MAX_CHANNUM_V30]; //Channel than triggered the event
            BYTE byRuleID;                     //Rule ID, 0xff- all
            BYTE byRes1[43];                 //Reserved
        }struVcaParam;

        struct //VCA-- By Value
        {
            WORD wChanNo[64];     //Channel than triggered the event
            BYTE byRuleID;      //Rule ID, 0xff- all
            BYTE byRes[171];
        }struVcaParamByValue;

        struct//Inquest
        {
            BYTE byRoomIndex;    //Inquest room number
            BYTE byRes1[3];
            BYTE sInquestInfo[INQUEST_CASE_LEN];
            BYTE byRes2[232];     //Reserved
        } struInquestParam;
        struct// VCA Detect Condition
        {
            BYTE byChan[256];//VCA Detect Trigger channel number, If byChan[0] is 1, is to say Find VCA Detect chan 1
        }struVCADetectByBit;

        struct   // VCA Detect Condition, Chan  indicated by value 
        {
            DWORD dwChanNo[MAX_CHANNUM_V30 - 1];// VCA Detect Trigger channel number, by value,  0xffffffff invalid and subsequent data also indicates an invalid value
            BYTE byAll;//0-not all,1-all
            BYTE byres[3];
        }struVCADetectByValue;
        struct
        {
            NET_DVR_STREAM_INFO struIDInfo; // Stream id
            DWORD                dwCmdType;  // Command type
            BYTE                byBackupVolumeNum;
            BYTE                byRes[223];
        }struStreamIDParam;
        struct
        {
            BYTE    byCaseNo[SEARCH_CASE_NO_LEN];
            BYTE    byCaseName[SEARCH_CASE_NAME_LEN];
            BYTE    byLitigant1[SEARCH_LITIGANT_LEN];
            BYTE    byLitigant2[SEARCH_LITIGANT_LEN];
            BYTE    byChiefJudge[SEARCH_CHIEF_JUDGE_LEN];
            BYTE    byCaseType;
            BYTE    byRes[47];
        }struTrialParam;
    }uSeniorParam;
}NET_DVR_SEARCH_EVENT_PARAM, *LPNET_DVR_SEARCH_EVENT_PARAM;

#define  MAX_POS_KEYWORDS_NUM               3           
#define  MAX_POS_KEYWORD_LEN                128          
#define  MAX_POS_FILTER_DATA_LEN_MAX         128
#define  SEARCH_EVENT_INFO_LEN_V40             800


typedef struct tagNET_DVR_SEARCH_EVENT_PARAM_V40
{
    WORD wMajorType;             //0- Motion detect, 1- Alarm input,  2-  intelligent event, 7- ACS event
    WORD wMinorType;             //Sub type- diverse according to the main type, 0xffff- all
    NET_DVR_TIME struStartTime; //Search start and end time, (0,  0) stands for searching from the earliest time and get maximum 4000 events 
    NET_DVR_TIME struEndTime;
    BYTE            byLockType;        // 0xff-all,0-unlock,1-lock
    BYTE            byQuickSearch;        // Whether to enable quick query, 0- not enabled, 1- enabled (quick query does not return file size, only query the device database, avoid frequent waking of hard disk)
    BYTE             byRes[130];
    union
    {
        BYTE byLen[SEARCH_EVENT_INFO_LEN_V40/*800*/];
        struct//Alarm input -- By Value
        {
            WORD wAlarmInNo[128];     /*Alarm input No. ,according to the values*/
            BYTE byRes[544];
        }struAlarmParam;

        struct
        {

            WORD wMotDetChanNo[MAX_CHANNUM_V30];
            BYTE byRes[672];
        }struMotionParam;

        struct
        {
            WORD wChanNo[MAX_CHANNUM_V30];
            BYTE byRuleID;
            BYTE byRes[671];
        }struVcaParam;

        struct
        {
            BYTE byRoomIndex;
            BYTE byRes[799];
        } struInquestParam;

        struct
        {
            BYTE byAll;
            BYTE byRes1[3];
            WORD wChanNo[MAX_CHANNUM_V30];
            BYTE byRes[668];
        }struVCADetect;

        struct
        {
            NET_DVR_STREAM_INFO struIDInfo; // Stream id
            DWORD                dwCmdType;  // Command type
            BYTE                byBackupVolumeNum;
            BYTE                byRes1[3];
            BYTE                byArchiveLabel[64]; //Archive label
            BYTE                byRes[656];
        }struStreamIDParam;

        struct
        {
            WORD    wChannel[MAX_CHANNUM_V30];
            BYTE    byAllChan;
            BYTE    byCaseSensitive;
            BYTE    byCombinateMode;
            BYTE    byRes1;
            char    sKeyWord[MAX_POS_KEYWORDS_NUM][MAX_POS_KEYWORD_LEN];
            BYTE    byRes[284];
        }struPosAlarm;

        struct
        {
            BYTE    byCaseNo[SEARCH_CASE_NO_LEN];
            BYTE    byCaseName[SEARCH_CASE_NAME_LEN];
            BYTE    byLitigant1[SEARCH_LITIGANT_LEN];
            BYTE    byLitigant2[SEARCH_LITIGANT_LEN];
            BYTE    byChiefJudge[SEARCH_CHIEF_JUDGE_LEN];
            BYTE    byCaseType;
            BYTE    byRes[47];
        }struTrialParam;

        struct
        {
            DWORD dwMajor;
            DWORD dwMinor;
            BYTE byCardNo[ACS_CARD_NO_LEN];
            BYTE byName[NAME_LEN];
            BYTE byMACAddr[MACADDR_LEN];
            BYTE byRes[722];
        }struACSAlarm;
    }uSeniorParam;
}NET_DVR_SEARCH_EVENT_PARAM_V40, *LPNET_DVR_SEARCH_EVENT_PARAM_V40;

//event search conditions
typedef struct tagNET_DVR_SEARCH_EVENT_PARAM_V50
{
    WORD wMajorType;            //0- Motion detect, 1- Alarm input,  2-  intelligent event, 7- ACS event , 8-IOT event
    WORD wMinorType;            //Sub type- diverse according to the main type, 0xffff- all
    NET_DVR_TIME_SEARCH_COND struStartTime;    //Search start and end time, (0,  0) stands for searching from the earliest time and get maximum 4000 events 
    NET_DVR_TIME_SEARCH_COND struEndTime;    //
    BYTE            byLockType;        // 0xff-all,0-unlock,1-lock
    BYTE            byQuickSearch;        //
    BYTE             byRes[254];
    union
    {
        BYTE byLen[SEARCH_EVENT_INFO_LEN_V40/*800*/];
        struct
        {

            WORD wAlarmInNo[128];
            BYTE byRes[544];
        }struAlarmParam;

        struct
        {

            WORD wMotDetChanNo[MAX_CHANNUM_V30];
            BYTE byRes[672];
        }struMotionParam;

        struct
        {
            WORD wChanNo[MAX_CHANNUM_V30];
            BYTE byRuleID;
            BYTE byRes[671];
        }struVcaParam;

        struct//Trial event
        {
            BYTE byRoomIndex;
            BYTE byRes[799];
        }struInquestParam;

        struct//Intelligent detection and search conditions, the channel number by value 
        {
            BYTE byAll;
            BYTE byRes1[3];
            WORD wChanNo[MAX_CHANNUM_V30];//The channel, according to the value, the compact arrangement, encountered 0xFFFF, said the follow-up value of the array is invalid 
            BYTE byRes[668];
        }struVCADetect;

        struct
        {
            NET_DVR_STREAM_INFO struIDInfo; // id,72 byte length
            DWORD                dwCmdType;  //External trigger type, NVR access cloud storage use 
            BYTE                byBackupVolumeNum;
            BYTE                byRes1[3];
            BYTE                byArchiveLabel[64]; //
            BYTE                byRes[656];
        }struStreamIDParam;

        struct //pos 
        {
            WORD   wChannel[MAX_CHANNUM_V30];        //The channel, according to the value, the compact arrangement, encountered 0xFFFF, said the follow-up value of the array is invalid 
            BYTE     byAllChan;            //,0-no,1-yes
            BYTE      byCaseSensitive;      //0-Case insensitive 1-Case sensitive 
            BYTE      byCombinateMode;  //combination mode,0-or,1-and
            BYTE      byRes1;
            char     sKeyWord[MAX_POS_KEYWORDS_NUM][MAX_POS_KEYWORD_LEN];
            BYTE    byRes[284];
        }struPosAlarm;

        struct
        {
            BYTE    byCaseNo[SEARCH_CASE_NO_LEN];
            BYTE    byCaseName[SEARCH_CASE_NAME_LEN];
            BYTE    byLitigant1[SEARCH_LITIGANT_LEN];
            BYTE    byLitigant2[SEARCH_LITIGANT_LEN];
            BYTE    byChiefJudge[SEARCH_CHIEF_JUDGE_LEN];
            BYTE    byCaseType;
            BYTE    byRes[547];
        }struTrialParam;

        struct //acs
        {
            DWORD dwMajor;
            DWORD dwMinor;
            BYTE byCardNo[ACS_CARD_NO_LEN];
            BYTE byName[NAME_LEN/*32*/];
            BYTE byMACAddr[MACADDR_LEN];
            BYTE byRes[722];
        }struACSAlarm;
        struct //IOT
        {
            WORD      wDeviceType;            //Device type
            WORD      wEventType;            //Search subtype - 0xffff represents the whole, according to the main type change.
            WORD      wChannel[MAX_CHANNUM_V30/*64*/];        //The channel number, by value, is compact, and when it encounters 0xffff, it means that the array's subsequent value is invalid.
            BYTE      byAllChan;        //Whether to find all channels, 0- no, at this time wChannel is valid, 1- all channels, when wChannel is invalid.
            BYTE      byCaseSensitive;      //0- case insensitive, 1- case sensitive.
            BYTE      byCombinateMode;  //Keyword combination, 0- or 1- with.
            BYTE      bySearchType;      //Search mode: 0- search by video source
            char      sKeyWord[MAX_POS_KEYWORDS_NUM/*3*/][MAX_POS_KEYWORD_LEN/*128*/];//Conditions for keyword search.
            WORD      wZoneNo;           //zone No.
            BYTE      byRes[278];          //reserv
        }struIOTAlarm;
    }uSeniorParam;
}NET_DVR_SEARCH_EVENT_PARAM_V50, *LPNET_DVR_SEARCH_EVENT_PARAM_V50;

//Search result returned
typedef struct tagNET_DVR_SEARCH_EVENT_RET
{
    WORD wMajorType;             //Main type
    WORD wMinorType;             //Sub type
    NET_DVR_TIME struStartTime; //Event starts time
    NET_DVR_TIME struEndTime;   //Event ends time, it will be equal to the start time for pulse event
    BYTE byChan[MAX_CHANNUM_V30];
    BYTE byChanEx[32];         //Expand bychan ,you can use this byChanEx replace byChan
    BYTE byRes[4];
    union
    {
        struct//alarm input result
        {
            DWORD dwAlarmInNo;      //alarm input number
            BYTE byRes[SEARCH_EVENT_INFO_LEN];
        }struAlarmRet;
        struct//Motion detect result
        {
            DWORD dwMotDetNo;     //Motion detect channel
            BYTE byRes[SEARCH_EVENT_INFO_LEN];
        }struMotionRet;
        struct//VCA
        {
            DWORD dwChanNo;                     //Channel than VCA event is triggered
            BYTE byRuleID;                     //Rule ID
            BYTE byRes1[3];                     //Reserved
            BYTE byRuleName[NAME_LEN];         //Rule ID
            NET_VCA_EVENT_UNION uEvent;      //VCA event parameters, wMinorType = VCA_EVENT_TYPE
        }struVcaRet;
        struct//Inquest
        {
            BYTE  byRoomIndex;     //Inquest room number
            BYTE  byDriveIndex;    //Driver number
            BYTE  byRes1[6];       //Reserved
            DWORD dwSegmentNo;     //Segment number
            WORD  wSegmetSize;     //Segment size,M
            WORD  wSegmentState;   //Segment state: 0- Normal, 1- Exception, 2- CD not write when inquest
            BYTE  byRes2[288];     //Reserved
        }struInquestRet;
        struct // Stream id
        {
            DWORD dwRecordType;        //record type 
            DWORD dwRecordLength;    //record length
            BYTE  byLockFlag;    // lock flag 0:locked 1:not locked
            BYTE  byDrawFrameType;    // 0:common record 1:draw frame record
            BYTE  byRes1[2];
            BYTE  byFileName[NAME_LEN];     //File name
            DWORD dwFileIndex;
            BYTE  byRes[256];
        }struStreamIDRet;
        struct
        {
            BYTE    byRoomIndex;
            BYTE    byDriveIndex;
            WORD    wSegmetSize;
            DWORD    dwSegmentNo;
            BYTE    bySegmentState;
            BYTE    byCaseType;
            BYTE    byRes[2];
            BYTE    byCaseNo[CASE_NO_RET_LEN];
            BYTE    byCaseName[CASE_NAME_RET_LEN];
            BYTE    byLitigant1[LITIGANT_RET_LEN];
            BYTE    byLitigant2[LITIGANT_RET_LEN];
            BYTE    byChiefJudge[CHIEF_JUDGE_RET_LEN];
            BYTE    byRes1[104];
        }struTrialRet;
    }uSeniorRet;
}NET_DVR_SEARCH_EVENT_RET, *LPNET_DVR_SEARCH_EVENT_RET;

#define NET_SDK_MAX_TAPE_INDEX_LEN  32  //Maximum length of tape number
#define NET_SDK_MAX_FILE_LEN        256  //Maximum length of filename

typedef struct tagNET_DVR_SEARCH_EVENT_RET_V40
{
    WORD wMajorType;             //Main type
    WORD wMinorType;             //Sub type
    NET_DVR_TIME struStartTime; //Event starts time
    NET_DVR_TIME struEndTime;   //Event ends time, it will be equal to the start time for pulse event

    WORD  wChan[MAX_CHANNUM_V40/*512*/];
    BYTE byRes[36];
    union
    {
        BYTE  byLen[800];
        struct//alarm input result
        {
            DWORD dwAlarmInNo;      //alarm input number
            BYTE byRes[796];
        }struAlarmRet;
        struct//Motion detect result
        {
            DWORD dwMotDetNo;     //Motion detect channel
            BYTE byRes[796];
        }struMotionRet;
        struct//VCA
        {
            DWORD dwChanNo;                     //Channel than VCA event is triggered
            BYTE byRuleID;                     //Rule ID
            BYTE byRes1[3];                     //Reserved
            BYTE byRuleName[NAME_LEN];         //Rule ID
            NET_VCA_EVENT_UNION uEvent;      //VCA event parameters, wMinorType = VCA_EVENT_TYPE
            BYTE byRes[668];                    //Reserved
        }struVcaRet;

        struct//Inquest
        {
            BYTE  byRoomIndex;     //Inquest room number
            BYTE  byDriveIndex;    //Driver number
            BYTE  byRes1[6];       //Reserved
            DWORD dwSegmentNo;     //Segment number
            WORD  wSegmetSize;     //Segment size,M
            WORD  wSegmentState;   //Segment state: 0- Normal, 1- Exception, 2- CD not write when inquest
            BYTE  byRes2[784];     //Reserved
        }struInquestRet;

        struct
        {
            DWORD dwRecordType;        //record type 
            DWORD dwRecordLength;    //record length
            BYTE  byLockFlag;    // lock flag 0:locked 1:not locked
            BYTE  byDrawFrameType;    // 0:common record 1:draw frame record
            BYTE  byPosition;/* File storage location: 0 - array, 1 - to bring library reservation, you can directly download,
                             2 - tape rolls, need to put the disk on the switch to the ticket reservation,
                             3 - not in the tape library, need to insert a disk into the tape library */
            BYTE  byRes1;
            BYTE  byFileName[NAME_LEN];     //File name
            DWORD dwFileIndex;
            BYTE  byTapeIndex[NET_SDK_MAX_TAPE_INDEX_LEN];  //File tape number
            BYTE  byFileNameEx[NET_SDK_MAX_FILE_LEN/*256*/]; //Filename extension
            BYTE  byRes[464];
        }struStreamIDRet;
        struct
        {
            DWORD dwChanNo;
            BYTE byRes[796];
        }struPosRet;
    }uSeniorRet;
}NET_DVR_SEARCH_EVENT_RET_V40, *LPNET_DVR_SEARCH_EVENT_RET_V40;


typedef struct tagNET_DVR_SEARCH_EVENT_RET_V50
{
    WORD wMajorType;            //Main type
    WORD wMinorType;            //Sub type
    NET_DVR_TIME_SEARCH struStartTime;  //Event starts time
    NET_DVR_TIME_SEARCH struEndTime;   //Event ends time, it will be equal to the start time for pulse event
    NET_DVR_ADDRESS struAddr;  //Fragments of address information, cluster playback when used
    WORD  wChan[MAX_CHANNUM_V40/*512*/];    //the channel number which is triggered ,0xffff-invalid
    BYTE byRes[256];
    union
    {
        BYTE  byLen[800];
        struct//alarm input result
        {
            DWORD dwAlarmInNo;    //alarm input number
            BYTE byRes[796];
        }struAlarmRet;
        struct//Motion detect result
        {
            DWORD dwMotDetNo;    //channel
            BYTE byRes[796];
        }struMotionRet;
        struct//VCA
        {
            DWORD dwChanNo;                    //Channel than VCA event is triggered
            BYTE byRuleID;                    ///Rule ID
            BYTE byRes1[3];                    //Reserved
            BYTE byRuleName[NAME_LEN];        //Rule ID
            NET_VCA_EVENT_UNION uEvent;     //VCA event parameters, wMinorType = VCA_EVENT_TYPE
            BYTE byRes[668];                    //Reserved
        }struVcaRet;

        struct//Inquest
        {
            BYTE  byRoomIndex;     //Inquest room number
            BYTE  byDriveIndex;    //Driver number
            BYTE  byRes1[6];       //Reserved
            DWORD dwSegmentNo;     ///Segment number
            WORD  wSegmetSize;     //Segment size,M
            WORD  wSegmentState;   //Segment state: 0- Normal, 1- Exception, 2- CD not write when inquest
            BYTE  byRes2[784];     //Reserved
        }struInquestRet;

        struct //StreamID
        {
            DWORD dwRecordType;      //record type
            DWORD dwRecordLength;    ////record length
            BYTE  byLockFlag;    // lock flag 0:locked 1:not locked
            BYTE  byDrawFrameType;    // 0:common record 1:draw frame record
            BYTE  byPosition;/* File storage location: 0 - array, 1 - to bring library reservation, you can directly download,
                             2 - tape rolls, need to put the disk on the switch to the ticket reservation,
                             3 - not in the tape library, need to insert a disk into the tape library */
            BYTE  byRes1;
            BYTE  byFileName[NAME_LEN];      //File name
            DWORD dwFileIndex;
            BYTE  byTapeIndex[NET_SDK_MAX_TAPE_INDEX_LEN];  //File tape number
            BYTE  byFileNameEx[NET_SDK_MAX_FILE_LEN/*256*/]; //Filename extension
            BYTE  byRes[464];
        }struStreamIDRet;

        struct//POS
        {
            DWORD dwChanNo;        //channel
            BYTE byRes[796];
        }struPosRet;

        struct
        {
            BYTE    byRoomIndex;
            BYTE    byDriveIndex;
            WORD    wSegmetSize;
            DWORD   dwSegmentNo;
            BYTE    bySegmentState;
            BYTE    byCaseType;
            BYTE    byRes[2];
            BYTE    byCaseNo[CASE_NO_RET_LEN];
            BYTE    byCaseName[CASE_NAME_RET_LEN];
            BYTE    byLitigant1[LITIGANT_RET_LEN];
            BYTE    byLitigant2[LITIGANT_RET_LEN];
            BYTE    byChiefJudge[CHIEF_JUDGE_RET_LEN];
            BYTE    byRes1[600];
        }struTrialRet;
        struct//IOT
        {
            DWORD dwChanNo;        //The channel number that triggers the event (event source channel)
            BYTE byRes[796];
        }struIOTRet;
    }uSeniorRet;
}NET_DVR_SEARCH_EVENT_RET_V50, *LPNET_DVR_SEARCH_EVENT_RET_V50;

//SDK_V35  2009- 10- 26


// Set face recognition parameter key word
typedef enum _FACE_PARAM_KEY_
{
    MAX_FACE_SIZE = 20,    //Max. face size
    MINI_FACE_SIZE = 21        //Min. Face size
}FACE_PARAM_KEY;            //Face recognition parameter 


// Calibration type 
typedef enum tagCALIBRATE_TYPE
{
    PDC_CALIBRATE = 0x01,  //PDC calibration
    BEHAVIOR_OUT_CALIBRATE = 0x02,  //VCA outdoor calibration  
    BEHAVIOR_IN_CALIBRATE = 0x03,  //VCA indoor calibration
    ITS_CALBIRETE = 0x04,  //Traffic event calibration
    BV_DIRECT_CALIBRATE = 0x05,  //Binocular camera calibration  
    PDC_LINE_CALIBRATE = 0x06   //PDC Line
}CALIBRATE_TYPE;

#define MAX_RECT_NUM  6
typedef struct tagNET_DVR_RECT_LIST
{
    BYTE    byRectNum;     // Rectangle number
    BYTE    byRes1[11];   //Reserved
    NET_VCA_RECT struVcaRect[MAX_RECT_NUM];  // Maximum 6 rectangles 
}NET_DVR_RECT_LIST, *LPNET_DVR_RECT_LIST;

// PDC  Calibration
typedef struct tagNET_DVR_PDC_CALIBRATION
{
    NET_DVR_RECT_LIST struRectList;   //Calibrated rectangle list
    BYTE           byRes[120];        //Reserved 
}NET_DVR_PDC_CALIBRATION, *LPNET_DVR_PDC_CALIBRATION;


//Calibration line mode
typedef enum tagLINE_MODE
{
    HEIGHT_LINE,           //Height calibration
    LENGTH_LINE        //Length calibration
}LINE_MODE;
/*
For calibration setting, if the user also set 'enable' status, then they can set corresponding parameters,
otherwise the users can get relative parameters after calibration setting
*/
typedef struct tagNET_DVR_CAMERA_PARAM
{
    BYTE    byEnableHeight;    //Enable camera height line setting
    BYTE    byEnableAngle;     //Enable camera view angle setting
    BYTE    byEnableHorizon;   //Enable camera horizon setting
    BYTE    byRes[5];          //Reserved 
    float   fCameraHeight;     //Enable Camera height setting
    float   fCameraAngle;      //Enable Camera install angle setting
    float   fHorizon;          //enable setting of  video scene's horizon
}NET_DVR_CAMERA_PARAM, *LPNET_DVR_CAMERA_PARAM;
/*
 If the fValue stands for the target height, then struStartPoint and struEndPoint stands for the target upped point and bottom point
 If the fValue stands for the length of the line, then struStartPoint and struEndPoint stands for the start point and end point of the line
 mode stands for the line type (height or length)
 */
typedef struct tagNET_DVR_LINE_SEGMENT
{
    BYTE            byLineMode;      //plz refer to LINE_MODE
    BYTE            byRes[3];        //Reserved 
    NET_VCA_POINT   struStartPoint;
    NET_VCA_POINT   struEndPoint;
    float           fValue;
}NET_DVR_LINE_SEGMENT, *LPNET_DVR_LINE_SEGMENT;

#define  MAX_LINE_SEG_NUM 8

/*
Needs 4-8 calibration lines to get camera parameters
*/
typedef struct tagNET_DVR_BEHAVIOR_OUT_CALIBRATION
{
    DWORD                   dwLineSegNum;                          // Calibration line number
    NET_DVR_LINE_SEGMENT    struLineSegment[MAX_LINE_SEG_NUM];     // Max. calibration line number
    NET_DVR_CAMERA_PARAM    struCameraParam;                       // Camera parameters
    BYTE byRes[20];
}NET_DVR_BEHAVIOR_OUT_CALIBRATION, *LPNET_DVR_BEHAVIOR_OUT_CALIBRATION;

/*
Calibration sample
--including 1 target brim rectangle (standing target) and 1 corresponding height calibration line (from head to bottom)
*/
typedef struct tagNET_DVR_IN_CAL_SAMPLE
{
    NET_VCA_RECT struVcaRect;    // target brim rectangle
    NET_DVR_LINE_SEGMENT struLineSegment;     // Height calibration line
}NET_DVR_IN_CAL_SAMPLE, *LPNET_DVR_IN_CAL_SAMPLE;

#define  MAX_SAMPLE_NUM 5
#define  MAX_SAMPLE_NUM_EX 7

typedef struct tagNET_DVR_BEHAVIOR_IN_CALIBRATION
{
    DWORD    dwCalSampleNum;       //  Calibration sample number
    NET_DVR_IN_CAL_SAMPLE  struCalSample[MAX_SAMPLE_NUM];  // Max. calibration sample number
    NET_DVR_CAMERA_PARAM    struCameraParam;     // Camera parameters
    BYTE byRes[20];
}NET_DVR_BEHAVIOR_IN_CALIBRATION, *LPNET_DVR_BEHAVIOR_IN_CALIBRATION;

#define  CALIB_PT_NUM 4
typedef struct tagNET_DVR_ITS_CALIBRATION
{
    DWORD dwPointNum;  //Calibration number
    NET_VCA_POINT struPoint[CALIB_PT_NUM];  //Image coordinates
    float       fWidth;
    float       fHeight;
    BYTE        byRes1[100];         // Reserved
}NET_DVR_ITS_CALIBRATION, *LPNET_DVR_ITS_CALIBRATION;

typedef struct tagNET_DVR_BV_DIRECT_CALIBRATION
{
    DWORD  dwCameraHeight;   //Camera Height,unit:cm
    float  fPitchAngle;      //Camera Pitch Angle[0, 60],
    float  fInclineAngle;    //Camera Incline Angle[-20,20]
    BYTE   byRes1[228];
}NET_DVR_BV_DIRECT_CALIBRATION, *LPNET_DVR_BV_DIRECT_CALIBRATION;

// PDC Line
typedef struct  tagNET_DVR_PDC_LINE_CALIBRATION
{
    NET_VCA_LINE  struCalibrationLine;
    BYTE       byRes[232];
} NET_DVR_PDC_LINE_CALIBRATION, *LPNET_DVR_PDC_LINE_CALIBRATION;


// Calibration union
typedef union tagNET_DVR_CALIBRATION_PRARM_UNION
{
    BYTE byRes[240];                     //Union size
    NET_DVR_PDC_CALIBRATION struPDCCalibration;   //PDC calibration parameters
    NET_DVR_BEHAVIOR_OUT_CALIBRATION  struBehaviorOutCalibration;   //  Outdoor calibration for VCA (mainly for IVS)
    NET_DVR_BEHAVIOR_IN_CALIBRATION  struBehaviorInCalibration;      // Indoor calibration for VCA (mainly for IAS)
    NET_DVR_ITS_CALIBRATION struITSCalibration;
    NET_DVR_BV_DIRECT_CALIBRATION struBvDirectCalibration; // calibration
    NET_DVR_PDC_LINE_CALIBRATION struPDCLineCalibration; //PDC Line
}NET_DVR_CALIBRATION_PRARM_UNION, *LPNET_DVR_CALIBRATION_PRARM_UNION;


// Calibration configuration
typedef struct tagNET_DVR_CALIBRATION_CFG
{
    DWORD   dwSize;                // Calibration structure size
    BYTE    byEnable;              // Enable/disable calibration
    BYTE    byCalibrationType;     // Calibration type, please refer to CALIBRATE_TYPE
    BYTE    byRes1[2];
    NET_DVR_CALIBRATION_PRARM_UNION uCalibrateParam;   // Calibration type union
    BYTE    byRes2[12];
}NET_DVR_CALIBRATION_CFG, *LPNET_DVR_CALIBRATION_CFG;

//PDC direction structure
typedef struct  tagNET_DVR_PDC_ENTER_DIRECTION
{
    NET_VCA_POINT struStartPoint;   // Start point of the direction
    NET_VCA_POINT struEndPoint;     // End point of the direction 
}NET_DVR_PDC_ENTER_DIRECTION, *LPNET_DVR_PDC_ENTER_DIRECTION;

typedef struct tagNET_DVR_PDC_RULE_CFG
{
    DWORD           dwSize;               //Structure size
    BYTE            byEnable;             //Enable/disable the function; 
    BYTE            byRes1[23];           //Reserved 
    NET_VCA_POLYGON          struPolygon;              //Polygon
    NET_DVR_PDC_ENTER_DIRECTION  struEnterDirection;   //Enter direction
} NET_DVR_PDC_RULE_CFG, *LPNET_DVR_PDC_RULE_CFG;

typedef struct tagNET_DVR_PDC_RULE_CFG_V41
{
    DWORD           dwSize;
    BYTE            byEnable;             // enable;
    BYTE            byRes1[23];       //
    NET_VCA_POLYGON struPolygon;            //polygon
    NET_DVR_PDC_ENTER_DIRECTION  struEnterDirection;    // enter direction
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//alarm time
    NET_DVR_TIME_EX struDayStartTime; //day start time
    NET_DVR_TIME_EX struNightStartTime; //night start time
    BYTE            byRes[100];       // 
}NET_DVR_PDC_RULE_CFG_V41, *LPNET_DVR_PDC_RULE_CFG_V41;

/********* IPC5.1.7 Traffic statistical rules Begin 2014-03-21***********/
typedef struct tagNET_DVR_PDC_RULE_COND
{
    DWORD  dwSize;
    DWORD  dwChannel; //Channel No.
    DWORD dwID; //Scene ID, compatible with the ball machine scene concept, more compatible with the old version of the SDK configuration of new equipment, keep byte 0, so the byte 0, also for scenario 1 by default 
    BYTE  byRes[60];
}NET_DVR_PDC_RULE_COND, *LPNET_DVR_PDC_RULE_COND;

//Polygonal line structure 
typedef struct tagNET_VCA_POLYLINE
{
    NET_VCA_POINT struPoint[4];    //polygonal line
}NET_VCA_POLYLINE, *LPNET_VCA_POLYLINE;

typedef struct tagNET_DVR_PDC_RULE_CFG_V42
{
    DWORD  dwSize;
    BYTE   byEnable; //byEnable;
    BYTE   byOSDEnable;//Traffic statistics OSD display is enabled, 0 - no (0 - no), 1 - (0 to enter and leave), 2 -, 3 - to leave for the old equipment is not enabled OSD superposition corresponding (no), enable the corresponding (enter/leave) 4-pass people number, 5- enter and pass people. 
    BYTE   byCurDetectType;// current detection area type,0-Polygon,1-Detection line,2-Polygonal line detection
    BYTE   byInterferenceSuppression; //Interference suppression, bitwise said, 0 - this option is 1 - check, bit0 - shadow, bit1 - hovering, bit2 - cart 
    NET_VCA_POINT   struOSDPoint;//OSD Upper left corner
    BYTE   byDataUploadCycle;
    BYTE   bySECUploadEnable;
    BYTE   byEmailDayReport;
    BYTE   byEmailWeekReport;
    BYTE   byEmailMonthReport;
    BYTE   byEmailYearReport;
    BYTE   byRes2[6];
    NET_VCA_POLYGON          struPolygon; // Polygon
    NET_DVR_PDC_ENTER_DIRECTION  struEnterDirection; // Flow Enter Direction
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Alarm Time
    NET_DVR_TIME_EX struDayStartTime; //Day Start Time
    NET_DVR_TIME_EX struNightStartTime; //Night Start Time
    NET_DVR_HANDLEEXCEPTION_V40 struAlarmHandleType; /*Alarm Handle Type*/
    BYTE   byDetecteSensitivity;//Sensitivity:Range:1-100,Default:50
    BYTE   byGenerateSpeedSpace;//Generate Speed Space:Range:1-100,Default:50
    BYTE   byGenerateSpeedTime;// Generate Speed Time:Range:1-100,Default:50
    BYTE   byCountSpeed;// Count Speed:Range:1-100,Default:50
    BYTE   byDetecteType;// Detecte Type:0-Automatic ,1-head,2-head and shoulders,Default0-Automatic 
    BYTE   byTargetSizeCorrect;//Target Size Correction:Range:1-100,Default:50
    BYTE   byStreamOverlayRuleInfos;//Stream intelligence information overlay 0- no, 1- yes 
    BYTE   byRes3;
    NET_VCA_LINE  struLine;//Detection line
    BYTE byHeightFilterEnable;//High filtration is open, 1 to shut down, 2 to open it
    BYTE byDetectThreshold;//Detect Threshold
    BYTE byAidedTrackEnabled;//Aided Track Enabled
    BYTE byRes4;
    float fHeightFilter;//Filter height, unit: cm. Default value: 120 cm, range: 40-200 cm. ByHeightFilterEnable 1 is effective 
    BYTE byCalibrateType;//1 calibration type, 0 - without the need for automatic calibration, 2 - manual calibration 
    BYTE byCountingType;//Count trigger mode 0- no, 1- alarm input trigger, 2- video analysis trigger 
    BYTE bySignalType;//Signal type 0- level, 1- pulse 
    BYTE byRS485TransmissionEnabled;//Enable 485 transfer 0- off, 1- open 
    float fTiltAngle;//Pitching Angle, unit: degree; Pitching Angle default: 0; Pitching Angle range: 0-180 degrees
    float fHeelAngle;//Tilt Angle, the unit: degree; Default: 0 slope Angle; Angle range: - 90-90 degrees
    float fHeight;//Height, height unit: cm long; Range of height default value is 300 cm, height: 200-500 cm, setting up effective when byCalibrateType is 2 
    NET_VCA_POLYGON struCountPolygon;//Count area 
    NET_VCA_POLYGON struAutoCalibPolygon;//Calibration area, effective when byCalibrateType is 1 
    NET_DVR_TIME_EX struDailyResetTime; //Timing clear
    NET_VCA_POLYLINE struPolyLine;//Polygonal line detection area (configuration line, struLine do not display) 
    BYTE   byRes[4];
}NET_DVR_PDC_RULE_CFG_V42, *LPNET_DVR_PDC_RULE_CFG_V42;
/********* IPC5.1.7 Traffic statistical rules End 2014-03-21***********/

typedef struct tagNET_DVR_TRIAL_VERSION_CFG
{
    DWORD dwSize;
    WORD wReserveTime; //Reserve time,0xffff--invalid, uint:day
    BYTE byRes[62];
}NET_DVR_TRIAL_VERSION_CFG, *LPNET_DVR_TRIAL_VERSION_CFG;

typedef struct tagNET_DVR_SYN_CHANNEL_NAME_PARAM
{
    DWORD dwSize;
    DWORD dwChannel; //channel
    BYTE  byRes[64];
}NET_DVR_SYN_CHANNEL_NAME_PARAM, *LPNET_DVR_SYN_CHANNEL_NAME_PARAM;

typedef struct tagNET_DVR_RESET_COUNTER_CFG
{
    DWORD dwSize;
    BYTE  byEnable; //Enable,0-no,1-yes
    BYTE  byMode; //Mode,0-Timing, 1- manual
    BYTE  byRes1[2];
    NET_DVR_TIME_EX struTime[MAX_DAYS];//Reset counter time
    BYTE  byRes[64];
}NET_DVR_RESET_COUNTER_CFG, *LPNET_DVR_RESET_COUNTER_CFG;

typedef struct tagNET_DVR_VCA_CTRLINFO_COND
{
    DWORD dwSize;
    NET_DVR_STREAM_INFO  struStreamInfo;
    BYTE byRes[64];
}NET_DVR_VCA_CTRLINFO_COND, *LPNET_DVR_VCA_CTRLINFO_COND;

#define NET_SDK_MAX_RELATED_CHAN_NUM  4 //Maximum related channel number 

typedef struct tagNET_DVR_VCA_CTRLINFO_CFG
{
    DWORD  dwSize;
    BYTE   byVCAEnable;        //vca enable
    BYTE   byVCAType;        //vca type,VCA_CHAN_ABILITY_TYPE 
    BYTE   byStreamWithVCA; //stream with vca
    BYTE   byMode;            //mode,VCA_CHAN_MODE_TYPE for ATM analysis,TFS_CHAN_MODE_TYPE for TFS analysis,BEHAVIOR_SCENE_MODE_TYPE for behavior full analysis
    BYTE   byControlType;   //contril type,bit,0-no,1-yes
    // byControlType &1 enable snap 
    // byControlType &2 enable related ipc
    BYTE   byRes1[3];
    WORD   wRelatedChannel[NET_SDK_MAX_RELATED_CHAN_NUM/*4*/];     /*related channel, 0-Not related*/
    BYTE   byRes[72];         //
}NET_DVR_VCA_CTRLINFO_CFG, *LPNET_DVR_VCA_CTRLINFO_CFG;

//Set PDC statistic parameters 
// HUMAN_GENERATE_RATE
// Speed for target generating. This parameter controls the time interval from target appear in the image to analysis starts. For video scene with various interference signals, please set a lower speed to avoid false alarm;  and for video scene with high speed objects, please set a higher speed to avoid event missing. Totally 5 levels, ranges from 1 (lowest speed)~ 5 (highest speed), and the default value is 3
// 
// DETECT_SENSITIVE
//Object detection sensitivity level , ranges from 1(lowest) to 5 (highest) , default level: 3

typedef enum tagPDC_PARAM_KEY
{
    HUMAN_GENERATE_RATE = 50,                //Target  generating speed, start from 50
    DETECT_SENSITIVE = 51,                //Detecting sensitivity
}PDC_PARAM_KEY;


typedef struct tagNET_DVR_PDC_TARGET_INFO
{
    DWORD       dwTargetID;                  //Target ID
    NET_VCA_RECT struTargetRect;             //Target brim
    BYTE      byRes1[8];                     //Reserved
}NET_DVR_PDC_TARGET_INFO, *LPNET_DVR_PDC_TARGET_INFO;

typedef struct tagNET_DVR_PDC_TARGET_IN_FRAME
{
    BYTE           byTargetNum;                    //Target number
    BYTE            byRes1[3];
    NET_DVR_PDC_TARGET_INFO  struTargetInfo[MAX_TARGET_NUM];    //Target info array
    BYTE    byRes2[8];                   // Reserved
}NET_DVR_PDC_TARGET_IN_FRAME, *LPNET_DVR_PDC_TARGET_IN_FRAME;

typedef struct tagNET_DVR_PDC_ALRAM_INFO
{
    DWORD                       dwSize;             // PDC alarm upload structure size
    BYTE                        byMode;             // 0 - single frame statistic result;  1- statistic result in min. time period  2 The signal trigger (results exist in "Statistics starting time" & & "statistical end time") 
    BYTE                        byChannel;          // Alarm upload channel
    /********* IPC5.1.7 New Begin 2014-03-21***********/
    BYTE                        bySmart;         //0-Intelligence,1-Smart 
    BYTE                        byRes1;
    /********* IPC5.1.7 New End 2014-03-21***********/
    NET_VCA_DEV_INFO       struDevInfo;                 // PU device info
    union
    {
        struct   // For single frame statistic result
        {
            DWORD   dwRelativeTime;      // Relative time stamp
            DWORD   dwAbsTime;           // Absolute time stamp
            BYTE    byTimeDiffFlag;      /*Time difference is valid or not 0-invalid 1-valid */
            char    cTimeDifferenceH;         /*Time difference(HOUR) from UTC */
            char    cTimeDifferenceM;      	/*Time difference(MINUTE) from UTC*/
            BYTE    byRes[89];             
        }struStatFrame;
        struct
        {
            NET_DVR_TIME                      tmStart; // Statistic start time 
            NET_DVR_TIME                      tmEnd;   //  Statistic end time
            BYTE	        byTimeDifferenceFlag;   /*Time difference is valid or not 0-invalid 1-valid*/
            char            cStartTimeDifferenceH;      /*Start time difference(HOUR) from UTC*/
            char            cStartTimeDifferenceM;      /*Start time difference(MINUTE) from UTC*/
            char            cStopTimeDifferenceH;        /*Stop time difference(HOUR) from UTC*/
            char            cStopTimeDifferenceM;       /*Stop time difference(MINUTE) from UTC*/
            BYTE            byRes[87]; 
        }struStatTime;
    }uStatModeParam;
    DWORD                       dwLeaveNum;         // Number of left
    DWORD                       dwEnterNum;         // Number of entered
    BYTE                        byBrokenNetHttp;     //Offline continuingly flags, 0 - not the retransmission data, 1 - retransmission data 
    BYTE                        byRes3;
    WORD                        wDevInfoIvmsChannelEx;     //NET_VCA_DEV_INFO->byIvmsChannel
    DWORD                       dwPassingNum;        // After the number (after wandering into the area did not trigger the number of people entering and leaving) 
    BYTE                        byRes2[32];           // Reserved
}NET_DVR_PDC_ALRAM_INFO, *LPNET_DVR_PDC_ALRAM_INFO;


//  PDC Info Query
typedef struct tagNET_DVR_PDC_QUERY
{
    NET_DVR_TIME tmStart;
    NET_DVR_TIME tmEnd;
    DWORD        dwLeaveNum;
    DWORD        dwEnterNum;
    BYTE         byRes1[256];
}NET_DVR_PDC_QUERY, *LPNET_DVR_PDC_QUERY;


typedef struct tagNET_DVR_POSITION_RULE_CFG
{
    DWORD                   dwSize;              // Structure size
    NET_DVR_PTZ_POSITION    struPtzPosition;     // Video scene position info
    NET_VCA_RULECFG         struVcaRuleCfg;      //Video 
    BYTE                    byRes2[80];          // Reserved
}NET_DVR_POSITION_RULE_CFG, *LPNET_DVR_POSITION_RULE_CFG;

typedef struct tagNET_DVR_POSITION_RULE_CFG_V41
{
    DWORD                   dwSize;             // Structure size 
    NET_DVR_PTZ_POSITION    struPtzPosition;    // Video scene position info
    NET_VCA_RULECFG_V41         struVcaRuleCfg;     //Video
    BYTE  byTrackEnable; //Enable track
    BYTE  byRes1;
    WORD wTrackDuration; //Track duration(s)
    BYTE                    byRes2[76];         // 
}NET_DVR_POSITION_RULE_CFG_V41, *LPNET_DVR_POSITION_RULE_CFG_V41;

typedef struct tagNET_DVR_LIMIT_ANGLE
{
    BYTE                byEnable;      // Enable video scene position limitation
    BYTE                byRes1[3];
    NET_DVR_PTZPOS      struUp;      // upper limit position
    NET_DVR_PTZPOS      struDown;    // bottom limit position 
    NET_DVR_PTZPOS      struLeft;    // left limit position
    NET_DVR_PTZPOS      struRight;   // right limit position
    BYTE                byRes2[20];
}NET_DVR_LIMIT_ANGLE, *LPNET_DVR_LIMIT_ANGLE;

typedef struct tagNET_DVR_POSITION_INDEX
{
    BYTE    byIndex;    //video scene index
    BYTE    byRes1;
    WORD    wDwell;     // dwell time
    BYTE    byRes2[4];  // Reserved
}NET_DVR_POSITION_INDEX, *LPNET_DVR_POSITION_INDEX;

#define  MAX_POSITION_NUM 10
typedef struct tagNET_DVR_POSITION_TRACK_CFG
{
    DWORD   dwSize;
    BYTE    byNum;  // video scene number
    BYTE    byRes1[3];
    NET_DVR_POSITION_INDEX   struPositionIndex[MAX_POSITION_NUM];
    BYTE    byRes2[8];
}NET_DVR_POSITION_TRACK_CFG, *LPNET_DVR_POSITION_TRACK_CFG;

//Patrol path scene info
typedef struct tagNET_DVR_PATROL_SCENE_INFO
{
    WORD   wDwell;          // Dwell time [30- 300]
    BYTE   byPositionID;    // Scene number 1- 10, Default: 0 (do not add to patrol scene)
    BYTE   byRes[5];
}NET_DVR_PATROL_SCENE_INFO, *LPNET_DVR_PATROL_SCENE_INFO;

// Patrol scene tracking info
typedef struct tagNET_DVR_PATROL_TRACKCFG
{
    DWORD  dwSize;                                  // Structure size
    NET_DVR_PATROL_SCENE_INFO struPatrolSceneInfo[10];     // patrol path
    BYTE   byRes[16];                               // Reserved
}NET_DVR_PATROL_TRACKCFG, *LPNET_DVR_PATROL_TRACKCFG;

//Speed dome local rule configuration via menu
typedef struct tagNET_DVR_TRACK_PARAMCFG
{
    DWORD   dwSize;             // Structure size
    WORD    wAlarmDelayTime;    // Alarm delay time (speed dome only supports global intrusion detection mode) range:1-120s
    WORD    wTrackHoldTime;     // Alarm tracking holding time range 0-300s
    BYTE    byTrackMode;        //  Plz refer to IPDOME_TRACK_MODE
    BYTE    byPreDirection;     // Pre judge of tracking direction 0-disable 1-enable
    BYTE     byTrackSmooth;         //Smooth tracking 0-disable 1-enable    
    BYTE    byZoomAdjust;         // Zoom adjustment
    BYTE    byMaxTrackZoom;     // Max. zoom ratio 0-default zoom ratio,1-15
    BYTE    byStopTrackWhenFindFace;  //stop track when find face 0-no 1-yes
    BYTE    byStopTrackThreshold;   //the value for stop track
    BYTE    byRes[9];               //  Reserved                
}NET_DVR_TRACK_PARAMCFG, *LPNET_DVR_TRACK_PARAMCFG;

typedef struct tagNET_DVR_DOME_MOVEMENT_PARAM
{
    WORD wMaxZoom;    // Max. zoom ratio
    BYTE    byRes[42];   // Reserved
}NET_DVR_DOME_MOVEMENT_PARAM, *LPNET_DVR_DOME_MOVEMENT_PARAM;


/********************************Intelligent traffic event  begin****************************************/
#define  MAX_REGION_NUM            8       // Max. region list number
#define  MAX_TPS_RULE            8       // Max. rule number
#define  MAX_AID_RULE            8       // Max. event rule number
#define  MAX_LANE_NUM            8        // Max. traffic lane number

//Traffic event type
typedef enum tagTRAFFIC_AID_TYPE
{
    CONGESTION = 0x01,     //Traffic jam
    PARKING = 0x02,     //Parking
    INVERSE = 0x04,     //Inverse travel
    PEDESTRIAN = 0x08,     //Pedestrian                      
    DEBRIS = 0x10,     //Debris 
    SMOKE = 0x20,     //Smoke
    OVERLINE = 0x40,      //Over line
    VEHICLE_CONTROL_LIST = 0x80,    //black list
    SPEED = 0x100,    //over speed
    LANECHANGE = 0x200,      //lane change
    TURNAROUND = 0x400,     //turn around
    VEHICLE_OCCUPANCY_NONVEHICLE = 0x800, //Occupy the non motorized vehicle parking spaces
    GASSER = 0x1000,    //gasser
    ROADBLOCK = 0x2000,   //roadblock
    CONSTRUCTION = 0x4000,    //construction
    TRAFFIC_ACCIDENT = 0x8000,    //traffic accident
    PARALLEL_PARKING = 0x10000,    //parallel parking
    FOG_DETECTION = 0x20000,       // fog detection
    OCCUPY_EMERGENCY_LANE = 0x40000, //occupy emergency lane
    CONFLAGRATION = 0X80000,     //conflagration
}TRAFFIC_AID_TYPE;

typedef enum tagTRAFFIC_SCENE_MODE
{
    FREEWAY = 0,    //  High-speed outdoor scene
    TUNNEL,         //  High-speed tunnel scene 
    BRIDGE          //  High-speed bridge scene
}TRAFFIC_SCENE_MODE;

typedef enum tagITS_ABILITY_TYPE
{
    ITS_CONGESTION_ABILITY = 0x01,       //Traffic jam
    ITS_PARKING_ABILITY = 0x02,       //Parking 
    ITS_INVERSE_ABILITY = 0x04,       //Inverse travel
    ITS_PEDESTRIAN_ABILITY = 0x08,       //Pedestrian                      
    ITS_DEBRIS_ABILITY = 0x10,       //Debris
    ITS_SMOKE_ABILITY = 0x20,       //Smoke - tunnel
    ITS_OVERLINE_ABILITY = 0x40,       //Over line
    ITS_VEHICLE_CONTROL_LIST_ABILITY = 0x80,        //black list
    ITS_SPEED_ABILITY = 0x100,        //over speed    
    ITS_LANECHANGE_ABILITY = 0x200,     //lane change
    ITS_TURNAROUND_ABILITY = 0x400,      //turn around
    ITS_LANE_VOLUME_ABILITY = 0x010000,   //Flow  counting of traffic lane
    ITS_LANE_VELOCITY_ABILITY = 0x020000,   //Vehicle velocity of traffic lane
    ITS_TIME_HEADWAY_ABILITY = 0x040000,   //Vehicle headway counting (unit: time)
    ITS_SPACE_HEADWAY_ABILITY = 0x080000,   //Vehicle headway counting (unit: distance) 
    ITS_TIME_OCCUPANCY_RATIO_ABILITY = 0x100000,   //Traffic lane occupancy (unit: time)
    ITS_SPACE_OCCUPANCY_RATIO_ABILITY = 0x200000,   //Traffic lane occupancy (unit: distance) 
    ITS_LANE_QUEUE_ABILITY = 0x400000,   //Queue length
    ITS_VEHICLE_TYPE_ABILITY = 0x800000,   //Vehicle type
    ITS_TRAFFIC_STATE_ABILITY = 0x1000000   //Traffic state
}ITS_ABILITY_TYPE;

// Traffic statistics
typedef enum tagITS_TPS_TYPE
{
    LANE_VOLUME = 0x01,     //Traffic lane flow
    LANE_VELOCITY = 0x02,     //Vehicle velocity
    TIME_HEADWAY = 0x04,     //Vehicle headway counting (unit: time)
    SPACE_HEADWAY = 0x08,     //Vehicle headway counting (unit: distance) 
    TIME_OCCUPANCY_RATIO = 0x10,     //Traffic lane occupancy (unit: time)
    SPACE_OCCUPANCY_RATIO = 0x20,     //Traffic lane occupancy (unit: distance)  
    QUEUE = 0x40,     //Queue length
    VEHICLE_TYPE = 0x80,     //vehicle type
    TRAFFIC_STATE = 0x100     //traffic state
}ITS_TPS_TYPE;

typedef struct tagNET_DVR_REGION_LIST
{
    DWORD    dwSize;     // Structure size
    BYTE    byNum;       // Region number
    BYTE    byRes1[3];     // Reserved
    NET_VCA_POLYGON struPolygon[MAX_REGION_NUM];  // Region
    BYTE    byRes2[20];     // Reserved
}NET_DVR_REGION_LIST, *LPNET_DVR_REGION_LIST;


// Direction structure
typedef struct tagNET_DVR_DIRECTION
{
    NET_VCA_POINT struStartPoint;    // Direction start point
    NET_VCA_POINT struEndPoint;      // Direction end point
}NET_DVR_DIRECTION, *LPNET_DVR_DIRECTION;

// Single traffic lane
typedef struct tagNET_DVR_ONE_LANE
{
    BYTE    byEnable;  // Enable traffic lane
    BYTE    byRes1[11];     // Reserved
    BYTE    byLaneName[NAME_LEN];        // Traffic lane name
    NET_DVR_DIRECTION struFlowDirection;     // Flow direction of the traffic lane
    NET_VCA_POLYGON struPolygon;         // Traffic lane region
}NET_DVR_ONE_LANE, *LPNET_DVR_ONE_LANE;

// Traffic lane configuration
typedef struct tagNET_DVR_LANE_CFG
{
    DWORD    dwSize;     // Structure size
    NET_DVR_ONE_LANE struLane[MAX_LANE_NUM];     // Traffic lane parameter, and the  subscript is corresponding to the traffic lane ID 
    BYTE    byRes1[40];      // Reserved
}NET_DVR_LANE_CFG, *LPNET_DVR_LANE_CFG;

// Traffic event parameters
typedef struct tagNET_DVR_AID_PARAM
{
    WORD    wParkingDuration;        // Parking time [10s- 120s]
    WORD    wPedestrianDuration;     // Pedestrian time [1s- 120s]
    WORD    wDebrisDuration;         // Debris time [10s- 120s]
    WORD    wCongestionLength;       // Traffic jam distance threshold [5m- 200m] 
    WORD    wCongestionDuration;     // Traffic jam time length [10s- 120s]
    WORD    wInverseDuration;        // Inverse travel time [1s- 10s]
    WORD    wInverseDistance;        // Inverse travel distance [2m- 100m] (default: 10m)
    WORD    wInverseAngleTolerance;  // Inverse angle tolerance [90- 180] degree
    WORD    wIllegalParkingTime;     // Illegal parking time[4min,60min],take effect in mode TFS_CITYROAD
    WORD    wIllegalParkingPicNum;   // Illegal parking snap pic num[1,6], take effect in mode TFS_CITYROAD
    BYTE    byMergePic;              // Merge snap pics ,0- disable 1- enable ,take effect in mode TFS_CITYROAD
    BYTE    byRes1[23];              // reserved
}NET_DVR_AID_PARAM, *LPNET_DVR_AID_PARAM;

// Traffic rule structure
typedef struct tagNET_DVR_ONE_AID_RULE
{
    BYTE    byEnable;                    //enable/disable event rules
    BYTE    byRes1[3];                   //Reserved
    BYTE    byRuleName[NAME_LEN];        //Rule name 
    DWORD   dwEventType;                 //Traffic event detection type TRAFFIC_AID_TYPE
    NET_VCA_SIZE_FILTER struSizeFilter;  //Size filter
    NET_VCA_POLYGON     struPolygon;     //Rule region
    NET_DVR_AID_PARAM struAIDParam;      //Event parameters
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2]; //Arm schedule
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;     // Handle method
    BYTE byRelRecordChan[MAX_CHANNUM_V30];             //Recording channel triggered by alarm, 1-trigger recording on this channel
    BYTE    byRes2[20];
}NET_DVR_ONE_AID_RULE, *LPNET_DVR_ONE_AID_RULE;

// Traffic events
typedef struct tagNET_DVR_AID_RULECFG
{
    DWORD   dwSize;         // Structure size 
    BYTE    byPicProType;     //0- do not upload snapshot on alarm;  1- upload snapshot on alarm
    BYTE    byRes1[3];      // Reserved
    NET_DVR_JPEGPARA struPictureParam;          //Snapshot parameter structure
    NET_DVR_ONE_AID_RULE  struOneAIDRule[MAX_AID_RULE];  //Rule array
    BYTE    byRes2[32];     //Reserved
}NET_DVR_AID_RULECFG, *LPNET_DVR_AID_RULECFG;

typedef struct tagNET_DVR_ONE_AID_RULE_V41
{
    BYTE                        byEnable;                 // 0 - disable, 1 - enable
    BYTE                        byLaneNo;                 // Relate Lane No
    BYTE                        byRes1[2];                // Reserved
    BYTE                        byRuleName[NAME_LEN];     // Rule name
    DWORD                       dwEventType;              // Traffic event detection type TRAFFIC_AID_TYPE
    NET_VCA_SIZE_FILTER         struSizeFilter;           // Size filter
    NET_VCA_POLYGON             struPolygon;              // Rule region
    NET_DVR_AID_PARAM           struAIDParam;             // Event parameters
    NET_DVR_SCHEDTIME           struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Arm schedule
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;              //Handle method
    BYTE                        byRelRecordChan[MAX_IVMS_IP_CHANNEL]; //Recording channel triggered by alarm, 1-trigger recording on this channel
    BYTE                        byRes2[60];               //Reserved
}NET_DVR_ONE_AID_RULE_V41, *LPNET_DVR_ONE_AID_RULE_V41;

typedef struct tagNET_DVR_AID_RULECFG_V41
{
    DWORD   dwSize;                     // Structure size 
    BYTE    byPicProType;               // 0- do not upload snapshot on alarm;  1- upload snapshot on alarm
    BYTE    byRes1[3];                  // Reserved
    NET_DVR_JPEGPARA struPictureParam;     // Snapshot parameter structure
    NET_DVR_ONE_AID_RULE_V41  struAIDRule[MAX_AID_RULE];  //Rule array
    BYTE    byRes2[128];                //Reserved
} NET_DVR_AID_RULECFG_V41, *LPNET_DVR_AID_RULECFG_V41;

// Traffic statistics structure
typedef struct tagNET_DVR_ONE_TPS_RULE
{
    BYTE    byEnable;        // Enable traffic rule parameters
    BYTE    byLaneID;           // Traffic lane ID
    BYTE    byRes1[2];       //Reserved
    DWORD   dwCalcType;      // Statistics type ITS_TPS_TYPE
    NET_VCA_SIZE_FILTER struSizeFilter;  // Size filter
    NET_VCA_POLYGON struVitrualLoop;     // Virtual coil
    NET_DVR_SCHEDTIME struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2]; //Arm schedule
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;     //Handle mode (upload to center)
    BYTE    byRes2[20];   // Reserved
}NET_DVR_ONE_TPS_RULE, *LPNET_DVR_ONE_TPS_RULE;

// Traffic statistics rule configuration structure
typedef struct tagNET_DVR_TPS_RULECFG
{
    DWORD   dwSize;               // Structure size
    NET_DVR_ONE_TPS_RULE struOneTpsRule[MAX_TPS_RULE];  // The subscript is corresponding to the traffic parameter's ID
    BYTE    byRes2[40];      // Reserved
}NET_DVR_TPS_RULECFG, *LPNET_DVR_TPS_RULECFG;

typedef struct tagNET_DVR_ONE_TPS_RULE_V41
{
    BYTE    byEnable;                     //0 - disable,1 - enable
    BYTE    byLaneID;                      //Lane id
    BYTE    byRes1[2];                    //Reserved
    DWORD   dwCalcType;                   //Statistics type ITS_TPS_TYPE
    NET_VCA_SIZE_FILTER  struSizeFilter;  //Size filter
    NET_VCA_POLYGON      struVitrualLoop; //Virtual coil
    NET_DVR_SCHEDTIME    struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Arm schedule
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;       //Handle mode
    BYTE    byRes2[60];                   // Reserved
}NET_DVR_ONE_TPS_RULE_V41, *LPNET_DVR_ONE_TPS_RULE_V41;

typedef struct tagNET_DVR_TPS_RULECFG_V41
{
    DWORD   dwSize;         //Structure size
    NET_DVR_ONE_TPS_RULE_V41 struOneTpsRule[MAX_TPS_RULE]; //The subscript is corresponding to the traffic parameter's ID
    BYTE    byRes[128];     //Reserved
}NET_DVR_TPS_RULECFG_V41, *LPNET_DVR_TPS_RULECFG_V41;

// Traffic event info
typedef struct tagNET_DVR_AID_INFO
{
    BYTE            byRuleID;    // Rule ID, which is equal to the subscript of the rule configuration structure ([0- 16])
    BYTE            byRes1[3];
    BYTE            byRuleName[NAME_LEN];  //  Rule ID
    DWORD           dwAIDType;   // Alarm event type
    NET_DVR_DIRECTION   struDirect;  // ALarm region  
    BYTE    bySpeedLimit; //Limit speed,km/h[0,255]
    BYTE    byCurrentSpeed; //current speed,km/h[0,255]
    BYTE    byVehicleEnterState;//vehicle state  0-invalid  1-in 2-out 
    BYTE            byState; //0-change,1-loop
    BYTE            byParkingID[16]; //parking id
    BYTE            byRes2[20];
}NET_DVR_AID_INFO, *LPNET_DVR_AID_INFO;

// Traffic event alarm
typedef struct tagNET_DVR_AID_ALARM
{
    DWORD               dwSize;          // Structure length
    DWORD               dwRelativeTime;     // Relative time stamp
    DWORD               dwAbsTime;         // Absolute time stamp
    NET_VCA_DEV_INFO      struDevInfo;     // PU info
    NET_DVR_AID_INFO    struAIDInfo;     // Traffic event info
    DWORD               dwPicDataLen;    // Return snapshot picture length, 0- no snapshot;  else- snapshot data length
    BYTE                *pImage;         // pointer to the snapshot picture data
    BYTE                byRes[40];       // Reserved  
}NET_DVR_AID_ALARM, *LPNET_DVR_AID_ALARM;

// Queue structure of the Traffic Line
typedef struct tagNET_DVR_LANE_QUEUE
{
    NET_VCA_POINT   struHead;        //Head of the queue
    NET_VCA_POINT   struTail;        //End of the queue
    DWORD           dwLength;         //Actual queue length
}NET_DVR_LANE_QUEUE, *LPNET_DVR_LANE_QUEUE;


typedef struct tagNET_DVR_LANE_PARAM
{
    BYTE    byRuleName[NAME_LEN];                  //Traffic lane rule name
    BYTE    byRuleID;                // Rule ID, which is equal to the subscript of the rule configuration structure ([0- 7]) 
    BYTE    byVaryType;       //Vehicle status for virtual coil, 1-vehicle passing, 0-no vehicle passing 
    BYTE    byLaneType;             // Traffic lane type
    BYTE    byRes1;
    DWORD    dwLaneVolume;     // Traffic flow
    DWORD   dwLaneVelocity;       //velocity on this traffic lane (km/h)
    DWORD   dwTimeHeadway;       //Vehicle headway counting (unit: time)
    DWORD   dwSpaceHeadway;        //Vehicle headway counting (unit: m)
    float   fSpaceOccupyRation;  //Occupation 
    NET_DVR_LANE_QUEUE  struLaneQueue;          //Queue length of the traffic lane
    NET_VCA_POINT       struRuleLocation;      //Center position of the coil rule
    BYTE    byRes2[32];
}NET_DVR_LANE_PARAM, *LPNET_DVR_LANE_PARAM;


typedef struct tagNET_DVR_TPS_INFO
{
    DWORD   dwLanNum;    // Traffic lane number for the rule
    NET_DVR_LANE_PARAM  struLaneParam[MAX_TPS_RULE];
}NET_DVR_TPS_INFO, *LPNET_DVR_TPS_INFO;

typedef struct tagNET_DVR_TPS_ALARM
{
    DWORD       dwSize;               // Structure size
    DWORD       dwRelativeTime;       // relative time stamp
    DWORD       dwAbsTime;            // Absolute time stamp
    NET_VCA_DEV_INFO      struDevInfo;  // PU device info
    NET_DVR_TPS_INFO  struTPSInfo;    // Traffic event info
    BYTE        byRes1[32];           // Reserved
}NET_DVR_TPS_ALARM, *LPNET_DVR_TPS_ALARM;

typedef enum tagTRAFFIC_DATA_VARY_TYPE_EX_ENUM
{
    ENUM_TRAFFIC_VARY_NO = 0x00,   //No vary
    ENUM_TRAFFIC_VARY_VEHICLE_ENTER = 0x01,   //Vehicle enter the virtual loop
    ENUM_TRAFFIC_VARY_VEHICLE_LEAVE = 0x02,   //Vehicle leave the vitual loop
    ENUM_TRAFFIC_VARY_QUEUE = 0x04,   //Queue vary
    ENUM_TRAFFIC_VARY_STATISTIC = 0x08,   //Statistics vary
}TRAFFIC_DATA_VARY_TYPE_EX_ENUM;

typedef struct tagNET_DVR_LANE_PARAM_V41
{
    BYTE               byRuleName[NAME_LEN]; //Traffic lane rule name
    BYTE               byRuleID;             //Rule ID, which is equal to the subscript of the rule configuration structure ([0- 7])  
    BYTE               byLaneType;             //Lane type,up or down
    BYTE               byTrafficState;       //Traffic state,0-Invalid,1-Smooth,2-Crowd,3-Blocked
    BYTE               byLaneNo;            //Relate Lane No
    DWORD              dwVaryType;           //Data vary type,refer to TRAFFIC_DATA_VARY_TYPE_EX_ENUM
    DWORD              dwTpsType;            //Tell which member of this structure is used,refer to ITS_TPS_TYPE
    DWORD              dwLaneVolume;         //Traffic flow
    DWORD              dwLaneVelocity;       //Velocity on this traffic lane (km/h)
    DWORD              dwTimeHeadway;       //Vehicle headway counting (unit: time)
    DWORD              dwSpaceHeadway;       //Vehicle headway counting (unit: m)
    float              fSpaceOccupyRation;   //Space Occupation
    float              fTimeOccupyRation;    //Time Occupation 
    DWORD              dwLightVehicle;       //Number of light vehicle
    DWORD              dwMidVehicle;         //Number of mid vehicle
    DWORD              dwHeavyVehicle;       //Number of heavy vehicle
    NET_DVR_LANE_QUEUE struLaneQueue;        //Queue length of the traffic lane
    NET_VCA_POINT      struRuleLocation;     //Center position of the coil rule
    DWORD               dwOversizeVehicle;    //Number of Oversize vehicle
    BYTE               byRes2[60];           //Reserved
}NET_DVR_LANE_PARAM_V41, *LPNET_DVR_LANE_PARAM_V41;


typedef struct tagNET_DVR_TPS_INFO_V41
{
    DWORD                   dwLanNum;          //Traffic lane number for the rule
    NET_DVR_LANE_PARAM_V41  struLaneParam[MAX_TPS_RULE]; //Lane param array
    DWORD                   dwSceneID;//scene ID
    BYTE                    byRes[28];         //Reserved
}NET_DVR_TPS_INFO_V41, *LPNET_DVR_TPS_INFO_V41;

// Face rule configuration 
typedef struct tagNET_DVR_FACEDETECT_RULECFG
{
    DWORD          dwSize;              //Structure size
    BYTE           byEnable;            //Enable or not
    BYTE           byEventType;            //Event type: 0- abnormal face, 1- normal face, 2- abnormal face and normal face, 4- More than one face & abnormal face; 5- More than one face & normal face; 6- More than one face & abnormal face & normal face;7- More than one face
    BYTE           byUpLastAlarm;       //2011-04-06 Whether upload last alarm firstly
    BYTE           byUpFacePic; //Enable upload face picture,0-no, 1-yes
    BYTE           byRuleName[NAME_LEN];
    NET_VCA_POLYGON     struVcaPolygon; //Face detection rule region
    BYTE           byPicProType;        //Picture handling mode when alarming: 0- not handle, none 0- upload
    BYTE           bySensitivity;       //Rule sensitivity
    WORD            wDuration;          //Time threshold to trigger face alarm
    NET_DVR_JPEGPARA    struPictureParam;         //Picture parameter
    NET_VCA_SIZE_FILTER struSizeFilter;         //Size filter
    NET_DVR_SCHEDTIME   struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_2];//Time parameter of fortification 
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;      //Handling mode 
    BYTE           byRelRecordChan[MAX_CHANNUM_V30];//Whether alarm triggers recording channel:1-trigger;0-not trigger 
    BYTE          byPicRecordEnable;  /*2012-3-1 Whether record picture, 0-no, 1-yes*/
    BYTE           byRes1[3];         //Reserved
    /*
    Alert event types:
    0x00: invalid
    0x01: abnormal human face
    0x02: normal human face
    0x04: more than one face
    0x08: sunglasses face
    0x10: calling face
    */
    DWORD          dwEventTypeEx; //dwEventTypeEx fields for 0, byEventType field effect.If dwEventTypeEx, byEventType fields have values, will be subject to dwEventTypeEx field.After the upper configuration dwEventTypeEx field, will value synchronization to byEventType.
    BYTE            byRes2[32];         //Reserved
}NET_DVR_FACEDETECT_RULECFG, *LPNET_DVR_FACEDETECT_RULECFG;

typedef struct tagNET_DVR_FACE_PIPCFG
{
    BYTE byEnable; //enable PIP
    BYTE byBackChannel; //Back channel(panel channel)
    BYTE byPosition; //position,0-left top,1-left bottom,2-right top,3-right bottom
    BYTE byPIPDiv; //Division (face:panel),0-1:4,1-1:9,2-1:16
    BYTE byRes[4];
}NET_DVR_FACE_PIPCFG, *LPNET_DVR_FACE_PIPCFG;

typedef struct tagNET_DVR_FACEDETECT_RULECFG_V41
{
    DWORD dwSize;              //Structure size
    BYTE  byEnable;            //Enable or not
    BYTE  byEventType;            //Event type: 0- abnormal face, 1- normal face, 2- abnormal face and normal face, 4- More than one face & abnormal face; 5- More than one face & normal face; 6- More than one face & abnormal face & normal face;7- More than one face
    BYTE  byUpLastAlarm;       //2011-04-06 Whether upload last alarm firstly
    BYTE  byUpFacePic; //Enable upload face picture,0-no, 1-yes    
    BYTE  byRuleName[NAME_LEN];
    NET_VCA_POLYGON struVcaPolygon;    //Face detection rule region
    BYTE  byPicProType;    //Picture handling mode when alarming: 0- not handle, none 0- upload
    BYTE  bySensitivity;   //Rule sensitivity
    WORD  wDuration;      //Time threshold to trigger face alarm
    NET_DVR_JPEGPARA    struPictureParam;         //Picture parameter
    NET_VCA_SIZE_FILTER struSizeFilter;         //Size filter
    NET_DVR_SCHEDTIME   struAlarmTime[MAX_DAYS][MAX_TIMESEGMENT_V30];//Time parameter of fortification
    NET_DVR_HANDLEEXCEPTION_V30 struHandleType;      //Handling mode 
    BYTE  byRelRecordChan[MAX_CHANNUM_V30];            //Whether alarm triggers recording channel:1-trigger;0-not trigger
    BYTE  byPicRecordEnable;  /*2012-10-22Whether record picture, 0-no, 1-yes*/
    BYTE  byRes1;
    WORD  wAlarmDelay; //2012-10-22 Alarm delay,0-5s,1-10,2-30s,3-60s,4-120s,5-300s,6-600s
    NET_DVR_FACE_PIPCFG struFacePIP; //2012-11-7 Face PIP
    WORD  wRelSnapChan[MAX_REL_SNAPCHAN_NUM]; /*Relate snap channel,when the main channel alarms,together upload the relate channel picture
                                               0-unused,other- channel number*/
    BYTE  byRes2[2];         //Reserved
    /*
    Alert event types:
    0x00: invalid
    0x01: abnormal human face
    0x02: normal human face
    0x04: more than one face
    0x08: sunglasses face
    0x10: calling face
    */
    DWORD dwEventTypeEx; //dwEventTypeEx fields for 0, byEventType field effect.If dwEventTypeEx, byEventType fields have values, will be subject to dwEventTypeEx field.After the upper configuration dwEventTypeEx field, will value synchronization to byEventType.
    BYTE  byRes[16];         //Reserved
}NET_DVR_FACEDETECT_RULECFG_V41, *LPNET_DVR_FACEDETECT_RULECFG_V41;

typedef struct tagNET_DVR_FACEDETECT_ALARM
{
    DWORD  dwSize;                 // Structure size
    DWORD     dwRelativeTime;     // Relative time
    DWORD    dwAbsTime;            // Absolute time
    BYTE        byRuleName[NAME_LEN];       //Rule name
    NET_VCA_TARGET_INFO  struTargetInfo;    //Alarm target information
    NET_VCA_DEV_INFO       struDevInfo;        //Device information
    DWORD dwPicDataLen;                        //Returned picture length, 0 means no picture, larger than 0 means picture data follows the structure
    BYTE        byAlarmPicType;                //0- abnormal face alarm picture, 1- face picture,2-multi faces,3-sunglasses face, 4-calling face  
    BYTE     byPanelChan;        /*2012-3-1 Related panel channel*/
    BYTE    byRelAlarmPicNum; //Related alarm picture num
    BYTE    byRes1; //Reserved
    DWORD   dwFacePicDataLen;//Face picture length
    DWORD   dwAlarmID;    //Alarm ID,marking the same group of alarmls,0-unused
    WORD    wDevInfoIvmsChannelEx;     //NET_VCA_DEV_INFO->byIvmsChannel
    BYTE    byRes2[42];   //Reserved
    BYTE    *pFaceImage; //Pointer to face picture
    BYTE    *pImage;       //Pointer to picture
}NET_DVR_FACEDETECT_ALARM, *LPNET_DVR_FACEDETECT_ALARM;

typedef struct tagNET_DVR_EVENT_PARAM_UNION
{
    DWORD  uLen[3];        //Union size, 12 bytes
    DWORD  dwHumanIn;         //There are nobody or someone access, 0 -nobody, 1- someone  
    float  fCrowdDensity;  //Aggregation value of people
}NET_DVR_EVENT_PARAM_UNION, *LPNET_DVR_EVENT_PARAM_UNION;

//Real-time alarm upload of someone and onbody event or people aggregation event
typedef struct tagNET_DVR_EVENT_INFO
{
    BYTE   byRuleID;                // Rule ID
    BYTE   byRes[3];                // Reserved
    BYTE   byRuleName[NAME_LEN];    // Rule name
    DWORD       dwEventType;        // See to VCA_EVENT_TYPE
    NET_DVR_EVENT_PARAM_UNION uEventParam;
}NET_DVR_EVENT_INFO, *LPNET_DVR_EVENT_INFO;

typedef struct tagNET_DVR_EVENT_INFO_LIST
{
    BYTE            byNum;      // Total number of event real-time information
    BYTE            byRes1[3];  // Reserved
    NET_DVR_EVENT_INFO struEventInfo[MAX_RULE_NUM];    // Event real-time information
}NET_DVR_EVENT_INFO_LIST, *LPNET_DVR_EVENT_INFO_LIST;

typedef struct tagNET_DVR_RULE_INFO_ALARM
{
    DWORD         dwSize;                       // Structure size
    DWORD         dwRelativeTime;         // Relative time
    DWORD        dwAbsTime;                // Absolute time
    NET_VCA_DEV_INFO      struDevInfo;    // Front-end device information
    NET_DVR_EVENT_INFO_LIST struEventInfoList;    //Event information list
    BYTE            byRes2[40];            // Reserved
}NET_DVR_RULE_INFO_ALARM, *LPNET_DVR_RULE_INFO_ALARM;

typedef struct tagNET_DVR_ONE_SCENE_TIME
{
    BYTE     byActive;                     //0 - Disabled,1-Enabled
    BYTE     byRes1[3];                    //Reserved
    DWORD    dwSceneID;                    //Scene ID
    NET_DVR_SCHEDTIME struEffectiveTime;   //Scene onset time 
    BYTE     byRes2[16];                   //Reserved
}NET_DVR_ONE_SCENE_TIME, *LPNET_DVR_ONE_SCENE_TIME;

typedef struct tagNET_DVR_SCENE_TIME_CFG
{
    DWORD  dwSize;                                               //Structure size
    NET_DVR_ONE_SCENE_TIME struSceneTime[MAX_SCENE_TIMESEG_NUM]; //Scene time array
    BYTE   byRes[64];                                            //Reserved
}NET_DVR_SCENE_TIME_CFG, *LPNET_DVR_SCENE_TIME_CFG;

typedef struct  tagNET_DVR_ONE_SCENE_CFG_
{
    BYTE   byEnable;                 //Enable scene,0-disabled 1- enabled
    BYTE   byDirection;              //Monitoring direction: 1- up-road,2- down-road, 3- two-way, 4- from east to west, 5- from south to north, 6- from west to east, 7- from north to south, 8- others 
    BYTE   byRes1[2];                //Reserved
    DWORD  dwSceneID;                //Scene ID(Read only), 0 - Invalid
    BYTE   bySceneName[NAME_LEN];    //Scene name
    NET_DVR_PTZPOS struPtzPos;       //Ptz pos
    DWORD  dwTrackTime;              //Track time[5s,300s],take effect in TFS intelligent analysis
    BYTE   byRes2[24];               //Reserved
}NET_DVR_ONE_SCENE_CFG, *LPNET_DVR_ONE_SCENE_CFG;


typedef struct tagNET_DVR_SCENE_CFG
{
    DWORD dwSize;                                          //Structure size
    NET_DVR_ONE_SCENE_CFG struSceneCfg[MAX_ITS_SCENE_NUM]; //Scene configuration param
    BYTE   byRes[40];                                      //Reserved
}NET_DVR_SCENE_CFG, *LPNET_DVR_SCENE_CFG;


typedef struct tagNET_DVR_SCENE_COND
{
    DWORD   dwSize;       //Structure size
    LONG    lChannel;     //Channel number
    DWORD   dwSceneID;    //Scene ID, 0-Invalid
    BYTE    byRes[48];    //Reserved
}NET_DVR_SCENE_COND, *LPNET_DVR_SCENE_COND;

typedef struct tagNET_DVR_FORENSICS_MODE
{
    DWORD  dwSize;      //Structure size
    BYTE   byMode;      //Forentics mode,0-Manual ,1-Auto,2-semiAutoTrack
    BYTE   byRes[23];   //Reserved
}NET_DVR_FORENSICS_MODE, *LPNET_DVR_FORENSICS_MODE;

typedef struct tagNET_DVR_SCENE_INFO_
{
    DWORD           dwSceneID;              //Scene ID, 0 - Invalid
    BYTE            bySceneName[NAME_LEN];  //Scene name
    BYTE            byDirection;            //Monitoring direction: 1- up-road,2- down-road, 3- two-way, 4- from east to west, 5- from south to north, 6- from west to east, 7- from north to south, 8- others 
    BYTE            byRes1[3];              //Reserved
    NET_DVR_PTZPOS  struPtzPos;             //Ptz Pos
    BYTE            byRes2[64];            //Reserved
}NET_DVR_SCENE_INFO, *LPNET_DVR_SCENE_INFO;

typedef struct tagNET_DVR_AID_ALARM_V41
{
    DWORD              dwSize;              //Structure size
    DWORD              dwRelativeTime;        //Relative time
    DWORD              dwAbsTime;            //Absolute time
    NET_VCA_DEV_INFO   struDevInfo;            //Device info
    NET_DVR_AID_INFO   struAIDInfo;         //Traffic event info
    NET_DVR_SCENE_INFO struSceneInfo;       //Scene info
    DWORD              dwPicDataLen;        //Picture length 
    BYTE               *pImage;             //pointer to image data 
    // 0- upload data directly; 1- cloud storage server URL (3.7Ver) image data into URL data the original picture into URL length
    BYTE               byDataType;
    BYTE               byLaneNo;  //Relate Lane No 
    WORD               wMilliSecond;        //milliseconds
    BYTE               byMonitoringSiteID[MONITORSITE_ID_LEN/*48*/];
    BYTE               byDeviceID[DEVICE_ID_LEN/*48*/];
    DWORD              dwXmlLen;//XML Alarm Len
    char*              pXmlBuf;// EventNotificationAlert XML Block
    BYTE               byTargetType;// Type of calibration target,0~unknown,1~pedestrians,2~Two wheels,3~tricycle(Return during pedestrian detection)
    BYTE               byRes[19];
}NET_DVR_AID_ALARM_V41, *LPNET_DVR_AID_ALARM_V41;

typedef struct tagNET_DVR_TPS_ALARM_V41
{
    DWORD                 dwSize;          //Structure size
    DWORD                 dwRelativeTime;  //Relative time
    DWORD                 dwAbsTime;       //Absolute time
    NET_VCA_DEV_INFO      struDevInfo;     //Device info
    NET_DVR_TPS_INFO_V41  struTPSInfo;     //Traffic parameter statistics information 
    BYTE           byMonitoringSiteID[MONITORSITE_ID_LEN/*48*/];
    BYTE           byDeviceID[DEVICE_ID_LEN/*48*/];
    DWORD                dwStartTime;
    DWORD                dwStopTime;
    BYTE                   byRes[24];
} NET_DVR_TPS_ALARM_V41, *LPNET_DVR_TPS_ALARM_V41;

/*******************************Intelligent Traffic Function end*****************************************/

#define PRIVT_XXX_MAJOR_VERSION      2

#define PRIVT_XXX_SUB_VERSION        3 /* Sub version value, up to 31 */

#define PRIVT_XXX_REVISION_VERSION   4

typedef struct tagNET_DVR_VCA_VERSION
{
    WORD    wMajorVersion;         // Main version
    WORD    wMinorVersion;         // Sub version
    WORD    wRevisionNumber;     // Revision
    WORD    wBuildNumber;         // Build
    WORD    wVersionYear;         //Version date- Year
    BYTE    byVersionMonth;         //Version date- Month
    BYTE    byVersionDay;             //Version date- Day
    BYTE    byType;
    BYTE    byRes[7];
}NET_DVR_VCA_VERSION, *LPNET_DVR_VCA_VERSION;

/******************************Intelligent function end***********************************/

/*******************************Video Management system***********************************/
//09- 11- 21
#define MAX_SUBSYSTEM_NUM    80   //Max. sub system number in the matrix
#define MAX_SERIALLEN        36   //Max. SN Length
#define MAX_LOOPPLANNUM        16   //Max loop group number
#define DECODE_TIMESEGMENT  4    //Time segment number of decoding schedule
typedef struct tagNET_DVR_SUBSYSTEMINFO
{
    BYTE        bySubSystemType; //Sub system type, 1- decoding, 2- encoding, 0- NULL (Read-only) 
    BYTE        byChan; //Channel parameters for the sub system (Read-only) 
    BYTE        byLoginType; //Registration type, 1- direct connect, 2- DNS, 3- Peanut Hull
    BYTE        byRes1[5];
    NET_DVR_IPADDR   struSubSystemIP;         /*IP Address */
    WORD        wSubSystemPort;         //Sub system port number 
    BYTE        byRes2[6];
    NET_DVR_IPADDR  struSubSystemIPMask; //Subnet mask
    NET_DVR_IPADDR    struGatewayIpAddr;     /*Network Gateway*/
    BYTE        sUserName[NAME_LEN];     /* User name  (Read-only) */
    BYTE        sPassword[PASSWD_LEN];     /*Password (Read-only) */
    char        sDomainName[MAX_DOMAIN_NAME]; // Domain name  
    char         sDnsAddress[MAX_DOMAIN_NAME]; /*DNS domain name or IP*/
    BYTE        sSerialNumber[SERIALNO_LEN]; //SN (Read-only) 
}NET_DVR_SUBSYSTEMINFO, *LPNET_DVR_SUBSYSTEMINFO;

typedef struct tagNET_DVR_ALLSUBSYSTEMINFO
{
    DWORD dwSize;
    NET_DVR_SUBSYSTEMINFO struSubSystemInfo[MAX_SUBSYSTEM_NUM];
    BYTE byRes[8];
}NET_DVR_ALLSUBSYSTEMINFO, *LPNET_DVR_ALLSUBSYSTEMINFO;

typedef struct tagNET_DVR_ALARMMODECFG
{
    DWORD     dwSize;
    BYTE    byAlarmMode; //Alarm trigger mode, 1- loop, 2- Remain        
    WORD    wLoopTime; //Loop cycle interval (unit: second)            
    BYTE    byRes[9];
}NET_DVR_ALARMMODECFG, *LPNET_DVR_ALARMMODECFG;

typedef struct  tagNET_DVR_CODESPLITTERINFO
{
    DWORD            dwSize;
    NET_DVR_IPADDR   struIP;         /*IP of Code Distributor*/
    WORD        wPort;                     //Port number of Code Distributor
    BYTE        byRes1[6];
    BYTE        sUserName[NAME_LEN];     /* User name */
    BYTE        sPassword[PASSWD_LEN];     /*Password */
    BYTE        byChan; //485 port number of the Code Distributor
    BYTE        by485Port; //485 address of the Code Distributor
    BYTE        byRes2[14];
} NET_DVR_CODESPLITTERINFO, *LPNET_DVR_CODESPLITTERINFO;

typedef struct tagNET_DVR_ASSOCIATECFG
{
    BYTE    byAssociateType; //Alarm linkage, 1- alarm out
    WORD    wAlarmDelay; //Alarm out delay, 0- 5 seconds;  1- 10 seconds; 2- 30 seconds; 3- 1 minute; 4- 2 minutes; 5- 5 minutes; 6- 10 minutesw; 
    BYTE    byAlarmNum; //Alarm ID number
    BYTE    byRes[8];
} NET_DVR_ASSOCIATECFG, *LPNET_DVR_ASSOCIATECFG;

typedef struct tagNET_DVR_DYNAMICDECODE
{
    DWORD                            dwSize;
    NET_DVR_ASSOCIATECFG           struAssociateCfg; //Trigger dynamic decoding associated structure
    NET_DVR_PU_STREAM_CFG        struPuStreamCfg; //Dynamic decoding structure
    BYTE                            byRes[8];
}NET_DVR_DYNAMICDECODE, *LPNET_DVR_DYNAMICDECODE;

typedef struct  tagNET_DVR_DECODESCHED
{
    NET_DVR_SCHEDTIME  struSchedTime; //
    BYTE  byDecodeType; /*0- no, 1- loop decoding, 2- dynamic decoding*/
    BYTE  byLoopGroup; //Loop Group
    BYTE  byRes[6];
    NET_DVR_PU_STREAM_CFG struDynamicDec; //Dynamic decoding
} NET_DVR_DECODESCHED, *LPNET_DVR_DECODESCHED;

typedef struct tagNET_DVR_PLANDECODE
{
    DWORD dwSize;
    NET_DVR_DECODESCHED struDecodeSched[MAX_DAYS][DECODE_TIMESEGMENT]; //Start from Monday, consistent with 9000
    BYTE byRes[8];
} NET_DVR_PLANDECODE, *LPNET_DVR_PLANDECODE;

typedef struct
{
    NET_DVR_TIME strLogTime;
    DWORD    dwMajorType;     //Main type 1- alarm;  2- abnormal;  3- operation;  0xff- all 
    DWORD    dwMinorType;     //Hypo- Type 0- all; 
    BYTE    sPanelUser[MAX_NAMELEN];  //user ID for local panel operation
    BYTE    sNetUser[MAX_NAMELEN]; //user ID for network operation
    NET_DVR_IPADDR    struRemoteHostAddr; //remote host IP
    DWORD    dwParaType; //parameter type
    DWORD    dwChannel; //channel number
    DWORD    dwDiskNumber; //HD number
    DWORD    dwAlarmInPort; //alarm input port
    DWORD    dwAlarmOutPort; //alarm output port
    DWORD   dwInfoLen;
    BYTE  byDevSequence; //Slot number
    BYTE  byMacAddr[MACADDR_LEN]; //MAC address, 6
    BYTE  sSerialNumber[SERIALNO_LEN]; //Serial Number, 48
    char  sInfo[LOG_INFO_LEN - SERIALNO_LEN - MACADDR_LEN - 1];
}NET_DVR_LOG_MATRIX, *LPNET_DVR_LOG_MATRIX;

//2009- 11- 21 Video Management Platform
typedef struct tagVEDIOPLATLOG
{
    BYTE bySearchCondition; //Search condition, 0-  search by slot number, 1- Search by SN,  2- Search by MAC
    //Slot number, 0- 79: (corresponding to the slot number in the sub system); 
    //0xff: Search all the logs
    //0xfe: Search logs on 78k;0xfd:Search logs on sub domain;0xfc:Search logs on domain
    BYTE byDevSequence;
    BYTE  sSerialNumber[SERIALNO_LEN]; //Serial Number, 48
    BYTE  byMacAddr[MACADDR_LEN]; //MAC, 6
} NET_DVR_VEDIOPLATLOG, *LPNET_DVR_VEDIOPLATLOG;

//2009- 11- 21
#define VIDEOPLATFORM_SBUCODESYSTEM_ABILITY          0x211 //Encoding sub system ability
typedef struct tagNET_DVR_CODESYSTEMABILITY
{
    DWORD dwSize;
    DWORD dwAbilityVersion; //Ability version number, the highest 16 digits stands for the main version and the lowest 16 digits stands for the sub version 
    DWORD dwSupportMaxVideoFrameRate; //Unit (Kbps) 
    /*Recording mode by digit:
    0: continuous recording according to time schedule;
    1: continues| event trigger recording
    2: Motion detect
    3: Network alarm;
    4: Motion| Network Alarm;
    5: Motion & Network alarm;
    6: Perimeter alarm;
    7: Face recognition;
    8: LPR;
    9: Manual recording*/
    DWORD dwSupportRecordType;
    BYTE  bySupportLinkMode; //By digit: 0th-main stream; 1st: sub stream
    BYTE  bySupportStringRow;//Supported character string rows
    BYTE  byRes1[2];
    //Resolution:0-DCIF 1-CIF, 2-QCIF, 3-4CIF, 4-2CIF 5-(Reserved),
    //16-VGA(640*480), 17-UXGA(1600*1200), 18-SVGA(800*600),
    //19-HD720p(1280*720),20-XVGA,  21-HD900p, 27-HD1080i, 
    //28-2560*1920, 29-1600*304, 30-2048*1536, 31-2448*2048    
    BYTE  byMainStreamSupportResolution[32]; //Supported resolution of main stream(added in v1.1 ability)
    BYTE  bySubStreamSupportResolution[32];  //Supported resolution of sub stream(added in v1.1 ability)
    BYTE  byEventStreamSupportResolution[32];//Supported resolution of event stream(added in v1.1 ability)
    BYTE  byRes2[28];//Reserved
}NET_DVR_CODESYSTEMABILITY, *LPNET_DVR_CODESYSTEMABILITY;

//2010- 03- 31 Add ability set of the video management system
typedef struct tagNET_DVR_SUBSYSTEM_ABILITY
{
    BYTE  bySubSystemType; //Sub system type, 1- Decoding, 2- Encoding, 0- NULL
    BYTE  byChanNum; //Channel number in the sub system
    BYTE  byStartChan; //Start channel of the sub system
    BYTE  byRes1[5];
    union
    {
        BYTE Res[200];
        struct
        {
            BYTE  byVGANums; // Display channel number of VGA( start from 1) 
            BYTE  byBNCNums; // Display channel number of BNC(start from 9) 
            BYTE  byHDMINums; // Display channel number of HDMI (start from 25) 
            BYTE  byDVINums; // Display channel number of DVI(start from 29) 
            BYTE  byRes[196];
        }struDecoderSystemAbility;
        struct
        {
            BYTE  byRes[200];
        }struCoderSystemAbility;
    }struAbility;
}NET_DVR_SUBSYSTEM_ABILITY, *LPNET_DVR_SUBSYSTEM_ABILITY;

typedef struct tagNET_DVR_VIDEOPLATFORM_ABILITY
{
    DWORD dwSize;
    BYTE  byCodeSubSystemNums; //number of encoding sub system
    BYTE  byDecodeSubSystemNums; //number of decoding sub system
    BYTE  bySupportNat; //0- does not support NAT, 1- support NAT
    BYTE  byRes1[17];
    NET_DVR_SUBSYSTEM_ABILITY struSubSystemAbility[MAX_SUBSYSTEM_NUM];
    BYTE  byRes2[640];
}NET_DVR_VIDEOPLATFORM_ABILITY, *LPNET_DVR_VIDEOPLATFORM_ABILITY;

/********************************end*******************************************/

/******************************Intelligent Traffic Surveillance Camera*******************************************/
//IO input
typedef struct tagNET_DVR_IO_INCFG
{
    DWORD   dwSize;
    BYTE    byIoInStatus; //Input IO status, 0- Falling edge, 1- Rising edge, 2- Falling edge and Rising edge, 3- HIGH, 4- LOW
    BYTE    byRes[3]; //Reserved
}NET_DVR_IO_INCFG, *LPNET_DVR_IO_INCFG;

//IO output
typedef struct tagNET_DVR_IO_OUTCFG
{
    DWORD   dwSize;
    BYTE    byDefaultStatus; //Default IO status: 0- LOW, 1- HIGH 
    BYTE    byIoOutStatus; //IO valid status: 0- LOW, 1- HIGH, 2- PULSE
    WORD    wAheadTime; //Advance time of IO Output, Unit: us
    DWORD   dwTimePluse; //Pulse interval (unit: us)
    DWORD   dwTimeDelay; //IO delay time (unit: us)
    BYTE    byFreqMulti;        //frequence,[1,15]
    BYTE    byDutyRate;        //duty rate,[0,40%]
    BYTE    byRes2[2];
}NET_DVR_IO_OUTCFG, *LPNET_DVR_IO_OUTCFG;

//Flashlight
typedef struct tagNET_DVR_FLASH_OUTCFG
{
    DWORD  dwSize;
    BYTE   byMode;// 0- not flashing, 1- flashing, 2- alarm linkage, 3- loop mode
    BYTE   byRelatedIoIn;//Corresponding IO (for alarm linkage mode) 
    BYTE   byRecognizedLane;  /*Corresponding IO, expressed by bit, bit0 means whether IO1 is related: 0-not related, 1-related*/
    BYTE   byDetectBrightness;/*Detect brightness enable flashlight automatically:0-not detect;1-detect*/
    BYTE   byBrightnessThreld;/*Brightness threshold of enable flashlight:[0,100].Flashlight works when up to the threshold*/
    BYTE   byStartHour;            //Start time--hour, value range: 0-23
    BYTE   byStartMinute;        //Start time--minute, value range: 0-59
    BYTE   byEndHour;            //End time--hour, value range: 0-23
    BYTE   byEndMinute;            //End time--minute, value range: 0-59
    BYTE   byFlashLightEnable;    //Set flashlight time enable: 0 - off, 1 - open
    BYTE   byRes[2];
}NET_DVR_FLASH_OUTCFG, *LPNET_DVR_FLASH_OUTCFG;

//Traffic light 
typedef struct tagNET_DVR_LIGHTSNAPCFG
{
    DWORD   dwSize;
    BYTE    byLightIoIn; //Traffic Light IO
    BYTE    byTrigIoIn; //Triggered IO
    BYTE    byRelatedDriveWay; //Corresponding traffic lane
    BYTE    byTrafficLight;  //0- HIGH status for red light and LOW for green light; 1- HIGH status for green light and LOW for red light
    BYTE     bySnapTimes1;  //Red light snapshot time, 0- disable, else- snapshot time (up to 5)
    BYTE     bySnapTimes2;  //Green light snapshot time, 0-disable, else- snapshot time (up to 5) 
    BYTE    byRes1[2];
    WORD    wIntervalTime1[4]; //Red light snapshot interval (unit: ms)
    WORD    wIntervalTime2[4]; //Green light snapshot interval (unit: ms)
    BYTE    byRecord; //Record when driving on red light, 0- disable, 1- enable
    BYTE    bySessionTimeout; //Time out session for red light recording (unit: s) 
    BYTE    byPreRecordTime; //Pre-Recording time for red light recording (unit: s)
    BYTE    byVideoDelay; //Post--Recording time for red light recording (unit: s) 
    BYTE    byRes2[32]; //Reserved
}NET_DVR_LIGHTSNAPCFG, *LPNET_DVR_LIGHTSNAPCFG;

//Speed Measurement
typedef struct tagNET_DVR_MEASURESPEEDCFG
{
    DWORD   dwSize;
    BYTE    byTrigIo1;    //Testing coil 1
    BYTE    byTrigIo2;    //Testing coil 2
    BYTE    byRelatedDriveWay; //Corresponding traffic lane
    BYTE    byTestSpeedTimeOut; //Timeout for speed testing (unit: s) 
    DWORD   dwDistance; //Coil distance, cm
    BYTE    byCapSpeed; //Capture speed starts from (unit:km/h)
    BYTE    bySpeedLimit; //Speed limitation (km/h)
    BYTE     bySnapTimes1;  //Snapshot time for coil 1, 0- disable, else- snapshot time (up to 5)
    BYTE     bySnapTimes2;  //Snapshot time for coil 2, 0- disable, else- snapshot time (up to 5)
    WORD    wIntervalTime1[4]; //Snapshot interval for Coil 1 (unit: ms)
    WORD    wIntervalTime2[4]; //Snapshot interval for Coil 2 (unit: ms)
    BYTE    byRes[32]; //Reserved
}NET_DVR_MEASURESPEEDCFG, *LPNET_DVR_MEASURESPEEDCFG;


typedef struct tagNET_DVR_CLOUDSTORAGE_COND
{
    DWORD  dwSize;
    DWORD  dwChannel;
    BYTE    byRes1[64];
}NET_DVR_CLOUDSTORAGE_COND, *LPNET_DVR_CLOUDSTORAGE_COND;


typedef struct tagNET_DVR_POOLPARAM
{
    DWORD  dwPoolID;// Pool ID
    BYTE    byRes[4];
}NET_DVR_POOLPARAM, *LPNET_DVR_POOLPARAM;

typedef struct tagNET_DVR_CLOUDSTORAGE_CFG
{
    DWORD   dwSize;
    BYTE    byEnable;
    BYTE    byRes[3];
    NET_DVR_IPADDR  struIP;
    WORD    wPort; //Data Port
    BYTE    byRes1[2];
    char    szUser[CLOUD_NAME_LEN/*48*/]; //User 
    char    szPassword[CLOUD_PASSWD_LEN/*48*/];     // Password
    NET_DVR_POOLPARAM  struPoolInfo[16];//Array 0 bayonet video pool, an array of 1 said illegal video pool
    BYTE    byRes2[128];
}NET_DVR_CLOUDSTORAGE_CFG, *LPNET_DVR_CLOUDSTORAGE_CFG;

typedef  struct  tagNET_DVR_PARKLAMP_COND
{
    DWORD  dwSize;
    DWORD  dwChannel;
    BYTE   byParkingIndex;//ParkingIndex(1~4)
    BYTE   byRes[15];
}NET_DVR_PARKLAMP_COND, *LPNET_DVR_PARKLAMP_COND;

typedef  struct  tagNET_DVR_PARKLAMP_INFOCFG
{
    DWORD dwSize;
    char  sLicense[MAX_LICENSE_LEN/*16*/];//Plate License
    char  sParkingNo[MAX_LICENSE_LEN/*16*/];//Parking No(Actual)
    BYTE   byLampFlicker;//0 ~ no flashing 1 ~flashing
    BYTE   byLampColor;//0-close 1-red 2-green 3-yellow 4-blue 5-magenta  6-cyan 7-white (lamp work)
    BYTE   byStatus; //Parking state 0- no car, 1- car
    BYTE   byColorDepth; //Body color shades,0-Dark,1-Light
    BYTE   byColor;//Body color,0-other colors,1-white,2-Silver,3-gray,4-black,5-red,6-Deep Blue,7-Blue,8-yellow,9-Green,10-brown,11-pink,12-purple,0xff-Body color recognition not performed 
    //Identify the type of vehicle brands; Reference enumerated type: VLR_VEHICLE_CLASS
    BYTE   byVehicleLogoRecog;
    BYTE   byRes[250];//Reservations
}NET_DVR_PARKLAMP_INFOCFG, *LPNET_DVR_PARKLAMP_INFOCFG;

//Video parameter configuration
typedef struct tagNET_DVR_VIDEOEFFECT
{
    BYTE byBrightnessLevel;  /*0- 100*/
    BYTE byContrastLevel;  /*0- 100*/
    BYTE bySharpnessLevel;  /*0- 100*/
    BYTE bySaturationLevel;  /*0- 100*/
    BYTE byHueLevel;  /*0- 100,  (Reserved) */
    BYTE byEnableFunc; //enable,bit0-SMART IR,bit1-illumination,bit2-light inhibit,0-no,1-yes
    BYTE byLightInhibitLevel; //light inhibit level,[1-3]
    BYTE byGrayLevel; //gray level,0-[0-255],1-[16-235]
}NET_DVR_VIDEOEFFECT, *LPNET_DVR_VIDEOEFFECT;

//Gain Configuration
typedef struct tagNET_DVR_GAIN
{
    BYTE byGainLevel;  /*Gain: 0- 100*/
    BYTE byGainUserSet;  /*Customize Gain level adjustment ([0- 100]) for CCD mode*/
    BYTE byRes[2];
    DWORD dwMaxGainValue; /*Max. Gain level (unit: dB)*/
}NET_DVR_GAIN, *LPNET_DVR_GAIN;

//White Balance
typedef struct tagNET_DVR_WHITEBALANCE
{
    BYTE byWhiteBalanceMode;  /*0-MWB,1-AWB1,2-AWB2,3-Locked WB,
                             4-Outdoor,5-Indoor,6-Fluorescent Lamp,7-Sodium Lamp,
                             8-Auto-Track,9-One Push,10-Auto-Outdoor,
                             11-Auto-Sodiumlight,12-Mercury Lamp,13-Auto,
                             14-IncandescentLamp,15-Warm Light Lamp,16-Natural Light */
    BYTE byWhiteBalanceModeRGain;  /*R Gain for Manual White Balance mode*/
    BYTE byWhiteBalanceModeBGain;  /*B Gain for Manual White Balance mode*/
    BYTE byRes[5];
}NET_DVR_WHITEBALANCE, *LPNET_DVR_WHITEBALANCE;

//Exposure Control
typedef struct tagNET_DVR_EXPOSURE
{
    BYTE  byExposureMode;  /*0 - manual exposure 1- auto exposure*/
    BYTE  byAutoApertureLevel; /* Auto Aperture Level, 0-10 */
    BYTE  byRes[2];
    DWORD dwVideoExposureSet;  /* Exposure time for manual mode or Max. exposure time for auto mode(unit: us) 20-1s(1000000us)*/
    DWORD dwExposureUserSet;  /* Exposure time (Shutter speed for CCD mode)*/
    DWORD dwRes;
} NET_DVR_EXPOSURE, *LPNET_DVR_EXPOSURE;

//WDR configuration
typedef struct tagNET_DVR_WDR
{
    BYTE byWDREnabled;  /*WDR: 0 disable  1 enable 2 auto*/
    BYTE byWDRLevel1;  /*0- F*/
    BYTE byWDRLevel2;  /*0- F*/
    BYTE byWDRContrastLevel;  /*0- 100*/
    BYTE byRes[16];
} NET_DVR_WDR, *LPNET_DVR_WDR;

typedef struct tagNET_DVR_WDR_CFG
{
    DWORD  dwSize;
    NET_DVR_WDR  struWDR;
} NET_DVR_WDR_CFG, *LPNET_DVR_WDR_CFG;


//Day/Night Switching
typedef struct tagNET_DVR_DAYNIGHT
{
    BYTE byDayNightFilterType;  /*Day/Night mode: 0 day, 1 night, 2 auto,3-timing,4-alarm in trigger,
                                5 - automatic mode 2 (no light) ,6-black light,7-auto black light,8-time black light*/
    BYTE bySwitchScheduleEnabled;  /*0 disable  1 enable (Reserved) */
    //Mode 1 
    BYTE byBeginTime;  /*begin time hour,0-23*/
    BYTE byEndTime;  /*end time hour,0-23*/
    //Mode 2 (Reserved)
    BYTE byDayToNightFilterLevel;  //0- 7
    BYTE byNightToDayFilterLevel;  //0- 7
    BYTE byDayNightFilterTime; // (60 sec) 
    BYTE byBeginTimeMin; //begin time min,0-59
    BYTE byBeginTimeSec; //begin time sec,0-59
    BYTE byEndTimeMin; //end time min,0-59
    BYTE byEndTimeSec; //end time sec,0-59
    BYTE byAlarmTrigState; //alarm in trigger state,0-day,1-night
} NET_DVR_DAYNIGHT, *LPNET_DVR_DAYNIGHT;

//Gamma correction
typedef struct tagNET_DVR_GAMMACORRECT
{
    BYTE byGammaCorrectionEnabled;  /*0- disable;  1- enable*/
    BYTE byGammaCorrectionLevel;  /*0- 100*/
    BYTE byRes[6];
} NET_DVR_GAMMACORRECT, *LPNET_DVR_GAMMACORRECT;

//BLC
typedef struct tagNET_DVR_BACKLIGHT
{
    BYTE byBacklightMode;  /*BLC: 0-off  1- UP, 2- DOWN, 3- LEFT, 4- RIGHT, 5- MIDDLE, 6-USERSET ,10-start,11-auto,12-Multi regional backlight compensation*/
    BYTE byBacklightLevel;  /*0x0- 0xF*/
    BYTE byRes1[2];
    DWORD dwPositionX1;  // (X coordinate 1) 
    DWORD dwPositionY1;  // (Y coordinate 1) 
    DWORD dwPositionX2;  // (X coordinate 2) 
    DWORD dwPositionY2;  // (Y coordinate 2) 
    BYTE byRes2[4];
} NET_DVR_BACKLIGHT, *LPNET_DVR_BACKLIGHT;

//DNR
typedef struct tagNET_DVR_NOISEREMOVE
{
    BYTE byDigitalNoiseRemoveEnable;  /*DNR: 0- disable  1- normal mode, 2-expert mode*/
    BYTE byDigitalNoiseRemoveLevel;  /*0x0- 0xF*/
    BYTE bySpectralLevel;   /*expert mode Spatial intensity, 0-100*/
    BYTE byTemporalLevel;   /*expert mode Time-domain intensity, 0-100*/
    BYTE byDigitalNoiseRemove2DEnable;
    BYTE byDigitalNoiseRemove2DLevel;
    BYTE byRes[2];
} NET_DVR_NOISEREMOVE, *LPNET_DVR_NOISEREMOVE;

//Lens configuration under CMOS mode
typedef struct tagNET_DVR_CMOSMODCFG
{
    BYTE byCaptureMod;    //Snapshot mode: 0- mode1; 1- mode2
    BYTE byBrightnessGate; //Brightness threshold
    BYTE byCaptureGain1;    //Snapshot Gain1, 0- 100
    BYTE byCaptureGain2;    //Snapshot Gain2, 0- 100
    DWORD dwCaptureShutterSpeed1; //Snapshot Shutter speed 1
    DWORD dwCaptureShutterSpeed2; //Snapshot Shutter speed 2
    BYTE    byRes[4];
}NET_DVR_CMOSMODECFG, *LPNET_DVR_CMOSMODECFG;

//IPC CCD Parameter Configuration
typedef struct tagNET_DVR_CAMERAPARAMCFG
{
    DWORD dwSize;
    NET_DVR_VIDEOEFFECT struVideoEffect; /*Brightness, Contrast, Saturation, Sharpness, Hue Configuration*/
    NET_DVR_GAIN struGain; /*Auto Gain*/
    NET_DVR_WHITEBALANCE struWhiteBalance; /*White Balance*/
    NET_DVR_EXPOSURE struExposure;  /*Exposure Control*/
    NET_DVR_GAMMACORRECT struGammaCorrect; /*Gamma Correction*/
    NET_DVR_WDR struWdr; /*WDR*/
    NET_DVR_DAYNIGHT struDayNight; /*Day/Night*/
    NET_DVR_BACKLIGHT struBackLight; /*BLC*/
    NET_DVR_NOISEREMOVE struNoiseRemove; /*DNR*/
    BYTE byPowerLineFrequencyMode;  /*0- 50HZ;  1- 60HZ*/
    /*
        0-Auto Iris,
        1-Manual Iris,
        2-P-Iris1,
        3-Union 3-9mm F1.6-2.7 (T5280-PQ1) [IPC5.1.7]
        4-Union 2.8-12mm F1.6-2.7 (T5289-PQ1) [IPC5.1.7]
        5-HIK 3.8-16mm F1.5(HV3816P-8MPIR)
        6-HIK 11-40mm F1.7 (HV1140P-8MPIR)
        7-HIK 2.7-12mm F1.2(TV2712P-MPIR)
        8- MZ5721D-12MPIR
        9- MZ1555D-12MPIR
        10- MZ5721D-12MPIR(RS485)
        11- MZ1555D-12MPIR(RS485)
        */
    BYTE byIrisMode;
    BYTE byMirror;   /* Mirror: 0 off, 1- leftright, 2- updown, 3-center */
    BYTE byDigitalZoom;   /*Digital zoom: 0 disable  1 enable*/
    BYTE byDeadPixelDetect;    /*Corrupted Pixel detect, 0-disable  1-enable*/
    BYTE byBlackPwl; /*Black Power Level ,   0- 255*/
    BYTE byEptzGate; // EPTZ: 0-off; 1-Eletronic PTZ
    BYTE byLocalOutputGate; //Local output 0- local output closed; 1- Local BNC output open; 2- HDMI output closed  
    //20- HDMI_720P50 output open
    //21- HDMI_720P60 output open
    //22- HDMI_1080I60 output open
    //23- HDMI_1080I50 output open
    //24- HDMI_1080P24 output open
    //25- HDMI_1080P25 output open
    //26- HDMI_1080P30 output open
    //27- HDMI_1080P50 output open
    //28- HDMI_1080P60 output open

    //40-SDI_720P50,
    //41-SDI_720P60,
    //42-SDI_1080I50,
    //43-SDI_1080I60,
    //44-SDI_1080P24,
    //45-SDI_1080P25,
    //46-SDI_1080P30,
    //47-SDI_1080P50,
    //48-SDI_1080P60
    BYTE byCoderOutputMode; //Encoder's FPGA output mode
    BYTE byLineCoding; //Enable line coding or not: 0- enable, 1- disable
    BYTE byDimmerMode; //Dimming mode: 0- semi-automatic, 1- automatic
    BYTE byPaletteMode; //Color palette: 0- incandescence, 1- Black heat, 2- palette 2, ..., 8- palette 8
    BYTE byEnhancedMode; //Enhance mode (around detected object): 0- not enhance, 1- 1, 2- 2, 3- 3, 4- 4
    BYTE byDynamicContrastEN;     //Increase Dynamic Contrast 0- 1
    BYTE byDynamicContrast;     //Dynamic Contrast 0- 100
    BYTE byJPEGQuality;     //JPEG Quality: 0- 100
    NET_DVR_CMOSMODECFG struCmosModeCfg; //Configuration under CMOS mode
    BYTE byFilterSwitch; //Filter switch: 0- disable, 1- enable
    BYTE byFocusSpeed;  //Focus speed: 0-10
    BYTE byAutoCompensationInterval; //Scheduled automatic shutter compensation: 1-120, unit: minute
    BYTE bySceneMode;  //Scene mode: 0- outdoor, 1- indoor, 2- default, 3 - lowLight
}NET_DVR_CAMERAPARAMCFG, *LPNET_DVR_CAMERAPARAMCFG;

typedef struct tagNET_DVR_DEFOGCFG
{
    BYTE byMode; //mode 0-disable,1-auto,2-enble
    BYTE byLevel; //level 1-100 
    BYTE byRes[6];
}NET_DVR_DEFOGCFG, *LPNET_DVR_DEFOGCFG;

typedef struct tagNET_DVR_ELECTRONICSTABILIZATION
{
    BYTE byEnable;
    BYTE byLevel; //level 1-100 
    BYTE byRes[6];
}NET_DVR_ELECTRONICSTABILIZATION, *LPNET_DVR_ELECTRONICSTABILIZATION;

typedef struct tagNET_DVR_CORRIDOR_MODE_CCD
{
    BYTE       byEnableCorridorMode; // 0~NO enable, 1~ enable
    BYTE       byRes[11];
}NET_DVR_CORRIDOR_MODE_CCD, *LPNET_DVR_CORRIDOR_MODE_CCD;

typedef struct tagNET_DVR_SMARTIR_PARAM
{
    BYTE  byMode;//0~Automatic,1~manual
    BYTE  byIRDistance;//Infrared distance class (grade, distance is proportional) level:1~100 default: 50 (manual mode increase)
    BYTE  byShortIRDistance;// Short IR Distance(1~100)
    BYTE  byLongIRDistance;// Long IR Distance(1~100)
}NET_DVR_SMARTIR_PARAM, *LPNET_DVR_SMARTIR_PARAM;

typedef struct tagNET_DVR_PIRIS_PARAM
{
    BYTE  byMode;//0~Automatic,1~manual
    BYTE  byPIrisAperture;//Infrared aperture size grade (grade, aperture size is proportional) level:1~100 default: 50 (manual mode increase)
    BYTE  byRes[6];
}NET_DVR_PIRIS_PARAM, *LPNET_DVR_PIRIS_PARAM;

//laser parameter 2014-02-25
typedef struct tagNET_DVR_LASER_PARAM_CFG
{
    //Length = 16
    BYTE    byControlMode;        //control mode            0-invalid,1-auto,2-manual  the default is auto
    BYTE    bySensitivity;        //laser sensitivity        0-100  the default is 50
    BYTE    byTriggerMode;        //laser trigger mode    0-invalid,1-Camera Module Trigger,2-Photoresistance Trigger  the default is 1
    BYTE    byBrightness;        //Manual mode;laser brightness        0-255  the default is 100
    BYTE    byAngle;            //laser angle            0-invalid,1-36  the default is 12
    BYTE    byLimitBrightness;  //Auto mode;Laser lamp brightness limit 0~100      2014-01-26
    BYTE    byEnabled;         //Enabled
    BYTE    byIllumination;     //Illumination; 0~100
    BYTE    byLightAngle;       //Light Angle 0~100
    BYTE    byRes[7];
} NET_DVR_LASER_PARAM_CFG, *LPNET_DVR_LASER_PARAM_CFG;

typedef struct tagNET_DVR_FFC_PARAM
{
    //1-Schedule Mode,2-Temperature Mode, 3-Off 
    BYTE   byMode;
    //(time: according to ability display unit minutes, options 10,20,30,40,50,60,120,180,240)
    BYTE   byRes1;
    WORD  wCompensateTime; //Timing mode effect
    BYTE   byRes2[4];
}NET_DVR_FFC_PARAM, *LPNET_DVR_FFC_PARAM;

typedef struct tagNET_DVR_DDE_PARAM
{
    BYTE  byMode;//1-Off,2-Normal Mode,3-Expert Mode
    BYTE  byNormalLevel;//Normal Mode Level[1,100],Normal mode effect
    BYTE  byExpertLevel;//Exper Mode Level[1,100],Exper Mode effect
    BYTE  byRes[5];
}NET_DVR_DDE_PARAM, *LPNET_DVR_DDE_PARAM;

typedef struct tagNET_DVR_AGC_PARAM
{
    BYTE  bySceneType;//1-Normal Sence,2-Highlight Sence,3-Manual Sence
    BYTE  byLightLevel;//Light Level[1,100];Manual Mode effect
    BYTE  byGainLevel; //Gain Level[1,100];Manual Mode effect
    BYTE  byRes[5];
}NET_DVR_AGC_PARAM, *LPNET_DVR_AGC_PARAM;

//Snap CCD CFG
typedef struct tagNET_DVR_SNAP_CAMERAPARAMCFG
{
    BYTE byWDRMode;   // WDR Mode
    BYTE byWDRType;    // WDR Type
    BYTE byWDRLevel;   // WDR Level
    BYTE byRes1;
    NET_DVR_TIME_EX struStartTime; //Start WDR Time
    NET_DVR_TIME_EX struEndTime; //Stop WDR Time
    BYTE byDayNightBrightness; //Day Night Brightness
    //MCE
    BYTE byMCEEnabled;//MCE Enabled,
    BYTE byMCELevel;//MCE Level
    //Auto Contrast
    BYTE byAutoContrastEnabled;//Auto Contrast Enabled
    BYTE byAutoContrastLevel;//Auto Contrast Level
    //LSE Detail
    BYTE byLSEDetailEnabled;//LSE Detail Enabled
    BYTE byLSEDetailLevel;//LSE Detail Level
    // License Plate Definition Enhancement
    BYTE byLPDEEnabled;//LPDE Enabled
    BYTE byLPDELevel;//LPDE Level
    //Contrast enhancement
    BYTE byLseEnabled; //Contrast enhancement enable, true:turn on, false: turn off
    BYTE byLseLevel; //Contrast enhancement level 0-100, default 0
    BYTE byLSEHaloLevel;//Halo suppression level range 0-100, default 0 
    BYTE byLseType; //Contrast enhancement switch model 0~force enable, 1~enable by time, 2~enable by brightness
    BYTE byRes2[3];
    NET_DVR_TIME_EX struLSEStartTime; //enable Contrast enhancement time(when byLseType is 1)
    NET_DVR_TIME_EX struLSEEndTime; //disable Contrast enhancement time(when byLseType is 1)
    BYTE byLightLevel;//brightness range 0-100, default 0(Take effect when byLseType is 2)
    //plate contrast
    BYTE byPlateContrastLevel;//plate contrast level range 0-100,default 0
    //plate saturation
    BYTE byPlateSaturationLevel;//plate saturation level range 0-100 default 0
    BYTE byRes[9];
} NET_DVR_SNAP_CAMERAPARAMCFG, *LPNET_DVR_SNAP_CAMERAPARAMCFG;

//Optical Dehaze
typedef struct tagNET_DVR_OPTICAL_DEHAZE
{
    BYTE byEnable; //0~disable,1~Enable
    BYTE byRes[7];
} NET_DVR_OPTICAL_DEHAZE, *LPNET_DVR_OPTICAL_DEHAZE;

//Thermometry AGC configure
typedef struct tagNET_DVR_THERMOMETRY_AGC
{
    BYTE  byMode;//AGC Mode,0~invalid,1~auto,2~manual
    BYTE  byRes1[3];
    int     iHighTemperature;//High temperature,range:-273~9999 centigrade(1~manual valid)
    int     iLowTemperature;//Low temperature,range:-273~9999 centigrade(1~manual valid)
    BYTE  byRes[8];
}NET_DVR_THERMOMETRY_AGC, *LPNET_DVR_THERMOMETRY_AGC;

//IPC CCD Parameter Configuration
typedef struct tagNET_DVR_CAMERAPARAMCFG_EX
{
    DWORD dwSize;
    NET_DVR_VIDEOEFFECT struVideoEffect; /*Brightness, Contrast, Saturation, Sharpness, Hue Configuration*/
    NET_DVR_GAIN struGain; /*Auto Gain*/
    NET_DVR_WHITEBALANCE struWhiteBalance; /*White Balance*/
    NET_DVR_EXPOSURE struExposure;  /*Exposure Control*/
    NET_DVR_GAMMACORRECT struGammaCorrect; /*Gamma Correction*/
    NET_DVR_WDR struWdr; /*WDR*/
    NET_DVR_DAYNIGHT struDayNight; /*Day/Night*/
    NET_DVR_BACKLIGHT struBackLight; /*BLC*/
    NET_DVR_NOISEREMOVE struNoiseRemove; /*DNR*/
    BYTE byPowerLineFrequencyMode;  /*0- 50HZ;  1- 60HZ*/
    BYTE byIrisMode;
    /*
    0-Auto Iris
    1-Manual Iris
    2-P-Iris1
    3-Union 3-9mm F1.6-2.7 (T5280-PQ1)
    4-Union 2.8-12mm F1.
    5-HIK 3.8-16mm F1.5(HV3816P-8MPIR)
    6-HIK 11-40mm F1.7 (HV1140P-8MPIR)
    7-HIK 2.7-12mm F1.2(TV2712P-MPIR)
    8- MZ5721D-12MPIR
    9- MZ1555D-12MPIR
    10- MZ5721D-12MPIR(RS485)
    11- MZ1555D-12MPIR(RS485)
    */
    BYTE byMirror;   /* Mirror: 0 off, 1- leftright, 2- updown, 3-center */
    BYTE byDigitalZoom;   /*Digital zoom: 0 disable, 1-*2,2-*4,3-*8,4-*16,5-*32*/
    BYTE byDeadPixelDetect;    /*Corrupted Pixel detect, 0-disable  1-enable*/
    BYTE byBlackPwl; /*Black Power Level ,   0- 255*/
    BYTE byEptzGate; // EPTZ: 0-off; 1-Eletronic PTZ
    BYTE byLocalOutputGate; //Local output 0- local output closed; 1- Local BNC output open; 2- HDMI output closed  
    //20- HDMI_720P50 output open
    //21- HDMI_720P60 output open
    //22- HDMI_1080I60 output open
    //23- HDMI_1080I50 output open
    //24- HDMI_1080P24 output open
    //25- HDMI_1080P25 output open
    //26- HDMI_1080P30 output open
    //27- HDMI_1080P50 output open
    //28- HDMI_1080P60 output open
    BYTE byCoderOutputMode; //Encoder's FPGA output mode
    BYTE byLineCoding; //Enable line coding or not: 0- enable, 1- disable
    BYTE byDimmerMode; //Dimming mode: 0- semi-automatic, 1- automatic
    BYTE byPaletteMode; //Color palette: 0- incandescence, 1- Black heat, 2- palette 2, ..., 8- palette 8
    BYTE byEnhancedMode; //Enhance mode (around detected object): 0- not enhance, 1- 1, 2- 2, 3- 3, 4- 4
    BYTE byDynamicContrastEN;     //Increase Dynamic Contrast 0- 1
    BYTE byDynamicContrast;     //Dynamic Contrast 0- 100
    BYTE byJPEGQuality;     //JPEG Quality: 0- 100
    NET_DVR_CMOSMODECFG struCmosModeCfg; //Configuration under CMOS mode
    BYTE byFilterSwitch; //Filter switch: 0- disable, 1- enable
    BYTE byFocusSpeed;  //Focus speed: 0-10
    BYTE byAutoCompensationInterval; //Scheduled automatic shutter compensation: 1-120, unit: minute
    BYTE bySceneMode;  //Scene mode: 0- outdoor, 1- indoor, 2- default, 3 - lowLight
    NET_DVR_DEFOGCFG struDefogCfg;//
    NET_DVR_ELECTRONICSTABILIZATION struElectronicStabilization;//
    NET_DVR_CORRIDOR_MODE_CCD struCorridorMode;//
    BYTE   byExposureSegmentEnable; //0~ is not enabled, 1~ enables the exposure time and gain ladder adjustment, such as exposure to adjust, improve the exposure time to the intermediate value, and then increase the gain to the intermediate value, and then improve the exposure to a maximum value, finally improve the gain to the maximum
    BYTE   byBrightCompensate;//Brightness enhancement [0~100]
    /*
      0-close,1-640*480@25fps,2-640*480@30ps,3-704*576@25fps,4-704*480@30fps,5-1280*720@25fps,6-1280*720@30fps,
      7-1280*720@50fps,8-1280*720@60fps,9-1280*960@15fps,10-1280*960@25fps,11-1280*960@30fps,
      12-1280*1024@25fps,13--1280*1024@30fps,14-1600*900@15fps,15-1600*1200@15fps,16-1920*1080@15fps,
      17-1920*1080@25fps,18-1920*1080@30fps,19-1920*1080@50fps,20-1920*1080@60fps,21-2048*1536@15fps,22-2048*1536@20fps,
      23-2048*1536@24fps,24-2048*1536@25fps,25-2048*1536@30fps,26-2560*2048@25fps,27-2560*2048@30fps,
      28-2560*1920@7.5fps,29-3072*2048@25fps,30-3072*2048@30fps,31-2048*1536@12.5,32-2560*1920@6.25,
      33-1600*1200@25,34-1600*1200@30,35-1600*1200@12.5,36-1600*900@12.5,37-1280*960@12.5fps,38-800*600@25fps,39-800*600@30fps40,
      4000*3000@12.5fps,41-4000*3000@15fps,42-4096*2160@20fps,43-3840*2160@20fps ,44-960*576@25fps,45-960*480@30fps,46-752*582@25fps,
      47-768*494@30fps,48-2560*1440@25fps,49-2560*1440@30fps ,50-720P@100fps,51-720P@120fps,52-2048*1536@50fps,53-2048*1536@60fps,
      54-3840*2160@25fps,55-3840*2160@30fps,56-4096*2160@25fps,57-4096*2160@30fps ,58-1280*1024@50fps,59-1280*1024@60fps,
      60-3072*2048@50fps,61-3072*2048@60fps,62-3072*1728@25fps,63-3072*1728@30fps,64-3072*1728@50fps,65-3072*1728@60fps,66-336*256@50fps,67-336*256@60fps,
      68-384*288@50fps,69-384*288@60fps ,70- 640 * 512@50fps ,71- 640 * 512@60fps,72-2592*1944@25fps,73-2592*1944@30fps,74-2688*1536@25fps,75-2688*1536@30fps
      76-2592*1944@20fps,77-2592*1944@15fps,78-2688*1520@20fps,79-2688*1520@15fps,80-2688*1520@25fps,81-2688*1520@30fps,82- 2720*2048@25fps, 83- 2720*2048@30fps,
      84- 336*256@25fps,85- 384*288@25fps,86-640*512@25fps,87-1280*960@50fps,88-1280*960@60fps,89-1280*960@100fps,90-1280*960@120fps,91-4000*3000@20fps,
      92-1920*1200@25fps,93-1920*1200@30fps,94-2560*1920@25fps,95-2560*1920@20fps,96-2560*1920@30fps,97-1280*1920@25fps,98-1280*1920@30fps,
      99-4000*3000@24fps,100-4000*3000@25fps,101-4000*3000@10fps,102- 384*288@30fps,103-2560*1920@15fps,104-2400*3840@25fps,105-1200*1920@25fps,
      106-4096*1800@30fps,107-3840*1680@30fps,108-2560*1120@30fps,109-704*320@30fps,110-1280*560@30fps,111-4096*1800@25fps,112-3840*1680@25fps,
      113-2560*1120@25fps,114-704*320@25fps,115-1280*560@25fps,116-2400*3840@24fps,117-3840*2400@24fps,118-3840*2400@25fps,119-2560*1920@12.5fps,
      120-2560*2048@12fps,121-2560*2048@15fps,122-2560*1536@25fps,123-2560*1536@30fps,124-2256*2048@25fps,125-2256*2048@30fps,126-2592*2592@12.5fps,127-2592*2592@15fps,
      128 - 640*512@30fps,129-2048*1520@30fps,130-2048*1520@25fps,131-3840*2160@24fps,132-2592*1520@25fps,133-2592*1520@30fps,134-2592*1536@25fps,135-2592*1536@30fps,
      136-640*960@25fps,137-640*960@24fps,142-2992*2192@25fps,143-2992*2192@30fps,144-3008*2160@25fps,145-3008*2160@30fps,146-3072*1728@20fps,147-2560*1440@20fps,
      148-2160*3840@25fps,149-2160*3840@30fps,150-7008*1080@25fps,151-7008*1080@30fps,152-3072*2048@20fps,153-1536*864@25fps,154-2560*1920@24fps,155-2400*3840@30fps,
      156-3840*2400@30fps,157-3840*2160@15fps
      158-384*288@8.3fps, 159-640*512@8.3fps, 160-160*120@8.3fps, 161-1024*768@8.3fps, 162-640*480@8.3fps, 163-3840*2160@12.5fps, 164-2304*1296@30fps, 165-2304*1296@25fps,
      166-2560*1440@24fps, 167-2688*1512@25fps, 168-2688*1512@30fps, 169-2688*1512@50fps, 170-2688*1512@60fps, 171-1536*864@30fps, 172-2560*1440@50fps, 173-2560*1440@60fps,
      174-2048*2048@25fps, 175-2048*2048@30fps, 176-4000*3060@20fps, 177-3060*3060@25fps, 178-3060*3060@30fps, 179-3000*3000@25fps, 180-3000*3000@30fps,181-8160*3616@30fps,
      182-8160*3616@25fps, 183-3000*3000@20fps, 184-3000*3000@15fps, 185-3000*3000@12.5fps,186-5472*3648@25fps,187-5472*3648@30fps,188-7680*4320@25fps,189-7680*4320@30fps,
      190-8160*2400@25fps, 191-8160*2400@30fps, 192-5520*2400@25fps, 193-5520*2400@30fps, 194-7680*4320@25fps, 195-7680*4320@30fps*/
    BYTE   byCaptureModeN;
    BYTE   byCaptureModeP;
    NET_DVR_SMARTIR_PARAM struSmartIRParam;
    NET_DVR_PIRIS_PARAM struPIrisParam;//The PIris configuration information corresponding to the byIrisMode field come into force from 2-PIris1
    NET_DVR_LASER_PARAM_CFG struLaserParam;    //laser parameter
    NET_DVR_FFC_PARAM  struFFCParam;
    NET_DVR_DDE_PARAM  struDDEParam;
    NET_DVR_AGC_PARAM  struAGCParam;
    BYTE   byLensDistortionCorrection;//Lens distortion correction 0-Disable,1-Enable
    BYTE   byDistortionCorrectionLevel;//0-res;1-level1;2-level2;3-level3;255-custom
    BYTE   byCalibrationAccurateLevel;//[0-100]
    BYTE   byZoomedInDistantViewLevel;//[0-100]
    NET_DVR_SNAP_CAMERAPARAMCFG struSnapCCD; //Snap CCD CFG
    NET_DVR_OPTICAL_DEHAZE struOpticalDehaze;//Optical Dehaze
    NET_DVR_THERMOMETRY_AGC struThermAGC;//AGC configure
    BYTE   byFusionMode; //fusion mode,0-thermal;1-fusion;2-PIP
    BYTE   byHorizontalFOV;//[0-100]
    BYTE   byVerticalFOV;//[0-100]
    BYTE   byBrightnessSuddenChangeSuppression;//0-close 1-open
    BYTE   byRes2[156];
}NET_DVR_CAMERAPARAMCFG_EX, *LPNET_DVR_CAMERAPARAMCFG_EX;

typedef struct tagNET_DVR_FOCUSING_POSITION_STATE
{
    DWORD  dwSize;
    BYTE    byState;//Focusing Position State: 0-not in place,1-in place
    BYTE    byRes[31];
} NET_DVR_FOCUSING_POSITION_STATE, *LPNET_DVR_FOCUSING_POSITION_STATE;

//plate color
typedef enum _VCA_PLATE_COLOR_
{
    VCA_BLUE_PLATE = 0,       //Blue license plate
    VCA_YELLOW_PLATE,          //Yellow license plate
    VCA_WHITE_PLATE,           //White license plate
    VCA_BLACK_PLATE,           //Black license plate
    VCA_GREEN_PLATE,           //Green license plate
    VCA_BKAIR_PLATE,           //Civil aviation balck license plate
    VCA_RED_PLATE,            //Red license plate
    VCA_ORANGE_PLATE,         //Orange license plate
    VCA_OTHER = 0xff           //Other
}VCA_PLATE_COLOR;

//plate type
typedef enum _VCA_PLATE_TYPE_
{
    VCA_STANDARD92_PLATE = 0,    //Standard civil car and military car
    VCA_STANDARD02_PLATE,        //civil car license plate of form 02
    VCA_WJPOLICE_PLATE,            //Armed police car 
    VCA_JINGCHE_PLATE,            //Police car
    STANDARD92_BACK_PLATE,      //Dual-line rear plate of civil car
    VCA_SHIGUAN_PLATE,          //Embassy license plate
    VCA_NONGYONG_PLATE,         //Agricultural vehicles
    VCA_MOTO_PLATE,              //Motorcycle
    NEW_ENERGY_PLATE,             //new Energy Plate
    //2017-05-18 add The Middle East Plate Type
    TRANSPORT_PLATE = 0x20,     //Transport
    COMMERCIAL_PLATE,           //Commercial
    PRIVATE_PLATE,              //Private car
    LEARNING_PLATE,             //Learning
    CD_PLATE,                   //Embassy car(CD)
    CC_PLATE,                   //Embassy car(CC)
    ARMY_PLATE,                 //military car
    PROTOCOL_PLATE,             //PROTOCOL
    GOVERNMENT_PLATE,           //Government Car
    EXPORT_PLATE,               //EXPORT
    TAXI_PLATE,                 //Taxi
    TESTING_PLATE,              //TESTING
    TRANSFER_PLATE,             //TRANSFER
    TRUCK_PLATE,                //TRUCK
    BUS_PLATE,                  //BUS
    PUBLIC_PLATE,               //PUBLIC
    PUB_TRANS_PLATE,            //PUBLIC TRANSFER
    PRI_TRANS_PLATE,            //PRIVATE TRANSPORT
    UNKNOWN_PLATE = 0xff,       //Unknown(Unrecognized)
}VCA_PLATE_TYPE;

//Vehicle Color
typedef enum _VCR_CLR_CLASS
{
    VCR_CLR_UNSUPPORT = 0,      //Not supported
    VCR_CLR_WHITE = 1,   //White
    VCR_CLR_SILVER = 2,   //Silver
    VCR_CLR_GRAY = 3,      //Gray
    VCR_CLR_BLACK = 4,      //Black
    VCR_CLR_RED = 5,      //Red
    VCR_CLR_DARKBLUE = 6,      //Darkblue
    VCR_CLR_BLUE = 7,      //Blue
    VCR_CLR_YELLOW = 8,      //Yellow
    VCR_CLR_GREEN = 9,      //Green
    VCR_CLR_BROWN = 10,  //Brown
    VCR_CLR_PINK = 11,  //Pink
    VCR_CLR_PURPLE = 12,  //Purple
    VCR_CLR_DARKGRAY = 13,  //Darkgray
    VCR_CLR_CYAN = 14   //Cyan
}VCR_CLR_CLASS;

//Vehicle Operate Type 2013-11-04
typedef enum _VCA_OPERATE_TYPE_
{
    VCA_LICENSE_TYPE = 0x1,  //License
    VCA_PLATECOLOR_TYPE = 0x2,  //Plate Color
    VCA_CARDNO_TYPE = 0x4,  //Card No
    VCA_PLATETYPE_TYPE = 0x8,  //Plate Type
    VCA_LISTTYPE_TYPE = 0x10, //List Type
    VCA_INDEX_TYPE = 0x20,  //Data Index
    VCA_OPERATE_INDEX_TYPE = 0x40   //Operate Index Type 2014-03-03
}VCA_OPERATE_TYPE;

typedef enum _VCA_ILLEGAL_TYPE_
{
    VCA_POSTPIC_TYPE = 0x1,
    VCA_LOWSPEED_TYPE = 0x2,
    VCA_HIGHSPEED_TYPE = 0x4,
    VCA_RETROGRADE_TYPE = 0x8,
    VCA_RUSH_REDLIGHT_TYPE = 0x10,
    VCA_PRESS_LANE_TYPE = 0x20,
    VCA_VIOLATE_GUIDE_TYPE = 0x40,
    VCA_ROAD_STRAND_TYPE = 0x80,
    VCA_VEHICLE_ILLEGAL_LANE_TYPE = 0x100,
    VCA_ILLEGAL_LANE_CHANGE_TYPE = 0x200,
    VCA_ILLEGAL_LANE_DRIVE_TYPE = 0x400,
    VCA_VIOLATE_BAN_TYPE = 0x800,
    VCA_CROSS_PARKING_TYPE = 0x1000,
    VCA_GREEN_PARKING_TYPE = 0x2000
}VCA_ILLEGAL_TYPE;

typedef enum _VCA_VEHICLE_TYPE_
{
    VCA_OTHER_TYPE = 0x1,
    VCA_SMALLCAR_TYPE = 0x2,
    VCA_BIGCAR_TYPE = 0x4,
    VCA_BUS_TYPE = 0x8,
    VCA_TRUCK_TYPE = 0x10,
    VCA_CAR_TYPE = 0x20,
    VCA_MINIBUS_TYPE = 0x40,
    VCA_SMALL_TRUCK_TYPE = 0x80
}VCA_VEHICLE_TYPE;

typedef enum _VLR_VEHICLE_CLASS
{
    VLR_OTHER = 0,
    VLR_VOLKSWAGEN = 1,
    VLR_BUICK = 2,
    VLR_BMW = 3,
    VLR_HONDA = 4,
    VLR_PEUGEOT = 5,
    VLR_TOYOTA = 6,
    VLR_FORD = 7,
    VLR_NISSAN = 8,
    VLR_AUDI = 9,
    VLR_MAZDA = 10,
    VLR_CHEVROLET = 11,
    VLR_CITROEN = 12,
    VLR_HYUNDAI = 13,
    VLR_CHERY = 14,
    VLR_KIA = 15,
    VLR_ROEWE = 16,
    VLR_MITSUBISHI = 17,
    VLR_SKODA = 18,
    VLR_GEELY = 19,
    VLR_ZHONGHUA = 20,
    VLR_VOLVO = 21,
    VLR_LEXUS = 22,
    VLR_FIAT = 23,
    VLR_EMGRAND = 24,
    VLR_DONGFENG = 25,
    VLR_BYD = 26,
    VLR_SUZUKI = 27,
    VLR_JINBEI = 28,
    VLR_HAIMA = 29,
    VLR_SGMW = 30,
    VLR_JAC = 31,
    VLR_SUBARU = 32,
    VLR_ENGLON = 33,
    VLR_GREATWALL = 34,
    VLR_HAFEI = 35,
    VLR_ISUZU = 36,
    VLR_SOUEAST = 37,
    VLR_CHANA = 38,
    VLR_FOTON = 39,
    VLR_XIALI = 40,
    VLR_BENZ = 41,
    VLR_FAW = 42,
    VLR_NAVECO = 43,
    VLR_LIFAN = 44,
    VLR_BESTURN = 45,
    VLR_CROWN = 46,
    VLR_RENAULT = 47,
    VLR_JMC = 48,
    VLR_MG = 49,
    VLR_KAMA = 50,
    VLR_ZOTYE = 51,
    VLR_CHANGHE = 52,
    VLR_XMKINGLONG = 53,
    VLR_HUIZHONG = 54,
    VLR_SZKINGLONG = 55,
    VLR_HIGER = 56,
    VLR_YUTONG = 57,
    VLR_CNHTC = 58,
    VLR_BEIBEN = 59,
    VLR_XINGMA = 60,
    VLR_YUEJIN = 61,
    VLR_HUANGHAI = 62,
    VLR_OLDWALL = 63,
    VLR_CHANACOMMERCIAL = 64,
    VLR_PORSCHE = 65,
    VLR_CADILLAC = 66,
    VLR_INFINITI = 67,
    VLR_GLEAGLE = 68,
    VLR_JEEP = 69,
    VLR_LANDROVER = 70,
    VLR_CHANGFENG = 71,
    VLR_BENNI = 72,
    VLR_ERA = 73,
    VLR_TAURUS = 74,
    VLR_EADO = 75,
    VLR_SHANQI = 76,
    VLR_HONGYAN = 77,
    VLR_DRAGON = 78,
    VLR_JACTEXT = 79,
    VLR_JACBUS = 80,
    VLR_ANKAI = 81,
    VLR_SHENLONG = 82,
    VLR_DAEWOO = 83,
    VLR_WUZHENG = 84,
    VLR_MAN = 85,
    VLR_ZHONGTONG = 86,
    VLR_BAOJUN = 87,
    VLR_BQWEIWANG = 88,
    VLR_TRUMPCHE = 89,
    VLR_LUFENG = 90,
    VLR_HMZHENGZHOU = 91,
    VLR_BEIJING = 92,
    VLR_ZHONGSHUN = 93,
    VLR_WEILIN = 94,
    VLR_OPEL = 95,
    VLR_KARRY = 96,
    VLR_SMA = 97,
    VLR_SMATEXT = 98,
    VLR_YUWIN = 99,
    VLR_MINI = 100,
    VLR_MARK = 101,
    VLR_HAVAL = 102,
    VLR_OGA = 103,
    VLR_VENUCIA = 104,
    VLR_BYD2 = 105,
    VLR_SMART = 106,
    VLR_BAW = 107,
    VLR_LUXGEN = 108,
    VLR_YEMA = 109,
    VLR_ZTE = 110,
    VLR_EVERUS = 111,
    VLR_CHRYSLER = 112,
    VLR_GONOW = 113,
    VLR_SHJIANG = 114,
    VLR_RUILIN = 115,
    VLR_FORTA = 116,
    VLR_GAGUAR = 117,
    VLR_HEIBAO = 118,
    VLR_TKING = 119,
    VLR_TKINGTEXT = 120,
    VLR_FODAY = 121,
    VLR_LOTUS = 122,
    VLR_NANJUN = 123,
    VLR_SHUANGHUAN = 124,
    VLR_SAIBAO = 125,
    VLR_HAWTAI = 126,
    VLR_LIFO = 127,
    VLR_JONWAY = 128,
    VLR_FULONGMA = 129,
    VLR_WEILI = 130,
    VLR_ANCHI = 131,
    VLR_PAIXI = 132,
    VLR_HIGERTEXT = 133,
    VLR_RIYECAR = 134,
    VLR_RIYETRUCK = 135,
    VLR_JIANGNAN = 136,
    VLR_OLDZOTYE = 137,
    VLR_OLDXIALI = 138,
    VLR_NEWAOCHI = 139,
    VLR_CDW = 140,
    VLR_CDWTEXT = 141,
    VLR_CIIMO = 142,
    VLR_CHANADS = 143,
    VLR_DS = 144,
    VLR_ROHENS = 145,
    VLR_YANTAI = 146,
    VLR_SHUANGLONG = 147,
    VLR_FENGLING = 148,
    VLR_XINKAI = 149,
    VLR_GMC = 150,
    VLR_DATONG = 151,
    VLR_BQYINXIANG = 152,
    VLR_NEWCHERY = 153,
    VLR_MUDAN = 154,
    VLR_DAYUN = 155,
    VLR_DONGWO = 156,
    VLR_UNION = 157,
    VLR_CHUNZHOU = 158,
    VLR_SANY = 159,
    VLR_YAXING = 160,
    VLR_HENGTONG = 161,
    VLR_SHAOLIN = 162,
    VLR_YOUNG = 163,
    VLR_STOM = 164,
    VLR_SANHUAN = 165,
    VLR_XUGONG = 166,
    VLR_BEIFANG = 167,
    VLR_JIANGHUAN = 168,
    VLR_BJFARM = 169,
    VLR_NEWDADI = 170,
    VLR_SUNWIN = 171,
    VLR_YINGTIAN = 172,
    VLR_QINGQI = 173,
    VLR_CHUFENG = 174,
    VLR_SCANIA = 175,
    VLR_JIULONG = 176,
    VLR_YOUYI = 177,
    VLR_SHANGRAO = 178,
    VLR_JIJIANG = 179,
    VLR_YANGZI = 180,
    VLR_XIWO = 181,
    VLR_CHANGJIANG = 182,
    VLR_WUYI = 183,
    VLR_CHENGDU = 184,
    VLR_TIANMA = 185,
    VLR_BAOLONG = 186,
    VLR_NEWYATU = 187,
    VLR_BARUI = 188,
    VLR_GUANZHI = 189,
    VLR_XIYATE = 190,
    VLR_BINLI = 191,
    VLR_DADI = 192,
    VLR_FUQI = 193,
    VLR_HANGTIAN = 194,
    VLR_HENGTIAN = 195,
    VLR_JMCCAR = 196,
    VLR_KAERSEN = 197,
    VLR_KAWEI = 198,
    VLR_LANBOJINI = 199,
    VLR_MASHALADI = 200,
    VLR_SHUCHI = 201,
    VLR_SHILI = 202,
    VLR_HUABEI = 203,
    VLR_YIZHENG = 204,
    VLR_CHUNLAN = 205,
    VLR_DAFA = 206,
    VLR_SHENYE = 207,
    VLR_FALALI = 208,
    VLR_FUXING = 209,
    VLR_ANYUAN = 210,
    VLR_JINGHUA = 211,
    VLR_TAIHU = 212,
    VLR_WUZHOULONG = 213,
    VLR_CHANGLONG = 214,
    VLR_YUEXI = 215,
    VLR_SHENMA = 216,
    VLR_LUSHAN = 217,
    VLR_WANFENG = 218,
    VLR_GZYUNBAO = 219,
    VLR_ZHONGDA = 220,
    VLR_THREEWHEEL = 221,
    VLR_TWOWHEEL = 222,
    VLR_JBC = 223,
    VLR_YZJIANG = 224,
    VLR_CNJ = 225,
    VLR_FORLAND = 226,
    VLR_FARMCAR = 227,
    VLR_DONGFANGHONG = 228,
    VLR_STEYR = 229,
    VLR_HONGQI = 230,
    VLR_USER1 = 231,
    VLR_USER2 = 232,
    VLR_USER3 = 233,
    VLR_USER4 = 234,
    VLR_USER5 = 235,
    VLR_USER6 = 236,
    VLR_USER7 = 237,
    VLR_USER8 = 238
}VLR_VEHICLE_CLASS;

/********************Vehicle Brand Sub Type Begin*************************/
//VOLKSWAGEN
typedef enum _VSB_VOLKSWAGEN_CLASS
{
    VSB_VOLKSWAGEN_OTHER = 0,
    VSB_VOLKSWAGEN_LAVIDA = 1,
    VSB_VOLKSWAGEN_CROSSLAVIDA = 2,
    VSB_VOLKSWAGEN_TIGUAN = 3,
    VSB_VOLKSWAGEN_TOURAN = 4,
    VSB_VOLKSWAGEN_SANTANA = 5,
    VSB_VOLKSWAGEN_SANTANA2000 = 6,
    VSB_VOLKSWAGEN_SANTANA3000 = 7,
    VSB_VOLKSWAGEN_VISTA = 8,
    VSB_VOLKSWAGEN_PASSAT = 9,
    VSB_VOLKSWAGEN_PASSATLINGYU = 10,
    VSB_VOLKSWAGEN_POLO = 11,
    VSB_VOLKSWAGEN_POLOCROSS = 12,
    VSB_VOLKSWAGEN_POLOGTI = 13,
    VSB_VOLKSWAGEN_SAGITAR = 14,
    VSB_VOLKSWAGEN_MAGOTAN = 15,
    VSB_VOLKSWAGEN_JETTA = 16,
    VSB_VOLKSWAGEN_BORA = 17,
    VSB_VOLKSWAGEN_NEWGOLF = 18,
    VSB_VOLKSWAGEN_GOLFGTI = 19,
    VSB_VOLKSWAGEN_GOL = 20,
    VSB_VOLKSWAGEN_CADDY = 21,
    VSB_VOLKSWAGEN_PHAETON = 22,
    VSB_VOLKSWAGEN_TOUREG = 23,
    VSB_VOLKSWAGEN_SCIROCCO = 24,
    VSB_VOLKSWAGEN_BEETLE = 25,
    VSB_VOLKSWAGEN_SHARAN = 26,
    VSB_VOLKSWAGEN_MULTIVAN = 27,
    VSB_VOLKSWAGEN_CARBONCOPY = 28,
    VSB_VOLKSWAGEN_VISTACHANGDA = 29,
    VSB_VOLKSWAGEN_BORASPORTLINE = 30,
    VSR_VOLKSWAGEN_CC_1 = 31,
    VSR_VOLKSWAGEN_Cross_POLO_1 = 32,
    VSR_VOLKSWAGEN_Cross_POLO_2 = 33,
    VSR_VOLKSWAGEN_MULTIVAN_1 = 34,
    VSR_VOLKSWAGEN_POLO_1 = 35,
    VSR_VOLKSWAGEN_POLO_2 = 36,
    VSR_VOLKSWAGEN_POLO_JINQU_1 = 37,
    VSR_VOLKSWAGEN_POLO_JINQU_2 = 38,
    VSR_VOLKSWAGEN_Tiguan_1 = 39,
    VSR_VOLKSWAGEN_Tiguan_2 = 40,
    VSR_VOLKSWAGEN_XIALANG_1 = 41,
    VSR_VOLKSWAGEN_BAOLAI_1 = 42,
    VSR_VOLKSWAGEN_BAOLAI_2 = 43,
    VSR_VOLKSWAGEN_BAOLAI_3 = 44,
    VSR_VOLKSWAGEN_BAOLAI_4 = 45,
    VSR_VOLKSWAGEN_SHANGKU_1 = 46,
    VSR_VOLKSWAGEN_PASATE_1 = 47,
    VSR_VOLKSWAGEN_PASATE_2 = 48,
    VSR_VOLKSWAGEN_PASATE_3 = 49,
    VSR_VOLKSWAGEN_PASATE_4 = 50,
    VSR_VOLKSWAGEN_PASATE_5 = 51,
    VSR_VOLKSWAGEN_JIEDA_1 = 52,
    VSR_VOLKSWAGEN_JIEDA_2 = 53,
    VSR_VOLKSWAGEN_JIEDA_3 = 54,
    VSR_VOLKSWAGEN_JIEDA_4 = 55,
    VSR_VOLKSWAGEN_LANGYI_1 = 56,
    VSR_VOLKSWAGEN_LANGYI_2 = 57,
    VSR_VOLKSWAGEN_SANGTANA_1 = 58,
    VSR_VOLKSWAGEN_SANGTANA_2 = 59,
    VSR_VOLKSWAGEN_SANGTANA_3 = 60,
    VSR_VOLKSWAGEN_SANGTANA_4 = 61,
    VSR_VOLKSWAGEN_SANGTANAZHIJUN_1 = 62,
    VSR_VOLKSWAGEN_SANGTANAZHIJUN_2 = 63,
    VSR_VOLKSWAGEN_JIAKECHONG_1 = 64,
    VSR_VOLKSWAGEN_JIAKECHONG_2 = 65,
    VSR_VOLKSWAGEN_HUITENG_2 = 66,
    VSR_VOLKSWAGEN_MAITENG_1 = 67,
    VSR_VOLKSWAGEN_MAITENG_2 = 68,
    VSR_VOLKSWAGEN_TUAN_3 = 69,
    VSR_VOLKSWAGEN_TUAN_1 = 70,
    VSR_VOLKSWAGEN_TUAN_2 = 71,
    VSR_VOLKSWAGEN_TUGUAN_1 = 72,
    VSR_VOLKSWAGEN_TURUI_1 = 73,
    VSR_VOLKSWAGEN_TURUI_2 = 74,
    VSR_VOLKSWAGEN_SUTENG_1 = 75,
    VSR_VOLKSWAGEN_SUTENG_2 = 76,
    VSR_VOLKSWAGEN_SUTENG_3 = 77,
    VSR_VOLKSWAGEN_GAOERFU_1 = 78,
    VSR_VOLKSWAGEN_GAOERFU_2 = 79,
    VSR_VOLKSWAGEN_GAOERFU_3 = 80,
    VSR_VOLKSWAGEN_LANGYI_3 = 81,
    VSR_VOLKSWAGEN_HUITENG_1 = 82
} VSB_VOLKSWAGEN_CLASS;


typedef enum _VBR_BUICK_CLASS
{
    VBR_BUICK_OTHER = 0,
    VBR_BUICK_ENCORE = 1,
    VBR_BUICK_GL8 = 2,
    VBR_BUICK_LEGAL = 3,
    VBR_BUICK_LACROSS = 4,
    VBR_BUICK_EXCELLE = 5,
    VBR_BUICK_EXCELLEGT = 6,
    VBR_BUICK_WXCELLEXT = 7,
    VBR_BUICK_ENCLAVE = 8,
    VBR_BUICK_ROYAUM = 9,
    VBR_BUICK_SAIL = 10,
    VBR_BUICK_EXCELLEHRV = 11,
    VBR_BUICK_PARKAVENUE = 12,
    VBR_BUICK_CENTURY = 13,
    VBR_BUICK_GL8_1 = 14,
    VBR_BUICK_GL8_2 = 15,
    VBR_BUICK_GL8_3 = 16,
    VBR_BUICK_GL8_4 = 17,
    VBR_BUICK_GL8_5 = 18,
    VBR_BUICK_ENCORE_1 = 19,
    VBR_BUICK_ENCLAVE_1 = 20,
    VBR_BUICK_LEGAL_1 = 21,
    VBR_BUICK_LEGAL_2 = 22,
    VBR_BUICK_LEGAL_3 = 23,
    VBR_BUICK_LEGAL_4 = 24,
    VBR_BUICK_LEGAL_5 = 25,
    VBR_BUICK_LEGAL_6 = 26,
    VBR_BUICK_LACROSS_1 = 27,
    VBR_BUICK_LACROSS_2 = 28,
    VBR_BUICK_LACROSS_3 = 29,
    VBR_BUICK_EXCELLE_1 = 30,
    VBR_BUICK_EXCELLE_2 = 31,
    VBR_BUICK_EXCELLE_3 = 32,
    VBR_BUICK_EXCELLE_4 = 33,
    VBR_BUICK_PARKAVENUE_1 = 34,
    VBR_BUICK_SAIL_1 = 35,
    VBR_BUICK_EXCELLEGT_1 = 36,
    VBR_BUICK_WXCELLEXT_1 = 37,
    VBR_BUICK_CENTURY_1 = 38,
    VBR_BUICK_RONGYU_1 = 39
}VBR_BUICK_CLASS;


typedef enum _VSB_BMW_CLASS
{
    VSB_BMW_OTHER = 0,
    VSB_BMW_3SERIES = 1,
    VSB_BMW_5SERIES = 2,
    VSB_BMW_X1 = 3,
    VSB_BMW_1SERIES = 4,
    VSB_BMW_7SERIES = 5,
    VSB_BMW_X3 = 6,
    VSB_BMW_X5 = 7,
    VSB_BMW_X6 = 8,
    VSB_BMW_Z4 = 9,
    VSB_BMW_MINI = 10,
    VSB_BMW_6SERIES = 11,
    VSB_BMW_YIXI_1 = 12,
    VSB_BMW_YIXI_2 = 13,
    VSB_BMW_SANXI_1 = 14,
    VSB_BMW_SANXI_2 = 15,
    VSB_BMW_SANXI_3 = 16,
    VSB_BMW_SANXI_4 = 17,
    VSB_BMW_WUXI_1 = 18,
    VSB_BMW_WUXI_2 = 19,
    VSB_BMW_LIUXI_1 = 20,
    VSB_BMW_QIXI_1 = 21,
    VSB_BMW_QIXI_2 = 22,
    VSB_BMW_X1_1 = 23,
    VSB_BMW_X1_2 = 24,
    VSB_BMW_X3_1 = 25,
    VSB_BMW_X3_2 = 26,
    VSB_BMW_X5_1 = 27,
    VSB_BMW_X5_2 = 28,
    VSB_BMW_X5_3 = 29,
    VSB_BMW_X6_1 = 30,
    VSB_BMW_Z4_1 = 31
}VSB_BMW_CLASS;


typedef enum _VSB_HONDA_CLASS
{
    VSB_HONDA_OTHER = 0,
    VSB_HONDA_CRV = 1,
    VSB_HONDA_JADE = 2,
    VSB_HONDA_CIVIC = 3,
    VSB_HONDA_SPIRIOR = 4,
    VSB_HONDA_CIIMO = 5,
    VSB_HONDA_ELYSION = 6,
    VSB_HONDA_OBYSSEY = 7,
    VSB_HONDA_FIT = 8,
    VSB_HONDA_NEWCITY = 9,
    VSB_HONDA_CROSSTOUR = 10,
    VSB_HONDA_CRIDER = 11,
    VSB_HONDA_ACCORD = 12,
    VSB_HONDA_CITY = 13,
    VSB_HONDA_ANTILOCK = 14,
    VSB_HONDA_CRZ = 15,
    VSB_HONDA_CRV_1 = 16,
    VSB_HONDA_CRV_2 = 17,
    VSB_HONDA_CRV_3 = 18,
    VSB_HONDA_CRV_4 = 19,
    VSB_HONDA_CRV_5 = 20,
    VSB_HONDA_CRIDER_1 = 21,
    VSB_HONDA_OBYSSEY_1 = 22,
    VSB_HONDA_OBYSSEY_2 = 23,
    VSB_HONDA_OBYSSEY_3 = 24,
    VSB_HONDA_OBYSSEY_4 = 25,
    VSB_HONDA_CIVIC_1 = 26,
    VSB_HONDA_CIVIC_5 = 27,
    VSB_HONDA_CIVIC_2 = 28,
    VSB_HONDA_CIVIC_3 = 29,
    VSB_HONDA_CIVIC_4 = 30,
    VSB_HONDA_CITY_1 = 31,
    VSB_HONDA_SPIRIOR_1 = 32,
    VSB_HONDA_SIMING_1 = 33,
    VSB_HONDA_JIEDE_1 = 34,
    VSB_HONDA_CROSSTOUR_1 = 35,
    VSB_HONDA_AILISHEN_1 = 36,
    VSB_HONDA_NEWCITY_1 = 37,
    VSB_HONDA_NEWCITY_2 = 38,
    VSB_HONDA_NEWCITY_3 = 39,
    VSB_HONDA_ACCORD_1 = 40,
    VSB_HONDA_ACCORD_2 = 41,
    VSB_HONDA_ACCORD_3 = 42,
    VSB_HONDA_ACCORD_4 = 43,
    VSB_HONDA_ACCORD_5 = 44,
    VSB_HONDA_ACCORD_6 = 45,
    VSB_HONDA_ACCORD_7 = 46,
    VSB_HONDA_ACCORD_8 = 47,
    VSB_HONDA_ACCORD_9 = 48,
    VSB_HONDA_ACCORD_10 = 49,
    VSB_HONDA_FIT_1 = 50,
    VSB_HONDA_FIT_2 = 51,
    VSB_HONDA_FIT_3 = 52,
    VSB_HONDA_FIT_4 = 53,
    VSB_HONDA_FIT_5 = 54,
    VSB_HONDA_FIT_6 = 55
}VSB_HONDA_CLASS;


typedef enum _VSB_PEUGEOT_CLASS
{
    VSB_PEUGEOT_OTHER = 0,
    VSB_PEUGEOT_2008 = 1,
    VSB_PEUGEOT_207 = 2,
    VSB_PEUGEOT_SENNA = 3,
    VSB_PEUGEOT_3008 = 4,
    VSB_PEUGEOT_301 = 5,
    VSB_PEUGEOT_307 = 6,
    VSB_PEUGEOT_308 = 7,
    VSB_PEUGEOT_408 = 8,
    VSB_PEUGEOT_508 = 9,
    VSB_PEUGEOT_206 = 10,
    VSB_PEUGEOT_407 = 11,
    VSB_PEUGEOT_206_1 = 12,
    VSB_PEUGEOT_207_1 = 13,
    VSB_PEUGEOT_207_2 = 14,
    VSB_PEUGEOT_3008_1 = 15,
    VSB_PEUGEOT_301_1 = 16,
    VSB_PEUGEOT_307_1 = 17,
    VSB_PEUGEOT_307_2 = 18,
    VSB_PEUGEOT_307_3 = 19,
    VSB_PEUGEOT_308_1 = 20,
    VSB_PEUGEOT_407_1 = 21,
    VSB_PEUGEOT_408_1 = 22,
    VSB_PEUGEOT_408_2 = 23,
    VSB_PEUGEOT_508_1 = 24,
    VSB_PEUGEOT_207_3 = 25,
    VSB_PEUGEOT_307_4 = 26

}VSB_PEUGEOT_CLASS;


typedef enum _VSB_TOYOTA_CLASS
{
    VSB_TOYOTA_OTHER = 0,
    VSB_TOYOTA_HIGHLANDER = 1,
    VSB_TOYOTA_CAMRY = 2,
    VSB_TOYOTA_YARIS = 3,
    VSB_TOYOTA_YARISL = 4,
    VSB_TOYOTA_VERSO = 5,
    VSB_TOYOTA_HUAGUAN = 6,
    VSB_TOYOTA_CROWN = 7,
    VSB_TOYOTA_COROLLA = 8,
    VSB_TOYOTA_COSTER = 9,
    VSB_TOYOTA_PRADO = 10,
    VSB_TOYOTA_PRIUS = 11,
    VSB_TOYOTA_RAV4 = 12,
    VSB_TOYOTA_REZI = 13,
    VSB_TOYOTA_VIOS = 14,
    VSB_TOYOTA_PREVIA = 15,
    VSB_TOYOTA_HIACE = 16,
    VSB_TOYOTA_86 = 17,
    VSB_TOYOTA_SPEQUOIA = 18,
    VSB_TOYOTA_LANDCRUISER = 19,
    VSB_TOYOTA_SIENNA = 20,
    VSB_TOYOTA_CAMRYHYBRID = 21,
    VSB_TOYOTA_GRACE = 22,
    VSB_TOYOTA_ALPHARD = 23,
    VSB_TOYOTA_RA