// CPicture.h: interface for the CPicture class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PICTURE_H__081D008A_5029_4C56_B80C_37793E323DF6__INCLUDED_)
#define AFX_PICTURE_H__081D008A_5029_4C56_B80C_37793E323DF6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <afxctl.h>
//------------------------------------------

typedef enum
{
	OFM_WRITE        = 0,
	OFM_READ         = 1
}FILE_OPENMODE;

#define HIMETRIC_INCH 2540

//=-----------------------------
class CFileProcess
{
private :
	FILE  *m_File;

public:
	CFileProcess();
   ~CFileProcess();
    BOOL	Open        (char * FileName , FILE_OPENMODE Open_Mode);
	BOOL	Write       (VOID * zBuffer, DWORD cSize);
    BOOL	Read        (VOID * zBuffer, DWORD cSize);
	LONG    GetSize     (VOID);
	VOID    Close       (VOID);
};

//-------------------------------------------------------------


//-----------------------------------------
class CPicture  
{
public:
	CPicture();
	virtual ~CPicture();
	
private:
	IPicture *m_pic;
	HGLOBAL  hGlobal;
	LPPICTURE m_pPict;

public:

	HBITMAP LoadPicture(char * FileName);
	HBITMAP LoadPicture(char * FileName, HDC hdc);
	HBITMAP LoadPicture(char *FileName, HDC hdc, long cx, long cy);
	VOID    FreePicture( VOID );
    HDC     _GetDC     ( VOID );
	HBITMAP _GetHandle ( VOID );
	DWORD   _GetWidth  ( VOID );
	DWORD   _GetHeight ( VOID );
	BOOL    DrawPicture(HDC hdc,long x,long y,long cx,long cy);
	void Render(CDC* pDC, LPRECT pDrawRect/*ĿΣλ߼굥λ*/, LPRECT 
		
		
		
		pSrcRect=NULL/*ԴΣλ0.01,ΪգͼĿ*/,LPCRECT prcWBounds=NULL/*ͼԪļרã󶨾*/);//ڸDCϻͼ


};

class CPicture_Ex:public CPictureHolder  
{
public:
	BOOL Load(CString sFilePathName);//ļȡͼ
	BOOL Load(HINSTANCE hInstance,LPCTSTR lpszResourceName, LPCSTR ResourceType);//Դȡͼ
	BOOL LoadPictureData(BYTE* pBuffer, int nSize);//ڴȡͼ
	BOOL SaveAsBitmap(CString sFilePathName);//д뵽BMPļ
	void Render(CDC* pDC, LPRECT pDrawRect/*ĿΣλ߼굥λ*/, LPRECT 
		
		
		
		pSrcRect=NULL/*ԴΣλ0.01,ΪգͼĿ*/,LPCRECT prcWBounds=NULL/*ͼԪļרã󶨾*/);//ڸDCϻͼ
	CPicture_Ex();
	virtual ~CPicture_Ex();
	void  UnloadPicture();//ͷͼͬCPictureHolder::~CPictureHolder()
public:
	LONG      get_Height(); // 0.01Ϊλͼ߶
	LONG      get_Width();  // 0.01Ϊλͼ
};

#endif // !defined(AFX_PICTURE_H__081D008A_5029_4C56_B80C_37793E323DF6__INCLUDED_)
