﻿/**
* @constructor
* @extend {aui.ui.Dialog.DialogBase}
*/
aui.ui.Dialog.Panel = function(options) {
    this.options = {
        className: 'aui-ui-Dialog-Panel',
        title: null,
        content: '',
        buttons: aui.ui.Dialog.ButtonSet.CancelOK,
        defaultButton: aui.ui.Dialog.DialogResult.OK, //null
        defaultButtonHidden: false,
        defaultButtonLocation: true,
        topButtons: false,
        width: '500',
        height: '300',
        showMessage: false  //show error message
    }

    this.options = aui.lang.merge(this.options, options || {});
    this.title = this.options.title;
    this.content = this.options.content;
    this.buttons = this.options.buttons;
    this.topButtons = this.options.topButtons;
    this.defaultButton = this.options.defaultButton;
    this.width = new String(this.options.width).replace("px", "");
    this.height = new String(this.options.height).replace("px", "");
    this.showMessage = this.options.showMessage;
    this.buttonList = [];

    var me = this;

    this.prepareDialog = function(nodeToAppend) {
        if (this.title)
            this.dTitle = NewObj("div", "dialog-service-title", this.title);
        var dframe = NewObj("iframe", "dialog-service-frame");
        
        this.dButtonsTop = NewObj("div", "dialog-service-buttons-top");
        this.dButtons    = NewObj("div", "dialog-service-buttons");

        this.dContent = NewObj("div", "dialog-service-content");
        if(this.showMessage)
            this.dMessage = NewObj("div", "dialog-service-message");
        
//        if(this.title){
//            this.dContent.style.height = (this.height - ((this.topButtons) ? 150 : 120)) + "px";
//        }
//        else{
//            this.dContent.style.height = (this.height - ((this.topButtons) ? 115 : 85)) + "px";
//        }
        var height = (this.height - (this.title?35:0) - (this.topButtons?110:80) - (this.showMessage?26:0));
        this.dContent.style.height = (height > 0? height: 0) +"px";
        
        dframe.frameBorder = 0;

        this.buttonList = [];
        
        if(!this.options.defaultButtonHidden){
            this.pvtInsertButton();
        }
        else{
            this.defaultButton = null;
        }
        
        this.refresh();

        if (this.content) {
            if (this.content instanceof aui.ui.ControlBase)
                this.content.render(this.dContent);
            else {
                if (this.content[0]) {
                    for (var i in this.content)
                        this.dContent.appendChild(this.content[i]);
                } else {
                    this.dContent.appendChild(this.content);
                }
            }
        }

        var container = NewObj("div", "dialog-service-container");

        if(this.dTitle) container.appendChild(this.dTitle);
        if(this.topButtons) container.appendChild(this.dButtonsTop);
        
        container.appendChild(this.dContent);
        if(this.showMessage) container.appendChild(this.dMessage);
        container.appendChild(this.dButtons);
        container.appendChild(dframe);

        nodeToAppend.appendChild(container);
    }
    aui.ui.Dialog.Panel.superclass.constructor.call(this, this.options);
}
aui.lang.Class.extend(aui.ui.Dialog.Panel, aui.ui.Dialog.DialogBase, {
    setContent: function(content) {
        if (this.content) {
            try {
                if (this.content instanceof aui.ui.ControlBase)
                    this.dContent.removeChild(this.content._managedNode);
                else
                    this.dContent.removeChild(this.content);
            } catch (e) { }
        }
        this.content = content;

        if (this.content instanceof aui.ui.ControlBase)
            this.content.render(this.dContent);
        else
            this.dContent.appendChild(this.content);

    },

    setTitle: function(title) {
        if (this.title) {
            this.dTitle.innerText = title;
        }
    },

    setButton: function(buttons) {
        if (this.buttons) {
            try {
                for (var i in this.buttonList) {
                    var obj = this.buttonList[i];
                    obj.unrender(this.dButtons);
                }
                this.buttonList = [];
            } catch (e) { }
        }
        this.buttons = buttons;

        this.pvtInsertButton();
        this.refresh();
    },
    
    setMessage: function(message){
        if (this.showMessage) {
            if (!this.msgText) { //[Bug 14883]將訊息存在靠左的容器中.(Leo modify 20121129)
                this.msgText = NewObj("div", "msg-text");
                this.dMessage.appendChild(this.msgText);
            }
            this.msgText.innerText = message;
        }
    },

    pvtInsertButton: function() {
        var me = this;
        if (this.buttons) {
            for (var index in this.buttons) {
                var classname = this.buttons.join("") + "-" + this.buttons[index];
                var dButton = new aui.nvr.ui.CheckButton({
                    //                var dButton = new aui.nvr.ui.Button({
                    //                        className:"button "+classname ,
                    caption: LangText("TXT_" + this.buttons[index])
                });
                dButton.dialogType = classname;
                if (me.defaultButton == aui.ui.Dialog.DialogResult[this.buttons[index]]) dButton.setActivation(true);
                this.buttonList.push(dButton);

                dButton.onclick.subscribe(function(type, args, result) {
                    for (var i in me.buttons) {
                        if (me.buttons[i] == result) {
                            if (!me.buttonList[i].getEnable()) return;
                        }
                    }
                    me.setResult(aui.ui.Dialog.DialogResult[result]);
                }, this.buttons[index]);

                dButton.render(this.dButtons);
            }
        }
    },

    refresh: function() {
        aui.ui.Dialog.Panel.superclass.refresh.call(this);

        var totalW = 0;
        var reset = false;
        var maxWidth = Math.floor((this.width - (20*2) - Math.abs((this.buttonList.length - 1)) * 35)/this.buttonList.length);
        
        for (var index in this.buttonList) {
            var dButton = this.buttonList[index];
            //reset btn status
            var enable = dButton.getEnable();
            dButton.setEnable(enable);
            
            if(this.defaultButton && this.buttons[index]){
                if (this.defaultButton == aui.ui.Dialog.DialogResult[this.buttons[index]]) dButton.setActivation(true);
            }
            
            //get width
            var dButtonW = (dButton.getWidth() <= 100) ? 100 : (dButton.getWidth() + 1);
            totalW += dButtonW;
            if (index > 0 && this.options.defaultButtonLocation) dButton._managedNode.style.marginLeft = "35px";
            
            if(dButtonW >= maxWidth) reset = true;
        }
        
        if(reset){
            totalW = 0;
            for(var index in this.buttonList){
                var dButton = this.buttonList[index];
                    dButton.setWidth(maxWidth);
                totalW += maxWidth;
            }
        }
        
        if(this.options.defaultButtonLocation){
            totalW = totalW + Math.abs((this.buttonList.length - 1)) * (35+1);
            this.dButtons.style.width = totalW + "px";
        }
        else{
            this.dButtons.style.width = totalW + "px";
        }
    },

    showDialog: function(config) {
        aui.ui.Dialog.Panel.superclass.showDialog.call(this, config);

        if (this.content.load) {
            this.content.load();
        }
    },

    setHeight: function(height) {
        aui.ui.Dialog.Panel.superclass.setHeight.call(this, height);
        
//        if(this.topButtons){
//            this.dContent.style.height = (this.height - 155) + "px";
//        }
//        else{
//            this.dContent.style.height = (this.height - 120) + "px";
//        }
        //Judy modified for Bug 12766, IE8 does not support negative number
        var contentHeight = this.height - (this.title?35:0) - (this.topButtons?110:80) - (this.showMessage?26:0);
        this.dContent.style.height = (contentHeight > 0? contentHeight: 0) + "px";
        
        var buttonHeight = this.height - 45;
        this.dButtons.style.top = (buttonHeight > 0? buttonHeight: 0) + "px";
        this.refresh();
    },

    setWidth: function(width) {
        aui.ui.Dialog.Panel.superclass.setWidth.call(this, width);
        this.refresh();
    },
    
    setTitleHeight: function(height){
        
        if(height > 0) this.dTitle.style.height = height + "px";
        
        if(this.title){
            this.dContent.style.height = (this.height - ((this.topButtons) ? 120 : 90) - height) + "px";
            this.dContent.style.height = (this.height - (this.topButtons?110:80) - (this.showMessage?26:0) - height) + "px";
        }
    },
    
    addButton: function(btn){
        btn.render(this.dButtons);
        
        this.buttonList.push(btn);
        this.refresh();
    },
    
    addTopButton: function(btn){
        btn.render(this.dButtonsTop);
    }
});