﻿/**
 * <p>Image Button Control.</p>
 * <p>The image button control will render as two &lt;div&gt; element into 
 * target element with HTMLDom.appendChild() method. The relation of those
 * two element is as figures shown below:</p>
 * <p><img src="images/ui_Button.png"/></p>
 * <strong>The status of Button</strong>
 * <p>Normally, there are 3 different status of button, 1) Disabled, 2) 
 * Enabled 3) Actived. and in Enabled and Actived status, there are also
 * two different situation i) MouseOver, ii) MouseDown.
 * </p>
 * <strong>How to define images for each status</strong>
 * <p></p> 
 * @constructor
 */
aui.nvr.ui.Button = function(options) {
    this.options = {
        hint: "",
        className: "button",
        caption: "",
        enabled: true,
        using: false,
        capture: true,
        capturedElement: null,
        value: ""
    };
    this.options = aui.lang.merge(this.options, options || {});

    this._enabled = this.options.enabled;
    this._using = this.options.using;
    this._buttonBackground = null;

    this.className = this.options.className;
    this.hint = this.options.hint;
    this.value = this.options.value;
    
    aui.nvr.ui.Button.superclass.constructor.call(this);
};

aui.lang.Class.extend(aui.nvr.ui.Button, aui.ui.ControlBase, {
    setEnable: function(isEnable) {
        this._enabled = isEnable;
        this._buttonBackground.className = (this._enabled) ? "en" : "di";
        aui.nvr.ui.Button.superclass.setEnable.call(this, this._enabled);
    },

    getEnable: function() {
        return this._enabled;
    },

    setActivation: function(isUsing) {
        if (!this._enabled) return;
        this._using = isUsing;
        this._buttonBackground.className = (this._using) ? "us" : "en";
    },

    getActivation: function() {
        return this._using;
    },

    setCaption: function(caption) {
        while (this._buttonBackground.childNodes.length > 0)
            this._buttonBackground.removeChild(this._buttonBackground.firstChild);
        if (typeof caption == "string") {
            //bug 15284
            //this._buttonBackground.appendChild(Lang(caption));
            var font = document.createElement("div");
            font.className = "btn-text";
            font.innerText = caption;
            this._buttonBackground.appendChild(font);
        }else
            this._buttonBackground.appendChild(caption);
    },
    
    setCaption_v2: function(caption){
        if (typeof caption == "string")
            this._buttonBackground.innerText = caption;
    },

    prepareNode: function(nodeToAppend) {
        var me = this;
        this._buttonBackground = document.createElement("div");

        if (typeof this.options.caption == "string") {
            var font = document.createElement("div");
            font.className = "btn-text";
            font.innerHTML = this.options.caption;
            this._buttonBackground.appendChild(font);
        } else if (typeof this.options.caption == "object") {
            this.options.caption.className = "btn-text";
            this._buttonBackground.appendChild(this.options.caption);
        }
        //this._buttonBackground.innerHTML = this.options.caption;
        this._nodeToAppend = nodeToAppend;
        nodeToAppend.className = this.className;
        nodeToAppend.style.display = "inline-block";
        nodeToAppend.title = this.hint;
        //_buttonLayout.style.position = "absolute";
        this._buttonBackground.className = (this._enabled) ? "en" : "di";
        this._buttonBackground.style.display = "inline-block";
        this._buttonBackground.style.width = "100%";
        this._buttonBackground.style.height = "100%";

        //todo. VAL: aui.nvr.ui.Button繼承ControlBase, 事件透過ControlBase來處理較好。
        this._buttonBackground.onmouseover = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "um" : "mm";
        };
        this._buttonBackground.onmouseup = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "um" : ((window.event.srcElement == this) ? "mm" : "en");    //Albert Modify, Bug 11377, mouseup判斷是否在原DOM上
            if (me.options.capture)
                ((me.options.capturedElement) ? me.options.capturedElement : this).releaseCapture();
        };
        this._buttonBackground.onmousedown = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "ud" : "md";
            if (me.options.capture)
                ((me.options.capturedElement) ? me.options.capturedElement : this).setCapture();
        };
        this._buttonBackground.onmouseout = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "us" : "en";
        };

        nodeToAppend.appendChild(this._buttonBackground);
    },

    //todo. VAL: 用Controlbase的getClientRegion()取代它。
    pvtGetRegion: function() {
        return YAHOO.util.Dom.getRegion(this._managedNode);
    },
    
    setClassName: function(name){
        this._nodeToAppend.className = this.className = name;
    }
});

aui.nvr.ui.Button2 = function(options) {
    this.options = {
        hint: "",
        className: "button",
        title: "",
        desc: "",
        links: null,
        enabled: true,
        using: false,
        capture: true,
        capturedElement: null
    };
    this.options = aui.lang.merge(this.options, options || {});

    this._enabled = this.options.enabled;
    this._using = this.options.using;
    this._buttonBackground = null;

    this.className = this.options.className;
    this.hint = this.options.hint;

    aui.nvr.ui.Button2.superclass.constructor.call(this);
};

aui.lang.Class.extend(aui.nvr.ui.Button2, aui.ui.ControlBase, {
    setEnable: function(isEnable) {
        this._enabled = isEnable;
        this._buttonBackground.className = (this._enabled) ? "en" : "di";
        aui.nvr.ui.Button2.superclass.setEnable.call(this, this._enabled);
    },

    getEnable: function() {
        return this._enabled;
    },

    setActivation: function(isUsing) {
        if (!this._enabled) return;
        this._using = isUsing;
        this._buttonBackground.className = (this._using) ? "us" : "en";
    },

    getActivation: function() {
        return this._using;
    },
    
    /* 若有需要再加 setTitle 和 setDesc
    setCaption: function(caption) {
        while(this._buttonBackground.childNodes.length>0) 
            this._buttonBackground.removeChild( this._buttonBackground.firstChild );
        if(typeof caption == "string")
            this._buttonBackground.appendChild(Lang(caption));
        else
            this._buttonBackground.appendChild(caption);
    },
    */
    
    prepareNode: function(nodeToAppend) {
        var me = this;
        
        nodeToAppend.className = this.className;
        nodeToAppend.style.display = "inline-block";
        
        this._buttonBackground = document.createElement("div");
        
        this.img    = document.createElement("div");
        this.title  = document.createElement("p");
        this.desc   = document.createElement("p");
        this.link   = document.createElement("p");
        
        this.img.className   = 'img';
        this.title.className = 'title';
        this.desc.className  = 'desc';
        this.link.className  = 'link';
        
        this._buttonBackground.appendChild(this.img);
        this._buttonBackground.appendChild(this.title);
        this._buttonBackground.appendChild(this.desc);
        this._buttonBackground.appendChild(this.link);
        
        if(typeof this.options.title == "string")
            this.title.appendChild(Lang(this.options.title));
        else
            this.title.appendChild(this.options.title);
        
        if(typeof this.options.desc == "string")
            this.desc.appendChild(Lang(this.options.desc));
        else
            this.desc.appendChild(this.options.desc);
        
        if (this.options.links) {
            for (var i in this.options.links) {
                var linkText = NewObj('li', 'link-item', this.options.links[i].text);
                linkText.clickCallback = me.options.links[i].clickCallback ? me.options.links[i].clickCallback : null;
                linkText.onclick = function() {
                    event.cancelBubble = true; 
                    if (this.clickCallback) this.clickCallback();                    
                }
                this.link.appendChild(linkText);            
            }
        }        
        
        this._buttonBackground.className = (this._enabled) ? "en" : "di";
        this._buttonBackground.style.display = "inline-block";

        //todo. VAL: aui.nvr.ui.Button繼承ControlBase, 事件透過ControlBase來處理較好。
        this._buttonBackground.onmouseover = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "um" : "mm";
        };
        this._buttonBackground.onmouseup = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "um" : "mm";
            if (me.options.capture)
                ((me.options.capturedElement)?me.options.capturedElement:this).releaseCapture();
        };
        this._buttonBackground.onmousedown = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "ud" : "md";
            if (me.options.capture)
                ((me.options.capturedElement)?me.options.capturedElement:this).setCapture();
        };
        this._buttonBackground.onmouseout = function() {
            if (!me._enabled) return;
            me._buttonBackground.className = (me._using) ? "us" : "en";
        };

        nodeToAppend.appendChild(this._buttonBackground);
    },

    //todo. VAL: 用Controlbase的getClientRegion()取代它。
    pvtGetRegion: function() {
        return YAHOO.util.Dom.getRegion(this._managedNode);
    }
});

aui.nvr.ui.CheckButton = function(options) {
    this.options = {
        className: "checkbutton",
        caption: "",
        enabled: true,
        using: false
    };
    this.options = aui.lang.merge(this.options, options || {});

    this._enabled = this.options.enabled;
    this._using = this.options.using;

    this.className = this.options.className;
    this._buttonBackground = null;

    aui.nvr.ui.CheckButton.superclass.constructor.call(this);
};

aui.lang.Class.extend(aui.nvr.ui.CheckButton, aui.ui.ControlBase, {
    setEnable: function(isEnable){
        this._enabled = isEnable;
        this.pvtSetStatus();
        aui.nvr.ui.CheckButton.superclass.setEnable.call(this, this._enabled);
    },

    getEnable: function(){
        return this._enabled;
    },

    setActivation: function(isUsing){
        this._using = isUsing;
        this.pvtSetStatus();
    },

    getActivation: function(){
        return this._using;
    },
    
    pvtSetStatus: function(){
        if(this._enabled){
            this._left.className = (this._using) ? "us-left" : "en-left";
            this._right.className = (this._using) ? "us-right" : "en-right";
            this._content.className = (this._using) ? "us-content" : "en-content";
        }else{
            this._left.className = "di-left";
            this._right.className = "di-right";
            this._content.className = "di-content";
        }
    },
    
    setCaption: function(caption) {
        //ex: caption = LangText(value) / caption = Lang(value)        
        if (typeof caption == "string")
            this._content.innerText = caption;
        else if (typeof caption == "object") {
//            this._content.innerText = caption.innerText;
            if (this._content.firstChild)
                this._content.removeChild(this._content.firstChild);
            this._content.appendChild(caption);
        }
    },
    
    setWidth: function(value){
        this._content.style.width = value - 30 +"px";
    },
    
    getWidth: function(){
        return this._content.offsetWidth + 30;
    },
    
    setMaxWidth: function(value) {
        if (value < 30) value = 30;
        this._content.style.maxWidth = value - 30 + "px";
        if (this._content.children[0]) this._content.children[0].style.maxWidth = value - 30 + "px";
        this._buttonBackground.style.maxWidth = value +"px";     
    },
    
    setFloat: function(value){
        this._buttonBackground.style.styleFloat = value;    //Albert Modify, Bug 11040
    },
    
    prepareNode: function(nodeToAppend){
        var me = this;
        
        this._left = document.createElement("div");
        this._right = document.createElement("div");
        this._content = document.createElement("div");
        
        if (typeof this.options.caption == "string") {
            var font = document.createElement("div");
            font.className = "btn-text";
            font.innerHTML = this.options.caption;
            this._content.appendChild(font);
        } else if (typeof this.options.caption == "object") {
            this.options.caption.className = "btn-text";
            this._content.appendChild(this.options.caption);
        }
        
        nodeToAppend.className = this.className;
        
        nodeToAppend.onmouseover = function(){
            if (!me._enabled) return;
            me._left.className = "mm-left";
            me._right.className = "mm-right";
            me._content.className = "mm-content";
        };
        nodeToAppend.onmouseup = function() {
            if (!me._enabled) return;
            me._left.className = (me._using) ? "us-left" : "en-left";
            me._right.className = (me._using) ? "us-right" : "en-right";
            me._content.className = (me._using) ? "us-content" : "en-content";
        };
        nodeToAppend.onmousedown = function() {
            if (!me._enabled) return;
            me._left.className = "md-left";
            me._right.className = "md-right";
            me._content.className = "md-content";
        };
        nodeToAppend.onmouseout = function() {
            if (!me._enabled) return;
            me._left.className = (me._using) ? "us-left" : "en-left";
            me._right.className = (me._using) ? "us-right" : "en-right";
            me._content.className = (me._using) ? "us-content" : "en-content";
        };
        
        nodeToAppend.appendChild(this._left);        
        nodeToAppend.appendChild(this._content); 
        nodeToAppend.appendChild(this._right);
        
        this._buttonBackground = nodeToAppend;
        
        this.pvtSetStatus();
    }
});

aui.nvr.ui.TabButton = function(options) {
    this.options = {
        className: "tabbutton",
        iconName: "",
        enabled: true,
        using: false
    };
    this.options = aui.lang.merge(this.options, options || {});

    this._enabled = this.options.enabled;
    this._using = this.options.using;
    
    this._buttonBackground = null;
    this._btn = null;
    this.className = this.options.className;

    aui.nvr.ui.TabButton.superclass.constructor.call(this);
};

aui.lang.Class.extend(aui.nvr.ui.TabButton, aui.ui.ControlBase, {
    setActivation: function(isUsing) {
        this._using = isUsing;
        this._buttonBackground.className = (this._using) ? "us" : "en";
        this._btn._buttonBackground.className = (this._using) ? "us" : "en";
    },

    prepareNode: function(nodeToAppend) {
        var me = this;
        
        this._buttonBackground = document.createElement("div");
        this._buttonBackground.className = "en";
        nodeToAppend.className = this.className;

        this._buttonBackground.onmouseover = function() {            
            if(me._enabled && !me._using){
                me._buttonBackground.className = "mm";
                me._btn._buttonBackground.className = "mm";
            }
        };

        this._buttonBackground.onmouseout = function() {
            if(me._enabled && !me._using){
                me._buttonBackground.className = "en";
                me._btn._buttonBackground.className = "en";
            } 
        };        
        
        this._btn = new aui.nvr.ui.Button({ className: this.options.iconName});
        this._btn.setEnable(false);
        this._btn.render(this._buttonBackground);        
        nodeToAppend.appendChild(this._buttonBackground); 
    }
});


aui.nvr.ui.ImageButton = function(options) {
    this.options = {
        hint: "",
        subClassName: "",
        caption: "",
        enabled: true,
        using: false,
        capture: true
    };
    this.options = aui.lang.merge(this.options, options || {});

    this._enabled = this.options.enabled;
    this._using = this.options.using;
    this._icon = null;
    this._caption = null;

    this.className = "aui-nvr-ui-ImageButton";
    if (this.options.subClassName) {
        this.options.className = this.className + " " + this.options.subClassName;
    }
    this.hint = this.options.hint;

    aui.nvr.ui.ImageButton.superclass.constructor.call(this, this.options);
};

aui.lang.Class.extend(aui.nvr.ui.ImageButton, aui.nvr.ui.Button, {
    setCaption: function(caption) {
        while (this._caption.childNodes.length > 0)
            this._caption.removeChild(this._caption.firstChild);
        if (typeof caption == "string")
            this._caption.innerText = LangText(caption);
        else
            this._caption.appendChild(caption);
    },

    prepareNode: function(nodeToAppend) {
        aui.nvr.ui.ImageButton.superclass.prepareNode.call(this, nodeToAppend);
        
        /* re-create content */
        this._buttonBackground.innerHTML = "";
        nodeToAppend.style.display = "";
        
        this._icon = NewObj("div", "icon");
        this._caption = NewObj("div", "caption");

        if (typeof this.options.caption == "string")
            this._caption.innerText = LangText(this.options.caption);
        else
            this._caption.appendChild(this.options.caption);
        
        this._buttonBackground.appendChild(this._icon);
        this._buttonBackground.appendChild(this._caption);
    }
});

aui.nvr.ui.FixedTextImageButton = function(options) {
    /// <summary>
    /// mutil-line image button
    /// </summary>
    /// <param name="options"></param>

    this.options = {
        hint: "",
        subClassName: "",
        caption: "",
        enabled: true,
        using: false,
        capture: true
    };
    this.options = aui.lang.merge(this.options, options || {});

    this._enabled = this.options.enabled;
    this._using = this.options.using;
    this._icon = null;
    this._caption = null;

    this.className = "aui-nvr-ui-ImageButton";
    if (this.options.subClassName) {
        this.options.className = this.className + " " + this.options.subClassName;
    }
    this.hint = this.options.hint;

    aui.nvr.ui.ImageButton.superclass.constructor.call(this, this.options);
};

aui.lang.Class.extend(aui.nvr.ui.FixedTextImageButton, aui.nvr.ui.Button, {
   
    prepareNode: function(nodeToAppend) {
        /// <summary>
        /// overwrite prepareNode methods
        /// </summary>
        /// <param name="nodeToAppend"></param>
        aui.nvr.ui.FixedTextImageButton.superclass.prepareNode.call(this, nodeToAppend);
        
        this._buttonBackground.innerHTML = "";
        nodeToAppend.style.display = "";
        
        this._icon = NewObj("div", "icon");
        this._caption = NewObj("div", "caption");

        if (typeof this.options.caption == "string") {
            var temp = LangText(this.options.caption);

            if (/.*[\u4e00-\u9fa5]+.*$/.test(temp)) {
                this._caption.innerText = LangText(this.options.caption);
            } else {
                var text, count, index, blankIndex, temp2, widthTextNumbers = 9;
                while (temp.length > 0){
                    text = NewObj("div", "btn-text");
                    count = 0;
                    blankIndex = temp.indexOf(" ");
                    if (blankIndex > -1) {
                   
                        if (blankIndex + 1 >= widthTextNumbers) {
                            text.style.textAlign = "left";
                            text.innerText = temp.slice(0, blankIndex);
                            temp = temp.slice(blankIndex + 1);
                        } else {
                            temp2 = temp.slice(0, blankIndex + 1);
                            temp = temp.slice(blankIndex + 1);
                            blankIndex = temp.indexOf(" ");
                            while (temp2.length < widthTextNumbers && temp.length > 0) {
                                if (blankIndex > -1) {
                                    if (temp2.length + blankIndex + 1 > widthTextNumbers) break;
                                    temp2 += temp.slice(0, blankIndex + 1);
                                    temp = temp.slice(blankIndex + 1);
                                } else {
                                    if (temp2.length + temp.length > widthTextNumbers) break;
                                    temp2 += temp.slice(0, temp.length);
                                    temp = temp.slice(temp.length);
                                }
                                blankIndex = temp.indexOf(" ");
                            }
                            if (temp2.length >= widthTextNumbers) {
                                text.style.textAlign = "left";
                            }
                            text.innerText = temp2;
                        }
                    } else {
                        if (temp.length >= widthTextNumbers) {
                            text.style.textAlign = "left";
                        }
                        text.innerText = temp.slice(0, temp.length);
                        temp = temp.slice(temp.length);
                    }
                    this._caption.appendChild(text);
                }
            }
        } else {
            this._caption.appendChild(this.options.caption);
        }
        this._buttonBackground.appendChild(this._icon);
        this._buttonBackground.appendChild(this._caption);
    }
});

aui.nvr.ui.ButtonList = function(options) {
    this.options = {
        className: "aui-nvr-ui-ButtonList",
        buttonType: "ImageButton"
    };
    this.options = aui.lang.merge(this.options, options || {});
    
    /* variables*/
    var buttonCollections = {};
    var buttonType = aui.nvr.ui.ButtonList.ButtonTypes[this.options.buttonType];
    if (!buttonType) buttonType = aui.nvr.ui.ButtonList.ButtonTypes["ImageButton"];
    var container;
    var selectedItems = new aui.collections.ArrayList();
    
    this.prepareNode = function(nodeToAppend) {
        nodeToAppend.className = this.options.className;
        container = nodeToAppend;
    };
    this.add = function(key, options) {
        var button = new buttonType(options);
            button.render(container);
            button.onclick.subscribe(function() {
                this.setActivation(!this.getActivation());
            });
        buttonCollections[key] = button;
        
        return button;
    };
    this.clear = function() {
        for (var key in buttonCollections) {
            buttonCollections[key].unrender(container);
            buttonCollections[key] = null;
        }
        selectedItems.clear();
    };
    this.getSelectedItems = function() {
        selectedItems.clear();
        for (var key in buttonCollections) {
            if (buttonCollections[key].getActivation())
                selectedItems.add(key);
        }
        return selectedItems;
    };
    this.selectAll = function(value) {
        for (var key in buttonCollections) {            
            buttonCollections[key].setActivation(value);
        }    
    };
    
    aui.nvr.ui.ButtonList.superclass.constructor.call(this);
}
aui.lang.Class.extend(aui.nvr.ui.ButtonList, aui.ui.ControlBase, {});

aui.nvr.ui.ButtonList.ButtonTypes = {
    Button: aui.nvr.ui.Button,
    Button2: aui.nvr.ui.Button2,
    CheckButton: aui.nvr.ui.CheckButton,
    TabButton: aui.nvr.ui.TabButton,
    ImageButton: aui.nvr.ui.ImageButton,
    FixedTextImageButton: aui.nvr.ui.FixedTextImageButton
}