﻿/**
* Load network device information from given data service.
* @function
* @param {aui.nvr.data.DeviceDataService} loader The data service 
* which provides method to read a tree structure from 
* storage. Please refer to aui.nvr.data.DeviceDataService for 
* more information.
*/

/**
* Login to a NVR or CMS server.
* @static
* @function
* @param {server} The Network Address of NVR or CMS.
* @param {user} The User instance for current user.
*/
aui.nvr.core.login = function(server, user) {
    if (aui.nvr.core.pvtServer)
        aui.nvr.core.pvtServer.onReady.unsubscribe();

    aui.nvr.core.pvtServer = server;
    aui.nvr.core.pvtCurrentUser = user;
    aui.nvr.ui.ControlProvider.Server = server;
    aui.nvr.ui.ControlProvider.User = user;
    aui.nvr.core.pvtServer.onReady.subscribe(function() {
        aui.nvr.core.Events.onServerReady.fire();
    });

    //welcome message
    //server.EventManager.welcome();
}

aui.nvr.core.reloadCaption = function() {
    var collections = aui.nvr.core.Caption.collections;
    var count = 0, count2 = 0;
    for (var i in collections) {
        var obj = collections[i];
        for (var j in obj) {
            /*while(obj[j] && !obj[j].parentNode){
            obj.splice(j, 1);
            count2++;
            }*/
            if (obj[j]) obj[j].innerText = LangText(i, obj[j].params || null);
            //count++;
        }
        //  trace("key: "+i+" ; data: "+obj);
    }
    //Debug.WriteLine("totally "+count+" language objects, "+count2+" objects recycled.");
}

/**
* Get localized string for display.
* @function
* @param {HTMLNode} node Htmlnode that contains the language text.
* @param {string} key The key of the text. ex. "TXT_SETUP".
* @param {array} params Array contains data to replace in language string. ex: "{1} devices found in {2}." with [2,"camera"] will be "2 devices found in camera."
* @return {string} return the node given as first parameter.
*/

aui.nvr.core.Caption = function(key, params) {
    if (!key) return document.createElement("font");
    if (params && !params.length) exception("[" + key + " ]Params should be an array.", "aui.nvr.core.Caption");
    /* create language object */
    var node = document.createElement("font");
    /* get language settings */
    var text = aui.nvr.core.CaptionText(key, params);

    /* alter textnode */
    node.innerText = text;
    node.key = key;
    node.params = params;
    /* remember key for further translation */
    if (!aui.nvr.core.Caption.collections[key]) aui.nvr.core.Caption.collections[key] = [];
    aui.nvr.core.Caption.collections[key].push(node);

    return node;
}
/* collections to keep all textnode */
aui.nvr.core.Caption.collections = {};

/* return lauguage text */
aui.nvr.core.CaptionText = function(key, params) {
    /* get language settings */

    if (aui.nvr.core.pvtCurrentLanguage) {
        var temp = aui.nvr.core.pvtCurrentLanguage.getItem(key);
        var text = (temp == -1 || temp == null) ? key : temp[0];
    } else
        var text = key;

    /* replace params if exists */
    if (params && params.length > 0)
        text = text.replace(/\{(\d+)\}/gi, function(a, b) {
            /* confirm undefined to avoid number 0 problem */
            return params[b] == "undefined" ? a : params[b];
        });
    return text;
}

/**
* Move a {aui.nvr.GroupItem} from group to group.
* @static
* @function
* @param {aui.nvr.Group} fromGroup
* The origional group, the specify item will be removed from this group.
* @param {aui.nvr.Group} targetGroup
* New group for specify item to join.
* @param {aui.nvr.GroupItem} item
* The item to move, could be an instance of {aui.nvr.Camera}, 
* {aui.nvr.VideoServer}, {aui.nvr.NetworkVideoRecorder}, 
* {aui.nvr.Group} or any sub class of {aui.nvr.GroupItem}.
*/
aui.nvr.core.moveToGroup = function(fromGroup, targetGroup, item) {
    return this.pvtServer.DeviceManager.moveToGroup(fromGroup, targetGroup, item);
};

/**
* Copy a reference to another group.
* @static
* @function
* @param {aui.nvr.Group} targetGroup
* Another group for the given item. The item will join the group
* without leaving any related group.
* @param {aui.nvr.GroupItem} item
* The item for copy. There won't be any clone or new instance
* for this item. Instead, the method just add a new reference to 
* the given group.
*/
aui.nvr.core.copyToGroup = function(targetGroup, item) {
    return this.pvtServer.DeviceManager.copyToGroup(targetGroup, item);
};

/**
* Return a new Device Id according to licence.
* @static
* @function
* @return {number} Device Id.
*/
aui.nvr.core.getAvailableDeviceId = function() {
    return this.pvtServer.DeviceManager.getAvailableDeviceId();
};

/**
* Delete specify group. All sub item of this group won't be deleted.
* @static
* @function
* @param {aui.nvr.Group} group Group instance for delete.
* @throw
*/
aui.nvr.core.deleteGroup = function(group) {
    return this.pvtServer.DeviceManager.deleteGroup(group);
};

/**
* Delete specify device.
* @static
* @function
* @param {aui.nvr.NetworkDevice} device Device instance for delete.
* @throw
*/
aui.nvr.core.deleteDevice = function(device) {
    return this.pvtServer.DeviceManager.deleteDevice(device);
};

/**
* Delete a instance of {aui.nvr.GroupItem}
* @static
* @function
* @param {aui.nvr.GroupItem} groupitem
*/
aui.nvr.core.deleteGroupItem = function(groupitem) {
    return this.pvtServer.DeviceManager.deleteGroupItem(groupitem);
};

/**
* Create a group instance.
* @static
* @function
* @param {aui.nvr.Group} parentGroup;
* @return {aui.nvr.Group} New Group instance.
*/
aui.nvr.core.createGroup = function(parentGroups) {
    return this.pvtServer.DeviceManager.createGroup(parentGroups);
};

/**
* Create a device instance.
* @static
* @function
* @param {object} type Device type.
* @param {aui.nvr.Group} parentGroup
* @return {object} Return instance of given type.
*/
aui.nvr.core.createDevice = function(type, parentGroups) {
    return this.pvtServer.DeviceManager.createDevice(type, parentGroups);
};

/**
* Create an instance of {aui.nvr.GroupItem}.
* @static
* @function
* @param {object} type
* @param {aui.nvr.Group} parentGroup
* @return {object} Return instance of given type.
*/
aui.nvr.core.createGroupItem = function(type, parentGroups) {
    return this.pvtServer.DeviceManager.createGroupItem(type, parentGroups);
};

/**
* Save all changes.
* @static
* @function
*/
aui.nvr.core.save = function() {
    //return this.pvtServer.DeviceManager.save();
    //Leah marked , for DeviceManager will take save out.
};

/**
* Export configuration to file.
* @static
* @function
*/
aui.nvr.core.exportConfiguration = function() { };

aui.nvr.core.Delegates = {};

aui.nvr.core.Delegates.PTZ = {
    moveUp: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveUp();
            device.stopMove();
        }
    },
    moveDown: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveDown();
            device.stopMove();
        }
    },
    moveLeft: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveLeft();
            device.stopMove();
        }
    },
    moveLeftUp: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveLeftUp();
            device.stopMove();
        }
    },
    moveLeftDown: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveLeftDown();
            device.stopMove();
        }
    },
    moveRight: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveRight();
            device.stopMove();
        }
    },
    moveRightUp: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveRightUp();
            device.stopMove();
        }
    },
    moveRightDown: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.moveRightDown();
            device.stopMove();
        }
    },
    zoomIn: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.zoomIn();
            device.stopMove();
        }
    },
    zoomOut: function() {
        var device = aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device)) {
            device.zoomOut();
            device.stopMove();
        }
    },
    gotoPreset: function(point, device) {
        var device = device || aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device))
            device.gotoPreset(point);
    },
    removePreset: function(point, device) {
        var device = device || aui.nvr.core.getCurrentDevice();

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device))
            device.removePreset(point);
    },
    createPreset: function(device, id) {
        var device = device || aui.nvr.core.getCurrentDevice();

        //var id = (device.Presets.getCount()+1);

        if (device && aui.nvr.ISupportPTZ.interfaceOf(device))
            return device.createPreset(undefined, id);
        else
            return false;
    },
    presetTour: function(tour) {
        var device = aui.nvr.core.getCurrentDevice();
        if (device && aui.nvr.ISupportPTZ.interfaceOf(device))
            return device.presetTour(tour);
    },
    focusChannel: function(type, channelId) { },
    soundAlarm: function(duration, frequency, options) { }
};

aui.nvr.core.getRegErrorMsg = function(errorCode, regType, source) {
    switch (errorCode) {
        case "10001":
            //LICENSE_INSUFFICIENT
            return LangText("MSG_ACTIVATIONKEY_INCORRECT") + ' (10001)';
            break;

        case "10002":
            //LICENSE_AUTHENTICATE_FAILED
            return LangText("MSG_MEMBERINFO_ERROR") + ' (10002)';  //目前不會發生，改以1008取代
            break;

        case "10003":
            //LICENSE_MACADDRESS_NOTMATCH
            if (regType)
                return LangText("MSG_LICENSEMAC_NOTMATCH") + ' (10003)';
            else
                return LangText("MSG_ACTIVATIONMAC_NOTMATCH") + ' (10003)';
            break;

        case "10004":
            //LICENSE_REGISTERED                  
            return LangText("MSG_LICENSE_REGISTERED") + ' (10004)';
            break;

        case "10005":
            //MSG_LICENSE_INVALID                  
            return LangText("MSG_LICENSE_INVALID") + ' (10005)';
            break;

        case "10006":
            //MSG_LICENCEMAXIMUM //[Bug 16683, 16684] get MaxLicenseCounts by source.
            var maxLicense = (!source) ? aui.nvr.core.getMaxLicenseCount() : aui.nvr.core.getMaxLicenseCountBySource(); 
                                                                         
            return LangText("MSG_LICENCEMAXIMUM", [maxLicense]) + ' (10006)';
            break;

        case "10007":
            //LICENSE_AUTHENTICATE_FAILED
            return LangText("MSG_CANTCONNECTREGCENTER") + ' (10007)';
            break;

        case "10008":
            //MSG_REGISTERD_PRODUCT_NOMATCH
            //return LangText("MSG_REGISTERD_PRODUCT_NOMATCH");
            return LangText("MSG_LICENSE_INVALID") + ' (10008)';   //Albert Modify, SPEC  
            break;

        case "10009":
            //MSG_NETWORKADAPTER_FAILED
            //return LangText("MSG_NETWORKADAPTER_FAILED");
            return LangText("MSG_NETWORKADAPTER_FAILED") + ' (10009)';   //Albert Modify, SPEC  
            break;

        case "12029":
            //MSG_CONNECTSERVERFAIL
            return LangText("MSG_CONNECTSERVERFAIL");
            break;
        
        case "11001":
            //Can't find product name.
            return LangText("MSG_CANNOTFIND_PRODUCTNAME") + ' (11001)';
            break;
        case "11002":
            //Duplicate product code.
            return LangText("MSG_DUPLICATE_PRODUCTCODE") + ' (11002)';
            break;
        case "11003":
            //License format is incorrect.
            return LangText("MSG_LICENSEFORMAT_INCORRECT") + ' (11003)';
            break;
        case "11004":
            //License key is empty.
            return LangText("MSG_LICENSEKEY_EMPTY") + ' (11004)';
            break;
        case "11005":
            //License key length error.
            return LangText("MSG_LICENSEKEYLENGTH_ERROR") + ' (11005)';
            break;
        case "11006":
            //License key is incorrect.
            return LangText("MSG_LICENSEKEY_INCORRECT") + ' (11006)';
            break;
        case "11007":
            //Registration Center has exception.
            return LangText("MSG_REGISTRATIONCENTER_EXCEPTION") + ' (11007)';
            break;
        case "11008":
            //ACTi member id/password mismatch. Please try again.
            return LangText("MSG_MEMBERINFO_ERROR") + ' (11008)';
            break;
        case "11009":
            //Parameter error.
            return LangText("MSG_PARAMETER_ERROR") + ' (11009)';
            break;
        case "11010":
            //[S3.0.02.24-001]add error code from license server.
            //License Key does not exist.
            return LangText("MSG_LICENSEKEY_NOT_EXIST") + ' (11010)';
            break;
        case "11011":
            //[S3.0.02.24-001]add error code from license server.
            //The license has been registered. 
            return LangText("MSG_LICENSE_REGISTERED") + ' (11011)';
            break;
                
        case "1001":
            //MSG_ACCOUNTDUPLICATE
            return LangText("MSG_ACCOUNTDUPLICATE");
            break;
        case "1002":
            //MSG_USERGROUPDUPLICATED
            return LangText("MSG_USERGROUPDUPLICATED");
            break;
        case "1003":
            //[S3.0.02.27-002]add no permisssion error code from media server
            //MSG_NO_PERMISSION_ACCESS_FUNCTION
            return LangText("MSG_NO_PERMISSION_ACCESS_FUNCTION");
            break;
        case "2001":
            //MSG_DEVICE_ACCESS_DENIED
            return LangText("MSG_DEVICE_ACCESS_DENIED");
            break;
        case "2003":
            //MSG_DEVICE_NOT_EXIST
            return LangText("MSG_DEVICE_NOT_EXIST");
            break;
        case "4200":
            //MSG_REMOTE_FAILED
            return LangText("MSG_CMS_REMOTE_CONNECTION_FAILED");
            break;
        case "4201":
            //MSG_REMOTE_FAILED
            return LangText("MSG_NVR_RESPONSE_ERROR");
            break;
        case "4202":
            //MSG_REMOTE_FAILED
            return LangText("MSG_DEVICE_SOURCE_NOT_EXIST");
            break;
        default:
            if (!isNaN(errorCode) && parseInt(errorCode) > 0) {
                return LangText("MSG_PROCESS_FAILED") + ' (' + errorCode + ')';
            }
            else return LangText("MSG_PROCESS_FAILED");
            break;
    }
};

aui.nvr.core.capabilityParser = function(obj, param) {
    var result = {};
    var previous = null;
    
    if(obj.getAttribute("default")) result.defaultValue = obj.getAttribute("default");
    
    switch(obj.getAttribute("type")){
        case 'int':
            
            result.options = [];
            
            if(obj.getAttribute("start") && obj.getAttribute("end")){
                
                for(var i = Number(obj.getAttribute("start")); i <= Number(obj.getAttribute("end")); i++){
                    result.options.push({value: i, text: i});
                }
            }
            else{
                if(result.defaultValue) result.options.push({value: result.defaultValue, text: result.defaultValue});
            }
            break;
        
        case 'string':
        case 'intxint':
            
            result.options = [];
            
            if(obj.firstChild){
                
                for(var i=0; i<obj.firstChild.childNodes.length; i++){
                    var existFlag = true;
                    var firstNode = obj.firstChild.childNodes[i];
                    
                    if(firstNode.nodeTypeString != "comment"){
                        
                        for(var a=0; a<firstNode.attributes.length; a++){
                            
                            var validate = false;
                            
                            if(firstNode.attributes[a].name == "cmd") continue;
                            
                            if(param){ // validate failed if parameter not set.
                                var key = firstNode.attributes[a].name;
                                var value = firstNode.attributes[a].value;
                                var value_arr = value.split(",");
                                
                                if((key == "Resolution1" || key == "Resolution2") && (param[key].substr(0,1) == "N" || param[key].substr(0,1) == "P")){
                                    param[key] = param[key].replace(/\N|\P/g, '');
                                    /*
                                    param[key] = param[key].substr(1, param[key].length-1);
                                    */
                                }
                                
                                for(var b=0; b<value_arr.length; b++){
                                    if(param[key] == value_arr[b]){
                                        validate = true;
                                        break;
                                    }
                                }
                            }
                            
                            if(!validate){
                                existFlag = false;
                                break;
                            }
                        }
                        
                        if(existFlag){
                            var value = firstNode.getAttribute("cmd")?firstNode.getAttribute("cmd"):firstNode.text;
                            var text = firstNode.text?firstNode.text:firstNode.getAttribute("cmd");
                            
                            if(previous != value){
                                result.options.push({value: value, text: text});
                                previous = value;
                            }
                        } 
                        
                    }
                }
            }
            else{
                if(result.defaultValue) result.options.push({value: result.defaultValue, text: result.defaultValue});
            }
            break;
        default:
            result.options = [];
            
            if(result.defaultValue) result.options.push({value: result.defaultValue, text: result.defaultValue});
            
            break;
    }
    
    return result;
};

var Lang = aui.nvr.core.Caption;
var LangText = aui.nvr.core.CaptionText;
