﻿/**
 * @static 
 * @field
 */
aui.nvr.core.Events = {
    /** @lends aui.nvr.core */
    /**
     * Fires whenever focused group changed.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */
    onCurrentGroupChanged : 
        aui.lang.util.CustomEvent('onCurrentGroupChanged',aui.nvr.core),

    /** @lends aui.nvr.core */
    /**
     * Fires whenever focused control changed.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */
    onCurrentControlChanged : 
        aui.lang.util.CustomEvent('onCurrentControlChanged',aui.nvr.core),
        
    /** @lends aui.nvr.core */
    /**
     * Fires whenever focused volume changed.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */
    onCurrentVolumeChanged : 
        aui.lang.util.CustomEvent('onCurrentVolumeChanged',aui.nvr.core),        

    /**
     * Fires whenever focused device changed.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */
    onCurrentDeviceChanged : 
        aui.lang.util.CustomEvent('onFocusDeviceChanged',aui.nvr.core),
       
    /**
     * Fires whenever the device list han been edited.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */     
    onDeviceListChanged : 
        aui.lang.util.CustomEvent('onDeviceListChanged',aui.nvr.core),
       
    /**
     * Fires whenever the group list has been edited.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */ 
    onGroupListChanged : 
        aui.lang.util.CustomEvent('onGroupListChanged',aui.nvr.core),
       
    /**
     * Fires whenever current user changed.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */ 
    onCurrentUserChanged : 
        aui.lang.util.CustomEvent('onCurrentUserChanged',aui.nvr.core),

    /**
     * Fires whenever the display language changed.
     * @static
     * @field
     * @property {aui.lang.util.CustomEvent}
     */
    onLanguageChanged :
        aui.lang.util.CustomEvent('onLanguageChanged', aui.nvr.core),
        
    onServerReady :
        aui.lang.util.CustomEvent('onServerReady', aui.nvr.core),
    
    /**
     * Fires whenever the onGotoPlayback trigger
     */    
    onAddChanneltoPlayback :
        aui.lang.util.CustomEvent('onAddChanneltoPlayback', aui.nvr.core),
        
    /**
     * Fire whenever the pop up window trigger
     */
     
     onPopupWindow:
        aui.lang.util.CustomEvent('onPopupWindow', aui.nvr.core),
        
    /**
     * Fire whenever the patrol trigger
     */
     
     onPatrolStatusChanged:
        aui.lang.util.CustomEvent('onPatrolStatusChanged', aui.nvr.core),
        
    /**
     * Fire whenever the dialog status changed(open/close)
     */
     
     onDialogStatusChanged:
        aui.lang.util.CustomEvent('onDialogStatusChanged', aui.nvr.core),
            
    /**
     * Fire whenever the sort mode of device tree changed(by-id/by-ip)
     */
     
     onDeviceSortModeChanged:
        aui.lang.util.CustomEvent('onDeviceSortModeChanged', aui.nvr.core),
        
    /**
     * Fire whenever InstantPlayback triggered manual record
     */
     
     onInstantPlaybackManualRecord:
        aui.lang.util.CustomEvent('onInstantPlaybackManualRecord', aui.nvr.core),
        
    /**
     * Fire whenever Stretch Video status changed
     */
     
     onStretchVideoChanged:
        aui.lang.util.CustomEvent('onStretchVideoChanged', aui.nvr.core),
    
     /**
     * Fire whenever Stretch Window status changed
     */
     
     onStretchWindowChanged:
        aui.lang.util.CustomEvent('onStretchWindowChanged', aui.nvr.core),

     /**
     * Fire whenever Display Title Bar status changed
     */

     onDisplayTitleBarChanged:
        aui.lang.util.CustomEvent('onDisplayTitleBarChanged', aui.nvr.core),        
        
    /**
     * Fire whenever Daylight Saving status changed
     */
     
     onEnableDaylightChanged:
        aui.lang.util.CustomEvent('onEnableDaylightChanged', aui.nvr.core),
    
    /**
     * Fire whenever update a device
     */
     
     onDeviceSave:
        aui.lang.util.CustomEvent('onDeviceSave', aui.nvr.core),
    
    
    /**
     * Fire whenever added a source
     */
     
     onSourceAdd:
        aui.lang.util.CustomEvent('onSourceAdd', aui.nvr.core),
    
    /**
     * Fire whenever update a source
     */
     
     onSourceUpdate:
        aui.lang.util.CustomEvent('onSourceUpdate', aui.nvr.core),
    
    /**
     * Fire whenever delete a source
     */
     
     onSourceDelete:
        aui.lang.util.CustomEvent('onSourceDelete', aui.nvr.core),
        
    /**
     * Fire whenever add/update/delete a view
     */
     
     onViewSaved:
        aui.lang.util.CustomEvent('onViewSaved', aui.nvr.core)
    
}