#include <asm/arch/hardware.h>
#include <asm/arch/vic.h>

static volatile pVIC1CON vic1;

/*
 * Init VIC1 
 */
inline void vic_init (void)
{
	soc_trace();
	vic1 = (pVIC1CON) (A1_VIC_BASE);
	vic1->VIC1IntSelectR = 0x0;
	vic1->VIC1IntEnClearR = 0xffffffff;
	vic1->VIC1SoftIntclearR = 0x0;
	vic1->VIC1EdgeClrR = 0x0;
}

/*
 * Enable interrupt in selected device.
 * STP1.Seleceted MODE(IRQ FIQ)
 * STP2.Edge trigger or Level trigger.
 * STP3.Enable selected interrupt.
 * dev: Selected ip. 
 */
void vic_enirq (IntrVector_E dev)
{
	u32 i = 0;

	soc_trace();
	
	switch (dev) {
	case int_eth110:
	case int_uart0:
	case int_gpio:
	case int_isp:
		// Set IRQ Mode
		i = vic1->VIC1IntSelectR;
		i &= ~(1 << dev);
		vic1->VIC1IntSelectR = i;
		//Level trigger Active High.
		vic1->VIC1SenseR |= (1 << dev);
		vic1->VIC1EventR |= (1 << dev);
		//Enbale Interrupt
		vic1->VIC1IntEnableR |= (1 << dev);
		break;

	case tmr1_intr:
	case tmr2_intr:
	case tmr3_intr:
		// Set IRQ Mode
		i = vic1->VIC1IntSelectR;
		i &= ~(1 << dev);
		vic1->VIC1IntSelectR = i;
		//Edge trigger, rising edge
		vic1->VIC1SenseR &= ~(1 << dev);
		vic1->VIC1BothEdgeR &= ~(1 << dev);
		vic1->VIC1EventR |= (1 << dev);
		//Enbale Interrupt
		vic1->VIC1IntEnableR |= (1 << dev);
		break;
	default:
		break;
	}
}

/*
 * Disable interrupt of IRQ in selected device.
 * dev: Selected ip. 
 */
void vic_disirq(IntrVector_E dev)
{
	vic1->VIC1IntEnClearR = (0x1UL << dev);
	vic1->VIC1IntEnableR &= ~(0x1UL << dev);
}

/*
 * Search interrupt source.
 * return source number. 
 */
u32 vic_queryirq(void)
{
	u32 i = 0, j = 0;

	//Get VIC1 interrupt raw status.
//      j = vic1->VIC1RawIntrR;
	j = vic1->VIC1IRQStatusR;

	__asm__ __volatile__("clz %0, %1 \n\t":"=r"(i):"r"(j));

	return (31 - i);
}

/*
 * Clean edge trigger int.
 * dev: Interrupt source. 
 */
void vic_cleanirq(IntrVector_E dev)
{
	vic1->VIC1EdgeClrR |= (0x1 << dev);
}
