#include <config.h>
#include <common.h>
#include <asm/arch/hardware.h>
#include <asm/sizes.h>
#include <asm/io.h>

static int current_pin = -1;

inline int  A1_get_pinmux (void)
{
	return current_pin;
}

void A1_set_pin_mux(int Device)
{
	unsigned int mfs0, mfs1, mfs2, mfs3, mfs4, mfs5, reg;

	if (A1_get_pinmux() == Device)
		return;

	current_pin = Device;

	mfs0 = HAL_GETREG32 (HAL_REG_SYS_MSF0);
	mfs1 = HAL_GETREG32 (HAL_REG_SYS_MSF1);
	mfs2 = HAL_GETREG32 (HAL_REG_SYS_MSF2);
	mfs3 = HAL_GETREG32 (HAL_REG_SYS_MSF3);
	mfs4 = HAL_GETREG32 (HAL_REG_SYS_MSF4);
	mfs5 = HAL_GETREG32 (HAL_REG_SYS_MSF5);

	switch(Device)
	{
		case HAL_MFP_I2C0:
			mfs4 = (mfs4 & 0xFFFFCFFF) | 0x00000000;
			break;
		case HAL_MFP_I2C1:
			mfs4 = (mfs4 & 0xFFFF3FFF) | 0x00000000;
			mfs5 = (mfs5 & 0xFFFFFCFF) | 0x00000000;
			break;
		case HAL_MFP_I2C2:
			mfs4 = (mfs4 & 0xF3FFFFFF) | 0x00000000;
			mfs5 = (mfs5 & 0xFFFFF3FF) | 0x00000000;
			break;
		case HAL_MFP_NAND:
			mfs1 = (mfs1 & 0x000000FF) | 0x00000000;
			mfs2 = 0x00000000;
			mfs3 = (mfs3 & 0xFFFFF000) | 0x00000000;
			mfs4 = (mfs4 & 0xFDFFFFFF) | 0x00000000;
			break;
		case HAL_MFP_SDC:
			mfs3 = (mfs3 & 0xFFE00FFF) | 0x00000000;
			break;
		case HAL_MFP_SMC:
			mfs1 = (mfs1 & 0x000000FF) | 0x55555500;
			mfs2 = 0x55555555;
			mfs3 = (mfs3 & 0xFFFFF000) | 0x00000555;
			mfs4 |= 0x02000000;
			break;
		case HAL_MFP_LCD:
#if 1 /* New pin mux */
			mfs0 = (mfs0 & ~0x1FFFFFFF) | 0x0AAABFFF;
			mfs1 = (mfs1 & ~0x000000FF) | 0x000000FF;
			mfs5 = (mfs5 & ~0x000000FF) | 0x00000000;
#else /* Old pin mux */
			mfs2 = 0x0AAABFFF;
			mfs3 = 0x000000FF;
#endif /* LCDC pin mux */
			break;

		case HAL_MFP_WDT:
			mfs4 |= 0x10000000;
			break;
		case HAL_MFP_SENSOR:
			mfs5 |= 0x80000000;
			break;
//		case HAL_MFP_ISP:
//			halSysInternalISPEnable(1);
//			break;
//		case HAL_MFP_EXTERNAL_ISP:
//			halSysInternalISPEnable(0);
//			break;
		default:
			break;
	}
	HAL_SETREG32(HAL_REG_SYS_MSF0, mfs0);
	HAL_SETREG32(HAL_REG_SYS_MSF1, mfs1);
	HAL_SETREG32(HAL_REG_SYS_MSF2, mfs2);
	HAL_SETREG32(HAL_REG_SYS_MSF3, mfs3);
	HAL_SETREG32(HAL_REG_SYS_MSF4, mfs4);
	HAL_SETREG32(HAL_REG_SYS_MSF5, mfs5);
}
