#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include<sys/mman.h>
#include<fcntl.h>
#ifdef __UCLIBC__
#include <bits/getopt.h>
#else
#include <getopt.h>
#endif

#if 1
unsigned int reg_addr = 0;
unsigned int len = 4;
unsigned int op_data = 0;
static const char *short_options = "r:w:n:d:";
#define NO_ARG		0
#define HAS_ARG		1
static struct option long_options[] = {
	{"read", HAS_ARG, 0, 'r'},
	{"write", HAS_ARG, 0, 'w'},
	{"len", HAS_ARG, 0, 'n'},
	{"data", HAS_ARG, 0, 'd'},	
	{0, 0, 0, 0}
};
enum
{
	DO_NONE,
	DO_READ,
	DO_WRITE,
};

int action = -1;
int init_param(int argc, char **argv)
{
	int rval = 0;
	int errorCode = 0;
	int ch;
	int option_index = 0;
	opterr = 0;
	action = DO_NONE;
	while ((ch = getopt_long(argc, argv, short_options, long_options, &option_index)) != -1) 
	{
		switch (ch) 
		{
		case 'r':
			rval = sscanf(optarg, "0x%08x",&reg_addr);
			if (rval != 1)
				errorCode = -1;
			else
				action = DO_READ;
			break;
		case 'w':
			rval = sscanf(optarg, "0x%08x",&reg_addr);
			if (rval != 1)
				errorCode = -1;
			else
				action = DO_WRITE;
			break;
		case 'n':
			rval = sscanf(optarg, "%d",&len);
			if (rval != 1)
				len = 4;
			break;
		case 'd':
			rval = sscanf(optarg, "0x%08x", &op_data);
			if (rval != 1)
			{
				errorCode = -1;
				action = DO_NONE;
			}
			break;
		
		default:
			printf("unknown option found: %c\n", ch);
			errorCode = -1;
		}
	}
	return errorCode;
}
void usage(void)
{
	printf("Usage : \n");
	printf("*********************************\n");
	printf("(1) To query a register value : \n");
	printf("./io.exe  -r physical_address (in hex) -n nBytes (in decimal)\n");
	printf("\n");
	printf("(2) To set a value to a register : \n");
	printf("./io.exe -w physical_address (in hex) -d data (in hex) -n nBytes (in decimal)\n"); 
}
#endif
int main(int argc, char **argv)
{

	int fd;
	unsigned char *virt_base = NULL;
	volatile unsigned int *virt_addr = NULL;
int i;

	if (argc < 2)
	{
		usage();
		return -1;
	}

	init_param(argc, argv);
	fd = open("/dev/mem",O_RDWR);

	// do 1st remap
	virt_base = (unsigned char *)mmap(NULL, 0x1000, PROT_WRITE | PROT_READ, MAP_SHARED, fd, reg_addr & 0xFFFFF000);
	virt_addr = (unsigned int *)(virt_base + (reg_addr& 0x00000FFF));
	
	if (action == DO_WRITE)
	{
		for(i = 0; i < (len / 4); i++)
		{	
			// write
			*virt_addr = op_data;
			printf("Addr: 0x%08X has been set to 0x%08X\n", (unsigned int)reg_addr, *virt_addr);

			// if over 4K page, redo remap
			reg_addr += 4;
			if((reg_addr & 0x00000FFF) == 0)
				virt_addr = (unsigned int *)mmap(NULL, 0x1000, PROT_WRITE | PROT_READ, MAP_SHARED, fd, reg_addr);
			else
				virt_addr++;
		}	
	}
	else if (action == DO_READ)
	{
		for(i = 0; i < (len / 4); i++)
		{
			if((i % 8) ==0)
				printf("\nAddr: 0x%08X = ", (unsigned int)reg_addr);

			// read
			printf("0x%08X ", *virt_addr);

			// if over 4K page, redo remap
			reg_addr += 4;
			if((reg_addr & 0x00000FFF) == 0)
				virt_addr = (unsigned int *)mmap(NULL, 0x1000, PROT_WRITE | PROT_READ, MAP_SHARED, fd, reg_addr);
			else
				virt_addr++;
		}	
		printf("\n");
	}

	close(fd);

	return 0;

}



