#ifndef __sysHashTable_h__
#define __sysHashTable_h__

#include "sys.h"
#include "stddef.h"
#include "string.h"


EXTERN_C_BEGIN

typedef void * 							sysHashBucket_T;
typedef struct sysHashTable_S			sysHashTable_S;
typedef struct sysDoubleHashTable_S		sysDoubleHashTable_S;


typedef bool_T (*sysHashCompare_FT) (const void *pElement, const void *qElement);
typedef int    (*sysHashHash_FT)    (const void *pElement);
typedef void   (*sysHashDumpOne_FT) (const void *pElement);
/*
 * pElement is a pointer to the data structure defined by AP.
 */



/* single hash */
sysHashTable_S *
sysHashTableInit(int storageStructSize,
               int storageNextPtrOffset,
               int bucketNum,
               sysHashCompare_FT compareFunctionPtr,
               sysHashHash_FT    hashFunctionPtr,
               sysHashDumpOne_FT dumpOneFunctionPtr);

void sysHashTableExit(sysHashTable_S *pHashTable);
void sysHashTableDump(sysHashTable_S *pHashTable); /* for debug */
void * sysHashTableProbe(sysHashTable_S *pHashTable, void *pStruct); /* return structure pointer */
bool_T sysHashTableFind(sysHashTable_S *pHashTable, void *pStruct);
bool_T sysHashTableAdd(sysHashTable_S *pHashTable, void *pStruct);
bool_T sysHashTableDelete(sysHashTable_S *pHashTable, void *pStruct);



/* double hash */
sysDoubleHashTable_S *
sysDoubleHashTableInit(int storageStructSize,
					int storageNextPtrOffset,
					int bucket1Num,  /* number of the 1st buckets */
					int bucket2Num,  /* number of the 2nd buckets */
					sysHashCompare_FT	compareFunctionPtr,
					sysHashHash_FT		hashFunction1Ptr,   /* 1st hash function */
					sysHashHash_FT		hashFunction2Ptr,	/* 2nd hash function */
					sysHashDumpOne_FT	dumpOneFunctionPtr);

void sysDoubleHashTableExit(sysDoubleHashTable_S *);
void sysDoubleHashTableDump(sysDoubleHashTable_S *); /* for debug */
void * sysDoubleHashTableProbe(sysDoubleHashTable_S *, void *pStruct); /* return structure pointer */
bool_T sysDoubleHashTableFind(sysDoubleHashTable_S *, void *pStruct);
bool_T sysDoubleHashTableAdd(sysDoubleHashTable_S *, void *pStruct);
bool_T sysDoubleHashTableDelete(sysDoubleHashTable_S *, void *pStruct);

EXTERN_C_END


#define SYSHASH_TABLE_INIT(type,next,bucketnum,comp,hash,dumpOne) \
        sysHashTableInit(sizeof(type), offsetof(type,next), bucketnum, comp, hash, dumpOne)

/*
 * pStruAddr is of 'void *' datatype. You have to cast it to your proper data type.
 */
#define SYSHASH_ITERATE_BEGIN(pTable,pStruAddr) 				\
		{														\
			int __i;											\
			for (__i = 0; __i < pTable->bucketNum; ++__i)		\
			{													\
				pStruAddr = pTable->buckets[__i];				\
				while (pStruAddr)								\
				{
			
#define SYSHASH_ITERATE_END(pTable,pStruAddr)					\
					memcpy(&pStruAddr, (void *) (((char *) pStruAddr) + pTable->storageNextPtrOffset), sizeof(void *)); \
				}												\
			}													\
		}
		

#define SYSDOUBLEHASH_TABLE_INIT(type,next,bucket1Num,bucket2Num,comp,hash1,hash2,dumpOne) \
		sysDoubleHashTableInit(sizeof(type), offsetof(type,next), bucket1Num, bucket2Num, comp, hash1, hash2, dumpOne)

#define SYSDOUBLEHASH_ITERATE_BEGIN(pDTable,pStruAddr)					\
		{																\
			int i__;													\
			struct sysHashTable_S *pSTable__;							\
			for (i__ = 0; i__ < pDTable->bucket1Num; ++i__)				\
			{															\
				pSTable__ = pDTable->buckets_1[i__];					\
				SYSHASH_ITERATE_BEGIN(pSTable__,pStruAddr)

#define SYSDOUBLEHASH_ITERATE_END(pDTable,pStruAddr)					\
				SYSHASH_ITERATE_END(pSTable__,pStruAddr)				\
			}															\
		}
				

struct sysHashTable_S
{
    int     storageStructSize;
    int     storageNextPtrOffset;
    int     bucketNum;
    sysHashBucket_T *buckets;   /* an array; size is determined by bucketNum */

    sysHashCompare_FT compFun;
    sysHashHash_FT    hashFun;
    sysHashDumpOne_FT dumpOneFun;
};

struct sysDoubleHashTable_S
{
	int		bucket1Num;
	struct sysHashTable_S	**buckets_1; /* an array of `sysHashTable_S *` */
	sysHashHash_FT		hashFun1;
};

#endif  /* __sysHashTable_h__ */

