#include "sys.h"
#include "hal.h"
#include "hal_mmp2.h"

#if 0
#define HAL_SETREG_ASM(x, y) 		__asm__ __volatile__ ( \
										"ldr	r0, %0 \n\t" \
										"ldr	r1, %1 \n\t" \
										"str	r1, [r0] \n\t" \
										" \n\t" :: "m" (x) , "m" (y))
#else
#define HAL_SETREG_ASM(x, y) 		__asm__ __volatile__ ( \
										"ldr	r0, %0 \n\t" \
										"ldr	r1, %1 \n\t" \
										"str	r1, [r0] \n\t" \
										" \n\t" :: "m" (x) , "m" (y))
#endif

#ifndef HAL_REG_DDR2C_BASE
	#define HAL_REG_DDR2C_BASE 0x90d00000
#endif

unsigned int halGetDDR2Base(void)
{
	return HAL_REG_DDR2C_BASE;
}

/* This function is used to initialize DDR2 controller, it might be called
 * before DRAM & SW stack are enabled. So this function should be made sure
 * do not generate instruction code that uses stack */
void halInitDDR2(void)
{
#if 1
#if 1
	/* control DDR PHY */
	//HAL_SETREG_ASM(HAL_REG_DDR2C_DLLContol, 0x0008003);
	HAL_SETREG_ASM(HAL_REG_DDR2C_TimingReg3, 0x00001a29);

	/* refresh */
//	HAL_SETREG_ASM(HAL_REG_DDR2C_DRAMRefresh, 0x08200810);
	HAL_SETREG_ASM(HAL_REG_DDR2C_DRAMRefresh, 0x086c9835);

	/* control */
//	HAL_SETREG_ASM(HAL_REG_DDR2C_DRAMConfig, 0x010009a8);
	HAL_SETREG_ASM(HAL_REG_DDR2C_DRAMConfig, 0x010201c8);

	HAL_SETREG_ASM(HAL_REG_DDR2C_CtrlConfig, 0x80000004);

	HAL_SETREG_ASM(HAL_REG_DDR2C_CtrlConfig, 0x40000004);
#else

	/* control DDR PHY */
	HAL_SETREG(HAL_REG_DDR2C_DLLContol, 0x0008003);
	HAL_SETREG(HAL_REG_DDR2C_TimingReg3, 0x00001a29);

	/* refresh */
	HAL_SETREG(HAL_REG_DDR2C_DRAMRefresh, 0x08200810);

	/* control */
	HAL_SETREG(HAL_REG_DDR2C_DRAMConfig, 0x010009a8);
	HAL_SETREG(HAL_REG_DDR2C_CtrlConfig, 0x40000004);
#endif
#endif
}

////////////////////////////////////////////////////////////////////////////////////////////////
// DDR2 controller/PHY parameter calculation function.
// It is used for PLL1 FCS
////////////////////////////////////////////////////////////////////////////////////////////////

// default value
double 	tCK;		// unit: ns
double	Timer_tuning_ratio = 1.10;
// DCR
int	DDRMD = 0;
int	DIO = 2;
int	DSIZE = 4;
int	SIO = 3;
int	PIO = 0;
int	RANKS = 0;
int	RNKALL = 0;
int	AMAP = 1;
int	PDQ = 2;
int	MPRDQ = 0;
int	MVAR = 0;
int	RDIMM = 0;
int	DO_INIT = 1;
int	RANK = 0;
int	CMD = 0;
int	EXE = 0;

int	DQ_ODT = 1;
int	DQS_ODT = 1;
int	TESETEN = 0;

int	MCTL_DQ_RTT = 50; // unit: Ohm
int	MCTL_DQS_RTT = 50; // unit: Ohm

int DRAM_DS = 0; // 0: disable, 1: enable
int	DRAM_RTT = 150; // unit: Ohm

//Ted int	MCTL_DS = 1;
int	MCTL_DS_DQ = 1;
int	MCTL_DS_DQS = 1;
int	MCTL_DS_CKE = 1;
int	MCTL_DS_CK = 1;

int	AUTO_CMD_IOPD = 0;
int	AUTO_DATA_IOPD = 0;
int	RTTOH = 0; // 0: 1T, 1: 2T, etc
int	RTTOE = 0; // only 0 or 1
int	DQRTT = 1;
int	DQSRTT = 1;
// DRR
double 	tRFC = 127.5;
double	tREFI = 7800;	// Refresh Period, unit: ns
//double	tREFI = 3900;	// Refresh Period, unit: ns
int	RFBURST = 8; // only 0 ~ 8
// TPR0
int	tMRD = 2; // unit: T
double	tRTP = 7.5;
double	tWTR = 7.5;
double	tRP;
double	tRCD;
double	tRAS = 45.0;
double	tRRD = 10.0;
double	tRC;
int	tCCD_mode = 0; // MUST set to 0 when booting!! but 0 is unstable for AP...   0: BL/2 for DDR2 and 4 for DDR3, 1: BL/2 + 1 for DDR2 and 5 for DDR3
// TPR1
int	tAOND_tAOFD_mode = 0;
int	tRTW_mode = 1;
double  tFAW = 50.0;	// Four-bank activate period
int	tMOD_mode = 0; // DDR3 only
int	tRTODT_mode = 0; // DDR3 only
int	TRNKRTR_mode = 1; // 0 => 1T, 1 => 2T, 2 => 3T
int	TRNKWTW_mode = 0;
// TPR2
int	tXS = 200;
int	tXP = 8;
int	tCKE = 3;
// TPR3 (also affect to MR)
int	BL = 4;
int	BLOTF_EN_mode = 0;
int 	CL = 5; // only 5 or 6
int 	CWL;
double 	tWR = 15.0;
int 	AL = 0;
// HPCR2
int	HPBL_2 = 31;
int	HCBP_2 = 0;
int	HNPC_2 = 0;
// PQCR0
int	TOUT_0 = 1;
int	TOUTX_0 = 3;
int	LPQS_0 = 0;
int	PQBL_0 = 8;
int	SWAIT_0 = 0;
int	INTRPT_0 = 0;
int	APQS_0 = 0;

static int roundup(double a)
{
	int x = a;
	return (a > x)? x+1: x;
}

static int get_fsb(int value)
{
    int counter = 32;

    while(--counter){
        if ((value >> counter) & 1){
            return counter-1;
        }
    }
    return 0;
}

void ddr_setting_table_add(DDRSetting_T *table, int addr, int value)
{
	table->addr[table->count] = addr;
	table->value[table->count] = value;
	table->count++;
}

int halGetDDRSetting(int mSpeed, DDRSetting_T *DDRSettingTable)
{
	unsigned int set_SYSREG_0x80_VALUE;
	unsigned int set_DCR_VALUE;
	unsigned int set_IOCR_VALUE;
	unsigned int set_DRR_VALUE;
	unsigned int set_TPR0_VALUE;
	unsigned int set_TPR1_VALUE;
	unsigned int set_TPR2_VALUE;
	unsigned int set_TPR3_VALUE;
	unsigned int set_MR_VALUE;
	unsigned int set_EMR1_VALUE;
	unsigned int set_HPCR2_VALUE;
	unsigned int set_PQCR0_VALUE;

#if 0
	// real initialization value by Ted
	if(mSpeed >= 333)
	{
		MCTL_DS_DQ = 0;
//		MCTL_DS_DQS = 1;
		MCTL_DS_DQS = 0;	// for power saving @ 2012/4/30
		MCTL_DS_CKE = 0;
		MCTL_DS_CK = 0;
		// to turn off ODT @2012/4/23 for power saving
		MCTL_DQ_RTT = 0;
		MCTL_DQS_RTT = 0;

//		DQ_ODT = 1;
//		DQS_ODT = 1;
//		DRAM_DS = 0;
//		DRAM_RTT = 50;
		// to turn off DDR ODT @2012/4/30 for power saving
		DQ_ODT = 0;
		DQS_ODT = 0;
		DRAM_DS = 0;
		DRAM_RTT = 0;
	}
	else if(mSpeed >= 266)
	{
		MCTL_DS_DQ = 0;
//		MCTL_DS_DQS = 1;
		MCTL_DS_DQS = 0;	// for power saving @ 2012/4/30
		MCTL_DS_CKE = 0;
		MCTL_DS_CK = 0;
		// to turn off ODT @2012/4/23 for power saving
		MCTL_DQ_RTT = 0;
		MCTL_DQS_RTT = 0;

//		DQ_ODT = 1;
//		DQS_ODT = 1;
//		DRAM_DS = 0;
//		DRAM_RTT = 50;
		// to turn off DDR ODT @2012/4/30 for power saving
		DQ_ODT = 0;
		DQS_ODT = 0;
		DRAM_DS = 0;
		DRAM_RTT = 0;
	}
	else if(mSpeed >= 133)
	{
		MCTL_DS_DQ = 0;
		MCTL_DS_DQS = 0;
		MCTL_DS_CKE = 0;
		MCTL_DS_CK = 0;
		// to turn off ODT @2012/4/23 for power saving
		MCTL_DQ_RTT = 0;
		MCTL_DQS_RTT = 0;

//		DQ_ODT = 1;
//		DQS_ODT = 1;
//		DRAM_DS = 0;
//		DRAM_RTT = 150;
		// to turn off DDR ODT @2012/4/30 for power saving
		DQ_ODT = 0;
		DQS_ODT = 0;
		DRAM_DS = 0;
		DRAM_RTT = 0;
	}
#else
	// to turn off driving strength @ 2012/4/30 for power saving
	MCTL_DS_DQ = 0;
	MCTL_DS_DQS = 0;
	MCTL_DS_CKE = 0;
	MCTL_DS_CK = 0;
	// to turn off ODT @2012/4/23 for power saving
	MCTL_DQ_RTT = 0;
	MCTL_DQS_RTT = 0;
	// to turn off DDR ODT @2012/4/30 for power saving
	DQ_ODT = 0;
	DQS_ODT = 0;
	DRAM_DS = 0;
	DRAM_RTT = 0;
#endif

	tCK = (float)1000/mSpeed;
 	CWL = CL -1;

	tRCD = (CL == 5) ? 12.5 : 15.0;
	tRP = (CL == 5) ? 12.5 : 15.0;
	tRC = (CL == 5) ? 57.5 : 60.0;

	int c_MCTL_DQ_RTT = (DQ_ODT == 0) ? 0 :
		MCTL_DQ_RTT == 150 ? 1 :
		MCTL_DQ_RTT == 75 ? 2 :
		MCTL_DQ_RTT == 50 ? 3 : 0;
	int c_MCTL_DQS_RTT = (DQS_ODT == 0) ? 0 :
		MCTL_DQS_RTT == 150 ? 1 :
		MCTL_DQS_RTT == 75 ? 2 :
		MCTL_DQS_RTT == 50 ? 3 : 0;
	int c_DRAM_RTT_mode_bit0 = (DRAM_RTT == 75 || DRAM_RTT == 50) ? 1 : 0;
	int c_DRAM_RTT_mode_bit1 = (DRAM_RTT == 150 || DRAM_RTT == 50) ? 1 : 0;
	int c_DQRTT = DQ_ODT ? DQRTT : 0;
	int c_DQSRTT = DQS_ODT ? DQSRTT : 0;
	int c_TRFC = roundup(tRFC * Timer_tuning_ratio/tCK);
	int c_TRFPRD = roundup((tREFI*(RFBURST+1)*0.95)/tCK - 200);
	int c_TRTP = roundup(tRTP * Timer_tuning_ratio/tCK);
	int c_TWTR = roundup(tWTR * Timer_tuning_ratio/tCK);
	int c_TRP = roundup(tRP * Timer_tuning_ratio/tCK);
	int c_TRCD = roundup(tRCD * Timer_tuning_ratio/tCK);
	int c_TRAS = roundup(tRAS * Timer_tuning_ratio/tCK);
	int c_TRRD = roundup(tRRD * Timer_tuning_ratio/tCK);
	int c_TRC = roundup(tRC * Timer_tuning_ratio/tCK);
	int c_TFAW = roundup(tFAW * Timer_tuning_ratio/tCK);
	int c_tWR = roundup(tWR * Timer_tuning_ratio/tCK);

	if (c_TRFC < 1) {
		c_TRFC = 1;
	} else if (c_TRFC > 255) {
		c_TRFC = 255;
	}

	if (c_TRTP < 2) {
		c_TRTP = 2;
	} else if (c_TRTP > 6) {
		c_TRTP = 6;
	}

	if (c_TWTR < 1) {
		c_TWTR = 1;
	} else if (c_TWTR > 6) {
		c_TWTR = 6;
	}

	if (c_TRP < 2) {
		c_TRP = 2;
	} else if (c_TRP > 11) {
		c_TRP = 11;
	}

	if (c_TRCD < 2) {
		c_TRCD = 2;
	} else if (c_TRCD > 11) {
		c_TRCD = 11;
	}

	if (c_TRAS < 2) {
		c_TRAS = 2;
	} else if (c_TRAS > 31) {
		c_TRAS = 31;
	}

	if (c_TRRD < 1) {
		c_TRRD = 1;
	} else if (c_TRRD > 8) {
		c_TRRD = 8;
	}

	if (c_TRC < 2) {
		c_TRC = 2;
	} else if (c_TRC > 42) {
		c_TRC = 42;
	}

	if (c_TFAW < 2) {
		c_TFAW = 2;
	} else if (c_TFAW > 31) {
		c_TFAW = 31;
	}

	if (c_tWR > 5) {
		c_tWR = 5;
	} else if (c_tWR < 1) {
		c_tWR = 1;
	}

	set_SYSREG_0x80_VALUE = (0x3ff) | (c_MCTL_DQS_RTT << 16) | (c_MCTL_DQ_RTT << 18) | (MCTL_DS_DQ << 20) | (MCTL_DS_DQS << 21) |(MCTL_DS_CKE << 22) |(MCTL_DS_CK << 23);

	set_DCR_VALUE = DDRMD | (DIO << 2) | (DSIZE << 4) | (SIO << 7) | (PIO << 10) | (RANKS << 11) | (RNKALL << 13) | (AMAP << 14) |
		(PDQ << 16) | (MPRDQ << 19) | (MVAR << 20) | (RDIMM << 21) | (DO_INIT << 24) | (RANK << 25) | (CMD << 27) | (EXE << 31);
	set_IOCR_VALUE = DQ_ODT | (DQS_ODT << 1) |
		(TESETEN << 2) |
		(c_MCTL_DQ_RTT << 3) | (c_MCTL_DQS_RTT << 5) |
		(MCTL_DS_DQ << 7) | (MCTL_DS_DQS << 8) | (MCTL_DS_CKE << 9) | (MCTL_DS_CK << 10) |
		(AUTO_CMD_IOPD << 18) | (AUTO_DATA_IOPD << 22) | (RTTOH << 26) | (RTTOE << 29) | (c_DQRTT << 30) | (c_DQSRTT << 31);
	set_DRR_VALUE  = c_TRFC | (c_TRFPRD << 8) | (RFBURST << 24);
	set_TPR0_VALUE = tMRD | (c_TRTP << 2) | (c_TWTR << 5) | (c_TRP << 8) | (c_TRCD << 12) | (c_TRAS << 16) | (c_TRRD << 21) | (c_TRC << 25) | (tCCD_mode << 31);
	set_TPR1_VALUE = tAOND_tAOFD_mode | (tRTW_mode << 2) | (c_TFAW << 3) | (tMOD_mode << 9) | (tRTODT_mode << 11) | (TRNKRTR_mode << 12) | (TRNKWTW_mode << 14);
	set_TPR2_VALUE = tXS | (tXP << 10) | (tCKE << 15);
	set_TPR3_VALUE = get_fsb(BL)| (BLOTF_EN_mode << 2) | (CL << 3) | (CWL << 7) | (c_tWR << 11) | (AL << 15);
	set_MR_VALUE = (BL == 4 ? 2 : 3) | (CL << 4) | (c_tWR << 9);
	set_EMR1_VALUE = (DRAM_DS << 1) | (c_DRAM_RTT_mode_bit0 << 2) | (AL << 3) | (c_DRAM_RTT_mode_bit1 << 6);
	set_HPCR2_VALUE = HPBL_2 | (HCBP_2 << 8) | (HNPC_2 << 9);
	set_PQCR0_VALUE = TOUT_0 | (TOUTX_0 << 8) | (LPQS_0 << 10) | (PQBL_0 << 12) | (SWAIT_0 << 20) | (INTRPT_0 << 25) | (APQS_0 << 28);

	DDRSettingTable->count = 0;
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_ODTCR, 0x000f000f);	//Ted Added
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_DCR, set_DCR_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_SYS_DDR2PhyCtrl, set_SYSREG_0x80_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_IOCR, set_IOCR_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_DRR, set_DRR_VALUE );
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_TPR0, set_TPR0_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_TPR1, set_TPR1_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_TPR2, set_TPR2_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_TPR3, set_TPR3_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_MR, set_MR_VALUE);
	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_EMR, set_EMR1_VALUE);
//Ted	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_HPCR2, set_HPCR2_VALUE);
//Ted	ddr_setting_table_add(DDRSettingTable, HAL_REG_DDR2C_PQCR0, set_PQCR0_VALUE);

	return DDRSettingTable->count;
}
