TARGET_CONFIG=A1EVB

if [ "$CROSS_COMPILE" == "" ];then
	ARM_ELF_HOME=`pwd`/../../build/toolchain/arm-elf
	if [ -d $ARM_ELF_HOME ];then
		export PATH=$ARM_ELF_HOME:$PATH
		export A1_UBOOT_TOOLCHAIN_HOME=$ARM_ELF_HOME
	else
		echo "No arm-elf toolchain in path \"$ARM_ELF_HOME\""
		echo "Need to set \"A1_UBOOT_TOOLCHAIN_HOME\" manually"
		exit 1
	fi

	export CROSS_COMPILE=arm-elf-
	export TOPDIR='pwd'
fi

if [ ! -f include/config.mk ]; then
	make ${TARGET_CONFIG}_config
fi

if [ ! -h a1soc ];then
	ln -sf arch/arm/cpu/arm926ejs/A1 a1soc
fi
if [ ! -h a1board ];then
	ln -sf board/ACTi/A1EVB a1board
fi

if [ ! -h a1arch ];then
	ln -sf arch/arm/include/asm/arch a1arch
fi

if [ $1 = env ];then
	export CROSS_COMPILE=arm-none-linux-gnueabi-
	make $1 clean
	make $1
	exit
fi
make clean
make -j8
rm -f dump
arm-elf-objdump -S u-boot > dump
cp u-boot u-boot.elf
