#ifndef __A1_IRQ_H__
#define __A1_IRQ_H__

/* number of possible interrupt */
#define N_IRQS  32

/*
 * ISR, stand for interrupt handling
 */
typedef void (*ISR_FT)(void);

/*
 * Vector Table
 */
typedef enum _IntrVector_E
{
	int_usb20		= 2,
	int_eth110		= 3,
	int_sdc			= 5,
	int_nand		= 6,
	int_isp			= 10,
	int_uart0		= 12,
	int_uart1		= 13,
	int_uart2		= 14,
	int_uart3		= 15,
	int_uart4		= 16,
	int_gpio		= 17,
	tmr1_intr		= 27,
	tmr2_intr		= 28,
	tmr3_intr		= 29,
	int_wdt_intr	= 30,
	int_lcd_intr	= 31,
}IntrVector_E;

typedef enum _INT_TYPE{USE_IRQ=0, USE_FIQ} INT_TYPE;

//Registered control struct.
typedef struct _REG_ISR_S
{
    ISR_FT          pISR;
    INT_TYPE        type;
}REG_ISR_S; 

#endif /* __A1_IRQ_H__ */
