/*
 * include/asm-arm/arch-umvp/entry-macro.S
 *
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2. This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */
#include <asm/hardware.h>
#include <asm/arch/irqs.h>

		.macro	disable_fiq
		.endm


		.macro	get_irqnr_and_base, irqnr, irqstat, base, tmp

		/*********************************************/
		/* load VIC (VIC1) status value into irqstat */
		/*********************************************/
		ldr		\base, 	=IO_ADDRESS(UMVP_VIC_BASE)
		ldr		\irqstat,	[\base, #UMVP_VIC_STATUS_OFFSET]

		/**********************************************/
		/* check each status bit and start from bit 0 */
		/**********************************************/
		mov		\irqnr,		#0
1000:	tst		\irqstat,	#1		/* Check irqstat[irqnr] is 1 or not.  */
		bne		1300f				/* If irqstat[irqnr] is 1, service    */
									/* this interrupt.                    */
		/* check next bit */
		add		\irqnr,		\irqnr,		#1
		mov		\irqstat,	\irqstat,	lsr #1

		cmp		\irqnr,		#32	/* If irqnr is number 32, all bits on VIC1 */
		beq		1300f			/* have been checked and leave this macro. */
								/* Note that the Zero bit should be 1.     */
		bne		1000b			/* continue to check next bit */

1300:
		.endm


		.macro	irq_prio_table
		.endm

