#include <mach/platform2500.h>
#include <mach/hardware.h>
#include <asm/proc-fns.h>

#define WDT_READ_REG(r)        (*((volatile unsigned int *) (IO_ADDRESS(UMVP_WDT_BASE) + r)))
#define WDT_WRITE_REG(r,v)     (*((volatile unsigned int *) (IO_ADDRESS(UMVP_WDT_BASE) + r)) = ((unsigned int)   (v)))
#define WDT_RELOAD_MAGIC	0x4755
#define A1_WDT_CNT_STS	0x00                                                                                                                                                                                                           
#define A1_WDT_RRELOAD	0x04
#define A1_WDT_RESTART	0x08
#define A1_WDT_CTRL		0x0C
#define A1_WDT_TIMEOUT	0x10
#define A1_WDT_CLR		0x14

static inline void arch_idle(void)
{
	cpu_do_idle();
}


void arch_reset(char mode)
{
	/* stop the wathdog */
	WDT_WRITE_REG (A1_WDT_CTRL, 0x0);

	/* give counter restart a smaller value */
    WDT_WRITE_REG (A1_WDT_RRELOAD, 500);
    WDT_WRITE_REG (A1_WDT_RESTART, WDT_RELOAD_MAGIC);
	/* enable WDT */
	WDT_WRITE_REG (A1_WDT_CTRL, 0xf);

	/* wait it restart */
    while(1);
}
