# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


PACKAGES_LIB_INSTALL_DIR = $(SANDBOX)/staging/lib


include usr/packages/Makefile.config

list-packages:
	@printf "Available package:\n"
	@printf "\t%s\n" $(PACKAGE_COMPS)

$(PACKAGE_COMPS:%=package-%):
	@printf "Building package: %s\n" $(subst package-,,$@)
	@make -C usr/packages CROSS_COMPILE=$(CROSS_COMPILE) $(subst package-,,$@)

$(PACKAGE_COMPS:%=package-%-install):
	@printf "Installing package: %s\n" $(subst -install,,$(subst package-,,$@))
	@make -C usr/packages CROSS_COMPILE=$(CROSS_COMPILE) $(subst package-,,$@)

$(PACKAGE_COMPS:%=package-%-clean):
	@printf "Cleaning package: %s\n" $(subst -clean,,$(subst package-,,$@))
	@make -C usr/packages CROSS_COMPILE=$(CROSS_COMPILE) $(subst package-,,$@)

$(PACKAGE_COMPS:%=package-%-distclean):
	@printf "Cleaning package: %s\n" $(subst -distclean,,$(subst package-,,$@))
	@make -C usr/packages CROSS_COMPILE=$(CROSS_COMPILE) $(subst package-,,$@)

packages-build:
	@printf "Compiling 3rd party packages\n"
	@make -C usr/packages CROSS_COMPILE=$(CROSS_COMPILE) HOST=$(HOST) all

#packages-install: packages root-fs-staging
packages-install: output packages-build packages-staging
	@printf "Installing 3rd party packages\n"
	@make -C usr/packages CROSS_COMPILE=$(CROSS_COMPILE) install

packages-clean:
	@printf "Cleaning 3rd party packages\n"
	@make -C usr/packages clean

packages-distclean:
	@printf "Distcleaning 3rd party packages\n"
	@make -C usr/packages distclean

packages-staging:
	@mkdir -p $(PACKAGES_LIB_INSTALL_DIR)

.PHONY: packages-build packages-install packages-clean \
		$(PACKAGE_COMPS:%=package-%) $(PACKAGE_COMPS:%=package-%-install) $(PACKAGE_COMPS:%=package-%-clean)
