# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


KERNEL_OUTPUT = $(SANDBOX)
KERNEL_MOD_STAGING     = $(SANDBOX)/staging/lib/modules
KERNEL_MOD_RES_STAGING = $(SANDBOX)/staging/etc/init.d
# number of processors
_NCPU ?= 1


include kernel/modules/Makefile.config

$(KMOD_COMPS:%=kernel-module-%):
	@printf "Building workspace compent: %s\n" $(subst kernel-module-,,$@)
	@make -C kernel/modules CROSS_COMPILE=$(CROSS_COMPILE) $(subst kernel-module-,,$@)

$(KMOD_COMPS:%=kernel-module-%-install):
	@printf "Installing workspace compent: %s\n" $(subst -install,,$(subst kernel-module-,,$@))
	@make -C kernel/modules CROSS_COMPILE=$(CROSS_COMPILE) $(subst kernel-module-,,$@)

$(KMOD_COMPS:%=kernel-module-%-clean):
	@printf "Cleaning workspace compent: %s\n" $(subst -clean,,$(subst kernel-module-,,$@))
	@make -C kernel/modules CROSS_COMPILE=$(CROSS_COMPILE) $(subst kernel-module-,,$@)


PREFERRED_KCONFIG = default.config
ifeq ($(TARGET_PROFILE),ipcam-ref)
	PREFERRED_KCONFIG = ipcam-ref.config
endif
ifeq ($(TARGET_PROFILE),ipcam-evb)
	PREFERRED_KCONFIG = ipcam-evb.config
endif
ifeq ($(TARGET_PROFILE),starmovie)
	PREFERRED_KCONFIG = A1-EVB.config
#	PREFERRED_KCONFIG = ipcam-ref.config
endif
ifeq ($(TARGET_PROFILE),testbench)
	PREFERRED_KCONFIG = ipcam-ref.config
endif
ifeq ($(TARGET_PROFILE),intercom-ref)
	PREFERRED_KCONFIG = intercom-ref.config
endif
ifeq ($(TARGET_PROFILE),isp-debug)
	PREFERRED_KCONFIG = isp-debug.config
endif
ifeq ($(TARGET_PROFILE),A1-EVB)
	PREFERRED_KCONFIG = A1-EVB.config
endif


kernel-menuconfig:
	@make -C kernel/linux menuconfig

kernel-build: output
	@printf "Making kernel image\n"

	@if ! diff kernel/linux/$(PREFERRED_KCONFIG) kernel/linux/.config > /dev/null; then \
		printf "Copying pre-defined configure file \"%s\" to kernel\n" $(PREFERRED_KCONFIG) ;\
		cp kernel/linux/$(PREFERRED_KCONFIG) kernel/linux/.config; \
	fi

	@pushd kernel/linux; \
	make -j$(_NCPU); \
	popd
	@cp kernel/linux/arch/arm/boot/zImage $(KERNEL_OUTPUT)
	@cp kernel/linux/arch/arm/boot/Image $(KERNEL_OUTPUT)
	@printf "Kernel image created\n"

#	@cp kernel/linux/$(PREFERRED_KCONFIG) kernel/linux/.config
#	@pushd kernel/linux; \
#	make -j$(_NCPU); \
#	popd
#	@cp kernel/linux/arch/arm/boot/zImage $(KERNEL_OUTPUT)
#	@cp kernel/linux/arch/arm/boot/Image $(KERNEL_OUTPUT)
#	@printf "Kernel image created\n"

kernel-modules-all-build: kernel-build
#	@make -C kernel/linux modules
	@pushd kernel/linux; \
	make -j$(_NCPU) modules; \
	popd
	@make -C kernel/modules all

kernel-modules-private-build: kernel-build
	@make -C kernel/modules all

kernel-modules-install: kernel-modules-all-build kernel-modules-staging kernel-module-resources-staging
	@echo "mkdir -p $(KERNEL_MOD_STAGING)" > output/copy_kmods.sh
	@gawk -F \/ '{printf "cp kernel/linux/%s $(KERNEL_MOD_STAGING)/%s\n", substr($$0, 8), $$NF}' \
			kernel/linux/modules.order >> output/copy_kmods.sh
	@chmod +x output/copy_kmods.sh
	@bash output/copy_kmods.sh
	@rm -f output/copy_kmods.sh
	@make -C kernel/modules install

kernel-modules-staging:
	@mkdir -p $(KERNEL_MOD_STAGING)

kernel-module-resources-staging:
	@mkdir -p $(KERNEL_MOD_RES_STAGING)

kernel-clean:
	@printf "Cleaning kernel files\n"
	@make -C kernel/linux clean
	@rm -f $(KERNEL_OUTPUT)/zImage

kernel-modules-private-clean:
	@printf "Cleaning private kernel modules\n"
	@make -C kernel/modules clean

.PHONY: kernel-menuconfig kernel-build \
		kernel-modules-all-build kernel-modules-private-build \
		kernel-modules-staging kernel-modules-install \
		kernel-clean kernel-modules-private-clean \
		$(KMOD_COMPS:%=kernel-module-%) $(KMOD_COMPS:%=kernel-module-%-install) $(KMOD_COMPS:%=kernel-module-%-clean)
