# (c) Copyright 2010, ACTi Corporation, Inc. ALL RIGHTS RESERVED
#
# All software are Copyright 2010 by ACTi Corporation. ALL RIGHTS RESERVED.
# Redistribution and use in source and binary forms, with or without modification,
# are strictly prohibited.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


BUILD_TOPDIR ?= $(shell pwd)
A1_TOOLCHAIN_HOME ?= $(BUILD_TOPDIR)/build/toolchain/arm
A1_UBOOT_TOOLCHAIN_HOME ?= $(BUILD_TOPDIR)/build/toolchain/arm-elf
BUILD_HOST_BIN_PATH = $(BUILD_TOPDIR)/build/host/bin
HOST ?= arm-none-linux-gnueabi
CROSS_COMPILE ?= arm-none-linux-gnueabi-
ARM_ELF_VERSION ?= $(shell cat $(BUILD_TOPDIR)/build/toolchain/ARM-ELF-CXT-VERSION)
UBOOT_PATH	?= uboot
UBOOT_VERSION ?= u-boot-2010.09
A1_UBOOT_CONFIG ?= A1EVB
RAMDISK_SIZE ?= 24576
STRIP_MODULES ?= no
NCPU ?= 1

#
# Current available profiles are:
#
#       ipcam-ref, intercom-ref, isp-debug, starmovie
#
TARGET_PROFILE ?= A1-EVB

#
# Current available compiler optimization levels are:
#
#       op-level-0, op-level-1, op-level-2, op-level-3
#
OPTIMIZATION_LEVEL ?= op-level-2


list-available-targets:
	@printf "Kernel target list : A1-EVB\n"
	@printf "UBOOT  target list : A1EVB\n"
	@printf "\n"

configure-do:
	@if [ ! -e "config.cache" ]; then \
		printf "#!/bin/bash\n\n" > config.cache; \
		printf "export BUILD_TOPDIR=%s\n" $(BUILD_TOPDIR) >> config.cache; \
		printf "export A1_TOOLCHAIN_HOME=%s\n" $(A1_TOOLCHAIN_HOME) >> \
		config.cache; \
		printf "export A1_UBOOT_TOOLCHAIN_HOME=%s\n" $(A1_UBOOT_TOOLCHAIN_HOME) >> \
		config.cache; \
		printf "export TARGET_PROFILE=%s\n" $(TARGET_PROFILE) >> config.cache; \
		printf "export OPTIMIZATION_LEVEL=%s\n" $(OPTIMIZATION_LEVEL) >> config.cache; \
		printf "export RAMDISK_SIZE=%s\n" $(RAMDISK_SIZE) >> config.cache; \
		printf "export UBOOT_PATH=%s\n" $(UBOOT_PATH) >> config.cache; \
		printf "export UBOOT_VERSION=%s\n" $(UBOOT_VERSION) >> config.cache; \
		printf "export A1_UBOOT_CONFIG=%s\n" $(A1_UBOOT_CONFIG) >> config.cache; \
		printf "export STRIP_MODULES=%s\n" $(STRIP_MODULES) >> config.cache; \
		printf "export _NCPU=%s\n" $(NCPU) >> config.cache; \
		printf "\n" >> config.cache; \
		printf "export PATH=%s:%s/bin:%s/bin:%s\n" \
		$(PATH) $(A1_TOOLCHAIN_HOME) $(A1_UBOOT_TOOLCHAIN_HOME) $(BUILD_HOST_BIN_PATH)>> \
		config.cache; \
		printf "config.cache is created\n"; \
	else \
		printf "config.cache exists already.\n"; \
		printf "To re-configure this project:\n"; \
		printf "\t1. make clean\n"; \
		printf "\t2. rm config.cache\n"; \
		printf "\t3. make configure PROFILE=[profile name]\n"; \
	fi

.PHONY: configure-do

