/******************************************************************************
 * A mini NAND control lib
 	- limitation
	- for generation small code, we made following assumption...
	- default target is chip-#0, won't select target
	- CONFIG_SYS_NAND_BASE
 ******************************************************************************/
#ifndef __A1_NAND_H_
#define __A1_NAND_H_

#define NF_SFR_STATUS_CTRL_STAT                 (0x1uL << 8)
#define NF_ERR_NO_ERRORS                0x00u
#define NF_ERR_TIMEOUT                  0x0Bu

/** Controller commands register */
#define NF_SFR_COMMAND          0x00
/** The main configurations register */
#define NF_SFR_CONTROL          0x04
/** The controller status register */
#define NF_SFR_STATUS           0x08
/** Interrupts mask register */
#define NF_SFR_INT_MASK         0x0C
/** Interrupts status register */
#define NF_SFR_INT_STATUS       0x10
/** The ECC module statuses register. */
#define NF_SFR_ECC_CTRL         0x14
/** The ECC offset in the spare area. */
#define NF_SFR_ECC_OFFSET       0x18
/** The most significant part of the address register 0. */
#define NF_SFR_ADDR0_H          0x24
/** The least significant part of the address register 0. */
#define NF_SFR_ADDR0_L          0x1C
/** The most significant part of the address register 1. */
#define NF_SFR_ADDR1_H          0x28
/** The least significant part of the address register 1. */
#define NF_SFR_ADDR1_L          0x20
/** The SPARE_SIZE register 
 * it stores the actual value of the NAND flash device 
 * spare area size */
#define NF_SFR_SPARE_SIZE       0x30
/** The hardware protect against the write/erase process control register. */
#define NF_SFR_PROTECT          0x38
/** Enables Look-up registers during NAND Flash memory addressing. */
#define NF_SFR_LOOKUP_EN        0x40
/** Look Up Table register 0. LUT is used to address remapping. */
#define NF_SFR_LOOKUP0          0x44
/** Look Up Table register 1. LUT is used to address remapping. */
#define NF_SFR_LOOKUP1          0x48
/** Look Up Table register 2. LUT is used to address remapping. */
#define NF_SFR_LOOKUP2          0x4C
/** Look Up Table register 3. LUT is used to address remapping. */
#define NF_SFR_LOOKUP3          0x50
/** Look Up Table register 4. LUT is used to address remapping. */
#define NF_SFR_LOOKUP4          0x54
/** Look Up Table register 5. LUT is used to address remapping. */
#define NF_SFR_LOOKUP5          0x58
/** Look Up Table register 6. LUT is used to address remapping. */
#define NF_SFR_LOOKUP6          0x5C
/** Look Up Table register 7. LUT is used to address remapping. */
#define NF_SFR_LOOKUP7          0x60
/** DMA module first transfer address offset. */
#define NF_SFR_DMA_ADDR         0x64
/** DMA module counters initial value. */
#define NF_SFR_DMA_CNT          0x68
/** DMA module control register. */
#define NF_SFR_DMA_CTRL         0x6C
/** The memory device control register. */
#define NF_SFR_MEM_CTRL         0x80
/** The custom page size value. */
#define NF_SFR_DATA_SIZE        0x84
/** The custom page size value. */
#define NF_SFR_READ_STATUS      0x88
/** The command sequence timings configuration SFR. */
#define NF_SFR_TIME_SEQ_0       0x8C
/** The command sequence timings configuration SFR. */
#define NF_SFR_TIME_SEQ_1       0xBC
/** The timings configurations register 0. */
#define NF_SFR_TIMINGS_ASYN     0x90
/** The timings configurations register 1. */
#define NF_SFR_TIMINGS_SYN      0x94
/** The FIFO module interface. */
#define NF_SFR_FIFO_DATA        0x98
/** The DQS signal delay select. */
#define NF_SFR_TIME_MODE        0x9C
/** The DMA module address offset. */
#define NF_SFR_DMA_ADDR_OFFSET  0xA0
/** The FIFO_INIT register 
 * it is a control register for the FIFO module. */
#define NF_SFR_FIFO_INIT        0xB0
/** it stores the set of the configuration for the two generic sequences 
 * available to mimic the almost any command available in the 
 * present or in the future NAND flash devices */
#define NF_SFR_GENERIC_SEQ_CTRL 0xB4
/* The latest release move ECC_STAT out of ECC_CTRL */
#define NF_SFR_ECC_STAT			0xC4


/** Enable transfer custom data block instead of full data page*/
#define NF_SFR_CONTROL_CUSTOM_DATA_SIZE_EN      (0x1uL << 11)
/** Hardware ECC support enable  */
#define NF_SFR_CONTROL_ECC_EN                   (0x1uL << 5)
/** Enable spare area for the given command sequence */
#define NF_SFR_CONTROL_SPARE_EN                 (0x1uL << 3)
#define NF_SFR_DMA_READY_FLAG                   (0x1uL << 0)
#define NF_SFR_STATUS_MEMX_RDY(x)               (0x1uL << x)

#define DMA_START	(0x1uL << 7)
#define DMA_READ	(0x1uL << 6)
#define DMA_WRITE	(0x0uL << 6)

/** incremental burst (burst length is four) */
#define DMA_CTRL_INC_BURST_LENGTH_4      (0x0uL << 2)

/** Stream burst (address const)  */
#define DMA_CTRL_STREAM_BURST            (0x1uL << 2)

/** single transfer (address increment) */
#define DMA_CTRL_SINGLE_TRANSFER         (0x2uL << 2)

/** burst of unspecified length (address increment) */
#define DMA_CTRL_BURST                   (0x3uL << 2)

/** incremental burst (burst length eight) */
#define DMA_CTRL_INC_BURST_LENGTH_8      (0x4uL << 2)

/** incremental burst (burst length sixteen) */
#define DMA_CTRL_INC_BURST_LENGTH_16     (0x5uL << 2)


#endif 	/* End of __A1_NAND_H_ */
