#!/bin/sh
CONFIG_DIR=/etc/config

if [ ! -d $CONFIG_DIR ]; then
	echo "$CONFIG_DIR not a directory!!"
	exit 1
fi

cd $CONFIG_DIR > /dev/null

DEFAULT_CONFIG=/etc/default/default.conf
UPDATE_CONFIG=update.conf
FOUND_TAG=0

if [ -f $UPDATE_CONFIG ]; then
	# check the integrity of update.conf in the next steps
	cp $UPDATE_CONFIG update_00000000.conf
fi

FILES=$(ls -Xr /etc/config/update_*)
for d in $FILES
do
	if [ $FOUND_TAG -eq 1 ]; then
		# remove all old backups
		rm $d
	else
		HEAD=0
		line=`head -n 1 $d`
		tag=`echo $line | cut -d= -f1`
		value=`echo $line | cut -d= -f2`
		if [ "$tag" = "MAGIC" ]; then
			HEAD=1
			TAIL_NUM=1
			line=`tail -n $TAIL_NUM $d`
			while [ -z $line ]; do
				TAIL_NUM=`expr $TAIL_NUM + 1`
				line=`tail -n $TAIL_NUM $d`		
			done
			tag=`echo $line | cut -d= -f1`
			if [ "$tag" = "ENDFILE" -a $HEAD -eq 1 ]; then
				mv $d $UPDATE_CONFIG
				FOUND_TAG=1
			else
				if [ "$d" = "update_00000000.conf" ]; then
					rm $UPDATE_CONFIG
					echo "check_updatefile: error. ENDFILE is lost in $UPDATE_CONFIG"
				fi
				rm $d
				echo "check_updatefile: error. ENDFILE is lost in $d"
			fi
		else
			if [ "$d" = "update_00000000.conf" ]; then
				rm $UPDATE_CONFIG
				echo "check_updatefile: error. MAGIC is lost in $UPDATE_CONFIG"
			fi
			rm $d
			echo "check_updatefile: error. MAGIC is lost in $d"
		fi
	fi
done

cd - > /dev/null
