/*
 * ASoC driver for UMVP platform
 *
 * Author:      Betta Lin, <Betta.Lin@acti.com>
 * Copyright:   (C) 2010 ACTI, Inc., 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/pcm_params.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

#include <asm/dma.h>
#include <mach/hardware.h>
#include <mach/platform2500.h>


#include "../codecs/ssm2602.h"
#include "umvp-pcm.h"
#include "umvp-i2s.h"


/*
SND_SOC_DAIFMT_NB_NF :           
normal bit clock + frame 
*/
#if 0
/* cpu is master; codec clk & frame slave */
#define AUDIO_FORMAT SND_SOC_DAIFMT_I2S | SND_SOC_DAIFMT_NB_NF | SND_SOC_DAIFMT_CBS_CFS
#else
/* cpu is slave; codec clk & frame master */
#define AUDIO_FORMAT SND_SOC_DAIFMT_I2S | SND_SOC_DAIFMT_NB_NF | SND_SOC_DAIFMT_CBM_CFM

#endif


static int umvp_hw_params(struct snd_pcm_substream *substream,
	struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	struct snd_soc_dai *codec_dai = rtd->dai->codec_dai;
	struct snd_soc_dai *cpu_dai = rtd->dai->cpu_dai;
	unsigned int clk = 0;
	int ret = 0;


//	params_channels(params) = 1;

 //   printk("umvp_hw_params(): format = %d, channels = %d, rate = %d\n", params_format(params),params_channels(params),params_rate(params));

/* The followings are sampling rate supported by ssm2602 */
	switch (params_rate(params)) {
	case 8000:
	case 16000:
	case 48000:
	case 96000:
	/* clk = 48000 x 256 fs */
		clk = 12288000; 
		break;
	case 11025:
	case 22050:
	case 44100:
	/* clk = 44100 x 256 fs */
		clk = 11289600;
		break;
	}
	
	/* set codec DAI configuration */
		
	ret = snd_soc_dai_set_fmt(codec_dai, AUDIO_FORMAT);
	if (ret < 0)
		return ret;

	/* set cpu DAI configuration */
	ret = snd_soc_dai_set_fmt(cpu_dai, AUDIO_FORMAT);
	if (ret < 0)
		return ret;

	/*
		@snd_soc_dai_set_sysclk(struct snd_soc_dai *dai, int clk_id,
			unsigned int freq, int dir);
		=> dai->ops.set_sysclk(dai, clk_id, freq, dir);

		@clk_id: clock ID
		@freq: the frequency of the given clock ID, currently ignored
		@dir: SND_SOC_CLOCK_IN (clock slave) or SND_SOC_CLOCK_OUT (clock master)
	*/
	
	/* set the codec system clock for DAC and ADC */
	ret = snd_soc_dai_set_sysclk(codec_dai, 0, clk, SND_SOC_CLOCK_IN);
	/* => call ssm2602_set_dai_sysclk */
	if (ret < 0)
		return ret;

#if 0	//ted
	/* 12M/clk */
	if ( (UMVP2500_APBCLOCK / clk ) > 1 )
	{
		int div = UMVP2500_APBCLOCK/clk;
		snd_soc_dai_set_clkdiv(cpu_dai, UMVP_CODEC_CLK_DIV_ON, div);
	}
	else 
	{
		snd_soc_dai_set_clkdiv(cpu_dai, UMVP_CODEC_CLK_DIV_OFF, 0);
	}
#else
	snd_soc_dai_set_clkdiv(cpu_dai, UMVP_CODEC_CLK_DIV_OFF, 0);
#endif
	if (ret < 0)
		return ret;

	return 0;
}
		

static struct snd_soc_ops umvp_ops = {
	.hw_params = umvp_hw_params,
};

#if 1
static const struct snd_soc_dapm_widget umvp_dapm_widgets[] = {
	SND_SOC_DAPM_HP("Headphone Jack", NULL),
	SND_SOC_DAPM_MIC("Mic Jack", NULL),
	
};

static const struct snd_soc_dapm_route audio_map[] = {

	/* headphone connected to LHPOUT1, RHPOUT1 */
	{"Headphone Jack", NULL, "LHPOUT"},
	{"Headphone Jack", NULL, "RHPOUT"},

	/* mic is connected to Mic Jack, with ssm2602 Mic Bias */
	{"MICIN", NULL, "Mic Bias"},
	{"Mic Bias", NULL, "Mic Jack"},
};

/*
 * Logic for a ssm2602 as connected on a at91sam9g20ek board.
 */
static int ssm2602_pins_init(struct snd_soc_codec *codec)
{
	printk(KERN_DEBUG
			"at91sam9g20ek_ssm2602 "
			": at91sam9g20ek_ssm2602_init() called\n");

	/* Add specific widgets */
	snd_soc_dapm_new_controls(codec, umvp_dapm_widgets,
				  ARRAY_SIZE(umvp_dapm_widgets));
	/* Set up specific audio path interconnects */
	snd_soc_dapm_add_routes(codec, audio_map, ARRAY_SIZE(audio_map));

	/* not connected */
	snd_soc_dapm_nc_pin(codec, "RLINEIN");
	snd_soc_dapm_nc_pin(codec, "LLINEIN");
	snd_soc_dapm_nc_pin(codec, "LOUT");
	snd_soc_dapm_nc_pin(codec, "ROUT");
	

	/* always connected */
	snd_soc_dapm_enable_pin(codec, "Mic Jack");
	snd_soc_dapm_enable_pin(codec, "Headphone Jack");

	snd_soc_dapm_sync(codec);

	return 0;
}



#endif
/* umvp digital audio interface glue - connects codec <--> CPU */
static struct snd_soc_dai_link umvp_dai = {
	.name = "SSM2602",
	.stream_name = "SSM2602",
	.cpu_dai = &umvp_i2s_dai,  /* defined in umvp-i2s.c */
	.codec_dai = &ssm2602_dai, /*  defined in ssm2602.c */
/* unconnected codec pins can be set and 
	 machine specific audio mixer controls can be added 
	 in the DAI init function
*/	
	.init = ssm2602_pins_init,
	.ops = &umvp_ops, 
};

/* umvp audio machine driver */
static struct snd_soc_card snd_soc_card_umvp = {
	.name = "UMVP ssm2602",
	.platform = &umvp_soc_platform, /* defined in umvp-pcm.c */
	.dai_link = &umvp_dai,
	.num_links = 1,
};

/* umvp audio private data */

static struct ssm2602_setup_data umvp_ssm2602_setup = {
	.i2c_bus = 0,
	.i2c_address = 0x1a,
};

/* umvp audio subsystem */
static struct snd_soc_device umvp_snd_devdata = {
	.card = &snd_soc_card_umvp,
	.codec_dev = &soc_codec_dev_ssm2602,
	.codec_data = &umvp_ssm2602_setup,
};

static struct resource umvp_snd_resources[] = {
	{
		.start = UMVP_DAI_BASE,
		.end = UMVP_DAI_BASE + SZ_4K - 1,
		.flags = IORESOURCE_MEM,
	},
};




static struct platform_device *umvp_snd_device;

static int __init umvp_ssm2602_init(void)
{
	int ret;

	/* Note : Don't change the string "soc-audio" */
	umvp_snd_device = platform_device_alloc("soc-audio", 0);
	
	if (!umvp_snd_device)
		return -ENOMEM;

	platform_set_drvdata(umvp_snd_device, &umvp_snd_devdata);
	umvp_snd_devdata.dev = &umvp_snd_device->dev;
	//umvp_snd_device->dev.platform_data = &umvp_snd_data;

	ret = platform_device_add_resources(umvp_snd_device, umvp_snd_resources,
					    ARRAY_SIZE(umvp_snd_resources));
	if (ret) {
		platform_device_put(umvp_snd_device);
		return ret;
	}

	ret = platform_device_add(umvp_snd_device);
	if (ret)
		platform_device_put(umvp_snd_device);

	return ret;
}

static void __exit umvp_ssm2602_exit(void)
{
	platform_device_unregister(umvp_snd_device);
}

module_init(umvp_ssm2602_init);
module_exit(umvp_ssm2602_exit);

MODULE_AUTHOR("Betta Lin");
MODULE_DESCRIPTION("UMVP-ssm2602 machine ASoC driver");
MODULE_LICENSE("GPL");
