

#ifndef _OTGDRV_H
#define _OTGDRV_H




#define OTGMODE_HOST          0x01
#define OTGMODE_MEDUSA        0x02


#define OTG_BCWR1    (0x00/4)
#define OTG_BCSR1    (0x10/4)
#define OTG_BCISR1    (0x20/4)
#define OTG_BCIER1    (0x30/4)
#define OTG_BCIDR1    (0x40/4)


#define BCWR0   0
#define BCWR1   1
#define BCSR0   4
#define BCISR0  8
#define BCISR1  9
#define IER0    12   
#define IER1    13   
#define IDR0    16
#define IDR1    17

#define BSRP_VBUS               1
#define BSRP_DPLUS              2
#define BSRP_BOTH               3
#define BSRP_DISCHARGE_VBUS     4

enum HOST_CONTROLLER
{
    HOST_UHCI = 1,
    HOST_EHCI,
    WAIT_EHCI_DISCONNECT_EVENT,
    WAIT_UHCI_DISCONNECT_EVENT,
    DEVICE
};
typedef enum HOST_CONTROLLER HOST_CONTROLLER;


struct otg_device
{
    struct usb_hcd *otg_ehci;
    struct uhci_hcd *otg_uhci;
    int irq;
    struct timer_list    timer;
};

enum AHNP_STATE
{
    DETECTION_HNP_SUCCESS,
    DEVICE_NOT_SUPPORT_HNP,
    DETECTION_HNP_FAILED,
    NO_REQUEST_HNP,
    DEVICE_NOT_BE_ENABLED_HNP,
};
typedef enum AHNP_STATE AHNP_STATE;



enum BHNP_STATE
{
    BHNP_IDLE,
    BHNP_FAILED,
    BHNP_SUCCESS
};
typedef enum BHNP_STATE BHNP_STATE;


extern int isHost;
extern int reqHNPA;   // HNP request command from keyobard
extern int reqHNPB;
extern int reqSRPB;



void SRP_AdeviceVBUS(int isOn);
void BDeviceSRP(void);


int isHNP_A(void);
void HNP_DetectionB(unsigned int);
AHNP_STATE HNP_ADevice(void);


int HNP_BDevice(void);
void HNP_Enable_BDevice(void);

void HNP_BDeviceReturnToB(void);
BHNP_STATE isHNP_B(void);
void HNP_Disable_BDevice(void);


int disconnectA_OTG(void);
void Init_OTG(void);
int ConnectA_OTG(int _isAHNP);
void Return_To_AIDLE(int portno);

void  Interrupt_OTG(unsigned int);
int isLowPower_OTG(void);
int Detect_IDPID_OTG(void);
int ConnectB_OTG(void);
int isDisconnectB_OTG(void);
int SRP_DetectionA(void);

void set_otg_feature(int selector);

void change_host_state(HOST_CONTROLLER _owner);


#endif //_OTGDRV_H


