
#include <linux/usb.h>

//#include "medusa.h"
#include "otg_drv.h"

#if 0
#define dprintk        printk
#else
#define dprintk(msg...) do { } while(0)
#endif


int   MediaInit=1;
struct Capab *capability;
//unsigned int cbw_buffer1[31];
//unsigned int cbw_buffer2[31];
unsigned int cbw_flag =1;

//unsigned int cap[2]={0};
//unsigned abc=0;

unsigned char * Sector[0x870];
unsigned char * PhySector[0x870];
//unsigned char * TempMem;
//unsigned long * mbr_buffer;
//unsigned long * phy_mbr_buffer;

unsigned long * disk_buffer;

unsigned long * medusa_base;
//unsigned long index =0;

////////////////
unsigned int bHighSpeed=1;                 //by default, USB Speed is 2.0
unsigned int bOldSpeed=1;
unsigned int flag_datastage_value;
//unsigned int data_buffer[4112] __attribute__ ((aligned (4))); ;
//unsigned char xfer_buffer[64];
unsigned char *xfer_buffer;
unsigned long *virt_addr;
//unsigned int initMedusaIndex=0;
int  ctrl_cs;                 // Current CTRL stage
dma_addr_t *phy_des_addr;

unsigned int bSuspendAckLater=0;

extern void GlobalSuspendSet(void);
extern void GlobalSuspendClear(void);
extern int  GlobalSuspendCheckSet(void);

extern unsigned long *otg_base;


//#define dprintk //dprintk



struct ahb_pool        *desc_pool;
struct USBHandle *handle_s;
//struct USBHandle m_usbvHandle_g;
struct Device_Descriptor *dev_desc;
struct Configuration_Descriptor *config_desc;
struct CBW_BUFFER *cbw_buffer;
struct csw_buffer *cswbuf;
struct StdInquiryData *Inquiry_Buffer;
struct ScsiCmd *scsicmd23;
struct Mode_Buffer *modbuffer;
struct String_Descriptor *string_desc;
struct Skey_Buffer *skbuf;
struct Other_Speed *otherbuf; //Shirley 2006/01/16


#include "device.c"

//#define dprintk

int Init_Medusa(void)
{
    dprintk("Initialising Medusa \n");
/*    if (!isFirstTimeMedusa) 
    {
        // reentry();
        return 0;
    }
    isFirstTimeMedusa = 0;*/
    // Initialize Medusa        
    usbInitInMain();        
    return    0;
}


void load_usb_descriptors(struct USBHandle *usb_handle)
{
    unsigned int temp =0;


    if (bHighSpeed) 
    {
        dprintk("HiSped\n");
        //Control, TBCR0, EP_MaxSize=64 
        temp = 0x00400000;
        writel(temp,medusa_base+EDR0);
        temp = readl(medusa_base+EDR0);
                //dprintk("EDR0(%x)\n",temp);
        
        //Bulk IN, Ep_No=1, TBCR1, EP_MaxSize=512 
        temp = 0x12000019;
        writel(temp,medusa_base+EDR1);
        temp = readl(medusa_base+EDR1);
                dprintk("EDR1(%x)\n",temp);
        
        // Bulk OUT, Ep_No=2, TBCR0, EP_MaxSize=512
        temp = 0x02000021; 
        writel(temp,medusa_base+EDR2);
        temp = readl(medusa_base+EDR2);
                //dprintk("EDR2(%x)\n",temp);

        //    dprintk("Elango:EDR2 is %08x \n ",readl(medusa_base+EDR2));
        
        usb_handle->Device_DescBUFFER[0]     = 0x02000112;
        usb_handle->Device_DescBUFFER[1]     = 0x40000000;
        usb_handle->Device_DescBUFFER[2]     = 0x20000520;
        usb_handle->Device_DescBUFFER[3]     = 0x00000100;
        usb_handle->Device_DescBUFFER[4]     = 0x00000100;
        usb_handle->Device_DescBUFFER[5]     = 0x00000000;
        usb_handle->Device_DescBUFFER[6]     = 0x00000000;
        usb_handle->Device_DescBUFFER[7]     = 0x00000000;
        usb_handle->Device_DescBUFFER[8]     = 0x0200060a;
        //usb_handle->Device_DescBUFFER[9]     = 0x08000000;
        usb_handle->Device_DescBUFFER[9]     = 0x40000000;
        usb_handle->Device_DescBUFFER[10]    = 0xbeaf0001;
        usb_handle->Device_DescBUFFER[11]    = 0x00010090;
        usb_handle->Device_DescBUFFER[12]    = 0x00000100;
        usb_handle->Device_DescBUFFER[13]    = 0x00000000;
        usb_handle->Device_DescBUFFER[14]    = 0x00000000;
        usb_handle->Device_DescBUFFER[15]    = 0x00000000;

        usb_handle->Configure_DescBUFFER[0]  = 0x00200209;
        usb_handle->Configure_DescBUFFER[1]  = 0xc0010101;
        usb_handle->Configure_DescBUFFER[2]  = 0x00040932;
        usb_handle->Configure_DescBUFFER[3]  = 0x06080200;
        usb_handle->Configure_DescBUFFER[4]  = 0x05070050;
        usb_handle->Configure_DescBUFFER[5]  = 0x02000281;
        usb_handle->Configure_DescBUFFER[6]  = 0x02050700;
        usb_handle->Configure_DescBUFFER[7]  = 0x00020002;
        usb_handle->Configure_DescBUFFER[8]  = 0x00030903;
//        usb_handle->Configure_DescBUFFER[8]  = 0x03830507; //; Configuration1 Descriptor
        usb_handle->Configure_DescBUFFER[9]  = 0x00010008;
        usb_handle->Configure_DescBUFFER[10] = 0x00000000;
        usb_handle->Configure_DescBUFFER[11] = 0x00000000;
        usb_handle->Configure_DescBUFFER[12] = 0x00000000;
        usb_handle->Configure_DescBUFFER[13] = 0x00000000;
        usb_handle->Configure_DescBUFFER[14] = 0x00000000;
        usb_handle->Configure_DescBUFFER[15] = 0x00000000;      
        
        usb_handle->OtherSpeed_DescBUFFER[0]  = 0x00230709;
   		usb_handle->OtherSpeed_DescBUFFER[1]  = 0xc0000101;
    	usb_handle->OtherSpeed_DescBUFFER[2]  = 0x00040932;
    	usb_handle->OtherSpeed_DescBUFFER[3]  = 0x06080200;
    	usb_handle->OtherSpeed_DescBUFFER[4]  = 0x05070050;
    	usb_handle->OtherSpeed_DescBUFFER[5]  = 0x00400281;
    	usb_handle->OtherSpeed_DescBUFFER[6]  = 0x02050700;
    	usb_handle->OtherSpeed_DescBUFFER[7]  = 0x00004002;
		usb_handle->OtherSpeed_DescBUFFER[8]  = 0x00030903;
	//	handle_s->OtherSpeed_DescBUFFER[8]  = 0x03830507; // Other Speed Configuration1 Descriptor
    //handle_s->OtherSpeed_DescBUFFER[9]  = 0x00ff0008;
	    usb_handle->OtherSpeed_DescBUFFER[9]  = 0x00010008;
	    usb_handle->OtherSpeed_DescBUFFER[10] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[11] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[12] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[13] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[14] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[15] = 0x00000000;      
        
    }
    else 
    {
        // Control, TBCR0, EP_MaxSize=64
        dprintk("Class Speed Device \n");
            temp = 0x00400000;            
        writel(temp,medusa_base+EDR0);
        temp = readl(medusa_base+EDR0);
                dprintk("EDR0(%x)\n",temp);

      
        // Bulk IN, Ep_No=1, TBCR1, EP_MaxSize=64 
        temp = 0x10400019;
        writel(temp,medusa_base+EDR1);
        temp = readl(medusa_base+EDR1);
                dprintk("EDR1(%x)\n",temp);

        
        // Bulk OUT, Ep_No=2, TBCR0, EP_MaxSize=64
        temp = 0x00400021; 
        writel(temp,medusa_base+EDR2);
        temp = readl(medusa_base+EDR2);
                dprintk("EDR2(%x)\n",temp);

        //usb_handle->Device_DescBUFFER[0]     = 0x01100112; //orign
        usb_handle->Device_DescBUFFER[0]     = 0x02000112;
        usb_handle->Device_DescBUFFER[1]     = 0x40000000;
        usb_handle->Device_DescBUFFER[2]     = 0x20000520;
        usb_handle->Device_DescBUFFER[3]     = 0x00000100;
        usb_handle->Device_DescBUFFER[4]     = 0x00000100;
        usb_handle->Device_DescBUFFER[5]     = 0x00000000;
        usb_handle->Device_DescBUFFER[6]     = 0x00000000;
        usb_handle->Device_DescBUFFER[7]     = 0x00000000;
        usb_handle->Device_DescBUFFER[8]     = 0x0110060a;
        usb_handle->Device_DescBUFFER[9]     = 0x08000000;
        usb_handle->Device_DescBUFFER[10]    = 0xbeaf0001;
        usb_handle->Device_DescBUFFER[11]    = 0x00010090;
        usb_handle->Device_DescBUFFER[12]    = 0x00000100;
        usb_handle->Device_DescBUFFER[13]    = 0x00000000;
        usb_handle->Device_DescBUFFER[14]    = 0x00000000;
        usb_handle->Device_DescBUFFER[15]    = 0x00000000;

        usb_handle->Configure_DescBUFFER[0]  = 0x00200209;
        usb_handle->Configure_DescBUFFER[1]  = 0xc0010101;
        usb_handle->Configure_DescBUFFER[2]  = 0x00040932;
        usb_handle->Configure_DescBUFFER[3]  = 0x06080200;
        usb_handle->Configure_DescBUFFER[4]  = 0x05070050;
        usb_handle->Configure_DescBUFFER[5]  = 0x00400281;
        usb_handle->Configure_DescBUFFER[6]  = 0x02050700;
        usb_handle->Configure_DescBUFFER[7]  = 0x00004002;
        usb_handle->Configure_DescBUFFER[8]  = 0x03830507;    //; Configuration1 Descriptor
        usb_handle->Configure_DescBUFFER[9]  = 0x00010008;
        usb_handle->Configure_DescBUFFER[10] = 0x00000000;
        usb_handle->Configure_DescBUFFER[11] = 0x00000000;
        usb_handle->Configure_DescBUFFER[12] = 0x00000000;
        usb_handle->Configure_DescBUFFER[13] = 0x00000000;
        usb_handle->Configure_DescBUFFER[14] = 0x00000000;
        usb_handle->Configure_DescBUFFER[15] = 0x00000000;
        
        usb_handle->OtherSpeed_DescBUFFER[0]  = 0x00230709;
   		usb_handle->OtherSpeed_DescBUFFER[1]  = 0xc0000101;
    	usb_handle->OtherSpeed_DescBUFFER[2]  = 0x00040932;
    	usb_handle->OtherSpeed_DescBUFFER[3]  = 0x06080200;
    	usb_handle->OtherSpeed_DescBUFFER[4]  = 0x05070050;
    	usb_handle->OtherSpeed_DescBUFFER[5]  = 0x02000281;
    	usb_handle->OtherSpeed_DescBUFFER[6]  = 0x02050700;
    	usb_handle->OtherSpeed_DescBUFFER[7]  = 0x00020002;
		usb_handle->OtherSpeed_DescBUFFER[8]  = 0x00030903;
	//	handle_s->OtherSpeed_DescBUFFER[8]  = 0x03830507; // Other Speed Configuration1 Descriptor
    //handle_s->OtherSpeed_DescBUFFER[9]  = 0x00ff0008;
	    usb_handle->OtherSpeed_DescBUFFER[9]  = 0x00010008;
	    usb_handle->OtherSpeed_DescBUFFER[10] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[11] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[12] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[13] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[14] = 0x00000000;
	    usb_handle->OtherSpeed_DescBUFFER[15] = 0x00000000;      
        

    }

    temp = 0xffffffff;
    writel(temp,medusa_base+EDR3);
        temp = readl(medusa_base+EDR3);
        //dprintk("EDR3(%x)\n",temp);

      
    // Bulk IN, Ep_No=1, TBCR1, EP_MaxSize=512 
    temp = 0xffffffff;
    writel(temp,medusa_base+EDR4);
    temp = readl(medusa_base+EDR4);
        //dprintk("EDR4(%x)\n",temp);
        
    // Bulk OUT, Ep_No=2, TBCR0, EP_MaxSize=512
    temp = 0xffffffff; 
    writel(temp,medusa_base+EDR5);
    temp = readl(medusa_base+EDR5);
        //dprintk("EDR5(%x)\n",temp);

        // Bulk OUT, Ep_No=2, TBCR0, EP_MaxSize=512
    temp = 0xffffffff; 
    writel(temp,medusa_base+EDR6);
    temp = readl(medusa_base+EDR6);
        //dprintk("EDR6(%x)\n",temp);


        usb_handle->Qualifier_DescBUFFER[0]  = 0x0200060a;
        usb_handle->Qualifier_DescBUFFER[1]  = 0x40000000;
        usb_handle->Qualifier_DescBUFFER[2]  = 0x00000001;
	/* orign
	handle_s->OtherSpeed_DescBUFFER[0]  = 0x00230709;
    handle_s->OtherSpeed_DescBUFFER[1]  = 0xc0000101;
    handle_s->OtherSpeed_DescBUFFER[2]  = 0x00040932;
    handle_s->OtherSpeed_DescBUFFER[3]  = 0x06080200;
    handle_s->OtherSpeed_DescBUFFER[4]  = 0x05070050;
    handle_s->OtherSpeed_DescBUFFER[5]  = 0x00400281;
    handle_s->OtherSpeed_DescBUFFER[6]  = 0x02050700;
    handle_s->OtherSpeed_DescBUFFER[7]  = 0x00004002;
	handle_s->OtherSpeed_DescBUFFER[8]  = 0x00030903;
//	handle_s->OtherSpeed_DescBUFFER[8]  = 0x03830507; // Other Speed Configuration1 Descriptor
    //handle_s->OtherSpeed_DescBUFFER[9]  = 0x00ff0008;
    handle_s->OtherSpeed_DescBUFFER[9]  = 0x00010008;
    handle_s->OtherSpeed_DescBUFFER[10] = 0x00000000;
    handle_s->OtherSpeed_DescBUFFER[11] = 0x00000000;
    handle_s->OtherSpeed_DescBUFFER[12] = 0x00000000;
    handle_s->OtherSpeed_DescBUFFER[13] = 0x00000000;
    handle_s->OtherSpeed_DescBUFFER[14] = 0x00000000;
    handle_s->OtherSpeed_DescBUFFER[15] = 0x00000000;
	*/
	
    handle_s->String_DescBuffer[0]    = 0x04090304; // String0 Descriptor
    handle_s->String_DescBuffer[1]    = 0x00000000;
    handle_s->String_DescBuffer[2]    = 0x0074030A; // String1 Descriptor
    handle_s->String_DescBuffer[3]    = 0x006D0073;
    handle_s->String_DescBuffer[4]    = 0x00000063;
    handle_s->String_DescBuffer[5]    = 0x00000000;
    handle_s->String_DescBuffer[6]    = 0x00550314; // String2 Descriptor
    handle_s->String_DescBuffer[7]    = 0x00500041;
    handle_s->String_DescBuffer[8]    = 0x002D0046;
    handle_s->String_DescBuffer[9]    = 0x00300032;
    handle_s->String_DescBuffer[10]   = 0x00300030;
    handle_s->String_DescBuffer[11]   = 0x00000000;
    handle_s->String_DescBuffer[12]   = 0x00310308; // String3 Descriptor
    handle_s->String_DescBuffer[13]   = 0x0031002E;
    handle_s->String_DescBuffer[14]   = 0x00000000;
    handle_s->String_DescBuffer[15]   = 0x00000000;
    
    // alex added for logo test ===============

     handle_s->String_DescBuffer[16]    =  0x0031032A; // String4 Descriptor
     handle_s->String_DescBuffer[17]    =  0x00300030;
     handle_s->String_DescBuffer[18]    =  0x00320030;
     handle_s->String_DescBuffer[19]    =  0x00300030;
     handle_s->String_DescBuffer[20]    =  0x00310030;
     handle_s->String_DescBuffer[21]    =  0x00300030;
     handle_s->String_DescBuffer[22]    =  0x00300030; 
     handle_s->String_DescBuffer[23]    =  0x00300030;
     handle_s->String_DescBuffer[24]    =  0x00300030;
     handle_s->String_DescBuffer[25]    =  0x00370038;
     handle_s->String_DescBuffer[26]    =  0x00000032;	
     handle_s->String_DescBuffer[27]    =  0x00000000;
    
    handle_s->OTG_DescBuffer[0]       = 0x00030903; // HNP, SRP Support
}


void set_scsi_capicitybuf(struct USBHandle *usb_handle)
{
    // dprintk("Inside set_scsi_capicitybuf \n");
    //unsigned int sizedata=0;
    //unsigned int sizedata=0x3e00000;   // 62MBytes
    
    unsigned int sizedata=VIRDISKSIZE; //0x1EA0000;   // 30.6MBytes
    unsigned int tmpval;

    //sizedata  =    smGetMediaSize()    /    512;
    sizedata  =    sizedata    /    512;

    tmpval    =    ((sizedata & 0xff) << 24);
    tmpval    |=   ((sizedata & 0xff00) << 8);
    tmpval    |=   ((sizedata & 0xff0000) >> 8);
    tmpval    |=   ((sizedata & 0xff000000) >> 24);

    // dprintk("tmpval is %08x ",tmpval);

    //usb_handle->CAP_BUFFER[0]     =    tmpval;
    handle_s->CAP_BUFFER[0]     =    tmpval;
    //dprintk("handle_s->CAP_BUFFER[0] is %08x \n",handle_s->CAP_BUFFER[0]);

    //usb_handle->CAP_BUFFER[0]   =    0xffe90100;
    
    handle_s->CAP_BUFFER[1]     =    0x00020000;
    // dprintk("handle_s->CAP_BUFFER[1] is %08x \n",handle_s->CAP_BUFFER[1]);

}


void medusa_suspendACK(void)
{
  unsigned int temp;    
  
   temp = 0x00000008;
   writel(temp,medusa_base+ISR);              
   writel(temp,medusa_base+IER); // Enable Suspend Event     
}

void medusa_interrupt(struct pt_regs *regs)
#if 1
{
    unsigned int medusa_isr=0;
    unsigned int temp      =0;
    static unsigned int isr_cnt   =0;
    
    //printk("i");    
    
    medusa_isr = readl(medusa_base+ISR);
    
    if(medusa_isr==0x20||medusa_isr==0x100 ||medusa_isr==0x120){
       dprintk("Only SOF event %x\n", medusa_isr);
       writel(medusa_isr,medusa_base+ISR);    
	return ;
    }


	
    if(isr_cnt % (1<<6) ==0)
    {
      dprintk("ISR event %x\n", medusa_isr);    
      isr_cnt++;            
    }
    
    
    if (medusa_isr ) 
    {
        // dprintk("Interrupt from the Medusa Controller \n");
        // Connect

	
        if (medusa_isr & 0x00000001) 
        {
            temp = 0x00000001;
            writel(temp,medusa_base+ISR);
            temp = readl(medusa_base+ISR);
            reset_medusa();            
            printk("USB Connect\n");
        }
        //DisConnect
        else if (medusa_isr & 0x00000002) 
        {
            writel(0x00000002,medusa_base+ISR);
//            _ConnectB =0;
            reset_medusa();            
            printk("USB Disconnect\n");
  
            }
            // Reset Event
        else if (medusa_isr & 0x00000004) 
        {        
            
            temp = 0x00000004;
            writel(temp,medusa_base+ISR);                
            temp = readl(medusa_base+UDCR);
            
            if(temp & 0x00040000)
            {
                //printk("High Speed\n");
                bHighSpeed = 1;
            }
            else
            {
                //printk("Full Speed\n");
                bHighSpeed = 0;
            }
                        if (bOldSpeed != bHighSpeed) {
                bOldSpeed = bHighSpeed;
            }
             
                     //bHighSpeed = 1; //Shirley 2006/01/17
            reset_medusa();
            load_usb_descriptors(handle_s);
            Speed_Switch(bHighSpeed);            
            printk("Reset\n");
            GlobalSuspendClear();
            //check return USB_RESET_EVT;
        }

        //Suspend Event
        else if (!bSuspendAckLater && (medusa_isr & 0x00000008)) 
        {
            
            //printk("Suspend begin: %lx\n", medusa_isr);  //lcc0117
            // Ack later in process context
            bSuspendAckLater = 1;
            temp = 0x00000008;
            writel(temp,medusa_base+IDR); // Disable Suspend Event
            //writel(temp,medusa_base+ISR);    
            if(!GlobalSuspendSetCheck())        
              printk("USB Suspend Event\n");
                         
            GlobalSuspendSet();

        }
		
		// Resume Event
        else if (medusa_isr & 0x00000010) 
        {
            GlobalSuspendClear();
            temp = 0x00000010; 
            writel(temp,medusa_base+ISR);            
            printk("Resume Event\n");  //lcc0117
            
        }
                
        //Bulk Out Event
        else if (medusa_isr & 0x02000000)         
        {    
            temp = (readl(medusa_base+PRIR) & 0x000007ff);
            handle_s->data_cnt = temp;
            bulkout(handle_s);            
            dprintk("BU End\n");
            
        }            
        // BulkIn Event
        else if (medusa_isr & 0x01000000) 
        {       
            handle_s->data_cnt = 512;
            bulkin(handle_s);            
            dprintk("BI End\n");            
            //check    return USB_BULKIN_EVT;
        
        }
        // Control 0 Setup Event
        else if (medusa_isr & 0x00010000) 
        {        
            // dprintk("=====  Setup Event  ===== \n");
            temp = (readl(medusa_base+PRIR) & 0x000007ff);
            handle_s->data_cnt = temp;
        
            temp = readl(medusa_base+PRIR);
            temp = (temp >>16) & 0x000000ff;
        
            handle_s->pep_c = temp;
            msgpipe(handle_s,CTRL_SETUP);            
            dprintk("Setup Event End \n");
        
            }
                // Control Out Event
        else if (medusa_isr & 0x00020000) 
        {
            // dprintk("=====Control EP0 Out Event===== \n");
            handle_s->data_cnt = (readl(medusa_base+PRIR) & 0x000007ff);
            temp = readl(medusa_base+PRIR);
            handle_s->pep_c = (temp >>16) & 0x000000ff;
            msgpipe(handle_s, CTRL_OUT);
            //printk("Control EP0\n");
                        //check return USB_CTRL_OUT_EVT;
        }    
        // USB_CTRL_IN_EVT
        else if (medusa_isr & 0x00040000) 
        {
            // dprintk("\n=====Control In EP0 Event===== \n");
            temp = readl(medusa_base+PRIR);
            //dprintk("PRIR Byte Count is %8x \n",readl(medusa_base+PRIR));
            temp &= 0x000007ff;
            //dprintk("value of temp after anding the  valus is %8x \n",temp);
            handle_s->data_cnt = temp;
            //dprintk("handle_s->data_cnt In data Requested is %8x \n",handle_s->data_cnt);
            //Physical Endpoint Number
            temp = readl(medusa_base+PRIR);
            //dprintk("Post Request Information Register value is %8x \n",readl(medusa_base+PRIR));
            temp = temp >> 16;
            temp &= 0x000000ff;
            //dprintk("for the EndPoint No : %x \n",temp);
        
            handle_s->pep_c = temp;
            //dprintk("handle_s->pep_c is %8x \n",handle_s->pep_c);
            msgpipe(handle_s,CTRL_IN);
            //printk("Control In EP0 Event End\n");
            //check return USB_CTRL_IN_EVT;
        }
        // USB_CTRL_QUERY_EVT
        else if (medusa_isr & 0x00080000) 
        {
            msgpipe(handle_s, CTRL_STATUS);
            //check return    USB_CTRL_QUERY_EVT;
            printk("Control Query Event \n");
        }

        // Set Feature (b_hnp_enable)
        else if (medusa_isr & 0x00000800) 
        {
            printk("Set Feature (b_hnp_enable)\n");
            BHNP_OTG(1);
            set_otg_feature(3);

            // *USBISR = 0x00000800;
            writel(0x00000800,medusa_base+ISR);
        }

        // Set Feature (a_hnp_enable)
        else if (medusa_isr & 0x00001000) 
        {
            printk("Set Feature (a_hnp_enable) \n");
            set_otg_feature(4);

            // *USBISR = 0x00001000;
            writel(0x00001000,medusa_base+ISR);
        }
        // Set Feature (a_alt_hnp_support)
        else if (medusa_isr & 0x00002000) 
        {
            printk(" Set Feature (a_alt_hnp_support \n");
            
            set_otg_feature(5);
            // *USBISR = 0x00002000;
            writel(0x00002000,medusa_base+ISR);
        }
                
        // USB_OTH_EVT          
         else 
        {
           /*Led_Debug (MED_Other_Event);
            *USBISR = 0x3C000738;*/
            dprintk(" USB_OTH_EVT %x %x\n", medusa_isr, readl(medusa_base+IER));
            //temp = 0x3C000738;
            //writel(temp,medusa_base+ISR);
            writel(medusa_isr,medusa_base+ISR);
            //dprintk("\n=====Other Event=====\n");
            //check return    USB_OTH_EVT;
        }
    
    } // end of medusa_isr
    //else
    //{
    //    printk("Not a Medusa Interrupt \n");
    //}
}
#else  // alex orginal code
{
    unsigned int medusa_isr=0;
    unsigned int temp      =0;
    static unsigned int isr_cnt   =0;
    
    //printk("i");    
    
    medusa_isr = readl(medusa_base+ISR);
    
    if(medusa_isr==0x20)
     dprintk("Only SOF event %x\n", medusa_isr);
        
    
    if(isr_cnt % (1<<6) ==0)
    {
      dprintk("ISR event %x\n", medusa_isr);    
      isr_cnt++;            
    }
    
    
    if (medusa_isr ) 
    {
        // dprintk("Interrupt from the Medusa Controller \n");
        // Connect
        if (medusa_isr & 0x00000001) 
        {
            temp = 0x00000001;
            writel(temp,medusa_base+ISR);
            temp = readl(medusa_base+ISR);
            reset_medusa();            
            printk("USB Connect\n");
        }
        //DisConnect
        else if (medusa_isr & 0x00000002) 
        {
            writel(0x00000002,medusa_base+ISR);
//            _ConnectB =0;
            reset_medusa();            
            printk("USB Disconnect\n");
  
            }
            // Reset Event
        else if (medusa_isr & 0x00000004) 
        {        
            
            temp = 0x00000004;
            writel(temp,medusa_base+ISR);                
            temp = readl(medusa_base+UDCR);
            
            if(temp & 0x00040000)
            {
                printk("High Speed\n");
                bHighSpeed = 1;
            }
            else
            {
                printk("Full Speed\n");
                bHighSpeed = 0;
            }
                        if (bOldSpeed != bHighSpeed) {
                bOldSpeed = bHighSpeed;
            }
             
                     //bHighSpeed = 1; //Shirley 2006/01/17
            reset_medusa();
            load_usb_descriptors(handle_s);
            Speed_Switch(bHighSpeed);            
            printk("Reset\n");
            GlobalSuspendClear();
            //check return USB_RESET_EVT;
        }
         //Suspend Event
        else if (medusa_isr & 0x00000008) 
        {
            
            dprintk("Suspend begin\n");
            // Ack later in process context
            temp = 0x00000008;
            writel(temp,medusa_base+IDR); // Disable Suspend Event
            //writel(temp,medusa_base+ISR);    
            if(!GlobalSuspendSetCheck())        
             printk("USB Suspend Event\n");
                         
            GlobalSuspendSet();
            
        }
        // Resume Event
        else if (medusa_isr & 0x00000010) 
        {
            GlobalSuspendClear();
            temp = 0x00000010; 
            writel(temp,medusa_base+ISR);            
            printk("Resume Event\n");
            
        }
                
        //Bulk Out Event
        else if (medusa_isr & 0x02000000)         
        {    
            temp = (readl(medusa_base+PRIR) & 0x000007ff);
            handle_s->data_cnt = temp;
            bulkout(handle_s);            
            dprintk("BU End\n");
            
        }            
        // BulkIn Event
        else if (medusa_isr & 0x01000000) 
        {       
            handle_s->data_cnt = 512;
            bulkin(handle_s);            
            dprintk("BI End\n");            
            //check    return USB_BULKIN_EVT;
        
        }
        // Control 0 Setup Event
        else if (medusa_isr & 0x00010000) 
        {        
            // dprintk("=====  Setup Event  ===== \n");
            temp = (readl(medusa_base+PRIR) & 0x000007ff);
            handle_s->data_cnt = temp;
        
            temp = readl(medusa_base+PRIR);
            temp = (temp >>16) & 0x000000ff;
        
            handle_s->pep_c = temp;
            msgpipe(handle_s,CTRL_SETUP);            
            dprintk("Setup Event End \n");
        
            }
                // Control Out Event
        else if (medusa_isr & 0x00020000) 
        {
            // dprintk("=====Control EP0 Out Event===== \n");
            handle_s->data_cnt = (readl(medusa_base+PRIR) & 0x000007ff);
            temp = readl(medusa_base+PRIR);
            handle_s->pep_c = (temp >>16) & 0x000000ff;
            msgpipe(handle_s, CTRL_OUT);
            dprintk("Control EP0 Out Event End\n");
                        //check return USB_CTRL_OUT_EVT;
        }    
        // USB_CTRL_IN_EVT
        else if (medusa_isr & 0x00040000) 
        {
            // dprintk("\n=====Control In EP0 Event===== \n");
            temp = readl(medusa_base+PRIR);
            //dprintk("PRIR Byte Count is %8x \n",readl(medusa_base+PRIR));
            temp &= 0x000007ff;
            //dprintk("value of temp after anding the  valus is %8x \n",temp);
            handle_s->data_cnt = temp;
            //dprintk("handle_s->data_cnt In data Requested is %8x \n",handle_s->data_cnt);
            //Physical Endpoint Number
            temp = readl(medusa_base+PRIR);
            //dprintk("Post Request Information Register value is %8x \n",readl(medusa_base+PRIR));
            temp = temp >> 16;
            temp &= 0x000000ff;
            //dprintk("for the EndPoint No : %x \n",temp);
        
            handle_s->pep_c = temp;
            //dprintk("handle_s->pep_c is %8x \n",handle_s->pep_c);
            msgpipe(handle_s,CTRL_IN);
            //printk("Control In EP0 Event End\n");
            //check return USB_CTRL_IN_EVT;
        }
        // USB_CTRL_QUERY_EVT
        else if (medusa_isr & 0x00080000) 
        {
            msgpipe(handle_s, CTRL_STATUS);
            //check return    USB_CTRL_QUERY_EVT;
            printk("Control Query Event \n");
        }

        // Set Feature (b_hnp_enable)
        else if (medusa_isr & 0x00000800) 
        {
            printk("Set Feature (b_hnp_enable)\n");
            BHNP_OTG(1);
            set_otg_feature(3);

            // *USBISR = 0x00000800;
            writel(0x00000800,medusa_base+ISR);
        }

        // Set Feature (a_hnp_enable)
        else if (medusa_isr & 0x00001000) 
        {
            printk("Set Feature (a_hnp_enable) \n");
            set_otg_feature(4);

            // *USBISR = 0x00001000;
            writel(0x00001000,medusa_base+ISR);
        }
        // Set Feature (a_alt_hnp_support)
        else if (medusa_isr & 0x00002000) 
        {
            printk(" Set Feature (a_alt_hnp_support \n");
            
            set_otg_feature(5);
            // *USBISR = 0x00002000;
            writel(0x00002000,medusa_base+ISR);
        }
                
        // USB_OTH_EVT          
         else 
        {
           /*Led_Debug (MED_Other_Event);
            *USBISR = 0x3C000738;*/
            dprintk(" USB_OTH_EVT %x %x\n", medusa_isr, readl(medusa_base+IER));
            //temp = 0x3C000738;
            //writel(temp,medusa_base+ISR);
            writel(medusa_isr,medusa_base+ISR);
            //dprintk("\n=====Other Event=====\n");
            //check return    USB_OTH_EVT;
        }
    
    } // end of medusa_isr
    //else
    //{
    //    printk("Not a Medusa Interrupt \n");
    //}
}

#endif   

void reset_medusa(void)
{
    dprintk("Reset medusa \n");
    handle_s->pep_c         = 0;              // Current Active Physical Endp
    handle_s->cswtag        = 0;              // CSW Tag
    handle_s->lba_c         = 0;              // Current LBA
    handle_s->cswres_c      = 0;              // Current CSW Residue Data
    handle_s->cswstatus_c   = GOOD;           // Current CSW Status
    handle_s->bulk_cs       = BULK_SETUP;     // BULK Endpoint Current Stage
    handle_s->data_cnt      = 0;              // Receive PRIR Data Count
    handle_s->data_addr     = 0;              // Bulk Data Stage RAM access addr
    handle_s->cbwb_addr     = 0;              // Bulk CBWB address
    handle_s->direction     = 0;              // SCSI Command direction
    handle_s->stdcmd        = GMAXLUN;        // USB Standard Command
    handle_s->ctrl_ns       = CTRL_SETUP;     // Message pipe Next Stage
    handle_s->data_length   = 0;              // SCSI Command request datalength
    handle_s->noff          = 0;
    handle_s->data_length_c = 0;              // Current executed datalength
    handle_s->des_dataok    = 0;              // Descriptor Data access count
    handle_s->des_addr      = 0;              // Desciptor RAM address
    handle_s->command       = TESTUNIT;       // SCSI Command OPCode
}

void usbInitInMain(void)
{
    unsigned int temp=0;

	bSuspendAckLater = 0;
    
    temp = readl(medusa_base+UDCR);
        dprintk("UDCR(%x)\n",temp);
        
    /*if(temp & 0x00040000)
    {
        dprintk("High Speed Device is settled \n");
        bHighSpeed = 1;        
    }
    else
    {
        dprintk("Class Speed Device \n");
        bHighSpeed = 0;        
    }    */
    Data_Structures(1);
    

    
    // *USBPIR0 = 0x00001100;
    temp = 0xffff1100;
    writel(temp,medusa_base+PIR0);
    temp = readl(medusa_base+PIR0);
    dprintk("PIR0(%x)\n",temp);

    //*USBPIR1 = 0xffffffff;
    temp = 0xffffffff;
    writel(temp,medusa_base+PIR1);
    temp = readl(medusa_base+PIR1);
        dprintk("PIR1(%x)\n",temp);
    

    temp = readl(medusa_base+UDCR);
        dprintk("UDCR(%x)\n",temp);
    if(temp & 0x00040000)
    {
        dprintk("High Speed Device is settled \n");
        bHighSpeed = 1;        
    }
    else
    {
        dprintk("Class Speed Device \n");
        bHighSpeed = 0;        
    }    
    
    bOldSpeed = bHighSpeed;
    load_usb_descriptors(handle_s); 

    temp = 0x00000000;
    writel(temp,medusa_base+TBCR0);
    temp = readl(medusa_base+TBCR0);
        dprintk("TBCR0(%x)\n",temp);
    
    
    // *USBTBCR1 = 0x00000010;
    temp = 0x00000010;
    writel(temp,medusa_base+TBCR1);
    temp = readl(medusa_base+TBCR1);
        dprintk("TBCR1(%x)\n",temp);
    
    // *USBTBCR2 = 0x00000110;
    temp = 0x00000110;
    writel(temp,medusa_base+TBCR2);
    temp = readl(medusa_base+TBCR2);
        dprintk("TBCR2(%x)\n",temp);
    
    // *USBTBCR3 = 0x00000190;
    temp = 0x00000190;
    writel(temp,medusa_base+TBCR3);
    temp = readl(medusa_base+TBCR3);
        dprintk("TBCR3(%x)\n",temp);
    
    // *USBACR   = 0x00000003;
    temp = 0x00000003;
    writel(temp,medusa_base+ACR);
    temp = readl(medusa_base+ACR);
        dprintk("ACR(%x)\n",temp);
    
    
    //firmware  
    //  0x030f0007; [13:11] for OTG HNP Set_Feature

    // *USBIER   = 0x030f381f;
    temp = 0x030f381f;
    writel(temp,medusa_base+IER);
    temp = readl(medusa_base+IER);
        dprintk("IER(%x)\n",temp);
    
    // *USBFNCR  = 0x00000000;
    temp = 0x00000000;
    writel(temp,medusa_base+FNCR);
    temp = readl(medusa_base+FNCR);
        dprintk("FNCR(%x)\n",temp);
    
    //load usb descriptors 
    //is it necessary to call this function again ? - Elango
    //load_usb_descriptors(handle_s);

    // capabilities of the Disk
    // init capacity buffer
    set_scsi_capicitybuf(handle_s);  
    
//    Allocate_memory();

    reset_medusa();

    InitSectors();



    // USBUDCR[18]:1, High Speed
    // USBUDCR[10]:1, HNP Support
    // USBUDCR[4]:0, No Short Period Enable
    // *USBUDCR = 0x00070401; // resume after simulation

    temp = 0x00070401;
    writel(temp,medusa_base+UDCR);
    temp = readl(medusa_base+UDCR);
    dprintk("UDCR(%x)\n",temp);

//    dprintk("value of UDCR after writing is  %08x \n",readl(medusa_base+UDCR));

}

void msgpipe_setup_stage(struct USBHandle *usb_handle)
{

        __u32   temp;
        __u32   wValue;	
	 __u32    bRequest,bmRequestType,wLength;	
        //dprintk("\nIn the SetUp Stage \n");
        //Read STR0 & STR1
        //wValue = (*USBSTR0 >> 16) & 0x0000ffff;
        temp = readl(medusa_base+STR0);
        temp = ((temp>>16) & 0x0000ffff);
        wValue = temp;
        dprintk("%s %d wValue %lx\n",__FUNCTION__,__LINE__,wValue);
        //bRequest = (*USBSTR0 >> 8) & 0x000000ff;
        temp = readl(medusa_base+STR0);
        temp = ((temp>>8) & 0x000000ff);
        bRequest = temp;
        
        //bmRequestType = *USBSTR0 & 0x000000ff;
        temp = readl(medusa_base+STR0);
        temp &= 0x000000ff;
        bmRequestType = temp;
    
        //wLength = (*USBSTR1 >> 16) & 0x0000ffff;
        temp = readl(medusa_base+STR1);
        temp = ((temp>>16) & 0x0000ffff);
        wLength = temp;
        
        // USB Mass Storage Reset (2 stage)
        if ((bRequest == 0xFF) && (bmRequestType == 0x21)) 
        {   
            // dprintk("Inside MassStorage reset \n");
            mass_reset(handle_s);
            usb_handle->ctrl_ns = CTRL_STATUS;
          }

        // USB Mass Storage Get Max LUN (3 stage)
        else if ((bRequest == 0xFE) && (bmRequestType == 0xa1)) 
        {
            // dprintk("Inside GetMaxLun \n");
            handle_s->stdcmd  = GMAXLUN;
            handle_s->ctrl_ns = CTRL_DATA;
           }

        // USB Get Descriptor
        else if ((bRequest == 0x06) && (bmRequestType == 0x80)) 
        {
            //dprintk("Inside the Get Descriptor part \n");
            handle_s->stdcmd  = GET_DESCRIPTOR;
                    handle_s->ctrl_ns = CTRL_DATA;

            // Get Device Descriptor
            flag_datastage_value = wValue;
            
            if (wValue == 0x0100) 
            {
                // dprintk("Inside Setup Get Device Descriptor \n");
        
                if (wLength < 18)
                {
                  // dprintk("Less than 18 bytes of Get DeviceDescriptor \n");
                                  handle_s->des_dataok = wLength;
                }
                else
                {
                 //  dprintk("18 bytes of DeviceDescriptor \n");
                                 handle_s->des_dataok = 18;
                }
    
            }
            
            // Get Configuration Descriptor
            else if (wValue == 0x0200) 
            {
               // dprintk("Inside Setup Get Configuration Descriptor \n");
               if (wLength < 35) //32) //here
                    usb_handle->des_dataok = wLength;
               else
                    usb_handle->des_dataok = 35;//32;
               
               //usb_handle->des_addr = (int)usb_handle->Configure_DescBUFFER;
            }
            
            // Get String0 Descriptor
            else if (wValue == 0x0300) 
            {
               // dprintk("Inside Setup String Descriptor \n");
               if (wLength < 4)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 4;
               
               //usb_handle->des_addr = (int) usb_handle->String_DescBuffer;
            }

            // Get String1 Descriptor
            else if (wValue == 0x0301) 
            {
               // dprintk("Inside Setup String1 Descriptor \n");
               if (wLength < 0x0A)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 0x0A;
           
               usb_handle->des_addr = (int) (&usb_handle->String_DescBuffer[2]);
            }

            // Get String2 Descriptor
            else if (wValue == 0x0302) 
            {
               // dprintk("Inside Setup String2 Descriptor \n");
               if (wLength < 0x14)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 0x14;
          
               usb_handle->des_addr = (int) (&usb_handle->String_DescBuffer[6]);
            }

            // Get String3 Descriptor
            else if (wValue == 0x0303) 
            {
               // dprintk("Inside Setup String3 Descriptor \n");
               if (wLength < 0x08)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 0x08;
          
               usb_handle->des_addr = (int) (&usb_handle->String_DescBuffer[12]);
            }
            // alex -------------------------			
// Get String4 Descriptor
            else if (wValue == 0x0304) 
            {
            	
               // dprintk("Inside Setup String4 Descriptor \n");
               if (wLength < 0x2A)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 0x2A;
          
               usb_handle->des_addr = (int) (&usb_handle->String_DescBuffer[16]);
            }
// alex ------------------------

            // Get OTG Descriptor
            else if ((wValue & 0xff00) == 0x0900) 
            {
               // dprintk("Inside Setup OTG Descriptor \n");
               if (wLength < 3)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 3;
          
               usb_handle->des_addr = (int) usb_handle->OTG_DescBuffer;
            }

            // Get Device Qualifier
            else if (wValue == 0x0600) 
            {
               //printk("Inside Setup Device Qualifier Descriptor \n");
               if (wLength < 10)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 10;
          
               usb_handle->des_addr = (int) (usb_handle->Qualifier_DescBUFFER);
               //HexDump(usb_handle->Qualifier_DescBUFFER, 10);
            }

            // Get OtherSpeedConfiguration
            else if (wValue == 0x0700) 
            {
               //printk("Inside Setup Other Speed Configuration Descriptor \n");
               //HexDump(usb_handle->OtherSpeed_DescBUFFER, 16);
               if (wLength < 35)//32)
                   usb_handle->des_dataok = wLength;
               else
                   usb_handle->des_dataok = 35;  //32;

               usb_handle->des_addr = (int) (usb_handle->OtherSpeed_DescBUFFER);
            }
                /*else if (wValue == 0x201) //Shirley 2006.01.16
                {
                    printk("wValue %x wLength %x\n",wValue, wLength);
                    if(wLength < 9)
                        usb_handle->des_dataok = wLength;
                    else
                        usb_handle->des_dataok = 9;
                    //usb_handle->des_addr = (int)usb_handle->Configure_DescBUFFER;
                    
                }*/

            // UnSupport
            else 
            {
                dprintk("Inside UnSupported Command \n");
                dprintk("wValue %x wLength %x\n",wValue, wLength);
               usb_handle->stdcmd = UNSUPPORT;
               //*USBFHHR = 0x01010000;
               //temp = 0x01010000;//---orign, marked by shirley
               // dprintk("FHHR is %08x \n",readl(medusa_base+FHHR));

               //writel(temp,medusa_base+FHHR);//---orign, marked by shirley
               //Shirley update for BFCR
               writel(0x10000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
               // dprintk("2. FHHR is %08x \n",readl(medusa_base+FHHR));
         
            }
        }    
        
        // USB Set Descriptor
        else if ((bRequest == 0x07) && (bmRequestType == 0x00)) 
        {
             // dprintk("Inside the Set Descriptor part \n");
         
            usb_handle->stdcmd = SET_DESCRIPTOR;
            usb_handle->ctrl_ns = CTRL_DATA;
            // Set Device Descriptor
            if (wValue == 0x0100) 
            {
               // dprintk("Inside Setup SetDevice Descriptor \n");
               usb_handle->des_dataok = wLength;
               usb_handle->des_addr = (int)usb_handle->Device_DescBUFFER;
            }
            // Set Configuration Descriptor
            else if (wValue == 0x0200) 
            {
               // dprintk("Inside Setup Configuration Descriptor \n");
               usb_handle->des_dataok = wLength;
               usb_handle->des_addr = (int)usb_handle->Configure_DescBUFFER;
            }
            // Set String0 Descriptor
            else if (wValue == 0x0300) 
            {
               // dprintk("Inside Setup String0 Descriptor \n");
               usb_handle->des_dataok = wLength;
               usb_handle->des_addr = (int) usb_handle->String_DescBuffer;
            }
            // Set String1 Descriptor
            else if (wValue == 0x0301) 
            {
               // dprintk("Inside Setup String1 Descriptor \n");
               usb_handle->des_dataok = wLength;
               usb_handle->des_addr = (int) (usb_handle->String_DescBuffer+2);
            }

            // Set Device Qualifier
            else if (wValue == 0x0600) 
            {
               // dprintk("Inside Setup SetDevice Qualifier Descriptor \n");
               usb_handle->des_dataok = wLength;
               usb_handle->des_addr = (int) (usb_handle->Qualifier_DescBUFFER);
            }

            // Set OtherSpeedConfiguration
            else if (wValue == 0x0700) 
            {
               dprintk("Other Speed Configuration Descriptor \n");
               
               usb_handle->des_dataok = wLength;                              
               usb_handle->des_addr = (int) usb_handle->OtherSpeed_DescBUFFER;
            }

            // UnSupport
            else 
            {
               dprintk("Inside UnSupported Command \n");
               usb_handle->stdcmd = UNSUPPORT;

               //*USBFHHR = 0x01010000;
               //temp = 0x01010000; //orign
               // dprintk("FHHR is %08x \n",readl(medusa_base+FHHR));

               //writel(temp,medusa_base+FHHR);//orign
                //Shirley update for BFCR
               writel(0x10000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
               // dprintk("2. FHHR is %08x \n",readl(medusa_base+FHHR));

            }
          
        } // end of SetDescriptor

//////////////OTG part/////////////////////////////////////////////////////////////
//     else if   ((bRequest == 0x03) && (bmRequestType == 0x00))
//               {         //Set Feature
//               set_otg_feature(wValue);
//               usb_handle->ctrl_ns =    CTRL_STATUS;
//               }
//////////////////////////////////////////////////////////////////////////////////

        else if((bRequest == 0xFF) && (bmRequestType == 0x41))   //Vendor FF
        {
            // dprintk("Inside the Vendor Command FF \n");
            usb_handle->ctrl_ns =    CTRL_STATUS;
        }
        else if   ((bRequest == 0x66) && (bmRequestType == 0xC1))
        {         //Vendor 66
            // dprintk("inside the Vendor Command 66 \n");
            usb_handle->des_dataok   =    1;
                        usb_handle->ctrl_ns      =    CTRL_DATA;
                        usb_handle->stdcmd       =    VENDOR66;
        }
        else if   ((bRequest == 0x67) && (bmRequestType == 0xC1))
        {         //Vendor 67
            // dprintk("Inside the Vendor Command 67 \n");
                       usb_handle->des_dataok   =    1;
                       usb_handle->ctrl_ns      =    CTRL_DATA;
                       usb_handle->stdcmd       =    VENDOR67;
        }
        else if   ((bRequest == 0x68) && (bmRequestType == 0xC1))
        {         //Vendor 68
            // dprintk("Inside the Vendor Command 68 \n");
                       usb_handle->des_dataok   =    1;
                       usb_handle->ctrl_ns      =    CTRL_DATA;
                       usb_handle->stdcmd       =    VENDOR68;
        }
        else
        {
            // dprintk("Inside the Vendor Command Unsupported \n");
                        usb_handle->ctrl_ns = CTRL_SETUP;
                        usb_handle->stdcmd  = UNSUPPORT;
                        // *USBFHHR  =    0x01010000;
	        //temp = 0x01010000; //orign
            //writel(temp,medusa_base+FHHR); //orign
             //Shirley update for BFCR
               writel(0x10000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
                       
        }
    
}

void msgpipe_data_stage(struct USBHandle *usb_handle)
{
         __u32   temp,value;
		 
		 
         // Get Max LUN --> return data "0"
         if (handle_s->stdcmd == GMAXLUN) 
          {
              // dprintk("Data Stage of GetMaxlun \n");
              
              xfer_buffer[0] = 0x00;
              xfer_buffer[1] = 0x00;
                          usb_handle->ctrl_ns = CTRL_STATUS;

              // *USBMDAR = (unsigned int)&xfer_buffer[0];
                          /*phy_des_addr = virt_to_bus(xfer_buffer);
              writel((unsigned int)phy_des_addr,medusa_base+MDAR);
              temp = readl(medusa_base+MDAR);*/              
                
              consistent_sync(xfer_buffer,2,DMA_TO_DEVICE);
              phy_des_addr = (dma_addr_t *)virt_to_bus(&xfer_buffer[0]);
              writel((unsigned int)phy_des_addr,medusa_base+MDAR);
              temp = readl(medusa_base+MDAR);

              virt_addr = (unsigned long *)__bus_to_virt(phy_des_addr);
              // dprintk("check here virt_addr is ",virt_addr[0]);
              
              // *USBACR  = 0x00010023;
              // Prepare Control IN data (enable DMA)
              temp = 0x00010022;
              writel(temp,medusa_base+ACR);
              while (1) // check DMA status
              {
                                  //value = *USBACR & 0x00000830;
                   temp = readl(medusa_base+ACR);
                   temp &= 0x00000830;
                   value = temp;
                   //dprintk("value is %8x \n",value);

                          if (value == 0) // DMA OK done
                    {
                            // dprintk("No Error in Dma\n");
                                            break;
                    }
                          else if (value == 0x00000800) // DMA error done
                          {
                                           // *USBISR  =  0x00040000;
                       temp = 0x00040000;
                       writel(temp,medusa_base+ISR);
                                        
                       // *USBACR  |= 0x00000800;
                       temp |= 0x00000800;
                       writel(temp,medusa_base+ACR);
                       // *USBFHHR =  0x01010000;
                       // Halt endpoint0
                        temp = 0x00010000;
                       writel(temp,medusa_base+FHHR);
                       return;
                          }
                        }
                        // ISR clear for DMA OK done case.
            writel(0x00040000,medusa_base+ISR); // Clearing the ISR
    
          }

          // GetDescriptor()
          else if (usb_handle->stdcmd == GET_DESCRIPTOR) 
          {
               if (handle_s->data_cnt > handle_s->des_dataok)
               {
                   handle_s->data_cnt = handle_s->des_dataok;
               }
               
               // dprintk("handle_s->des_dataok is %08x \n",handle_s->des_dataok);
               // dprintk("handle_s->data_cnt is %08x \n",handle_s->data_cnt);

                           /*dprintk("Printing the Desc Values: \n \n");
               for (abc= 0;abc<18;abc++);
                    dprintk("byte[%d] is %08x \n",abc,byte[abc]);*/

               
               //dprintk("handle_s->Device_DescBUFFER is %08x \n",handle_s->Device_DescBUFFER);
               //dprintk("Device Descriptor:: \n");
               /*for(abc=0;abc<18;abc++)
               {
                   dprintk("handle_s->Device_DescBUFFER[%d] is %08x \n",abc,handle_s->Device_DescBUFFER[abc]);
               }*/

                           
               if(flag_datastage_value == 0x100)
               {
                   // dprintk("Giving the Device Descriptor \n");
                   consistent_sync(dev_desc,18,DMA_TO_DEVICE);
                   phy_des_addr = (dma_addr_t *)virt_to_bus(dev_desc);
               }
               else if(flag_datastage_value == 0x200)
               {
                   // dprintk("Giving the Configuration Descriptor \n");
                   consistent_sync(config_desc,18,DMA_TO_DEVICE);
                   phy_des_addr = (dma_addr_t *)virt_to_bus(config_desc);
               }
               else if(flag_datastage_value == 0x0300)
               {
                   // dprintk("Giving the String Descriptor \n");
                   consistent_sync(string_desc,16,DMA_TO_DEVICE);
                   //phy_des_addr = (dma_addr_t *)virt_to_bus(string_desc);
                   phy_des_addr = (dma_addr_t *)virt_to_bus(&string_desc->buffer[0]);
               }
               else if(flag_datastage_value == 0x0301)
               {
                   // dprintk("Giving the String1 Descriptor \n");
                   consistent_sync(string_desc,16,DMA_TO_DEVICE);
                   phy_des_addr = (dma_addr_t *)virt_to_bus(&string_desc->buffer[2]);
               }
               else if(flag_datastage_value == 0x0302)
               {
                   // dprintk("Giving the String2 Descriptor \n");
                   consistent_sync(string_desc,16,DMA_TO_DEVICE);
                   phy_des_addr =(dma_addr_t *) virt_to_bus(&string_desc->buffer[6]);
               }
               else if(flag_datastage_value == 0x0303)
               {
                   // dprintk("Giving the String3 Descriptor \n");
                   consistent_sync(string_desc,16,DMA_TO_DEVICE);
                   phy_des_addr =(dma_addr_t *) virt_to_bus(&string_desc->buffer[12]);
                   
               }
                //alex ----------			   
	        else if(flag_datastage_value == 0x0304)
               {
                   // dprintk("Giving the String4 Descriptor \n");
                   //cpu_dcache_clean_range((unsigned long)((unsigned int)string_desc),(unsigned long)(string_desc+28));
                   //HexDump(string_desc->buffer, 112);
                   writel(0x04,medusa_base+FHHR); //Clean TX Buffer
                   //consistent_sync(string_desc, 48, DMA_TO_DEVICE);
                   //phy_des_addr =(dma_addr_t *) virt_to_bus(&string_desc->buffer[16]);
                   consistent_sync(usb_handle->String_DescBuffer, 42, DMA_TO_DEVICE);
                   phy_des_addr =(dma_addr_t *) virt_to_bus(&string_desc->buffer[16]);
                   
               }
//  ----------	
               else if(flag_datastage_value == 0x0600)
               {
                   // Other Speed                   
                   consistent_sync(usb_handle->Qualifier_DescBUFFER,10,DMA_TO_DEVICE);
                   phy_des_addr =(dma_addr_t *) virt_to_bus(&usb_handle->Qualifier_DescBUFFER[0]);
               }               
               //Shirley 2006/01/16
               else if(flag_datastage_value == 0x0700)
               {
                   // Other Speed                   
                   consistent_sync(usb_handle->OtherSpeed_DescBUFFER, 16,DMA_TO_DEVICE);
                   phy_des_addr =(dma_addr_t *) virt_to_bus(&usb_handle->OtherSpeed_DescBUFFER[0]);
               }

               //dprintk("Physical address is %08x \n",phy_des_addr);
              
               //Physical to Virtual Address
               virt_addr = (unsigned long *)__bus_to_virt(phy_des_addr);
               //dprintk("Virtual Address is %08x \n",virt_addr);
               /*dprintk("Device Descriptor:: \n");
               for(abc =0;abc<18;abc++)
               {
                   dprintk("virt_addr[%d] is %08x \n",abc,*(virt_addr+abc));
               }*/
               
               
               writel( ((unsigned int)phy_des_addr), medusa_base+MDAR);

                           // Prepare descriptor data (Enable DMA)
                           //value = 0x23 + (usb_handle->data_cnt << 16);
               value =0;                             
               value = (handle_s->data_cnt << 16);
               value = value | 0x22;// as we doing Post-Buffering mechanism                             
              
               // *USBACR = value; // enable DMA
               
               /*dprintk("Before Enabling Dma: \n");
               dprintk("MDAR is %08x \n",readl(medusa_base+MDAR));
               dprintk("UDCR is %08x \n",readl(medusa_base+UDCR));
               dprintk("FHHR is %08x \n",readl(medusa_base+FHHR));
               dprintk("STR0 is %08x \n",readl(medusa_base+STR0));
               dprintk("STR1 is %08x \n",readl(medusa_base+STR1));
               dprintk("TBCR0 is %08x \n",readl(medusa_base+TBCR0));
               dprintk("TBCR1 is %08x \n",readl(medusa_base+TBCR1));
               dprintk("TBCR2 is %08x \n",readl(medusa_base+TBCR2));
               dprintk("TBCR3 is %08x \n",readl(medusa_base+TBCR3));
               dprintk("PRIR is %08x \n",readl(medusa_base+PRIR));
               dprintk("EDR0 is %08x \n",readl(medusa_base+EDR0));
               dprintk("EDR1 is %08x \n",readl(medusa_base+EDR1));
               dprintk("EDR2 is %08x \n",readl(medusa_base+EDR2));
               dprintk("EDR3 is %08x \n",readl(medusa_base+EDR3));
               dprintk("EDR4 is %08x \n",readl(medusa_base+EDR4));
               dprintk("EDR5 is %08x \n",readl(medusa_base+EDR5));
               dprintk("EDR6 is %08x \n",readl(medusa_base+EDR6));
               dprintk("CCR is %08x \n",readl(medusa_base+CCR));
               dprintk("PIR0 is %08x \n",readl(medusa_base+PIR0));
               dprintk("PIR1 is %08x \n",readl(medusa_base+PIR1));
               dprintk("IER is %08x \n",readl(medusa_base+IER));
               dprintk("ISR is %08x \n",readl(medusa_base+ISR));
               dprintk("IDR is %08x \n",readl(medusa_base+IDR));    */

               writel(value,medusa_base+ACR);
               
               
               while (1) 
               { 
                    //value = *USBACR & 0x00000830;
                   temp = readl(medusa_base+ACR);
                   temp = temp & 0x0830;
                   value = temp;
                                   if (value == 0) // No error, DMA done
                   {
                      // dprintk("No Error \n");
                               
                                    break;
                   }
                                   else if (value == 0x00000800) 
                   { 
                      // *USBISR = 0x00040000; // clear ISR
                      // dprintk("Error in Dma \n");
                      temp = 0x00040000;
                      writel(temp,medusa_base+ISR);
                      
                      // *USBACR |= 0x00000800; // clear error flag
                      temp = readl(medusa_base+ACR);
                      temp |= 0x00000800;
                      writel(temp,medusa_base+ACR);
                      
                      // *USBFHHR = 0x01010000; // Set STALL
                      //temp = 0x01010000; //--orign
                      //writel(temp,medusa_base+FHHR); //--orign
                      //Shirley update for BFCR
               		  writel(0x10000, medusa_base + FHHR);
               		  writel(0x1, medusa_base + BFCR);
                      
                      return;
                               }
                             } // end of while(1)

                          // *USBISR = 0x00040000;
              temp = 0x00040000;
              writel(temp,medusa_base+ISR);
              
                          handle_s->des_dataok = handle_s->des_dataok - handle_s->data_cnt;
                           if (handle_s->des_dataok == 0) 
                 {
                //  dprintk("Data Stage completed initiating Status Stage \n");
                   handle_s->ctrl_ns = CTRL_STATUS;
                              } 
                 else
                  {
                  //dprintk("Data Stage is not completed yet \n");
                                   handle_s->ctrl_ns = CTRL_DATA;
                  }

          }

          // SetDescriptor(Device)
          else if (usb_handle->stdcmd == SET_DESCRIPTOR) {               
               writel((unsigned int)usb_handle->des_addr,  medusa_base+MDAR);               
               value     =    0x13 +    (usb_handle->data_cnt << 16);
               writel(value,medusa_base+ACR);              
               while(1)
               {
                    value = (readl(medusa_base + ACR))& 0x830;
                    if (value == 0)
                         break;
                    else if   (value == 0x800)
                         {
                              writel(0x20000, medusa_base+ISR);
                              temp = readl(medusa_base+ACR);
                              temp |= 0x800;
                              writel(temp, medusa_base+ACR);
		                      //writel(0x01010000, medusa_base+FHHR);//orign
		                       //Shirley update for BFCR
               				  writel(0x10000, medusa_base + FHHR);
               				  writel(0x1, medusa_base + BFCR);
                              return;
                          }
                }
               usb_handle->des_addr   = usb_handle->des_addr     +
                                        usb_handle->data_cnt;
               usb_handle->des_dataok = usb_handle->des_dataok   -
                                        usb_handle->data_cnt;
               if (usb_handle->des_dataok == 0)
                    usb_handle->ctrl_ns = CTRL_STATUS;
               else
                    usb_handle->ctrl_ns =    CTRL_DATA;              
               writel(0x20000, medusa_base+ISR); //Clear Control OUT Event
          }

          // VendorCommand(0x66)
          else if (handle_s->stdcmd == VENDOR66) 
          {
               // dprintk("VendorCommand 0x66 \n");
               xfer_buffer[0] = 0x51;
               xfer_buffer[1] = 0x08;
               handle_s->ctrl_ns = CTRL_STATUS;

               // *USBMDAR = (unsigned int)xfer_buffer;
               // *USBACR  = 0x00020023;
               
               phy_des_addr =(dma_addr_t *) virt_to_bus(xfer_buffer);
               writel((unsigned int) phy_des_addr, medusa_base+MDAR);
               temp = 0x00020023;
               writel(temp,medusa_base+ACR);

               while (1) 
               {
                    value = (readl(medusa_base+ACR) & 0x00000830);

                    if (value == 0x00000800)
                    {
                         // *USBISR = 0x00040000;
                         // *USBACR |= 0x00000800;
                         // *USBFHHR = 0x01010000;
                        temp = 0x00040000;
                        writel(temp, medusa_base+ISR);

                        temp = readl(medusa_base+ACR);
                        temp |= 0x00000800;
                        writel(temp,medusa_base+ACR);

                        //temp = 0x01010000; //--orign
                        //writel(temp,medusa_base+FHHR); //--orign
                         //Shirley update for BFCR
               			 writel(0x10000, medusa_base + FHHR);
               			 writel(0x1, medusa_base + BFCR);
                         return;
                    }
                    else if (value == 0)
                    {
                        // dprintk("No Error \n");
                              break;                              
                    }
               }
               // *USBISR = 0x00040000;
               temp = 0x00040000;
               writel(temp,medusa_base+ISR);
          }

          // VendorCommand(0x67)
          else if (handle_s->stdcmd == VENDOR67) 
          {
               // dprintk("VendorCommand 0x67 \n");
               xfer_buffer[0] = 0x01;
               handle_s->ctrl_ns = CTRL_STATUS;

               // *USBMDAR = (unsigned int)xfer_buffer;
               // *USBACR  = 0x00010023;

               phy_des_addr = (dma_addr_t *)virt_to_bus(xfer_buffer);
               writel((unsigned int) phy_des_addr, medusa_base+MDAR);
               temp = 0x00010023;
               writel(temp,medusa_base+ACR);


               while (1) 
               {
                    //value = *USBACR & 0x00000830;
                    value = (readl(medusa_base+ACR) & 0x00000830);
                    if   (value == 0x800)
                         {
                         // *USBISR   =    0x40000;
                         // *USBACR   |=   0x800;
                         // *USBFHHR  =    0x01010000;
                        temp = 0x00040000;
                        writel(temp, medusa_base+ISR);

                        temp = readl(medusa_base+ACR);
                        temp |= 0x00000800;
                        writel(temp,medusa_base+ACR);

                        //temp = 0x01010000; //--orign
                        //writel(temp,medusa_base+FHHR); //--orign
                        
                         //Shirley update for BFCR
               			writel(0x10000, medusa_base + FHHR);
               			writel(0x1, medusa_base + BFCR);

                                                return;
                         }
                    else if   (value == 0)
                    {
                        // dprintk("No error \n");
                              break;
                    }
               }
               // *USBISR = 0x00040000;
               temp = 0x00040000;
               writel(temp,medusa_base+ISR);
          }

          // VendorCommand(0x67)
          else if (handle_s->stdcmd == VENDOR68)
          {
               // dprintk("VendorCommand 0x67 \n");
               xfer_buffer[0] =    0x02;
               handle_s->ctrl_ns = CTRL_STATUS;

               // *USBMDAR  =    (unsigned int)xfer_buffer;
               // *USBACR   =    0x00010023;
               phy_des_addr = (dma_addr_t *)virt_to_bus(xfer_buffer);
               writel((unsigned int) phy_des_addr, medusa_base+MDAR);
               temp = 0x00010023;
               writel(temp,medusa_base+ACR);

               while (1) 
               {
                    //value = *USBACR & 0x00000830;
                   value = (readl(medusa_base+ACR) & 0x00000830);

                    if   (value == 0x800)
                    {
                         // *USBISR  = 0x00040000;
                         // *USBACR |= 0x00000800;
                         // *USBFHHR = 0x01010000;
                        temp = 0x00040000;
                        writel(temp, medusa_base+ISR);

                        temp = readl(medusa_base+ACR);
                        temp |= 0x00000800;
                        writel(temp,medusa_base+ACR);

                        //temp = 0x01010000; //--orign
	                    //writel(temp,medusa_base+FHHR); //--orign
	                     //Shirley update for BFCR
               			writel(0x10000, medusa_base + FHHR);
               			writel(0x1, medusa_base + BFCR);

                         return;
                    }
                    else if (value == 0)
                    {
                        // dprintk("No error \n");
                              break;
                    }
              }
              // *USBISR = 0x00040000;
               temp = 0x00040000;
               writel(temp, medusa_base+ISR);
          }

          // Unsupported()
          else 
          {
               // dprintk("Unsupported Command \n");
               handle_s->ctrl_ns = CTRL_SETUP;
               // *USBFHHR = 0x01010000;
               //temp = 0x01010000; //--orign
               //writel(temp,medusa_base+FHHR); //--orign
                //Shirley update for BFCR
                writel(0x10000, medusa_base + FHHR);
                writel(0x1, medusa_base + BFCR);
          }
    }

void msgpipe_status_stage(struct USBHandle *usb_handle)	
{

     __u32 temp;
          //if   (usb_handle->ctrl_ns != ctrl_cs)
          //     *USBFHHR = 0x00000002;    // STALL
          //else
      // dprintk("Inside the Status Stage part \n");
          
      //*USBFHHR = 0x00000001;    // ACK
      temp = 0x00000001;
      // dprintk("FHHR is %08x \n",readl(medusa_base+FHHR));
      writel(temp,medusa_base+FHHR);

      //*USBISR  = 0x00080000;
      temp = 0x00080000;
      // dprintk("ISR is %08x \n",readl(medusa_base+ISR));
      writel(temp,medusa_base+ISR);

      usb_handle->ctrl_ns = CTRL_SETUP;

    }


void msgpipe(struct USBHandle *usb_handle, int stage)
{
    
    
    unsigned int temp=0;

    
    //--------------------------------------------------------------------------
    // Execution code
    //--------------------------------------------------------------------------
    // Event priority: SETUP > OUT = IN > QUERY
    
    //NewChange here Clearing the Interrupt Status register at the End of this function
    if (stage == CTRL_SETUP) 
    {
    
        writel(0x10000,medusa_base+ISR); //Clearing the Setup Event
        //ctrl_cs = CTRL_SETUP;
        dprintk("Ctl Setup\n");
  	 msgpipe_setup_stage(usb_handle);	
    }
    else if (stage == CTRL_OUT)
    {
        // dprintk("Control out Stage \n");
        //ctrl_cs = CTRL_DATA;
	msgpipe_data_stage(usb_handle);	
    }
    else if (stage == CTRL_IN) 
    { 
        //ctrl_cs = CTRL_DATA;
	 msgpipe_data_stage(usb_handle);	
    }
    else if (stage == CTRL_STATUS) // QUERY event
    {
        // dprintk("Control Status Stage \n");
        ctrl_cs = CTRL_STATUS;
	 msgpipe_status_stage(usb_handle);	
    }
    else // Wrong status
    {
       usb_handle->ctrl_ns = CTRL_SETUP;
     
            // dprintk("Something wrong in CTL status \n");
       //*USBFHHR = 0x01010000;
       //temp = 0x01010000; //--orign
       //writel(temp,medusa_base+FHHR); //-orign
        //Shirley update for BFCR
        writel(0x10000, medusa_base + FHHR);
        writel(0x1, medusa_base + BFCR);

    }
    
    if (stage == CTRL_IN) 
    {         
        // *USBISR = 0x40000;
        // temp = readl(medusa_base+ISR);        
        temp = 0x40000;
        writel(temp,medusa_base+ISR);
        //// dprintk("After Clearing ISR is %8x \n",readl(medusa_base+ISR));
    }
    else if (stage == CTRL_STATUS) // QUERY event
    {
        // dprintk("Control Status Stage \n");
    }
    
    //newchange
    temp = 0x030f381f;
    writel(temp,medusa_base+IER);
    //temp = readl(medusa_base+IER);
    //dprintk("IER after enabling  %08x \n",readl(medusa_base+IER));

}
// msgpipe()

#define EXPIRE_TIMES    20

void bulkin(struct USBHandle *usb_handle)
{
    unsigned int temp;
    static unsigned int expire=0;
  //------------------------------------------
  // 1. BULKIN DATA stage
  //    return request data to Medusa
  // 2. BULKIN STATUS stage
  //    return status data to Medusa
  //------------------------------------------
  
  dprintk("bulkin\n");
  
  if (handle_s->bulk_cs == BULK_DATA) 
  {
      //dprintk("BDI\n");
      datain(handle_s);
      expire=0;
  }
  else if (handle_s->bulk_cs == BULK_STATUS) 
  {      
    // *USBISR = 0x01000000;

      temp = 0x01000000;
      writel(temp,medusa_base+ISR);
      handle_s->bulk_cs = BULK_SETUP;
      dprintk("Sts\n");
      expire=0;
  } 
 
  else //if(handle_s->bulk_cs != BULK_SETUP)
  {
    // *USBFHHR = 0x01020000; // Halt Bulk IN
    // *USBISR  = 0x01000000;     
    
   // if(expire == EXPIRE_TIMES)
    //{ 
      //temp = 0x01020000;  --orign
      //writel(temp,medusa_base+FHHR); --orign
       //Shirley update for BFCR
       writel(0x20000, medusa_base + FHHR);
       writel(0x1, medusa_base + BFCR);

      temp =  0x01000000;
      writel(temp,medusa_base+ISR);
      dprintk("Halt Bulk In %x\n", handle_s->bulk_cs);
   // }
    //else
    // expire++;
 // }
  //else
 // {
    //temp =  0x01000000;
    //writel(temp,medusa_base+ISR);      
  }
}

void bulkout(struct USBHandle *usb_handle)
{
  unsigned int value;
  unsigned int temp;
  

  if(handle_s->bulk_cs == BULK_DATA)
  {
      dprintk("BDO\n");
      dataout(handle_s);
  }


  // SETUP statge: Command Block Wrapper
  else if (handle_s->bulk_cs == BULK_SETUP) 
  {

      // dprintk("Inside the Setup Packet for Bulk Out\n");
      cbwcheck(handle_s);

      // dprintk("After the cbwcheck *** \n");

      if (handle_s->direction == 0x80) 
      {
        
          // dprintk("Inside the In direction *** \n");
          // SCSI Read10
        if (handle_s->command == READ10) 
        {
            //printk("Read10\n");
            return;
        }

        //device_to_host
        // Return INQUERY buffer data
        if (handle_s->command == INQUERY) 
        {
            // dprintk("INQUERY\n");        

            dprintk("handle_s->data_length is %08x \n",handle_s->data_length);
            dprintk("handle_s->data_length_c is %08x \n",handle_s->data_length_c);
            // by Shirley 2007.01.04
            /*
            if( (handle_s->data_length == 0x00) || (handle_s->data_length == 0x01) || (handle_s->data_length == 0x02) || (handle_s->data_length == 0x04) || (handle_s->data_length == 0x05))
            {
				handle_s->bulk_cs =    BULK_STATUS;
				handle_s->cswstatus_c  =    CMD_FAIL;               
            }
            else if (handle_s->data_length >= 64)
                 handle_s->data_cnt = 64;
            */     
		if (handle_s->bulk_cs == BULK_DATA)
		{
			/*
            if ((handle_s->data_length - handle_s->data_length_c) >= 0x64)
                handle_s->data_cnt = 64;
            else
                handle_s->data_cnt = handle_s->data_length  -
                                 handle_s->data_length_c;            
            */
            //Shirley 2008.01.08
            if(handle_s->data_length >= 0xff)
            {
            	handle_s->data_cnt = 36;
            	handle_s->data_length = 36;
            }
            else
                handle_s->data_cnt = handle_s->data_length;	
            // By Macleod 2006.01.11
            //handle_s->data_cnt = 36;
            
            //dprintk("\n===================\n");
            //dprintk("handle_s->data_length is %08x \n",handle_s->data_length);
            //dprintk("handle_s->data_length_c is %08x \n",handle_s->data_length_c);
            //dprintk("handle_s->data_cnt is %08x \n",handle_s->data_cnt);
            //dprintk("handle_s->data_addr is %08x \n",handle_s->data_addr);


            
            //phy_des_addr = virt_to_bus(Inquiry_Buffer);
            //writel((unsigned long)phy_des_addr,medusa_base+MDAR);

            consistent_sync(Inquiry_Buffer->buffer,36,DMA_TO_DEVICE);
            //HexDump(Inquiry_Buffer->buffer, handle_s->data_cnt);

            writel((unsigned int)handle_s->data_addr,medusa_base+MDAR);
            value = 0x123 + (handle_s->data_cnt << 16);
            writel(value,medusa_base+ACR);

            while (1) 
            {
                value = (readl(medusa_base+ACR) & 0x830 );
                if (value == 0) 
                {
                    // dprintk("No Error after Dma \n");
                    break;
                }
                else if (value == 0x800) 
                {
                  //  *USBACR   |=   0x800;
                  //  *USBFHHR  =    0x01020000;
                    temp = readl(medusa_base+ACR);
                    temp |= 0x800;
                    writel(temp,medusa_base+ACR);

                    //temp = 0x01020000; //--orign
                    //writel(temp,medusa_base+FHHR); //--orign
                     //Shirley update for BFCR
               		writel(0x20000, medusa_base + FHHR);
               		writel(0x1, medusa_base + BFCR);
                    return;
                }
            }
            
            
            handle_s->data_length_c = handle_s->data_length_c +    
                                        handle_s->data_cnt;
            // dprintk("****handle_s->data_length_c is %08x \n",handle_s->data_length_c);
         }   

        }

        
        // Return SENSE buffer data
        else if (handle_s->command == REQSENSE) 
        {
          if (handle_s->bulk_cs == BULK_DATA)
		 {
            dprintk("Sense Buffer Data \n");
            /*
            if ((handle_s->data_length - handle_s->data_length_c) >= 0x64)
                handle_s->data_cnt = 64;
            else
                handle_s->data_cnt = handle_s->data_length  - 
                                 handle_s->data_length_c;
        	*/
        	//Shirley 2007.01.08
            if(handle_s->data_length >= 0xff)
            {
            	handle_s->data_cnt = 18;
            	handle_s->data_length = 18;
            }
            else
                handle_s->data_cnt = handle_s->data_length;
        	
            // *USBMDAR = (unsigned int)usb_handle->data_addr;
        /*    for (abc=0;abc<6;abc++)
            {
                skbuf->buffer[abc] = handle_s->SKEY_BUFFER[abc];
            }*/

            dprintk("RS+++\n");
            //dmac_clean_range((unsigned long)handle_s->SKEY_BUFFER,(unsigned long)((((unsigned char *)handle_s->SKEY_BUFFER)+20)));
            consistent_sync(skbuf->buffer,20,DMA_TO_DEVICE);
            dprintk("RS==\n");


        
          //  phy_des_addr = (dma_addr_t *)virt_to_bus(skbuf->buffer);
          //  handle_s->data_addr = (int)phy_des_addr;
            
            writel((unsigned int)phy_des_addr, medusa_base+MDAR);
            value   = 0x123 + (usb_handle->data_cnt << 16);
        
            // *USBACR = value;
            writel(value,medusa_base+ACR);

            while (1) 
            {
                
                value = (readl(medusa_base+ACR) & 0x830);
                  if (value == 0) 
                {
                    // dprintk("No Error after dma");
                    break;
                }
                else if (value == 0x800) 
                {
                    // *USBACR   |=   0x800;
                    // *USBFHHR  =    0x01020000;
                    temp = readl(medusa_base+ACR);
                    temp = temp | 0x800;
                    writel(temp,medusa_base+ACR);

                    //temp = 0x01020000; //--orign
                    //writel(temp,medusa_base+FHHR); //-orign
                     //Shirley update for BFCR
               		writel(0x20000, medusa_base + FHHR);
               		writel(0x1, medusa_base + BFCR);
                    return;
                }
                
            }
            
            handle_s->data_length_c = handle_s->data_length_c +
                                    handle_s->data_cnt;
            dprintk("RS--\n");                    
         }
        
       }

      // Return CAPACITY buffer data, 8 bytes
      else if (handle_s->command == CAPACITY) 
      {
             

          dprintk("Capacity Command************** \n");
          //already commented usb_handle->data_addr    =    (int)&xfer_buffer[0];
          handle_s->data_cnt     =    8;
          //dmac_clean_range(handle_s->CAP_BUFFER,(((unsigned char *)handle_s->CAP_BUFFER)+8));

          // dprintk("Setting the Data bytes to send for Capacity is 8 bytes \n");

          // dprintk("Cap Buffer[0] is %08x \n",handle_s->CAP_BUFFER[0]);
          // dprintk("Cap Buffer[1] is %08x \n",handle_s->CAP_BUFFER[1]);
          // dprintk("handle_s->data_addr is %08x \n",handle_s->data_addr);

          capability->buffer[0] = handle_s->CAP_BUFFER[0];
          capability->buffer[1] = handle_s->CAP_BUFFER[1];


          
          //dmac_clean_range((unsigned int *)cap,(((unsigned char *)cap)+8));
          
          /*cap[0] = handle_s->CAP_BUFFER[0];
          cap[1] = 0x00123000;
          dprintk("Cap0 is %08x \n",cap[0]);
          dprintk("Cap1 is %08x \n",cap[1]);*/
         
          consistent_sync(capability,8,DMA_TO_DEVICE);


          
          phy_des_addr = (dma_addr_t *)virt_to_bus(capability);
          virt_addr = (unsigned long *)__bus_to_virt(phy_des_addr);

          // dprintk("Virtual: %08x, Physical: %08x\n" ,virt_addr, phy_des_addr);
          //for(abc=0;abc<2;abc++)
        //      dprintk("virt_addr[abc] is %08x \n",virt_addr[abc]);

          //writel((unsigned int)handle_s->data_addr, medusa_base+MDAR);
          writel((unsigned int)phy_des_addr, medusa_base+MDAR);
          // dprintk("MDAR is %08x \n ",readl(medusa_base+MDAR));

          //writel((unsigned long)phy_des_addr,medusa_base+MDAR);
          value   = 0x00080123;
        
          // *USBACR = value;
          writel(value,medusa_base+ACR);
        
          while(1) 
          {
            //value     =    *USBACR   &    0x830;
            value = (readl(medusa_base+ACR) & 0x830);

            if(value == 0) 
            {
                // dprintk("No error after dma \n");
                break;
            }
            else if   (value == 0x800)
            {
                // *USBACR   |=   0x800;
                // *USBFHHR  =    0x01020000;
                temp = readl(medusa_base+ACR);
                temp = temp | 0x800;
                writel(temp,medusa_base+ACR);

                //temp = 0x01020000; //--orign
                //writel(temp,medusa_base+FHHR); //--orign
                 //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
                return;
            }
          }
            
          handle_s->data_length_c=   handle_s->data_length_c + 8; 
          //wait_ms(2);
          //dmac_clean_range((unsigned int *)handle_s->CAP_BUFFER,(((unsigned char *)handle_s->CAP_BUFFER)+8));
          //dmac_clean_range((unsigned int *)cap,(((unsigned char *)cap)+8));
          //dmac_inv_range(handle_s->CAP_BUFFER,(((unsigned char *)handle_s->CAP_BUFFER)+8));
          
      }

      //------------------------------------------
      // 1. Command Valid (page code == 0x3F)
      //    return MODE buffer data
      // 2. Command Invalid
      //    Halt bulkin Endpoint, enter STATUS stage
      //------------------------------------------
      else if (handle_s->command == MODESENSE) 
      {
          dprintk("ModSense Command \n");
          //usb_handle->data_addr    =    (int)&xfer_buffer[0];
          handle_s->data_cnt     =    handle_s->data_length;

          if(handle_s->data_length == 0)
          {
              handle_s->bulk_cs =    BULK_STATUS;
              // *USBFHHR  =    0x01020000;         //Halt Bulk IN
              //temp = 0x01020000; //--orign
              //writel(temp,medusa_base+FHHR); //--orign
               //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
          }
          else 
          {
              // *USBMDAR  =    (unsigned int)usb_handle->data_addr;
              // value     =    0x123 +   (usb_handle->data_cnt << 16);
              //'*USBACR   =    value;
              consistent_sync(modbuffer->buffer, 4,DMA_TO_DEVICE);
           
              phy_des_addr = (dma_addr_t *)virt_to_bus(modbuffer);
              
              writel((unsigned int)handle_s->data_addr, medusa_base+MDAR);
              value   = 0x123 +   (handle_s->data_cnt << 16);
        
                writel(value,medusa_base+ACR);

              while(1) 
              {
                 //value     =    *USBACR   &    0x830;
                 value = (readl(medusa_base+ACR) & 0x830);
                 if(value == 0) 
                 {
                    // dprintk("No Error after Dma \n");
                    break;
                 }
                 else if   (value == 0x800) 
                 {
                    // *USBACR   |=   0x800;
                    // *USBFHHR  =    0x01020000;
                    temp = readl(medusa_base+ACR);
                    temp = temp | 0x800;
                    writel(temp,medusa_base+ACR);

                    //temp = 0x01020000; //--orign
                    //writel(temp,medusa_base+FHHR); //--orign
                     //Shirley update for BFCR
               		writel(0x20000, medusa_base + FHHR);
               		writel(0x1, medusa_base + BFCR);

                  return;
                 }
              }
                
              handle_s->data_length_c=   handle_s->data_length_c +    handle_s->data_cnt;
          } 
          //dmac_clean_range(modbuffer->buffer,(((unsigned char *)modbuffer->buffer)+4));
          
      }
      else if (handle_s->command == MODESENSE10) 
      {
          dprintk("ModSense10 Command \n");
          //usb_handle->data_addr    =    (int)&xfer_buffer[0];
          handle_s->data_cnt     =    handle_s->data_length;

          if(handle_s->data_length == 0)
          {
              handle_s->bulk_cs =    BULK_STATUS;
              // *USBFHHR  =    0x01020000;         //Halt Bulk IN
              //temp = 0x01020000; //--orign
              //writel(temp,medusa_base+FHHR); //--orign
               //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
          }
          else 
          {
              // *USBMDAR  =    (unsigned int)usb_handle->data_addr;
              // value     =    0x123 +   (usb_handle->data_cnt << 16);
              //'*USBACR   =    value;
              consistent_sync(modbuffer->buffer,  4,DMA_TO_DEVICE);
           
              phy_des_addr = (dma_addr_t *)virt_to_bus(modbuffer);
              
              writel((unsigned int)handle_s->data_addr, medusa_base+MDAR);
              value   = 0x123 +   (handle_s->data_cnt << 16);
        
                writel(value,medusa_base+ACR);

              while(1) 
              {
                 //value     =    *USBACR   &    0x830;
                 value = (readl(medusa_base+ACR) & 0x830);
                 if(value == 0) 
                 {
                    // dprintk("No Error after Dma \n");
                    break;
                 }
                 else if   (value == 0x800) 
                 {
                    // *USBACR   |=   0x800;
                    // *USBFHHR  =    0x01020000;
                    temp = readl(medusa_base+ACR);
                    temp = temp | 0x800;
                    writel(temp,medusa_base+ACR);

                    //temp = 0x01020000; //--orign
                    //writel(temp,medusa_base+FHHR); //--orign
                     //Shirley update for BFCR
               		writel(0x20000, medusa_base + FHHR);
               		writel(0x1, medusa_base + BFCR);

                  return;
                 }
              }
                
              handle_s->data_length_c=   handle_s->data_length_c +    handle_s->data_cnt;
          } 
          //dmac_clean_range(modbuffer->buffer,(((unsigned char *)modbuffer->buffer)+4));
          
      }

      // Return CMD23 buffer data, 12 bytes
      else if (handle_s->command == CMD_23)
      {
          dprintk(" CMD23 Command \n");
        //usb_handle->data_addr = (int)&xfer_buffer[0];

        handle_s->data_cnt = handle_s->data_length;
        consistent_sync(scsicmd23->buffer,12,DMA_TO_DEVICE);

        // *USBMDAR = (unsigned int)usb_handle->data_addr;
        // value = 0x123 +   (usb_handle->data_cnt << 16);
        // *USBACR = value;
        //dmac_clean_range(scsicmd23->buffer,(((unsigned char *)scsicmd23->buffer)+12));

        phy_des_addr = (dma_addr_t *)virt_to_bus(scsicmd23);

        writel((unsigned int)phy_des_addr, medusa_base+MDAR);
        value   = 0x123 +   (handle_s->data_cnt << 16);
        writel(value,medusa_base+ACR);


        while (1) 
        {
          //value = *USBACR & 0x830;
            value = (readl(medusa_base+ACR) & 0x830);

          if (value == 0) 
          {
              // dprintk("No Error \n");
              break;
          }
          else if (value == 0x800) 
          {
            // *USBACR |= 0x800;
            // *USBFHHR = 0x01020000;
            
            temp = readl(medusa_base+ACR);
                temp = temp | 0x800;
                writel(temp,medusa_base+ACR);

                //temp = 0x01020000; //--orign
                //writel(temp,medusa_base+FHHR); //--orign
                 //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
            return;
          }
        }
        handle_s->data_length_c = handle_s->data_length_c +
                                    handle_s->data_cnt;

        //dmac_clean_range(scsicmd23->buffer,(((unsigned char *)scsicmd23->buffer)+12));
      
      }
      
   }
     
    if (handle_s->bulk_cs == BULK_STATUS)
    {
        //csw_cache
        //try1           
        consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);
        cswcheck(handle_s);
    }
    
    }
   
  else 
  {
    //*USBISR   =    0x2000000;
    //*USBFHHR  =    0x01060000;

      //dprintk("Clearing the BUlk Out Event \n");
      //dprintk("Flushing and halt the Ep 1 and 2 \n");
      temp = 0x2000000;
      writel(temp,medusa_base+ISR);
      //temp = 0x01060000; //--orign
      //writel(temp,medusa_base+FHHR); //--orign
       //Shirley update for BFCR, Ep1 & Ep2
       writel(0x60000, medusa_base + FHHR);
       writel(0x1, medusa_base + BFCR);
      usb_handle->bulk_cs =    BULK_SETUP;
  }
}



void dataout(struct USBHandle *usb_handle)
{
//  int  i;
  unsigned  int  value;
  unsigned  int  host_count;
  unsigned int temp, int_wait;
  
  //dprintk("Inside the Dataout \n");
  if(handle_s->command == WRITE10)
    {
        // Use polling mechanism
        // *USBIDR       =     0x2000000;
        temp = 0x2000000;
        writel(temp,medusa_base+IDR);
        //dprintk("Inside DataOut \n");

        host_count    =     handle_s->data_cnt;
        dprintk("Write10: In %x, %x\n",handle_s->data_addr, host_count);
        
        // Write10 data access: 10us timing constraint is exist between two OUT transactions
        while   (handle_s->data_length_c < handle_s->data_length)
                {
        // dprintk("I:%x\n",handle_s->data_addr);
                // *USBMDAR  =    (unsigned int)usb_handle->data_addr;
                //value     =    0x13 +    (usb_handle->data_cnt << 16);
                // *USBACR   =    value;
            
            // Get data from Medusa (enable DMA)
        writel((unsigned int)handle_s->data_addr, medusa_base+MDAR);
        value   = 0x13 +   (handle_s->data_cnt << 16);
        writel(value,medusa_base+ACR);

            while(1)
                {
                 //value     =    *USBACR   &    0x830;
                    value = (readl(medusa_base+ACR) & 0x830);

                    if   (value == 0)
                    {
                        //dprintk("Write No Error\n");
                        
                        break;
                    }
                    else if   (value == 0x800)
                    {
                        //   *USBISR   =    0x2000000;
                        //   *USBACR   |=   0x800;
                        //   *USBFHHR  =    0x01020000;
                        temp = 0x2000000;
                        writel(temp,medusa_base+ISR);
                        
                        temp = readl(medusa_base+ACR);
                        temp |= 0x800;
                        writel(temp,medusa_base+ACR);

	                    //temp = 0x01020000; //--orign
                        //writel(temp,medusa_base+FHHR); //--orign
                         //Shirley update for BFCR
               			writel(0x20000, medusa_base + FHHR);
               			writel(0x1, medusa_base + BFCR);

                                                return;
                    }
                 }
                
        // *USBISR   =    0x2000000;
        temp = 0x2000000;
        writel(temp,medusa_base+ISR);

                handle_s->data_length_c     =   handle_s->data_length_c +    
                                              handle_s->data_cnt;
                handle_s->data_addr         =   handle_s->data_addr     +    
                                              handle_s->data_cnt;

               if   (host_count < handle_s->data_length){
                    int_wait = 0;
                 while(1) {
             temp = readl(medusa_base+ISR);
                        if(temp & 0x2000000)
                        {
                         host_count =   host_count + usb_handle->data_cnt; 
                         break;
                        }
                        else if(int_wait>=5000)
                        {
                         printk("Inside write10, no ISR response failed!!! %x %x %x\n", temp, host_count, handle_s->data_length);
                         // Re-enable IER
                         temp =  0x2000000;
                         writel(temp,medusa_base+IER);                         
                         return;    
                        }
                        else
                         int_wait++;
                        udelay(10);
                 } 
            }
        }



       handle_s->cswres_c     =    0;
       handle_s->bulk_cs      =    BULK_STATUS;
       //csw_cache
       consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);
       cswcheck(handle_s);

       // *USBIER       =     0x2000000;
       dprintk("Write10 Finished!!\n");
        
       temp =  0x2000000;
       writel(temp,medusa_base+IER);
       //dprintk("returning\n");
       return;
    }   
  
    // dprintk("Not an Write10 command \n");

    // *USBMDAR  =    (unsigned int)usb_handle->data_addr;
    // value     =    0x13 +    (usb_handle->data_cnt << 16);
    // *USBACR   =    value;
    
    //dprintk("handle_s->data_addr is %08x \n",handle_s->data_addr);
    //dprintk("handle_s->data_cnt is %08x \n",handle_s->data_cnt);

    writel((unsigned int)handle_s->data_addr, medusa_base+MDAR);
    value = 0x13 +    (usb_handle->data_cnt << 16);
    writel(value, medusa_base+ACR);

    while(1)
    {
            //value     =    *USBACR   &    0x830;
        value = (readl(medusa_base+ACR) &0x830);

            if   (value == 0)
            {
                // dprintk("No Error after medusa to memory\n");
                 break;
            }
            else if   (value == 0x800)
            {
                // *USBISR   =    0x2000000;
                // *USBACR   |=   0x800;
                // *USBFHHR  =    0x01020000;
                temp = 0x2000000;
                writel(temp,medusa_base+ISR);
                        
                temp = readl(medusa_base+ACR);
                temp |= 0x800;
                writel(temp,medusa_base+ACR);

                //temp = 0x01020000; //--orign
                //writel(temp,medusa_base+FHHR); //--orign
                 //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
                return;
            }
    }
    handle_s->data_length_c=   handle_s->data_length_c +    handle_s->data_cnt;
    handle_s->data_addr    =   handle_s->data_addr     +    handle_s->data_cnt;

    
    // *USBISR   =    0x2000000;
    temp = 0x2000000;
    writel(temp, medusa_base+ISR);

   //dprintk("handle_s->data_cnt is %08x \n",handle_s->data_cnt);
    //dprintk("handle_s->data_length_c is %08x \n",handle_s->data_length_c);
  
    //write data to sm card
    #ifndef SDRAM_DMA
    if   ((handle_s->command == WRITE10) && (handle_s->bulk_cs == BULK_DATA))
    {
       handle_s->noff    +=   handle_s->data_cnt;
       if   (handle_s->noff == 0x4000)
       {
            handle_s->noff    =    0;
            i = (handle_s->data_length_c - 0x4000) / 512;

            //already commented smWriteMediaSectorNByte2( (usb_handle->Clba + i),0,0x4000, data_buffer);
            
            //WritePhyVDiskNByte( (usb_handle->Clba + i),0,0x4000, data_buffer);
            usb_handle->data_addr    =    (int)&data_buffer[0];
       }
       else if   (usb_handle->data_length_c  ==  usb_handle->data_length)
       {
            i    =    (usb_handle->data_length_c - usb_handle->noff)    /    512;
            //smWriteMediaSectorNByte2( (usb_handle->Clba + i),0,usb_handle->noff, data_buffer);
            WritePhyVDiskNByte( (handle_s->Clba + i),0,handle_s->noff, data_buffer);
            handle_s->data_addr    =    (int)&data_buffer[0];
       }
    }
  #endif
  
  if   (handle_s->data_length_c >= handle_s->data_length)
       {
       handle_s->cswres_c     =    0;
       handle_s->bulk_cs      =    BULK_STATUS;
       //csw_cache
       consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);
       cswcheck(handle_s);
       }
  else
       handle_s->cswres_c     =    handle_s->data_length  -
                                     handle_s->data_length_c;
}

void cbwcheck(struct USBHandle *usb_handle)
{
  //-----------------------------
  // Local variable declaration
  //-----------------------------
  unsigned int value;
  int  cbwb_lba;                // CBWCB LBA
  unsigned int* pBuf;
  unsigned char* pBuf1;
  unsigned int temp;
  

  // dprintk("Inside cbwcheck \n");

  //-----------------------------
  // Execution code
  //-----------------------------
  //Check if length of CBW is 31 bytes
  if (usb_handle->data_cnt != 31) 

  {
      // *USBFHHR = 0x01020000; // Halt Bulk IN
      // dprintk("Length of CBW is not equal to 31 \n");
      // temp = 0x01020000;
      //Shirley, 2008.01.09,MSC
      handle_s->bulk_cs =    BULK_STATUS;
       handle_s->cswstatus_c  =    CMD_FAIL;
      //--Shirley
      //writel(0x01020000,medusa_base+FHHR); //--orign
       //Shirley update for BFCR
       writel(0x20000, medusa_base + FHHR);
       writel(0x1, medusa_base + BFCR);
      return;
  }

  //Receive CBW data
  //*USBMDAR = (unsigned int)usb_handle->CBW_BUFFER;

  //Elango flushing the cache
  //flush
  //dmac_clean_range(cbw_buffer->buffer,(((unsigned char *)cbw_buffer->buffer)+31));
  //receive_cbw

  
  // Cache flush issue
 /* Shirley marked
  if(cbw_flag)
  {
     // dmac_clean_range(cbw_buffer->buffer,(((unsigned char *)cbw_buffer->buffer)+31));
      //cbw_buffer->buffer = cbw_buffer1;
      cbw_buffer = (struct CBW_BUFFER *)cbw_buffer->buffer;
      // dprintk("cbw_buffer %08x \n",cbw_buffer);
      
      cbw_flag =0;
  }
  else
  {
     // dmac_clean_range(cbw_buffer->buffer,(((unsigned char *)cbw_buffer->buffer)+31));
      //cbw_buffer->buffer = cbw_buffer2;
      cbw_buffer = (struct CBW_BUFFER *)cbw_buffer->buffer+32;
      
      // dprintk("cbw_buffer %08x \n",cbw_buffer);
      cbw_flag = 1;
  }
*/
  
  phy_des_addr = (dma_addr_t *)virt_to_bus(cbw_buffer);
  writel(phy_des_addr,medusa_base+MDAR);  

  // Copy CBW command content from Medusa16 to system memory
  //*USBACR  = 0x001F0013;
  temp = 0x001F0013;
  writel(temp,medusa_base+ACR);

  while (1) 
  {
    // DMA status Check
    //value = *USBACR & 0x00000830;
      value = (readl(medusa_base+ACR) & 0x00000830);

    // no error
    if (value == 0) 
    {
        // dprintk("No Error after DMA\n");
         

        //newchange
        /*writel(0x1000000,medusa_base+FHHR);

        dprintk("After Flushing %08x \n",readl(medusa_base+FHHR));
        writel(0x0000,medusa_base+FHHR);*/
        

        break;
    }
    // Some errors
    else if (value == 0x800) 
    {
      //*USBISR = 0x2000000;
      //*USBACR |= 0x00000800;
      //*USBFHHR = 0x01020000;
        //temp = 0x2000000;
        writel(0x2000000,medusa_base+ISR);
        //dprintk("ISR is %08x",readl(medusa_base+ISR));

        temp = readl(medusa_base+ACR);
        temp |= 0x00000800;
        writel(temp,medusa_base+ACR);
        //dprintk("ACR is %08x",readl(medusa_base+ACR));

        //temp = 0x01020000;
        //writel(0x01020000,medusa_base+FHHR); //--orign
         //Shirley update for BFCR
         writel(0x20000, medusa_base + FHHR);
         writel(0x1, medusa_base + BFCR);
        //dprintk("FHHR is %08x",readl(medusa_base+FHHR));
      return;
    }
  }



  //Clear Isr as of 22/11/05
  temp = 0x2000000;
  writel(temp,medusa_base+ISR);
  
  
  consistent_sync(cbw_buffer->buffer,31,DMA_FROM_DEVICE);
  /*for(abc =0;abc<8;abc++)
  {
      dprintk("buffer[%d] is %08x \n",abc,cbw_buffer->buffer[abc] );
  }*/


  //pBuf = (unsigned int* )usb_handle->CBW_BUFFER;
  /* for(abc =0;abc<8;abc++)
  {
      dprintk("buffer[%d] is %08x \n",abc,cbw_buffer->buffer[abc] );
  }*/

  pBuf = (unsigned int* )cbw_buffer->buffer;

  // Add by stanlin (one line)
  dprintk("CBW:%x\n", pBuf[3]);

  if ((pBuf[0] != CBWSIGNATURE) || (pBuf[3] & 0xff00)) 
  {
     //*USBFHHR = 0x01020000; // Halt Bulk IN
      // dprintk("CBW Signature is not matching so halt \n");
      //Shirley, 2008.01.09,MSC
      handle_s->bulk_cs =    BULK_STATUS;
       handle_s->cswstatus_c  =    CMD_FAIL;
      //--Shirley
      //temp = 0x01020000; //--orign
      //writel(temp,medusa_base+FHHR); //--orign
       //Shirley update for BFCR
       writel(0x20000, medusa_base + FHHR);
       writel(0x1, medusa_base + BFCR);
      return;
  }

  /*
  usb_handle->cswtag = pBuf[1];
  value = pBuf[3];
  usb_handle->direction = pBuf[3] & 0xff;
  value = (value >> 16) & 0xff;     // bCBWCBLength
  pBuf1 = (unsigned char* )pBuf + 15;
  usb_handle->command = pBuf1[0];*/

  handle_s->cswtag = pBuf[1];
  value = pBuf[3];
  handle_s->direction = pBuf[3] & 0xff;
  value = (value >> 16) & 0xff;     // bCBWCBLength
  pBuf1 = (unsigned char* )pBuf + 15;
  handle_s->command = pBuf1[0];
  // dprintk("CSW Values from CBW ::: \n");
  // dprintk("Command      %08x \n",handle_s->command);
  // dprintk("Direction    %08x \n",handle_s->direction);
  // dprintk("Value    %08x \n",value);


  /*if (value != 10)
    cbwb_lba = 0;
  else {
    cbwb_lba = (pBuf1[2] << 24) + (pBuf1[3] << 16) +
               (pBuf1[4] << 8) + pBuf1[5];
  }*/
  
  
  if (value != 10)
  {
      //dprintk("CBWLength is not 10 \n");
      cbwb_lba = 0;
  }
  else 
  {
      cbwb_lba =    (pBuf1[2] << 24) + (pBuf1[3] << 16) +
                (pBuf1[4] << 8) + pBuf1[5];
  }




  /*if (cbwb_lba >= 0)
     usb_handle->cbwb_addr = MBR_OFFSET;
  else 
  {
     usb_handle->cswres_c = usb_handle->data_cnt;
     usb_handle->cswstatus_c = PHASE_ERROR;
     *USBFHHR = 0x01060000; // Halt Bulk IN & Bulk OUT
  }*/


  if (cbwb_lba >= 0)
  {
      //dprintk("cbwb_lba is greater than zero \n");
      handle_s->cbwb_addr = MBR_OFFSET;
  }
  else 
  {
      // dprintk("Phase Error \n");
     handle_s->cswres_c = handle_s->data_cnt;
     handle_s->cswstatus_c = PHASE_ERROR;
     temp = 0x01060000;
     writel(temp,medusa_base+FHHR);
     

  }


  //flush
  /*dmac_inv_range(cbw_buffer->buffer,(((unsigned char *)cbw_buffer->buffer)+31));
  for(abc =0;abc<8;abc++)
  {
      dprintk("buffer[%d] is %08x \n",abc,cbw_buffer->buffer[abc] );
  }*/



  
  //CLEARING ISR OLD BEFORE CHANGE 22/11/05
  // dprintk("Clearing the Bulk Out Event in ISR \n");
  //temp = 0x2000000;
  //writel(temp,medusa_base+ISR);

  //try flushing the buffers
  //writel(0x1000000,medusa_base+ISR);

 //for(abc =0;abc<8;abc++)
 // {
 // dprintk("buffer[%d] is %08x \n",abc,cbw_buffer->buffer[abc] );
 //}



  if (handle_s->command == WRITE10) 
  {
     
     handle_s->Clba = cbwb_lba;

     #ifdef SDRAM_DMA
       handle_s->data_addr = VDISK_BASE + (handle_s->Clba << 9);
     #else 
       phy_des_addr = virt_to_bus(&data_buffer[0]);
       handle_s->data_addr = phy_des_addr;
     #endif
     
     write10(handle_s);
  }

  else if (handle_s->command == READ10) 
  {     
    
      
     handle_s->Clba = cbwb_lba;
     //dprintk("handle_s->Clba is %08x \n",handle_s->Clba);
     //dprintk("cbwb_lba is %08x \n",cbwb_lba);
     
     //tocheck
     #ifdef SDRAM_DMA
        dprintk("Reading from the SDRAM \n");
        usb_handle->data_addr = VDISK_BASE + (usb_handle->Clba << 9);
     #else 
        
        phy_des_addr = virt_to_bus(&data_buffer[0]);
        usb_handle->data_addr = phy_des_addr; // into physical address
        //index =512;
     #endif

     //dprintk("handle_s->data_addr is %08x \n",handle_s->data_addr);
     
     read10(handle_s);
  }

  else if (handle_s->command == TESTUNIT) 
  {
//   Led_Debug (MED_TestUnit_Start);
     dprintk("Test Unit Start\n");

     testunit(handle_s);
     handle_s->bulk_cs = BULK_STATUS;
     
         dprintk("Test Unit Done\n");     
  }

  else if (handle_s->command == REQSENSE) 
  {
     //Led_Debug (MED_RequestSense_Start);
     //dprintk("ReqSense:\n");

     //handle_s->data_addr = (int)handle_s->SKEY_BUFFER;
     //phy_des_addr = virt_to_bus(handle_s->SKEY_BUFFER);
     //handle_s->data_addr = (int)phy_des_addr;

     //handle_s->data_addr = (int)phy_des_addr;
     //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);
     
     //Shirley 2007.01.08
     phy_des_addr = (dma_addr_t *)virt_to_bus(skbuf);
     handle_s->data_addr = (int)phy_des_addr;
     reqsense(handle_s);
  }

  else if (handle_s->command == INQUERY) 
  {
     //Led_Debug (MED_Inquery_Start);
      //dprintk("InQuery==\n");

     //handle_s->data_addr = (int)handle_s->INQRY_BUFFER;


      phy_des_addr = (dma_addr_t *)virt_to_bus(Inquiry_Buffer);
     //phy_des_addr = virt_to_bus(handle_s->INQRY_BUFFER);
     handle_s->data_addr = (int)phy_des_addr;
     //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);

     //dmac_clean_range(Inquiry_Buffer->buffer,(((unsigned char *)Inquiry_Buffer->buffer)+36));
     


     inquery(handle_s);
  }
  

  else if (handle_s->command == MODESENSE) 
  {
   //  Led_Debug (MED_ModeSense_Start);
      //dprintk("ModSense:\n");
     //handle_s->data_addr = (int)handle_s->MODE_BUFFER;
     

     phy_des_addr = (dma_addr_t *)virt_to_bus(modbuffer);
     handle_s->data_addr = (int)phy_des_addr;
     //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);
     modesense(handle_s);
     handle_s->bulk_cs = BULK_DATA;
  }
  else if   (usb_handle->command == MODESENSE10)
  {
     phy_des_addr = (dma_addr_t *)virt_to_bus(modbuffer);
     handle_s->data_addr = (int)phy_des_addr;
     modesense(handle_s);
     handle_s->bulk_cs = BULK_DATA;
  }	  

  else if (handle_s->command == STARTSTOP) 
  {
     //Led_Debug (MED_StartStop_Start);
     //dprintk("StartStop\n");
     startstop(handle_s);
     handle_s->bulk_cs = BULK_STATUS;
  }

  else if   (handle_s->command == REMOVAL) 
  {
     //Led_Debug(MED_Removal_Start);
     // dprintk("Removal:\n");

     removal(handle_s);
     handle_s->bulk_cs = BULK_STATUS;
     //dprintk("End of Removal Data \n");
  }

  else if (handle_s->command == CMD_23) 
  {
     //Led_Debug(MED_SCSI23_Start);
      //dprintk("SCSI23:\n");
     //usb_handle->data_addr = (int)usb_handle->CMD23_BUFFER;
      //dmac_clean_range(scsicmd23->buffer,(((unsigned char *)scsicmd23->buffer)+12));

      phy_des_addr = (dma_addr_t *)virt_to_bus(scsicmd23);
     handle_s->data_addr = (int )phy_des_addr;
     //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);
     //dmac_clean_range(scsicmd23->buffer,(((unsigned char *)scsicmd23->buffer)+12));
     
     cmd23(handle_s);
     handle_s->bulk_cs = BULK_DATA;
  }

  else if (handle_s->command == CAPACITY) 
  {
     //Led_Debug (MED_ReadCapacity_Start);
     // dprintk("Capacity:\n");
     //usb_handle->data_addr = (int)usb_handle->CAP_BUFFER;
      //dprintk("Cap Buffer[0] is %08x \n",handle_s->CAP_BUFFER[0]);
     // dprintk("Cap Buffer[1] is %08x \n",handle_s->CAP_BUFFER[1]);

      /*capacity[0] = handle_s->CAP_BUFFER[0];
      capacity[1] = handle_s->CAP_BUFFER[1];
      dprintk("capacity[0] is %08x \n",capacity[0]);
      dprintk("handle_s->CAP_BUFFER[0] is %08x \n",handle_s->CAP_BUFFER[0]);
      dprintk("capacity[1] is %08x \n",capacity[1]);
      dprintk("handle_s->CAP_BUFFER[1] is %08x \n",handle_s->CAP_BUFFER[1]);*/



     phy_des_addr = (dma_addr_t *)virt_to_bus(handle_s->CAP_BUFFER);
     handle_s->data_addr = (int)phy_des_addr;
     //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);
     capacity(handle_s);
     handle_s->bulk_cs = BULK_DATA;
  }

  else if (handle_s->command == VERIFY) 
  {
     ///Led_Debug (MED_Verify_Start);
     // dprintk("Verify:\n");
      //handle_s->data_addr = handle_s->cbwb_addr;
      phy_des_addr = (dma_addr_t *)__virt_to_bus(handle_s->cbwb_addr);
     handle_s->data_addr = (int)phy_des_addr;
     //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);

     
     verify(usb_handle);
  }

  else if (usb_handle->command == CMD_FF) 
  {
     //Led_Debug (MED_SCSIff_Start);
      //dprintk("SCSIff \n");
     
      //handle_s->data_addr = CMDFF_OFFSET;
      temp = CMDFF_OFFSET;

      phy_des_addr = (dma_addr_t *)__virt_to_bus(temp);
      handle_s->data_addr = (int)phy_des_addr;  
     // dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);
      cmdff(usb_handle);
      
     handle_s->bulk_cs = BULK_DATA;
  }
  else if (usb_handle->command == READ12)
  {
  		handle_s->bulk_cs = BULK_STATUS;
  		handle_s->cswstatus_c = CMD_FAIL;
  		//writel(0x01020000,medusa_base+FHHR); //halt bulk in //--orign
  		 //Shirley update for BFCR
         writel(0x20000, medusa_base + FHHR);
         writel(0x1, medusa_base + BFCR);
  }
  else if (usb_handle->command == WRITE12)
  {
  	handle_s->bulk_cs = BULK_STATUS;
  	handle_s->cswstatus_c = CMD_FAIL;
  	//writel(0x00040000,medusa_base+FHHR); //halt bulk out //--orign
  	 //Shirley update for BFCR
     writel(0x40000, medusa_base + FHHR);
               
  }
  else {
//   Led_Debug (MED_SCSIff_Start);
    //  dprintk("Command Fails \n");
    handle_s->bulk_cs = BULK_STATUS;
     handle_s->cswstatus_c = CMD_FAIL;
  }


  //try
  /*dprintk("Clearing the Bulk Out Event in ISR \n");
  temp = 0x2000000;
  writel(temp,medusa_base+ISR);*/

} // end of cbwcheck()
    

void datain(struct USBHandle *usb_handle)
{
  unsigned int value;
  unsigned int temp;
  
  temp = 0x1000000;
  writel(temp,medusa_base+ISR);
  
  //dprintk("handle_s->data_length_c is %08x \n",handle_s->data_length_c);
  //dprintk("handle_s->data_length is %08x \n",handle_s->data_length);  
  // Data transfer done, enter STATUS stage
  if(handle_s->data_length_c >= handle_s->data_length) 
  {
//    dprintk("Data Transfer done enter Status Stage \n");
    //dmac_clean_range((unsigned long *)handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));
    ////dmac_clean_range((unsigned long *) handle_s->data_addr,(((unsigned char *)handle_s->data_addr)+handle_s->data_length));    
    handle_s->bulk_cs = BULK_STATUS;
    //csw_cache
    //try1
    consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);
    //dprintk("CSW--\n");
    cswcheck(handle_s);
    //dprintk("CSW++\n");
  }
  else 
  {
  //      dprintk("Inside the Else part(Data transfer not done)\n");
      handle_s->data_length_c = handle_s->data_length_c + 512;

      if (handle_s->data_length_c >= handle_s->data_length) 
      {
    //      dprintk("CHECK THIS \n");
          //handle_s->bulk_cs =    BULK_STATUS;
          //cswcheck(usb_handle);
        return;
      }
   
      //dprintk("Before the SDRAM DMA \n");
      #ifndef SDRAM_DMA
    //  dprintk("Inside the SDRAM_DMA defined \n");
      // convert to Physical Address
      handle_s->data_addr = (int)&data_buffer[0];
    //ReadPhyMediaSectorNByte_i(
    //     usb_handle->Clba + (usb_handle->data_length_c / 512) ,
    //     usb_handle->noff,
    //     512, data_buffer);
      ReadPhyVDiskNByte(
           handle_s->Clba + (handle_s->data_length_c / 512) ,
           handle_s->noff,
           512, data_buffer);
      #endif
      // *USBMDAR = (unsigned int)usb_handle->data_addr;
      // *USBACR = 0x02000123;

      //newchange
      //writel(0x1000000,medusa_base+FHHR);

      //dprintk("Before writing the MDAR \n");
      //dprintk("handle_s->data_addr  is %08x \n",handle_s->data_addr);
      writel((unsigned int)handle_s->data_addr,medusa_base+MDAR);

      temp = 0x02000123;
      writel(temp,medusa_base+ACR);

      while (1) 
      {
        //value = *USBACR & 0x00000830;
          value = (readl(medusa_base+ACR) & 0x830);

        if (value == 0) 
        {
            //dprintk("NO Error after Dma \n");
            break;
        }
        else if (value == 0x00000800) 
        {
          // *USBISR = 0x1000000;
          // *USBACR |= 0x800;
          // *USBFHHR = 0x01020000;
            temp =  0x1000000;
            writel(temp,medusa_base+ISR);
              
            temp = readl(medusa_base+ACR);
            temp = temp | 0x800;
            writel(temp,medusa_base+ACR);
            
            //temp = 0x01020000; //--orign
            //writel(temp,medusa_base+FHHR); //--orign
             //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
            return;
        }
      }

      //phy_des_addr = virt_to_bus(&data_buffer[index]);
      //handle_s->data_addr = phy_des_addr;

      handle_s->data_addr = handle_s->data_addr + 512;
      //index = index + 512;
      handle_s->bulk_cs = BULK_DATA;
    }
  
  //temp = 0x1000000;
  //writel(temp,medusa_base+ISR);

  
  }


void cswcheck(struct USBHandle *usb_handle)
{

    //unsigned int*  pXferBuf;
    unsigned int   value;
    unsigned int temp;
    //int abc;

    //pXferBuf  =    (unsigned int *)xfer_buffer;

/*    if(csw_flag)
  {
      //dmac_clean_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));
      //cbw_buffer->buffer = cbw_buffer1;
      cswbuf = (struct csw_buffer *)cswbuf->buffer;
      // dprintk("cswbuf %08x \n",cswbuf);      
      csw_flag =0;
  }
  else
  {
      //dmac_clean_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));
      //cbw_buffer->buffer = cbw_buffer2;
      cswbuf = (struct csw_buffer *)cswbuf->buffer+16;
      
      // dprintk("cswbuf %08x \n",cswbuf);
      csw_flag = 1;
  }*/
  //dmac_clean_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));
  //dmac_clean_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));

    
    
    cswbuf->buffer[0] = CSWSIGNATURE;
    cswbuf->buffer[1] = handle_s->cswtag;
    cswbuf->buffer[2] = handle_s->cswres_c;
    cswbuf->buffer[3] = handle_s->cswstatus_c;

    // dprintk("cswbuf->buffer[0] is %08x \n",cswbuf->buffer[0] );
    // dprintk("CSWSIGNATURE is %08x \n\n",CSWSIGNATURE );

    // dprintk("cswbuf->buffer[1] is %08x \n",cswbuf->buffer[1] );
    // dprintk("handle_s->cswtag is %08x \n",handle_s->cswtag );

    //  dprintk("cswbuf->buffer[2] is %08x \n",cswbuf->buffer[2] );
    // dprintk("handle_s->cswres_c is %08x \n",handle_s->cswres_c );

    //dprintk("cswbuf->buffer[3] is %08x \n",cswbuf->buffer[3] );
    //dprintk("handle_s->cswstatus_c is %08x \n",handle_s->cswstatus_c );
    consistent_sync(cswbuf->buffer,13,DMA_TO_DEVICE);

    // stanlin add one line
//    dprintk("csw0%x\n", cswbuf->buffer[0]);
//    dprintk("csw1%x\n", cswbuf->buffer[1]);
//    dprintk("csw2%x\n", cswbuf->buffer[2]);
    dprintk("csw3%x\n", cswbuf->buffer[3]);
    

    //pXferBuf[0]    =    CSWSIGNATURE;
    //pXferBuf[1]    =    handle_s->cswtag;
    //pXferBuf[2]    =    handle_s->cswres_c;
    //pXferBuf[3]    =    handle_s->cswstatus_c;

    // *USBMDAR  =    (unsigned int)xfer_buffer;
    // *USBACR   =    0x000d0123;

    //for(abc =0;abc<20;abc++)
    //    dprintk("xfer_buffer[%d] is %08x \n",abc,xfer_buffer[abc] );

    //recentchange
    
    phy_des_addr = (dma_addr_t *)virt_to_bus(cswbuf->buffer);
    dprintk("1\n");
    writel((unsigned int)phy_des_addr,medusa_base+MDAR);

    //virt_addr = (unsigned long *)bus_to_virt(phy_des_addr);
    
    /*for(abc =0;abc<4;abc++)
        dprintk("virt_addr[%d] is %08x \n",abc,virt_addr[abc] );*/
    
    temp = 0x000d0123;
    writel(temp,medusa_base+ACR);

    while(1)
    {
        //value     =    *USBACR   &    0x830;
        value = (readl(medusa_base+ACR) & 0x830);
          if   (value == 0)
          {
              //dprintk("CSW No Error \n");
               break;
          }
          else if   (value == 0x800)
          {
              //  *USBISR   =    0x1000000;
              //     *USBACR   |=   0x800;
              //      *USBFHHR  =    0x01020000;

              temp =  0x1000000;
              writel(temp,medusa_base+ISR);
              
              temp = readl(medusa_base+ACR);
              temp = temp | 0x800;
              writel(temp,medusa_base+ACR);
            
              //temp = 0x01020000; //--orign
              //writel(temp,medusa_base+FHHR); //--orign
               //Shirley update for BFCR
               writel(0x20000, medusa_base + FHHR);
               writel(0x1, medusa_base + BFCR);
              return;
          }
    }
    // already commented *USBISR   =    0x1000000;
    //dmac_inv_range(cswbuf->buffer,(((unsigned char *)cswbuf->buffer)+13));

    // Clear data length counter
    handle_s->data_length_c     =    0;
    handle_s->cswres_c          =    0;
    
    /*for(abc =0;abc<4;abc++)
        dprintk("virt_addr[%d] is %08x \n",abc,virt_addr[abc] );*/

    if((handle_s->command == READ10) ||( handle_s->command ==  WRITE10))
    {
    //    dprintk("Inside Read or Write \n");
        handle_s->noff    =    0;
    }
    dprintk("End of cswcheck \n");
    
    
}
// cswcheck()

