struct ahb_pool {    /* the pool */
    
    struct list_head    page_list;
    spinlock_t        lock;
    size_t            blocks_per_page;
    size_t            size;
    int            flags;
    size_t            allocation;
    char            name [32];
    wait_queue_head_t    waitq;
};

struct ahb_page {    /* cacheable header for 'allocation' bytes */
    struct list_head    page_list;
    void            *vaddr;
    dma_addr_t        dma;
    unsigned long        bitmap [0];
};

#define    AHB_POOL_TIMEOUT_JIFFIES    ((100 /* msec */ * HZ) / 1000)
#define    AHB_POOL_POISON_BYTE    0xa7

