//  ***************************************************************************
// 
//   Copyright (c) 2009  Evatronix SA 
//
//  ***************************************************************************
//
//   Please review the terms of the license agreement before using     
//   this file. If you are not an authorized user, please destroy this 
//   source code file and notify Evatronix SA immediately that you     
//   inadvertently received an unauthorized copy.                      
//
//  ***************************************************************************
/// @file           nf_utils.c
/// @brief          Aditional helpful functions.
/// @version        $Revision: 1.3 $
/// @author         Piotr Sroka
/// @date           $Date: 2010-05-14 11:16:23 $
//  ***************************************************************************
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/types.h>
#include <linux/delay.h>

#include "nf_setup.h"
#include "nf_types.h"
#include "nf_utils.h"
#include "nf_controller.h"
#include "nf_error.h"
#include "nf_dma.h"

/******************************************************************************/
uint8_t wait_for_value(uint32_t reg_addr, uint32_t mask, uint32_t timeout_us, 
                       uint8_t is_set)
{
	timeout_us <<=1;
    if (is_set == 0){
        // wait until bit/bits will clear
		while (((IORD_32NF(reg_addr) & mask) != 0) && (timeout_us > 0)) {
			udelay(10);
			timeout_us -= 10;
		}
	}
	else {
        // wait until bit/bits will set
		while (((IORD_32NF(reg_addr) & mask) == 0) && (timeout_us > 0)) {
			udelay(10);
			timeout_us -= 10;
		}
	}

	return (timeout_us == 0) ? NF_ERR_TIMEOUT : NF_ERR_NO_ERRORS;
}

uint8_t get_fsb(uint32_t value)
{
    uint8_t counter = 32;

    while(--counter){
        if ((value >> counter) & 1){
            return counter;
        }
    }
    return 0;
}
