#ifndef __XRA1201_H
#define __XRA1201_H

#define XRA1201_I2C_ADDR    0x40
#define XRA1201_DIS	    	4
#define XRA1201_DOS	    	4
#define XRA1201_DIS_MASK    ((0x01<<XRA1201_DIS)-1)
#define XRA1201_DOS_MASK    ((0x01<<XRA1201_DOS)-1)

/* ##### command byte of XRA1201 i2C registers #####*/
#define XRA1201_GSR1	    0x00 /* GPIO State for P0-P7, RO */
#define XRA1201_GSR2	    0x01 /* GPIO State for P8-P15, RO */
#define XRA1201_OCR1	    0x02 /* Output Control for P0-P7, RW */
#define XRA1201_OCR2	    0x03 /* Output Control for P8-P15, RW */
#define XRA1201_PIR1	    0x04 /* Input Polarity Inversion for P0-P7, RW */
#define XRA1201_PIR2	    0x05 /* Input Polarity Inversion for P8-P15, RW */
#define XRA1201_GCR1	    0x06 /* GPIO Configuration for P0-P7, RW */
#define XRA1201_GCR2	    0x07 /* GPIO Configuration for P8-15, RW */
#define XRA1201_PUR1	    0x08 /* Input Internal Pull-up Resistor Enable/Disable for P0-P7, RW */
#define XRA1201_PUR2	    0x09 /* Input Internal Pull-up Resistor Enable/Disable for P8-P15, RW */
#define XRA1201_IER1	    0x0A /* Input Interrupt Enable for P0-P7, RW */
#define XRA1201_IER2        0x0B /* Input Interrupt Enable for P8-P15, RW */
#define XRA1201_TSCR1	    0x0C /* Output Three-State Control for P0-P7, RW */
#define XRA1201_TSCR2       0x0D /* Output Three-State Control for P8-P15, RW */
#define XRA1201_ISR1	    0x0E /* Input Interrupt Status for P0-P7, RO */
#define XRA1201_ISR2        0x0F /* Input Interrupt Status for P8-P15, RO */
#define XRA1201_REIR1	    0x10 /* Input Rising Edge Interrupt Enable for P0-P7, RW */
#define XRA1201_REIR2       0x11 /* Input Rising Edge Interrupt Enable for P8-P15, RW */
#define XRA1201_FEIR1	    0x12 /* Input Falling Edge Interrupt Enable for P0-P7, RW */
#define XRA1201_FEIR2	    0x13 /* Input Falling Edge Interrupt Enable for P8-P15, RW */
#define XRA1201_IFR1	    0x14 /* Input Filter Enable/Disable for P0-P7, RW */
#define XRA1201_IFR2	    0x15 /* Input Filter Enable/Disable for P8-P15, RW */

typedef struct {
    unsigned char GSR1;
    unsigned char GSR2;
    unsigned char OCR1;
    unsigned char OCR2;

    unsigned char PIR1;
    unsigned char PIR2;
    unsigned char GCR1;
    unsigned char GCR2;

    unsigned char PUR1;
    unsigned char PUR2;
    unsigned char IER1;
    unsigned char IER2;

    unsigned char TSCR1;
    unsigned char TSCR2;
    unsigned char ISR1;
    unsigned char ISR2;

    unsigned char REIR1;
    unsigned char REIR2;
    unsigned char FEIR1;
    unsigned char FEIR2;

    unsigned char IFR1;
    unsigned char IFR2;
    unsigned char rsv[2];
} tXra1201Regs;

extern int is_xra1201_found(void);
extern void xra1201_set_data_output(u_int, u_int);
extern u_int xra1201_read_data_input(void);
extern void xra1201_input_data_update(void);
//
extern void gpio_send_signal2app(int ev_type);

#endif  // __XRA1201_H

