#ifndef __LCM_H__
#define __LCM_H__

#include <asm/ioctl.h>

#define DEV_NAME	"lcm"

#define LCM_INIT_CMD    _IO('L', 0x1)
#define LCM_ROW_CMD     _IOW('L', 0x2, unsigned long)
#define LCM_COL_CMD     _IOW('L', 0x3, unsigned long)
#define LCM_CLEAR_CMD   _IO('L', 0x4)
#define LCM_READ_CMD    _IO('L', 0x5)
#define LCM_WRITE_CMD   _IO('L', 0x6)

#define LCM_BASE	IO_ADDRESS(UMVP_LCM_BASE)
#define LCM_CTRL_START  (LCM_BASE+0x00)
#define LCM_DATA_START  (LCM_BASE+0x04)
#define LCM_CTRL1       (LCM_BASE+0x08)
#define LCM_CTRL2       (LCM_BASE+0x0C)
#define LCM_DATA1       (LCM_BASE+0x20)
#define LCM_DATA2       (LCM_BASE+0x24)
#define LCM_DATA3       (LCM_BASE+0x28)
#define LCM_DATA4       (LCM_BASE+0x2C)
#define LCM_DATA5       (LCM_BASE+0x30)
#define LCM_DATA6       (LCM_BASE+0x34)
#define LCM_DATA7       (LCM_BASE+0x38)
#define LCM_DATA8       (LCM_BASE+0x3C)

#define UMVP_LCM_READ_REG(reg)  (*((volatile unsigned int *)(reg)))
#define UMVP_LCM_WRITE_REG(reg, value)  (*((volatile unsigned int *)(reg))) = ((unsigned int)(value))

#endif
