#include <stdio.h>
#include "sqlite3.h"

sqlite3 *pDB;

int callback (void *arg, int argc, char **argv, char **sCol)
{
	int i;
	for(i=0; i<argc; i++){
		printf("%s = %s\n", sCol[i], argv[i] ? argv[i] : "NULL");
	}
	printf("\n");
	return 0;
}

void  sql_query (char *s)
{
	char *errmsg = NULL;

	sqlite3_exec (pDB, s, callback, NULL, &errmsg);
	if (errmsg != NULL) {
		printf ("Error, sqlite3_exec(%s) failed errmsg %s.\n", s, errmsg);
		sqlite3_free (errmsg);
		errmsg = NULL;
		return;
	}
	printf ("leave sql_query %s\n", s);
	return;
}

#define DB	"./xx.db"
int main (int argc, char *argv[])
{
	int ret;
	char *errmsg = NULL;
	char buf[1024];

	unlink (DB);
	if ((ret = sqlite3_open (DB, &pDB)) != SQLITE_OK) {
		printf ("Error, sqlite3_open () failed ret %d error %s.\n", ret, sqlite3_errmsg (pDB));
		return -1;	
	}

#if 0
	if (argc <= 1) {
		printf ("Usage: ./%s <SQL>\n", argv[0]);
		return -1;
	}
#endif

	//sqlite3_exec (pDB, argv[1], NULL, NULL, &errmsg);
	sql_query ("\
CREATE TABLE event (\
		'id' INTEGER PRIMARY KEY AUTOINCREMENT, \
	    'type' INTEGER,\
		'state' INTEGER,\
		'misc' VARCHAR(255),	\
		'time' INTEGER DEFAULT '0');");
	sql_query ("INSERT INTO event(type, state, misc, time) VALUES (1, 1, '', 10);");
	sql_query ("INSERT INTO event(type, state, misc, time) VALUES (1, 1, '', 4);");
	sql_query ("INSERT INTO event(type, state, misc, time) VALUES (1, 1, '', 2);");
	sql_query ("INSERT INTO event(type, state, misc, time) VALUES (1, 1, '', 3);");
	sql_query ("\
CREATE TABLE media (\
		'id' INTEGER PRIMARY KEY AUTOINCREMENT, \
		'filename',\
	    'finished' BOOLEAN,\
		'starttime',\
		'stoptime' INTEGER,\
		'lock' BOOLEAN);");
	sql_query ("INSERT INTO media(filename, finished, starttime, stoptime, lock) VALUES('1.raw',1,datetime('now'),10,1);");
	sql_query ("INSERT INTO media(filename, finished, starttime, stoptime, lock) VALUES('2.raw',1,3,10,1);");
	sql_query ("INSERT INTO media(filename, finished, starttime, stoptime, lock) VALUES('3.raw',1,5,10,1);");

	/*sql_query ("SELECT starttime,1,filename,starttime,stoptime,0,0 FROM media UNION "
			"SELECT time,2,'',0,0,type,state FROM event ORDER BY starttime;");*/
	sql_query ("SELECT type,state,misc,time FROM event ORDER BY time;");
	sql_query ("SELECT filename,finished,starttime,stoptime,lock FROM media ORDER BY starttime;");



	if (sqlite3_close (pDB) != SQLITE_OK) {
		printf ("Error, sqlite3_close () failed.\n");
		return -1;
	}


	return 0;
}
