#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include "CommonHeader.h"
#include "Server.h"
#include "MiscFuncs.h"
#include "Event.h"

/*
 * Sending the msssage
 * Input:
 * 		cmd : Refer to event.h msg type of tStorageMsg
 * 		data: the message data
 * 		len: length of message data
 */
static int StreamingServerMsgSend (int cmd)
{
	tMsgBuff msg;
	int id;

	id = msgget (KEY_LOCAL_STORAGE_QUEUE, 0666 | IPC_CREAT);
	if (id == -1) {
		fprintf (stderr, "Error. msgget errno %d %s\n", errno, strerror (errno));
		return -1;
	}

	/* Accquire a receipt for tracking leaving state */
	msg.mtype = cmd;
	msg.mtext.state = NULL;
	/* Sending message */
	if (msgsnd (id, &msg, TMSGTEXTHEAD, IPC_NOWAIT) == -1) {
		fprintf (stderr, "Error. msgsnd errno %d %s\n", errno, strerror (errno));
		return -1;
	}

	return 0;
}

void insert_sd (void)
{
	fprintf (stderr, "insert_sd\n");
	/* A buffer time to wait SD Card fully inserted */
	sleep (1);

	/* Send a message to Streaming Server to notify the SD card is inserted */
	StreamingServerMsgSend (STORAGE_CARD_INSERTED);
	return;
}

void remove_sd (void)
{
	fprintf (stderr, "remove_sd\n");
	/* A buffer time to wait SD Card fully removed */
	sleep (1);

	/* Send a message to Streaming Server to notify the SD card is removed */
	StreamingServerMsgSend (STORAGE_CARD_REMOVED);
	system ("umount /mnt/hd");
	return;
}

int main (int argc, char *argv[])
{
	enum {ADD, REMOVE};
	int action = -1;
	char *value;

	if (argc < 2) {
		fprintf (stdout, "Usage:\n\t./%s [add/remove]\n\n", argv[0]);
	}

	if (argc >= 2) {
		if (strcmp (argv[1], "add") == 0) {
			action = ADD;
		} else if (strcmp (argv[1], "remove") == 0) {
			action = REMOVE;
		} else {
			fprintf (stderr, "Error, the input argument \"%s\" is invalid, leave.\n", argv[1]);
			exit (1);
		}
	} else {
		value = getenv ("ACTION");
		fprintf (stderr, "uEvent told me to %s\n", value ? value : "(null)");
		if (strcmp (value, "add") == 0) {
			action = ADD;
		} else if (strcmp (value, "remove") == 0) {
			action = REMOVE;
		} else {
			fprintf (stderr, "Error, the ACTION env value \"%s\" is invalid, leave.\n", value);
			exit (1);
		}
	}

	switch (action) {
	case ADD:
		insert_sd ();
		break;

	case REMOVE:
		remove_sd ();
		break;

	default:
		fprintf (stderr, "Error, program wrong.\n");
		exit (1);
	}
	return 0;
}
