#================================================================
# RPM Specification for QDBM
#================================================================



%define name qdbm
%define version 1.8.77
%define release 1
%define libver 14
%define librev 13
%define disturl http://qdbm.sourceforge.net/
%define homeurl http://qdbm.sourceforge.net/

Summary: Quick Database Manager
Name: %{name}
Version: %{version}
Release: %{release}
Source: %{disturl}%{name}-%{version}.tar.gz
Copyright: LGPL
Group: Development/Libraries
Packager: Mikio Hirabayashi <mikio@users.sourceforge.net>
Distribution: Private
Vendor: Private
Url: %{homeurl}
Requires: zlib
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
QDBM is an embeded database library compatible with GDBM and NDBM.
It features hash database and B+ tree database and is developed referring
to GDBM for the purpose of the following three points: higher processing
speed, smaller size of a database file, and simpler API.
This package includes APIs for C, C++, and Java.  CGI scripts are also
contained.  APIs for Perl and Ruby should be installed with a source package.

%package devel
Summary: Headers, libraries, utilities and documentation for QDBM
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
This package contains header files and libraries needed to develop programs
using the QDBM library.  Some utility commands are also provided.

%package plus
Summary: C++ libraries for QDBM
Group: Development/Libraries
Requires: %{name} = %{version}

%description plus
This package contains libraries needed to develop and run programs using the
QDBM C++ bindings.

%package java
Summary: Java libraries for QDBM
Group: Development/Libraries
Requires: %{name} = %{version}

%description java
This package contains libraries needed to develop and run programs using the
QDBM Java bindings.

%package cgi
Summary: CGI scripts with QDBM
Group: Development/Libraries
Requires: %{name} = %{version}

%description cgi
This package contains CGI scripts with QDBM, for administration of databases,
file uploading, and full-text search.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q

%build
( cd . ; %{configure} --prefix=%{_usr} --mandir=%{_mandir} \
  --enable-stable --enable-zlib --enable-iconv --enable-pthread ; make )
( cd plus ; %{configure} --prefix=%{_usr} --mandir=%{_mandir} ; make )
( cd java ; %{configure} --prefix=%{_usr} --mandir=%{_mandir} ; make )
( cd cgi ; %{configure} --prefix=%{_usr} --mandir=%{_mandir} ; make )

%install
rm -rf $RPM_BUILD_ROOT
( cd . ; make DESTDIR=$RPM_BUILD_ROOT install-strip )
( cd plus ; make DESTDIR=$RPM_BUILD_ROOT install-strip )
( cd java ; make DESTDIR=$RPM_BUILD_ROOT install )
( cd cgi ; make DESTDIR=$RPM_BUILD_ROOT install-strip )
( mkdir -p $RPM_BUILD_ROOT%{_datadir}/doc/qdbm && \
  cd $RPM_BUILD_ROOT%{_usr}/share/qdbm && \
  cp -Rf spex-ja.html spex.html COPYING ChangeLog NEWS THANKS \
    plus/xspex.html plus/xspex-ja.html plus/xapidoc \
    java/jspex.html java/jspex-ja.html java/japidoc \
    cgi/cgispex-ja.html cgi/cgispex.html $RPM_BUILD_ROOT%{_datadir}/doc/qdbm )

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_libdir}/libqdbm.so.%{libver}.%{librev}.0
%{_libdir}/libqdbm.so.%{libver}
%{_libdir}/libqdbm.so

%files devel
%defattr(-,root,root)
%{_includedir}/depot.h
%{_includedir}/curia.h
%{_includedir}/relic.h
%{_includedir}/hovel.h
%{_includedir}/cabin.h
%{_includedir}/villa.h
%{_includedir}/vista.h
%{_includedir}/odeum.h
%{_libdir}/libqdbm.a
%{_bindir}/dpmgr
%{_bindir}/dptest
%{_bindir}/dptsv
%{_bindir}/crmgr
%{_bindir}/crtest
%{_bindir}/crtsv
%{_bindir}/rlmgr
%{_bindir}/rltest
%{_bindir}/hvmgr
%{_bindir}/hvtest
%{_bindir}/cbtest
%{_bindir}/cbcodec
%{_bindir}/vlmgr
%{_bindir}/vltest
%{_bindir}/vltsv
%{_bindir}/odmgr
%{_bindir}/odtest
%{_bindir}/odidx
%{_bindir}/qmttest
%{_mandir}/man1/dpmgr.1.gz
%{_mandir}/man1/dptest.1.gz
%{_mandir}/man1/dptsv.1.gz
%{_mandir}/man1/crmgr.1.gz
%{_mandir}/man1/crtest.1.gz
%{_mandir}/man1/crtsv.1.gz
%{_mandir}/man1/rlmgr.1.gz
%{_mandir}/man1/rltest.1.gz
%{_mandir}/man1/hvmgr.1.gz
%{_mandir}/man1/hvtest.1.gz
%{_mandir}/man1/cbtest.1.gz
%{_mandir}/man1/cbcodec.1.gz
%{_mandir}/man1/vlmgr.1.gz
%{_mandir}/man1/vltest.1.gz
%{_mandir}/man1/vltsv.1.gz
%{_mandir}/man1/odmgr.1.gz
%{_mandir}/man1/odtest.1.gz
%{_mandir}/man1/odidx.1.gz
%{_mandir}/man1/qmttest.1.gz
%{_mandir}/man3/qdbm.3.gz
%{_mandir}/man3/depot.3.gz
%{_mandir}/man3/dpopen.3.gz
%{_mandir}/man3/curia.3.gz
%{_mandir}/man3/cropen.3.gz
%{_mandir}/man3/relic.3.gz
%{_mandir}/man3/hovel.3.gz
%{_mandir}/man3/cabin.3.gz
%{_mandir}/man3/villa.3.gz
%{_mandir}/man3/vlopen.3.gz
%{_mandir}/man3/vista.3.gz
%{_mandir}/man3/odeum.3.gz
%{_mandir}/man3/odopen.3.gz
%{_datadir}/doc/qdbm/spex.html
%{_datadir}/doc/qdbm/spex-ja.html
%{_datadir}/doc/qdbm/COPYING
%{_datadir}/doc/qdbm/ChangeLog
%{_datadir}/doc/qdbm/NEWS
%{_datadir}/doc/qdbm/THANKS
%{_libdir}/pkgconfig/qdbm.pc

%files plus
%defattr(-,root,root)
%{_includedir}/xqdbm.h
%{_includedir}/xadbm.h
%{_includedir}/xdepot.h
%{_includedir}/xcuria.h
%{_includedir}/xvilla.h
%{_libdir}/libxqdbm.a
%{_libdir}/libxqdbm.so.3.0.0
%{_libdir}/libxqdbm.so.3
%{_libdir}/libxqdbm.so
%{_bindir}/xdptest
%{_bindir}/xcrtest
%{_bindir}/xvltest
%{_datadir}/doc/qdbm/xspex.html
%{_datadir}/doc/qdbm/xspex-ja.html
%{_datadir}/doc/qdbm/xapidoc/

%files java
%defattr(-,root,root)
%{_libdir}/qdbm.jar
%{_libdir}/libjqdbm.so.1.0.0
%{_libdir}/libjqdbm.so.1
%{_libdir}/libjqdbm.so
%{_datadir}/doc/qdbm/jspex.html
%{_datadir}/doc/qdbm/jspex-ja.html
%{_datadir}/doc/qdbm/japidoc/

%files cgi
%defattr(-,root,root)
%{_libexecdir}/qadm.cgi
%{_libexecdir}/qupl.cgi
%{_libexecdir}/qfts.cgi
%{_datadir}/qdbm/cgi/qadm.conf
%{_datadir}/qdbm/cgi/qupl.conf
%{_datadir}/qdbm/cgi/qfts.conf
%{_datadir}/doc/qdbm/cgispex.html
%{_datadir}/doc/qdbm/cgispex-ja.html



# END OF FILE
