/* Definitions */
#define NONCE_SIZE (32)		/* arbitrary */

#define HT	(9)
#define CR	(13)
#define LF	(10)
#define SP	(32)
#define DEL	(127)

#define bool int

#define SASL_OK          0   /* successful result */
#define SASL_FAIL       -1   /* generic failure */
#define SASL_CONTINUE    1   /* another step is needed in authentication */

/* Layer Flags */
#define DIGEST_NOLAYER    (1)
#define DIGEST_INTEGRITY  (2)
#define DIGEST_PRIVACY    (4)

/* defines */
#define HASHLEN 16
typedef unsigned char HASH[HASHLEN + 1];
#define HASHHEXLEN 32
typedef unsigned char HASHHEX[HASHHEXLEN + 1];


/* context that stores info */
typedef struct context {
//    char *authid;
    char *realm;
    unsigned char *nonce;
    unsigned int nonce_count;
    unsigned char *cnonce;

    char *response_value;
    
    HASH HA1;		/* Kcc or Kcs */
    
    /* copy of utils from the params structures */
//    const sasl_utils_t *utils;
    
    /* For general use */
    char *out_buf;
    unsigned out_buf_len;

    char *serverFQDN;
    int protection;
    /* for encoding/decoding */
//    buffer_info_t *enc_in_buf;
//    char *encode_buf, *decode_buf, *decode_once_buf;
//    unsigned encode_buf_len, decode_buf_len, decode_once_buf_len;
//    char *decode_tmp_buf;
//    unsigned decode_tmp_buf_len;
//    char *MAC_buf;
//    unsigned MAC_buf_len;
	int server_maxbuf;
     
    /* if privacy mode is used use these functions for encode and decode */
//    cipher_function_t *cipher_enc;
//    cipher_function_t *cipher_dec;
//    cipher_init_t *cipher_init;
//    cipher_free_t *cipher_free;
//    struct cipher_context *cipher_enc_context;
//    struct cipher_context *cipher_dec_context;
} context_t;

int digestmd5_client_mech_step2(context_t *, char *, int , char *, char *, char **, int *);
int digestmd5_client_mech_step3(context_t *, const char *,unsigned );
void digestmd5_free(context_t *);
