/* soapSecurity.c
   Generated by gSOAP 2.7.16 from wssedemo.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"
#include "soapSecurity.h"

static const struct soap_code_map soap_codes_wsse__FaultcodeEnum[] =
{	{ (long)wsse__UnsupportedSecurityToken, "wsse:UnsupportedSecurityToken" },
	{ (long)wsse__UnsupportedAlgorithm, "wsse:UnsupportedAlgorithm" },
	{ (long)wsse__InvalidSecurity, "wsse:InvalidSecurity" },
	{ (long)wsse__InvalidSecurityToken, "wsse:InvalidSecurityToken" },
	{ (long)wsse__FailedAuthentication, "wsse:FailedAuthentication" },
	{ (long)wsse__FailedCheck, "wsse:FailedCheck" },
	{ (long)wsse__SecurityTokenUnavailable, "wsse:SecurityTokenUnavailable" },
	{ 0, NULL }
};

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__Security(struct soap *soap, struct _wsse__Security *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->wsu__Timestamp = NULL;
	a->UsernameToken = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__Security(struct soap *soap, const struct _wsse__Security *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_wsu__Timestamp(soap, &a->wsu__Timestamp);
	soap_serialize_PointerTo_wsse__UsernameToken(soap, &a->UsernameToken);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__Security(struct soap *soap, const char *tag, int id, const struct _wsse__Security *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__Security), type))
		return soap->error;
	if (soap_out_PointerTo_wsu__Timestamp(soap, "wsu:Timestamp", -1, &a->wsu__Timestamp, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__UsernameToken(soap, "wsse:UsernameToken", -1, &a->UsernameToken, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__Security * SOAP_FMAC4 soap_in__wsse__Security(struct soap *soap, const char *tag, struct _wsse__Security *a, const char *type)
{
	size_t soap_flag_wsu__Timestamp = 1;
	size_t soap_flag_UsernameToken = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__Security *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__Security, sizeof(struct _wsse__Security), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__Security(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_wsu__Timestamp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsu__Timestamp(soap, "wsu:Timestamp", &a->wsu__Timestamp, ""))
				{	soap_flag_wsu__Timestamp--;
				printf("Created: %s\n", a->wsu__Timestamp->Created);
				printf("Expires: %s\n", a->wsu__Timestamp->Expires);
				printf("wsu__Id: %s\n", a->wsu__Timestamp->wsu__Id);
					continue;
				}
			if (soap_flag_UsernameToken && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__UsernameToken(soap, "wsse:UsernameToken", &a->UsernameToken, ""))
				{	soap_flag_UsernameToken--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__Security *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__Security, 0, sizeof(struct _wsse__Security), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__Security(struct soap *soap, const struct _wsse__Security *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__Security);
	if (soap_out__wsse__Security(soap, tag?tag:"wsse:Security", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Security * SOAP_FMAC4 soap_get__wsse__Security(struct soap *soap, struct _wsse__Security *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__Security(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__Password(struct soap *soap, struct _wsse__Password *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->__item);
	soap_default_string(soap, &a->Type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__Password(struct soap *soap, const struct _wsse__Password *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->__item);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__Password(struct soap *soap, const char *tag, int id, const struct _wsse__Password *a, const char *type)
{
	if (a->Type)
		soap_set_attr(soap, "Type", a->Type);
	return soap_out_string(soap, tag, id, &a->__item, "");
}

SOAP_FMAC3 struct _wsse__Password * SOAP_FMAC4 soap_in__wsse__Password(struct soap *soap, const char *tag, struct _wsse__Password *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!(a = (struct _wsse__Password *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__Password, sizeof(struct _wsse__Password), 0, NULL, NULL, NULL)))
		return NULL;
	soap_revert(soap);
	*soap->id = '\0';
	soap_default__wsse__Password(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Type", 0), &a->Type, -1, -1))
		return NULL;
	if (!soap_in_string(soap, tag, &a->__item, ""))
		return NULL;
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__Password(struct soap *soap, const struct _wsse__Password *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__Password);
	if (soap_out__wsse__Password(soap, tag?tag:"wsse:Password", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Password * SOAP_FMAC4 soap_get__wsse__Password(struct soap *soap, struct _wsse__Password *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__Password(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->Username);
	a->Password = NULL;
	soap_default_string(soap, &a->Nonce);
	soap_default_string(soap, &a->wsu__Created);
	soap_default_string(soap, &a->wsu__Id);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsse__UsernameToken(struct soap *soap, const struct _wsse__UsernameToken *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Username);
	soap_serialize_PointerTo_wsse__Password(soap, &a->Password);
	soap_serialize_string(soap, &a->Nonce);
	soap_serialize_string(soap, &a->wsu__Created);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsse__UsernameToken(struct soap *soap, const char *tag, int id, const struct _wsse__UsernameToken *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsse__UsernameToken), type))
		return soap->error;
	if (soap_out_string(soap, "wsse:Username", -1, &a->Username, ""))
		return soap->error;
	if (soap_out_PointerTo_wsse__Password(soap, "wsse:Password", -1, &a->Password, ""))
		return soap->error;
	printf("%s: a->Password %s = %s\n", __func__, a->Password->__item, a->Password->Type);
	if (soap_out_string(soap, "wsse:Nonce", -1, &a->Nonce, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Created", -1, &a->wsu__Created, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsse__UsernameToken * SOAP_FMAC4 soap_in__wsse__UsernameToken(struct soap *soap, const char *tag, struct _wsse__UsernameToken *a, const char *type)
{
	size_t soap_flag_Username = 1;
	size_t soap_flag_Password = 1;
	size_t soap_flag_Nonce = 1;
	size_t soap_flag_wsu__Created = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsse__UsernameToken *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsse__UsernameToken, sizeof(struct _wsse__UsernameToken), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsse__UsernameToken(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, -1, -1))
		return NULL;

	printf("%s, Id:%s\n", __func__, a->wsu__Id);
//	printf("soap->body: %d, soap->href: %x\n", soap->body, *soap->href);
	if (soap->body && !*soap->href)
	{
		printf("%s\n", __func__);
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Username && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsse:Username", &a->Username, "xsd:string"))
				{	soap_flag_Username--;
				printf("wsse:Username = %s\n", a->Username);
					continue;
				}
			if (soap_flag_Password && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_wsse__Password(soap, "wsse:Password", &a->Password, ""))
				{	soap_flag_Password--;
				printf("%s: a->Password_item: %s\n", __func__, a->Password->__item);
				printf("%s: a->Password_type: %s\n", __func__, a->Password->Type);
					continue;
				}
			if (soap_flag_Nonce && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsse:Nonce", &a->Nonce, "xsd:string"))
				{	soap_flag_Nonce--;
					continue;
				}
			if (soap_flag_wsu__Created && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Created", &a->wsu__Created, "xsd:string"))
				{	soap_flag_wsu__Created--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsse__UsernameToken *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsse__UsernameToken, 0, sizeof(struct _wsse__UsernameToken), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsse__UsernameToken(struct soap *soap, const struct _wsse__UsernameToken *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsse__UsernameToken);
	if (soap_out__wsse__UsernameToken(soap, tag?tag:"wsse:UsernameToken", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__UsernameToken * SOAP_FMAC4 soap_get__wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsse__UsernameToken(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->wsu__Id);
	soap_default_string(soap, &a->Created);
	soap_default_string(soap, &a->Expires);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__wsu__Timestamp(struct soap *soap, const struct _wsu__Timestamp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->Created);
	soap_serialize_string(soap, &a->Expires);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__wsu__Timestamp(struct soap *soap, const char *tag, int id, const struct _wsu__Timestamp *a, const char *type)
{
	if (a->wsu__Id)
		soap_set_attr(soap, "wsu:Id", a->wsu__Id);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__wsu__Timestamp), type))
		return soap->error;
	if (soap_out_string(soap, "wsu:Created", -1, &a->Created, ""))
		return soap->error;
	if (soap_out_string(soap, "wsu:Expires", -1, &a->Expires, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct _wsu__Timestamp * SOAP_FMAC4 soap_in__wsu__Timestamp(struct soap *soap, const char *tag, struct _wsu__Timestamp *a, const char *type)
{
	size_t soap_flag_Created = 1;
	size_t soap_flag_Expires = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _wsu__Timestamp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__wsu__Timestamp, sizeof(struct _wsu__Timestamp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__wsu__Timestamp(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "wsu:Id", 0), &a->wsu__Id, -1, -1))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Created && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Created", &a->Created, "xsd:string"))
				{	soap_flag_Created--;
					continue;
				}
			if (soap_flag_Expires && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "wsu:Expires", &a->Expires, "xsd:string"))
				{	soap_flag_Expires--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _wsu__Timestamp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__wsu__Timestamp, 0, sizeof(struct _wsu__Timestamp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__wsu__Timestamp(struct soap *soap, const struct _wsu__Timestamp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__wsu__Timestamp);
	if (soap_out__wsu__Timestamp(soap, tag?tag:"wsu:Timestamp", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsu__Timestamp * SOAP_FMAC4 soap_get__wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *p, const char *tag, const char *type)
{
	if ((p = soap_in__wsu__Timestamp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__Security(struct soap *soap, struct _wsse__Security *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__Security))
		soap_serialize__wsse__Security(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__Security(struct soap *soap, const char *tag, int id, struct _wsse__Security *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__Security);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__Security(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__Security ** SOAP_FMAC4 soap_in_PointerTo_wsse__Security(struct soap *soap, const char *tag, struct _wsse__Security **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__Security **)soap_malloc(soap, sizeof(struct _wsse__Security *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__Security(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__Security **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__Security, sizeof(struct _wsse__Security), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__Security(struct soap *soap, struct _wsse__Security *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__Security);
	if (soap_out_PointerTo_wsse__Security(soap, tag?tag:"wsse:Security", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Security ** SOAP_FMAC4 soap_get_PointerTo_wsse__Security(struct soap *soap, struct _wsse__Security **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__Security(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__UsernameToken))
		soap_serialize__wsse__UsernameToken(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__UsernameToken(struct soap *soap, const char *tag, int id, struct _wsse__UsernameToken *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__UsernameToken);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__UsernameToken(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__UsernameToken ** SOAP_FMAC4 soap_in_PointerTo_wsse__UsernameToken(struct soap *soap, const char *tag, struct _wsse__UsernameToken **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__UsernameToken **)soap_malloc(soap, sizeof(struct _wsse__UsernameToken *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__UsernameToken(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__UsernameToken **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__UsernameToken, sizeof(struct _wsse__UsernameToken), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__UsernameToken);
	if (soap_out_PointerTo_wsse__UsernameToken(soap, tag?tag:"wsse:UsernameToken", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__UsernameToken ** SOAP_FMAC4 soap_get_PointerTo_wsse__UsernameToken(struct soap *soap, struct _wsse__UsernameToken **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__UsernameToken(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsu__Timestamp))
		soap_serialize__wsu__Timestamp(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsu__Timestamp(struct soap *soap, const char *tag, int id, struct _wsu__Timestamp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsu__Timestamp);
	if (id < 0)
		return soap->error;
	return soap_out__wsu__Timestamp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsu__Timestamp ** SOAP_FMAC4 soap_in_PointerTo_wsu__Timestamp(struct soap *soap, const char *tag, struct _wsu__Timestamp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsu__Timestamp **)soap_malloc(soap, sizeof(struct _wsu__Timestamp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsu__Timestamp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsu__Timestamp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsu__Timestamp, sizeof(struct _wsu__Timestamp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsu__Timestamp);
	if (soap_out_PointerTo_wsu__Timestamp(soap, tag?tag:"wsu:Timestamp", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsu__Timestamp ** SOAP_FMAC4 soap_get_PointerTo_wsu__Timestamp(struct soap *soap, struct _wsu__Timestamp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsu__Timestamp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_wsse__Password(struct soap *soap, struct _wsse__Password *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__wsse__Password))
		soap_serialize__wsse__Password(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_wsse__Password(struct soap *soap, const char *tag, int id, struct _wsse__Password *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__wsse__Password);
	if (id < 0)
		return soap->error;
	return soap_out__wsse__Password(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _wsse__Password ** SOAP_FMAC4 soap_in_PointerTo_wsse__Password(struct soap *soap, const char *tag, struct _wsse__Password **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _wsse__Password **)soap_malloc(soap, sizeof(struct _wsse__Password *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__wsse__Password(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _wsse__Password **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__wsse__Password, sizeof(struct _wsse__Password), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_wsse__Password(struct soap *soap, struct _wsse__Password *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_wsse__Password);
	if (soap_out_PointerTo_wsse__Password(soap, tag?tag:"wsse:Password", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct _wsse__Password ** SOAP_FMAC4 soap_get_PointerTo_wsse__Password(struct soap *soap, struct _wsse__Password **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_wsse__Password(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsse__FaultcodeEnum
	*a = SOAP_DEFAULT_wsse__FaultcodeEnum;
#else
	*a = (enum wsse__FaultcodeEnum)0;
#endif
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsse__FaultcodeEnum2s(struct soap *soap, enum wsse__FaultcodeEnum n)
{	const char *s = soap_code_str(soap_codes_wsse__FaultcodeEnum, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsse__FaultcodeEnum(struct soap *soap, const char *tag, int id, const enum wsse__FaultcodeEnum *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsse__FaultcodeEnum), type) || soap_send(soap, soap_wsse__FaultcodeEnum2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsse__FaultcodeEnum(struct soap *soap, const char *s, enum wsse__FaultcodeEnum *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsse__FaultcodeEnum, t);
	if (map)
		*a = (enum wsse__FaultcodeEnum)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 6)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsse__FaultcodeEnum)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_in_wsse__FaultcodeEnum(struct soap *soap, const char *tag, enum wsse__FaultcodeEnum *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsse__FaultcodeEnum *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsse__FaultcodeEnum, sizeof(enum wsse__FaultcodeEnum), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsse__FaultcodeEnum(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsse__FaultcodeEnum *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsse__FaultcodeEnum, 0, sizeof(enum wsse__FaultcodeEnum), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsse__FaultcodeEnum(struct soap *soap, const enum wsse__FaultcodeEnum *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsse__FaultcodeEnum);
	if (soap_out_wsse__FaultcodeEnum(soap, tag?tag:"wsse:FaultcodeEnum", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsse__FaultcodeEnum * SOAP_FMAC4 soap_get_wsse__FaultcodeEnum(struct soap *soap, enum wsse__FaultcodeEnum *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsse__FaultcodeEnum(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_wsu__tTimestampFault
	*a = SOAP_DEFAULT_wsu__tTimestampFault;
#else
	*a = (enum wsu__tTimestampFault)0;
#endif
}

static const struct soap_code_map soap_codes_wsu__tTimestampFault[] =
{	{ (long)wsu__MessageExpired, "wsu:MessageExpired" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_wsu__tTimestampFault2s(struct soap *soap, enum wsu__tTimestampFault n)
{	const char *s = soap_code_str(soap_codes_wsu__tTimestampFault, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_wsu__tTimestampFault(struct soap *soap, const char *tag, int id, const enum wsu__tTimestampFault *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_wsu__tTimestampFault), type) || soap_send(soap, soap_wsu__tTimestampFault2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2wsu__tTimestampFault(struct soap *soap, const char *s, enum wsu__tTimestampFault *a)
{
	const struct soap_code_map *map;
	char *t;
	if (!s)
		return soap->error;
	soap_s2QName(soap, s, &t, -1, -1);
	map = soap_code(soap_codes_wsu__tTimestampFault, t);
	if (map)
		*a = (enum wsu__tTimestampFault)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum wsu__tTimestampFault)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_in_wsu__tTimestampFault(struct soap *soap, const char *tag, enum wsu__tTimestampFault *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (enum wsu__tTimestampFault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_wsu__tTimestampFault, sizeof(enum wsu__tTimestampFault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2wsu__tTimestampFault(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum wsu__tTimestampFault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_wsu__tTimestampFault, 0, sizeof(enum wsu__tTimestampFault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_wsu__tTimestampFault(struct soap *soap, const enum wsu__tTimestampFault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_wsu__tTimestampFault);
	if (soap_out_wsu__tTimestampFault(soap, tag?tag:"wsu:tTimestampFault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 enum wsu__tTimestampFault * SOAP_FMAC4 soap_get_wsu__tTimestampFault(struct soap *soap, enum wsu__tTimestampFault *p, const char *tag, const char *type)
{
	if ((p = soap_in_wsu__tTimestampFault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}


/* End of soapSecurity.c */
