// vim: ts=4 sw=4
/* ######################################################################################
 * onvif.h
 * created by Cathy. date: 2010/08/06
 * modified by Skyter. date: 2011/03/02
 * Description:
 *    header file of the OnvifAPIs.c
 * ###################################################################################### */
#ifndef _onvif_h_
#define _onvif_h_
#include "ErrCode.h" /* mask this for A1 platform */
#include "Common.h"  /* mask this for A1 platform */
//#include "CommonHeader.h" /* Add this for A1 platform */
//#include "Server.h" /* add this for A1 platform */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/prctl.h>
#include "Http.h"
#include "debug.h"
#include "log.h"

#include <pthread.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/types.h>			/* See NOTES */
#include <sys/time.h>			/* See NOTES */

#include "soapStub.h"
#include "Net.h"

/* ##### supported Onvif cose spec. version */
/* ##### now, we support onvif 2.2 ##### */
#define ONVIF_VERSION_MAJOR		2	/* one digit */
#define ONVIF_VERSION_MINOR		20	/* two digits */

/* ######################################################################################
 * Definitions of Onvif database 
 * ###################################################################################### */
#define ONVIF_ACCOUNT_NAME_LEN	32
#define ONVIF_ACCOUNT_PWD_LEN	64
#define ONVIF_THREAD_STACK	512*1024	/* default stack size is 2,093,056 bytes */

enum {
	ONVIF_SOCK_OPT_DISABLE=0,
	ONVIF_SOCK_OPT_ENABLE
};

enum {
	ONVIF_METHOD_TCP2 = 0,
	ONVIF_METHOD_MCAST,
	ONVIF_METHOD_TCP2_MCAST,
	ONVIF_METHOD_RTP,
	ONVIF_METHOD_RTP_MCAST,
	ONVIF_METHOD_RTP_DUAL,
	ONVIF_METHOD_UNKNOWN
};

typedef enum
{
	ONVIF_STD_DEFAULT,
	ONVIF_NTSC,
	ONVIF_PAL
} TV_STD;

enum {
	ONVIF_STATE_INIT = 0,
	ONVIF_STATE_RUN,
	ONVIF_STATE_ERR,
	ONVIF_STATE_STOP,
	ONVIF_STATE_CLOSE
};

enum {
	ONVIF_DLS_TIME_QUIT=0,
	ONVIF_DLS_TIME_TYPE1,
	ONVIF_DLS_TIME_TYPE2
};
/* ##### definitions in index in week in tDLSTime ##### */
enum {
        ONVIF_DLS_WEEK_FIRST=1,
        ONVIF_DLS_WEEK_SECOND,
        ONVIF_DLS_WEEK_THIRD,
        ONVIF_DLS_WEEK_LAST
};
/* Normalization/Denormalization Options */
enum  
{
	OPT_PAN_SPEED = 0, //Generic
	OPT_PAN_POSITION,  //Absolute or Relative
	OPT_PAN_VELOCITY,  //Velocity
	OPT_TILT_SPEED,
	OPT_TILT_POSITION,
	OPT_TILT_VELOCITY,
	OPT_ZOOM_SPEED,
	OPT_ZOOM_POSITION,
	OPT_ZOOM_VELOCITY
}; 
/* PTZ Limit */
enum 
{ 
 	LIMIT_MIN = 0, 
 	LIMIT_MAX 
}; 
/* Imaging Exposure Iris */
/*
enum {
	IRIS_NO_SUPPORTED = 0,  // not supported
        IRIS_F220,                              // 22 mm
        IRIS_F190,                              // 19 mm
        IRIS_F160,                              // 16 mm
        IRIS_F140,              // 14 mm
        IRIS_F110,              // 11 mm
        IRIS_F96,               // 9.6 mm
        IRIS_F80,               // 8.0 mm
        IRIS_F68,               // 6.8 mm
        IRIS_F56,               // 5.6 mm
        IRIS_F48,               // 4.8 mm
        IRIS_F40,               // 4.0 mm
        IRIS_F34,               // 3.4 mm
        IRIS_F28,               // 2.8 mm
        IRIS_F24,               // 2.4 mm
        IRIS_F20,               // 2.0 mm
        IRIS_F16,               // 1.6 mm
        IRIS_F14,               // 1.4 mm
        IRIS_F10,               // 1.0 mm
        MAX_SUPPORTED_IRIS              // 20/Mar/2007
};
*/
/* ##### Configuration of tOnvifDLSTime ##### */
typedef struct {
        int type;
        union {
                struct {
                        int mon; /* month: 1~12 */
                        int week; /* week of a month. 1~4 */
                        int hour; /* hour: 0~23 */
                        int min;  /* minute: 0~59 */
                        int wday; /* weekday. 1~7 for Monday~Sunday */
                } type1;
                struct {
                        int mon; /* month: 1~12 */
                        int mday; /* month day. 1~31 */
                        int hour; /* hour: 0~23 */
                        int min; /* minute: 0~59 */
                } type2;
        } set;
} tOnvifDLSTime;
/* ##### Configuration of the Daylight Saving ##### */
typedef struct {
        int      state;  /* refer to Common.h ENABLE/DISABLE enum definitons */
        tOnvifDLSTime start;
        tOnvifDLSTime end;
} tOnvifDLS;

typedef struct {
	int state;
	int trigger;
	enum xsd__boolean valid;	//true_: valid   false_:invalid, valid for waiting trigger
} SourceDescription;

#define ONVIF_MSG_LEN		258
typedef struct {
	int mtype;
	char mtext[ONVIF_MSG_LEN];
} tOnvifMsgBuf;

typedef struct{
	int state;
	int msgid;
	char Name[ONVIF_ACCOUNT_NAME_LEN];
	char Pwd[ONVIF_ACCOUNT_PWD_LEN];
	int HttpPort;
} OnvifDB;

typedef enum{
	ONVIF_CMD_NONE = 0,
	ONVIF_MAIN_THREAD_START,
	ONVIF_MAIN_THREAD_CLOSE,
	ONVIF_MAIN_THREAD_RESTART
}tOnvifMsg;

#define	KEY_ONVIF_QUEUE	2019

#define MAX_TOKEN_STRLEN	32
#define ISO8601_DURATION_STRLEN		23
#define V2_WAN_STATUS_LEN       320

typedef struct {
	char Token[MAX_TOKEN_STRLEN]; /* Relay Output token */
	char DelayTime[ISO8601_DURATION_STRLEN+1];	/* required element of type xsd:duration */
}Acti_RelayOutput;

struct onvif_convert_int {
	unsigned int name;			//url command value
	unsigned int value;			//convert to private data or media data:  value or index
};

#define MAX_SCOPES_STRLEN	512
#define MAX_UUID_LEN		48
#define MAX_PROFILE_STR		32
#define MAX_NAMESPACE_LEN	95	
#define MAX_AUX_LEN		39
#define MAX_SCOPES_LIST		10
#define MAX_PROFILE_LIST	20
#define MAX_VS_LIST		2
#define MAX_VE_LIST		10
#define MAX_EVENT_SCRIPTION_NUM	 8
#define MAX_EVENT_NUM	 	64
#define DEFAULT_EVENT_TIMEINTERVAL	10
#define MIN_EVENT_TIMEINTERVAL	 2
#define MIN_EVENT_MESSAGE_LIMIT	 1
#define MAX_PTZ_CONFIGS		8
#define MAX_CONTENT_MSG_NUM	7  // MD1 MD2 MD2 DI1 DI2 DI3 DI4
#define MIN_ZOOM_SPEED		2
#define MAX_ZOOM_SPEED		7
#define MIN_MOVE_SPEED		1
#define MAX_MOVE_SPEED		5
#define CURRENT_PHY_ZOOM_POS	65535
/* Physical PTZ Speed */
#define MIN_PHY_PAN_SPEED 	1
#define MAX_PHY_PAN_SPEED 	5
#define MIN_PHY_TILT_SPEED 	1
#define MAX_PHY_TILT_SPEED 	5
#define MIN_PHY_ZOOM_SPEED	2
#define MAX_PHY_ZOOM_SPEED	7
#define MAX_AUX_SIZE		2
/* physical Imaging Range */
#define MIN_PHY_BRIGHTNESS      0
#define MAX_PHY_BRIGHTNESS      100
#define MIN_PHY_SATURATION      0
#define MAX_PHY_SATURATION      100
#define MIN_PHY_CONTRAST        0
#define MAX_PHY_CONTRAST        100
#define MIN_PHY_EXPOSURE_GAIN	1
#define MAX_PHY_EXPOSURE_GAIN	255
#define MIN_PHY_SHARPNESS	    1
#define MAX_PHY_SHARPNESS	    255
#define MIN_PHY_WDR             0
#define MAX_PHY_WDR             255
#define MAX_WDR_SIZE		    2

#define MAX_DI_NUM              4
#define MAX_DO_NUM              4
#define MAX_PRESET_NUM		    64

#define ONVIF_MOTION_WINDOWS    3

#define MAX_CONF_NAME_LEN		32
#define MAX_CONF_DATA_LEN		320
typedef struct {
	char name[MAX_CONF_NAME_LEN];
	char data[MAX_CONF_DATA_LEN];
} tOnvifConfEntry;
#define ONVIF_CONF_ENTRY_LEN          sizeof(tOnvifConfEntry)
#define MAX_ONVIF_CONF_ENTRY          512
typedef struct {
	int        len;
	tOnvifConfEntry entry[MAX_ONVIF_CONF_ENTRY];
} tOnvifDevConf;

typedef struct {
//	char Account[2][ONVIF_ACCOUNT_PWD_LEN];
	char Name[ONVIF_ACCOUNT_NAME_LEN];
	char Pwd[ONVIF_ACCOUNT_PWD_LEN];
	int HttpPort;
}OnvifReqValue;

#define URLCMD_LEN      240
typedef struct {
    int  len; /* length of the cmd */
    char cgi[12];
    char cmd[URLCMD_LEN];
} tUrlDB;

#define URLCGI_LEN		12
typedef struct {
	char cgi[URLCGI_LEN];
	int  len;
	char cmd[URLCMD_LEN];
	int  maxReplyLen; /* max size of *reply */
	char *reply; /* container of return message of url commands */
} tOnvifUrl;

typedef struct {
	char DifinStr[20]; /* scope difinition array*/
	char tStr[MAX_SCOPES_STRLEN]; /* total scopes string */
    int size; /* scope items */
	char *Ptr[MAX_SCOPES_LIST]; /* scope pointer, reference tStr[] */
	char difin[MAX_SCOPES_LIST]; /* scope definition, reference DifinStr[] */
	int location_count;
}Acti_Scopes ;

typedef struct {
	enum tt__IPType Type;
	char IPv4Address[16];
	int Port;
	int TTL;
	enum xsd__boolean AutoStart;
} Acti_MulticastConfiguration; 

typedef struct {
	/* BLC */
	enum tt__BacklightCompensationMode BLCMode;
	float BLCLevel;
	float Brightness;
	float ColorSaturation;
	float Contrast;
	/* Exposure */
	enum tt__ExposureMode ExposureMode;
	enum tt__ExposurePriority ExposurePriority;
	float ExposureWindowBottom;
	float ExposureWindowTop;
	float ExposureWindowRight;
	float ExposureWindowLeft;
	float MinExposureTime;
	float MaxExposureTime;
	float MinGain;
	float MaxGain;
	float MinIris;
	float MaxIris;
	float ExposureTime;
	float Gain;
	float Iris;
	/* Focus */
	enum tt__AutoFocusMode AutoFocusMode;
	float DefaultSpeed;
	float NearLimit;
	float FarLimit;
	enum tt__IrCutFilterMode IrCutFilter;
	float Sharpness;
	/* WideDynamicRange */
	enum tt__WideDynamicMode WDRMode;
	float WDRLevel;
	/* WhiteBalance */
	enum tt__WhiteBalanceMode WhiteBalanceMode;
	float CrGain;
	float CbGain;
} Acti_ImagingSettings;

typedef struct {
	/* BLC */
	int sizeBLCMode;
	enum tt__BacklightCompensationMode BLCMode;
	float MinBLCLevel;
	float MaxBLCLevel;
	/* Brightness */	
	float MinBrightness;
	float MaxBrightness;
	/* Saturation */
	float MinSaturation;
	float MaxSaturation;
	/* Contrast */	
	float MinContrast;
	float MaxContrast;
	/* Exposure */
	int sizeExposureMode;
	enum tt__ExposureMode ExposureMode;	//{AUTO_ = 0, MANUAL_ = 1};
	int sizeExposurePriority;
	enum tt__ExposurePriority ExposurePriority;
	float MinExposureTime;	
	float MaxExposureTime;
	float MinGain;
	float MaxGain;
	float MinIris;
	float MaxIris;
	float ExposureTime;
	float Gain;
	float Iris;
	/* Focus */
	int sizeAutoFocusModes;
	enum tt__AutoFocusMode AutoFocusModes;
	float MinDefaultSpeed;
	float MaxDefaultSpeed;
	float MinNearLimit;
	float MaxNearLimit;
	float MinFarLimit;
	float MaxFarLimit;
	/* IrCut*/
	int sizeIrCutFilterModes;
	enum tt__IrCutFilterMode IrCutFilterModes;
	/* Sharpness */
	float MinSharpness;
	float MaxSharpness;
	/* WideDynamicRange */
	int sizeWDRMode;
	enum tt__WideDynamicMode WDRMode[MAX_WDR_SIZE];
	float MinWDRLevel;
	float MaxWDRLevel;
	/* WhiteBalance */
	int sizeWhiteBalanceMode;
	enum tt__WhiteBalanceMode WhiteBalanceMode;
	float MinYrGain;
	float MaxYrGain;
	float MinYbGain;
	float MaxYbGain;
} Acti_ImagingOptions;

typedef struct {
    char Token[MAX_TOKEN_STRLEN];
    int FrameRate;
    struct tt__VideoResolution res;
    Acti_ImagingSettings img;
    Acti_ImagingOptions ImgOpt;
} Acti_VideoSources;

typedef struct {
    char Name[MAX_PROFILE_STR];	/* required element of type tt:Name */
    int UseCount;	/* required element of type xsd:int */
    char token[MAX_TOKEN_STRLEN];	/* required attribute of type tt:ReferenceToken */
    int SourceTokenIdx; /* Reference SourceToken group */
    struct tt__IntRectangle b; /* required element of type tt:IntRectangle */
    enum xsd__boolean ForcePersistence;
}Acti_VideoSourceConfig;

typedef struct {
    int   valid; /* 0: this video encoder configuration is not vaild. 1: otherwise */
    int   needSaved; /* 0: no need to save to flash, 1: otherwise */
    int   videoSrc; /* 1: video source 1, 2: video source 2 */
    int   videoSrcInProfile; /* -1: no profile asociated, 1: video source 1, 2: video source 2 */
    char  Name[MAX_PROFILE_STR];	/* required element of type tt:Name */
    int   UseCount;	/* required element of type xsd:int */
    char  token[MAX_TOKEN_STRLEN];	/* required attribute of type tt:ReferenceToken */
    enum  tt__VideoEncoding Encoding;	/* required element of type tt:VideoEncoding */
    struct tt__VideoResolution r;
    int   Quality;
    struct tt__VideoRateControl rc;
    union{
        struct tt__Mpeg4Configuration MPEG4;	/* optional element of type tt:Mpeg4Configuration */
        struct tt__H264Configuration H264;	/* optional element of type tt:H264Configuration */
    } t;
    Acti_MulticastConfiguration Multicast; 
    char SessionTimeout[ISO8601_DURATION_STRLEN+1];	/* required element of type xsd:duration */
}Acti_VideoEncoderConfig;

typedef struct {
    int valid; /* 0: invalid, 1: otherwise */
	char Name[MAX_PROFILE_STR];	/* required element of type tt:Name */
	int UseCount;	/* required element of type xsd:int */
	char token[MAX_TOKEN_STRLEN];	/* required attribute of type tt:ReferenceToken */
	//struct tt__EventSubscription Events;	/* optional element of type tt:EventSubscription */
	//struct tt__MulticastConfiguration Multicast;	/* required element of type tt:MulticastConfiguration */
	/*multicast, todo!! */
	enum tt__IPType IPType;
	char IPv4Address[16];
	enum xsd__boolean AutoStart;	
	char SessionTimeout[ISO8601_DURATION_STRLEN+1];	/* required element of type xsd:duration */
}Acti_MetaDataConfig;

typedef struct {
	char token[MAX_TOKEN_STRLEN];
	int Channels;
} Acti_AudioSources; 

typedef struct {
	char Name[MAX_PROFILE_STR];	
	int UseCount;
	char token[MAX_TOKEN_STRLEN];
	char SourceToken[MAX_TOKEN_STRLEN];
} Acti_AudioSourceConfig;

typedef struct {
	char Name[MAX_PROFILE_STR];
	int UseCount;
	char token[MAX_TOKEN_STRLEN];
	enum tt__AudioEncoding Encoding;
	int Bitrate;
	int SampleRate;
	Acti_MulticastConfiguration Multicast;
	char SessionTimeout[ISO8601_DURATION_STRLEN+1];
} Acti_AudioEncoderConfig;

typedef struct {
	//struct tt__PanTiltLimits PanTiltLimits;
	/* PanTiltLimits */	
	float MinPanLimits;	
	float MaxPanLimits;	
	float MinTiltLimits;	
	float MaxTiltLimits;	
	//struct tt__ZoomLimits ZoomLimits;
	/* ZoomLimits */	
	float MinZoomLimits;
	float MaxZoomLimits;
} Acti_PTZLimits;

typedef struct {
	char Token[MAX_TOKEN_STRLEN]; 	//PTZ Configuration Token	
	char Name[MAX_PROFILE_STR]; 	//PTZ User Name. 
	char NodeToken[MAX_TOKEN_STRLEN]; 	//refer to PTZ Node. Currently, we have One PTZ Node.
	int UseCount; 				//Use Count of PTZ Configurations. Currently, we have One PTZ configuration
	char AbsolutePantTiltPositionSpace[MAX_NAMESPACE_LEN + 1];
	char AbsoluteZoomPositionSpace[MAX_NAMESPACE_LEN + 1];	
	char RelativePanTiltTranslationSpace[MAX_NAMESPACE_LEN + 1];
	char RelativeZoomTranslationSpace[MAX_NAMESPACE_LEN + 1];	
	char ContinuousPanTiltVelocitySpace[MAX_NAMESPACE_LEN + 1];
	char ContinuousZoomVelocitySpace[MAX_NAMESPACE_LEN + 1];
	int PTZ_timeout;
	/* DefaultPTZSpeed */
	float PanDefaultSpeed; 
	float TiltDefaultSpeed; 
	char PTDefaultSpeedSpace[MAX_NAMESPACE_LEN + 1];
	float ZoomDefaultSpeed; 
	char ZoomDefaultSpeedSpace[MAX_NAMESPACE_LEN + 1];
	/* PanTiltLimits */	
	float MinPanLimits;	
	float MaxPanLimits;	
	float MinTiltLimits;	
	float MaxTiltLimits;	
	char PanTiltLimits_URI[MAX_NAMESPACE_LEN + 1]; 
	/* ZoomLimits */	
	float MinZoomLimits;
	float MaxZoomLimits;
	char ZoomLimits_URI[MAX_NAMESPACE_LEN + 1]; 
	int  maxPresetPoints; /* TCM: 256, KCM:64, A1: 256*/
} Acti_PTZConfig;

typedef struct {
	char token[MAX_TOKEN_STRLEN];
	char Name[MAX_PROFILE_STR];
	//struct tt__PTZSpaces SupportedPTZSpaces;
	int MaximumNumberOfPresets;
	enum xsd__boolean HomeSupported;
	char MinPTZTimeout[ISO8601_DURATION_STRLEN + 1];
	char MaxPTZTimeout[ISO8601_DURATION_STRLEN + 1];
	int sizeAuxiliaryCommands;
	char AuxiliaryCommands[MAX_AUX_SIZE][MAX_AUX_LEN+1];
} Acti_PTZNode; 
/* below Marco for attr of Acti_MediaProfile */
#define VARIABLE	0
#define FIXED		1

typedef struct {
    int  valid; /* 0: invalid, 1: vaild */
    int  readOnly; /* 0: this profile is configurable, 1: otherwise */
    char Name[MAX_PROFILE_STR]; /* profile Name */
    char token[MAX_TOKEN_STRLEN]; /* profile token */
    int  vsIdx; /* video source token index, started from 0 */
    int  veIdx; /* video encoder token index, started from 0 */
} Acti_MediaProfile;

enum SubscriptMethod{
	EVENT_SUBSCRIPT = 0,
	EVENT_CREATE_PULLPOINT
};

enum EventTopic{
	EVENT_TOPIC_ALL = 0,
	EVENT_TOPIC_MD,
	EVENT_TOPIC_DI
};

enum MsgContent{
	EVENT_MSG_NONE = -1,
	EVENT_MSG_ALL = 0,
	EVENT_MSG_WINDOW_ALL,
	EVENT_MSG_WINDOW_1,
	EVENT_MSG_WINDOW_2,
	EVENT_MSG_WINDOW_3,
	EVENT_MSG_DI_ALL,
	EVENT_MSG_DI_1,
	EVENT_MSG_DI_2,
	EVENT_MSG_DI_3,
	EVENT_MSG_DI_4,
	EVENT_MSG_DI_5,
	EVENT_MSG_DI_6,
	EVENT_MSG_DI_7,
	EVENT_MSG_DI_8
};

typedef struct {
	int enable;
	int SubscriptionId;
	int state;
	enum SubscriptMethod Method; //Subscript or CreatePullPoint
	int EQIndex;
	enum EventTopic Topic;
	enum MsgContent Msg;
	time_t BeginTime;
	time_t TerminationTime;
	struct timeval LastGetEventTime;
	char NotifyServer[256];
	enum MsgContent NotifyMsg;
} Acti_EventSubscription;


typedef struct {
	int state;
	int trigger;
	enum MsgContent NotifyEvent;
	struct timeval TimeStamp;
//	time_t TimeStamp;
} EventMsg;
	

typedef struct {
    sem_t    sem;
    int 	 InsertIndex;
    EventMsg EMsg[MAX_EVENT_NUM];
} EventMsgContent;

#define ONVIF_RELAY_OUTPUT_DELAY
struct tt__ActiRelayOutputSettings
{
    int state; /* record the delay time thread state */
    char DelayTime[16];	/* required element of type xsd:duration */
    enum tt__RelayIdleState IdleState;	/* required element of type tt:RelayIdleState */
    enum tt__RelayMode Mode;	/* required element of type tt:RelayMode */
//  enum tt__RelayLogicalState LogicalState;	/* required element of type tt:RelayLogicalState */
};
#define CONF_FILE_ONVIF	"/etc/config/onvif.conf"

#define ONVIF_DEVICE_TYPE	"dn:NetworkVideoTransmitter"
#define Scope_Scheme_Authority "onvif://www.onvif.org/"
#define Scope_Category_type_ve	Scope_Scheme_Authority"type/video_encoder"
#define Scope_Category_type_ae	Scope_Scheme_Authority"type/audio_encoder"
#define Scope_Category_loca	Scope_Scheme_Authority"location/"
#define Scope_Category_hw	Scope_Scheme_Authority"hardware/"
#define Scope_Category_name Scope_Scheme_Authority"name/"

#define ONVIF_PLATFROM_UNKNOWN      0
#define ONVIF_PLATFROM_T            1
#define ONVIF_PLATFROM_K            2
#define ONVIF_PLATFROM_A1           3

#define ONVIF_MODELNAME_LEN			64
#define ONVIF_SERACHDOMAIN_LEN      64
typedef struct {
    int state; /* Server State Configurations */
    int tv; /* VIDEO_TV, TVStandard_NTSC or TVStandard_PAL */
    /* About root-account & password in the device config */
    char root[ONVIF_ACCOUNT_NAME_LEN];
    char passwd[ONVIF_ACCOUNT_PWD_LEN];
    char CurrentIP[16];
    char macar[16];
    char fwVer[32];
    char ModelName[ONVIF_MODELNAME_LEN];
    int  platform;
    int  brandACTi; /* 0: NB, 1: AC*/
    char companyName[MAX_CONF_NAME_LEN];
    char serialNum[MAX_CONF_NAME_LEN];
    int numStreams; /* 1: single video streaming mdoe, 2: dual streaming mode */
    /* DIO */
    int DIs; // DI number
    int DOs; // DO number
    SourceDescription DICurrentState[MAX_DI_NUM]; //[DI1][DI2]...
    struct tt__ActiRelayOutputSettings DOSetting[MAX_DO_NUM];
    /* Motion Detection */
    SourceDescription MDCurrentState[ONVIF_MOTION_WINDOWS]; 
    /* Resolution Capability of Video Source 1 */
    int ResCapNum;
    struct tt__VideoResolution ResCap[16]; //VideoEncoderConfigurationOptions
    int maxResWidth;
    int maxResHeight;
    int minResWidth;
    int minResHeight;
    /* Resolution Capability of Video Source 2 */
    int ResCapNum2;
    struct tt__VideoResolution ResCap2[16]; //VideoEncoderConfigurationOptions
    int maxResWidth2;
    int maxResHeight2;
    int minResWidth2;
    int minResHeight2;
    /* Discovery WSDL: GetDiscoveryMode, other sub-items */
    int DiscoveryMode;
    char EndpointAddr[MAX_UUID_LEN];
    int MetaDataVerion; /* Must be saved to flash memory */
    Acti_Scopes Scopes;
    /* SOAP-ENV: Header's elements */
    struct d__AppSequenceType AppSequence;
    /* DeviceManagement WSDL*/
    /* Get WSDLURL */
    char WsdlUrl[64];
    /* Get Capabilities */
    char MediaXAddr[64];
    /* StreamURI */
    char StreamUri[128];
    /* SnapShotURI */
    char SnapshotUri[128];
    char TZString[64];
    int  DnsFromDHCP; /* 1: DNS configurations is from DHCP, 0: otherwise */
    char DnsConfPri[16]; /* runtime primary dns configuration */
    char DnsConfSec[16]; /* runtime Secondary dns configuration */
    char Domain[ONVIF_SERACHDOMAIN_LEN];
    int HttpPort;
#ifdef SUPPORT_HTTPS
//  int HttpsPort;
#endif
    /* Media WSDL: configuration */
    enum tt__Mpeg4Profile ProfileType;
    enum tt__H264Profile H264ProfileType;
    /* videosources */
    int SourceTokenCnt;
    Acti_VideoSources SourceToken[MAX_VS_LIST];
    /* VideoSourceConfiguration */
    int VsCnt;
    Acti_VideoSourceConfig vsConf[MAX_VS_LIST];
    /* VideoEncoderConfiguration */
    int VeCnt;
    Acti_VideoEncoderConfig veConf[MAX_VE_LIST];
    /* Audio Sources */
    int sizeAS; 
    Acti_AudioSources AudioSource; 
    /* Audio Source Config */
    int sizeAsConf; 
    Acti_AudioSourceConfig asConf;
    /* Audio Encoder Config */
    int sizeAeConf; 
    Acti_AudioEncoderConfig aeConf;
    /* meta-data configuration */
    Acti_MetaDataConfig meConf;
    /* profile configuration */
    int ProfileCnt;
    Acti_MediaProfile profile[MAX_PROFILE_LIST];
    Acti_EventSubscription scription[MAX_EVENT_SCRIPTION_NUM];
    EventMsgContent EventQueue;
    /* Audio */
    enum xsd__boolean ASToken[MAX_PROFILE_LIST]; //Audio Source
    enum xsd__boolean AEToken[MAX_PROFILE_LIST]; //Audio Encoder
    /* Status of RTSP */
    enum xsd__boolean rtsp_status;
    /* from  DHCP */
    enum xsd__boolean from_dhcp;
    /* PTZ flags */
    enum xsd__boolean PTEnable;
    enum xsd__boolean ZoomEnable;
    enum xsd__boolean PTEnableBy485;
    enum xsd__boolean ZoomEnableBy485;
    enum xsd__boolean PTZ_AddToken[MAX_PROFILE_LIST];
    /* Audio flag */
    enum xsd__boolean AudioEnable;
    /* DIO flags */
    enum xsd__boolean DIEnable;
    enum xsd__boolean DOEnable;
    /* Imaging flags */
    enum xsd__boolean BLCEnable;
    enum xsd__boolean BrightnessEnable;
    enum xsd__boolean SaturationEnable;
    enum xsd__boolean ContrastEnable;
    enum xsd__boolean SharpnessEnable;
    enum xsd__boolean ExposureEnable;
    enum xsd__boolean WDREnable;
    enum xsd__boolean WhiteBalanceEnable;
    /* VideoEncoder format flags */
    enum xsd__boolean MJPEG_Enable;
    enum xsd__boolean MPEG4_Enable;
    enum xsd__boolean H264_Enable;
    /* PTZ Node */
    int sizePTZNode; 
    Acti_PTZNode PTZNode; 
    int sizePTZConfig; 
    Acti_PTZConfig PTZConfig; 
} tOnvifConf;

typedef struct {
	int tsec;
	char *POSIX_TZString;
} tTZ;

typedef struct {
	char *TZ;
	int tsec;
	char *POSIX_TZString;
} sTZ;
#define ONVIF_MAX_FPS_OPTIONS   15
typedef struct {
    char streamID;
    char maxFps;
    char fpsList[ONVIF_MAX_FPS_OPTIONS];
} tOnvifChannelFpsCap;
#define ONVIF_MAX_STREAMS       6 /* KCM 6VGA */
typedef struct {
    int numStreams;
    tOnvifChannelFpsCap fpsCap[ONVIF_MAX_STREAMS];
} tOnvifFpsCap;

#define MAX_HISTORY (10)

#define RESOLUTION_SXGA			0x01
#define RESOLUTION_N1280x960	0x02
#define RESOLUTION_HDTV			0x04
#define RESOLUTION_D1P			0x08
#define RESOLUTION_D1N			0x10
#define RESOLUTION_VGA			0x20
#define RESOLUTION_CIF			0x40
#define RESOLUTION_SIF			0x80
#define RESOLUTION_QVGA			0x100
#define RESOLUTION_QCIF			0x200
#define RESOLUTION_QSIF			0x400

/* ######################################################################################
 * Share Functions in OnvifAPIs.c
 * ###################################################################################### */
extern int soap_handler(int, void *);
extern void DiscoveryMulticast_Hello(void);
extern void DiscoveryMulticast_Bye(void);
extern int OnvifDiscoveryThreadCreate(char *Name, char *Pwd, int httpPort);
extern int OnvifDiscoveryThreadClose(void);
extern int DecideVideoSourceVideoEncoder(void);
extern int OnvifConfBin2File(char *);
extern int OnvifConfigChange();
extern int OnvifRootAccountChange(char *Name, char *Pwd);
extern int OnvifSemLock(void);
extern int OnvifSemUnlock(void);
extern int OnvifChangeVideoStreamNum(int StreamNum);
extern int OnvifMotionStateChange(int Index, int State);
extern int OnvifDIStateChange(int Index, int State, int Trigger);

/* ######################################################################################
 * Share Functions in OnvifIF.c
 * ###################################################################################### */
extern int ThreadOnvifCreate (char *Name, char *Pwd, int HttpPort);
extern int ThreadOnvifClose (void);
extern int OnvifMsgSend (int cmd);

#endif
