/* ######################################################################################
 * OnvifIF.c
 *    Created by Anne Chen. date: 2012/02/21
 * Description:
 *    create a thread to handle the Onvif thread.
 * ###################################################################################### */
//#include "server.h"
#include "onvif.h"

OnvifDB tOnvifDB = {ONVIF_STATE_INIT, 0, "", "", 80};

static int OnvifMsgReceive (OnvifDB *db, tOnvifMsgBuf *msg, int *len)
{
	*len = msgrcv (db->msgid, msg, sizeof (tOnvifMsgBuf), 0, IPC_NOWAIT);
	if (*len == -1) {
		if (errno == ENOMSG) {
			return ERR;
		}
//		if (log_ratelimit ())
//			L1 ("Error. id %d msgrcv %d errno %d %s\n", db->msgid, *len, errno, strerror (errno));
		/* If the message is too big, then just receive(truncated) and remove
		 * the message from message queue
		 */
		if (errno == E2BIG)
			msgrcv (db->msgid, msg, sizeof (tOnvifMsgBuf), 0, IPC_NOWAIT | MSG_NOERROR);
		return ERR;
	}
	return OK;
}

int OnvifMsgSend (int cmd)
{
	tOnvifMsgBuf msg;
	int id;

	id = msgget (KEY_ONVIF_QUEUE, 0);
	if (id == -1) {
		L1 ("Error. msgget errno %d %s\n", errno, strerror (errno));
		return ERR;
	}

	/* Accquire a receipt for tracking leaving state */
	msg.mtype = cmd;
	//msg.mtext.state = NULL;
	/* Sending message */
	if (msgsnd (id, &msg, sizeof (tOnvifMsgBuf), IPC_NOWAIT) == -1) {
		L1 ("Error. msgsnd errno %d %s\n", errno, strerror (errno));
		return ERR;
	}
	return OK;
}

static void OnvifCmdHandler (OnvifDB *db)
{
	tOnvifMsgBuf msg;
	int len;
	int ret=0;

	/* Loop getting message from message queue */
	while (OnvifMsgReceive (db, &msg, &len) == OK) {
		/* handle the command */
		switch (msg.mtype) {
		case ONVIF_MAIN_THREAD_START:
			L4("ONVIF_MAIN_THREAD_START\n");
			ret = OnvifDiscoveryThreadCreate(db->Name, db->Pwd, db->HttpPort);
			if(ret == ERR) 
				L1("ONVIF_MAIN_THREAD_START Fail\n");
			break;
		case ONVIF_MAIN_THREAD_CLOSE:
			L4("ONVIF_MAIN_THREAD_CLOSE\n");
			OnvifDiscoveryThreadClose();
			break;
		case ONVIF_MAIN_THREAD_RESTART:
			L4("ONVIF_MAIN_THREAD_RESTART\n");
			OnvifDiscoveryThreadClose();
			ret = OnvifDiscoveryThreadCreate(db->Name, db->Pwd, db->HttpPort);
			if(ret == ERR) 
				L1("ONVIF_MAIN_THREAD_RESTART Fail\n");
			break;
		default:
			L1 ("Unknown event message type %d len %d\n", msg.mtype, len);
			break;
		}
	}
	return;
}

static void *ThreadOnvifCtrl (void *arg)
{
	OnvifDB *db = (OnvifDB *)arg;

    pthread_detach(pthread_self());
    
	L2 ("Start\n");	
#ifdef HAVE_PRCTL
	prctl(PR_SET_NAME, "ThreadOnvif", 0, 0, 0);
#endif
	db->state = ONVIF_STATE_RUN;
	OnvifMsgSend(ONVIF_MAIN_THREAD_START);
	L2 ("PID %d ThreadOnvif runnung\n", getpid ());
	/* Check if the database is healthy */
	while (db->state == ONVIF_STATE_RUN) {
		/* Handling the ONVIF command */
		OnvifCmdHandler (db);
		usleep(100000);
//#ifdef HAVE_ONVIF_DEBUG
//		fprintf (stderr, "<GSOAP/ONVIF> %s: ONVIF is still running ...<\n", __func__); fflush (stderr);
//#endif
	}
	/* Close all recording record */
	/* Notify caller we've left */
	db->state = ONVIF_STATE_CLOSE;
	L2 ("Leave\n");	
	pthread_exit (NULL);
}

static int OnvifCmdInit (OnvifDB * db)
{
	tOnvifMsgBuf msg;
	int len;

	/* Creating message queue */
	db->msgid = msgget (KEY_ONVIF_QUEUE, 0666 | IPC_CREAT);
	L4 ("msgid %d\n", db->msgid);
	if (db->msgid == -1) {
		L1 ("Error. msgget create ONVIF message queue. %d %s", errno, strerror (errno));
		return ERR;
	}
	/* Clean up ONVIF message queue before running */
	while (OnvifMsgReceive (db, &msg, &len) == OK)
		;
	return OK;
}

int ThreadOnvifCreate (char *Name, char *Pwd, int HttpPort)
{
	pthread_t task_t = 0;

	OnvifDB *db = &tOnvifDB;
#ifdef HAVE_ONVIF_DEBUG
	fprintf (stderr, "<GSOAP/ONVIF> %s: OnvifDB.state=%d<\n", __func__, db->state); fflush (stderr); 
#endif
	if(tOnvifDB.state == ONVIF_STATE_RUN) return ERR;

	if (OnvifCmdInit (db) == ERR) {
		L1 ("Error. OnvifCmdInit");
		return ERR;
	}
	strncpy(db->Name, Name, ONVIF_ACCOUNT_NAME_LEN - 1);
	db->Name[ONVIF_ACCOUNT_NAME_LEN-1] = '\0';
	strncpy(db->Pwd, Pwd, ONVIF_ACCOUNT_PWD_LEN - 1);
	db->Pwd[ONVIF_ACCOUNT_PWD_LEN-1] = '\0';
	db->HttpPort = HttpPort;
	/* Create the Onvif IF thread */
	if (pthread_create (&task_t, NULL, ThreadOnvifCtrl, db)) {
		L1 ("Error. create Onvif IF thread\n");
		return ERR;
	}
	/* success in creating the Onvif moniter thread!! distory the thread attr */
	return OK;
}

int ThreadOnvifClose (void)
{
	int i;

	if(tOnvifDB.state == ONVIF_STATE_RUN)
	{
		DiscoveryMulticast_Bye();
		OnvifMsgSend(ONVIF_MAIN_THREAD_CLOSE);
		usleep(100000);
		tOnvifDB.state=ONVIF_STATE_STOP;

		for (i = 0; i < 100; i++) {
			usleep(100000);
			if(tOnvifDB.state == ONVIF_STATE_CLOSE)
				break;
		}
		if (i == 100) {
			L1 ("Error, the Onvif Ctrl Thread is failed to leave\n");
			return ERR;
		}
		return OK;
	} else {
		L1 ("Error. tOnvifDB.state %d is not ONVIF_STATE_RUN.\n", tOnvifDB.state);
		return ERR;
	}
}
