/* OnvifAPIs.c
   Generated by gSOAP 2.7.16 from onvif.h
   Copyright(C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
/*
   Stand-alone server auto-test code:
   Takes request from standard input and returns response to standard output

   Compile:
   cc soapTester.c soapServer.c soapC.c stdsoap2.c 

Command line usage: 
$ a.out < SomeTest.req.xml 
$ a.out 12288 < SomeTest.req.xml
 note: 12288 = SOAP_XML_INDENT | SOAP_XML_STRICT
 */

#include "onvif.h" 

#include "DeviceBinding.nsmap"
#include "d.nsmap" 
#include "probe.nsmap" 
#include "Notification.nsmap" 

#define MYYOU_ONVIF_DEBUG                   0

#define MYYOU_IMAGING_FOCUS_SUPPORTED       0
#define MYYOU_IMAGING_IRCUT_SUPPORTED       0
#define MYYOU_IMAGING_WDR_SUPPORTED         0

/* extern RTP multicast IP address of audio */
extern char gRtspAudioMcastIP[16]; 
/* ######################################################################################
 * External APIs in OnvifUrl.c
 * ###################################################################################### */
extern int  OnvifGetValueFmUrlReply(char *, char *, char *, int);
extern int  OnvifGetDIsFmUrl(int *);
extern void OnvifUrlCmdInit(tUrlDB *, char *);
extern int  OnvifSendUrlCmd(tOnvifUrl *, tOnvifConf *);
extern int  OnvifSingleUrlCmdSend(char *, char *, char *, int);
extern int  OnvifPTVelocityFmUrl(float);
extern int  OnvifZoomVelocityFmUrl(float);

/* ######################################################################################
 * Macro Definition
 * ###################################################################################### */
 typedef struct {
    int timer; /* timeout timer in seconds */
    int needStopPTCmd;
    int needStopZoomCmd;
    char moveCmd[64];
    char zoomCmd[64];
 } tContinueMoveCmd;
/* ######################################################################################
 * My Global Variables
 * ######################################################################################
*/
sem_t      gOnvifSem;
int        gOnvifSemInit = 0;
int        gOnvifRequests = 0;
tOnvifConf gOnvifConf;
Acti_PTZLimits gPTZLimits; 
Acti_VideoSourceConfig tmpVsConf [MAX_VS_LIST]; 
Acti_AudioSourceConfig tmpAsConf; 	//Only One 
Acti_AudioEncoderConfig tmpAeConf; 	//Only One 
Acti_PTZConfig tmpPTZConf; //Currently, we have Only one PTZ Configuration.  
char ptzErrDesc[128];
int VSConfigState[MAX_VS_LIST]; 
int ASConfigState; 	// Only One 
int AEConfigState; 	// Only One 
int PTZConfigState;  	// Only One
int gMovePanDirection = 0; /* 0: not update, 1: position direction, -1: negative direction */
int ImgConfigState[MAX_VS_LIST]; 
int config_change = false_; 
char *received_id[MAX_HISTORY]; 
int last_received; 
static float NotAvailable = 0.0; 
int gMcastPort = 0; 
int gMcastTTL = 0; 
static char gMcastIPv4Addr[16]; 
static char gDnsPrimary[16]; 
static char gDnsSecondary[16]; 
static float Brightness = 0; //encoder?VIDEO_BRIGHTNESS (0~100) 
static float ColorSaturation = 0; //encoder?VIDEO_SATURATION (0~100) 
static float Contrast = 0; //encoder?VIDEO_CONTRAST (0~100) 
static float MinGain = MIN_PHY_EXPOSURE_GAIN; 
static float MaxGain = MAX_PHY_EXPOSURE_GAIN; 
static float Gain = 0; //1; //encoder?VIDEO_EXPOSURE_GAIN (1~255) 
static float Sharpness = 0; //1; //encoder?VIDEO_SHARPNESS (1~255) 
static float WideDynamicLevel = 0.0; 
static enum tt__BacklightCompensationMode BLCMode = OFF_; //OFF_ = 0, ON_ = 1 
static enum tt__ExposureMode ExposureMode = AUTO_ ; //AUTO_ = 0, MANUAL_ = 1 
static enum tt__ExposurePriority ExposurePriority = LowNoise; //LowNoise = 0, FrameRate = 1 
static enum tt__AutoFocusMode AutoFocusMode = _AUTO_; //_AUTO_ = 0, _MANUAL_ = 1 
static enum tt__IrCutFilterMode IrCutFilterMode = AUTO___; //{ON__ = 0, OFF__ = 1, AUTO___ = 2}; 
static enum tt__WideDynamicMode WideDynamicMode = OFF; //{OFF = 0, ON = 1}; 
static enum tt__WideDynamicMode WideDynamicMode_ON = ON; //{OFF = 0, ON = 1}; 
static enum tt__WideDynamicMode WideDynamicMode_OFF = OFF; //{OFF = 0, ON = 1}; 
static enum tt__WhiteBalanceMode WhiteBalanceMode = AUTO__; //{AUTO__ = 0, MANUAL__ = 1}; 

extern const char* soap_wsse_get_Username(struct soap *soap); 
extern void isoap_wsse_delete_Security(struct soap *soap); 
extern void soap_wsse_delete_Security(struct soap *soap); 
extern int soap_wsse_fault(struct soap *soap, wsse__FaultcodeEnum fault, const char *detail); 
extern int soap_wsse_verify_Timestamp(struct soap *soap); 
extern int soap_wsse_verify_Password(struct soap *soap, const char *password); 
extern int TcpSockCreate(int *sock); 
extern int SockOptReuseAddrSet(int sock, int opt); 
extern int Base64AccountEncode (char *name, char *pwd, char *result); 
extern int TcpSockNonBlockRead(int sock, unsigned char *buf, int len, int timer); 
extern int TcpSockNonBlockRead_V2(int sock, unsigned char *buf, int len, int timer, int flag); 
extern int SockNonblockingConnect(int sock, struct sockaddr_in *addr, int msec); 
extern int IPv4AddrResolution(struct sockaddr_in *addr, char *ip, int port); 
extern int SockClose(int *sock); 

static int OnvifCmdSend (tUrlDB *url, char *ReplyMsg, int MaxLen); 
static int OnvifReplyMsgParser(char *cmd, char *ReplyMsg, char *pValue);
static int IsEventQHaveNewEvent(int ScripIndex, int MessageLimit, int *MessageCnt, EventMsg *OutputEMsg);
#if MYYOU_ONVIF_DEBUG
static void OnvifDumpConf(void);
#endif
/* ######################################################################################
 * My Static Variables
 * ###################################################################################### */ 
#define MAX_MEDIA_NUM		2 //wait for check 
#define BITRATE_LENGTH		19 
#define BASIC_PROFILE_NUM 	6 

/* Normalized PTZ Range */
float ptzNormalRange[][2] =  //[][0],[][1] : Min,Max
{ 
	//Pan
	{ 0.0, 1.0},  //PanTiltSpeedSpace: PanTiltSpaces/GenericSpeedSpace 
	{-1.0, 1.0}, //PanTiltPositionSpace: PanTiltSpaces/PositionGenericSpace 
	{-1.0, 1.0}, //ContinuousPanTiltVelocitySpace: PanTiltSpaces/VelocityGenericSpace
	 //Tilt 
	{ 0.0, 1.0},  //PanTiltSpeedSpace: PanTiltSpaces/GenericSpeedSpace 
	{-1.0, 1.0}, //PanTiltPositionSpace: PanTiltSpaces/PositionGenericSpace 
	{-1.0, 1.0}, //ContinuousPanTiltVelocitySpace: PanTiltSpaces/VelocityGenericSpace 
	//Zoom 
	{ 0.0, 1.0},  //ZoomSpeedSpace: ZoomSpaces/ZoomGenericSpeedSpace 
	{ 0.0, 1.0},  //ZoomPositionSpace: ZoomSpaces/PositionGenericSpace 
	{-1.0, 1.0}  //ContinuousZoomVelocitySpace: ZoomSpaces/VelocityGenericSpace 
}; 
static char authrealm[] = "gSOAP Authentication"; 
static enum xsd__boolean blTrue = true_; 
static enum xsd__boolean blFalse = false_; 

static sTZ aTZ[] = {
	{"-12",    -43200, "<GMT+12>12"},	/*-12:00*/ 
	{"-11",    -39600, "SST11"},		/*-11:00*/ 
	{"-10",    -36000, "HAST10HADT"},	/*-10:00*/ 
	{"-09:30", -34200, "MART9:30"},  	/*-09:30*/ 
	{"-09",    -32400, "AKST9AKDT"},	/*-09:00*/ 
	{"-08",    -28800, "PST8PDT"},  	/*-08:00*/ 
	{"-07",    -25200, "MST7MDT"},  	/*-07:00*/ 
	{"-06",    -21600, "CST6CDT"},  	/*-06:00*/ 
	{"-05",    -18000, "EST5EDT"},  	/*-05:00*/ 
	{"-04:30", -16200, "VET4:30"},  	/*-04:30*/ 
	{"-04",    -14400, "PYT4PYST"},  	/*-04:00*/ 
	{"-03:30", -12600, "NST3:30NDT"},	/*-03:30*/ 
	{"-03",    -10800, "BRT3BRST"},  	/*-03:00*/ 
	{"-02",     -7200, "FNT2"},  		/*-02:00*/
	{"-01",     -3600, "AZOT1AZOST"},	/*-01:00*/ 
	{"+00",         0, "GMT0BST"},		/*+00:00 */ 
	{"+01",      3600, "CET-1CEST"},	/*+01:00 */ 
	{"+02",      7200, "EET-2EEST"},	/*+02:00 */ 
	{"+03",     10800, "MSK-3MSD"},		/*+03:00 */ 
	{"+03:30",  12600, "IRST-3:30IRDT"},	/*+03:30 */ 
	{"+04",     14400, "AZT-4AZST"},	/*+04:00 */ 
	{"+04:30",  16200, "AFT-4:30"},		/*+04:30 */ 
	{"+05",     18000, "PKT-5"},		/*+05:00 */ 
	{"+05:30",  19800, "IST-5:30"},		/*+05:30 */ 
	{"+05:45",  20700, "NPT-5:45"},		/*+05:45 */ 
	{"+06",     21600, "OMST-6OMSST"},	/*+06:00 */ 
	{"+06:30",  23400, "CCT-6:30"},		/*+06:30 */ 
	{"+07",     25200, "WIT-7"},		/*+07:00 */ 
	{"+08",     28800, "CST-8"},		/*+08:00 */ 
	{"+09",     32400, "JST-9"},		/*+09:00 */ 
	{"+09:30",  34200, "CST-9:30CST"},	/*+09:30 */ 
	{"+10",     36000, "EST-10EST"},	/*+10:00 */ 
	{"+11",     39600, "SBT-11"},		/*+11:00 */ 
	{"+11:30",  41400, "NFT-11:30"},	/*+11:30 */ 
	{"+12",     43200, "NZST-12NZDT"},	/*+12:00 */ 
	{"+12:45",  45900, "CHAST-12:45CHADT"},	/*+12:45 */ 
	{"+13",     46800, "TOT-13"}		/*+13:00 */
}; 

static char *TopicNamespaceLocation[] = {"http://www.onvif.org/onvif/ver10/topics/topicns.xml", ""}; 
static char *wsnt__TopicExpressionDialect[] = {"http://www.onvif.org/ver10/tev/topicExpression/ConcreteSet",
                                               "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete"}; 
static char *MessageContentFilterDialect[] = {"http://www.onvif.org/ver10/tev/messageContentFilter/ItemFilter", ""}; 
static char *MessageContentSchemaLocation[] = {"http://www.onvif.org/ver10/schema/onvif.xsd", ""}; 
static char OnvifPTPositionGenericSpace[] = "http://www.onvif.org/ver10/tptz/PanTiltSpaces/PositionGenericSpace";
static char OnvifZoomPositionGenericSpace[] = "http://www.onvif.org/ver10/tptz/ZoomSpaces/PositionGenericSpace";
//static char OnvifDeviceVirtualPort[] = "tns1:Device/tnsacti:IO/VirtualPort";
static char OnvifDeviceVirtualPort[] = "tns1:Device/IO/VirtualPort";
//static char OnvifDeviceMotion[] = "tns1:VideoAnalytics/tnsacti:MotionDetection";
static char OnvifDeviceMotion[] = "tns1:VideoAnalytics/MotionDetection";
static char Motion_source_Name[] = "window"; 
static char Motion_source_Type[] = "xsd:int"; 
static char Motion_data_Name[] = "state"; 
static char Motion_data_Type[] = "xsd:int"; 
static char VirtualPor_source_Name[] = "DI"; 
static char VirtualPor_source_Type[] = "xsd:int"; 
static char VirtualPor_data_Name[] = "state"; 
static char VirtualPor_data_Type[] = "xsd:int"; 
static char *Data_Value[] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", ""}; 
static char AuxiliaryAlarmOutputOn[MAX_AUX_LEN+1] = "AuxiliaryAlarmOutputOn"; 	
static char AuxiliaryAlarmOutputOff[MAX_AUX_LEN+1] = "AuxiliaryAlarmOutputOff"; 
static char *Auxiliary_Operations[] = {AuxiliaryAlarmOutputOn, AuxiliaryAlarmOutputOff}; 
char *AccessNotRequiredAuthList[] = 
{ /* PRE_AUTH */ 
	"GetWsdlUrl", 
	"GetServices", 
	"GetServiceCapabilities", 
	"GetCapabilities", 
	"GetHostname", 
	"GetSystemDateAndTime", 
	"GetEndpointReference",
	"GetServiceCapabilities",
	"GetEventProperties"
}; 
struct tPtzPos {
	int PositionP;
	int PositionT;
	int PositionZ;
};
struct tOnvifSocket {
	int sock;
	int transfer;
};
/* ######################################################################################
 * Static Functions
 * ###################################################################################### */ 
static void GenerateUUiD (char *uuid) 
{ 
	FILE *in = fopen ("/proc/sys/kernel/random/uuid", "r"); 
	int out[16]; 

	if (in) { 
		if (4 == fscanf (in, "%x-%x-%x-%x-", &out[0], &out[1], &out[2], &out[3])) 
			sprintf (uuid, "uuid:%08x-%04x-%04x-%04x-%s", 
					out[0], out[1], out[2], out[3], gOnvifConf.macar); 
		fclose (in); 
	} 
} 

static void GenerateUrnUUiD (char *uuid) 
{ 
	FILE *in = fopen ("/proc/sys/kernel/random/boot_id", "r"); 
	int out[16]; 
	if (in) { 
		if (4 == fscanf (in, "%x-%x-%x-%x-", &out[0], &out[1], &out[2], &out[3])) 
{ 
out[0] = 0x74d1ad; 
out[1] = 0x0e01; 
out[2] = 0x431c; 
out[3] = 0x92b2; 
			sprintf (uuid, "urn:uuid:%08x-%04x-%04x-%04x-%s", 
					out[0], out[1], out[2], out[3], gOnvifConf.macar); 
} 
		fclose (in); 
	} 
} 
static void GenerateTZString (struct tt__SystemDateTime *time, tOnvifDLS * dls) 
{ 
	char DLSstring[32]; 

	if (dls->state && (dls->start.type == ONVIF_DLS_TIME_TYPE1) && (dls->end.type == ONVIF_DLS_TIME_TYPE1)) {//CST6CDT,M3.2.0,M11.1.0 
		time->DaylightSavings = true_; 
		sprintf (DLSstring, ",M%d.%d.%d,M%d.%d.%d", 
				dls->start.set.type1.mon, dls->start.set.type1.week, 
				(dls->start.set.type1.wday == 7 ? 0 : dls->start.set.type1.wday), 
				dls->end.set.type1.mon, dls->end.set.type1.week, 
				(dls->end.set.type1.wday == 7 ? 0 : dls->end.set.type1.wday)); 
		strcat(time->TimeZone->TZ, DLSstring); 
	} else { 
		time->DaylightSavings = false_; 
	} 
} 

/* DlsConfBin2Txt: 
 *    Transfer the Daylight Saving settings to the daylight saving text string
 * inputs: *    str: return of the daylight saving configuration string
 *    dls: daylight saving settings
 * return:
 *    None. */ 
void DlsConfBin2Txt(char *str, tOnvifDLS *dls) { 
	char sTime[6]; 
	char eTime[6]; 
	if(dls->start.type == ONVIF_DLS_TIME_TYPE1) { 
		sprintf(sTime, "%d:%d", \
			dls->start.set.type1.hour, dls->start.set.type1.min); 
		if(dls->end.type == ONVIF_DLS_TIME_TYPE1) { 
			sprintf(eTime, "%d:%d", \
				dls->end.set.type1.hour, dls->end.set.type1.min); 
			sprintf(str, "%d,1,%d,%d,%s,%d,1,%d,%d,%s,%d", \
					dls->state, \
					dls->start.set.type1.mon,  dls->start.set.type1.week, \
					sTime, dls->start.set.type1.wday, \
					dls->end.set.type1.mon,  dls->end.set.type1.week, \
					eTime, dls->end.set.type1.wday); 
		} else { 
			sprintf(eTime, "%d:%d", \
				dls->end.set.type2.hour, dls->end.set.type2.min); 
			sprintf(str, "%d,1,%d,%d,%02d:%02d,%d,2,%d,%d,%s", \
					dls->state, \
					dls->start.set.type1.mon,  dls->start.set.type1.week, \
					dls->start.set.type1.hour, dls->start.set.type1.min, \
					dls->start.set.type1.wday, \
					dls->end.set.type2.mon,  dls->end.set.type2.mday, eTime);
		 } 
	} else { 
		sprintf(sTime, "%d:%d", \
				dls->start.set.type2.hour, dls->start.set.type2.min); 
		if(dls->end.type == ONVIF_DLS_TIME_TYPE1) { 
			sprintf(eTime, "%d:%d", \
				dls->end.set.type1.hour, dls->end.set.type1.min); 
			sprintf(str, "%d,2,%d,%d,%s,1,%d,%d,%s,%d", \
					dls->state, \
					dls->start.set.type2.mon,  dls->start.set.type2.mday, \
					sTime, \
					dls->end.set.type1.mon,  dls->end.set.type1.week, \
					eTime, dls->end.set.type1.wday); 
		} else { 
			sprintf(eTime, "%d:%d", \
					dls->end.set.type2.hour, dls->end.set.type2.min); 
			sprintf(str, "%d,2,%d,%d,%s,2,%d,%d,%s", \
					dls->state, \
					dls->start.set.type2.mon,  dls->start.set.type2.mday, sTime, \
					dls->end.set.type2.mon,  dls->end.set.type2.mday, eTime); 
		} 
	} 
	return; 
} 
static int TZStringParser (char *tzstr, char *dlsStr)
{ 
	int sMon, sWeek, eMon, eWeek; 
	int sday, eday; 
	int shh, smm, ehh, emm; 
	char sTmp[16], eTmp[16]; 
	char *p = NULL; 
	tOnvifDLS dls; 

	dls.state = 1; 
	if (sscanf (tzstr, "M%d.%d.%[^,],M%d.%d.%s", &sMon, &sWeek, sTmp, &eMon, &eWeek, eTmp) != 6) 
		return ERR; 
	if ((p = strchr (sTmp, '/'))) { 
		*p = '\0'; 
		if (strchr (p + 1, ':') == NULL) { 
			shh = atoi (p + 1); 
			smm = 0; 
		} else { 
			sscanf (p + 1, "%d:%d", &shh, &smm); 
		} 

		sday = atoi (sTmp); 
		dls.start.type = ONVIF_DLS_TIME_TYPE1; 
		if (sMon > 12 || sMon < 1 || sWeek > 5 || sWeek < 1 || 
			sday < 0 || sday > 6 || shh < 0 || shh > 23 || smm < 0 || smm > 59) 
			return ERR; 
		dls.start.set.type1.mon = sMon; 
		dls.start.set.type1.week = sWeek; 
		dls.start.set.type1.wday = (!sday ? 7 : sday); 
		dls.start.set.type1.hour = shh; 
		dls.start.set.type1.min = smm;
	 } 
	else 
	{ 
		sday = atoi (sTmp); 
		dls.start.type = ONVIF_DLS_TIME_TYPE1; 
		if (sMon > 12 || sMon < 1 || sWeek > 5 || sWeek < 1 || sday < 0 || sday > 6 ) 
			return ERR; 
		dls.start.set.type1.mon = sMon; 
		dls.start.set.type1.week = sWeek; 
		dls.start.set.type1.wday = (!sday ? 7 : sday); 
		dls.start.set.type1.hour = 0; 
		dls.start.set.type1.min = 0; 
	} 
	if ((p = strchr (eTmp, '/'))) { 
		*p = '\0'; 
		if (strchr (p + 1, ':') == NULL) { 
			ehh = atoi (p + 1); 
			emm = 0; 
		} else { 
			sscanf (p + 1, "%d:%d", &ehh, &emm); 
		} 
		eday = atoi (eTmp); 
		dls.end.type = ONVIF_DLS_TIME_TYPE1; 
		if (eMon > 12 || eMon < 1 || eWeek > 5 || eWeek < 1 || 
			eday < 0 || eday > 6 || ehh < 0 || ehh > 23 || emm < 0 || emm > 59) 
			return ERR; 
		dls.end.set.type1.mon = eMon; 
		dls.end.set.type1.week = eWeek; 
		dls.end.set.type1.wday = (!eday ? 7 : eday); 
		dls.end.set.type1.hour = ehh; 
		dls.end.set.type1.min = emm;
	 } 
	else
	{ 
		eday = atoi (eTmp); 
		dls.end.type = ONVIF_DLS_TIME_TYPE1; 
		if (eMon > 12 || eMon < 1 || eWeek > 5 || eWeek < 1 || eday < 0 || eday > 6) 
			return ERR; 
		dls.end.set.type1.mon = eMon; 
		dls.end.set.type1.week = eWeek; 
		dls.end.set.type1.wday = (!eday ? 7 : eday); 
		dls.end.set.type1.hour = 0; 
		dls.end.set.type1.min = 0; 
	} 

	DlsConfBin2Txt (dlsStr, &dls); 
	return OK;
} 
static int DlsTimeValueCheck(tOnvifDLSTime *dls) { 
	int MaxMday = 31; 

	switch(dls->type) { 
		case ONVIF_DLS_TIME_TYPE1: 
			if( 	(dls->set.type1.mon >= 1) && \
				(dls->set.type1.mon <= 12) && \
				(dls->set.type1.week >= ONVIF_DLS_WEEK_FIRST) && \
				(dls->set.type1.week <= ONVIF_DLS_WEEK_LAST) && \
				(dls->set.type1.hour >= 0) && \
				(dls->set.type1.hour <= 23) && \
				(dls->set.type1.min >= 0) && \
				(dls->set.type1.min <= 59) && \
				(dls->set.type1.wday >= 1) && \
				(dls->set.type1.wday <= 7) ) return OK; 
			return ERR; 
		case ONVIF_DLS_TIME_TYPE2: 
			if(	(dls->set.type2.mon >= 1) && \
				(dls->set.type2.mon <= 12) && \
				(dls->set.type2.hour >= 0) && \
				(dls->set.type2.hour <= 23) && \
				(dls->set.type2.min >= 0) && \
				(dls->set.type2.min <= 59) ) { 
					switch(dls->set.type2.mon) { 
						case 4: 
						case 6: 
						case 9: 
						case 11: 
							MaxMday = 30; 
						case 2: MaxMday = 29; 
					} 
					if( (dls->set.type2.mday >= 1) && \
					    (dls->set.type2.mday <= MaxMday) ) return OK;
			 }	
			return ERR; 
		default: 
			return ERR; 
	} 
} 

static int DlsValueCheck(tOnvifDLS *dls) { 

	if((dls->state == DISABLE) || (dls->state == ENABLE)) { 
		if(DlsTimeValueCheck(&dls->start) == OK) { 
			return DlsTimeValueCheck(&dls->end); 
		} /* else => start time setting is not correct */ 
	} /* daylight saving state is not correct */ 
	return ERR; 
} 
static int DlsTimeTxt2Bin(char *str, int *hh, int *mm) { 

	switch(sscanf(str, "%d:%d", hh, mm)) { 
		case 2: return OK; 
		case 1: 
			*mm = 0; 
			return OK; 
		default: 
			return ERR; 
	} 
} 
int DlsConfTxt2Bin(char *str, tOnvifDLS *dls) { 
	tOnvifDLS nDls; 
	char end[64]; 
	char hour[6]; 
	int  a=0, b=0, c=0; 

	if(sscanf(str, "%d,%d,%d,%d,%5[^','],%d,%63s", \
			&nDls.state, &nDls.start.type, &a, &b, hour, &c, end) == 7) { 
		/* success in parser the start time, get the start time */ 
		if(nDls.start.type == ONVIF_DLS_TIME_TYPE1) { /* start time is type 1 */ 
			nDls.start.set.type1.mon  = a; 
			nDls.start.set.type1.week = b; 
			if(DlsTimeTxt2Bin(hour, \
					&nDls.start.set.type1.hour, \
					&nDls.start.set.type1.min) == ERR) { 
				return ERR; 
			} 
			nDls.start.set.type1.wday = c; 
			switch(sscanf(end, "%d,%d,%d,%5[^','],%d", \
					&nDls.end.type, &a, &b, hour, &c)) { 
				case 5: /* end time should be type 1 */ 
					if(nDls.end.type ==  ONVIF_DLS_TIME_TYPE1) { 
						nDls.end.set.type1.mon  = a; 
						nDls.end.set.type1.week = b; 
						if(DlsTimeTxt2Bin(hour, \
								&nDls.end.set.type1.hour, \
								&nDls.end.set.type1.min) == ERR) { 
							return ERR; 
						}
						nDls.end.set.type1.wday = c; 
					} else return ERR; /* end time is not type 1 */ 
					break; 
				case 4: /* end time should be type 2 */ 
					if(nDls.end.type ==  ONVIF_DLS_TIME_TYPE2) { 
						nDls.end.set.type2.mon  = a; 
						nDls.end.set.type2.mday = b; 
						if(DlsTimeTxt2Bin(hour, \
								&nDls.end.set.type2.hour, \
								&nDls.end.set.type2.min) == ERR) { 
							return ERR; 
						} 
					} else return ERR; /* end time is not type 2 */ 
					break; 
				default: /* fail to parser the end time */ 
					return ERR; 
			} 
		} else if(nDls.start.type == ONVIF_DLS_TIME_TYPE2){ /* start time is type 2 */ 
			nDls.start.set.type2.mon  = a; 
			nDls.start.set.type2.mday = b; 
			if(DlsTimeTxt2Bin(hour, \
				&nDls.start.set.type2.hour, \
				&nDls.start.set.type2.min) == ERR) { 
				return ERR; 
			} 
			nDls.end.type = c; 
			if(nDls.end.type == ONVIF_DLS_TIME_TYPE1) { /* end time is type 1 */ 
				if(sscanf(end, "%d,%d,%5[^','],%d", \
						&nDls.end.set.type1.mon, &nDls.end.set.type1.week, \
						hour, &nDls.end.set.type1.wday) == 4) { 
					if(DlsTimeTxt2Bin(hour, \
								&nDls.end.set.type1.hour, \
								&nDls.end.set.type1.min) == ERR) { 
						return ERR; 
					} 
				} else return ERR; /* fail to parser the enc time */ 
			} else if(nDls.end.type == ONVIF_DLS_TIME_TYPE2) { /* end time is type 2 */ 
				if(sscanf(end, "%d,%d,%5s", \
						&nDls.end.set.type2.mon, \
						&nDls.end.set.type2.mday, hour) == 3) { 
					if(DlsTimeTxt2Bin(hour, \
							&nDls.end.set.type2.hour, \
							&nDls.end.set.type2.min) == ERR) { 
						return ERR; 
					} 
				} else return ERR; /* fail to parser the enc time */ 
			} else return ERR; /* unknown type in end time */ 
		} else return ERR; /* unknown type in start time */ 

	} else return ERR;/* fail to parser the start time */ 
	/* check the daylight saving settings */ 
	if(DlsValueCheck(&nDls) == OK) { 
		memcpy((unsigned char *)dls, (unsigned char *)&nDls, sizeof(tOnvifDLS)); 
		return OK; 
	} 
	return ERR; 
} 
int DateValueCheck(int mm, int dd, int yy) { 
	int MaxMday = 31; 

	if((yy >= 2004) && (yy <= 2035)) { 
		switch(mm) { 
			case 4: 
			case 6: 
			case 9: 
			case 11: 
				MaxMday = 30; 
			case 2: 
				if((dd%400) == 0)        MaxMday = 28; 
				else if((dd % 100) == 0) MaxMday = 28; 
				else if((dd % 4) == 0)   MaxMday = 29; 
				else MaxMday = 28; 
			default: MaxMday = 31;
		} 
		if((dd >= 1) && (dd <= MaxMday)) return OK;
	} 
	return ERR; 
} 

int TimeValueCheck(int hh, int mm, int ss) { 
	if(	((hh >= 0) && (hh <= 23)) && \
		((mm >= 0) && (mm <= 59)) && \
		((ss >= 0) && (ss <= 59)) ) return OK; 
	return ERR; 
} 

static int CheckValidIPv4Address (char *ip)
{ 
	int i; 
	char *endptr = NULL; 
	char *stop = NULL; 
	unsigned long ret; 

	if (*ip == '0') 
		return ERR; 
	if (*ip == '\0') 
		return OK; 
	stop = ip + strlen (ip); 
	endptr = ip; 
	for (i = 0; endptr < stop && i < 4; i++, endptr++) { 
		ret = strtoul (endptr, &endptr, 10); 
		if (endptr == stop || *endptr == '.') { 
			if (ret < 0 || ret >= 255) 
				return ERR; 
		} else 
			return ERR; 
	} 
	if (i == 4) 
		return OK; 
	else 
		return ERR; 
} 
static int CheckValidName (char *name, int len) 
{ 
	int i; 

	for (i = 0; i < strlen (name); i++) { 
		if ((name[i] >= 0x41 && name[i] <= 0x5a) || 
			(name[i] >= 0x61 && name[i] <= 0x7a) || (name[i] >= 0x30 && name[i] <= 0x39) || name[i] == 0x2d) {
			//pass 
		} else { 
			return ERR; 
		} 
	} 
	if (strlen (name) >= len) 
		return ERR; 
	return OK; 
} 
static unsigned int bits2netmask(int bits)
{ 
	unsigned int netmask, bm; 

	if (bits >= 32 || bits < 0) 
		return(~0); 
	for (netmask = 0, bm = 0x80000000; bits; bits--, bm >>= 1) 
		netmask |= bm; 
	return htonl(netmask); 
} 
static void IpPrefix2Str (int bits, char *maskstr, int strLen)
{ 
	struct in_addr addr; 

	if (strLen < 15) { 
		L1 ("Error. strLen %d is not enough (15).", strLen); 
		return; 
	} 
	addr.s_addr = bits2netmask (bits); 
	snprintf (maskstr, strLen, "%s", inet_ntoa (addr)); 
} 
static int Netmask2Prefix (unsigned int netmask)
{ 
	unsigned int bm; 
	int bits; 

	netmask = ntohl(netmask); 
	for (bits = 0, bm = 0x80000000; netmask & bm; netmask <<= 1) 
		bits++; 
	if (netmask) 
		L2 ("Warnings: there are holes\n"); 
	return bits; 
} 

static int MaxFrameRateByRes(int channel, enum tt__VideoEncoding EncoderType, int width, int height,
			     enum tt__VideoEncoding EncoderType2, int width2, int height2,
			     tOnvifFpsCap *retFpsCap) { 
    tUrlDB url;
    char ReplyMsg[512];  
    char Encoder[8];
    char *p = NULL;
    int  len = 0;
    int  k = 0;
    int  i = 0;
    int  fps = 0;

    memset((char *)retFpsCap, 0, sizeof(tOnvifFpsCap));
    
    switch(EncoderType) {
        case JPEG:
            strcpy(Encoder, "MJPEG"); break;
        case MPEG4:
            strcpy(Encoder, "MPEG4"); break;
        case H264:
            strcpy(Encoder, "H264"); break;
        default: /* use camera current encoder type */
            strcpy(url.cgi, "encoder"); 
            url.len = snprintf (url.cmd, URLCMD_LEN, "VIDEO_ENCODER");
            if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) { 
                OnvifReplyMsgParser("VIDEO_ENCODER", ReplyMsg, Encoder); 
            } else {
                strcpy(Encoder, "H264");
            }
    }
    if (channel == 0) {
        url.len = snprintf(url.cmd, URLCMD_LEN, "FPS_CAP_QUERY_ALL=SINGLE,%s,%c%dx%d",
                           Encoder, (gOnvifConf.tv == ONVIF_NTSC)?'N':'P', width,
			   (height==1072)?1080:height);
    } else {
        url.len = snprintf(url.cmd, URLCMD_LEN, "FPS_CAP_QUERY_ALL=DUAL,%s,%c%dx%d,%s,%c%dx%d",
                           Encoder, (gOnvifConf.tv == ONVIF_NTSC)?'N':'P', width,
			   (height==1072)?1080:height,
                           Encoder, (gOnvifConf.tv == ONVIF_NTSC)?'N':'P', width2,
			   (height2==1072)?1080:height2);
    }
    strcpy(url.cgi, "encoder");
    if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) {
        p = strchr(ReplyMsg, '\'');
        if(p == NULL) return ERR;
        p ++;
        len = strlen(p);
        retFpsCap->numStreams = 1;
        fps = 0;
        k = 0;
        for(i = 0 ; i < len ; i ++) {
            if(p[i] == ',') {
                retFpsCap->fpsCap[retFpsCap->numStreams-1].fpsList[k] = fps;
                k ++;
                fps = 0;
            } else if((p[i] == ';') || (p[i] == '\'')) {
                retFpsCap->fpsCap[retFpsCap->numStreams-1].streamID = retFpsCap->numStreams;
                retFpsCap->fpsCap[retFpsCap->numStreams-1].fpsList[k] = fps;
                retFpsCap->fpsCap[retFpsCap->numStreams-1].maxFps = fps;
                k = 0;
                fps = 0;
                if(p[i] == ';') retFpsCap->numStreams ++;
                else            break;
            } else {
                fps = (fps * 10) + (p[i] - '0');
            }
        }
		retFpsCap->numStreams = gOnvifConf.numStreams;
    } else { /* fail to query the frame rate capability, use default */
		fprintf(stderr, "%s:error, send URL %s\n", __func__, url.cmd);
		return ERR;
    } 
#if ONVIF_MYYOU_DEBUG
    /* ##### dump the retFpsCap ###### */
    fprintf(stdout, "#####dump FpsCap:%d streams,\n(%d)%s\n", retFpsCap->numStreams, len, p);
    for(i = 0 ; i < retFpsCap->numStreams ; i ++) {
        fprintf(stdout, "FPS in stream%d: max FPS=%d, ", retFpsCap->fpsCap[i].streamID, retFpsCap->fpsCap[i].maxFps);
        for(k = 0; k < ONVIF_MAX_FPS_OPTIONS ; k ++) {
            if(retFpsCap->fpsCap[i].fpsList[k]) {
                fprintf(stdout, "%d,", retFpsCap->fpsCap[i].fpsList[k]);
            } else {
                fprintf(stdout, "\n");
                break;
            }
        }
    }
#endif
    if(retFpsCap->numStreams == (channel+1)) return OK;
    return ERR;
} 
static int check_received (const char *id) 
{ 
	int i; 
	if (!id) 
		return 1; 
	/* Check if Message ID already received */ 
	for (i = 0; i < MAX_HISTORY; i++) { 
		if (received_id[i] && !strcmp (id, received_id[i])) 
			return 1; 
	} 
	if (received_id[last_received]){ 
		free (received_id[last_received]); 
		received_id[last_received] = NULL; 
	} 
	received_id[last_received++] = strdup (id); 
	/* Wrap to overwrite old IDs */ 
	if (last_received >= MAX_HISTORY) 
		last_received = 0; 
	return 0; 
} 
static int GenerateScope (char *ScopeStr) 
{ 
	int i = 0, j = 0; 
	char *p1 = NULL; 
	char *p2 = NULL; 

	p1 = ScopeStr; 
	while (1) { 
		p2 = strstr (p1, "\x20\x20"); 
		if (p2 == 0) 
			break; 
		*p2 = '\0'; 
		if (strncmp (p1, Scope_Scheme_Authority, strlen (Scope_Scheme_Authority)) == 0) 
			gOnvifConf.Scopes.Ptr[i++] = p1; 
		p1 = p2 + 2; 
	} 
	if (strncmp (p1, Scope_Scheme_Authority, strlen (Scope_Scheme_Authority)) == 0) 
		gOnvifConf.Scopes.Ptr[i++] = p1; 

	/* difinition */ 
	p1 = gOnvifConf.Scopes.DifinStr; 
	for (;;) { 
		p2 = strchr (p1, ','); 
		if (p2 == 0) 
			break; 
		gOnvifConf.Scopes.difin[j++] = atoi (p1); 
		p1 = p2 + 1; 
	} 
	if (*p1 != '\0') { 
		gOnvifConf.Scopes.difin[j++] = atoi (p1); 
	} 
	if (i == j) 
		return i; 
	return 0; 
} 
static void OnvifUsedCountMinus(int *cnt) {
    int value = *cnt;
    
    if(value > 0) *cnt = value-1;
    else          *cnt = 0;
}
void AppendCustomVEConf (int videoSrc) { 
    int i = 0;
    int FrameRate1 = 30;
    int FrameRate2 = 1;
    tOnvifFpsCap myFpsCap;

    if(MaxFrameRateByRes(gOnvifConf.numStreams-1,
			 H264, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight,
			 H264, gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2, &myFpsCap) == OK) {
	FrameRate1 =  myFpsCap.fpsCap[0].maxFps;
        if(myFpsCap.numStreams == 2) FrameRate2 = myFpsCap.fpsCap[1].maxFps;
	else FrameRate2 = FrameRate1;
    }
    for (i = gOnvifConf.VeCnt ; i < MAX_VE_LIST; i++) {
	gOnvifConf.veConf[i].valid = 0;
        gOnvifConf.veConf[i].videoSrc = videoSrc;
        gOnvifConf.veConf[i].needSaved = 0;
	snprintf (gOnvifConf.veConf[i].Name,  MAX_PROFILE_STR, "uVE%d_%d", i, (videoSrc-1)); 
	snprintf (gOnvifConf.veConf[i].token, MAX_TOKEN_STRLEN, "t%s", gOnvifConf.veConf[i].Name); 
	gOnvifConf.veConf[i].UseCount = 0;
        if(videoSrc == 1) {
            gOnvifConf.veConf[i].r.Width = gOnvifConf.maxResWidth; 
            gOnvifConf.veConf[i].r.Height = gOnvifConf.maxResHeight; 
            gOnvifConf.veConf[i].rc.FrameRateLimit = FrameRate1;
        } else {
            gOnvifConf.veConf[i].r.Width = gOnvifConf.maxResWidth2; 
            gOnvifConf.veConf[i].r.Height = gOnvifConf.maxResHeight2; 
            gOnvifConf.veConf[i].rc.FrameRateLimit = FrameRate2;
        }
	gOnvifConf.veConf[i].Quality = 70;
        if(gOnvifConf.veConf[i].r.Width >= 1920)      gOnvifConf.veConf[i].rc.BitrateLimit = 4000;
        else if(gOnvifConf.veConf[i].r.Width >= 1280) gOnvifConf.veConf[i].rc.BitrateLimit = 3000;
        else                                          gOnvifConf.veConf[i].rc.BitrateLimit = 2000;
	gOnvifConf.veConf[i].rc.EncodingInterval = 1;
	gOnvifConf.veConf[i].Encoding = H264;
	gOnvifConf.veConf[i].t.H264.GovLength = 0; 
	gOnvifConf.veConf[i].t.H264.H264Profile = gOnvifConf.H264ProfileType;
      gOnvifConf.veConf[i].Quality = 70;
	/* multicast */
	gOnvifConf.veConf[i].Multicast.Type = IPv4_;
	strncpy (gOnvifConf.veConf[i].Multicast.IPv4Address, (char *)&gMcastIPv4Addr, 16); 
	gOnvifConf.veConf[i].Multicast.Port = 5000;
	gOnvifConf.veConf[i].Multicast.TTL = 16;
	gOnvifConf.veConf[i].Multicast.AutoStart = false_;
	sprintf (gOnvifConf.veConf[i].SessionTimeout, "PT0S");
    }
}
static void CreateMetaDataConfig ()
{
	Acti_MetaDataConfig *meta = &gOnvifConf.meConf;
    
    meta->valid = 0;
    meta->UseCount = 0;
    snprintf(meta->Name, MAX_PROFILE_STR, "Meta");
    snprintf(meta->token, MAX_TOKEN_STRLEN, "t%s", meta->Name);
	meta->IPType = IPv4_;
	sprintf(meta->IPv4Address, "0.0.0.0");
    meta->AutoStart = false_;
	sprintf(meta->SessionTimeout, "PT0S");
}
static void CreateVideoSources(void) {
    int FrameRate1 = 30;
    int FrameRate2 = 1;
    tOnvifFpsCap myFpsCap;
    
    /* force to work in dual streaming mode */
    gOnvifConf.SourceTokenCnt =  gOnvifConf.numStreams;
    if(gOnvifConf.SourceTokenCnt == 1) { /* single video streaming mode */
		/* stream 1 */
		if(MaxFrameRateByRes(0, -1, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight,
							-1, 0, 0, &myFpsCap) == OK) {
	    	FrameRate1 = myFpsCap.fpsCap[0].maxFps;
		}
		gOnvifConf.SourceToken[0].res.Width = gOnvifConf.maxResWidth;
		gOnvifConf.SourceToken[0].res.Height = gOnvifConf.maxResHeight;
		sprintf (gOnvifConf.SourceToken[0].Token, "tVS_1");
		gOnvifConf.SourceToken[0].FrameRate = FrameRate1;
		/* stream 2 use stream 1 configurations */
		gOnvifConf.SourceToken[1].res.Width = gOnvifConf.maxResWidth;
		gOnvifConf.SourceToken[1].res.Height = gOnvifConf.maxResHeight;
		sprintf (gOnvifConf.SourceToken[1].Token, "tVS_2");
		gOnvifConf.SourceToken[1].FrameRate = FrameRate1;
    } else { /* dual video streaming mode */
		if(MaxFrameRateByRes(1, -1, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight,
							-1, gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2,
							&myFpsCap) == OK) {
	    	FrameRate1 = myFpsCap.fpsCap[0].maxFps;
            FrameRate2 = myFpsCap.fpsCap[1].maxFps;
        }
		gOnvifConf.SourceToken[0].res.Width = gOnvifConf.maxResWidth;
        gOnvifConf.SourceToken[0].res.Height = gOnvifConf.maxResHeight;
        sprintf (gOnvifConf.SourceToken[0].Token, "tVS_1");
        gOnvifConf.SourceToken[0].FrameRate = FrameRate1;
		/* stream 2 use stream 1 configurations */
        gOnvifConf.SourceToken[1].res.Width = gOnvifConf.maxResWidth2;
        gOnvifConf.SourceToken[1].res.Height = gOnvifConf.maxResHeight2;
        sprintf (gOnvifConf.SourceToken[1].Token, "tVS_2");
        gOnvifConf.SourceToken[1].FrameRate = FrameRate2;
    }
    /*
    fprintf(stdout, "%s: dump video source:%d, %s:%dx%d@%d,%s:%dx%d@%d\n", __func__, gOnvifConf.numStreams,
	    gOnvifConf.SourceToken[0].Token, gOnvifConf.SourceToken[0].res.Width,
	    gOnvifConf.SourceToken[0].res.Height, gOnvifConf.SourceToken[0].FrameRate,
	    gOnvifConf.SourceToken[1].Token, gOnvifConf.SourceToken[1].res.Width,
	    gOnvifConf.SourceToken[1].res.Height, gOnvifConf.SourceToken[1].FrameRate);
    */
}
static void CreateVideoSourceConfigs (void) {

    gOnvifConf.VsCnt = gOnvifConf.numStreams;
    /* create video source 1 */
    snprintf(gOnvifConf.vsConf[0].token, MAX_TOKEN_STRLEN, "%s", gOnvifConf.SourceToken[0].Token);
    gOnvifConf.vsConf[0].SourceTokenIdx = 0;
    sprintf (gOnvifConf.vsConf[0].Name, "VS_1");
    gOnvifConf.vsConf[0].b.x = 0;
    gOnvifConf.vsConf[0].b.y = 0;
    gOnvifConf.vsConf[0].b.width = gOnvifConf.maxResWidth;
    gOnvifConf.vsConf[0].b.height = gOnvifConf.maxResHeight;
    snprintf(gOnvifConf.vsConf[1].token, MAX_TOKEN_STRLEN, "%s", gOnvifConf.SourceToken[1].Token);
    gOnvifConf.vsConf[1].b.x = 0;
    gOnvifConf.vsConf[1].b.y = 0;
    if(gOnvifConf.VsCnt == 2) { /* create video source 2 in dual stream mode */
    		sprintf (gOnvifConf.vsConf[1].Name, "VS_2");
		gOnvifConf.vsConf[1].SourceTokenIdx = 1;
		gOnvifConf.vsConf[1].b.width = gOnvifConf.maxResWidth2;
		gOnvifConf.vsConf[1].b.height = gOnvifConf.maxResHeight2;
    } else {
    		gOnvifConf.vsConf[1].Name[0] = '\0';
		gOnvifConf.vsConf[1].SourceTokenIdx = 0;
		gOnvifConf.vsConf[1].b.width = gOnvifConf.maxResWidth;
		gOnvifConf.vsConf[1].b.height = gOnvifConf.maxResHeight;
    }
    /*
    fprintf(stdout,
	    "%s:dump video src conf:%d\n"
	    "%s,%s:%d,%d~%d,%d(%d), %s,%s:%d,%d~%d,%d(%d)\n", __func__, gOnvifConf.VsCnt,
	    gOnvifConf.vsConf[0].token, gOnvifConf.vsConf[0].Name,
	    gOnvifConf.vsConf[0].b.x, gOnvifConf.vsConf[0].b.y,
	    gOnvifConf.vsConf[0].b.width, gOnvifConf.vsConf[0].b.height, gOnvifConf.vsConf[0].SourceTokenIdx,
	    gOnvifConf.vsConf[1].token, gOnvifConf.vsConf[1].Name,
            gOnvifConf.vsConf[1].b.x, gOnvifConf.vsConf[1].b.y,
            gOnvifConf.vsConf[1].b.width, gOnvifConf.vsConf[1].b.height, gOnvifConf.vsConf[1].SourceTokenIdx);
    */
}
static void OnvifPatch1080PResolutionForTK(int *height) {

    if((gOnvifConf.platform == ONVIF_PLATFROM_T) || (gOnvifConf.platform == ONVIF_PLATFROM_K)) {
            if(*height == 1080) *height = 1072;
    }
}
static void GetResolutionFmString(char *str, struct tt__VideoResolution *res) {

    /* get the video stream 1 capability, pick up the 1080p or lower reqolution for this encoder */
    if(strstr(str, "1920x1080")) {
	res->Width = 1920;
	res->Height = 1080;
	OnvifPatch1080PResolutionForTK(&res->Height);
    } else if(strstr(str, "2048x1536")) {
       res->Width = 2048;
       res->Height = 1536;
    } else if(strstr(str, "1280x960")) {
       res->Width = 1280;
       res->Height = 960;
    } else if(strstr(str, "1280x720")) {
       res->Width = 1280;
       res->Height = 720;
    } else if(strstr(str, "720x480")) {
       res->Width = 720;
       res->Height = 480;
    } else if(strstr(str, "720x576")) {
       res->Width = 720;
       res->Height = 576;
    } else {
       res->Width = 640;
       res->Height = 480;
    }
}
static void InitVideoEncoderParameters(int veIdx, int videoSrc, int encoder,
                                        struct tt__VideoResolution *res, int fps) {
    Acti_VideoEncoderConfig *conf = &gOnvifConf.veConf[veIdx];
                                        
    conf->videoSrc = videoSrc;
    conf->videoSrcInProfile = -1;
//    snprintf(conf->Name, MAX_PROFILE_STR, "VE%d_%d", gOnvifConf.VeCnt, videoSrc);
    snprintf(conf->Name, MAX_PROFILE_STR, "VE%d_%d", veIdx, videoSrc);
    conf->UseCount = 0;
    snprintf(conf->token, MAX_TOKEN_STRLEN, "t%s", conf->Name);
    conf->Encoding = encoder;
    conf->r.Width = res->Width;
    conf->r.Height = res->Height;
    conf->Quality = 80;
    conf->rc.FrameRateLimit = fps;
    if(conf->r.Width >= 1920) 		conf->rc.BitrateLimit = 4000; /* 4Mbps */
    else if(conf->r.Width >= 1280) 	conf->rc.BitrateLimit = 3000; /* 3Mbps */
    else if(conf->r.Width >= 640) 	conf->rc.BitrateLimit = 2000; /* 2Mbps */
    else 							conf->rc.BitrateLimit = 1000; /* 1Mbps */
    conf->rc.EncodingInterval = 1;
    conf->Multicast.Type = IPv4_;
    strncpy (conf->Multicast.IPv4Address, (char *)&gMcastIPv4Addr, 16); 
    conf->Multicast.Port = 0;
    conf->Multicast.TTL = 16;
    conf->Multicast.AutoStart = false_;
    sprintf(conf->SessionTimeout, "PT0S");
    conf->valid = 1;
}
static void CreateVideoEncoderConfigs (void) {
    char retBuf[1024*4];
    char value[256];
    struct tt__VideoResolution r1, r2;
    tOnvifFpsCap retFpsCap;
    int i = 0;
    int ret = 0;

    gOnvifConf.VeCnt = 0;
    for(i = 0 ; i < 3 ; i ++) {
	/* according the camera capability from system_info to set the encoder configurations */
	ret = OnvifSingleUrlCmdSend("system", "SYSTEM_INFO", retBuf, (sizeof(retBuf)-1));
	if(ret > 0) break;
	sleep(5);
    }
    if(ret > 0) {
        /* resolution capability */
        if(OnvifGetValueFmUrlReply(retBuf, "VIDEO_RESOLUTION_CAP = ", value, (sizeof(value)-1)) > 0) {
            GetResolutionFmString(value, &r1);
        }
        if((gOnvifConf.platform == ONVIF_PLATFROM_T) || (gOnvifConf.platform == ONVIF_PLATFROM_K)) {
            r2.Width = r1.Width;
            r2.Height = r1.Height;
            gOnvifConf.H264_Enable  = true_;
            gOnvifConf.MPEG4_Enable = true_;
            gOnvifConf.MJPEG_Enable = true_;
        } else {
            if(OnvifGetValueFmUrlReply(retBuf, "VIDEO2_RESOLUTION_CAP = ", value, (sizeof(value)-1)) > 0) {
                GetResolutionFmString(value, &r2);
            } else {
                r2.Width = r1.Width;
                r2.Height = r1.Height;
            }
            gOnvifConf.H264_Enable  = true_;
            gOnvifConf.MPEG4_Enable = false_;
            gOnvifConf.MJPEG_Enable = true_;
        }
    } else {
        r1.Width = 1280; r1.Height = 720; 
        r2.Width = 1280; r2.Height = 720;
	L1("error, send SYSTEM_INFO. use 720\n");
    }
    /* set the frame rate in H264 stream1 and stream 2 */
    if(MaxFrameRateByRes(gOnvifConf.numStreams-1, H264, r1.Width, r1.Height,
			 H264, r2.Width, r2.Height, &retFpsCap) == OK) {
        InitVideoEncoderParameters(gOnvifConf.VeCnt, 1, H264, &r1, retFpsCap.fpsCap[0].maxFps);
        gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
        gOnvifConf.VeCnt += 1;
	if(gOnvifConf.numStreams == 2) {
	    InitVideoEncoderParameters(gOnvifConf.VeCnt, 2, H264, &r2, retFpsCap.fpsCap[1].maxFps);
	    gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
	    gOnvifConf.VeCnt += 1;
	}
    } else {
        InitVideoEncoderParameters(gOnvifConf.VeCnt, 1, H264, &r1, 30);
        gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
        gOnvifConf.VeCnt += 1;
	if(gOnvifConf.numStreams == 2) {
	    InitVideoEncoderParameters(gOnvifConf.VeCnt, 2, H264, &r2, 1);
	    gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
	    gOnvifConf.VeCnt += 1;
	}
    }
    /* set the frame rate in MJPEG stream1 and stream 2 */  
    if(MaxFrameRateByRes(gOnvifConf.numStreams-1, JPEG, r1.Width, r1.Height,
                         JPEG, r2.Width, r2.Height, &retFpsCap) == OK) {
        InitVideoEncoderParameters(gOnvifConf.VeCnt, 1, JPEG, &r1, retFpsCap.fpsCap[0].maxFps);
        gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
        gOnvifConf.VeCnt += 1;
	if(gOnvifConf.numStreams == 2) {
	    InitVideoEncoderParameters(gOnvifConf.VeCnt, 2, JPEG, &r2, retFpsCap.fpsCap[1].maxFps);
	    gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
	    gOnvifConf.VeCnt += 1;
	}
    } else {
        InitVideoEncoderParameters(gOnvifConf.VeCnt, 1, JPEG, &r1, 30);
        gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
        gOnvifConf.VeCnt += 1;
	if(gOnvifConf.numStreams == 2) {
            InitVideoEncoderParameters(gOnvifConf.VeCnt, 2, JPEG, &r2, 1);
	    gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
	    gOnvifConf.VeCnt += 1;
	}
    }
    /* set the frame rate in MPEG4 stream1 and stream 2 if we have MPEG4 */
    if(gOnvifConf.MPEG4_Enable == true_) {
        if(MaxFrameRateByRes(gOnvifConf.numStreams-1, MPEG4, r1.Width, r1.Height,
                             MPEG4, r2.Width, r2.Height, &retFpsCap) == OK) {
            InitVideoEncoderParameters(gOnvifConf.VeCnt, 1, MPEG4, &r1, retFpsCap.fpsCap[0].maxFps);
            gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
            gOnvifConf.VeCnt += 1;
	    if(gOnvifConf.numStreams == 2) {
		InitVideoEncoderParameters(gOnvifConf.VeCnt, 2, MPEG4, &r2, retFpsCap.fpsCap[1].maxFps);
		gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
		gOnvifConf.VeCnt += 1;
	    }
        } else {
            InitVideoEncoderParameters(gOnvifConf.VeCnt, 1, MPEG4, &r1, 30);
            gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
            gOnvifConf.VeCnt += 1;
	    if(gOnvifConf.numStreams == 2) {
		InitVideoEncoderParameters(gOnvifConf.VeCnt, 2, MPEG4, &r2, 1);
		gOnvifConf.veConf[gOnvifConf.VeCnt].needSaved = 1;
		gOnvifConf.VeCnt += 1;
	    }
        }
    }
    AppendCustomVEConf(1);
    return;
}
static int FindMediaProfile (struct soap *soap, char *ProfileToken, int *idx)
{
	int i = 0;

    if((ProfileToken) && (strlen(ProfileToken) > 0)) {
        for (i = 0; i < MAX_PROFILE_LIST; i++) {
            if (gOnvifConf.profile[i].valid) {
                if ((strcmp (gOnvifConf.profile[i].token, ProfileToken)) == 0) {
                    *idx = i;
			  //L1("ProfileToken = %s id=%d\n", ProfileToken, i);
                    return OK;
                }
			}
		}
	}
	return ERR;
}

static int FindVideoSource (char *VideoSourceToken, int *idx)
{
	int i;
    if(VideoSourceToken) {
        for (i = 0; i < MAX_VS_LIST; i++) {
            if ((strcmp (gOnvifConf.SourceToken[i].Token, VideoSourceToken)) == 0) {
                *idx = i;
                return SOAP_OK;
            }
		}
        L1("error, not found video source %s\n", VideoSourceToken);
	}
	return SOAP_ERR;
}

static int GetV2WanStatus (char *ReplyMsg, int size) 
{
    tUrlDB url;
    char ReplyMsg2[512];
    int TimeOutCounter = 0; 

    sprintf(url.cgi, "system");
    url.len = sprintf(url.cmd, "V2_WAN_STATUS");
    do {
        if((OnvifCmdSend(&url, ReplyMsg2, sizeof(ReplyMsg2)) == OK) && (strncmp(ReplyMsg2, "ERROR", 5) != 0))
        {
            if (ReplyMsg2[0] != '\0')
            {
                strncpy (ReplyMsg, ReplyMsg2, strlen(ReplyMsg2)); 
                ReplyMsg[strlen(ReplyMsg2)] = '\0';
                return OK;	
            }
        } 
        sleep (2); 
    } while (TimeOutCounter++ < 5);
    ReplyMsg[0] = '\0';    
    return ERR;
}

static struct tt__DeviceCapabilities *PrepareDeviceCap (struct soap *soap)
{
    struct tt__DeviceCapabilities *dev = NULL;
    static int DIs = 0, DOs = 0;
    int sizeAux = 0; 
    tUrlDB url;
    char value[2];
    char buf[64];
    char ReplyMsg[512];
    static enum xsd__boolean IPFilter = false_;
    static enum xsd__boolean ZeroConfiguration = false_;
    static enum xsd__boolean DynDNS = false_;
    static enum xsd__boolean Auxiliary = true_;
    char V2WanStatusReply[V2_WAN_STATUS_LEN];

    strcpy(url.cgi, "system");
    url.len = sprintf(url.cmd, "IP_FILTER_STATE");
    if((OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) && (strncmp(ReplyMsg, "ERROR", 5) != 0)) {
	OnvifReplyMsgParser("IP_FILTER_STATE", ReplyMsg, value);
	IPFilter = (enum xsd__boolean) atoi(value);
    }
    if (GetV2WanStatus (V2WanStatusReply, sizeof (V2WanStatusReply)) == OK) {
	OnvifReplyMsgParser("BONJOUR_CONFIG", V2WanStatusReply, buf);
	buf[1] = '\0';
	ZeroConfiguration = (enum xsd__boolean) atoi(buf);
    } else {
	ZeroConfiguration = 0;
    }
    url.len = sprintf(url.cmd, "DDNS");
    url.len = strlen(url.cmd);
    if((OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) && (strncmp(ReplyMsg, "ERROR", 5) != 0)) {
	OnvifReplyMsgParser("DDNS_TYPE", ReplyMsg, buf);
	DynDNS = (enum xsd__boolean) atoi(buf);
    }
    DIs = gOnvifConf.DIs;
    DOs = gOnvifConf.DOs;
    dev = (struct tt__DeviceCapabilities *) soap_malloc (soap, sizeof (struct tt__DeviceCapabilities));
    soap_default_tt__DeviceCapabilities (soap, dev);
    /* tt:XAddr */
    dev->XAddr = gOnvifConf.MediaXAddr;
    /*tt:Network */
    dev->Network = (struct tt__NetworkCapabilities *) soap_malloc (soap, sizeof (struct tt__NetworkCapabilities));
    soap_default_tt__NetworkCapabilities (soap, dev->Network);
    dev->Network->IPFilter = &IPFilter; 
    dev->Network->ZeroConfiguration = &ZeroConfiguration; 
    dev->Network->DynDNS = &DynDNS; 
    /* tt:System */
    dev->System = (struct tt__SystemCapabilities *) soap_malloc (soap, sizeof (struct tt__SystemCapabilities));
    soap_default_tt__SystemCapabilities (soap, dev->System);
    dev->System->DiscoveryResolve = false_;
    dev->System->DiscoveryBye = true_;
    dev->System->RemoteDiscovery = false_;
    dev->System->SystemBackup = false_;
    dev->System->SystemLogging = false_;
    dev->System->FirmwareUpgrade = false_;
    dev->System->__sizeSupportedVersions = 1;
    dev->System->SupportedVersions = (struct tt__OnvifVersion *) soap_malloc (soap, sizeof (struct tt__OnvifVersion));
    soap_default_tt__OnvifVersion (soap, dev->System->SupportedVersions);
    dev->System->SupportedVersions->Major = ONVIF_VERSION_MAJOR;
    dev->System->SupportedVersions->Minor = ONVIF_VERSION_MINOR;
    /* tt:IO */
    dev->IO = (struct tt__IOCapabilities *) soap_malloc (soap, sizeof (struct tt__IOCapabilities));
    soap_default_tt__IOCapabilities (soap, dev->IO);
    dev->IO->InputConnectors = &DIs;
    dev->IO->RelayOutputs = &DOs;
    /* tt:IOCapabilitiesExtension */
    dev->IO->Extension = (struct tt__IOCapabilitiesExtension *) soap_malloc (soap, sizeof (struct tt__IOCapabilitiesExtension));
    soap_default_tt__IOCapabilitiesExtension (soap, dev->IO->Extension);
	
    if (gOnvifConf.DOEnable == true_) {
	sizeAux = (sizeof (Auxiliary_Operations)/4);
	Auxiliary = true_;
	dev->IO->Extension->Auxiliary = &Auxiliary;
	dev->IO->Extension->__sizeAuxiliaryCommands = sizeAux; //(sizeof (Auxiliary_Operations)/4); 
	dev->IO->Extension->AuxiliaryCommands = Auxiliary_Operations;
    }
    /* tt:IOCapabilitiesExtension2 */
    dev->IO->Extension->Extension = (struct tt__IOCapabilitiesExtension2 *) soap_malloc (soap, sizeof (struct tt__IOCapabilitiesExtension2));
    soap_default_tt__IOCapabilitiesExtension2 (soap, dev->IO->Extension->Extension);
    /* tt:Security */
    dev->Security = (struct tt__SecurityCapabilities *) soap_malloc (soap, sizeof (struct tt__SecurityCapabilities));
    soap_default_tt__SecurityCapabilities (soap, dev->Security);
    dev->Security->TLS1_x002e1 = false_;
    dev->Security->TLS1_x002e2 = false_;
    dev->Security->OnboardKeyGeneration = false_;
    dev->Security->AccessPolicyConfig = false_;
    dev->Security->X_x002e509Token = false_;
    dev->Security->SAMLToken = false_;
    dev->Security->KerberosToken = false_;
    dev->Security->RELToken = false_;
    return dev;
}

static struct tt__MediaCapabilities *PrepareMediaCap (struct soap *soap)
{
	struct tt__MediaCapabilities *media = NULL;

	media = (struct tt__MediaCapabilities *) soap_malloc (soap, sizeof (struct tt__MediaCapabilities));
	soap_default_tt__MediaCapabilities (soap, media);
	/* tt:XAddr */
	media->XAddr = gOnvifConf.MediaXAddr;
	/* tt:stream */
	media->StreamingCapabilities =
		(struct tt__RealTimeStreamingCapabilities *) soap_malloc (soap, sizeof (struct tt__RealTimeStreamingCapabilities));
	soap_default_tt__RealTimeStreamingCapabilities (soap, media->StreamingCapabilities);
	media->StreamingCapabilities->RTPMulticast = &blTrue;
	media->StreamingCapabilities->RTP_USCORETCP = &blTrue;//Anne
	media->StreamingCapabilities->RTP_USCORERTSP_USCORETCP = &blFalse;//Anne

	return media;
}

static struct tt__ImagingCapabilities *PrepareImagingCap (struct soap *soap)
{
	struct tt__ImagingCapabilities *imaging = NULL;

	imaging = (struct tt__ImagingCapabilities *) soap_malloc (soap, sizeof (struct tt__ImagingCapabilities));
	soap_default_tt__ImagingCapabilities (soap, imaging);
	/*tds:Imaging */
	imaging->XAddr = gOnvifConf.MediaXAddr;
	return imaging;
}

static struct tt__EventCapabilities *PrepareEventsCap (struct soap *soap)
{
	struct tt__EventCapabilities *event = NULL;

	event = (struct tt__EventCapabilities *) soap_malloc (soap, sizeof (struct tt__EventCapabilities));
	soap_default_tt__EventCapabilities (soap, event);
	/* tt:XAddr */
	event->XAddr = gOnvifConf.MediaXAddr;
	/* tt:stream */
	event->WSSubscriptionPolicySupport = true_;
	event->WSPullPointSupport = true_;
	event->WSPausableSubscriptionManagerInterfaceSupport = true_;

	return event;
}

static struct tt__PTZCapabilities *PreparePTZCap (struct soap *soap)
{
	struct tt__PTZCapabilities *PTZ = NULL;

	PTZ = (struct tt__PTZCapabilities *) soap_malloc (soap, sizeof (struct tt__PTZCapabilities));
	soap_default_tt__PTZCapabilities (soap, PTZ);
	/*tds:Imaging */
	PTZ->XAddr = gOnvifConf.MediaXAddr;
	return PTZ;
}

static void PrepareVSConfig (struct soap *soap, Acti_VideoSourceConfig * vsConf,
				 struct tt__VideoSourceConfiguration *VideoSourceConfig)
{
	if (vsConf) {
		VideoSourceConfig->Name = vsConf->Name;
		VideoSourceConfig->UseCount = vsConf->UseCount;
		VideoSourceConfig->token = vsConf->token;
		VideoSourceConfig->SourceToken = gOnvifConf.SourceToken[vsConf->SourceTokenIdx].Token;
		VideoSourceConfig->Bounds = &vsConf->b;
	}
}
static int GetNumOfValidVeConfByVsIdx(Acti_VideoEncoderConfig *veConf, int vsIdx) {
	int i = 0;
	int cnt = 0;

	/* vsIdx: 1: video source 1, 2: video source 2. it is the same definition as veConf[].videoSrc */
	for(i = 0 ; i < MAX_VE_LIST ; i ++) {
		if((veConf[i].valid == 1) && (veConf[i].videoSrc == vsIdx)) cnt ++;
	}
	return cnt;
}
static void PrepareVEConfig (struct soap *soap, int idx, Acti_VideoEncoderConfig * ve,
				 struct tt__VideoEncoderConfiguration *VideoEncoderConfig)
{
    Acti_VideoEncoderConfig *vePtr = &gOnvifConf.veConf[idx];	

    VideoEncoderConfig->Name = vePtr->Name;
    VideoEncoderConfig->UseCount = gOnvifConf.veConf[idx].UseCount;
    VideoEncoderConfig->token = vePtr->token;
    VideoEncoderConfig->Encoding = vePtr->Encoding;
    VideoEncoderConfig->Resolution = &vePtr->r;
    VideoEncoderConfig->Quality = (float) vePtr->Quality;
    VideoEncoderConfig->RateControl = &vePtr->rc;
    if (vePtr->Encoding == MPEG4) {
        VideoEncoderConfig->MPEG4 =
            (struct tt__Mpeg4Configuration *) soap_malloc (soap, sizeof (struct tt__Mpeg4Configuration));
        soap_default_tt__Mpeg4Configuration (soap, VideoEncoderConfig->MPEG4);
        VideoEncoderConfig->MPEG4->GovLength = vePtr->t.MPEG4.GovLength;
        VideoEncoderConfig->MPEG4->Mpeg4Profile = vePtr->t.MPEG4.Mpeg4Profile;
    } else if (vePtr->Encoding == H264) {
        VideoEncoderConfig->H264 =
            (struct tt__H264Configuration *) soap_malloc (soap, sizeof (struct tt__H264Configuration));
        soap_default_tt__H264Configuration (soap, VideoEncoderConfig->H264);
        VideoEncoderConfig->H264->GovLength = vePtr->t.H264.GovLength;
        VideoEncoderConfig->H264->H264Profile = vePtr->t.H264.H264Profile;
    }
	VideoEncoderConfig->Multicast =
			(struct tt__MulticastConfiguration *) soap_malloc (soap, sizeof (struct tt__MulticastConfiguration));
	soap_default_tt__MulticastConfiguration (soap, VideoEncoderConfig->Multicast);
	VideoEncoderConfig->Multicast->Address =
			(struct tt__IPAddress *) soap_malloc (soap, sizeof (struct tt__IPAddress));
	soap_default_tt__IPAddress (soap, VideoEncoderConfig->Multicast->Address);
    VideoEncoderConfig->Multicast->Address->Type = IPv4_;
    VideoEncoderConfig->Multicast->Address->IPv4Address = (char **)soap_malloc (soap, 1); 
    VideoEncoderConfig->Multicast->Address->IPv4Address[0] = (char *)soap_malloc (soap, 16); 
    VideoEncoderConfig->Multicast->Address->IPv4Address[0][0] = '\0'; 
    strncpy (VideoEncoderConfig->Multicast->Address->IPv4Address[0], (char *)&vePtr->Multicast.IPv4Address, 16);
    VideoEncoderConfig->Multicast->Port = vePtr->Multicast.Port;
    VideoEncoderConfig->Multicast->TTL = vePtr->Multicast.TTL; 
    VideoEncoderConfig->Multicast->AutoStart = vePtr->Multicast.AutoStart;
    VideoEncoderConfig->SessionTimeout = (char *) soap_malloc (soap, ISO8601_DURATION_STRLEN); 
    VideoEncoderConfig->SessionTimeout[0] = '\0'; 
    strncpy (VideoEncoderConfig->SessionTimeout, vePtr->SessionTimeout, ISO8601_DURATION_STRLEN);
	return; 
}
#ifdef HAVE_METADATA
	/* 
	   Onvif Core Spec V2.0: 
		4.15.1 Synchronization Points
		Because receivers use RTSP addresses to specify the source of the stream, they do not
		necessarily have access to the web services interface of the transmitter. This means that they
		cannot use the SetSynchronizationPoint command described in Section 11.18.1.
		Instead, receivers should use the PLI message described in [RFC 4585] to request a
		synchronization point.
	    SSPO Policy: We don't support this function currently.
 	*/
static void PrepareMEConfig (struct soap *soap, Acti_MetaDataConfig *me,
				 struct tt__MetadataConfiguration *MetadataConfig)
{
	tUrlDB url;
	char ReplyMsg[512];
	char value[16];
	int MulticastPort = 0;
	int TTL = 0;
	static char *IPv4Address;
	IPv4Address = (char *) soap_malloc (soap, 16);

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "V2_PORT_RTP_MULTI_VIDEO&VIDEO_MULTICAST_TTL&V2_MULTICAST_IP");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK )
	{
		OnvifReplyMsgParser("V2_PORT_RTP_MULTI_VIDEO", ReplyMsg, value);
		MulticastPort = atoi(value);
		OnvifReplyMsgParser("VIDEO_MULTICAST_TTL", ReplyMsg, value);
		TTL = atoi(value);
		OnvifReplyMsgParser("V2_MULTICAST_IP", ReplyMsg, value);
		strncpy (IPv4Address, value, strlen (value));
	}

	if (me) {
		MetadataConfig->Name = me->Name;
		MetadataConfig->UseCount = me->UseCount;
		MetadataConfig->token = me->token;
		MetadataConfig->Multicast =
			(struct tt__MulticastConfiguration *) soap_malloc (soap, sizeof (struct tt__MulticastConfiguration));
		soap_default_tt__MulticastConfiguration (soap, MetadataConfig->Multicast);
		MetadataConfig->Multicast->Address =
			(struct tt__IPAddress *) soap_malloc (soap, sizeof (struct tt__IPAddress));
		soap_default_tt__IPAddress (soap, MetadataConfig->Multicast->Address);
		MetadataConfig->Multicast->Address->Type = me->IPType;
		MetadataConfig->Multicast->Address->IPv4Address = &IPv4Address;
		MetadataConfig->Multicast->Port = MulticastPort;
		MetadataConfig->Multicast->TTL = TTL; 
		MetadataConfig->Multicast->AutoStart = me->AutoStart;
		MetadataConfig->SessionTimeout = me->SessionTimeout;
	}
}
#endif
static void PreparePTZConfig (struct soap *soap, struct tt__PTZConfiguration *PTZConfig)
{
	int i = 0;
	static char timeout[16];
	Acti_PTZConfig *PtzConfPtr = NULL;
    
	if (PTZConfigState == true_)  PtzConfPtr = &gOnvifConf.PTZConfig;
	else                          PtzConfPtr = &tmpPTZConf;			

	PTZConfig->Name = PtzConfPtr->Name;
	PtzConfPtr->UseCount = 0;

	for (i=0; i<MAX_PROFILE_LIST; i++)
	{
		if (gOnvifConf.PTZ_AddToken[i] == true_) 
			PtzConfPtr->UseCount++;
	}
	PTZConfig->UseCount = PtzConfPtr->UseCount;

	PTZConfig->token = PtzConfPtr->Token;
	PTZConfig->NodeToken = PtzConfPtr->NodeToken;

	if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_))
	{
		PTZConfig->DefaultAbsolutePantTiltPositionSpace = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->DefaultRelativePanTiltTranslationSpace = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->DefaultContinuousPanTiltVelocitySpace = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->DefaultAbsolutePantTiltPositionSpace[0] = '\0';
		PTZConfig->DefaultRelativePanTiltTranslationSpace[0] = '\0';
		PTZConfig->DefaultContinuousPanTiltVelocitySpace[0] = '\0';
        
		snprintf(PTZConfig->DefaultAbsolutePantTiltPositionSpace, MAX_NAMESPACE_LEN, "%s",
                 PtzConfPtr->AbsolutePantTiltPositionSpace);
		snprintf(PTZConfig->DefaultRelativePanTiltTranslationSpace, MAX_NAMESPACE_LEN, "%s",
                 PtzConfPtr->RelativePanTiltTranslationSpace);
		snprintf(PTZConfig->DefaultContinuousPanTiltVelocitySpace, MAX_NAMESPACE_LEN, "%s", 
                 PtzConfPtr->ContinuousPanTiltVelocitySpace);
	}
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZConfig->DefaultAbsoluteZoomPositionSpace = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->DefaultRelativeZoomTranslationSpace = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->DefaultContinuousZoomVelocitySpace = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->DefaultAbsoluteZoomPositionSpace[0] = '\0';
		PTZConfig->DefaultRelativeZoomTranslationSpace[0] = '\0';
		PTZConfig->DefaultContinuousZoomVelocitySpace[0] = '\0'; 
		snprintf(PTZConfig->DefaultAbsoluteZoomPositionSpace, MAX_NAMESPACE_LEN, "%s", PtzConfPtr->AbsoluteZoomPositionSpace);
		snprintf(PTZConfig->DefaultRelativeZoomTranslationSpace, MAX_NAMESPACE_LEN, "%s", PtzConfPtr->RelativeZoomTranslationSpace);
		snprintf(PTZConfig->DefaultContinuousZoomVelocitySpace, MAX_NAMESPACE_LEN, "%s", PtzConfPtr->ContinuousZoomVelocitySpace);
	}
	PTZConfig->DefaultPTZSpeed = (struct tt__PTZSpeed *) soap_malloc(soap, sizeof(struct tt__PTZSpeed));
	soap_default_tt__PTZSpeed(soap, PTZConfig->DefaultPTZSpeed);
	if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_))
	{
		PTZConfig->DefaultPTZSpeed->PanTilt = (struct tt__Vector2D *) soap_malloc (soap, sizeof(struct tt__Vector2D));	
		soap_default_tt__Vector2D (soap, PTZConfig->DefaultPTZSpeed->PanTilt);
		PTZConfig->DefaultPTZSpeed->PanTilt->x = PtzConfPtr->PanDefaultSpeed; 
		PTZConfig->DefaultPTZSpeed->PanTilt->y = PtzConfPtr->TiltDefaultSpeed; 
		PTZConfig->DefaultPTZSpeed->PanTilt->space = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		snprintf(PTZConfig->DefaultPTZSpeed->PanTilt->space, MAX_NAMESPACE_LEN, "%s", PtzConfPtr->PTDefaultSpeedSpace);
	}
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZConfig->DefaultPTZSpeed->Zoom = (struct tt__Vector1D *) soap_malloc (soap, sizeof(struct tt__Vector1D));	
		soap_default_tt__Vector1D (soap, PTZConfig->DefaultPTZSpeed->Zoom);
		PTZConfig->DefaultPTZSpeed->Zoom->x = PtzConfPtr->ZoomDefaultSpeed; 
		PTZConfig->DefaultPTZSpeed->Zoom->space = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		snprintf(PTZConfig->DefaultPTZSpeed->Zoom->space, MAX_NAMESPACE_LEN, "%s", PtzConfPtr->ZoomDefaultSpeedSpace); 
	}
	//DefaultPTZTimeout
	snprintf (timeout, (sizeof(timeout)-1), "PT%dS", PtzConfPtr->PTZ_timeout);
	PTZConfig->DefaultPTZTimeout = timeout;
	//PanTiltLimits
	if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_))
	{
		PTZConfig->PanTiltLimits = 
			(struct tt__PanTiltLimits *) soap_malloc (soap, sizeof(struct tt__PanTiltLimits));
		soap_default_tt__PanTiltLimits (soap, PTZConfig->PanTiltLimits);
		PTZConfig->PanTiltLimits->Range = 
			(struct tt__Space2DDescription *) soap_malloc (soap, sizeof(struct tt__Space2DDescription));
		soap_default_tt__Space2DDescription (soap, PTZConfig->PanTiltLimits->Range);
		PTZConfig->PanTiltLimits->Range->URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZConfig->PanTiltLimits->Range->URI[0] = '\0';
		snprintf(PTZConfig->PanTiltLimits->Range->URI, MAX_NAMESPACE_LEN ,"%s", PtzConfPtr->PanTiltLimits_URI); 
		PTZConfig->PanTiltLimits->Range->XRange =
			(struct tt__FloatRange *) soap_malloc(soap, sizeof (struct tt__FloatRange));
		soap_default_tt__FloatRange (soap, PTZConfig->PanTiltLimits->Range->XRange);
		PTZConfig->PanTiltLimits->Range->XRange->Min = PtzConfPtr->MinPanLimits;
		PTZConfig->PanTiltLimits->Range->XRange->Max = PtzConfPtr->MaxPanLimits;
		PTZConfig->PanTiltLimits->Range->YRange =
			(struct tt__FloatRange *) soap_malloc(soap, sizeof (struct tt__FloatRange));
		soap_default_tt__FloatRange (soap, PTZConfig->PanTiltLimits->Range->YRange);
		PTZConfig->PanTiltLimits->Range->YRange->Min = PtzConfPtr->MinTiltLimits;
		PTZConfig->PanTiltLimits->Range->YRange->Max = PtzConfPtr->MaxTiltLimits;
	}
	//ZoomLimits
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZConfig->ZoomLimits = 
			(struct tt__ZoomLimits *) soap_malloc (soap, sizeof (struct tt__ZoomLimits));	
		soap_default_tt__ZoomLimits (soap, PTZConfig->ZoomLimits);
		PTZConfig->ZoomLimits->Range = 
			(struct tt__Space1DDescription *) soap_malloc (soap, sizeof (struct tt__Space1DDescription));
		soap_default_tt__Space1DDescription (soap, PTZConfig->ZoomLimits->Range);
		PTZConfig->ZoomLimits->Range->URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1); 
		PTZConfig->ZoomLimits->Range->URI[0] = '\0'; 
		snprintf (PTZConfig->ZoomLimits->Range->URI, MAX_NAMESPACE_LEN, "%s", PtzConfPtr->ZoomLimits_URI); 
		PTZConfig->ZoomLimits->Range->XRange = 
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange));
		soap_default_tt__FloatRange (soap, PTZConfig->ZoomLimits->Range->XRange);
		PTZConfig->ZoomLimits->Range->XRange->Min = PtzConfPtr->MinZoomLimits;
		PTZConfig->ZoomLimits->Range->XRange->Max = PtzConfPtr->MaxZoomLimits;
	}
}

static void PrepareAEConfig (struct soap *soap, struct tt__AudioEncoderConfiguration *AudioEncoderConfig)
{
	int i = 0;
/// Top of Winters ///
	Acti_AudioEncoderConfig *AePtr = NULL;

	if (AEConfigState == true_)
		AePtr = &gOnvifConf.aeConf; 	
	else
		AePtr = &tmpAeConf; 	

	//strcpy (AudioEncoderConfig->Name, AePtr->Name); 
	AudioEncoderConfig->Name = (char *)&AePtr->Name; 
	gOnvifConf.aeConf.UseCount = 0;
	for(i=0; i<MAX_PROFILE_LIST; i++)
	{
		if(gOnvifConf.AEToken[i] == true_) 
			gOnvifConf.aeConf.UseCount++;
	}

	AudioEncoderConfig->UseCount = gOnvifConf.aeConf.UseCount++; 
	AePtr->UseCount = gOnvifConf.aeConf.UseCount; 
	//strcpy (AudioEncoderConfig->token, AePtr->token); 
	AudioEncoderConfig->token = (char *) &AePtr->token; 
	AudioEncoderConfig->Encoding = AePtr->Encoding; 
	AudioEncoderConfig->Bitrate = AePtr->Bitrate/1000; 
	AudioEncoderConfig->SampleRate = AePtr->SampleRate/1000; 
	AudioEncoderConfig->Multicast = 
		(struct tt__MulticastConfiguration *) soap_malloc (soap, sizeof (struct tt__MulticastConfiguration));
	soap_default_tt__MulticastConfiguration (soap, AudioEncoderConfig->Multicast);
	AudioEncoderConfig->Multicast->Address =
		(struct tt__IPAddress *) soap_malloc (soap, sizeof (struct tt__IPAddress));
	soap_default_tt__IPAddress (soap, AudioEncoderConfig->Multicast->Address);
	AudioEncoderConfig->Multicast->Address->Type = AePtr->Multicast.Type;
	AudioEncoderConfig->Multicast->Address->IPv4Address = (char **) soap_malloc (soap, 1); 
	AudioEncoderConfig->Multicast->Address->IPv4Address[0] = (char *) soap_malloc (soap, 16); 
	AudioEncoderConfig->Multicast->Address->IPv4Address[0][0] = '\0';
	//w: strcpy (AudioEncoderConfig->Multicast->Address->IPv4Address[0], (char *)&AePtr->Multicast.IPv4Address);
	strncpy (AudioEncoderConfig->Multicast->Address->IPv4Address[0], (char *)&AePtr->Multicast.IPv4Address, 16);
	AudioEncoderConfig->Multicast->Port = AePtr->Multicast.Port; 
	AudioEncoderConfig->Multicast->TTL = AePtr->Multicast.TTL; 
	AudioEncoderConfig->Multicast->AutoStart = AePtr->Multicast.AutoStart; //false_;
	AudioEncoderConfig->SessionTimeout = (char *) soap_malloc (soap, ISO8601_DURATION_STRLEN + 1); 
	AudioEncoderConfig->SessionTimeout[0] = '\0';
	strncpy (AudioEncoderConfig->SessionTimeout, AePtr->SessionTimeout, ISO8601_DURATION_STRLEN + 1);
/// Bottom of Winters ///
}

static void PrepareProfile (struct soap *soap, struct tt__Profile *p, int idx)
{
	int i=0;
    int index = 0;
    Acti_MediaProfile       *profile = &gOnvifConf.profile[idx];
	Acti_VideoSourceConfig  *vsConf  = NULL;
	Acti_VideoEncoderConfig *veConf  = NULL;
	Acti_AudioSourceConfig  *AsPtr   = NULL; 
	Acti_AudioEncoderConfig *AePtr   = NULL; 
#ifdef HAVE_METADATA
	Acti_MetaDataConfig     *meConf = &gOnvifConf.meConf;
#endif
    
	if (ASConfigState == true_)    AsPtr = &gOnvifConf.asConf; 	
	else                           AsPtr = &tmpAsConf; 	
	if (AEConfigState == true_)    AePtr = &gOnvifConf.aeConf; 	
	else                           AePtr = &tmpAeConf;

	p->Name = profile->Name;
	p->token = profile->token;
	p->fixed = (enum xsd__boolean*) &profile->readOnly;
    /* set video source configurations */
	p->VideoSourceConfiguration =
			(struct tt__VideoSourceConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoSourceConfiguration));
	soap_default_tt__VideoSourceConfiguration (soap, p->VideoSourceConfiguration);
    if((profile->vsIdx >= 0) && (profile->vsIdx < MAX_VS_LIST)) vsConf = &gOnvifConf.vsConf[profile->vsIdx];
    else                                                        vsConf = &gOnvifConf.vsConf[0];
	PrepareVSConfig (soap, vsConf, p->VideoSourceConfiguration);
    /* set video encoder configurations */
    if((profile->veIdx >= 0) && (profile->veIdx < MAX_VE_LIST)) {
        index = profile->veIdx;
        veConf = &gOnvifConf.veConf[profile->veIdx];
    } else {
        index = 0;
        veConf = &gOnvifConf.veConf[index];
    }
	p->VideoEncoderConfiguration =
            (struct tt__VideoEncoderConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoEncoderConfiguration));
	soap_default_tt__VideoEncoderConfiguration (soap, p->VideoEncoderConfiguration);
	PrepareVEConfig (soap, index, veConf, p->VideoEncoderConfiguration);
    
#ifdef HAVE_METADATA
	p->MetadataConfiguration =
		(struct tt__MetadataConfiguration *) soap_malloc (soap, sizeof (struct tt__MetadataConfiguration));
	soap_default_tt__MetadataConfiguration (soap, p->MetadataConfiguration);
	PrepareMEConfig (soap, meConf, p->MetadataConfiguration);
#endif
	if( (gOnvifConf.PTEnable == true_) || (gOnvifConf.ZoomEnable == true_) ||
        (gOnvifConf.PTEnableBy485 == true_) || (gOnvifConf.ZoomEnableBy485 == true_) )
	{
		if(gOnvifConf.PTZ_AddToken[idx] == true_) 
		{
			p->PTZConfiguration =
				(struct tt__PTZConfiguration *) soap_malloc (soap, sizeof (struct tt__PTZConfiguration));
			soap_default_tt__PTZConfiguration (soap, p->PTZConfiguration);
			PreparePTZConfig (soap, p->PTZConfiguration);
        }
	}
	if (gOnvifConf.AudioEnable == true_)
	{
		if(gOnvifConf.ASToken[idx] == true_) 
		{
			p->AudioSourceConfiguration = 
				(struct tt__AudioSourceConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioSourceConfiguration));
			soap_default_tt__AudioSourceConfiguration (soap, p->AudioSourceConfiguration);
			p->AudioSourceConfiguration->Name = soap_malloc (soap, MAX_PROFILE_STR);
			p->AudioSourceConfiguration->Name[0] = '\0';
			strncpy (p->AudioSourceConfiguration->Name, AsPtr->Name, MAX_PROFILE_STR);
		
			AsPtr->UseCount = 0; 
			for(i=0; i<MAX_PROFILE_LIST; i++)
			{
				if(gOnvifConf.ASToken[i] == true_) 
					AsPtr->UseCount++;
			}
			p->AudioSourceConfiguration->UseCount = AsPtr->UseCount;
			p->AudioSourceConfiguration->token = soap_malloc (soap, MAX_TOKEN_STRLEN);
			p->AudioSourceConfiguration->token[0] = '\0';
			strncpy (p->AudioSourceConfiguration->token, AsPtr->token, MAX_TOKEN_STRLEN);
			p->AudioSourceConfiguration->SourceToken = soap_malloc (soap, MAX_TOKEN_STRLEN);
			p->AudioSourceConfiguration->SourceToken[0] = '\0';
			strncpy (p->AudioSourceConfiguration->SourceToken, AsPtr->SourceToken, MAX_TOKEN_STRLEN);
		}
	
		if(gOnvifConf.AEToken[idx] == true_) 
		{
			p->AudioEncoderConfiguration = 
				(struct tt__AudioEncoderConfiguration *) 
				soap_malloc(soap, sizeof(struct tt__AudioEncoderConfiguration));
			soap_default_tt__AudioEncoderConfiguration (soap, p->AudioEncoderConfiguration);
			PrepareAEConfig (soap, p->AudioEncoderConfiguration);
		}
	}
}

static void PreparePTZSpace (struct soap *soap, struct tt__PTZSpaces *PTZSpaces)
{
	int i = 0;

	/* RelativePanTiltTranslationSpace:
	 *    Add zoom enabled check here for workarouund Onvif Test Tool v13.06 PTZ-7-4-4 test, it needs
	 * pan/tilt absolute position address space for zoom lens only camera */
	if( ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) ||
	    ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)))
	{
		PTZSpaces->__sizeRelativePanTiltTranslationSpace = 1;
		PTZSpaces->RelativePanTiltTranslationSpace = 
			(struct tt__Space2DDescription *) soap_malloc(soap, sizeof(struct tt__Space2DDescription));
		PTZSpaces->RelativePanTiltTranslationSpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1); 
		snprintf(PTZSpaces->RelativePanTiltTranslationSpace[0].URI, MAX_NAMESPACE_LEN, "%s", gOnvifConf.PTZConfig.RelativePanTiltTranslationSpace); 
		for (i = 0; i < PTZSpaces->__sizeRelativePanTiltTranslationSpace; i++)
		{
			//XRange
			PTZSpaces->RelativePanTiltTranslationSpace[i].XRange =
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->RelativePanTiltTranslationSpace[i].XRange->Min = ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN]; 
			PTZSpaces->RelativePanTiltTranslationSpace[i].XRange->Max = ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX];
			//YRange
			PTZSpaces->RelativePanTiltTranslationSpace[i].YRange =
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->RelativePanTiltTranslationSpace[i].YRange->Min = ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN];
			PTZSpaces->RelativePanTiltTranslationSpace[i].YRange->Max = ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX];
		}
	}
	//RelativeZoomTranslationSpace
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZSpaces->__sizeRelativeZoomTranslationSpace = 1;
		PTZSpaces->RelativeZoomTranslationSpace = 
			(struct tt__Space1DDescription *) soap_malloc(soap, sizeof(struct tt__Space1DDescription) * 1);
		//w: PTZSpaces->RelativeZoomTranslationSpace[0].URI = "http://www.onvif.org/ver10/tptz/ZoomSpaces/PositionGenericSpace";
		PTZSpaces->RelativeZoomTranslationSpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZSpaces->RelativeZoomTranslationSpace[0].URI[0] = '\0'; 
		snprintf(PTZSpaces->RelativeZoomTranslationSpace[0].URI, MAX_NAMESPACE_LEN, "%s", gOnvifConf.PTZConfig.RelativeZoomTranslationSpace); 
		for (i=0; i<PTZSpaces->__sizeRelativeZoomTranslationSpace; i++)
		{
		    PTZSpaces->RelativeZoomTranslationSpace[i].XRange = 
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
		    PTZSpaces->RelativeZoomTranslationSpace[i].XRange->Min = ptzNormalRange[OPT_ZOOM_VELOCITY][LIMIT_MIN];
		    PTZSpaces->RelativeZoomTranslationSpace[i].XRange->Max = ptzNormalRange[OPT_ZOOM_VELOCITY][LIMIT_MAX];
		    L4("RelativeZoomSpace %f, %f\n", PTZSpaces->RelativeZoomTranslationSpace[i].XRange->Min,
			PTZSpaces->RelativeZoomTranslationSpace[i].XRange->Max);
		}
	}

	/* AbsolutePanTiltPositionSpace:
	 *    Add zoom enabled check here for workarouund Onvif Test Tool v13.06 PTZ-7-4-4 test, it needs
	 * pan/tilt absolute position address space for zoom lens only camera */
	if( ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) ||
	    ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)))
	{
		PTZSpaces->__sizeAbsolutePanTiltPositionSpace = 1;
		PTZSpaces->AbsolutePanTiltPositionSpace = 
			(struct tt__Space2DDescription *) soap_malloc(soap, sizeof(struct tt__Space2DDescription));
		PTZSpaces->AbsolutePanTiltPositionSpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1); 
		snprintf(PTZSpaces->AbsolutePanTiltPositionSpace[0].URI, MAX_NAMESPACE_LEN, "%s", gOnvifConf.PTZConfig.PanTiltLimits_URI); 
		for (i = 0; i < PTZSpaces->__sizeAbsolutePanTiltPositionSpace; i++)
		{
			//XRange
			PTZSpaces->AbsolutePanTiltPositionSpace[i].XRange =
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->AbsolutePanTiltPositionSpace[i].XRange->Min = ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN]; 
			PTZSpaces->AbsolutePanTiltPositionSpace[i].XRange->Max = ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX];
			//YRange
			PTZSpaces->AbsolutePanTiltPositionSpace[i].YRange =
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->AbsolutePanTiltPositionSpace[i].YRange->Min = ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN];
			PTZSpaces->AbsolutePanTiltPositionSpace[i].YRange->Max = ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX];
		}
	}
	//AbsoluteZoomPositionSpace
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZSpaces->__sizeAbsoluteZoomPositionSpace = 1;
		PTZSpaces->AbsoluteZoomPositionSpace = 
			(struct tt__Space1DDescription *) soap_malloc(soap, sizeof(struct tt__Space1DDescription) * 1);
		//w: PTZSpaces->AbsoluteZoomPositionSpace[0].URI = "http://www.onvif.org/ver10/tptz/ZoomSpaces/PositionGenericSpace";
		PTZSpaces->AbsoluteZoomPositionSpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		PTZSpaces->AbsoluteZoomPositionSpace[0].URI[0] = '\0'; 
		snprintf(PTZSpaces->AbsoluteZoomPositionSpace[0].URI, MAX_NAMESPACE_LEN, "%s", gOnvifConf.PTZConfig.ZoomLimits_URI); 
		for (i=0; i<PTZSpaces->__sizeAbsoluteZoomPositionSpace; i++)
		{
		    PTZSpaces->AbsoluteZoomPositionSpace[i].XRange = 
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
		    PTZSpaces->AbsoluteZoomPositionSpace[i].XRange->Min = ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MIN];
		    PTZSpaces->AbsoluteZoomPositionSpace[i].XRange->Max = ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MAX];
		    L4("AbsZoomSpace %f, %f\n", PTZSpaces->AbsoluteZoomPositionSpace[i].XRange->Min,
			PTZSpaces->AbsoluteZoomPositionSpace[i].XRange->Max);
		}
	}

    /* continue PT movement */
	if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_))
	{
		PTZSpaces->__sizeContinuousPanTiltVelocitySpace = 1;
		PTZSpaces->ContinuousPanTiltVelocitySpace =
			(struct tt__Space2DDescription *) soap_malloc(soap, sizeof(struct tt__Space2DDescription));
		PTZSpaces->ContinuousPanTiltVelocitySpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		snprintf(PTZSpaces->ContinuousPanTiltVelocitySpace[0].URI, MAX_NAMESPACE_LEN, "%s",
                 gOnvifConf.PTZConfig.ContinuousPanTiltVelocitySpace);
		for (i=0; i<PTZSpaces->__sizeContinuousPanTiltVelocitySpace; i++)
		{
			//XRange
			PTZSpaces->ContinuousPanTiltVelocitySpace[i].XRange =
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->ContinuousPanTiltVelocitySpace[i].XRange->Min = ptzNormalRange[OPT_PAN_VELOCITY][LIMIT_MIN]; 
			PTZSpaces->ContinuousPanTiltVelocitySpace[i].XRange->Max = ptzNormalRange[OPT_PAN_VELOCITY][LIMIT_MAX];
			//YRange
			PTZSpaces->ContinuousPanTiltVelocitySpace[i].YRange =
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->ContinuousPanTiltVelocitySpace[i].YRange->Min = ptzNormalRange[OPT_TILT_VELOCITY][LIMIT_MIN]; 
			PTZSpaces->ContinuousPanTiltVelocitySpace[i].YRange->Max = ptzNormalRange[OPT_TILT_VELOCITY][LIMIT_MAX]; 
		}
	}
	//ContinuousZoomVelocitySpace
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZSpaces->__sizeContinuousZoomVelocitySpace = 1;
		PTZSpaces->ContinuousZoomVelocitySpace = 
			(struct tt__Space1DDescription *) soap_malloc(soap, sizeof(struct tt__Space1DDescription));
		PTZSpaces->ContinuousZoomVelocitySpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1); 
		snprintf(PTZSpaces->ContinuousZoomVelocitySpace[0].URI, MAX_NAMESPACE_LEN, "%s",
			 gOnvifConf.PTZConfig.ContinuousZoomVelocitySpace);
		for(i=0; i<PTZSpaces->__sizeContinuousZoomVelocitySpace; i++)
		{
			PTZSpaces->ContinuousZoomVelocitySpace[i].XRange = 
				(struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->ContinuousZoomVelocitySpace[i].XRange->Min = ptzNormalRange[OPT_ZOOM_VELOCITY][LIMIT_MIN]; 
			PTZSpaces->ContinuousZoomVelocitySpace[i].XRange->Max = ptzNormalRange[OPT_ZOOM_VELOCITY][LIMIT_MAX];
			L4("ContinueZoomSpeedSpace %f, %f\n", PTZSpaces->ContinuousZoomVelocitySpace[i].XRange->Min,
			    PTZSpaces->ContinuousZoomVelocitySpace[i].XRange->Max);
		}
	}
	//PanTiltSpeedSpace
	if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_))
	{
		PTZSpaces->__sizePanTiltSpeedSpace = 1;
		PTZSpaces->PanTiltSpeedSpace = (struct tt__Space1DDescription *) 
			soap_malloc(soap, sizeof(struct tt__Space1DDescription) * 1);
		PTZSpaces->PanTiltSpeedSpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1); 
		snprintf (PTZSpaces->PanTiltSpeedSpace[0].URI, MAX_NAMESPACE_LEN, "%s",
                 gOnvifConf.PTZConfig.PTDefaultSpeedSpace);
		for(i=0; i<PTZSpaces->__sizePanTiltSpeedSpace; i++)
		{
			PTZSpaces->PanTiltSpeedSpace[i].XRange = (struct tt__FloatRange *) soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->PanTiltSpeedSpace[i].XRange->Min = ptzNormalRange[OPT_PAN_SPEED][LIMIT_MIN]; 
			PTZSpaces->PanTiltSpeedSpace[i].XRange->Max = ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX]; 
		}
	}
	//ZoomSpeedSpace
	if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		PTZSpaces->__sizeZoomSpeedSpace = 1;	
		PTZSpaces->ZoomSpeedSpace = (struct tt__Space1DDescription *) soap_malloc(soap, sizeof(struct tt__Space1DDescription) * 1);
		PTZSpaces->ZoomSpeedSpace[0].URI = (char *) soap_malloc (soap, MAX_NAMESPACE_LEN+1);
		snprintf(PTZSpaces->ZoomSpeedSpace[0].URI, MAX_NAMESPACE_LEN, "%s", gOnvifConf.PTZConfig.ZoomDefaultSpeedSpace); 
		for(i=0; i<PTZSpaces->__sizeZoomSpeedSpace; i++)
		{
			PTZSpaces->ZoomSpeedSpace[i].XRange = (struct tt__FloatRange *) 
				soap_malloc(soap, sizeof(struct tt__FloatRange));
			PTZSpaces->ZoomSpeedSpace[i].XRange->Min = ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MIN]; 
			PTZSpaces->ZoomSpeedSpace[i].XRange->Max = ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX]; 
			L4("ZoomSpeedSpace %f,%f\n", PTZSpaces->ZoomSpeedSpace[i].XRange->Min, PTZSpaces->ZoomSpeedSpace[i].XRange->Max);
		}
	}
}

static int DiscoverySoapFault (struct soap *soap)
{
	soap->header->wsa__RelatesTo = (struct wsa__RelatesToType *) soap_malloc (soap, sizeof (struct wsa__RelatesToType));
	soap_default_wsa__RelatesToType (soap, soap->header->wsa__RelatesTo);
	soap->header->wsa__RelatesTo->__item = soap->header->wsa__MessageID.__item;
{ // modify by alexcheng
	static char uuid[MAX_UUID_LEN];
	soap->header->wsa__MessageID.__item = uuid;
	GenerateUUiD(soap->header->wsa__MessageID.__item);
//	soap->header->wsa__MessageID.__item = NULL;
}
	soap->header->wsa__To.__item = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
	soap->header->wsa__Action.__item = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault";
	return soap_sender_fault_subcode (soap, "d:MatchingRuleNotSupported",
									  "The matching rule specified is not supported",
									  "<d:SupportedMatchingRules>http://schemas.xmlsoap.org/ws/2005/04/discovery/rfc3986</d:SupportedMatchingRules>");

}
static int GetVeConfIndexByEncoderVideoSrc(Acti_VideoEncoderConfig *veConf, int encoder, int videoSrc) {
    int i = 0;
    
    for(i = 0 ; i < MAX_VE_LIST ; i ++) {
        if(veConf[i].valid == 1) {
            if((veConf[i].Encoding == encoder) && (veConf[i].videoSrc == videoSrc)) {
                /* found */
                return i;
            }
        }
    }
    return -1;
}
static void InitMediaProfileParameters(Acti_MediaProfile *profile, int veIdx) {
    Acti_VideoEncoderConfig *veConf = &gOnvifConf.veConf[veIdx];
    
    snprintf(profile->Name, MAX_PROFILE_STR, "p_%s", veConf->Name);
    snprintf(profile->token, MAX_PROFILE_STR, "t%s", profile->Name);
    profile->vsIdx = veConf->videoSrc-1; /* veConf->videoSrc started from 1 but profile->vsIdx started from 0 */
    profile->veIdx = veIdx; /* profile->veIdx started from 0 */
    profile->readOnly = 0; /* by default */
    profile->valid = 1;
    /* update the vsConf and veConf used count */
    gOnvifConf.vsConf[profile->vsIdx].UseCount ++;
    veConf->videoSrcInProfile = veConf->videoSrc;
    veConf->UseCount ++;
}
static void CreateMediaProfiles (void) {
    int i = 0;
    int veIdx = 0;
    int addPTZ = 0;
    Acti_MediaProfile *profile = NULL;
    
    /* reset the video source, video encoder and metadata used count in the vsConf, veConf */
    for (i = 0; i < MAX_VS_LIST; i++)   gOnvifConf.vsConf[i].UseCount = 0;
    for (i = 0; i < MAX_VE_LIST; i++)   gOnvifConf.veConf[i].UseCount = 0;
    
    if( (gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_) ||
        (gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) addPTZ = 1;

    /* create the media profiles, align with encders */
    gOnvifConf.ProfileCnt = 0;
    for(i = 0 ; i < MAX_PROFILE_LIST ; i ++) {
	gOnvifConf.profile[i].valid = 0;
        gOnvifConf.profile[i].readOnly = 0;
        gOnvifConf.profile[i].Name[0] = '\0';
        gOnvifConf.profile[i].token[0] = '\0';
        gOnvifConf.profile[i].vsIdx = -1;
        gOnvifConf.profile[i].veIdx = -1;
    }
    if(gOnvifConf.H264_Enable == true_) {
        for(i = 1 ; i <= gOnvifConf.numStreams ; i ++) {
            /* add media profiles with H.264 encoders. */
            profile = &gOnvifConf.profile[gOnvifConf.ProfileCnt];
            veIdx = GetVeConfIndexByEncoderVideoSrc(gOnvifConf.veConf, H264, i);
            if((veIdx >= 0) && (veIdx < MAX_VE_LIST)) {
                InitMediaProfileParameters(profile, veIdx);
                if(addPTZ) gOnvifConf.PTZ_AddToken[gOnvifConf.ProfileCnt] = true_;
                if(gOnvifConf.AudioEnable == true_) {
                    gOnvifConf.ASToken[gOnvifConf.ProfileCnt] = true_;
                    gOnvifConf.AEToken[gOnvifConf.ProfileCnt] = true_;
                }
                gOnvifConf.ProfileCnt ++;
            } else {
		fprintf(stderr, "%s:error, not found H264,%d for profile %d\n", __func__,
			i, gOnvifConf.ProfileCnt);
	    }
       }
    }
    if (gOnvifConf.MJPEG_Enable == true_) {
        for(i = 1 ; i <= gOnvifConf.numStreams ; i ++) {
            /* add two media profiles with MJPEG encoders. */
            profile = &gOnvifConf.profile[gOnvifConf.ProfileCnt];
            veIdx = GetVeConfIndexByEncoderVideoSrc(gOnvifConf.veConf, JPEG, i);
            if((veIdx >= 0) && (veIdx < MAX_VE_LIST)) {
                InitMediaProfileParameters(profile, veIdx);
                if(addPTZ) gOnvifConf.PTZ_AddToken[gOnvifConf.ProfileCnt] = true_;
                if(gOnvifConf.AudioEnable == true_) {
                    gOnvifConf.ASToken[gOnvifConf.ProfileCnt] = true_;
                    gOnvifConf.AEToken[gOnvifConf.ProfileCnt] = true_;
                }
                gOnvifConf.ProfileCnt ++;
            } else {
		fprintf(stderr, "%s:error, not found MJPEG,%d for profile %d\n", __func__,
			i, gOnvifConf.ProfileCnt);
	    }
        }
    }
    if (gOnvifConf.MPEG4_Enable == true_) {
        for(i = 1 ; i <= gOnvifConf.numStreams ; i ++) {
            /* add two media profiles with MJPEG encoders. */
            profile = &gOnvifConf.profile[gOnvifConf.ProfileCnt];
            veIdx = GetVeConfIndexByEncoderVideoSrc(gOnvifConf.veConf, MPEG4, i);
            if((veIdx >= 0) && (veIdx < MAX_VE_LIST)) {
                InitMediaProfileParameters(profile, veIdx);
                if(addPTZ) gOnvifConf.PTZ_AddToken[gOnvifConf.ProfileCnt] = true_;
                if(gOnvifConf.AudioEnable == true_) {
                    gOnvifConf.ASToken[gOnvifConf.ProfileCnt] = true_;
                    gOnvifConf.AEToken[gOnvifConf.ProfileCnt] = true_;
                }
                gOnvifConf.ProfileCnt ++;
            } else {
		fprintf(stderr, "%s:error, not found MPEG4,%d for profile %d\n", __func__,
			i, gOnvifConf.ProfileCnt);
	    }
        }
    }
}

static int onvif_check_scope_prefix_path(char *input_string, char *prefix_path)
{
  int processing_length;
  char scope_path_thring [MAX_SCOPES_STRLEN];
int ret=0;

  for( processing_length =  0;
       processing_length <  strlen ( input_string );
       processing_length += strlen ( scope_path_thring ) + 1 )
  {
    scope_path_thring [0] = 0x0;

    /* get each segment */
    sscanf ( input_string + processing_length, "%s", scope_path_thring );

    /* check prefix path */
    if ( !memcmp ( scope_path_thring, prefix_path, strlen ( prefix_path ) ) )
      ret = 1;

  }
  return ret;
}

static int onvif_check_scope_prefix_name(char *input_string, char *prefix_path)
{
  int processing_length;
  char scope_path_thring [MAX_SCOPES_STRLEN];
  int prefix_path_length;

  prefix_path_length = strlen(prefix_path);

  for( processing_length =  0;
       processing_length <  strlen ( input_string );
       processing_length += strlen ( scope_path_thring ) + 1 )
  {
    scope_path_thring [0] = 0x0;

    /* get each segment */
    sscanf ( input_string + processing_length, "%s", scope_path_thring );

    /* check prefix path */
    if ( memcmp ( scope_path_thring, prefix_path, strlen ( prefix_path ) ) )
      return 0;

    if ( memcmp( scope_path_thring + prefix_path_length, "type", 4) &&
         memcmp( scope_path_thring + prefix_path_length, "location", 8) &&
         memcmp( scope_path_thring + prefix_path_length, "hardware", 8) &&
         memcmp( scope_path_thring + prefix_path_length, "name", 4) )
      return 0;
  }

  return 1;
}

int check_match(char *first_input, char *second_input)
{
  int first_index = 0;
  int second_index = 0;

//  int first_len = 0;
//  int second_len = 0;

  char first_string[MAX_SCOPES_STRLEN];
  char second_string[MAX_SCOPES_STRLEN];

  int first_input_len;
  int second_input_len;

  int have_same = 0;

  first_input_len = strlen(first_input);
  second_input_len = strlen(second_input);

  for ( first_index = 0;
        first_index < first_input_len;
        first_index = first_index + strlen(first_string) + 1 )
  {
    	sscanf ( first_input + first_index, "%s", first_string );

    	for ( second_index = 0;
          	second_index < second_input_len;
          	second_index = second_index + strlen(second_string) + 1 )
    	{
      		sscanf ( second_input + second_index, "%s", second_string );

      		if ( !strcmp(first_string, second_string) )
		{
        		have_same = 1;
		}
    	}
  }
  return have_same;

}

static int OnvifHttpdConnect (int *sock, tHttpSrvDB * httpd, tCdrMsg * dmsg)
{
	struct sockaddr_in addr;
	int ret = 0;
	struct timeval tv;

	/* create the TCP socket */
	if (TcpSockCreate (sock) == ERR) {
		return ERR;
	}
	if (SockOptReuseAddrSet (*sock, ONVIF_SOCK_OPT_ENABLE) == ERR) {
		return ERR;
	}
	tv.tv_sec = 60;
	tv.tv_usec = 0;
	setsockopt (*sock, SOL_SOCKET, SO_SNDTIMEO, &tv, sizeof (tv));
	setsockopt (*sock, SOL_SOCKET, SO_RCVTIMEO, &tv, sizeof (tv));
	/* setup the address of the httpd */
	if (IPv4AddrResolution (&addr, httpd->addr, httpd->port) == OK) {
		ret = SockNonblockingConnect (*sock, &addr, (httpd->time * 1000));
		if (ret == OK)
			return OK;
		if (ret == ERR_TIMEOUT) {
			L1 ("Error. connect %s:%d timeout %d sec\n", httpd->addr, httpd->port, httpd->time);
		} else {
			L1 ("Error. connect %s:%d %s\n", httpd->addr, httpd->port, strerror (errno));
		}
	} else {
		L1 ("Error, invalid addr %s:%d\n", httpd->addr, httpd->port);
	}
	/* close the socket */
	if (*sock > 0)
		SockClose (sock);
	L1 ("Err\n");
	return ERR;
}

static int OnvifHttpAuthenGet (tHttpSrvDB * srv, char *auth, tCdrMsg * dmsg)
{

	if (strlen (srv->name)) {
		if (Base64AccountEncode (srv->name, srv->pwd, auth) == ERR) {
			L1 ("Error. base64 %s:%s\n", srv->name, srv->pwd);
			return ERR;
		}
	} else
		auth[0] = '\0';
	return OK;
}

static int OnvifUrlCmdSend (int *sock, tHttpSrvDB * srv, tUrlDB *url, tCdrMsg * dmsg)
{
	char buf[1024];
	char auth[256];
	int len = 0;
	int tLen = 0;

	if (OnvifHttpAuthenGet (srv, auth, dmsg) == ERR)
		goto OnvifUrlCmdSendERR;

	/* build the URL commands */
	len = sprintf (buf,
				   "GET /cgi-bin/%s?USER=%s&PWD=%s&%s HTTP/1.1\r\n"
				   "HOST: %s:%d\r\n"
				   "User-Agent: Mozilla/4.0 (compatible: MISE 6.0; Windows NT 5.1; SV1)\r\n"
				   "Accept: */*\r\n" "Connection: Keep-Alive\r\n", \
				   url->cgi, srv->name, srv->pwd, url->cmd, srv->addr, srv->port);
	if (strlen (auth)) {
		/* add the authentication header */
		len += sprintf (&buf[len], "Authorization: Basic %s\r\n\r\n", auth);
	} else {
		len += sprintf (&buf[len], "\r\n");
	}
	/* send this command out */
	tLen = send (*sock, buf, len, 0);
	if (tLen == len)
		return OK;
	L1 ("Error. send %d/%d. %s\n", tLen, len, strerror (errno));
 OnvifUrlCmdSendERR:
	L1 ("Err\n");
	if (*sock > 0)
		SockClose (sock);
	return ERR;
}

static int OnvifUrlCmdWaitReply (int sock, int msec, char *ReplyMsg, int MaxLen)
{
	int len = 0;
//int rlen = 0; 
	char buf[512];

	if(ReplyMsg == NULL) return ERR;
	buf[0] = '\0';
	ReplyMsg[0] = '\0';
	/* non-blocking to get the reply from remote httpd */
	if (msec == 0)
		msec = 30000;			/* 30 seconds */
	if (HttpReplyHeaderGet (sock, buf, sizeof (buf) -1, msec) != OK)
		return ERR;

	strncpy(ReplyMsg, buf, MaxLen - 1);
/// Top of MY
/*
	ReplyMsg[0] = '\0';
	do {
		len = TcpSockNonBlockRead (sock, &ReplyMsg[rlen], (MaxLen-rlen-1), msec);
		if(len > 0) {
			rlen += len;
			ReplyMsg[rlen] = '\0';
		}
	} while(len > 0);
*/
/// Bottom of MY
	ReplyMsg[MaxLen - 1] = '\0';

	do{
		buf[0] = '\0';
		len = TcpSockNonBlockRead (sock, (unsigned char *)buf, sizeof(buf), msec);
		if (len > 0) {
			buf[len]='\0';
			if((strlen(ReplyMsg) + len) >= (MaxLen - 1))
				break;
			strcat(ReplyMsg, buf);
		}
	}while(len > 0);
	//L4 ("ReplyMsg = \n%s\n", ReplyMsg);

	return OK;
}

#if 1
static int POSIX_TZStringParser(char *TZString, int *index)
{
	int i = 0;

	for (i=0; i < sizeof(aTZ)/sizeof(aTZ[0]); i++)
	{
		if(strcmp(aTZ[i].POSIX_TZString, TZString) == 0)
		{
			*index = i;
			return OK;
		}
	}

	return ERR;
}

static int TimeZoneStringParser(char *TZ, int *index)
{
	int i = 0;

	for (i=0; i < sizeof(aTZ)/sizeof(aTZ[0]); i++)
	{
		if(strcmp(aTZ[i].TZ, TZ) == 0)
		{
			*index = i;
			return OK;
		}
	}

	return ERR;
}
#endif
static int OnvifReplyMsgParser(char *cmd, char *ReplyMsg, char *pValue)
{
	char *pCmd = NULL;
	char *pEnd = NULL;
	char *pHead = NULL;
	int len = 0;
    
	if((cmd == NULL) || (ReplyMsg == NULL) || (pValue == NULL)) return ERR;

	pCmd = strstr(ReplyMsg, cmd);
	if(pCmd == NULL) return ERR;
	
	pHead = strchr(pCmd, '\'');
	if(pHead == NULL) return ERR;
	pHead++;
    
	pEnd = strchr(pHead, '\'');
	if(pEnd == NULL) return ERR;

	len = pEnd - pHead;
	if(len == 0) {
        pValue[0]='\0';
        return OK;
    }
	strncpy(pValue, pHead, len);
	pValue[len]='\0';
	return OK;
}

static int GetAvailablePresetEntry(int *idxPreset)
{
	char ReplyMsg[8192];
    char *s = ReplyMsg;
	char *p = NULL;
	char *e = NULL;
	int  i = 1;
    
    if(OnvifSingleUrlCmdSend("encoder", "PTZ_PRESET_GET", ReplyMsg, sizeof(ReplyMsg)-1) > 0) {
        for(i = 1; i <= gOnvifConf.PTZConfig.maxPresetPoints; i++) {
            p = strstr(s, "PTZ_PRESET_GET=");
            if(p) {
                p += strlen("PTZ_PRESET_GET=");
                if(*p == '\'') p ++;
                if(*p == '\'') {  /* no valid preset entry, use the first entry */
                    *idxPreset = 1;
                    return 0;
                }
                e = strchr(p, ',');
                if(e) {
                    *e = '\0';
                    if(atoi(p) != i) {
                        *idxPreset = i;
                        return 0;
                    }
                    /* this preset entry is vaild, try next one */
                    s = e + 1;
                } else {
                    if(*p == '\'') {
                        *idxPreset = i;
                        return 0;
                    } else return -1;
                }
            } else {
                *idxPreset = i;
                return 0;
            }
        }
        L1("error, no free preset entry\n");
    }
    return -1;
}

static int OnvifParserSystemInfo(char *cmd, char *ReplyMsg, char *pValue)
{
	char *pCmd = NULL;
	char *pEnd = NULL;
	char *pHead = NULL;
	int len = 0;
	char *pNext = NULL;

	pValue [0] = '\0';
	pNext = ReplyMsg;
	do {
		if(cmd == NULL || pNext == NULL) 	return ERR;
		pCmd = strcasestr(pNext, cmd); //w
		if(pCmd == NULL) return ERR;
		//if (!(*(pCmd-1) == '\n' && (*(pCmd+strlen(cmd)+1) == '=' || *(pCmd+strlen(cmd)+2) == '=')))
		if (!(*(pCmd+strlen(cmd)+1) == '=' || *(pCmd+strlen(cmd)+2) == '='))
	        {
	                pNext = pCmd + strlen (cmd);
	                continue;
	        }
	
		pHead = strchr(pCmd, '=');
		if(pHead == NULL) return ERR;
	
		pHead=pHead+2;
		pEnd = strchr(pHead, '\n');
		if(pEnd == NULL) return ERR;
	
		len = pEnd - pHead;
		if(len == 0) return ERR;
		break;
	} while (pNext != NULL && (pNext < (ReplyMsg + strlen(ReplyMsg)))); 
	strncpy(pValue, pHead, len);
	pValue[len]='\0';
	if((pValue == NULL) || (pValue[0] == '\0')) return ERR;
	return OK;
}

static int OnvifCmdAdd (tUrlDB *url, char *cmd)
{
	if((cmd == NULL) || (url == NULL)) return ERR;

	if(url->cmd[0] != '\0')
		strcat(url->cmd, "&");

	strcat(url->cmd, cmd);
	return OK;
}

static int OnvifCmdSend (tUrlDB *url, char *ReplyMsg, int MaxLen)
{
	int sock = 0;
	tCdrMsg msg;
	tHttpSrvDB httpd;

	httpd.state = ENABLE; 
	sprintf(httpd.addr, "127.0.0.1");
	snprintf(httpd.name, sizeof(httpd.name), "%s", gOnvifConf.root);
	snprintf(httpd.pwd, sizeof(httpd.pwd), "%s", gOnvifConf.passwd);
	httpd.port = gOnvifConf.HttpPort; 
	httpd.time = 30;

	/* create a TCP socket to connect to the http server now */
	if (OnvifHttpdConnect (&sock, &httpd, &msg) == ERR) goto OnvifCmdSendErr;
	/* connect to the httpd successfully, send the URL to the device now */
	if (OnvifUrlCmdSend (&sock, &httpd, url, &msg) == ERR) goto OnvifCmdSendErr;
	/* send the URL command successfully, wait for the reply. */
	if( OnvifUrlCmdWaitReply (sock, (httpd.time*1000), ReplyMsg, MaxLen) == ERR) goto OnvifCmdSendErr;
    
    SockClose (&sock);
	return OK;

OnvifCmdSendErr:
	L1 ("Err leave\n");
	if (sock > 0) SockClose (&sock);
	return ERR;
}

static int parserTimeInterval(char *TerminationTime, int *timeInterval)
{
	char *pLeft = NULL;
	char *pRight = NULL;
	char buf[64];
	int year = 0;
	int day = 0;
	int hour = 0;
	int min = 0;
	int sec = 0;

	if((TerminationTime == NULL) || (timeInterval == NULL)) {
        L1("error, TerminationTime or timeInterval is NULL\n");
        return ERR;
    }

	pLeft = strstr(TerminationTime, "PT");
	if (pLeft == NULL) {
        L1("error, not found PT in the TerminationTime %s\n", TerminationTime);
        return ERR;
    }
	pLeft = pLeft+2;   
    snprintf(buf, sizeof(buf), "%s", pLeft);
    
	pRight = strrchr(buf, 'Y');
	if (pRight != NULL) 
	{
		buf[pRight - buf] = '\0';
		year = atoi(buf);
		pRight++;
		pLeft = pRight;
		strcpy(buf, pLeft);
	}
	// D
	pRight = strrchr(buf, 'D');
	if (pRight != NULL) 
	{
		buf[pRight - buf] = '\0';
		day = atoi(buf);
		pRight++;
		pLeft = pRight;
		strcpy(buf, pLeft);
	}
	// H
	pRight = strrchr(buf, 'H');
	if (pRight != NULL) 
	{
		buf[pRight - buf] = '\0';
		hour = atoi(buf);
		pRight++;
		pLeft = pRight;
		strcpy(buf, pLeft);
	}
	// M
	pRight = strrchr(buf, 'M');
	if (pRight != NULL) 
	{
		buf[pRight - buf] = '\0';
		min = atoi(buf);
		pRight++;
		pLeft = pRight;
		strcpy(buf, pLeft);
	}
	// S
	pRight = strrchr(buf, 'S');
	if (pRight != NULL) 
	{
		buf[pRight - buf] = '\0';
		sec = atoi(buf);
	}
	*timeInterval = (((year*365+day)*24+hour)*60+min)*60+sec;
	//L2("timeInterval = %d sec\n", *timeInterval);
	return OK;
}

static int parserTimeString(char *TimeString, time_t *TerminationTime)
{
	struct tm tm1;

	if((TimeString == NULL) || (TerminationTime == NULL)) return ERR;
	//L2("%s\n", TimeString);
	if (sscanf (TimeString, "%4d-%2d-%2dT%2d:%2d:%2dZ", 
			&tm1.tm_year, &tm1.tm_mon, &tm1.tm_mday, &tm1.tm_hour, &tm1.tm_min, &tm1.tm_sec) != 6) return ERR;
	tm1.tm_year -= 1900;
	tm1.tm_mon --;
	tm1.tm_isdst=-1;

	*TerminationTime = mktime(&tm1);

	return OK;
}

static int parserTopicExpression(char *TopicExpression, enum EventTopic *Topic)
{
	char *pLeft = NULL;
	char *pMiddle = NULL;
	char *pRight = NULL;

	if((TopicExpression == NULL) || (Topic == NULL)) return ERR;

	pLeft = strstr(TopicExpression, "tns1:");
	if (pLeft == NULL) return ERR;
	pLeft = pLeft+5;

	pRight = strstr(TopicExpression, "tnsacti:");
	if (pRight == NULL)
	{
		pRight = strchr(pLeft, '/');
		pRight = pRight+1;
	}
	else
		pRight = pRight+8;
	
	pMiddle = strchr(TopicExpression, '/');
	if (pMiddle == NULL) return ERR;
	TopicExpression[pMiddle - TopicExpression]= '\0';

	if((strcmp(pLeft, "VideoAnalytics") == 0) && (strncmp(pRight, "MotionDetection", 15) == 0))
		*Topic = EVENT_TOPIC_MD; 
	else if((strcmp(pLeft, "Device") == 0) && (strncmp(pRight, "IO", 2) == 0))
		*Topic = EVENT_TOPIC_DI; 
	else
		return ERR;
	
	return OK;
}

static int parserMessageContent(char *MessageContent, enum EventTopic Topic, enum MsgContent *Msg)
{
	char *pLeft = NULL;
	char *pRight = NULL;
	char *pEnd = NULL;

	if((MessageContent == NULL) || (Msg == NULL)) return ERR;

	pLeft = strstr(MessageContent, "tns1:");
	if (pLeft == NULL) return ERR;

	pLeft = strchr(MessageContent, '@');
	if (pLeft == NULL) return ERR;
	pLeft = pLeft+1;

	pRight = strchr(MessageContent, '=');
	if (pRight == NULL) return ERR;
	MessageContent[pRight - MessageContent] = '\0';
	pRight = pRight+2;

	pEnd = strchr(pRight, '\"');
	if (pEnd == NULL) return ERR;
	pRight[pEnd - pRight] = '\0';

	if( ((Topic == EVENT_TOPIC_MD) || (Topic == EVENT_TOPIC_ALL))
	   && (strcmp(pLeft, "window") == 0))
	{
		if(strcmp(pRight, "1") == 0)
			*Msg = EVENT_MSG_WINDOW_1; 
		if(strcmp(pRight, "2") == 0)
			*Msg = EVENT_MSG_WINDOW_2;
		if(strcmp(pRight, "3") == 0)
			*Msg = EVENT_MSG_WINDOW_3;
	}
	else if( ((Topic == EVENT_TOPIC_DI) || (Topic == EVENT_TOPIC_ALL))
		&&(strcmp(pLeft, "DI") == 0))
	{
		if(strcmp(pRight, "1") == 0)
			*Msg = EVENT_MSG_DI_1;
		if(strcmp(pRight, "2") == 0)
			*Msg = EVENT_MSG_DI_2;
		if(strcmp(pRight, "3") == 0)
			*Msg = EVENT_MSG_DI_3;
		if(strcmp(pRight, "4") == 0)
			*Msg = EVENT_MSG_DI_4;
	}
	else
		return ERR;
	
	return OK;
	
}

static int checkTimeInterval(int index)
{
	struct timeval tv;
	time_t CurrentTime;

	if(gOnvifConf.scription[index].TerminationTime > 0) {
		gettimeofday(&tv, NULL);
		CurrentTime = tv.tv_sec;
		if ((CurrentTime >= gOnvifConf.scription[index].BeginTime) &&
	   		(CurrentTime < gOnvifConf.scription[index].TerminationTime) ) {
			/* not expired */
			return OK;
		}
		return ERR;
	}
	/* termination time is 0 means there is not time expired condition, need remote host to leave */
	return OK;
}

//void Notify (int index, int topic, int id, int value)
void Notify (int index, EventMsg *OutputEMsg)
{
	struct soap soap;
	struct SOAP_ENV__Header header;
	struct _wsnt__Notify wsnt__Notify;
	struct wsnt__NotificationMessageHolderType NotificationMessage;
	struct wsnt__TopicExpressionType Topic;	
	struct wsa__EndpointReferenceType ProducerReference;	
	struct _tt__Message Message;
	struct tt__ItemList Source;	
	struct tt__ItemList Data;
	struct _tt__ItemList_SimpleItem SimpleItem_Source;
	struct _tt__ItemList_SimpleItem SimpleItem_Data;
	//struct timeval tv;
	char item[MAX_UUID_LEN];


	if(OutputEMsg == NULL)
	{
		L1("OutputEMsg ==NULL");
		return;
	}

	soap_init (&soap);
	soap_set_namespaces (&soap, notifynamespaces);
	soap.connect_flags = SO_BROADCAST;
	soap.send_timeout = 1;		// 1s timeout
	soap_default_SOAP_ENV__Header (&soap, &header);
	soap.header = &header;

	GenerateUUiD (item);
	header.SubscriptionId = gOnvifConf.scription[index].SubscriptionId;
	header.wsa__To.__item = (char *) soap_malloc (&soap, 256);
	strcpy(header.wsa__To.__item, gOnvifConf.scription[index].NotifyServer);
	header.wsa__Action.__item = "http://docs.oasis-open.org/wsn/bw-2/NotificationConsumer/Notify";
	// AppSequence
	gOnvifConf.AppSequence.MessageNumber++;
	// Noify
	soap_default__wsnt__Notify(&soap, &wsnt__Notify);
	//	NotificationMessage
	wsnt__Notify.__sizeNotificationMessage = 1;
	wsnt__Notify.NotificationMessage = &NotificationMessage;
	soap_default_wsnt__NotificationMessageHolderType(&soap, &NotificationMessage);
	//		Topic
	NotificationMessage.Topic = &Topic;
	soap_default_wsnt__TopicExpressionType(&soap, &Topic);
	Topic.Dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple";
	//		ProducerReference
	NotificationMessage.ProducerReference = &ProducerReference;
	soap_default_wsa__EndpointReferenceType(&soap, &ProducerReference);
	ProducerReference.Address = (struct wsa__AttributedURIType *) soap_malloc (&soap, sizeof (struct wsa__AttributedURIType) * 1);
	ProducerReference.Address->__item = (char *) soap_malloc (&soap, 64);
	sprintf (ProducerReference.Address->__item, "uri://%s/ProducerReference", item+5);
	//		Message
	soap_default__wsnt__NotificationMessageHolderType_Message(&soap, &NotificationMessage.Message);
	//			tt__Message
	NotificationMessage.Message.tt__Message = &Message;
	soap_default__tt__Message (&soap, &Message);
	//				Source		
	Message.Source = &Source;
	soap_default_tt__ItemList(&soap, &Source);
	Source.__sizeSimpleItem = 1; 
	Source.SimpleItem = &SimpleItem_Source;
	soap_default__tt__ItemList_SimpleItem(&soap, &SimpleItem_Source);
	//				Data
	Message.Data = &Data;
	soap_default_tt__ItemList(&soap, &Data);
	Data.__sizeSimpleItem = 1; 
	Data.SimpleItem = &SimpleItem_Data;
	soap_default__tt__ItemList_SimpleItem(&soap, &SimpleItem_Data);

	if((OutputEMsg->NotifyEvent >= EVENT_MSG_DI_1) && (OutputEMsg->NotifyEvent <= EVENT_MSG_DI_8)){
		//Set DI Message Response Data
		Topic.__any = OnvifDeviceVirtualPort;
		SimpleItem_Source.Name = VirtualPor_source_Name;
		SimpleItem_Source.Value = Data_Value[OutputEMsg->NotifyEvent - EVENT_MSG_DI_1 + 1];
		SimpleItem_Data.Name =  VirtualPor_data_Name;
		SimpleItem_Data.Value = Data_Value[OutputEMsg->trigger];
		Message.UtcTime = OutputEMsg->TimeStamp.tv_sec; 
		Message.UtcTime_usec = OutputEMsg->TimeStamp.tv_usec; 
	}else if((OutputEMsg->NotifyEvent >= EVENT_MSG_WINDOW_1) && (OutputEMsg->NotifyEvent <= EVENT_MSG_WINDOW_3)){
		//Set MD Message Response Data
		Topic.__any = OnvifDeviceMotion;
		SimpleItem_Source.Name = Motion_source_Name; 
		SimpleItem_Source.Value = Data_Value[OutputEMsg->NotifyEvent - EVENT_MSG_WINDOW_1 + 1]; 
		SimpleItem_Data.Name =  Motion_data_Name; 
		SimpleItem_Data.Value = Data_Value[OutputEMsg->trigger]; 
		Message.UtcTime = OutputEMsg->TimeStamp.tv_sec; 	
		Message.UtcTime_usec = OutputEMsg->TimeStamp.tv_usec; 
	}else
		goto DESTROY_SOAP;
		//return;

	L4("Send Notify to = %s\n", gOnvifConf.scription[index].NotifyServer);	
	if (soap_send___ns7__Notify(&soap, gOnvifConf.scription[index].NotifyServer, NULL, &wsnt__Notify)) 
		soap_print_fault (&soap, stderr);
DESTROY_SOAP:
	soap_destroy (&soap);		// cleanup
	soap_end (&soap);		// cleanup
	soap_done (&soap);		// close connection (should not use soap struct after this)
	return;
}

static void *OnvifSubscriptionThread(void *arg) {
	int index = 0;
	int sock = 0;
	int i = 0;
	int MessageCnt=0;
	EventMsg OutputEMsg[MAX_CONTENT_MSG_NUM];

    pthread_detach(pthread_self());

    index = *(int *)arg;
    memset((char *)OutputEMsg, 0, sizeof(EventMsg)*MAX_CONTENT_MSG_NUM);

    L4("scription[%d] topic=%d, state=%d\n", index, gOnvifConf.scription[index].Topic, gOnvifConf.scription[index].state);
    if(gOnvifConf.scription[index].state == ONVIF_STATE_INIT) {
        gOnvifConf.scription[index].state = ONVIF_STATE_RUN;
    } else {
        L1("error. scription[%d].state=%d is not ONVIF_STATE_INIT\n", index, gOnvifConf.scription[index].state);
        goto OnvifEventThreadLeave;
    }
    do {
		if(checkTimeInterval(index) != OK) {
            	gOnvifConf.scription[index].state = ONVIF_STATE_STOP;
	            break;
        	}
		
		if(IsEventQHaveNewEvent(index, MAX_CONTENT_MSG_NUM, &MessageCnt, OutputEMsg) == true_){
			for(i=0; i<MessageCnt; i++){
    				(void)OnvifSemLock();
				Notify(index, &OutputEMsg[i]);
    				(void)OnvifSemUnlock();
			}
			MessageCnt = 0;
		}

		usleep(25000);
    } while((gOnvifConf.scription[index].state == ONVIF_STATE_RUN)&&(gOnvifConf.state == ONVIF_STATE_RUN));

OnvifEventThreadLeave:
    gOnvifConf.scription[index].state = ONVIF_STATE_CLOSE;
//    gOnvifConf.scription[index].enable = false_;
    config_change = true_;
    if (sock > 0)  SockClose (&sock);
    L4("leave. scription[%d] state=%d\n", index, gOnvifConf.scription[index].state);
    pthread_exit(NULL);
}

static void *OnvifEventThread(void *arg) {
    int index = 0;
    int sock = 0;

    pthread_detach(pthread_self());
    
    index = *(int *)arg;
    L4("scription[%d] topic=%d, state=%d, enable=%d\n", index, gOnvifConf.scription[index].Topic, gOnvifConf.scription[index].state,
	gOnvifConf.scription[index].enable);
    if(gOnvifConf.scription[index].state == ONVIF_STATE_INIT) {
        gOnvifConf.scription[index].state = ONVIF_STATE_RUN;
    } else {
        L1("error. scription[%d].state=%d is not ONVIF_STATE_INIT\n", index, gOnvifConf.scription[index].state);
        goto OnvifEventThreadLeave;
    }
    do {
        if(checkTimeInterval(index) != OK) {
            gOnvifConf.scription[index].state = ONVIF_STATE_STOP;
            break;
        }

    } while((gOnvifConf.scription[index].state == ONVIF_STATE_RUN)&&(gOnvifConf.state == ONVIF_STATE_RUN));

OnvifEventThreadLeave:
    gOnvifConf.scription[index].state = ONVIF_STATE_CLOSE;
//    gOnvifConf.scription[index].enable = false_;
    config_change = true_;
    if (sock > 0)  SockClose (&sock);
    L4("leave. scription[%d] state=%d\n", index, gOnvifConf.scription[index].state);
    pthread_exit(NULL);
}

static void *HandleDelayTime(void *arg)
{
    int DelayTime = 0;
    int nDO = -1;
    tUrlDB url;
    char ReplyMsg[512];
    int cnt = 0;

    nDO = *(int *)arg;

    parserTimeInterval(gOnvifConf.DOSetting[nDO-1].DelayTime, &DelayTime);
    gOnvifConf.DOSetting[nDO-1].state = ONVIF_STATE_RUN;
    L4("DOSetting[%d]: DelayTime=%d\n", nDO-1, DelayTime);
    do {
	sleep(1);	
	cnt++;
	if( (gOnvifConf.DOSetting[nDO-1].state != ONVIF_STATE_RUN) ||
	    (cnt >= DelayTime)) {
	    L4("leave, DOSetting[%d]:%d/%d, state=%d\n", nDO-1, cnt, DelayTime, gOnvifConf.DOSetting[nDO-1].state);
	    break;
	}
    } while(gOnvifConf.state == ONVIF_STATE_RUN);

    if(gOnvifConf.state == ONVIF_STATE_RUN) {
	strcpy(url.cgi, "encoder");
	if(gOnvifConf.DOSetting[nDO-1].IdleState == _open_) {
	    url.len = sprintf(url.cmd, "SET_DO=%d,0", nDO);
	} else {
	    url.len = sprintf(url.cmd, "SET_DO=%d,1", nDO);
	}
	OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
	L1("send %s done and leave\n", url.cmd);
    }
    gOnvifConf.DOSetting[nDO-1].state = ONVIF_STATE_CLOSE;
    pthread_exit(NULL);
}

int timer; /* timeout timer in seconds */
    int needStopPTCmd;
    int needStopZoomCmd;
    char moveCmd[64];
    char zoomCmd[64];

static void *ContinueMoveTimerHandler(void *arg)
{
    tContinueMoveCmd toutCmd;
	int first = 1;

    memcpy((void *)&toutCmd, arg, sizeof(tContinueMoveCmd));
	pthread_detach(pthread_self());

	fprintf(stdout, "%s: timer=%d, need stop %d,%d\n", __func__,
	             toutCmd.timer, toutCmd.needStopPTCmd, toutCmd.needStopZoomCmd);
    
    if(toutCmd.needStopPTCmd == 1)   {
		(void)OnvifSingleUrlCmdSend("encoder", toutCmd.moveCmd, NULL, 0);
        gMovePanDirection = 0;
    }
    if(toutCmd.needStopZoomCmd == 1) {
		(void)OnvifSingleUrlCmdSend("encoder", toutCmd.zoomCmd, NULL, 0);
    }

    while((toutCmd.timer > 1) && (gOnvifConf.state == ONVIF_STATE_RUN)) {
		if(first == 0) {
			sleep(1);
		} else {
			usleep(800000);
			first = 0;
		}
		toutCmd.timer --;
    }
	/* send the MOVE=STOP URL to streaming engine */
    if(toutCmd.needStopPTCmd) {
		(void)OnvifSingleUrlCmdSend("encoder", "MOVE=STOP", NULL, 0);
    }
    if(toutCmd.needStopZoomCmd) {
		(void)OnvifSingleUrlCmdSend("encoder", "ZOOM=STOP", NULL, 0);
    }
    pthread_exit (NULL);
}
int DenormalizeValueGet(int minSteps, int maxSteps, float minRatio, float maxRatio, float ratio) {
    int steps = 0;

    if(ratio >= maxRatio) return maxSteps;
    if(ratio <= minRatio) return minSteps;
    if(maxRatio > minRatio) {
        if((minRatio < 0) && (maxRatio > 0)) {
			if((minSteps < 0) && (maxSteps > 0)) {
            	if(ratio >= 0) {
                	steps = (int)(ratio * maxSteps);
            	} else {
                	steps = (int)((-1) * ratio * minSteps);
            	}
			} else {
				steps = minSteps + (int)((float)((ratio-minRatio)*(maxSteps-minSteps))/(maxRatio-minRatio));
			}
        } else {
            steps = minSteps + (int)((float)((ratio-minRatio)*(maxSteps-minSteps))/(maxRatio-minRatio));
        }
        if(steps <= minSteps) return minSteps;
        if(steps >= maxSteps) return maxSteps;
        return steps;
    }
    L1("error, maxRatio(%f) <= minRatio(%f), use min steps(%d)\n", maxRatio, minRatio, minSteps);
    return minSteps;
} 
int Denormalize_PTZPosition (int Option, float Normal_Pos) { 		
	switch (Option) {	
        case OPT_PAN_POSITION:
            return DenormalizeValueGet( gPTZLimits.MinPanLimits, gPTZLimits.MaxPanLimits,
                                        ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                        Normal_Pos);
        case OPT_TILT_POSITION:
            return DenormalizeValueGet( gPTZLimits.MinTiltLimits, gPTZLimits.MaxTiltLimits,
                                        ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                        Normal_Pos);
            break;
        case OPT_TILT_VELOCITY:
            return DenormalizeValueGet( -1*gPTZLimits.MaxTiltLimits, gPTZLimits.MaxTiltLimits,
                                        ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                        Normal_Pos);
            break;
        case OPT_ZOOM_POSITION:
            return DenormalizeValueGet( gPTZLimits.MinZoomLimits, gPTZLimits.MaxZoomLimits,
                                        ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                        Normal_Pos);
            break;
        case OPT_ZOOM_VELOCITY:
            return DenormalizeValueGet( -1*gPTZLimits.MaxZoomLimits, gPTZLimits.MaxZoomLimits,
                                        ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                        Normal_Pos);
            break;
        default:
            return SOAP_ERR;
	}
}
int Denormalize_PanTiltSpeed (int Option, float Normal_Speed) {
	float speed = (Normal_Speed > 0)?Normal_Speed:((-1)*Normal_Speed); 
    
	switch (Option) {
        case OPT_PAN_SPEED:
        case OPT_PAN_VELOCITY:
            if (speed == 0) return 0; //Stop if pan speed == 0
            return DenormalizeValueGet( MIN_PHY_PAN_SPEED, MAX_PHY_PAN_SPEED,
                                        ptzNormalRange[OPT_PAN_SPEED][LIMIT_MIN], ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX],
                                        speed);
        case OPT_TILT_SPEED:
        case OPT_TILT_VELOCITY:
            if (speed == 0) return 0; 	//Stop if tilt speed == 0
            return DenormalizeValueGet( MIN_PHY_TILT_SPEED, MAX_PHY_TILT_SPEED,
                                        ptzNormalRange[OPT_TILT_SPEED][LIMIT_MIN], ptzNormalRange[OPT_TILT_SPEED][LIMIT_MAX],
                                        speed);
        default:
            return SOAP_ERR;
	} 
}
int Denormalize_ZoomSpeed (int Option, float Normal_Speed) {
	float speed = (Normal_Speed >= 0)? Normal_Speed : ((-1)*Normal_Speed); 

	switch (Option) {
        case OPT_ZOOM_SPEED:
        case OPT_ZOOM_VELOCITY:
            if (speed == 0) return 0;	//Stop if tilt speed == 0
            return DenormalizeValueGet( MIN_PHY_ZOOM_SPEED, MAX_PHY_ZOOM_SPEED,
                                        ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MIN], ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX],
                                        speed);
        default:
            return SOAP_ERR; 
	}
}
static float NormalizeValueGet(int minSteps, int maxSteps, float minRatio, float maxRatio, int steps) {
    float value = 0.0;

    if(steps <= minSteps) return minRatio;
    if(steps >= maxSteps) return maxRatio;
    if(maxSteps > minSteps) {
        if((minSteps < 0) && (maxSteps > 0)) {
			if((minRatio < 0) && (maxRatio > 0)) {
            	if(steps >= 0) {
                	value = (float)steps;
                	value = value / maxSteps;
            	} else {
                	value = (float)steps;
                	value = -1 * value / minSteps;
            	}
			} else {
				value = steps - minSteps;
				value = minRatio + (float)((value*(maxRatio-minRatio))/(maxSteps-minSteps));
			}
        } else {
            value = steps - minSteps;
			value = minRatio + (float)((value*(maxRatio-minRatio))/(maxSteps-minSteps));
        }
        if(value <= minRatio) return minRatio;
        if(value >= maxRatio) return maxRatio;
        return value;
    }
    L1("error, maxSteps(%d) <= minSteps(%d). use minRatio %f\n", minSteps, maxSteps, minRatio);
    return minRatio;
}
int Normalize_GetPTZCurrentPosition (int Option, struct tPtzPos *Pos, float *ret)  
{   
	switch (Option) {
        case OPT_PAN_POSITION:
            *ret = NormalizeValueGet(gPTZLimits.MinPanLimits, gPTZLimits.MaxPanLimits,
                                     ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                     Pos->PositionP);
            return OK;			
        case OPT_TILT_POSITION: 
            *ret = NormalizeValueGet(gPTZLimits.MinTiltLimits, gPTZLimits.MaxTiltLimits,
                                     ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                     Pos->PositionT);
            return OK;
        case OPT_ZOOM_POSITION: 
            *ret = NormalizeValueGet(gPTZLimits.MinZoomLimits, gPTZLimits.MaxZoomLimits,
                                     ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                     Pos->PositionZ);
            return OK;
        default:
            *ret = SOAP_ERR; 
            return SOAP_ERR;
	}
}

int Normalize_PTZPosition (int Option, int Physical_Pos, float *ret)  
{ 
	switch (Option) {
        case OPT_PAN_POSITION:
            *ret = NormalizeValueGet(gPTZLimits.MinPanLimits, gPTZLimits.MaxPanLimits,
                                     ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                     Physical_Pos);
            return OK;		
        case OPT_TILT_POSITION: 
            *ret = NormalizeValueGet(gPTZLimits.MinTiltLimits, gPTZLimits.MaxTiltLimits,
                                     ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                     Physical_Pos);
            return OK;
        case OPT_ZOOM_POSITION: 
            *ret = NormalizeValueGet(gPTZLimits.MinZoomLimits, gPTZLimits.MaxZoomLimits,
                                     ptzNormalRange[Option][LIMIT_MIN], ptzNormalRange[Option][LIMIT_MAX],
                                     Physical_Pos);
            return OK;
        default:
            *ret = SOAP_ERR; 
            return SOAP_ERR;
	}
}
/* ######################################################################################
 * Shart Functions
 * ###################################################################################### */




int __d__Hello (struct soap *soap, struct d__HelloType *d__Hello, struct d__ResolveType *d__HelloResponse)
{
	return SOAP_STOP;
}


int __d__Bye (struct soap *soap, struct d__ByeType *d__Bye, struct d__ResolveType *d__ByeResponse)
{
	return SOAP_STOP;
}

int __d__Probe (struct soap *soap, struct d__ProbeType *d__Probe, struct d__ProbeMatchesType *d__ProbeResponse)
{
	int i, offset = 0;
	static char uuid[MAX_UUID_LEN];
    int have_same = 0;

	if (gOnvifConf.DiscoveryMode == NonDiscoverable) {
        L4("I'm not discoverable, ignore this request\n");
        return SOAP_STOP;
    }
    
	if (!soap->header) return soap_sender_fault (soap, "No SOAP header", NULL);
    
	if (!soap->header->wsa__MessageID.__item) return soap_sender_fault (soap, "No WS-Addressing MessageID", NULL);
    
	if((d__Probe->Types == NULL) || (strlen(d__Probe->Types) == 0) || (strcmp (d__Probe->Types, ONVIF_DEVICE_TYPE))) {
        L4("type error\n");
        return SOAP_STOP;
	}
    
	if (d__Probe->Scopes) {
		/*search the same scopes, if not found, don't response. */
		if (d__Probe->Scopes->__item && (d__Probe->Scopes->__item[0] != '\0')) {
			for (i = 0; i < gOnvifConf.Scopes.size; i++) {
				if ( check_match (d__Probe->Scopes->__item, gOnvifConf.Scopes.Ptr[i]) == 1 ) have_same = 1;
			}
			if ( have_same ) goto PROBEMATCH;
			else {
				if ( onvif_check_scope_prefix_path ( d__Probe->Scopes->__item, "onvif://www.onvif.org/" ) == 0 ) {
                    L1("error. scope_prefix_path mismatch %s\n", d__Probe->Scopes->__item);
                    return SOAP_STOP;
                }
				if ( onvif_check_scope_prefix_name ( d__Probe->Scopes->__item, "onvif://www.onvif.org/" ) == 0 ) {
                    L1("error. scope_prefix_name mismatch %s\n", d__Probe->Scopes->__item);
                    return SOAP_STOP;
                }
			}
			gOnvifConf.AppSequence.MessageNumber++;
			soap->header->d__AppSequence = &gOnvifConf.AppSequence;
		}
PROBEMATCH:
		if (d__Probe->Scopes->MatchBy) {
            L1("error. Scopes has MatchBy %s\n", d__Probe->Scopes->MatchBy);
            return DiscoverySoapFault (soap);
        }
	}

	soap->header->wsa__RelatesTo = (struct wsa__RelatesToType *) soap_malloc (soap, sizeof (struct wsa__RelatesToType));
	soap_default_wsa__RelatesToType (soap, soap->header->wsa__RelatesTo);
	soap->header->wsa__RelatesTo->__item = soap->header->wsa__MessageID.__item;
	// must check for duplicate messages
	if (check_received (soap->header->wsa__MessageID.__item)) {
        //printf("Request message %s already received\n", soap->header->wsa__MessageID.__item);
		return SOAP_STOP;		// don't return response
	}
	soap->header->wsa__To.__item = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
	soap->header->wsa__MessageID.__item = uuid;
	GenerateUUiD (soap->header->wsa__MessageID.__item);
	soap->header->wsa__Action.__item = "http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches";
	// AppSequence
	gOnvifConf.AppSequence.MessageNumber++;
	soap->header->d__AppSequence = &gOnvifConf.AppSequence;

	d__ProbeResponse->__sizeProbeMatch = 1;
	d__ProbeResponse->ProbeMatch = (d__ProbeMatchType *) soap_malloc (soap, sizeof (d__ProbeMatchType));
	soap_default_d__ProbeMatchType (soap, d__ProbeResponse->ProbeMatch);
	d__ProbeResponse->ProbeMatch->wsa__EndpointReference =
		(wsa__EndpointReferenceType *) soap_malloc (soap, sizeof (wsa__EndpointReferenceType));
	soap_default_wsa__EndpointReferenceType (soap, d__ProbeResponse->ProbeMatch->wsa__EndpointReference);
	d__ProbeResponse->ProbeMatch->wsa__EndpointReference->Address =
		(wsa__AttributedURIType *) soap_malloc (soap, sizeof (wsa__AttributedURIType));
	d__ProbeResponse->ProbeMatch->wsa__EndpointReference->Address->__item = gOnvifConf.EndpointAddr;
	d__ProbeResponse->ProbeMatch->Scopes = (d__ScopesType *) soap_malloc (soap, sizeof (d__ScopesType));
	soap_default_d__ScopesType (soap, d__ProbeResponse->ProbeMatch->Scopes);
	d__ProbeResponse->ProbeMatch->Scopes->__item = (char *) soap_malloc (soap, MAX_SCOPES_STRLEN);
	for (i = 0; i < gOnvifConf.Scopes.size; i++) {
		offset += sprintf (&d__ProbeResponse->ProbeMatch->Scopes->__item[offset], "%s  ", gOnvifConf.Scopes.Ptr[i]);
	}
	d__ProbeResponse->ProbeMatch->Types = ONVIF_DEVICE_TYPE;
	d__ProbeResponse->ProbeMatch->XAddrs = gOnvifConf.MediaXAddr;
	d__ProbeResponse->ProbeMatch->MetadataVersion = gOnvifConf.MetaDataVerion;
	return SOAP_OK;
}

#ifdef HAVE__GETSERVICES
int __timg__GetServiceCapabilities(struct soap *soap, struct _timg__GetServiceCapabilities *timg__GetServiceCapabilities, struct _timg__GetServiceCapabilitiesResponse *timg__GetServiceCapabilitiesResponse)
{
    L4("is called\n");
	soap_default__timg__GetServiceCapabilitiesResponse (soap, timg__GetServiceCapabilitiesResponse);
	/* struct timg__Capabilities */
	timg__GetServiceCapabilitiesResponse->Capabilities =
        (struct timg__Capabilities *) soap_malloc (soap, sizeof (struct timg__Capabilities));
	soap_default_timg__Capabilities (soap, timg__GetServiceCapabilitiesResponse->Capabilities);
	return SOAP_OK;
}
#endif
int __timg__GetImagingSettings(struct soap *soap, struct _timg__GetImagingSettings *timg__GetImagingSettings, struct _timg__GetImagingSettingsResponse *timg__GetImagingSettingsResponse)
{	
	int idx = 0; 
 	Acti_ImagingSettings *ImgPtr = NULL;
	char buf[512];
	char data[64];
	int  len = 0;

	if (FindVideoSource (timg__GetImagingSettings->VideoSourceToken, &idx) == SOAP_ERR) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource", 
                                             NULL, "The requested VideoSource does not exist.");
	}
	ImgPtr = &gOnvifConf.SourceToken[idx].img;

	soap_default__timg__GetImagingSettingsResponse (soap, timg__GetImagingSettingsResponse); 
	timg__GetImagingSettingsResponse->ImagingSettings = 
		(struct tt__ImagingSettings20 *) soap_malloc (soap, sizeof (struct tt__ImagingSettings20)); 
	soap_default_tt__ImagingSettings20 (soap, timg__GetImagingSettingsResponse->ImagingSettings); 
	/* struct tt__BacklightCompensation20 */
	if (gOnvifConf.BLCEnable == true_) {
		timg__GetImagingSettingsResponse->ImagingSettings->BacklightCompensation = 
			(struct tt__BacklightCompensation20 *) soap_malloc (soap, sizeof (struct tt__BacklightCompensation20)); 
		soap_default_tt__BacklightCompensation20 (soap, 
			timg__GetImagingSettingsResponse->ImagingSettings->BacklightCompensation); 
		timg__GetImagingSettingsResponse->ImagingSettings->BacklightCompensation->Mode = ImgPtr->BLCMode;
		if (timg__GetImagingSettingsResponse->ImagingSettings->BacklightCompensation->Mode == ON_)
			timg__GetImagingSettingsResponse->ImagingSettings->BacklightCompensation->Level = &ImgPtr->BLCLevel;
	}
	/* get the runtime brightness, saturation and contrast settings back */
	if(OnvifSingleUrlCmdSend("encoder", "VIDEO_STATUS", buf, (sizeof(buf)-1)) > 0) {
		len = OnvifGetValueFmUrlReply(buf, "VIDEO_BRIGHTNESS=", data, sizeof(data));
		if(len > 0) ImgPtr->Brightness = atof(data);
		len = OnvifGetValueFmUrlReply(buf, "VIDEO_CONTRAST=", data, sizeof(data));
		if(len > 0) ImgPtr->Contrast = atof(data);
		len = OnvifGetValueFmUrlReply(buf, "VIDEO_SATURATION=", data, sizeof(data));
		if(len > 0) ImgPtr->ColorSaturation = atof(data);
	}
	if (gOnvifConf.BrightnessEnable == true_)
		timg__GetImagingSettingsResponse->ImagingSettings->Brightness = &ImgPtr->Brightness; 
	if (gOnvifConf.SaturationEnable == true_)
		timg__GetImagingSettingsResponse->ImagingSettings->ColorSaturation = &ImgPtr->ColorSaturation; 
	if (gOnvifConf.ContrastEnable == true_)
		timg__GetImagingSettingsResponse->ImagingSettings->Contrast = &ImgPtr->Contrast; 
	/* struct tt__Exposure20 */
	if (gOnvifConf.ExposureEnable == true_)
	{
		timg__GetImagingSettingsResponse->ImagingSettings->Exposure =
			(struct tt__Exposure20 *) soap_malloc (soap, sizeof (struct tt__Exposure20)); 
		soap_default_tt__Exposure20 (soap, timg__GetImagingSettingsResponse->ImagingSettings->Exposure); 
		timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Mode = ImgPtr->ExposureMode; 
		if (timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Mode == AUTO_)
		{
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Priority = &ImgPtr->ExposurePriority; 
			/* struct tt__Rectangle */
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Window = 
				(struct tt__Rectangle *) soap_malloc (soap, sizeof (struct tt__Rectangle)); 
			soap_default_tt__Rectangle (soap, 
				timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Window); 
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Window->bottom = 
				&ImgPtr->ExposureWindowBottom;
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Window->top = 
				&ImgPtr->ExposureWindowTop;
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Window->right = 
				&ImgPtr->ExposureWindowRight;
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Window->left = 
				&ImgPtr->ExposureWindowLeft;
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->MinExposureTime = &ImgPtr->MinExposureTime; 
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->MaxExposureTime = &ImgPtr->MaxExposureTime; 
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->MinGain = &ImgPtr->MinGain; 
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->MaxGain = &ImgPtr->MaxGain; 
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->MinIris = &ImgPtr->MinIris;  
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->MaxIris = &ImgPtr->MaxIris;  
		} else {
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->ExposureTime= &ImgPtr->ExposureTime;  
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Gain = &ImgPtr->Gain;  
			timg__GetImagingSettingsResponse->ImagingSettings->Exposure->Iris = &ImgPtr->Iris;  
		}
	}
#if MYYOU_IMAGING_FOCUS_SUPPORTED
	/* struct tt__FocusConfiguration20 */
	timg__GetImagingSettingsResponse->ImagingSettings->Focus =
            (struct tt__FocusConfiguration20 *) soap_malloc (soap, sizeof (struct tt__FocusConfiguration20)); 
    soap_default_tt__FocusConfiguration20 (soap, timg__GetImagingSettingsResponse->ImagingSettings->Focus); 
	timg__GetImagingSettingsResponse->ImagingSettings->Focus->AutoFocusMode = ImgPtr->AutoFocusMode;  
	if (timg__GetImagingSettingsResponse->ImagingSettings->Focus->AutoFocusMode == _AUTO_) {
		timg__GetImagingSettingsResponse->ImagingSettings->Focus->NearLimit = &ImgPtr->NearLimit;  
		timg__GetImagingSettingsResponse->ImagingSettings->Focus->FarLimit = &ImgPtr->FarLimit; 
	} else {
		timg__GetImagingSettingsResponse->ImagingSettings->Focus->DefaultSpeed = &ImgPtr->DefaultSpeed;
    }
#endif
#if MYYOU_IMAGING_IRCUT_SUPPORTED
	timg__GetImagingSettingsResponse->ImagingSettings->IrCutFilter = &ImgPtr->IrCutFilter;
#endif
#if MYYOU_IMAGING_SHARPNESS_SUPPORTED
	if (gOnvifConf.SharpnessEnable == true_)
		timg__GetImagingSettingsResponse->ImagingSettings->Sharpness = &ImgPtr->Sharpness;
#endif
#if MYYOU_IMAGING_WDR_SUPPORTED
	/* struct tt__WideDynamicRange20 */
	if (gOnvifConf.WDREnable == true_) {
		timg__GetImagingSettingsResponse->ImagingSettings->WideDynamicRange = 
			(struct tt__WideDynamicRange20 *) soap_malloc (soap, sizeof (struct tt__WideDynamicRange20)); 
		soap_default_tt__WideDynamicRange20 (soap, timg__GetImagingSettingsResponse->ImagingSettings->WideDynamicRange); 
		timg__GetImagingSettingsResponse->ImagingSettings->WideDynamicRange->Mode = ImgPtr->WDRMode; 
		if (timg__GetImagingSettingsResponse->ImagingSettings->WideDynamicRange->Mode == ON)
			timg__GetImagingSettingsResponse->ImagingSettings->WideDynamicRange->Level = &ImgPtr->WDRLevel; 
	}
#endif
	/* struct tt__WhiteBalance20 */
	if (gOnvifConf.WhiteBalanceEnable == true_) {
		timg__GetImagingSettingsResponse->ImagingSettings->WhiteBalance = 
			(struct tt__WhiteBalance20 *) soap_malloc (soap, sizeof (struct tt__WhiteBalance20)); 
		soap_default_tt__WhiteBalance20 (soap, timg__GetImagingSettingsResponse->ImagingSettings->WhiteBalance); 
		timg__GetImagingSettingsResponse->ImagingSettings->WhiteBalance->Mode = ImgPtr->WhiteBalanceMode; 
		if (timg__GetImagingSettingsResponse->ImagingSettings->WhiteBalance->Mode == MANUAL__) {
			timg__GetImagingSettingsResponse->ImagingSettings->WhiteBalance->CrGain = &ImgPtr->CrGain; 
			timg__GetImagingSettingsResponse->ImagingSettings->WhiteBalance->CbGain = &ImgPtr->CbGain; 
		}
	}
	return SOAP_OK;
}

int __timg__SetImagingSettings(struct soap *soap, struct _timg__SetImagingSettings *timg__SetImagingSettings, struct _timg__SetImagingSettingsResponse *timg__SetImagingSettingsResponse)
{	
	int idx = 0; 
 	Acti_ImagingSettings *ImgPtr = NULL;
    int needSave = 0;
	int len = 0;
	char cmd[512];

	if (FindVideoSource (timg__SetImagingSettings->VideoSourceToken, &idx) == SOAP_ERR) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource", 
                                             NULL, "The requested VideoSource does not exist.");
    }
    L4("video src token %d is used\n", idx);
	if (timg__SetImagingSettings->ForcePersistence_x0020 == NULL || 
	   *timg__SetImagingSettings->ForcePersistence_x0020 == false_)	{
        needSave  = 0;
    } else {
        needSave = 1;
    }
	ImgPtr = &gOnvifConf.SourceToken[idx].img; 

    if (gOnvifConf.BLCEnable == true_) {
        /* BacklightCompensation */
        if (timg__SetImagingSettings->ImagingSettings->BacklightCompensation != NULL) { 
            if (timg__SetImagingSettings->ImagingSettings->BacklightCompensation->Mode == OFF_) {
                ImgPtr->BLCMode = OFF_; 
            } else {
                ImgPtr->BLCMode = ON_;
            }
        }
	}
    if (gOnvifConf.BrightnessEnable == true_) {
        /* Brightness */
        if (timg__SetImagingSettings->ImagingSettings->Brightness != NULL) {
            L4("Brightness=%f, %f/%f, %f\n", *timg__SetImagingSettings->ImagingSettings->Brightness,
                gOnvifConf.SourceToken[idx].ImgOpt.MinBrightness, gOnvifConf.SourceToken[idx].ImgOpt.MaxBrightness,
                ImgPtr->Brightness);
            if ((*timg__SetImagingSettings->ImagingSettings->Brightness >= gOnvifConf.SourceToken[idx].ImgOpt.MinBrightness) &&
                (*timg__SetImagingSettings->ImagingSettings->Brightness <= gOnvifConf.SourceToken[idx].ImgOpt.MaxBrightness)) {
                ImgPtr->Brightness = *timg__SetImagingSettings->ImagingSettings->Brightness; 
				len += snprintf(&cmd[len], (sizeof(cmd)-len), "%sVIDEO_BRIGHTNESS=%d", (len>0)?"&":"", (int)ImgPtr->Brightness);
            } else {
                L1("error. brightness=%f\n", *timg__SetImagingSettings->ImagingSettings->Brightness);
                goto ImagingSettingsInvalid;
            }
        }
    }
	/* ColorSaturation */
    if (gOnvifConf.SaturationEnable == true_) {
        L4("ColorSaturation=%f, %f/%f, %f\n", *timg__SetImagingSettings->ImagingSettings->ColorSaturation,
            gOnvifConf.SourceToken[idx].ImgOpt.MinSaturation, gOnvifConf.SourceToken[idx].ImgOpt.MaxSaturation,
            ImgPtr->ColorSaturation);
        if (timg__SetImagingSettings->ImagingSettings->ColorSaturation != NULL) {
            if ((*timg__SetImagingSettings->ImagingSettings->ColorSaturation >= gOnvifConf.SourceToken[idx].ImgOpt.MinSaturation) &&
                (*timg__SetImagingSettings->ImagingSettings->ColorSaturation <= gOnvifConf.SourceToken[idx].ImgOpt.MaxSaturation)) {
                ImgPtr->ColorSaturation = *timg__SetImagingSettings->ImagingSettings->ColorSaturation;
				len += snprintf(&cmd[len], (sizeof(cmd)-len), "%sVIDEO_SATURATION=%d", (len>0)?"&":"", (int)ImgPtr->ColorSaturation);
            } else {
                L1("error. saturation=%f\n", *timg__SetImagingSettings->ImagingSettings->ColorSaturation);
                goto ImagingSettingsInvalid;
            }
        }
	}
    if (gOnvifConf.ContrastEnable == true_) {
        L4("Contrast=%f, %f/%f, %f\n", *timg__SetImagingSettings->ImagingSettings->Contrast,
            gOnvifConf.SourceToken[idx].ImgOpt.MinContrast, gOnvifConf.SourceToken[idx].ImgOpt.MaxContrast,
            ImgPtr->Contrast);
        if (timg__SetImagingSettings->ImagingSettings->Contrast != NULL) {
            if ((*timg__SetImagingSettings->ImagingSettings->Contrast >= gOnvifConf.SourceToken[idx].ImgOpt.MinContrast) &&
                (*timg__SetImagingSettings->ImagingSettings->Contrast <= gOnvifConf.SourceToken[idx].ImgOpt.MaxContrast)) {
                ImgPtr->Contrast = *timg__SetImagingSettings->ImagingSettings->Contrast; 
				len += snprintf(&cmd[len], (sizeof(cmd)-len), "%sVIDEO_CONTRAST=%d", (len>0)?"&":"", (int)ImgPtr->Contrast);
            } else {
                L1("error. contrast=%f\n", *timg__SetImagingSettings->ImagingSettings->Contrast);
                goto ImagingSettingsInvalid;
            }
        }
	}
	if(len > 0) (void)OnvifSingleUrlCmdSend("encoder", cmd, NULL, 0);

    if (gOnvifConf.ExposureEnable == true_) {
        if (timg__SetImagingSettings->ImagingSettings->Exposure != NULL) {
            if ((enum tt__ExposureMode)timg__SetImagingSettings->ImagingSettings->Exposure->Mode == AUTO_) {
                ImgPtr->ExposureMode = AUTO_;
                /* Exposure->Priority */
                if (timg__SetImagingSettings->ImagingSettings->Exposure->Priority != NULL) {
                    if ((enum tt__ExposurePriority) *timg__SetImagingSettings->ImagingSettings->Exposure->Priority == LowNoise)	{
                        ImgPtr->ExposurePriority = (enum tt__ExposurePriority) LowNoise;
                    } else {
                        ImgPtr->ExposurePriority = (enum tt__ExposurePriority) FrameRate;
                    }
                }
			}
			/* Exposure->Window */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->Window != NULL) {
				// We don't support Exposure Window Settings 
				if (*timg__SetImagingSettings->ImagingSettings->Exposure->Window->bottom != NotAvailable)
					goto ImagingSettingsInvalid;
				if (*timg__SetImagingSettings->ImagingSettings->Exposure->Window->top != NotAvailable)
					goto ImagingSettingsInvalid;
				if (*timg__SetImagingSettings->ImagingSettings->Exposure->Window->right != NotAvailable)
					goto ImagingSettingsInvalid;
				if (*timg__SetImagingSettings->ImagingSettings->Exposure->Window->left != NotAvailable)
					goto ImagingSettingsInvalid;
				ImgPtr->ExposureWindowBottom = *timg__SetImagingSettings->ImagingSettings->Exposure->Window->bottom; 
				ImgPtr->ExposureWindowTop    = *timg__SetImagingSettings->ImagingSettings->Exposure->Window->top; 
				ImgPtr->ExposureWindowRight  = *timg__SetImagingSettings->ImagingSettings->Exposure->Window->right; 
				ImgPtr->ExposureWindowLeft   = *timg__SetImagingSettings->ImagingSettings->Exposure->Window->left; 
			}
			/* Exposure->MinExposureTime */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->MinExposureTime != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->MinExposureTime >= gOnvifConf.SourceToken[idx].ImgOpt.MinExposureTime) &&
			   	    (*timg__SetImagingSettings->ImagingSettings->Exposure->MinExposureTime <= gOnvifConf.SourceToken[idx].ImgOpt.MaxExposureTime)) {
					ImgPtr->MinExposureTime = *timg__SetImagingSettings->ImagingSettings->Exposure->MinExposureTime;
				} else {
                    L1("error, min exp time %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MinExposureTime);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->MaxExposureTime */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->MaxExposureTime != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->MaxExposureTime >= gOnvifConf.SourceToken[idx].ImgOpt.MinExposureTime) &&
			        (*timg__SetImagingSettings->ImagingSettings->Exposure->MaxExposureTime <= gOnvifConf.SourceToken[idx].ImgOpt.MaxExposureTime)) {
					ImgPtr->MaxExposureTime = *timg__SetImagingSettings->ImagingSettings->Exposure->MaxExposureTime;
				} else {
                    L1("error, max exp time %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MaxExposureTime);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->MinGain */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->MinGain != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->MinGain >= gOnvifConf.SourceToken[idx].ImgOpt.MinGain) &&
			   	    (*timg__SetImagingSettings->ImagingSettings->Exposure->MinGain <= gOnvifConf.SourceToken[idx].ImgOpt.MaxGain)) {
					ImgPtr->MinGain = *timg__SetImagingSettings->ImagingSettings->Exposure->MinGain;
				} else {
                    L1("error, min exp gain %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MinGain);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->MaxGain */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->MaxGain != NULL) {	
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->MaxGain >= gOnvifConf.SourceToken[idx].ImgOpt.MinGain) &&
			   	    (*timg__SetImagingSettings->ImagingSettings->Exposure->MaxGain <= gOnvifConf.SourceToken[idx].ImgOpt.MaxGain)) {
					ImgPtr->MaxGain = *timg__SetImagingSettings->ImagingSettings->Exposure->MaxGain;
				} else {
                    L1("error, max exp gain %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MaxGain);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->MinIris */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->MinIris != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->MinIris >= gOnvifConf.SourceToken[idx].ImgOpt.MinIris) &&
				    (*timg__SetImagingSettings->ImagingSettings->Exposure->MinIris <= gOnvifConf.SourceToken[idx].ImgOpt.MaxIris)) {
					ImgPtr->MinIris = *timg__SetImagingSettings->ImagingSettings->Exposure->MinIris;
				} else {
                    L1("error, min iris %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MinIris);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->MaxIris */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->MaxIris) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->MaxIris >= gOnvifConf.SourceToken[idx].ImgOpt.MinIris) &&
				    (*timg__SetImagingSettings->ImagingSettings->Exposure->MaxIris <= gOnvifConf.SourceToken[idx].ImgOpt.MaxIris)) {
					ImgPtr->MaxIris = *timg__SetImagingSettings->ImagingSettings->Exposure->MaxIris;
				} else {
                    L1("error, max iris %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MaxIris);
					goto ImagingSettingsInvalid;
                }
			}
		} else if (timg__SetImagingSettings->ImagingSettings->Exposure->Mode == MANUAL_) {
            ImgPtr->ExposureMode = MANUAL_;
			/* Exposure->ExposureTime */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->ExposureTime != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->ExposureTime >= gOnvifConf.SourceToken[idx].ImgOpt.MinExposureTime) &&
				    (*timg__SetImagingSettings->ImagingSettings->Exposure->ExposureTime <= gOnvifConf.SourceToken[idx].ImgOpt.MaxExposureTime)) {
					ImgPtr->ExposureTime = *timg__SetImagingSettings->ImagingSettings->Exposure->ExposureTime;
				} else {
                    L1("error, manual exp. time %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->ExposureTime);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->Gain */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->Gain != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->Gain >= gOnvifConf.SourceToken[idx].ImgOpt.MinGain) &&
				    (*timg__SetImagingSettings->ImagingSettings->Exposure->Gain <= gOnvifConf.SourceToken[idx].ImgOpt.MaxGain)) {
					ImgPtr->Gain = *timg__SetImagingSettings->ImagingSettings->Exposure->Gain;
				} else {
                    L1("error, manual max exp. gain %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->MaxGain);
					goto ImagingSettingsInvalid;
                }
			}
			/* Exposure->Iris */
			if (timg__SetImagingSettings->ImagingSettings->Exposure->Iris != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Exposure->Iris >= gOnvifConf.SourceToken[idx].ImgOpt.MinIris) &&
				   (*timg__SetImagingSettings->ImagingSettings->Exposure->Iris <= gOnvifConf.SourceToken[idx].ImgOpt.MaxIris)) {
					ImgPtr->Iris = *timg__SetImagingSettings->ImagingSettings->Exposure->Iris;
				} else {
                    L1("error, manual iris %f\n", *timg__SetImagingSettings->ImagingSettings->Exposure->Iris);
					goto ImagingSettingsInvalid;
                }
			}
		} else return SOAP_OK;	
	}
#if MYYOU_IMAGING_FOCUS_SUPPORTED
	if (timg__SetImagingSettings->ImagingSettings->Focus != NULL) {
		if ((enum tt__AutoFocusMode)timg__SetImagingSettings->ImagingSettings->Focus->AutoFocusMode == _AUTO_) {
            ImgPtr->AutoFocusMode = _AUTO_;
			/* Focus->NearLimit */
			if (timg__SetImagingSettings->ImagingSettings->Focus->NearLimit != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Focus->NearLimit >= gOnvifConf.SourceToken[idx].ImgOpt.MinNearLimit) &&
				    (*timg__SetImagingSettings->ImagingSettings->Focus->NearLimit >= gOnvifConf.SourceToken[idx].ImgOpt.MaxNearLimit)) {
					ImgPtr->NearLimit = *timg__SetImagingSettings->ImagingSettings->Focus->NearLimit; 
				} else {
                    L1("error, near focus limit %f\n", *timg__SetImagingSettings->ImagingSettings->Focus->NearLimit);
					goto ImagingSettingsInvalid;
                }
			}
			/* Focus->FarLimit */
			if (timg__SetImagingSettings->ImagingSettings->Focus->FarLimit != NULL) {
				if ((*timg__SetImagingSettings->ImagingSettings->Focus->FarLimit >= gOnvifConf.SourceToken[idx].ImgOpt.MinFarLimit) &&
				   (*timg__SetImagingSettings->ImagingSettings->Focus->FarLimit >= gOnvifConf.SourceToken[idx].ImgOpt.MaxFarLimit)) {
					ImgPtr->FarLimit = *timg__SetImagingSettings->ImagingSettings->Focus->FarLimit; 
				} else {
                    L1("error, far focus limit %f\n", *timg__SetImagingSettings->ImagingSettings->Focus->FarLimit);
					goto ImagingSettingsInvalid;
                }
			}
		} else if (timg__SetImagingSettings->ImagingSettings->Focus->AutoFocusMode == _MANUAL_) {
            ImgPtr->AutoFocusMode = _MANUAL_;
			/* Focus->DefaultSpeed */
			if ((*timg__SetImagingSettings->ImagingSettings->Focus->DefaultSpeed >= gOnvifConf.SourceToken[idx].ImgOpt.MinDefaultSpeed) &&
			    (*timg__SetImagingSettings->ImagingSettings->Focus->DefaultSpeed <= gOnvifConf.SourceToken[idx].ImgOpt.MaxDefaultSpeed)) {
				ImgPtr->DefaultSpeed = *timg__SetImagingSettings->ImagingSettings->Focus->DefaultSpeed; 
			} else {
                L1("error, focus speed %f\n", *timg__SetImagingSettings->ImagingSettings->Focus->DefaultSpeed);
				goto ImagingSettingsInvalid;
            }
		} else {
            L1("error, unsupport focus mode %d\n", timg__SetImagingSettings->ImagingSettings->Focus->AutoFocusMode);
			goto ImagingSettingsInvalid;
        }
	}
#endif
#if MYYOU_IMAGING_IRCUT_SUPPORTED
	/* IrCutFilter */
	if (timg__SetImagingSettings->ImagingSettings->IrCutFilter != NULL) {
		if (*timg__SetImagingSettings->ImagingSettings->IrCutFilter == AUTO___) {
			ImgPtr->IrCutFilter = AUTO___;
		} else {
            L1("error, not supported iris mode %d\n", *timg__SetImagingSettings->ImagingSettings->IrCutFilter);
			goto ImagingSettingsInvalid;
        }
	}
#endif
#if MYYOU_IMAGING_SHARPNESS_SUPPORTED
    if (gOnvifConf.SharpnessEnable == true_) {
        /* Sharpness */
        if (timg__SetImagingSettings->ImagingSettings->Sharpness != NULL) {
            if ((*timg__SetImagingSettings->ImagingSettings->Sharpness >= gOnvifConf.SourceToken[idx].ImgOpt.MinSharpness) &&
                (*timg__SetImagingSettings->ImagingSettings->Sharpness <= gOnvifConf.SourceToken[idx].ImgOpt.MaxSharpness)) {
                ImgPtr->Sharpness = *timg__SetImagingSettings->ImagingSettings->Sharpness;
            } else {
                L1("error, sharpness %f\n", *timg__SetImagingSettings->ImagingSettings->Sharpness);
                goto ImagingSettingsInvalid;
            }
        }
	}
#endif
#if MYYOU_IMAGING_WDR_SUPPORTED
    if (gOnvifConf.WDREnable == true_) {
        if (timg__SetImagingSettings->ImagingSettings->WideDynamicRange != NULL) {
            if (timg__SetImagingSettings->ImagingSettings->WideDynamicRange->Mode == ON) {
                ImgPtr->WDRMode = ON;
                if(timg__SetImagingSettings->ImagingSettings->WideDynamicRange->Level) {
                    if ((*timg__SetImagingSettings->ImagingSettings->WideDynamicRange->Level >= gOnvifConf.SourceToken[idx].ImgOpt.MinWDRLevel) &&
                        (*timg__SetImagingSettings->ImagingSettings->WideDynamicRange->Level <= gOnvifConf.SourceToken[idx].ImgOpt.MaxWDRLevel)) {
                        ImgPtr->WDRLevel = *timg__SetImagingSettings->ImagingSettings->WideDynamicRange->Level; 
                    } else {
                        L1("error, wdr level %f\n", *timg__SetImagingSettings->ImagingSettings->WideDynamicRange->Level);
                        goto ImagingSettingsInvalid;
                    }
                }
            } else ImgPtr->WDRMode = OFF;
		}	
	}
#endif
    if (gOnvifConf.WhiteBalanceEnable == true_) {
        /* WhiteBalance */
        if (timg__SetImagingSettings->ImagingSettings->WhiteBalance != NULL) {
            if (timg__SetImagingSettings->ImagingSettings->WhiteBalance->Mode == AUTO__) {
                ImgPtr->WhiteBalanceMode = AUTO__;
            } else if (timg__SetImagingSettings->ImagingSettings->WhiteBalance->Mode == MANUAL__) {
                ImgPtr->WhiteBalanceMode = MANUAL__;
            } else {
                L1("error, white balance mode %d\n", timg__SetImagingSettings->ImagingSettings->WhiteBalance->Mode);
                goto ImagingSettingsInvalid;
            }
        }
	}
	return SOAP_OK;
    
ImagingSettingsInvalid:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:SettingsInvalid", 
                                         NULL, "The requested settings are incorrect.");
}

int __timg__GetOptions(struct soap *soap, struct _timg__GetOptions *timg__GetOptions, struct _timg__GetOptionsResponse *timg__GetOptionsResponse)
{	
	int idx = 0; 
	Acti_ImagingOptions *ImgOptPtr = NULL;
#if MYYOU_IMAGING_WDR_SUPPORTED
    int j = 0;
#endif

	if (FindVideoSource (timg__GetOptions->VideoSourceToken, &idx) == SOAP_ERR) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource", 
                                             NULL, "The requested VideoSource does not exist.");
	}
	ImgOptPtr = &gOnvifConf.SourceToken[idx].ImgOpt; 
    
	soap_default__timg__GetOptionsResponse (soap, timg__GetOptionsResponse); 
	timg__GetOptionsResponse->ImagingOptions = (struct tt__ImagingOptions20 *) soap_malloc (soap, sizeof (struct tt__ImagingOptions20)); 
	soap_default_tt__ImagingOptions20 (soap, timg__GetOptionsResponse->ImagingOptions); 

	if (gOnvifConf.BLCEnable == true_) {	
		timg__GetOptionsResponse->ImagingOptions->BacklightCompensation =
            (struct tt__BacklightCompensationOptions20 *) soap_malloc (soap, sizeof (struct tt__ImagingOptions20)); 
		soap_default_tt__BacklightCompensationOptions20 (soap, timg__GetOptionsResponse->ImagingOptions->BacklightCompensation); 
		timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->__sizeMode = ImgOptPtr->sizeBLCMode; 
		timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->Mode = &ImgOptPtr->BLCMode; 
		if (*timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->Mode == ON_) {
			timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->Level =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->Level); 
			timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->Level->Min = ImgOptPtr->MinBLCLevel; 
			timg__GetOptionsResponse->ImagingOptions->BacklightCompensation->Level->Max = ImgOptPtr->MaxBLCLevel; 
		}
	}
	/* Brightness */
	if (gOnvifConf.BrightnessEnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->Brightness =
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Brightness); 
		timg__GetOptionsResponse->ImagingOptions->Brightness->Min = ImgOptPtr->MinBrightness; 
		timg__GetOptionsResponse->ImagingOptions->Brightness->Max = ImgOptPtr->MaxBrightness; 
	}
	/* ColorSaturation */
	if (gOnvifConf.SaturationEnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->ColorSaturation =
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->ColorSaturation); 
		timg__GetOptionsResponse->ImagingOptions->ColorSaturation->Min = ImgOptPtr->MinSaturation; 
		timg__GetOptionsResponse->ImagingOptions->ColorSaturation->Max = ImgOptPtr->MaxSaturation; 
	}
	/* Contrast */
	if (gOnvifConf.ContrastEnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->Contrast =
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Contrast); 
		timg__GetOptionsResponse->ImagingOptions->Contrast->Min =  ImgOptPtr->MinContrast; 
		timg__GetOptionsResponse->ImagingOptions->Contrast->Max =  ImgOptPtr->MaxContrast; 
	}
	/* Exposure */
	if (gOnvifConf.ExposureEnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->Exposure =
			(struct tt__ExposureOptions20 *) soap_malloc (soap, sizeof (struct tt__ExposureOptions20)); 
		soap_default_tt__ExposureOptions20 (soap, timg__GetOptionsResponse->ImagingOptions->Exposure); 
		timg__GetOptionsResponse->ImagingOptions->Exposure->__sizeMode = ImgOptPtr->sizeExposureMode; 
		timg__GetOptionsResponse->ImagingOptions->Exposure->Mode = &ImgOptPtr->ExposureMode; 
		if (*timg__GetOptionsResponse->ImagingOptions->Exposure->Mode == AUTO_) {
			/* Priority */
			timg__GetOptionsResponse->ImagingOptions->Exposure->__sizePriority = ImgOptPtr->sizeExposurePriority;
			timg__GetOptionsResponse->ImagingOptions->Exposure->Priority = &ImgOptPtr->ExposurePriority; 
			/* MinExposureTime */
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinExposureTime =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, 
				timg__GetOptionsResponse->ImagingOptions->Exposure->MinExposureTime); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinExposureTime->Min = 
				ImgOptPtr->MinExposureTime; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinExposureTime->Max = 
				ImgOptPtr->MinExposureTime; 
			/* MaxExposureTime */
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxExposureTime =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, 
				timg__GetOptionsResponse->ImagingOptions->Exposure->MaxExposureTime); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxExposureTime->Min = 
				ImgOptPtr->MaxExposureTime; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxExposureTime->Max =
				ImgOptPtr->MaxExposureTime; 
			/* MinGain */
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinGain =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->MinGain); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinGain->Min = ImgOptPtr->MinGain; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinGain->Max = ImgOptPtr->MinGain; 
			/* MaxGain */
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxGain =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->MaxGain); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxGain->Min = ImgOptPtr->MaxGain;
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxGain->Max = ImgOptPtr->MaxGain;
			/* MinIris */
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinIris =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->MinIris); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinIris->Min = ImgOptPtr->MinIris; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MinIris->Max = ImgOptPtr->MinIris; 
			/* MaxIris */
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxIris =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->MaxIris); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxIris->Min = ImgOptPtr->MaxIris; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->MaxIris->Max = ImgOptPtr->MaxIris; 
		} else { /* Exposure Mode == Manual */
			/* ExposureTime */
			timg__GetOptionsResponse->ImagingOptions->Exposure->ExposureTime =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->ExposureTime); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->ExposureTime->Min = ImgOptPtr->MinExposureTime; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->ExposureTime->Max = ImgOptPtr->MaxExposureTime; 
			/* Gain */
			timg__GetOptionsResponse->ImagingOptions->Exposure->Gain =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->Gain); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->Gain->Min = ImgOptPtr->MinGain; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->Gain->Max = ImgOptPtr->MaxGain; 
			/* Iris */
			timg__GetOptionsResponse->ImagingOptions->Exposure->Iris =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Exposure->Iris); 
			timg__GetOptionsResponse->ImagingOptions->Exposure->Iris->Min = ImgOptPtr->MinIris; 
			timg__GetOptionsResponse->ImagingOptions->Exposure->Iris->Max = ImgOptPtr->MaxIris; 
		}
	}
#if MYYOU_IMAGING_FOCUS_SUPPORTED
	timg__GetOptionsResponse->ImagingOptions->Focus =  
		(struct tt__FocusOptions20 *) soap_malloc (soap, sizeof (struct tt__FocusOptions20)); 
	soap_default_tt__FocusOptions20 (soap, timg__GetOptionsResponse->ImagingOptions->Focus); 
	timg__GetOptionsResponse->ImagingOptions->Focus->__sizeAutoFocusModes = ImgOptPtr->sizeAutoFocusModes; 		
	timg__GetOptionsResponse->ImagingOptions->Focus->AutoFocusModes = &ImgOptPtr->AutoFocusModes; 
	if (*timg__GetOptionsResponse->ImagingOptions->Focus->AutoFocusModes == _AUTO_) {
		/* NearLimit */
		timg__GetOptionsResponse->ImagingOptions->Focus->NearLimit =  
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Focus->NearLimit); 
		timg__GetOptionsResponse->ImagingOptions->Focus->NearLimit->Min = ImgOptPtr->MinNearLimit;  
		timg__GetOptionsResponse->ImagingOptions->Focus->NearLimit->Max = ImgOptPtr->MaxNearLimit;  
		/* FarLimit */
		timg__GetOptionsResponse->ImagingOptions->Focus->FarLimit =  
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Focus->FarLimit); 
		timg__GetOptionsResponse->ImagingOptions->Focus->FarLimit->Min = ImgOptPtr->MinFarLimit; 
		timg__GetOptionsResponse->ImagingOptions->Focus->FarLimit->Max = ImgOptPtr->MaxFarLimit; 
	} else {
		/* DefaultSpeed */
		timg__GetOptionsResponse->ImagingOptions->Focus->DefaultSpeed =  
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Focus->DefaultSpeed); 
		timg__GetOptionsResponse->ImagingOptions->Focus->DefaultSpeed->Min = ImgOptPtr->MinDefaultSpeed; 
		timg__GetOptionsResponse->ImagingOptions->Focus->DefaultSpeed->Max = ImgOptPtr->MaxDefaultSpeed; 
	}
#endif
#if MYYOU_IMAGING_IRCUT_SUPPORTED
	/* IrCutFilterMode */
	timg__GetOptionsResponse->ImagingOptions->__sizeIrCutFilterModes = ImgOptPtr->sizeIrCutFilterModes; 
	timg__GetOptionsResponse->ImagingOptions->IrCutFilterModes = &ImgOptPtr->IrCutFilterModes; 
#endif
#if MYYOU_IMAGING_SHARPNESS_SUPPORTED
	/* Sharpness*/
	if (gOnvifConf.SharpnessEnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->Sharpness =
			(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
		soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->Sharpness); 
		timg__GetOptionsResponse->ImagingOptions->Sharpness->Min = ImgOptPtr->MinSharpness; 
		timg__GetOptionsResponse->ImagingOptions->Sharpness->Max = ImgOptPtr->MaxSharpness; 
	}
#endif
#if MYYOU_IMAGING_WDR_SUPPORTED
	/* WideDynamicRangeOptions20 */
	if (gOnvifConf.WDREnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->WideDynamicRange =
			(struct tt__WideDynamicRangeOptions20 *) soap_malloc (soap, sizeof (tt__WideDynamicRangeOptions20)); 
		soap_default_tt__WideDynamicRangeOptions20 (soap, timg__GetOptionsResponse->ImagingOptions->WideDynamicRange); 
		timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->__sizeMode = ImgOptPtr->sizeWDRMode; 
		timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Mode = 
            (enum tt__WideDynamicMode *)soap_malloc(soap, sizeof (enum tt__WideDynamicMode) * timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->__sizeMode);	
		for (j = 0; j < ImgOptPtr->sizeWDRMode ; j++) {
			soap_default_tt__WideDynamicMode (soap, &timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Mode[j]); 
			timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Mode[j] = ImgOptPtr->WDRMode[j]; 
			if (timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Mode[j] == ON) {
				/* WideDynamicRange->Level */
				timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Level =
					(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange));
				soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Level); 
				timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Level->Min = ImgOptPtr->MinWDRLevel;
				timg__GetOptionsResponse->ImagingOptions->WideDynamicRange->Level->Max = ImgOptPtr->MaxWDRLevel;
			} 
		}
	}
#endif
	/* WhiteBalanceOptions20 */
	if (gOnvifConf.WhiteBalanceEnable == true_) {
		timg__GetOptionsResponse->ImagingOptions->WhiteBalance =
			(struct tt__WhiteBalanceOptions20 *) soap_malloc (soap, sizeof (tt__WhiteBalanceOptions20)); 
		soap_default_tt__WhiteBalanceOptions20 (soap, timg__GetOptionsResponse->ImagingOptions->WhiteBalance); 
		timg__GetOptionsResponse->ImagingOptions->WhiteBalance->__sizeMode = ImgOptPtr->sizeWhiteBalanceMode; 
		timg__GetOptionsResponse->ImagingOptions->WhiteBalance->Mode = &ImgOptPtr->WhiteBalanceMode; 
		if (*timg__GetOptionsResponse->ImagingOptions->WhiteBalance->Mode == MANUAL__) {
			/* WhiteBalance->YrGain */
			timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YrGain = 
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YrGain); 
			timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YrGain->Min = ImgOptPtr->MinYrGain; 
			timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YrGain->Max = ImgOptPtr->MaxYrGain; 
			/* WhiteBalance->YbGain */
			timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YbGain =
				(struct tt__FloatRange *) soap_malloc (soap, sizeof (struct tt__FloatRange)); 
			soap_default_tt__FloatRange (soap, timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YbGain); 
			timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YbGain->Min = ImgOptPtr->MinYbGain; 
			timg__GetOptionsResponse->ImagingOptions->WhiteBalance->YbGain->Max = ImgOptPtr->MaxYbGain; 
		}
	}
	return SOAP_OK;
}

int __timg__Move(struct soap *soap, struct _timg__Move *timg__Move, struct _timg__MoveResponse *timg__MoveResponse)
{
	int idx = 0;
    
	if (FindVideoSource (timg__Move->VideoSourceToken, &idx) == SOAP_ERR) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource",
                                             NULL, "The requested VideoSource does not exist.");
    }
#if MYYOU_IMAGING_FOCUS_SUPPORTED
    return OK;
#endif
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:NoImagingForSource", 
                                           NULL, "The requested VideoSource does not support imaging settings.");
}

int __timg__Stop(struct soap *soap, struct _timg__Stop *timg__Stop, struct _timg__StopResponse *timg__StopResponse) {	
	int idx = 0; 
    
	if (FindVideoSource (timg__Stop->VideoSourceToken, &idx) == SOAP_ERR) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource", 
			                                 NULL, "The requested VideoSource does not exist.");
	}
#if MYYOU_IMAGING_FOCUS_SUPPORTED
    return OK;
#endif
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:NoImagingForSource", 
                                           NULL, "The requested VideoSource does not support imaging settings.");
}

int __timg__GetStatus(struct soap *soap, struct _timg__GetStatus *timg__GetStatus, struct _timg__GetStatusResponse *timg__GetStatusResponse)
{	
	int idx = 0; 
    
	if (FindVideoSource (timg__GetStatus->VideoSourceToken, &idx) == SOAP_ERR) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource", 
                                             NULL, "The requested VideoSource does not exist.");
	}
	soap_default__timg__GetStatusResponse (soap, timg__GetStatusResponse); 
	timg__GetStatusResponse->Status = (struct tt__ImagingStatus20 *) soap_malloc (soap, sizeof (struct tt__ImagingStatus20)); 
	soap_default_tt__ImagingStatus20 (soap, timg__GetStatusResponse->Status); 
	return SOAP_OK;
}

int __timg__GetMoveOptions(struct soap *soap, struct _timg__GetMoveOptions *timg__GetMoveOptions, struct _timg__GetMoveOptionsResponse *timg__GetMoveOptionsResponse)
{	
	int idx = 0; 
    
	if (FindVideoSource (timg__GetMoveOptions->VideoSourceToken, &idx) == SOAP_ERR) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoSource", 
                                             NULL, "The requested VideoSource does not exist.");
	}
	soap_default__timg__GetMoveOptionsResponse (soap, timg__GetMoveOptionsResponse); 
	timg__GetMoveOptionsResponse->MoveOptions = (struct tt__MoveOptions20 *) soap_malloc (soap, sizeof (struct tt__MoveOptions20)); 
	soap_default_tt__MoveOptions20 (soap, timg__GetMoveOptionsResponse->MoveOptions); 
	return SOAP_OK;
}

static int EventSoapFaultReply (struct soap *soap, char *subCode, char *shortMsg, char *msg) {

    soap->header->wsa__Action.__item = "http://www.w3.org/2005/08/addressing/soap/fault";
	return soap_sender_fault_subcode_v2 (soap, subCode, NULL, shortMsg, msg);
}

static int IsEventTopicMatch(int EventMsg, int NotifyEvent)
{
	switch(EventMsg){
		case EVENT_MSG_ALL:
			return true_;
		case EVENT_MSG_WINDOW_ALL:
			if((NotifyEvent >= EVENT_MSG_WINDOW_1) && (NotifyEvent <= EVENT_MSG_WINDOW_3))
				return true_;
			break;
		case EVENT_MSG_WINDOW_1:
			if(NotifyEvent == EVENT_MSG_WINDOW_1)
				return true_;
			break;
		case EVENT_MSG_WINDOW_2:
			if(NotifyEvent == EVENT_MSG_WINDOW_2)
				return true_;
			break;
		case EVENT_MSG_WINDOW_3:
			if(NotifyEvent == EVENT_MSG_WINDOW_3)
				return true_;
			break;
		case EVENT_MSG_DI_ALL:
			if((NotifyEvent >= EVENT_MSG_DI_1) && (NotifyEvent <= EVENT_MSG_DI_3))
				return true_;
			break;
		case EVENT_MSG_DI_1:
			if(NotifyEvent == EVENT_MSG_DI_1)
				return true_;
			break;
		case EVENT_MSG_DI_2:
			if(NotifyEvent == EVENT_MSG_DI_2)
				return true_;
			break;
		case EVENT_MSG_DI_3:
			if(NotifyEvent == EVENT_MSG_DI_3)
				return true_;
			break;
		case EVENT_MSG_DI_4:
			if(NotifyEvent == EVENT_MSG_DI_4)
				return true_;
			break;
		default:
			return false_;
	}
	return false_;
}

static int IsEventQHaveNewEvent(int ScripIndex, int MessageLimit, int *MessageCnt, EventMsg *OutputEMsg)
{
	int NewIndex = 0;
	int EQIndex = 0;
	struct timeval *LastGetEventTime;
	struct timeval *NewTimeStamp;
	struct timeval *TimeStamp;
	struct timeval *NextTimeStamp;
	Acti_EventSubscription *script = NULL;
	

	NewIndex = gOnvifConf.EventQueue.InsertIndex;
	NewTimeStamp = &gOnvifConf.EventQueue.EMsg[NewIndex].TimeStamp;
	EQIndex = gOnvifConf.scription[ScripIndex].EQIndex;
	TimeStamp = &gOnvifConf.EventQueue.EMsg[EQIndex].TimeStamp;
	LastGetEventTime = &gOnvifConf.scription[ScripIndex].LastGetEventTime;
	script =  &gOnvifConf.scription[ScripIndex];

	//Have new Event
	if((LastGetEventTime->tv_sec < NewTimeStamp->tv_sec) ||
	   ((LastGetEventTime->tv_sec == NewTimeStamp->tv_sec) && (LastGetEventTime->tv_usec < NewTimeStamp->tv_usec))){

		/* Locking semaphore */
		if (sem_wait (&gOnvifConf.EventQueue.sem)) {
			L1 ("Error. lock sem\n");
		}

		//If LastGetEventTime in script < the time of the index in Queue, 
		//it means the event data of this index in the queue had been recoverd by new events .
		if((LastGetEventTime->tv_sec < TimeStamp->tv_sec) || (LastGetEventTime->tv_usec < TimeStamp->tv_usec))
			EQIndex = NewIndex;

		while(*MessageCnt < MessageLimit){
			EQIndex = EQIndex + 1;
			if (EQIndex >= MAX_EVENT_NUM) EQIndex = EQIndex - MAX_EVENT_NUM;
			NextTimeStamp = &gOnvifConf.EventQueue.EMsg[EQIndex].TimeStamp;
			if((NextTimeStamp->tv_sec > TimeStamp->tv_sec) ||
			   ((NextTimeStamp->tv_sec == TimeStamp->tv_sec) && (NextTimeStamp->tv_usec > TimeStamp->tv_usec))){
			   if(IsEventTopicMatch(script->Msg, gOnvifConf.EventQueue.EMsg[EQIndex].NotifyEvent) == true_){
					OutputEMsg->state = gOnvifConf.EventQueue.EMsg[EQIndex].state;
					OutputEMsg->trigger = gOnvifConf.EventQueue.EMsg[EQIndex].trigger;
					OutputEMsg->NotifyEvent = gOnvifConf.EventQueue.EMsg[EQIndex].NotifyEvent; 
					OutputEMsg->TimeStamp.tv_sec = gOnvifConf.EventQueue.EMsg[EQIndex].TimeStamp.tv_sec;
					OutputEMsg->TimeStamp.tv_usec = gOnvifConf.EventQueue.EMsg[EQIndex].TimeStamp.tv_usec;
					OutputEMsg++;
					*MessageCnt = *MessageCnt+1;	
					L2 ("MessageCnt=%d\n", *MessageCnt);
				}
			} 
			if (EQIndex == NewIndex) break;
		}
		script->EQIndex = EQIndex;
		LastGetEventTime->tv_sec = gOnvifConf.EventQueue.EMsg[EQIndex].TimeStamp.tv_sec;
		LastGetEventTime->tv_usec = gOnvifConf.EventQueue.EMsg[EQIndex].TimeStamp.tv_usec;

		/* Unlocking semaphore */
		if (sem_post (&gOnvifConf.EventQueue.sem)) {
			L1 ("Error. unlock sem\n");
		}

		return true_;
	//Reset Time for Event
	}else if((LastGetEventTime->tv_sec > TimeStamp->tv_sec) ||
	 	   ((LastGetEventTime->tv_sec == TimeStamp->tv_sec) && (LastGetEventTime->tv_usec > TimeStamp->tv_usec))){
		LastGetEventTime->tv_sec = TimeStamp->tv_sec;
	   	LastGetEventTime->tv_usec = TimeStamp->tv_usec;
		*MessageCnt = 0;
		L2 ("Reset Time for Event\n");
		return false_;
	//Have NO Event
	}else{
		*MessageCnt = 0;
		//L2 ("Wait for Event Measge!!!!\n");
		return false_;
	}
	
}

int __ns3__PullMessages(struct soap *soap, struct _tev__PullMessages *tev__PullMessages, struct _tev__PullMessagesResponse *tev__PullMessagesResponse)
{	
	int index = 0;
	int EQIndex = 0;
	int timeInterval = 0;
	int MessageLimit = 0;
	int MessageCnt = 0;
	int NoEvent = false_;
	char item[MAX_UUID_LEN];
	struct wsnt__TopicExpressionType *Topic = NULL;
	struct wsa__EndpointReferenceType *ProducerReference = NULL;	
	struct _wsnt__NotificationMessageHolderType_Message *Message = NULL;
	struct tt__ItemList *Source = NULL;
	struct tt__ItemList *Data = NULL;
	struct timeval tv;
	struct timeval current_tv;
	int i = 0;
	int k = 0;
	EventMsg *OutputEMsg = NULL;
	//EventMsg OutputEMsg[MAX_EVENT_NUM];

	// Check Time interval & MessageLimit
	if (tev__PullMessages->Timeout == NULL) { //Set default timeInterval = 10 sec 
		timeInterval = DEFAULT_EVENT_TIMEINTERVAL;
    	} else {
		if (parserTimeInterval(tev__PullMessages->Timeout, &timeInterval) == ERR) return SOAP_ERR;
		if (timeInterval < MIN_EVENT_TIMEINTERVAL) {
		        L1("error, timeInterval %d is out of range (it should be larger than 2 sec)\n", timeInterval);
		        return SOAP_ERR;
	    	}
	}
	
	MessageLimit = tev__PullMessages->MessageLimit;
	if(MessageLimit < MIN_EVENT_MESSAGE_LIMIT){
	        L1("MessageLimit %d is out of range (it should be larger than 1)\n", MessageLimit);
	        return SOAP_ERR;
	}

	// Set Action
	if(soap->header) {
		if(soap->header->wsa__Action.__item != NULL) {
		   strcpy(soap->header->wsa__Action.__item, "http://www.onvif.org/ver10/events/wsdl/PullPointSubscription/PullMessagesResponse");
		}
		// Get SubscriptionId
		if((soap->header->SubscriptionId > MAX_EVENT_SCRIPTION_NUM) || (soap->header->SubscriptionId < 1)) {
        		L1("error, invalid SubscriptionId %d not in (1~%d)\n", soap->header->SubscriptionId, MAX_EVENT_SCRIPTION_NUM);
        		return SOAP_ERR;
		}
	} else {
		L1("error, no soap header found\n");
		return SOAP_ERR;
	}
	index = soap->header->SubscriptionId-1;

	// Check timeout	
	if(gOnvifConf.scription[index].state != ONVIF_STATE_RUN) {
		L1("error, scription[%d].state=%d, no ONVIF_STATE_RUN\n", index, gOnvifConf.scription[index].state);
        	return SOAP_ERR;
	}

	OutputEMsg = (EventMsg *) soap_malloc (soap, sizeof(EventMsg)*MessageLimit);	
	//Check EventQueue
	EQIndex = gOnvifConf.scription[index].EQIndex;
	if(IsEventQHaveNewEvent(index, MessageLimit, &MessageCnt, OutputEMsg) == false_)
	{
		gettimeofday(&current_tv, NULL);
		tv.tv_sec = current_tv.tv_sec + timeInterval;
		while(current_tv.tv_sec < tv.tv_sec) {
			if(IsEventQHaveNewEvent(index, MessageLimit, &MessageCnt, OutputEMsg) == true_){
				break;
			}
			usleep(250000);
			gettimeofday(&current_tv, NULL);
		}
	}
	if(MessageCnt == 0)
	{
		MessageCnt = 1; 
		NoEvent = true_;
	}

	//Prepare PullMessagesResponse
	soap_default__tev__PullMessagesResponse(soap, tev__PullMessagesResponse);
	// Current time & TerminationTime
	tev__PullMessagesResponse->CurrentTime = gOnvifConf.scription[index].BeginTime; 
	tev__PullMessagesResponse->TerminationTime = gOnvifConf.scription[index].TerminationTime;
	tev__PullMessagesResponse->__sizeNotificationMessage = MessageCnt; 
	tev__PullMessagesResponse->wsnt__NotificationMessage = (struct wsnt__NotificationMessageHolderType *) soap_malloc (soap, sizeof(struct wsnt__NotificationMessageHolderType) * MessageCnt);
	for (i=0; i < MessageCnt; i++) {
		soap_default_wsnt__NotificationMessageHolderType(soap, &tev__PullMessagesResponse->wsnt__NotificationMessage[i]);
      }
	GenerateUUiD (item);
	
	for (i = 0 ; i < tev__PullMessagesResponse->__sizeNotificationMessage ; i++) {
		//Prepare NotifyMessage.Topic
		tev__PullMessagesResponse->wsnt__NotificationMessage[i].Topic = 
			(struct wsnt__TopicExpressionType *) soap_malloc (soap, sizeof (struct wsnt__TopicExpressionType));
		soap_default_wsnt__TopicExpressionType(soap, tev__PullMessagesResponse->wsnt__NotificationMessage[i].Topic);
		Topic = tev__PullMessagesResponse->wsnt__NotificationMessage[i].Topic;
		Topic->Dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple";
		//Prepare NotifyMessage.ProducerReference
		tev__PullMessagesResponse->wsnt__NotificationMessage[i].ProducerReference = 
			(struct wsa__EndpointReferenceType *) soap_malloc (soap, sizeof (struct wsa__EndpointReferenceType) );
		ProducerReference = tev__PullMessagesResponse->wsnt__NotificationMessage[i].ProducerReference;
		soap_default_wsa__EndpointReferenceType(soap, ProducerReference);
		ProducerReference->Address = 
			(struct wsa__AttributedURIType *) soap_malloc (soap, sizeof (struct wsa__AttributedURIType) * 1);
		ProducerReference->Address->__item = (char *) soap_malloc (soap, 64);
		sprintf (ProducerReference->Address->__item, "uri://%s/ProducerReference", item+5);
		//Prepare NotifyMessage.Message
		Message = &tev__PullMessagesResponse->wsnt__NotificationMessage[i].Message; 
		Message->tt__Message = (struct _tt__Message *) soap_malloc (soap, sizeof (struct _tt__Message));
		soap_default__tt__Message (soap, Message->tt__Message);
		//Prepare Message Source 
		Message->tt__Message->Source = (struct tt__ItemList *) soap_malloc (soap, sizeof (struct tt__ItemList));
		soap_default_tt__ItemList(soap, Message->tt__Message->Source);
		Source = Message->tt__Message->Source;
		Source->__sizeSimpleItem = 1; 
		Source->SimpleItem = (struct _tt__ItemList_SimpleItem *) soap_malloc (soap, sizeof (struct _tt__ItemList_SimpleItem));
		soap_default__tt__ItemList_SimpleItem(soap, Source->SimpleItem);
		//Prepare Message Data
		Message->tt__Message->Data = (struct tt__ItemList *) soap_malloc (soap, sizeof (struct tt__ItemList));
		soap_default_tt__ItemList(soap, Message->tt__Message->Data);
		Data = Message->tt__Message->Data;
		Data->__sizeSimpleItem = 1; 
		Data->SimpleItem = (struct _tt__ItemList_SimpleItem *) soap_malloc (soap, sizeof (struct _tt__ItemList_SimpleItem)); 
		soap_default__tt__ItemList_SimpleItem(soap, Data->SimpleItem);

		if(NoEvent == true_){
			if(gOnvifConf.DIs > 0){
				for(k = 0; k < gOnvifConf.DIs; k ++){
					if(IsEventTopicMatch(gOnvifConf.scription[index].Msg, EVENT_MSG_DI_1+k) == true_) {
						Topic->__any = OnvifDeviceVirtualPort;
						Source->SimpleItem->Name = VirtualPor_source_Name;
						Source->SimpleItem->Value = Data_Value[k+1];
						Data->SimpleItem->Name =  VirtualPor_data_Name;
						Data->SimpleItem->Value = Data_Value[gOnvifConf.DICurrentState[k].trigger];
						Message->tt__Message->UtcTime = current_tv.tv_sec; 
						Message->tt__Message->UtcTime_usec = current_tv.tv_usec;
						MessageCnt--;
						break;
					}
				}
			}
			if(MessageCnt > 0){
				for(k = 0; k < ONVIF_MOTION_WINDOWS; k ++){
					if(IsEventTopicMatch(gOnvifConf.scription[index].Msg, EVENT_MSG_WINDOW_1+k) == true_) {
						Topic->__any = OnvifDeviceMotion;
						Source->SimpleItem->Name = Motion_source_Name;
						Source->SimpleItem->Value = Data_Value[k+1];
						Data->SimpleItem->Name = Motion_data_Name;
						Data->SimpleItem->Value = Data_Value[gOnvifConf.MDCurrentState[k].state];
						Message->tt__Message->UtcTime = current_tv.tv_sec; 
						Message->tt__Message->UtcTime_usec = current_tv.tv_usec; 
						MessageCnt--;
						break;
					}
				}
			}
		}else if((OutputEMsg[i].NotifyEvent >= EVENT_MSG_DI_1) && (OutputEMsg[i].NotifyEvent <= EVENT_MSG_DI_4)){
			//Set DI Message Response Data
			Topic->__any = OnvifDeviceVirtualPort;
			Source->SimpleItem->Name = VirtualPor_source_Name;
			Source->SimpleItem->Value = Data_Value[OutputEMsg[i].NotifyEvent - EVENT_MSG_DI_1 + 1];
			Data->SimpleItem->Name =  VirtualPor_data_Name;
			Data->SimpleItem->Value = Data_Value[OutputEMsg[i].trigger];
			Message->tt__Message->UtcTime = OutputEMsg[i].TimeStamp.tv_sec; 
			Message->tt__Message->UtcTime_usec = OutputEMsg[i].TimeStamp.tv_usec; 
		}else if((OutputEMsg[i].NotifyEvent >= EVENT_MSG_WINDOW_1) && (OutputEMsg[i].NotifyEvent <= EVENT_MSG_WINDOW_3)){
			//Set MD Message Response Data
			Topic->__any = OnvifDeviceMotion;
			Source->SimpleItem->Name = Motion_source_Name;
			Source->SimpleItem->Value = Data_Value[OutputEMsg[i].NotifyEvent - EVENT_MSG_WINDOW_1 +1];
			Data->SimpleItem->Name = Motion_data_Name;
			Data->SimpleItem->Value = Data_Value[OutputEMsg[i].trigger];
			Message->tt__Message->UtcTime = OutputEMsg[i].TimeStamp.tv_sec; 
			Message->tt__Message->UtcTime_usec = OutputEMsg[i].TimeStamp.tv_usec; 
		}else{
	        	L1("error, Err Event Notify!!!\n");
			return SOAP_ERR;
		}
	}

	return SOAP_OK;
}

int __ns3__SetSynchronizationPoint(struct soap *soap, struct _tev__SetSynchronizationPoint *tev__SetSynchronizationPoint, struct _tev__SetSynchronizationPointResponse *tev__SetSynchronizationPointResponse)
{	
	if((soap->header) && (soap->header->wsa__Action.__item != NULL))
	{
		strcpy(soap->header->wsa__Action.__item, "http://www.onvif.org/ver10/events/wsdl/PullPointSubscription/SetSynchronizationPointResponse");
	}
	return SOAP_OK;
}

#ifdef HAVE__GETSERVICES
/** Auto-test server operation __ns5__GetServiceCapabilities */
int __ns4__GetServiceCapabilities(struct soap *soap, struct _tev__GetServiceCapabilities *tev__GetServiceCapabilities, struct _tev__GetServiceCapabilitiesResponse *tev__GetServiceCapabilitiesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}
#endif
int __ns4__CreatePullPointSubscription(struct soap *soap, struct _tev__CreatePullPointSubscription *tev__CreatePullPointSubscription,
                                       struct _tev__CreatePullPointSubscriptionResponse *tev__CreatePullPointSubscriptionResponse)
{	
    int i = 0;
    int index = -1;
    int timeInterval = 0;
    struct timeval tv;
    struct timeval TimeStamp;
    enum EventTopic Topic;
    enum MsgContent Msg;
    pthread_t event_t = 0;

    if((soap->header)&&(soap->header->wsa__Action.__item)) {
        sprintf(soap->header->wsa__Action.__item,
                "http://www.onvif.org/ver10/events/wsdl/EventPortType/CreatePullPointSubscriptionResponse");
    }
    soap_default__tev__CreatePullPointSubscriptionResponse(soap, tev__CreatePullPointSubscriptionResponse);
    tev__CreatePullPointSubscriptionResponse->SubscriptionReference = 
            (struct wsa__EndpointReferenceType *) soap_malloc (soap, sizeof (struct wsa__EndpointReferenceType));
    soap_default_wsa__EndpointReferenceType (soap, tev__CreatePullPointSubscriptionResponse->SubscriptionReference);
	
    //Address
    tev__CreatePullPointSubscriptionResponse->SubscriptionReference->Address = 
        (struct wsa__AttributedURIType *) soap_malloc (soap, sizeof (struct wsa__AttributedURIType) * 1);
    tev__CreatePullPointSubscriptionResponse->SubscriptionReference->Address->__item = (char *) soap_malloc (soap, 64);
    sprintf(tev__CreatePullPointSubscriptionResponse->SubscriptionReference->Address->__item,
            "http://%s" WEB_ONVIF_MEDIA, gOnvifConf.CurrentIP);
    tev__CreatePullPointSubscriptionResponse->SubscriptionReference->ReferenceParameters =
            (struct wsa__ReferenceParametersType *) soap_malloc (soap, sizeof (struct wsa__ReferenceParametersType) * 1);
    soap_default_wsa__ReferenceParametersType(soap, tev__CreatePullPointSubscriptionResponse->SubscriptionReference->ReferenceParameters);	
    //Time interval
    if (tev__CreatePullPointSubscription->InitialTerminationTime) {
		if ((parserTimeInterval(tev__CreatePullPointSubscription->InitialTerminationTime, &timeInterval) == ERR) ||
			(timeInterval <= 0) ){
        	return EventSoapFaultReply(soap,"ter:InvalidArgVal", "TerminationTime error", "the TerminationTime is not valid");
		}
    } else { /* this pull point handlet is alive until remote host delete it */
		timeInterval = 0;
	}
    //Filter
    if(tev__CreatePullPointSubscription->Filter != NULL) {	
        if(tev__CreatePullPointSubscription->Filter->TopicExpression != NULL) {
            if(tev__CreatePullPointSubscription->Filter->TopicExpression->__any == NULL){
			  if(gOnvifConf.DIs > 0) Topic = EVENT_TOPIC_ALL;
			  else                   Topic = EVENT_TOPIC_MD;
		}else{
			  L2("TopicExpression = %s\n", tev__CreatePullPointSubscription->Filter->TopicExpression->__any);
			  if (parserTopicExpression(tev__CreatePullPointSubscription->Filter->TopicExpression->__any, &Topic) == ERR) {
				return EventSoapFaultReply(soap,"ter:InvalidArgVal", "TopicExpression error", "the TopicExpression is not valid");
			  }
		}
        } else {
            if(gOnvifConf.DIs > 0) Topic = EVENT_TOPIC_ALL;
            else                   Topic = EVENT_TOPIC_MD;
        }
        if(tev__CreatePullPointSubscription->Filter->MessageContent != NULL) {
            L2("MessageContent = %s\n", tev__CreatePullPointSubscription->Filter->MessageContent->__any);
            if (parserMessageContent(tev__CreatePullPointSubscription->Filter->MessageContent->__any, Topic, &Msg) == ERR) {
                return EventSoapFaultReply(soap,"ter:InvalidArgVal", "MessageContent error", "the MessageContent is not valid");
            }
        } else {
            if(Topic == EVENT_TOPIC_MD) {
                Msg = EVENT_MSG_WINDOW_ALL;
            } else if(Topic == EVENT_TOPIC_DI) {
                Msg = EVENT_MSG_DI_ALL;
            } else {
                if(gOnvifConf.DIs > 0) Topic = EVENT_TOPIC_ALL;
                else                   Topic = EVENT_TOPIC_MD;
            }
        }
    } else {
        if(gOnvifConf.DIs > 0) {
            Topic = EVENT_TOPIC_ALL;
            Msg = EVENT_MSG_ALL;
        } else {
            Topic = EVENT_TOPIC_MD;
            Msg   = EVENT_MSG_WINDOW_ALL;
        }
    }
      

    tev__CreatePullPointSubscriptionResponse->SubscriptionReference->ReferenceParameters->SubscriptionId = -1;
    /* find a free subscription for this request */
    for (i = 0; i < MAX_EVENT_SCRIPTION_NUM; i++) {
        if( (gOnvifConf.state == ONVIF_STATE_RUN) &&
            (gOnvifConf.scription[i].enable == false_) &&
            (gOnvifConf.scription[i].state == ONVIF_STATE_CLOSE)) {
            gOnvifConf.scription[i].enable = true_;
            gOnvifConf.scription[i].state = ONVIF_STATE_INIT;
            gOnvifConf.scription[i].Method = EVENT_CREATE_PULLPOINT;
            gOnvifConf.scription[i].EQIndex = gOnvifConf.EventQueue.InsertIndex;
            TimeStamp.tv_sec = gOnvifConf.EventQueue.EMsg[gOnvifConf.EventQueue.InsertIndex].TimeStamp.tv_sec;
            TimeStamp.tv_usec = gOnvifConf.EventQueue.EMsg[gOnvifConf.EventQueue.InsertIndex].TimeStamp.tv_usec;
            gOnvifConf.scription[i].LastGetEventTime.tv_sec = TimeStamp.tv_sec;
            gOnvifConf.scription[i].LastGetEventTime.tv_usec = TimeStamp.tv_usec;
            gOnvifConf.scription[i].Topic = Topic;
            gOnvifConf.scription[i].Msg = Msg;
            gettimeofday(&tv, NULL);
            gOnvifConf.scription[i].BeginTime = tv.tv_sec; 
			if(timeInterval > 0) {
            	gOnvifConf.scription[i].TerminationTime = gOnvifConf.scription[i].BeginTime + timeInterval;
			} else {
				gOnvifConf.scription[i].TerminationTime = 0;
			}
            gOnvifConf.scription[i].SubscriptionId = i + 1;
		soap->header->SubscriptionId = gOnvifConf.scription[i].SubscriptionId;
            tev__CreatePullPointSubscriptionResponse->SubscriptionReference->ReferenceParameters->SubscriptionId = gOnvifConf.scription[i].SubscriptionId;
            L4("found a free subscription[%d]: Topic=%d, Msg=%d, %u/%u\n", i,
                gOnvifConf.scription[i].Topic, gOnvifConf.scription[i].Msg,
                (unsigned int)gOnvifConf.scription[i].BeginTime, (unsigned int)gOnvifConf.scription[i].TerminationTime);
            break;
        }
    }
    if(tev__CreatePullPointSubscriptionResponse->SubscriptionReference->ReferenceParameters->SubscriptionId == -1) {
        L1("error. not free scription\n");
        return EventSoapFaultReply(soap,"ter:InvalidArgVal", "SubscriptionId error", "the SubscriptionId is not valid");
    }
    /* create the event thread */
    index = i;
    if (pthread_create (&event_t, NULL, OnvifEventThread, (void *)&index)) {
        gOnvifConf.scription[i].state = ONVIF_STATE_CLOSE;
        gOnvifConf.scription[i].enable = false_;
        L1("error. create OnvifEventThread for scription[%d]\n", i); //Anne
        return SOAP_ERR;
    }
    usleep(100000);
    //CurrentTime & TerminationTime
    tev__CreatePullPointSubscriptionResponse->wsnt__CurrentTime = gOnvifConf.scription[i].BeginTime;
    tev__CreatePullPointSubscriptionResponse->wsnt__TerminationTime = gOnvifConf.scription[i].TerminationTime;
    config_change = true_;
    return SOAP_OK;
}


int __ns4__GetEventProperties(struct soap *soap, struct _tev__GetEventProperties *tev__GetEventProperties, struct _tev__GetEventPropertiesResponse *tev__GetEventPropertiesResponse)
{	
	/* Return incomplete response with default data values */
	struct tns1__VideoAnalytics *VideoAnalytics;	
	struct tns1__Device *Device;	

	if((soap->header) && (soap->header->wsa__Action.__item)) { 
		strcpy(soap->header->wsa__Action.__item, "http://www.onvif.org/ver10/events/wsdl/EventPortType/GetEventPropertiesResponse");
	}
	soap_default__tev__GetEventPropertiesResponse(soap, tev__GetEventPropertiesResponse);	
	tev__GetEventPropertiesResponse->__sizeTopicNamespaceLocation = 1;
	tev__GetEventPropertiesResponse->TopicNamespaceLocation = TopicNamespaceLocation;
	//tev__GetEventPropertiesResponse->wsnt__FixedTopicSet = false_;
    tev__GetEventPropertiesResponse->wsnt__FixedTopicSet = true_;

	tev__GetEventPropertiesResponse->wstop__TopicSet = 
		(struct wstop__TopicSetType *) soap_malloc (soap, sizeof (struct wstop__TopicSetType) * 1);
	soap_default_wstop__TopicSetType(soap, tev__GetEventPropertiesResponse->wstop__TopicSet);

	//VideoAnalytics of wstop__TopicSet
	VideoAnalytics = (struct tns1__VideoAnalytics *) soap_malloc (soap, sizeof (struct tns1__VideoAnalytics) * 1);
	soap_default_tns1__VideoAnalytics(soap, VideoAnalytics);
	VideoAnalytics->MotionDetection = 
		(struct tnsacti__MotionDetection *) soap_malloc (soap, sizeof (struct tnsacti__MotionDetection) * 1);
	soap_default_tnsacti__MotionDetection(soap,  VideoAnalytics->MotionDetection);
	VideoAnalytics->MotionDetection->MessageDescription =
		(struct tt__MessageDescription *) soap_malloc (soap, sizeof (struct tt__MessageDescription) * 1);
	soap_default_tt__MessageDescription(soap, VideoAnalytics->MotionDetection->MessageDescription);
	VideoAnalytics->MotionDetection->MessageDescription->Source =
		(struct tt__ItemListDescription *) soap_malloc (soap, sizeof (struct tt__ItemListDescription) * 1);
	soap_default_tt__ItemListDescription(soap, VideoAnalytics->MotionDetection->MessageDescription->Source);
	VideoAnalytics->MotionDetection->MessageDescription->Source->__sizeSimpleItemDescription = 1;
	VideoAnalytics->MotionDetection->MessageDescription->Source->SimpleItemDescription =
		(struct _tt__ItemListDescription_SimpleItemDescription *) soap_malloc (soap, sizeof (struct _tt__ItemListDescription_SimpleItemDescription) * 1);
	VideoAnalytics->MotionDetection->MessageDescription->Source->SimpleItemDescription->Name = Motion_source_Name; 
	VideoAnalytics->MotionDetection->MessageDescription->Source->SimpleItemDescription->Type = Motion_source_Type; 
	VideoAnalytics->MotionDetection->MessageDescription->Data =
		(struct tt__ItemListDescription *) soap_malloc (soap, sizeof (struct tt__ItemListDescription) * 1);
	soap_default_tt__ItemListDescription(soap, VideoAnalytics->MotionDetection->MessageDescription->Data);
	VideoAnalytics->MotionDetection->MessageDescription->Data->__sizeSimpleItemDescription = 1;

	VideoAnalytics->MotionDetection->MessageDescription->Data->SimpleItemDescription =
		(struct _tt__ItemListDescription_SimpleItemDescription *) soap_malloc (soap, sizeof (struct _tt__ItemListDescription_SimpleItemDescription) * 1);
	VideoAnalytics->MotionDetection->MessageDescription->Data->SimpleItemDescription->Name = Motion_data_Name; 
	VideoAnalytics->MotionDetection->MessageDescription->Data->SimpleItemDescription->Type = Motion_data_Type; 

	VideoAnalytics->MotionDetection->wstop__topic = true_;
	tev__GetEventPropertiesResponse->wstop__TopicSet->VideoAnalytics = VideoAnalytics;

	//Device of wstop__TopicSet
if (gOnvifConf.DIEnable == true_)
{
	Device = (struct tns1__Device *) soap_malloc (soap, sizeof (struct tns1__Device) * 1);
	soap_default_tns1__Device(soap, Device);
	Device->IO = 
		(struct tnsacti__IO *) soap_malloc (soap, sizeof (struct tnsacti__IO) * 1);
	soap_default_tnsacti__IO(soap, Device->IO);
	Device->IO->VirtualPort =
		(struct tnsacti__VirtualPort *) soap_malloc (soap, sizeof (struct tnsacti__VirtualPort) * 1);
	soap_default_tnsacti__VirtualPort(soap, Device->IO->VirtualPort);
	Device->IO->VirtualPort->MessageDescription =
		(struct tt__MessageDescription *) soap_malloc (soap, sizeof (struct tt__MessageDescription) * 1);
	soap_default_tt__MessageDescription(soap, Device->IO->VirtualPort->MessageDescription);
	Device->IO->VirtualPort->MessageDescription->Source =
		(struct tt__ItemListDescription *) soap_malloc (soap, sizeof (struct tt__ItemListDescription) * 1);
	soap_default_tt__ItemListDescription(soap, Device->IO->VirtualPort->MessageDescription->Source);
	Device->IO->VirtualPort->MessageDescription->Source->__sizeSimpleItemDescription = 1;
	Device->IO->VirtualPort->MessageDescription->Source->SimpleItemDescription =
		(struct _tt__ItemListDescription_SimpleItemDescription *) soap_malloc (soap, sizeof (struct _tt__ItemListDescription_SimpleItemDescription) * 1);
	Device->IO->VirtualPort->MessageDescription->Source->SimpleItemDescription->Name = VirtualPor_source_Name; 
	Device->IO->VirtualPort->MessageDescription->Source->SimpleItemDescription->Type = VirtualPor_source_Type; 
	Device->IO->VirtualPort->MessageDescription->Data =
		(struct tt__ItemListDescription *) soap_malloc (soap, sizeof (struct tt__ItemListDescription) * 1);
	soap_default_tt__ItemListDescription(soap, Device->IO->VirtualPort->MessageDescription->Data);
	Device->IO->VirtualPort->MessageDescription->Data->__sizeSimpleItemDescription = 1;

	Device->IO->VirtualPort->MessageDescription->Data->SimpleItemDescription =
		(struct _tt__ItemListDescription_SimpleItemDescription *) soap_malloc (soap, sizeof (struct _tt__ItemListDescription_SimpleItemDescription) * 1);
	Device->IO->VirtualPort->MessageDescription->Data->SimpleItemDescription->Name = VirtualPor_data_Name; 
	Device->IO->VirtualPort->MessageDescription->Data->SimpleItemDescription->Type = VirtualPor_data_Type; 

	Device->IO->VirtualPort->wstop__topic = true_;
	tev__GetEventPropertiesResponse->wstop__TopicSet->Device = Device;
} 

	tev__GetEventPropertiesResponse->__sizeTopicExpressionDialect = 2;
	tev__GetEventPropertiesResponse->wsnt__TopicExpressionDialect = wsnt__TopicExpressionDialect;
	tev__GetEventPropertiesResponse->__sizeMessageContentFilterDialect = 1;
	tev__GetEventPropertiesResponse->MessageContentFilterDialect = MessageContentFilterDialect;
	tev__GetEventPropertiesResponse->__sizeProducerPropertiesFilterDialect = 0;
	tev__GetEventPropertiesResponse->ProducerPropertiesFilterDialect = NULL;
	tev__GetEventPropertiesResponse->__sizeMessageContentSchemaLocation = 1;
	tev__GetEventPropertiesResponse->MessageContentSchemaLocation = MessageContentSchemaLocation;

	return SOAP_OK;
}


int __ns5__Renew(struct soap *soap, struct _wsnt__Renew *wsnt__Renew, struct _wsnt__RenewResponse *wsnt__RenewResponse)
{	
	/* Return incomplete response with default data values */
	static int index = 0;
	int timeInterval = 0;
	struct timeval tv;
	struct timeval TimeStamp;
      pthread_t event_t = 0;

	/* Return incomplete response with default data values */
	L2("SubscriptionId = %d\n", soap->header->SubscriptionId);
	if (wsnt__Renew->TerminationTime == NULL) return SOAP_REQUIRED;
	if((soap->header->SubscriptionId > MAX_EVENT_SCRIPTION_NUM) || (soap->header->SubscriptionId < 1))
	{	
        L1("error, invalid SubscriptionId %d/%d\n", soap->header->SubscriptionId, MAX_EVENT_SCRIPTION_NUM);
        return EventSoapFaultReply(soap,"ter:InvalidArgVal", "SubscriptionId error", "the SubscriptionId is not valid");
	}
	index = soap->header->SubscriptionId-1;
	if(gOnvifConf.scription[index].enable == false_) {
        L1("error, subscription %d is not running %d\n", index, gOnvifConf.scription[index].state);
        return EventSoapFaultReply(soap, "ter:InvalidArgVal", "renew error", "the event subscribe is not valid");
    }
	wsnt__RenewResponse->CurrentTime = (time_t *) soap_malloc (soap, sizeof (time_t) * 1);
	if (parserTimeInterval(wsnt__Renew->TerminationTime, &timeInterval) == OK)
	{
		gettimeofday(&tv, NULL);
		*wsnt__RenewResponse->CurrentTime = tv.tv_sec;
		wsnt__RenewResponse->TerminationTime = *wsnt__RenewResponse->CurrentTime + timeInterval;
	}	 
	else 
	{
		if(parserTimeString(wsnt__Renew->TerminationTime, &wsnt__RenewResponse->TerminationTime) == ERR) {
            return EventSoapFaultReply(soap,"ter:InvalidArgVal", "TerminationTime error", "the TerminationTime is not valid");
            }
		*wsnt__RenewResponse->CurrentTime = gOnvifConf.scription[index].BeginTime;
	}

	if(gOnvifConf.scription[index].enable == true_)
	{
		gOnvifConf.scription[index].BeginTime = *wsnt__RenewResponse->CurrentTime;
		gOnvifConf.scription[index].TerminationTime = wsnt__RenewResponse->TerminationTime;

      	gOnvifConf.scription[index].EQIndex = gOnvifConf.EventQueue.InsertIndex;
            TimeStamp.tv_sec = gOnvifConf.EventQueue.EMsg[gOnvifConf.EventQueue.InsertIndex].TimeStamp.tv_sec;
            TimeStamp.tv_usec = gOnvifConf.EventQueue.EMsg[gOnvifConf.EventQueue.InsertIndex].TimeStamp.tv_usec;
            gOnvifConf.scription[index].LastGetEventTime.tv_sec = TimeStamp.tv_sec;
            gOnvifConf.scription[index].LastGetEventTime.tv_usec = TimeStamp.tv_usec;

	} else {
        L1("error, subscription %d became not running %d\n", index, gOnvifConf.scription[index].state);
		return EventSoapFaultReply(soap, "ter:InvalidArgVal", "renew error", "the event subscribe is not valid");
    }
	if((gOnvifConf.scription[index].state == ONVIF_STATE_CLOSE) ||
		(gOnvifConf.scription[index].state == ONVIF_STATE_STOP)){
		gOnvifConf.scription[index].state = ONVIF_STATE_INIT;
		L2("ONVIF_STATE_RENEW\n");	
		if(gOnvifConf.scription[index].Method == EVENT_SUBSCRIPT){
			  if (pthread_create (&event_t, NULL, OnvifSubscriptionThread, (void *)&index)) {
			    L1("error. Renew OnvifSubscriptionThread for scription[%d]\n", index);
			    gOnvifConf.scription[index].state = ONVIF_STATE_CLOSE;
			    config_change = true_;
			    return SOAP_ERR;
			  } 
		}
		else if(gOnvifConf.scription[index].Method == EVENT_CREATE_PULLPOINT){
			  if (pthread_create (&event_t, NULL, OnvifEventThread, (void *)&index)) {
				L1("error. Renew OnvifEventThread for scription[%d]\n", index); 
				gOnvifConf.scription[index].state = ONVIF_STATE_CLOSE;
				return SOAP_ERR;
			  }
			
		}
		usleep(100000);
	}
	config_change = true_;
	return SOAP_OK;
}

int __ns5__Unsubscribe(	struct soap *soap, struct _wsnt__Unsubscribe *wsnt__Unsubscribe,
			struct _wsnt__UnsubscribeResponse *wsnt__UnsubscribeResponse)
{
    int index = 0;
    int i = 0;
    
    /* Return incomplete response with default data values */
    L2("SubscriptionId = %d\n", soap->header->SubscriptionId);
    if((soap->header->SubscriptionId > MAX_EVENT_SCRIPTION_NUM) || (soap->header->SubscriptionId < 1)) {
        L1("error, invalid SubscriptionId %d/%d\n", soap->header->SubscriptionId, MAX_EVENT_SCRIPTION_NUM);
        return EventSoapFaultReply(soap, "ter:InvalidArgVal", "SubscriptionId error", "the SubscriptionId is not valid");
    }
    index = soap->header->SubscriptionId-1;

/*    if (gOnvifConf.scription[index].state == ONVIF_STATE_CLOSE) {
        L1("error, the subscription is in close state %d\n", index);
	return EventSoapFaultReply(soap, "ter:InvalidArgVal", "renew error", "the event subscribe is not valid");
    }*/
    if (gOnvifConf.scription[index].enable == false_) {
        L1("error, the subscription is in close state %d\n", index);
	return EventSoapFaultReply(soap, "ter:InvalidArgVal", "renew error", "the event subscribe is not valid");
    }
    if (gOnvifConf.scription[index].state == ONVIF_STATE_STOP) {
	L1("the %d subscription was in STOP state\n", index);
        goto UNSUBSCRIBE;
    }
    if (gOnvifConf.scription[index].state == ONVIF_STATE_RUN) {
	L4("attempt to colse scription[%d]\n", index);
	gOnvifConf.scription[index].state = ONVIF_STATE_STOP;
    }
UNSUBSCRIBE:
    for (i = 0 ; i < 100 ; i++)  {
	usleep(100000);
	if(gOnvifConf.scription[index].state == ONVIF_STATE_CLOSE) {
	    L4("scription[%d] was closed\n", index);
	    break;
	}
    }
    if (i == 100) {
	L1 ("error. scription[%d] fail to leave\n", index);
	return SOAP_ERR;
    }
    gOnvifConf.scription[index].enable = false_;
    gOnvifConf.scription[index].state = ONVIF_STATE_CLOSE;
    gOnvifConf.scription[index].Topic = EVENT_TOPIC_ALL;
    gOnvifConf.scription[index].Msg = EVENT_MSG_ALL;
    gOnvifConf.scription[index].NotifyServer[0] = '\0';
    config_change = true_;
    return SOAP_OK;
}
int __ns6__Subscribe(struct soap *soap, struct _wsnt__Subscribe *wsnt__Subscribe,
		     struct _wsnt__SubscribeResponse *wsnt__SubscribeResponse)
{
    int i = 0;
    int timeInterval = 0;
    char Address[256];
    struct timeval tv;
    struct timeval TimeStamp;
    enum EventTopic Topic;
    enum MsgContent Msg;
    int index = -1;
    pthread_t event_t = 0;

    soap_default__wsnt__SubscribeResponse(soap, wsnt__SubscribeResponse);
    wsnt__SubscribeResponse->SubscriptionReference = 
	(struct wsa__EndpointReferenceType *) soap_malloc (soap, sizeof (struct wsa__EndpointReferenceType) * 1);
    soap_default_wsa__EndpointReferenceType (soap, wsnt__SubscribeResponse->SubscriptionReference);

    wsnt__SubscribeResponse->SubscriptionReference->Address = 
	(struct wsa__AttributedURIType *) soap_malloc (soap, sizeof (struct wsa__AttributedURIType) * 1);
    wsnt__SubscribeResponse->SubscriptionReference->Address->__item = (char *) soap_malloc (soap, 64);
    sprintf (wsnt__SubscribeResponse->SubscriptionReference->Address->__item, "http://%s" WEB_ONVIF_MEDIA, gOnvifConf.CurrentIP);

    wsnt__SubscribeResponse->SubscriptionReference->ReferenceParameters=
	(struct wsa__ReferenceParametersType *) soap_malloc (soap, sizeof (struct wsa__ReferenceParametersType) * 1);
    soap_default_wsa__ReferenceParametersType(soap, wsnt__SubscribeResponse->SubscriptionReference->ReferenceParameters);	

    if(wsnt__Subscribe->ConsumerReference->Address->__item == NULL) {
	L1("error. wsnt__Subscribe->ConsumerReference->Address->__item is NULL\n");
        return EventSoapFaultReply(soap, "ter:InvalidArgVal", "Invalid Addres", "Invalid consumer reference address");
    }
    snprintf(Address, sizeof(Address), "%s", wsnt__Subscribe->ConsumerReference->Address->__item);

    //Time interval
    if( (wsnt__Subscribe->InitialTerminationTime == NULL)||
	(parserTimeInterval(wsnt__Subscribe->InitialTerminationTime, &timeInterval) == ERR)) {
        if(wsnt__Subscribe->InitialTerminationTime == NULL) {
            L1("error. wsnt__Subscribe->ConsumerReference->Address->__item is NULL\n");
        } else {
            L1("error, parserTimeInterval(wsnt__Subscribe->InitialTerminationTime, &timeInterval)\n");
        }
        return EventSoapFaultReply(soap, "ter:InvalidArgVal", "Invalid Time", "Invalid Termination Time");
    }
    //Filter
    if(wsnt__Subscribe->Filter != NULL) {	
	if(wsnt__Subscribe->Filter->TopicExpression != NULL) {
	    if(wsnt__Subscribe->Filter->TopicExpression->__any == NULL){
		  Topic = EVENT_TOPIC_ALL;
	    }else {
		  L2("TopicExpression = %s\n", wsnt__Subscribe->Filter->TopicExpression->__any);
	 	  if( parserTopicExpression(wsnt__Subscribe->Filter->TopicExpression->__any, &Topic) == ERR)  {
                  return EventSoapFaultReply(soap, "ter:InvalidTopic", "Invalid Topic", "Invalid Topic");
              }
	    }
	} else Topic = EVENT_TOPIC_ALL;
	if(wsnt__Subscribe->Filter->MessageContent != NULL) {
	    if( (wsnt__Subscribe->Filter->MessageContent->__any == NULL) ||
		(parserMessageContent(wsnt__Subscribe->Filter->MessageContent->__any, Topic, &Msg) == ERR)) {
		if(wsnt__Subscribe->Filter->MessageContent->__any == NULL) {
                    L1("error, wsnt__Subscribe->Filter->MessageContent->__any is NULL\n");
                } else {
                    L1("error, parser parserMessageContent(wsnt__Subscribe->Filter->MessageContent->__any, Topic, &Msg)\n");
                }
                return EventSoapFaultReply(soap, "ter:InvalidMessage", "Invalid Message", "no Data in the MessageContent");                                       
            }
	    L2("MessageContent=%s\n", wsnt__Subscribe->Filter->MessageContent->__any);
	} else {
	    if(Topic == EVENT_TOPIC_MD)       Msg = EVENT_MSG_WINDOW_ALL;
	    else if(Topic == EVENT_TOPIC_DI)  Msg = EVENT_MSG_DI_ALL;
	    else                              Msg = EVENT_MSG_ALL;
	}
    } else {
	L4("no event filter\n");
	Topic = EVENT_TOPIC_ALL;
	Msg = EVENT_MSG_ALL;
    }
    //Set scription value
    gettimeofday(&tv, NULL);
    //SubscriptionId 
    wsnt__SubscribeResponse->SubscriptionReference->ReferenceParameters->SubscriptionId = -1;
    for (i = 0; i < MAX_EVENT_SCRIPTION_NUM; i++) {
	if( (gOnvifConf.state == ONVIF_STATE_RUN) &&
	    (gOnvifConf.scription[i].enable == false_) &&
	    (gOnvifConf.scription[i].state == ONVIF_STATE_CLOSE)) {
	    	gOnvifConf.scription[i].enable = true_;
	   	gOnvifConf.scription[i].state = ONVIF_STATE_INIT;
            gOnvifConf.scription[i].Method = EVENT_SUBSCRIPT;
      	gOnvifConf.scription[i].EQIndex = gOnvifConf.EventQueue.InsertIndex;
            TimeStamp.tv_sec = gOnvifConf.EventQueue.EMsg[gOnvifConf.EventQueue.InsertIndex].TimeStamp.tv_sec;
            TimeStamp.tv_usec = gOnvifConf.EventQueue.EMsg[gOnvifConf.EventQueue.InsertIndex].TimeStamp.tv_usec;
            gOnvifConf.scription[i].LastGetEventTime.tv_sec = TimeStamp.tv_sec;
            gOnvifConf.scription[i].LastGetEventTime.tv_usec = TimeStamp.tv_usec;
	    	gOnvifConf.scription[i].Topic = Topic;
	    	gOnvifConf.scription[i].Msg = Msg;
	    	gOnvifConf.scription[i].BeginTime = tv.tv_sec; 
	    	gOnvifConf.scription[i].TerminationTime = gOnvifConf.scription[i].BeginTime + timeInterval;
	    	strcpy(gOnvifConf.scription[i].NotifyServer, Address);
	    wsnt__SubscribeResponse->SubscriptionReference->ReferenceParameters->SubscriptionId = gOnvifConf.scription[i].SubscriptionId;
		soap->header->SubscriptionId = gOnvifConf.scription[i].SubscriptionId;
            break;
	}
    }
    if(wsnt__SubscribeResponse->SubscriptionReference->ReferenceParameters->SubscriptionId == -1) {
        L1("error, no free event entry. %d\n", MAX_EVENT_SCRIPTION_NUM);
        return EventSoapFaultReply(soap, "ter:InvalidArgVal", "event table is full", "no free event entry for this subscription"); 
    }
    /* create the event thread */
    index = i;
    if (pthread_create (&event_t, NULL, OnvifSubscriptionThread, (void *)&index)) {
	L1("error. create OnvifSubscriptionThread for scription[%d]\n", i);
	gOnvifConf.scription[i].state = ONVIF_STATE_CLOSE;
	gOnvifConf.scription[i].enable = false_;
	config_change = true_;
	return SOAP_ERR;
    } else usleep(100000);
    /* Response this Subscribe */
    wsnt__SubscribeResponse->CurrentTime = (time_t *) soap_malloc (soap, sizeof (time_t) * 1);
    wsnt__SubscribeResponse->TerminationTime = (time_t *) soap_malloc (soap, sizeof (time_t) * 1);;
    *wsnt__SubscribeResponse->CurrentTime = tv.tv_sec;
    *wsnt__SubscribeResponse->TerminationTime = *wsnt__SubscribeResponse->CurrentTime + timeInterval;
    return SOAP_OK;
}

int __ns7__Notify(struct soap *soap, struct _wsnt__Notify *wsnt__Notify)
{	
	return SOAP_OK;
}


#ifdef HAVE__GETSERVICES
/** Auto-test server operation __tds__GetServices */
int __tds__GetServices(struct soap *soap, struct _tds__GetServices *tds__GetServices, struct _tds__GetServicesResponse *tds__GetServicesResponse)
{	
	static char *device_ns[] = {
		"http://www.onvif.org/ver10/device/wsdl/Network",
		"http://www.onvif.org/ver10/media/wsdl",
		"http://www.onvif.org/ver10/events/wsdl",
		"http://www.onvif.org/ver10/ptz/wsdl",
		"http://www.onvif.org/ver20/imaging/wsdl"
	}; 
	enum 
	{
		NS_DEVICE = 0,
		NS_MEDIA, 
		NS_EVENTS, 
		NS_PTZ, 
		NS_IMAGING 
	}; 
	L4("is called\n");
	/* struct _tds__GetServicesResponse */
	soap_default__tds__GetServicesResponse (soap, tds__GetServicesResponse);
	/* struct tds__Service */
	tds__GetServicesResponse->__sizeService = 5;
	tds__GetServicesResponse->Service = (struct tds__Service *)soap_malloc(soap, sizeof(struct tds__Service)*tds__GetServicesResponse->__sizeService);
	soap_default_tds__Service (soap, &tds__GetServicesResponse->Service[0]);
	/* ###### Given Device Service ###### */
	tds__GetServicesResponse->Service[0].Namespace = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[0].Namespace, 0, 64);
	snprintf (tds__GetServicesResponse->Service[0].Namespace, 64, "%s", device_ns [NS_DEVICE]); 
	tds__GetServicesResponse->Service[0].XAddr = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[0].XAddr, 0, 64);
	tds__GetServicesResponse->Service[0].XAddr = gOnvifConf.MediaXAddr;
	tds__GetServicesResponse->Service[0].Capabilities =
        (struct _tds__Service_Capabilities *)soap_malloc (soap, sizeof (struct _tds__Service_Capabilities)); 
	soap_default__tds__Service_Capabilities (soap, tds__GetServicesResponse->Service[0].Capabilities);
	tds__GetServicesResponse->Service[0].Capabilities->__any = (char *) soap_malloc (soap, 8192);
	memset (tds__GetServicesResponse->Service[0].Capabilities->__any, 0, 8192);
	snprintf (tds__GetServicesResponse->Service[0].Capabilities->__any, 8192, 
              "<tds:Network>"
              "<tds:IPFilter>true</tds:IPFilter>"
              "<tds:ZeroConfiguration>true</tds:ZeroConfiguration>"
              "<tds:IPVersion6>true</tds:IPVersion6>"
              "<tds:DynDNS>true</tds:DynDNS>"
              "<tds:Dot11Configuration>false</tds:Dot11Configuration>"
              "<tds:HostnameFromDHCP>false</tds:HostnameFromDHCP>"
              "<tds:NTP>true</tds:NTP>"
              "</tds:Network>");
	tds__GetServicesResponse->Service[0].Version = 
		(struct tt__OnvifVersion *) 
		soap_malloc (soap, sizeof (struct tt__OnvifVersion));
	soap_default_tt__OnvifVersion (soap, tds__GetServicesResponse->Service[0].Version);
	tds__GetServicesResponse->Service[0].Version->Major = ONVIF_VERSION_MAJOR;
	tds__GetServicesResponse->Service[0].Version->Minor = ONVIF_VERSION_MINOR;
	/* ###### Given Media Service ###### */
	soap_default_tds__Service (soap, &tds__GetServicesResponse->Service[1]);
	tds__GetServicesResponse->Service[1].Namespace = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[1].Namespace, 0, 64);
	snprintf (tds__GetServicesResponse->Service[1].Namespace, 64, "%s", device_ns [NS_MEDIA]); 
	tds__GetServicesResponse->Service[1].XAddr = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[1].XAddr, 0, 64);
	tds__GetServicesResponse->Service[1].XAddr = gOnvifConf.MediaXAddr;
	tds__GetServicesResponse->Service[1].Capabilities = 
		(struct _tds__Service_Capabilities *)soap_malloc (soap, sizeof (struct _tds__Service_Capabilities)); 
	soap_default__tds__Service_Capabilities (soap, tds__GetServicesResponse->Service[1].Capabilities);
	tds__GetServicesResponse->Service[1].Version = 
		(struct tt__OnvifVersion *) soap_malloc (soap, sizeof (struct tt__OnvifVersion));
	soap_default_tt__OnvifVersion (soap, tds__GetServicesResponse->Service[1].Version);
	tds__GetServicesResponse->Service[1].Version->Major = ONVIF_VERSION_MAJOR;
	tds__GetServicesResponse->Service[1].Version->Minor = ONVIF_VERSION_MINOR;
	/* ###### Given Event Service ###### */
	soap_default_tds__Service (soap, &tds__GetServicesResponse->Service[2]);
	tds__GetServicesResponse->Service[2].Namespace = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[2].Namespace, 0, 64);
	snprintf (tds__GetServicesResponse->Service[2].Namespace, 64, "%s", device_ns [NS_EVENTS]); 
	tds__GetServicesResponse->Service[2].XAddr = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[2].XAddr, 0, 64);
	tds__GetServicesResponse->Service[2].XAddr = gOnvifConf.MediaXAddr;
	tds__GetServicesResponse->Service[2].Capabilities = 
		(struct _tds__Service_Capabilities *) soap_malloc (soap, sizeof (struct _tds__Service_Capabilities)); 
	soap_default__tds__Service_Capabilities (soap, tds__GetServicesResponse->Service[2].Capabilities);
	tds__GetServicesResponse->Service[2].Version = 
		(struct tt__OnvifVersion *) soap_malloc (soap, sizeof (struct tt__OnvifVersion));
	soap_default_tt__OnvifVersion (soap, tds__GetServicesResponse->Service[2].Version);
	tds__GetServicesResponse->Service[2].Version->Major = ONVIF_VERSION_MAJOR;
	tds__GetServicesResponse->Service[2].Version->Minor = ONVIF_VERSION_MINOR;
	/* ###### Given PTZ Service ###### */
	soap_default_tds__Service (soap, &tds__GetServicesResponse->Service[3]);
	tds__GetServicesResponse->Service[3].Namespace = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[3].Namespace, 0, 64);
	snprintf (tds__GetServicesResponse->Service[3].Namespace, 64, "%s", device_ns [NS_PTZ]); 
	tds__GetServicesResponse->Service[3].XAddr = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[3].XAddr, 0, 64);
	tds__GetServicesResponse->Service[3].XAddr = gOnvifConf.MediaXAddr;
	tds__GetServicesResponse->Service[3].Capabilities = 
            (struct _tds__Service_Capabilities *) soap_malloc (soap, sizeof (struct _tds__Service_Capabilities)); 
	soap_default__tds__Service_Capabilities (soap, tds__GetServicesResponse->Service[3].Capabilities);
	tds__GetServicesResponse->Service[3].Version = (struct tt__OnvifVersion *) soap_malloc (soap, sizeof (struct tt__OnvifVersion));
	soap_default_tt__OnvifVersion (soap, tds__GetServicesResponse->Service[3].Version);
	tds__GetServicesResponse->Service[3].Version->Major = ONVIF_VERSION_MAJOR;
	tds__GetServicesResponse->Service[3].Version->Minor = ONVIF_VERSION_MINOR;
	/* ###### Given Imaging Service ###### */
	soap_default_tds__Service (soap, &tds__GetServicesResponse->Service[4]);
	tds__GetServicesResponse->Service[4].Namespace = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[4].Namespace, 0, 64);
	snprintf (tds__GetServicesResponse->Service[4].Namespace, 64, "%s", device_ns [NS_IMAGING]); 
	tds__GetServicesResponse->Service[4].XAddr = (char *) soap_malloc(soap, 64);
	memset (tds__GetServicesResponse->Service[4].XAddr, 0, 64);
	tds__GetServicesResponse->Service[4].XAddr = gOnvifConf.MediaXAddr;
	tds__GetServicesResponse->Service[4].Capabilities = 
		(struct _tds__Service_Capabilities *) soap_malloc (soap, sizeof (struct _tds__Service_Capabilities)); 
	soap_default__tds__Service_Capabilities (soap, tds__GetServicesResponse->Service[4].Capabilities);
	tds__GetServicesResponse->Service[4].Version = (struct tt__OnvifVersion *) soap_malloc (soap, sizeof (struct tt__OnvifVersion));
	soap_default_tt__OnvifVersion (soap, tds__GetServicesResponse->Service[4].Version);
	tds__GetServicesResponse->Service[4].Version->Major = ONVIF_VERSION_MAJOR;
	tds__GetServicesResponse->Service[4].Version->Minor = ONVIF_VERSION_MINOR;

	return SOAP_OK;
}

/** Auto-test server operation __tds__GetServiceCapabilities */
int __tds__GetServiceCapabilities(struct soap *soap, struct _tds__GetServiceCapabilities *tds__GetServiceCapabilities, struct _tds__GetServiceCapabilitiesResponse *tds__GetServiceCapabilitiesResponse)
{		
	tUrlDB url;
	char value[2];
	char buf[64];
	char ReplyMsg[512];
    int  len = 0;

	static enum xsd__boolean IPFilter = false_;
	static enum xsd__boolean ZeroConfiguration = false_;
	static enum xsd__boolean DynDNS = false_;
	static int NTP = 1; //Maximum number of NTP servers supported by the devices SetNTP command.
    char V2WanStatusReply[320];

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "IP_FILTER_STATE");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
	{
		if((OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) && (strncmp(ReplyMsg, "ERROR", 5) != 0))
		{
			OnvifReplyMsgParser("IP_FILTER_STATE", ReplyMsg, value);
			IPFilter = (enum xsd__boolean) atoi(value);
		}
	}
	if (GetV2WanStatus (V2WanStatusReply, sizeof (V2WanStatusReply)) == OK) {
		OnvifReplyMsgParser("BONJOUR_CONFIG", V2WanStatusReply, buf);
		buf[1] = '\0';
		ZeroConfiguration = (enum xsd__boolean) atoi(buf);
	} else {
		ZeroConfiguration = 0;
	}
	strcpy(url.cmd, "DDNS");
	url.len = strlen(url.cmd);
	if(url.len > 0) {
		if((OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) && (strncmp(ReplyMsg, "ERROR", 5) != 0)) {
			OnvifReplyMsgParser("DDNS_TYPE", ReplyMsg, buf);
			DynDNS = (enum xsd__boolean) atoi(buf);
		}
	}
	/* struct _tds__GetServiceCapabilitiesResponse */
	soap_default__tds__GetServiceCapabilitiesResponse (soap, tds__GetServiceCapabilitiesResponse);
	/* struct tds__DeviceServiceCapabilities */
	tds__GetServiceCapabilitiesResponse->Capabilities = 
		(struct tds__DeviceServiceCapabilities *) soap_malloc (soap, sizeof (struct tds__DeviceServiceCapabilities));
	soap_default_tds__DeviceServiceCapabilities (soap, tds__GetServiceCapabilitiesResponse->Capabilities);
	/* struct tds__NetworkCapabilities */
	tds__GetServiceCapabilitiesResponse->Capabilities->Network = 
		(struct tds__NetworkCapabilities *) soap_malloc (soap, sizeof (struct tds__NetworkCapabilities));
	soap_default_tds__NetworkCapabilities (soap, tds__GetServiceCapabilitiesResponse->Capabilities->Network);
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->IPFilter = &IPFilter; 
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->ZeroConfiguration = &ZeroConfiguration; 
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->IPVersion6 = &blFalse; 
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->DynDNS = &DynDNS; 
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->Dot11Configuration = &blFalse; 
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->HostnameFromDHCP = &blFalse; 
	tds__GetServiceCapabilitiesResponse->Capabilities->Network->NTP = &NTP; 
	/* struct tds__SecurityCapabilities */
	tds__GetServiceCapabilitiesResponse->Capabilities->Security = 
		(struct tds__SecurityCapabilities *) soap_malloc (soap, sizeof (struct tds__SecurityCapabilities));
	soap_default_tds__SecurityCapabilities (soap, tds__GetServiceCapabilitiesResponse->Capabilities->Security);
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->TLS1_x002e0 = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->TLS1_x002e1 = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->TLS1_x002e2 = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->OnboardKeyGeneration = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->AccessPolicyConfig = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->DefaultAccessPolicy = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->Dot1X = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->RemoteUserHandling = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->X_x002e509Token = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->SAMLToken = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->KerberosToken = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->UsernameToken = &blTrue; // <==
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->HttpDigest = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->RELToken = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->Security->SupportedEAPMethods = NULL;
	/* struct tds__SystemCapabilities */
	tds__GetServiceCapabilitiesResponse->Capabilities->System = 
		(struct tds__SystemCapabilities *) soap_malloc (soap, sizeof (struct tds__SystemCapabilities));
	soap_default_tds__SystemCapabilities (soap, tds__GetServiceCapabilitiesResponse->Capabilities->System);
	tds__GetServiceCapabilitiesResponse->Capabilities->System->DiscoveryResolve = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->DiscoveryBye = &blTrue; // <==
	tds__GetServiceCapabilitiesResponse->Capabilities->System->RemoteDiscovery = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->SystemBackup = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->SystemLogging = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->FirmwareUpgrade = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->HttpFirmwareUpgrade = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->HttpSystemBackup = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->HttpSystemLogging = &blFalse;
	tds__GetServiceCapabilitiesResponse->Capabilities->System->HttpSupportInformation = &blFalse;
	/* struct tds__MiscCapabilities */
	tds__GetServiceCapabilitiesResponse->Capabilities->Misc = 
		(struct tds__MiscCapabilities *) soap_malloc (soap, sizeof (struct tds__MiscCapabilities));
	soap_default_tds__MiscCapabilities (soap, tds__GetServiceCapabilitiesResponse->Capabilities->Misc);
    len = ((MAX_AUX_LEN + 1) * 2) + 8; /* allocated space for string "oncmd, offCmd" */
	tds__GetServiceCapabilitiesResponse->Capabilities->Misc->AuxiliaryCommands = soap_malloc (soap, len); 
	snprintf (tds__GetServiceCapabilitiesResponse->Capabilities->Misc->AuxiliaryCommands, len-1, "%s, %s", 
		AuxiliaryAlarmOutputOn, AuxiliaryAlarmOutputOff); 
	return SOAP_OK;
}
#endif
 
int __tds__GetDeviceInformation (struct soap *soap, struct _tds__GetDeviceInformation *tds__GetDeviceInformation,
						 struct _tds__GetDeviceInformationResponse *tds__GetDeviceInformationResponse)
{
	int  modelLen = 8;
    
    if(gOnvifConf.brandACTi) modelLen = 8;
    else                     modelLen = 24;

	tds__GetDeviceInformationResponse->FirmwareVersion = (char *) soap_malloc(soap, 64);
    tds__GetDeviceInformationResponse->Manufacturer = (char *) soap_malloc(soap, 32);
    tds__GetDeviceInformationResponse->Model = (char *) soap_malloc(soap, modelLen);
    tds__GetDeviceInformationResponse->SerialNumber = (char *) soap_malloc(soap, 32);
    tds__GetDeviceInformationResponse->HardwareId = (char *) soap_malloc(soap, 32);
    
    if( (tds__GetDeviceInformationResponse->FirmwareVersion) && 
        (tds__GetDeviceInformationResponse->Manufacturer) &&
        (tds__GetDeviceInformationResponse->Model) &&
        (tds__GetDeviceInformationResponse->SerialNumber)) {
        snprintf(tds__GetDeviceInformationResponse->FirmwareVersion, 63, "%s", gOnvifConf.fwVer);
        snprintf(tds__GetDeviceInformationResponse->Manufacturer, 31, "%s", gOnvifConf.companyName);
        snprintf(tds__GetDeviceInformationResponse->SerialNumber, 31, "%s", gOnvifConf.serialNum);
        snprintf(tds__GetDeviceInformationResponse->Model, modelLen-1, "%s", gOnvifConf.ModelName);
        snprintf(tds__GetDeviceInformationResponse->HardwareId, 31, "%s", gOnvifConf.serialNum);
        return SOAP_OK;
    }
    /* fail to allocate the memory */
    fprintf(stderr, "%s:error. allocate the memory, free some memort later on\n", __func__);
    return SOAP_ERR;
}

int __tds__SetSystemDateAndTime (struct soap *soap, struct _tds__SetSystemDateAndTime *input,
				 struct _tds__SetSystemDateAndTimeResponse *tds__SetSystemDateAndTimeResponse)
{
///Top of 20130327 ///
//struct _tds__SetSystemDateAndTime *input
	//enum tt__SetDateTimeType DateTimeType;	/* required element of type tt:SetDateTimeType */
	//enum xsd__boolean DaylightSavings;	/* required element of type xsd:boolean */
	//struct tt__TimeZone *TimeZone;	/* optional element of type tt:TimeZone */
		//char *TZ;	/* required element of type xsd:token */
	//struct tt__DateTime *UTCDateTime;	/* optional element of type tt:DateTime */
		//struct tt__Time *Time;	/* required element of type tt:Time */
			//int Hour;	/* required element of type xsd:int */
			//int Minute;	/* required element of type xsd:int */
			//int Second;	/* required element of type xsd:int */
		//struct tt__Date *Date;	/* required element of type tt:Date */
			//int Year;	/* required element of type xsd:int */
			//int Month;	/* required element of type xsd:int */
			//int Day;	/* required element of type xsd:int */
///Bottom of 20130327 ///
	char TZString[32]; /* POSIX_TZString */
	char dlsStr[32]; /* M3.2.0,M11.1.0 */
	char TimeZone[16]; /* +00~-13 */
	char DLS[64]; /* a,1,c1,d1,e1,f1,2,c2,d2,e2 */
	int TimeZoneSec = 0;
	int idx = -1;
	struct tt__DateTime *utctime = NULL;
	tUrlDB url;
	char ReplyMsg[512];
	int DateType;
	char TimeString[32];
	time_t UTCtime;
	time_t LocalTime;
	struct tm *ptm = NULL;
/// Top of Winters ///
	char SntpAddress[16];
	char SntpUpdateInterval[16];
/// Bottom of Winters ///
	/* Date Type*/
	if (input == NULL)
		return SOAP_REQUIRED;
	DateType = input->DateTimeType + 1;
	/* TimeZone */
	TZString[0]= '\0';
	dlsStr[0]= '\0';
	TimeZone[0]= '\0';
	DLS[0]= '\0';
/// Top of Winters 
	strcpy(url.cgi, "system");
	strcpy(url.cmd, "DATE");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
	{
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) 
		{
			return SOAP_ERR;
		}
	}
/// Bottom of Winters 
	if(input->TimeZone != NULL)
	{
		if (input->TimeZone->TZ == NULL)
			return SOAP_REQUIRED;
		if (strchr (input->TimeZone->TZ, ',')) 
			sscanf (input->TimeZone->TZ, "%16[^,],%31s", TZString, dlsStr);
		else 
			sscanf (input->TimeZone->TZ, "%16s\n", TZString);
		if(POSIX_TZStringParser(TZString, &idx) == OK)
		{
			TimeZoneSec = aTZ[idx].tsec;
			strcpy(TimeZone, aTZ[idx].TZ);
		}
		else 
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidTimeZone", "Invalid data",
				"An invalid time zone was specified.");
	}
	else
	{
		if(OnvifReplyMsgParser("DATE_MANUAL_ZONE", ReplyMsg, TimeZone) == OK)
		{
			if(OK == TimeZoneStringParser(TimeZone, &idx))
				TimeZoneSec = aTZ[idx].tsec;
		}
	}

	if(OnvifReplyMsgParser("DATE_SNTP_IP", ReplyMsg, SntpAddress) != OK)
		return SOAP_ERR;
	if(OnvifReplyMsgParser("DATE_SNTP_UPDATE", ReplyMsg, SntpUpdateInterval) != OK)
		return SOAP_ERR;
	/* DayLight Saving*/
	if(dlsStr[0] == '\0')
	{
		strcpy(url.cgi, "system");
		strcpy(url.cmd, "DAYLIGHT_SAVING_CONFIG");
		url.len = strlen(url.cmd);
		if(url.len > 0) 
			if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK)
				return SOAP_ERR;
		OnvifReplyMsgParser("DAYLIGHT_SAVING_CONFIG", ReplyMsg, DLS);
	}
	else 
	{
		if (TZStringParser (dlsStr, DLS) == ERR) 
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidTimeZone", "Invalid data",
				"An invalid time zone was specified.");
	}
	if (input->DaylightSavings == false_) 
		DLS[0] = '0'; //Diable DLS
	else
		DLS[0] = '1'; //Enable DLS

	/* Set Value by sending URL CMD*/
	if (DateType == DATETIME_TYPE_MANUAL) 
	{
		if (input->UTCDateTime == NULL || input->UTCDateTime->Date == NULL || input->UTCDateTime->Time == NULL)
			return SOAP_REQUIRED;
		utctime = input->UTCDateTime;
		if (DateValueCheck (utctime->Date->Month, utctime->Date->Day, utctime->Date->Year) == ERR)
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidDateTime", "Invalid data",
				"An invalid date or time was specified.");
		if (TimeValueCheck (utctime->Time->Hour, utctime->Time->Minute, utctime->Time->Second) == ERR)
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidDateTime", "Invalid data",
				"An invalid date or time was specified.");
		sprintf(TimeString, "%4d-%2d-%2dT%2d:%2d:%2dZ", 
			utctime->Date->Year, utctime->Date->Month, utctime->Date->Day,
			utctime->Time->Hour, utctime->Time->Minute, utctime->Time->Second);

		if(parserTimeString(TimeString, &UTCtime) == ERR)
			 return SOAP_ERR;
		LocalTime = UTCtime + TimeZoneSec;
		ptm = gmtime (&LocalTime);

		strcpy(url.cgi, "system");
		sprintf(url.cmd, "DATE_CONFIG=%d,%02d%02d0000%4d,%02d:%02d:%02d,%s",
			DateType, ptm->tm_mon+1, ptm->tm_mday, ptm->tm_year + 1900, 
			ptm->tm_hour, ptm->tm_min, ptm->tm_sec, TimeZone);
		url.len = strlen(url.cmd);
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK)
			return SOAP_ERR;
	} else {
		/* SNTP case */
		strcpy(url.cgi, "system");
		//w: sprintf(url.cmd, "DATE_TYPE=%d&DATE_MANUAL_ZONE=%s", DateType, TimeZone);
		sprintf(url.cmd, "DATE_CONFIG=%d,%s,%s,%s", DateType, SntpAddress, SntpUpdateInterval, TimeZone); 
		url.len = strlen(url.cmd);
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK)
			return SOAP_ERR;
	}
	sprintf(url.cmd, "DAYLIGHT_SAVING_CONFIG=%s", DLS);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK)
	{
		return SOAP_ERR;
	}

	config_change = true_;
	return SOAP_OK;
}

int __tds__GetSystemDateAndTime (struct soap *soap, struct _tds__GetSystemDateAndTime *tds__GetSystemDateAndTime,
								 struct _tds__GetSystemDateAndTimeResponse *response)
{
	tUrlDB url;
	char ReplyMsg[512];
	char DateType[4];
	char TimeZone[16];
	char DLS[40];
	int index;
	tOnvifDLS dls;
	struct tt__DateTime *utc = NULL;
	struct tt__DateTime *local = NULL;
	time_t rawtime;
	struct tm *ptm = NULL;

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "DATE");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;
	
	response->SystemDateAndTime = (struct tt__SystemDateTime *) soap_malloc (soap, sizeof (struct tt__SystemDateTime));

	/* Date Type*/
	if(OnvifReplyMsgParser("DATE_TYPE", ReplyMsg, DateType) == OK)
	{
		response->SystemDateAndTime->DateTimeType = atoi(&DateType[0]) - 1;
	}

	/* Time Zone */
	if(OnvifReplyMsgParser("DATE_MANUAL_ZONE", ReplyMsg, TimeZone) == OK)
	{
		response->SystemDateAndTime->TimeZone = (struct tt__TimeZone *) soap_malloc (soap, sizeof (struct tt__TimeZone));
		if(OK == TimeZoneStringParser(TimeZone, &index))
		{
			response->SystemDateAndTime->TimeZone->TZ = (char *) soap_malloc(soap, 64);
			strcpy(response->SystemDateAndTime->TimeZone->TZ, aTZ[index].POSIX_TZString);
		}
	}

	/* Daylight Saving */
	strcpy(url.cmd, "DAYLIGHT_SAVING_CONFIG");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
	{
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) 
		{
			return SOAP_ERR;
		}
	}
	if(OnvifReplyMsgParser("DAYLIGHT_SAVING_CONFIG", ReplyMsg, DLS) == OK)
	{
		if (DlsConfTxt2Bin (DLS, &dls) != OK)
			L1 ("DlsConfTxt2Bin failed\n");
		GenerateTZString (response->SystemDateAndTime, &dls);
	}

	/* UTC DateTime */
	time (&rawtime);
	ptm = gmtime (&rawtime);
	response->SystemDateAndTime->UTCDateTime =
		(struct tt__DateTime *) soap_malloc (soap, sizeof (struct tt__DateTime));
	utc = response->SystemDateAndTime->UTCDateTime;
	utc->Date = (struct tt__Date *) soap_malloc (soap, sizeof (struct tt__Date));
	utc->Date->Year = ptm->tm_year + 1900;
	utc->Date->Month = ptm->tm_mon + 1;
	utc->Date->Day = ptm->tm_mday;
	utc->Time = (struct tt__Time *) soap_malloc (soap, sizeof (struct tt__Time));
	utc->Time->Hour = ptm->tm_hour;
	utc->Time->Minute = ptm->tm_min;
	utc->Time->Second = ptm->tm_sec;
	/* local Date Time */
	rawtime = rawtime + aTZ[index].tsec;
	ptm = gmtime (&rawtime);
	response->SystemDateAndTime->LocalDateTime =
		(struct tt__DateTime *) soap_malloc (soap, sizeof (struct tt__DateTime));
	local = response->SystemDateAndTime->LocalDateTime;
	local->Date = (struct tt__Date *) soap_malloc (soap, sizeof (struct tt__Date));
	local->Date->Year = ptm->tm_year + 1900;
	local->Date->Month = ptm->tm_mon + 1;
	local->Date->Day = ptm->tm_mday;
	local->Time = (struct tt__Time *) soap_malloc (soap, sizeof (struct tt__Time));
	local->Time->Hour = ptm->tm_hour;
	local->Time->Minute = ptm->tm_min;
	local->Time->Second = ptm->tm_sec;
	return SOAP_OK;
}


int __tds__SetSystemFactoryDefault (struct soap *soap,
				struct _tds__SetSystemFactoryDefault *tds__SetSystemFactoryDefault,
				struct _tds__SetSystemFactoryDefaultResponse *tds__SetSystemFactoryDefaultResponse)
{
	tUrlDB url;
	char ReplyMsg[512];

	strcpy(url.cgi, "system");

	if (tds__SetSystemFactoryDefault->FactoryDefault == Soft) {
		strcpy(url.cmd, "CONFIG_RESET");
	} else {
		strcpy(url.cmd, "FACTORY_DEFAULT");
	}
	url.len = strlen(url.cmd);

	if(url.len > 0) 
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;

	return SOAP_OK;
}


/** NVT BYE MESSAGE */
int __tds__SystemReboot (struct soap *soap, struct _tds__SystemReboot *tds__SystemReboot,
						 struct _tds__SystemRebootResponse *tds__SystemRebootResponse)
{
	tUrlDB url;
	char ReplyMsg[512];

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "SAVE_REBOOT");
	url.len = strlen(url.cmd);

	if(url.len > 0) 
	{
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;
	}

	tds__SystemRebootResponse->Message = "Reboot Device now...";
	return SOAP_OK;
}


int __tds__GetSystemLog(struct soap *soap, struct _tds__GetSystemLog *tds__GetSystemLog, struct _tds__GetSystemLogResponse *tds__GetSystemLogResponse)
{
	tUrlDB url;
	char ReplyMsg[4096];

	/* Return incomplete response with default data values */
	if(tds__GetSystemLog->LogType == System)
	{
		tds__GetSystemLogResponse->SystemLog = (struct tt__SystemLog *) soap_malloc(soap, sizeof(tt__SystemLog));
		tds__GetSystemLogResponse->SystemLog->String = ReplyMsg;
	
		strcpy(url.cgi, "system");
		strcpy(url.cmd, "SYSTEM_LOG");
		url.len = strlen(url.cmd);
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;
	}
	else
	{
		tds__GetSystemLogResponse->SystemLog = (struct tt__SystemLog *) soap_malloc(soap, sizeof(tt__SystemLog));
		tds__GetSystemLogResponse->SystemLog->String = NULL;
	}

	return SOAP_OK;
}

int __tds__GetScopes (struct soap *soap, struct _tds__GetScopes *tds__GetScopes,
					  struct _tds__GetScopesResponse *tds__GetScopesResponse)
{
	int i;

	tds__GetScopesResponse->__sizeScopes = gOnvifConf.Scopes.size;
	if (gOnvifConf.Scopes.size > 0) {
		tds__GetScopesResponse->Scopes =
			(struct tt__Scope *) soap_malloc (soap, sizeof (struct tt__Scope) * gOnvifConf.Scopes.size);
		soap_default_tt__Scope (soap, tds__GetScopesResponse->Scopes);
	}
	for (i = 0; i < gOnvifConf.Scopes.size; i++) {
		tds__GetScopesResponse->Scopes[i].ScopeDef = gOnvifConf.Scopes.difin[i];
		tds__GetScopesResponse->Scopes[i].ScopeItem = gOnvifConf.Scopes.Ptr[i];
	}
	return SOAP_OK;
}


int __tds__SetScopes (struct soap *soap, struct _tds__SetScopes *tds__SetScopes,
					  struct _tds__SetScopesResponse *tds__SetScopesResponse)
{
	//char *nscopes = NULL;
	//w: char *oscopes = NULL;
	//w: int i, j, index1 = -1, index2 = -1;
	int offset = 0;
	char tStr[MAX_SCOPES_STRLEN];
/// Top of Winters ///
	int i = 0,
	    j = 0,
	    k = 0,
	    idx = 0; 
	int flag = 0; 
	int NewScopeCounter = 0; 
	int NewScopeCounter2 = 0; 
	int NewScopeIndexes[MAX_SCOPES_STRLEN]; 
	int ConfigurableScopeIndexes[MAX_SCOPES_STRLEN]; 
/// Bottom of Winters ///
	if (tds__SetScopes->Scopes == NULL)
		return SOAP_REQUIRED;

	/*
 	   1. get index from difin
	   2. replace the first found configurable scope
	   3. replace it.
 	*/
	if (tds__SetScopes->__sizeScopes > MAX_SCOPES_LIST)
	{
		return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:TooManyScopes", "Too large scope list",
			"The scope list exceeds the supported number of scopes.");
	}
	for (i = 0; i < tds__SetScopes->__sizeScopes; i++) 
	{
		flag = 0; 
		for (j = 0; j < gOnvifConf.Scopes.size; j++)
		{
			if (tds__SetScopes->Scopes[i] == NULL)
				return SOAP_REQUIRED;
			if (strcmp (tds__SetScopes->Scopes[i], gOnvifConf.Scopes.Ptr[j]) == 0)
				break; 
			else
				flag = 1;
		}
		if (j == gOnvifConf.Scopes.size && flag == 1) 
			NewScopeIndexes[NewScopeCounter++] = i; 
	}
	if (NewScopeCounter == 0)
	{
		return soap_sender_fault_subcode_v2 (soap, "ter:OperationProhibited", "ter:ScopeOverwrite",
			"Overwrite", "Overwrite fixed device scope setting.");
	}
	if (strchr (gOnvifConf.Scopes.DifinStr, '1') != NULL)
	{
		// Searching for index of configurable scope 
		for (idx = 0; idx < gOnvifConf.Scopes.size * 2; idx += 2)
		{
			if (atoi (&gOnvifConf.Scopes.DifinStr[idx]) == Configurable)
				ConfigurableScopeIndexes[idx/2] = Configurable;
			else
				ConfigurableScopeIndexes[idx/2] = Fixed;
		}
		for (k = 0; k < gOnvifConf.Scopes.size; k++) 
		{
			if (ConfigurableScopeIndexes[k] == Fixed) 
				offset += sprintf (&tStr[offset], "%s  ", gOnvifConf.Scopes.Ptr[k]);
			else 
				offset += sprintf (&tStr[offset], "%s  ", 
					tds__SetScopes->Scopes[NewScopeIndexes[NewScopeCounter2++]]);
			if (offset > MAX_SCOPES_STRLEN)
				goto ERROR_HANDLE;
		}
	}

	strcpy (gOnvifConf.Scopes.tStr, tStr);
	//  printf("%s\n", gOnvifConf.Scopes.tStr);
	gOnvifConf.Scopes.size = GenerateScope (gOnvifConf.Scopes.tStr);
	gOnvifConf.MetaDataVerion++;
	soap->hello_callback = DiscoveryMulticast_Hello;
	config_change = true_;
	return SOAP_OK;
ERROR_HANDLE:
	return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:TooManyScopes", "Too large scope list",
		"The scope list exceeds the supported number of scopes.");
}


int __tds__AddScopes (struct soap *soap, struct _tds__AddScopes *tds__AddScopes,
					  struct _tds__AddScopesResponse *tds__AddScopesResponse)
{
	int i, j;
	int offset = 0, add = 1, t = 0;
	char tStr[MAX_SCOPES_STRLEN];
	int reject = 0;

	if (tds__AddScopes->ScopeItem == NULL)
		return SOAP_REQUIRED;
	if (gOnvifConf.Scopes.size + tds__AddScopes->__sizeScopeItem > MAX_SCOPES_LIST)
		return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:TooManyScopes", "Too large scope list",
			"The scope list exceeds the supported number of scopes.");
	for (i = 0; i < gOnvifConf.Scopes.size; i++) {
		offset += sprintf (&tStr[offset], "%s  ", gOnvifConf.Scopes.Ptr[i]);
	}
	for (i = 0; i < tds__AddScopes->__sizeScopeItem; i++) {
		add = 1;
		for (j = 0; j < gOnvifConf.Scopes.size; j++) {
			if (tds__AddScopes->ScopeItem[j] == NULL)
				return SOAP_REQUIRED;
			if (strcmp (gOnvifConf.Scopes.Ptr[j], tds__AddScopes->ScopeItem[i]) == 0) {
				add = 0;
				break;
			}
		}
		if (add) {
			if (strlen (tds__AddScopes->ScopeItem[i]) + strlen (tStr) > MAX_SCOPES_STRLEN - 1) {
				reject = 1;
				break;
			}
			if (strncmp (tds__AddScopes->ScopeItem[i], Scope_Category_loca, strlen (Scope_Category_loca)) == 0)
				gOnvifConf.Scopes.location_count++;
			offset += sprintf (&tStr[offset], "%s  ", tds__AddScopes->ScopeItem[i]);
			strcat (gOnvifConf.Scopes.DifinStr, "1,");
			t++;
		}
	}
	if (reject)
		return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:TooManyScopes", "Too large scope list",
										   "The scope list exceeds the supported number of scopes.");
	strcpy (gOnvifConf.Scopes.tStr, tStr);
	gOnvifConf.Scopes.size = GenerateScope (gOnvifConf.Scopes.tStr);
	if (t > 0) {
		gOnvifConf.MetaDataVerion++;
		soap->hello_callback = DiscoveryMulticast_Hello;
	}
	config_change = true_;
	return SOAP_OK;
}


int __tds__RemoveScopes (struct soap *soap, struct _tds__RemoveScopes *tds__RemoveScopes,
						 struct _tds__RemoveScopesResponse *tds__RemoveScopesResponse)
{
	int i, j;
	int offset = 0, removed, t = 0;
	int off2 = 0;
	char tStr[MAX_SCOPES_STRLEN];
	int reject = 0;

	if (tds__RemoveScopes->ScopeItem == NULL)
		return SOAP_REQUIRED;
	for (i = 0; i < gOnvifConf.Scopes.size; i++) {
		removed = 0;
		for (j = 0; j < tds__RemoveScopes->__sizeScopeItem; j++) {
			if (tds__RemoveScopes->ScopeItem[j] == NULL)
				return SOAP_REQUIRED;
			if (strcmp (tds__RemoveScopes->ScopeItem[j], gOnvifConf.Scopes.Ptr[i]) == 0) {
				if (gOnvifConf.Scopes.difin[i] == Configurable) {
					if (strncmp (tds__RemoveScopes->ScopeItem[j], Scope_Category_loca, strlen (Scope_Category_loca)) == 0) {
						if (gOnvifConf.Scopes.location_count > 1) {
							gOnvifConf.Scopes.location_count--;
							goto REMOVE_FLAG;
						} else
							reject++;
					} else {
					  REMOVE_FLAG:
						removed = 1;
						t++;
					}
				} else
					reject++;
			}
		}
		if (!removed) {
			offset += sprintf (&tStr[offset], "%s  ", gOnvifConf.Scopes.Ptr[i]);
//          if(!off2)
//              off2 += sprintf(&gOnvifConf.Scopes.DifinStr[off2], "%d", gOnvifConf.Scopes.difin[i]);
//          else 
			off2 += sprintf (&gOnvifConf.Scopes.DifinStr[off2], "%d,", gOnvifConf.Scopes.difin[i]);
		}
	}
	strcpy (gOnvifConf.Scopes.tStr, tStr);
	//  printf("RemoveScopes %s\n", gOnvifConf.Scopes.tStr);
	gOnvifConf.Scopes.size = GenerateScope (gOnvifConf.Scopes.tStr);
	if (reject)
		return soap_sender_fault_subcode_v2 (soap, "ter:OperationProhibited", "ter:FixedScope",
											 NULL, "Trying to delete fixed scope parameter, command rejected.");
	if (t > 0) {
		gOnvifConf.MetaDataVerion++;
		soap->hello_callback = DiscoveryMulticast_Hello;
	}
	config_change = true_;
	return SOAP_OK;
}

int __tds__GetDiscoveryMode (struct soap *soap, struct _tds__GetDiscoveryMode *tds__GetDiscoveryMode,
							 struct _tds__GetDiscoveryModeResponse *tds__GetDiscoveryModeResponse)
{
	tds__GetDiscoveryModeResponse->DiscoveryMode = (enum tt__DiscoveryMode) gOnvifConf.DiscoveryMode;
	return SOAP_OK;
}

int __tds__SetDiscoveryMode (struct soap *soap, struct _tds__SetDiscoveryMode *tds__SetDiscoveryMode,
							 struct _tds__SetDiscoveryModeResponse *tds__SetDiscoveryModeResponse)
{

	if(gOnvifConf.DiscoveryMode != (int)tds__SetDiscoveryMode->DiscoveryMode) {
		gOnvifConf.DiscoveryMode = (int)tds__SetDiscoveryMode->DiscoveryMode;
        config_change = true_;
        L4("discovery mode changed to %s\n", (gOnvifConf.DiscoveryMode == Discoverable)?"discoverable":"non-discoverable");
		(void)OnvifSingleUrlCmdSend("system", "SAVE", NULL, 0);
        sleep(1);
	}
	return SOAP_OK;
}

int CheckMsg(char *ReplyMsg, char *cmd)
{
	char *pCmd = NULL;

	if( (ReplyMsg == NULL) || (cmd == NULL)) return ERR;

	pCmd = strstr(ReplyMsg, cmd);
	if(pCmd == NULL) return ERR;
	
	return OK;
}

int GetAllUserAccounts(char *ReplyMsg, char *pName, char *pPwd, int *pMark, int MaxLen)
{

	tUrlDB url;
	int i=0;
	int num = 0;
	char *name = NULL;
	char *pwd = NULL;
	char item1[32];
	char item2[32];

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "ACCOUNT");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, MaxLen) != OK) return SOAP_ERR;
	while((CheckMsg(ReplyMsg, "ACCOUNT_ROOT_NAME") != OK) || (CheckMsg(ReplyMsg, "ACCOUNT_USER_PASSWORD_10") != OK))
	{
		sleep(1);
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;
	}
    /* get the root account name and password */
	if ((OK == OnvifReplyMsgParser("ACCOUNT_ROOT_NAME", ReplyMsg, pName)) &&
        (OK == OnvifReplyMsgParser("ACCOUNT_ROOT_PASSWORD", ReplyMsg, pPwd))) {
		pMark[0]=1;
		num++;
	} else {
		pMark[0]=0;
		pName[0]='\0';
		pPwd[0]='\0';
	}
    /* get the user account name and password */
	for (i = 1; i < MAX_ACCOUNT_NUM; i++) {
		sprintf(item1, "ACCOUNT_USER_NAME_%d", i);
		sprintf(item2, "ACCOUNT_USER_PASSWORD_%d", i);
		name = pName + ONVIF_ACCOUNT_NAME_LEN * i;
		pwd  = pPwd  + ONVIF_ACCOUNT_PWD_LEN * i;
		if ((OK == OnvifReplyMsgParser(item1, ReplyMsg, name)) &&
			(OK == OnvifReplyMsgParser(item2, ReplyMsg, pwd)) &&
            (strlen(name) > 0) ) {
            pMark[i]=1;
            num ++;
		} else {
			pMark[i]=0;
			name[0]='\0';
			pwd[0]='\0';
		}
	}
	return num;
}

int __tds__GetUsers (struct soap *soap, struct _tds__GetUsers *tds__GetUsers,
					 struct _tds__GetUsersResponse *tds__GetUsersResponse)
{
	int i,j=0;
	int num = 0;
	char ReplyMsg[1024];
	static char aName[11][ONVIF_ACCOUNT_NAME_LEN];
	static char aPwd[11][ONVIF_ACCOUNT_PWD_LEN];
	int aMark[11];

	num = GetAllUserAccounts(ReplyMsg, (char *)aName, (char *)aPwd, aMark, sizeof(ReplyMsg));

	tds__GetUsersResponse->__sizeUser = num ;
	tds__GetUsersResponse->User = (struct tt__User *) soap_malloc (soap, sizeof (struct tt__User) * num);

	//Root
	soap_default_tt__User (soap, &tds__GetUsersResponse->User[0]);
	tds__GetUsersResponse->User[0].Password = NULL;
	tds__GetUsersResponse->User[0].UserLevel = Administrator;
    #if 0
	if ((aName[0][0] != '\0') && (aPwd[0][0] != '\0')) tds__GetUsersResponse->User[0].Username = (char *)&aName[0];
	else tds__GetUsersResponse->User[0].Username = NULL;
    #else /* MY: allow null password */
    if(aName[0][0] != '\0') tds__GetUsersResponse->User[0].Username = (char *)&aName[0];
    else                    tds__GetUsersResponse->User[0].Username = NULL;
    #endif
	//User
	for (i = 1; i < MAX_ACCOUNT_NUM; i++) {
        #if 0
		if ((aName[i][0] != '\0') && (aPwd[i][0] != '\0') && (aMark[i]==1))
        #else /* MY: allow null password */
        if ((aName[i][0] != '\0') && (aMark[i]==1))
        #endif
		{
			j++;
			tds__GetUsersResponse->User[j].Username = (char *)&aName[i];
			tds__GetUsersResponse->User[j].Password = NULL;
			if(i <= 3)
				tds__GetUsersResponse->User[j].UserLevel = Administrator;
			else if(i<=6)
				tds__GetUsersResponse->User[j].UserLevel = Operator;
			else
				tds__GetUsersResponse->User[j].UserLevel = User;
			tds__GetUsersResponse->User[j].__anyAttribute = NULL;
		}
	}
	return SOAP_OK;
}

int __tds__CreateUsers (struct soap *soap, struct _tds__CreateUsers *tds__CreateUsers,
						struct _tds__CreateUsersResponse *tds__CreateUsersResponse)
{
	int i;
	int j=0;
	int num;
	int len = 0;
	tUrlDB url;
    char cmd[URLCMD_LEN];
	char ReplyMsg[1024];
	char aName[11][ONVIF_ACCOUNT_NAME_LEN];
	char aPwd[11][ONVIF_ACCOUNT_PWD_LEN];
	int  aMark[11];

	if (tds__CreateUsers->User == NULL)  return SOAP_REQUIRED;
	num = tds__CreateUsers->__sizeUser;		

	// Check the Username already exists or not
	GetAllUserAccounts(ReplyMsg, (char *)aName, (char *)aPwd, aMark, sizeof(ReplyMsg));
    /* check if new user name was in the account configurations */
	for(j = 0; j < num ; j++) {
		for(i=0; i<MAX_ACCOUNT_NUM; i++) {
			if(aMark[i]) {
                if(strcmp((char *)&aName[i], tds__CreateUsers->User[j].Username) == 0) {
                    return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:UsernameClash",
														"Username already exists", "Username already exists.");
                }
            }
		}
	}
	// Create new user
	strcpy(url.cgi, "system");
	url.cmd[0]='\0';
	url.len = 0;
	for (j = 0; j < num; j++) {
		// Check length of Username & Password
		if (tds__CreateUsers->User == NULL || tds__CreateUsers->User[j].Username == NULL) return SOAP_REQUIRED;
		len = strlen(tds__CreateUsers->User[j].Username);
		if(len <= 0) return SOAP_ERR;
		if(len > ONVIF_ACCOUNT_NAME_LEN) {
			return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:UsernameTooLong",
													  "Too long username", "The username is too long.");
		}
		if(tds__CreateUsers->User[j].Password) {
			len = strlen(tds__CreateUsers->User[j].Password);
            /*
			if(len <= 0) {
				return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:Password",
														  "Too weak password", "Too weak password.");
			}
            */
            if(len > ONVIF_ACCOUNT_PWD_LEN) {
				return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:PasswordTooLong",
														  "Too long password", "The password is too long.");
			}
		}
		// Create user by userlevel
		if(tds__CreateUsers->User[j].UserLevel == Administrator) {
			if(strcmp(tds__CreateUsers->User[j].Username, (char *)&aName[0]) == 0) continue; /* root accout */
			for (i = 1; i <= MAX_ACCOUNT_NUM/3; i++) {
				if(aMark[i]==0) {
					sprintf(cmd, "ACCOUNT_USER_%d=%s,%s", \
							i, tds__CreateUsers->User[j].Username, tds__CreateUsers->User[j].Password);
					aMark[i]=1;
					break;
				}
			}
			if (i > MAX_ACCOUNT_NUM/3) {
				return soap_receiver_fault_subcode_v2(soap, "ter:Action", "ter:TooManyUsers",
															"Too many users", "Maximum number of supported users exceeded.");
			}
		} else if(tds__CreateUsers->User[j].UserLevel == Operator) {
			for (i = MAX_ACCOUNT_NUM/3+1; i <= MAX_ACCOUNT_NUM/3*2; i++) {
				if(aMark[i]==0) {
					sprintf(cmd, "ACCOUNT_USER_%d=%s,%s", \
                            i, tds__CreateUsers->User[j].Username, tds__CreateUsers->User[j].Password);
					aMark[i]=1;
					break;
				}
			}
			if (i > MAX_ACCOUNT_NUM/3*2)
				return soap_receiver_fault_subcode_v2(soap, "ter:Action", "ter:TooManyUsers",
													  "Too many users", "Maximum number of supported users exceeded.");
		} else {
			for (i = MAX_ACCOUNT_NUM/3*2+1; i < MAX_ACCOUNT_NUM; i++) {
				if(aMark[i]==0)	{
					sprintf(cmd, "ACCOUNT_USER_%d=%s,%s", \
                            i, tds__CreateUsers->User[j].Username, tds__CreateUsers->User[j].Password);
					aMark[i]=1;
					break;
				}
			}
			if (i == MAX_ACCOUNT_NUM) {
				return soap_receiver_fault_subcode_v2(soap, "ter:Action", "ter:TooManyUsers",
					 								 "Too many users", "Maximum number of supported users exceeded.");
			}
		}
		OnvifCmdAdd(&url, cmd);
	}
	url.len = strlen(url.cmd);

	if(url.len == 0) return SOAP_OK; //Only create Root (needless to send URL because root is already exit.)
	
	L2("create user %s", url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) return SOAP_OK;
	
	return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:UsernameClash", 
											  "Username already exists", "Username already exists.");
}

int __tds__DeleteUsers (struct soap *soap, struct _tds__DeleteUsers *tds__DeleteUsers,
						struct _tds__DeleteUsersResponse *tds__DeleteUsersResponse)
{
	//int __sizeUsername;	/* sequence of elements <Username> */
	//char **Username;	/* required element of type xsd:string */
#if 1
	int i;
	int j=0;
	int num;
	tUrlDB url;
    	char cmd[URLCMD_LEN];
	char ReplyMsg[1024];
	char aName[11][ONVIF_ACCOUNT_NAME_LEN];
	char aPwd[11][ONVIF_ACCOUNT_PWD_LEN];
	int aMark[11];
	if (tds__DeleteUsers == NULL)
		return SOAP_REQUIRED;
	num = tds__DeleteUsers->__sizeUsername;		

	strcpy(url.cgi, "system");
	url.cmd[0]='\0';
	url.len = 0;

	//Check the Username already exists or not
	GetAllUserAccounts(ReplyMsg, (char *)aName, (char *)aPwd, aMark, sizeof(ReplyMsg));
	for(j=0; j<num; j++)
	{
		for(i=1; i<MAX_ACCOUNT_NUM; i++)
		{
			if (tds__DeleteUsers->Username[j] == NULL) return SOAP_REQUIRED;
			if(aName[i][0] == '\0') continue;
			if(strcmp((char *)&aName[i], tds__DeleteUsers->Username[j]) == 0)
			{
				//L1("old name = %s, delete user = %s\n", (char *)&aName[i], tds__DeleteUsers->Username[j]);
				if (i == 0)
					return soap_sender_fault_subcode_v2(soap, "ter:InvalidArgVal", "ter:FixedUser", "Removing fixed user", "Rootname may not be deleted.");

				sprintf(cmd, "ACCOUNT_USER_%d=\',\'", i);
				OnvifCmdAdd(&url, cmd);
				break;
			}
		}
		if(i == MAX_ACCOUNT_NUM)
			return soap_sender_fault_subcode_v2(soap, "ter:InvalidArgVal", "ter:UsernameMissing", "Username not recognized", "Username NOT recognized.");
	}
	url.len = strlen(url.cmd);
	//L1("%s", url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK)
		return SOAP_OK;
	else
		return SOAP_ERR;
#endif
}


int __tds__SetUser (struct soap *soap, struct _tds__SetUser *tds__SetUser,
					struct _tds__SetUserResponse *tds__SetUserResponse)
{
	int i;
	int j=0;
	int num;
	int len=0;
	tUrlDB url;
    char cmd[URLCMD_LEN];
	char ReplyMsg[1024];
	char aName[11][ONVIF_ACCOUNT_NAME_LEN];
	char aPwd[11][ONVIF_ACCOUNT_PWD_LEN];
	int aMark[11];
    
	if (tds__SetUser == NULL) return SOAP_REQUIRED;
	num = tds__SetUser->__sizeUser;		

	strcpy(url.cgi, "system");
	url.cmd[0]='\0';
	url.len = 0;

	// Check the Username already exists or not
	GetAllUserAccounts(ReplyMsg, (char *)aName, (char *)aPwd, aMark, sizeof(ReplyMsg));
	for(j=0; j<num; j++)
	{
		for(i=0; i<MAX_ACCOUNT_NUM; i++)
		{
			if (tds__SetUser->User == NULL || tds__SetUser->User[j].Username == NULL) return SOAP_REQUIRED;
			if(aName[i][0] == '\0') continue;
			if(strcmp((char *)&aName[i], tds__SetUser->User[j].Username) == 0) {
				//L1("old name = %s, set user = %s\n", &aName[i], tds__SetUser->User[j].Username);
				len = strlen(tds__SetUser->User[j].Password);
                /* MY: allow NULL password to pass Onvif Test Tool V13.06 for psec 2.4
                if(len <= 0)
					return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:PasswordTooWeak", "Too weak password", "The password is too short.");
				*/
				if(len > 64)
					return soap_sender_fault_subcode_v2(soap, "ter:OperationProhibited", "ter:PasswordTooLong", "Too long password", "The password is too long.");

				if(i == 0){
					sprintf(cmd, "ACCOUNT_ROOT=%s,%s", \
					tds__SetUser->User[j].Username, tds__SetUser->User[j].Password);
				}else{
					sprintf(cmd, "ACCOUNT_USER_%d=%s,%s", \
					i, tds__SetUser->User[j].Username, tds__SetUser->User[j].Password);
				}
				OnvifCmdAdd(&url, cmd);
				break;
			}
		}
		if(i == MAX_ACCOUNT_NUM)
			return soap_sender_fault_subcode_v2(soap, "ter:InvalidArgVal", "ter:UsernameMissing", "Username not recognized", "Username NOT recognized.");
	}
	url.len = strlen(url.cmd);
	//L1("setuser %s", url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK) 
		return SOAP_OK;
	else
		return SOAP_ERR;

}


int __tds__GetWsdlUrl (struct soap *soap, struct _tds__GetWsdlUrl *tds__GetWsdlUrl,
					   struct _tds__GetWsdlUrlResponse *tds__GetWsdlUrlResponse)
{
	tds__GetWsdlUrlResponse->WsdlUrl = gOnvifConf.WsdlUrl;
	return SOAP_OK;
}

int __tds__GetCapabilities (struct soap *soap, struct _tds__GetCapabilities *tds__GetCapabilities,
							struct _tds__GetCapabilitiesResponse *tds__GetCapabilitiesResponse)
{
	struct tt__Capabilities *cap = NULL;
    
	tds__GetCapabilitiesResponse->Capabilities = (struct tt__Capabilities *) soap_malloc (soap, sizeof (struct tt__Capabilities));
	soap_default_tt__Capabilities (soap, tds__GetCapabilitiesResponse->Capabilities);
	cap = tds__GetCapabilitiesResponse->Capabilities;
	if (tds__GetCapabilities->Category == NULL) {
		cap->Device = PrepareDeviceCap (soap);
		cap->Media = PrepareMediaCap (soap);
		cap->Imaging = PrepareImagingCap (soap);
		cap->Events = PrepareEventsCap (soap);
		if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.ZoomEnable == true_) ||
            (gOnvifConf.PTEnableBy485 == true_) || (gOnvifConf.ZoomEnableBy485 == true_) ) {
			cap->PTZ = PreparePTZCap (soap);
        }
		return SOAP_OK;
	}
	if (*tds__GetCapabilities->Category == All) {
		cap->Device = PrepareDeviceCap (soap);
		cap->Media = PrepareMediaCap (soap);
		cap->Imaging = PrepareImagingCap (soap);
		cap->Events = PrepareEventsCap (soap);
		if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.ZoomEnable == true_) ||
            (gOnvifConf.PTEnableBy485 == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
			cap->PTZ = PreparePTZCap (soap);
        }
		return SOAP_OK;
	}
	if (*tds__GetCapabilities->Category == Imaging) {
		cap->Imaging = PrepareImagingCap (soap);
		return SOAP_OK;
	}
	if (*tds__GetCapabilities->Category == Media) {
		cap->Media = PrepareMediaCap (soap);
		return SOAP_OK;
	}
	if (*tds__GetCapabilities->Category == Device) {
		cap->Device = PrepareDeviceCap (soap);
		return SOAP_OK;
	}
	if (*tds__GetCapabilities->Category == Events) {
		cap->Events = PrepareEventsCap (soap);
		return SOAP_OK;
	}
	if (*tds__GetCapabilities->Category == PTZ) {
        if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.ZoomEnable == true_) ||
            (gOnvifConf.PTEnableBy485 == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
            cap->PTZ = PreparePTZCap (soap);
            return SOAP_OK;
        }
	}
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:NoSuchService", NULL,
                                           "The requested WSDL service category is not supported by the device.");
}

#if 0

int __tds__SetDPAddresses (struct soap *soap, struct _tds__SetDPAddresses *tds__SetDPAddresses,
						   struct _tds__SetDPAddressesResponse *tds__SetDPAddressesResponse)
{
	return soap_sender_fault (soap, "", NULL);
}

#endif
int __tds__GetHostname (struct soap *soap, struct _tds__GetHostname *tds__GetHostname,
						struct _tds__GetHostnameResponse *tds__GetHostnameResponse)
{
	tUrlDB url;
	char ReplyMsg[512];
	static char hostname[68];

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "LAN_HOSTNAME");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;
	if(OK != OnvifReplyMsgParser("LAN_HOSTNAME", ReplyMsg, (char *)&hostname)) return SOAP_ERR; 
	tds__GetHostnameResponse->HostnameInformation =
		(struct tt__HostnameInformation *) soap_malloc (soap, sizeof (struct tt__HostnameInformation));
	if (tds__GetHostnameResponse->HostnameInformation == NULL) return SOAP_ERR; 
	soap_default_tt__HostnameInformation (soap, tds__GetHostnameResponse->HostnameInformation);
	tds__GetHostnameResponse->HostnameInformation->Name = (char *) soap_malloc (soap, 68);
	if (tds__GetHostnameResponse->HostnameInformation->Name == NULL) return SOAP_ERR; 
	strncpy (tds__GetHostnameResponse->HostnameInformation->Name, (char *)&hostname, 67); 
	tds__GetHostnameResponse->HostnameInformation->Name[67] = '\0'; 

	/* ACTi's IP camera don't support host name obtained from the DHCP server. */
	tds__GetHostnameResponse->HostnameInformation->FromDHCP = false_;
	return SOAP_OK;

}

int __tds__SetHostname (struct soap *soap, struct _tds__SetHostname *tds__SetHostname,
						struct _tds__SetHostnameResponse *tds__SetHostnameResponse)
{
	tUrlDB url;
	char ReplyMsg[512];

	if (tds__SetHostname == NULL || tds__SetHostname->Name == NULL)
		return SOAP_REQUIRED;
	strcpy(url.cgi, "system");
	strcpy(url.cmd, "LAN_HOSTNAME=");
	strcat(url.cmd, tds__SetHostname->Name);
	url.cmd[URLCMD_LEN-1] = '\0';

	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;

	if(strncmp(ReplyMsg, "OK", 2) == 0)
		return SOAP_OK;
	else
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidHostname",
			"Invalid name", "The requested hostname cannot be accepted by the NVT.");
}
static int OnvifGetDnsConf(char *pri, char *sec) {
    char reply[256];
    char dns[16];
    int  len = 0;
    
    if(OnvifSingleUrlCmdSend("system", "DNS", reply, (sizeof(reply)-1)) > 0) {
        len = OnvifGetValueFmUrlReply(reply, "DNS_PRIMARY=", dns, sizeof(dns));
        if((len > 0) && strcmp("0.0.0.0", dns)) snprintf(pri, 16, "%s", dns);
        else                                    pri[0] = '\0';
        len = OnvifGetValueFmUrlReply(reply, "DNS_SECONDARY=", dns, sizeof(dns));
        if((len > 0) && strcmp("0.0.0.0", dns)) snprintf(sec, 16, "%s", dns);
        else                                    sec[0] = '\0';
        return 0;
    }
    return -1;
}
static int OnvifGetRuntimeDnsConf(char *pri, char *sec) {
    FILE *fp = NULL;
    char *p  = NULL;
    char reply[256];
    int  idx = 0;
    
    fp = fopen("/etc/resolv.conf", "rb");
    if(fp) {
        while(fgets(reply, sizeof(reply), fp)) {
            p = strstr(reply, "nameserver");
            if(p) {
                p += strlen("nameserver");
                while(*p == ' ') p ++;
                if(idx == 0) {
                    snprintf(pri, 16, "%s", p);
                    p = strchr(pri, '\n');
                    if(p) *p = '\0';
                    idx ++;
                } else { /* idx is 1 */
                    snprintf(sec, 16, "%s", p);
                    p = strchr(pri, '\n');
                    if(p) *p = '\0';
                    idx ++;
                    break;
                }
            } /* not founc key, try next read */
        }
        if(idx == 0) return -1;
        if(idx == 1) sec[0] = '\0';
        return 0; 
    }
    return -1;
}
int __tds__GetDNS (struct soap *soap, struct _tds__GetDNS *tds__GetDNS, struct _tds__GetDNSResponse *tds__GetDNSResponse)
{
	static char *DnsConfPri, *DnsConfSec, *searchDomain;
    int  RuntimeDnsFromDhcp = 1;
    int  hasDnsPri=0, hasDnsSec=0;
    int  idx = 0;
    int  numOfDns = 0;

    DnsConfPri = (char *) soap_malloc (soap, 16);
    DnsConfSec = (char *) soap_malloc (soap, 16);
    if((DnsConfPri == NULL) && (DnsConfSec == NULL)) return SOAP_ERR;
    
    /* get the manual DNS configurations */
    if(OnvifGetDnsConf(DnsConfPri, DnsConfSec)) { /* fail to get DNS configurations */
        DnsConfPri[0] = '\0';
        DnsConfSec[0] = '\0';
    } else {
        if((strlen(DnsConfPri) > 0) || (strlen(DnsConfSec) > 0)) {
            /* DNS settings must not be fron DHCP */
            RuntimeDnsFromDhcp = 0;
        }
    }
    /* get the runtime DNS configurations */
    if(OnvifGetRuntimeDnsConf(gOnvifConf.DnsConfPri, gOnvifConf.DnsConfSec) == 0) {
        /* check if runtime DNS is from DHCP or not */
        if(strlen(gOnvifConf.DnsConfPri) > 0) {
            hasDnsPri = 1;
            numOfDns ++;
            snprintf(DnsConfPri, 16, "%s", gOnvifConf.DnsConfPri);
        }
        if(strlen(gOnvifConf.DnsConfSec) > 0) {
            hasDnsSec = 1;
            numOfDns ++;
            snprintf(DnsConfSec, 16, "%s", gOnvifConf.DnsConfSec);
        }
    } /* use current runtime DNS settings if failed to read runtime DNS settings */
    
    /* prepare the response messages */
    tds__GetDNSResponse->DNSInformation = (struct tt__DNSInformation *) soap_malloc (soap, sizeof(struct tt__DNSInformation));
    if(tds__GetDNSResponse->DNSInformation) soap_default_tt__DNSInformation (soap, tds__GetDNSResponse->DNSInformation);
    else                                    return SOAP_ERR;

    if(gOnvifConf.DnsFromDHCP == 1) { /* onvif expect the DNS settings are from DHCP */
        tds__GetDNSResponse->DNSInformation->FromDHCP = true_;
    } else {
        tds__GetDNSResponse->DNSInformation->FromDHCP = false_;
    }
    if(strlen(gOnvifConf.Domain) > 0) {
        searchDomain = (char *) soap_malloc (soap, ONVIF_SERACHDOMAIN_LEN);
        if(searchDomain) {
            snprintf(searchDomain, ONVIF_SERACHDOMAIN_LEN, "%s", gOnvifConf.Domain);
            tds__GetDNSResponse->DNSInformation->__sizeSearchDomain = 1;
            tds__GetDNSResponse->DNSInformation->SearchDomain = &searchDomain;
        } else {
            tds__GetDNSResponse->DNSInformation->__sizeSearchDomain = 0;
            tds__GetDNSResponse->DNSInformation->SearchDomain = NULL;
        }
    } else {
        tds__GetDNSResponse->DNSInformation->__sizeSearchDomain = 0;
        tds__GetDNSResponse->DNSInformation->SearchDomain = NULL;
    } 
    if(RuntimeDnsFromDhcp == 1) {
        tds__GetDNSResponse->DNSInformation->__sizeDNSFromDHCP = numOfDns;
        tds__GetDNSResponse->DNSInformation->__sizeDNSManual   = 0;
    } else {
        tds__GetDNSResponse->DNSInformation->__sizeDNSFromDHCP = 0;
        tds__GetDNSResponse->DNSInformation->__sizeDNSManual   = numOfDns;
    }
    /* give DHCP DNS settings if I have */
    if(tds__GetDNSResponse->DNSInformation->__sizeDNSFromDHCP) {
        tds__GetDNSResponse->DNSInformation->DNSFromDHCP = (struct tt__IPAddress *) soap_malloc(soap,
                (sizeof(struct tt__IPAddress) * tds__GetDNSResponse->DNSInformation->__sizeDNSFromDHCP));
        if(tds__GetDNSResponse->DNSInformation->__sizeDNSFromDHCP) {
            idx = 0;
            if(hasDnsPri) {
                soap_default_tt__IPAddress (soap, &tds__GetDNSResponse->DNSInformation->DNSFromDHCP[idx]);
                tds__GetDNSResponse->DNSInformation->DNSFromDHCP[idx].Type = IPv4;
                tds__GetDNSResponse->DNSInformation->DNSFromDHCP[idx].IPv4Address = &DnsConfPri;
                idx ++;
            }
            if(hasDnsPri) {
                soap_default_tt__IPAddress (soap, &tds__GetDNSResponse->DNSInformation->DNSFromDHCP[idx]);
                tds__GetDNSResponse->DNSInformation->DNSFromDHCP[idx].Type = IPv4;
                tds__GetDNSResponse->DNSInformation->DNSFromDHCP[idx].IPv4Address = &DnsConfSec;
            }
        }
    } else tds__GetDNSResponse->DNSInformation->DNSFromDHCP = NULL;
    /* give manual DNS settings if I have */
    if(tds__GetDNSResponse->DNSInformation->__sizeDNSManual) {
        tds__GetDNSResponse->DNSInformation->DNSManual = (struct tt__IPAddress *) soap_malloc (soap, 
                (sizeof (struct tt__IPAddress) * tds__GetDNSResponse->DNSInformation->__sizeDNSManual));
        if(tds__GetDNSResponse->DNSInformation->DNSManual) {
            idx = 0;
            if(hasDnsPri) {
                soap_default_tt__IPAddress (soap, &tds__GetDNSResponse->DNSInformation->DNSManual[idx]);
                tds__GetDNSResponse->DNSInformation->DNSManual[idx].Type = IPv4;
                tds__GetDNSResponse->DNSInformation->DNSManual[idx].IPv4Address = &DnsConfPri;
                idx ++;
            }
            if(hasDnsSec) {
                soap_default_tt__IPAddress (soap, &tds__GetDNSResponse->DNSInformation->DNSManual[idx]);
                tds__GetDNSResponse->DNSInformation->DNSManual[idx].Type = IPv4;
                tds__GetDNSResponse->DNSInformation->DNSManual[idx].IPv4Address = &DnsConfSec;
                idx ++;
            }
        }
    } else tds__GetDNSResponse->DNSInformation->DNSManual = NULL;
	return SOAP_OK;
}

int __tds__SetDNS (struct soap *soap, struct _tds__SetDNS *tds__SetDNS, struct _tds__SetDNSResponse *tds__SetDNSResponse)
{
	struct tt__IPAddress *sipaddr = NULL;
    char cmd[64];
    int  len = 0;
 
    if(tds__SetDNS->FromDHCP == false_) { /* set the manual DNS configueations */
        gOnvifConf.DnsFromDHCP = 0;
        if(tds__SetDNS->__sizeDNSManual > 0) {
            sipaddr = &tds__SetDNS->DNSManual[0];
            if((sipaddr->IPv4Address) && (CheckValidIPv4Address (sipaddr->IPv4Address[0]) == OK)) {
                len = snprintf(cmd, sizeof(cmd), "DNS_PRIMARY=\'%s\'", sipaddr->IPv4Address[0]);
            } else goto SetDnsIPv4AddrInvalid;
        }
        if(tds__SetDNS->__sizeDNSManual > 1) {
            sipaddr = &tds__SetDNS->DNSManual[1];
            if((sipaddr->IPv4Address) && (CheckValidIPv4Address (sipaddr->IPv4Address[0]) == OK)) {
                len += snprintf(&cmd[len], (sizeof(cmd)-len), "&DNS_SECONDARY=\'%s\'", sipaddr->IPv4Address[0]);
            } else goto SetDnsIPv4AddrInvalid;
        }
    } else {
        gOnvifConf.DnsFromDHCP = 1;
        /* remove the DNS configurations */
        len = snprintf(cmd, sizeof(cmd), "DNS_PRIMARY=\'\'&DNS_SECONDARY=\'\'");
    }
    if((tds__SetDNS->__sizeSearchDomain > 0) && (*tds__SetDNS->SearchDomain)) {
        snprintf(gOnvifConf.Domain, ONVIF_SERACHDOMAIN_LEN, "%s", *tds__SetDNS->SearchDomain);
    }
    if(len > 0) {
        (void)OnvifSingleUrlCmdSend("system", cmd, NULL, 0);
    }
    
    config_change = true_;
    
    return SOAP_OK;
    
SetDnsIPv4AddrInvalid:
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidIPv4Address", NULL,
                                         "The suggested IPv4 address is invalid.");
}


int __tds__GetNTP (struct soap *soap, struct _tds__GetNTP *tds__GetNTP,
				   struct _tds__GetNTPResponse *tds__GetNTPResponse)
{
	tUrlDB url;
	char ReplyMsg[512];
	static char SNTP_IP[16];

	tds__GetNTPResponse->NTPInformation =
		(struct tt__NTPInformation *) soap_malloc (soap, sizeof (struct tt__NTPInformation));
	soap_default_tt__NTPInformation (soap, tds__GetNTPResponse->NTPInformation);

	//We didn't support SetNTP from DHCP, so ...
	if(gOnvifConf.from_dhcp == true_)
	{
		tds__GetNTPResponse->NTPInformation->FromDHCP = true_;
		tds__GetNTPResponse->NTPInformation->__sizeNTPFromDHCP = 1;
		tds__GetNTPResponse->NTPInformation->NTPFromDHCP = 
			(struct tt__NetworkHost *) soap_malloc (soap, sizeof (struct tt__NetworkHost));
		soap_default_tt__NetworkHost (soap, tds__GetNTPResponse->NTPInformation->NTPFromDHCP);
		tds__GetNTPResponse->NTPInformation->NTPFromDHCP->Type = IPv4;
		return SOAP_OK;
	}
/// Top of Winters ///
	strcpy(url.cgi, "system");
	strcpy(url.cmd, "DATE");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
		OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
	tds__GetNTPResponse->NTPInformation->__sizeNTPManual = 1;
	tds__GetNTPResponse->NTPInformation->NTPManual =
		(struct tt__NetworkHost *) soap_malloc (soap, sizeof (struct tt__NetworkHost));
	soap_default_tt__NetworkHost (soap, tds__GetNTPResponse->NTPInformation->NTPManual);
	tds__GetNTPResponse->NTPInformation->NTPManual->Type = IPv4;
	tds__GetNTPResponse->NTPInformation->NTPManual->IPv4Address = (char **) soap_malloc (soap, 1);
	tds__GetNTPResponse->NTPInformation->NTPManual->IPv4Address[0] = (char *) soap_malloc (soap, 16);
	if (OnvifReplyMsgParser("DATE_SNTP_IP", ReplyMsg, SNTP_IP) == OK) 
	{
		strcpy (tds__GetNTPResponse->NTPInformation->NTPManual->IPv4Address[0], (char *)&SNTP_IP);
	}
	else 
		return SOAP_ERR; 
/// Bottom of Winters ///
	return SOAP_OK;
}


int __tds__SetNTP (struct soap *soap, struct _tds__SetNTP *tds__SetNTP,
				   struct _tds__SetNTPResponse *tds__SetNTPResponse)
{
	tUrlDB url;
	char ReplyMsg[512];
/// Top of Winters ///
	char TimeZone[4]; 
/// Bottom of Winters ///

	url.cmd[0] = '\0';

	if (tds__SetNTP->FromDHCP)
	{
		gOnvifConf.from_dhcp = true_;
		return SOAP_OK;
	}
	else
		gOnvifConf.from_dhcp = false_;
/// Top of Winters ///
	//get TimeZone here !!
	strcpy(url.cgi, "system");
	snprintf (url.cmd, URLCMD_LEN, "DATE"); 
	url.len = strlen(url.cmd);
	if(url.len > 0) 
	{
		if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) != OK) return SOAP_ERR;
	}
	if (OnvifReplyMsgParser ("DATE_MANUAL_ZONE", ReplyMsg, TimeZone) != OK)
	{
		return SOAP_ERR;
	}

/// Bottom of Winters ///
if (tds__SetNTP->NTPManual != NULL) {
	if (tds__SetNTP->NTPManual->DNSname)
		if (CheckValidName (tds__SetNTP->NTPManual->DNSname[0], 64) == ERR)
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidDnsName", NULL,
				"The suggested NTP server name is invalid.");
	if (tds__SetNTP->NTPManual->IPv4Address) {
		if (CheckValidIPv4Address (tds__SetNTP->NTPManual->IPv4Address[0]) == OK) 
		{
			//w: sprintf(url.cmd, "DATE_SNTP_IP=%s", tds__SetNTP->NTPManual->IPv4Address[0]);
			sprintf(url.cmd, "DATE_CONFIG=2,%s,86400,%s", tds__SetNTP->NTPManual->IPv4Address[0], TimeZone);
		} 
		else
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidIPv4Address", NULL,
				"The suggested IPv4 address is invalid.");
	}
	strcpy(url.cgi, "system");
	url.len = strlen(url.cmd);

	if(url.len > 0) 
	{
		if(OK != OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)))
		{
			return SOAP_ERR;
		}
	}
} //end of if (tds__SetNTP->NTPManual != NULL) 
	return SOAP_OK;
}


int __tds__GetDynamicDNS (struct soap *soap, struct _tds__GetDynamicDNS *tds__GetDynamicDNS,
						  struct _tds__GetDynamicDNSResponse *tds__GetDynamicDNSResponse)
{
	return SOAP_OK;
}


int __tds__SetDynamicDNS (struct soap *soap, struct _tds__SetDynamicDNS *tds__SetDynamicDNS,
						  struct _tds__SetDynamicDNSResponse *tds__SetDynamicDNSResponse)
{
	return SOAP_OK;
}

int __tds__GetNetworkInterfaces (struct soap *soap, struct _tds__GetNetworkInterfaces *tds__GetNetworkInterfaces,
							 struct _tds__GetNetworkInterfacesResponse *tds__GetNetworkInterfacesResponse)
{
	struct tt__NetworkInterface *netif = NULL;
	static int MTU = 1500;
	tUrlDB url;
	char ReplyMsg[512]; //w
	char ReplyMsg2[512]; //w
	char ManuelWanIP[16];
	char ManuelWanNetmask[16];
	char WanType[2];
	char LLIP[16];
	char DHCPWanNetmask[16];

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "WAN");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
	{
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) 
		{
			return SOAP_ERR;
		}
	}
	
	if (GetV2WanStatus (ReplyMsg2, sizeof (ReplyMsg2)) != OK)
		return SOAP_ERR;

	tds__GetNetworkInterfacesResponse->__sizeNetworkInterfaces = 1;
	tds__GetNetworkInterfacesResponse->NetworkInterfaces =
		(struct tt__NetworkInterface *) soap_malloc (soap, sizeof (struct tt__NetworkInterface));
	soap_default_tt__NetworkInterface (soap, tds__GetNetworkInterfacesResponse->NetworkInterfaces);
	netif = tds__GetNetworkInterfacesResponse->NetworkInterfaces;
	netif->token = "eth0";
	netif->Enabled = true_;
	netif->Info = (struct tt__NetworkInterfaceInfo *) soap_malloc (soap, sizeof (struct tt__NetworkInterfaceInfo));
	soap_default_tt__NetworkInterfaceInfo (soap, netif->Info);
	netif->Info->Name = "eth0";
	netif->Info->HwAddress = (char *) soap_malloc (soap, 20);
	sprintf(netif->Info->HwAddress, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c", 
		gOnvifConf.macar[0], gOnvifConf.macar[1], gOnvifConf.macar[2], 
		gOnvifConf.macar[3], gOnvifConf.macar[4], gOnvifConf.macar[5], 
		gOnvifConf.macar[6], gOnvifConf.macar[7], gOnvifConf.macar[8], 
		gOnvifConf.macar[9], gOnvifConf.macar[10], gOnvifConf.macar[11]); 

	L2("HwAddress = %s\n", netif->Info->HwAddress);
	netif->Info->MTU = &MTU;
	netif->Link = (struct tt__NetworkInterfaceLink *) soap_malloc (soap, sizeof (struct tt__NetworkInterfaceLink));
	soap_default_tt__NetworkInterfaceLink (soap, netif->Link);
	netif->Link->AdminSettings =
		(struct tt__NetworkInterfaceConnectionSetting *) soap_malloc (soap, sizeof (struct tt__NetworkInterfaceConnectionSetting));
	soap_default_tt__NetworkInterfaceConnectionSetting (soap, netif->Link->AdminSettings);
	netif->Link->AdminSettings->AutoNegotiation = true_;
	netif->Link->AdminSettings->Speed = 100;
	netif->Link->AdminSettings->Duplex = Full;
	netif->Link->OperSettings =
		(struct tt__NetworkInterfaceConnectionSetting *) soap_malloc (soap, sizeof (struct tt__NetworkInterfaceConnectionSetting));
	soap_default_tt__NetworkInterfaceConnectionSetting (soap, netif->Link->OperSettings);
	netif->Link->OperSettings->AutoNegotiation = true_;
	netif->Link->OperSettings->Speed = 100;
	netif->Link->OperSettings->Duplex = Full;
	netif->Link->InterfaceType = 6;	//refer to http://www.iana.org/assignments/ianaiftype-mib
	netif->IPv4 = (struct tt__IPv4NetworkInterface *) soap_malloc (soap, sizeof (struct tt__IPv4NetworkInterface));
	soap_default_tt__IPv4NetworkInterface (soap, netif->IPv4);
	netif->IPv4->Enabled = true_;
	netif->IPv4->Config = (struct tt__IPv4Configuration *) soap_malloc (soap, sizeof (struct tt__IPv4Configuration));
	soap_default_tt__IPv4Configuration (soap, netif->IPv4->Config);
	netif->IPv4->Config->__sizeManual = 1;
	netif->IPv4->Config->Manual =
		(struct tt__PrefixedIPv4Address *) soap_malloc (soap, sizeof (struct tt__PrefixedIPv4Address));
	soap_default_tt__PrefixedIPv4Address (soap, netif->IPv4->Config->Manual);
	if(OnvifReplyMsgParser("WAN_IP", ReplyMsg, ManuelWanIP) == OK)
	{
		netif->IPv4->Config->Manual->Address = (char *) soap_malloc (soap, 16);
		//w: strcpy(netif->IPv4->Config->Manual->Address, ManuelWanIP);
/// Top of Winters ///
		netif->IPv4->Config->Manual->Address[0] = '\0';
		strncpy(netif->IPv4->Config->Manual->Address, ManuelWanIP, 16);
/// Bottom of Winters ///
	}
	if(OnvifReplyMsgParser("WAN_NETMASK", ReplyMsg, ManuelWanNetmask) == OK)
		netif->IPv4->Config->Manual->PrefixLength = Netmask2Prefix (inet_addr (ManuelWanNetmask));

	netif->IPv4->Config->LinkLocal =
		(struct tt__PrefixedIPv4Address *) soap_malloc (soap, sizeof (struct tt__PrefixedIPv4Address));
	soap_default_tt__PrefixedIPv4Address (soap, netif->IPv4->Config->LinkLocal);
	netif->IPv4->Config->LinkLocal->Address = (char *) soap_malloc (soap, 16);
/// Top of Winters ///
	netif->IPv4->Config->LinkLocal->Address[0] = '\0';
/// Bottom of Winters ///
	if(OnvifReplyMsgParser("LLIP", ReplyMsg2, LLIP) == OK)
	{
		//w: strcpy(netif->IPv4->Config->LinkLocal->Address, LLIP); 
		strncpy(netif->IPv4->Config->LinkLocal->Address, LLIP, 16);  //w
	}
	netif->IPv4->Config->LinkLocal->PrefixLength = 16;
	netif->IPv4->Config->FromDHCP =
		(struct tt__PrefixedIPv4Address *) soap_malloc (soap, sizeof (struct tt__PrefixedIPv4Address));
	soap_default_tt__PrefixedIPv4Address (soap, netif->IPv4->Config->FromDHCP);
	netif->IPv4->Config->FromDHCP->Address = (char *) soap_malloc (soap, 16);
/// Top of Winters ///
	netif->IPv4->Config->FromDHCP->Address[0] = '\0';
/// Bottom of Winters ///
	//w: strcpy(netif->IPv4->Config->FromDHCP->Address, gOnvifConf.CurrentIP);
	strncpy(netif->IPv4->Config->FromDHCP->Address, gOnvifConf.CurrentIP, 16); //w
	if(OnvifReplyMsgParser("WAN_NETMASK", ReplyMsg2, DHCPWanNetmask) == OK)
		netif->IPv4->Config->FromDHCP->PrefixLength = Netmask2Prefix (inet_addr (DHCPWanNetmask));

	if(OnvifReplyMsgParser("WAN_TYPE", ReplyMsg, WanType) == OK)
	{
		if (atoi(WanType) == WAN_TYPE_DYNAMIC)
			netif->IPv4->Config->DHCP = true_;
		else
			netif->IPv4->Config->DHCP = false_;
	}

	return SOAP_OK;
}


int __tds__SetNetworkInterfaces (struct soap *soap, struct _tds__SetNetworkInterfaces *tds__SetNetworkInterfaces,
								 struct _tds__SetNetworkInterfacesResponse *tds__SetNetworkInterfacesResponse)
{
	int wantype;
	int i;
	char ipAddress[16];
	char netmask[16];
	char gateway[16];
	char *pRight = NULL;
	tUrlDB url;
	char ReplyMsg[512];
	char cmd[256];

	url.cmd[0] = '\0';
	cmd[0] = '\0';
	url.len = 0; 
	if ((tds__SetNetworkInterfaces->InterfaceToken == NULL) || (tds__SetNetworkInterfaces->NetworkInterface == NULL)) {
		return soap_sender_fault_subcode_v2(soap, "ter:InvalidArgVal", "ter:InvalidNetworkInterface", NULL,
                                            "The supplied network interface token does not exist.");
    }
	if (strcmp (tds__SetNetworkInterfaces->InterfaceToken, "eth0"))
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidNetworkInterface", NULL,
                                             "The supplied network interface token does not exists.");
                                             
	if(tds__SetNetworkInterfaces->NetworkInterface->MTU != NULL) {
        if(*tds__SetNetworkInterfaces->NetworkInterface->MTU > 1500) {	//RFC1191
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidMtuValue", NULL,
                                                 "The MTU value is invalid.");
		}
	}
	
    if (tds__SetNetworkInterfaces->NetworkInterface->IPv4 != NULL) {
        for (i = 0; i < tds__SetNetworkInterfaces->NetworkInterface->IPv4->__sizeManual; i++) {
            if ((tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual != NULL) &&
                (tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual[i].Address != NULL) &&
                (CheckValidIPv4Address (tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual[i].Address) != ERR)) {
                strncpy (ipAddress, tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual[i].Address, 16);
                strncpy (gateway  , tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual[i].Address, 16);
                pRight = strrchr(gateway, '.');
                if(pRight != NULL) {
                    gateway[pRight - gateway + 1]='\0'; 
                    strcat(gateway, "253");
                    sprintf(url.cmd, "WAN_IP=%s&WAN_GATEWAY=%s", ipAddress, gateway);
                }
		sprintf(url.cmd, "WAN_IP=%s&WAN_GATEWAY=%s", ipAddress, gateway);
                if (tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual[i].PrefixLength > 0) { //sub-mask
                    IpPrefix2Str (tds__SetNetworkInterfaces->NetworkInterface->IPv4->Manual[i].PrefixLength, netmask, sizeof (netmask));
                    sprintf(cmd, "WAN_NETMASK=%s", netmask);
                    OnvifCmdAdd(&url, cmd);
                }
            } else {
                return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidIPv4Address", NULL,
                                                     "The suggested IPv4 address is invalid.");
            }
        }
    }
	if (tds__SetNetworkInterfaces->NetworkInterface->IPv4->DHCP) {
		wantype = (*tds__SetNetworkInterfaces->NetworkInterface->IPv4->DHCP == true_ ? WAN_TYPE_DYNAMIC : WAN_TYPE_STATIC);
		sprintf(cmd, "WAN_TYPE=%d", wantype);
		OnvifCmdAdd(&url, cmd);
	}
	strcpy(url.cgi, "system");
	OnvifCmdAdd(&url, "SAVE");
	url.len = strlen(url.cmd);
	if(url.len > 0) {
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) {
            L1("error. send %s/%s\n", url.cgi, url.cmd);
			return SOAP_ERR;
		}
	}
    /* give time for firmware to save the configuration before return this function */
    sleep(1);
	/* wan configurations are not on-fly */
	tds__SetNetworkInterfacesResponse->RebootNeeded = true_;
	return SOAP_OK;
}


int __tds__GetNetworkProtocols (struct soap *soap, struct _tds__GetNetworkProtocols *tds__GetNetworkProtocols,
								struct _tds__GetNetworkProtocolsResponse *tds__GetNetworkProtocolsResponse)
{
	int i = 0;
	tUrlDB url;
	char ReplyMsg[512];
	char Port[8];
	int *HttpPort = NULL;
#ifdef SUPPORT_HTTPS
	int *HttpsPort = NULL;
#endif
	int *RtspPort = NULL;

	strcpy(url.cgi, "system");

	tds__GetNetworkProtocolsResponse->__sizeNetworkProtocols = 2;
#ifdef SUPPORT_HTTPS
	tds__GetNetworkProtocolsResponse->__sizeNetworkProtocols++;
#endif
	tds__GetNetworkProtocolsResponse->NetworkProtocols =
		(struct tt__NetworkProtocol *) soap_malloc (soap,
			sizeof (struct tt__NetworkProtocol) * tds__GetNetworkProtocolsResponse->__sizeNetworkProtocols);
	// HTTP
	soap_default_tt__NetworkProtocol (soap, &tds__GetNetworkProtocolsResponse->NetworkProtocols[i]);
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Name = HTTP_;
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Enabled = true_;	/* HTTP always true */
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].__sizePort = 1;
	HttpPort = (int *) soap_malloc (soap, sizeof(int));
	*HttpPort = gOnvifConf.HttpPort;
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Port = HttpPort;
	i++;
#ifdef SUPPORT_HTTPS
	//HTTPS
	soap_default_tt__NetworkProtocol (soap, &tds__GetNetworkProtocolsResponse->NetworkProtocols[i]);
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Name = HTTPS;
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Enabled = true_;
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].__sizePort = 1;
	strcpy(url.cmd, "PORT_HTTPS");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
		OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
	if (OK == OnvifReplyMsgParser("PORT_HTTPS", ReplyMsg, Port))
	{
		HttpsPort = (int *) soap_malloc (soap, sizeof(int));
		*HttpsPort = atoi(Port);
		tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Port = HttpsPort;
	}
	i++;
#endif
	//RTSP
	soap_default_tt__NetworkProtocol (soap, &tds__GetNetworkProtocolsResponse->NetworkProtocols[i]);
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Name = RTSP_;
	if(gOnvifConf.rtsp_status == false_)
		tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Enabled = false_;
	else
		tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Enabled = true_;
	tds__GetNetworkProtocolsResponse->NetworkProtocols[i].__sizePort = 1;
	strcpy(url.cmd, "V2_PORT_RTSP");
	url.len = strlen(url.cmd);
	if(url.len > 0) 
		OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
	if (OK == OnvifReplyMsgParser("V2_PORT_RTSP", ReplyMsg, Port))
	{
		RtspPort = (int *) soap_malloc (soap, sizeof(int));
		*RtspPort = atoi(Port);
		tds__GetNetworkProtocolsResponse->NetworkProtocols[i].Port = RtspPort;
	}

	return SOAP_OK;
}


int __tds__SetNetworkProtocols (struct soap *soap, struct _tds__SetNetworkProtocols *tds__SetNetworkProtocols,
								struct _tds__SetNetworkProtocolsResponse *tds__SetNetworkProtocolsResponse)
{
	int i;
	tUrlDB url;
	char ReplyMsg[512];
	int HttpPort = -1;
#ifdef SUPPORT_HTTPS
	int HttpsPort;
#endif
	int RtspPort;
	char cmd[256];

	strcpy(url.cgi, "system");
	url.cmd[0] = '\0';
	if (tds__SetNetworkProtocols->NetworkProtocols == NULL 
	   || tds__SetNetworkProtocols->NetworkProtocols->Port == NULL)
		return SOAP_REQUIRED;
	for (i = 0; i < tds__SetNetworkProtocols->__sizeNetworkProtocols; i++) {
		switch (tds__SetNetworkProtocols->NetworkProtocols[i].Name) {
		case HTTP_:
			/* http alwary true */
			if (tds__SetNetworkProtocols->NetworkProtocols[i].Enabled == false_ ||
				tds__SetNetworkProtocols->NetworkProtocols[i].__sizePort > 1)
				goto FAILED;
			HttpPort = *tds__SetNetworkProtocols->NetworkProtocols[i].Port;
			sprintf(cmd, "PORT_HTTP=%d", HttpPort);
			break;
#ifdef SUPPORT_HTTPS
		case HTTPS:
			if (tds__SetNetworkProtocols->NetworkProtocols[i].Enabled == false_ ||
				tds__SetNetworkProtocols->NetworkProtocols[i].__sizePort > 1)
				goto FAILED;
			HttpsPort = *tds__SetNetworkProtocols->NetworkProtocols[i].Port;
			sprintf(cmd, "PORT_HTTPS=%d", HttpsPort);
			break;
#endif
		case RTSP_:
			if (tds__SetNetworkProtocols->NetworkProtocols[i].Enabled == false_)
			{
				gOnvifConf.rtsp_status = false_;
				return SOAP_OK;
			}
			else
				gOnvifConf.rtsp_status = true_;

			if (tds__SetNetworkProtocols->NetworkProtocols[i].__sizePort > 1)
				return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ServiceNotSupported", NULL, NULL);
			RtspPort = *tds__SetNetworkProtocols->NetworkProtocols[i].Port;
			sprintf(cmd, "V2_PORT_RTSP=%d", RtspPort);
			break;
		default:
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ServiceNotSupported",
									 NULL, "The supplied network service is not supported.");
		}
		if(url.cmd[0] == '\0')
			strcpy(url.cmd, cmd);
		else
			OnvifCmdAdd(&url, cmd);
	}
	url.len = strlen(url.cmd);

	if(url.len > 0) 
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) return SOAP_ERR;
	
	if(HttpPort != -1)
		gOnvifConf.HttpPort = HttpPort;

	return SOAP_OK;
  FAILED:
	return soap_sender_fault (soap, "", NULL);
}

int __tds__GetNetworkDefaultGateway (struct soap *soap,
			 struct _tds__GetNetworkDefaultGateway *tds__GetNetworkDefaultGateway,
			 struct _tds__GetNetworkDefaultGatewayResponse
			 *tds__GetNetworkDefaultGatewayResponse)
{
    char ReplyMsg[512];
    char value[16];

    if (GetV2WanStatus (ReplyMsg, sizeof (ReplyMsg)) == OK) {
	if(OnvifReplyMsgParser("WAN_GATEWAY=", ReplyMsg, value) == ERR) {
	    L1("error, fail to get WAN_GATEWAY=%s from %s\n", value, ReplyMsg);
	    return SOAP_ERR;
	}
    } else { 
	return SOAP_ERR; 
    }
    tds__GetNetworkDefaultGatewayResponse->NetworkGateway =
	(struct tt__NetworkGateway *) soap_malloc (soap, sizeof (struct tt__NetworkGateway));
    soap_default_tt__NetworkGateway (soap, tds__GetNetworkDefaultGatewayResponse->NetworkGateway);
    tds__GetNetworkDefaultGatewayResponse->NetworkGateway->__sizeIPv4Address = 1;
    tds__GetNetworkDefaultGatewayResponse->NetworkGateway->IPv4Address = (char **)soap_malloc (soap, 1);
    tds__GetNetworkDefaultGatewayResponse->NetworkGateway->IPv4Address[0] = (char *)soap_malloc (soap, 16);
    strcpy (tds__GetNetworkDefaultGatewayResponse->NetworkGateway->IPv4Address[0], value); 	
    return SOAP_OK;
}


int __tds__SetNetworkDefaultGateway (struct soap *soap,
			 struct _tds__SetNetworkDefaultGateway *tds__SetNetworkDefaultGateway,
			 struct _tds__SetNetworkDefaultGatewayResponse *tds__SetNetworkDefaultGatewayResponse)
{
    tUrlDB url;
    char ReplyMsg[512];

    if ((tds__SetNetworkDefaultGateway->IPv4Address == NULL) ||
	(CheckValidIPv4Address (tds__SetNetworkDefaultGateway->IPv4Address[0]) == ERR)) {
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidGatewayAddress", NULL,
					     "The supplied gateway address was invalid.");
    }
    strcpy(url.cgi, "system");
    url.len = sprintf(url.cmd, "WAN_GATEWAY=%s", tds__SetNetworkDefaultGateway->IPv4Address[0]);
    if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) {	
	L1("error, send %s\n", url.cmd);
	return SOAP_ERR;
    }
    fprintf(stdout, "send %s done\n", url.cmd);
    return SOAP_OK;
}


int __tds__GetZeroConfiguration (struct soap *soap, struct _tds__GetZeroConfiguration *tds__GetZeroConfiguration,
								 struct _tds__GetZeroConfigurationResponse *tds__GetZeroConfigurationResponse)
{
	static char *Addresses;
	char ReplyMsg[512]; //w
	char value[125];
	char LLIP[16];

	value[0]='\0';

	if (GetV2WanStatus (ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		OnvifReplyMsgParser("LLIP", ReplyMsg, LLIP);
		OnvifReplyMsgParser("BONJOUR_CONFIG", ReplyMsg, value);
	}
	else 
	{
		return SOAP_ERR; 
	}

	tds__GetZeroConfigurationResponse->ZeroConfiguration =
		(struct tt__NetworkZeroConfiguration *) soap_malloc (soap, sizeof (struct tt__NetworkZeroConfiguration));
	soap_default_tt__NetworkZeroConfiguration (soap, tds__GetZeroConfigurationResponse->ZeroConfiguration);
	tds__GetZeroConfigurationResponse->ZeroConfiguration->InterfaceToken = "eth0"; 	
	tds__GetZeroConfigurationResponse->ZeroConfiguration->Enabled = (enum xsd__boolean) atoi(value);
	tds__GetZeroConfigurationResponse->ZeroConfiguration->__sizeAddresses = 1;
	Addresses = (char *) soap_malloc(soap, 16);
	strcpy(Addresses, LLIP); 
	tds__GetZeroConfigurationResponse->ZeroConfiguration->Addresses = &Addresses;

	return SOAP_OK;
}


int __tds__SetZeroConfiguration (struct soap *soap, struct _tds__SetZeroConfiguration *tds__SetZeroConfiguration,
								 struct _tds__SetZeroConfigurationResponse *tds__SetZeroConfigurationResponse)
{
	tUrlDB url;
	char ReplyMsg[512];
	if (tds__SetZeroConfiguration->InterfaceToken == NULL
	   || strcmp ("eth0", tds__SetZeroConfiguration->InterfaceToken))
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidNetworkInterface",
					 "Invalid data", "The supplied network interface token does not exists");
	strcpy(url.cgi, "system");
	sprintf(url.cmd, "BONJOUR_CONFIG=%d", tds__SetZeroConfiguration->Enabled);
	url.len = strlen(url.cmd);

	if(url.len > 0) 
	{
		if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) 
		{
			return SOAP_ERR;
		}
	}

	return SOAP_OK;
}

int __tds__GetRelayOutputs(struct soap *soap, struct _tds__GetRelayOutputs *tds__GetRelayOutputs, struct _tds__GetRelayOutputsResponse *tds__GetRelayOutputsResponse)
{	
	int i = 0;
    int size = 0;

	tds__GetRelayOutputsResponse->__sizeRelayOutputs = gOnvifConf.DOs;
	tds__GetRelayOutputsResponse->RelayOutputs = 
	     (struct tt__RelayOutput *) soap_malloc(soap, sizeof(struct tt__RelayOutput) * tds__GetRelayOutputsResponse->__sizeRelayOutputs);

    size = sizeof(gOnvifConf.DOSetting[0].DelayTime);
	for(i=0; i<tds__GetRelayOutputsResponse->__sizeRelayOutputs; i++) {
		soap_default_tt__RelayOutput(soap, &tds__GetRelayOutputsResponse->RelayOutputs[i]);
		tds__GetRelayOutputsResponse->RelayOutputs[i].token = (char *) soap_malloc(soap, 4);
		sprintf(tds__GetRelayOutputsResponse->RelayOutputs[i].token, "DO%d", i+1);
		tds__GetRelayOutputsResponse->RelayOutputs[i].Properties = 
			(struct tt__RelayOutputSettings *) soap_malloc(soap, sizeof(struct tt__RelayOutputSettings));
		tds__GetRelayOutputsResponse->RelayOutputs[i].Properties->Mode = gOnvifConf.DOSetting[i].Mode;
		tds__GetRelayOutputsResponse->RelayOutputs[i].Properties->DelayTime = (char *) soap_malloc (soap, size);
		memset (tds__GetRelayOutputsResponse->RelayOutputs[i].Properties->DelayTime, 0, size); 
		snprintf (tds__GetRelayOutputsResponse->RelayOutputs[i].Properties->DelayTime, size-1, "%s", gOnvifConf.DOSetting[i].DelayTime); 
		tds__GetRelayOutputsResponse->RelayOutputs[i].Properties->IdleState = gOnvifConf.DOSetting[i].IdleState;
	}
	return SOAP_OK;
}
static int GetDOnumFmToken(char *token, int *nDO) {
    int num = 0;

    /* DO token format is DO%d */
    if((token[0] == 'D') && (token[1] == 'O') && (token[2] >= '1') && (token[2] <= '9')) {
        num = (int)(token[2] - '0');
        if((num >= 1) && (num <= gOnvifConf.DOs)) {
            *nDO = num;
            return OK;
        }
    }
    return ERR;
}
int __tds__SetRelayOutputSettings(struct soap *soap, struct _tds__SetRelayOutputSettings *tds__SetRelayOutputSettings,
				  struct _tds__SetRelayOutputSettingsResponse *tds__SetRelayOutputSettingsResponse) {	
    int nDO = -1;
    int DelayTime = -1;
    
    if (tds__SetRelayOutputSettings->RelayOutputToken == NULL) return SOAP_REQUIRED;
    if(GetDOnumFmToken(tds__SetRelayOutputSettings->RelayOutputToken, &nDO) == ERR) {
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:RelayToken", NULL,
					     "Unknown relay token reference");
    }
    if(tds__SetRelayOutputSettings->Properties) {
	if ((tds__SetRelayOutputSettings->Properties->Mode == Monostable) || 
	    (tds__SetRelayOutputSettings->Properties->Mode == Bistable)) {
            gOnvifConf.DOSetting[nDO-1].Mode = tds__SetRelayOutputSettings->Properties->Mode;
        } else {
            return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ModeError", NULL,
                                                "Unknown Mode");
        }
        if( (tds__SetRelayOutputSettings->Properties->DelayTime != NULL) && 
            (strncmp(tds__SetRelayOutputSettings->Properties->DelayTime, "PT", 2) == 0) ) {
            if(parserTimeInterval(tds__SetRelayOutputSettings->Properties->DelayTime, &DelayTime) != ERR) {
                if(DelayTime >= 0) {
                    snprintf(gOnvifConf.DOSetting[nDO-1].DelayTime, sizeof(gOnvifConf.DOSetting[nDO-1].DelayTime)-1,
                            "PT%dS", DelayTime);
                } else DelayTime = -1;
            } else DelayTime = -1;
        }
    }
    if(DelayTime < 0) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ModeError", NULL,
                                             "Monostable delay time not valid");
    }
    /* get the Idle State */
    if( (tds__SetRelayOutputSettings->Properties->IdleState == _open_) ||
        (tds__SetRelayOutputSettings->Properties->IdleState == _closed_)) {
	gOnvifConf.DOSetting[nDO-1].IdleState = tds__SetRelayOutputSettings->Properties->IdleState;
    } else {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:IdleStateError", NULL,
                                             "Unknown Idle State");
    }
    return SOAP_OK;
}


int __tds__SetRelayOutputState(	struct soap *soap, struct _tds__SetRelayOutputState *tds__SetRelayOutputState,
				struct _tds__SetRelayOutputStateResponse *tds__SetRelayOutputStateResponse) {
    static int nDO = -1;	
    tUrlDB url;
    int loops = 0;
    char ReplyMsg[512];
    static int DelayTime = 0;
    pthread_t DelayTime_t = 0;

    if(tds__SetRelayOutputState->RelayOutputToken == NULL ) return SOAP_REQUIRED;
    
    if(GetDOnumFmToken(tds__SetRelayOutputState->RelayOutputToken, &nDO) == ERR) {
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:RelayToken", NULL,
                                             "Unknown relay token reference");
    }
    parserTimeInterval(gOnvifConf.DOSetting[nDO-1].DelayTime, &DelayTime);
    if(gOnvifConf.DOSetting[nDO-1].state == ONVIF_STATE_CLOSE) {
	strcpy(url.cgi, "encoder");
	if(gOnvifConf.DOSetting[nDO-1].IdleState == _open_) {
	    if(tds__SetRelayOutputState->LogicalState == active) {
		url.len = sprintf(url.cmd, "SET_DO=%d,1", nDO);
	    } else {
		url.len = sprintf(url.cmd, "SET_DO=%d,0", nDO);
	    }
	} else {
	    if(tds__SetRelayOutputState->LogicalState == active) {
		url.len = sprintf(url.cmd, "SET_DO=%d,0", nDO);
	    } else {
		url.len = sprintf(url.cmd, "SET_DO=%d,1", nDO);
	    }
	}
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) {
	    L1("error, send %s\n", url.cmd);
	}
	if((DelayTime > 0) && (tds__SetRelayOutputState->LogicalState == active)) {
	    if (pthread_create (&DelayTime_t, NULL, HandleDelayTime, (void *)&nDO)) {
		L1("error, create thread HandleDelayTime for nDO=%d, DelayTime=%d\n", nDO, DelayTime);
	    }
	}
    } else {
	L4("warning. DOSetting[%d] is in DelayTime loop %d\n", nDO-1, DelayTime);
	return SOAP_OK;
	while(gOnvifConf.DOSetting[nDO-1].state != ONVIF_STATE_CLOSE) {
	    sleep(1);
	    loops ++;
	    if(loops > DelayTime) {
		L1("error. DOSetting[%d] HandleDelayTime not leaves after %d sec.\n", nDO-1, DelayTime);
		gOnvifConf.DOSetting[nDO-1].state = ONVIF_STATE_CLOSE;
		break;
	    }
	}
    }
    return SOAP_OK;
}

/** Auto-test server operation __tds__SendAuxiliaryCommand */
int __tds__SendAuxiliaryCommand(struct soap *soap, struct _tds__SendAuxiliaryCommand *tds__SendAuxiliaryCommand, struct _tds__SendAuxiliaryCommandResponse *tds__SendAuxiliaryCommandResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}
#ifdef HAVE__GETSERVICES
/** Auto-test server operation __tptz__GetServiceCapabilities */
int __tptz__GetServiceCapabilities(struct soap *soap, struct _tptz__GetServiceCapabilities *tptz__GetServiceCapabilities, struct _tptz__GetServiceCapabilitiesResponse *tptz__GetServiceCapabilitiesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}
#endif
int __tptz__GetConfigurations(struct soap *soap, struct _tptz__GetConfigurations *tptz__GetConfigurations, struct _tptz__GetConfigurationsResponse *tptz__GetConfigurationsResponse)
{	
	tptz__GetConfigurationsResponse->__sizePTZConfiguration = 1;
	tptz__GetConfigurationsResponse->PTZConfiguration = 
		(struct tt__PTZConfiguration *) soap_malloc(soap, sizeof(struct tt__PTZConfiguration));
	soap_default_tt__PTZConfiguration(soap, tptz__GetConfigurationsResponse->PTZConfiguration);
	PreparePTZConfig (soap, tptz__GetConfigurationsResponse->PTZConfiguration);

	return SOAP_OK;
}


int __tptz__GetPresets(struct soap *soap, struct _tptz__GetPresets *tptz__GetPresets, struct _tptz__GetPresetsResponse *tptz__GetPresetsResponse)
{	
    int  id=0;
    char ReplyMsg[1024*6];
    char *s = NULL;
    char *p = NULL;
    char *e;
    int  leave = 0;
    int  validPresets = 0;
    int  i = 0;
    int  valid,entry, x, y, z, sx, sy, sz, dwell, n;
    char namePreset[32];
    float Normalized = 0.0; 

	if (FindMediaProfile (soap, tptz__GetPresets->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
                                             "The requested profile token ProfileToken does not exist.");
                                             
	if(gOnvifConf.PTZ_AddToken[id] != true_) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoPTZProfile", NULL,
                                             "The requested profile token does not reference a PTZ configuration.");
    }	
    /* send URL to get the current valid preset points */
    if(OnvifSingleUrlCmdSend("encoder", "PTZ_PRESET_GET", ReplyMsg, (sizeof(ReplyMsg)-1)) > 0) {
        s = ReplyMsg;
        do {
            p = strstr(s, "PTZ_PRESET_GET=");
            if(p) { 
                p += strlen("PTZ_PRESET_GET=");
                if(*p == '\'') p ++;
                if(*p == '\'') break;
                validPresets ++;
                s = p;
            } else break;
        } while(1);
    }	
	if(validPresets == 0) return SOAP_OK;
    /* allocate memory for returning these valid preset points */
	tptz__GetPresetsResponse->__sizePreset = validPresets;
	tptz__GetPresetsResponse->Preset = (struct tt__PTZPreset *) soap_malloc(soap, sizeof(struct tt__PTZPreset) * validPresets);
    if(tptz__GetPresetsResponse->Preset == NULL) goto GetPresetsError;
    
    /* parser URL return message to onvif preset configurations */
	s = ReplyMsg;
    while((leave == 0) && (i < validPresets)) {
        p = strstr(s, "PTZ_PRESET_GET=");
        if(p) {
            p += strlen("PTZ_PRESET_GET=");
            if( *p == '\'') p ++;
            if( *p == '\'') break;
            /* try to find entey terminator */
            e = strchr(p, '\n');
            if(e) {
                if(*(e-1) == '\'') *(e-1) = '\0';
                else *e = '\0';
                s = e+1;
            } else {
                e = strchr(p, '\0');
                if(e) {
                    if(*(e-1) == '\'') *(e-1) = '\0';
                    else *e = '\0';
                    leave = 1;
                }
            }
            if(e) { /* extract one preset entry in *p */
		n = sscanf(p, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%31s\n", &valid, &entry, &x, &y, &z, &sx, &sy, &sz, &dwell, namePreset);
		if(n != 10) {
		    (void)sscanf(p, "%d,%d,%d,%d,%d,%d,%d,%d,%31s\n", &entry, &x, &y, &z, &sx, &sy, &sz, &dwell, namePreset);
		}
                soap_default_tt__PTZPreset(soap, &tptz__GetPresetsResponse->Preset[i]);
                tptz__GetPresetsResponse->Preset[i].token = (char *) soap_malloc(soap, 32);
                if(tptz__GetPresetsResponse->Preset[i].token) snprintf(tptz__GetPresetsResponse->Preset[i].token, 31, "%s", namePreset);
                else goto GetPresetsError;
                /* get the pan, tilt and zoom positions form the reply message */
                tptz__GetPresetsResponse->Preset[i].PTZPosition = (struct tt__PTZVector *) soap_malloc(soap, sizeof(struct tt__PTZVector));
                if(tptz__GetPresetsResponse->Preset[i].PTZPosition) {
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->PanTilt=(struct tt__Vector2D *)soap_malloc(soap, sizeof(struct tt__Vector2D));
                    Normalize_PTZPosition (OPT_PAN_POSITION, x, &Normalized); 
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->PanTilt->x = Normalized; 
                    Normalize_PTZPosition (OPT_TILT_POSITION, y, &Normalized); 
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->PanTilt->y = Normalized;
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->PanTilt->space = OnvifPTPositionGenericSpace;
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->Zoom=(struct tt__Vector1D *)soap_malloc(soap,sizeof(struct tt__Vector1D));
                    Normalize_PTZPosition (OPT_ZOOM_POSITION, z, &Normalized); 
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->Zoom->x = Normalized;
                    tptz__GetPresetsResponse->Preset[i].PTZPosition->Zoom->space = OnvifZoomPositionGenericSpace;
                    tptz__GetPresetsResponse->Preset[i].Name = (char *) soap_malloc(soap, 32);
                    snprintf(tptz__GetPresetsResponse->Preset[i].Name, 31, "%s", namePreset);
                    i ++;
                } else goto GetPresetsError;
            } else break; /* not found the terminator */
        } else break; /* not found the key */
	}
	return SOAP_OK;
    
GetPresetsError:
    return SOAP_ERR;

}
int FindPresetEntryByToken(char *token, char *name, int *idx) {
    char retMsg[1024*6];
    char *s = NULL;
    char *p = NULL;
    char *e = NULL;
    char *q = NULL;
    int  index = -1;
    int  leave = 0;
    int  found = 0;
    
    if(OnvifSingleUrlCmdSend("encoder", "PTZ_PRESET_GET", retMsg, (sizeof(retMsg)-1)) > 0) {
        s = retMsg;
        do {
            p = strstr(s, "PTZ_PRESET_GET=");
            if(p) {
                p += strlen("PTZ_PRESET_GET=");
                if( *p == '\'') p ++;
                if( *p == '\'') {
                    break; /* no valid preset point */
                }
                /* try to find entey terminator */
                e = strchr(p, '\n');
                if(e) {
                    if(*(e-1) == '\'') *(e-1) = '\0';
                    else *e = '\0';
                    s = e+1;
                } else {
                    e = strchr(p, '\0');
                    if(e) {
                        if(*(e-1) == '\'') *(e-1) = '\0';
                        else *e = '\0';
                        leave = 1;
                    }
                }
                if(e) {
                    if(token) {
                        q = strrchr(p, ',');
				if(q) q = q+1;
                        if((q) && (strlen(q) == strlen(token)) && (strcmp(q, token)==0)) found = 1;
                    }
                    if((found == 0) && name) {
                        q = strrchr(p, ',');
				if(q) q = q+1;
                        if((q) && (strlen(q) == strlen(name)) && (strcmp(q, name)==0)) found = 1;
                    }
                    if(found) {
                        s = strchr(p, ',');
                        if(s) {
                            *s = '\0';
                            index = atoi(p);
                            if((index >= 1) && (index <= gOnvifConf.PTZConfig.maxPresetPoints)) {
                                *idx = index;
                                *s = ',';
                                return index;
                            }
                            break;
                        }
                    } /* else => not this one, try next one */
                } else break; /* not find terminator, somthing wrong in parsering retMag or bug in firmware */
            } else break; /* fail to find key */
        } while(leave == 0);
    } /* else => fail to send URL */
    return -1;
}
int __tptz__SetPreset(struct soap *soap, struct _tptz__SetPreset *tptz__SetPreset, struct _tptz__SetPresetResponse *tptz__SetPresetResponse)
{	
	int id=0;
	char cmd[256];
	char ReplyMsg[2048];
	int idxPreset=0;
    char namePreset[32]; /* bsed on URL design spec */

	if (FindMediaProfile (soap, tptz__SetPreset->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, 
			                                 "ter:InvalidArgVal", "ter:NoProfile", NULL,
			                                 "The requested profile token ProfileToken does not exist.");
	if(gOnvifConf.PTZ_AddToken[id] != true_) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoPTZProfile", NULL,
                                             "The requested profile token does not reference a PTZ configuration.");
    }
    /* get the target preset index from preset token */
    if((tptz__SetPreset->PresetToken) || (tptz__SetPreset->PresetName)) {
        if( (FindPresetEntryByToken(tptz__SetPreset->PresetToken, tptz__SetPreset->PresetName, &idxPreset) >= 0) ||
            (GetAvailablePresetEntry(&idxPreset) >= 0) ) {
            if(tptz__SetPreset->PresetToken) snprintf(namePreset, sizeof(namePreset), "%s", tptz__SetPreset->PresetToken);
            else                             snprintf(namePreset, sizeof(namePreset), "%s", tptz__SetPreset->PresetName);
            goto SetPresetByURL;
        }
    } else {
        if(GetAvailablePresetEntry(&idxPreset) >= 0) {
            snprintf(namePreset, sizeof(namePreset), "Entry_%03d", idxPreset);
            goto SetPresetByURL;
        }
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidArgVal", NULL,
                                         "Maximum number of Presets reached.");
SetPresetByURL:
    /* set the preset by using current position */
    snprintf(cmd, sizeof(cmd), "PTZ_PRESET_SET=%d,1,0,0,65535,5,5,7,10,%s", idxPreset, namePreset);
	(void)OnvifSingleUrlCmdSend("encoder", cmd, ReplyMsg, (sizeof(ReplyMsg)-1));
    
    tptz__SetPresetResponse->PresetToken = (char *) soap_malloc(soap, sizeof(namePreset));
    snprintf(tptz__SetPresetResponse->PresetToken, sizeof(namePreset), "%s", namePreset);
    return SOAP_OK;
}


int __tptz__RemovePreset(struct soap *soap, struct _tptz__RemovePreset *tptz__RemovePreset, struct _tptz__RemovePresetResponse *tptz__RemovePresetResponse)
{	
	int idx = 0;
	char cmd[512];

	if(FindMediaProfile (soap, tptz__RemovePreset->ProfileToken, &idx) == OK) {
        if(FindPresetEntryByToken(tptz__RemovePreset->PresetToken, NULL, &idx) >= 0) {
            /* find the preset entry, remove it now */
            snprintf(cmd, sizeof(cmd), "PTZ_PRESET_SET=%d,0", idx);
            (void)OnvifSingleUrlCmdSend("encoder", cmd, NULL, 0);
            return SOAP_OK;
         }
         return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal ", "ter:NoToken", NULL,
                                         "The requested preset token does not exist.");
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
                                         "The requested profile token ProfileToken does not exist.");   
}


int __tptz__GotoPreset(struct soap *soap, struct _tptz__GotoPreset *tptz__GotoPreset, struct _tptz__GotoPresetResponse *tptz__GotoPresetResponse)
{
	int idx=0;
	char cmd[512];
    
	if (FindMediaProfile (soap, tptz__GotoPreset->ProfileToken, &idx) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
                                             "The requested profile token ProfileToken does not exist.");
                                             
    if(tptz__GotoPreset->PresetToken) {
        if(FindPresetEntryByToken(tptz__GotoPreset->PresetToken, NULL, &idx) >= 0) {
            /* find the preset point, go to this preset now */
            snprintf(cmd, sizeof(cmd), "PTZ_PRESET_GO=%d", idx);
            (void)OnvifSingleUrlCmdSend("encoder", cmd, NULL, 0);
            return SOAP_OK;
        } /* else => not found the preset entry */
    } /* else => preset token is null */
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoToken", NULL,
                                         "The requested preset token does not exist.");
}

int __tptz__GetStatus(struct soap *soap, struct _tptz__GetStatus *tptz__GetStatus, struct _tptz__GetStatusResponse *tptz__GetStatusResponse)
{	
	int id;
    int errGetPos = 1;
	char ReplyMsg[512];
	char value[64];
	static enum tt__MoveStatus zoom = _UNKNOWN_;
	static enum tt__MoveStatus pan_tilt = _UNKNOWN_;
	struct timeval tv;
	float NormalPos = 0.0; 
	struct tPtzPos Pos; 

	if (FindMediaProfile (soap, tptz__GetStatus->ProfileToken, &id) != OK) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
                                             "The requested profile token ProfileToken does not exist.");
    }
	if(gOnvifConf.PTZ_AddToken[id] != true_)  {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoPTZProfile", NULL,
                                             "The requested profile token does not reference a PTZ configuration.");
    }
    Pos.PositionP = 0;
    Pos.PositionT = 0;
    Pos.PositionZ = gPTZLimits.MinZoomLimits;
    if(OnvifSingleUrlCmdSend("encoder", "XYZ_POS_GET", ReplyMsg, (sizeof(ReplyMsg)-1)) > 0) {
        if(OnvifGetValueFmUrlReply(ReplyMsg, "XYZ_POS_GET=", value, (sizeof(value)-1)) > 0) {
            sscanf (value, "%d,%d,%d", (int *) &Pos.PositionP, (int *) &Pos.PositionT, (int *) &Pos.PositionZ);
            /*
			L4("XYZ_POS_GET=%d(%f,%f),%d(%f,%f),%d(%f,%f), value=%s\n",
                    Pos.PositionP, gPTZLimits.MinPanLimits, gPTZLimits.MaxPanLimits,
                    Pos.PositionT, gPTZLimits.MinTiltLimits, gPTZLimits.MaxTiltLimits,
                    Pos.PositionZ, gPTZLimits.MinZoomLimits, gPTZLimits.MaxZoomLimits,
                    value);
			*/
            if((Pos.PositionP == 18000) || (Pos.PositionP == -18000)) { /* workaround I9x boundary position */
                if((Pos.PositionP > 0) && (gMovePanDirection < 0))      Pos.PositionP *= (-1);
                else if((Pos.PositionP < 0) && (gMovePanDirection > 0)) Pos.PositionP *= (-1);
            }
            errGetPos = 0;
        }
    }
    if(errGetPos) L1("error, send XYZ_POS_GET\n");
	tptz__GetStatusResponse->PTZStatus = (struct tt__PTZStatus *) soap_malloc(soap, sizeof(struct tt__PTZStatus));	
	soap_default_tt__PTZStatus (soap, tptz__GetStatusResponse->PTZStatus);
    
	tptz__GetStatusResponse->PTZStatus->Position = (struct tt__PTZVector *) soap_malloc (soap, sizeof(struct tt__PTZVector));
	soap_default_tt__PTZVector (soap, tptz__GetStatusResponse->PTZStatus->Position);
	
	if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
		tptz__GetStatusResponse->PTZStatus->Position->PanTilt = 
                        (struct tt__Vector2D *) soap_malloc(soap, sizeof(struct tt__Vector2D));
		soap_default_tt__Vector2D (soap, tptz__GetStatusResponse->PTZStatus->Position->PanTilt);
		
		if (Normalize_GetPTZCurrentPosition (OPT_PAN_POSITION, &Pos, &NormalPos) == SOAP_ERR) errGetPos = 1;
		tptz__GetStatusResponse->PTZStatus->Position->PanTilt->x = NormalPos; 
		if (Normalize_GetPTZCurrentPosition (OPT_TILT_POSITION, &Pos, &NormalPos) == SOAP_ERR) errGetPos = 1;
		tptz__GetStatusResponse->PTZStatus->Position->PanTilt->y = NormalPos; 
		tptz__GetStatusResponse->PTZStatus->Position->PanTilt->space = OnvifPTPositionGenericSpace;
		/*
		L4("PT Onvif value: %f,%f\n", tptz__GetStatusResponse->PTZStatus->Position->PanTilt->x,
			tptz__GetStatusResponse->PTZStatus->Position->PanTilt->y);
		*/
	}
	if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_))
	{
		tptz__GetStatusResponse->PTZStatus->Position->Zoom = 
                        (struct tt__Vector1D *) soap_malloc(soap, sizeof(struct tt__Vector1D));
		soap_default_tt__Vector1D (soap, tptz__GetStatusResponse->PTZStatus->Position->Zoom);
		if (Normalize_GetPTZCurrentPosition (OPT_ZOOM_POSITION, &Pos, &NormalPos) == SOAP_ERR) errGetPos = 1;
		tptz__GetStatusResponse->PTZStatus->Position->Zoom->x = NormalPos; 
		tptz__GetStatusResponse->PTZStatus->Position->Zoom->space = OnvifZoomPositionGenericSpace;
		//L4("Zoom Onvif value: %f\n", tptz__GetStatusResponse->PTZStatus->Position->Zoom->x);
	}
	tptz__GetStatusResponse->PTZStatus->MoveStatus = 
                        (struct tt__PTZMoveStatus *) soap_malloc(soap, sizeof(struct tt__PTZMoveStatus));
	soap_default_tt__PTZMoveStatus (soap, tptz__GetStatusResponse->PTZStatus->MoveStatus);
	if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
		tptz__GetStatusResponse->PTZStatus->MoveStatus->PanTilt = &pan_tilt;
    }
	if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
		tptz__GetStatusResponse->PTZStatus->MoveStatus->Zoom = &zoom;
    }
    if(errGetPos) {
        snprintf(ptzErrDesc, sizeof(ptzErrDesc), "fail to get positions");
        tptz__GetStatusResponse->PTZStatus->Error = ptzErrDesc;
    }
	gettimeofday(&tv, NULL);
	tptz__GetStatusResponse->PTZStatus->UtcTime = tv.tv_sec;	/* required element of type xsd:dateTime */
	return SOAP_OK;
}

int __tptz__GetConfiguration(struct soap *soap, struct _tptz__GetConfiguration *tptz__GetConfiguration, struct _tptz__GetConfigurationResponse *tptz__GetConfigurationResponse)
{
	if (tptz__GetConfiguration->PTZConfigurationToken == NULL)
		return SOAP_ERR;
	if(tptz__GetConfiguration->PTZConfigurationToken != NULL)
		if(strcmp(tptz__GetConfiguration->PTZConfigurationToken, gOnvifConf.PTZConfig.Token) != 0) 
			return SOAP_ERR;
	tptz__GetConfigurationResponse->PTZConfiguration = 
		(struct tt__PTZConfiguration *) soap_malloc(soap, sizeof(struct tt__PTZConfiguration));
	soap_default_tt__PTZConfiguration(soap, tptz__GetConfigurationResponse->PTZConfiguration);
	PreparePTZConfig (soap, tptz__GetConfigurationResponse->PTZConfiguration);

	return SOAP_OK;
}


int __tptz__GetNodes(struct soap *soap, struct _tptz__GetNodes *tptz__GetNodes, struct _tptz__GetNodesResponse *tptz__GetNodesResponse)
{	
	/* 
 	   Only one set of PTZ node and it cannot be changed by user.
	   So, always refers to gOnvifConf.PTZNode . 
 	*/
	int i = 0; 
	if( (gOnvifConf.ZoomEnable == false_) && (gOnvifConf.PTEnable == false_) &&
        (gOnvifConf.ZoomEnableBy485 == false_) && (gOnvifConf.PTEnableBy485 == false_) ) {
		return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:PTZNotSupported", NULL,
                                               "PTZ is not supported by the device.");
    }
	tptz__GetNodesResponse->__sizePTZNode = gOnvifConf.sizePTZNode;//w: 1; //Hard code
	tptz__GetNodesResponse->PTZNode = (struct tt__PTZNode *) soap_malloc(soap, sizeof(struct tt__PTZNode));

	tptz__GetNodesResponse->PTZNode->token = (char *)&gOnvifConf.PTZNode.token;//w: "1";
	tptz__GetNodesResponse->PTZNode->Name = (char *)&gOnvifConf.PTZNode.Name; //w: "node1";
	tptz__GetNodesResponse->PTZNode->SupportedPTZSpaces = 
		(struct tt__PTZSpaces *) soap_malloc (soap, sizeof (struct tt__PTZSpaces));
	soap_default_tt__PTZSpaces (soap, tptz__GetNodesResponse->PTZNode->SupportedPTZSpaces);
	PreparePTZSpace (soap, tptz__GetNodesResponse->PTZNode->SupportedPTZSpaces);
	tptz__GetNodesResponse->PTZNode->MaximumNumberOfPresets = gOnvifConf.PTZNode.MaximumNumberOfPresets; //w: 64;
	tptz__GetNodesResponse->PTZNode->HomeSupported = gOnvifConf.PTZNode.HomeSupported;

	/* Auxiliary */
	tptz__GetNodesResponse->PTZNode->__sizeAuxiliaryCommands = gOnvifConf.PTZNode.sizeAuxiliaryCommands; 
	tptz__GetNodesResponse->PTZNode->AuxiliaryCommands = 
		(char **) soap_malloc (soap, gOnvifConf.PTZNode.sizeAuxiliaryCommands); 
	for (i = 0; i < gOnvifConf.PTZNode.sizeAuxiliaryCommands; i++)
	{
		tptz__GetNodesResponse->PTZNode->AuxiliaryCommands[i] = (char *) soap_malloc (soap, MAX_AUX_LEN+1); 
        snprintf(tptz__GetNodesResponse->PTZNode->AuxiliaryCommands[i], MAX_AUX_LEN, "%s",
                 &gOnvifConf.PTZNode.AuxiliaryCommands[i][0]); 
	}
	return SOAP_OK;
}


int __tptz__GetNode(struct soap *soap, struct _tptz__GetNode *tptz__GetNode, struct _tptz__GetNodeResponse *tptz__GetNodeResponse)
{	
	/* 
 	   Only one set of PTZ node and it cannot be changed by user.
	   So, always refers to gOnvifConf.PTZNode . 
 	*/
	int i = 0; 
	if ( (gOnvifConf.ZoomEnable == false_) && (gOnvifConf.PTEnable == false_) &&
         (gOnvifConf.ZoomEnableBy485 == false_) && (gOnvifConf.PTEnableBy485 == false_) ) {
		return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:PTZNotSupported", NULL,
			"PTZ is not supported by the device.");
	}
	if (tptz__GetNode->NodeToken == NULL) 	return SOAP_ERR;
	if(strcmp(tptz__GetNode->NodeToken, gOnvifConf.PTZNode.token) != 0) 
		return soap_sender_fault_subcode_v2 (soap, 
			"ter:InvalidArgVal", "ter:NoEntity", NULL, "No such PTZNode on the device");
	tptz__GetNodeResponse->PTZNode = (struct tt__PTZNode *) soap_malloc(soap, sizeof(struct tt__PTZNode));
	tptz__GetNodeResponse->PTZNode->token = (char *)&gOnvifConf.PTZNode.token; //w: "1";
	tptz__GetNodeResponse->PTZNode->Name = (char *)&gOnvifConf.PTZNode.Name; //w: "node1";
	tptz__GetNodeResponse->PTZNode->SupportedPTZSpaces = 
		(struct tt__PTZSpaces *) soap_malloc(soap, sizeof(struct tt__PTZSpaces));
	soap_default_tt__PTZSpaces(soap, tptz__GetNodeResponse->PTZNode->SupportedPTZSpaces);
	PreparePTZSpace (soap, tptz__GetNodeResponse->PTZNode->SupportedPTZSpaces);
	tptz__GetNodeResponse->PTZNode->MaximumNumberOfPresets = gOnvifConf.PTZNode.MaximumNumberOfPresets; //w: 64;
	tptz__GetNodeResponse->PTZNode->HomeSupported = gOnvifConf.PTZNode.HomeSupported; //w: true_;	

	/* Auxiliary */
	tptz__GetNodeResponse->PTZNode->__sizeAuxiliaryCommands = gOnvifConf.PTZNode.sizeAuxiliaryCommands; 

	tptz__GetNodeResponse->PTZNode->AuxiliaryCommands = 
		(char **) soap_malloc (soap, gOnvifConf.PTZNode.sizeAuxiliaryCommands); 
	for (i = 0; i < gOnvifConf.PTZNode.sizeAuxiliaryCommands; i++)
	{
		tptz__GetNodeResponse->PTZNode->AuxiliaryCommands[i] = (char *) soap_malloc (soap, MAX_AUX_LEN+1); 
		snprintf(tptz__GetNodeResponse->PTZNode->AuxiliaryCommands[i], MAX_AUX_LEN, "%s",
                &gOnvifConf.PTZNode.AuxiliaryCommands[i][0]); 
	}

	return SOAP_OK;
}


int __tptz__SetConfiguration(struct soap *soap, struct _tptz__SetConfiguration *tptz__SetConfiguration, struct _tptz__SetConfigurationResponse *tptz__SetConfigurationResponse)
{	
	Acti_PTZConfig *PtzConfPtr = NULL;
	int timeout = 0;

	if (tptz__SetConfiguration->PTZConfiguration == NULL) return SOAP_REQUIRED;
	if (tptz__SetConfiguration->PTZConfiguration->token != NULL) {
		if (strcmp (tptz__SetConfiguration->PTZConfiguration->token, gOnvifConf.PTZConfig.Token) != 0)	
			goto ERROR_PROFILE;
    }
	if (tptz__SetConfiguration->PTZConfiguration->Name != NULL) {
		if (strcmp (tptz__SetConfiguration->PTZConfiguration->Name, gOnvifConf.PTZConfig.Name) != 0)
			goto ERROR_PROFILE;
    }
	if (tptz__SetConfiguration->PTZConfiguration->UseCount != gOnvifConf.PTZConfig.UseCount) {
		L1("error. UseCount %d!=%d\n", tptz__SetConfiguration->PTZConfiguration->UseCount, gOnvifConf.PTZConfig.UseCount);
		goto ERROR_CONFIG; 
    }
	if (tptz__SetConfiguration->PTZConfiguration->NodeToken != NULL) {
	    if (strcmp (tptz__SetConfiguration->PTZConfiguration->NodeToken, gOnvifConf.PTZConfig.NodeToken) != 0) {
		L1("error, NodeToken %s!=%s\n", tptz__SetConfiguration->PTZConfiguration->NodeToken, gOnvifConf.PTZConfig.NodeToken);
		goto ERROR_CONFIG;
	    }
    }
	if (tptz__SetConfiguration->ForcePersistence == false_) {
		PtzConfPtr = &tmpPTZConf;
		PTZConfigState = false_; 
	} else {
		PtzConfPtr = &gOnvifConf.PTZConfig; 
		PTZConfigState = true_; 
	}
    if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
        if ( (tptz__SetConfiguration->PTZConfiguration->DefaultAbsolutePantTiltPositionSpace != NULL) &&
        	 (tptz__SetConfiguration->PTZConfiguration->DefaultRelativePanTiltTranslationSpace != NULL) &&
             (tptz__SetConfiguration->PTZConfiguration->DefaultContinuousPanTiltVelocitySpace != NULL)) {
            if ((strcmp(tptz__SetConfiguration->PTZConfiguration->DefaultAbsolutePantTiltPositionSpace, 
                        gOnvifConf.PTZConfig.AbsolutePantTiltPositionSpace) != 0) ||
                (strcmp(tptz__SetConfiguration->PTZConfiguration->DefaultRelativePanTiltTranslationSpace, 
                        gOnvifConf.PTZConfig.RelativePanTiltTranslationSpace) != 0) ||
                (strcmp (tptz__SetConfiguration->PTZConfiguration->DefaultContinuousPanTiltVelocitySpace, 
                        gOnvifConf.PTZConfig.ContinuousPanTiltVelocitySpace) != 0) ) {
		L1("error. PTspeed Space %s,%s %s,%s %s,%s\n",
		    tptz__SetConfiguration->PTZConfiguration->DefaultAbsolutePantTiltPositionSpace,
		    gOnvifConf.PTZConfig.AbsolutePantTiltPositionSpace,
		    tptz__SetConfiguration->PTZConfiguration->DefaultRelativePanTiltTranslationSpace,
		    gOnvifConf.PTZConfig.RelativePanTiltTranslationSpace,
		    tptz__SetConfiguration->PTZConfiguration->DefaultContinuousPanTiltVelocitySpace,
		    gOnvifConf.PTZConfig.ContinuousPanTiltVelocitySpace);
                goto ERROR_CONFIG; 
            }
        } else goto ERROR_CONFIG;
    }
    if((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
        if ((tptz__SetConfiguration->PTZConfiguration->DefaultAbsoluteZoomPositionSpace != NULL) &&
        	(tptz__SetConfiguration->PTZConfiguration->DefaultRelativeZoomTranslationSpace != NULL) &&
            (tptz__SetConfiguration->PTZConfiguration->DefaultContinuousZoomVelocitySpace != NULL)) {
            if( (strcmp (tptz__SetConfiguration->PTZConfiguration->DefaultAbsoluteZoomPositionSpace, 
                         gOnvifConf.PTZConfig.AbsoluteZoomPositionSpace) != 0) ||
                (strcmp (tptz__SetConfiguration->PTZConfiguration->DefaultRelativeZoomTranslationSpace, 
                         gOnvifConf.PTZConfig.RelativeZoomTranslationSpace) != 0) ||
                (strcmp (tptz__SetConfiguration->PTZConfiguration->DefaultContinuousZoomVelocitySpace,
                         gOnvifConf.PTZConfig.ContinuousZoomVelocitySpace) != 0) ) {
		L1("error. Zspeed Space %s,%s %s,%s %s,%s\n",
		    tptz__SetConfiguration->PTZConfiguration->DefaultAbsoluteZoomPositionSpace,
		    gOnvifConf.PTZConfig.AbsoluteZoomPositionSpace,
		    tptz__SetConfiguration->PTZConfiguration->DefaultRelativeZoomTranslationSpace,
		    gOnvifConf.PTZConfig.RelativeZoomTranslationSpace,
		    tptz__SetConfiguration->PTZConfiguration->DefaultContinuousZoomVelocitySpace,
		    gOnvifConf.PTZConfig.ContinuousZoomVelocitySpace);
                goto ERROR_CONFIG; 
            }
        } else goto ERROR_CONFIG;
    }
    
	if (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed != NULL) {
        if ((gOnvifConf.PTEnable == true_) && (gOnvifConf.PTEnableBy485 == true_)) {
            if (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt != NULL) {
                if ((tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->x < ptzNormalRange[OPT_PAN_SPEED][LIMIT_MIN]) ||
                    (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->x > ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX]) ||
                    (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->y < ptzNormalRange[OPT_TILT_SPEED][LIMIT_MIN]) ||
                    (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->y > ptzNormalRange[OPT_TILT_SPEED][LIMIT_MAX])) {
		    L1("error, PTSpeed %f,%f,%f, %f,%f,%f\n",
			tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->x,
			ptzNormalRange[OPT_PAN_SPEED][LIMIT_MIN], ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX],
			tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->y,
			ptzNormalRange[OPT_TILT_SPEED][LIMIT_MIN], ptzNormalRange[OPT_TILT_SPEED][LIMIT_MAX]);
                    goto ERROR_CONFIG; 
                }
            } else goto ERROR_CONFIG;
	    if (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->space != NULL) {
		if (strcmp (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->space, 
			    gOnvifConf.PTZConfig.PTDefaultSpeedSpace) != 0) {
		    L1("error, default PT DefaultSpeed Space %s!=%s\n", 
			tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->space,
			gOnvifConf.PTZConfig.PTDefaultSpeedSpace);
		    goto ERROR_CONFIG;
		}
            }
        }
    }
    if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
	if ((tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom != NULL) &&
            (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->space != NULL) ) {
	    if ((tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->x < ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MIN]) || 
		(tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->x > ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX]) ||
                (strcmp (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->space,
                         gOnvifConf.PTZConfig.ZoomDefaultSpeedSpace) != 0) ) {
		    L1("error, Zoom Speed %f,%f,%f %s!=%s\n", 
			tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->x,
			ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MIN], ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX],
			tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->space,
			gOnvifConf.PTZConfig.ZoomDefaultSpeedSpace);
				goto ERROR_CONFIG; 
			}
		}
    }
		
	if(tptz__SetConfiguration->PTZConfiguration->DefaultPTZTimeout != NULL) {
		parserTimeInterval(tptz__SetConfiguration->PTZConfiguration->DefaultPTZTimeout, &timeout);
		if((timeout < 0) && (timeout > 10)) {
		    L1("error, timeout %d\n", timeout);
		    goto ERROR_CONFIG;
		}
	} else {
	    L1("error, missing tomieout\n");
	    goto ERROR_CONFIG;
	}
	if (tptz__SetConfiguration->PTZConfiguration->PanTiltLimits != NULL) {
	    if ((tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range == NULL) || 
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->URI == NULL) ||
		(strcmp (tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->URI, 
			 gOnvifConf.PTZConfig.PanTiltLimits_URI) != 0) ) {
		L1("error, PTLimitRange\n");
		goto ERROR_CONFIG;
	    }
	    if ((tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange == NULL) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Min < ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN]) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Min > ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX]) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Max < ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN]) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Max > ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX]) ) {
		L1("error, PanLimitRange %f,%f,%f %f,%f,%f\n",
		    tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Min,
		    ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN],
		    ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX],
		    tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Max,
		    ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN],
		    ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX]);
		goto ERROR_CONFIG;
	    }
	    if ((tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange == NULL) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Min < ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN]) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Min > ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX]) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Max < ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN]) ||
		(tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Max > ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX])) {
		L1("error, TiltLimitRange %f,%f,%f %f,%f,%f\n",
		    tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Min,
		    ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN], ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX],
		    tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Max,
		    ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN], ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX]);
		goto ERROR_CONFIG;
	    }
	}
	if( ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) && 
	    (tptz__SetConfiguration->PTZConfiguration->ZoomLimits != NULL) ) {
	    if ((tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range == NULL) ||
		(tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->URI == NULL) ||
		(strcmp (tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->URI, 
			gOnvifConf.PTZConfig.ZoomLimits_URI) != 0) ) {
		L1("error, ZoomLimit\n");
		goto ERROR_CONFIG;
	    }
	    if ((tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange == NULL) ||
		(tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Min < ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MIN]) ||
		(tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Min > ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MAX]) ||
		(tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Max < ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MIN]) ||
		(tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Max < ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MAX])) {
		L1("error, ZoomLimitRange %f,%f,%f, %f,%f,%f\n",
		    tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Min,
		    ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MIN], ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MAX],
		    tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Max,
		    ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MIN], ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MAX]);
		goto ERROR_CONFIG; 
	    }
    }
	snprintf (PtzConfPtr->Token, MAX_TOKEN_STRLEN, "%s", tptz__SetConfiguration->PTZConfiguration->token);
	snprintf (PtzConfPtr->Name, MAX_PROFILE_STR, "%s", tptz__SetConfiguration->PTZConfiguration->Name);
	snprintf (PtzConfPtr->NodeToken, MAX_TOKEN_STRLEN, "%s", tptz__SetConfiguration->PTZConfiguration->NodeToken);
	PtzConfPtr->UseCount = gOnvifConf.PTZConfig.UseCount; 
	if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
		if (tptz__SetConfiguration->PTZConfiguration->DefaultAbsolutePantTiltPositionSpace != NULL) {
			snprintf(PtzConfPtr->AbsolutePantTiltPositionSpace, MAX_NAMESPACE_LEN, "%s", 
                     tptz__SetConfiguration->PTZConfiguration->DefaultAbsolutePantTiltPositionSpace); 
		} 
		if (tptz__SetConfiguration->PTZConfiguration->DefaultRelativePanTiltTranslationSpace != NULL) {
			snprintf(PtzConfPtr->RelativePanTiltTranslationSpace, MAX_NAMESPACE_LEN, "%s", 
                     tptz__SetConfiguration->PTZConfiguration->DefaultRelativePanTiltTranslationSpace); 
		} 
		if (tptz__SetConfiguration->PTZConfiguration->DefaultContinuousPanTiltVelocitySpace != NULL) {
			snprintf(PtzConfPtr->ContinuousPanTiltVelocitySpace, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->DefaultContinuousPanTiltVelocitySpace);
		}
		PtzConfPtr->PanDefaultSpeed = tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->x; 
		PtzConfPtr->TiltDefaultSpeed = tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->y; 
		if (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->space != NULL) {
			snprintf(PtzConfPtr->PTDefaultSpeedSpace, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->PanTilt->space); 
		}
		if (tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->URI != NULL) {
			snprintf(PtzConfPtr->PanTiltLimits_URI, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->URI);  
		}
		PtzConfPtr->MinPanLimits = tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Min;  
		PtzConfPtr->MaxPanLimits = tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->XRange->Max;
		PtzConfPtr->MinTiltLimits = tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Min;
		PtzConfPtr->MaxTiltLimits = tptz__SetConfiguration->PTZConfiguration->PanTiltLimits->Range->YRange->Max;
	}
	if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
		if (tptz__SetConfiguration->PTZConfiguration->DefaultAbsoluteZoomPositionSpace != NULL) {
			snprintf(PtzConfPtr->AbsoluteZoomPositionSpace, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->DefaultAbsoluteZoomPositionSpace); 
		} 
		if (tptz__SetConfiguration->PTZConfiguration->DefaultRelativeZoomTranslationSpace != NULL) {
			snprintf(PtzConfPtr->RelativeZoomTranslationSpace, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->DefaultRelativeZoomTranslationSpace); 
		} 
		if(tptz__SetConfiguration->PTZConfiguration->DefaultContinuousZoomVelocitySpace != NULL) {
			snprintf(PtzConfPtr->ContinuousZoomVelocitySpace, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->DefaultContinuousZoomVelocitySpace); 
		}
        
		PtzConfPtr->ZoomDefaultSpeed = tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->x;
		if (tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->space != NULL) {
			snprintf(PtzConfPtr->ZoomDefaultSpeedSpace, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->DefaultPTZSpeed->Zoom->space);
		}
		if (tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->URI != NULL) {
			snprintf(PtzConfPtr->ZoomLimits_URI, MAX_NAMESPACE_LEN, "%s",
                     tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->URI);  
		} 
		PtzConfPtr->MinZoomLimits = tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Min;
		PtzConfPtr->MaxZoomLimits = tptz__SetConfiguration->PTZConfiguration->ZoomLimits->Range->XRange->Max;
	}
	PtzConfPtr->PTZ_timeout = timeout;
	return SOAP_OK;
ERROR_PROFILE:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
                                         "The configuration does not exist.");
ERROR_CONFIG:
	return soap_receiver_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ConfigModify", NULL,
                                           "The configuration parameters are not possible to set.");
}

int __tptz__GetConfigurationOptions(struct soap *soap, struct _tptz__GetConfigurationOptions *tptz__GetConfigurationOptions, struct _tptz__GetConfigurationOptionsResponse *tptz__GetConfigurationOptionsResponse)
{	
	tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions = 
		(struct tt__PTZConfigurationOptions *) soap_malloc(soap, sizeof(struct tt__PTZConfigurationOptions)); 
	soap_default_tt__PTZConfigurationOptions (soap, tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions);
	//Space
	tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions->Spaces = 
		(struct tt__PTZSpaces *) soap_malloc(soap, sizeof(struct tt__PTZSpaces));
	soap_default_tt__PTZSpaces (soap, tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions->Spaces);
	PreparePTZSpace (soap, tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions->Spaces);
	//PTZTimeout
	tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions->PTZTimeout = 
		(struct tt__DurationRange *) soap_malloc(soap, sizeof(struct tt__DurationRange));
	tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions->PTZTimeout->Min = 
		(char *)&gOnvifConf.PTZNode.MinPTZTimeout;//w: "PT0S";
	tptz__GetConfigurationOptionsResponse->PTZConfigurationOptions->PTZTimeout->Max = 
		(char *)&gOnvifConf.PTZNode.MaxPTZTimeout;//w: "PT10S";
	return SOAP_OK;
}


int __tptz__GotoHomePosition(struct soap *soap, struct _tptz__GotoHomePosition *tptz__GotoHomePosition, struct _tptz__GotoHomePositionResponse *tptz__GotoHomePositionResponse)
{	
	int id=0;
	tUrlDB url;
	char ReplyMsg[512];

	url.cmd[0] = '\0';

	if (tptz__GotoHomePosition->ProfileToken == NULL)
		return soap_sender_fault (soap, "", NULL);
	if (FindMediaProfile (soap, tptz__GotoHomePosition->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
									 "The requested profile token ProfileToken does not exist.");
	if(gOnvifConf.PTZ_AddToken[id] != true_) return SOAP_ERR;

	strcpy(url.cgi, "encoder");
	strcpy(url.cmd, "MOVE=HOME");
	url.len = strlen(url.cmd);
	OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
    gMovePanDirection = 0;
	return SOAP_OK;
}

int __tptz__SetHomePosition(struct soap *soap, struct _tptz__SetHomePosition *tptz__SetHomePosition, struct _tptz__SetHomePositionResponse *tptz__SetHomePositionResponse)
{	
//char *ProfileToken;	/* required element of type tt:ReferenceToken */
	int id = 0;
	tUrlDB url;
	char ReplyMsg[512];

	url.cmd[0] = '\0';

	if (tptz__SetHomePosition->ProfileToken == NULL)   return soap_sender_fault (soap, "", NULL);
    
	if (FindMediaProfile (soap, tptz__SetHomePosition->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
									 "The requested profile token ProfileToken does not exist.");
	if(gOnvifConf.PTZ_AddToken[id] != true_) return SOAP_ERR;

	strcpy(url.cgi, "encoder");
	strcpy(url.cmd, "HOME_POS=1");
	url.len = strlen(url.cmd);
	if (OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) != OK) 
		goto ERROR_RETURN; 
	if (strncmp (ReplyMsg, "OK", 2) != 0) 	
		goto ERROR_RETURN; 

    gMovePanDirection = 0;
	return SOAP_OK;
ERROR_RETURN:
	return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:CannotOverwriteHome", NULL,
		"The home position is fixed and cannot be overwritten.");
}

int __tptz__ContinuousMove( struct soap *soap, struct _tptz__ContinuousMove *tptz__ContinuousMove,
			    struct _tptz__ContinuousMoveResponse *tptz__ContinuousMoveResponse) {
    int id=0;
    tContinueMoveCmd toutCmd;
    pthread_t DelayTime_t = 0;
    int SpeedP = 0; 
    int SpeedT = 0; 
    int SpeedZ = 0; 

    toutCmd.timer = 0;
    toutCmd.needStopPTCmd   = 0;
    toutCmd.needStopZoomCmd = 0;
    toutCmd.moveCmd[0] = '\0';
    toutCmd.zoomCmd[0] = '\0';
    
    if (FindMediaProfile (soap, tptz__ContinuousMove->ProfileToken, &id) != OK) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
					     					 "The requested profile token ProfileToken does not exist.");
    }
    if(gOnvifConf.PTZ_AddToken[id] != true_) return SOAP_ERR;

    if(tptz__ContinuousMove->Velocity != NULL) {
		if(tptz__ContinuousMove->Velocity->PanTilt != NULL) { /* client request PT move */
	    	if ((gOnvifConf.PTEnable == false_) && (gOnvifConf.PTEnableBy485 == false_)) {
				return soap_sender_fault_subcode_v2 (soap, "ter::ActionNotSupported", "ter:PTZNotSupported",
                                                     NULL, "PTZ is not supported.");
	    	}
	    	/* I could perform PT control */
	    	SpeedP = OnvifPTVelocityFmUrl(tptz__ContinuousMove->Velocity->PanTilt->x);
	    	SpeedT = OnvifPTVelocityFmUrl(tptz__ContinuousMove->Velocity->PanTilt->y);
	    	if((SpeedP != 0) || (SpeedT != 0)) toutCmd.needStopPTCmd = 1;
	    	if(SpeedP > 0) { /* move to right */
				if(SpeedT > 0) {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=UPRIGHT,%d,%d", SpeedP, SpeedT);
				} else if(SpeedT < 0) {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=DOWNRIGHT,%d,%d", SpeedP, (-1*SpeedT));
				} else {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=RIGHT,%d", SpeedP);
				}
	    	} else if(SpeedP < 0) { /* move to left */
				SpeedP = -1 * SpeedP;
				if(SpeedT > 0) {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=UPLEFT,%d,%d", SpeedP, SpeedT);
				} else if(SpeedT < 0) {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=DOWNLEFT,%d,%d", SpeedP, (-1*SpeedT));
				} else {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=LEFT,%d", SpeedP);
				}
	    	} else { /* no pan direction movement */
				if(SpeedT > 0) {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=UP,%d", SpeedT);
				} else if(SpeedT < 0) {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=DOWN,%d", (-1*SpeedT));
				} else {
		    		snprintf(toutCmd.moveCmd, sizeof(toutCmd.moveCmd), "MOVE=STOP");
				}
	    	}
        } /* end of PT control with velocity settings */
		if(tptz__ContinuousMove->Velocity->Zoom != NULL) { /* client request zoom move */
	    	if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
				SpeedZ = OnvifZoomVelocityFmUrl(tptz__ContinuousMove->Velocity->Zoom->x);
	    	} else {
				return soap_sender_fault_subcode_v2 (soap, "ter::ActionNotSupported", "ter:PTZNotSupported",
						    						 NULL, "PTZ is not supported.");
	    	}
	    	/* I could perfrom zoom control */
	    	if(SpeedZ != 0) toutCmd.needStopZoomCmd = 1;
	    	if(SpeedZ > 0) { /* move to tele */
				snprintf(toutCmd.zoomCmd, sizeof(toutCmd.zoomCmd), "ZOOM=TELE,%d", SpeedZ);
	    	} else if (SpeedZ < 0) { /* move to wide */
				snprintf(toutCmd.zoomCmd, sizeof(toutCmd.zoomCmd), "ZOOM=WIDE,%d", (-1*SpeedZ));
	    	} else {
				snprintf(toutCmd.zoomCmd, sizeof(toutCmd.zoomCmd), "ZOOM=STOP");
	    	}
		}
    } /* end of PTZ velocity parser */
    
    if(tptz__ContinuousMove->Timeout != NULL) {
        if (parserTimeInterval(tptz__ContinuousMove->Timeout, &toutCmd.timer) == ERR) return SOAP_ERR;
    }
    
    if( (toutCmd.timer > 1) &&
        ((toutCmd.needStopPTCmd == 1) || (toutCmd.needStopZoomCmd == 1)) ) {
        if (pthread_create (&DelayTime_t, NULL, ContinueMoveTimerHandler, (void *)&toutCmd) == 0) {
            usleep(100*1000);
			return SOAP_OK;
        }
        /* fail to create the thread !! */
        L1 ("error. create ContinueMoveTimerHandler (%d), (%s),(%s)\n", toutCmd.timer, toutCmd.moveCmd, toutCmd.zoomCmd);
        return SOAP_ERR;
    }
    if(toutCmd.needStopPTCmd == 1) {
		(void)OnvifSingleUrlCmdSend("encoder", toutCmd.moveCmd, NULL, 0);
		gMovePanDirection = 0;
		fprintf(stdout, "%s:send URL %s\n", __func__, toutCmd.moveCmd);
	}
    if(toutCmd.needStopZoomCmd == 1) {
	   	(void)OnvifSingleUrlCmdSend("encoder", toutCmd.zoomCmd, NULL, 0);
		fprintf(stdout, "%s:send URL %s\n", __func__, toutCmd.zoomCmd);
    }
	if(toutCmd.timer == 1) {
		 if(toutCmd.needStopPTCmd == 1)   (void)OnvifSingleUrlCmdSend("encoder", "MOVE=STOP", NULL, 0);
		 if(toutCmd.needStopZoomCmd == 1) (void)OnvifSingleUrlCmdSend("encoder", "ZOOM=STOP", NULL, 0);
	}
    return SOAP_OK;
}

int __tptz__SendAuxiliaryCommand(struct soap *soap, struct _tptz__SendAuxiliaryCommand *tptz__SendAuxiliaryCommand, struct _tptz__SendAuxiliaryCommandResponse *tptz__SendAuxiliaryCommandResponse)
{
//char *ProfileToken;	/* required element of type tt:ReferenceToken */
//char *AuxiliaryData;	/* required element of type tt:AuxiliaryData */
	tUrlDB url;
	char ReplyMsg[512];
 	int idx = 0; 
    
	if (tptz__SendAuxiliaryCommand->ProfileToken == NULL
	   || tptz__SendAuxiliaryCommand->AuxiliaryData == NULL)
		return SOAP_REQUIRED;

	if (FindMediaProfile (soap, tptz__SendAuxiliaryCommand->ProfileToken, &idx) == OK) {
		tptz__SendAuxiliaryCommandResponse->AuxiliaryResponse = (char *) soap_malloc (soap, 4);
	} else {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", 
                                             NULL, "The requested profile token ProfileToken does not exist.");
	}

	strcpy(url.cgi, "encoder");
	if (!strcmp (tptz__SendAuxiliaryCommand->AuxiliaryData, AuxiliaryAlarmOutputOn)) {
		strcpy(url.cmd, "DIO_OUTPUT=0x3");
	} else if (!strcmp (tptz__SendAuxiliaryCommand->AuxiliaryData, AuxiliaryAlarmOutputOff)) {
		strcpy(url.cmd, "DIO_OUTPUT=0x0");
	} else {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter: AuxiliaryDataNotSupported", 
                                             NULL, "The requested AuxiliaryCommand is not supported.");
	}

	url.len = strlen(url.cmd);
	OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
	tptz__SendAuxiliaryCommandResponse->AuxiliaryResponse = "OK"; 	/* DIO_OUTPUT returns OK always */

	return SOAP_OK;
}


int __tptz__RelativeMove(struct soap *soap, struct _tptz__RelativeMove *tptz__RelativeMove, struct _tptz__RelativeMoveResponse *tptz__RelativeMoveResponse)
{
    int id=0;
    char cmd[64];
    int SetOffsetXY = 0; /* 0: not set, 1: set */
    int SetOffsetZ = 0; /* 0: not set, -1, out of range, 1: set */
    int OffsetX = -1;
    int OffsetY = -1;
    int OffsetZ = -1;
    int PosZ = -1;
    int SpeedX = -1; /* -1: not set pan speed or out of range */
    int SpeedY = -1; /* -1: not set tilt speed or out of range */
    int SpeedZ = -1; /* -1: not set tilt speed or out of range */
    int ret=ERR;
    tUrlDB url;
    char ReplyMsg[512];
    char value[32];

    if (FindMediaProfile (soap, tptz__RelativeMove->ProfileToken, &id) != OK) {
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
					    "The requested profile token ProfileToken does not exist.");
    }
    if(gOnvifConf.PTZ_AddToken[id] != true_) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoPTZProfile", NULL,
                                             "The requested profile token does not reference a PTZ configuration.");
    }
	
    if(tptz__RelativeMove->Translation == NULL) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:SpaceNotSupported", NULL,
                                             "A space is referenced in an argument which is not supported by the PTZ Node.");
    }
        /* get the absolute pan and tilt position if they are in the request */
    if(tptz__RelativeMove->Translation->PanTilt != NULL) {
	if( (tptz__RelativeMove->Translation->PanTilt->x >= ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN]) &&
	    (tptz__RelativeMove->Translation->PanTilt->x <= ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX]) &&
            (tptz__RelativeMove->Translation->PanTilt->y >= ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN]) &&
            (tptz__RelativeMove->Translation->PanTilt->y <= ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX])) {
            OffsetX = -1*Denormalize_PTZPosition (OPT_PAN_POSITION, tptz__RelativeMove->Translation->PanTilt->x);
            OffsetY = Denormalize_PTZPosition (OPT_TILT_VELOCITY, tptz__RelativeMove->Translation->PanTilt->y);
            if(OffsetX == 18000) {
                if(gPTZLimits.MaxPanLimits > 0)      gMovePanDirection = 1;
                else if(gPTZLimits.MaxPanLimits < 0) gMovePanDirection = -1;
            } else if(OffsetX == -18000) {
                if(gPTZLimits.MinPanLimits > 0)      gMovePanDirection = 1;
                else if(gPTZLimits.MinPanLimits < 0) gMovePanDirection = -1;
            }
	    	SetOffsetXY = 1;
			/*
            printf("%s:set pan,tilt to %d/%f, %d/%f\n", __func__,
                       OffsetX, tptz__RelativeMove->Translation->PanTilt->x,
                       OffsetY, tptz__RelativeMove->Translation->PanTilt->y);
			*/
        } else {
	    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidTranslation", NULL,
                                                     "The requested position is out of bounds.");
	}
    }
    /* get the absolute zoom position if they are in the request, the zoom position is non-negative value */
    if(tptz__RelativeMove->Translation->Zoom != NULL) {
	if( (tptz__RelativeMove->Translation->Zoom->x >= ptzNormalRange[OPT_ZOOM_VELOCITY][LIMIT_MIN]) &&
	    (tptz__RelativeMove->Translation->Zoom->x <= ptzNormalRange[OPT_ZOOM_VELOCITY][LIMIT_MAX])) {

		strcpy(url.cgi, "encoder");
		url.len = 0;
	    	if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
			url.len = sprintf(url.cmd, "ZOOM_POSITION");
      	  if(url.len > 0) {
            	ret = OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
			if(ret == OK) {
        			if(OnvifGetValueFmUrlReply(ReplyMsg, "ZOOM_POSITION=", value, (sizeof(value)-1)) > 0) 
					PosZ = atoi(value);
				else PosZ = gPTZLimits.MinZoomLimits;
			}else PosZ = gPTZLimits.MinZoomLimits;
	            L4("send URL %d, %s, Get Current Zoom Position = %d\n", url.len, url.cmd, PosZ);
      	    }
	       }else PosZ = gPTZLimits.MinZoomLimits;

            OffsetZ = Denormalize_PTZPosition (OPT_ZOOM_VELOCITY, tptz__RelativeMove->Translation->Zoom->x);
		PosZ = PosZ + OffsetZ;
		if(PosZ < gPTZLimits.MinZoomLimits) PosZ = gPTZLimits.MinZoomLimits;
		if(PosZ > gPTZLimits.MaxZoomLimits) PosZ = gPTZLimits.MaxZoomLimits;
            SetOffsetZ = 1;
            //printf("%s: set zoom pos %d/%f\n", __func__, OffsetZ, tptz__RelativeMove->Translation->Zoom->x);
        } else {
	    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidTranslation", NULL,
                                                     "The requested position is out of bounds.");
	}
    }
    /* get the pan/tilt speed */
    if(tptz__RelativeMove->Speed != NULL) {
	if(tptz__RelativeMove->Speed->PanTilt != NULL) {
	    if(	(tptz__RelativeMove->Speed->PanTilt->x >= ptzNormalRange[OPT_PAN_SPEED][LIMIT_MIN]) &&
		(tptz__RelativeMove->Speed->PanTilt->x <= ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX])) {
		SpeedX = Denormalize_PanTiltSpeed (OPT_PAN_SPEED, tptz__RelativeMove->Speed->PanTilt->x);
	    }
	    if(	(tptz__RelativeMove->Speed->PanTilt->y >= ptzNormalRange[OPT_TILT_SPEED][LIMIT_MIN]) &&
		(tptz__RelativeMove->Speed->PanTilt->y <= ptzNormalRange[OPT_TILT_SPEED][LIMIT_MAX])) {
		SpeedY = Denormalize_PanTiltSpeed (OPT_TILT_SPEED, tptz__RelativeMove->Speed->PanTilt->y);
	    }
	    if((SpeedX < 0) || (SpeedY < 0)) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidSpeed", NULL,
                                                         "The requested speed is out of bounds.");
	    }
	}
	if(tptz__RelativeMove->Speed->Zoom != NULL) {
	    if(	(tptz__RelativeMove->Speed->Zoom->x >= ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MIN]) &&
		(tptz__RelativeMove->Speed->Zoom->x <= ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX])) {
		SpeedZ = Denormalize_ZoomSpeed (OPT_ZOOM_SPEED, tptz__RelativeMove->Speed->Zoom->x);
	    } else {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidSpeed", NULL,
                                                         "The requested speed is out of bounds.");
	    }
	}
    }
    /* send PTZ URL command to the aistreamer */
    strcpy(url.cgi, "encoder");
    url.len = 0;
    if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
        if(SpeedZ == 0) { /* send zoom stop command */
            url.len = sprintf(cmd, "ZOOM=STOP");
        } else {
            if(SetOffsetZ == 1) {
		    if(SpeedZ > 0)
	                url.len = sprintf(url.cmd, "ZOOM=DIRECT,%d,%d", PosZ, SpeedZ);
		    else
	                url.len = sprintf(url.cmd, "ZOOM=DIRECT,%d,%d", PosZ, MAX_PHY_ZOOM_SPEED);//Work Around for Onvif Device Management
           }
        }
        if(url.len > 0) {
            OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
            L4("send URL %d, %s, %f\n", url.len, url.cmd, tptz__RelativeMove->Translation->Zoom->x);
        }
    }
    url.len = 0;
    if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
        if((SpeedX == 0) || (SpeedY == 0)) { /* send stop command */
            url.len = sprintf(url.cmd, "MOVE=STOP");
        } else {
            if(SetOffsetXY == 1) {
                url.len = sprintf(url.cmd, "POSITION=RELATE,%d,%d", OffsetX, OffsetY);
                if((SpeedX > 0) && (SpeedY > 0)) {
                    url.len += sprintf(&url.cmd[url.len], ",%d,%d", SpeedX, SpeedY);
                } else {
                    url.len += sprintf(&url.cmd[url.len], ",%d,%d", MAX_PHY_PAN_SPEED, MAX_PHY_TILT_SPEED);//Work Around for Onvif Device Management
		    }
            }
        }
        if(url.len > 0) {
            OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
			L4(	"send URL %d, %s, %f,%f\n", url.len, url.cmd,
				tptz__RelativeMove->Translation->PanTilt->x, tptz__RelativeMove->Translation->PanTilt->y); 
        }
	}
	return SOAP_OK;
}

int __tptz__AbsoluteMove(struct soap *soap, struct _tptz__AbsoluteMove *tptz__AbsoluteMove, struct _tptz__AbsoluteMoveResponse *tptz__AbsoluteMoveResponse)
{
    int id=0;
    char cmd[64];
    int SetPosXY = 0; /* 0: not set, 1: set */
    int SetPosZ = 0; /* 0: not set, -1, out of range, 1: set */
    int PosX = -1;
    int PosY = -1;
    int PosZ = -1;
    int SpeedX = -1; /* -1: not set pan speed or out of range */
    int SpeedY = -1; /* -1: not set tilt speed or out of range */
    int SpeedZ = -1; /* -1: not set tilt speed or out of range */
    tUrlDB url;
    char ReplyMsg[512];

    if (FindMediaProfile (soap, tptz__AbsoluteMove->ProfileToken, &id) != OK) {
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
					    "The requested profile token ProfileToken does not exist.");
    }
    if(gOnvifConf.PTZ_AddToken[id] != true_) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoPTZProfile", NULL,
                                             "The requested profile token does not reference a PTZ configuration.");
    }
	
    if(tptz__AbsoluteMove->Position == NULL) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:SpaceNotSupported", NULL,
                                             "A space is referenced in an argument which is not supported by the PTZ Node.");
    }
        /* get the absolute pan and tilt position if they are in the request */
    if(tptz__AbsoluteMove->Position->PanTilt != NULL) {
	if( (tptz__AbsoluteMove->Position->PanTilt->x >= ptzNormalRange[OPT_PAN_POSITION][LIMIT_MIN]) &&
	    (tptz__AbsoluteMove->Position->PanTilt->x <= ptzNormalRange[OPT_PAN_POSITION][LIMIT_MAX]) &&
            (tptz__AbsoluteMove->Position->PanTilt->y >= ptzNormalRange[OPT_TILT_POSITION][LIMIT_MIN]) &&
            (tptz__AbsoluteMove->Position->PanTilt->y <= ptzNormalRange[OPT_TILT_POSITION][LIMIT_MAX])) {
            PosX = Denormalize_PTZPosition (OPT_PAN_POSITION, tptz__AbsoluteMove->Position->PanTilt->x);
            PosY = Denormalize_PTZPosition (OPT_TILT_POSITION, tptz__AbsoluteMove->Position->PanTilt->y);
            if(PosX == 18000) {
                if(gPTZLimits.MaxPanLimits > 0)      gMovePanDirection = 1;
                else if(gPTZLimits.MaxPanLimits < 0) gMovePanDirection = -1;
            } else if(PosX == -18000) {
                if(gPTZLimits.MinPanLimits > 0)      gMovePanDirection = 1;
                else if(gPTZLimits.MinPanLimits < 0) gMovePanDirection = -1;
            }
	    	SetPosXY = 1;
			/*
            printf("%s:set pan,tilt to %d/%f, %d/%f\n", __func__,
                       PosX, tptz__AbsoluteMove->Position->PanTilt->x,
                       PosY, tptz__AbsoluteMove->Position->PanTilt->y);
			*/
        } else {
	    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidPosition", NULL,
                                                     "The requested position is out of bounds.");
	}
    }
    /* get the absolute zoom position if they are in the request, the zoom position is non-negative value */
    if(tptz__AbsoluteMove->Position->Zoom != NULL) {
	if( (tptz__AbsoluteMove->Position->Zoom->x >= ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MIN]) &&
	    (tptz__AbsoluteMove->Position->Zoom->x <= ptzNormalRange[OPT_ZOOM_POSITION][LIMIT_MAX])) {
            PosZ = Denormalize_PTZPosition (OPT_ZOOM_POSITION, tptz__AbsoluteMove->Position->Zoom->x);
            SetPosZ = 1;
            //printf("%s: set zoom pos %d/%f\n", __func__, PosZ, tptz__AbsoluteMove->Position->Zoom->x);
        } else {
	    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidPosition", NULL,
                                                     "The requested position is out of bounds.");
	}
    }
    /* get the pan/tilt speed */
    if(tptz__AbsoluteMove->Speed != NULL) {
	if(tptz__AbsoluteMove->Speed->PanTilt != NULL) {
	    if(	(tptz__AbsoluteMove->Speed->PanTilt->x >= ptzNormalRange[OPT_PAN_SPEED][LIMIT_MIN]) &&
		(tptz__AbsoluteMove->Speed->PanTilt->x <= ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX])) {
		SpeedX = Denormalize_PanTiltSpeed (OPT_PAN_SPEED, tptz__AbsoluteMove->Speed->PanTilt->x);
	    }
	    if(	(tptz__AbsoluteMove->Speed->PanTilt->y >= ptzNormalRange[OPT_TILT_SPEED][LIMIT_MIN]) &&
		(tptz__AbsoluteMove->Speed->PanTilt->y <= ptzNormalRange[OPT_TILT_SPEED][LIMIT_MAX])) {
		SpeedY = Denormalize_PanTiltSpeed (OPT_TILT_SPEED, tptz__AbsoluteMove->Speed->PanTilt->y);
	    }
	    if((SpeedX < 0) || (SpeedY < 0)) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidSpeed", NULL,
                                                         "The requested speed is out of bounds.");
	    }
	}
	if(tptz__AbsoluteMove->Speed->Zoom != NULL) {
	    if(	(tptz__AbsoluteMove->Speed->Zoom->x >= ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MIN]) &&
		(tptz__AbsoluteMove->Speed->Zoom->x <= ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX])) {
		SpeedZ = Denormalize_ZoomSpeed (OPT_ZOOM_SPEED, tptz__AbsoluteMove->Speed->Zoom->x);
	    } else {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidSpeed", NULL,
                                                         "The requested speed is out of bounds.");
	    }
	}
    }
    /* send PTZ URL command to the aistreamer */
    strcpy(url.cgi, "encoder");
    url.len = 0;
    if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
        if(SpeedZ == 0) { /* send zoom stop command */
            url.len = sprintf(cmd, "ZOOM=STOP");
        } else {
            if(SetPosZ == 1) {
                url.len = sprintf(url.cmd, "ZOOM=DIRECT,%d,%d", PosZ, SpeedZ);
            }
        }
        if(url.len > 0) {
            OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
            L4("send URL %d, %s, %f\n", url.len, url.cmd, tptz__AbsoluteMove->Position->Zoom->x);
        }
    }
    url.len = 0;
    if ((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
        if((SpeedX == 0) || (SpeedY == 0)) { /* send stop command */
            url.len = sprintf(url.cmd, "MOVE=STOP");
        } else {
            if(SetPosXY == 1) {
                url.len = sprintf(url.cmd, "POSITION=ABSOLUTE,%d,%d", PosX, PosY);
                if((SpeedX > 0) && (SpeedY > 0)) {
                    url.len += sprintf(&url.cmd[url.len], ",%d,%d", SpeedX, SpeedY);
                } else {
                    url.len += sprintf(&url.cmd[url.len], ",%d,%d", 5, 5);//Work Around for Onvif Device Management
		    }
            }
        }
        if(url.len > 0) {
            OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
			L4(	"send URL %d, %s, %f,%f\n", url.len, url.cmd,
				tptz__AbsoluteMove->Position->PanTilt->x, tptz__AbsoluteMove->Position->PanTilt->y); 
        }
    }
    return SOAP_OK;
}


int __tptz__Stop(struct soap *soap, struct _tptz__Stop *tptz__Stop, struct _tptz__StopResponse *tptz__StopResponse)
{	
	int id=0;
	tUrlDB url;
	char ReplyMsg[512];

	url.cmd[0] = '\0';

	if (tptz__Stop->ProfileToken == NULL)
		return soap_sender_fault (soap, "", NULL);
	if (FindMediaProfile (soap, tptz__Stop->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
									 "The requested profile token ProfileToken does not exist.");
	if(gOnvifConf.PTZ_AddToken[id] != true_) return SOAP_ERR;

	if((tptz__Stop->PanTilt != NULL) && (*tptz__Stop->PanTilt == true_))
		strcpy(url.cmd, "MOVE=STOP");
	
	if((tptz__Stop->Zoom != NULL) && (*tptz__Stop->Zoom == true_))
		OnvifCmdAdd(&url, "ZOOM=STOP");

	if(url.cmd[0] != '\0')
	{
		strcpy(url.cgi, "encoder");
		L2("URL = %s\n", url.cmd);
		url.len = strlen(url.cmd);
		OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
	}

	return SOAP_OK;
}


#ifdef HAVE__GETSERVICES
/** Auto-test server operation __tptz__GetServiceCapabilities_ */
int __tptz__GetServiceCapabilities_(struct soap *soap, struct _tptz__GetServiceCapabilities *tptz__GetServiceCapabilities, struct _tptz__GetServiceCapabilitiesResponse *tptz__GetServiceCapabilitiesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}
#endif

int __tptz__GetConfigurations_(struct soap *soap, struct _tptz__GetConfigurations *tptz__GetConfigurations, struct _tptz__GetConfigurationsResponse *tptz__GetConfigurationsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__GetPresets_(struct soap *soap, struct _tptz__GetPresets *tptz__GetPresets, struct _tptz__GetPresetsResponse *tptz__GetPresetsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__SetPreset_(struct soap *soap, struct _tptz__SetPreset *tptz__SetPreset, struct _tptz__SetPresetResponse *tptz__SetPresetResponse)
{	
	return SOAP_OK;
}


int __tptz__RemovePreset_(struct soap *soap, struct _tptz__RemovePreset *tptz__RemovePreset, struct _tptz__RemovePresetResponse *tptz__RemovePresetResponse)
{	
	return SOAP_OK;
}


int __tptz__GotoPreset_(struct soap *soap, struct _tptz__GotoPreset *tptz__GotoPreset, struct _tptz__GotoPresetResponse *tptz__GotoPresetResponse)
{	
	return SOAP_OK;
}


int __tptz__GetStatus_(struct soap *soap, struct _tptz__GetStatus *tptz__GetStatus, struct _tptz__GetStatusResponse *tptz__GetStatusResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__GetConfiguration_(struct soap *soap, struct _tptz__GetConfiguration *tptz__GetConfiguration, struct _tptz__GetConfigurationResponse *tptz__GetConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__GetNodes_(struct soap *soap, struct _tptz__GetNodes *tptz__GetNodes, struct _tptz__GetNodesResponse *tptz__GetNodesResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__GetNode_(struct soap *soap, struct _tptz__GetNode *tptz__GetNode, struct _tptz__GetNodeResponse *tptz__GetNodeResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__SetConfiguration_(struct soap *soap, struct _tptz__SetConfiguration *tptz__SetConfiguration, struct _tptz__SetConfigurationResponse *tptz__SetConfigurationResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__GetConfigurationOptions_(struct soap *soap, struct _tptz__GetConfigurationOptions *tptz__GetConfigurationOptions, struct _tptz__GetConfigurationOptionsResponse *tptz__GetConfigurationOptionsResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


int __tptz__GotoHomePosition_(struct soap *soap, struct _tptz__GotoHomePosition *tptz__GotoHomePosition, struct _tptz__GotoHomePositionResponse *tptz__GotoHomePositionResponse)
{	
	return SOAP_OK;
}


//w: int __tptz__SetHomePosition_(struct soap *soap, struct _tptz__SetHomePosition *tptz__SetHomePosition, char **tptz__SetHomePositionResponse)
int __tptz__SetHomePosition_(struct soap *soap, struct _tptz__SetHomePosition *tptz__SetHomePosition, struct _tptz__SetHomePositionResponse *tptz__SetHomePositionResponse)
{
	return SOAP_OK;
}


int __tptz__ContinuousMove_(struct soap *soap, struct _tptz__ContinuousMove *tptz__ContinuousMove, struct _tptz__ContinuousMoveResponse *tptz__ContinuousMoveResponse)
{	
	return SOAP_OK;
}


/** Auto-test server operation __tptz__SendAuxiliaryCommand_ */
int __tptz__SendAuxiliaryCommand_(struct soap *soap, struct _tptz__SendAuxiliaryCommand *tptz__SendAuxiliaryCommand, struct _tptz__SendAuxiliaryCommandResponse *tptz__SendAuxiliaryCommandResponse)
{	
	/* Return incomplete response with default data values */
	return SOAP_OK;
}


#if 1
int __tptz__RelativeMove_(struct soap *soap, struct _tptz__RelativeMove *tptz__RelativeMove, struct _tptz__RelativeMoveResponse *tptz__RelativeMoveResponse)
{	
	return SOAP_OK;
}
#endif 
int __tptz__AbsoluteMove_(struct soap *soap, struct _tptz__AbsoluteMove *tptz__AbsoluteMove, struct _tptz__AbsoluteMoveResponse *tptz__AbsoluteMoveResponse)
{	
	return SOAP_OK;
}


int __tptz__Stop_(struct soap *soap, struct _tptz__Stop *tptz__StopRequest, struct _tptz__StopResponse *tptz__StopResponse)
{	
	return SOAP_OK;
}

#ifdef HAVE__GETSERVICES
/** Auto-test server operation __trt__GetServiceCapabilities */
int __trt__GetServiceCapabilities(struct soap *soap, struct _trt__GetServiceCapabilities *trt__GetServiceCapabilities, struct _trt__GetServiceCapabilitiesResponse *trt__GetServiceCapabilitiesResponse)
{	
	static int MaxNumOfProfiles = MAX_PROFILE_LIST; 
	/* struct _trt__GetServiceCapabilitiesResponse */
	soap_default__trt__GetServiceCapabilitiesResponse (soap, trt__GetServiceCapabilitiesResponse);
	/* struct trt__Capabilities */
	trt__GetServiceCapabilitiesResponse->Capabilities = 
		(struct trt__Capabilities *) 
		soap_malloc (soap, sizeof (struct trt__Capabilities));
	soap_default_trt__Capabilities (soap, trt__GetServiceCapabilitiesResponse->Capabilities);
	/* struct trt__ProfileCapabilities */
	trt__GetServiceCapabilitiesResponse->Capabilities->ProfileCapabilities = 
		(struct trt__ProfileCapabilities *) 
		soap_malloc (soap, sizeof (struct trt__ProfileCapabilities));
	soap_default_trt__ProfileCapabilities (soap, trt__GetServiceCapabilitiesResponse->Capabilities->ProfileCapabilities);
	trt__GetServiceCapabilitiesResponse->Capabilities->ProfileCapabilities->MaximumNumberOfProfiles = &MaxNumOfProfiles; //make sure
	/* struct trt__StreamingCapabilities */
	trt__GetServiceCapabilitiesResponse->Capabilities->StreamingCapabilities = 
		(struct trt__StreamingCapabilities *) 
		soap_malloc (soap, sizeof (struct trt__StreamingCapabilities));
	soap_default_trt__StreamingCapabilities (soap, trt__GetServiceCapabilitiesResponse->Capabilities->StreamingCapabilities);
	trt__GetServiceCapabilitiesResponse->Capabilities->StreamingCapabilities->RTPMulticast = &blTrue;
	trt__GetServiceCapabilitiesResponse->Capabilities->StreamingCapabilities->RTP_USCORETCP = &blFalse;
	trt__GetServiceCapabilitiesResponse->Capabilities->StreamingCapabilities->RTP_USCORERTSP_USCORETCP = &blFalse;
	//Indicates support for non aggregate RTSP control.
	trt__GetServiceCapabilitiesResponse->Capabilities->StreamingCapabilities->NonAggregateControl = &blFalse;//make sure

	return SOAP_OK;
}
#endif
int __trt__GetVideoSources (struct soap *soap, struct _trt__GetVideoSources *trt__GetVideoSources,
							struct _trt__GetVideoSourcesResponse *trt__GetVideoSourcesResponse)
{
	int i;
/// Top of Winters ///
	soap_default__trt__GetVideoSourcesResponse (soap, trt__GetVideoSourcesResponse); 
/// Bottom of Winters ///
	trt__GetVideoSourcesResponse->__sizeVideoSources = gOnvifConf.SourceTokenCnt;
	trt__GetVideoSourcesResponse->VideoSources =
		(struct tt__VideoSource *) soap_malloc (soap, sizeof (struct tt__VideoSource) * gOnvifConf.SourceTokenCnt);
	for (i = 0; i < gOnvifConf.SourceTokenCnt; i++) {
		soap_default_tt__VideoSource (soap, &trt__GetVideoSourcesResponse->VideoSources[i]);
		trt__GetVideoSourcesResponse->VideoSources[i].token = gOnvifConf.SourceToken[i].Token;
		trt__GetVideoSourcesResponse->VideoSources[i].Framerate = gOnvifConf.SourceToken[i].FrameRate;
		trt__GetVideoSourcesResponse->VideoSources[i].Resolution =
			(struct tt__VideoResolution *) soap_malloc (soap, sizeof (struct tt__VideoResolution));
		soap_default_tt__VideoResolution (soap, trt__GetVideoSourcesResponse->VideoSources[i].Resolution);
		trt__GetVideoSourcesResponse->VideoSources[i].Resolution->Width = gOnvifConf.SourceToken[i].res.Width;
		trt__GetVideoSourcesResponse->VideoSources[i].Resolution->Height = gOnvifConf.SourceToken[i].res.Height;
/// Top of Winters ///
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging = 
			(struct tt__ImagingSettings *) soap_malloc (soap, sizeof (struct tt__ImagingSettings));
		soap_default_tt__ImagingSettings (soap, trt__GetVideoSourcesResponse->VideoSources[i].Imaging);
		/* struct tt__BacklightCompensation */
if (gOnvifConf.BLCEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->BacklightCompensation = 
			(struct tt__BacklightCompensation *) 
			soap_malloc (soap, sizeof (struct tt__BacklightCompensation));
		soap_default_tt__BacklightCompensation (soap, 
			trt__GetVideoSourcesResponse->VideoSources[i].Imaging->BacklightCompensation);
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->BacklightCompensation->Mode = 
			gOnvifConf.SourceToken[i].img.BLCMode;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->BacklightCompensation->Level = 
			gOnvifConf.SourceToken[i].img.BLCLevel;
}
if (gOnvifConf.BrightnessEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Brightness = 
			&gOnvifConf.SourceToken[i].img.Brightness;
}
if (gOnvifConf.SaturationEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->ColorSaturation = 
			&gOnvifConf.SourceToken[i].img.ColorSaturation;
}
if (gOnvifConf.ContrastEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Contrast = 
			&gOnvifConf.SourceToken[i].img.Contrast;
}
		/* struct tt__Exposure */
if (gOnvifConf.ExposureEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure = 
			(struct tt__Exposure *) soap_malloc (soap, sizeof (struct tt__Exposure));
		soap_default_tt__Exposure (soap, 
			trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure);
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Mode = 
			gOnvifConf.SourceToken[i].img.ExposureMode; 
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Priority = 
			gOnvifConf.SourceToken[i].img.ExposurePriority; 
		/* struct tt__Rectangle */
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Window = 
			(struct tt__Rectangle *) soap_malloc (soap, sizeof (struct tt__Rectangle));
		soap_default_tt__Rectangle (soap, 
			trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Window);
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Window->bottom = 
			&gOnvifConf.SourceToken[i].img.ExposureWindowBottom; 
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Window->top = 
			&gOnvifConf.SourceToken[i].img.ExposureWindowTop; 
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Window->right = 
			&gOnvifConf.SourceToken[i].img.ExposureWindowRight; 
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Window->left = 
			&gOnvifConf.SourceToken[i].img.ExposureWindowLeft; 
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->MinExposureTime = 
			gOnvifConf.SourceToken[i].img.MinExposureTime;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->MaxExposureTime = 
			gOnvifConf.SourceToken[i].img.MaxExposureTime;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->MinGain = 
			gOnvifConf.SourceToken[i].img.MinGain;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->MaxGain = 
			gOnvifConf.SourceToken[i].img.MaxGain;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->MinIris = 
			gOnvifConf.SourceToken[i].img.MinIris;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->MaxIris = 
			gOnvifConf.SourceToken[i].img.MaxIris;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->ExposureTime = 
			gOnvifConf.SourceToken[i].img.ExposureTime;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Gain = 
			gOnvifConf.SourceToken[i].img.Gain;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Exposure->Iris = 
			gOnvifConf.SourceToken[i].img.Iris;
}
		/* struct tt__FocusConfiguration */
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Focus = 
			(struct tt__FocusConfiguration *) soap_malloc (soap, sizeof (struct tt__FocusConfiguration)); 
		soap_default_tt__FocusConfiguration (soap, 
			trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Focus);
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Focus->AutoFocusMode = 
			gOnvifConf.SourceToken[i].img.AutoFocusMode;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Focus->DefaultSpeed = 
			gOnvifConf.SourceToken[i].img.DefaultSpeed;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Focus->NearLimit = 
			gOnvifConf.SourceToken[i].img.NearLimit;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Focus->FarLimit = 
			gOnvifConf.SourceToken[i].img.FarLimit;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->IrCutFilter = 
			&gOnvifConf.SourceToken[i].img.IrCutFilter;
if (gOnvifConf.SharpnessEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->Sharpness = 
			&gOnvifConf.SourceToken[i].img.Sharpness;
}
		/* struct tt__WideDynamicRange */
if (gOnvifConf.WDREnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WideDynamicRange = 
			(struct tt__WideDynamicRange *) soap_malloc (soap, sizeof (struct tt__WideDynamicRange));
		soap_default_tt__WideDynamicRange (soap, 
			trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WideDynamicRange);
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WideDynamicRange->Mode = 
			gOnvifConf.SourceToken[i].img.WDRMode;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WideDynamicRange->Level = 
			gOnvifConf.SourceToken[i].img.WDRLevel;
}
		/* struct tt__WhiteBalance */
if (gOnvifConf.WhiteBalanceEnable == true_)
{
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WhiteBalance = 
			(struct tt__WhiteBalance *) soap_malloc (soap, sizeof (struct tt__WhiteBalance));
		soap_default_tt__WhiteBalance (soap, 
			trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WhiteBalance);
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WhiteBalance->Mode = 
			gOnvifConf.SourceToken[i].img.WhiteBalanceMode;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WhiteBalance->CrGain = 
			gOnvifConf.SourceToken[i].img.CrGain;
		trt__GetVideoSourcesResponse->VideoSources[i].Imaging->WhiteBalance->CrGain = 
			gOnvifConf.SourceToken[i].img.CbGain;
}
/// Bottom of Winters ///
	}
	return SOAP_OK;
}


int __trt__GetAudioSources (struct soap *soap, struct _trt__GetAudioSources *trt__GetAudioSources,
							struct _trt__GetAudioSourcesResponse *trt__GetAudioSourcesResponse)
{
	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
	trt__GetAudioSourcesResponse->__sizeAudioSources = gOnvifConf.sizeAS;	
	trt__GetAudioSourcesResponse->AudioSources = 
		(struct tt__AudioSource *) soap_malloc (soap, sizeof(struct tt__AudioSource));
	soap_default_tt__AudioSource (soap, trt__GetAudioSourcesResponse->AudioSources);
	trt__GetAudioSourcesResponse->AudioSources->token = soap_malloc (soap, MAX_TOKEN_STRLEN); 
	strcpy (trt__GetAudioSourcesResponse->AudioSources->token, gOnvifConf.AudioSource.token);
	trt__GetAudioSourcesResponse->AudioSources->Channels = gOnvifConf.AudioSource.Channels;
#if 0 //w
	trt__GetAudioSourcesResponse->__sizeAudioSources = 1;	
	trt__GetAudioSourcesResponse->AudioSources = (struct tt__AudioSource *) soap_malloc(soap, sizeof(struct tt__AudioSource));
	soap_default_tt__AudioSource(soap, trt__GetAudioSourcesResponse->AudioSources);
	trt__GetAudioSourcesResponse->AudioSources->token = "0";
	trt__GetAudioSourcesResponse->AudioSources->Channels = 1;
#endif
	return SOAP_OK;
}

/** Auto-test server operation __trt__GetAudioOutputs */
int __trt__GetAudioOutputs(struct soap *soap, struct _trt__GetAudioOutputs *trt__GetAudioOutputs, struct _trt__GetAudioOutputsResponse *trt__GetAudioOutputsResponse)
{	
	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return SOAP_OK;
}

int __trt__CreateProfile (struct soap *soap, struct _trt__CreateProfile *trt__CreateProfile,
			  struct _trt__CreateProfileResponse *trt__CreateProfileResponse)
{
    int i;
    int veIdx = 0;
    Acti_MediaProfile *profile = NULL;

    if (gOnvifConf.ProfileCnt >= MAX_PROFILE_LIST) {
	L1("error. max profile cnt reach %d/%d\n", gOnvifConf.ProfileCnt, MAX_PROFILE_LIST);
	fprintf(stdout, "profile:%d\n", gOnvifConf.ProfileCnt);
	for(i = 0 ; i < MAX_PROFILE_LIST ; i ++) {
	    fprintf(stdout, "profile %d: valid=%d,ro=%d,%s,%s,vsIdx=%d,veIdx=%d\n", i+1,
		    gOnvifConf.profile[i].valid,gOnvifConf.profile[i].readOnly,
		    gOnvifConf.profile[i].Name, gOnvifConf.profile[i].token,
		    gOnvifConf.profile[i].vsIdx, gOnvifConf.profile[i].veIdx);
	}
	return soap_receiver_fault_subcode_v2 (	soap, "ter:Action", "ter:MaxNVTProfiles", "Maximum number reached",
						"The maximum number of supported profiles has been reached.");
    }
    if (!trt__CreateProfile->Name || !strlen (trt__CreateProfile->Name) ||
	strlen (trt__CreateProfile->Name) > MAX_PROFILE_STR ) {
	return soap_sender_fault (soap, "", NULL);
    }
    /* check if the token in this creating profile is the same as the existing profile */
    if((trt__CreateProfile->Token) && (strlen(trt__CreateProfile->Token) > 0)) {
	for (i = 0; i < MAX_PROFILE_LIST; i++) {
	    if(gOnvifConf.profile[i].valid == 1) {
		if(strcmp(gOnvifConf.profile[i].token, trt__CreateProfile->Token) == 0) {
		    return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:ProfileExists", NULL,
							   "A profile with the token ProfileToken already exists.");
		}
	    }
	}
    }
    /* find a free profile entry for this request */
    for (i = 0; i < MAX_PROFILE_LIST; i++) {
	if (gOnvifConf.profile[i].valid == 0) {
	    profile = &gOnvifConf.profile[i];
	    profile->readOnly = 0;
            snprintf(profile->Name, MAX_PROFILE_STR, "%s", trt__CreateProfile->Name);
	    if((trt__CreateProfile->Token == NULL) || (strlen(trt__CreateProfile->Token)==0)) {
		snprintf (profile->token, MAX_TOKEN_STRLEN, "t%s", trt__CreateProfile->Name);
	    } else {
		snprintf (profile->token, MAX_TOKEN_STRLEN, "%s", trt__CreateProfile->Token);
            }
	    trt__CreateProfileResponse->Profile = (struct tt__Profile *) soap_malloc (soap, sizeof (struct tt__Profile));
	    soap_default_tt__Profile (soap, trt__CreateProfileResponse->Profile);
	    trt__CreateProfileResponse->Profile->Name  = profile->Name;
	    trt__CreateProfileResponse->Profile->token = profile->token;
	    for(veIdx = 0; veIdx < MAX_VE_LIST ; veIdx ++) {
		if(gOnvifConf.veConf[veIdx].valid == 1) {
		    profile->vsIdx = gOnvifConf.veConf[veIdx].videoSrc-1; 
		    profile->veIdx = veIdx;
		    gOnvifConf.veConf[profile->veIdx].videoSrcInProfile =  gOnvifConf.veConf[veIdx].videoSrc;
		    gOnvifConf.ProfileCnt++;
		    gOnvifConf.veConf[profile->veIdx].UseCount++;
		    gOnvifConf.vsConf[profile->vsIdx].UseCount++;
		    profile->valid = 1;
		    return SOAP_OK;
		}
	    }
	    /* there is no valid video encoder configuration entry for this profile. */
	    L1("error. no valid ve conf for new profile\n");
	}
    }
    return soap_receiver_fault_subcode_v2 (soap, "ter:Action", "ter:MaxNVTProfiles", "Maximum number reached",
					   "The maximum number of supported profiles has been reached.");
}


int __trt__GetProfile (struct soap *soap, struct _trt__GetProfile *trt__GetProfile,
					   struct _trt__GetProfileResponse *trt__GetProfileResponse)
{
	int  idx = 0;
	Acti_MediaProfile *profile = NULL;

    if (FindMediaProfile (soap, trt__GetProfile->ProfileToken, &idx) == OK) {
		profile = &gOnvifConf.profile[idx];
		trt__GetProfileResponse->Profile = (struct tt__Profile *) soap_malloc (soap, sizeof (struct tt__Profile));
		soap_default_tt__Profile (soap, trt__GetProfileResponse->Profile);
		PrepareProfile (soap, trt__GetProfileResponse->Profile, idx);
		return SOAP_OK;
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
		                                 "The requested profile token ProfileToken does not exist.");
}
void OnvifUseCountHousekeeping(void) {
    int i = 0;
    int cntProfile = 0;
    int setValid = 0;
	
    for(i = 0 ; i < MAX_VS_LIST ; i ++) gOnvifConf.vsConf[i].UseCount = 0;
    for(i = 0 ; i < MAX_VE_LIST ; i ++) gOnvifConf.veConf[i].UseCount = 0;
	
    for(i = 0 ; i < MAX_PROFILE_LIST ; i ++) {
	setValid = 0;
	if(gOnvifConf.profile[i].valid == 1) {
	    if((gOnvifConf.profile[i].vsIdx >= 0) && (gOnvifConf.profile[i].veIdx >= 0)) {
		switch(gOnvifConf.veConf[gOnvifConf.profile[i].veIdx].Encoding) {
		    case H264:
			if(gOnvifConf.H264_Enable == true_) setValid = 1;
                        break;
                    case MPEG4:
                        if(gOnvifConf.MJPEG_Enable == true_) setValid = 1;
                        break;
                    default: /* JPEG */
                        if(gOnvifConf.MJPEG_Enable == true_) setValid = 1;
		}
	    } 
	}
	if(setValid) {
	    cntProfile ++;
            gOnvifConf.vsConf[gOnvifConf.profile[i].vsIdx].UseCount ++;
	    gOnvifConf.veConf[gOnvifConf.profile[i].veIdx].UseCount ++;
            gOnvifConf.veConf[gOnvifConf.profile[i].veIdx].videoSrcInProfile = gOnvifConf.profile[i].vsIdx + 1;        
	} else {
	    gOnvifConf.profile[i].valid = 0;
	    gOnvifConf.profile[i].vsIdx = -1;
	    gOnvifConf.profile[i].veIdx  = -1;
	}
    }
    gOnvifConf.ProfileCnt = cntProfile;
}
int __trt__GetProfiles (struct soap *soap, struct _trt__GetProfiles *trt__GetProfiles,
						struct _trt__GetProfilesResponse *trt__GetProfilesResponse)
{
	int i = 0;
	int k = 0;

	OnvifUseCountHousekeeping();
	
	if(gOnvifConf.ProfileCnt > 0) {
		trt__GetProfilesResponse->__sizeProfiles = gOnvifConf.ProfileCnt;
		trt__GetProfilesResponse->Profiles =
			(struct tt__Profile *) soap_malloc (soap, sizeof (struct tt__Profile) * gOnvifConf.ProfileCnt);
		for (i = 0; i < MAX_PROFILE_LIST; i++) {
			if(gOnvifConf.profile[i].valid == 1) {
                soap_default_tt__Profile (soap, &trt__GetProfilesResponse->Profiles[k]);
                PrepareProfile (soap, &trt__GetProfilesResponse->Profiles[k], i);
                k++;
                if(k > gOnvifConf.ProfileCnt) {
                    L1("error. profile count mismatch %d/%d\n", k, gOnvifConf.ProfileCnt);
                    break;
                }
            }
		}
	} else {
        L4("warning! no valide profiles %d\n", gOnvifConf.ProfileCnt);
    }
	return SOAP_OK;
}


int __trt__AddVideoEncoderConfiguration (struct soap *soap,
			 struct _trt__AddVideoEncoderConfiguration *trt__AddVideoEncoderConfiguration,
			 struct _trt__AddVideoEncoderConfigurationResponse *trt__AddVideoEncoderConfigurationResponse)
{
	int  i = 0;
    Acti_MediaProfile *profile = NULL;

    if (trt__AddVideoEncoderConfiguration->ConfigurationToken == NULL) return SOAP_REQUIRED;
    
	if (FindMediaProfile (soap, trt__AddVideoEncoderConfiguration->ProfileToken, &i) == OK) { /* find profile */
        profile = &gOnvifConf.profile[i];
        if(profile->readOnly == 0) {
            /* find the video encoder configuration entry */
            for(i = 0 ; i < MAX_VE_LIST ; i ++) {
                if( (gOnvifConf.veConf[i].valid == 1) &&
                    (strcmp (trt__AddVideoEncoderConfiguration->ConfigurationToken, gOnvifConf.veConf[i].token) == 0)) {
                    /* find video encoder conf entry associated with this profile matches this request */
                    if((profile->veIdx >= 0) && (profile->veIdx < MAX_VE_LIST)) {
                        OnvifUsedCountMinus(&gOnvifConf.veConf[profile->veIdx].UseCount);
                    }
                    profile->veIdx = i;
                    gOnvifConf.veConf[profile->veIdx].UseCount ++;
                    /* update the video source configuration in the encoder configuration
                     * if it does not match video source setting in this profile */
		    if(profile->vsIdx >= 0) {
			if(gOnvifConf.veConf[i].videoSrcInProfile > 0) {
			    if(gOnvifConf.veConf[i].videoSrcInProfile != (profile->vsIdx+1)) {
				/* change the video source index in the encoder configuration */
				OnvifUsedCountMinus(&gOnvifConf.vsConf[gOnvifConf.veConf[i].videoSrcInProfile-1].UseCount);
				gOnvifConf.veConf[i].videoSrcInProfile = profile->vsIdx + 1;
			    }
			} else { /* this encoder configuation has not been associated with media profiles */
			    gOnvifConf.veConf[i].videoSrcInProfile = profile->vsIdx + 1;
			}
		    }
                    config_change = true_;
                    return SOAP_OK;
                }
	    }
            /* not found the video encoder configurations */
            return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", "Configuration token does not exist",
                                                "The VideoEncoderConfiguration indicated by the ConfigurationToken does not exist.");
	}
        /* this profile is read only, could not be changed for new encoder configurations */
        return soap_sender_fault_subcode_v2 (soap, "ter:Action", "ter:ConfigurationConflict ", "media profile conflicts",
               "Other configurations of the media profile conflicts with the one to add and adding it would cause a conflicting media profile.");
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
                                         "The requested profile token ProfileToken does not exist.");
}

int __trt__AddVideoSourceConfiguration (struct soap *soap,
					struct _trt__AddVideoSourceConfiguration *trt__AddVideoSourceConfiguration,
					struct _trt__AddVideoSourceConfigurationResponse *trt__AddVideoSourceConfigurationResponse)
{
    int idx, i;
    Acti_MediaProfile *profile = NULL;

    if ((trt__AddVideoSourceConfiguration->ProfileToken == NULL) ||
	(strlen (trt__AddVideoSourceConfiguration->ProfileToken) == 0)) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
			"The requested profile token ProfileToken does not exist.");
    }
    if (FindMediaProfile (soap, trt__AddVideoSourceConfiguration->ProfileToken, &idx) == OK) {
	for (i = 0; i < gOnvifConf.VsCnt; i++) {
	    if (trt__AddVideoSourceConfiguration->ConfigurationToken == NULL) return SOAP_REQUIRED;
            if (strcmp (trt__AddVideoSourceConfiguration->ConfigurationToken, gOnvifConf.vsConf[i].token) == 0) {
		profile = &gOnvifConf.profile[idx];
		if((profile->vsIdx >= 0) && (profile->vsIdx < MAX_VS_LIST)) {
		    OnvifUsedCountMinus(&gOnvifConf.vsConf[profile->vsIdx].UseCount);
                }
		profile->vsIdx = i;
		gOnvifConf.vsConf[profile->vsIdx].UseCount++;
		tmpVsConf[i].UseCount = gOnvifConf.vsConf[i].UseCount;
		return SOAP_OK;
	    }
	}
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", "Configuration token does not exist",
					 "The VideoSourceConfiguration indicated by the ConfigurationToken does not exist.");
}


int __trt__AddAudioEncoderConfiguration (struct soap *soap,
					 struct _trt__AddAudioEncoderConfiguration *trt__AddAudioEncoderConfiguration,
					 struct _trt__AddAudioEncoderConfigurationResponse *trt__AddAudioEncoderConfigurationResponse)
{
	int idx;
	int i; 
	int count = 0; 
	/*
 	   Onvif Core Spec v2.0:
	   11.2.7 Add audio encoder configuration to a profile
		This operation adds an AudioEncoderConfiguration to an existing media profile. 
		If a configuration exists in the media profile, it will be replaced. 
		The change shall be persistent.
 	*/

	if (trt__AddAudioEncoderConfiguration->ProfileToken == NULL ||
		(strlen (trt__AddAudioEncoderConfiguration->ProfileToken) == 0))
			goto ERROR_PROFILE;
	if (FindMediaProfile (soap, trt__AddAudioEncoderConfiguration->ProfileToken, &idx) != OK) 
		goto ERROR_PROFILE;

	//w: if(strcmp(trt__AddAudioEncoderConfiguration->ConfigurationToken, "0") != 0 ) return SOAP_ERR;
	/* 
  	   Only one set of Audio Encoder configuration.
	   so always refers to audio encoder configuration 0.
	*/
	if (trt__AddAudioEncoderConfiguration->ConfigurationToken == NULL) 
		return SOAP_REQUIRED;
	if(strcmp(trt__AddAudioEncoderConfiguration->ConfigurationToken, gOnvifConf.aeConf.token) != 0) //w: return SOAP_ERR;
		goto ERROR_AUDIOTOKEN;
	gOnvifConf.AEToken[idx] = true_;
/// Top of Winters ///
	for (i = 0; i<MAX_PROFILE_LIST; i++)
	{
		if (gOnvifConf.AEToken[i] == true_) 
			count++;
	}
	gOnvifConf.aeConf.UseCount = count; 
/// Bottom of Winters ///
	//gOnvifConf.profile[idx].aeIdx = 0; //w
	return SOAP_OK;
ERROR_PROFILE:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
		"The requested profile token ProfileToken does not exist.");
ERROR_AUDIOTOKEN:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
		"The AudioEncoderConfiguration indicated by the ConfigurationToken does not exist");
}


int __trt__AddAudioSourceConfiguration (struct soap *soap,
					struct _trt__AddAudioSourceConfiguration *trt__AddAudioSourceConfiguration,
					struct _trt__AddAudioSourceConfigurationResponse *trt__AddAudioSourceConfigurationResponse)
{
	int idx;
	int i; 
	int count = 0; 

	if (trt__AddAudioSourceConfiguration->ProfileToken == NULL ||
		(strlen (trt__AddAudioSourceConfiguration->ProfileToken) == 0))
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
								 "The requested profile token ProfileToken does not exist.");

	if (FindMediaProfile (soap, trt__AddAudioSourceConfiguration->ProfileToken, &idx) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
									 "The requested profile token ProfileToken does not exist.");

	if(trt__AddAudioSourceConfiguration->ConfigurationToken == NULL)
		return SOAP_REQUIRED;
	if(strcmp(trt__AddAudioSourceConfiguration->ConfigurationToken, "0") != 0 )
	{
		return SOAP_ERR;
	}

	gOnvifConf.ASToken[idx] = true_;
/// Top of Winters ///
	for (i = 0; i<MAX_PROFILE_LIST; i++)
	{
		if (gOnvifConf.ASToken[i] == true_) 
			count++;
	}
	gOnvifConf.asConf.UseCount = count; 
/// Bottom of Winters ///
	return SOAP_OK;
}

int __trt__AddMetadataConfiguration(struct soap *soap, struct _trt__AddMetadataConfiguration *trt__AddMetadataConfiguration, struct _trt__AddMetadataConfigurationResponse *trt__AddMetadataConfigurationResponse)
{	
#ifdef HAVE_METADATA
	int idx, i;

	if (trt__AddMetadataConfiguration->ProfileToken == NULL ||
		(strlen (trt__AddMetadataConfiguration->ProfileToken) == 0))
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
								 "The requested profile token ProfileToken does not exist.");

	if (FindMediaProfile (soap, trt__AddMetadataConfiguration->ProfileToken, &idx) == OK) 
	{
		if (strcmp (trt__AddMetadataConfiguration->ConfigurationToken, gOnvifConf.meConf.token) == 0) 
			return SOAP_OK;
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", "Configuration token does not exist",
						 "The MetadataConfiguration indicated by the ConfigurationToken does not exist.");
#endif 
	return SOAP_OK;
}

int __trt__AddAudioOutputConfiguration(struct soap *soap, struct _trt__AddAudioOutputConfiguration *trt__AddAudioOutputConfiguration, struct _trt__AddAudioOutputConfigurationResponse *trt__AddAudioOutputConfigurationResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}

int __trt__AddPTZConfiguration(struct soap *soap, struct _trt__AddPTZConfiguration *trt__AddPTZConfiguration, struct _trt__AddPTZConfigurationResponse *trt__AddPTZConfigurationResponse)
{
	int id = 0;	

	if (trt__AddPTZConfiguration->ProfileToken == NULL)
		return soap_sender_fault (soap, "", NULL);
	if (FindMediaProfile (soap, trt__AddPTZConfiguration->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
			"The requested profile token ProfileToken does not exist.");

	gOnvifConf.PTZ_AddToken[id] = true_;
	
	return SOAP_OK;
}

int __trt__RemoveVideoEncoderConfiguration (struct soap *soap,
					struct _trt__RemoveVideoEncoderConfiguration *trt__RemoveVideoEncoderConfiguration,
					struct _trt__RemoveVideoEncoderConfigurationResponse *trt__RemoveVideoEncoderConfigurationResponse)
{
    int idx;
    Acti_MediaProfile *profile = NULL;

    if ((trt__RemoveVideoEncoderConfiguration->ProfileToken == NULL) ||
	(strlen (trt__RemoveVideoEncoderConfiguration->ProfileToken) == 0)) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
			"The requested profile token ProfileToken does not exist.");
    }
    if (FindMediaProfile (soap, trt__RemoveVideoEncoderConfiguration->ProfileToken, &idx) == OK) {
	profile = &gOnvifConf.profile[idx];
	if((profile->veIdx >= 0) && (profile->veIdx < MAX_VE_LIST))	{
            OnvifUsedCountMinus(&gOnvifConf.veConf[profile->veIdx].UseCount);
        }
	profile->veIdx = -1;
	config_change = true_;
	return SOAP_OK;
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
					 "There exists no video encoder configuration in the media profile.");
}


int __trt__RemoveVideoSourceConfiguration (struct soap *soap,
				   struct _trt__RemoveVideoSourceConfiguration *trt__RemoveVideoSourceConfiguration,
				   struct _trt__RemoveVideoSourceConfigurationResponse *trt__RemoveVideoSourceConfigurationResponse)
{
    int idx;
    Acti_MediaProfile *profile = NULL;

    if ((trt__RemoveVideoSourceConfiguration->ProfileToken == NULL) ||
	(strlen (trt__RemoveVideoSourceConfiguration->ProfileToken) == 0)) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
			"The requested profile token ProfileToken does not exist.");
    }
    if (FindMediaProfile (soap, trt__RemoveVideoSourceConfiguration->ProfileToken, &idx) == OK) {
        profile = &gOnvifConf.profile[idx];
        if((profile->vsIdx >= 0) && (profile->vsIdx < MAX_VS_LIST)) {
            OnvifUsedCountMinus(&gOnvifConf.vsConf[profile->vsIdx].UseCount);
	}
	profile->vsIdx = -1;
	gOnvifConf.ASToken[idx] = false_;
	config_change = true_;
	return SOAP_OK;
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
                                         "There exists no video source configuration in the media profile.");
}


int __trt__RemoveAudioEncoderConfiguration (struct soap *soap,
					struct _trt__RemoveAudioEncoderConfiguration *trt__RemoveAudioEncoderConfiguration,
					struct _trt__RemoveAudioEncoderConfigurationResponse *trt__RemoveAudioEncoderConfigurationResponse)
{
	int idx;
	int i; 
	int count = 0; 

	if (trt__RemoveAudioEncoderConfiguration->ProfileToken == NULL ||
		(strlen (trt__RemoveAudioEncoderConfiguration->ProfileToken) == 0))
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", 
			"Profile token does not exist", "The requested profile token ProfileToken does not exist.");

	if (FindMediaProfile (soap, trt__RemoveAudioEncoderConfiguration->ProfileToken, &idx) != OK) 
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
			"The requested profile token ProfileToken does not exist.");

	gOnvifConf.AEToken[idx] = false_;
/// Top of Winters ///
	for (i = 0; i<MAX_PROFILE_LIST; i++)
	{
		if (gOnvifConf.AEToken[i] == true_) 
			count++;
	}
	gOnvifConf.aeConf.UseCount = count; 
/// Bottom of Winters ///
	
	return SOAP_OK;
}


int __trt__RemoveAudioSourceConfiguration (struct soap *soap,
				   struct _trt__RemoveAudioSourceConfiguration *trt__RemoveAudioSourceConfiguration,
				   struct _trt__RemoveAudioSourceConfigurationResponse *trt__RemoveAudioSourceConfigurationResponse)
{
	int idx;
	int i; 
	int count = 0; 

	if (trt__RemoveAudioSourceConfiguration->ProfileToken == NULL ||
		(strlen (trt__RemoveAudioSourceConfiguration->ProfileToken) == 0))
		return soap_sender_fault_subcode_v2 (soap, 
			"ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
			"The requested profile token ProfileToken does not exist.");

	if (FindMediaProfile (soap, trt__RemoveAudioSourceConfiguration->ProfileToken, &idx) != OK) 
		return soap_sender_fault_subcode_v2 (soap, 
			"ter:InvalidArgVal", "ter:NoProfile", NULL,
			"The requested profile token ProfileToken does not exist.");

	gOnvifConf.ASToken[idx] = false_;
/// Top of Winters ///
	for (i = 0; i<MAX_PROFILE_LIST; i++)
	{
		if (gOnvifConf.ASToken[i] == true_) 
			count++;
	}
	gOnvifConf.asConf.UseCount = count; 
/// Bottom of Winters ///
	
	return SOAP_OK;
}

int __trt__RemovePTZConfiguration(struct soap *soap, struct _trt__RemovePTZConfiguration *trt__RemovePTZConfiguration, struct _trt__RemovePTZConfigurationResponse *trt__RemovePTZConfigurationResponse)
{	
	int id = 0;	
	int i; 
	int count = 0; 

	if (trt__RemovePTZConfiguration->ProfileToken == NULL)
		return soap_sender_fault (soap, "", NULL);
	if (FindMediaProfile (soap, trt__RemovePTZConfiguration->ProfileToken, &id) != OK) 
		return soap_sender_fault_subcode_v2 (soap, 
			"ter:InvalidArgVal", "ter:NoProfile", NULL,
			"The requested profile token ProfileToken does not exist.");
	//if(gOnvifConf.PTZ_AddToken[id] != true_) return SOAP_ERR;

	gOnvifConf.PTZ_AddToken[id] = false_;
/// Top of Winters ///
	for (i = 0; i < MAX_PROFILE_LIST; i++)
	{
		if (gOnvifConf.PTZ_AddToken[i] == true_) 
			count++;
	}
	gOnvifConf.PTZConfig.UseCount = count; 
/// Bottom of Winters ///
	
	return SOAP_OK;
}

int __trt__RemoveMetadataConfiguration(struct soap *soap, struct _trt__RemoveMetadataConfiguration *trt__RemoveMetadataConfiguration, struct _trt__RemoveMetadataConfigurationResponse *trt__RemoveMetadataConfigurationResponse)
{	
	/* 
	   Onvif Core Spec V2.0: 
		4.15.1 Synchronization Points
		Because receivers use RTSP addresses to specify the source of the stream, they do not
		necessarily have access to the web services interface of the transmitter. This means that they
		cannot use the SetSynchronizationPoint command described in Section 11.18.1.
		Instead, receivers should use the PLI message described in [RFC 4585] to request a
		synchronization point.
	   SSPO Policy: We don't support this function currently.
 	*/
#ifdef HAVE_METADATA
	int idx;

	if (trt__RemoveMetadataConfiguration->ProfileToken == NULL ||
		(strlen (trt__RemoveMetadataConfiguration->ProfileToken) == 0))
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
								 "The requested profile token ProfileToken does not exist.");
	if (FindMediaProfile (soap, trt__RemoveMetadataConfiguration->ProfileToken, &idx) == OK) {
        gOnvifConf.meConf.UseCount --;
			if(gOnvifConf.meConf.UseCount < 0) 
            {
				gOnvifConf.meConf.UseCount = 0;
                gOnvifConf.meConf.valid = 0;
            }
		}
		return SOAP_OK;
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
							 "There exists no Metadata configuration in the media profile.");
#endif 
	return SOAP_OK;
}

int __trt__RemoveAudioOutputConfiguration(struct soap *soap, struct _trt__RemoveAudioOutputConfiguration *trt__RemoveAudioOutputConfiguration, struct _trt__RemoveAudioOutputConfigurationResponse *trt__RemoveAudioOutputConfigurationResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}

int __trt__DeleteProfile (struct soap *soap, struct _trt__DeleteProfile *trt__DeleteProfile,
						  struct _trt__DeleteProfileResponse *trt__DeleteProfileResponse)
{
    int i;
    Acti_MediaProfile *profile = NULL;

    if (trt__DeleteProfile->ProfileToken == NULL) return SOAP_REQUIRED;
    if (FindMediaProfile (soap, trt__DeleteProfile->ProfileToken, &i) == OK) {
	profile = &gOnvifConf.profile[i];
	if (profile->readOnly) {
	    return soap_sender_fault_subcode_v2 (soap, "ter:Action", "ter:DeletionOfFixedProfile", 
                                                 "Fixed profile can not be deleted", "The fixed Profile cannot be deleted.");
	}
	fprintf(stdout, "%s: remove profile[%d]. %s,%s: %d,%d\n", __func__, i,
		profile->token, profile->Name, profile->vsIdx, profile->veIdx);
		
        snprintf(profile->Name, MAX_PROFILE_STR, "PNone%d", i);
	snprintf(profile->token, MAX_TOKEN_STRLEN, "t%s", profile->Name);
	if((profile->vsIdx >= 0) && (profile->vsIdx < MAX_VS_LIST)) {
	    fprintf(stdout, "vsConf[%d].UseCount=%d\n", profile->vsIdx, gOnvifConf.vsConf[profile->vsIdx].UseCount);
            OnvifUsedCountMinus(&gOnvifConf.vsConf[profile->vsIdx].UseCount);
	    profile->vsIdx = -1;
	}
	if((profile->veIdx >= 0) && (profile->veIdx < MAX_VE_LIST)) {
	    if(gOnvifConf.veConf[profile->veIdx].videoSrcInProfile > 0) {
		/* need to restore the video source index */
		fprintf(stdout, "veConf[%d].videoSrcInProfile=%d\n",
			profile->veIdx, gOnvifConf.veConf[profile->veIdx].videoSrcInProfile);
                gOnvifConf.veConf[profile->veIdx].videoSrcInProfile = -1;
            }
	    fprintf(stdout, "veConf[%d].UseCount=%d\n", profile->veIdx, gOnvifConf.veConf[profile->veIdx].UseCount);
            OnvifUsedCountMinus(&gOnvifConf.veConf[profile->veIdx].UseCount);
	    profile->veIdx = -1;
	}
#ifdef HAVE_METADATA
        gOnvifConf.meConf.UseCount--;
	if(gOnvifConf.meConf.UseCount < 0)  {
            gOnvifConf.meConf.UseCount = 0;
            gOnvifConf.meConf.valid = 0;
	}
#endif
	gOnvifConf.PTZ_AddToken[i] = false_;
	gOnvifConf.ASToken[i] = false_;
	gOnvifConf.AEToken[i] = false_;
	profile->valid = 0;
	gOnvifConf.ProfileCnt--;
	config_change = true_;
	return SOAP_OK;
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", "Profile token does not exist",
                                         "The requested profile token ProfileToken does not exist.");
}

int __trt__GetMetadataConfigurations(struct soap *soap, struct _trt__GetMetadataConfigurations *trt__GetMetadataConfigurations,
                                     struct _trt__GetMetadataConfigurationsResponse *trt__GetMetadataConfigurationsResponse)
{
	/* 
	   Onvif Core Spec V2.0: 
		4.15.1 Synchronization Points
		Because receivers use RTSP addresses to specify the source of the stream, they do not
		necessarily have access to the web services interface of the transmitter. This means that they
		cannot use the SetSynchronizationPoint command described in Section 11.18.1.
		Instead, receivers should use the PLI message described in [RFC 4585] to request a
		synchronization point.
	   SSPO Policy: We don't support this function currently.
 	*/
#ifdef HAVE_METADATA
	int i = 0;
	static char *IPv4Address = NULL; //w
	struct tt__MetadataConfiguration *Configurations = NULL;
	tUrlDB url;
	char ReplyMsg[512];
	char value[16];
	int MulticastPort = 0;
	int TTL = 0;
	IPv4Address = (char *) soap_malloc(soap, 16);
	memset (IPv4Address, 0, 16);
	strcpy (IPv4Address, "0.0.0.0");

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "V2_PORT_RTP_MULTI_VIDEO&VIDEO_MULTICAST_TTL&V2_MULTICAST_IP");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK )
	{
		OnvifReplyMsgParser("V2_PORT_RTP_MULTI_VIDEO", ReplyMsg, value);
		MulticastPort = atoi(value);
		OnvifReplyMsgParser("VIDEO_MULTICAST_TTL", ReplyMsg, value);
		TTL = atoi(value);
	}

	trt__GetMetadataConfigurationsResponse->__sizeConfigurations = 1;
	trt__GetMetadataConfigurationsResponse->Configurations =
		(struct tt__MetadataConfiguration *) soap_malloc (soap, sizeof(struct tt__MetadataConfiguration));

    soap_default_tt__MetadataConfiguration (soap, &trt__GetMetadataConfigurationsResponse->Configurations);
    Configurations = &trt__GetMetadataConfigurationsResponse->Configurations;
    Configurations->Name = gOnvifConf.meConf.Name;
    Configurations->UseCount = gOnvifConf.meConf.UseCount;
    Configurations->token = gOnvifConf.meConf.token;
    Configurations->Multicast = 
        (struct tt__MulticastConfiguration *) soap_malloc (soap, sizeof (struct tt__MulticastConfiguration));
    soap_default_tt__MulticastConfiguration (soap, Configurations->Multicast);
    Configurations->Multicast->Address = (struct tt__IPAddress *) soap_malloc (soap, sizeof (struct tt__IPAddress));
    soap_default_tt__IPAddress (soap, Configurations->Multicast->Address);
    Configurations->Multicast->Address->Type = IPv4_;
    Configurations->Multicast->Address->IPv4Address = &IPv4Address; //w
    Configurations->Multicast->Port = MulticastPort; 
    Configurations->Multicast->TTL = TTL;
    Configurations->Multicast->AutoStart = gOnvifConf.meConf.AutoStart;
    Configurations->SessionTimeout = gOnvifConf.meConf.SessionTimeout;
#endif
	return SOAP_OK;
}


int __trt__GetVideoSourceConfigurations (struct soap *soap,
				 struct _trt__GetVideoSourceConfigurations *trt__GetVideoSourceConfigurations,
				 struct _trt__GetVideoSourceConfigurationsResponse *trt__GetVideoSourceConfigurationsResponse)
{
	int i;

	trt__GetVideoSourceConfigurationsResponse->__sizeConfigurations = gOnvifConf.VsCnt;
	trt__GetVideoSourceConfigurationsResponse->Configurations =
		(struct tt__VideoSourceConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoSourceConfiguration) * gOnvifConf.VsCnt);
	for (i = 0; i < gOnvifConf.VsCnt; i++) {
		soap_default_tt__VideoSourceConfiguration (soap, &trt__GetVideoSourceConfigurationsResponse->Configurations[i]);
		PrepareVSConfig (soap, &gOnvifConf.vsConf[i], &trt__GetVideoSourceConfigurationsResponse->Configurations[i]);
	}
	return SOAP_OK;
}


int __trt__GetVideoEncoderConfigurations (struct soap *soap,
					  struct _trt__GetVideoEncoderConfigurations *trt__GetVideoEncoderConfigurations,
					  struct _trt__GetVideoEncoderConfigurationsResponse *trt__GetVideoEncoderConfigurationsResponse)
{
	int i = 0;
    int k = 0;
    
	trt__GetVideoEncoderConfigurationsResponse->__sizeConfigurations = gOnvifConf.VeCnt;
	trt__GetVideoEncoderConfigurationsResponse->Configurations =
		(struct tt__VideoEncoderConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoEncoderConfiguration) * gOnvifConf.VeCnt);
	for (i = 0; i < MAX_VE_LIST; i++) {
	    if(gOnvifConf.veConf[i].valid == 1) {
		soap_default_tt__VideoEncoderConfiguration (soap, &trt__GetVideoEncoderConfigurationsResponse->Configurations[k]);
		PrepareVEConfig (soap, i, &gOnvifConf.veConf[i], &trt__GetVideoEncoderConfigurationsResponse->Configurations[k]);
		k ++;
		if(k >= gOnvifConf.VeCnt) break;
	    }
	}

	return SOAP_OK;
}


int __trt__GetAudioSourceConfigurations (struct soap *soap,
				 struct _trt__GetAudioSourceConfigurations *trt__GetAudioSourceConfigurations,
				 struct _trt__GetAudioSourceConfigurationsResponse *trt__GetAudioSourceConfigurationsResponse)
{
    int i = 0;
    Acti_AudioSourceConfig *AsConfPtr = NULL;

	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
    if (ASConfigState == true_) AsConfPtr = &gOnvifConf.asConf; 
    else			AsConfPtr = &tmpAsConf; 
    trt__GetAudioSourceConfigurationsResponse->__sizeConfigurations = gOnvifConf.sizeAsConf;
    trt__GetAudioSourceConfigurationsResponse->Configurations = 
	(struct tt__AudioSourceConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioSourceConfiguration));
    soap_default_tt__AudioSourceConfiguration(soap, trt__GetAudioSourceConfigurationsResponse->Configurations);
    trt__GetAudioSourceConfigurationsResponse->Configurations->Name = soap_malloc(soap, MAX_PROFILE_STR);
    gOnvifConf.asConf.UseCount = 0;
    for(i = 0 ; i < MAX_PROFILE_LIST ; i++) {
	if(gOnvifConf.ASToken[i] == true_) gOnvifConf.asConf.UseCount++;
    }
    //Only one audio source	
    trt__GetAudioSourceConfigurationsResponse->Configurations->token = soap_malloc (soap, MAX_PROFILE_STR); 
    trt__GetAudioSourceConfigurationsResponse->Configurations->Name = soap_malloc (soap, MAX_TOKEN_STRLEN); 
    trt__GetAudioSourceConfigurationsResponse->Configurations->SourceToken = soap_malloc (soap, MAX_TOKEN_STRLEN); 
    strcpy (trt__GetAudioSourceConfigurationsResponse->Configurations->token, AsConfPtr->token);
    strcpy (trt__GetAudioSourceConfigurationsResponse->Configurations->Name, AsConfPtr->Name);
    strcpy (trt__GetAudioSourceConfigurationsResponse->Configurations->SourceToken, AsConfPtr->SourceToken);
    trt__GetAudioSourceConfigurationsResponse->Configurations->UseCount = gOnvifConf.asConf.UseCount;
    return SOAP_OK;
}


int __trt__GetAudioEncoderConfigurations (struct soap *soap,
					  struct _trt__GetAudioEncoderConfigurations *trt__GetAudioEncoderConfigurations,
					  struct _trt__GetAudioEncoderConfigurationsResponse *trt__GetAudioEncoderConfigurationsResponse)
{
	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
	//w: trt__GetAudioEncoderConfigurationsResponse->__sizeConfigurations = 1;
	trt__GetAudioEncoderConfigurationsResponse->__sizeConfigurations = gOnvifConf.sizeAeConf; 
	trt__GetAudioEncoderConfigurationsResponse->Configurations = 
		(struct tt__AudioEncoderConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioEncoderConfiguration) );	
	soap_default_tt__AudioEncoderConfiguration(soap, trt__GetAudioEncoderConfigurationsResponse->Configurations);
	PrepareAEConfig (soap, trt__GetAudioEncoderConfigurationsResponse->Configurations);
	
	return SOAP_OK;
}

int __trt__GetMetadataConfiguration(struct soap *soap,
                    struct _trt__GetMetadataConfiguration *trt__GetMetadataConfiguration,
                    struct _trt__GetMetadataConfigurationResponse *trt__GetMetadataConfigurationResponse)
{	
	/* 
	   Onvif Core Spec V2.0: 
		4.15.1 Synchronization Points
		Because receivers use RTSP addresses to specify the source of the stream, they do not
		necessarily have access to the web services interface of the transmitter. This means that they
		cannot use the SetSynchronizationPoint command described in Section 11.18.1.
		Instead, receivers should use the PLI message described in [RFC 4585] to request a
		synchronization point.
	   SSPO Policy: We don't support this function currently.
 	*/
#ifdef HAVE_METADATA
	int i = 0;
	static char *IPv4Address = NULL;
	struct tt__MetadataConfiguration *Configuration = NULL;
	tUrlDB url;
	char ReplyMsg[512];
	char value[16];
	int MulticastPort = 0;
	int TTL = 0;
	IPv4Address = (char *) soap_malloc (soap, 16); 
	memset (IPv4Address, 0, 16);

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "V2_PORT_RTP_MULTI_VIDEO&VIDEO_MULTICAST_TTL&V2_MULTICAST_IP");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK )
	{
		OnvifReplyMsgParser("V2_PORT_RTP_MULTI_VIDEO", ReplyMsg, value);
		MulticastPort = atoi(value);
		OnvifReplyMsgParser("VIDEO_MULTICAST_TTL", ReplyMsg, value);
		//w: MulticastPort = atoi(value);
		TTL = atoi(value); //w
		OnvifReplyMsgParser("V2_MULTICAST_IP", ReplyMsg, value);
		strncpy (IPv4Address, value, strlen (value));
	}
	
	trt__GetMetadataConfigurationResponse->Configuration =
		(struct tt__MetadataConfiguration *) soap_malloc (soap, sizeof (struct tt__MetadataConfiguration) );
	soap_default_tt__MetadataConfiguration (soap, trt__GetMetadataConfigurationResponse->Configuration);

	Configuration = trt__GetMetadataConfigurationResponse->Configuration;
	Configuration->token =  (char *) soap_malloc (soap, MAX_TOKEN_STRLEN);
    snprintf(Configuration->token, MAX_TOKEN_STRLEN, "%s", trt__GetMetadataConfiguration->ConfigurationToken);
    L2("token %s %s\n", Configuration->token, gOnvifConf.meConf.token);
    if(strcmp(Configuration->token, gOnvifConf.meConf.token)==0)
    {
        Configuration->UseCount = gOnvifConf.meConf.UseCount;
        Configuration->Name =  (char *) soap_malloc (soap, MAX_PROFILE_STR);
        snprintf(Configuration->Name, MAX_PROFILE_STR, "%s", gOnvifConf.meConf.Name);
        Configuration->Multicast = 
            (struct tt__MulticastConfiguration *) soap_malloc (soap, sizeof (struct tt__MulticastConfiguration));
        soap_default_tt__MulticastConfiguration (soap, Configuration->Multicast);
        Configuration->Multicast->Address = (struct tt__IPAddress *) soap_malloc (soap, sizeof (struct tt__IPAddress));
        soap_default_tt__IPAddress (soap, Configuration->Multicast->Address);
        Configuration->Multicast->Address->Type = IPv4_;
        Configuration->Multicast->Address->IPv4Address = &IPv4Address;
        Configuration->Multicast->Port = MulticastPort; 
        Configuration->Multicast->TTL = TTL;
        Configuration->Multicast->AutoStart = gOnvifConf.meConf.AutoStart;
        Configuration->SessionTimeout = gOnvifConf.meConf.SessionTimeout;
    } else return SOAP_ERR;
#endif 
	return SOAP_OK;
}

int __trt__GetAudioOutputConfigurations(struct soap *soap, struct _trt__GetAudioOutputConfigurations *trt__GetAudioOutputConfigurations, struct _trt__GetAudioOutputConfigurationsResponse *trt__GetAudioOutputConfigurationsResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}

int __trt__GetVideoSourceConfiguration (struct soap *soap,
				struct _trt__GetVideoSourceConfiguration *trt__GetVideoSourceConfiguration,
				struct _trt__GetVideoSourceConfigurationResponse *trt__GetVideoSourceConfigurationResponse)
{
	int i;
	if (trt__GetVideoSourceConfiguration->ConfigurationToken == NULL)
		return SOAP_REQUIRED;
	for (i = 0; i < gOnvifConf.VsCnt; i++) {
		if (strcmp (gOnvifConf.vsConf[i].token, trt__GetVideoSourceConfiguration->ConfigurationToken) == 0) {
			trt__GetVideoSourceConfigurationResponse->Configuration =
				(struct tt__VideoSourceConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoSourceConfiguration));
			soap_default_tt__VideoSourceConfiguration (soap, trt__GetVideoSourceConfigurationResponse->Configuration);
			PrepareVSConfig (soap, &gOnvifConf.vsConf[i], trt__GetVideoSourceConfigurationResponse->Configuration);
			return SOAP_OK;
		}
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", "No such configuration",
										 "The requested configuration indicated with ConfigurationToken does not exist.");
}


int __trt__GetVideoEncoderConfiguration (struct soap *soap,
					 struct _trt__GetVideoEncoderConfiguration *trt__GetVideoEncoderConfiguration,
					 struct _trt__GetVideoEncoderConfigurationResponse *trt__GetVideoEncoderConfigurationResponse)
{
	int i;

	if (trt__GetVideoEncoderConfiguration->ConfigurationToken == NULL) return SOAP_REQUIRED;
	
    for (i = 0; i < MAX_VE_LIST; i++) {
		if ((gOnvifConf.veConf[i].valid == 1) &&
            (strcmp (gOnvifConf.veConf[i].token, trt__GetVideoEncoderConfiguration->ConfigurationToken) == 0)) {
			trt__GetVideoEncoderConfigurationResponse->Configuration =
				(struct tt__VideoEncoderConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoEncoderConfiguration));
			soap_default_tt__VideoEncoderConfiguration (soap, trt__GetVideoEncoderConfigurationResponse->Configuration);
			PrepareVEConfig (soap, i, &gOnvifConf.veConf[i], trt__GetVideoEncoderConfigurationResponse->Configuration);
			return SOAP_OK;
		}
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", "No such configuration",
                                         "The requested configuration indicated with ConfigurationToken does not exist.");
}


int __trt__GetAudioSourceConfiguration (struct soap *soap,
					struct _trt__GetAudioSourceConfiguration *trt__GetAudioSourceConfiguration,
					struct _trt__GetAudioSourceConfigurationResponse *trt__GetAudioSourceConfigurationResponse)
{
	int i = 0;
	Acti_AudioSourceConfig *AsConfPtr = NULL;

	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
	if (trt__GetAudioSourceConfiguration->ConfigurationToken == NULL) return SOAP_REQUIRED;

	if (ASConfigState == true_) AsConfPtr = &gOnvifConf.asConf; 
	else                        AsConfPtr = &tmpAsConf; 
	
	if (strcmp (trt__GetAudioSourceConfiguration->ConfigurationToken, AsConfPtr->token) != 0) 
		goto ERROR_AUDIOSOURCE;	

	trt__GetAudioSourceConfigurationResponse->Configuration = 
		(struct tt__AudioSourceConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioSourceConfiguration));
	soap_default_tt__AudioSourceConfiguration(soap, trt__GetAudioSourceConfigurationResponse->Configuration);
	trt__GetAudioSourceConfigurationResponse->Configuration->Name = soap_malloc (soap, MAX_PROFILE_STR);
	strcpy (trt__GetAudioSourceConfigurationResponse->Configuration->Name, AsConfPtr->Name);
	gOnvifConf.asConf.UseCount = 0;
	for(i=0; i<MAX_PROFILE_LIST; i++)
	{
		if(gOnvifConf.ASToken[i] == true_) 
			gOnvifConf.asConf.UseCount++;
	}
	
	trt__GetAudioSourceConfigurationResponse->Configuration->UseCount = gOnvifConf.asConf.UseCount;
	trt__GetAudioSourceConfigurationResponse->Configuration->token = soap_malloc (soap, MAX_TOKEN_STRLEN); 
	strcpy (trt__GetAudioSourceConfigurationResponse->Configuration->token, AsConfPtr->token);
	trt__GetAudioSourceConfigurationResponse->Configuration->SourceToken = soap_malloc (soap, MAX_TOKEN_STRLEN); 
	strcpy (trt__GetAudioSourceConfigurationResponse->Configuration->SourceToken, AsConfPtr->SourceToken);
	return SOAP_OK;

ERROR_AUDIOSOURCE:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
					     "The requested configuration indicated with ConfigurationToken does not exist.");
}


int __trt__GetAudioEncoderConfiguration (struct soap *soap,
					 struct _trt__GetAudioEncoderConfiguration *trt__GetAudioEncoderConfiguration,
					 struct _trt__GetAudioEncoderConfigurationResponse *trt__GetAudioEncoderConfigurationResponse)
{
	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
	if(trt__GetAudioEncoderConfiguration->ConfigurationToken == NULL) return SOAP_ERR;

	if(strcmp(trt__GetAudioEncoderConfiguration->ConfigurationToken, "0") != 0) return SOAP_ERR;

	trt__GetAudioEncoderConfigurationResponse->Configuration = 
		(struct tt__AudioEncoderConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioEncoderConfiguration) );	
	
	soap_default_tt__AudioEncoderConfiguration(soap, trt__GetAudioEncoderConfigurationResponse->Configuration);
	PrepareAEConfig (soap, trt__GetAudioEncoderConfigurationResponse->Configuration);
	return SOAP_OK;
}


int __trt__GetAudioOutputConfiguration(struct soap *soap, struct _trt__GetAudioOutputConfiguration *trt__GetAudioOutputConfiguration, struct _trt__GetAudioOutputConfigurationResponse *trt__GetAudioOutputConfigurationResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}

int __trt__GetCompatibleVideoEncoderConfigurations (struct soap *soap,
			struct _trt__GetCompatibleVideoEncoderConfigurations *trt__GetCompatibleVideoEncoderConfigurations,
			struct _trt__GetCompatibleVideoEncoderConfigurationsResponse *trt__GetCompatibleVideoEncoderConfigurationsResponse)
{
	int i = 0;
    int k = 0;
	int VeCnt = gOnvifConf.VeCnt;
	int vsIdx = 1; /* video source 1 */
	int listVeConfByVsIdx = 1;

	if (trt__GetCompatibleVideoEncoderConfigurations->ProfileToken == NULL) return SOAP_REQUIRED;	
	if (FindMediaProfile (soap, trt__GetCompatibleVideoEncoderConfigurations->ProfileToken, &i) == OK) {
		vsIdx = gOnvifConf.profile[i].vsIdx + 1;
		if((vsIdx < 0) || (vsIdx > gOnvifConf.VsCnt)) {
			L1("error, vsIdx in profile[%d], %s is %d\n", i, gOnvifConf.profile[i].token, gOnvifConf.profile[i].vsIdx);
			vsIdx = 1; /* use video source 1 */
		}
		VeCnt = GetNumOfValidVeConfByVsIdx(gOnvifConf.veConf, vsIdx);
		L4("valid %d VeConf for VsIdx %d for profile %s (%d)\n", VeCnt, vsIdx, trt__GetCompatibleVideoEncoderConfigurations->ProfileToken, i); 
		if(VeCnt == 0) {
			VeCnt = gOnvifConf.VeCnt;
			listVeConfByVsIdx = 0;
			L1("error, no valid veConf found by vsIdx=%d, VeCnt=%d\n", vsIdx, gOnvifConf.VeCnt); 
		}
		trt__GetCompatibleVideoEncoderConfigurationsResponse->__sizeConfigurations = VeCnt;
		if(VeCnt > 0) {
        	trt__GetCompatibleVideoEncoderConfigurationsResponse->Configurations =
        	            (struct tt__VideoEncoderConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoEncoderConfiguration) * VeCnt);
        	for (i = 0; i < MAX_VE_LIST; i++) {
				if(gOnvifConf.veConf[i].valid == 1) {
            		soap_default_tt__VideoEncoderConfiguration (soap, &trt__GetCompatibleVideoEncoderConfigurationsResponse->Configurations[k]);
					if((listVeConfByVsIdx == 0) || (gOnvifConf.veConf[i].videoSrc == vsIdx)) {
            			PrepareVEConfig (soap, i, &gOnvifConf.veConf[i],
								 		&trt__GetCompatibleVideoEncoderConfigurationsResponse->Configurations[k]);
            			k ++;
            			if(k >= VeCnt) break;
					}
				}
			}
        }
        return SOAP_OK;
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
									 "The requested profile token ProfileToken does not exist.");
}


int __trt__GetCompatibleVideoSourceConfigurations (struct soap *soap,
			   struct _trt__GetCompatibleVideoSourceConfigurations *trt__GetCompatibleVideoSourceConfigurations,
			   struct _trt__GetCompatibleVideoSourceConfigurationsResponse *trt__GetCompatibleVideoSourceConfigurationsResponse)
{
	int i;

	if (trt__GetCompatibleVideoSourceConfigurations->ProfileToken == NULL) 
		return SOAP_REQUIRED;
	if (FindMediaProfile (soap, trt__GetCompatibleVideoSourceConfigurations->ProfileToken, &i) == OK) {
		goto FOUND;
	}

	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
										 "The requested profile token ProfileToken does not exist.");
  FOUND:
	trt__GetCompatibleVideoSourceConfigurationsResponse->__sizeConfigurations = gOnvifConf.VsCnt;
	trt__GetCompatibleVideoSourceConfigurationsResponse->Configurations =
		(struct tt__VideoSourceConfiguration *) soap_malloc (soap, sizeof (struct tt__VideoSourceConfiguration) * gOnvifConf.VsCnt);
	for (i = 0; i < gOnvifConf.VsCnt; i++) {
		soap_default_tt__VideoSourceConfiguration (soap, &trt__GetCompatibleVideoSourceConfigurationsResponse->Configurations[i]);
		PrepareVSConfig (soap, &gOnvifConf.vsConf[i], &trt__GetCompatibleVideoSourceConfigurationsResponse->Configurations[i]);
	}
	return SOAP_OK;
}


int __trt__GetCompatibleAudioEncoderConfigurations (struct soap *soap,
			struct _trt__GetCompatibleAudioEncoderConfigurations *trt__GetCompatibleAudioEncoderConfigurations,
			struct _trt__GetCompatibleAudioEncoderConfigurationsResponse *trt__GetCompatibleAudioEncoderConfigurationsResponse)
{
	int id = 0;

	if(trt__GetCompatibleAudioEncoderConfigurations->ProfileToken != NULL)
	{
		if (FindMediaProfile (soap, trt__GetCompatibleAudioEncoderConfigurations->ProfileToken, &id) != OK) 
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
								 "The requested profile token ProfileToken does not exist.");
	}

	trt__GetCompatibleAudioEncoderConfigurationsResponse->__sizeConfigurations = 1;
	trt__GetCompatibleAudioEncoderConfigurationsResponse->Configurations = 
		(struct tt__AudioEncoderConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioEncoderConfiguration) );	
	
	soap_default_tt__AudioEncoderConfiguration(soap, trt__GetCompatibleAudioEncoderConfigurationsResponse->Configurations);
	PrepareAEConfig (soap, trt__GetCompatibleAudioEncoderConfigurationsResponse->Configurations);
	return SOAP_OK;
}


int __trt__GetCompatibleAudioSourceConfigurations (struct soap *soap,
			   struct _trt__GetCompatibleAudioSourceConfigurations *trt__GetCompatibleAudioSourceConfigurations,
			   struct _trt__GetCompatibleAudioSourceConfigurationsResponse *trt__GetCompatibleAudioSourceConfigurationsResponse)
{
	int i = 0;
	int id = 0;

	if(trt__GetCompatibleAudioSourceConfigurations->ProfileToken != NULL)
	{
		if (FindMediaProfile (soap, trt__GetCompatibleAudioSourceConfigurations->ProfileToken, &id) != OK) 
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
				"The requested profile token ProfileToken does not exist.");
	}

	/*
 	   No API to add new Compatible Audio Source Configurations except by developer, 
	   so that always refers to gOnvifConf.AsConf .
	*/
	trt__GetCompatibleAudioSourceConfigurationsResponse->__sizeConfigurations = gOnvifConf.sizeAsConf; 
	trt__GetCompatibleAudioSourceConfigurationsResponse->Configurations = 
		(struct tt__AudioSourceConfiguration *) soap_malloc(soap, sizeof(struct tt__AudioSourceConfiguration));
	soap_default_tt__AudioSourceConfiguration(soap, trt__GetCompatibleAudioSourceConfigurationsResponse->Configurations);
	trt__GetCompatibleAudioSourceConfigurationsResponse->Configurations->Name = gOnvifConf.asConf.Name;
	gOnvifConf.asConf.UseCount = 0;
	for(i=0; i<MAX_PROFILE_LIST; i++)
	{
		if(gOnvifConf.ASToken[i] == true_) 
			gOnvifConf.asConf.UseCount++;
	}
	trt__GetCompatibleAudioSourceConfigurationsResponse->Configurations->UseCount = gOnvifConf.asConf.UseCount;
	trt__GetCompatibleAudioSourceConfigurationsResponse->Configurations->token = gOnvifConf.asConf.token;
	trt__GetCompatibleAudioSourceConfigurationsResponse->Configurations->SourceToken = gOnvifConf.asConf.SourceToken;
	return SOAP_OK;
}

int __trt__SetMetadataConfiguration(struct soap *soap, struct _trt__SetMetadataConfiguration *trt__SetMetadataConfiguration, struct _trt__SetMetadataConfigurationResponse *trt__SetMetadataConfigurationResponse)
{	
	/* 
	   Onvif Core Spec V2.0: 
		4.15.1 Synchronization Points
		Because receivers use RTSP addresses to specify the source of the stream, they do not
		necessarily have access to the web services interface of the transmitter. This means that they
		cannot use the SetSynchronizationPoint command described in Section 11.18.1.
		Instead, receivers should use the PLI message described in [RFC 4585] to request a
		synchronization point.
	   SSPO Policy: We don't support this function currently.
 	*/
#ifdef HAVE_METADATA
	struct tt__MetadataConfiguration *Configuration = NULL;
	int timeInterval = 0;

	Configuration = trt__SetMetadataConfiguration->Configuration;
	if(strcmp(Configuration->token, gOnvifConf.meConf.token)==0) {
        snprintf(gOnvifConf.meConf.Name, MAX_PROFILE_STR, "%s", Configuration->Name);
        gOnvifConf.meConf.IPType = IPv4_;
        snprintf(gOnvifConf.meConf.IPv4Address, 16, "%s", *Configuration->Multicast->Address->IPv4Address);
		gOnvifConf.meConf.AutoStart = Configuration->Multicast->AutoStart;
		if (strlen(Configuration->SessionTimeout) > (ISO8601_DURATION_STRLEN+1)) return SOAP_ERR;
		if (parserTimeInterval(Configuration->SessionTimeout, &timeInterval) == ERR) return SOAP_ERR;//TODO
		sprintf(gOnvifConf.meConf.SessionTimeout, "%s", Configuration->SessionTimeout);
		L2("SessionTimeout %s\n", Configuration->SessionTimeout);
        gOnvifConf.meConf.valid = 1;
	} else return SOAP_ERR;
#endif
	return SOAP_OK;
}

int __trt__GetCompatibleMetadataConfigurations(struct soap *soap, 
                    struct _trt__GetCompatibleMetadataConfigurations *trt__GetCompatibleMetadataConfigurations,
                    struct _trt__GetCompatibleMetadataConfigurationsResponse *trt__GetCompatibleMetadataConfigurationsResponse)
{	
	/* 
	   Onvif Core Spec V2.0: 
		4.15.1 Synchronization Points
		Because receivers use RTSP addresses to specify the source of the stream, they do not
		necessarily have access to the web services interface of the transmitter. This means that they
		cannot use the SetSynchronizationPoint command described in Section 11.18.1.
		Instead, receivers should use the PLI message described in [RFC 4585] to request a
		synchronization point.
	   SSPO Policy: We don't support this function currently.
 	*/
#ifdef HAVE_METADATA
	int i = 0;
	static char *IPv4Address = NULL;
	struct tt__MetadataConfiguration *Configurations = NULL;
	tUrlDB url;
	char ReplyMsg[512];
	char value[16];
	int MulticastPort = 0;
	int TTL = 0;
	IPv4Address = (char *) soap_malloc (soap, 16);
	memset (IPv4Address, 0, 16);

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "V2_PORT_RTP_MULTI_VIDEO&VIDEO_MULTICAST_TTL&V2_MULTICAST_IP");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK )
	{
		OnvifReplyMsgParser("V2_PORT_RTP_MULTI_VIDEO", ReplyMsg, value);
		MulticastPort = atoi(value);
		OnvifReplyMsgParser("VIDEO_MULTICAST_TTL", ReplyMsg, value);
		//w: MulticastPort = atoi(value);
		TTL = atoi(value);
		OnvifReplyMsgParser("V2_MULTICAST_IP", ReplyMsg, value);
		strncpy (IPv4Address, value, strlen (value));
	}

	
	trt__GetCompatibleMetadataConfigurationsResponse->__sizeConfigurations = 1;
	trt__GetCompatibleMetadataConfigurationsResponse->Configurations =
		(struct tt__MetadataConfiguration *) soap_malloc (soap, sizeof(struct tt__MetadataConfiguration));

	soap_default_tt__MetadataConfiguration (soap, trt__GetCompatibleMetadataConfigurationsResponse->Configurations);
	Configurations = trt__GetCompatibleMetadataConfigurationsResponse->Configurations;
	Configurations->Name = gOnvifConf.meConf.Name;
	Configurations->UseCount = gOnvifConf.meConf.UseCount;
	Configurations->token = gOnvifConf.meConf.token;
	Configurations->Multicast = 
			(struct tt__MulticastConfiguration *) soap_malloc (soap, sizeof (struct tt__MulticastConfiguration));
	soap_default_tt__MulticastConfiguration (soap, Configurations->Multicast);
	Configurations->Multicast->Address = (struct tt__IPAddress *) soap_malloc (soap, sizeof (struct tt__IPAddress));
	soap_default_tt__IPAddress (soap, Configurations->Multicast->Address);
	Configurations->Multicast->Address->Type = IPv4_;
	Configurations->Multicast->Address->IPv4Address = &IPv4Address;
	Configurations->Multicast->Port = MulticastPort; 
	Configurations->Multicast->TTL = TTL;
	Configurations->Multicast->AutoStart = gOnvifConf.meConf.AutoStart;
	Configurations->SessionTimeout = gOnvifConf.meConf.SessionTimeout;
#endif
	return SOAP_OK;
}

int __trt__GetCompatibleAudioOutputConfigurations(struct soap *soap, struct _trt__GetCompatibleAudioOutputConfigurations *trt__GetCompatibleAudioOutputConfigurations, struct _trt__GetCompatibleAudioOutputConfigurationsResponse *trt__GetCompatibleAudioOutputConfigurationsResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}

int __trt__SetVideoSourceConfiguration (struct soap *soap,
					struct _trt__SetVideoSourceConfiguration *trt__SetVideoSourceConfiguration,
					struct _trt__SetVideoSourceConfigurationResponse *trt__SetVideoSourceConfigurationResponse)
{
	int i, j;
	struct tt__VideoSourceConfiguration *vsConf = NULL;
	Acti_VideoSourceConfig *VsConfPtr = NULL;

	//check value
	if (trt__SetVideoSourceConfiguration->Configuration == NULL)
		return soap_sender_fault (soap, "", NULL);

	//find token
	vsConf = trt__SetVideoSourceConfiguration->Configuration;
	for (i = 0; i < gOnvifConf.VsCnt; i++) {
		if (vsConf->token == NULL || vsConf->SourceToken == NULL || vsConf->Name == NULL || vsConf->Bounds == NULL) 
			return SOAP_REQUIRED;
		if (strcmp (gOnvifConf.vsConf[i].token, vsConf->token) == 0) {
			for (j = 0; j < gOnvifConf.SourceTokenCnt; j++) {
				if (strcmp (gOnvifConf.SourceToken[j].Token, vsConf->SourceToken) == 0) {
//TODO
//					if(j != gOnvifConf.vsConf[i].SourseTokenIdx)
//						return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoVideoSource", NULL,
//									 "The requested VideoSource does not exist");
					/// Top of Winters ///
					if (VsConfPtr == NULL)
					{
						if (trt__SetVideoSourceConfiguration->ForcePersistence == false_)
						{
							VsConfPtr = &tmpVsConf[i]; 
							VSConfigState[i] = false_;
						}
						else 	
						{
							VsConfPtr = &gOnvifConf.vsConf[i];
							VSConfigState[i] = true_;
						}
					}
					/// Bottom of Winters ///
					if(((vsConf->Bounds->x + vsConf->Bounds->width) > gOnvifConf.SourceToken[j].res.Width) || 
						((vsConf->Bounds->y + vsConf->Bounds->height) > gOnvifConf.SourceToken[j].res.Height))
						return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ConfigModify", 
										"Parameters can not be set", 
										 "The configuration parameters are not possible to set.");
					strcpy (VsConfPtr->Name, vsConf->Name);
					VsConfPtr->b.x = vsConf->Bounds->x;
					VsConfPtr->b.y = vsConf->Bounds->y;
					VsConfPtr->b.width = vsConf->Bounds->width;//TODO check TV
					VsConfPtr->b.height = vsConf->Bounds->height;
					//VsConfPtr->ForcePersistence = trt__SetVideoSourceConfiguration->ForcePersistence;
					config_change = true_;
					return SOAP_OK;
				}
			}
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ConfigModify", "Parameters can not be set",
									 "The configuration parameters are not possible to set.");
		}
	}
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoVideoSource", NULL,
									 "The requested VideoSource does not exist");
}
static int OnvifResolutionCheck(int width, int height, int videoSrc) {
    int i = 0;
    int cnt = 0;
    struct tt__VideoResolution *cap = NULL;
    
    if(videoSrc == 1) {
        cnt = gOnvifConf.ResCapNum;
        cap = gOnvifConf.ResCap;
    } else {
        cnt = gOnvifConf.ResCapNum2; 
        cap = gOnvifConf.ResCap2;
    }
    for (i = 0; i < cnt; i++) {	
        if((width == cap[i].Width) && (height == cap[i].Height)) return OK;
	}
    L1("error. no %dx%d in src %d\n", width, height, videoSrc);
    return ERR;
}
static int OnvifEncoderCheck(int encoder) {

    switch(encoder) {
        case H264:
            if(gOnvifConf.H264_Enable == true_) return OK;
            fprintf(stdout, "%s:error, request h264 but not enabled\n", __func__);
            return ERR;
        case JPEG:
            if(gOnvifConf.MJPEG_Enable == true_) return OK;
            fprintf(stdout, "%s:error, request mjpeg but not enabled\n", __func__);
            return ERR;
        case MPEG4:
            if(gOnvifConf.MPEG4_Enable == true_) return OK;
            fprintf(stdout, "%s:error, request mpeg4 but not enabled\n", __func__);
            return ERR;
        default:
            fprintf(stdout, "%s:error, request unknown requested encoder %d\n", __func__, encoder);
            return ERR;
    }
}
int __trt__SetVideoEncoderConfiguration (struct soap *soap,
					 struct _trt__SetVideoEncoderConfiguration *trt__SetVideoEncoderConfiguration,
					 struct _trt__SetVideoEncoderConfigurationResponse *trt__SetVideoEncoderConfigurationResponse)
{
    int i;
    int vsrc = 1;
    struct tt__VideoEncoderConfiguration *veConf = NULL;
    Acti_VideoEncoderConfig *VeConfPtr = NULL; 

    if ((trt__SetVideoEncoderConfiguration->Configuration  == NULL) ||
	(trt__SetVideoEncoderConfiguration->Configuration->Name == NULL) ||
	(trt__SetVideoEncoderConfiguration->Configuration->token == NULL) || 
	(trt__SetVideoEncoderConfiguration->Configuration->Resolution == NULL) || 
	(trt__SetVideoEncoderConfiguration->Configuration->Multicast == NULL) ||
	(trt__SetVideoEncoderConfiguration->Configuration->Multicast->Address == NULL) ||
	(trt__SetVideoEncoderConfiguration->Configuration->SessionTimeout == NULL))    return SOAP_REQUIRED;

    veConf = trt__SetVideoEncoderConfiguration->Configuration;
    for (i = 0; i < MAX_VE_LIST; i++) {
	if( (gOnvifConf.veConf[i].valid == 1) &&
	    (strcmp (gOnvifConf.veConf[i].token, veConf->token) == 0)) {
	    /* check this encoder settings with my capability */
	    if(gOnvifConf.veConf[i].videoSrcInProfile > 0) vsrc = gOnvifConf.veConf[i].videoSrcInProfile;
	    else                                           vsrc = gOnvifConf.veConf[i].videoSrc;
	    if( (OnvifResolutionCheck(veConf->Resolution->Width, veConf->Resolution->Height, vsrc) == OK) &&
		    (OnvifEncoderCheck(veConf->Encoding) == OK) ) {
		if (veConf->Encoding == MPEG4) {
		    if (veConf->MPEG4 == NULL)  return SOAP_REQUIRED;
		    if (veConf->MPEG4->GovLength > 60) goto SetVideoEncoderConfigurationInvalidArgVal;
		}
		if ((veConf->Encoding == H264)) {
		    if (veConf->H264 == NULL)  return SOAP_REQUIRED;
		    if(veConf->H264->GovLength > 60) goto SetVideoEncoderConfigurationInvalidArgVal;
		}
		/* every settings are fine, update to this video encoder configurations */
		VeConfPtr = &gOnvifConf.veConf[i];
		if (veConf->RateControl != NULL) {
		    /* max. video bitrate is 6Mbps */
		    if(veConf->RateControl->BitrateLimit > 60000) {
			VeConfPtr->rc.BitrateLimit = 60000;
		    } else {
			VeConfPtr->rc.BitrateLimit = veConf->RateControl->BitrateLimit;
		    }
		    /* get the max frame rate */
		    if(veConf->RateControl->FrameRateLimit > 0) {
			VeConfPtr->rc.FrameRateLimit = veConf->RateControl->FrameRateLimit;
		    }
		    VeConfPtr->rc.EncodingInterval = 1;
		}
		snprintf(VeConfPtr->Name, MAX_PROFILE_STR, "%s", veConf->Name);
		snprintf(VeConfPtr->token, MAX_TOKEN_STRLEN, "%s", veConf->token);
		if(trt__SetVideoEncoderConfiguration->ForcePersistence == false_) VeConfPtr->needSaved = 0;
		else                                                              VeConfPtr->needSaved = 1;
		VeConfPtr->r.Height = veConf->Resolution->Height;
		VeConfPtr->r.Width = veConf->Resolution->Width;
		VeConfPtr->Encoding = veConf->Encoding;
		VeConfPtr->Quality = (int) veConf->Quality;
		if (veConf->H264) {
		    VeConfPtr->t.H264.GovLength   = veConf->H264->GovLength;
		    VeConfPtr->t.H264.H264Profile = veConf->H264->H264Profile;
		}
		if (veConf->MPEG4) {
		    VeConfPtr->t.MPEG4.GovLength    = veConf->MPEG4->GovLength;
		    VeConfPtr->t.MPEG4.Mpeg4Profile = veConf->MPEG4->Mpeg4Profile;
		}
		VeConfPtr->Multicast.Type = IPv4_;
		/* Onvif Core Spec:
		   Changes in the Multicast settings shall always be persistent.
                   Saving Multicast settings to gOnvifConf.veConf . */
		if (veConf->Multicast->Address->IPv4Address != NULL) {
		    strncpy ((char *)&VeConfPtr->Multicast.IPv4Address, veConf->Multicast->Address->IPv4Address[0], 
		    strlen (veConf->Multicast->Address->IPv4Address[0])); 
		    //Sync Multicast data to gOnvifConf
		    strncpy ((char *)&gOnvifConf.veConf[i].Multicast.IPv4Address, veConf->Multicast->Address->IPv4Address[0], 16);
		}
		VeConfPtr->Multicast.Port = veConf->Multicast->Port;
		VeConfPtr->Multicast.TTL = veConf->Multicast->TTL;
		VeConfPtr->Multicast.Port = veConf->Multicast->Port;
		VeConfPtr->Multicast.TTL = veConf->Multicast->TTL;
		VeConfPtr->Multicast.AutoStart = veConf->Multicast->AutoStart;
		//session Timeout
		strcpy (VeConfPtr->SessionTimeout, veConf->SessionTimeout);
		if(VeConfPtr->needSaved) config_change = true_;
		fprintf(stdout, "%s:set veConf[%d]. %s,%s %dx%d, %s\n", __func__, i, VeConfPtr->token, VeConfPtr->Name,
			VeConfPtr->r.Width, VeConfPtr->r.Height, 
			(VeConfPtr->Encoding==H264)?"H264":(VeConfPtr->Encoding==MPEG4)?"MPEG4":"MJPEG");
		return SOAP_OK;
	    } else goto SetVideoEncoderConfigurationInvalidArgVal;
	}
    }
    L1("error. not found token '%s' %dx%d, from veConf\n", veConf->token, veConf->Resolution->Width, veConf->Resolution->Height);
	/*
    for(i = 0 ; i < MAX_VE_LIST ; i ++) {
		if(gOnvifConf.veConf[i].valid == 1) {
			printf("ve[%d]:%d,'%s',%d, %d\n", i+1, gOnvifConf.veConf[i].valid, gOnvifConf.veConf[i].token,
		    gOnvifConf.veConf[i].videoSrc, gOnvifConf.veConf[i].videoSrcInProfile);
		}
    }
	*/
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
                                            "The configuration does not exist.");
SetVideoEncoderConfigurationInvalidArgVal:
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ConfigModify", NULL,
                                         "The configuration parameters are not possible to set.");
}

int __trt__SetAudioSourceConfiguration (struct soap *soap,
					struct _trt__SetAudioSourceConfiguration *trt__SetAudioSourceConfiguration,
					struct _trt__SetAudioSourceConfigurationResponse *trt__SetAudioSourceConfigurationResponse)
{
	Acti_AudioSourceConfig *AsConfPtr = NULL;

	if (trt__SetAudioSourceConfiguration == NULL
	   || trt__SetAudioSourceConfiguration->Configuration == NULL
	   || trt__SetAudioSourceConfiguration->Configuration->Name == NULL
	   || trt__SetAudioSourceConfiguration->Configuration->token == NULL
	   || trt__SetAudioSourceConfiguration->Configuration->SourceToken == NULL)
		return SOAP_REQUIRED;

	if (trt__SetAudioSourceConfiguration->ForcePersistence == true_)
	{
		AsConfPtr = &gOnvifConf.asConf; 
		ASConfigState = true_;
	}
	else
	{
		AsConfPtr = &tmpAsConf; 	
		ASConfigState = false_;
	}
	if (trt__SetAudioSourceConfiguration->Configuration->token != NULL)
	{
		if (AsConfPtr->Name[0] == '\0')
		{
			if (strcmp (trt__SetAudioSourceConfiguration->Configuration->token, gOnvifConf.asConf.token) != 0) 
			{
				goto ERROR_PARAMETER; 
			}
		}
		else if (strcmp (trt__SetAudioSourceConfiguration->Configuration->token, AsConfPtr->token) != 0) 
		{
			goto ERROR_PARAMETER; 
		}
	}
	else if (trt__SetAudioSourceConfiguration->Configuration->Name != NULL)
	{
		if (AsConfPtr->Name[0] == '\0')
		{
			if (strcmp (trt__SetAudioSourceConfiguration->Configuration->Name, gOnvifConf.asConf.Name) != 0) 
			{
				goto ERROR_PARAMETER; 
			}
		}
	}
	else
	{
		goto ERROR_PARAMETER; 
	}
	//Only one Audio Source
	if (strcmp (trt__SetAudioSourceConfiguration->Configuration->SourceToken, gOnvifConf.asConf.SourceToken) != 0)
	{
		goto ERROR_PARAMETER; 
	}

	snprintf (AsConfPtr->token, MAX_TOKEN_STRLEN, "%s", 
		trt__SetAudioSourceConfiguration->Configuration->token); 
	snprintf (AsConfPtr->Name, MAX_PROFILE_STR, "%s", 
		trt__SetAudioSourceConfiguration->Configuration->Name); 
	snprintf (AsConfPtr->SourceToken, MAX_TOKEN_STRLEN, "%s", 
		trt__SetAudioSourceConfiguration->Configuration->SourceToken); 
	AsConfPtr->UseCount = gOnvifConf.asConf.UseCount; 
	return SOAP_OK;
ERROR_PARAMETER:
	ASConfigState = true_;
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
		"The configuration parameters are not possible to set.");
}


int __trt__SetAudioEncoderConfiguration (struct soap *soap,
					 struct _trt__SetAudioEncoderConfiguration *trt__SetAudioEncoderConfiguration,
					 struct _trt__SetAudioEncoderConfigurationResponse
										 *trt__SetAudioEncoderConfigurationResponse)
{
	Acti_AudioEncoderConfig *AeConfPtr = NULL;
	/*
       Only one set of Audio Encoder Configuration, so that always refers to gOnvifConf.AeConf .
	   Policy: 
	   We don't allow user to change token, name, ercoding (type), bitrate and samplerate.
	*/
	if (trt__SetAudioEncoderConfiguration->ForcePersistence	== true_)
	{
		AeConfPtr = &gOnvifConf.aeConf; 
		AEConfigState = true_;
	}
	else
	{
		AeConfPtr = &tmpAeConf; 
		AEConfigState = false_;
	}
	if (trt__SetAudioEncoderConfiguration == NULL 
	   || trt__SetAudioEncoderConfiguration->Configuration == NULL 
	   || trt__SetAudioEncoderConfiguration->Configuration->Multicast == NULL
	   || trt__SetAudioEncoderConfiguration->Configuration->Multicast->Address == NULL
	   || trt__SetAudioEncoderConfiguration->Configuration->SessionTimeout == NULL)
	   //|| trt__SetAudioEncoderConfiguration->Configuration->Multicast->Address->IPv4Address == NULL)
		return SOAP_REQUIRED;
	if(trt__SetAudioEncoderConfiguration->Configuration->Name != NULL)
		if(strcmp(trt__SetAudioEncoderConfiguration->Configuration->Name, gOnvifConf.aeConf.Name) != 0) 
			goto ERROR_AUDIOTOKEN;
	if(trt__SetAudioEncoderConfiguration->Configuration->token != NULL)
		if(strcmp(trt__SetAudioEncoderConfiguration->Configuration->token, gOnvifConf.aeConf.token) != 0) 
			goto ERROR_AUDIOTOKEN;
	if(trt__SetAudioEncoderConfiguration->Configuration->Encoding != gOnvifConf.aeConf.Encoding)
		goto ERROR_PARAMETER;
	if(trt__SetAudioEncoderConfiguration->Configuration->Bitrate != gOnvifConf.aeConf.Bitrate/1000)
		goto ERROR_PARAMETER;
	if(trt__SetAudioEncoderConfiguration->Configuration->SampleRate != gOnvifConf.aeConf.SampleRate/1000)
		goto ERROR_PARAMETER;
	if (trt__SetAudioEncoderConfiguration->Configuration->Multicast->Address->Type != gOnvifConf.aeConf.Multicast.Type)
		goto ERROR_PARAMETER;
		snprintf (AeConfPtr->Name, MAX_PROFILE_STR, "%s", 
			trt__SetAudioEncoderConfiguration->Configuration->Name); 
		snprintf (AeConfPtr->token, MAX_TOKEN_STRLEN, "%s", 
			trt__SetAudioEncoderConfiguration->Configuration->token); 
	AeConfPtr->Encoding = trt__SetAudioEncoderConfiguration->Configuration->Encoding;
	AeConfPtr->Multicast.Type = IPv4_;
	if (trt__SetAudioEncoderConfiguration->Configuration->Multicast->Address->IPv4Address != NULL) {
		snprintf (AeConfPtr->Multicast.IPv4Address, 16, "%s", 
			trt__SetAudioEncoderConfiguration->Configuration->Multicast->Address->IPv4Address[0]); 
	}
	AeConfPtr->Multicast.Port = trt__SetAudioEncoderConfiguration->Configuration->Multicast->Port;
	AeConfPtr->Multicast.TTL = trt__SetAudioEncoderConfiguration->Configuration->Multicast->TTL;
	if (AEConfigState == false_) {
		gOnvifConf.aeConf.Multicast.Type = AeConfPtr->Multicast.Type;
		snprintf (gOnvifConf.aeConf.Multicast.IPv4Address, 16, "%s", AeConfPtr->Multicast.IPv4Address);
		gOnvifConf.aeConf.Multicast.Port = AeConfPtr->Multicast.Port; 
		gOnvifConf.aeConf.Multicast.TTL = AeConfPtr->Multicast.TTL;
	}
	snprintf (AeConfPtr->SessionTimeout, 16, "%s", trt__SetAudioEncoderConfiguration->Configuration->SessionTimeout); 
	config_change = true_; //Multicast settings always be persist
	return SOAP_OK;
ERROR_AUDIOTOKEN:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", NULL,
		"The configuration does not exist.");
ERROR_PARAMETER:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:ConfigModify", NULL,
		"The configuration parameters are not possible to set.");
}

int __trt__SetAudioOutputConfiguration(struct soap *soap, struct _trt__SetAudioOutputConfiguration *trt__SetAudioOutputConfiguration, struct _trt__SetAudioOutputConfigurationResponse *trt__SetAudioOutputConfigurationResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}
static int GetVsIdxFmConfigToken(char *token) {

	int i = 0;
	int vsIdx = 1;

	if((token) && (strlen(token) > 0)) {
		for (i = 0 ; i < gOnvifConf.VsCnt ; i++) {
			if(strcmp(token, gOnvifConf.SourceToken[i].Token) == 0) {
				vsIdx = i+1;
				break;
			}
		}
	}
	return vsIdx;
}
int __trt__GetVideoSourceConfigurationOptions (struct soap *soap,
				   struct _trt__GetVideoSourceConfigurationOptions *trt__GetVideoSourceConfigurationOptions,
				   struct _trt__GetVideoSourceConfigurationOptionsResponse *trt__GetVideoSourceConfigurationOptionsResponse)
{
	int i = 0;
	int vsIdx = 0;
	static char *Token[MAX_VS_LIST]; 
	struct tt__VideoSourceConfigurationOptions *option = NULL;

	trt__GetVideoSourceConfigurationOptionsResponse->Options =
		(struct tt__VideoSourceConfigurationOptions *) soap_malloc (soap, sizeof (struct tt__VideoSourceConfigurationOptions));
	soap_default_tt__VideoSourceConfigurationOptions (soap, trt__GetVideoSourceConfigurationOptionsResponse->Options);
	option = trt__GetVideoSourceConfigurationOptionsResponse->Options;
	option->BoundsRange = (struct tt__IntRectangleRange *) soap_malloc (soap, sizeof (struct tt__IntRectangleRange));
	soap_default_tt__IntRectangleRange (soap, option->BoundsRange);
	option->BoundsRange->XRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
	soap_default_tt__IntRange (soap, option->BoundsRange->XRange);
	option->BoundsRange->XRange->Min = 0;
	option->BoundsRange->XRange->Max = 0;
	option->BoundsRange->YRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
	soap_default_tt__IntRange (soap, option->BoundsRange->YRange);
	option->BoundsRange->YRange->Min = 0;
	option->BoundsRange->YRange->Max = 0;
	option->BoundsRange->WidthRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
	soap_default_tt__IntRange (soap, option->BoundsRange->WidthRange);
	option->BoundsRange->HeightRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
	soap_default_tt__IntRange (soap, option->BoundsRange->HeightRange);
	vsIdx = GetVsIdxFmConfigToken(trt__GetVideoSourceConfigurationOptions->ConfigurationToken);
	if(vsIdx == 2) {
		option->BoundsRange->WidthRange->Min  = gOnvifConf.minResWidth2;
		option->BoundsRange->HeightRange->Min = gOnvifConf.minResHeight2;
		option->BoundsRange->WidthRange->Max  = gOnvifConf.maxResWidth2;
		option->BoundsRange->HeightRange->Max = gOnvifConf.maxResHeight2;
		option->__sizeVideoSourceTokensAvailable = gOnvifConf.VsCnt;
	} else {
		option->BoundsRange->WidthRange->Min = gOnvifConf.minResWidth; 
		option->BoundsRange->HeightRange->Min = gOnvifConf.minResHeight; 
		option->BoundsRange->WidthRange->Max = gOnvifConf.maxResWidth;
		option->BoundsRange->HeightRange->Max = gOnvifConf.maxResHeight;
		option->__sizeVideoSourceTokensAvailable = gOnvifConf.VsCnt;
	}
	for (i=0 ; i < gOnvifConf.VsCnt ; i++) {
		Token[i] = (char *)soap_malloc (soap, MAX_TOKEN_STRLEN);
        snprintf(Token[i], MAX_TOKEN_STRLEN, "%s", gOnvifConf.SourceToken[i].Token);
	}
	option->VideoSourceTokensAvailable = Token;

	return SOAP_OK;
}


int __trt__GetVideoEncoderConfigurationOptions (struct soap *soap,
		struct _trt__GetVideoEncoderConfigurationOptions *trt__GetVideoEncoderConfigurationOptions,
		struct _trt__GetVideoEncoderConfigurationOptionsResponse *trt__GetVideoEncoderConfigurationOptionsResponse)
{
	int i = 0;
    int vsrc = 1;
	struct tt__VideoEncoderConfigurationOptions *option = NULL;
    Acti_VideoEncoderConfig *ve = NULL;

    if (trt__GetVideoEncoderConfigurationOptions->ConfigurationToken == NULL) {
        /* use the profile token to find the video encoder configurations */
        if(trt__GetVideoEncoderConfigurationOptions->ProfileToken) {
            if (FindMediaProfile (soap, trt__GetVideoEncoderConfigurationOptions->ProfileToken, &i) == OK) {
                if(gOnvifConf.profile[i].valid == 1) {
                    if(gOnvifConf.veConf[gOnvifConf.profile[i].veIdx].valid == 1) {
                        ve = &gOnvifConf.veConf[i];
                        goto GetVideoEncoderConfigurationOptionsReply;
                    }
                }
            }
        } else { /* no token found in the request, use the first found valid veconf as the generic veconf */
            for (i = 0; i < MAX_VE_LIST; i++) {
                if (gOnvifConf.veConf[i].valid == 1) {
                    ve = &gOnvifConf.veConf[i];
                    goto GetVideoEncoderConfigurationOptionsReply;
                }
            }
        }
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
                                             "The requested profile token ProfileToken does not exist.");
    } else { /* use video encoder configuration token to find the video encoder configurations */
        for (i = 0; i < MAX_VE_LIST; i++) {
            if ((gOnvifConf.veConf[i].valid == 1) &&
                (strcmp (gOnvifConf.veConf[i].token, trt__GetVideoEncoderConfigurationOptions->ConfigurationToken) == 0)) {
                /* found the video encoder configuration token */
                ve = &gOnvifConf.veConf[i];
                goto GetVideoEncoderConfigurationOptionsReply;
            }
        }
    }
    return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoConfig", "No such configuration",
										 "The requested configuration indicated with ConfigurationToken does not exist.");
                                         
GetVideoEncoderConfigurationOptionsReply:
	trt__GetVideoEncoderConfigurationOptionsResponse->Options =
		(struct tt__VideoEncoderConfigurationOptions *) soap_malloc (soap, sizeof (struct tt__VideoEncoderConfigurationOptions));
	soap_default_tt__VideoEncoderConfigurationOptions (soap, trt__GetVideoEncoderConfigurationOptionsResponse->Options);
	option = trt__GetVideoEncoderConfigurationOptionsResponse->Options;

	/* prepare QualityRange Options */
    if(ve->videoSrcInProfile > 0) vsrc = ve->videoSrcInProfile;
    else                          vsrc = ve->videoSrc;
	option->QualityRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
	soap_default_tt__IntRange (soap, option->QualityRange);
	option->QualityRange->Max = 100;
	option->QualityRange->Min = 1;
	/* prepare H264 encoder options */
	if (gOnvifConf.H264_Enable == true_) {
		option->H264 = (struct tt__H264Options *) soap_malloc (soap, sizeof (struct tt__H264Options));
		soap_default_tt__H264Options (soap, option->H264);
        if(vsrc == 1) {
            option->H264->__sizeResolutionsAvailable = gOnvifConf.ResCapNum;
            option->H264->ResolutionsAvailable = 
                  (struct tt__VideoResolution *) soap_malloc (soap, sizeof (struct tt__VideoResolution) * option->H264->__sizeResolutionsAvailable);
            for(i = 0; i < option->H264->__sizeResolutionsAvailable ; i++) {
                option->H264->ResolutionsAvailable[i].Width = gOnvifConf.ResCap[i].Width; 
                option->H264->ResolutionsAvailable[i].Height = gOnvifConf.ResCap[i].Height;
            }
        } else {
            option->H264->__sizeResolutionsAvailable = gOnvifConf.ResCapNum2;
            option->H264->ResolutionsAvailable = 
                  (struct tt__VideoResolution *) soap_malloc (soap, sizeof (struct tt__VideoResolution) * option->H264->__sizeResolutionsAvailable);
            for(i = 0; i < option->H264->__sizeResolutionsAvailable ; i++) {
                option->H264->ResolutionsAvailable[i].Width = gOnvifConf.ResCap2[i].Width; 
                option->H264->ResolutionsAvailable[i].Height = gOnvifConf.ResCap2[i].Height;
            }
        }
		option->H264->GovLengthRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->H264->GovLengthRange->Max = 60;
		option->H264->GovLengthRange->Min = 0;
		option->H264->FrameRateRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->H264->FrameRateRange->Max = 30;
		option->H264->FrameRateRange->Min = 1;
		option->H264->EncodingIntervalRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->H264->EncodingIntervalRange->Max = 1;
		option->H264->EncodingIntervalRange->Min = 1;
		option->H264->__sizeH264ProfilesSupported = 1;
		option->H264->H264ProfilesSupported = &gOnvifConf.H264ProfileType;
	}
	/* prepare MJPEG encoder options */
	if (gOnvifConf.MJPEG_Enable == true_) {
		option->JPEG = (struct tt__JpegOptions *) soap_malloc (soap, sizeof (struct tt__JpegOptions));
		soap_default_tt__JpegOptions (soap, option->JPEG);
        if(vsrc == 1) {
            option->JPEG->__sizeResolutionsAvailable = gOnvifConf.ResCapNum; 
            option->JPEG->ResolutionsAvailable = 
                    (struct tt__VideoResolution *) soap_malloc (soap, sizeof (struct tt__VideoResolution) * option->JPEG->__sizeResolutionsAvailable);
            for(i = 0; i < option->JPEG->__sizeResolutionsAvailable ; i++) {
                option->JPEG->ResolutionsAvailable[i].Width = gOnvifConf.ResCap[i].Width; 
                option->JPEG->ResolutionsAvailable[i].Height = gOnvifConf.ResCap[i].Height;
            }
        } else {
            option->JPEG->__sizeResolutionsAvailable = gOnvifConf.ResCapNum2; 
            option->JPEG->ResolutionsAvailable = 
                    (struct tt__VideoResolution *) soap_malloc (soap, sizeof (struct tt__VideoResolution) * option->JPEG->__sizeResolutionsAvailable);
            for(i = 0; i < option->JPEG->__sizeResolutionsAvailable ; i++) {
                option->JPEG->ResolutionsAvailable[i].Width = gOnvifConf.ResCap2[i].Width; 
                option->JPEG->ResolutionsAvailable[i].Height = gOnvifConf.ResCap2[i].Height;
            }
        }
		option->JPEG->FrameRateRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->JPEG->FrameRateRange->Max = 30;
		option->JPEG->FrameRateRange->Min = 1;
		option->JPEG->EncodingIntervalRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->JPEG->EncodingIntervalRange->Max = 1;
		option->JPEG->EncodingIntervalRange->Min = 1;
	}
	/* prepare MPEG4 encoder options */
	if (gOnvifConf.MPEG4_Enable == true_) {
		option->MPEG4 = (struct tt__Mpeg4Options *) soap_malloc (soap, sizeof (struct tt__Mpeg4Options));
		soap_default_tt__Mpeg4Options (soap, option->MPEG4);
		/* MPEG4 always use video source 1 resolution capability */
		option->MPEG4->__sizeResolutionsAvailable = gOnvifConf.ResCapNum; 
		option->MPEG4->ResolutionsAvailable = 
                (struct tt__VideoResolution *) soap_malloc (soap, sizeof (struct tt__VideoResolution) * option->MPEG4->__sizeResolutionsAvailable);
		for(i=0; i<option->MPEG4->__sizeResolutionsAvailable; i++) {
			option->MPEG4->ResolutionsAvailable[i].Width = gOnvifConf.ResCap[i].Width; 
			option->MPEG4->ResolutionsAvailable[i].Height = gOnvifConf.ResCap[i].Height;
		}
		option->MPEG4->GovLengthRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->MPEG4->GovLengthRange->Max = 60;
		option->MPEG4->GovLengthRange->Min = 0;
		option->MPEG4->FrameRateRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->MPEG4->FrameRateRange->Max = 30;
		option->MPEG4->FrameRateRange->Min = 1;
		option->MPEG4->EncodingIntervalRange = (struct tt__IntRange *) soap_malloc (soap, sizeof (struct tt__IntRange));
		option->MPEG4->EncodingIntervalRange->Max = 1;
		option->MPEG4->EncodingIntervalRange->Min = 1;
		option->MPEG4->__sizeMpeg4ProfilesSupported = 1;
		option->MPEG4->Mpeg4ProfilesSupported = &gOnvifConf.ProfileType;
	}
	return SOAP_OK;
}

int __trt__GetAudioSourceConfigurationOptions (struct soap *soap,
		   struct _trt__GetAudioSourceConfigurationOptions   *trt__GetAudioSourceConfigurationOptions,
		   struct _trt__GetAudioSourceConfigurationOptionsResponse  *trt__GetAudioSourceConfigurationOptionsResponse)
{
//char *ConfigurationToken;	/* optional element of type tt:ReferenceToken */
//char *ProfileToken;	/* optional element of type tt:ReferenceToken */
	int id = 0;
	static char *TokenAvaliable;

	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
	if (trt__GetAudioSourceConfigurationOptions->ProfileToken != NULL)
	{
		if (FindMediaProfile (soap, trt__GetAudioSourceConfigurationOptions->ProfileToken, &id) != OK) 
			goto ERROR_AUDIOTOKEN; 
	}
	else if (trt__GetAudioSourceConfigurationOptions->ConfigurationToken != NULL)
	{
	   	if (strcmp (trt__GetAudioSourceConfigurationOptions->ConfigurationToken, gOnvifConf.asConf.token) != 0)
			goto ERROR_AUDIOTOKEN; 
	}

	trt__GetAudioSourceConfigurationOptionsResponse->Options = 
		(struct tt__AudioSourceConfigurationOptions *) 
		soap_malloc (soap, sizeof (struct tt__AudioSourceConfigurationOptions));
	soap_default_tt__AudioSourceConfigurationOptions (soap, trt__GetAudioSourceConfigurationOptionsResponse->Options); 
	// Only one set of Audio Source.
	trt__GetAudioSourceConfigurationOptionsResponse->Options->__sizeInputTokensAvailable = gOnvifConf.sizeAsConf; 
	TokenAvaliable = (char *) soap_malloc (soap, 4);
	TokenAvaliable = gOnvifConf.asConf.token;
	trt__GetAudioSourceConfigurationOptionsResponse->Options->InputTokensAvailable = &TokenAvaliable;
	return SOAP_OK;
ERROR_AUDIOTOKEN:
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoAudioSource", NULL,
		"The requested Audio Input does not exist");
}


int __trt__GetAudioEncoderConfigurationOptions (struct soap *soap,
				struct _trt__GetAudioEncoderConfigurationOptions *trt__GetAudioEncoderConfigurationOptions,
				struct _trt__GetAudioEncoderConfigurationOptionsResponse *trt__GetAudioEncoderConfigurationOptionsResponse)
{
	int id = 0;
	static int Bitrate = 64; /* in kbps */
	static int SampleRate = 8; /* in KHz */
	if (gOnvifConf.AudioEnable == false_)
		return soap_receiver_fault_subcode_v2 (	soap, "ter:ActionNotSupported", "ter:AudioNotSupported", 
												NULL, "The device does not support audio.");
			
	if(trt__GetAudioEncoderConfigurationOptions->ProfileToken != NULL)
	{
		if (FindMediaProfile (soap, trt__GetAudioEncoderConfigurationOptions->ProfileToken, &id) != OK) 
			return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
								 "The requested profile token ProfileToken does not exist.");
	}
	
	if(trt__GetAudioEncoderConfigurationOptions->ConfigurationToken != NULL)
		if(strcmp(trt__GetAudioEncoderConfigurationOptions->ConfigurationToken, "0") != 0) return SOAP_ERR;
	//AudioEncoderConfigurationOptions Options
	trt__GetAudioEncoderConfigurationOptionsResponse->Options = 
		(struct tt__AudioEncoderConfigurationOptions *) soap_malloc(soap, sizeof(struct tt__AudioEncoderConfigurationOptions)); 
	soap_default_tt__AudioEncoderConfigurationOptions(soap, trt__GetAudioEncoderConfigurationOptionsResponse->Options);
	//AudioEncoderConfigurationOption Options
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->__sizeOptions = 1;
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options =
		(struct tt__AudioEncoderConfigurationOption *) soap_malloc(soap, sizeof(struct tt__AudioEncoderConfigurationOption)); 
	soap_default_tt__AudioEncoderConfigurationOption(soap, trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options);
	//Encoding
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->Encoding = G711;
	//Bitrate
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->BitrateList = 
					(struct tt__IntList *) soap_malloc(soap, sizeof(struct tt__IntList));
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->BitrateList->__sizeItems = 1;
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->BitrateList->Items = &Bitrate;
	//SampleRate
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->SampleRateList = 
					(struct tt__IntList *) soap_malloc(soap, sizeof(struct tt__IntList));
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->SampleRateList->__sizeItems = 1;
	trt__GetAudioEncoderConfigurationOptionsResponse->Options->Options->SampleRateList->Items = &SampleRate;

	return SOAP_OK;
}

int __trt__GetMetadataConfigurationOptions(struct soap *soap, struct _trt__GetMetadataConfigurationOptions *trt__GetMetadataConfigurationOptions, struct _trt__GetMetadataConfigurationOptionsResponse *trt__GetMetadataConfigurationOptionsResponse)
{	
	soap_default__trt__GetMetadataConfigurationOptionsResponse (soap, trt__GetMetadataConfigurationOptionsResponse);
	trt__GetMetadataConfigurationOptionsResponse->Options = 
		(struct tt__MetadataConfigurationOptions *) soap_malloc (soap, sizeof (struct tt__MetadataConfigurationOptions));
	soap_default_tt__MetadataConfigurationOptions (soap, trt__GetMetadataConfigurationOptionsResponse->Options);
	trt__GetMetadataConfigurationOptionsResponse->Options->PTZStatusFilterOptions = 
		(struct tt__PTZStatusFilterOptions *) soap_malloc (soap, sizeof (struct tt__PTZStatusFilterOptions));
	soap_default_tt__PTZStatusFilterOptions(soap, trt__GetMetadataConfigurationOptionsResponse->Options->PTZStatusFilterOptions);
	trt__GetMetadataConfigurationOptionsResponse->Options->PTZStatusFilterOptions->PanTiltStatusSupported = false_;
	trt__GetMetadataConfigurationOptionsResponse->Options->PTZStatusFilterOptions->ZoomStatusSupported = false_;
	return SOAP_OK;
}

int __trt__GetAudioOutputConfigurationOptions(struct soap *soap, struct _trt__GetAudioOutputConfigurationOptions *trt__GetAudioOutputConfigurationOptions, struct _trt__GetAudioOutputConfigurationOptionsResponse *trt__GetAudioOutputConfigurationOptionsResponse)
{	
	/* Media Service Spec V2.2: 
  		5.11.1 Get audio outputs
			GetAudioOutputsResponse: 
			Contains a list of structures describing all available audio outputs of the device. 
			If a device has no AudioOutputs an empty list is returned.
	   SSPO Policy: We don't support this function currently.
 	*/
	return soap_receiver_fault_subcode_v2 (soap, "ter:ActionNotSupported", "ter:AudioOutputNotSupported", 
		NULL, "Audio or Audio Outputs are not supported by the device");
}

int __trt__GetGuaranteedNumberOfVideoEncoderInstances(struct soap *soap, 
		struct _trt__GetGuaranteedNumberOfVideoEncoderInstances *trt__GetGuaranteedNumberOfVideoEncoderInstances, 
		struct _trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse *trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse)
{	
    /* Return incomplete response with default data values */
	int vsIdx = 1;
    static int cnt_mp4 = 0;
    static int cnt_mjp = 0;
    static int cnt_264 = 0;
    int i = 0;
    //Acti_VideoEncoderConfig *p = NULL;
   
	vsIdx = GetVsIdxFmConfigToken(trt__GetGuaranteedNumberOfVideoEncoderInstances->ConfigurationToken);
    cnt_mp4 = 0;
    cnt_mjp = 0;
    cnt_264 = 0;
    for(i = 0 ; i < MAX_VE_LIST ; i ++) {
		if((gOnvifConf.veConf[i].valid == 1) && (gOnvifConf.veConf[i].videoSrc == vsIdx)) {
	    	//p = &gOnvifConf.veConf[i];
			if(gOnvifConf.veConf[i].Encoding == H264) {
				cnt_264 ++;
				/*
				fprintf(stdout, "%d,H264:veConf[%d] %s,%s,%d,%d,%d,%d,%dx%d,%d\n", cnt_264, i,
				p->token, p->Name, p->needSaved, p->videoSrc, p->videoSrcInProfile,
				p->UseCount, p->r.Width, p->r.Height, p->rc.FrameRateLimit);
				*/
	    	} else if(gOnvifConf.veConf[i].Encoding == MPEG4) {
				cnt_mp4 ++;
				/*
				fprintf(stdout, "%d,MPEG:veConf[%d] %s,%s,%d,%d,%d,%d,%dx%d,%d\n", cnt_mp4, i,
                        p->token, p->Name, p->needSaved, p->videoSrc, p->videoSrcInProfile,
                        p->UseCount, p->r.Width, p->r.Height, p->rc.FrameRateLimit);
				*/
	    	} else if(gOnvifConf.veConf[i].Encoding == JPEG) {
				cnt_mjp ++;
				/*
				fprintf(stdout, "%d,JPEG:veConf[%d] %s,%s,%d,%d,%d,%d,%dx%d,%d\n", cnt_mjp, i,
                        p->token, p->Name, p->needSaved, p->videoSrc, p->videoSrcInProfile,
                        p->UseCount, p->r.Width, p->r.Height, p->rc.FrameRateLimit);
				*/
	    	}
		}
    }
    trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse->TotalNumber = cnt_mp4 + cnt_mjp + cnt_264;
    trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse->JPEG  = &cnt_mjp;
    trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse->MPEG4 = &cnt_mp4;
    trt__GetGuaranteedNumberOfVideoEncoderInstancesResponse->H264  = &cnt_264;
    return SOAP_OK;
}

static int OnvifGetRtspPort(int *portRtsp) {
    char ReplyMsg[512];
    char value[32];
    int  port = 7070;
    int  i = 0;
    
    for(i = 0 ; i < 2 ; i ++) {
        if(OnvifSingleUrlCmdSend("system", "V2_PORT_RTSP", ReplyMsg, (sizeof(ReplyMsg)-1)) > 0) {
            if(OnvifGetValueFmUrlReply(ReplyMsg, "V2_PORT_RTSP", value, (sizeof(value)-1)) > 0) {
                port = atoi(value);
                if((port > 0) && (port < 65535)) {
                    *portRtsp = port;
                    return OK;
                }
                fprintf(stderr, "%s:error. invalid RTSP port %d from %s\n", __func__, port, value);
            } else fprintf(stderr, "%s:error. parser V2_PORT_RTSP fm %s\n", __func__, ReplyMsg);
        } else fprintf(stderr, "%s:error. send V2_PORT_RTSP\n", __func__);
        usleep(500000);
    }
    return ERR;
}
static void OnvifBtirateToString(int rate, char *strBitrate, int maxLen) {
    int q = 0;
    int r = 0;

    if(rate < 1000) { /* kbps level */
        snprintf(strBitrate, maxLen, "%dK", rate);
    } else {    /* mbps level */
        q = rate / 1000;
        r = (rate % 1000) / 100;
        if(r) snprintf(strBitrate, maxLen, "%d.%dM", q, r);
        else  snprintf(strBitrate, maxLen, "%dM", q);
    }
}
int __trt__GetStreamUri (struct soap *soap, struct _trt__GetStreamUri *trt__GetStreamUri,
					 struct _trt__GetStreamUriResponse *trt__GetStreamUriResponse)
{
    int i;
    int channel = 1;
    int portRtsp = 7070;
    int protocolErr = 0;
    Acti_MediaProfile       *profile = NULL;
    Acti_VideoEncoderConfig *VeConfPtr = NULL;
    char ReplyMsg[512];
    char cmd[256];
    int  cmdLen = 0;
    char strBitrate[8];

    L4("is called\n");
    if ((trt__GetStreamUri->ProfileToken == NULL) || (trt__GetStreamUri->StreamSetup == NULL) ||
	(trt__GetStreamUri->StreamSetup->Transport == NULL)) {
	L1("error, ProfileToken, StreamSetup or Transport is NULL\n");
	return SOAP_REQUIRED;
    }
    /* Get Media Profile*/
    if (FindMediaProfile (soap, trt__GetStreamUri->ProfileToken, &i) == ERR) {
	return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
					     "The requested profile token ProfileToken does not exist.");
    }
    fprintf(stdout, "%s: profile[%d] token=%s\n", __func__, i, trt__GetStreamUri->ProfileToken);
    profile = &gOnvifConf.profile[i];
    if((profile->vsIdx >= 0) && (profile->vsIdx < MAX_VS_LIST)) channel = profile->vsIdx + 1;
    else {
        L1("error. invalid vsIdx in profile[%d]\n", profile->vsIdx, i);
        channel = 1;
    }
    /* force the audio format to G711U if the device has audio function */
    if(gOnvifConf.AudioEnable == true_) {
        for(i = 0 ; i < 2 ; i ++) {
            if(OnvifSingleUrlCmdSend("system", "AUDIO_IN_FORMAT=G711U&V2_AUDIO_ENABLED=1", ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
                L1("error. send AUDIO_IN_FORMAT=G711U&V2_AUDIO_ENABLED=1, i=%d\n", i);
                usleep(500000);
            } else break;
        }
    }
    /* Get RTSP port number */
    (void)OnvifGetRtspPort(&portRtsp);
    /* Get Stream Uri */
    trt__GetStreamUriResponse->MediaUri = (struct tt__MediaUri *) soap_malloc (soap, sizeof (struct tt__MediaUri));
    soap_default_tt__MediaUri (soap, trt__GetStreamUriResponse->MediaUri);
    trt__GetStreamUriResponse->MediaUri->InvalidAfterConnect = true_;
    trt__GetStreamUriResponse->MediaUri->InvalidAfterReboot = false_;
    trt__GetStreamUriResponse->MediaUri->Timeout = "PT0S";

    switch (trt__GetStreamUri->StreamSetup->Stream) {
	case RTP_Unicast:
            switch (trt__GetStreamUri->StreamSetup->Transport->Protocol) {
                case UDP:
                case RTSP:
                case TCP:
                    snprintf (gOnvifConf.StreamUri, sizeof(gOnvifConf.StreamUri), "rtsp://%s:%d/onvif-stream%d", 
                              gOnvifConf.CurrentIP, portRtsp, channel);
                    break;
                case HTTP:
                    snprintf (gOnvifConf.StreamUri, sizeof (gOnvifConf.StreamUri), "http://%s:%d/onvif-stream%d", 
                          gOnvifConf.CurrentIP, gOnvifConf.HttpPort, channel);
                    break;
                default:
                    L1("error, unknown unicast protocol %d\n", trt__GetStreamUri->StreamSetup->Transport->Protocol);
                    protocolErr = 1;
            }
            break;
        case RTP_Multicast:
            L4("multicasting request\n");
            if (trt__GetStreamUri->StreamSetup->Transport->Protocol == UDP) {
                /* now, the RTSP library does not care of streaming mode to support the multicast RTP */
                VeConfPtr = &gOnvifConf.veConf[profile->veIdx];
                if(VeConfPtr->valid == 1) { 
                    snprintf(cmd, sizeof(cmd), "CHANNEL=%d&V2_MULTICAST_IP=%s&V2_PORT_RTP_MULTI_VIDEO=%d&VIDEO_MULTICAST_TTL=%d&V2_STREAMING_METHOD=0",
                              channel,VeConfPtr->Multicast.IPv4Address, VeConfPtr->Multicast.Port, VeConfPtr->Multicast.TTL);
                } else {
                    snprintf(cmd, sizeof(cmd), "V2_STREAMING_METHOD=0");
                }
                          
                /* change to streaming mode 0 for RTP multicasting */
                if(OnvifSingleUrlCmdSend("system", cmd, ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
                    L1("error. send %s\n", cmd);
                } else L4("send %s\n", cmd);
                
                if(OnvifSingleUrlCmdSend("encoder", "RTP_MULTICAST_STREAMING=PAUSE", ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
                    L1("error. send encoder?RTP_MULTICAST_STREAMING=PAUSE\n");
                } else L4("send encoder?RTP_MULTICAST_STREAMING=PAUSE\n");
                
                snprintf (gOnvifConf.StreamUri, sizeof (gOnvifConf.StreamUri), "rtsp://%s:%d/multicast/onvif-stream%d", 
                          gOnvifConf.CurrentIP, portRtsp, channel); 
            } else {
                L1("error, not udp in mcast %d\n", trt__GetStreamUri->StreamSetup->Transport->Protocol);
                protocolErr = 1;
            }
			break;
		default:
            L1("error, unknown casting %d\n", trt__GetStreamUri->StreamSetup->Stream);
            protocolErr = 1;
    }
    if(protocolErr) {
        return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:InvalidStreamSetup", NULL,
                                             "Specification of StreamType or Transport part in StreamSetup is not supported.");
    }
    trt__GetStreamUriResponse->MediaUri->Uri = (char *)&gOnvifConf.StreamUri;
    
    if((profile->veIdx >= 0) && (profile->veIdx < MAX_VE_LIST)) {
        VeConfPtr = &gOnvifConf.veConf[profile->veIdx];
        if(VeConfPtr->valid == 1) { 
            /* set encoder type based on this profile settings */
            if(VeConfPtr->Encoding==JPEG) {
                cmdLen += snprintf(&cmd[cmdLen], (sizeof(cmd)-cmdLen-1),
                         "CHANNEL=%d&VIDEO_ENCODER=MJPEG&VIDEO_MJPEG_QUALITY=%d",
                         channel, VeConfPtr->Quality);
            } else {
                cmdLen += snprintf(&cmd[cmdLen], (sizeof(cmd)-cmdLen-1),
                          "CHANNEL=%d&VIDEO_ENCODER=%s&VIDEO_GOP=%d",
                          channel,
                          (VeConfPtr->Encoding==H264)?"H264&VIDEO_H264_QUALITY=NONE":"MPEG4&VIDEO_MPEG4_QUALITY=NONE",
                          (VeConfPtr->Encoding==H264)?VeConfPtr->t.H264.GovLength:VeConfPtr->t.MPEG4.GovLength);
            }
            /* set the video resolutions */
            cmdLen += snprintf(&cmd[cmdLen], (sizeof(cmd)-cmdLen), "&VIDEO_RESOLUTION=%c%dx%d",
			       (gOnvifConf.tv == ONVIF_PAL)?'P':'N', VeConfPtr->r.Width,
			       (VeConfPtr->r.Height==1072)?1080:VeConfPtr->r.Height);
            /* set the fps, bitrate and quality */
            OnvifBtirateToString(VeConfPtr->rc.BitrateLimit, strBitrate, (sizeof(strBitrate)-1));
            cmdLen += snprintf(&cmd[cmdLen], (sizeof(cmd)-cmdLen),
                     "&VIDEO_FPS_NUM=%d&VIDEO_MAX_BITRATE=UNLIMITED&VIDEO_BITRATE=%s",
                     VeConfPtr->rc.FrameRateLimit, strBitrate);
            for(i = 0 ; i < 2 ; i ++) {
                if(OnvifSingleUrlCmdSend("encoder", cmd, ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
                    fprintf(stderr, "%s:error, send %s\n", __func__, cmd);
                    usleep(500000);
                } else {
                    L4("sent %s\n", cmd);
                    break;
                }
            }
        }
    }
    L4("uri: %s\n", trt__GetStreamUriResponse->MediaUri->Uri);
	return SOAP_OK;
}

int __trt__StartMulticastStreaming(struct soap *soap, struct _trt__StartMulticastStreaming *trt__StartMulticastStreaming, 
								   struct _trt__StartMulticastStreamingResponse *trt__StartMulticastStreamingResponse)
{	
	int idx = 0;
    int channel = 1;
    int hasAudio = 0;
    int i = 0;
	char ReplyMsg[512];
    char buf[512];
    int  len = 0;
    char strBitrate[8];
	Acti_VideoEncoderConfig *veConf = NULL;
	
	if (FindMediaProfile (soap, trt__StartMulticastStreaming->ProfileToken, &idx) != OK) {
		return soap_sender_fault_subcode_v2 (soap, 
											 "ter:InvalidArgVal", "ter:NoProfile", NULL,
											 "The requested profile token ProfileToken does not exist.");
	}
    channel = gOnvifConf.profile[idx].vsIdx + 1;
    if((channel < 1) || (channel > 2)) L1("error, invalid video source idx %d\n", gOnvifConf.profile[idx].vsIdx);
    if((gOnvifConf.profile[idx].veIdx >= 0) && (gOnvifConf.profile[idx].veIdx < MAX_VE_LIST)) {
        veConf = &gOnvifConf.veConf[gOnvifConf.profile[idx].veIdx];
        if(veConf->valid == 1) { /* valid video encoder configuration in this profile */
            goto StartMulticastStreamingNext;
        }
        L1( "error, video encoder configuration is not valid for profile %s (%d)\n",
            trt__StartMulticastStreaming->ProfileToken, idx);
    } else { /* there is not valid video encoder configuration associated with this profile */
        L1( "error, invalid video encoder index %d in profile %s (%d)\n",
            gOnvifConf.profile[idx].veIdx, trt__StartMulticastStreaming->ProfileToken, idx);
    }
    return SOAP_ERR;
    
StartMulticastStreamingNext:

    /* check if audio in function is enabled */
    if(OnvifSingleUrlCmdSend("system", "V2_AUDIO_ENABLED", ReplyMsg, (sizeof(ReplyMsg)-1)) >= 0){
        if(OnvifGetValueFmUrlReply(ReplyMsg, "V2_AUDIO_ENABLED=", buf, (sizeof(buf)-1)) > 0) {
            hasAudio = atoi(buf);
            if(hasAudio != 1) hasAudio = 0;
        }
    }
    len = snprintf(buf, sizeof(buf), "CHANNEL=%d&V2_MULTICAST_IP=%s&V2_PORT_RTP_MULTI_VIDEO=%d&VIDEO_MULTICAST_TTL=%d",
                   channel, veConf->Multicast.IPv4Address, veConf->Multicast.Port, veConf->Multicast.TTL);
    /* set the multicast configuration to the camera */
    if(hasAudio) { /* multicast configurations are from audio encoder configuration to pass Onvif test */
        /* set the audio multicast address */
        if((gOnvifConf.aeConf.UseCount > 0) && (strlen(gOnvifConf.aeConf.Multicast.IPv4Address) > 0)) {
            snprintf(gRtspAudioMcastIP, sizeof(gRtspAudioMcastIP), "%s", gOnvifConf.aeConf.Multicast.IPv4Address);
            L4("@@@@ update audio multicast address %s\n", gRtspAudioMcastIP);
        }
        for(i = 0 ; i < 2 ; i ++) {
            if(OnvifSingleUrlCmdSend("system", "AUDIO_IN_FORMAT=G711U", ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
                L1("error, send AUDIO_IN_FORMAT=G711U\n");
                usleep(500000);
            } else {
                L4("send AUDIO_IN_FORMAT=G711U done\n");
                break;
            }
        }
        /* set the multicast configurations for audio rtp streaming */
        len += snprintf(&buf[len], sizeof(buf)-len, "&V2_PORT_RTP_MULTI_AUDIO=%d", gOnvifConf.aeConf.Multicast.Port);     
    }
    for(i = 0 ; i < 2 ; i ++) {
        if(OnvifSingleUrlCmdSend("system", buf, ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
            L1("error, send %s\n", buf);
            usleep(500000);
        } else {
            L4("send %s done\n", buf);
            sleep(1);
            break;
        }
    }
    len = 0;
    /* set the video encoder configurations */
    if(veConf->Encoding==JPEG) {
        len += snprintf(&buf[len], (sizeof(buf)-len),
                        "CHANNEL=%d&VIDEO_ENCODER=MJPEG&VIDEO_MJPEG_QUALITY=%d", channel, veConf->Quality);
    } else {
        len += snprintf(&buf[len], (sizeof(buf)-len),
                        "CHANNEL=%d&VIDEO_ENCODER=%s&VIDEO_GOP=%d",
                        channel,
                        (veConf->Encoding==H264)?"H264&VIDEO_H264_QUALITY=NONE":"MPEG4&VIDEO_MPEG4_QUALITY=NONE",
                        (veConf->Encoding==H264)?veConf->t.H264.GovLength:veConf->t.MPEG4.GovLength);
    }
    /* set the video resolutions */
    len += snprintf(&buf[len], (sizeof(buf)-len), "&VIDEO_RESOLUTION=%c%dx%d",
                    (gOnvifConf.tv == ONVIF_PAL)?'P':'N', veConf->r.Width,
		    (veConf->r.Height==1072)?1080:veConf->r.Height);
    /* set the fps, bitrate and quality */
    OnvifBtirateToString(veConf->rc.BitrateLimit, strBitrate, (sizeof(strBitrate)-1));
    len += snprintf(&buf[len], (sizeof(buf)-len),
                    "&VIDEO_FPS_NUM=%d&VIDEO_MAX_BITRATE=UNLIMITED&VIDEO_BITRATE=%s", veConf->rc.FrameRateLimit, strBitrate);
    for(i = 0 ; i < 2 ; i ++) {
        if(OnvifSingleUrlCmdSend("encoder", buf, ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
            fprintf(stderr, "%s:error, send %s\n", __func__, buf);
            usleep(500000);
        } else {
            L4("sent %s\n", buf);
            break;
        }
    }
    /* start the multicasting streaming */
    for(i = 0 ; i < 2 ; i ++) {
        if(OnvifSingleUrlCmdSend("system", "V2_STREAMING_METHOD=4", ReplyMsg, (sizeof(ReplyMsg)-1)) <= 0) {
            L1("error, send V2_STREAMING_METHOD=4, %d\n", i);
            usleep(500000);
        } else {
            L4("send V2_STREAMING_METHOD=4 done\n");
            break;
        }
    }
    return SOAP_OK;
}

int __trt__StopMulticastStreaming(struct soap *soap, struct _trt__StopMulticastStreaming *trt__StopMulticastStreaming, struct _trt__StopMulticastStreamingResponse *trt__StopMulticastStreamingResponse)
{
    char retMsg[512];
    int  idx = 0;
    int  i = 0;
    
	if (FindMediaProfile (soap, trt__StopMulticastStreaming->ProfileToken, &idx) != OK) {
		return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
                                             "The requested profile token ProfileToken does not exist.");
	}
    gRtspAudioMcastIP[0]='\0';
    for(i = 0 ; i < 2 ; i ++) {
        if(OnvifSingleUrlCmdSend("system", "V2_STREAMING_METHOD=0", retMsg, (sizeof(retMsg)-1)) <= 0) {
            L1("error, send V2_STREAMING_METHOD=0\n");
            usleep(500000);
        } else {
            L4("send V2_STREAMING_METHOD=0 done\n");
            break;
        }
    }
    /*
    sleep(2);
    if(OnvifSingleUrlCmdSend("encoder", "RTP_MULTICAST_STREAMING=PAUSE", retMsg, (sizeof(retMsg)-1)) <= 0) {
        L1("error, send RTP_MULTICAST_STREAMING=PAUSE\n");
    } else L4("send RTP_MULTICAST_STREAMING=PAUSE done\n");
    sleep(2);
    */
	return SOAP_OK;
}

int __trt__SetSynchronizationPoint(struct soap *soap, struct _trt__SetSynchronizationPoint *trt__SetSynchronizationPoint, struct _trt__SetSynchronizationPointResponse *trt__SetSynchronizationPointResponse)
{	
	if((soap->header) && (soap->header->wsa__Action.__item != NULL))
	{
		strcpy(soap->header->wsa__Action.__item, "http://www.onvif.org/ver10/events/wsdl/PullPointSubscription/SetSynchronizationPointResponse");
	}
	return SOAP_OK;
}

int __trt__GetSnapshotUri (struct soap *soap, struct _trt__GetSnapshotUri *trt__GetSnapshotUri,
					   struct _trt__GetSnapshotUriResponse *trt__GetSnapshotUriResponse)
{
    int idx;

    if((trt__GetSnapshotUri->ProfileToken != NULL) && (strlen(trt__GetSnapshotUri->ProfileToken) != 0)) {
	if (FindMediaProfile (soap, trt__GetSnapshotUri->ProfileToken, &idx) == OK) {
	    trt__GetSnapshotUriResponse->MediaUri =
		(struct tt__MediaUri *) soap_malloc (soap, sizeof (struct tt__MediaUri));
	    soap_default_tt__MediaUri (soap, trt__GetSnapshotUriResponse->MediaUri);
	    sprintf (gOnvifConf.SnapshotUri, "http://%s/cgi-bin/encoder?USER=%s&PWD=%s&SNAPSHOT=%c%dx%d,%d",
		     gOnvifConf.CurrentIP, gOnvifConf.root, gOnvifConf.passwd,
		     (gOnvifConf.tv == ONVIF_NTSC ? 'N' : 'P'),
		     gOnvifConf.veConf[gOnvifConf.profile[idx].veIdx].r.Width,
		     (gOnvifConf.veConf[gOnvifConf.profile[idx].veIdx].r.Height==1072)?1080:gOnvifConf.veConf[gOnvifConf.profile[idx].veIdx].r.Height,
		     (int) gOnvifConf.veConf[gOnvifConf.profile[idx].veIdx].Quality);
	} else return soap_sender_fault_subcode_v2 (soap, "ter:InvalidArgVal", "ter:NoProfile", NULL,
						    "The media profile does not exist.");
    } else {
	trt__GetSnapshotUriResponse->MediaUri =
	    (struct tt__MediaUri *) soap_malloc (soap, sizeof (struct tt__MediaUri));
	soap_default_tt__MediaUri (soap, trt__GetSnapshotUriResponse->MediaUri);
	sprintf (gOnvifConf.SnapshotUri, "http://%s/cgi-bin/encoder?USER=%s&PWD=%s&SNAPSHOT",
		 gOnvifConf.CurrentIP, gOnvifConf.root, gOnvifConf.passwd);
    }
    trt__GetSnapshotUriResponse->MediaUri->Uri = gOnvifConf.SnapshotUri;
    trt__GetSnapshotUriResponse->MediaUri->InvalidAfterConnect = true_;
    trt__GetSnapshotUriResponse->MediaUri->InvalidAfterReboot = false_;
    trt__GetSnapshotUriResponse->MediaUri->Timeout = "PT0S";
    return SOAP_OK;
}

int CheckHttpAuthority (struct soap *soap)
{
	if (soap->userid && soap->passwd) {/* Basic authentication: we may want to reject this since the password was sent in the clear */
		if (!strcmp (soap->userid, gOnvifConf.root)
			&& !strcmp (soap->passwd, gOnvifConf.passwd))
			return SOAP_OK;
	}
#if HAVE_SOAP_HTTP_DA
	else if (soap->authrealm && soap->userid) {
		/* simulate database lookup on userid to find passwd */
		if (!strcmp (soap->authrealm, authrealm) && !strcmp (soap->userid, gOnvifConf.root)) {

			if (!http_da_verify_post (soap, gOnvifConf.passwd))
				return SOAP_OK;
		}
	}
#endif
	soap->authrealm = authrealm;
	return SOAP_ERR;			/* Not authorized, challenge digest authentication with httpda plugin */

}

int CheckAccessClass (const char *soap_tag) 
{
	int i = 0; 
	char *p = NULL;

	p = strchr(soap_tag, ':');
	if(p == NULL) p = (char *)soap_tag;
	else p ++;

	for (i = 0; i < (sizeof (AccessNotRequiredAuthList)/4) ; i++) 
	{
		if (strcasecmp (AccessNotRequiredAuthList[i], p) == 0)
		{
			return ACCESS_NOT_REQUIRED_AUTH; 
		}
	}	
	return ACCESS_REQUIRED_AUTH; 
}
int Security_header_verify(struct soap *soap)
{
	const char *username = soap_wsse_get_Username(soap);

	if(!username || strcmp(username, gOnvifConf.root)) {
		soap_wsse_delete_Security(soap);
		return soap_wsse_fault(soap, wsse__FailedAuthentication, "Authentication required");
//		return soap_sender_fault_subcode(soap, "ter:NotAuthorized", "Sender not authorized", 
//	"The action requested requires authorization and the sender is not authorized.");
	}

	//check password and timestamp!!
	if (soap_wsse_verify_Timestamp(soap)
			|| soap_wsse_verify_Password(soap, gOnvifConf.passwd))
	{
		return soap->error;
	}
//	soap_wsse_add_Timestamp(soap, "Time", 10);  /* lifetime of 10 seconds */
//	soap_wsse_add_UsernameTokenDigest(soap, "Root", gOnvifConf.root, gOnvifConf.passwd);
	return SOAP_OK;
}

/* ---- Client-side one-way unicast/multicast  ---- */
void DiscoveryMulticast_Hello (void)
{
	struct soap soap;
	struct SOAP_ENV__Header header;
	struct d__HelloType hello;
	struct wsa__EndpointReferenceType replyTo;
	struct wsa__AttributedURIType addr;
	struct d__ScopesType helloScope;
	int offset = 0;
	int i;

	if (gOnvifConf.DiscoveryMode == NonDiscoverable) return; /* do nothing if it is not discoverable */

	L4("send discovery hello(mcast)\n");; 

	soap_init (&soap);
	soap_set_namespaces (&soap, wdnamespaces);
	soap.connect_flags = SO_BROADCAST;
	soap.send_timeout = 1;		// 1s timeout
	soap_default_SOAP_ENV__Header (&soap, &header);
	soap.header = &header;
	header.wsa__MessageID.__item = (char *) soap_malloc (&soap, MAX_UUID_LEN);
	if (header.wsa__MessageID.__item == 0)
		goto DESTROY_SOAP;
		//return;
	GenerateUUiD (header.wsa__MessageID.__item);
	header.wsa__To.__item = "urn:schemas-xmlsoap-org:ws:2005:04:discovery";
	header.wsa__Action.__item = "http://schemas.xmlsoap.org/ws/2005/04/discovery/Hello";
	// AppSequence
	gOnvifConf.AppSequence.MessageNumber++;
	header.d__AppSequence = &gOnvifConf.AppSequence;
	soap_default_d__HelloType (&soap, &hello);
	soap_default_wsa__EndpointReferenceType (&soap, &replyTo);
	hello.wsa__EndpointReference = &replyTo;
	soap_default_wsa__AttributedURIType (&soap, &addr);
	replyTo.Address = &addr;
	addr.__item = gOnvifConf.EndpointAddr;
	hello.Types = ONVIF_DEVICE_TYPE;
	soap_default_d__ScopesType (&soap, &helloScope);
	hello.Scopes = &helloScope;
	helloScope.__item = (char *) soap_malloc (&soap, MAX_SCOPES_STRLEN);
	for (i = 0; i < gOnvifConf.Scopes.size; i++) {
		offset += sprintf (&helloScope.__item[offset], "%s  ", gOnvifConf.Scopes.Ptr[i]);
	}
	hello.XAddrs = gOnvifConf.MediaXAddr;
	hello.MetadataVersion = gOnvifConf.MetaDataVerion;
	if (soap_call___d__Hello (&soap, "soap.udp://239.255.255.250:3702", NULL, &hello, NULL)) {
		soap_print_fault (&soap, stderr);
	}
DESTROY_SOAP:
	soap_destroy (&soap);		// cleanup
	soap_end (&soap);			// cleanup
	soap_done (&soap);			// close connection (should not use soap struct after this)
#ifdef HAVE_ONVIF_DEBUG
	L4 ("onvif:destroyed hello.\n"); 
#endif
	return;	
}

void DiscoveryMulticast_Bye (void)
{
	struct soap soap;
	struct SOAP_ENV__Header header;
	struct d__ByeType bye;
	struct wsa__EndpointReferenceType replyTo;
	struct wsa__AttributedURIType addr;

#ifdef HAVE_ONVIF_DEBUG
	L4 ("onvif:send mcast bye.\n"); 
#endif
	if (gOnvifConf.DiscoveryMode ==  NonDiscoverable) return; /* do nothing if it is not discoverable */

	soap_init (&soap);
	soap_set_namespaces (&soap, wdnamespaces);
	soap.connect_flags = SO_BROADCAST;
	soap.send_timeout = 1;		// 1s timeout
	soap_default_SOAP_ENV__Header (&soap, &header);
	soap.header = &header;
	header.wsa__MessageID.__item = (char *) soap_malloc (&soap, MAX_UUID_LEN);
	if (header.wsa__MessageID.__item == 0) goto DESTROY_SOAP;

	GenerateUUiD (header.wsa__MessageID.__item);
	header.wsa__To.__item = "urn:schemas-xmlsoap-org:ws:2005:04:discovery";
	header.wsa__Action.__item = "http://schemas.xmlsoap.org/ws/2005/04/discovery/Bye";
	
	gOnvifConf.AppSequence.MessageNumber++;
	header.d__AppSequence = &gOnvifConf.AppSequence;
	soap_default_d__ByeType (&soap, &bye);
	soap_default_wsa__EndpointReferenceType (&soap, &replyTo);
	bye.wsa__EndpointReference = &replyTo;
	soap_default_wsa__AttributedURIType (&soap, &addr);
	replyTo.Address = &addr;
	addr.__item = gOnvifConf.EndpointAddr;
	bye.Types = ONVIF_DEVICE_TYPE;
	bye.Scopes = NULL;
	bye.XAddrs = NULL;
	bye.MetadataVersion = NULL;
	if (soap_call___d__Bye (&soap, "soap.udp://239.255.255.250:3702", NULL, &bye, NULL))
		soap_print_fault (&soap, stderr);
DESTROY_SOAP:
	soap_destroy (&soap);		// cleanup
	soap_end (&soap);			// cleanup
	soap_done (&soap);			// close connection (should not use soap struct after this)
#ifdef HAVE_ONVIF_DEBUG
	L4 ("onvif:destroyed bye.\n"); 
#endif
	return;
}

static int ScopesValidation (char *pBegin) 
{
	char *p1 = NULL;
	char *p2 = NULL;
	int i = 0; 
	int matched = 0;
	int leave = 0;

	p1 = strstr (pBegin, Scope_Scheme_Authority);
    if(p1 == NULL) return SOAP_ERR;
    do {
        p2 = strchr (p1, ' ');
        if(p2) {
            *p2 = '\0';
            do {
                if(*(p2+1) == '\0') {
                    leave = 1;  
                    break;
                } else if(*(p2+1) == ' ') {
                    p2 ++;
                } else break;
            } while(1);
        } else {
            leave = 1; /* this is the last one */
        }
        matched = 0;
        for (i = 0; i < gOnvifConf.Scopes.size ; i++) {
            if (strncmp (gOnvifConf.Scopes.Ptr[i], p1, strlen(p1)) == 0) matched = 1;
        }
        if(matched == 0) return SOAP_ERR;
        if(leave == 0) {
            p1 = p2 + 1;
        } else break;
    } while(1);
    return SOAP_OK;
}
/* Client-side request-response unicast */

/* Server-side */
#define MAX_LEN_RCVMSG 		2048	//read length
#define MAX_LEN_WRTMSG 		3072	//write length
void *DiscoveryUnicastThread (void *arg)
{
	struct timeval 	tout;
    fd_set         	RxFd;
	int		sock = -1;
	struct sockaddr_in addr;
	char 		buf[MAX_LEN_RCVMSG];  
	char 		wbuf[MAX_LEN_WRTMSG]; 
	int 		i = 0;
	int		    offset = 0;
    static char RelatesTo_uuid[MAX_UUID_LEN];
    static char MessageID_uuid[MAX_UUID_LEN];
	char 		Scopes[MAX_SCOPES_STRLEN]; 
	int 		wlen = 0;
	char 		tmpbuf [1024]; 
	char 		*pBegin = NULL;
	char 		*pEnd = NULL;
	char 		*pEnd1 = NULL;
	char 		*pEnd2 = NULL;
	char 		*pNext = NULL;
	int         len = 0;
    int         ReplyInvalidMatchRule = 0;
    int         probe_pkt = 0;

	pthread_detach(pthread_self());

	gOnvifConf.state = ONVIF_STATE_RUN;

#if MEMORY_LEAK_TEST
	MemAllocTableInit();
#endif

	L1("entered\n");
	
	if (UdpSockCreate(&sock) == OK) {
		if (SockBind(sock, NULL, 3702) != 0) {
			close(sock);
			L1("fail to bind port 3702\n");
			goto DiscoveryUnicastThreadErr;
		}
	} else {
		L1("fail to create an UDP sock. %d (%s)\n", errno, strerror(errno)); 	
        goto DiscoveryUnicastThreadErr;
	}
	/* ###### set some socket options ##### */
	/* add the multicast IP address to this socket */
	if(SockOptMcastIPSet(sock, NULL, "239.255.255.250") == ERR) {
		L1("fail to add 239.255.255.250\n");
	}
	(void)SockOptTtlSet(sock, 8);
	(void)SockOptReuseAddrSet(sock, SOCK_OPT_ENABLE);
	
	while (gOnvifConf.state == ONVIF_STATE_RUN) 
	{
		FD_ZERO(&RxFd);
		tout.tv_sec  = 1;
		tout.tv_usec = 0;
		FD_SET(sock, &RxFd);
		len = 0;
        ReplyInvalidMatchRule = 0;
	    switch(select(sock+1, &RxFd, (fd_set *)0, (fd_set *)0, &tout)) 
		{
			case 0: /* timeout */
				break;
			case 1:
				if(FD_ISSET(sock, &RxFd)) {
					len = UdpSockBlockRead(sock, (unsigned char *)buf, sizeof(buf)-1, &addr); 
					if (len > 0) {
						buf [len] = '\0';
					} else {
						L1("socket error. %d, %s\n", errno, strerror(errno)); 
					}
				}
	            break;
			default: /* select error */
				L1("select error, %d, %s\n", errno, strerror(errno));
	   }
	   if(len > 0) {
            //L3("rx packet %dB from %s\n", len, inet_ntoa(addr.sin_addr));
            //printf("buf: %s\n", buf);
			if(gOnvifConf.DiscoveryMode == NonDiscoverable) continue; /* do nothing if it is non-discoverable */
            
            if(strstr(buf, "Envelope") == NULL) {
                L1("error. not found Envelope\n");
                continue; /* not found Envelope */
            }
			if(strstr(buf, "Header") == NULL) {
                L1("error. not found Header\n");
                continue; /* not found Header */
            }
			pBegin = strstr (buf, "uuid:");
			if (pBegin == NULL) {
                L1("error. not found uuid\n");
                continue; /* not found uuid */
            }
			/* get the uuid setting */
			pEnd = strstr (pBegin, "<");
			if (pEnd == NULL) continue; /* not found uuid terminator */
			strncpy (RelatesTo_uuid, pBegin, pEnd - pBegin);
			RelatesTo_uuid[pEnd - pBegin] = '\0';
			/* parser message body */
			pBegin = strstr (pEnd, "Body");
			if (pBegin == NULL) {
                L1("error. not found Body\n");
                continue; /* not found Body */
            }
			pBegin += strlen("Body");
            
            if(strstr(pBegin, "ProbeMatch"))  probe_pkt = 0;
            else if(strstr(pBegin, "Probe"))   probe_pkt = 1;
            else                              probe_pkt = 0;
            if(probe_pkt == 0) {
                /* find Types element */
                pNext= strstr (pBegin, "Types");
                if(pNext == NULL) {
                    L1("error. not found Types\n");
                    continue; /* not found Types */
                }
                pNext += strlen("Types");
                pEnd1 = strchr(pNext, '>');
                if(pEnd1) {
                    if(*(pEnd1-1) == '/') { /* Types terminator is <Types .... /> or <prefix:Types    /> */
                        pEnd = pEnd1 - 1; /* pEnd points to "/" position */
                        pNext ++; /* pNext points to the next character of "Types " */
                    } else { /* Types terminator is </Types> or </prefix:Types> */
                        pEnd2 = strstr(pEnd1, "</");
                        if(pEnd2) {
                            pEnd = pEnd2; /* pEnd points to the "<" */
                            pNext = pEnd1 + 1; /* pNext points to the next character of "<...Types ..>" */
                        } else {
                            L1("error. not found Types terminator 1\n");
                            continue;
                        }
                    }
                } else {
                    L1("error. not found Types terminator 2\n");
                    continue;
                }
                if((pNext+1) == pEnd) {
                    L4("Types is NULL\n");
                } else { /* check types */
                    *pEnd = '\0';
                    if (strstr(pNext, "NetworkVideoTransmitter") == NULL) {
                        //printf("Types mismatch %s\n", pNext);
                        continue;
                    }
                    //L1("Types matches %s\n", pNext);
                }
                /* find Scopes, Scopes in the Probe is an option */
            }
            pBegin = pEnd + 2;
			pNext = strstr(pBegin, "Scopes");
                if(pNext) {
                pBegin = pNext + strlen("Scopes");
                pNext = strstr(pBegin, "MatchBy=");
                if(pNext) {
                    //printf("found MatchBy in Scopes\n");
                    pNext += strlen("MatchBy=");
                    if(strstr(pNext, "InvalidMatchRule")) {
                        //printf("found InvalidMatchRule\n");
                        ReplyInvalidMatchRule = 1;
                        goto ProbeReply;
                    }
                    pBegin = pNext;
                } /* no MatchBy in the Scopes */
                pEnd1 = strstr(pBegin, "/>");
                pEnd2 = strstr(pBegin, "</");
                if((pEnd1 == NULL) && (pEnd2 == NULL)) {
                    L1("error. not found Scope terminator 1\n");
                    continue; /* not found Scope terminator */
                }
                if(pEnd1 && pEnd2) {
                    if(pEnd1 < pEnd2) { /* found <PREFIX:Scopes /> or <Scopes /> */
                        pEnd = pEnd1;
                    } else { /* found </PREFIX:Scopes> or </Scopes> */
                        if(strstr(pEnd2, "Scopes") == NULL) {
                            L1("error. not found Scope terminator 2\n");
                            continue; /* not found Scope terminator */
                        }
                        pEnd = pEnd2;
                        pNext = strchr(pBegin, '>');
                        if((pNext == NULL) || (pNext >= pEnd)) {
                            L1("error. not found Scope terminator 3\n");
                            continue; /* not found Scope pair */
                        }
                        pBegin = pNext + 1;
                    }
                } else if(pEnd1) { /* found found <PREFIX:Scopes /> or <Scopes /> */
                    pEnd = pEnd1;
                } else { /* found </PREFIX:Scopes> or </Scopes> */
                    if(strstr(pEnd2, "Scopes") == NULL) {
                        L1("error. not found Scope terminator 4\n");
                        continue; /* not found Scope terminator */
                    }
                    pEnd = pEnd2;
                    pNext = strchr(pBegin, '>');
                    if((pNext == NULL) || (pNext >= pEnd)) {
                        L1("error. not found Scope terminator 5\n");
                        continue; /* not found Types pair */
                    }
                    pBegin = pNext + 1;
                }
                while(*pBegin == ' ') pBegin ++;
                while((pEnd > pBegin) && (*(pEnd-1) == ' ')) pEnd --;
                if(pEnd > pBegin) { /* got scope strings */
                    snprintf (tmpbuf, (pEnd-pBegin)+1, "%s", pBegin);
                    /* validate the scopes */
                    if (ScopesValidation (tmpbuf) == SOAP_ERR) {
                        L1("error. Scope mismatches %s\n", tmpbuf);
                        continue;
                    }
                }
            }
ProbeReply:
			/* ######  prepare the probe reply packet ##### */
			offset = 0;
			for (i = 0; i < gOnvifConf.Scopes.size; i++) {
				offset += snprintf(&Scopes[offset], (sizeof(Scopes)), "%s  ", gOnvifConf.Scopes.Ptr[i]);
				if(offset >= sizeof(Scopes)) {
					L1 ("%s: Error. out of memory for Scopes %d\n", __func__, offset);
					break;
				}
			}
			gOnvifConf.AppSequence.InstanceId = time (NULL);
			GenerateUUiD((char *)MessageID_uuid);
            if(ReplyInvalidMatchRule == 0) {
                wlen = snprintf (wbuf, MAX_LEN_WRTMSG, 
                                 "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
                                 "<SOAP-ENV:Envelope "
                                    "xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\" "
                                    "xmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\" "
                                    "xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" "
                                    "xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" "
                                    "xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\">"
                                    "<SOAP-ENV:Header>"
                                        "<wsa:MessageID>%s</wsa:MessageID>"
                                        "<wsa:RelatesTo>%s</wsa:RelatesTo>"
                                        "<wsa:To SOAP-ENV:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous</wsa:To>"
                                        "<wsa:Action SOAP-ENV:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches</wsa:Action>"
                                        "<d:AppSequence SOAP-ENV:mustUnderstand=\"true\" MessageNumber=\"%d\" InstanceId=\"%u\"></d:AppSequence>"
                                        "<SubscriptionId>%d</SubscriptionId>"
                                    "</SOAP-ENV:Header>"
                                    "<SOAP-ENV:Body>"
                                        "<d:ProbeMatches>"
                                            "<d:ProbeMatch>"
                                                "<wsa:EndpointReference>"
                                                    "<wsa:Address>%s</wsa:Address>"
                                                "</wsa:EndpointReference>"
                                                "<d:Types>%s</d:Types>"
                                                "<d:Scopes>%s</d:Scopes>"
                                                "<d:XAddrs>%s</d:XAddrs>"
                                                "<d:MetadataVersion>1</d:MetadataVersion>"
                                            "</d:ProbeMatch>"
                                        "</d:ProbeMatches>"
                                    "</SOAP-ENV:Body>"
                                "</SOAP-ENV:Envelope>",
                                MessageID_uuid,
                                RelatesTo_uuid,
                                gOnvifConf.AppSequence.MessageNumber++,
                                gOnvifConf.AppSequence.InstanceId/*InstanceId*/,
                                0/*SubscriptionId*/,
                                gOnvifConf.EndpointAddr,
                                ONVIF_DEVICE_TYPE, 
                                Scopes, 
                                gOnvifConf.MediaXAddr);
            } else {
                wlen = snprintf (wbuf, MAX_LEN_WRTMSG, 
                                 "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
                                 "<SOAP-ENV:Envelope "
                                    "xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\" "
                                    "xmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\" "
                                    "xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" "
                                    "xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" "
                                    "xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\">"
                                    "<SOAP-ENV:Header>"
                                        "<wsa:RelatesTo>%s</wsa:RelatesTo>"
                                        "<wsa:To SOAP-ENV:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous</wsa:To>"
                                        "<wsa:Action>http://schemas.xmlsoap.org/ws/2004/08/addressing/fault</wsa:Action>"
                                    "</SOAP-ENV:Header>"
                                    "<SOAP-ENV:Body>"
                                        "<SOAP-ENV:Fault>"
                                            "<SOAP-ENV:Code>"
                                                "<SOAP-ENV:Value>SOAP-ENV:Sender</SOAP-ENV:Value>"
                                                "<SOAP-ENV:Subcode>"
                                                    "<SOAP-ENV:Value>d:MatchingRuleNotSupported</SOAP-ENV:Value>"
                                                "</SOAP-ENV:Subcode>"
                                            "</SOAP-ENV:Code>"
                                            "<SOAP-ENV:Reason>"
                                                "<SOAP-ENV:Text xml:lang=\"en\">the matching rule specified is not supported </SOAP-ENV:Text>"
                                            "</SOAP-ENV:Reason>"
                                            "<SOAP-ENV:Detail>"
                                                "<d:SupportedMatchingRules>"
                                                    "http://schemas.xmlsoap.org/ws/2005/04/discovery/rfc3986"
                                                "</d:SupportedMatchingRules>"
                                            "</SOAP-ENV:Detail>"
                                        "</SOAP-ENV:Fault>"
                                    "</SOAP-ENV:Body>"
                                "</SOAP-ENV:Envelope>",
                                RelatesTo_uuid);
            }
			len = sendto(sock, (char *)wbuf, wlen, 0, (struct sockaddr *)&addr, SOCK_ADDR_SIZE);	
			if(len != wlen) {
				L1("error. send probe reply. %d/%d. %d, %s\n", len, wlen, errno, strerror(errno));
			}
		}
	}
	close (sock);

DiscoveryUnicastThreadErr:
	gOnvifConf.state = ONVIF_STATE_CLOSE;
	L2 ("Leave\n");
	pthread_exit (NULL);
	return NULL;
}

static void OnvifDumpEventThreadState(int cnt, int *scription) {
	int i = 0;

	L1("dump active event threads (%d) ", cnt);
	for(i = 0 ; i < MAX_EVENT_SCRIPTION_NUM ; i ++) {
		if(scription[i]) printf("%d=%d,", i, gOnvifConf.scription[i].state);
	}
	printf("\n");
}
int OnvifDiscoveryThreadClose (void)
{
	int i = 0;
	int cnt = 0;
	int scription[MAX_EVENT_SCRIPTION_NUM];

	for (i = 0; i < MAX_EVENT_SCRIPTION_NUM; i++) {
		if (gOnvifConf.scription[i].state == ONVIF_STATE_RUN) {
			gOnvifConf.scription[i].state = ONVIF_STATE_STOP;
			scription[i] = 1;
			cnt ++;
		} else scription[i] = 0;
	}

	DiscoveryMulticast_Bye();

	// Stop the Discovery Thread
	if (gOnvifConf.state == ONVIF_STATE_RUN) gOnvifConf.state = ONVIF_STATE_STOP;
	else L1("Warning, the Discovery Thread is not running\n");

	if(cnt > 0) {
#ifdef HAVE_ONVIF_DEBUG
		OnvifDumpEventThreadState(cnt, scription);
#endif
		/* wait for all event threads were left */
		for(i = 0 ; i < 50 ; i++) {
			cnt = 0;
			if(scription[i]) {
				if(gOnvifConf.scription[0].state == ONVIF_STATE_CLOSE) scription[i] = 0;
			} else cnt ++;
			if(cnt == 0) goto CheckDiscoveryThread;
			usleep(100*1000);
		}
		L1("Error. %d event threads are not closed\n", cnt);
		OnvifDumpEventThreadState(cnt, scription);
	}

CheckDiscoveryThread:
	for(i = 0 ; i < 50 ; i++) {
		if((gOnvifConf.state == ONVIF_STATE_CLOSE) || (gOnvifConf.state == ONVIF_STATE_INIT)) {
			return OK;
		}
		usleep(100*1000);
	}
	L1 ("Error, the Discovery Thread is not left.\n");
	return ERR;
}
/*
static int VSTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf) {
    int id = 1;

    if (strncmp (e->name, "SOURCE_TOKEN", 12) == 0) {
	id = atoi (e->name + 12);
	if((id >= 1) && (id <= gOnvifConf.numStreams)) {
	    sscanf (e->data, "%31[^,],%d,%d,%d", 
		    conf->SourceToken[id - 1].Token, &conf->SourceToken[id - 1].FrameRate, 
		    &conf->SourceToken[id - 1].res.Width, &conf->SourceToken[id - 1].res.Height); 
	    if (conf->SourceTokenCnt < id) conf->SourceTokenCnt = id;
	}
	return OK;
    }
    return ERR;
}
*/
/*
static int VSConfTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf) {
    int id = 0;
    int UseCount = 0;

    if(strncmp (e->name, "VIDEO_SOURCE", 12) == 0) {
	id = atoi (e->name + 12);
	if((id >= 1) && (id <= gOnvifConf.numStreams)) {
	    sscanf(e->data, "%31[^,],%31[^,],%d,%d,%d,%d,%d,%d",
		   conf->vsConf[id - 1].token, conf->vsConf[id - 1].Name, &conf->vsConf[id - 1].SourceTokenIdx,
		   &UseCount, &conf->vsConf[id - 1].b.x, &conf->vsConf[id - 1].b.y,
		   &conf->vsConf[id - 1].b.width, &conf->vsConf[id - 1].b.height);
	    if(conf->VsCnt < id) conf->VsCnt = id;
	    if(UseCount > conf->vsConf[id - 1].UseCount) conf->vsConf[id - 1].UseCount = UseCount;
	}
	return OK;
    }
    return ERR;
}
*/
static int VEConfTxt2Bin(tOnvifConfEntry *e, tOnvifConf * conf) {
    int id;
    int encoding, gov, ProfileType, boolean;
    Acti_VideoEncoderConfig enc;

    if(strncmp (e->name, "V2_VIDEO_ENCODER", strlen("V2_VIDEO_ENCODER")) == 0) {
	id = atoi (e->name + strlen("V2_VIDEO_ENCODER"));
	if((id >= 1) && (id <= MAX_VE_LIST)) {
	    memset((void *)&enc, 0, sizeof(enc));
	    if(sscanf (e->data, "%31[^,],%31[^,],%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%31s",
		       enc.token, enc.Name, &enc.videoSrc, &enc.UseCount, &encoding,
		       &enc.r.Width, &enc.r.Height, &enc.Quality,
		       &enc.rc.FrameRateLimit, &enc.rc.EncodingInterval,
		       &enc.rc.BitrateLimit, &gov, &ProfileType, &boolean,
		       enc.SessionTimeout) == 15) {
			   enc.rc.EncodingInterval = 1;
		OnvifPatch1080PResolutionForTK(&enc.r.Height);
		enc.Encoding = (enum tt__VideoEncoding) encoding;
		if(enc.Encoding == H264) {
		    enc.t.H264.GovLength = gov;
		    enc.t.H264.H264Profile = (enum tt__H264Profile) ProfileType;
		} else if(enc.Encoding == MPEG4) {
		    enc.t.MPEG4.GovLength = gov;
		    enc.t.MPEG4.Mpeg4Profile = (enum tt__Mpeg4Profile) ProfileType;
		}
		enc.Multicast.AutoStart = (enum xsd__boolean) boolean;
		if((enc.videoSrc >= 1) && (enc.videoSrc <= gOnvifConf.numStreams)) {
		    enc.needSaved = 1;
		    enc.videoSrcInProfile = -1;
		    enc.valid = 1;
		    memcpy((void *)&conf->veConf[id-1], (void *)&enc, sizeof(Acti_VideoEncoderConfig));
		}
	    } else L1("error, read %s='%s'\n", e->name, e->data);
	}
	return OK;
    }
    return ERR;
}

static int ProfileConfTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf) {
    int id;
    int readOnly;
    int num, meIdx = 0;
    Acti_MediaProfile profile;

    if(strncmp(e->name, "MEDIA_PROFILE", 13) == 0) {
	id = atoi (e->name + 13);
	if((id >= 1) && (id <= MAX_PROFILE_LIST)) {
	    memset((void *)&profile, 0, sizeof(Acti_MediaProfile));
	    num = sscanf(e->data, "%d,%31[^,],%31[^,],%d,%d,%d",
			 &readOnly, profile.token, profile.Name, &profile.vsIdx, &profile.veIdx, &meIdx);
	    if(num >= 4) {
		profile.readOnly = (unsigned short) readOnly;
		if( ((profile.veIdx >= 0) && (profile.veIdx < MAX_VE_LIST)) &&
		    ((profile.vsIdx >= 0) && (profile.vsIdx < gOnvifConf.numStreams)) &&
		    (conf->veConf[profile.veIdx].valid == 1) &&
		    (((conf->veConf[profile.veIdx].Encoding == JPEG) && (gOnvifConf.MJPEG_Enable == true_)) ||
		    ((conf->veConf[profile.veIdx].Encoding == MPEG4) && (gOnvifConf.MPEG4_Enable == true_)) ||
		    ((conf->veConf[profile.veIdx].Encoding == H264) && (gOnvifConf.H264_Enable == true_))) ) {
		    profile.valid = 1;
		    memcpy((void *)&conf->profile[id-1], (void *)&profile, sizeof(Acti_MediaProfile));
		    gOnvifConf.ProfileCnt++; 
		}
	    } else L1("error, read %s='%s'\n", e->name, e->data);
	}
	return OK;
    }
    return ERR;
}
/*
static int EventConfTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf)
{
	int id;
	int Topic, Msg, NotifyMsg;
	long BeginTime, TerminationTime;

	if (strncmp (e->name, "EVENT_CONF", 10) == 0) {
		id = atoi (e->name + 10);
		if (id < 1 || id > MAX_EVENT_SCRIPTION_NUM)
			return ERR;
		sscanf (e->data, "%d,%d,%d,%d,%d,%ld,%ld,%256[^,],%d",
			&conf->scription[id-1].enable, &conf->scription[id-1].SubscriptionId, 
			&conf->scription[id-1].state,
			&Topic, &Msg,
			&BeginTime, &TerminationTime, 
			conf->scription[id-1].NotifyServer, &NotifyMsg);
		conf->scription[id-1].SubscriptionId = id;
		conf->scription[id-1].Topic = (enum EventTopic) Topic;
		conf->scription[id-1].Msg = (enum MsgContent) Msg;
		conf->scription[id-1].BeginTime = (time_t) BeginTime;
		conf->scription[id-1].TerminationTime = (time_t) TerminationTime;
		conf->scription[id-1].NotifyMsg = (enum MsgContent) NotifyMsg;
		return OK;
	}
	return ERR;

}
*/
static int VE_McastTxt2Bin (tOnvifConfEntry *e, tOnvifConf *conf)  {
    int id = 0; 

    if (strncmp (e->name, "VE_MCAST", 8) != 0) 	return ERR;
    id = atoi (e->name + 8);
    if ((id >= 1) && (id <= MAX_VE_LIST)) {
	sscanf (e->data, "%d,%16[^,],%d,%d", 
		(int *) &conf->veConf[id-1].Multicast.Type,
		conf->veConf[id-1].Multicast.IPv4Address, 
		(int *) &conf->veConf[id-1].Multicast.Port,
		(int *) &conf->veConf[id-1].Multicast.TTL);
    }
    return OK;
}

static int AE_McastTxt2Bin (tOnvifConfEntry *e, tOnvifConf *conf) {

    if (strncmp (e->name, "AE_MCAST", 8) != 0) 	return ERR;
    sscanf (e->data, "%d,%16[^,],%d,%d,%d", 
	    (int *) &conf->aeConf.Multicast.Type,
	    conf->aeConf.Multicast.IPv4Address, 
	    (int *) &conf->aeConf.Multicast.Port,
	    (int *) &conf->aeConf.Multicast.TTL,
	    (int *) &conf->aeConf.Multicast.AutoStart);
    return OK;
}

static int IMGConfTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf)
{
	int i; 
	if (strncmp (e->name, "IMAGING", 7) != 0) 	return ERR;
	i = atoi (e->name + 7);
	if (i < 1 || i > MAX_VS_LIST)
		return ERR;
	sscanf (e->data, 
		"%d,%f,%f,%f,%f,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%d,%f,%d,%f,%d,%f,%f", 
		(int *) &conf->SourceToken[i-1].img.BLCMode, 
		(float *) &conf->SourceToken[i-1].img.BLCLevel, 
		(float *) &conf->SourceToken[i-1].img.Brightness, 
		(float *) &conf->SourceToken[i-1].img.ColorSaturation, 
		(float *) &conf->SourceToken[i-1].img.Contrast, 
		(int *) &conf->SourceToken[i-1].img.ExposureMode, 
		(int *) &conf->SourceToken[i-1].img.ExposurePriority, 
		(float *) &conf->SourceToken[i-1].img.ExposureWindowBottom, 
		(float *) &conf->SourceToken[i-1].img.ExposureWindowTop, 
		(float *) &conf->SourceToken[i-1].img.ExposureWindowRight, 
		(float *) &conf->SourceToken[i-1].img.ExposureWindowLeft, 
		(float *) &conf->SourceToken[i-1].img.MinExposureTime, 
		(float *) &conf->SourceToken[i-1].img.MaxExposureTime, 
		(float *) &conf->SourceToken[i-1].img.MinGain, 
		(float *) &conf->SourceToken[i-1].img.MaxGain, 
		(float *) &conf->SourceToken[i-1].img.MinIris, 
		(float *) &conf->SourceToken[i-1].img.MaxIris, 
		(float *) &conf->SourceToken[i-1].img.ExposureTime, 
		(float *) &conf->SourceToken[i-1].img.Gain, 
		(float *) &conf->SourceToken[i-1].img.Iris, 
		(int *) &conf->SourceToken[i-1].img.AutoFocusMode, 
		(float *) &conf->SourceToken[i-1].img.DefaultSpeed, 
		(float *) &conf->SourceToken[i-1].img.NearLimit, 
		(float *) &conf->SourceToken[i-1].img.FarLimit, 
		(int *) &conf->SourceToken[i-1].img.IrCutFilter, 
		(float *) &conf->SourceToken[i-1].img.Sharpness, 
		(int *) &conf->SourceToken[i-1].img.WDRMode, 
		(float *) &conf->SourceToken[i-1].img.WDRLevel, 
		(int *) &conf->SourceToken[i-1].img.WhiteBalanceMode, 
		(float *) &conf->SourceToken[i-1].img.CrGain, 
		(float *) &conf->SourceToken[i-1].img.CbGain);
	return OK;
}

static int PTZConfigsTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf)
{
	if (strncmp (e->name, "PTZ_CONFIGS", 11) != 0) 		return ERR;
	//sscanf (e->data, "%32[^,],%32[^,],%32[^,],%96[^,],%f,%f,%96[^,],%f,%f,%f,%f,%d,%96[^,],%96[^,],%96[^,],%96[^,],%f,%f,%96[^,],%f,%s",
	sscanf (e->data, "%32[^,],%32[^,],%32[^,],%f,%f,%f,%f,%f,%f,%d,%f,%f,%f",
		conf->PTZConfig.Token,
		conf->PTZConfig.Name,
		conf->PTZConfig.NodeToken,
		//conf->PTZConfig.ZoomLimits.Range->URI,
		(float *) &conf->PTZConfig.MinZoomLimits,
		(float *) &conf->PTZConfig.MaxZoomLimits,
		//conf->PTZConfig.PanTiltLimits.Range->URI,
		(float *) &conf->PTZConfig.MinPanLimits, 
		(float *) &conf->PTZConfig.MaxPanLimits, 
		(float *) &conf->PTZConfig.MinTiltLimits, 
		(float *) &conf->PTZConfig.MaxTiltLimits, 
		(int *) &conf->PTZConfig.PTZ_timeout,
		//conf->PTZConfig.AbsolutePantTiltPositionSpace,
		//conf->PTZConfig.AbsoluteZoomPositionSpace,	
		//conf->PTZConfig.ContinuousPanTiltVelocitySpace,
		//conf->PTZConfig.ContinuousZoomVelocitySpace,
		(float *) &conf->PTZConfig.PanDefaultSpeed,
		(float *) &conf->PTZConfig.TiltDefaultSpeed,
		//conf->PTZConfig.DefaultPTZSpeed.PanTilt->space,
		(float *) &conf->PTZConfig.ZoomDefaultSpeed//,
		//conf->PTZConfig.DefaultPTZSpeed.Zoom->space); 
		); 
	return OK;
}

/// Bottom of Winters ///
static int ScopeConfTxt2Bin (tOnvifConfEntry * e, tOnvifConf * conf, int *seek)
{
	int attr;
	char strBuff[64];

	if (strcmp (e->name, "SCOPES") == 0) {
		if(*seek == SEEK_SET) {//Cathy: string buffer offset must go back to start pointer
			conf->Scopes.tStr[0] = '\0';
			conf->Scopes.DifinStr[0] = '\0';
			*seek = SEEK_CUR;
		}

//      strncpy(conf->Scopes.tStr, e->data, MAX_SCOPES_STRLEN);
//      conf->Scopes.tStr[MAX_SCOPES_STRLEN-1] = '\0';
		sscanf (e->data, "%d,%63[^,]\n", &attr, strBuff);
		if (strlen (strBuff) > 0) {
			sprintf (&conf->Scopes.tStr[strlen (conf->Scopes.tStr)], "%s  ", strBuff);
			sprintf (&conf->Scopes.DifinStr[strlen (conf->Scopes.DifinStr)], "%d,", attr);
		}
	} else if (strcmp (e->name, "SCOPE_ATTR") == 0) {
		strncpy (conf->Scopes.DifinStr, e->data, sizeof (conf->Scopes.DifinStr));
		conf->Scopes.DifinStr[sizeof (conf->Scopes.DifinStr) - 1] = '\0';
	} else {
		return ERR;
	}
	return OK;
}

static void checkUseCountOfConfigs()
{
    int i = 0;
    Acti_MediaProfile *profile = NULL;

    for (i = 0; i < MAX_VS_LIST; i++) gOnvifConf.vsConf[i].UseCount = 0;
    for (i = 0; i < MAX_VE_LIST; i++) gOnvifConf.veConf[i].UseCount = 0;

    for (i = 0; i < MAX_PROFILE_LIST; i++) {
	profile = &gOnvifConf.profile[i];
	if(profile->valid == 1) {
	    if((profile->vsIdx >= 0) && (profile->vsIdx < MAX_VS_LIST)) {
		gOnvifConf.vsConf[profile->vsIdx].UseCount++;
	    }
	    if((profile->veIdx >= 0) && (profile->veIdx < MAX_VE_LIST)) {
		gOnvifConf.veConf[profile->veIdx].UseCount++;
		gOnvifConf.veConf[profile->veIdx].videoSrcInProfile = profile->vsIdx + 1;
	    }
        }
    }
}

static int OnvifDevConfEntryGet(char *buf, tOnvifConfEntry *entry) {
	int n = 0;

	/* not parser the string if the first byte is #, \r, \n */
	if((buf[0] == '#') || (buf[0] == 0x0d) || (buf[0] == 0x0a)) return ERR;
	/* parset the string */
	/* refer to Config.h: 
 	 * 	#define CONF_NAME_LEN           32
 	 * 	#define CONF_DATA_LEN           128
 	 */
	//w: n = sscanf(buf, "%31[^'=']='%255[^''']'", entry->name, entry->data);
	n = sscanf(buf, "%31[^'=']='%319[^''']'", entry->name, entry->data);
	if(n == 2) return OK;
	if(n == 1) { /* no setting in this configuration */
		entry->data[0] = '\0';
		return OK;
	}
	/* unknowm configuration entry!! */
	return ERR_VALUE;
}

static int OnvifDevConfReadFmTxtFile(char *name, tOnvifDevConf *conf) {
	FILE *fp = NULL;
	char buf[ONVIF_CONF_ENTRY_LEN];

	/* open the file first */
	conf->len = 0;
	/* read the configuration file */
	fp = fopen(name, "rb");
	if(fp != NULL) {
		/* success in openning the configuration file */
		while(fgets(buf, ONVIF_CONF_ENTRY_LEN, fp) != NULL) {
			switch(OnvifDevConfEntryGet(buf, &conf->entry[conf->len])) {
				case OK:
					conf->len ++;
					break;
				case ERR_VALUE:
					L1("Error. parser %s", buf);
					break;
			}
		}
		fclose(fp);
		return OK;
	}
	/* fail to open the configuration file, return error */
	L2 ("%s file is not exist\n", name);
	return ERR;
}

static int Str2UlBaseGet(char *str) {

	if(strncasecmp("0x", str, 2) == 0) return 16;
	return 10;
}

static int OnvifConfEntryTxt2BinI32(tOnvifConfEntry *e, char *name, int *data) {
	int base = 0;

	if(strcmp(e->name, name)) return 0;
	base = Str2UlBaseGet(e->data);
	*data = (int)strtoul(e->data, NULL, base);
	return 1;
}

static int OnvifConfFile2Bin (char *filename) {
    int i = 0;
    tOnvifConf *conf = &gOnvifConf;
    tOnvifDevConf TConf;
    int key = 0;
    int seek = SEEK_SET; //Cathy

    if (OnvifDevConfReadFmTxtFile (filename, &TConf) != OK) return ERR;
    /* success in reading the text configuration file to the conf. Parser the string
     * data in conf to get the device configurations and set them to DevConf data
     * structure. */
    gOnvifConf.ProfileCnt = 0;
    if(TConf.len > 0) {
        /* the first entry should be KEY='' */
        (void)OnvifConfEntryTxt2BinI32 (&TConf.entry[0], "KEY", &key);
        if(key < 1000) {
            /* old onvif configuration, not use this conf file. discard it */
            fprintf(stdout, "[Onvif.%s]:warning, old conf file, not use it, %s='%s'\n",
                                    __func__, TConf.entry[0].name, TConf.entry[0].data);
            return OK;
        }
    } else return OK; /* invalid onvif confifuration file */
    
    for (i = 1; i < TConf.len; i++) {
        if (OnvifConfEntryTxt2BinI32 (&TConf.entry[i], "DNS_FROM_DHCP", &conf->DnsFromDHCP))  continue;
	if (OnvifConfEntryTxt2BinI32 (&TConf.entry[i], "VIDEO_TV", &conf->tv))  continue;
	if (OnvifConfEntryTxt2BinI32 (&TConf.entry[i], "DISCOVERY_MODE", &conf->DiscoveryMode)) continue;
	if (OnvifConfEntryTxt2BinI32 (&TConf.entry[i], "METADATAVERSION", &conf->MetaDataVerion))  continue;
	if (OnvifConfEntryTxt2BinI32 (&TConf.entry[i], "SCOPE_LOCATION_COUNT", &conf->Scopes.location_count))  continue;
	if (ScopeConfTxt2Bin (&TConf.entry[i], conf, &seek) == OK) continue;
	//if (VSTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	//if (VSConfTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	if (VEConfTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	if (ProfileConfTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	//if (EventConfTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	if (PTZConfigsTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	if (VE_McastTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	if (AE_McastTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
	if (IMGConfTxt2Bin (&TConf.entry[i], conf) == OK)  continue;
    }
    if(conf->ProfileCnt == 0)   CreateMediaProfiles ();
    //Check UseCount of vsconf, veConf
    checkUseCountOfConfigs();
    //Scope Count
    gOnvifConf.Scopes.size = GenerateScope (gOnvifConf.Scopes.tStr);
    if (gOnvifConf.Scopes.size == 0) L1 ("Oops! Failure occurs: No Scope Items\n");
    //L4("Discovery Mode = %s\n", (conf->DiscoveryMode == Discoverable)?"discoverable":"non-discoverable");
    return OK;
}

static int ParserSpaceToken(char *dst, char *src, int srcsize, int bufsize)
{
	char *Org = src;
	if((src == NULL) || (dst == NULL) || (srcsize == 0) || (bufsize == 0))
		return ERR;
	
	while((*src != '\0') && ((Org-src) <= bufsize)){
		if(*src == ' ') {
			strcpy(dst, "%20");
			dst = dst+3;
		}else{
			*dst = *src;
			dst++;
		}
		src++;
	}
	*dst = '\0';

	return OK;	
}



static void ScopeDefaultConf (void)
{
    char HW[ONVIF_MODELNAME_LEN];
    char CN[MAX_CONF_NAME_LEN+ONVIF_MODELNAME_LEN+4];  //Add 4 for space
    int ret_HW = ERR;
    int ret_CN = ERR;

    
    ret_HW = ParserSpaceToken(HW, gOnvifConf.ModelName, strlen(gOnvifConf.ModelName), ONVIF_MODELNAME_LEN);
    ret_CN = ParserSpaceToken(CN, gOnvifConf.companyName, strlen(gOnvifConf.companyName), MAX_CONF_NAME_LEN);
    if(ret_HW == ERR)	strcpy(HW, "NoModelName");
    if(ret_CN == ERR)	strcpy(CN, "NoCompanyName");
    strcat(CN, "%20");
    strcat(CN, HW);

	if(gOnvifConf.AudioEnable == true_)
	{
		snprintf(gOnvifConf.Scopes.tStr, MAX_SCOPES_STRLEN,
			 "onvif://www.onvif.org/type/video_encoder  "
			 "onvif://www.onvif.org/type/audio_encoder  "
			 "onvif://www.onvif.org/hardware/%s  "
			 "onvif://www.onvif.org/name/%s  " 
			 "onvif://www.onvif.org/location/  "
			 "onvif://www.onvif.org/Profile/Streaming", HW, CN);
    		sprintf (gOnvifConf.Scopes.DifinStr, "%d,%d,%d,%d,%d,%d,", Fixed, Fixed, Fixed, Fixed, Fixed, Configurable);
	}else{
		snprintf(gOnvifConf.Scopes.tStr, MAX_SCOPES_STRLEN,
			 "onvif://www.onvif.org/type/video_encoder  "
			 "onvif://www.onvif.org/hardware/%s  "
			 "onvif://www.onvif.org/name/%s  " 
			 "onvif://www.onvif.org/location/  "
			 "onvif://www.onvif.org/Profile/Streaming", HW, CN);
    		sprintf (gOnvifConf.Scopes.DifinStr, "%d,%d,%d,%d,%d,", Fixed, Fixed, Fixed, Fixed, Configurable);
	}
    gOnvifConf.Scopes.size = GenerateScope (gOnvifConf.Scopes.tStr);
    gOnvifConf.Scopes.location_count = 1;
}

static void PTZTokenDefault (void)
{
	int i=0;

	for(i=0; i<MAX_PROFILE_LIST; i++) gOnvifConf.PTZ_AddToken[i] = false_;
}

static void AudioSourceDefault (void)
{
	int i=0;

	for(i=0; i<MAX_PROFILE_LIST; i++)      gOnvifConf.ASToken[i] = false_;
}

static void AudioEncoderDefault (void)
{
	int i=0;

	for(i=0; i<MAX_PROFILE_LIST; i++)  gOnvifConf.AEToken[i] = false_;
}
static void EventScriptionDefault (void)
{
    int i;
    struct timeval tv;
    int  dioStatus = 0xff; /* all DIs are '1' by default */

    for(i = 0 ; i < ONVIF_MOTION_WINDOWS; i ++) {
        gOnvifConf.MDCurrentState[i].state = 0;
    }
    for(i = 0 ; i < MAX_DI_NUM ; i ++) {
        gOnvifConf.DICurrentState[i].state = ((dioStatus & (0x01 << i)) != 0);
    }
	gettimeofday(&tv, NULL);
	for (i = 0; i < MAX_EVENT_SCRIPTION_NUM; i++) {
		gOnvifConf.scription[i].enable = false_;
		gOnvifConf.scription[i].SubscriptionId = i+1;
		gOnvifConf.scription[i].state = ONVIF_STATE_CLOSE;
		gOnvifConf.scription[i].Topic = EVENT_TOPIC_ALL;
		gOnvifConf.scription[i].Msg = EVENT_MSG_ALL;
		gOnvifConf.scription[i].BeginTime = tv.tv_sec;
		gOnvifConf.scription[i].TerminationTime = tv.tv_sec;
		gOnvifConf.scription[i].NotifyServer[0] = '\0';
	}
}
/* 
 * TPL: This function would be called by external function when TV standard changed (media.c).
 */
int DecideVideoSourceVideoEncoder (void) {

    /* Media default VideoSource */
    CreateVideoSources ();
    /* Media Configuration: VideoSourceConfigurations */
    CreateVideoSourceConfigs ();
    /* Media Configuration: VideoEncoderConfigurations */
    CreateVideoEncoderConfigs ();
    return OK;
}

static void OnvifDefaultConf (void) {
	
    /* GetDiscoveryMode :defalut */
    gOnvifConf.DiscoveryMode = Discoverable;
    gOnvifConf.MetaDataVerion = 1;
    PTZTokenDefault ();
    AudioSourceDefault ();
    AudioEncoderDefault ();
    /* Discovery */
    ScopeDefaultConf ();
    /* VideoSources, VideoSourceConfig, VideoEncoderConfig */
    DecideVideoSourceVideoEncoder ();
    CreateMetaDataConfig ();
    /* Media Configuration: Profile */
    CreateMediaProfiles ();
    EventScriptionDefault(); 
}

int OnvifConfigChange()
{
/// Top of 20130223 ///
	if (gOnvifConf.state == ONVIF_STATE_CLOSE)
		config_change = false_;
/// Bottom of 20130223 ///
	return config_change;
}

int OnvifRootAccountChange(char *Name, char *Pwd)
{
	if((Name == NULL) || (Pwd == NULL))
	{
		L1("Name or Pwd is NULL\n");
		return ERR;
	}

	if((strlen(Name) > ONVIF_ACCOUNT_NAME_LEN-1) || (strlen(Pwd) > ONVIF_ACCOUNT_PWD_LEN-1))
	{
		L1("the length of Name or Pwd is too long");
		return ERR;
	}

	strcpy(gOnvifConf.root, Name);
	strcpy(gOnvifConf.passwd, Pwd);
	return OK;
}

int OnvifConfBin2File(char *filename) {
    FILE *fp = NULL;
    int i;
    tOnvifConf *conf = &gOnvifConf;

    if (config_change != true_) {
        //L1("config_change is not true_ (%d), not update %s\n", config_change, filename);
        return OK;
    }
    if (gOnvifConf.state != ONVIF_STATE_RUN) {
        //L1("onvif is not running (%d), not update %s\n", gOnvifConf.state, filename);
		config_change = false_;
        return OK; 
    }
	config_change = false_;
    /* open the configuration file */
    fp = fopen (filename, "wb");
    if (fp) {
	/* success in openning the configuration file. write the configuration to
	 * this file now */
        fprintf (fp, "KEY='1000'\n");
        fprintf (fp, "DNS_FROM_DHCP='%d'\n", conf->DnsFromDHCP);
		fprintf (fp, "DISCOVERY_MODE='%d'\n", conf->DiscoveryMode);
		fprintf (fp, "METADATAVERSION='%d'\n", conf->MetaDataVerion);
	#if 0
	fprintf (fp, "VIDEO_TV='%d'\n", gOnvifConf.tv);
	for (i = 0; i < conf->SourceTokenCnt; i++) {
	    fprintf (fp, "SOURCE_TOKEN%d='%s,%d,%d,%d'\n", i + 1, conf->SourceToken[i].Token,
		     conf->SourceToken[i].FrameRate, conf->SourceToken[i].res.Width, conf->SourceToken[i].res.Height);
	}
	for (i = 0; i < MAX_VS_LIST; i++) {
	    fprintf (fp, "VIDEO_SOURCE%d='%s,%s,%d,%d,%d,%d,%d,%d'\n", i + 1, conf->vsConf[i].token,
		     conf->vsConf[i].Name, conf->vsConf[i].SourceTokenIdx, conf->vsConf[i].UseCount,
		     conf->vsConf[i].b.x, conf->vsConf[i].b.y, conf->vsConf[i].b.width, conf->vsConf[i].b.height);
	}
	#endif
	for (i = 0; i < MAX_VE_LIST; i++) {
            if((conf->veConf[i].valid == 1) && (conf->veConf[i].needSaved == 1)) {
                fprintf (fp, "V2_VIDEO_ENCODER%d='%s,%s,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s'\n",
			 i+1, conf->veConf[i].token, conf->veConf[i].Name,
			 conf->veConf[i].videoSrc, conf->veConf[i].UseCount, conf->veConf[i].Encoding,
                         conf->veConf[i].r.Width, conf->veConf[i].r.Height, conf->veConf[i].Quality,
                         conf->veConf[i].rc.FrameRateLimit, conf->veConf[i].rc.EncodingInterval,
                         conf->veConf[i].rc.BitrateLimit,
			 (conf->veConf[i].Encoding==H264)?conf->veConf[i].t.H264.GovLength:conf->veConf[i].t.MPEG4.GovLength,
			 (conf->veConf[i].Encoding==H264)?conf->veConf[i].t.H264.H264Profile:conf->veConf[i].t.MPEG4.Mpeg4Profile,
			 conf->veConf[i].Multicast.AutoStart, conf->veConf[i].SessionTimeout);
		/*
		fprintf (stdout, "%s:V2_VIDEO_ENCODER%d='%s,%s,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%s'\n", __func__,
                         i+1, conf->veConf[i].token, conf->veConf[i].Name,
                         conf->veConf[i].videoSrc, conf->veConf[i].UseCount, conf->veConf[i].Encoding,
                         conf->veConf[i].r.Width, conf->veConf[i].r.Height, conf->veConf[i].Quality,
                         conf->veConf[i].rc.FrameRateLimit, conf->veConf[i].rc.EncodingInterval,
                         conf->veConf[i].rc.BitrateLimit,
                         (conf->veConf[i].Encoding==H264)?conf->veConf[i].t.H264.GovLength:conf->veConf[i].t.MPEG4.GovLength,
                         (conf->veConf[i].Encoding==H264)?conf->veConf[i].t.H264.H264Profile:conf->veConf[i].t.MPEG4.Mpeg4Profile,
                         conf->veConf[i].Multicast.AutoStart, conf->veConf[i].SessionTimeout);
		*/
            }
	}
	for (i = 0; i < MAX_VE_LIST; i++) {
            if(conf->veConf[i].valid == 1) {
                fprintf (fp, "VE_MCAST%d='%d,%s,%d,%d'\n", i + 1, 
			 IPv4_,
			 conf->veConf[i].Multicast.IPv4Address, 
			 conf->veConf[i].Multicast.Port,
			 conf->veConf[i].Multicast.TTL);
            }
	}
	fprintf (fp, "AE_MCAST%d='%d,%s,%d,%d'\n", 
		 1, 
		 conf->aeConf.Multicast.Type,
		 conf->aeConf.Multicast.IPv4Address, 
		 conf->aeConf.Multicast.Port,
		 conf->aeConf.Multicast.TTL);

	for (i = 0; i < MAX_PROFILE_LIST; i++) {
	    if (conf->profile[i].valid == 1) {
		fprintf (fp, "MEDIA_PROFILE%d='%d,%s,%s,%d,%d,0'\n",
			 i+1, conf->profile[i].readOnly,
			 conf->profile[i].token, conf->profile[i].Name, conf->profile[i].vsIdx, 
			 conf->profile[i].veIdx);
	    }
	}
	/*
	for (i = 0; i < MAX_EVENT_SCRIPTION_NUM; i++) {
	    fprintf (fp, "EVENT_CONF%d='%d,%d,%d,%d,%d,%ld,%ld,%s,%d'\n", i + 1, conf->scription[i].enable,
		     conf->scription[i].SubscriptionId, conf->scription[i].state,
		     conf->scription[i].Topic, conf->scription[i].Msg,
		     conf->scription[i].BeginTime, conf->scription[i].TerminationTime, 
		     conf->scription[i].NotifyServer, conf->scription[i].NotifyMsg);
	}
	*/
	fprintf (fp, "PTZ_CONFIGS='%s,%s,%s,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f'\n",
		 conf->PTZConfig.Token,
		 conf->PTZConfig.Name,
		 conf->PTZConfig.NodeToken,
		 conf->PTZConfig.MinZoomLimits,
		 conf->PTZConfig.MaxZoomLimits,
		 conf->PTZConfig.MinPanLimits, 
		 conf->PTZConfig.MaxPanLimits, 
		 conf->PTZConfig.MinTiltLimits, 
		 conf->PTZConfig.MaxTiltLimits, 
		 conf->PTZConfig.PTZ_timeout,
		 conf->PTZConfig.PanDefaultSpeed,
		 conf->PTZConfig.TiltDefaultSpeed,
		 conf->PTZConfig.ZoomDefaultSpeed); 

	for (i = 0; i < MAX_VS_LIST; i++) {
	    fprintf (fp, "IMAGING%d='%d,%f,%f,%f,%f,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%f,%f,%f,%d,%f,%d,%f,%d,%f,%f'\n", 
		     i + 1,
		     gOnvifConf.SourceToken[i].img.BLCMode, 
		     gOnvifConf.SourceToken[i].img.BLCLevel, 
		     gOnvifConf.SourceToken[i].img.Brightness, 
		     gOnvifConf.SourceToken[i].img.ColorSaturation, 
		     gOnvifConf.SourceToken[i].img.Contrast, 
		     gOnvifConf.SourceToken[i].img.ExposureMode, 
		     gOnvifConf.SourceToken[i].img.ExposurePriority, 
		     gOnvifConf.SourceToken[i].img.ExposureWindowBottom, 
		     gOnvifConf.SourceToken[i].img.ExposureWindowTop, 
		     gOnvifConf.SourceToken[i].img.ExposureWindowRight, 
		     gOnvifConf.SourceToken[i].img.ExposureWindowLeft, 
		     gOnvifConf.SourceToken[i].img.MinExposureTime, 
		     gOnvifConf.SourceToken[i].img.MaxExposureTime, 
		     gOnvifConf.SourceToken[i].img.MinGain, 
		     gOnvifConf.SourceToken[i].img.MaxGain, 
		     gOnvifConf.SourceToken[i].img.MinIris, 
		     gOnvifConf.SourceToken[i].img.MaxIris, 
		     gOnvifConf.SourceToken[i].img.ExposureTime, 
		     gOnvifConf.SourceToken[i].img.Gain, 
		     gOnvifConf.SourceToken[i].img.Iris, 
		     gOnvifConf.SourceToken[i].img.AutoFocusMode, 
		     gOnvifConf.SourceToken[i].img.DefaultSpeed, 
		     gOnvifConf.SourceToken[i].img.NearLimit, 
		     gOnvifConf.SourceToken[i].img.FarLimit, 
		     gOnvifConf.SourceToken[i].img.IrCutFilter, 
		     gOnvifConf.SourceToken[i].img.Sharpness, 
		     gOnvifConf.SourceToken[i].img.WDRMode, 
		     gOnvifConf.SourceToken[i].img.WDRLevel, 
		     gOnvifConf.SourceToken[i].img.WhiteBalanceMode, 
		     gOnvifConf.SourceToken[i].img.CrGain, 
		     gOnvifConf.SourceToken[i].img.CbGain); 
	}
	for (i = 0; i < conf->Scopes.size; i++) {
	    fprintf (fp, "SCOPES='%d,%s'\n", conf->Scopes.difin[i], conf->Scopes.Ptr[i]);
	}
	fprintf (fp, "SCOPE_LOCATION_COUNT='%d'\n", conf->Scopes.location_count);
	/* give breaking line */
	fprintf (fp, "\n");
	fclose (fp);
        L4("done\n");
	return OK;
    }
    /* fail to open the file */
    L1("error. open %s for writting\n", __func__, filename);
    return ERR;
}
#if 0
void EventThreadReOpen()
{
    int i;
    struct timeval tv;
    static int index[MAX_EVENT_SCRIPTION_NUM];
    pthread_t event_t = 0;

    gettimeofday(&tv, NULL);

    for (i = 0; i < MAX_EVENT_SCRIPTION_NUM; i++) {
	if( (gOnvifConf.scription[i].enable == true_) &&
	    (tv.tv_sec > gOnvifConf.scription[i].BeginTime) &&
	    (tv.tv_sec < gOnvifConf.scription[i].TerminationTime)) {
	    index[i] = i;
	    gOnvifConf.scription[i].state = ONVIF_STATE_INIT;
	    if (pthread_create (&event_t, NULL, OnvifEventThread, (void *)&index[i])) {
		gOnvifConf.scription[i].state = ONVIF_STATE_CLOSE;
		gOnvifConf.scription[i].enable = false_;
	    }
	} else {
	    gOnvifConf.scription[i].enable = false_;
	    gOnvifConf.scription[i].state = ONVIF_STATE_CLOSE;
	}
    }
}
#endif
void ImgInit (Acti_ImagingSettings *img)
{
	/* BLC */
	img->BLCMode = BLCMode;
	img->BLCLevel = NotAvailable;
	img->Brightness = Brightness;
	img->ColorSaturation = ColorSaturation;
	img->Contrast = Contrast;
	/* Exposure */
	img->ExposureMode = ExposureMode;
	img->ExposurePriority = ExposurePriority;
	img->ExposureWindowBottom = NotAvailable;
	img->ExposureWindowTop = NotAvailable;
	img->ExposureWindowRight = NotAvailable;
	img->ExposureWindowLeft = NotAvailable;
	img->MinExposureTime = NotAvailable;
	img->MaxExposureTime = NotAvailable;
	img->MinGain = MinGain;
	img->MaxGain = MinGain;
	img->MinIris = NotAvailable;
	img->MaxIris = NotAvailable;
	img->ExposureTime = NotAvailable;
	img->Gain = Gain;
	img->Iris = NotAvailable;
	/* Focus */
	img->AutoFocusMode = AutoFocusMode;
	img->DefaultSpeed = NotAvailable;
	img->NearLimit = NotAvailable;
	img->FarLimit = NotAvailable;
	img->IrCutFilter = IrCutFilterMode;
	img->Sharpness = Sharpness;
	/* WideDynamicRange */
	img->WDRMode = WideDynamicMode;
	img->WDRLevel = WideDynamicLevel;
	/* WhiteBalance */
	img->WhiteBalanceMode = WhiteBalanceMode;
	img->CrGain = NotAvailable;
	img->CbGain = NotAvailable;
	return;
}

void ImgOptInit (Acti_ImagingOptions *ImgOpt)
{
//Acti_VideoSources SourceToken[MAX_VS_LIST];
	/* BLC */
	ImgOpt->sizeBLCMode = 1;
	ImgOpt->BLCMode = BLCMode;
	ImgOpt->MinBLCLevel = NotAvailable;
	ImgOpt->MaxBLCLevel = NotAvailable;
	/* Brightness */	
	ImgOpt->MinBrightness = MIN_PHY_BRIGHTNESS;
	ImgOpt->MaxBrightness = MAX_PHY_BRIGHTNESS;
	/* Saturation */
	ImgOpt->MinSaturation = MIN_PHY_SATURATION;
	ImgOpt->MaxSaturation = MAX_PHY_SATURATION;
	/* Contrast */	
	ImgOpt->MinContrast = MIN_PHY_CONTRAST;
	ImgOpt->MaxContrast = MAX_PHY_CONTRAST;
	/* Exposure */
	ImgOpt->sizeExposureMode = 1;
	ImgOpt->ExposureMode = ExposureMode;
	ImgOpt->sizeExposurePriority = 1;
	ImgOpt->ExposurePriority = ExposurePriority;
	ImgOpt->MinExposureTime = NotAvailable;	
	ImgOpt->MaxExposureTime = NotAvailable;
	ImgOpt->MinGain = MinGain;
	ImgOpt->MaxGain = MaxGain;
	ImgOpt->MinIris = NotAvailable;
	ImgOpt->MaxIris = NotAvailable;
	ImgOpt->ExposureTime = NotAvailable;
	ImgOpt->Gain = Gain;
	ImgOpt->Iris = NotAvailable;
	/* Focus */
	ImgOpt->sizeAutoFocusModes = 1;
	ImgOpt->AutoFocusModes = AutoFocusMode;
	ImgOpt->MinDefaultSpeed = NotAvailable;
	ImgOpt->MaxDefaultSpeed = NotAvailable;
	ImgOpt->MinNearLimit = NotAvailable;
	ImgOpt->MaxNearLimit = NotAvailable;
	ImgOpt->MinFarLimit = NotAvailable;
	ImgOpt->MaxFarLimit = NotAvailable;
	/* IrCut*/
	ImgOpt->sizeIrCutFilterModes = 1;
	ImgOpt->IrCutFilterModes = IrCutFilterMode;
	/* Sharpness */
	ImgOpt->MinSharpness = MIN_PHY_SHARPNESS;
	ImgOpt->MaxSharpness = MAX_PHY_SHARPNESS;
	/* WideDynamicRange */
	ImgOpt->sizeWDRMode = MAX_WDR_SIZE;
	ImgOpt->WDRMode[0] = WideDynamicMode_ON;
	ImgOpt->WDRMode[1] = WideDynamicMode_OFF;
	ImgOpt->MinWDRLevel = MIN_PHY_WDR;
	ImgOpt->MaxWDRLevel = MAX_PHY_WDR;
	/* WhiteBalance */
	ImgOpt->sizeWhiteBalanceMode = 1;
	ImgOpt->WhiteBalanceMode = WhiteBalanceMode;
	ImgOpt->MinYrGain = NotAvailable;
	ImgOpt->MaxYrGain = NotAvailable;
	ImgOpt->MinYbGain = NotAvailable;
	ImgOpt->MaxYbGain = NotAvailable;
	return;
}

void ImagingConfInit () 
{
	int i; 
	for (i = 0; i < MAX_VS_LIST; i++)
	{
		/* Init Persist ImagingSettings and Options */
		ImgInit (&gOnvifConf.SourceToken[i].img);	
		ImgOptInit (&gOnvifConf.SourceToken[i].ImgOpt); 	
	}
	return;
}
void GetPtzInfo () 
{
    tUrlDB url;
    char ReplyMsg[2048];
    char value[256];
    int x1=0, x2=0, y1=0, y2=0;
		
    if ((gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) {
	strcpy(url.cgi, "encoder");
	strcpy(url.cmd, "ZOOM_CAP_GET");
	url.len = strlen(url.cmd);
        if ((OnvifCmdSend (&url, ReplyMsg, sizeof(ReplyMsg)) == OK) && (strncmp(ReplyMsg, "ERROR", 5) != 0)) {
            value[0] = '\0';
            OnvifReplyMsgParser ("ZOOM_CAP_GET", ReplyMsg, value);
            if(sscanf (value, "%d,%d", &x1, &x2) == 2) {
                if(x1 > x2) {
                    gPTZLimits.MinZoomLimits = x2;
                    gPTZLimits.MaxZoomLimits = x1;
                } else {
                    gPTZLimits.MinZoomLimits = x1;
                    gPTZLimits.MaxZoomLimits = x2;
                }
                goto get_move_limit;
            }
        }
        L4 ("warning! can't get max & min Zoom Position!, use default\n");
        gPTZLimits.MinZoomLimits = 0;
	gPTZLimits.MaxZoomLimits = 60000;
    } else {
	gPTZLimits.MinZoomLimits = 0;
	gPTZLimits.MaxZoomLimits = 0;
    }
    
get_move_limit:
    if((gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_)) {
	strcpy(url.cgi, "encoder");
	strcpy(url.cmd, "MOVE_LIMIT_GET");
	url.len = strlen(url.cmd);
	if ((OnvifCmdSend (&url, ReplyMsg, sizeof(ReplyMsg)) == OK) && (strncmp(ReplyMsg, "ERROR", 5) != 0)) {
		value[0] = '\0';
		OnvifReplyMsgParser ("MOVE_LIMIT_GET=", ReplyMsg, value);
            if(sscanf(value, "%d,%d,%d,%d", &x1, &y1, &x2, &y2) == 4) {
                if(x1 > x2) {
                    gPTZLimits.MinPanLimits = x2;
                    gPTZLimits.MaxPanLimits = x1;
                } else {
                    gPTZLimits.MinPanLimits = x1;
                    gPTZLimits.MaxPanLimits = x2;
                }
                if(y1 > y2) {
                    gPTZLimits.MinTiltLimits = y2;
                    gPTZLimits.MaxTiltLimits = y1;
                } else {
                    gPTZLimits.MinTiltLimits = y1;
                    gPTZLimits.MaxTiltLimits = y2;
                }
                goto get_move_limit_done;
            }
        }
        L1("ERROR to get MOVE_LIMIT_GET!!");
	gPTZLimits.MinPanLimits = -18000;
	gPTZLimits.MaxPanLimits = 18000;
	gPTZLimits.MinTiltLimits = 0;
	gPTZLimits.MaxTiltLimits = 9000;
    } else {
	gPTZLimits.MinPanLimits = 0;
        gPTZLimits.MaxPanLimits = 0;
        gPTZLimits.MinTiltLimits = 0;
        gPTZLimits.MaxTiltLimits = 0;
    }
        
get_move_limit_done:
    L2 ("gPTZLimits: Pan,Tilt,Zoom = (%f,%f),(%f,%f),(%f,%f)\n",
	gPTZLimits.MinPanLimits, gPTZLimits.MaxPanLimits,
	gPTZLimits.MinTiltLimits, gPTZLimits.MaxTiltLimits,
	gPTZLimits.MinZoomLimits, gPTZLimits.MaxZoomLimits); 
}

int PTZNodeInit () 
{
    /* Note: ONVIF test tool v12.06 must ask for PTZ node token named "1". */
    gOnvifConf.sizePTZNode = 1; 
    snprintf(gOnvifConf.PTZNode.token, MAX_TOKEN_STRLEN, "1");
    snprintf(gOnvifConf.PTZNode.Name, MAX_PROFILE_STR, "node1"); 

    gOnvifConf.PTZNode.MaximumNumberOfPresets = 64;
    gOnvifConf.PTZNode.HomeSupported = true_;
    snprintf(gOnvifConf.PTZNode.MinPTZTimeout, ISO8601_DURATION_STRLEN, "PT0S"); 
	if(gOnvifConf.PTEnableBy485 == 0) {
		snprintf(gOnvifConf.PTZNode.MaxPTZTimeout, ISO8601_DURATION_STRLEN, "PT5S");
	} else {
    	snprintf(gOnvifConf.PTZNode.MaxPTZTimeout, ISO8601_DURATION_STRLEN, "PT1S"); 
	}
    /* Auxiliary */
    gOnvifConf.PTZNode.sizeAuxiliaryCommands = (sizeof (Auxiliary_Operations)/4); // sizeof (char *str[]) = 4
    snprintf(gOnvifConf.PTZNode.AuxiliaryCommands[0], MAX_AUX_LEN, "%s", AuxiliaryAlarmOutputOn); 
    snprintf(gOnvifConf.PTZNode.AuxiliaryCommands[1], MAX_AUX_LEN, "%s", AuxiliaryAlarmOutputOff); 
    return OK;
}

int PTZConfInit (Acti_PTZConfig *ptzPtr) 
{
    snprintf(ptzPtr->Name, MAX_TOKEN_STRLEN, "PTZ");
    snprintf(ptzPtr->Token, MAX_PROFILE_STR, "tokenPTZ");

    strncpy (ptzPtr->NodeToken, gOnvifConf.PTZNode.token, MAX_TOKEN_STRLEN);
    ptzPtr->NodeToken[strlen (ptzPtr->NodeToken)] = '\0';

    ptzPtr->UseCount = 0;
    ptzPtr->PTZ_timeout = 0;
    /* ZoomLimits */
    ptzPtr->MinZoomLimits = gPTZLimits.MinZoomLimits;
    ptzPtr->MaxZoomLimits = gPTZLimits.MaxZoomLimits; 
    snprintf(ptzPtr->ZoomLimits_URI, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/ZoomSpaces/PositionGenericSpace");
    /* PanTiltLimits */
    ptzPtr->MinPanLimits = gPTZLimits.MinPanLimits; 
    ptzPtr->MaxPanLimits = gPTZLimits.MaxPanLimits; 
    ptzPtr->MinTiltLimits = gPTZLimits.MinTiltLimits; 
    ptzPtr->MaxTiltLimits = gPTZLimits.MaxTiltLimits; 
    snprintf(gOnvifConf.PTZConfig.PanTiltLimits_URI, MAX_NAMESPACE_LEN, 
             "http://www.onvif.org/ver10/tptz/PanTiltSpaces/PositionGenericSpace");
    snprintf(ptzPtr->PTDefaultSpeedSpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/PanTiltSpaces/GenericSpeedSpace");
    snprintf(ptzPtr->ZoomDefaultSpeedSpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/ZoomSpaces/ZoomGenericSpeedSpace");
    /* Namespaces*/
    snprintf(ptzPtr->AbsolutePantTiltPositionSpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/PanTiltSpaces/PositionGenericSpace");
    snprintf(ptzPtr->AbsoluteZoomPositionSpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/ZoomSpaces/PositionGenericSpace");
    snprintf(ptzPtr->RelativePanTiltTranslationSpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/PanTiltSpaces/TranslationGenericSpace");
    snprintf(ptzPtr->RelativeZoomTranslationSpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/ZoomSpaces/TranslationGenericSpace");
    snprintf(ptzPtr->ContinuousPanTiltVelocitySpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/PanTiltSpaces/VelocityGenericSpace");
    snprintf(ptzPtr->ContinuousZoomVelocitySpace, MAX_NAMESPACE_LEN,
             "http://www.onvif.org/ver10/tptz/ZoomSpaces/VelocityGenericSpace");

    /* ZoomLimits */
    Normalize_PTZPosition (OPT_ZOOM_POSITION, gPTZLimits.MinZoomLimits, &ptzPtr->MinZoomLimits); 
    Normalize_PTZPosition (OPT_ZOOM_POSITION, gPTZLimits.MaxZoomLimits, &ptzPtr->MaxZoomLimits);
    /* PanTiltLimits */
    Normalize_PTZPosition (OPT_PAN_POSITION, gPTZLimits.MinPanLimits, &ptzPtr->MinPanLimits); 
    Normalize_PTZPosition (OPT_PAN_POSITION, gPTZLimits.MaxPanLimits, &ptzPtr->MaxPanLimits); 
    Normalize_PTZPosition (OPT_TILT_POSITION, gPTZLimits.MinTiltLimits, &ptzPtr->MinTiltLimits); 
    Normalize_PTZPosition (OPT_TILT_POSITION, gPTZLimits.MaxTiltLimits, &ptzPtr->MaxTiltLimits); 
    /* DefaultSpeed */
    ptzPtr->PanDefaultSpeed = ptzNormalRange[OPT_PAN_SPEED][LIMIT_MAX]; 
    ptzPtr->TiltDefaultSpeed = ptzNormalRange[OPT_TILT_SPEED][LIMIT_MAX];
    ptzPtr->ZoomDefaultSpeed = ptzNormalRange[OPT_ZOOM_SPEED][LIMIT_MAX];
	/* max. Preset Points is desided by platform */
	if(gOnvifConf.platform == ONVIF_PLATFROM_K) ptzPtr->maxPresetPoints = 64;
	else                                        ptzPtr->maxPresetPoints = 256;
    return OK; 
}

void VideoEncoderInit () {
    int i;

    for (i = 0; i < MAX_VE_LIST; i++) {
	gOnvifConf.veConf[i].valid = 0;
	gOnvifConf.veConf[i].videoSrc = 1;
	gOnvifConf.veConf[i].videoSrcInProfile = -1;
	gOnvifConf.veConf[i].UseCount = 0;
	strncpy (gOnvifConf.veConf[i].Multicast.IPv4Address, gMcastIPv4Addr, 16); 
	gOnvifConf.veConf[i].Multicast.Port = gMcastPort; 
	gOnvifConf.veConf[i].Multicast.TTL = gMcastTTL; 
	gOnvifConf.veConf[i].Multicast.AutoStart = false_;
	strcpy (gOnvifConf.veConf[i].SessionTimeout, "PT60S");
    }
    return; 
}

void AudioSourceConfInit ()
{
	gOnvifConf.sizeAsConf = 1; 
	strcpy (gOnvifConf.asConf.Name, "AudioSourceConfig0"); 
	gOnvifConf.asConf.UseCount = 0; 
	strcpy (gOnvifConf.asConf.token, "0"); 
	strcpy (gOnvifConf.asConf.SourceToken, "0");  //index of Audio Source
	
	return; 
}

void AudioEncoderConfInit (Acti_AudioEncoderConfig *aePtr)
{
	gOnvifConf.sizeAeConf = 1; 
	strcpy (aePtr->Name, "AudioEncoderConfig0"); 
	aePtr->UseCount = 0; 
	strcpy (aePtr->token, "0"); 
	aePtr->Encoding = G711; 
	aePtr->Bitrate = 64000 ; 
	aePtr->SampleRate = 8000; 
	aePtr->Multicast.Type = IPv4_;
	aePtr->Multicast.Port = gMcastPort;
	aePtr->Multicast.TTL = gMcastTTL;
	strncpy (aePtr->Multicast.IPv4Address, gMcastIPv4Addr, 16);
	aePtr->Multicast.AutoStart = false_;
	strcpy (aePtr->SessionTimeout, "PT60S");
	return; 
}
void AudioConfInit () 
{
	/* One set of Audio Source */
	gOnvifConf.sizeAS = 1; 
	strcpy (gOnvifConf.AudioSource.token, "0"); 
	gOnvifConf.AudioSource.Channels = 1;

	AudioSourceConfInit (); 
	AudioEncoderConfInit (&gOnvifConf.aeConf); 
	AudioEncoderConfInit (&tmpAeConf); 
	return; 
}
void PersistStateInit () 
{
	int i = 0; 
    
	for (i = 0; i < MAX_VS_LIST; i++)  VSConfigState[i] = true_;
	ASConfigState = true_;
	AEConfigState = true_;
	PTZConfigState = true_; 
	for (i = 0; i < MAX_VS_LIST; i++) ImgConfigState[i] = true_; 
	return; 
}

// Get Multicast information 
void GetMcastInfo () 
{
	tUrlDB url;
	char ReplyMsg[512];
	char value[16];

	strcpy(url.cgi, "system");
	strcpy(url.cmd, "V2_PORT_RTP_MULTI_VIDEO&VIDEO_MULTICAST_TTL&V2_MULTICAST_IP");
	url.len = strlen(url.cmd);
	if(OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg)) == OK )
	{
		OnvifReplyMsgParser("V2_PORT_RTP_MULTI_VIDEO", ReplyMsg, value);
		gMcastPort = atoi(value);
		OnvifReplyMsgParser("VIDEO_MULTICAST_TTL", ReplyMsg, value);
		gMcastTTL = atoi(value);
		OnvifReplyMsgParser("V2_MULTICAST_IP", ReplyMsg, value);
		strcpy (gMcastIPv4Addr, value);
	}
	else
	{
		// If failed to get multicast info, use "empty configuration".
		gMcastPort = 0;
		gMcastTTL = 0;
		strcpy (gMcastIPv4Addr, "0.0.0.0");
	}
	return; 
}

void GetImagingInfo ()
{
	tUrlDB url;
	char ReplyMsg[512];
	char value[8];
	char *p1 = NULL, *p2 = NULL;
	char tmpvar[4] = {0, 0, 0, 0};
    
	strcpy (url.cgi, "encoder");
	strcpy (url.cmd, "VIDEO_BRIGHTNESS");
	url.len = strlen (url.cmd);
	if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		if (OnvifReplyMsgParser ("VIDEO_BRIGHTNESS", ReplyMsg, value) == OK)
		{
			Brightness = atof(value);
			gOnvifConf.BrightnessEnable = true_;
		}
		else
			gOnvifConf.BrightnessEnable = false_;
	}
	else
		gOnvifConf.BrightnessEnable = false_;

	strcpy (url.cmd, "VIDEO_SATURATION"); 
	url.len = strlen (url.cmd);
	if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		if (OnvifReplyMsgParser ("VIDEO_SATURATION", ReplyMsg, value) == OK)
		{
			ColorSaturation = atof(value);
			gOnvifConf.SaturationEnable = true_;
		}
		else
			gOnvifConf.SaturationEnable = false_;
	}
	else
		gOnvifConf.SaturationEnable = false_;

	strcpy (url.cmd, "VIDEO_CONTRAST"); 
	url.len = strlen (url.cmd);
	if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		if (OnvifReplyMsgParser ("VIDEO_CONTRAST", ReplyMsg, value) == OK)
		{
			Contrast = atof(value);
			gOnvifConf.ContrastEnable = true_;
		}
		else
			gOnvifConf.ContrastEnable = false_;
	}
	else
		gOnvifConf.ContrastEnable = false_;

	strcpy (url.cmd, "VIDEO_SHARPNESS"); 
	url.len = strlen (url.cmd);
	if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		if (OnvifReplyMsgParser ("VIDEO_SHARPNESS", ReplyMsg, value) == OK)
		{
			Sharpness = atof(value);
			gOnvifConf.SharpnessEnable = true_;
		}
		else
			gOnvifConf.SharpnessEnable = false_;
	}
	else
		gOnvifConf.SharpnessEnable = false_;

	strcpy (url.cmd, "VIDEO_WDR"); 
	url.len = strlen (url.cmd);
	if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		if (OnvifReplyMsgParser ("VIDEO_WDR", ReplyMsg, value) == OK) 
		{
			if (strncasecmp (value, "ON", 2) == 0)
			{
				WideDynamicMode = ON;
				p1 = strchr (value, ',');
				p2 = strrchr (value, ',');
				strncpy (tmpvar, (p1 + 1), (p2 - p1 -1)); 
				WideDynamicLevel = atof (tmpvar); 
			}
			else
				WideDynamicMode = OFF;
			gOnvifConf.WDREnable = true_; 
		} 
		else
			gOnvifConf.WDREnable = false_; 
	}

	strcpy (url.cmd, "VIDEO_EXPOSURE_MODE"); 
	url.len = strlen (url.cmd);
	if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
	{
		if (OnvifReplyMsgParser ("VIDEO_EXPOSURE_MODE", ReplyMsg, value) == OK)
		{
			memset (url.cmd, 0, URLCMD_LEN); 
			if (strcmp (value, "AUTO") == 0)
			{
				ExposureMode = AUTO_; 
				strcpy(url.cmd, "VIDEO_AGC_GAIN");
				url.len = strlen (url.cmd);
				if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
				{
					OnvifReplyMsgParser ("VIDEO_AGC_GAIN", ReplyMsg, value);
					Gain = atof (value);
				}
			}
			else
			{ 
				ExposureMode = MANUAL_; 
				strcpy(url.cmd, "VIDEO_EXPOSURE_GAIN");
				url.len = strlen (url.cmd);
				if (OnvifCmdSend (&url, ReplyMsg, sizeof (ReplyMsg)) == OK)
				{
					OnvifReplyMsgParser ("VIDEO_EXPOSURE_GAIN", ReplyMsg, value);
					Gain = atof (value);
				}
			}
			gOnvifConf.ExposureEnable = true_;
		}
		else 
			gOnvifConf.ExposureEnable = false_;
	}
	gOnvifConf.BLCEnable = false_;
	gOnvifConf.WhiteBalanceEnable = true_;
	return; 
}
static void OnvifGetOemConf(void) {
    char retMsg[512];
    char value[128];
    
    if(OnvifSingleUrlCmdSend("system", "OEM_INFO", retMsg, (sizeof(retMsg)-1)) > 0) {
        if(OnvifGetValueFmUrlReply(retMsg, "OEM_SERIAL_NUM", value, (sizeof(value)-1)) > 0) {
            snprintf(gOnvifConf.serialNum, sizeof(gOnvifConf.serialNum), "%s", value);
        } else {
            snprintf(gOnvifConf.serialNum, sizeof(gOnvifConf.serialNum), "Camera-%c%c%c%c%c%c", 
                     gOnvifConf.macar[6], gOnvifConf.macar[7], gOnvifConf.macar[8], 
                     gOnvifConf.macar[9], gOnvifConf.macar[10], gOnvifConf.macar[11]);
        }
        if(OnvifGetValueFmUrlReply(retMsg, "OEM_MODEL_NAME", value, (sizeof(value)-1)) > 0) {
            snprintf(gOnvifConf.ModelName, ONVIF_MODELNAME_LEN, "%s", value);
        } else {
            snprintf(gOnvifConf.ModelName, ONVIF_MODELNAME_LEN, "IPDevice");
        }
    } else {
        snprintf(gOnvifConf.serialNum, sizeof(gOnvifConf.serialNum), "Camera-%c%c%c%c%c%c", 
                     gOnvifConf.macar[6], gOnvifConf.macar[7], gOnvifConf.macar[8], 
                     gOnvifConf.macar[9], gOnvifConf.macar[10], gOnvifConf.macar[11]);
        snprintf(gOnvifConf.ModelName, ONVIF_MODELNAME_LEN, "IPDevice");
    }
}

int OnvifChangeVideoStreamNum (int StreamNum) //Anne
{	
	tOnvifFpsCap myFpsCap;
	tUrlDB url;
    	char ReplyMsg[1024*4];
	char value[256];
	char *pRight = NULL;
	char *pLeft = NULL;
	int FrameRate2 = 1;
	int i = 0;
	int ret = ERR;
	int veIdx;
	struct tt__VideoResolution r2;
	int addPTZ = 0;

	if(StreamNum > 2 || StreamNum <= 0) return ERR;

	if(gOnvifConf.numStreams == StreamNum) return OK;

	strcpy(url.cgi, "system");
	url.len = sprintf(url.cmd, "SYSTEM_INFO");
	
	for(i = 0 ; i < 3 ; i ++) {
		ret = OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
		if(ret == OK) break;
		sleep(5);
    	}
	if(ret == ERR) return ERR;

	if(StreamNum > 1) {
		if(OnvifParserSystemInfo("VIDEO2_RESOLUTION_CAP", ReplyMsg, value) == OK) {
			  sscanf(value, "%*1[NP]%dx%d", &gOnvifConf.maxResWidth2, &gOnvifConf.maxResHeight2);
			  OnvifPatch1080PResolutionForTK(&gOnvifConf.maxResHeight2);
			  pRight = strrchr(value, ',');
			  if(pRight) sscanf(pRight, ",%*1[NP]%dx%d", &gOnvifConf.minResWidth2, &gOnvifConf.minResHeight2);
			  OnvifPatch1080PResolutionForTK(&gOnvifConf.minResHeight2);
			  pLeft = value;
			  gOnvifConf.ResCapNum2 = 0;
			  sscanf(pLeft, "%*1[NP]%dx%d", &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Width,
				   &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
			  OnvifPatch1080PResolutionForTK(&gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
			  do {
					  pLeft = strchr(pLeft, ',');
					  if(pLeft != NULL) {
					  gOnvifConf.ResCapNum2++;
					  pLeft++;
					  sscanf(pLeft, "%*1[NP]%dx%d", &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Width, 
							   &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
					  OnvifPatch1080PResolutionForTK(&gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
					  }
			  } while(pLeft != NULL);
		  }else{
			  return ERR;
		  }
	}

	gOnvifConf.numStreams = StreamNum;
	gOnvifConf.SourceTokenCnt =  gOnvifConf.numStreams;
	gOnvifConf.VsCnt = gOnvifConf.numStreams;

	//Video Source Token
	if(gOnvifConf.SourceTokenCnt == 1) { /* single video streaming mode */
		gOnvifConf.SourceToken[1].Token[0] = '\0';; 
		gOnvifConf.SourceToken[1].res.Width = gOnvifConf.SourceToken[0].res.Width;
		gOnvifConf.SourceToken[1].res.Height = gOnvifConf.SourceToken[0].res.Height;
		gOnvifConf.SourceToken[1].FrameRate = gOnvifConf.SourceToken[0].FrameRate;
	} else { /* dual video streaming mode */
            if(MaxFrameRateByRes(1, -1, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight,
                                          -1, gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2,
                                          &myFpsCap) == OK) {
			FrameRate2 = myFpsCap.fpsCap[1].maxFps;
		}
		sprintf (gOnvifConf.SourceToken[1].Token, "tVS_2"); 
		gOnvifConf.SourceToken[1].res.Width = gOnvifConf.maxResWidth2;
		gOnvifConf.SourceToken[1].res.Height = gOnvifConf.maxResHeight2;
		gOnvifConf.SourceToken[1].FrameRate = FrameRate2;
	}

	//Video Source Config
	if(gOnvifConf.VsCnt == 1) { /* single video streaming mode */
		gOnvifConf.vsConf[1].token[0] = '\0';
		gOnvifConf.vsConf[1].Name[0] = '\0';
		gOnvifConf.vsConf[1].SourceTokenIdx = 0;
		gOnvifConf.vsConf[1].b.width = gOnvifConf.maxResWidth;
		gOnvifConf.vsConf[1].b.height = gOnvifConf.maxResHeight;
		gOnvifConf.vsConf[1].UseCount = 0;
	} else { /* create video source 2 in dual stream mode */
		snprintf(gOnvifConf.vsConf[1].token, MAX_TOKEN_STRLEN, "%s", gOnvifConf.SourceToken[1].Token);
		sprintf (gOnvifConf.vsConf[1].Name, "VS_2");
		gOnvifConf.vsConf[1].SourceTokenIdx = 1;
		gOnvifConf.vsConf[1].b.width = gOnvifConf.maxResWidth2;
		gOnvifConf.vsConf[1].b.height = gOnvifConf.maxResHeight2;
	}

	//Video Encoder Config
	if(gOnvifConf.numStreams == 1) { /* single video streaming mode */
		for(i = 0 ; i < MAX_VE_LIST ; i ++) {
			if((gOnvifConf.veConf[i].valid == 1) && (gOnvifConf.veConf[i].videoSrc == 2)){
				gOnvifConf.veConf[i].valid = 0; 
				gOnvifConf.veConf[i].UseCount = 0; 
				gOnvifConf.veConf[i].Name[0] = '\0'; 
				gOnvifConf.veConf[i].token[0] = '\0'; 
				gOnvifConf.VeCnt--;
			}
		}
	} else {
		r2.Width =  gOnvifConf.maxResWidth2;
		r2.Height =  gOnvifConf.maxResHeight2;
		if(gOnvifConf.H264_Enable  == true_) {
			for(i = 0 ; i < MAX_VE_LIST ; i ++) {
				if(gOnvifConf.veConf[i].valid == 0){
					if(MaxFrameRateByRes(1, H264, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight, 
						  			H264, gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2,
									&myFpsCap) == OK) {
						  InitVideoEncoderParameters(i, 2, H264, &r2, myFpsCap.fpsCap[1].maxFps);
						  gOnvifConf.veConf[i].needSaved = 1;
						  gOnvifConf.VeCnt += 1;
						  break;
					}
				}
			}
		}
		if(gOnvifConf.MJPEG_Enable  == true_) {
			for(i = 0 ; i < MAX_VE_LIST ; i ++) {
				if(gOnvifConf.veConf[i].valid == 0){
					if(MaxFrameRateByRes(1, JPEG, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight, 
						  			JPEG, gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2,
									&myFpsCap) == OK) {
						  InitVideoEncoderParameters(i, 2, JPEG, &r2, myFpsCap.fpsCap[1].maxFps);
						  gOnvifConf.veConf[i].needSaved = 1;
						  gOnvifConf.VeCnt += 1;
						  break;
					}
				}
			}
		}
		if(gOnvifConf.MPEG4_Enable  == true_) {
			for(i = 0 ; i < MAX_VE_LIST ; i ++) {
				if(gOnvifConf.veConf[i].valid == 0){
					if(MaxFrameRateByRes(1, MPEG4, gOnvifConf.maxResWidth, gOnvifConf.maxResHeight, 
						  			MPEG4, gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2,
									&myFpsCap) == OK) {
						  InitVideoEncoderParameters(i, 2, MPEG4, &r2, myFpsCap.fpsCap[1].maxFps);
						  gOnvifConf.veConf[i].needSaved = 1;
						  gOnvifConf.VeCnt += 1;
					}
				}
			}
		}
	}

	//Video Profile 
    if( (gOnvifConf.PTEnable == true_) || (gOnvifConf.PTEnableBy485 == true_) ||
        (gOnvifConf.ZoomEnable == true_) || (gOnvifConf.ZoomEnableBy485 == true_)) addPTZ = 1;

    /* create the media profiles, align with encders */
	if(gOnvifConf.numStreams == 1) { /* single video streaming mode */
		for (i = 0; i < MAX_PROFILE_LIST; i++) {
		    if((gOnvifConf.profile[i].valid == 1) && (gOnvifConf.profile[i].vsIdx == 1))
				gOnvifConf.profile[i].valid = 0;
	                	gOnvifConf.ProfileCnt--;
		}
	} else {
		if(gOnvifConf.H264_Enable  == true_) {
			for (i = 0; i < MAX_PROFILE_LIST; i++) {
				if(gOnvifConf.profile[i].valid == 0) {
		            	veIdx = GetVeConfIndexByEncoderVideoSrc(gOnvifConf.veConf, H264, 2);
            			if((veIdx >= 0) && (veIdx < MAX_VE_LIST)) {
	                			InitMediaProfileParameters(&gOnvifConf.profile[i], veIdx);
	      	      		if(addPTZ) gOnvifConf.PTZ_AddToken[i] = true_;
						if(gOnvifConf.AudioEnable == true_) {
      		              		gOnvifConf.ASToken[i] = true_;
            		        		gOnvifConf.AEToken[i] = true_;
						}
	                			gOnvifConf.ProfileCnt++;
                				break;
					} else {
					    fprintf(stderr, "%s:error, not found H264,%d for profile %d\n", __func__,
						    i, gOnvifConf.ProfileCnt);
					}
				}
			}
		}
		if(gOnvifConf.MJPEG_Enable  == true_) {
			for (i = i+1; i < MAX_PROFILE_LIST; i++) {
				if(gOnvifConf.profile[i].valid == 0) {
		            	veIdx = GetVeConfIndexByEncoderVideoSrc(gOnvifConf.veConf, JPEG, 2);
            			if((veIdx >= 0) && (veIdx < MAX_VE_LIST)) {
	                			InitMediaProfileParameters(&gOnvifConf.profile[i], veIdx);
	      	      		if(addPTZ) gOnvifConf.PTZ_AddToken[i] = true_;
						if(gOnvifConf.AudioEnable == true_) {
      		              		gOnvifConf.ASToken[i] = true_;
            		        		gOnvifConf.AEToken[i] = true_;
						}
	                			gOnvifConf.ProfileCnt++;
                				break;
					} else {
						fprintf(stderr, "%s:error, not found MJPEG,%d for profile %d\n", __func__,
							i, gOnvifConf.ProfileCnt);
					}
				}
			}
		}
		if(gOnvifConf.MPEG4_Enable  == true_) {
			for (i = i+1; i < MAX_PROFILE_LIST; i++) {
				if(gOnvifConf.profile[i].valid == 0) {
		            	veIdx = GetVeConfIndexByEncoderVideoSrc(gOnvifConf.veConf, MPEG4, 2);
            			if((veIdx >= 0) && (veIdx < MAX_VE_LIST)) {
	                			InitMediaProfileParameters(&gOnvifConf.profile[i], veIdx);
	      	      		if(addPTZ) gOnvifConf.PTZ_AddToken[i] = true_;
						if(gOnvifConf.AudioEnable == true_) {
      		              		gOnvifConf.ASToken[i] = true_;
            		        		gOnvifConf.AEToken[i] = true_;
						}
	                			gOnvifConf.ProfileCnt++;
                				break;
					} else {
						fprintf(stderr, "%s:error, not found MPEG4,%d for profile %d\n", __func__,
							i, gOnvifConf.ProfileCnt);
					}
				}
			}
		}
	}
	config_change = true_;
	return OnvifConfBin2File(CONF_FILE_ONVIF);
}


static int InitEventQueue()
{
	int i = 0;
	struct timeval tv;

	if (sem_init (&gOnvifConf.EventQueue.sem, 0, 1) != 0) {
		L1 ("Error. sem_init failed errno %d %s\n", errno, strerror (errno));
		return ERR;
	}
	
	/* Locking semaphore */
	if (sem_wait (&gOnvifConf.EventQueue.sem)) {
		L1 ("Error. lock sem\n");
	}

	gOnvifConf.EventQueue.InsertIndex = 0;
	gettimeofday(&tv, NULL);
	for(i=0; i<MAX_EVENT_NUM; i++){
		gOnvifConf.EventQueue.EMsg[i].state = false_;
		gOnvifConf.EventQueue.EMsg[i].trigger = false_;
		gOnvifConf.EventQueue.EMsg[i].NotifyEvent = EVENT_MSG_NONE;
		gOnvifConf.EventQueue.EMsg[i].TimeStamp.tv_sec = tv.tv_sec;
		gOnvifConf.EventQueue.EMsg[i].TimeStamp.tv_usec = tv.tv_usec;
	}

	/* Unlocking semaphore */
	if (sem_post (&gOnvifConf.EventQueue.sem)) {
		L1 ("Error. unlock sem\n");
	}
	return OK;
}

static int InsertEvent(int Event, int trigger, int state)
{
	int index;
	struct timeval tv;

	/* Locking semaphore */
	if (sem_wait (&gOnvifConf.EventQueue.sem)) {
		L1 ("Error. lock sem\n");
	}

	gettimeofday(&tv, NULL);
	gOnvifConf.EventQueue.InsertIndex++; 
	if(gOnvifConf.EventQueue.InsertIndex >= MAX_EVENT_NUM)
		gOnvifConf.EventQueue.InsertIndex = 0; 
	index = gOnvifConf.EventQueue.InsertIndex;
	gOnvifConf.EventQueue.EMsg[index].state = state;
	gOnvifConf.EventQueue.EMsg[index].trigger = trigger;
	gOnvifConf.EventQueue.EMsg[index].NotifyEvent = Event;
	gOnvifConf.EventQueue.EMsg[index].TimeStamp.tv_sec = tv.tv_sec;
	gOnvifConf.EventQueue.EMsg[index].TimeStamp.tv_usec = tv.tv_usec;

	/* Unlocking semaphore */
	if (sem_post (&gOnvifConf.EventQueue.sem)) {
		L1 ("Error. unlock sem\n");
	}
	return OK;
}

int OnvifMotionStateChange(int Index, int State)
{
	if(Index < 0 || Index >= ONVIF_MOTION_WINDOWS)
		return ERR;

	if(gOnvifConf.MDCurrentState[Index].state != State){
		gOnvifConf.MDCurrentState[Index].state = State;
		gOnvifConf.MDCurrentState[Index].trigger = State;
		InsertEvent(EVENT_MSG_WINDOW_1+Index, State, State);
		L2("OnvifMDTriggerState Window %d trigger state %d\n", Index+1, State);
	}
	return OK;	
}

int OnvifDIStateChange(int Index, int State, int Trigger)
{
	if(Index < 0 || Index >= MAX_DI_NUM)
		return ERR;

	if((gOnvifConf.DICurrentState[Index].state != State) ||
		(gOnvifConf.DICurrentState[Index].trigger != Trigger)){
		gOnvifConf.DICurrentState[Index].state = State;
		gOnvifConf.DICurrentState[Index].trigger = Trigger;
		InsertEvent(EVENT_MSG_DI_1+Index, Trigger, State);
		L2("OnvifDITriggerState DI %d trigger %d\n", Index+1, Trigger);
	}
	return OK;	
}

void OnvifConfInit(char *Name, char *Pwd, int HttpPort) {
    tUrlDB url;
    char ReplyMsg[1024*4];
    char ReplyMsg2[320];
    char value[256];
    char *pRight = NULL;
    char *pLeft = NULL;
    int i = 0;
    int serialPorts = 0; 

    memset (&gOnvifConf, 0, sizeof (tOnvifConf));

    gOnvifConf.state = ONVIF_STATE_INIT;

    /* get root account&password */
    snprintf(gOnvifConf.root, ONVIF_ACCOUNT_NAME_LEN, "%s", Name);
    snprintf(gOnvifConf.passwd, ONVIF_ACCOUNT_PWD_LEN, "%s", Pwd);
    gOnvifConf.HttpPort = HttpPort;
    
    if(GetV2WanStatus(ReplyMsg2, sizeof (ReplyMsg2)) == OK) {
	OnvifReplyMsgParser ("WAN_IP", ReplyMsg2, value);
	OnvifReplyMsgParser ("DNS_PRIMARY", ReplyMsg2, gDnsPrimary);
	OnvifReplyMsgParser ("DNS_SECONDARY", ReplyMsg2, gDnsSecondary);
    }
    if(strlen(gDnsPrimary) == 0) {
	snprintf (gDnsPrimary, sizeof(gDnsPrimary), "%s", "0.0.0.0");
    }
    if(strlen(gDnsSecondary) == 0) {
	snprintf (gDnsSecondary, sizeof(gDnsSecondary), "%s", "0.0.0.0");
    }
    gOnvifConf.DnsFromDHCP = 1; /* 1: DNS configurations is from DHCP */
    gOnvifConf.DnsConfPri[0] = '\0';
    gOnvifConf.DnsConfSec[0] = '\0';
    gOnvifConf.Domain[0] = '\0';

    strcpy(gOnvifConf.CurrentIP, value);
    sprintf (gOnvifConf.WsdlUrl, "http://%s" WEB_WSDL_ONVIF, value);
    sprintf (gOnvifConf.MediaXAddr, "http://%s:%d" WEB_ONVIF_SERVICE, value, HttpPort);
    
    strcpy(url.cgi, "system");
    url.len = sprintf(url.cmd, "SYSTEM_INFO");
    //fprintf(stdout, "%s: send SYSTEM_INFO URL\n", __func__);
    OnvifCmdSend(&url, ReplyMsg, sizeof(ReplyMsg));
    if(OnvifParserSystemInfo("MAC Address", ReplyMsg, value) == OK) {
	sscanf(	value, "%2s:%2s:%2s:%2s:%2s:%2s", &gOnvifConf.macar[0], &gOnvifConf.macar[2], 
		&gOnvifConf.macar[4], &gOnvifConf.macar[6], &gOnvifConf.macar[8], &gOnvifConf.macar[10]); 
	gOnvifConf.macar[12] = '\0'; 
    } else { /* give a fake mac address */
	sprintf(gOnvifConf.macar, "000f7c000001");
    }
#ifdef HAVE_ONVIF_DEBUG
    L2("IP:'%s',URL='%s',mac='%s'\n", gOnvifConf.CurrentIP, gOnvifConf.WsdlUrl, gOnvifConf.macar);
#endif

    if(OnvifParserSystemInfo("Serial Port", ReplyMsg, value) == OK) {
        serialPorts = atoi(value);
        if((serialPorts < 0) || (serialPorts > 1)) serialPorts = 0;
    }
    if(OnvifParserSystemInfo("Firmware Version", ReplyMsg, value) == OK) {	
        snprintf(gOnvifConf.fwVer, sizeof(gOnvifConf.fwVer), "%s", value);
	if (strstr (value, "-AC")) {/* ACTi brand */
	    gOnvifConf.brandACTi = 1;
            snprintf(gOnvifConf.companyName, sizeof(gOnvifConf.companyName), "ACTi Corporation");
            if(OnvifParserSystemInfo("Production ID", ReplyMsg, value) == OK) {
                snprintf(gOnvifConf.serialNum, sizeof(gOnvifConf.serialNum), "%s", value);
                snprintf(gOnvifConf.ModelName, ONVIF_MODELNAME_LEN, "%s", value);
            } else {
                snprintf(gOnvifConf.serialNum, sizeof(gOnvifConf.serialNum), "Unknown");
                snprintf(gOnvifConf.ModelName, ONVIF_MODELNAME_LEN, "Unknown");
            }
        } else { /* NB firmware */
            gOnvifConf.brandACTi = 0;
            OnvifGetOemConf();
            if(OnvifParserSystemInfo("Company Name", ReplyMsg, value) == OK) {
                snprintf(gOnvifConf.companyName, sizeof(gOnvifConf.companyName), "%s", value);
            } else {
                snprintf(gOnvifConf.companyName, sizeof(gOnvifConf.companyName), "Company Name");
            }
        }
    }
    if(OnvifParserSystemInfo("DI", ReplyMsg, value) == OK) {
	sscanf(value, "%1d", &gOnvifConf.DIs);
	if (gOnvifConf.DIs > 0) gOnvifConf.DIEnable = true_;
	else                    gOnvifConf.DIEnable = false_;
    }
    if(OnvifParserSystemInfo("DO", ReplyMsg, value) == OK) {
	sscanf(value, "%1d", &gOnvifConf.DOs);
	if (gOnvifConf.DOs > 0) {
	    gOnvifConf.DOEnable = true_;
	    for(i = 0 ; i < MAX_DO_NUM ; i ++) {
		if(i < gOnvifConf.DOs) { /* this is valid DO port */
                    gOnvifConf.DOSetting[i].Mode = Bistable;
		    strcpy(gOnvifConf.DOSetting[i].DelayTime, "PT0S");
		    gOnvifConf.DOSetting[i].IdleState = _open_;
		    gOnvifConf.DOSetting[i].state = ONVIF_STATE_CLOSE;
		}
	    }
	} else gOnvifConf.DOEnable = false_;
    }
    /* find the platform */
    if(OnvifParserSystemInfo("Platform", ReplyMsg, value) == OK) {
        //fprintf(stdout, "%s:Platform='%s'\n", __func__, value);
        if((value[0] == 'A') && (value[1] == '1')) gOnvifConf.platform = ONVIF_PLATFROM_A1;
        else if(value[0] == 'T') gOnvifConf.platform = ONVIF_PLATFROM_T;
        else if(value[0] == 'K') gOnvifConf.platform = ONVIF_PLATFROM_K;
        else gOnvifConf.platform = ONVIF_PLATFROM_UNKNOWN;
        //fprintf(stdout, "%s:Platform='%s', %d\n", __func__, value, gOnvifConf.platform);
    }
	if(OnvifParserSystemInfo("MAX_VIDEO_STREAMS", ReplyMsg, value) == OK) {
		gOnvifConf.numStreams = atoi(value);
	}else{
		gOnvifConf.numStreams = 2;
	}
	fprintf(stdout, "%s: gOnvifConf.numStreams = %d\n", __func__, gOnvifConf.numStreams);
	
	//Init Event Queue
	InitEventQueue(); 

    if(OnvifParserSystemInfo("VIDEO_RESOLUTION_CAP", ReplyMsg, value) == OK) {
	if(value[0] == 'N' || value[1] == 'N') gOnvifConf.tv = ONVIF_NTSC;
	else gOnvifConf.tv = ONVIF_PAL;
	sscanf(value, "%*1[NP]%dx%d", &gOnvifConf.maxResWidth, &gOnvifConf.maxResHeight);
	OnvifPatch1080PResolutionForTK(&gOnvifConf.maxResHeight);	
	pRight = strrchr(value, ',');
	if(pRight == NULL) pRight = value;
	    sscanf(pRight, ",%*1[NP]%dx%d", &gOnvifConf.minResWidth, &gOnvifConf.minResHeight);
	    OnvifPatch1080PResolutionForTK(&gOnvifConf.minResHeight);
	    pLeft = value;
	    gOnvifConf.ResCapNum = 0;
	    sscanf(pLeft, "%*1[NP]%dx%d", &gOnvifConf.ResCap[gOnvifConf.ResCapNum].Width,
		   	   &gOnvifConf.ResCap[gOnvifConf.ResCapNum].Height);
	    OnvifPatch1080PResolutionForTK(&gOnvifConf.ResCap[gOnvifConf.ResCapNum].Height);
	    do {
			pLeft = strchr(pLeft, ',');
			if(pLeft != NULL) {
		    	gOnvifConf.ResCapNum++;
		    	pLeft++;
		    	sscanf(pLeft, "%*1[NP]%dx%d", &gOnvifConf.ResCap[gOnvifConf.ResCapNum].Width, 
			   		   &gOnvifConf.ResCap[gOnvifConf.ResCapNum].Height);
		    	OnvifPatch1080PResolutionForTK(&gOnvifConf.ResCap[gOnvifConf.ResCapNum].Height);
			}
	    } while(pLeft != NULL);
	    gOnvifConf.ResCapNum++;
	}
	if(gOnvifConf.numStreams > 1) {
		if(OnvifParserSystemInfo("VIDEO2_RESOLUTION_CAP", ReplyMsg, value) == OK) {
	    	sscanf(value, "%*1[NP]%dx%d", &gOnvifConf.maxResWidth2, &gOnvifConf.maxResHeight2);
	    	OnvifPatch1080PResolutionForTK(&gOnvifConf.maxResHeight2);
	    	pRight = strrchr(value, ',');
	    	if(pRight) sscanf(pRight, ",%*1[NP]%dx%d", &gOnvifConf.minResWidth2, &gOnvifConf.minResHeight2);
	    	OnvifPatch1080PResolutionForTK(&gOnvifConf.minResHeight2);
	    	pLeft = value;
	    	gOnvifConf.ResCapNum2 = 0;
	    	sscanf(pLeft, "%*1[NP]%dx%d", &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Width,
                   &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
	    	OnvifPatch1080PResolutionForTK(&gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
	    	do {
				pLeft = strchr(pLeft, ',');
				if(pLeft != NULL) {
		    		gOnvifConf.ResCapNum2++;
		    		pLeft++;
		    		sscanf(pLeft, "%*1[NP]%dx%d", &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Width, 
			   		       &gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
		    		OnvifPatch1080PResolutionForTK(&gOnvifConf.ResCap2[gOnvifConf.ResCapNum2].Height);
				}
	    	} while(pLeft != NULL);
	    	gOnvifConf.ResCapNum2 ++;
		} else { /* force to single streaming mode */
			gOnvifConf.numStreams = 1;
		}
	}
	if(gOnvifConf.numStreams == 1) { /* this camera is in single streaming mode */
	    gOnvifConf.maxResWidth2 = gOnvifConf.maxResWidth;
	    gOnvifConf.maxResHeight2 = gOnvifConf.maxResHeight;
	    gOnvifConf.minResWidth2 = gOnvifConf.minResWidth;
	    gOnvifConf.minResHeight2 = gOnvifConf.minResHeight;	
	    gOnvifConf.ResCapNum2 = gOnvifConf.ResCapNum;
	    for(i = 0 ; i < gOnvifConf.ResCapNum2; i ++) {
			gOnvifConf.ResCap2[i].Width = gOnvifConf.ResCap[i].Width; 
			gOnvifConf.ResCap2[i].Height = gOnvifConf.ResCap[i].Height; 
	    }
	}
	/* ENCODER_CAP */
	gOnvifConf.MJPEG_Enable = true_;
	gOnvifConf.H264_Enable = true_;
	gOnvifConf.MPEG4_Enable = false_;
	if(OnvifParserSystemInfo("ENCODER_CAP", ReplyMsg, value) == OK) {
	    fprintf(stdout, "%s:ENCODER_CAP='%s'\n", __func__, value);
	    if (strstr (value, "MPEG4") != NULL) gOnvifConf.MPEG4_Enable = true_; 
	}
	/* PTZ */
	gOnvifConf.PTEnable = false_;
	gOnvifConf.ZoomEnable = false_;
	if(OnvifParserSystemInfo("PT_ENABLE", ReplyMsg, value) == OK) {
	    if(strcmp(value, "0") == 0) gOnvifConf.PTEnable = false_;
	    else                        gOnvifConf.PTEnable = true_;
	}
	if(OnvifParserSystemInfo("ZOOM_LENS", ReplyMsg, value) == OK) {
	    if (strncasecmp(value, "None", 4) != 0) gOnvifConf.ZoomEnable = true_;
	    else                                    gOnvifConf.ZoomEnable = false_;
	}
	/* follow the serial port to set the PTZ alternative functions */
	gOnvifConf.PTEnableBy485 = false_;
	gOnvifConf.ZoomEnableBy485 = false_;
	if(serialPorts > 0) {
	    if(gOnvifConf.PTEnable == false_)   gOnvifConf.PTEnableBy485 = true_;
	    if(gOnvifConf.ZoomEnable == false_) gOnvifConf.ZoomEnableBy485 = true_;
	}
	if(OnvifParserSystemInfo("Audio", ReplyMsg, value) == OK) {
		if(atoi(value) == 0) gOnvifConf.AudioEnable = false_;
		else                 gOnvifConf.AudioEnable = true_;
		/*
	    if(strncasecmp(value, "None", 4) != 0) gOnvifConf.AudioEnable = true_;
	    else				   gOnvifConf.AudioEnable = false_;
		*/
	}
#ifdef HAVE_ONVIF_DEBUG
	L2("AudioEnable=%d(%s)\n", gOnvifConf.AudioEnable, value);
#endif
	GetMcastInfo ();
	GetImagingInfo ();
	VideoEncoderInit ();
	ImagingConfInit (); 
	GetPtzInfo (); 
	PTZNodeInit (); 
	PTZConfInit (&gOnvifConf.PTZConfig); 
	PTZConfInit (&tmpPTZConf); 
	AudioConfInit ();
	/* EndPoint Address */
	GenerateUrnUUiD (gOnvifConf.EndpointAddr);
	gOnvifConf.AppSequence.InstanceId = time (NULL);
	gOnvifConf.AppSequence.MessageNumber = 0;
	gOnvifConf.Scopes.location_count = 1;	//default is 1
	/* definition MPEG4 profile type */
	gOnvifConf.ProfileType = SP;
	/* definition H264 profile type */
	gOnvifConf.H264ProfileType = Baseline;
	/* NetworkInterfaces */
	gOnvifConf.rtsp_status = true_;
	gOnvifConf.from_dhcp = false_;
	L4("PTZ enabled=%d/%d, RS485 PTZ=%d/%d\n", gOnvifConf.PTEnable, gOnvifConf.ZoomEnable,
	    gOnvifConf.PTEnableBy485, gOnvifConf.ZoomEnableBy485);
}

int OnvifDiscoveryThreadCreate_main (OnvifReqValue *Req) {
    int lenName = strlen(Req->Name);
    int lenPwd  = strlen(Req->Pwd);
    pthread_t onvifdiscovery_t = 0;


    if(	(lenName > 0) && (lenName < ONVIF_ACCOUNT_NAME_LEN) &&
	(lenPwd > 0)  && (lenPwd < ONVIF_ACCOUNT_PWD_LEN) ) {
	config_change = false_;
	OnvifConfInit(Req->Name, Req->Pwd, Req->HttpPort);
	OnvifDefaultConf ();
	(void)OnvifConfFile2Bin (CONF_FILE_ONVIF);
	if (gOnvifConf.Scopes.size <= 0) ScopeDefaultConf ();
	PersistStateInit (); 
#if MYYOU_ONVIF_DEBUG
	OnvifDumpConf();
#endif
	/* create the thread */
	if (pthread_create (&onvifdiscovery_t, NULL, DiscoveryUnicastThread, NULL)) {
	    L1("Error. create DiscoveryUnicastThread\n");
	    gOnvifConf.state = ONVIF_STATE_INIT;
	    return ERR;
	}
	sleep(1);
	DiscoveryMulticast_Hello();
	config_change = true_;
	return OK;
    }
    L1("Name or Pwd is NULL\n");
    gOnvifConf.state = ONVIF_STATE_INIT;
    return ERR;
}

int OnvifDiscoveryThreadCreate (char *Name, char *Pwd, int HttpPort)
{
	static OnvifReqValue Req;

	if((Name == NULL) || (Pwd == NULL))
	{
		L1("Name or Pwd is NULL\n");
		return ERR;
	}
	if((strlen(Name) > ONVIF_ACCOUNT_NAME_LEN - 1) || (strlen(Pwd) > ONVIF_ACCOUNT_PWD_LEN - 1))
	{
		L1("the length of Name or Pwd is too long");
		return ERR;
	}

	strcpy(Req.Name, Name);
	strcpy(Req.Pwd, Pwd);
	Req.HttpPort = HttpPort;

	if(gOnvifConf.state == ONVIF_STATE_RUN) {
		L1("Error. DiscoveryUnicastThread is running. Need stop it first\n");
		return ERR;
	}
	return OnvifDiscoveryThreadCreate_main(&Req);
}
void *thread_onvif_handler (void *arg)
{
	struct soap *soap = NULL;
	struct tOnvifSocket *onvifSock = (struct tOnvifSocket *) arg;
	int socket = 0;

    socket = onvifSock->sock;
    onvifSock->transfer = 1;

    (void)OnvifSemLock();
    pthread_detach(pthread_self());
    gOnvifRequests ++;
    //fprintf(stdout, "%s: sock=%d, gOnvifRequests=%d\n", __func__, socket, gOnvifRequests);
    soap = soap_new ();
    if(soap) {
#if HAVE_SOAP_HTTP_DA
        soap_register_plugin (soap, http_da);
#endif
        soap->socket = socket;
        soap_serve (soap);
        soap_destroy (soap);
        soap_end (soap);
        soap_free (soap);
    } else close(socket);
    
    OnvifUsedCountMinus(&gOnvifRequests);
    (void)OnvifSemUnlock();
    //fprintf(stdout, "%s: unlock sock=%d gOnvifRequests=%d\n", __func__, socket, gOnvifRequests);
	pthread_exit (NULL);
}

static int OnvifHttpReplyServerError(int sock) {
    char   StrNow[64];
    char   buf[512];
    int    len  = 0;
    time_t tnow;

    tnow = time(NULL);
    (void)strftime(StrNow, sizeof(StrNow), "%a, %d %b %Y %H:%M:%S GMT", gmtime(&tnow));
    len = snprintf( buf, sizeof(buf),
                    "HTTP/1.1 503 Service Unavailable\r\n"
                    "Server: Httpd v1.0 05may2008\r\n"
                    "Content-Type: text/plain\r\n"
                    "Content-Length: 0\r\n"
                    "Date: %s\r\n"
                    "Last-Modified: %s\n"
                    "Accept-Ranges: bytes\r\n"
                    "Connection: Close\r\n"
                    "Cache-Control: no-cache,no-store\r\n\r\n",
                    StrNow, StrNow);
    return write(sock, buf, len);
}

int soap_handler (int sock, void *conn) {
    pthread_t onvif_t;
	struct tOnvifSocket onvifSock;
	int i = 0;
   
    if (gOnvifConf.state == ONVIF_STATE_RUN) {
        /* create a thread to handle this request if the onvif service is idle */
        if(gOnvifRequests < 2) { //Keep in 1 connection only
			onvifSock.sock = sock;
			onvifSock.transfer = 0;
            if(pthread_create(&onvif_t, NULL, thread_onvif_handler, &onvifSock) == 0) {
                for(i = 0 ; i < 200 ; i ++) {
					if(onvifSock.transfer == 1) return OK;
					usleep(20*1000);
				}
				fprintf(stderr, "%s:error, thread_onvif_handler is not taken sock %d\n", __func__, sock);
                return OK;
            }
            fprintf(stderr, "%s:error, create thread_onvif_handler\n", __func__);
        } else fprintf(stderr, "%s:error, busy, gOnvifRequests=%d, sock=%d\n", __func__, gOnvifRequests, sock);
    } else fprintf(stderr, "%s:error, onvif is not running. gOnvifConf.state=%d\n", __func__, gOnvifConf.state);
    /* the onvif server is not available now, reject the connection */
    (void)OnvifHttpReplyServerError(sock); 
    return ERR; /* the http lib will close this socket when return ERR */
}

int OnvifSemLock(void) {
    if(gOnvifSemInit) {
        if(sem_wait(&gOnvifSem) == 0) return OK;
        fprintf(stderr, "%s:error in sem_wait %d\n", __func__, errno);
    } else {
		if (sem_init (&gOnvifSem, 0, 1) == 0) {
			gOnvifSemInit = 1;
			if(sem_wait(&gOnvifSem) == 0) return OK;
            fprintf(stderr, "%s:error in sem_wait %d\n", __func__, errno);
		} else fprintf(stderr, "%s:error in sem_init %d\n", __func__, errno);
    }
    return ERR;
}
int OnvifSemUnlock(void) {
    if(gOnvifSemInit) {
        if(sem_post(&gOnvifSem) == 0) return OK;
        fprintf(stderr, "%s:error in sem_post %d\n", __func__, errno);
        return ERR;
    }
    return OK;
}
#if MYYOU_ONVIF_DEBUG
static void OnvifDumpConf(void) {
	int i = 0;
	
	fprintf(stdout, "%s: ********** dump onvif conf **********\n", __func__);
	fprintf(stdout, "DIO=%d,%d, state[%d]=", gOnvifConf.DIs, gOnvifConf.DOs, MAX_DI_NUM);
	for(i = 0 ; i < MAX_DI_NUM ; i ++) fprintf(stdout, "%d,", gOnvifConf.DICurrnetDefault[i]);
	fprintf(stdout, "\n");
	fprintf(stdout, "stream 1 resolution cap %d,", gOnvifConf.ResCapNum);
	for(i = 0 ; i < gOnvifConf.ResCapNum ; i ++) fprintf(stdout, "%dx%d,", gOnvifConf.ResCap[i].Width, gOnvifConf.ResCap[i].Height);
	fprintf(stdout, "\nmax:%dx%d, min:%dx%d\n",
			gOnvifConf.maxResWidth, gOnvifConf.maxResHeight, gOnvifConf.minResWidth, gOnvifConf.minResHeight);
	fprintf(stdout, "stream 2 resolution cap %d,", gOnvifConf.ResCapNum2);
	for(i = 0 ; i < gOnvifConf.ResCapNum2 ; i ++) fprintf(stdout, "%dx%d,", gOnvifConf.ResCap2[i].Width, gOnvifConf.ResCap2[i].Height);
	fprintf(stdout, "\nmax:%dx%d, min:%dx%d\n",
			gOnvifConf.maxResWidth2, gOnvifConf.maxResHeight2, gOnvifConf.minResWidth2, gOnvifConf.minResHeight2);
	fprintf(stdout, "mp4 profile=%s, h264 profile=%s\n",
			(gOnvifConf.ProfileType==SP)?"SP":(gOnvifConf.ProfileType==ASP)?"ASP":"unknown",
			(gOnvifConf.H264ProfileType==Baseline)?"baseline":
			(gOnvifConf.H264ProfileType==Main)?"main":
			(gOnvifConf.H264ProfileType==High)?"high":"unknown");
	fprintf(stdout, "video source token:%d\n", gOnvifConf.SourceTokenCnt);
	for(i = 0 ; i < gOnvifConf.SourceTokenCnt ; i ++) {
		fprintf(stdout, "src %d:%s,fps=%d,%dx%d, imaging...\n", i+1,
				gOnvifConf.SourceToken[i].Token, gOnvifConf.SourceToken[i].FrameRate,
				gOnvifConf.SourceToken[i].res.Width, gOnvifConf.SourceToken[i].res.Height);
	}
	fprintf(stdout, "video source:%d\n", gOnvifConf.VsCnt);
	for(i = 0 ; i < MAX_VS_LIST ; i ++) {
		fprintf(stdout, "src %d:%s,%s,cnt=%d,src idx=%d,(%d,%d),(%d,%d),forced=%d\n", i+1,
				gOnvifConf.vsConf[i].Name, gOnvifConf.vsConf[i].token,
				gOnvifConf.vsConf[i].UseCount, gOnvifConf.vsConf[i].SourceTokenIdx,
				gOnvifConf.vsConf[i].b.x, gOnvifConf.vsConf[i].b.y, gOnvifConf.vsConf[i].b.width, gOnvifConf.vsConf[i].b.height,
				gOnvifConf.vsConf[i].ForcePersistence);
	}
	fprintf(stdout, "video encoder:%d\n", gOnvifConf.VeCnt);
	for(i = 0 ; i < MAX_VE_LIST ; i ++) {
        if(gOnvifConf.veConf[i].valid == 0) continue;
		fprintf(stdout, "enc %d:valid=%d,vSrc=%d,%s,%s,cnt=%d,enc=%s,%dx%d,%d\n", i+1,
				gOnvifConf.veConf[i].valid,
				gOnvifConf.veConf[i].videoSrc, gOnvifConf.veConf[i].Name, gOnvifConf.veConf[i].token,
				gOnvifConf.veConf[i].UseCount,
				(gOnvifConf.veConf[i].Encoding==H264)?"h264":
				(gOnvifConf.veConf[i].Encoding==JPEG)?"mjpeg":
				(gOnvifConf.veConf[i].Encoding==MPEG4)?"mpeg4":"unknown",
				gOnvifConf.veConf[i].r.Width, gOnvifConf.veConf[i].r.Height,
				gOnvifConf.veConf[i].Quality);
		fprintf(stdout, "      fps=%d,interval=%d,rate=%d\n", 
				gOnvifConf.veConf[i].rc.FrameRateLimit, gOnvifConf.veConf[i].rc.EncodingInterval,
				gOnvifConf.veConf[i].rc.BitrateLimit);
		if(gOnvifConf.veConf[i].Encoding==H264) {
			fprintf(stdout, "      gop=%d,profile=%s\n",
					gOnvifConf.veConf[i].t.H264.GovLength, 
					(gOnvifConf.veConf[i].t.H264.H264Profile==Baseline)?"baseline":
					(gOnvifConf.veConf[i].t.H264.H264Profile==Main)?"main":
					(gOnvifConf.veConf[i].t.H264.H264Profile==High)?"high":"unknown");
		}
		if(gOnvifConf.veConf[i].Encoding==MPEG4) {
			fprintf(stdout, "      gop=%d,profile=%s\n",
					gOnvifConf.veConf[i].t.MPEG4.GovLength, 
					(gOnvifConf.veConf[i].t.MPEG4.Mpeg4Profile==SP)?"sp":
					(gOnvifConf.veConf[i].t.MPEG4.Mpeg4Profile==ASP)?"asp":"unknown");
		}
		fprintf(stdout, "      mcst: type=%s,addr=%s,port=%d,ttl=%d,auto=%d,%s\n",
				(gOnvifConf.veConf[i].Multicast.Type==IPv4_)?"ipv4":"unknown",
				gOnvifConf.veConf[i].Multicast.IPv4Address, gOnvifConf.veConf[i].Multicast.Port,
				gOnvifConf.veConf[i].Multicast.TTL, gOnvifConf.veConf[i].Multicast.AutoStart,
				gOnvifConf.veConf[i].SessionTimeout);		
	}
	fprintf(stdout, "audio src:%d, %s, ch=%d\n", gOnvifConf.sizeAS,
			gOnvifConf.AudioSource.token, gOnvifConf.AudioSource.Channels);
	fprintf(stdout, "audio src conf:%s,%s,cnt=%d, src token=%s\n", gOnvifConf.asConf.Name, gOnvifConf.asConf.token,
			gOnvifConf.asConf.UseCount, gOnvifConf.asConf.SourceToken);
	fprintf(stdout, "audio enc:%d, %s,%s cnt=%d,%s,%d,%d,%s\n", gOnvifConf.sizeAeConf,
			gOnvifConf.aeConf.Name,gOnvifConf.aeConf.token, gOnvifConf.aeConf.UseCount,
			(gOnvifConf.aeConf.Encoding==G711)?"g711":"unknown",
			gOnvifConf.aeConf.Bitrate, gOnvifConf.aeConf.SampleRate, gOnvifConf.aeConf.SessionTimeout);
	fprintf(stdout, "    mcast:type=%s,addr=%s,port=%d,ttl=%d,auto=%d\n",
			(gOnvifConf.aeConf.Multicast.Type==IPv4_)?"ipv4":"unknown",
			gOnvifConf.aeConf.Multicast.IPv4Address, gOnvifConf.aeConf.Multicast.Port,
			gOnvifConf.aeConf.Multicast.TTL, gOnvifConf.aeConf.Multicast.AutoStart);
	fprintf(stdout, "meta:valid=%d,%s,%s,cnt=%d,type=%s,addr=%s,auto=%d,%s\n",
			gOnvifConf.meConf.valid, gOnvifConf.meConf.Name, gOnvifConf.meConf.token,
			gOnvifConf.meConf.UseCount,
			(gOnvifConf.meConf.IPType==IPv4_)?"ipv4":"unknown",
			gOnvifConf.meConf.IPv4Address,gOnvifConf.meConf.AutoStart, gOnvifConf.meConf.SessionTimeout);
	fprintf(stdout, "profile:%d\n", gOnvifConf.ProfileCnt);
	for(i = 0 ; i < MAX_PROFILE_LIST ; i ++) {
        if(gOnvifConf.profile[i].valid) {
            fprintf(stdout, "profile %d: valid=%d,ro=%d,%s,%s,vsIdx=%d,veIdx=%d\n", i+1,
                    gOnvifConf.profile[i].valid,gOnvifConf.profile[i].readOnly,
                    gOnvifConf.profile[i].Name, gOnvifConf.profile[i].token,
                    gOnvifConf.profile[i].vsIdx, gOnvifConf.profile[i].veIdx);
        }
	}
    fprintf(stdout, "encoder enabled: h264/mpeg4/mjpeg=%d/%d/%d\n",
            gOnvifConf.H264_Enable, gOnvifConf.MPEG4_Enable, gOnvifConf.MJPEG_Enable);
    fprintf(stdout, "PT enabled=%d,%d, Zoom enabled=%d,%d\n",
            gOnvifConf.PTEnable, gOnvifConf.PTEnableBy485, gOnvifConf.ZoomEnable, gOnvifConf.ZoomEnableBy485);
}

#endif

