#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <assert.h>
#include "ftplib.h"


// the ftp content structure
typedef struct ftpCnt {
    char host[64];
    char user[32];
    char pass[32];
    unsigned int port;
    int mode;
    int timer;
    char destfd[128];
    char destfnm[128];
}ftpCnt;

static ControlInfo *pCtrl = NULL;

char strarr[10]={"TryTry!"};

int main()
{
    FILE *fp;
    int irc, nBytes;
    int count = 5;

    ftpCnt one_ftpCnt, *ftpCnt_ptr = &one_ftpCnt;
   
    DataInfo *pData;
    FtpContent sCnt;

    fp = fopen("struct-file","r+");
    assert(fp != NULL);

    // prpare for reading from the beginning of the file
    rewind(fp);

    // read from the file one ftpContent at a time
    irc = fread(ftpCnt_ptr, sizeof(ftpCnt), 1, fp);

    strcpy(sCnt.user, ftpCnt_ptr->user);
    strcpy(sCnt.pass, ftpCnt_ptr->pass);
    strcpy(sCnt.host, ftpCnt_ptr->host);
    sCnt.port = ftpCnt_ptr->port;
    sCnt.mode = ftpCnt_ptr->mode;
    sCnt.timer = ftpCnt_ptr->timer;

    if(FTPLIB_ACTIVE == ftpCnt_ptr->mode)
        printf("active mode\n");
    else if (FTPLIB_PASSIVE == ftpCnt_ptr->mode)
        printf("passive mode\n");

    //Connect
    if (FTP_SUCCESS == FtpConnect(&sCnt, &pCtrl))
        printf("Connect to FTP server %s\n", sCnt.host);
    else
    {
        printf("Unable to connect to node %s\n", sCnt.host);
	return 0;
    }
    
    //New Dir
    if (FTP_SUCCESS == FtpNewDir(ftpCnt_ptr->destfd, pCtrl))
        printf("mkdir %s\n", ftpCnt_ptr->destfd);
    else
        printf("Unable to mkdir\n");

    //Open
    if (FTP_SUCCESS == FtpOpen(ftpCnt_ptr->destfnm, pCtrl, &pData))
        printf("Open %s\n", ftpCnt_ptr->destfnm);
    else
        printf("Open failure\n");

    while(0 < count)
    {
	nBytes = FtpPutDataFromMem(strarr, sizeof(strarr), pData);
	if (FTP_FAIL == nBytes)
	    printf("Unable to send files from Mem\n");
	else
	    printf("Send %d bytes From Mem\n", nBytes);

        sleep(1);
        printf("count: %d\n", count);
        count--;
    }

    if(FTP_SUCCESS == FtpClose(pData))
        printf("Close\n");
    else
        printf("Close failure\n");

    FtpDisconnect(pCtrl);
    printf("Disconnect!\n");
    
    return 0;
}
