#include <stdio.h>

void DefaultRulesInit (void)
{
	FILE *fd;

	fd = fopen ("/etc/DefaultRules.conf", "w+");
	if (!fd)
		return;

	fprintf (fd, "SERVER_TCP_PORTS=5001,49152,");
	fprintf (fd, "%d,", gsrv.NotOnFly.PortHttp);
	fprintf (fd, "%d,", gsrv.NotOnFly.PortHttps);
	fprintf (fd, "%d,", gsrv.conf.Stream.PortControl);
	fprintf (fd, "%d,", gsrv.conf.Stream.PortVideo);
	fprintf (fd, "%d\n", gsrv.conf.Stream.PortRtsp);

	fprintf (fd, "SERVER_UDP_PORTS=5001,161,162,1900,");
	fprintf (fd, "%d,", gsrv.conf.Host.PortSearch[0]);
	fprintf (fd, "%d\n", gsrv.conf.Host.PortSearch[1]);
	fclose (fd);

	my_system ("/usr/sbin/DefaultRules.sh", 0);

	return;
}

void IpFilterInit (void)
{
	FILE *fd;
	int i;

	fd = fopen ("/etc/IpFilter.conf", "w+");
	if (!fd)
		return;

	fprintf (fd, "IP_FILTER_STATE=%s\n", nvram_safe_get("IP_FILTER_STATE"));
	fprintf (fd, "IP_FILTER_TYPE=%s\n", nvram_safe_get("IP_FILTER_TYPE"));
	fprintf (fd, "IP_FILTER_RULE=\"");
	for (i=1; i<=16; i++)
		fprintf (fd, "%s, ", nvram_safe_getf ("IP_FILTER_RULE%02d", i));
	fprintf (fd, "\"\n");
	fclose (fd);

	my_system ("/usr/sbin/IpFilter.sh", 0);

	return;
}

void FirewallInit (void) {
	DefaultRulesInit ();
	IpFilterInit ();
}

int main()
{
	printf ("This is just a example.\n");
	//FirewallInit ();
}
