#!/bin/sh
# Version : v1.0.01
# Firewall Share Library
# Ip Filter shell script
# Description :
# 		This script will setup ip filter rule based by url: IP_FILTER_RULE
# Input :
# 		/etc/IpFilter.conf

. /etc/IpFilter.conf
IPTABLES="/sbin/iptables -t mangle "

#Checking if there is a existed IP_FILTER chain
$IPTABLES -L IP_FILTER -n > /dev/null 2>&1
if [ $? -eq 1 ]; then
        $IPTABLES -N IP_FILTER
fi
$IPTABLES -F
$IPTABLES -A INPUT -j IP_FILTER
$IPTABLES -I IP_FILTER -s 127.0.0.1/32 -j ACCEPT

if [ $IP_FILTER_STATE = "0" ]; then
        exit 0
fi

for RULE in $IP_FILTER_RULE ;
do
        STAT=`echo -n $RULE|cut -d ',' -f 2`
        IP=`echo -n $RULE|cut -d ',' -f 3`
        MASK=`echo -n $RULE|cut -d ',' -f 4`

        if [ $STAT -eq 1 ]; then
			#1 means matched need to be pass
			if [ $IP_FILTER_TYPE = "1" ]; then 
				$IPTABLES -A IP_FILTER -s $IP/$MASK -j RETURN
			else
				$IPTABLES -A IP_FILTER -s $IP/$MASK -j DROP
			fi	
        fi
done
#The not matched rest's need to be DROP
if [ $IP_FILTER_TYPE = "1" ]; then 
	$IPTABLES -A IP_FILTER -j DROP
fi

# if TYPE:0 Deny means those packets matched is needed
# to be DROP, otherwise will return to the caller chain 
# (ACCEPT and continueing on).

