#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "8021x_api.h"

/*
 * Full filename in the default directory
 */
char *default_fullname[] = {IEEE8021X_DEFAULT_PATH IEEE8021X_CA_FILE, 
		     	    IEEE8021X_DEFAULT_PATH IEEE8021X_CLIENTCERT_FILE, 
		     	    IEEE8021X_DEFAULT_PATH IEEE8021X_CLIENTPRIV_FILE}; 
/*
 * Full filename at runtime
 */
char *runtime_fullname[] = {IEEE8021X_RUNTIME_PATH IEEE8021X_CA_FILE, 
		     	    IEEE8021X_RUNTIME_PATH IEEE8021X_CLIENTCERT_FILE, 
		     	    IEEE8021X_RUNTIME_PATH IEEE8021X_CLIENTPRIV_FILE}; 
/*
 * short name of certificate and key files
 */
char *sname[] = {IEEE8021X_CA_FILE, 
		 IEEE8021X_CLIENTCERT_FILE, 
		 IEEE8021X_CLIENTPRIV_FILE,
		 IEEE8021X_NONE_FILE}; 

static int query_filename (int ftype, char *retName) {
		FILE *fp = NULL;

		if ((fp = fopen (default_fullname[ftype], "r")) == NULL) {
			strncpy(retName, sname[IEEE8021X_FTYPE_NONE], IEEE8021X_RETMSG_BUFSIZE); 
    	} else {
			strncpy(retName, sname[ftype], IEEE8021X_RETMSG_BUFSIZE); 
       		fclose(fp);
		}
		return IEEE8021X_OK;
}

int ieee8021x_api (int ftype, int op, t8021xApiOp *api) {
	char    buf[READ_SIZE];
	char 	wDefault [IEEE8021X_FILENAME_BUFSIZE],
	 	wRuntime [IEEE8021X_FILENAME_BUFSIZE];
    	FILE    *fp_R = NULL,
            	*fp_W1 = NULL,
            	*fp_W2 = NULL;
    	int     ret_read = 0,
            	ret_write1 = 0,
            	ret_write2 = 0,
            	total_size = 0;

	if (!(ftype >= IEEE8021X_FTYPE_CA && ftype <= IEEE8021X_FTYPE_USERKEY)) {
		fprintf(stdout, "<8021X API: Error file type of certificate.>\n");
        	goto INTERNAL_ERR;
    	}

    	if (!(op >= IEEE8021X_OP_QUERY && op <= IEEE8021X_OP_REMOVE)) {
		fprintf(stdout, "<8021X API: Error operation mode.>\n");
        	goto INTERNAL_ERR;
    	}

	if (op == IEEE8021X_OP_QUERY) {
		query_filename (ftype, api->retMsg);
    	} else if (op == IEEE8021X_OP_UPLOAD) {
        	if (api->inputArgs != NULL && api->argsLen > 0 && \
           	    api->argsLen == strlen(api->inputArgs) && api->argsLen <= IEEE8021X_INPUTARGS_BUFSIZE) {
			fp_R = fopen (api->inputArgs, "r");
                	if (fp_R == NULL) {
                		fprintf(stdout, "<8021X API: open file %s error!>\n", api->inputArgs);
                    		goto  FILE_ERR4;
                	}
			strncpy (wDefault, default_fullname[ftype], IEEE8021X_FILENAME_BUFSIZE);  
			strncpy (wRuntime, runtime_fullname[ftype], IEEE8021X_FILENAME_BUFSIZE);  

                	fp_W1 = fopen (wDefault, "w");
                	if (fp_W1 == NULL) {
                		fprintf(stdout, "<8021X API: open file %s error!>\n", wDefault);
                    		goto  FILE_ERR3;
                	}

                	fp_W2 = fopen (wRuntime, "w");
                	if (fp_W2 == NULL) {
                    		fprintf(stdout, "<8021X API: open file %s error!>\n", wRuntime);
                    		goto  FILE_ERR2;
                	}

			do {
				memset(buf, 0, READ_SIZE);
                    		ret_read = fread (buf, 1, READ_SIZE, fp_R);
                    		total_size += ret_read;
                    		if (total_size == 0) {
                    			fprintf(stdout, "<8021X API: read file %s error!>\n", api->inputArgs);
					goto  FILE_ERR1;
				} else if (ret_read > 0) {
                        		if((ret_write1 = fwrite(buf, 1, ret_read, fp_W1)) <= 0) {
                        			fprintf(stdout, "<8021X API: write file %s error!>\n", wDefault);
                            			goto  FILE_ERR1;
                        		}
                        		if((ret_write2 = fwrite(buf, 1, ret_read, fp_W2)) <= 0) {
                            			fprintf(stdout, "<8021X API: write file %s error!>\n", wRuntime);
                            			goto  FILE_ERR1;
                        		}
				}
			} while (ret_read > 0);
                	fclose (fp_R);
                	fclose (fp_W1);
                	fclose (fp_W2);
		} else {
        		fprintf(stdout, "<8021X API: Upload: error inputArgs or argsLen.>\n");
            		goto  INTERNAL_ERR;
        	}
        	snprintf (api->retMsg, sizeof (api->retMsg), "OK");
	} else if (op == IEEE8021X_OP_REMOVE) { /* Removing certificate and key files */
		strncpy (wDefault, default_fullname[ftype], IEEE8021X_FILENAME_BUFSIZE);  
        	unlink (wDefault);
        	snprintf (api->retMsg, sizeof (api->retMsg), "OK");
    } else {
        goto INVALID_ERR;
    }
    api->retLen = strlen(api->retMsg);
    return IEEE8021X_OK;

INTERNAL_ERR:   /* Wrong implementation that caused by developer. */
    snprintf (api->retMsg, sizeof (api->retMsg), "ERROR: internal error.");
    api->retLen = strlen(api->retMsg);
    return IEEE8021X_ERROR;
INVALID_ERR:    /* Wrong parameters is given by user. */
    snprintf (api->retMsg, sizeof (api->retMsg), "ERROR: invalid parameters");
    api->retLen = strlen(api->retMsg);
    return IEEE8021X_ERROR;
FILE_ERR1:
    fclose (fp_W2); 
FILE_ERR2:
    fclose (fp_W1); 
FILE_ERR3:
    fclose (fp_R); 
FILE_ERR4:
    snprintf (api->retMsg, sizeof (api->retMsg), "ERROR: internal error.(Exception occurred during file upload.)");
    api->retLen = strlen(api->retMsg);
    return IEEE8021X_ERROR;
}
