/**
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: xsup_common.h
 *
 * Authors: Chris.Hessing@utah.edu and Carsten Grohmann
 *
 * $Id: xsup_common.h,v 1.1 2006/08/25 23:37:18 chessing Exp $
 * $Date: 2006/08/25 23:37:18 $
 */
#ifndef XSUP_COMMON_H_
#define XSUP_COMMON_H_

/** Secure strncpy() replacement
 *
 *  Sets the last position of the buffer to 0. All times.
 *  All parameters are equal to strncpy().
 */
char* Strncpy(char *dest, const char *src, size_t n);

/** Secure free() replacement
 *
 * Check the pointer before freeing and set it to NULL after the memory
 * has been freed 
 */
#define FREE(p) if (p != NULL) {free(p); p=NULL;}

#endif
