/*******************************************************************
 * File: snmp.c
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file fore more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 * $Id: snmp.c,v 1.11 2006/06/01 22:49:49 galimorerpg Exp $
 * $Date: 2006/06/01 22:49:49 $
 * $Log: snmp.c,v $
 * Revision 1.11  2006/06/01 22:49:49  galimorerpg
 * Converted all instances of u_char to uint8_t
 * Fixed a bad #include in the generic frame handler.
 *
 * Revision 1.10  2006/05/26 22:04:58  chessing
 * Fixed some memory access errors, and cleaned up some wext stuff that was causing issues with the madwifi driver in wext mode.
 *
 * Revision 1.9  2006/04/25 01:17:42  chessing
 * LOTS of code cleanups, new error checking/debugging code added, and other misc. fixes/changes.
 *
 * Revision 1.8  2005/09/08 16:27:01  chessing
 * Some small updates to the new state machine code.  First attempt at an auto association mode.  (It mostly works. ;)
 *
 * Revision 1.7  2005/08/09 01:39:14  chessing
 * Cleaned out old commit notes from the released version.  Added a few small features including the ability to disable the friendly warnings that are spit out.  (Such as the warning that is displayed when keys aren't rotated after 10 minutes.)  We should also be able to start when the interface is down.  Last, but not least, we can handle empty network configs.  (This may be useful for situations where there isn't a good reason to have a default network defined.)
 *
 *
 *******************************************************************/

#include <stdlib.h>
#include <string.h>
#include <strings.h>

#include "profile.h"
#include "xsup_debug.h"
#include "snmp.h"

#ifdef USE_EFENCE
#include <efence.h>
#endif

struct snmp_data snmpdata;

void snmp_init()
{
  bzero(&snmpdata, sizeof(snmpdata));
}

void snmp_dump_stats(char *intname)
{
  if (!xsup_assert((intname != NULL), "intname != NULL", FALSE))
    return;

  debug_printf(DEBUG_SNMP, "\nStats for Interface %s :\n\n", intname);
  
  debug_printf(DEBUG_SNMP, "EAPOL Frames RX    : %10d   EAPOL Frames TX    : %10d\n", 
	       snmpdata.dot1xSuppEapolFramesRx, snmpdata.dot1xSuppEapolFramesTx);
  debug_printf(DEBUG_SNMP, "EAPOL Starts TX    : %10d   EAPOL Logoff TX    : %10d\n",
	       snmpdata.dot1xSuppEapolStartFramesTx, snmpdata.dot1xSuppEapolLogoffFramesTx);
  debug_printf(DEBUG_SNMP, "EAPOL Resp. ID TX  : %10d   EAPOL Resp. TX     : %10d\n",
	       snmpdata.dot1xSuppEapolRespIdFramesTx, snmpdata.dot1xSuppEapolRespFramesTx);
  debug_printf(DEBUG_SNMP, "EAPOL Req. ID RX   : %10d   EAPOL Req. RX      : %10d\n",
	       snmpdata.dot1xSuppEapolReqIdFramesRx, snmpdata.dot1xSuppEapolReqFramesRx);
  debug_printf(DEBUG_SNMP, "EAPOL Invalid Frame: %10d   EAP Length Error   : %10d\n",
	       snmpdata.dot1xSuppInvalidEapolFramesRx, snmpdata.dot1xSuppEapLengthErrorFramesRx);
  debug_printf(DEBUG_SNMP, "Last EAPOL Version : %10d   Last EAPOL Src.    :",
	       snmpdata.dot1xSuppLastEapolFrameVersion);
  debug_hex_printf(DEBUG_SNMP, snmpdata.dot1xSuppLastEapolFrameSource, 6);
  debug_printf(DEBUG_SNMP, "EAPOL Success      : %10d   EAPOL Failure      : %10d\n",
	       snmpdata.eapol_success_rx, snmpdata.eapol_fail_rx);
  debug_printf(DEBUG_SNMP, "Backend Timeouts   : %10d\n\n", 
	       snmpdata.backend_timeout);
}

void snmp_inc_dot1xSuppInvalidEapolFramesRx()
{
  snmpdata.dot1xSuppInvalidEapolFramesRx++;
}

void snmp_dot1xSuppLastEapolFrameVersion(int version)
{
  snmpdata.dot1xSuppLastEapolFrameVersion = version;
}

int snmp_get_dot1xSuppLastEapolFrameVersion()
{
  return snmpdata.dot1xSuppLastEapolFrameVersion;
}

void snmp_dot1xSuppEapolLogoffFramesTx()
{
  snmpdata.dot1xSuppEapolLogoffFramesTx++;
}

void snmp_dot1xSuppEapolStartFramesTx()
{
  snmpdata.dot1xSuppEapolStartFramesTx++;
}

void snmp_dot1xSuppEapolReqIdFramesRx()
{
  snmpdata.dot1xSuppEapolReqIdFramesRx++;
}

void snmp_dot1xSuppEapolReqFramesRx()
{
  snmpdata.dot1xSuppEapolReqFramesRx++;
}

void snmp_dot1xSuppEapLengthErrorFramesRx()
{
  snmpdata.dot1xSuppEapLengthErrorFramesRx++;
}

void snmp_eapol_success_rx()
{
  snmpdata.eapol_success_rx++;
}

void snmp_eapol_fail_rx()
{
  snmpdata.eapol_fail_rx++;
}

void snmp_backend_timeout()
{
  snmpdata.backend_timeout++;
}

void snmp_dot1xSuppEapolRespIdFramesTx()
{
  snmpdata.dot1xSuppEapolRespIdFramesTx++;
}

void snmp_dot1xSuppEapolRespFramesTx()
{
  snmpdata.dot1xSuppEapolRespFramesTx++;
}

void snmp_dot1xSuppEapolFramesTx()
{
  snmpdata.dot1xSuppEapolFramesTx++;
}

void snmp_dot1xSuppEapolFramesRx()
{
  snmpdata.dot1xSuppEapolFramesRx++;
}

void snmp_dot1xSuppLastEapolFrameSource(uint8_t *srcmac)
{
  if (!xsup_assert((srcmac != NULL), "srcmac != NULL", FALSE))
    return;

  memcpy(snmpdata.dot1xSuppLastEapolFrameSource, srcmac, 6);
}

