/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.   (See LICENSE file for more info.)
 *
 * File: ipc_callout.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _IPC_CALLOUT_H_
#define _IPC_CALLOUT_H_

#include <sys/socket.h>

#define AUTH_STATE_STOPPED    1
#define AUTH_STATE_RESTART    2
#define AUTH_STATE_START      3
#define AUTH_STATE_RUNNING    4

void ipc_callout_auth_state(struct interface_data *, int *, char *, int,
			    char *, int *);

void ipc_callout_get_ints(struct interface_data *, struct interface_data *, 
			  int *, char *, int, char *, int *);

void ipc_callout_send_error(struct interface_data *, int *, char *, int, 
			    char *);

void ipc_callout_set_password(struct interface_data *, int *, char *, int, 
			      char *, int *);

void ipc_callout_set_tnc(struct interface_data *, int *, char *, int, char *,
			 int *);

void ipc_callout_set_auth_ctrl(struct interface_data *, int *, char *, int, 
			       char *, int *);

void ipc_callout_request_password(int *, char *, int, char *, char *);

void ipc_callout_ping_resp(struct interface_data *, char *, int *);
#endif
