/*******************************************************************
 * EAPTTLS Function header
 * 
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: eapttls.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAPTTLS_H_
#define _EAPTTLS_H_

#include <openssl/ssl.h>
#include <netinet/in.h>
#include "profile.h"

#define TTLS_SESSION_KEY_CONST   "ttls keying material"
#define TTLS_SESSION_KEY_CONST_SIZE    20


int eapttls_setup(struct generic_eap_data *);
int eapttls_process(struct generic_eap_data *, uint8_t *, int, uint8_t *, int *);
int eapttls_get_keys(struct interface_data *);
int eapttls_cleanup(struct generic_eap_data *);
int eapttls_failed(struct generic_eap_data *);

#endif
