/*******************************************************************
 * EAPTLS (RFC 2716) Function header
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 * 
 * File: eaptls.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAPTLS_H_
#define _EAPTLS_H_

#include <openssl/ssl.h>
#include <netinet/in.h>
#include "profile.h"

#define EAPTLS_LENGTH_MORE   0xC0
#define EAPTLS_LENGTH_INCL   0x80
#define EAPTLS_MORE_FRAGS    0x40
#define EAPTLS_START         0x20
#define EAPTLS_ACK           0x00
#define EAPTLS_FINAL         0x00

#define TLS_SESSION_KEY_CONST       "client EAP encryption"
#define TLS_SESSION_KEY_CONST_SIZE  21
#define TLS_SESSION_KEY_SIZE        128

struct tls_vars {
  SSL_CTX *ctx;       // Our OpenSSL context.
  SSL *ssl;
  ENGINE *engine;
  BIO *ssl_in, *ssl_out;
  int resume;                // Should we attempt to resume this connection?
  int resuming;              // Are we in the process of resuming?

  int verify_mode;           // This should be set to SSL_VERIFY_PEER to 
                             // verify the peer certificate, and set to 
                             // SSL_VERIFY_NONE to ignore verification.

  int cnexact;               // Should be the same as the cnexact value for
                             // TTLS or PEAP, depending on which one we are
                             // using.

  char *cncheck;             // Should be the same as the cncheck .....
  char *tlsoutdata, *sessionkeyconst;
  int tlsoutsize,tlsoutptr,sessionkeylen;
  char *phase2data;
  int phase;                 // Which phase are we in?

  int cert_loaded;           // This should be set to TRUE when the user
                             // certificate is loaded.  This allows us to
                             // clear out thisint->tempPwd so that it can
                             // be used by a phase 2 type.

  // This next value needs some explaining.  With TTLS, as soon as the
  // the TLS piece is completed, we are expected to send back a response that
  // contains the inner authentication.  I choose to refer to this as a 
  // "quick" response.  With PEAP, we should simply ACK the final piece of
  // the TLS handshake, and wait for the RADIUS server to send us an inner
  // EAP Request Identity.  This is *not* a quick response.
  int quickResponse;
};

int eaptls_setup(struct generic_eap_data *);
int eaptls_process(struct generic_eap_data *, uint8_t *, int, uint8_t *, int *);
int eaptls_get_keys(struct interface_data *);
int eaptls_cleanup(struct generic_eap_data *);
int eaptls_keyblock(char *);
int eaptls_failed(struct generic_eap_data *);
#endif
