/*******************************************************************
 * EAP-MSCHAPv2 Function Headers
 * 
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: eapmschapv2.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAP_MSCHAPV2_H_
#define _EAP_MSCHAPV2_H_

#include <inttypes.h>
#include "profile.h"

#define MS_CHAPV2_CHALLENGE     1
#define MS_CHAPV2_RESPONSE      2
#define MS_CHAPV2_SUCCESS       3
#define MS_CHAPV2_FAILURE       4
#define MS_CHAPV2_CHANGE_PWD    7

struct mschapv2_vars {
  char *AuthenticatorChallenge;
  char *PeerChallenge;
  char *NtResponse;
  char *keyingMaterial;
};

struct mschapv2_challenge {
  uint8_t OpCode;
  uint8_t MS_CHAPv2_ID;
  uint16_t MS_Length;
  uint8_t Value_Size;
  uint8_t Challenge[16];
  // Everything else in the packet should be the name of the RADIUS server.
};

struct mschapv2_response {
  uint8_t OpCode;
  uint8_t MS_CHAPv2_ID;
  uint16_t MS_Length;
  uint8_t Value_Size;
  uint8_t Peer_Challenge[16];
  uint8_t Reserved[8];
  uint8_t NT_Response[24];
  uint8_t Flags;
};

struct mschapv2_success_request {
  uint8_t OpCode;
  uint8_t MS_CHAPv2_ID;
  uint16_t MS_Length;
  uint8_t MsgField[42];   // S=<auth_string>
};

// A success response is a single byte 0x03, so we really don't need a 
// structure.

int eapmschapv2_setup(struct generic_eap_data *);
int eapmschapv2_process(struct generic_eap_data *, uint8_t *, int, uint8_t *, 
			int *);
int eapmschapv2_get_keys(struct interface_data *);
int eapmschapv2_cleanup(struct generic_eap_data *);
int eapmschapv2_failed(struct generic_eap_data *);

#endif
