/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef __CONFIG_SSID_H__
#define __CONFIG_SSID_H__

struct found_ssids {
  char *ssid_name;
  uint8_t abilities;
  uint8_t *wpa_ie;
  uint8_t wpa_ie_len;
  uint8_t *rsn_ie;
  uint8_t rsn_ie_len;
  uint8_t mac[6];
  unsigned int freq;
  unsigned char quality;
  char signal;
  char noise;

  struct found_ssids *next;
};

void config_ssid_clear();
char *config_ssid_get_desired_ssid(struct interface_data *);
uint8_t config_ssid_get_ssid_abilities();
void config_ssid_get_wpa_ie(uint8_t **, uint8_t *);
void config_ssid_get_rsn_ie(uint8_t **, uint8_t *);
unsigned int config_ssid_get_freq();
uint8_t *config_ssid_get_mac();
void config_ssid_dump();
void config_ssid_set_active_ssid(char *);
int config_ssid_using_wep();
int config_ssid_ssid_known(char *);

// Functions to add information to an existing ESSID node.
void config_ssid_add_freq(unsigned int);
void config_ssid_add_bssid(char *);
void config_ssid_add_rsn_ie(uint8_t *, uint8_t);
void config_ssid_add_wpa_ie(uint8_t *, uint8_t);
void config_ssid_add_ssid_name(char *);
void config_ssid_update_abilities(uint8_t);
void config_ssid_add_qual(unsigned char, char, char);

#endif
