/*******************************************************************
 * Linux wireless extensions interface.
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: cardif_linux.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _CARDIF_LINUX_WEXT_
#define _CARDIF_LINUX_WEXT_

extern struct cardif_funcs cardif_linux_wext_driver;

int cardif_linux_wext_set_WEP_key(struct interface_data *, uint8_t *, int, int);
int cardif_linux_wext_set_ssid(struct interface_data *, char *);
int cardif_linux_wext_set_bssid(struct interface_data *, uint8_t *);
int cardif_linux_wext_check_ssid(struct interface_data *);
int cardif_linux_wext_get_bssid(struct interface_data *, char *);
int cardif_linux_wext_set_ssid(struct interface_data *, char *);
int cardif_linux_wext_wep_associate(struct interface_data *, int);
int cardif_linux_wext_get_ssid(struct interface_data *, char *);
int cardif_linux_wext_scan(struct interface_data *, char);
void cardif_linux_wext_associate(struct interface_data *);
void cardif_linux_wext_use_temp_keys(char);
int cardif_linux_wext_enc_open(struct interface_data *);
int cardif_linux_wext_enc_disable(struct interface_data *thisint);
void cardif_linux_wext_set_zero_keys(struct interface_data *);
void cardif_linux_wext_zero_keys(struct interface_data *);
int cardif_linux_wext_wpa_state(struct interface_data *, char);
int cardif_linux_wext_set_wpa_ie(struct interface_data *, unsigned char *, 
		unsigned int);
int cardif_linux_wext_set_iwauth(struct interface_data *, int, uint32_t, 
				 char *);
int cardif_linux_wext_set_key_ext(struct interface_data *, int, 
				  unsigned char *, int, int, char *, int,
				  char *, int);

void cardif_linux_wext_enc_capabilities(struct interface_data *);

#endif
