/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

void gSettings::populateNetwork(config_network *nethead)
{
    config_network *networks;
    
    networks = nethead;
    
    while (networks)
    {
	if (networks->name)
	{
	    defaultNetCombo->insertItem(QString(networks->name), -1);
	}
	
	networks = networks->next;
    }
}

void gSettings::setConfig(config_globals *globals, config_network *nethead)
{
    globaldata = globals;
    
    // Walk the network list, and populate the default network settings.
    populateNetwork(nethead);
    defaultNetCombo->setCurrentText(globaldata->default_net);
    
    if (strcmp(globals->logfile, "syslog") == 0)
    {
	syslogGroup->setEnabled(true);
	loggingFilePathGroup->setEnabled(false);
	syslogBtn->setChecked(true);
	fileButton->setChecked(false);
    }
    else
    {
	loggingFilePathGroup->setEnabled(true);
	syslogGroup->setEnabled(false);
	logfileEdit->setText(QString(globals->logfile));
	fileButton->setChecked(true);
	syslogBtn->setChecked(false);
    }
    
    if (globals->log_facility)
    {
	logFacility->setCurrentText(QString(globals->log_facility));
    }
    else
    {
	logFacility->setCurrentText(QString("NONE"));
    }
}

void gSettings::fileButton_toggled( bool enabled)
{
    loggingFilePathGroup->setEnabled(enabled);
}


void gSettings::syslogBtn_toggled( bool enabled )
{
    syslogGroup->setEnabled(enabled);
}


void gSettings::selectButton_clicked()
{
    QFileDialog qfd;
    QString filename;

    qfd.setMode(QFileDialog::AnyFile);
    qfd.setFilter( "Xsupplicant log (*.*)" );
    qfd.setCaption(QString("Set Xsupplicant Log File"));
    if (qfd.exec() == QDialog::Accepted)
    {
        logfileEdit->setText(qfd.selectedFile());
    }
}


void gSettings::okayButton_clicked()
{
    if (strcmp(globaldata->default_net, defaultNetCombo->currentText().ascii()) != 0)
    {
	// Our default net has changed.
	free(globaldata->default_net);
	globaldata->default_net = NULL;
	
	globaldata->default_net = strdup(defaultNetCombo->currentText().ascii());
	if (globaldata->default_net == NULL)
	{
	    // Fix!
	    printf("ACK!!!\n");
	    return;
	}
    }
    
    if (fileButton->isChecked())
    {
	// We are logging to a file.
	if (globaldata->log_facility != NULL)
	{
	    free(globaldata->log_facility);
	    globaldata->log_facility = NULL;
	}
	
	if (globaldata->logfile != NULL)
	{
	    free(globaldata->logfile);
	    globaldata->logfile = NULL;
	}
	
	globaldata->logfile = strdup(logfileEdit->text().ascii());
	if (globaldata->logfile == NULL)
	{
	    // XXX Fix!
	    printf("ACK!\n");
	    return;
	}
    }
    else
    {
	// We are sysloging.
	if (globaldata->log_facility != NULL)
	{
	    free(globaldata->log_facility);
	    globaldata->log_facility = NULL;
	}
	
	if (globaldata->logfile != NULL)
	{
	    free(globaldata->logfile);
	    globaldata->logfile = NULL;
	}	
	
	globaldata->logfile = strdup("syslog");
	if (globaldata->logfile == NULL)
	{
	    QMessageBox::critical(this, QString("Memory Allocation"),
				  QString("Couldn't allocate memory to save logfile settings. Some configuration data will be lost."), 1, 0, 0);
	    close();
	    return;
	}
	
	globaldata->log_facility = strdup(logFacility->currentText().ascii());
	if (globaldata->log_facility == NULL)
	{
	    QMessageBox::critical(this, QString("Memory Allocation"),
				  QString("Couldn't allocate memory to save log facility settings.  Some configuration data will be lost."), 1, 0, 0);
	    close();
	    return;
	}
    }
    
    close();
}
