/*
	udpclient.c

	SOAP-over-UDP demo client with zlib compression and WS-Addressing

--------------------------------------------------------------------------------
gSOAP XML Web services tools
Copyright (C) 2001-2008, Robert van Engelen, Genivia, Inc. All Rights Reserved.
This software is released under one of the following two licenses:
GPL or Genivia's license for commercial use.
--------------------------------------------------------------------------------
GPL license.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

Author contact information:
engelen@genivia.com / engelen@acm.org
--------------------------------------------------------------------------------
A commercial use license is available from Genivia, Inc., contact@genivia.com
--------------------------------------------------------------------------------
*/

#include "soapH.h"
#include "udp.nsmap"

int main(int argc, char **argv)
{ struct soap soap;
  struct SOAP_ENV__Header header;
  struct wsa__EndpointReferenceType replyTo;
  char *res;
  int multicast = 1;
  struct ns__echoString r;

  soap_init(&soap);
  if (multicast)
    soap.connect_flags = SO_BROADCAST;
  soap.send_timeout = 1; // 1s timeout
  soap_default_SOAP_ENV__Header(&soap, &header);
  soap.header = &header;
  header.wsa__MessageID = "test01";
  header.wsa__To = "urn:schemas-xmlsoap-org:ws:2005:04:discovery";
  header.wsa__Action = "http://schemas.xmlsoap.org/ws/2005/04/discovery/Hello";
  if (soap_send_ns__sendString(&soap, "soap.udp://239.255.255.250:3702", NULL, "hello world!"))
    soap_print_fault(&soap, stderr);

  soap_destroy(&soap); // cleanup
  soap_end(&soap); // cleanup
  soap_done(&soap); // close connection (should not use soap struct after this)

  return 0;
}
