#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#define DDD	0
#if DDD
#define multicast_string "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:dn=\"http://www.onvif.org/ver10/network/wsdl\"><SOAP-ENV:Header><wsa:MessageID>uuid:28879b86-9922-11df-8d2f-00408c93e0dc</wsa:MessageID><wsa:To SOAP-ENV:mustUnderstand=\"true\">urn:schemas-xmlsoap-org:ws:2005:04:discovery</wsa:To><wsa:Action SOAP-ENV:mustUnderstand=\"true\">http://schemas.xmlsoap.org/ws/2005/04/discovery/Hello</wsa:Action><d:AppSequence SOAP-ENV:mustUnderstand=\"true\" MessageNumber=\"0\" InstanceId=\"1280195783\"></d:AppSequence></SOAP-ENV:Header><SOAP-ENV:Body><d:Hello><wsa:EndpointReference><wsa:Address>urn:uuid:55cbcec0-85c0-11df-9976-00408c93e0dc</wsa:Address></wsa:EndpointReference><d:Types>dn:NetworkVideoTransmitter</d:Types><d:Scopes>onvif://www.onvif.org/type/video_encoder  onvif://www.onvif.org/type/audio_encoder  onvif://www.onvif.org/hardware/P3301 onvif://www.onvif.org/name/AXIS%20P3301 onvif://www.onvif.org/location/  </d:Scopes><d:XAddrs>http://172.16.15.33/onvif/services</d:XAddrs><d:MetadataVersion>13</d:MetadataVersion></d:Hello></SOAP-ENV:Body></SOAP-ENV:Envelope>"
#else
#define multicast_string "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\
<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:d=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:ns2=\"http://www.onvif.org/ver10/network/wsdl/RemoteDiscoveryBinding\" xmlns:ns3=\"http://www.onvif.org/ver10/network/wsdl/DiscoveryLookupBinding\" xmlns:ns1=\"http://www.onvif.org/ver10/network/wsdl/\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\"><SOAP-ENV:Header><wsa:MessageID>test01</wsa:MessageID><wsa:To SOAP-ENV:mustUnderstand=\"1\">urn:schemas-xmlsoap-org:ws:2005:04:discovery</wsa:To><wsa:Action SOAP-ENV:mustUnderstand=\"1\">http://schemas.xmlsoap.org/ws/2005/04/discovery/Hello</wsa:Action></SOAP-ENV:Header><SOAP-ENV:Body><d:Hello><d:Types></d:Types><d:XAddrs>abc</d:XAddrs><d:MetadataVersion>1</d:MetadataVersion></d:Hello></SOAP-ENV:Body></SOAP-ENV:Envelope>"
#endif

#if 1
int main(int argc, char *argv[])
{
	int myfd;
	struct timeval tv;
	struct sockaddr_in myaddr;

	myfd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	myaddr.sin_family = AF_INET;
	myaddr.sin_port = htons(3702);
	myaddr.sin_addr.s_addr = inet_addr("239.255.255.250");
	tv.tv_sec = 5;
	tv.tv_usec = 0;
	if(connect(myfd, (struct sockaddr *)&myaddr, sizeof(myaddr))){
	printf("connect failed\n");
	exit(-1);
	}
	sendto(myfd, multicast_string, strlen(multicast_string), 0, (struct sockaddr *)&myaddr, sizeof(myaddr));
	exit(0);
}
#else
int main(int argc, char *argv[])
{
	struct ip_mreq mreq;
	struct ip_mreq_source qsrc;
	int sock;
	struct sockaddr_in myaddr;
	unsigned char ttl = 8;	
	int reuse = 1, loop = 0;
	char buff[1024];
	struct timeval tv;
	fd_set rfd;

	sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
	myaddr.sin_family = AF_INET;
	myaddr.sin_port = htons(3702);
	myaddr.sin_addr.s_addr = inet_addr("172.16.15.33");//INADDR_ANY;
	bind(sock, (struct sockaddr *)&myaddr, sizeof(myaddr));
	
//	mreq.imr_multiaddr.s_addr = inet_addr("239.255.255.250");
//	mreq.imr_interface.s_addr = INADDR_ANY;
	qsrc.imr_multiaddr.s_addr = inet_addr("239.255.255.250");
	qsrc.imr_interface.s_addr = INADDR_ANY;
	//qsrc.imr_sourceaddr.s_addr = INADDR_ANY;//inet_addr("172.16.15.33");

	if(setsockopt(sock, IPPROTO_IP, IP_ADD_SOURCE_MEMBERSHIP, (char *)&qsrc, sizeof(qsrc))!= 0)
		perror("ADD_SOURCE_MEMBERSHIP");
	if(setsockopt(sock, IPPROTO_IP, IP_MULTICAST_TTL, &ttl, sizeof(ttl)) != 0)
		perror("TTL");
	if(setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&reuse, sizeof(reuse)) != 0)
		perror("REUSEADDR");
	if(setsockopt(sock, IPPROTO_IP, IP_MULTICAST_LOOP, &loop, sizeof(loop)) != 0)
		perror("MULTICAST_LOOP");
	
	FD_ZERO(&rfd);
        FD_SET(sock, &rfd);
	tv.tv_sec = 5;
	tv.tv_usec = 0;
	while(1) {
		if(select(sock+1, &rfd, NULL, NULL, &tv) > 0) {
			recvfrom(sock, buff, sizeof(buff), (struct sockaddr *)&myaddr, sizeof(myaddr), 0); 
	                printf("receive data %s\n", buff);
		}
	}
}
#endif

